mark_as_advanced(NONSTDSPAN_INCLUDE_DIR)

if(DEP_NONSTDSPAN STREQUAL "BUNDLED")
  message(STATUS "Using bundled NonstdSpan as requested")
else()
  find_path(NONSTDSPAN_INCLUDE_DIR nonstd/span.hpp)
  if(NONSTDSPAN_INCLUDE_DIR)
    file(READ "${NONSTDSPAN_INCLUDE_DIR}/nonstd/span.hpp" _nonstdspan_h)
    string(REGEX MATCH "#define span_lite_MAJOR ([0-9]+).*#define span_lite_MINOR ([0-9]+).*#define span_lite_PATCH ([0-9]+)" _ "${_nonstdspan_h}")
    set(_nonstdspan_version_string "${CMAKE_MATCH_1}.${CMAKE_MATCH_2}.${CMAKE_MATCH_3}")
    if(NOT "${CMAKE_MATCH_0}" STREQUAL "" AND "${_nonstdspan_version_string}" VERSION_GREATER_EQUAL "${NonstdSpan_FIND_VERSION}")
      message(STATUS "Using system NonstdSpan (${NONSTDSPAN_INCLUDE_DIR}/nonstd/span.hpp)")
      add_library(dep_nonstdspan INTERFACE IMPORTED)
      target_include_directories(dep_nonstdspan INTERFACE "${NONSTDSPAN_INCLUDE_DIR}")
      register_dependency(NonstdSpan "SYSTEM (${NONSTDSPAN_INCLUDE_DIR}/nonstd/span.hpp)" ${_nonstdspan_version_string})
    endif()
  endif()
  if(NOT TARGET dep_nonstdspan)
    message(STATUS "Using bundled NonstdSpan since NonstdSpan>=${NonstdSpan_FIND_VERSION} was not found locally")
  endif()
endif()
