/*
* Copyright (c) 2024-2026, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     nvlMediaKernel_av1brc_init.h
//! \brief    File holds the Firmware for the media kernels for HuC
//! \details  File holds the Firmware for the media kernels for HuC which is 
//!           a programmable Microcontroller added to the VDBox pipeline.
//!

/* Media Kernel Version - 20260203 */

#pragma once


/*==========================================================================================================================================================
Kernel begins from here. Do not remove this comment.
==========================================================================================================================================================*/

const uint32_t __MediaKernels_av1brc_init_nvl [] = 
{
    0x00002000, 0x000000c0, 0x00002a80, 0x00000040,
    0x00002440, 0x000020c0, 0x00002480, 0x00000940,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x672efcfa, 0x15010f66, 0x00002ac0, 0x66c0200f,
    0x6601c883, 0xffffff25, 0xc0220f9f, 0x00b800eb,
    0xb8c08e00, 0xe88e0028, 0x8e0010b8, 0x0018b8d8,
    0x20b8d08e, 0x66e08e00, 0x000080ea, 0x90000800,
    0x2ad0002f, 0x2e660000, 0x00841f0f, 0x00000000,
    0x00000000, 0x00000000, 0x2a802440, 0x00409b00,
    0x000029fd, 0x00409300, 0x00002000, 0x00409300,
    0x0000ffdf, 0x00cf9302, 0x2a802440, 0x00409300,
    0x001ffcbc, 0x0af6e800, 0xb8660000, 0xebf4dead,
    0xccccf4fd, 0x006afacf, 0x2ae9006a, 0xfa000001,
    0x016a006a, 0x000120e9, 0x006afa00, 0x16e9026a,
    0xfa000001, 0x036a006a, 0x00010ce9, 0x006afa00,
    0x02e9046a, 0xfa000001, 0x056a006a, 0x0000f8e9,
    0x006afa00, 0xeee9066a, 0xfa000000, 0x076a006a,
    0x0000e4e9, 0x086afa00, 0x0000dce9, 0x006afa00,
    0xd2e9096a, 0xfa000000, 0xcae90a6a, 0xfa000000,
    0xc2e90b6a, 0xfa000000, 0xbae90c6a, 0xfa000000,
    0xb2e90d6a, 0xfa000000, 0xaae90e6a, 0xfa000000,
    0x0f6a006a, 0x0000a0e9, 0x006afa00, 0x96e9106a,
    0xfa000000, 0x8ee9116a, 0xfa000000, 0x126a006a,
    0x000084e9, 0x006afa00, 0x7deb136a, 0x6a006afa,
    0xfa76eb14, 0x156a006a, 0x6afa6feb, 0xeb166a00,
    0x006afa68, 0x61eb176a, 0x6a006afa, 0xfa5aeb18,
    0x196a006a, 0x6afa53eb, 0xeb1a6a00, 0x006afa4c,
    0x45eb1b6a, 0x6a006afa, 0xfa3eeb1c, 0x1d6a006a,
    0x6afa37eb, 0xeb1e6a00, 0x006afa30, 0x29eb1f6a,
    0xd06860fa, 0xe8000000, 0x00000074, 0x6104c483,
    0x6a60facf, 0x0956e84c, 0xc4830000, 0xfacf6104,
    0xff68006a, 0xeb000000, 0x31e8600b, 0x61000000,
    0xcf08c483, 0x0056e860, 0x83610000, 0xcccf08c4,
    0x83e58955, 0xc76608ec, 0x07fff845, 0xc0fa45c7,
    0x0f000020, 0x83f85d01, 0xc35d08c4, 0xcccccccc,
    0x83e58955, 0x458b08ec, 0x084d8d28, 0xff240c89,
    0x28c08514, 0xc4830000, 0x90c35d08, 0x90909090,
    0x5de58955, 0x909090c3, 0x90909090, 0x90909090,
    0x5de58955, 0xccccccc3, 0xcccccccc, 0xcccccccc,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0x909090c3, 0x90909090,
    0xf4e58955, 0x5df4fdeb, 0xccccccc3, 0xcccccccc,
    0xb0e58955, 0xe6a1e6ff, 0x90c35d21, 0x90909090,
    0xb8e58955, 0x00020000, 0xe00380b9, 0x64c129fe,
    0xffff01c7, 0xe0b900ff, 0x29fee003, 0x01c764c1,
    0x00000001, 0xe00320b9, 0x64c129fe, 0x00d001c7,
    0xc35d0002, 0x90909090, 0x90909090, 0x90909090,
    0xb0e58955, 0xe6a1e6ff, 0x0000b821, 0x30b90002,
    0x29fee000, 0x098b64c1, 0xe000f0b9, 0x64c129fe,
    0x01ff01c7, 0xe0b90000, 0x29fee000, 0x01c764c1,
    0xffffffff, 0xe00080b9, 0x64c129fe, 0x000001c7,
    0x80b90000, 0x29fee003, 0x01c764c1, 0x00ffffff,
    0xe003e0b9, 0x64c129fe, 0x000101c7, 0x20b90000,
    0x29fee003, 0x01c764c1, 0x000200d0, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x08458b10, 0x890c558b,
    0x03e783c7, 0x04be4574, 0x29000000, 0x89ce39fe,
    0x890277cf, 0x89f929f7, 0x74ff85c6, 0x90909009,
    0x4f461688, 0xcf89fa75, 0x7502efc1, 0x03e18327,
    0x0010840f, 0x90900000, 0x90909090, 0x90909090,
    0x49461688, 0x5f5efa75, 0x89c35d5b, 0xc1cf89c6,
    0xd97402ef, 0xc1c2b60f, 0xc38918e2, 0x0908e3c1,
    0xc1da09c2, 0xd00910e0, 0x90909090, 0x90909090,
    0xc6830689, 0xf8754f04, 0x8b08458b, 0xe1830c55,
    0xebbd7503, 0x909090c1, 0x90909090, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x8908458b,
    0x03e683d6, 0xe783c789, 0x75fe3903, 0x74f68559,
    0x0004bb6e, 0xf3290000, 0xcf89cb39, 0xdf890277,
    0xc689f929, 0x840fff85, 0x0000000e, 0x90909090,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x0c558b10, 0x3908458b,
    0x8d7d76d0, 0xd6390834, 0xca017676, 0xe783d789,
    0x83f08903, 0xc73903e0, 0xff854875, 0xcf391e74,
    0x0277c889, 0xc129f889, 0x840fc085, 0x0000000c,
    0xff5ab60f, 0x4eff5e88, 0xf475484a, 0xe8c1c889,
    0x18840f02, 0x90000000, 0x90909090, 0x90909090,
    0x89fc7a8b, 0xc683fc7e, 0xfcc283fc, 0x83f17548,
    0xc98503e1, 0x0012840f, 0x90900000, 0x90909090,
    0xff42b60f, 0x4eff4688, 0xf475494a, 0x7aebf089,
    0xe683d689, 0x83c78903, 0xfe3903e7, 0xf6855875,
    0x04bb6d74, 0x29000000, 0x89cb39f3, 0x890277cf,
    0x89f929df, 0x0fff85c6, 0x00000d84, 0x90909000,
    0x881ab60f, 0x4f42461e, 0xcf89f675, 0x0f02efc1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x1e891a8b, 0x8304c683, 0x754f04c2, 0x03e183f3,
    0x0c75c985, 0xc68914eb, 0x840fc985, 0x0000000a,
    0x881ab60f, 0x4942461e, 0x5f5ef675, 0x89c35d5b,
    0xc1cf89c6, 0xc87502ef, 0x9090d3eb, 0x90909090,
    0x53e58955, 0x8b505657, 0xc985084d, 0x000002b8,
    0xdf840f00, 0x8b000000, 0xf6850c75, 0x00d4880f,
    0x558b0000, 0x76f23914, 0x83ca8960, 0x277403e2,
    0x000004bf, 0x39d72900, 0x77f289f7, 0x29fa8902,
    0x0fd285d6, 0x00000e84, 0x90909000, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1f2, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e683,
    0x00008184, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0xebf9754e, 0x105d8b6d, 0xe083c889,
    0xbe237403, 0x00000004, 0xd639c629, 0x0277d089,
    0xc229f089, 0x840fc085, 0x0000000a, 0x90909090,
    0x48411988, 0xd089fa75, 0x0f02e8c1, 0x00002784,
    0xf3b60f00, 0xe7c1df89, 0xf0758918, 0x08f065c1,
    0x7d03f709, 0x10e6c1f0, 0x9090fe09, 0x90909090,
    0xc1833189, 0xf8754804, 0xe283c031, 0x90077403,
    0x4a411988, 0xc483fa75, 0x5b5f5e04, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0xb8c98508, 0x00000002,
    0x00f1840f, 0x7d8b0000, 0x0fff850c, 0x0000e688,
    0x10758b00, 0x840ff685, 0x00000080, 0x3914558b,
    0x897977fa, 0x03e083f0, 0xe783cf89, 0x75f83903,
    0x74c0854f, 0x0004bf25, 0xc7290000, 0xd089d739,
    0xf8890277, 0xc085c229, 0x000c840f, 0x90900000,
    0x881eb60f, 0x48464119, 0xd089f675, 0x0f02e8c1,
    0x00001884, 0x90909000, 0x90909090, 0x90909090,
    0x39893e8b, 0x8304c183, 0x754804c6, 0x03e283f3,
    0xd285c031, 0x006d840f, 0x90900000, 0x90909090,
    0x881eb60f, 0x4a464119, 0x5bebf675, 0xe283ca89,
    0xbe247403, 0x00000004, 0xfe39d629, 0x0277fa89,
    0xd729f289, 0x840fd285, 0x0000000b, 0x90909090,
    0x410001c6, 0x89f9754a, 0x02eac1fa, 0x90900e74,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x0f03e783,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x410001c6, 0x5ef9754f, 0xc35d5b5f, 0x90909090,
    0x57e58955, 0x08558b56, 0x02b8d285, 0x0f000000,
    0x00008284, 0x0c4d8b00, 0x7b78c985, 0x8510758b,
    0x8b1974f6, 0xcf39147d, 0xec831277, 0x52565704,
    0xfffc9be8, 0x10c483ff, 0x5bebc031, 0xe683d689,
    0xbf247403, 0x00000004, 0xcf39f729, 0x0277ce89,
    0xf129fe89, 0x840ff685, 0x0000000b, 0x90909090,
    0x420002c6, 0x89f9754e, 0x02eec1ce, 0x90900e74,
    0x000002c7, 0xc2830000, 0xf4754e04, 0x0f03e183,
    0x00001284, 0x90909000, 0x90909090, 0x90909090,
    0x420002c6, 0x5ef97549, 0xccc35d5f, 0xcccccccc,
    0xb8e58955, 0x00020000, 0x100100b9, 0x64c129ff,
    0x000101c7, 0x00b90000, 0x29ff1000, 0x0004bac1,
    0xc229ff10, 0x0002c764, 0x64000200, 0x100001c7,
    0x0cb90002, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100008b9, 0x64c129ff, 0x000001c7, 0x14b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100010b9,
    0x64c129ff, 0x000001c7, 0x1cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100018b9, 0x64c129ff,
    0x000001c7, 0x24b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100020b9, 0x64c129ff, 0x000001c7,
    0x2cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100028b9, 0x64c129ff, 0x000001c7, 0x34b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100030b9,
    0x64c129ff, 0x000001c7, 0x3cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100038b9, 0x64c129ff,
    0x000001c7, 0x44b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100040b9, 0x64c129ff, 0x000001c7,
    0x4cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100048b9, 0x64c129ff, 0x000001c7, 0x54b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100050b9,
    0x64c129ff, 0x000001c7, 0x5cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100058b9, 0x64c129ff,
    0x000001c7, 0x64b90000, 0x29ff1000, 0x01c764c1,
    0x00000000, 0x100060b9, 0x64c129ff, 0x000001c7,
    0x6cb90000, 0x29ff1000, 0x01c764c1, 0x00000000,
    0x100068b9, 0x64c129ff, 0x000001c7, 0x74b90000,
    0x29ff1000, 0x01c764c1, 0x00000000, 0x100070b9,
    0x64c129ff, 0x000001c7, 0x7cb90000, 0x29ff1000,
    0x01c764c1, 0x00000000, 0x100078b9, 0x64c129ff,
    0x000001c7, 0xc35d0000, 0x90909090, 0x90909090,
    0x56e58955, 0x2000a150, 0xf8830000, 0x850b7402,
    0xe80c75c0, 0x00000138, 0x91e805eb, 0x8d000000,
    0x046af875, 0x6a006a56, 0x10a2e800, 0xc4830000,
    0x56046a10, 0x006a006a, 0x001133e8, 0x10c48300,
    0x6a56046a, 0xe8006a00, 0x00001084, 0xb810c483,
    0x00020000, 0xe000b0b9, 0x64c129fe, 0x000001c7,
    0xc4830000, 0xc35d5e04, 0x90909090, 0x90909090,
    0x83e58955, 0x55e808ec, 0xe8fffff6, 0xfffffda0,
    0xfff81be8, 0x0000b8ff, 0xb8b90002, 0x29ffe0d3,
    0x01c764c1, 0x0000004c, 0x90909090, 0x90909090,
    0xfcebf4fb, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x56e58955, 0x81c0e483, 0x0005c0ec, 0x12eee800,
    0x748d0000, 0x40684024, 0x56000005, 0x006a006a,
    0x000ffbe8, 0x10c48300, 0x4575c085, 0x382444c7,
    0x00002000, 0x8d08ec83, 0x50402444, 0x015ee856,
    0xc4830000, 0x05406810, 0x6a560000, 0xe8006a00,
    0x0000106c, 0x8510c483, 0x832875c0, 0x00680cec,
    0xe8100000, 0x00001278, 0x8d10c483, 0x5d5efc65,
    0x0cec83c3, 0x00000068, 0x1262e804, 0xc4830000,
    0x83a9eb10, 0x00680cec, 0xe8040000, 0x00001250,
    0xeb10c483, 0x909090c6, 0x90909090, 0x90909090,
    0x56e58955, 0x81c0e483, 0x0005c0ec, 0x124ee800,
    0x44c70000, 0x20003824, 0xec830000, 0x24448d08,
    0x24748d40, 0xe8565048, 0x00000ad4, 0x6810c483,
    0x00000540, 0x6a006a56, 0x0fe2e800, 0xc4830000,
    0x75c08510, 0x0cec8316, 0x00000068, 0x11eee810,
    0xc4830000, 0xfc658d10, 0x83c35d5e, 0x00680cec,
    0xe8040000, 0x000011d8, 0xeb10c483, 0xccccccd8,
    0x56e58955, 0x8b08458b, 0x1c798308, 0x31167400,
    0x207983c0, 0x0f0e7400, 0x815251b7, 0x0000fffa,
    0xeb217600, 0x1c41c73c, 0x0000001e, 0x012041c7,
    0xb8000000, 0x00000001, 0x5251b70f, 0x00fffa81,
    0x1d770000, 0x5071b70f, 0x00fffe81, 0x11770000,
    0x77d63966, 0x97b9800c, 0x11000000, 0x5d5e1873,
    0x5041c7c3, 0x00ff0000, 0x000001b8, 0x97b98000,
    0x11000000, 0x81c6e872, 0x00000097, 0x0001b810,
    0x5d5e0000, 0x909090c3, 0x90909090, 0x90909090,
    0x8be58955, 0x558b084d, 0x04eb5d0c, 0x90909090,
    0x53e58955, 0xec835657, 0xc84d893c, 0x8bd05589,
    0x1c438b1a, 0x1874c085, 0x4b8bc689, 0x8501b220,
    0x0f0d74c9, 0x3d5243b7, 0x000000ff, 0x48eb2776,
    0x1e1c43c7, 0xc7000000, 0x00012043, 0x1ebe0000,
    0xb9000000, 0x00000001, 0xb70fd231, 0xff3d5243,
    0x77000000, 0x7bb70f23, 0xffff8150, 0x77000000,
    0xc7396617, 0xbb801277, 0x00000097, 0x84197710,
    0xf07d89d2, 0x19eb4175, 0x005043c7, 0x8000ff00,
    0x000097bb, 0x09721100, 0x0097c381, 0x03c60000,
    0x0cec8310, 0x00000068, 0x1092e801, 0xc4830000,
    0xd0458b10, 0x738b188b, 0x204b8b1c, 0x5043b70f,
    0x0ff04589, 0x8b5243b7, 0x578bc87d, 0xc4558910,
    0x8904538b, 0x08538b17, 0x89e45589, 0x538b0457,
    0xd855890c, 0x8b085789, 0x55891053, 0x0c5789e0,
    0x8914538b, 0x5789e855, 0x18538b10, 0x89145789,
    0x7789d475, 0x89fe8918, 0x4f89ec4d, 0x53b70f1c,
    0x97896644, 0x000003e4, 0x487bb70f, 0xe6be8966,
    0x0f000003, 0x664a7bb7, 0x03e8be89, 0xb70f0000,
    0x4d894c4b, 0x8e8966bc, 0x000003ea, 0x4e4bb70f,
    0x66dc4d89, 0x03ec8e89, 0x4d8b0000, 0x8e8966f0,
    0x000003ee, 0xf0868966, 0x0f000003, 0x665443b7,
    0x03f28689, 0xb70f0000, 0x89665a43, 0x00041686,
    0x43b70f00, 0x8689665c, 0x00000422, 0x5e43b70f,
    0x24868966, 0x0f000004, 0x666243b7, 0x04268689,
    0xc2f60000, 0xf60f7510, 0x237520c2, 0x0f40c2f6,
    0x020cc094, 0xc03102eb, 0x8dec4d8b, 0x00044696,
    0xcc558900, 0x88f04589, 0x00044686, 0x8b55eb00,
    0xc889e44d, 0x0105e8c1, 0x468e8dc8, 0x89000004,
    0x86c6cc4d, 0x00000446, 0x04468901, 0x89d84d8b,
    0x05e8c1c8, 0x4d89c101, 0x084e89d8, 0x89e04d8b,
    0x05e8c1c8, 0x4d89c101, 0x0c4e89e0, 0x89e84d8b,
    0x05e8c1c8, 0x4d89c101, 0x104e89e8, 0x458901b0,
    0xec4d8bf0, 0xf7e0458b, 0xd4758be1, 0xefd1f789,
    0xd283f801, 0x74f68500, 0x56006a36, 0xd1e85052,
    0x83000013, 0x458910c4, 0xe445c7c0, 0x00000000,
    0xf7e8458b, 0xf801ec65, 0x6a00d283, 0x50525600,
    0x0013afe8, 0x10c48300, 0x458bc189, 0xc710ebc0,
    0x0000e445, 0x4d8b0000, 0x4daf0fe8, 0x8bf901ec,
    0xaf0fdc55, 0xeac1bc55, 0x8bc78908, 0x0e74c875,
    0x4d89f889, 0x31d189dc, 0x8bf1f7d2, 0x1ebadc4d,
    0x83000000, 0x1e770af8, 0x000016ba, 0x08f88300,
    0x10ba1477, 0x83000000, 0x0a7706f8, 0x000008ba,
    0x05f88300, 0x96890672, 0x000003b0, 0xbe89f889,
    0x000001b4, 0x89207e89, 0xbe89244e, 0x00000164,
    0x85ec4d8b, 0x9f840fc9, 0x8b000001, 0xd231d445,
    0xf883f1f7, 0xb8057c1f, 0x0000001e, 0xa993b60f,
    0x83000000, 0x7500c47d, 0xfed18911, 0x77f980c9,
    0x83880876, 0x000000a9, 0xaf0fc289, 0xc0be89fa,
    0x89000001, 0x0003a496, 0xa88b8a00, 0x8b000000,
    0xdb85c45d, 0x04898e88, 0x458b0000, 0x75c189f0,
    0xbc86c730, 0x00000001, 0x85000000, 0xf0458bd2,
    0x8e0fc189, 0x00000019, 0x01c48e8d, 0x90900000,
    0x000001c7, 0xc1830000, 0xf4754a04, 0x8acc458b,
    0x01f98008, 0x86c73c75, 0x000001c4, 0x00000000,
    0x01c886c7, 0x00000000, 0x86c70000, 0x000001cc,
    0x00000000, 0x01d086c7, 0x00000000, 0x86c70000,
    0x000001d4, 0x00000000, 0x01d886c7, 0x00000000,
    0xb70f0000, 0x00041686, 0x9cc08300, 0xb9c7af0f,
    0x51eb851f, 0xeac1e1f7, 0x89db8505, 0x0001b896,
    0x8b3b7400, 0xdf89284e, 0x0fe45d8b, 0x458bd9af,
    0x89e1f7e8, 0x01e9d1f9, 0x89da11c1, 0x347e8bf8,
    0x5250006a, 0x121ae851, 0xc4830000, 0x28468910,
    0x7e89c729, 0xc6077130, 0x00294005, 0xb70f0100,
    0x0003e686, 0x8eb70f00, 0x000003e8, 0xb70fc101,
    0x00042286, 0x96b70f00, 0x00000424, 0x448dc801,
    0xff3d0102, 0x720000ff, 0xffffb805, 0x89660000,
    0x0003f486, 0xf07d8000, 0x0f1d7503, 0x03f2beb7,
    0xff830000, 0x89447704, 0x8eb70ff8, 0x000003ee,
    0xca89cf39, 0x50eb4573, 0x8bd0458b, 0x81b60f08,
    0x00000095, 0x94b9b60f, 0x0f000000, 0x03ee8eb7,
    0xcf390000, 0x2373ca89, 0x458b2eeb, 0x1ff883d4,
    0xfe618d0f, 0x61e9ffff, 0x8dfffffe, 0xb70ffc47,
    0x0003ee8e, 0x89cf3900, 0x0f0d72ca, 0x03f096b7,
    0xd7390000, 0xfa890277, 0x0d7cc839, 0xf08eb70f,
    0x39000003, 0x89027fc8, 0x439688c1, 0x88000004,
    0x0004458e, 0x3d968800, 0x88000004, 0x00043f8e,
    0x86c76600, 0x00000420, 0x458b0020, 0x0f388bd0,
    0x897847be, 0x1ff9c1c1, 0x0fe05d8b, 0xe3f7cbaf,
    0x1132c083, 0x6a006aca, 0xe8505264, 0x00001004,
    0x8910c483, 0x00010c86, 0x47be0f00, 0xc1c18970,
    0xaf0f1ff9, 0x83e3f7cb, 0xca1132c0, 0x646a006a,
    0xdde85052, 0x8300000f, 0x868910c4, 0x000000ec,
    0x7947be0f, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0fb6e850, 0xc4830000,
    0x10868910, 0x0f000001, 0x897147be, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000f8fe8, 0x10c48300, 0x00f08689, 0xbe0f0000,
    0xc1897a47, 0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083,
    0x6a006aca, 0xe8505264, 0x00000f68, 0x8910c483,
    0x00011486, 0x47be0f00, 0xc1c18972, 0xaf0f1ff9,
    0x83e3f7cb, 0xca1132c0, 0x646a006a, 0x41e85052,
    0x8300000f, 0x868910c4, 0x000000f4, 0x7b47be0f,
    0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7, 0x6aca1132,
    0x52646a00, 0x0f1ae850, 0xc4830000, 0x18868910,
    0x0f000001, 0x897347be, 0x1ff9c1c1, 0xf7cbaf0f,
    0x32c083e3, 0x006aca11, 0x5052646a, 0x000ef3e8,
    0x10c48300, 0x00f88689, 0xbe0f0000, 0x00008c87,
    0xc1c18900, 0x5d8b1ff9, 0xcbaf0fd8, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0ec6e850, 0xc4830000,
    0xcc868910, 0x0f000000, 0x897c47be, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000e9fe8, 0x10c48300, 0x008c8689, 0xbe0f0000,
    0x00008487, 0xc1c18900, 0xe3f71ff9, 0x01cbaf0f,
    0x6a006ad1, 0xe8505164, 0x00000e78, 0x8910c483,
    0x0000ac86, 0x87be0f00, 0x0000008d, 0xf9c1c189,
    0xcbaf0f1f, 0xc083e3f7, 0x6aca1132, 0x52646a00,
    0x0e4ee850, 0xc4830000, 0xd0868910, 0x0f000000,
    0x897d47be, 0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3,
    0x006aca11, 0x5052646a, 0x000e27e8, 0x10c48300,
    0x00908689, 0xbe0f0000, 0x00008587, 0xc1c18900,
    0xe3f71ff9, 0x01cbaf0f, 0x6a006ad1, 0xe8505164,
    0x00000e00, 0x8910c483, 0x0000b086, 0x87be0f00,
    0x0000008e, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0dd6e850, 0xc4830000,
    0xd4868910, 0x0f000000, 0x897e47be, 0x1ff9c1c1,
    0xf7cbaf0f, 0x32c083e3, 0x006aca11, 0x5052646a,
    0x000dafe8, 0x10c48300, 0x00948689, 0xbe0f0000,
    0x00008687, 0xc1c18900, 0xe3f71ff9, 0x01cbaf0f,
    0x6a006ad1, 0xe8505164, 0x00000d88, 0x8910c483,
    0x0000b486, 0x87be0f00, 0x0000008f, 0xf9c1c189,
    0xcbaf0f1f, 0xc083e3f7, 0x6aca1132, 0x52646a00,
    0x0d5ee850, 0xc4830000, 0xd8868910, 0x0f000000,
    0x897f47be, 0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3,
    0x006aca11, 0x5052646a, 0x000d37e8, 0x10c48300,
    0x00988689, 0xbe0f0000, 0x00008787, 0xc1c18900,
    0xe3f71ff9, 0x01cbaf0f, 0x6a006ad1, 0xe8505164,
    0x00000d10, 0x8910c483, 0x0000b886, 0x87be0f00,
    0x00000090, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0ce6e850, 0xc4830000,
    0xdc868910, 0x0f000000, 0x008087be, 0xc1890000,
    0x0f1ff9c1, 0xe3f7cbaf, 0x1132c083, 0x6a006aca,
    0xe8505264, 0x00000cbc, 0x8910c483, 0x00009c86,
    0x87be0f00, 0x00000088, 0xf9c1c189, 0x0fe3f71f,
    0xd101cbaf, 0x646a006a, 0x95e85051, 0x8300000c,
    0x868910c4, 0x000000bc, 0x9187be0f, 0x89000000,
    0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3, 0x006aca11,
    0x5052646a, 0x000c6be8, 0x10c48300, 0x00e08689,
    0xbe0f0000, 0x00008187, 0xc1c18900, 0xaf0f1ff9,
    0x83e3f7cb, 0xca1132c0, 0x646a006a, 0x41e85052,
    0x8300000c, 0x868910c4, 0x000000a0, 0x8987be0f,
    0x89000000, 0x1ff9c1c1, 0xaf0fe3f7, 0x6ad101cb,
    0x51646a00, 0x0c1ae850, 0xc4830000, 0xc0868910,
    0x0f000000, 0x009287be, 0xc1890000, 0x0f1ff9c1,
    0xe3f7cbaf, 0x1132c083, 0x6a006aca, 0xe8505264,
    0x00000bf0, 0x8910c483, 0x0000e486, 0x87be0f00,
    0x00000082, 0xf9c1c189, 0xcbaf0f1f, 0xc083e3f7,
    0x6aca1132, 0x52646a00, 0x0bc6e850, 0xc4830000,
    0xa4868910, 0x0f000000, 0x008a87be, 0xc1890000,
    0xf71ff9c1, 0xcbaf0fe3, 0x006ad101, 0x5051646a,
    0x000b9fe8, 0x10c48300, 0x00c48689, 0xbe0f0000,
    0x00009387, 0xc1c18900, 0xaf0f1ff9, 0x83e3f7cb,
    0xca1132c0, 0x646a006a, 0x75e85052, 0x8300000b,
    0x868910c4, 0x000000e8, 0x8387be0f, 0x89000000,
    0x1ff9c1c1, 0xf7cbaf0f, 0x32c083e3, 0x006aca11,
    0x5052646a, 0x000b4be8, 0x10c48300, 0x00a88689,
    0xbe0f0000, 0x00008b87, 0xc1c18900, 0xe3f71ff9,
    0x01cbaf0f, 0x6a006ad1, 0xe8505164, 0x00000b24,
    0x8910c483, 0x0000c886, 0x3cc48300, 0x5d5b5f5e,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x0c7d8b1c, 0x6808758b,
    0x00000504, 0x0468006a, 0x56000005, 0xffeeffe8,
    0x10c483ff, 0xfa89f189, 0xfff5e3e8, 0x0f078bff,
    0x009798b6, 0xdb850000, 0x044b9e88, 0x840f0000,
    0x00000032, 0x0098808a, 0x86880000, 0x0000045f,
    0x0f01fb80, 0x00001d84, 0xff438d00, 0x9090c931,
    0xb60f178b, 0x00990a94, 0x94880000, 0x0004600e,
    0xc8394100, 0x468bea75, 0x087e8b04, 0x89284689,
    0x0003c086, 0x204e8b00, 0x8bec4d89, 0xc101244e,
    0x05c60773, 0x00002940, 0x29d23101, 0x310d72f9,
    0x46be80d2, 0x01000004, 0xca890274, 0x89e85d89,
    0x00008886, 0x84968900, 0x0f000000, 0x0422beb7,
    0xb70f0000, 0x0004249e, 0x86b70f00, 0x000003f4,
    0xe88eb70f, 0x0f000003, 0x03e696b7, 0xf9010000,
    0x5d89d101, 0x9b148de4, 0x8d890c8d, 0x8c8d890c,
    0x00012c91, 0xec65f700, 0x5251006a, 0x0b02e850,
    0xc4830000, 0x2cc86910, 0x89000001, 0x0c8df04d,
    0x890c8d80, 0xead1ca89, 0x0274ff85, 0x5d8bcf89,
    0x745e89f0, 0x896c4e89, 0x8e897056, 0x00000164,
    0x8b787e89, 0xc985e44d, 0xe0c10674, 0x800c8d02,
    0x8b7c4e89, 0x0003ea86, 0xfa868900, 0x8b000003,
    0x008b0c45, 0x5848b70f, 0xfe8e8966, 0x80000003,
    0x000446be, 0x20750300, 0xf2beb70f, 0x83000003,
    0x5d8b04ff, 0x893177e8, 0x8eb70ffa, 0x000003ee,
    0xc889cf39, 0x3deb3273, 0x94b8b60f, 0x0f000000,
    0x009590b6, 0x5d8b0000, 0x8eb70fe8, 0x000003ee,
    0xc889cf39, 0x1deb1273, 0x0ffc578d, 0x03ee8eb7,
    0xcf390000, 0x0d72c889, 0xf086b70f, 0x39000003,
    0x890277c7, 0x7cca39f8, 0x8eb70f0d, 0x000003f0,
    0x027fca39, 0x8688d189, 0x00000443, 0x04458e88,
    0x86880000, 0x0000043d, 0x043f8e88, 0xc2890000,
    0x8808c280, 0x00043e96, 0x80c28900, 0x96880cc2,
    0x00000440, 0x86881004, 0x00000441, 0x044986c6,
    0xc6ff0000, 0x00043c86, 0x86c7ff00, 0x00000168,
    0x00000001, 0x044e86c6, 0xc7ff0000, 0x00011c86,
    0xffffff00, 0x3086c7ff, 0xff000001, 0xc7ffffff,
    0x00014486, 0xffffff00, 0x2086c7ff, 0xff000001,
    0xc7ffffff, 0x00013486, 0xffffff00, 0x4886c7ff,
    0xff000001, 0xc7ffffff, 0x00012486, 0xffffff00,
    0x3886c7ff, 0xff000001, 0xc7ffffff, 0x00014c86,
    0xffffff00, 0x2886c7ff, 0xff000001, 0xc7ffffff,
    0x00013c86, 0xffffff00, 0x5086c7ff, 0xff000001,
    0xc7ffffff, 0x00012c86, 0xffffff00, 0x4086c7ff,
    0xff000001, 0xc7ffffff, 0x00015486, 0xffffff00,
    0xebf981ff, 0x7c000000, 0x00eab905, 0xfb800000,
    0x62820f02, 0x0f000001, 0x046086b6, 0xc0850000,
    0x0153840f, 0x45890000, 0x06598de4, 0x0f1ac183,
    0x045fbeb6, 0x458b0000, 0x71e7f7ec, 0x4005c607,
    0x01000029, 0x8906e8c1, 0x00015886, 0x02e7c100,
    0x897f3c8d, 0x06e8c1f8, 0x29f4c083, 0x88c329c1,
    0x0004438e, 0xf05d8900, 0x04459e88, 0x458b0000,
    0xe45d8bec, 0x0771e3f7, 0x294005c6, 0xc1010000,
    0x868906e8, 0x0000015c, 0xd231f889, 0x0ff3f766,
    0x428dd0b7, 0xfa8366f4, 0xe07d8919, 0xc2890f72,
    0x011eeac1, 0x02fac1c2, 0x890cc283, 0xe85d8bd0,
    0x01f0558b, 0x4f8688c8, 0x80000004, 0x820f03fb,
    0x000000a9, 0x61beb60f, 0x85000004, 0x9a840fff,
    0x8b000000, 0xe7f7ec45, 0x05c60771, 0x00002940,
    0x06e8c101, 0x01608689, 0x458b0000, 0x66d231e0,
    0xb70ff7f7, 0xf4428dd0, 0x19fa8366, 0xc2890f72,
    0x011eeac1, 0x02fac1c2, 0x890cc283, 0xf0558bd0,
    0x8688c801, 0x00000450, 0x7204fb80, 0xbeb60f50,
    0x00000462, 0x4574ff85, 0xf7ec458b, 0xc60771e7,
    0x00294005, 0xe8c10100, 0x84868906, 0x8b000001,
    0xd231e045, 0x0ff7f766, 0x428dd0b7, 0xfa8366f4,
    0x890f7219, 0x1eeac1c2, 0xfac1c201, 0x0cc28302,
    0x558bd089, 0x88c801f0, 0x00045186, 0x3d8e8800,
    0x88000004, 0x00043f96, 0x0c458b00, 0x808a008b,
    0x00000096, 0x04728688, 0x86c70000, 0x0000048b,
    0xffffffff, 0x048f86c7, 0x00ff0000, 0x86c60000,
    0x00000493, 0xc486c700, 0x00000004, 0xc6000000,
    0x0004c886, 0xc4830000, 0x5b5f5e1c, 0xccccc35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x6433048d, 0x0489008b, 0x04c68332, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x0c7d8b14, 0x01085d8b,
    0xc60773cf, 0x00294005, 0xfb830100, 0x0002b80f,
    0x75770000, 0x8510558b, 0xbe6e74d2, 0x00020000,
    0x100000b8, 0x8bf029ff, 0x29849d34, 0xc6010000,
    0x03368b64, 0x29449d04, 0x8b640000, 0x0fde2918,
    0xfb81c092, 0x00020000, 0xc0843a72, 0xf7393675,
    0x000002b8, 0x2e870f00, 0x85000000, 0x1d840fc9,
    0x03000000, 0x00b80c5d, 0x29000200, 0x90f631c3,
    0x8d32048b, 0x8964333c, 0x04c68307, 0xf072ce39,
    0x05ebc031, 0x000002b8, 0x5b5f5e00, 0x9090c35d,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0100c764,
    0x31000000, 0x5b5f5ec0, 0x9090c35d, 0x90909090,
    0x53e58955, 0x4d8b5657, 0x08458b14, 0x8b0c758b,
    0x29448514, 0x00bf0000, 0x29000200, 0x00c281fa,
    0x64ff1000, 0xfa893a8b, 0x920ff201, 0x72ce01c3,
    0x74db8404, 0x4005c607, 0x01000029, 0x8485048b,
    0xbb000029, 0x00020000, 0x0005d829, 0x64ff1000,
    0xfb29188b, 0x000002b8, 0x394a7200, 0x8b4677de,
    0x090f1045, 0x020000be, 0xd300bf00, 0xf729ffe0,
    0xba178964, 0xffe0d308, 0x8964f229, 0xd310b802,
    0xf029ffe0, 0xb8088964, 0xffe0d064, 0xc764f029,
    0x01800400, 0xd314b800, 0xf029ffe0, 0x0300c764,
    0x31000000, 0x5b5f5ec0, 0xccccc35d, 0xcccccccc,
    0x8be58955, 0xc0830845, 0xc0e08304, 0x5d40c083,
    0x909090c3, 0x90909090, 0x90909090, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0x450b018b, 0x01896408, 0x9090c35d, 0x90909090,
    0xb8e58955, 0x00020000, 0xe0d000b9, 0x64c129ff,
    0xff25018b, 0x6400ffff, 0xc35d0189, 0x90909090,
    0x56e58955, 0x8b08558b, 0x4ab60f32, 0xc1c88908,
    0x048a03e8, 0xfecc8806, 0x086288c4, 0x7508fc80,
    0x0842c607, 0x32894600, 0xe180d1f6, 0x24e8d207,
    0xc35d5e01, 0x90909090, 0x90909090, 0x90909090,
    0x53e58955, 0xf608458b, 0x74010c45, 0xb1108b10,
    0x08482a07, 0x000001bb, 0x08e3d300, 0x08488a1a,
    0x4888c1fe, 0x08f98008, 0x088b3975, 0x502bca89,
    0x02fa8304, 0x7980207c, 0x1a7500fe, 0x00ff7980,
    0x118a1475, 0x7703fa80, 0x0151880d, 0x01c6088b,
    0x41088b03, 0x518d0889, 0xc6108901, 0xc6000141,
    0x5b000840, 0x9090c35d, 0x90909090, 0x90909090,
    0x53e58955, 0x458b5657, 0x0fc08510, 0x0000a984,
    0x0c558b00, 0xe908758b, 0x00000018, 0x90909090,
    0x8901798d, 0x0141c63a, 0x0842c600, 0x840f4800,
    0x00000086, 0xb60f3e8b, 0xcb89084e, 0x0f03ebc1,
    0x881f1cb6, 0x88c7fecf, 0xff80087e, 0xc6077508,
    0x47000846, 0xd1f63e89, 0x0f07e180, 0xb60ffbb6,
    0xcfa30fc9, 0x3a8b1073, 0x4a2a07b1, 0x0001bb08,
    0xe3d30000, 0xb60f1f08, 0xc1fe084a, 0x80084a88,
    0xa97508f9, 0xcf890a8b, 0x83047a2b, 0x907c02ff,
    0x00fe7980, 0x79808a75, 0x847500ff, 0x8019b60f,
    0x870f03fb, 0xffffff78, 0x8b015988, 0x0301c60a,
    0x89410a8b, 0xff66e90a, 0x5f5effff, 0x90c35d5b,
    0x53e58955, 0x458b5657, 0x880f4810, 0x00000072,
    0x8b0c558b, 0x15e90875, 0x90000000, 0x90909090,
    0x8901798d, 0x0141c63e, 0x0846c600, 0x52784800,
    0x73c2a30f, 0xb13e8b10, 0x084e2a07, 0x000001bb,
    0x08e3d300, 0x4eb60f1f, 0x88c1fe08, 0xf980084e,
    0x8bda7508, 0x2bcf890e, 0xff83047e, 0x80c17c02,
    0x7500fe79, 0xff7980bb, 0x0fb57500, 0xfb8019b6,
    0x88ad7703, 0x0e8b0159, 0x8b0301c6, 0x0e89410e,
    0x5f5e9eeb, 0x90c35d5b, 0x90909090, 0x90909090,
    0x53e58955, 0xec835657, 0x087d8b08, 0x420c558b,
    0xffffffb9, 0xb91c747f, 0xffffffff, 0x9090d089,
    0x8541f8d1, 0x81f975c0, 0xffffffe1, 0xf4840f7f,
    0x89000000, 0xffbef055, 0xd3ffffff, 0xec4d89e6,
    0xe901598d, 0x0000001c, 0x90909090, 0x90909090,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x527edb85, 0x7501fb83, 0xb1178b10, 0x084f2a07,
    0x000001b8, 0x08e0d300, 0x57b60f02, 0x88c2fe08,
    0xfa800857, 0x8bd87508, 0x2bc8890f, 0xf8830447,
    0x80bd7c02, 0x7500fe79, 0xff7980b7, 0x0fb17500,
    0xfa8011b6, 0x88a97703, 0x078b0151, 0x8b0300c6,
    0x0f89410f, 0x75039aeb, 0xec5d8bf0, 0x9017eb4b,
    0x8901418d, 0x0141c607, 0x0847c600, 0x4bd23100,
    0x00a6880f, 0xa30f0000, 0x8b1373de, 0x2807b107,
    0x0001bad1, 0xe2d30000, 0xb60f1008, 0xc2fe0857,
    0x80085788, 0xd77508fa, 0xc8890f8b, 0x8304472b,
    0xbc7c02f8, 0x00fe7980, 0x7980b675, 0xb07500ff,
    0x8011b60f, 0xa87703fa, 0x8b015188, 0x0300c607,
    0x89410f8b, 0x8b99eb0f, 0x2a07b107, 0x01ba084f,
    0xd3000000, 0x8a1008e2, 0xc0fe0847, 0x3c084788,
    0x8b397508, 0x2bc18907, 0xf983044f, 0x80207c02,
    0x7500fe78, 0xff78801a, 0x8a147500, 0x03f98008,
    0x48880d77, 0xc6078b01, 0x078b0300, 0x8d078940,
    0x0f890148, 0x000140c6, 0x000847c6, 0x5e08c483,
    0xc35d5b5f, 0x24548b56, 0x24448b14, 0xc1d18910,
    0xc8311ff9, 0xc829ca31, 0x5489ca19, 0x44891424,
    0xce891024, 0x0c24548b, 0x0824448b, 0xf9c1d189,
    0x31c8311f, 0x19c829ca, 0x245489ca, 0x2444890c,
    0x53ce3108, 0x18245c8b, 0x0fcbbd0f, 0x00008f84,
    0x24448b00, 0xd1e8d314, 0xd3d1f7e8, 0x8bc309e3,
    0x8b102454, 0x390c2444, 0xf73773da, 0xd1f757f3,
    0xe8d3e8d1, 0x64f7c789, 0x5c8b1824, 0x4c8b1024,
    0xc3291424, 0x448bd119, 0xaf0f1c24, 0x83c129c7,
    0xd23100df, 0xf001f889, 0xf031f211, 0x5b5ff231,
    0xda29c35e, 0xf757f3f7, 0x0de8d1d1, 0x80000000,
    0xc789e8d3, 0x182464f7, 0x10245c8b, 0x14244c8b,
    0xd119c329, 0x1c24448b, 0x29c7af0f, 0x00df83c1,
    0xf889d231, 0xf211f001, 0xf231f031, 0xc35e5b5f,
    0x1024448b, 0x14244c8b, 0xf1f7d231, 0x448bc389,
    0xf1f70c24, 0xf001da89, 0xf031f211, 0x5e5bf231,
    0xccccccc3, 0x245c8b53, 0xcbbd0f14, 0x448b7d74,
    0xe8d31024, 0xd1f7e8d1, 0xc309e3d3, 0x0c24548b,
    0x0824448b, 0x2e73da39, 0xf757f3f7, 0xd3e8d1d1,
    0xf7c789e8, 0x8b142464, 0x8b0c245c, 0x2910244c,
    0x8bd119c3, 0x0f182444, 0xc129c7af, 0x3100df83,
    0x5ff889d2, 0xda29c35b, 0xf757f3f7, 0x0de8d1d1,
    0x80000000, 0xc789e8d3, 0x142464f7, 0x0c245c8b,
    0x10244c8b, 0xd119c329, 0x1824448b, 0x29c7af0f,
    0x00df83c1, 0xf889d231, 0x8bc35b5f, 0x8b0c2444,
    0x3110244c, 0x89f1f7d2, 0x24448bc3, 0x89f1f708,
    0xccc35bda, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0xcccccccc, 0xcccccccc, 0xcccccccc, 0xcccccccc,
    0x00080095, 0x00008e00, 0x0008009f, 0x00008e00,
    0x000800a9, 0x00008e00, 0x000800b3, 0x00008e00,
    0x000800bd, 0x00008e00, 0x000800c7, 0x00008e00,
    0x000800d1, 0x00008e00, 0x000800db, 0x00008e00,
    0x000800e5, 0x00008e00, 0x000800ed, 0x00008e00,
    0x000800f7, 0x00008e00, 0x000800ff, 0x00008e00,
    0x00080107, 0x00008e00, 0x0008010f, 0x00008e00,
    0x00080117, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080129, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801b1, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x000801a0, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x00080080, 0x00008e00,
    0x00080080, 0x00008e00, 0x000801bf, 0x00008e00,
    0x00000250, 0x00000260, 0x00000280, 0x00000270,
    0x00000290, 0x000002a0, 0x000002b0, 0x000002c0,
    0x000002d0, 0x000002e0, 0x000002f0, 0x00000300,
    0x00000310, 0x00000320, 0x00000330, 0x00000080,
    0x00000350, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000080, 0x00000080, 0x00000080, 0x00000080,
    0x00000000, 0x00000004, 0x0000000c, 0x00000014,
    0x0000001c, 0x00000024, 0x0000002c, 0x00000034,
    0x0000003c, 0x00000044, 0x0000004c, 0x00000054,
    0x0000005c, 0x00000064, 0x0000006c, 0x00000074,
    0x0000007c, 0x00000000, 0x00000008, 0x00000010,
    0x00000018, 0x00000020, 0x00000028, 0x00000030,
    0x00000038, 0x00000040, 0x00000048, 0x00000050,
    0x00000058, 0x00000060, 0x00000068, 0x00000070,
    0x00000078, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
