'\" t
.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbAllocCompatMap __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbAllocCompatMap \- Allocate a new compatibility map if you do not already have one available
.SH SYNOPSIS
.HP
.B Status XkbAllocCompatMap
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "unsigned int " "num_si" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I xkb
keyboard description in which to allocate compat map
.TP
.I which
mask of compatibility map components to allocate
.TP
.I num_si
number of symbol interpretations to allocate
.SH DESCRIPTION
.LP
.I xkb
specifies the keyboard description for which compatibility maps are to be allocated. The compatibility map is the
.I compat
field in this structure.

.I which
specifies the compatibility map components to be allocated (see XkbGetCompatMap).
.I which
is an inclusive OR of the bits shown in Table 1.

.TS
c s s
l l l.
Table 1 Compatibility Map Component Masks
_
Mask	Value	Affecting
_
XkbSymInterpMask	(1<<0)	Symbol interpretations
XkbGroupCompatMask	(1<<1)	Group maps
XkbAllCompatMask	(0x3)	All compatibility map components
.TE

.I num_si
specifies the total number of entries to allocate in the symbol interpretation vector
.I (xkb.compat.sym_interpret).

.I XkbAllocCompatMap
returns Success if successful, BadMatch if
.I xkb
is NULL, or BadAlloc if errors are encountered when attempting to allocate storage.
.SH STRUCTURES
.LP
.nf

    typedef struct {
        KeySym            sym;          /\&* keysym of interest or NULL */
        unsigned char     flags;        /\&* XkbSI_AutoRepeat, XkbSI_LockingKey */
        unsigned char     match;        /\&* specifies how mods is interpreted */
        unsigned char     mods;         /\&* modifier bits, correspond to eight real modifiers */
        unsigned char     virtual_mod;  /\&* 1 modifier to add to key virtual mod map */
        XkbAnyAction      act;          /\&* action to bind to symbol position on key */
    } XkbSymInterpretRec,*XkbSymInterpretPtr;

.fi
.SH DIAGNOSTICS
.TP 15
.B BadAlloc
Unable to allocate storage
.TP 15
.B BadMatch
A compatible version of Xkb was not available in the server or an argument has correct type and range, but is otherwise invalid
.SH "SEE ALSO"
.BR XkbGetCompatMap (__libmansuffix__)
.SH NOTES
.LP
Note that symbol interpretations in a compatibility map (the
.I sym_interpret
vector of XkbSymInterpretRec structures) are also allocated using this same function. To ensure that there is sufficient space in the symbol interpretation vector for entries to be added, use
.I XkbAllocCompatMap
specifying
.I which
as XkbSymInterpretMask and the number of free symbol interpretations needed in
.I num_si.
