
/***************************************************************************
 *
 * Copyright (C) 2021 Google Inc.
 * Copyright (c) 2023-2026 LunarG, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * *** ---- WARNING! ----
 * ***   THIS FILE IS GENERATED - DO NOT EDIT
 * ***   Update source file command_printer_generator.py for modifications
 * *** ---- WARNING! ----
 *
 ****************************************************************************/

// NOLINTBEGIN

#include <streambuf>
#include <vulkan/vk_enum_string_helper.h>

#include "command_common.h"
#include "command_printer.h"
#include "util.h"

YAML::Emitter &PrintNextPtr(YAML::Emitter &os, const void *pNext) {
    if (pNext == nullptr) {
        os << "nullptr";
        return os;
    }

    const VkStruct *pStruct = reinterpret_cast<const VkStruct *>(pNext);
    PrintVkStruct(os, pStruct);
    return PrintNextPtr(os, pStruct->pNext);
}

// Define all stream operators.

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExtent2D &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "width";
    // width -> Field -> uint32_t
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> uint32_t
    os << YAML::Value << t.height;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExtent3D &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "width";
    // width -> Field -> uint32_t
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> uint32_t
    os << YAML::Value << t.height;
    os << YAML::Key << "depth";
    // depth -> Field -> uint32_t
    os << YAML::Value << t.depth;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkOffset2D &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> int32_t
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> int32_t
    os << YAML::Value << t.y;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkOffset3D &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> int32_t
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> int32_t
    os << YAML::Value << t.y;
    os << YAML::Key << "z";
    // z -> Field -> int32_t
    os << YAML::Value << t.z;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRect2D &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "offset";
    // offset -> Field -> VkOffset2D
    os << YAML::Value << t.offset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent2D
    os << YAML::Value << t.extent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBaseInStructure &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBaseOutStructure &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferMemoryBarrier &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "srcQueueFamilyIndex";
    // srcQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.srcQueueFamilyIndex;
    os << YAML::Key << "dstQueueFamilyIndex";
    // dstQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.dstQueueFamilyIndex;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSubresourceRange &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::Key << "baseMipLevel";
    // baseMipLevel -> Field -> uint32_t
    os << YAML::Value << t.baseMipLevel;
    os << YAML::Key << "levelCount";
    // levelCount -> Field -> uint32_t
    os << YAML::Value << t.levelCount;
    os << YAML::Key << "baseArrayLayer";
    // baseArrayLayer -> Field -> uint32_t
    os << YAML::Value << t.baseArrayLayer;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageMemoryBarrier &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "oldLayout";
    // oldLayout -> Field -> VkImageLayout
    os << YAML::Value << t.oldLayout;
    os << YAML::Key << "newLayout";
    // newLayout -> Field -> VkImageLayout
    os << YAML::Value << t.newLayout;
    os << YAML::Key << "srcQueueFamilyIndex";
    // srcQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.srcQueueFamilyIndex;
    os << YAML::Key << "dstQueueFamilyIndex";
    // dstQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.dstQueueFamilyIndex;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "subresourceRange";
    // subresourceRange -> Field -> VkImageSubresourceRange
    os << YAML::Value << t.subresourceRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryBarrier &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.dstAccessMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAllocationCallbacks &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "pUserData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::Key << "pfnAllocation";
    // pointer
    if (t.pfnAllocation != nullptr) {
        os << YAML::Value << *t.pfnAllocation;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pfnReallocation";
    // pointer
    if (t.pfnReallocation != nullptr) {
        os << YAML::Value << *t.pfnReallocation;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pfnFree";
    // pointer
    if (t.pfnFree != nullptr) {
        os << YAML::Value << *t.pfnFree;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pfnInternalAllocation";
    // pointer
    if (t.pfnInternalAllocation != nullptr) {
        os << YAML::Value << *t.pfnInternalAllocation;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pfnInternalFree";
    // pointer
    if (t.pfnInternalFree != nullptr) {
        os << YAML::Value << *t.pfnInternalFree;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkApplicationInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pApplicationName";
    // pApplicationName -> Field -> string
    os << YAML::Value << t.pApplicationName;
    os << YAML::Key << "applicationVersion";
    // applicationVersion -> Field -> uint32_t
    os << YAML::Value << t.applicationVersion;
    os << YAML::Key << "pEngineName";
    // pEngineName -> Field -> string
    os << YAML::Value << t.pEngineName;
    os << YAML::Key << "engineVersion";
    // engineVersion -> Field -> uint32_t
    os << YAML::Value << t.engineVersion;
    os << YAML::Key << "apiVersion";
    // apiVersion -> Field -> uint32_t
    os << YAML::Value << t.apiVersion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFormatProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "linearTilingFeatures";
    // linearTilingFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.linearTilingFeatures;
    os << YAML::Key << "optimalTilingFeatures";
    // optimalTilingFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.optimalTilingFeatures;
    os << YAML::Key << "bufferFeatures";
    // bufferFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.bufferFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageFormatProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "maxExtent";
    // maxExtent -> Field -> VkExtent3D
    os << YAML::Value << t.maxExtent;
    os << YAML::Key << "maxMipLevels";
    // maxMipLevels -> Field -> uint32_t
    os << YAML::Value << t.maxMipLevels;
    os << YAML::Key << "maxArrayLayers";
    // maxArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.maxArrayLayers;
    os << YAML::Key << "sampleCounts";
    // sampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampleCounts;
    os << YAML::Key << "maxResourceSize";
    // maxResourceSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxResourceSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkInstanceCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkInstanceCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "pApplicationInfo";
    // pointer
    if (t.pApplicationInfo != nullptr) {
        os << YAML::Value << *t.pApplicationInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "enabledLayerCount";
    // enabledLayerCount -> Field -> uint32_t
    os << YAML::Value << t.enabledLayerCount;
    os << YAML::Key << "ppEnabledLayerNames";
    // ppEnabledLayerNames -> Field -> ConstDynamicArray(char)
    os << YAML::Value << t.ppEnabledLayerNames;
    os << YAML::Key << "enabledExtensionCount";
    // enabledExtensionCount -> Field -> uint32_t
    os << YAML::Value << t.enabledExtensionCount;
    os << YAML::Key << "ppEnabledExtensionNames";
    // ppEnabledExtensionNames -> Field -> ConstDynamicArray(char)
    os << YAML::Value << t.ppEnabledExtensionNames;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryHeap &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMemoryHeapFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryType &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "propertyFlags";
    // propertyFlags -> Field -> VkMemoryPropertyFlags
    os << YAML::Value << t.propertyFlags;
    os << YAML::Key << "heapIndex";
    // heapIndex -> Field -> uint32_t
    os << YAML::Value << t.heapIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "robustBufferAccess";
    // robustBufferAccess -> Field -> VkBool32
    os << YAML::Value << t.robustBufferAccess;
    os << YAML::Key << "fullDrawIndexUint32";
    // fullDrawIndexUint32 -> Field -> VkBool32
    os << YAML::Value << t.fullDrawIndexUint32;
    os << YAML::Key << "imageCubeArray";
    // imageCubeArray -> Field -> VkBool32
    os << YAML::Value << t.imageCubeArray;
    os << YAML::Key << "independentBlend";
    // independentBlend -> Field -> VkBool32
    os << YAML::Value << t.independentBlend;
    os << YAML::Key << "geometryShader";
    // geometryShader -> Field -> VkBool32
    os << YAML::Value << t.geometryShader;
    os << YAML::Key << "tessellationShader";
    // tessellationShader -> Field -> VkBool32
    os << YAML::Value << t.tessellationShader;
    os << YAML::Key << "sampleRateShading";
    // sampleRateShading -> Field -> VkBool32
    os << YAML::Value << t.sampleRateShading;
    os << YAML::Key << "dualSrcBlend";
    // dualSrcBlend -> Field -> VkBool32
    os << YAML::Value << t.dualSrcBlend;
    os << YAML::Key << "logicOp";
    // logicOp -> Field -> VkBool32
    os << YAML::Value << t.logicOp;
    os << YAML::Key << "multiDrawIndirect";
    // multiDrawIndirect -> Field -> VkBool32
    os << YAML::Value << t.multiDrawIndirect;
    os << YAML::Key << "drawIndirectFirstInstance";
    // drawIndirectFirstInstance -> Field -> VkBool32
    os << YAML::Value << t.drawIndirectFirstInstance;
    os << YAML::Key << "depthClamp";
    // depthClamp -> Field -> VkBool32
    os << YAML::Value << t.depthClamp;
    os << YAML::Key << "depthBiasClamp";
    // depthBiasClamp -> Field -> VkBool32
    os << YAML::Value << t.depthBiasClamp;
    os << YAML::Key << "fillModeNonSolid";
    // fillModeNonSolid -> Field -> VkBool32
    os << YAML::Value << t.fillModeNonSolid;
    os << YAML::Key << "depthBounds";
    // depthBounds -> Field -> VkBool32
    os << YAML::Value << t.depthBounds;
    os << YAML::Key << "wideLines";
    // wideLines -> Field -> VkBool32
    os << YAML::Value << t.wideLines;
    os << YAML::Key << "largePoints";
    // largePoints -> Field -> VkBool32
    os << YAML::Value << t.largePoints;
    os << YAML::Key << "alphaToOne";
    // alphaToOne -> Field -> VkBool32
    os << YAML::Value << t.alphaToOne;
    os << YAML::Key << "multiViewport";
    // multiViewport -> Field -> VkBool32
    os << YAML::Value << t.multiViewport;
    os << YAML::Key << "samplerAnisotropy";
    // samplerAnisotropy -> Field -> VkBool32
    os << YAML::Value << t.samplerAnisotropy;
    os << YAML::Key << "textureCompressionETC2";
    // textureCompressionETC2 -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionETC2;
    os << YAML::Key << "textureCompressionASTC_LDR";
    // textureCompressionASTC_LDR -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionASTC_LDR;
    os << YAML::Key << "textureCompressionBC";
    // textureCompressionBC -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionBC;
    os << YAML::Key << "occlusionQueryPrecise";
    // occlusionQueryPrecise -> Field -> VkBool32
    os << YAML::Value << t.occlusionQueryPrecise;
    os << YAML::Key << "pipelineStatisticsQuery";
    // pipelineStatisticsQuery -> Field -> VkBool32
    os << YAML::Value << t.pipelineStatisticsQuery;
    os << YAML::Key << "vertexPipelineStoresAndAtomics";
    // vertexPipelineStoresAndAtomics -> Field -> VkBool32
    os << YAML::Value << t.vertexPipelineStoresAndAtomics;
    os << YAML::Key << "fragmentStoresAndAtomics";
    // fragmentStoresAndAtomics -> Field -> VkBool32
    os << YAML::Value << t.fragmentStoresAndAtomics;
    os << YAML::Key << "shaderTessellationAndGeometryPointSize";
    // shaderTessellationAndGeometryPointSize -> Field -> VkBool32
    os << YAML::Value << t.shaderTessellationAndGeometryPointSize;
    os << YAML::Key << "shaderImageGatherExtended";
    // shaderImageGatherExtended -> Field -> VkBool32
    os << YAML::Value << t.shaderImageGatherExtended;
    os << YAML::Key << "shaderStorageImageExtendedFormats";
    // shaderStorageImageExtendedFormats -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageExtendedFormats;
    os << YAML::Key << "shaderStorageImageMultisample";
    // shaderStorageImageMultisample -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageMultisample;
    os << YAML::Key << "shaderStorageImageReadWithoutFormat";
    // shaderStorageImageReadWithoutFormat -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageReadWithoutFormat;
    os << YAML::Key << "shaderStorageImageWriteWithoutFormat";
    // shaderStorageImageWriteWithoutFormat -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageWriteWithoutFormat;
    os << YAML::Key << "shaderUniformBufferArrayDynamicIndexing";
    // shaderUniformBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderSampledImageArrayDynamicIndexing";
    // shaderSampledImageArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderSampledImageArrayDynamicIndexing;
    os << YAML::Key << "shaderStorageBufferArrayDynamicIndexing";
    // shaderStorageBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderStorageImageArrayDynamicIndexing";
    // shaderStorageImageArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageArrayDynamicIndexing;
    os << YAML::Key << "shaderClipDistance";
    // shaderClipDistance -> Field -> VkBool32
    os << YAML::Value << t.shaderClipDistance;
    os << YAML::Key << "shaderCullDistance";
    // shaderCullDistance -> Field -> VkBool32
    os << YAML::Value << t.shaderCullDistance;
    os << YAML::Key << "shaderFloat64";
    // shaderFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderFloat64;
    os << YAML::Key << "shaderInt64";
    // shaderInt64 -> Field -> VkBool32
    os << YAML::Value << t.shaderInt64;
    os << YAML::Key << "shaderInt16";
    // shaderInt16 -> Field -> VkBool32
    os << YAML::Value << t.shaderInt16;
    os << YAML::Key << "shaderResourceResidency";
    // shaderResourceResidency -> Field -> VkBool32
    os << YAML::Value << t.shaderResourceResidency;
    os << YAML::Key << "shaderResourceMinLod";
    // shaderResourceMinLod -> Field -> VkBool32
    os << YAML::Value << t.shaderResourceMinLod;
    os << YAML::Key << "sparseBinding";
    // sparseBinding -> Field -> VkBool32
    os << YAML::Value << t.sparseBinding;
    os << YAML::Key << "sparseResidencyBuffer";
    // sparseResidencyBuffer -> Field -> VkBool32
    os << YAML::Value << t.sparseResidencyBuffer;
    os << YAML::Key << "sparseResidencyImage2D";
    // sparseResidencyImage2D -> Field -> VkBool32
    os << YAML::Value << t.sparseResidencyImage2D;
    os << YAML::Key << "sparseResidencyImage3D";
    // sparseResidencyImage3D -> Field -> VkBool32
    os << YAML::Value << t.sparseResidencyImage3D;
    os << YAML::Key << "sparseResidency2Samples";
    // sparseResidency2Samples -> Field -> VkBool32
    os << YAML::Value << t.sparseResidency2Samples;
    os << YAML::Key << "sparseResidency4Samples";
    // sparseResidency4Samples -> Field -> VkBool32
    os << YAML::Value << t.sparseResidency4Samples;
    os << YAML::Key << "sparseResidency8Samples";
    // sparseResidency8Samples -> Field -> VkBool32
    os << YAML::Value << t.sparseResidency8Samples;
    os << YAML::Key << "sparseResidency16Samples";
    // sparseResidency16Samples -> Field -> VkBool32
    os << YAML::Value << t.sparseResidency16Samples;
    os << YAML::Key << "sparseResidencyAliased";
    // sparseResidencyAliased -> Field -> VkBool32
    os << YAML::Value << t.sparseResidencyAliased;
    os << YAML::Key << "variableMultisampleRate";
    // variableMultisampleRate -> Field -> VkBool32
    os << YAML::Value << t.variableMultisampleRate;
    os << YAML::Key << "inheritedQueries";
    // inheritedQueries -> Field -> VkBool32
    os << YAML::Value << t.inheritedQueries;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLimits &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "maxImageDimension1D";
    // maxImageDimension1D -> Field -> uint32_t
    os << YAML::Value << t.maxImageDimension1D;
    os << YAML::Key << "maxImageDimension2D";
    // maxImageDimension2D -> Field -> uint32_t
    os << YAML::Value << t.maxImageDimension2D;
    os << YAML::Key << "maxImageDimension3D";
    // maxImageDimension3D -> Field -> uint32_t
    os << YAML::Value << t.maxImageDimension3D;
    os << YAML::Key << "maxImageDimensionCube";
    // maxImageDimensionCube -> Field -> uint32_t
    os << YAML::Value << t.maxImageDimensionCube;
    os << YAML::Key << "maxImageArrayLayers";
    // maxImageArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.maxImageArrayLayers;
    os << YAML::Key << "maxTexelBufferElements";
    // maxTexelBufferElements -> Field -> uint32_t
    os << YAML::Value << t.maxTexelBufferElements;
    os << YAML::Key << "maxUniformBufferRange";
    // maxUniformBufferRange -> Field -> uint32_t
    os << YAML::Value << t.maxUniformBufferRange;
    os << YAML::Key << "maxStorageBufferRange";
    // maxStorageBufferRange -> Field -> uint32_t
    os << YAML::Value << t.maxStorageBufferRange;
    os << YAML::Key << "maxPushConstantsSize";
    // maxPushConstantsSize -> Field -> uint32_t
    os << YAML::Value << t.maxPushConstantsSize;
    os << YAML::Key << "maxMemoryAllocationCount";
    // maxMemoryAllocationCount -> Field -> uint32_t
    os << YAML::Value << t.maxMemoryAllocationCount;
    os << YAML::Key << "maxSamplerAllocationCount";
    // maxSamplerAllocationCount -> Field -> uint32_t
    os << YAML::Value << t.maxSamplerAllocationCount;
    os << YAML::Key << "bufferImageGranularity";
    // bufferImageGranularity -> Field -> VkDeviceSize
    os << YAML::Value << t.bufferImageGranularity;
    os << YAML::Key << "sparseAddressSpaceSize";
    // sparseAddressSpaceSize -> Field -> VkDeviceSize
    os << YAML::Value << t.sparseAddressSpaceSize;
    os << YAML::Key << "maxBoundDescriptorSets";
    // maxBoundDescriptorSets -> Field -> uint32_t
    os << YAML::Value << t.maxBoundDescriptorSets;
    os << YAML::Key << "maxPerStageDescriptorSamplers";
    // maxPerStageDescriptorSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorSamplers;
    os << YAML::Key << "maxPerStageDescriptorUniformBuffers";
    // maxPerStageDescriptorUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUniformBuffers;
    os << YAML::Key << "maxPerStageDescriptorStorageBuffers";
    // maxPerStageDescriptorStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorStorageBuffers;
    os << YAML::Key << "maxPerStageDescriptorSampledImages";
    // maxPerStageDescriptorSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorSampledImages;
    os << YAML::Key << "maxPerStageDescriptorStorageImages";
    // maxPerStageDescriptorStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorStorageImages;
    os << YAML::Key << "maxPerStageDescriptorInputAttachments";
    // maxPerStageDescriptorInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorInputAttachments;
    os << YAML::Key << "maxPerStageResources";
    // maxPerStageResources -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageResources;
    os << YAML::Key << "maxDescriptorSetSamplers";
    // maxDescriptorSetSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetSamplers;
    os << YAML::Key << "maxDescriptorSetUniformBuffers";
    // maxDescriptorSetUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUniformBuffers;
    os << YAML::Key << "maxDescriptorSetUniformBuffersDynamic";
    // maxDescriptorSetUniformBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUniformBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetStorageBuffers";
    // maxDescriptorSetStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetStorageBuffers;
    os << YAML::Key << "maxDescriptorSetStorageBuffersDynamic";
    // maxDescriptorSetStorageBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetStorageBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetSampledImages";
    // maxDescriptorSetSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetSampledImages;
    os << YAML::Key << "maxDescriptorSetStorageImages";
    // maxDescriptorSetStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetStorageImages;
    os << YAML::Key << "maxDescriptorSetInputAttachments";
    // maxDescriptorSetInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetInputAttachments;
    os << YAML::Key << "maxVertexInputAttributes";
    // maxVertexInputAttributes -> Field -> uint32_t
    os << YAML::Value << t.maxVertexInputAttributes;
    os << YAML::Key << "maxVertexInputBindings";
    // maxVertexInputBindings -> Field -> uint32_t
    os << YAML::Value << t.maxVertexInputBindings;
    os << YAML::Key << "maxVertexInputAttributeOffset";
    // maxVertexInputAttributeOffset -> Field -> uint32_t
    os << YAML::Value << t.maxVertexInputAttributeOffset;
    os << YAML::Key << "maxVertexInputBindingStride";
    // maxVertexInputBindingStride -> Field -> uint32_t
    os << YAML::Value << t.maxVertexInputBindingStride;
    os << YAML::Key << "maxVertexOutputComponents";
    // maxVertexOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxVertexOutputComponents;
    os << YAML::Key << "maxTessellationGenerationLevel";
    // maxTessellationGenerationLevel -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationGenerationLevel;
    os << YAML::Key << "maxTessellationPatchSize";
    // maxTessellationPatchSize -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationPatchSize;
    os << YAML::Key << "maxTessellationControlPerVertexInputComponents";
    // maxTessellationControlPerVertexInputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationControlPerVertexInputComponents;
    os << YAML::Key << "maxTessellationControlPerVertexOutputComponents";
    // maxTessellationControlPerVertexOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationControlPerVertexOutputComponents;
    os << YAML::Key << "maxTessellationControlPerPatchOutputComponents";
    // maxTessellationControlPerPatchOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationControlPerPatchOutputComponents;
    os << YAML::Key << "maxTessellationControlTotalOutputComponents";
    // maxTessellationControlTotalOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationControlTotalOutputComponents;
    os << YAML::Key << "maxTessellationEvaluationInputComponents";
    // maxTessellationEvaluationInputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationEvaluationInputComponents;
    os << YAML::Key << "maxTessellationEvaluationOutputComponents";
    // maxTessellationEvaluationOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxTessellationEvaluationOutputComponents;
    os << YAML::Key << "maxGeometryShaderInvocations";
    // maxGeometryShaderInvocations -> Field -> uint32_t
    os << YAML::Value << t.maxGeometryShaderInvocations;
    os << YAML::Key << "maxGeometryInputComponents";
    // maxGeometryInputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxGeometryInputComponents;
    os << YAML::Key << "maxGeometryOutputComponents";
    // maxGeometryOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxGeometryOutputComponents;
    os << YAML::Key << "maxGeometryOutputVertices";
    // maxGeometryOutputVertices -> Field -> uint32_t
    os << YAML::Value << t.maxGeometryOutputVertices;
    os << YAML::Key << "maxGeometryTotalOutputComponents";
    // maxGeometryTotalOutputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxGeometryTotalOutputComponents;
    os << YAML::Key << "maxFragmentInputComponents";
    // maxFragmentInputComponents -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentInputComponents;
    os << YAML::Key << "maxFragmentOutputAttachments";
    // maxFragmentOutputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentOutputAttachments;
    os << YAML::Key << "maxFragmentDualSrcAttachments";
    // maxFragmentDualSrcAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentDualSrcAttachments;
    os << YAML::Key << "maxFragmentCombinedOutputResources";
    // maxFragmentCombinedOutputResources -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentCombinedOutputResources;
    os << YAML::Key << "maxComputeSharedMemorySize";
    // maxComputeSharedMemorySize -> Field -> uint32_t
    os << YAML::Value << t.maxComputeSharedMemorySize;
    os << YAML::Key << "maxComputeWorkGroupCount";
    // maxComputeWorkGroupCount -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.maxComputeWorkGroupCount[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "maxComputeWorkGroupInvocations";
    // maxComputeWorkGroupInvocations -> Field -> uint32_t
    os << YAML::Value << t.maxComputeWorkGroupInvocations;
    os << YAML::Key << "maxComputeWorkGroupSize";
    // maxComputeWorkGroupSize -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.maxComputeWorkGroupSize[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "subPixelPrecisionBits";
    // subPixelPrecisionBits -> Field -> uint32_t
    os << YAML::Value << t.subPixelPrecisionBits;
    os << YAML::Key << "subTexelPrecisionBits";
    // subTexelPrecisionBits -> Field -> uint32_t
    os << YAML::Value << t.subTexelPrecisionBits;
    os << YAML::Key << "mipmapPrecisionBits";
    // mipmapPrecisionBits -> Field -> uint32_t
    os << YAML::Value << t.mipmapPrecisionBits;
    os << YAML::Key << "maxDrawIndexedIndexValue";
    // maxDrawIndexedIndexValue -> Field -> uint32_t
    os << YAML::Value << t.maxDrawIndexedIndexValue;
    os << YAML::Key << "maxDrawIndirectCount";
    // maxDrawIndirectCount -> Field -> uint32_t
    os << YAML::Value << t.maxDrawIndirectCount;
    os << YAML::Key << "maxSamplerLodBias";
    // maxSamplerLodBias -> Field -> float
    os << YAML::Value << t.maxSamplerLodBias;
    os << YAML::Key << "maxSamplerAnisotropy";
    // maxSamplerAnisotropy -> Field -> float
    os << YAML::Value << t.maxSamplerAnisotropy;
    os << YAML::Key << "maxViewports";
    // maxViewports -> Field -> uint32_t
    os << YAML::Value << t.maxViewports;
    os << YAML::Key << "maxViewportDimensions";
    // maxViewportDimensions -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.maxViewportDimensions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "viewportBoundsRange";
    // viewportBoundsRange -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.viewportBoundsRange[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "viewportSubPixelBits";
    // viewportSubPixelBits -> Field -> uint32_t
    os << YAML::Value << t.viewportSubPixelBits;
    os << YAML::Key << "minMemoryMapAlignment";
    // minMemoryMapAlignment -> Field -> size_t
    os << YAML::Value << t.minMemoryMapAlignment;
    os << YAML::Key << "minTexelBufferOffsetAlignment";
    // minTexelBufferOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minTexelBufferOffsetAlignment;
    os << YAML::Key << "minUniformBufferOffsetAlignment";
    // minUniformBufferOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minUniformBufferOffsetAlignment;
    os << YAML::Key << "minStorageBufferOffsetAlignment";
    // minStorageBufferOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minStorageBufferOffsetAlignment;
    os << YAML::Key << "minTexelOffset";
    // minTexelOffset -> Field -> int32_t
    os << YAML::Value << t.minTexelOffset;
    os << YAML::Key << "maxTexelOffset";
    // maxTexelOffset -> Field -> uint32_t
    os << YAML::Value << t.maxTexelOffset;
    os << YAML::Key << "minTexelGatherOffset";
    // minTexelGatherOffset -> Field -> int32_t
    os << YAML::Value << t.minTexelGatherOffset;
    os << YAML::Key << "maxTexelGatherOffset";
    // maxTexelGatherOffset -> Field -> uint32_t
    os << YAML::Value << t.maxTexelGatherOffset;
    os << YAML::Key << "minInterpolationOffset";
    // minInterpolationOffset -> Field -> float
    os << YAML::Value << t.minInterpolationOffset;
    os << YAML::Key << "maxInterpolationOffset";
    // maxInterpolationOffset -> Field -> float
    os << YAML::Value << t.maxInterpolationOffset;
    os << YAML::Key << "subPixelInterpolationOffsetBits";
    // subPixelInterpolationOffsetBits -> Field -> uint32_t
    os << YAML::Value << t.subPixelInterpolationOffsetBits;
    os << YAML::Key << "maxFramebufferWidth";
    // maxFramebufferWidth -> Field -> uint32_t
    os << YAML::Value << t.maxFramebufferWidth;
    os << YAML::Key << "maxFramebufferHeight";
    // maxFramebufferHeight -> Field -> uint32_t
    os << YAML::Value << t.maxFramebufferHeight;
    os << YAML::Key << "maxFramebufferLayers";
    // maxFramebufferLayers -> Field -> uint32_t
    os << YAML::Value << t.maxFramebufferLayers;
    os << YAML::Key << "framebufferColorSampleCounts";
    // framebufferColorSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.framebufferColorSampleCounts;
    os << YAML::Key << "framebufferDepthSampleCounts";
    // framebufferDepthSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.framebufferDepthSampleCounts;
    os << YAML::Key << "framebufferStencilSampleCounts";
    // framebufferStencilSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.framebufferStencilSampleCounts;
    os << YAML::Key << "framebufferNoAttachmentsSampleCounts";
    // framebufferNoAttachmentsSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.framebufferNoAttachmentsSampleCounts;
    os << YAML::Key << "maxColorAttachments";
    // maxColorAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxColorAttachments;
    os << YAML::Key << "sampledImageColorSampleCounts";
    // sampledImageColorSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampledImageColorSampleCounts;
    os << YAML::Key << "sampledImageIntegerSampleCounts";
    // sampledImageIntegerSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampledImageIntegerSampleCounts;
    os << YAML::Key << "sampledImageDepthSampleCounts";
    // sampledImageDepthSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampledImageDepthSampleCounts;
    os << YAML::Key << "sampledImageStencilSampleCounts";
    // sampledImageStencilSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampledImageStencilSampleCounts;
    os << YAML::Key << "storageImageSampleCounts";
    // storageImageSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.storageImageSampleCounts;
    os << YAML::Key << "maxSampleMaskWords";
    // maxSampleMaskWords -> Field -> uint32_t
    os << YAML::Value << t.maxSampleMaskWords;
    os << YAML::Key << "timestampComputeAndGraphics";
    // timestampComputeAndGraphics -> Field -> VkBool32
    os << YAML::Value << t.timestampComputeAndGraphics;
    os << YAML::Key << "timestampPeriod";
    // timestampPeriod -> Field -> float
    os << YAML::Value << t.timestampPeriod;
    os << YAML::Key << "maxClipDistances";
    // maxClipDistances -> Field -> uint32_t
    os << YAML::Value << t.maxClipDistances;
    os << YAML::Key << "maxCullDistances";
    // maxCullDistances -> Field -> uint32_t
    os << YAML::Value << t.maxCullDistances;
    os << YAML::Key << "maxCombinedClipAndCullDistances";
    // maxCombinedClipAndCullDistances -> Field -> uint32_t
    os << YAML::Value << t.maxCombinedClipAndCullDistances;
    os << YAML::Key << "discreteQueuePriorities";
    // discreteQueuePriorities -> Field -> uint32_t
    os << YAML::Value << t.discreteQueuePriorities;
    os << YAML::Key << "pointSizeRange";
    // pointSizeRange -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.pointSizeRange[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "lineWidthRange";
    // lineWidthRange -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.lineWidthRange[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pointSizeGranularity";
    // pointSizeGranularity -> Field -> float
    os << YAML::Value << t.pointSizeGranularity;
    os << YAML::Key << "lineWidthGranularity";
    // lineWidthGranularity -> Field -> float
    os << YAML::Value << t.lineWidthGranularity;
    os << YAML::Key << "strictLines";
    // strictLines -> Field -> VkBool32
    os << YAML::Value << t.strictLines;
    os << YAML::Key << "standardSampleLocations";
    // standardSampleLocations -> Field -> VkBool32
    os << YAML::Value << t.standardSampleLocations;
    os << YAML::Key << "optimalBufferCopyOffsetAlignment";
    // optimalBufferCopyOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.optimalBufferCopyOffsetAlignment;
    os << YAML::Key << "optimalBufferCopyRowPitchAlignment";
    // optimalBufferCopyRowPitchAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.optimalBufferCopyRowPitchAlignment;
    os << YAML::Key << "nonCoherentAtomSize";
    // nonCoherentAtomSize -> Field -> VkDeviceSize
    os << YAML::Value << t.nonCoherentAtomSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMemoryProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "memoryTypeCount";
    // memoryTypeCount -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeCount;
    os << YAML::Key << "memoryTypes";
    // memoryTypes -> Field -> DynamicArray(VkMemoryType)
    if (t.memoryTypeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkMemoryType");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.memoryTypeCount); ++i) {
                os << t.memoryTypes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "memoryHeapCount";
    // memoryHeapCount -> Field -> uint32_t
    os << YAML::Value << t.memoryHeapCount;
    os << YAML::Key << "memoryHeaps";
    // memoryHeaps -> Field -> DynamicArray(VkMemoryHeap)
    if (t.memoryHeapCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkMemoryHeap");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.memoryHeapCount); ++i) {
                os << t.memoryHeaps[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSparseProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "residencyStandard2DBlockShape";
    // residencyStandard2DBlockShape -> Field -> VkBool32
    os << YAML::Value << t.residencyStandard2DBlockShape;
    os << YAML::Key << "residencyStandard2DMultisampleBlockShape";
    // residencyStandard2DMultisampleBlockShape -> Field -> VkBool32
    os << YAML::Value << t.residencyStandard2DMultisampleBlockShape;
    os << YAML::Key << "residencyStandard3DBlockShape";
    // residencyStandard3DBlockShape -> Field -> VkBool32
    os << YAML::Value << t.residencyStandard3DBlockShape;
    os << YAML::Key << "residencyAlignedMipSize";
    // residencyAlignedMipSize -> Field -> VkBool32
    os << YAML::Value << t.residencyAlignedMipSize;
    os << YAML::Key << "residencyNonResidentStrict";
    // residencyNonResidentStrict -> Field -> VkBool32
    os << YAML::Value << t.residencyNonResidentStrict;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "apiVersion";
    // apiVersion -> Field -> uint32_t
    os << YAML::Value << t.apiVersion;
    os << YAML::Key << "driverVersion";
    // driverVersion -> Field -> uint32_t
    os << YAML::Value << t.driverVersion;
    os << YAML::Key << "vendorID";
    // vendorID -> Field -> uint32_t
    os << YAML::Value << t.vendorID;
    os << YAML::Key << "deviceID";
    // deviceID -> Field -> uint32_t
    os << YAML::Value << t.deviceID;
    os << YAML::Key << "deviceType";
    // deviceType -> Field -> VkPhysicalDeviceType
    os << YAML::Value << t.deviceType;
    os << YAML::Key << "deviceName";
    // deviceName -> Field -> FixedArray(char)
    os << YAML::Value << t.deviceName;
    os << YAML::Key << "pipelineCacheUUID";
    // pipelineCacheUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.pipelineCacheUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "limits";
    // limits -> Field -> VkPhysicalDeviceLimits
    os << YAML::Value << t.limits;
    os << YAML::Key << "sparseProperties";
    // sparseProperties -> Field -> VkPhysicalDeviceSparseProperties
    os << YAML::Value << t.sparseProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "queueFlags";
    // queueFlags -> Field -> VkQueueFlags
    os << YAML::Value << t.queueFlags;
    os << YAML::Key << "queueCount";
    // queueCount -> Field -> uint32_t
    os << YAML::Value << t.queueCount;
    os << YAML::Key << "timestampValidBits";
    // timestampValidBits -> Field -> uint32_t
    os << YAML::Value << t.timestampValidBits;
    os << YAML::Key << "minImageTransferGranularity";
    // minImageTransferGranularity -> Field -> VkExtent3D
    os << YAML::Value << t.minImageTransferGranularity;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceQueueCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceQueueCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "queueFamilyIndex";
    // queueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndex;
    os << YAML::Key << "queueCount";
    // queueCount -> Field -> uint32_t
    os << YAML::Value << t.queueCount;
    os << YAML::Key << "pQueuePriorities";
    // pQueuePriorities -> Field -> ConstDynamicArray(float)
    if (t.queueCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueCount); ++i) {
                os << t.pQueuePriorities[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "queueCreateInfoCount";
    // queueCreateInfoCount -> Field -> uint32_t
    os << YAML::Value << t.queueCreateInfoCount;
    os << YAML::Key << "pQueueCreateInfos";
    // pQueueCreateInfos -> Field -> ConstDynamicArray(VkDeviceQueueCreateInfo)
    if (t.queueCreateInfoCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceQueueCreateInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueCreateInfoCount); ++i) {
                os << t.pQueueCreateInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "enabledLayerCount";
    // enabledLayerCount -> Field -> uint32_t
    os << YAML::Value << t.enabledLayerCount;
    os << YAML::Key << "ppEnabledLayerNames";
    // ppEnabledLayerNames -> Field -> ConstDynamicArray(char)
    os << YAML::Value << t.ppEnabledLayerNames;
    os << YAML::Key << "enabledExtensionCount";
    // enabledExtensionCount -> Field -> uint32_t
    os << YAML::Value << t.enabledExtensionCount;
    os << YAML::Key << "ppEnabledExtensionNames";
    // ppEnabledExtensionNames -> Field -> ConstDynamicArray(char)
    os << YAML::Value << t.ppEnabledExtensionNames;
    os << YAML::Key << "pEnabledFeatures";
    // pointer
    if (t.pEnabledFeatures != nullptr) {
        os << YAML::Value << *t.pEnabledFeatures;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExtensionProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "extensionName";
    // extensionName -> Field -> FixedArray(char)
    os << YAML::Value << t.extensionName;
    os << YAML::Key << "specVersion";
    // specVersion -> Field -> uint32_t
    os << YAML::Value << t.specVersion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkLayerProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "layerName";
    // layerName -> Field -> FixedArray(char)
    os << YAML::Value << t.layerName;
    os << YAML::Key << "specVersion";
    // specVersion -> Field -> uint32_t
    os << YAML::Value << t.specVersion;
    os << YAML::Key << "implementationVersion";
    // implementationVersion -> Field -> uint32_t
    os << YAML::Value << t.implementationVersion;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreCount";
    // waitSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreCount;
    os << YAML::Key << "pWaitSemaphores";
    // pWaitSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.waitSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreCount); ++i) {
                os << t.pWaitSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pWaitDstStageMask";
    // pWaitDstStageMask -> Field -> ConstDynamicArray(VkPipelineStageFlags)
    if (t.waitSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineStageFlags");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreCount); ++i) {
                os << t.pWaitDstStageMask[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "commandBufferCount";
    // commandBufferCount -> Field -> uint32_t
    os << YAML::Value << t.commandBufferCount;
    os << YAML::Key << "pCommandBuffers";
    // pCommandBuffers -> Field -> ConstDynamicArray(VkCommandBuffer)
    if (t.commandBufferCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkCommandBuffer");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.commandBufferCount); ++i) {
                os << t.pCommandBuffers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreCount";
    // signalSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreCount;
    os << YAML::Key << "pSignalSemaphores";
    // pSignalSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.signalSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreCount); ++i) {
                os << t.pSignalSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMappedMemoryRange &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "allocationSize";
    // allocationSize -> Field -> VkDeviceSize
    os << YAML::Value << t.allocationSize;
    os << YAML::Key << "memoryTypeIndex";
    // memoryTypeIndex -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryRequirements &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "alignment";
    // alignment -> Field -> VkDeviceSize
    os << YAML::Value << t.alignment;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseMemoryBind &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "resourceOffset";
    // resourceOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.resourceOffset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSparseMemoryBindFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseBufferMemoryBindInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "bindCount";
    // bindCount -> Field -> uint32_t
    os << YAML::Value << t.bindCount;
    os << YAML::Key << "pBinds";
    // pBinds -> Field -> ConstDynamicArray(VkSparseMemoryBind)
    if (t.bindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseMemoryBind");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bindCount); ++i) {
                os << t.pBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageOpaqueMemoryBindInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "bindCount";
    // bindCount -> Field -> uint32_t
    os << YAML::Value << t.bindCount;
    os << YAML::Key << "pBinds";
    // pBinds -> Field -> ConstDynamicArray(VkSparseMemoryBind)
    if (t.bindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseMemoryBind");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bindCount); ++i) {
                os << t.pBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSubresource &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::Key << "mipLevel";
    // mipLevel -> Field -> uint32_t
    os << YAML::Value << t.mipLevel;
    os << YAML::Key << "arrayLayer";
    // arrayLayer -> Field -> uint32_t
    os << YAML::Value << t.arrayLayer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageMemoryBind &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "subresource";
    // subresource -> Field -> VkImageSubresource
    os << YAML::Value << t.subresource;
    os << YAML::Key << "offset";
    // offset -> Field -> VkOffset3D
    os << YAML::Value << t.offset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSparseMemoryBindFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageMemoryBindInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "bindCount";
    // bindCount -> Field -> uint32_t
    os << YAML::Value << t.bindCount;
    os << YAML::Key << "pBinds";
    // pBinds -> Field -> ConstDynamicArray(VkSparseImageMemoryBind)
    if (t.bindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseImageMemoryBind");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bindCount); ++i) {
                os << t.pBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindSparseInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreCount";
    // waitSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreCount;
    os << YAML::Key << "pWaitSemaphores";
    // pWaitSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.waitSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreCount); ++i) {
                os << t.pWaitSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "bufferBindCount";
    // bufferBindCount -> Field -> uint32_t
    os << YAML::Value << t.bufferBindCount;
    os << YAML::Key << "pBufferBinds";
    // pBufferBinds -> Field -> ConstDynamicArray(VkSparseBufferMemoryBindInfo)
    if (t.bufferBindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseBufferMemoryBindInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bufferBindCount); ++i) {
                os << t.pBufferBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "imageOpaqueBindCount";
    // imageOpaqueBindCount -> Field -> uint32_t
    os << YAML::Value << t.imageOpaqueBindCount;
    os << YAML::Key << "pImageOpaqueBinds";
    // pImageOpaqueBinds -> Field -> ConstDynamicArray(VkSparseImageOpaqueMemoryBindInfo)
    if (t.imageOpaqueBindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseImageOpaqueMemoryBindInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.imageOpaqueBindCount); ++i) {
                os << t.pImageOpaqueBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "imageBindCount";
    // imageBindCount -> Field -> uint32_t
    os << YAML::Value << t.imageBindCount;
    os << YAML::Key << "pImageBinds";
    // pImageBinds -> Field -> ConstDynamicArray(VkSparseImageMemoryBindInfo)
    if (t.imageBindCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSparseImageMemoryBindInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.imageBindCount); ++i) {
                os << t.pImageBinds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreCount";
    // signalSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreCount;
    os << YAML::Key << "pSignalSemaphores";
    // pSignalSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.signalSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreCount); ++i) {
                os << t.pSignalSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageFormatProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::Key << "imageGranularity";
    // imageGranularity -> Field -> VkExtent3D
    os << YAML::Value << t.imageGranularity;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSparseImageFormatFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageMemoryRequirements &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "formatProperties";
    // formatProperties -> Field -> VkSparseImageFormatProperties
    os << YAML::Value << t.formatProperties;
    os << YAML::Key << "imageMipTailFirstLod";
    // imageMipTailFirstLod -> Field -> uint32_t
    os << YAML::Value << t.imageMipTailFirstLod;
    os << YAML::Key << "imageMipTailSize";
    // imageMipTailSize -> Field -> VkDeviceSize
    os << YAML::Value << t.imageMipTailSize;
    os << YAML::Key << "imageMipTailOffset";
    // imageMipTailOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.imageMipTailOffset;
    os << YAML::Key << "imageMipTailStride";
    // imageMipTailStride -> Field -> VkDeviceSize
    os << YAML::Value << t.imageMipTailStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFenceCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkFenceCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSemaphoreCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueryPoolCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkQueryPoolCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "queryType";
    // queryType -> Field -> VkQueryType
    os << YAML::Value << t.queryType;
    os << YAML::Key << "queryCount";
    // queryCount -> Field -> uint32_t
    os << YAML::Value << t.queryCount;
    os << YAML::Key << "pipelineStatistics";
    // pipelineStatistics -> Field -> VkQueryPipelineStatisticFlags
    os << YAML::Value << t.pipelineStatistics;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkBufferCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "usage";
    // usage -> Field -> VkBufferUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "sharingMode";
    // sharingMode -> Field -> VkSharingMode
    os << YAML::Value << t.sharingMode;
    os << YAML::Key << "queueFamilyIndexCount";
    // queueFamilyIndexCount -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndexCount;
    os << YAML::Key << "pQueueFamilyIndices";
    // pQueueFamilyIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.queueFamilyIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueFamilyIndexCount); ++i) {
                os << t.pQueueFamilyIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImageCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "imageType";
    // imageType -> Field -> VkImageType
    os << YAML::Value << t.imageType;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::Key << "mipLevels";
    // mipLevels -> Field -> uint32_t
    os << YAML::Value << t.mipLevels;
    os << YAML::Key << "arrayLayers";
    // arrayLayers -> Field -> uint32_t
    os << YAML::Value << t.arrayLayers;
    os << YAML::Key << "samples";
    // samples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.samples;
    os << YAML::Key << "tiling";
    // tiling -> Field -> VkImageTiling
    os << YAML::Value << t.tiling;
    os << YAML::Key << "usage";
    // usage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "sharingMode";
    // sharingMode -> Field -> VkSharingMode
    os << YAML::Value << t.sharingMode;
    os << YAML::Key << "queueFamilyIndexCount";
    // queueFamilyIndexCount -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndexCount;
    os << YAML::Key << "pQueueFamilyIndices";
    // pQueueFamilyIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.queueFamilyIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueFamilyIndexCount); ++i) {
                os << t.pQueueFamilyIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "initialLayout";
    // initialLayout -> Field -> VkImageLayout
    os << YAML::Value << t.initialLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubresourceLayout &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "rowPitch";
    // rowPitch -> Field -> VkDeviceSize
    os << YAML::Value << t.rowPitch;
    os << YAML::Key << "arrayPitch";
    // arrayPitch -> Field -> VkDeviceSize
    os << YAML::Value << t.arrayPitch;
    os << YAML::Key << "depthPitch";
    // depthPitch -> Field -> VkDeviceSize
    os << YAML::Value << t.depthPitch;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkComponentMapping &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "r";
    // r -> Field -> VkComponentSwizzle
    os << YAML::Value << t.r;
    os << YAML::Key << "g";
    // g -> Field -> VkComponentSwizzle
    os << YAML::Value << t.g;
    os << YAML::Key << "b";
    // b -> Field -> VkComponentSwizzle
    os << YAML::Value << t.b;
    os << YAML::Key << "a";
    // a -> Field -> VkComponentSwizzle
    os << YAML::Value << t.a;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImageViewCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "viewType";
    // viewType -> Field -> VkImageViewType
    os << YAML::Value << t.viewType;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "components";
    // components -> Field -> VkComponentMapping
    os << YAML::Value << t.components;
    os << YAML::Key << "subresourceRange";
    // subresourceRange -> Field -> VkImageSubresourceRange
    os << YAML::Value << t.subresourceRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandPoolCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkCommandPoolCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "queueFamilyIndex";
    // queueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "commandPool";
    // commandPool -> Field -> VkCommandPool
    os << YAML::Value << t.commandPool;
    os << YAML::Key << "level";
    // level -> Field -> VkCommandBufferLevel
    os << YAML::Value << t.level;
    os << YAML::Key << "commandBufferCount";
    // commandBufferCount -> Field -> uint32_t
    os << YAML::Value << t.commandBufferCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "renderPass";
    // renderPass -> Field -> VkRenderPass
    os << YAML::Value << t.renderPass;
    os << YAML::Key << "subpass";
    // subpass -> Field -> uint32_t
    os << YAML::Value << t.subpass;
    os << YAML::Key << "framebuffer";
    // framebuffer -> Field -> VkFramebuffer
    os << YAML::Value << t.framebuffer;
    os << YAML::Key << "occlusionQueryEnable";
    // occlusionQueryEnable -> Field -> VkBool32
    os << YAML::Value << t.occlusionQueryEnable;
    os << YAML::Key << "queryFlags";
    // queryFlags -> Field -> VkQueryControlFlags
    os << YAML::Value << t.queryFlags;
    os << YAML::Key << "pipelineStatistics";
    // pipelineStatistics -> Field -> VkQueryPipelineStatisticFlags
    os << YAML::Value << t.pipelineStatistics;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkCommandBufferUsageFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "pInheritanceInfo";
    // pointer
    if (t.pInheritanceInfo != nullptr) {
        os << YAML::Value << *t.pInheritanceInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCopy &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSubresourceLayers &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::Key << "mipLevel";
    // mipLevel -> Field -> uint32_t
    os << YAML::Value << t.mipLevel;
    os << YAML::Key << "baseArrayLayer";
    // baseArrayLayer -> Field -> uint32_t
    os << YAML::Value << t.baseArrayLayer;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferImageCopy &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "bufferOffset";
    // bufferOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.bufferOffset;
    os << YAML::Key << "bufferRowLength";
    // bufferRowLength -> Field -> uint32_t
    os << YAML::Value << t.bufferRowLength;
    os << YAML::Key << "bufferImageHeight";
    // bufferImageHeight -> Field -> uint32_t
    os << YAML::Value << t.bufferImageHeight;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.imageSubresource;
    os << YAML::Key << "imageOffset";
    // imageOffset -> Field -> VkOffset3D
    os << YAML::Value << t.imageOffset;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent3D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCopy &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkOffset3D
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkOffset3D
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDispatchIndirectCommand &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> uint32_t
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> uint32_t
    os << YAML::Value << t.y;
    os << YAML::Key << "z";
    // z -> Field -> uint32_t
    os << YAML::Value << t.z;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCacheHeaderVersionOne &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "headerSize";
    // headerSize -> Field -> uint32_t
    os << YAML::Value << t.headerSize;
    os << YAML::Key << "headerVersion";
    // headerVersion -> Field -> VkPipelineCacheHeaderVersion
    os << YAML::Value << t.headerVersion;
    os << YAML::Key << "vendorID";
    // vendorID -> Field -> uint32_t
    os << YAML::Value << t.vendorID;
    os << YAML::Key << "deviceID";
    // deviceID -> Field -> uint32_t
    os << YAML::Value << t.deviceID;
    os << YAML::Key << "pipelineCacheUUID";
    // pipelineCacheUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.pipelineCacheUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkEventCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkEventCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferViewCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkBufferViewCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "range";
    // range -> Field -> VkDeviceSize
    os << YAML::Value << t.range;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShaderModuleCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkShaderModuleCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "codeSize";
    // codeSize -> Field -> size_t
    os << YAML::Value << t.codeSize;
    os << YAML::Key << "pCode";
    // pCode -> Field -> ConstDynamicArray(uint32_t)
    if ((t.codeSize / 4) == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t((t.codeSize / 4)); ++i) {
                os << t.pCode[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCacheCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCacheCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "initialDataSize";
    // initialDataSize -> Field -> size_t
    os << YAML::Value << t.initialDataSize;
    os << YAML::Key << "pInitialData";
    if (t.initialDataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pInitialData;
            for (uint64_t i = 0; i < t.initialDataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSpecializationMapEntry &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "constantID";
    // constantID -> Field -> uint32_t
    os << YAML::Value << t.constantID;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> size_t
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSpecializationInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "mapEntryCount";
    // mapEntryCount -> Field -> uint32_t
    os << YAML::Value << t.mapEntryCount;
    os << YAML::Key << "pMapEntries";
    // pMapEntries -> Field -> ConstDynamicArray(VkSpecializationMapEntry)
    if (t.mapEntryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSpecializationMapEntry");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.mapEntryCount); ++i) {
                os << t.pMapEntries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> size_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineShaderStageCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineShaderStageCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "stage";
    // stage -> Field -> VkShaderStageFlagBits
    os << YAML::Value << t.stage;
    os << YAML::Key << "module";
    // module -> Field -> VkShaderModule
    os << YAML::Value << t.module;
    os << YAML::Key << "pName";
    // pName -> Field -> string
    os << YAML::Value << t.pName;
    os << YAML::Key << "pSpecializationInfo";
    // pointer
    if (t.pSpecializationInfo != nullptr) {
        os << YAML::Value << *t.pSpecializationInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkComputePipelineCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "stage";
    // stage -> Field -> VkPipelineShaderStageCreateInfo
    os << YAML::Value << t.stage;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "basePipelineHandle";
    // basePipelineHandle -> Field -> VkPipeline
    os << YAML::Value << t.basePipelineHandle;
    os << YAML::Key << "basePipelineIndex";
    // basePipelineIndex -> Field -> int32_t
    os << YAML::Value << t.basePipelineIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPushConstantRange &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> uint32_t
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineLayoutCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineLayoutCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "setLayoutCount";
    // setLayoutCount -> Field -> uint32_t
    os << YAML::Value << t.setLayoutCount;
    os << YAML::Key << "pSetLayouts";
    // pSetLayouts -> Field -> ConstDynamicArray(VkDescriptorSetLayout)
    if (t.setLayoutCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorSetLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.setLayoutCount); ++i) {
                os << t.pSetLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pushConstantRangeCount";
    // pushConstantRangeCount -> Field -> uint32_t
    os << YAML::Value << t.pushConstantRangeCount;
    os << YAML::Key << "pPushConstantRanges";
    // pPushConstantRanges -> Field -> ConstDynamicArray(VkPushConstantRange)
    if (t.pushConstantRangeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPushConstantRange");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.pushConstantRangeCount); ++i) {
                os << t.pPushConstantRanges[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSamplerCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "magFilter";
    // magFilter -> Field -> VkFilter
    os << YAML::Value << t.magFilter;
    os << YAML::Key << "minFilter";
    // minFilter -> Field -> VkFilter
    os << YAML::Value << t.minFilter;
    os << YAML::Key << "mipmapMode";
    // mipmapMode -> Field -> VkSamplerMipmapMode
    os << YAML::Value << t.mipmapMode;
    os << YAML::Key << "addressModeU";
    // addressModeU -> Field -> VkSamplerAddressMode
    os << YAML::Value << t.addressModeU;
    os << YAML::Key << "addressModeV";
    // addressModeV -> Field -> VkSamplerAddressMode
    os << YAML::Value << t.addressModeV;
    os << YAML::Key << "addressModeW";
    // addressModeW -> Field -> VkSamplerAddressMode
    os << YAML::Value << t.addressModeW;
    os << YAML::Key << "mipLodBias";
    // mipLodBias -> Field -> float
    os << YAML::Value << t.mipLodBias;
    os << YAML::Key << "anisotropyEnable";
    // anisotropyEnable -> Field -> VkBool32
    os << YAML::Value << t.anisotropyEnable;
    os << YAML::Key << "maxAnisotropy";
    // maxAnisotropy -> Field -> float
    os << YAML::Value << t.maxAnisotropy;
    os << YAML::Key << "compareEnable";
    // compareEnable -> Field -> VkBool32
    os << YAML::Value << t.compareEnable;
    os << YAML::Key << "compareOp";
    // compareOp -> Field -> VkCompareOp
    os << YAML::Value << t.compareOp;
    os << YAML::Key << "minLod";
    // minLod -> Field -> float
    os << YAML::Value << t.minLod;
    os << YAML::Key << "maxLod";
    // maxLod -> Field -> float
    os << YAML::Value << t.maxLod;
    os << YAML::Key << "borderColor";
    // borderColor -> Field -> VkBorderColor
    os << YAML::Value << t.borderColor;
    os << YAML::Key << "unnormalizedCoordinates";
    // unnormalizedCoordinates -> Field -> VkBool32
    os << YAML::Value << t.unnormalizedCoordinates;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyDescriptorSet &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcSet";
    // srcSet -> Field -> VkDescriptorSet
    os << YAML::Value << t.srcSet;
    os << YAML::Key << "srcBinding";
    // srcBinding -> Field -> uint32_t
    os << YAML::Value << t.srcBinding;
    os << YAML::Key << "srcArrayElement";
    // srcArrayElement -> Field -> uint32_t
    os << YAML::Value << t.srcArrayElement;
    os << YAML::Key << "dstSet";
    // dstSet -> Field -> VkDescriptorSet
    os << YAML::Value << t.dstSet;
    os << YAML::Key << "dstBinding";
    // dstBinding -> Field -> uint32_t
    os << YAML::Value << t.dstBinding;
    os << YAML::Key << "dstArrayElement";
    // dstArrayElement -> Field -> uint32_t
    os << YAML::Value << t.dstArrayElement;
    os << YAML::Key << "descriptorCount";
    // descriptorCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorBufferInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "range";
    // range -> Field -> VkDeviceSize
    os << YAML::Value << t.range;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorImageInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sampler";
    // sampler -> Field -> VkSampler
    os << YAML::Value << t.sampler;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "imageLayout";
    // imageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.imageLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorPoolSize &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "type";
    // type -> Field -> VkDescriptorType
    os << YAML::Value << t.type;
    os << YAML::Key << "descriptorCount";
    // descriptorCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorPoolCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDescriptorPoolCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "maxSets";
    // maxSets -> Field -> uint32_t
    os << YAML::Value << t.maxSets;
    os << YAML::Key << "poolSizeCount";
    // poolSizeCount -> Field -> uint32_t
    os << YAML::Value << t.poolSizeCount;
    os << YAML::Key << "pPoolSizes";
    // pPoolSizes -> Field -> ConstDynamicArray(VkDescriptorPoolSize)
    if (t.poolSizeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorPoolSize");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.poolSizeCount); ++i) {
                os << t.pPoolSizes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorPool";
    // descriptorPool -> Field -> VkDescriptorPool
    os << YAML::Value << t.descriptorPool;
    os << YAML::Key << "descriptorSetCount";
    // descriptorSetCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorSetCount;
    os << YAML::Key << "pSetLayouts";
    // pSetLayouts -> Field -> ConstDynamicArray(VkDescriptorSetLayout)
    if (t.descriptorSetCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorSetLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorSetCount); ++i) {
                os << t.pSetLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetLayoutBinding &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "descriptorType";
    // descriptorType -> Field -> VkDescriptorType
    os << YAML::Value << t.descriptorType;
    os << YAML::Key << "descriptorCount";
    // descriptorCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorCount;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "pImmutableSamplers";
    // pImmutableSamplers -> Field -> ConstDynamicArray(VkSampler)
    if (t.descriptorCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSampler");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorCount); ++i) {
                os << t.pImmutableSamplers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetLayoutCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDescriptorSetLayoutCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "bindingCount";
    // bindingCount -> Field -> uint32_t
    os << YAML::Value << t.bindingCount;
    os << YAML::Key << "pBindings";
    // pBindings -> Field -> ConstDynamicArray(VkDescriptorSetLayoutBinding)
    if (t.bindingCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorSetLayoutBinding");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bindingCount); ++i) {
                os << t.pBindings[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkClearColorValue &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "float32";
    // float32 -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.float32[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "int32";
    // int32 -> Field -> FixedArray(int32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("int32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.int32[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "uint32";
    // uint32 -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.uint32[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrawIndexedIndirectCommand &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "indexCount";
    // indexCount -> Field -> uint32_t
    os << YAML::Value << t.indexCount;
    os << YAML::Key << "instanceCount";
    // instanceCount -> Field -> uint32_t
    os << YAML::Value << t.instanceCount;
    os << YAML::Key << "firstIndex";
    // firstIndex -> Field -> uint32_t
    os << YAML::Value << t.firstIndex;
    os << YAML::Key << "vertexOffset";
    // vertexOffset -> Field -> int32_t
    os << YAML::Value << t.vertexOffset;
    os << YAML::Key << "firstInstance";
    // firstInstance -> Field -> uint32_t
    os << YAML::Value << t.firstInstance;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrawIndirectCommand &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "vertexCount";
    // vertexCount -> Field -> uint32_t
    os << YAML::Value << t.vertexCount;
    os << YAML::Key << "instanceCount";
    // instanceCount -> Field -> uint32_t
    os << YAML::Value << t.instanceCount;
    os << YAML::Key << "firstVertex";
    // firstVertex -> Field -> uint32_t
    os << YAML::Value << t.firstVertex;
    os << YAML::Key << "firstInstance";
    // firstInstance -> Field -> uint32_t
    os << YAML::Value << t.firstInstance;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVertexInputBindingDescription &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "stride";
    // stride -> Field -> uint32_t
    os << YAML::Value << t.stride;
    os << YAML::Key << "inputRate";
    // inputRate -> Field -> VkVertexInputRate
    os << YAML::Value << t.inputRate;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVertexInputAttributeDescription &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "location";
    // location -> Field -> uint32_t
    os << YAML::Value << t.location;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineVertexInputStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineVertexInputStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "vertexBindingDescriptionCount";
    // vertexBindingDescriptionCount -> Field -> uint32_t
    os << YAML::Value << t.vertexBindingDescriptionCount;
    os << YAML::Key << "pVertexBindingDescriptions";
    // pVertexBindingDescriptions -> Field -> ConstDynamicArray(VkVertexInputBindingDescription)
    if (t.vertexBindingDescriptionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVertexInputBindingDescription");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.vertexBindingDescriptionCount); ++i) {
                os << t.pVertexBindingDescriptions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "vertexAttributeDescriptionCount";
    // vertexAttributeDescriptionCount -> Field -> uint32_t
    os << YAML::Value << t.vertexAttributeDescriptionCount;
    os << YAML::Key << "pVertexAttributeDescriptions";
    // pVertexAttributeDescriptions -> Field -> ConstDynamicArray(VkVertexInputAttributeDescription)
    if (t.vertexAttributeDescriptionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVertexInputAttributeDescription");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.vertexAttributeDescriptionCount); ++i) {
                os << t.pVertexAttributeDescriptions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineInputAssemblyStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineInputAssemblyStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "topology";
    // topology -> Field -> VkPrimitiveTopology
    os << YAML::Value << t.topology;
    os << YAML::Key << "primitiveRestartEnable";
    // primitiveRestartEnable -> Field -> VkBool32
    os << YAML::Value << t.primitiveRestartEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineTessellationStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineTessellationStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "patchControlPoints";
    // patchControlPoints -> Field -> uint32_t
    os << YAML::Value << t.patchControlPoints;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkViewport &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> float
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> float
    os << YAML::Value << t.y;
    os << YAML::Key << "width";
    // width -> Field -> float
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> float
    os << YAML::Value << t.height;
    os << YAML::Key << "minDepth";
    // minDepth -> Field -> float
    os << YAML::Value << t.minDepth;
    os << YAML::Key << "maxDepth";
    // maxDepth -> Field -> float
    os << YAML::Value << t.maxDepth;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineViewportStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "viewportCount";
    // viewportCount -> Field -> uint32_t
    os << YAML::Value << t.viewportCount;
    os << YAML::Key << "pViewports";
    // pViewports -> Field -> ConstDynamicArray(VkViewport)
    if (t.viewportCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkViewport");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewportCount); ++i) {
                os << t.pViewports[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "scissorCount";
    // scissorCount -> Field -> uint32_t
    os << YAML::Value << t.scissorCount;
    os << YAML::Key << "pScissors";
    // pScissors -> Field -> ConstDynamicArray(VkRect2D)
    if (t.scissorCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRect2D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.scissorCount); ++i) {
                os << t.pScissors[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineRasterizationStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "depthClampEnable";
    // depthClampEnable -> Field -> VkBool32
    os << YAML::Value << t.depthClampEnable;
    os << YAML::Key << "rasterizerDiscardEnable";
    // rasterizerDiscardEnable -> Field -> VkBool32
    os << YAML::Value << t.rasterizerDiscardEnable;
    os << YAML::Key << "polygonMode";
    // polygonMode -> Field -> VkPolygonMode
    os << YAML::Value << t.polygonMode;
    os << YAML::Key << "cullMode";
    // cullMode -> Field -> VkCullModeFlags
    os << YAML::Value << t.cullMode;
    os << YAML::Key << "frontFace";
    // frontFace -> Field -> VkFrontFace
    os << YAML::Value << t.frontFace;
    os << YAML::Key << "depthBiasEnable";
    // depthBiasEnable -> Field -> VkBool32
    os << YAML::Value << t.depthBiasEnable;
    os << YAML::Key << "depthBiasConstantFactor";
    // depthBiasConstantFactor -> Field -> float
    os << YAML::Value << t.depthBiasConstantFactor;
    os << YAML::Key << "depthBiasClamp";
    // depthBiasClamp -> Field -> float
    os << YAML::Value << t.depthBiasClamp;
    os << YAML::Key << "depthBiasSlopeFactor";
    // depthBiasSlopeFactor -> Field -> float
    os << YAML::Value << t.depthBiasSlopeFactor;
    os << YAML::Key << "lineWidth";
    // lineWidth -> Field -> float
    os << YAML::Value << t.lineWidth;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineMultisampleStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineMultisampleStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "rasterizationSamples";
    // rasterizationSamples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.rasterizationSamples;
    os << YAML::Key << "sampleShadingEnable";
    // sampleShadingEnable -> Field -> VkBool32
    os << YAML::Value << t.sampleShadingEnable;
    os << YAML::Key << "minSampleShading";
    // minSampleShading -> Field -> float
    os << YAML::Value << t.minSampleShading;
    os << YAML::Key << "pSampleMask";
    // pSampleMask -> Field -> ConstDynamicArray(VkSampleMask)
    if (((t.rasterizationSamples + 31) / 32) == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSampleMask");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(((t.rasterizationSamples + 31) / 32)); ++i) {
                os << t.pSampleMask[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "alphaToCoverageEnable";
    // alphaToCoverageEnable -> Field -> VkBool32
    os << YAML::Value << t.alphaToCoverageEnable;
    os << YAML::Key << "alphaToOneEnable";
    // alphaToOneEnable -> Field -> VkBool32
    os << YAML::Value << t.alphaToOneEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkStencilOpState &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "failOp";
    // failOp -> Field -> VkStencilOp
    os << YAML::Value << t.failOp;
    os << YAML::Key << "passOp";
    // passOp -> Field -> VkStencilOp
    os << YAML::Value << t.passOp;
    os << YAML::Key << "depthFailOp";
    // depthFailOp -> Field -> VkStencilOp
    os << YAML::Value << t.depthFailOp;
    os << YAML::Key << "compareOp";
    // compareOp -> Field -> VkCompareOp
    os << YAML::Value << t.compareOp;
    os << YAML::Key << "compareMask";
    // compareMask -> Field -> uint32_t
    os << YAML::Value << t.compareMask;
    os << YAML::Key << "writeMask";
    // writeMask -> Field -> uint32_t
    os << YAML::Value << t.writeMask;
    os << YAML::Key << "reference";
    // reference -> Field -> uint32_t
    os << YAML::Value << t.reference;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineDepthStencilStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineDepthStencilStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "depthTestEnable";
    // depthTestEnable -> Field -> VkBool32
    os << YAML::Value << t.depthTestEnable;
    os << YAML::Key << "depthWriteEnable";
    // depthWriteEnable -> Field -> VkBool32
    os << YAML::Value << t.depthWriteEnable;
    os << YAML::Key << "depthCompareOp";
    // depthCompareOp -> Field -> VkCompareOp
    os << YAML::Value << t.depthCompareOp;
    os << YAML::Key << "depthBoundsTestEnable";
    // depthBoundsTestEnable -> Field -> VkBool32
    os << YAML::Value << t.depthBoundsTestEnable;
    os << YAML::Key << "stencilTestEnable";
    // stencilTestEnable -> Field -> VkBool32
    os << YAML::Value << t.stencilTestEnable;
    os << YAML::Key << "front";
    // front -> Field -> VkStencilOpState
    os << YAML::Value << t.front;
    os << YAML::Key << "back";
    // back -> Field -> VkStencilOpState
    os << YAML::Value << t.back;
    os << YAML::Key << "minDepthBounds";
    // minDepthBounds -> Field -> float
    os << YAML::Value << t.minDepthBounds;
    os << YAML::Key << "maxDepthBounds";
    // maxDepthBounds -> Field -> float
    os << YAML::Value << t.maxDepthBounds;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineColorBlendAttachmentState &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "blendEnable";
    // blendEnable -> Field -> VkBool32
    os << YAML::Value << t.blendEnable;
    os << YAML::Key << "srcColorBlendFactor";
    // srcColorBlendFactor -> Field -> VkBlendFactor
    os << YAML::Value << t.srcColorBlendFactor;
    os << YAML::Key << "dstColorBlendFactor";
    // dstColorBlendFactor -> Field -> VkBlendFactor
    os << YAML::Value << t.dstColorBlendFactor;
    os << YAML::Key << "colorBlendOp";
    // colorBlendOp -> Field -> VkBlendOp
    os << YAML::Value << t.colorBlendOp;
    os << YAML::Key << "srcAlphaBlendFactor";
    // srcAlphaBlendFactor -> Field -> VkBlendFactor
    os << YAML::Value << t.srcAlphaBlendFactor;
    os << YAML::Key << "dstAlphaBlendFactor";
    // dstAlphaBlendFactor -> Field -> VkBlendFactor
    os << YAML::Value << t.dstAlphaBlendFactor;
    os << YAML::Key << "alphaBlendOp";
    // alphaBlendOp -> Field -> VkBlendOp
    os << YAML::Value << t.alphaBlendOp;
    os << YAML::Key << "colorWriteMask";
    // colorWriteMask -> Field -> VkColorComponentFlags
    os << YAML::Value << t.colorWriteMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineColorBlendStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineColorBlendStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "logicOpEnable";
    // logicOpEnable -> Field -> VkBool32
    os << YAML::Value << t.logicOpEnable;
    os << YAML::Key << "logicOp";
    // logicOp -> Field -> VkLogicOp
    os << YAML::Value << t.logicOp;
    os << YAML::Key << "attachmentCount";
    // attachmentCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentCount;
    os << YAML::Key << "pAttachments";
    // pAttachments -> Field -> ConstDynamicArray(VkPipelineColorBlendAttachmentState)
    if (t.attachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineColorBlendAttachmentState");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentCount); ++i) {
                os << t.pAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "blendConstants";
    // blendConstants -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.blendConstants[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineDynamicStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineDynamicStateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "dynamicStateCount";
    // dynamicStateCount -> Field -> uint32_t
    os << YAML::Value << t.dynamicStateCount;
    os << YAML::Key << "pDynamicStates";
    // pDynamicStates -> Field -> ConstDynamicArray(VkDynamicState)
    if (t.dynamicStateCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDynamicState");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.dynamicStateCount); ++i) {
                os << t.pDynamicStates[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGraphicsPipelineCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "stageCount";
    // stageCount -> Field -> uint32_t
    os << YAML::Value << t.stageCount;
    os << YAML::Key << "pStages";
    // pStages -> Field -> ConstDynamicArray(VkPipelineShaderStageCreateInfo)
    if (t.stageCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineShaderStageCreateInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.stageCount); ++i) {
                os << t.pStages[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pVertexInputState";
    // pointer
    if (t.pVertexInputState != nullptr) {
        os << YAML::Value << *t.pVertexInputState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pInputAssemblyState";
    // pointer
    if (t.pInputAssemblyState != nullptr) {
        os << YAML::Value << *t.pInputAssemblyState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pTessellationState";
    // pointer
    if (t.pTessellationState != nullptr) {
        os << YAML::Value << *t.pTessellationState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pViewportState";
    // pointer
    if (t.pViewportState != nullptr) {
        os << YAML::Value << *t.pViewportState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pRasterizationState";
    // pointer
    if (t.pRasterizationState != nullptr) {
        os << YAML::Value << *t.pRasterizationState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pMultisampleState";
    // pointer
    if (t.pMultisampleState != nullptr) {
        os << YAML::Value << *t.pMultisampleState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pDepthStencilState";
    // pointer
    if (t.pDepthStencilState != nullptr) {
        os << YAML::Value << *t.pDepthStencilState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pColorBlendState";
    // pointer
    if (t.pColorBlendState != nullptr) {
        os << YAML::Value << *t.pColorBlendState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pDynamicState";
    // pointer
    if (t.pDynamicState != nullptr) {
        os << YAML::Value << *t.pDynamicState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "renderPass";
    // renderPass -> Field -> VkRenderPass
    os << YAML::Value << t.renderPass;
    os << YAML::Key << "subpass";
    // subpass -> Field -> uint32_t
    os << YAML::Value << t.subpass;
    os << YAML::Key << "basePipelineHandle";
    // basePipelineHandle -> Field -> VkPipeline
    os << YAML::Value << t.basePipelineHandle;
    os << YAML::Key << "basePipelineIndex";
    // basePipelineIndex -> Field -> int32_t
    os << YAML::Value << t.basePipelineIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentDescription &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAttachmentDescriptionFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "samples";
    // samples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.samples;
    os << YAML::Key << "loadOp";
    // loadOp -> Field -> VkAttachmentLoadOp
    os << YAML::Value << t.loadOp;
    os << YAML::Key << "storeOp";
    // storeOp -> Field -> VkAttachmentStoreOp
    os << YAML::Value << t.storeOp;
    os << YAML::Key << "stencilLoadOp";
    // stencilLoadOp -> Field -> VkAttachmentLoadOp
    os << YAML::Value << t.stencilLoadOp;
    os << YAML::Key << "stencilStoreOp";
    // stencilStoreOp -> Field -> VkAttachmentStoreOp
    os << YAML::Value << t.stencilStoreOp;
    os << YAML::Key << "initialLayout";
    // initialLayout -> Field -> VkImageLayout
    os << YAML::Value << t.initialLayout;
    os << YAML::Key << "finalLayout";
    // finalLayout -> Field -> VkImageLayout
    os << YAML::Value << t.finalLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentReference &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "attachment";
    // attachment -> Field -> uint32_t
    os << YAML::Value << t.attachment;
    os << YAML::Key << "layout";
    // layout -> Field -> VkImageLayout
    os << YAML::Value << t.layout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFramebufferCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkFramebufferCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "renderPass";
    // renderPass -> Field -> VkRenderPass
    os << YAML::Value << t.renderPass;
    os << YAML::Key << "attachmentCount";
    // attachmentCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentCount;
    os << YAML::Key << "pAttachments";
    // pAttachments -> Field -> ConstDynamicArray(VkImageView)
    if (t.attachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageView");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentCount); ++i) {
                os << t.pAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "width";
    // width -> Field -> uint32_t
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> uint32_t
    os << YAML::Value << t.height;
    os << YAML::Key << "layers";
    // layers -> Field -> uint32_t
    os << YAML::Value << t.layers;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassDescription &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSubpassDescriptionFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "inputAttachmentCount";
    // inputAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.inputAttachmentCount;
    os << YAML::Key << "pInputAttachments";
    // pInputAttachments -> Field -> ConstDynamicArray(VkAttachmentReference)
    if (t.inputAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.inputAttachmentCount); ++i) {
                os << t.pInputAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachments";
    // pColorAttachments -> Field -> ConstDynamicArray(VkAttachmentReference)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pResolveAttachments";
    // pResolveAttachments -> Field -> ConstDynamicArray(VkAttachmentReference)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pResolveAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pDepthStencilAttachment";
    // pointer
    if (t.pDepthStencilAttachment != nullptr) {
        os << YAML::Value << *t.pDepthStencilAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "preserveAttachmentCount";
    // preserveAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.preserveAttachmentCount;
    os << YAML::Key << "pPreserveAttachments";
    // pPreserveAttachments -> Field -> ConstDynamicArray(uint32_t)
    if (t.preserveAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.preserveAttachmentCount); ++i) {
                os << t.pPreserveAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassDependency &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcSubpass";
    // srcSubpass -> Field -> uint32_t
    os << YAML::Value << t.srcSubpass;
    os << YAML::Key << "dstSubpass";
    // dstSubpass -> Field -> uint32_t
    os << YAML::Value << t.dstSubpass;
    os << YAML::Key << "srcStageMask";
    // srcStageMask -> Field -> VkPipelineStageFlags
    os << YAML::Value << t.srcStageMask;
    os << YAML::Key << "dstStageMask";
    // dstStageMask -> Field -> VkPipelineStageFlags
    os << YAML::Value << t.dstStageMask;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "dependencyFlags";
    // dependencyFlags -> Field -> VkDependencyFlags
    os << YAML::Value << t.dependencyFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkRenderPassCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "attachmentCount";
    // attachmentCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentCount;
    os << YAML::Key << "pAttachments";
    // pAttachments -> Field -> ConstDynamicArray(VkAttachmentDescription)
    if (t.attachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentDescription");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentCount); ++i) {
                os << t.pAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "subpassCount";
    // subpassCount -> Field -> uint32_t
    os << YAML::Value << t.subpassCount;
    os << YAML::Key << "pSubpasses";
    // pSubpasses -> Field -> ConstDynamicArray(VkSubpassDescription)
    if (t.subpassCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubpassDescription");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.subpassCount); ++i) {
                os << t.pSubpasses[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dependencyCount";
    // dependencyCount -> Field -> uint32_t
    os << YAML::Value << t.dependencyCount;
    os << YAML::Key << "pDependencies";
    // pDependencies -> Field -> ConstDynamicArray(VkSubpassDependency)
    if (t.dependencyCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubpassDependency");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.dependencyCount); ++i) {
                os << t.pDependencies[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkClearDepthStencilValue &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "depth";
    // depth -> Field -> float
    os << YAML::Value << t.depth;
    os << YAML::Key << "stencil";
    // stencil -> Field -> uint32_t
    os << YAML::Value << t.stencil;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkClearValue &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "color";
    // color -> Field -> VkClearColorValue
    os << YAML::Value << t.color;
    os << YAML::Key << "depthStencil";
    // depthStencil -> Field -> VkClearDepthStencilValue
    os << YAML::Value << t.depthStencil;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkClearAttachment &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::Key << "colorAttachment";
    // colorAttachment -> Field -> uint32_t
    os << YAML::Value << t.colorAttachment;
    os << YAML::Key << "clearValue";
    // clearValue -> Field -> VkClearValue
    os << YAML::Value << t.clearValue;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkClearRect &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "rect";
    // rect -> Field -> VkRect2D
    os << YAML::Value << t.rect;
    os << YAML::Key << "baseArrayLayer";
    // baseArrayLayer -> Field -> uint32_t
    os << YAML::Value << t.baseArrayLayer;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageBlit &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffsets";
    // srcOffsets -> Field -> FixedArray(VkOffset3D)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkOffset3D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.srcOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffsets";
    // dstOffsets -> Field -> FixedArray(VkOffset3D)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkOffset3D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.dstOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageResolve &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkOffset3D
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkOffset3D
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "renderPass";
    // renderPass -> Field -> VkRenderPass
    os << YAML::Value << t.renderPass;
    os << YAML::Key << "framebuffer";
    // framebuffer -> Field -> VkFramebuffer
    os << YAML::Value << t.framebuffer;
    os << YAML::Key << "renderArea";
    // renderArea -> Field -> VkRect2D
    os << YAML::Value << t.renderArea;
    os << YAML::Key << "clearValueCount";
    // clearValueCount -> Field -> uint32_t
    os << YAML::Value << t.clearValueCount;
    os << YAML::Key << "pClearValues";
    // pClearValues -> Field -> ConstDynamicArray(VkClearValue)
    if (t.clearValueCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkClearValue");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.clearValueCount); ++i) {
                os << t.pClearValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindBufferMemoryInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindImageMemoryInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryDedicatedRequirements &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "prefersDedicatedAllocation";
    // prefersDedicatedAllocation -> Field -> VkBool32
    os << YAML::Value << t.prefersDedicatedAllocation;
    os << YAML::Key << "requiresDedicatedAllocation";
    // requiresDedicatedAllocation -> Field -> VkBool32
    os << YAML::Value << t.requiresDedicatedAllocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryDedicatedAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryAllocateFlagsInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMemoryAllocateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "deviceMask";
    // deviceMask -> Field -> uint32_t
    os << YAML::Value << t.deviceMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupCommandBufferBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceMask";
    // deviceMask -> Field -> uint32_t
    os << YAML::Value << t.deviceMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreCount";
    // waitSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreCount;
    os << YAML::Key << "pWaitSemaphoreDeviceIndices";
    // pWaitSemaphoreDeviceIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.waitSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreCount); ++i) {
                os << t.pWaitSemaphoreDeviceIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "commandBufferCount";
    // commandBufferCount -> Field -> uint32_t
    os << YAML::Value << t.commandBufferCount;
    os << YAML::Key << "pCommandBufferDeviceMasks";
    // pCommandBufferDeviceMasks -> Field -> ConstDynamicArray(uint32_t)
    if (t.commandBufferCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.commandBufferCount); ++i) {
                os << t.pCommandBufferDeviceMasks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreCount";
    // signalSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreCount;
    os << YAML::Key << "pSignalSemaphoreDeviceIndices";
    // pSignalSemaphoreDeviceIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.signalSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreCount); ++i) {
                os << t.pSignalSemaphoreDeviceIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupBindSparseInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "resourceDeviceIndex";
    // resourceDeviceIndex -> Field -> uint32_t
    os << YAML::Value << t.resourceDeviceIndex;
    os << YAML::Key << "memoryDeviceIndex";
    // memoryDeviceIndex -> Field -> uint32_t
    os << YAML::Value << t.memoryDeviceIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindBufferMemoryDeviceGroupInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceIndexCount";
    // deviceIndexCount -> Field -> uint32_t
    os << YAML::Value << t.deviceIndexCount;
    os << YAML::Key << "pDeviceIndices";
    // pDeviceIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.deviceIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.deviceIndexCount); ++i) {
                os << t.pDeviceIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindImageMemoryDeviceGroupInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceIndexCount";
    // deviceIndexCount -> Field -> uint32_t
    os << YAML::Value << t.deviceIndexCount;
    os << YAML::Key << "pDeviceIndices";
    // pDeviceIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.deviceIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.deviceIndexCount); ++i) {
                os << t.pDeviceIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "splitInstanceBindRegionCount";
    // splitInstanceBindRegionCount -> Field -> uint32_t
    os << YAML::Value << t.splitInstanceBindRegionCount;
    os << YAML::Key << "pSplitInstanceBindRegions";
    // pSplitInstanceBindRegions -> Field -> ConstDynamicArray(VkRect2D)
    if (t.splitInstanceBindRegionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRect2D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.splitInstanceBindRegionCount); ++i) {
                os << t.pSplitInstanceBindRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceGroupProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "physicalDeviceCount";
    // physicalDeviceCount -> Field -> uint32_t
    os << YAML::Value << t.physicalDeviceCount;
    os << YAML::Key << "physicalDevices";
    // physicalDevices -> Field -> DynamicArray(VkPhysicalDevice)
    if (t.physicalDeviceCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPhysicalDevice");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.physicalDeviceCount); ++i) {
                os << t.physicalDevices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "subsetAllocation";
    // subsetAllocation -> Field -> VkBool32
    os << YAML::Value << t.subsetAllocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupDeviceCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "physicalDeviceCount";
    // physicalDeviceCount -> Field -> uint32_t
    os << YAML::Value << t.physicalDeviceCount;
    os << YAML::Key << "pPhysicalDevices";
    // pPhysicalDevices -> Field -> ConstDynamicArray(VkPhysicalDevice)
    if (t.physicalDeviceCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPhysicalDevice");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.physicalDeviceCount); ++i) {
                os << t.pPhysicalDevices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferMemoryRequirementsInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageMemoryRequirementsInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSparseMemoryRequirementsInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryRequirements2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryRequirements";
    // memoryRequirements -> Field -> VkMemoryRequirements
    os << YAML::Value << t.memoryRequirements;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageMemoryRequirements2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryRequirements";
    // memoryRequirements -> Field -> VkSparseImageMemoryRequirements
    os << YAML::Value << t.memoryRequirements;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFeatures2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "features";
    // features -> Field -> VkPhysicalDeviceFeatures
    os << YAML::Value << t.features;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "properties";
    // properties -> Field -> VkPhysicalDeviceProperties
    os << YAML::Value << t.properties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFormatProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "formatProperties";
    // formatProperties -> Field -> VkFormatProperties
    os << YAML::Value << t.formatProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageFormatProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageFormatProperties";
    // imageFormatProperties -> Field -> VkImageFormatProperties
    os << YAML::Value << t.imageFormatProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImageFormatInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "type";
    // type -> Field -> VkImageType
    os << YAML::Value << t.type;
    os << YAML::Key << "tiling";
    // tiling -> Field -> VkImageTiling
    os << YAML::Value << t.tiling;
    os << YAML::Key << "usage";
    // usage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImageCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queueFamilyProperties";
    // queueFamilyProperties -> Field -> VkQueueFamilyProperties
    os << YAML::Value << t.queueFamilyProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMemoryProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryProperties";
    // memoryProperties -> Field -> VkPhysicalDeviceMemoryProperties
    os << YAML::Value << t.memoryProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSparseImageFormatProperties2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "properties";
    // properties -> Field -> VkSparseImageFormatProperties
    os << YAML::Value << t.properties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSparseImageFormatInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "type";
    // type -> Field -> VkImageType
    os << YAML::Value << t.type;
    os << YAML::Key << "samples";
    // samples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.samples;
    os << YAML::Key << "usage";
    // usage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "tiling";
    // tiling -> Field -> VkImageTiling
    os << YAML::Value << t.tiling;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewUsageCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "usage";
    // usage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProtectedMemoryFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "protectedMemory";
    // protectedMemory -> Field -> VkBool32
    os << YAML::Value << t.protectedMemory;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProtectedMemoryProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "protectedNoFault";
    // protectedNoFault -> Field -> VkBool32
    os << YAML::Value << t.protectedNoFault;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceQueueInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceQueueCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "queueFamilyIndex";
    // queueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndex;
    os << YAML::Key << "queueIndex";
    // queueIndex -> Field -> uint32_t
    os << YAML::Value << t.queueIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkProtectedSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "protectedSubmit";
    // protectedSubmit -> Field -> VkBool32
    os << YAML::Value << t.protectedSubmit;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindImagePlaneMemoryInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "planeAspect";
    // planeAspect -> Field -> VkImageAspectFlagBits
    os << YAML::Value << t.planeAspect;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImagePlaneMemoryRequirementsInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "planeAspect";
    // planeAspect -> Field -> VkImageAspectFlagBits
    os << YAML::Value << t.planeAspect;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalMemoryProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "externalMemoryFeatures";
    // externalMemoryFeatures -> Field -> VkExternalMemoryFeatureFlags
    os << YAML::Value << t.externalMemoryFeatures;
    os << YAML::Key << "exportFromImportedHandleTypes";
    // exportFromImportedHandleTypes -> Field -> VkExternalMemoryHandleTypeFlags
    os << YAML::Value << t.exportFromImportedHandleTypes;
    os << YAML::Key << "compatibleHandleTypes";
    // compatibleHandleTypes -> Field -> VkExternalMemoryHandleTypeFlags
    os << YAML::Value << t.compatibleHandleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExternalImageFormatInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalImageFormatProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "externalMemoryProperties";
    // externalMemoryProperties -> Field -> VkExternalMemoryProperties
    os << YAML::Value << t.externalMemoryProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExternalBufferInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkBufferCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "usage";
    // usage -> Field -> VkBufferUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalBufferProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "externalMemoryProperties";
    // externalMemoryProperties -> Field -> VkExternalMemoryProperties
    os << YAML::Value << t.externalMemoryProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceIDProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceUUID";
    // deviceUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.deviceUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "driverUUID";
    // driverUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.driverUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "deviceLUID";
    // deviceLUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_LUID_SIZE); ++i) {
                os << t.deviceLUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "deviceNodeMask";
    // deviceNodeMask -> Field -> uint32_t
    os << YAML::Value << t.deviceNodeMask;
    os << YAML::Key << "deviceLUIDValid";
    // deviceLUIDValid -> Field -> VkBool32
    os << YAML::Value << t.deviceLUIDValid;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalMemoryImageCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalMemoryHandleTypeFlags
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalMemoryBufferCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalMemoryHandleTypeFlags
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMemoryAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalMemoryHandleTypeFlags
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExternalFenceInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalFenceHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalFenceProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "exportFromImportedHandleTypes";
    // exportFromImportedHandleTypes -> Field -> VkExternalFenceHandleTypeFlags
    os << YAML::Value << t.exportFromImportedHandleTypes;
    os << YAML::Key << "compatibleHandleTypes";
    // compatibleHandleTypes -> Field -> VkExternalFenceHandleTypeFlags
    os << YAML::Value << t.compatibleHandleTypes;
    os << YAML::Key << "externalFenceFeatures";
    // externalFenceFeatures -> Field -> VkExternalFenceFeatureFlags
    os << YAML::Value << t.externalFenceFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportFenceCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalFenceHandleTypeFlags
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportSemaphoreCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalSemaphoreHandleTypeFlags
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExternalSemaphoreInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalSemaphoreProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "exportFromImportedHandleTypes";
    // exportFromImportedHandleTypes -> Field -> VkExternalSemaphoreHandleTypeFlags
    os << YAML::Value << t.exportFromImportedHandleTypes;
    os << YAML::Key << "compatibleHandleTypes";
    // compatibleHandleTypes -> Field -> VkExternalSemaphoreHandleTypeFlags
    os << YAML::Value << t.compatibleHandleTypes;
    os << YAML::Key << "externalSemaphoreFeatures";
    // externalSemaphoreFeatures -> Field -> VkExternalSemaphoreFeatureFlags
    os << YAML::Value << t.externalSemaphoreFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSubgroupProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subgroupSize";
    // subgroupSize -> Field -> uint32_t
    os << YAML::Value << t.subgroupSize;
    os << YAML::Key << "supportedStages";
    // supportedStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.supportedStages;
    os << YAML::Key << "supportedOperations";
    // supportedOperations -> Field -> VkSubgroupFeatureFlags
    os << YAML::Value << t.supportedOperations;
    os << YAML::Key << "quadOperationsInAllStages";
    // quadOperationsInAllStages -> Field -> VkBool32
    os << YAML::Value << t.quadOperationsInAllStages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevice16BitStorageFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "storageBuffer16BitAccess";
    // storageBuffer16BitAccess -> Field -> VkBool32
    os << YAML::Value << t.storageBuffer16BitAccess;
    os << YAML::Key << "uniformAndStorageBuffer16BitAccess";
    // uniformAndStorageBuffer16BitAccess -> Field -> VkBool32
    os << YAML::Value << t.uniformAndStorageBuffer16BitAccess;
    os << YAML::Key << "storagePushConstant16";
    // storagePushConstant16 -> Field -> VkBool32
    os << YAML::Value << t.storagePushConstant16;
    os << YAML::Key << "storageInputOutput16";
    // storageInputOutput16 -> Field -> VkBool32
    os << YAML::Value << t.storageInputOutput16;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVariablePointersFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "variablePointersStorageBuffer";
    // variablePointersStorageBuffer -> Field -> VkBool32
    os << YAML::Value << t.variablePointersStorageBuffer;
    os << YAML::Key << "variablePointers";
    // variablePointers -> Field -> VkBool32
    os << YAML::Value << t.variablePointers;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorUpdateTemplateEntry &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "dstBinding";
    // dstBinding -> Field -> uint32_t
    os << YAML::Value << t.dstBinding;
    os << YAML::Key << "dstArrayElement";
    // dstArrayElement -> Field -> uint32_t
    os << YAML::Value << t.dstArrayElement;
    os << YAML::Key << "descriptorCount";
    // descriptorCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorCount;
    os << YAML::Key << "descriptorType";
    // descriptorType -> Field -> VkDescriptorType
    os << YAML::Value << t.descriptorType;
    os << YAML::Key << "offset";
    // offset -> Field -> size_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "stride";
    // stride -> Field -> size_t
    os << YAML::Value << t.stride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorUpdateTemplateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDescriptorUpdateTemplateCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "descriptorUpdateEntryCount";
    // descriptorUpdateEntryCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorUpdateEntryCount;
    os << YAML::Key << "pDescriptorUpdateEntries";
    // pDescriptorUpdateEntries -> Field -> ConstDynamicArray(VkDescriptorUpdateTemplateEntry)
    if (t.descriptorUpdateEntryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorUpdateTemplateEntry");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorUpdateEntryCount); ++i) {
                os << t.pDescriptorUpdateEntries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "templateType";
    // templateType -> Field -> VkDescriptorUpdateTemplateType
    os << YAML::Value << t.templateType;
    os << YAML::Key << "descriptorSetLayout";
    // descriptorSetLayout -> Field -> VkDescriptorSetLayout
    os << YAML::Value << t.descriptorSetLayout;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "pipelineLayout";
    // pipelineLayout -> Field -> VkPipelineLayout
    os << YAML::Value << t.pipelineLayout;
    os << YAML::Key << "set";
    // set -> Field -> uint32_t
    os << YAML::Value << t.set;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance3Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxPerSetDescriptors";
    // maxPerSetDescriptors -> Field -> uint32_t
    os << YAML::Value << t.maxPerSetDescriptors;
    os << YAML::Key << "maxMemoryAllocationSize";
    // maxMemoryAllocationSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxMemoryAllocationSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetLayoutSupport &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supported";
    // supported -> Field -> VkBool32
    os << YAML::Value << t.supported;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerYcbcrConversionCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "ycbcrModel";
    // ycbcrModel -> Field -> VkSamplerYcbcrModelConversion
    os << YAML::Value << t.ycbcrModel;
    os << YAML::Key << "ycbcrRange";
    // ycbcrRange -> Field -> VkSamplerYcbcrRange
    os << YAML::Value << t.ycbcrRange;
    os << YAML::Key << "components";
    // components -> Field -> VkComponentMapping
    os << YAML::Value << t.components;
    os << YAML::Key << "xChromaOffset";
    // xChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.xChromaOffset;
    os << YAML::Key << "yChromaOffset";
    // yChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.yChromaOffset;
    os << YAML::Key << "chromaFilter";
    // chromaFilter -> Field -> VkFilter
    os << YAML::Value << t.chromaFilter;
    os << YAML::Key << "forceExplicitReconstruction";
    // forceExplicitReconstruction -> Field -> VkBool32
    os << YAML::Value << t.forceExplicitReconstruction;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerYcbcrConversionInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "conversion";
    // conversion -> Field -> VkSamplerYcbcrConversion
    os << YAML::Value << t.conversion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSamplerYcbcrConversionFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "samplerYcbcrConversion";
    // samplerYcbcrConversion -> Field -> VkBool32
    os << YAML::Value << t.samplerYcbcrConversion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerYcbcrConversionImageFormatProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "combinedImageSamplerDescriptorCount";
    // combinedImageSamplerDescriptorCount -> Field -> uint32_t
    os << YAML::Value << t.combinedImageSamplerDescriptorCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupRenderPassBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceMask";
    // deviceMask -> Field -> uint32_t
    os << YAML::Value << t.deviceMask;
    os << YAML::Key << "deviceRenderAreaCount";
    // deviceRenderAreaCount -> Field -> uint32_t
    os << YAML::Value << t.deviceRenderAreaCount;
    os << YAML::Key << "pDeviceRenderAreas";
    // pDeviceRenderAreas -> Field -> ConstDynamicArray(VkRect2D)
    if (t.deviceRenderAreaCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRect2D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.deviceRenderAreaCount); ++i) {
                os << t.pDeviceRenderAreas[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePointClippingProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pointClippingBehavior";
    // pointClippingBehavior -> Field -> VkPointClippingBehavior
    os << YAML::Value << t.pointClippingBehavior;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkInputAttachmentAspectReference &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "subpass";
    // subpass -> Field -> uint32_t
    os << YAML::Value << t.subpass;
    os << YAML::Key << "inputAttachmentIndex";
    // inputAttachmentIndex -> Field -> uint32_t
    os << YAML::Value << t.inputAttachmentIndex;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassInputAttachmentAspectCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "aspectReferenceCount";
    // aspectReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.aspectReferenceCount;
    os << YAML::Key << "pAspectReferences";
    // pAspectReferences -> Field -> ConstDynamicArray(VkInputAttachmentAspectReference)
    if (t.aspectReferenceCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkInputAttachmentAspectReference");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.aspectReferenceCount); ++i) {
                os << t.pAspectReferences[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineTessellationDomainOriginStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "domainOrigin";
    // domainOrigin -> Field -> VkTessellationDomainOrigin
    os << YAML::Value << t.domainOrigin;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassMultiviewCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subpassCount";
    // subpassCount -> Field -> uint32_t
    os << YAML::Value << t.subpassCount;
    os << YAML::Key << "pViewMasks";
    // pViewMasks -> Field -> ConstDynamicArray(uint32_t)
    if (t.subpassCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.subpassCount); ++i) {
                os << t.pViewMasks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dependencyCount";
    // dependencyCount -> Field -> uint32_t
    os << YAML::Value << t.dependencyCount;
    os << YAML::Key << "pViewOffsets";
    // pViewOffsets -> Field -> ConstDynamicArray(int32_t)
    if (t.dependencyCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("int32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.dependencyCount); ++i) {
                os << t.pViewOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "correlationMaskCount";
    // correlationMaskCount -> Field -> uint32_t
    os << YAML::Value << t.correlationMaskCount;
    os << YAML::Key << "pCorrelationMasks";
    // pCorrelationMasks -> Field -> ConstDynamicArray(uint32_t)
    if (t.correlationMaskCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.correlationMaskCount); ++i) {
                os << t.pCorrelationMasks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMultiviewFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "multiview";
    // multiview -> Field -> VkBool32
    os << YAML::Value << t.multiview;
    os << YAML::Key << "multiviewGeometryShader";
    // multiviewGeometryShader -> Field -> VkBool32
    os << YAML::Value << t.multiviewGeometryShader;
    os << YAML::Key << "multiviewTessellationShader";
    // multiviewTessellationShader -> Field -> VkBool32
    os << YAML::Value << t.multiviewTessellationShader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMultiviewProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxMultiviewViewCount";
    // maxMultiviewViewCount -> Field -> uint32_t
    os << YAML::Value << t.maxMultiviewViewCount;
    os << YAML::Key << "maxMultiviewInstanceIndex";
    // maxMultiviewInstanceIndex -> Field -> uint32_t
    os << YAML::Value << t.maxMultiviewInstanceIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderDrawParametersFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderDrawParameters";
    // shaderDrawParameters -> Field -> VkBool32
    os << YAML::Value << t.shaderDrawParameters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan11Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "storageBuffer16BitAccess";
    // storageBuffer16BitAccess -> Field -> VkBool32
    os << YAML::Value << t.storageBuffer16BitAccess;
    os << YAML::Key << "uniformAndStorageBuffer16BitAccess";
    // uniformAndStorageBuffer16BitAccess -> Field -> VkBool32
    os << YAML::Value << t.uniformAndStorageBuffer16BitAccess;
    os << YAML::Key << "storagePushConstant16";
    // storagePushConstant16 -> Field -> VkBool32
    os << YAML::Value << t.storagePushConstant16;
    os << YAML::Key << "storageInputOutput16";
    // storageInputOutput16 -> Field -> VkBool32
    os << YAML::Value << t.storageInputOutput16;
    os << YAML::Key << "multiview";
    // multiview -> Field -> VkBool32
    os << YAML::Value << t.multiview;
    os << YAML::Key << "multiviewGeometryShader";
    // multiviewGeometryShader -> Field -> VkBool32
    os << YAML::Value << t.multiviewGeometryShader;
    os << YAML::Key << "multiviewTessellationShader";
    // multiviewTessellationShader -> Field -> VkBool32
    os << YAML::Value << t.multiviewTessellationShader;
    os << YAML::Key << "variablePointersStorageBuffer";
    // variablePointersStorageBuffer -> Field -> VkBool32
    os << YAML::Value << t.variablePointersStorageBuffer;
    os << YAML::Key << "variablePointers";
    // variablePointers -> Field -> VkBool32
    os << YAML::Value << t.variablePointers;
    os << YAML::Key << "protectedMemory";
    // protectedMemory -> Field -> VkBool32
    os << YAML::Value << t.protectedMemory;
    os << YAML::Key << "samplerYcbcrConversion";
    // samplerYcbcrConversion -> Field -> VkBool32
    os << YAML::Value << t.samplerYcbcrConversion;
    os << YAML::Key << "shaderDrawParameters";
    // shaderDrawParameters -> Field -> VkBool32
    os << YAML::Value << t.shaderDrawParameters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan11Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceUUID";
    // deviceUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.deviceUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "driverUUID";
    // driverUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.driverUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "deviceLUID";
    // deviceLUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_LUID_SIZE); ++i) {
                os << t.deviceLUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "deviceNodeMask";
    // deviceNodeMask -> Field -> uint32_t
    os << YAML::Value << t.deviceNodeMask;
    os << YAML::Key << "deviceLUIDValid";
    // deviceLUIDValid -> Field -> VkBool32
    os << YAML::Value << t.deviceLUIDValid;
    os << YAML::Key << "subgroupSize";
    // subgroupSize -> Field -> uint32_t
    os << YAML::Value << t.subgroupSize;
    os << YAML::Key << "subgroupSupportedStages";
    // subgroupSupportedStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.subgroupSupportedStages;
    os << YAML::Key << "subgroupSupportedOperations";
    // subgroupSupportedOperations -> Field -> VkSubgroupFeatureFlags
    os << YAML::Value << t.subgroupSupportedOperations;
    os << YAML::Key << "subgroupQuadOperationsInAllStages";
    // subgroupQuadOperationsInAllStages -> Field -> VkBool32
    os << YAML::Value << t.subgroupQuadOperationsInAllStages;
    os << YAML::Key << "pointClippingBehavior";
    // pointClippingBehavior -> Field -> VkPointClippingBehavior
    os << YAML::Value << t.pointClippingBehavior;
    os << YAML::Key << "maxMultiviewViewCount";
    // maxMultiviewViewCount -> Field -> uint32_t
    os << YAML::Value << t.maxMultiviewViewCount;
    os << YAML::Key << "maxMultiviewInstanceIndex";
    // maxMultiviewInstanceIndex -> Field -> uint32_t
    os << YAML::Value << t.maxMultiviewInstanceIndex;
    os << YAML::Key << "protectedNoFault";
    // protectedNoFault -> Field -> VkBool32
    os << YAML::Value << t.protectedNoFault;
    os << YAML::Key << "maxPerSetDescriptors";
    // maxPerSetDescriptors -> Field -> uint32_t
    os << YAML::Value << t.maxPerSetDescriptors;
    os << YAML::Key << "maxMemoryAllocationSize";
    // maxMemoryAllocationSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxMemoryAllocationSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan12Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "samplerMirrorClampToEdge";
    // samplerMirrorClampToEdge -> Field -> VkBool32
    os << YAML::Value << t.samplerMirrorClampToEdge;
    os << YAML::Key << "drawIndirectCount";
    // drawIndirectCount -> Field -> VkBool32
    os << YAML::Value << t.drawIndirectCount;
    os << YAML::Key << "storageBuffer8BitAccess";
    // storageBuffer8BitAccess -> Field -> VkBool32
    os << YAML::Value << t.storageBuffer8BitAccess;
    os << YAML::Key << "uniformAndStorageBuffer8BitAccess";
    // uniformAndStorageBuffer8BitAccess -> Field -> VkBool32
    os << YAML::Value << t.uniformAndStorageBuffer8BitAccess;
    os << YAML::Key << "storagePushConstant8";
    // storagePushConstant8 -> Field -> VkBool32
    os << YAML::Value << t.storagePushConstant8;
    os << YAML::Key << "shaderBufferInt64Atomics";
    // shaderBufferInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferInt64Atomics;
    os << YAML::Key << "shaderSharedInt64Atomics";
    // shaderSharedInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedInt64Atomics;
    os << YAML::Key << "shaderFloat16";
    // shaderFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderFloat16;
    os << YAML::Key << "shaderInt8";
    // shaderInt8 -> Field -> VkBool32
    os << YAML::Value << t.shaderInt8;
    os << YAML::Key << "descriptorIndexing";
    // descriptorIndexing -> Field -> VkBool32
    os << YAML::Value << t.descriptorIndexing;
    os << YAML::Key << "shaderInputAttachmentArrayDynamicIndexing";
    // shaderInputAttachmentArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayDynamicIndexing;
    os << YAML::Key << "shaderUniformTexelBufferArrayDynamicIndexing";
    // shaderUniformTexelBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformTexelBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderStorageTexelBufferArrayDynamicIndexing";
    // shaderStorageTexelBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageTexelBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderUniformBufferArrayNonUniformIndexing";
    // shaderUniformBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderSampledImageArrayNonUniformIndexing";
    // shaderSampledImageArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderSampledImageArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageBufferArrayNonUniformIndexing";
    // shaderStorageBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageImageArrayNonUniformIndexing";
    // shaderStorageImageArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageArrayNonUniformIndexing;
    os << YAML::Key << "shaderInputAttachmentArrayNonUniformIndexing";
    // shaderInputAttachmentArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayNonUniformIndexing;
    os << YAML::Key << "shaderUniformTexelBufferArrayNonUniformIndexing";
    // shaderUniformTexelBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformTexelBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageTexelBufferArrayNonUniformIndexing";
    // shaderStorageTexelBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageTexelBufferArrayNonUniformIndexing;
    os << YAML::Key << "descriptorBindingUniformBufferUpdateAfterBind";
    // descriptorBindingUniformBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUniformBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingSampledImageUpdateAfterBind";
    // descriptorBindingSampledImageUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingSampledImageUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageImageUpdateAfterBind";
    // descriptorBindingStorageImageUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageImageUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageBufferUpdateAfterBind";
    // descriptorBindingStorageBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingUniformTexelBufferUpdateAfterBind";
    // descriptorBindingUniformTexelBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUniformTexelBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageTexelBufferUpdateAfterBind";
    // descriptorBindingStorageTexelBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageTexelBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingUpdateUnusedWhilePending";
    // descriptorBindingUpdateUnusedWhilePending -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUpdateUnusedWhilePending;
    os << YAML::Key << "descriptorBindingPartiallyBound";
    // descriptorBindingPartiallyBound -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingPartiallyBound;
    os << YAML::Key << "descriptorBindingVariableDescriptorCount";
    // descriptorBindingVariableDescriptorCount -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingVariableDescriptorCount;
    os << YAML::Key << "runtimeDescriptorArray";
    // runtimeDescriptorArray -> Field -> VkBool32
    os << YAML::Value << t.runtimeDescriptorArray;
    os << YAML::Key << "samplerFilterMinmax";
    // samplerFilterMinmax -> Field -> VkBool32
    os << YAML::Value << t.samplerFilterMinmax;
    os << YAML::Key << "scalarBlockLayout";
    // scalarBlockLayout -> Field -> VkBool32
    os << YAML::Value << t.scalarBlockLayout;
    os << YAML::Key << "imagelessFramebuffer";
    // imagelessFramebuffer -> Field -> VkBool32
    os << YAML::Value << t.imagelessFramebuffer;
    os << YAML::Key << "uniformBufferStandardLayout";
    // uniformBufferStandardLayout -> Field -> VkBool32
    os << YAML::Value << t.uniformBufferStandardLayout;
    os << YAML::Key << "shaderSubgroupExtendedTypes";
    // shaderSubgroupExtendedTypes -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupExtendedTypes;
    os << YAML::Key << "separateDepthStencilLayouts";
    // separateDepthStencilLayouts -> Field -> VkBool32
    os << YAML::Value << t.separateDepthStencilLayouts;
    os << YAML::Key << "hostQueryReset";
    // hostQueryReset -> Field -> VkBool32
    os << YAML::Value << t.hostQueryReset;
    os << YAML::Key << "timelineSemaphore";
    // timelineSemaphore -> Field -> VkBool32
    os << YAML::Value << t.timelineSemaphore;
    os << YAML::Key << "bufferDeviceAddress";
    // bufferDeviceAddress -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddress;
    os << YAML::Key << "bufferDeviceAddressCaptureReplay";
    // bufferDeviceAddressCaptureReplay -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressCaptureReplay;
    os << YAML::Key << "bufferDeviceAddressMultiDevice";
    // bufferDeviceAddressMultiDevice -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressMultiDevice;
    os << YAML::Key << "vulkanMemoryModel";
    // vulkanMemoryModel -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModel;
    os << YAML::Key << "vulkanMemoryModelDeviceScope";
    // vulkanMemoryModelDeviceScope -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModelDeviceScope;
    os << YAML::Key << "vulkanMemoryModelAvailabilityVisibilityChains";
    // vulkanMemoryModelAvailabilityVisibilityChains -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModelAvailabilityVisibilityChains;
    os << YAML::Key << "shaderOutputViewportIndex";
    // shaderOutputViewportIndex -> Field -> VkBool32
    os << YAML::Value << t.shaderOutputViewportIndex;
    os << YAML::Key << "shaderOutputLayer";
    // shaderOutputLayer -> Field -> VkBool32
    os << YAML::Value << t.shaderOutputLayer;
    os << YAML::Key << "subgroupBroadcastDynamicId";
    // subgroupBroadcastDynamicId -> Field -> VkBool32
    os << YAML::Value << t.subgroupBroadcastDynamicId;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkConformanceVersion &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "major";
    // major -> Field -> uint8_t
    os << YAML::Value << t.major;
    os << YAML::Key << "minor";
    // minor -> Field -> uint8_t
    os << YAML::Value << t.minor;
    os << YAML::Key << "subminor";
    // subminor -> Field -> uint8_t
    os << YAML::Value << t.subminor;
    os << YAML::Key << "patch";
    // patch -> Field -> uint8_t
    os << YAML::Value << t.patch;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan12Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "driverID";
    // driverID -> Field -> VkDriverId
    os << YAML::Value << t.driverID;
    os << YAML::Key << "driverName";
    // driverName -> Field -> FixedArray(char)
    os << YAML::Value << t.driverName;
    os << YAML::Key << "driverInfo";
    // driverInfo -> Field -> FixedArray(char)
    os << YAML::Value << t.driverInfo;
    os << YAML::Key << "conformanceVersion";
    // conformanceVersion -> Field -> VkConformanceVersion
    os << YAML::Value << t.conformanceVersion;
    os << YAML::Key << "denormBehaviorIndependence";
    // denormBehaviorIndependence -> Field -> VkShaderFloatControlsIndependence
    os << YAML::Value << t.denormBehaviorIndependence;
    os << YAML::Key << "roundingModeIndependence";
    // roundingModeIndependence -> Field -> VkShaderFloatControlsIndependence
    os << YAML::Value << t.roundingModeIndependence;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat16";
    // shaderSignedZeroInfNanPreserveFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat16;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat32";
    // shaderSignedZeroInfNanPreserveFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat32;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat64";
    // shaderSignedZeroInfNanPreserveFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat64;
    os << YAML::Key << "shaderDenormPreserveFloat16";
    // shaderDenormPreserveFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat16;
    os << YAML::Key << "shaderDenormPreserveFloat32";
    // shaderDenormPreserveFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat32;
    os << YAML::Key << "shaderDenormPreserveFloat64";
    // shaderDenormPreserveFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat64;
    os << YAML::Key << "shaderDenormFlushToZeroFloat16";
    // shaderDenormFlushToZeroFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat16;
    os << YAML::Key << "shaderDenormFlushToZeroFloat32";
    // shaderDenormFlushToZeroFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat32;
    os << YAML::Key << "shaderDenormFlushToZeroFloat64";
    // shaderDenormFlushToZeroFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat64;
    os << YAML::Key << "shaderRoundingModeRTEFloat16";
    // shaderRoundingModeRTEFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat16;
    os << YAML::Key << "shaderRoundingModeRTEFloat32";
    // shaderRoundingModeRTEFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat32;
    os << YAML::Key << "shaderRoundingModeRTEFloat64";
    // shaderRoundingModeRTEFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat64;
    os << YAML::Key << "shaderRoundingModeRTZFloat16";
    // shaderRoundingModeRTZFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat16;
    os << YAML::Key << "shaderRoundingModeRTZFloat32";
    // shaderRoundingModeRTZFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat32;
    os << YAML::Key << "shaderRoundingModeRTZFloat64";
    // shaderRoundingModeRTZFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat64;
    os << YAML::Key << "maxUpdateAfterBindDescriptorsInAllPools";
    // maxUpdateAfterBindDescriptorsInAllPools -> Field -> uint32_t
    os << YAML::Value << t.maxUpdateAfterBindDescriptorsInAllPools;
    os << YAML::Key << "shaderUniformBufferArrayNonUniformIndexingNative";
    // shaderUniformBufferArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformBufferArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderSampledImageArrayNonUniformIndexingNative";
    // shaderSampledImageArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderSampledImageArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderStorageBufferArrayNonUniformIndexingNative";
    // shaderStorageBufferArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageBufferArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderStorageImageArrayNonUniformIndexingNative";
    // shaderStorageImageArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderInputAttachmentArrayNonUniformIndexingNative";
    // shaderInputAttachmentArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayNonUniformIndexingNative;
    os << YAML::Key << "robustBufferAccessUpdateAfterBind";
    // robustBufferAccessUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.robustBufferAccessUpdateAfterBind;
    os << YAML::Key << "quadDivergentImplicitLod";
    // quadDivergentImplicitLod -> Field -> VkBool32
    os << YAML::Value << t.quadDivergentImplicitLod;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindSamplers";
    // maxPerStageDescriptorUpdateAfterBindSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindSamplers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindUniformBuffers";
    // maxPerStageDescriptorUpdateAfterBindUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindStorageBuffers";
    // maxPerStageDescriptorUpdateAfterBindStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindSampledImages";
    // maxPerStageDescriptorUpdateAfterBindSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindSampledImages;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindStorageImages";
    // maxPerStageDescriptorUpdateAfterBindStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindStorageImages;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindInputAttachments";
    // maxPerStageDescriptorUpdateAfterBindInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    os << YAML::Key << "maxPerStageUpdateAfterBindResources";
    // maxPerStageUpdateAfterBindResources -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageUpdateAfterBindResources;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindSamplers";
    // maxDescriptorSetUpdateAfterBindSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindSamplers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindUniformBuffers";
    // maxDescriptorSetUpdateAfterBindUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindUniformBuffers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindUniformBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageBuffers";
    // maxDescriptorSetUpdateAfterBindStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageBuffers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindStorageBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindSampledImages";
    // maxDescriptorSetUpdateAfterBindSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindSampledImages;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageImages";
    // maxDescriptorSetUpdateAfterBindStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageImages;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindInputAttachments";
    // maxDescriptorSetUpdateAfterBindInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindInputAttachments;
    os << YAML::Key << "supportedDepthResolveModes";
    // supportedDepthResolveModes -> Field -> VkResolveModeFlags
    os << YAML::Value << t.supportedDepthResolveModes;
    os << YAML::Key << "supportedStencilResolveModes";
    // supportedStencilResolveModes -> Field -> VkResolveModeFlags
    os << YAML::Value << t.supportedStencilResolveModes;
    os << YAML::Key << "independentResolveNone";
    // independentResolveNone -> Field -> VkBool32
    os << YAML::Value << t.independentResolveNone;
    os << YAML::Key << "independentResolve";
    // independentResolve -> Field -> VkBool32
    os << YAML::Value << t.independentResolve;
    os << YAML::Key << "filterMinmaxSingleComponentFormats";
    // filterMinmaxSingleComponentFormats -> Field -> VkBool32
    os << YAML::Value << t.filterMinmaxSingleComponentFormats;
    os << YAML::Key << "filterMinmaxImageComponentMapping";
    // filterMinmaxImageComponentMapping -> Field -> VkBool32
    os << YAML::Value << t.filterMinmaxImageComponentMapping;
    os << YAML::Key << "maxTimelineSemaphoreValueDifference";
    // maxTimelineSemaphoreValueDifference -> Field -> uint64_t
    os << YAML::Value << t.maxTimelineSemaphoreValueDifference;
    os << YAML::Key << "framebufferIntegerColorSampleCounts";
    // framebufferIntegerColorSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.framebufferIntegerColorSampleCounts;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageFormatListCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "viewFormatCount";
    // viewFormatCount -> Field -> uint32_t
    os << YAML::Value << t.viewFormatCount;
    os << YAML::Key << "pViewFormats";
    // pViewFormats -> Field -> ConstDynamicArray(VkFormat)
    if (t.viewFormatCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFormat");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewFormatCount); ++i) {
                os << t.pViewFormats[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDriverProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "driverID";
    // driverID -> Field -> VkDriverId
    os << YAML::Value << t.driverID;
    os << YAML::Key << "driverName";
    // driverName -> Field -> FixedArray(char)
    os << YAML::Value << t.driverName;
    os << YAML::Key << "driverInfo";
    // driverInfo -> Field -> FixedArray(char)
    os << YAML::Value << t.driverInfo;
    os << YAML::Key << "conformanceVersion";
    // conformanceVersion -> Field -> VkConformanceVersion
    os << YAML::Value << t.conformanceVersion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkanMemoryModelFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vulkanMemoryModel";
    // vulkanMemoryModel -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModel;
    os << YAML::Key << "vulkanMemoryModelDeviceScope";
    // vulkanMemoryModelDeviceScope -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModelDeviceScope;
    os << YAML::Key << "vulkanMemoryModelAvailabilityVisibilityChains";
    // vulkanMemoryModelAvailabilityVisibilityChains -> Field -> VkBool32
    os << YAML::Value << t.vulkanMemoryModelAvailabilityVisibilityChains;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceHostQueryResetFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hostQueryReset";
    // hostQueryReset -> Field -> VkBool32
    os << YAML::Value << t.hostQueryReset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTimelineSemaphoreFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "timelineSemaphore";
    // timelineSemaphore -> Field -> VkBool32
    os << YAML::Value << t.timelineSemaphore;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTimelineSemaphoreProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxTimelineSemaphoreValueDifference";
    // maxTimelineSemaphoreValueDifference -> Field -> uint64_t
    os << YAML::Value << t.maxTimelineSemaphoreValueDifference;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreTypeCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphoreType";
    // semaphoreType -> Field -> VkSemaphoreType
    os << YAML::Value << t.semaphoreType;
    os << YAML::Key << "initialValue";
    // initialValue -> Field -> uint64_t
    os << YAML::Value << t.initialValue;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTimelineSemaphoreSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreValueCount";
    // waitSemaphoreValueCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreValueCount;
    os << YAML::Key << "pWaitSemaphoreValues";
    // pWaitSemaphoreValues -> Field -> ConstDynamicArray(uint64_t)
    if (t.waitSemaphoreValueCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreValueCount); ++i) {
                os << t.pWaitSemaphoreValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreValueCount";
    // signalSemaphoreValueCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreValueCount;
    os << YAML::Key << "pSignalSemaphoreValues";
    // pSignalSemaphoreValues -> Field -> ConstDynamicArray(uint64_t)
    if (t.signalSemaphoreValueCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreValueCount); ++i) {
                os << t.pSignalSemaphoreValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreWaitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSemaphoreWaitFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "semaphoreCount";
    // semaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.semaphoreCount;
    os << YAML::Key << "pSemaphores";
    // pSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.semaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.semaphoreCount); ++i) {
                os << t.pSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pValues";
    // pValues -> Field -> ConstDynamicArray(uint64_t)
    if (t.semaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.semaphoreCount); ++i) {
                os << t.pValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreSignalInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "value";
    // value -> Field -> uint64_t
    os << YAML::Value << t.value;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceBufferDeviceAddressFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "bufferDeviceAddress";
    // bufferDeviceAddress -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddress;
    os << YAML::Key << "bufferDeviceAddressCaptureReplay";
    // bufferDeviceAddressCaptureReplay -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressCaptureReplay;
    os << YAML::Key << "bufferDeviceAddressMultiDevice";
    // bufferDeviceAddressMultiDevice -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressMultiDevice;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferDeviceAddressInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferOpaqueCaptureAddressCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "opaqueCaptureAddress";
    // opaqueCaptureAddress -> Field -> uint64_t
    os << YAML::Value << t.opaqueCaptureAddress;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryOpaqueCaptureAddressAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "opaqueCaptureAddress";
    // opaqueCaptureAddress -> Field -> uint64_t
    os << YAML::Value << t.opaqueCaptureAddress;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceMemoryOpaqueCaptureAddressInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevice8BitStorageFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "storageBuffer8BitAccess";
    // storageBuffer8BitAccess -> Field -> VkBool32
    os << YAML::Value << t.storageBuffer8BitAccess;
    os << YAML::Key << "uniformAndStorageBuffer8BitAccess";
    // uniformAndStorageBuffer8BitAccess -> Field -> VkBool32
    os << YAML::Value << t.uniformAndStorageBuffer8BitAccess;
    os << YAML::Key << "storagePushConstant8";
    // storagePushConstant8 -> Field -> VkBool32
    os << YAML::Value << t.storagePushConstant8;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderAtomicInt64Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderBufferInt64Atomics";
    // shaderBufferInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferInt64Atomics;
    os << YAML::Key << "shaderSharedInt64Atomics";
    // shaderSharedInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedInt64Atomics;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderFloat16Int8Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderFloat16";
    // shaderFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderFloat16;
    os << YAML::Key << "shaderInt8";
    // shaderInt8 -> Field -> VkBool32
    os << YAML::Value << t.shaderInt8;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFloatControlsProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "denormBehaviorIndependence";
    // denormBehaviorIndependence -> Field -> VkShaderFloatControlsIndependence
    os << YAML::Value << t.denormBehaviorIndependence;
    os << YAML::Key << "roundingModeIndependence";
    // roundingModeIndependence -> Field -> VkShaderFloatControlsIndependence
    os << YAML::Value << t.roundingModeIndependence;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat16";
    // shaderSignedZeroInfNanPreserveFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat16;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat32";
    // shaderSignedZeroInfNanPreserveFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat32;
    os << YAML::Key << "shaderSignedZeroInfNanPreserveFloat64";
    // shaderSignedZeroInfNanPreserveFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderSignedZeroInfNanPreserveFloat64;
    os << YAML::Key << "shaderDenormPreserveFloat16";
    // shaderDenormPreserveFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat16;
    os << YAML::Key << "shaderDenormPreserveFloat32";
    // shaderDenormPreserveFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat32;
    os << YAML::Key << "shaderDenormPreserveFloat64";
    // shaderDenormPreserveFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormPreserveFloat64;
    os << YAML::Key << "shaderDenormFlushToZeroFloat16";
    // shaderDenormFlushToZeroFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat16;
    os << YAML::Key << "shaderDenormFlushToZeroFloat32";
    // shaderDenormFlushToZeroFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat32;
    os << YAML::Key << "shaderDenormFlushToZeroFloat64";
    // shaderDenormFlushToZeroFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderDenormFlushToZeroFloat64;
    os << YAML::Key << "shaderRoundingModeRTEFloat16";
    // shaderRoundingModeRTEFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat16;
    os << YAML::Key << "shaderRoundingModeRTEFloat32";
    // shaderRoundingModeRTEFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat32;
    os << YAML::Key << "shaderRoundingModeRTEFloat64";
    // shaderRoundingModeRTEFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTEFloat64;
    os << YAML::Key << "shaderRoundingModeRTZFloat16";
    // shaderRoundingModeRTZFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat16;
    os << YAML::Key << "shaderRoundingModeRTZFloat32";
    // shaderRoundingModeRTZFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat32;
    os << YAML::Key << "shaderRoundingModeRTZFloat64";
    // shaderRoundingModeRTZFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderRoundingModeRTZFloat64;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetLayoutBindingFlagsCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "bindingCount";
    // bindingCount -> Field -> uint32_t
    os << YAML::Value << t.bindingCount;
    os << YAML::Key << "pBindingFlags";
    // pBindingFlags -> Field -> ConstDynamicArray(VkDescriptorBindingFlags)
    if (t.bindingCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorBindingFlags");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bindingCount); ++i) {
                os << t.pBindingFlags[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorIndexingFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderInputAttachmentArrayDynamicIndexing";
    // shaderInputAttachmentArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayDynamicIndexing;
    os << YAML::Key << "shaderUniformTexelBufferArrayDynamicIndexing";
    // shaderUniformTexelBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformTexelBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderStorageTexelBufferArrayDynamicIndexing";
    // shaderStorageTexelBufferArrayDynamicIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageTexelBufferArrayDynamicIndexing;
    os << YAML::Key << "shaderUniformBufferArrayNonUniformIndexing";
    // shaderUniformBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderSampledImageArrayNonUniformIndexing";
    // shaderSampledImageArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderSampledImageArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageBufferArrayNonUniformIndexing";
    // shaderStorageBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageImageArrayNonUniformIndexing";
    // shaderStorageImageArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageArrayNonUniformIndexing;
    os << YAML::Key << "shaderInputAttachmentArrayNonUniformIndexing";
    // shaderInputAttachmentArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayNonUniformIndexing;
    os << YAML::Key << "shaderUniformTexelBufferArrayNonUniformIndexing";
    // shaderUniformTexelBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformTexelBufferArrayNonUniformIndexing;
    os << YAML::Key << "shaderStorageTexelBufferArrayNonUniformIndexing";
    // shaderStorageTexelBufferArrayNonUniformIndexing -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageTexelBufferArrayNonUniformIndexing;
    os << YAML::Key << "descriptorBindingUniformBufferUpdateAfterBind";
    // descriptorBindingUniformBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUniformBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingSampledImageUpdateAfterBind";
    // descriptorBindingSampledImageUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingSampledImageUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageImageUpdateAfterBind";
    // descriptorBindingStorageImageUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageImageUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageBufferUpdateAfterBind";
    // descriptorBindingStorageBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingUniformTexelBufferUpdateAfterBind";
    // descriptorBindingUniformTexelBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUniformTexelBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingStorageTexelBufferUpdateAfterBind";
    // descriptorBindingStorageTexelBufferUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingStorageTexelBufferUpdateAfterBind;
    os << YAML::Key << "descriptorBindingUpdateUnusedWhilePending";
    // descriptorBindingUpdateUnusedWhilePending -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingUpdateUnusedWhilePending;
    os << YAML::Key << "descriptorBindingPartiallyBound";
    // descriptorBindingPartiallyBound -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingPartiallyBound;
    os << YAML::Key << "descriptorBindingVariableDescriptorCount";
    // descriptorBindingVariableDescriptorCount -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingVariableDescriptorCount;
    os << YAML::Key << "runtimeDescriptorArray";
    // runtimeDescriptorArray -> Field -> VkBool32
    os << YAML::Value << t.runtimeDescriptorArray;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorIndexingProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxUpdateAfterBindDescriptorsInAllPools";
    // maxUpdateAfterBindDescriptorsInAllPools -> Field -> uint32_t
    os << YAML::Value << t.maxUpdateAfterBindDescriptorsInAllPools;
    os << YAML::Key << "shaderUniformBufferArrayNonUniformIndexingNative";
    // shaderUniformBufferArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderUniformBufferArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderSampledImageArrayNonUniformIndexingNative";
    // shaderSampledImageArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderSampledImageArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderStorageBufferArrayNonUniformIndexingNative";
    // shaderStorageBufferArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageBufferArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderStorageImageArrayNonUniformIndexingNative";
    // shaderStorageImageArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderStorageImageArrayNonUniformIndexingNative;
    os << YAML::Key << "shaderInputAttachmentArrayNonUniformIndexingNative";
    // shaderInputAttachmentArrayNonUniformIndexingNative -> Field -> VkBool32
    os << YAML::Value << t.shaderInputAttachmentArrayNonUniformIndexingNative;
    os << YAML::Key << "robustBufferAccessUpdateAfterBind";
    // robustBufferAccessUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.robustBufferAccessUpdateAfterBind;
    os << YAML::Key << "quadDivergentImplicitLod";
    // quadDivergentImplicitLod -> Field -> VkBool32
    os << YAML::Value << t.quadDivergentImplicitLod;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindSamplers";
    // maxPerStageDescriptorUpdateAfterBindSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindSamplers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindUniformBuffers";
    // maxPerStageDescriptorUpdateAfterBindUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindStorageBuffers";
    // maxPerStageDescriptorUpdateAfterBindStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindSampledImages";
    // maxPerStageDescriptorUpdateAfterBindSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindSampledImages;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindStorageImages";
    // maxPerStageDescriptorUpdateAfterBindStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindStorageImages;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindInputAttachments";
    // maxPerStageDescriptorUpdateAfterBindInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    os << YAML::Key << "maxPerStageUpdateAfterBindResources";
    // maxPerStageUpdateAfterBindResources -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageUpdateAfterBindResources;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindSamplers";
    // maxDescriptorSetUpdateAfterBindSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindSamplers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindUniformBuffers";
    // maxDescriptorSetUpdateAfterBindUniformBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindUniformBuffers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindUniformBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindUniformBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageBuffers";
    // maxDescriptorSetUpdateAfterBindStorageBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageBuffers;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindStorageBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindSampledImages";
    // maxDescriptorSetUpdateAfterBindSampledImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindSampledImages;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindStorageImages";
    // maxDescriptorSetUpdateAfterBindStorageImages -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindStorageImages;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindInputAttachments";
    // maxDescriptorSetUpdateAfterBindInputAttachments -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindInputAttachments;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetVariableDescriptorCountAllocateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorSetCount";
    // descriptorSetCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorSetCount;
    os << YAML::Key << "pDescriptorCounts";
    // pDescriptorCounts -> Field -> ConstDynamicArray(uint32_t)
    if (t.descriptorSetCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorSetCount); ++i) {
                os << t.pDescriptorCounts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetVariableDescriptorCountLayoutSupport &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxVariableDescriptorCount";
    // maxVariableDescriptorCount -> Field -> uint32_t
    os << YAML::Value << t.maxVariableDescriptorCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceScalarBlockLayoutFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "scalarBlockLayout";
    // scalarBlockLayout -> Field -> VkBool32
    os << YAML::Value << t.scalarBlockLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerReductionModeCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "reductionMode";
    // reductionMode -> Field -> VkSamplerReductionMode
    os << YAML::Value << t.reductionMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSamplerFilterMinmaxProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "filterMinmaxSingleComponentFormats";
    // filterMinmaxSingleComponentFormats -> Field -> VkBool32
    os << YAML::Value << t.filterMinmaxSingleComponentFormats;
    os << YAML::Key << "filterMinmaxImageComponentMapping";
    // filterMinmaxImageComponentMapping -> Field -> VkBool32
    os << YAML::Value << t.filterMinmaxImageComponentMapping;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "uniformBufferStandardLayout";
    // uniformBufferStandardLayout -> Field -> VkBool32
    os << YAML::Value << t.uniformBufferStandardLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSubgroupExtendedTypes";
    // shaderSubgroupExtendedTypes -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupExtendedTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentDescription2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAttachmentDescriptionFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "samples";
    // samples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.samples;
    os << YAML::Key << "loadOp";
    // loadOp -> Field -> VkAttachmentLoadOp
    os << YAML::Value << t.loadOp;
    os << YAML::Key << "storeOp";
    // storeOp -> Field -> VkAttachmentStoreOp
    os << YAML::Value << t.storeOp;
    os << YAML::Key << "stencilLoadOp";
    // stencilLoadOp -> Field -> VkAttachmentLoadOp
    os << YAML::Value << t.stencilLoadOp;
    os << YAML::Key << "stencilStoreOp";
    // stencilStoreOp -> Field -> VkAttachmentStoreOp
    os << YAML::Value << t.stencilStoreOp;
    os << YAML::Key << "initialLayout";
    // initialLayout -> Field -> VkImageLayout
    os << YAML::Value << t.initialLayout;
    os << YAML::Key << "finalLayout";
    // finalLayout -> Field -> VkImageLayout
    os << YAML::Value << t.finalLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentReference2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "attachment";
    // attachment -> Field -> uint32_t
    os << YAML::Value << t.attachment;
    os << YAML::Key << "layout";
    // layout -> Field -> VkImageLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "aspectMask";
    // aspectMask -> Field -> VkImageAspectFlags
    os << YAML::Value << t.aspectMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassDescription2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSubpassDescriptionFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "viewMask";
    // viewMask -> Field -> uint32_t
    os << YAML::Value << t.viewMask;
    os << YAML::Key << "inputAttachmentCount";
    // inputAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.inputAttachmentCount;
    os << YAML::Key << "pInputAttachments";
    // pInputAttachments -> Field -> ConstDynamicArray(VkAttachmentReference2)
    if (t.inputAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.inputAttachmentCount); ++i) {
                os << t.pInputAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachments";
    // pColorAttachments -> Field -> ConstDynamicArray(VkAttachmentReference2)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pResolveAttachments";
    // pResolveAttachments -> Field -> ConstDynamicArray(VkAttachmentReference2)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentReference2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pResolveAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pDepthStencilAttachment";
    // pointer
    if (t.pDepthStencilAttachment != nullptr) {
        os << YAML::Value << *t.pDepthStencilAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "preserveAttachmentCount";
    // preserveAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.preserveAttachmentCount;
    os << YAML::Key << "pPreserveAttachments";
    // pPreserveAttachments -> Field -> ConstDynamicArray(uint32_t)
    if (t.preserveAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.preserveAttachmentCount); ++i) {
                os << t.pPreserveAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassDependency2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcSubpass";
    // srcSubpass -> Field -> uint32_t
    os << YAML::Value << t.srcSubpass;
    os << YAML::Key << "dstSubpass";
    // dstSubpass -> Field -> uint32_t
    os << YAML::Value << t.dstSubpass;
    os << YAML::Key << "srcStageMask";
    // srcStageMask -> Field -> VkPipelineStageFlags
    os << YAML::Value << t.srcStageMask;
    os << YAML::Key << "dstStageMask";
    // dstStageMask -> Field -> VkPipelineStageFlags
    os << YAML::Value << t.dstStageMask;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "dependencyFlags";
    // dependencyFlags -> Field -> VkDependencyFlags
    os << YAML::Value << t.dependencyFlags;
    os << YAML::Key << "viewOffset";
    // viewOffset -> Field -> int32_t
    os << YAML::Value << t.viewOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassCreateInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkRenderPassCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "attachmentCount";
    // attachmentCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentCount;
    os << YAML::Key << "pAttachments";
    // pAttachments -> Field -> ConstDynamicArray(VkAttachmentDescription2)
    if (t.attachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentDescription2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentCount); ++i) {
                os << t.pAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "subpassCount";
    // subpassCount -> Field -> uint32_t
    os << YAML::Value << t.subpassCount;
    os << YAML::Key << "pSubpasses";
    // pSubpasses -> Field -> ConstDynamicArray(VkSubpassDescription2)
    if (t.subpassCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubpassDescription2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.subpassCount); ++i) {
                os << t.pSubpasses[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dependencyCount";
    // dependencyCount -> Field -> uint32_t
    os << YAML::Value << t.dependencyCount;
    os << YAML::Key << "pDependencies";
    // pDependencies -> Field -> ConstDynamicArray(VkSubpassDependency2)
    if (t.dependencyCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubpassDependency2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.dependencyCount); ++i) {
                os << t.pDependencies[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "correlatedViewMaskCount";
    // correlatedViewMaskCount -> Field -> uint32_t
    os << YAML::Value << t.correlatedViewMaskCount;
    os << YAML::Key << "pCorrelatedViewMasks";
    // pCorrelatedViewMasks -> Field -> ConstDynamicArray(uint32_t)
    if (t.correlatedViewMaskCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.correlatedViewMaskCount); ++i) {
                os << t.pCorrelatedViewMasks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "contents";
    // contents -> Field -> VkSubpassContents
    os << YAML::Value << t.contents;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassEndInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassDescriptionDepthStencilResolve &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthResolveMode";
    // depthResolveMode -> Field -> VkResolveModeFlagBits
    os << YAML::Value << t.depthResolveMode;
    os << YAML::Key << "stencilResolveMode";
    // stencilResolveMode -> Field -> VkResolveModeFlagBits
    os << YAML::Value << t.stencilResolveMode;
    os << YAML::Key << "pDepthStencilResolveAttachment";
    // pointer
    if (t.pDepthStencilResolveAttachment != nullptr) {
        os << YAML::Value << *t.pDepthStencilResolveAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDepthStencilResolveProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supportedDepthResolveModes";
    // supportedDepthResolveModes -> Field -> VkResolveModeFlags
    os << YAML::Value << t.supportedDepthResolveModes;
    os << YAML::Key << "supportedStencilResolveModes";
    // supportedStencilResolveModes -> Field -> VkResolveModeFlags
    os << YAML::Value << t.supportedStencilResolveModes;
    os << YAML::Key << "independentResolveNone";
    // independentResolveNone -> Field -> VkBool32
    os << YAML::Value << t.independentResolveNone;
    os << YAML::Key << "independentResolve";
    // independentResolve -> Field -> VkBool32
    os << YAML::Value << t.independentResolve;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageStencilUsageCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stencilUsage";
    // stencilUsage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.stencilUsage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImagelessFramebufferFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imagelessFramebuffer";
    // imagelessFramebuffer -> Field -> VkBool32
    os << YAML::Value << t.imagelessFramebuffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFramebufferAttachmentImageInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImageCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "usage";
    // usage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::Key << "width";
    // width -> Field -> uint32_t
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> uint32_t
    os << YAML::Value << t.height;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::Key << "viewFormatCount";
    // viewFormatCount -> Field -> uint32_t
    os << YAML::Value << t.viewFormatCount;
    os << YAML::Key << "pViewFormats";
    // pViewFormats -> Field -> ConstDynamicArray(VkFormat)
    if (t.viewFormatCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFormat");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewFormatCount); ++i) {
                os << t.pViewFormats[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFramebufferAttachmentsCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "attachmentImageInfoCount";
    // attachmentImageInfoCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentImageInfoCount;
    os << YAML::Key << "pAttachmentImageInfos";
    // pAttachmentImageInfos -> Field -> ConstDynamicArray(VkFramebufferAttachmentImageInfo)
    if (t.attachmentImageInfoCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFramebufferAttachmentImageInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentImageInfoCount); ++i) {
                os << t.pAttachmentImageInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassAttachmentBeginInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "attachmentCount";
    // attachmentCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentCount;
    os << YAML::Key << "pAttachments";
    // pAttachments -> Field -> ConstDynamicArray(VkImageView)
    if (t.attachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageView");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentCount); ++i) {
                os << t.pAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "separateDepthStencilLayouts";
    // separateDepthStencilLayouts -> Field -> VkBool32
    os << YAML::Value << t.separateDepthStencilLayouts;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentReferenceStencilLayout &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stencilLayout";
    // stencilLayout -> Field -> VkImageLayout
    os << YAML::Value << t.stencilLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentDescriptionStencilLayout &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stencilInitialLayout";
    // stencilInitialLayout -> Field -> VkImageLayout
    os << YAML::Value << t.stencilInitialLayout;
    os << YAML::Key << "stencilFinalLayout";
    // stencilFinalLayout -> Field -> VkImageLayout
    os << YAML::Value << t.stencilFinalLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan13Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "robustImageAccess";
    // robustImageAccess -> Field -> VkBool32
    os << YAML::Value << t.robustImageAccess;
    os << YAML::Key << "inlineUniformBlock";
    // inlineUniformBlock -> Field -> VkBool32
    os << YAML::Value << t.inlineUniformBlock;
    os << YAML::Key << "descriptorBindingInlineUniformBlockUpdateAfterBind";
    // descriptorBindingInlineUniformBlockUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingInlineUniformBlockUpdateAfterBind;
    os << YAML::Key << "pipelineCreationCacheControl";
    // pipelineCreationCacheControl -> Field -> VkBool32
    os << YAML::Value << t.pipelineCreationCacheControl;
    os << YAML::Key << "privateData";
    // privateData -> Field -> VkBool32
    os << YAML::Value << t.privateData;
    os << YAML::Key << "shaderDemoteToHelperInvocation";
    // shaderDemoteToHelperInvocation -> Field -> VkBool32
    os << YAML::Value << t.shaderDemoteToHelperInvocation;
    os << YAML::Key << "shaderTerminateInvocation";
    // shaderTerminateInvocation -> Field -> VkBool32
    os << YAML::Value << t.shaderTerminateInvocation;
    os << YAML::Key << "subgroupSizeControl";
    // subgroupSizeControl -> Field -> VkBool32
    os << YAML::Value << t.subgroupSizeControl;
    os << YAML::Key << "computeFullSubgroups";
    // computeFullSubgroups -> Field -> VkBool32
    os << YAML::Value << t.computeFullSubgroups;
    os << YAML::Key << "synchronization2";
    // synchronization2 -> Field -> VkBool32
    os << YAML::Value << t.synchronization2;
    os << YAML::Key << "textureCompressionASTC_HDR";
    // textureCompressionASTC_HDR -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionASTC_HDR;
    os << YAML::Key << "shaderZeroInitializeWorkgroupMemory";
    // shaderZeroInitializeWorkgroupMemory -> Field -> VkBool32
    os << YAML::Value << t.shaderZeroInitializeWorkgroupMemory;
    os << YAML::Key << "dynamicRendering";
    // dynamicRendering -> Field -> VkBool32
    os << YAML::Value << t.dynamicRendering;
    os << YAML::Key << "shaderIntegerDotProduct";
    // shaderIntegerDotProduct -> Field -> VkBool32
    os << YAML::Value << t.shaderIntegerDotProduct;
    os << YAML::Key << "maintenance4";
    // maintenance4 -> Field -> VkBool32
    os << YAML::Value << t.maintenance4;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan13Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minSubgroupSize";
    // minSubgroupSize -> Field -> uint32_t
    os << YAML::Value << t.minSubgroupSize;
    os << YAML::Key << "maxSubgroupSize";
    // maxSubgroupSize -> Field -> uint32_t
    os << YAML::Value << t.maxSubgroupSize;
    os << YAML::Key << "maxComputeWorkgroupSubgroups";
    // maxComputeWorkgroupSubgroups -> Field -> uint32_t
    os << YAML::Value << t.maxComputeWorkgroupSubgroups;
    os << YAML::Key << "requiredSubgroupSizeStages";
    // requiredSubgroupSizeStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.requiredSubgroupSizeStages;
    os << YAML::Key << "maxInlineUniformBlockSize";
    // maxInlineUniformBlockSize -> Field -> uint32_t
    os << YAML::Value << t.maxInlineUniformBlockSize;
    os << YAML::Key << "maxPerStageDescriptorInlineUniformBlocks";
    // maxPerStageDescriptorInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorInlineUniformBlocks;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks";
    // maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    os << YAML::Key << "maxDescriptorSetInlineUniformBlocks";
    // maxDescriptorSetInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetInlineUniformBlocks;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindInlineUniformBlocks";
    // maxDescriptorSetUpdateAfterBindInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    os << YAML::Key << "maxInlineUniformTotalSize";
    // maxInlineUniformTotalSize -> Field -> uint32_t
    os << YAML::Value << t.maxInlineUniformTotalSize;
    os << YAML::Key << "integerDotProduct8BitUnsignedAccelerated";
    // integerDotProduct8BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct8BitSignedAccelerated";
    // integerDotProduct8BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct8BitMixedSignednessAccelerated";
    // integerDotProduct8BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedUnsignedAccelerated";
    // integerDotProduct4x8BitPackedUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedSignedAccelerated";
    // integerDotProduct4x8BitPackedSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedSignedAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedMixedSignednessAccelerated";
    // integerDotProduct4x8BitPackedMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct16BitUnsignedAccelerated";
    // integerDotProduct16BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct16BitSignedAccelerated";
    // integerDotProduct16BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct16BitMixedSignednessAccelerated";
    // integerDotProduct16BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct32BitUnsignedAccelerated";
    // integerDotProduct32BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct32BitSignedAccelerated";
    // integerDotProduct32BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct32BitMixedSignednessAccelerated";
    // integerDotProduct32BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct64BitUnsignedAccelerated";
    // integerDotProduct64BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct64BitSignedAccelerated";
    // integerDotProduct64BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct64BitMixedSignednessAccelerated";
    // integerDotProduct64BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating8BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating8BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating16BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating16BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating32BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating32BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating64BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating64BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    os << YAML::Key << "storageTexelBufferOffsetAlignmentBytes";
    // storageTexelBufferOffsetAlignmentBytes -> Field -> VkDeviceSize
    os << YAML::Value << t.storageTexelBufferOffsetAlignmentBytes;
    os << YAML::Key << "storageTexelBufferOffsetSingleTexelAlignment";
    // storageTexelBufferOffsetSingleTexelAlignment -> Field -> VkBool32
    os << YAML::Value << t.storageTexelBufferOffsetSingleTexelAlignment;
    os << YAML::Key << "uniformTexelBufferOffsetAlignmentBytes";
    // uniformTexelBufferOffsetAlignmentBytes -> Field -> VkDeviceSize
    os << YAML::Value << t.uniformTexelBufferOffsetAlignmentBytes;
    os << YAML::Key << "uniformTexelBufferOffsetSingleTexelAlignment";
    // uniformTexelBufferOffsetSingleTexelAlignment -> Field -> VkBool32
    os << YAML::Value << t.uniformTexelBufferOffsetSingleTexelAlignment;
    os << YAML::Key << "maxBufferSize";
    // maxBufferSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxBufferSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceToolProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "name";
    // name -> Field -> FixedArray(char)
    os << YAML::Value << t.name;
    os << YAML::Key << "version";
    // version -> Field -> FixedArray(char)
    os << YAML::Value << t.version;
    os << YAML::Key << "purposes";
    // purposes -> Field -> VkToolPurposeFlags
    os << YAML::Value << t.purposes;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "layer";
    // layer -> Field -> FixedArray(char)
    os << YAML::Value << t.layer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePrivateDataFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "privateData";
    // privateData -> Field -> VkBool32
    os << YAML::Value << t.privateData;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDevicePrivateDataCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "privateDataSlotRequestCount";
    // privateDataSlotRequestCount -> Field -> uint32_t
    os << YAML::Value << t.privateDataSlotRequestCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPrivateDataSlotCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPrivateDataSlotCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryBarrier2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcStageMask";
    // srcStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.srcStageMask;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstStageMask";
    // dstStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.dstStageMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.dstAccessMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferMemoryBarrier2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcStageMask";
    // srcStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.srcStageMask;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstStageMask";
    // dstStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.dstStageMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "srcQueueFamilyIndex";
    // srcQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.srcQueueFamilyIndex;
    os << YAML::Key << "dstQueueFamilyIndex";
    // dstQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.dstQueueFamilyIndex;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageMemoryBarrier2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcStageMask";
    // srcStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.srcStageMask;
    os << YAML::Key << "srcAccessMask";
    // srcAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.srcAccessMask;
    os << YAML::Key << "dstStageMask";
    // dstStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.dstStageMask;
    os << YAML::Key << "dstAccessMask";
    // dstAccessMask -> Field -> VkAccessFlags2
    os << YAML::Value << t.dstAccessMask;
    os << YAML::Key << "oldLayout";
    // oldLayout -> Field -> VkImageLayout
    os << YAML::Value << t.oldLayout;
    os << YAML::Key << "newLayout";
    // newLayout -> Field -> VkImageLayout
    os << YAML::Value << t.newLayout;
    os << YAML::Key << "srcQueueFamilyIndex";
    // srcQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.srcQueueFamilyIndex;
    os << YAML::Key << "dstQueueFamilyIndex";
    // dstQueueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.dstQueueFamilyIndex;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "subresourceRange";
    // subresourceRange -> Field -> VkImageSubresourceRange
    os << YAML::Value << t.subresourceRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDependencyInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dependencyFlags";
    // dependencyFlags -> Field -> VkDependencyFlags
    os << YAML::Value << t.dependencyFlags;
    os << YAML::Key << "memoryBarrierCount";
    // memoryBarrierCount -> Field -> uint32_t
    os << YAML::Value << t.memoryBarrierCount;
    os << YAML::Key << "pMemoryBarriers";
    // pMemoryBarriers -> Field -> ConstDynamicArray(VkMemoryBarrier2)
    if (t.memoryBarrierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkMemoryBarrier2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.memoryBarrierCount); ++i) {
                os << t.pMemoryBarriers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "bufferMemoryBarrierCount";
    // bufferMemoryBarrierCount -> Field -> uint32_t
    os << YAML::Value << t.bufferMemoryBarrierCount;
    os << YAML::Key << "pBufferMemoryBarriers";
    // pBufferMemoryBarriers -> Field -> ConstDynamicArray(VkBufferMemoryBarrier2)
    if (t.bufferMemoryBarrierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkBufferMemoryBarrier2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.bufferMemoryBarrierCount); ++i) {
                os << t.pBufferMemoryBarriers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "imageMemoryBarrierCount";
    // imageMemoryBarrierCount -> Field -> uint32_t
    os << YAML::Value << t.imageMemoryBarrierCount;
    os << YAML::Key << "pImageMemoryBarriers";
    // pImageMemoryBarriers -> Field -> ConstDynamicArray(VkImageMemoryBarrier2)
    if (t.imageMemoryBarrierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageMemoryBarrier2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.imageMemoryBarrierCount); ++i) {
                os << t.pImageMemoryBarriers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "value";
    // value -> Field -> uint64_t
    os << YAML::Value << t.value;
    os << YAML::Key << "stageMask";
    // stageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.stageMask;
    os << YAML::Key << "deviceIndex";
    // deviceIndex -> Field -> uint32_t
    os << YAML::Value << t.deviceIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferSubmitInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "commandBuffer";
    // commandBuffer -> Field -> VkCommandBuffer
    os << YAML::Value << t.commandBuffer;
    os << YAML::Key << "deviceMask";
    // deviceMask -> Field -> uint32_t
    os << YAML::Value << t.deviceMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubmitInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSubmitFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "waitSemaphoreInfoCount";
    // waitSemaphoreInfoCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreInfoCount;
    os << YAML::Key << "pWaitSemaphoreInfos";
    // pWaitSemaphoreInfos -> Field -> ConstDynamicArray(VkSemaphoreSubmitInfo)
    if (t.waitSemaphoreInfoCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphoreSubmitInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreInfoCount); ++i) {
                os << t.pWaitSemaphoreInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "commandBufferInfoCount";
    // commandBufferInfoCount -> Field -> uint32_t
    os << YAML::Value << t.commandBufferInfoCount;
    os << YAML::Key << "pCommandBufferInfos";
    // pCommandBufferInfos -> Field -> ConstDynamicArray(VkCommandBufferSubmitInfo)
    if (t.commandBufferInfoCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkCommandBufferSubmitInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.commandBufferInfoCount); ++i) {
                os << t.pCommandBufferInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreInfoCount";
    // signalSemaphoreInfoCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreInfoCount;
    os << YAML::Key << "pSignalSemaphoreInfos";
    // pSignalSemaphoreInfos -> Field -> ConstDynamicArray(VkSemaphoreSubmitInfo)
    if (t.signalSemaphoreInfoCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphoreSubmitInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreInfoCount); ++i) {
                os << t.pSignalSemaphoreInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSynchronization2Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "synchronization2";
    // synchronization2 -> Field -> VkBool32
    os << YAML::Value << t.synchronization2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCopy2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyBufferInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcBuffer";
    // srcBuffer -> Field -> VkBuffer
    os << YAML::Value << t.srcBuffer;
    os << YAML::Key << "dstBuffer";
    // dstBuffer -> Field -> VkBuffer
    os << YAML::Value << t.dstBuffer;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkBufferCopy2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkBufferCopy2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCopy2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkOffset3D
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkOffset3D
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyImageInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkImageCopy2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageCopy2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferImageCopy2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "bufferOffset";
    // bufferOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.bufferOffset;
    os << YAML::Key << "bufferRowLength";
    // bufferRowLength -> Field -> uint32_t
    os << YAML::Value << t.bufferRowLength;
    os << YAML::Key << "bufferImageHeight";
    // bufferImageHeight -> Field -> uint32_t
    os << YAML::Value << t.bufferImageHeight;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.imageSubresource;
    os << YAML::Key << "imageOffset";
    // imageOffset -> Field -> VkOffset3D
    os << YAML::Value << t.imageOffset;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent3D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyBufferToImageInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcBuffer";
    // srcBuffer -> Field -> VkBuffer
    os << YAML::Value << t.srcBuffer;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkBufferImageCopy2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkBufferImageCopy2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyImageToBufferInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "dstBuffer";
    // dstBuffer -> Field -> VkBuffer
    os << YAML::Value << t.dstBuffer;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkBufferImageCopy2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkBufferImageCopy2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "textureCompressionASTC_HDR";
    // textureCompressionASTC_HDR -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionASTC_HDR;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFormatProperties3 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "linearTilingFeatures";
    // linearTilingFeatures -> Field -> VkFormatFeatureFlags2
    os << YAML::Value << t.linearTilingFeatures;
    os << YAML::Key << "optimalTilingFeatures";
    // optimalTilingFeatures -> Field -> VkFormatFeatureFlags2
    os << YAML::Value << t.optimalTilingFeatures;
    os << YAML::Key << "bufferFeatures";
    // bufferFeatures -> Field -> VkFormatFeatureFlags2
    os << YAML::Value << t.bufferFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance4Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance4";
    // maintenance4 -> Field -> VkBool32
    os << YAML::Value << t.maintenance4;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance4Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxBufferSize";
    // maxBufferSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxBufferSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceBufferMemoryRequirements &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pCreateInfo";
    // pointer
    if (t.pCreateInfo != nullptr) {
        os << YAML::Value << *t.pCreateInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceImageMemoryRequirements &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pCreateInfo";
    // pointer
    if (t.pCreateInfo != nullptr) {
        os << YAML::Value << *t.pCreateInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "planeAspect";
    // planeAspect -> Field -> VkImageAspectFlagBits
    os << YAML::Value << t.planeAspect;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCreationFeedback &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreationFeedbackFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "duration";
    // duration -> Field -> uint64_t
    os << YAML::Value << t.duration;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCreationFeedbackCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pPipelineCreationFeedback";
    // pointer
    if (t.pPipelineCreationFeedback != nullptr) {
        os << YAML::Value << *t.pPipelineCreationFeedback;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pipelineStageCreationFeedbackCount";
    // pipelineStageCreationFeedbackCount -> Field -> uint32_t
    os << YAML::Value << t.pipelineStageCreationFeedbackCount;
    os << YAML::Key << "pPipelineStageCreationFeedbacks";
    // pPipelineStageCreationFeedbacks -> Field -> DynamicArray(VkPipelineCreationFeedback)
    if (t.pipelineStageCreationFeedbackCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineCreationFeedback");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.pipelineStageCreationFeedbackCount); ++i) {
                os << t.pPipelineStageCreationFeedbacks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderTerminateInvocationFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderTerminateInvocation";
    // shaderTerminateInvocation -> Field -> VkBool32
    os << YAML::Value << t.shaderTerminateInvocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderDemoteToHelperInvocation";
    // shaderDemoteToHelperInvocation -> Field -> VkBool32
    os << YAML::Value << t.shaderDemoteToHelperInvocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineCreationCacheControlFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineCreationCacheControl";
    // pipelineCreationCacheControl -> Field -> VkBool32
    os << YAML::Value << t.pipelineCreationCacheControl;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderZeroInitializeWorkgroupMemory";
    // shaderZeroInitializeWorkgroupMemory -> Field -> VkBool32
    os << YAML::Value << t.shaderZeroInitializeWorkgroupMemory;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImageRobustnessFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "robustImageAccess";
    // robustImageAccess -> Field -> VkBool32
    os << YAML::Value << t.robustImageAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSubgroupSizeControlFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subgroupSizeControl";
    // subgroupSizeControl -> Field -> VkBool32
    os << YAML::Value << t.subgroupSizeControl;
    os << YAML::Key << "computeFullSubgroups";
    // computeFullSubgroups -> Field -> VkBool32
    os << YAML::Value << t.computeFullSubgroups;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSubgroupSizeControlProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minSubgroupSize";
    // minSubgroupSize -> Field -> uint32_t
    os << YAML::Value << t.minSubgroupSize;
    os << YAML::Key << "maxSubgroupSize";
    // maxSubgroupSize -> Field -> uint32_t
    os << YAML::Value << t.maxSubgroupSize;
    os << YAML::Key << "maxComputeWorkgroupSubgroups";
    // maxComputeWorkgroupSubgroups -> Field -> uint32_t
    os << YAML::Value << t.maxComputeWorkgroupSubgroups;
    os << YAML::Key << "requiredSubgroupSizeStages";
    // requiredSubgroupSizeStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.requiredSubgroupSizeStages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "requiredSubgroupSize";
    // requiredSubgroupSize -> Field -> uint32_t
    os << YAML::Value << t.requiredSubgroupSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceInlineUniformBlockFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "inlineUniformBlock";
    // inlineUniformBlock -> Field -> VkBool32
    os << YAML::Value << t.inlineUniformBlock;
    os << YAML::Key << "descriptorBindingInlineUniformBlockUpdateAfterBind";
    // descriptorBindingInlineUniformBlockUpdateAfterBind -> Field -> VkBool32
    os << YAML::Value << t.descriptorBindingInlineUniformBlockUpdateAfterBind;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceInlineUniformBlockProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxInlineUniformBlockSize";
    // maxInlineUniformBlockSize -> Field -> uint32_t
    os << YAML::Value << t.maxInlineUniformBlockSize;
    os << YAML::Key << "maxPerStageDescriptorInlineUniformBlocks";
    // maxPerStageDescriptorInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorInlineUniformBlocks;
    os << YAML::Key << "maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks";
    // maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks;
    os << YAML::Key << "maxDescriptorSetInlineUniformBlocks";
    // maxDescriptorSetInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetInlineUniformBlocks;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindInlineUniformBlocks";
    // maxDescriptorSetUpdateAfterBindInlineUniformBlocks -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindInlineUniformBlocks;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkWriteDescriptorSetInlineUniformBlock &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> uint32_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorPoolInlineUniformBlockCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxInlineUniformBlockBindings";
    // maxInlineUniformBlockBindings -> Field -> uint32_t
    os << YAML::Value << t.maxInlineUniformBlockBindings;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderIntegerDotProductFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderIntegerDotProduct";
    // shaderIntegerDotProduct -> Field -> VkBool32
    os << YAML::Value << t.shaderIntegerDotProduct;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderIntegerDotProductProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "integerDotProduct8BitUnsignedAccelerated";
    // integerDotProduct8BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct8BitSignedAccelerated";
    // integerDotProduct8BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct8BitMixedSignednessAccelerated";
    // integerDotProduct8BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct8BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedUnsignedAccelerated";
    // integerDotProduct4x8BitPackedUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedSignedAccelerated";
    // integerDotProduct4x8BitPackedSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedSignedAccelerated;
    os << YAML::Key << "integerDotProduct4x8BitPackedMixedSignednessAccelerated";
    // integerDotProduct4x8BitPackedMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct16BitUnsignedAccelerated";
    // integerDotProduct16BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct16BitSignedAccelerated";
    // integerDotProduct16BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct16BitMixedSignednessAccelerated";
    // integerDotProduct16BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct16BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct32BitUnsignedAccelerated";
    // integerDotProduct32BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct32BitSignedAccelerated";
    // integerDotProduct32BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct32BitMixedSignednessAccelerated";
    // integerDotProduct32BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct32BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProduct64BitUnsignedAccelerated";
    // integerDotProduct64BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProduct64BitSignedAccelerated";
    // integerDotProduct64BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitSignedAccelerated;
    os << YAML::Key << "integerDotProduct64BitMixedSignednessAccelerated";
    // integerDotProduct64BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProduct64BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating8BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating8BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating16BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating16BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating32BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating32BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitUnsignedAccelerated";
    // integerDotProductAccumulatingSaturating64BitUnsignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitSignedAccelerated";
    // integerDotProductAccumulatingSaturating64BitSignedAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    os << YAML::Key << "integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated";
    // integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated -> Field -> VkBool32
    os << YAML::Value << t.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTexelBufferAlignmentProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "storageTexelBufferOffsetAlignmentBytes";
    // storageTexelBufferOffsetAlignmentBytes -> Field -> VkDeviceSize
    os << YAML::Value << t.storageTexelBufferOffsetAlignmentBytes;
    os << YAML::Key << "storageTexelBufferOffsetSingleTexelAlignment";
    // storageTexelBufferOffsetSingleTexelAlignment -> Field -> VkBool32
    os << YAML::Value << t.storageTexelBufferOffsetSingleTexelAlignment;
    os << YAML::Key << "uniformTexelBufferOffsetAlignmentBytes";
    // uniformTexelBufferOffsetAlignmentBytes -> Field -> VkDeviceSize
    os << YAML::Value << t.uniformTexelBufferOffsetAlignmentBytes;
    os << YAML::Key << "uniformTexelBufferOffsetSingleTexelAlignment";
    // uniformTexelBufferOffsetSingleTexelAlignment -> Field -> VkBool32
    os << YAML::Value << t.uniformTexelBufferOffsetSingleTexelAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageBlit2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffsets";
    // srcOffsets -> Field -> FixedArray(VkOffset3D)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkOffset3D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.srcOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffsets";
    // dstOffsets -> Field -> FixedArray(VkOffset3D)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkOffset3D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.dstOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBlitImageInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkImageBlit2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageBlit2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "filter";
    // filter -> Field -> VkFilter
    os << YAML::Value << t.filter;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageResolve2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcSubresource";
    // srcSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.srcSubresource;
    os << YAML::Key << "srcOffset";
    // srcOffset -> Field -> VkOffset3D
    os << YAML::Value << t.srcOffset;
    os << YAML::Key << "dstSubresource";
    // dstSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.dstSubresource;
    os << YAML::Key << "dstOffset";
    // dstOffset -> Field -> VkOffset3D
    os << YAML::Value << t.dstOffset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent3D
    os << YAML::Value << t.extent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkResolveImageInfo2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkImageResolve2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageResolve2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingAttachmentInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "imageLayout";
    // imageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.imageLayout;
    os << YAML::Key << "resolveMode";
    // resolveMode -> Field -> VkResolveModeFlagBits
    os << YAML::Value << t.resolveMode;
    os << YAML::Key << "resolveImageView";
    // resolveImageView -> Field -> VkImageView
    os << YAML::Value << t.resolveImageView;
    os << YAML::Key << "resolveImageLayout";
    // resolveImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.resolveImageLayout;
    os << YAML::Key << "loadOp";
    // loadOp -> Field -> VkAttachmentLoadOp
    os << YAML::Value << t.loadOp;
    os << YAML::Key << "storeOp";
    // storeOp -> Field -> VkAttachmentStoreOp
    os << YAML::Value << t.storeOp;
    os << YAML::Key << "clearValue";
    // clearValue -> Field -> VkClearValue
    os << YAML::Value << t.clearValue;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkRenderingFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "renderArea";
    // renderArea -> Field -> VkRect2D
    os << YAML::Value << t.renderArea;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::Key << "viewMask";
    // viewMask -> Field -> uint32_t
    os << YAML::Value << t.viewMask;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachments";
    // pColorAttachments -> Field -> ConstDynamicArray(VkRenderingAttachmentInfo)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRenderingAttachmentInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachments[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pDepthAttachment";
    // pointer
    if (t.pDepthAttachment != nullptr) {
        os << YAML::Value << *t.pDepthAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pStencilAttachment";
    // pointer
    if (t.pStencilAttachment != nullptr) {
        os << YAML::Value << *t.pStencilAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRenderingCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "viewMask";
    // viewMask -> Field -> uint32_t
    os << YAML::Value << t.viewMask;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentFormats";
    // pColorAttachmentFormats -> Field -> ConstDynamicArray(VkFormat)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFormat");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentFormats[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "depthAttachmentFormat";
    // depthAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.depthAttachmentFormat;
    os << YAML::Key << "stencilAttachmentFormat";
    // stencilAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.stencilAttachmentFormat;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDynamicRenderingFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dynamicRendering";
    // dynamicRendering -> Field -> VkBool32
    os << YAML::Value << t.dynamicRendering;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceRenderingInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkRenderingFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "viewMask";
    // viewMask -> Field -> uint32_t
    os << YAML::Value << t.viewMask;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentFormats";
    // pColorAttachmentFormats -> Field -> ConstDynamicArray(VkFormat)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFormat");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentFormats[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "depthAttachmentFormat";
    // depthAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.depthAttachmentFormat;
    os << YAML::Key << "stencilAttachmentFormat";
    // stencilAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.stencilAttachmentFormat;
    os << YAML::Key << "rasterizationSamples";
    // rasterizationSamples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.rasterizationSamples;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan14Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "globalPriorityQuery";
    // globalPriorityQuery -> Field -> VkBool32
    os << YAML::Value << t.globalPriorityQuery;
    os << YAML::Key << "shaderSubgroupRotate";
    // shaderSubgroupRotate -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupRotate;
    os << YAML::Key << "shaderSubgroupRotateClustered";
    // shaderSubgroupRotateClustered -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupRotateClustered;
    os << YAML::Key << "shaderFloatControls2";
    // shaderFloatControls2 -> Field -> VkBool32
    os << YAML::Value << t.shaderFloatControls2;
    os << YAML::Key << "shaderExpectAssume";
    // shaderExpectAssume -> Field -> VkBool32
    os << YAML::Value << t.shaderExpectAssume;
    os << YAML::Key << "rectangularLines";
    // rectangularLines -> Field -> VkBool32
    os << YAML::Value << t.rectangularLines;
    os << YAML::Key << "bresenhamLines";
    // bresenhamLines -> Field -> VkBool32
    os << YAML::Value << t.bresenhamLines;
    os << YAML::Key << "smoothLines";
    // smoothLines -> Field -> VkBool32
    os << YAML::Value << t.smoothLines;
    os << YAML::Key << "stippledRectangularLines";
    // stippledRectangularLines -> Field -> VkBool32
    os << YAML::Value << t.stippledRectangularLines;
    os << YAML::Key << "stippledBresenhamLines";
    // stippledBresenhamLines -> Field -> VkBool32
    os << YAML::Value << t.stippledBresenhamLines;
    os << YAML::Key << "stippledSmoothLines";
    // stippledSmoothLines -> Field -> VkBool32
    os << YAML::Value << t.stippledSmoothLines;
    os << YAML::Key << "vertexAttributeInstanceRateDivisor";
    // vertexAttributeInstanceRateDivisor -> Field -> VkBool32
    os << YAML::Value << t.vertexAttributeInstanceRateDivisor;
    os << YAML::Key << "vertexAttributeInstanceRateZeroDivisor";
    // vertexAttributeInstanceRateZeroDivisor -> Field -> VkBool32
    os << YAML::Value << t.vertexAttributeInstanceRateZeroDivisor;
    os << YAML::Key << "indexTypeUint8";
    // indexTypeUint8 -> Field -> VkBool32
    os << YAML::Value << t.indexTypeUint8;
    os << YAML::Key << "dynamicRenderingLocalRead";
    // dynamicRenderingLocalRead -> Field -> VkBool32
    os << YAML::Value << t.dynamicRenderingLocalRead;
    os << YAML::Key << "maintenance5";
    // maintenance5 -> Field -> VkBool32
    os << YAML::Value << t.maintenance5;
    os << YAML::Key << "maintenance6";
    // maintenance6 -> Field -> VkBool32
    os << YAML::Value << t.maintenance6;
    os << YAML::Key << "pipelineProtectedAccess";
    // pipelineProtectedAccess -> Field -> VkBool32
    os << YAML::Value << t.pipelineProtectedAccess;
    os << YAML::Key << "pipelineRobustness";
    // pipelineRobustness -> Field -> VkBool32
    os << YAML::Value << t.pipelineRobustness;
    os << YAML::Key << "hostImageCopy";
    // hostImageCopy -> Field -> VkBool32
    os << YAML::Value << t.hostImageCopy;
    os << YAML::Key << "pushDescriptor";
    // pushDescriptor -> Field -> VkBool32
    os << YAML::Value << t.pushDescriptor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVulkan14Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "lineSubPixelPrecisionBits";
    // lineSubPixelPrecisionBits -> Field -> uint32_t
    os << YAML::Value << t.lineSubPixelPrecisionBits;
    os << YAML::Key << "maxVertexAttribDivisor";
    // maxVertexAttribDivisor -> Field -> uint32_t
    os << YAML::Value << t.maxVertexAttribDivisor;
    os << YAML::Key << "supportsNonZeroFirstInstance";
    // supportsNonZeroFirstInstance -> Field -> VkBool32
    os << YAML::Value << t.supportsNonZeroFirstInstance;
    os << YAML::Key << "maxPushDescriptors";
    // maxPushDescriptors -> Field -> uint32_t
    os << YAML::Value << t.maxPushDescriptors;
    os << YAML::Key << "dynamicRenderingLocalReadDepthStencilAttachments";
    // dynamicRenderingLocalReadDepthStencilAttachments -> Field -> VkBool32
    os << YAML::Value << t.dynamicRenderingLocalReadDepthStencilAttachments;
    os << YAML::Key << "dynamicRenderingLocalReadMultisampledAttachments";
    // dynamicRenderingLocalReadMultisampledAttachments -> Field -> VkBool32
    os << YAML::Value << t.dynamicRenderingLocalReadMultisampledAttachments;
    os << YAML::Key << "earlyFragmentMultisampleCoverageAfterSampleCounting";
    // earlyFragmentMultisampleCoverageAfterSampleCounting -> Field -> VkBool32
    os << YAML::Value << t.earlyFragmentMultisampleCoverageAfterSampleCounting;
    os << YAML::Key << "earlyFragmentSampleMaskTestBeforeSampleCounting";
    // earlyFragmentSampleMaskTestBeforeSampleCounting -> Field -> VkBool32
    os << YAML::Value << t.earlyFragmentSampleMaskTestBeforeSampleCounting;
    os << YAML::Key << "depthStencilSwizzleOneSupport";
    // depthStencilSwizzleOneSupport -> Field -> VkBool32
    os << YAML::Value << t.depthStencilSwizzleOneSupport;
    os << YAML::Key << "polygonModePointSize";
    // polygonModePointSize -> Field -> VkBool32
    os << YAML::Value << t.polygonModePointSize;
    os << YAML::Key << "nonStrictSinglePixelWideLinesUseParallelogram";
    // nonStrictSinglePixelWideLinesUseParallelogram -> Field -> VkBool32
    os << YAML::Value << t.nonStrictSinglePixelWideLinesUseParallelogram;
    os << YAML::Key << "nonStrictWideLinesUseParallelogram";
    // nonStrictWideLinesUseParallelogram -> Field -> VkBool32
    os << YAML::Value << t.nonStrictWideLinesUseParallelogram;
    os << YAML::Key << "blockTexelViewCompatibleMultipleLayers";
    // blockTexelViewCompatibleMultipleLayers -> Field -> VkBool32
    os << YAML::Value << t.blockTexelViewCompatibleMultipleLayers;
    os << YAML::Key << "maxCombinedImageSamplerDescriptorCount";
    // maxCombinedImageSamplerDescriptorCount -> Field -> uint32_t
    os << YAML::Value << t.maxCombinedImageSamplerDescriptorCount;
    os << YAML::Key << "fragmentShadingRateClampCombinerInputs";
    // fragmentShadingRateClampCombinerInputs -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateClampCombinerInputs;
    os << YAML::Key << "defaultRobustnessStorageBuffers";
    // defaultRobustnessStorageBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessStorageBuffers;
    os << YAML::Key << "defaultRobustnessUniformBuffers";
    // defaultRobustnessUniformBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessUniformBuffers;
    os << YAML::Key << "defaultRobustnessVertexInputs";
    // defaultRobustnessVertexInputs -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessVertexInputs;
    os << YAML::Key << "defaultRobustnessImages";
    // defaultRobustnessImages -> Field -> VkPipelineRobustnessImageBehavior
    os << YAML::Value << t.defaultRobustnessImages;
    os << YAML::Key << "copySrcLayoutCount";
    // copySrcLayoutCount -> Field -> uint32_t
    os << YAML::Value << t.copySrcLayoutCount;
    os << YAML::Key << "pCopySrcLayouts";
    // pCopySrcLayouts -> Field -> DynamicArray(VkImageLayout)
    if (t.copySrcLayoutCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.copySrcLayoutCount); ++i) {
                os << t.pCopySrcLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "copyDstLayoutCount";
    // copyDstLayoutCount -> Field -> uint32_t
    os << YAML::Value << t.copyDstLayoutCount;
    os << YAML::Key << "pCopyDstLayouts";
    // pCopyDstLayouts -> Field -> DynamicArray(VkImageLayout)
    if (t.copyDstLayoutCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.copyDstLayoutCount); ++i) {
                os << t.pCopyDstLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "optimalTilingLayoutUUID";
    // optimalTilingLayoutUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.optimalTilingLayoutUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "identicalMemoryTypeRequirements";
    // identicalMemoryTypeRequirements -> Field -> VkBool32
    os << YAML::Value << t.identicalMemoryTypeRequirements;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceQueueGlobalPriorityCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "globalPriority";
    // globalPriority -> Field -> VkQueueGlobalPriority
    os << YAML::Value << t.globalPriority;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceGlobalPriorityQueryFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "globalPriorityQuery";
    // globalPriorityQuery -> Field -> VkBool32
    os << YAML::Value << t.globalPriorityQuery;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyGlobalPriorityProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "priorityCount";
    // priorityCount -> Field -> uint32_t
    os << YAML::Value << t.priorityCount;
    os << YAML::Key << "priorities";
    // priorities -> Field -> DynamicArray(VkQueueGlobalPriority)
    if (t.priorityCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkQueueGlobalPriority");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.priorityCount); ++i) {
                os << t.priorities[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceIndexTypeUint8Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "indexTypeUint8";
    // indexTypeUint8 -> Field -> VkBool32
    os << YAML::Value << t.indexTypeUint8;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryMapInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMemoryMapFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryUnmapInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMemoryUnmapFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance5Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance5";
    // maintenance5 -> Field -> VkBool32
    os << YAML::Value << t.maintenance5;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance5Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "earlyFragmentMultisampleCoverageAfterSampleCounting";
    // earlyFragmentMultisampleCoverageAfterSampleCounting -> Field -> VkBool32
    os << YAML::Value << t.earlyFragmentMultisampleCoverageAfterSampleCounting;
    os << YAML::Key << "earlyFragmentSampleMaskTestBeforeSampleCounting";
    // earlyFragmentSampleMaskTestBeforeSampleCounting -> Field -> VkBool32
    os << YAML::Value << t.earlyFragmentSampleMaskTestBeforeSampleCounting;
    os << YAML::Key << "depthStencilSwizzleOneSupport";
    // depthStencilSwizzleOneSupport -> Field -> VkBool32
    os << YAML::Value << t.depthStencilSwizzleOneSupport;
    os << YAML::Key << "polygonModePointSize";
    // polygonModePointSize -> Field -> VkBool32
    os << YAML::Value << t.polygonModePointSize;
    os << YAML::Key << "nonStrictSinglePixelWideLinesUseParallelogram";
    // nonStrictSinglePixelWideLinesUseParallelogram -> Field -> VkBool32
    os << YAML::Value << t.nonStrictSinglePixelWideLinesUseParallelogram;
    os << YAML::Key << "nonStrictWideLinesUseParallelogram";
    // nonStrictWideLinesUseParallelogram -> Field -> VkBool32
    os << YAML::Value << t.nonStrictWideLinesUseParallelogram;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSubresource2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresource
    os << YAML::Value << t.imageSubresource;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceImageSubresourceInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pCreateInfo";
    // pointer
    if (t.pCreateInfo != nullptr) {
        os << YAML::Value << *t.pCreateInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pSubresource";
    // pointer
    if (t.pSubresource != nullptr) {
        os << YAML::Value << *t.pSubresource;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubresourceLayout2 &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subresourceLayout";
    // subresourceLayout -> Field -> VkSubresourceLayout
    os << YAML::Value << t.subresourceLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferUsageFlags2CreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "usage";
    // usage -> Field -> VkBufferUsageFlags2
    os << YAML::Value << t.usage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance6Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance6";
    // maintenance6 -> Field -> VkBool32
    os << YAML::Value << t.maintenance6;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance6Properties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "blockTexelViewCompatibleMultipleLayers";
    // blockTexelViewCompatibleMultipleLayers -> Field -> VkBool32
    os << YAML::Value << t.blockTexelViewCompatibleMultipleLayers;
    os << YAML::Key << "maxCombinedImageSamplerDescriptorCount";
    // maxCombinedImageSamplerDescriptorCount -> Field -> uint32_t
    os << YAML::Value << t.maxCombinedImageSamplerDescriptorCount;
    os << YAML::Key << "fragmentShadingRateClampCombinerInputs";
    // fragmentShadingRateClampCombinerInputs -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateClampCombinerInputs;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindMemoryStatus &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pResult";
    // pointer
    if (t.pResult != nullptr) {
        os << YAML::Value << *t.pResult;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceHostImageCopyFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hostImageCopy";
    // hostImageCopy -> Field -> VkBool32
    os << YAML::Value << t.hostImageCopy;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceHostImageCopyProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "copySrcLayoutCount";
    // copySrcLayoutCount -> Field -> uint32_t
    os << YAML::Value << t.copySrcLayoutCount;
    os << YAML::Key << "pCopySrcLayouts";
    // pCopySrcLayouts -> Field -> DynamicArray(VkImageLayout)
    if (t.copySrcLayoutCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.copySrcLayoutCount); ++i) {
                os << t.pCopySrcLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "copyDstLayoutCount";
    // copyDstLayoutCount -> Field -> uint32_t
    os << YAML::Value << t.copyDstLayoutCount;
    os << YAML::Key << "pCopyDstLayouts";
    // pCopyDstLayouts -> Field -> DynamicArray(VkImageLayout)
    if (t.copyDstLayoutCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.copyDstLayoutCount); ++i) {
                os << t.pCopyDstLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "optimalTilingLayoutUUID";
    // optimalTilingLayoutUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.optimalTilingLayoutUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "identicalMemoryTypeRequirements";
    // identicalMemoryTypeRequirements -> Field -> VkBool32
    os << YAML::Value << t.identicalMemoryTypeRequirements;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryToImageCopy &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pHostPointer";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::Key << "memoryRowLength";
    // memoryRowLength -> Field -> uint32_t
    os << YAML::Value << t.memoryRowLength;
    os << YAML::Key << "memoryImageHeight";
    // memoryImageHeight -> Field -> uint32_t
    os << YAML::Value << t.memoryImageHeight;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.imageSubresource;
    os << YAML::Key << "imageOffset";
    // imageOffset -> Field -> VkOffset3D
    os << YAML::Value << t.imageOffset;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent3D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageToMemoryCopy &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pHostPointer";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::Key << "memoryRowLength";
    // memoryRowLength -> Field -> uint32_t
    os << YAML::Value << t.memoryRowLength;
    os << YAML::Key << "memoryImageHeight";
    // memoryImageHeight -> Field -> uint32_t
    os << YAML::Value << t.memoryImageHeight;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.imageSubresource;
    os << YAML::Key << "imageOffset";
    // imageOffset -> Field -> VkOffset3D
    os << YAML::Value << t.imageOffset;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent3D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyMemoryToImageInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkHostImageCopyFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkMemoryToImageCopy)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkMemoryToImageCopy");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyImageToMemoryInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkHostImageCopyFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkImageToMemoryCopy)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageToMemoryCopy");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyImageToImageInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkHostImageCopyFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "srcImage";
    // srcImage -> Field -> VkImage
    os << YAML::Value << t.srcImage;
    os << YAML::Key << "srcImageLayout";
    // srcImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.srcImageLayout;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "regionCount";
    // regionCount -> Field -> uint32_t
    os << YAML::Value << t.regionCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkImageCopy2)
    if (t.regionCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageCopy2");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.regionCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHostImageLayoutTransitionInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "oldLayout";
    // oldLayout -> Field -> VkImageLayout
    os << YAML::Value << t.oldLayout;
    os << YAML::Key << "newLayout";
    // newLayout -> Field -> VkImageLayout
    os << YAML::Value << t.newLayout;
    os << YAML::Key << "subresourceRange";
    // subresourceRange -> Field -> VkImageSubresourceRange
    os << YAML::Value << t.subresourceRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubresourceHostMemcpySize &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHostImageCopyDevicePerformanceQuery &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "optimalDeviceAccess";
    // optimalDeviceAccess -> Field -> VkBool32
    os << YAML::Value << t.optimalDeviceAccess;
    os << YAML::Key << "identicalMemoryLayout";
    // identicalMemoryLayout -> Field -> VkBool32
    os << YAML::Value << t.identicalMemoryLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderSubgroupRotateFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSubgroupRotate";
    // shaderSubgroupRotate -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupRotate;
    os << YAML::Key << "shaderSubgroupRotateClustered";
    // shaderSubgroupRotateClustered -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupRotateClustered;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderFloatControls2Features &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderFloatControls2";
    // shaderFloatControls2 -> Field -> VkBool32
    os << YAML::Value << t.shaderFloatControls2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderExpectAssumeFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderExpectAssume";
    // shaderExpectAssume -> Field -> VkBool32
    os << YAML::Value << t.shaderExpectAssume;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCreateFlags2CreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreateFlags2
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePushDescriptorProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxPushDescriptors";
    // maxPushDescriptors -> Field -> uint32_t
    os << YAML::Value << t.maxPushDescriptors;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindDescriptorSetsInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "firstSet";
    // firstSet -> Field -> uint32_t
    os << YAML::Value << t.firstSet;
    os << YAML::Key << "descriptorSetCount";
    // descriptorSetCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorSetCount;
    os << YAML::Key << "pDescriptorSets";
    // pDescriptorSets -> Field -> ConstDynamicArray(VkDescriptorSet)
    if (t.descriptorSetCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorSet");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorSetCount); ++i) {
                os << t.pDescriptorSets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "dynamicOffsetCount";
    // dynamicOffsetCount -> Field -> uint32_t
    os << YAML::Value << t.dynamicOffsetCount;
    os << YAML::Key << "pDynamicOffsets";
    // pDynamicOffsets -> Field -> ConstDynamicArray(uint32_t)
    if (t.dynamicOffsetCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.dynamicOffsetCount); ++i) {
                os << t.pDynamicOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPushConstantsInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "size";
    // size -> Field -> uint32_t
    os << YAML::Value << t.size;
    os << YAML::Key << "pValues";
    if (t.size == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pValues;
            for (uint64_t i = 0; i < t.size; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPushDescriptorSetInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "set";
    // set -> Field -> uint32_t
    os << YAML::Value << t.set;
    os << YAML::Key << "descriptorWriteCount";
    // descriptorWriteCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorWriteCount;
    os << YAML::Key << "pDescriptorWrites";
    // pDescriptorWrites -> Field -> ConstDynamicArray(VkWriteDescriptorSet)
    if (t.descriptorWriteCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkWriteDescriptorSet");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorWriteCount); ++i) {
                os << t.pDescriptorWrites[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPushDescriptorSetWithTemplateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorUpdateTemplate";
    // descriptorUpdateTemplate -> Field -> VkDescriptorUpdateTemplate
    os << YAML::Value << t.descriptorUpdateTemplate;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "set";
    // set -> Field -> uint32_t
    os << YAML::Value << t.set;
    os << YAML::Key << "pData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineProtectedAccessFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineProtectedAccess";
    // pipelineProtectedAccess -> Field -> VkBool32
    os << YAML::Value << t.pipelineProtectedAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineRobustnessFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineRobustness";
    // pipelineRobustness -> Field -> VkBool32
    os << YAML::Value << t.pipelineRobustness;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineRobustnessProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "defaultRobustnessStorageBuffers";
    // defaultRobustnessStorageBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessStorageBuffers;
    os << YAML::Key << "defaultRobustnessUniformBuffers";
    // defaultRobustnessUniformBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessUniformBuffers;
    os << YAML::Key << "defaultRobustnessVertexInputs";
    // defaultRobustnessVertexInputs -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.defaultRobustnessVertexInputs;
    os << YAML::Key << "defaultRobustnessImages";
    // defaultRobustnessImages -> Field -> VkPipelineRobustnessImageBehavior
    os << YAML::Value << t.defaultRobustnessImages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRobustnessCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "storageBuffers";
    // storageBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.storageBuffers;
    os << YAML::Key << "uniformBuffers";
    // uniformBuffers -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.uniformBuffers;
    os << YAML::Key << "vertexInputs";
    // vertexInputs -> Field -> VkPipelineRobustnessBufferBehavior
    os << YAML::Value << t.vertexInputs;
    os << YAML::Key << "images";
    // images -> Field -> VkPipelineRobustnessImageBehavior
    os << YAML::Value << t.images;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLineRasterizationFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rectangularLines";
    // rectangularLines -> Field -> VkBool32
    os << YAML::Value << t.rectangularLines;
    os << YAML::Key << "bresenhamLines";
    // bresenhamLines -> Field -> VkBool32
    os << YAML::Value << t.bresenhamLines;
    os << YAML::Key << "smoothLines";
    // smoothLines -> Field -> VkBool32
    os << YAML::Value << t.smoothLines;
    os << YAML::Key << "stippledRectangularLines";
    // stippledRectangularLines -> Field -> VkBool32
    os << YAML::Value << t.stippledRectangularLines;
    os << YAML::Key << "stippledBresenhamLines";
    // stippledBresenhamLines -> Field -> VkBool32
    os << YAML::Value << t.stippledBresenhamLines;
    os << YAML::Key << "stippledSmoothLines";
    // stippledSmoothLines -> Field -> VkBool32
    os << YAML::Value << t.stippledSmoothLines;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLineRasterizationProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "lineSubPixelPrecisionBits";
    // lineSubPixelPrecisionBits -> Field -> uint32_t
    os << YAML::Value << t.lineSubPixelPrecisionBits;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationLineStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "lineRasterizationMode";
    // lineRasterizationMode -> Field -> VkLineRasterizationMode
    os << YAML::Value << t.lineRasterizationMode;
    os << YAML::Key << "stippledLineEnable";
    // stippledLineEnable -> Field -> VkBool32
    os << YAML::Value << t.stippledLineEnable;
    os << YAML::Key << "lineStippleFactor";
    // lineStippleFactor -> Field -> uint32_t
    os << YAML::Value << t.lineStippleFactor;
    os << YAML::Key << "lineStipplePattern";
    // lineStipplePattern -> Field -> uint16_t
    os << YAML::Value << t.lineStipplePattern;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVertexAttributeDivisorProperties &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxVertexAttribDivisor";
    // maxVertexAttribDivisor -> Field -> uint32_t
    os << YAML::Value << t.maxVertexAttribDivisor;
    os << YAML::Key << "supportsNonZeroFirstInstance";
    // supportsNonZeroFirstInstance -> Field -> VkBool32
    os << YAML::Value << t.supportsNonZeroFirstInstance;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVertexInputBindingDivisorDescription &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "divisor";
    // divisor -> Field -> uint32_t
    os << YAML::Value << t.divisor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineVertexInputDivisorStateCreateInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vertexBindingDivisorCount";
    // vertexBindingDivisorCount -> Field -> uint32_t
    os << YAML::Value << t.vertexBindingDivisorCount;
    os << YAML::Key << "pVertexBindingDivisors";
    // pVertexBindingDivisors -> Field -> ConstDynamicArray(VkVertexInputBindingDivisorDescription)
    if (t.vertexBindingDivisorCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVertexInputBindingDivisorDescription");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.vertexBindingDivisorCount); ++i) {
                os << t.pVertexBindingDivisors[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVertexAttributeDivisorFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vertexAttributeInstanceRateDivisor";
    // vertexAttributeInstanceRateDivisor -> Field -> VkBool32
    os << YAML::Value << t.vertexAttributeInstanceRateDivisor;
    os << YAML::Key << "vertexAttributeInstanceRateZeroDivisor";
    // vertexAttributeInstanceRateZeroDivisor -> Field -> VkBool32
    os << YAML::Value << t.vertexAttributeInstanceRateZeroDivisor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingAreaInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "viewMask";
    // viewMask -> Field -> uint32_t
    os << YAML::Value << t.viewMask;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentFormats";
    // pColorAttachmentFormats -> Field -> ConstDynamicArray(VkFormat)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFormat");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentFormats[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "depthAttachmentFormat";
    // depthAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.depthAttachmentFormat;
    os << YAML::Key << "stencilAttachmentFormat";
    // stencilAttachmentFormat -> Field -> VkFormat
    os << YAML::Value << t.stencilAttachmentFormat;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDynamicRenderingLocalReadFeatures &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dynamicRenderingLocalRead";
    // dynamicRenderingLocalRead -> Field -> VkBool32
    os << YAML::Value << t.dynamicRenderingLocalRead;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingAttachmentLocationInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentLocations";
    // pColorAttachmentLocations -> Field -> ConstDynamicArray(uint32_t)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentLocations[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingInputAttachmentIndexInfo &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentInputIndices";
    // pColorAttachmentInputIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentInputIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pDepthInputAttachmentIndex";
    // pointer
    if (t.pDepthInputAttachmentIndex != nullptr) {
        os << YAML::Value << *t.pDepthInputAttachmentIndex;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pStencilInputAttachmentIndex";
    // pointer
    if (t.pStencilInputAttachmentIndex != nullptr) {
        os << YAML::Value << *t.pStencilInputAttachmentIndex;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "minImageCount";
    // minImageCount -> Field -> uint32_t
    os << YAML::Value << t.minImageCount;
    os << YAML::Key << "maxImageCount";
    // maxImageCount -> Field -> uint32_t
    os << YAML::Value << t.maxImageCount;
    os << YAML::Key << "currentExtent";
    // currentExtent -> Field -> VkExtent2D
    os << YAML::Value << t.currentExtent;
    os << YAML::Key << "minImageExtent";
    // minImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minImageExtent;
    os << YAML::Key << "maxImageExtent";
    // maxImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxImageExtent;
    os << YAML::Key << "maxImageArrayLayers";
    // maxImageArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.maxImageArrayLayers;
    os << YAML::Key << "supportedTransforms";
    // supportedTransforms -> Field -> VkSurfaceTransformFlagsKHR
    os << YAML::Value << t.supportedTransforms;
    os << YAML::Key << "currentTransform";
    // currentTransform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.currentTransform;
    os << YAML::Key << "supportedCompositeAlpha";
    // supportedCompositeAlpha -> Field -> VkCompositeAlphaFlagsKHR
    os << YAML::Value << t.supportedCompositeAlpha;
    os << YAML::Key << "supportedUsageFlags";
    // supportedUsageFlags -> Field -> VkImageUsageFlags
    os << YAML::Value << t.supportedUsageFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceFormatKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "colorSpace";
    // colorSpace -> Field -> VkColorSpaceKHR
    os << YAML::Value << t.colorSpace;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSwapchainCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "surface";
    // surface -> Field -> VkSurfaceKHR
    os << YAML::Value << t.surface;
    os << YAML::Key << "minImageCount";
    // minImageCount -> Field -> uint32_t
    os << YAML::Value << t.minImageCount;
    os << YAML::Key << "imageFormat";
    // imageFormat -> Field -> VkFormat
    os << YAML::Value << t.imageFormat;
    os << YAML::Key << "imageColorSpace";
    // imageColorSpace -> Field -> VkColorSpaceKHR
    os << YAML::Value << t.imageColorSpace;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.imageExtent;
    os << YAML::Key << "imageArrayLayers";
    // imageArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.imageArrayLayers;
    os << YAML::Key << "imageUsage";
    // imageUsage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.imageUsage;
    os << YAML::Key << "imageSharingMode";
    // imageSharingMode -> Field -> VkSharingMode
    os << YAML::Value << t.imageSharingMode;
    os << YAML::Key << "queueFamilyIndexCount";
    // queueFamilyIndexCount -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndexCount;
    os << YAML::Key << "pQueueFamilyIndices";
    // pQueueFamilyIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.queueFamilyIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueFamilyIndexCount); ++i) {
                os << t.pQueueFamilyIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "preTransform";
    // preTransform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.preTransform;
    os << YAML::Key << "compositeAlpha";
    // compositeAlpha -> Field -> VkCompositeAlphaFlagBitsKHR
    os << YAML::Value << t.compositeAlpha;
    os << YAML::Key << "presentMode";
    // presentMode -> Field -> VkPresentModeKHR
    os << YAML::Value << t.presentMode;
    os << YAML::Key << "clipped";
    // clipped -> Field -> VkBool32
    os << YAML::Value << t.clipped;
    os << YAML::Key << "oldSwapchain";
    // oldSwapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.oldSwapchain;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreCount";
    // waitSemaphoreCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreCount;
    os << YAML::Key << "pWaitSemaphores";
    // pWaitSemaphores -> Field -> ConstDynamicArray(VkSemaphore)
    if (t.waitSemaphoreCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSemaphore");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreCount); ++i) {
                os << t.pWaitSemaphores[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pSwapchains";
    // pSwapchains -> Field -> ConstDynamicArray(VkSwapchainKHR)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSwapchainKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pSwapchains[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pImageIndices";
    // pImageIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pImageIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pResults";
    // pResults -> Field -> DynamicArray(VkResult)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkResult");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pResults[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageSwapchainCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindImageMemorySwapchainInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::Key << "imageIndex";
    // imageIndex -> Field -> uint32_t
    os << YAML::Value << t.imageIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAcquireNextImageInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::Key << "timeout";
    // timeout -> Field -> uint64_t
    os << YAML::Value << t.timeout;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "fence";
    // fence -> Field -> VkFence
    os << YAML::Value << t.fence;
    os << YAML::Key << "deviceMask";
    // deviceMask -> Field -> uint32_t
    os << YAML::Value << t.deviceMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupPresentCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentMask";
    // presentMask -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_DEVICE_GROUP_SIZE); ++i) {
                os << t.presentMask[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "modes";
    // modes -> Field -> VkDeviceGroupPresentModeFlagsKHR
    os << YAML::Value << t.modes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupPresentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pDeviceMasks";
    // pDeviceMasks -> Field -> ConstDynamicArray(uint32_t)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pDeviceMasks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "mode";
    // mode -> Field -> VkDeviceGroupPresentModeFlagBitsKHR
    os << YAML::Value << t.mode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceGroupSwapchainCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "modes";
    // modes -> Field -> VkDeviceGroupPresentModeFlagsKHR
    os << YAML::Value << t.modes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayModeParametersKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "visibleRegion";
    // visibleRegion -> Field -> VkExtent2D
    os << YAML::Value << t.visibleRegion;
    os << YAML::Key << "refreshRate";
    // refreshRate -> Field -> uint32_t
    os << YAML::Value << t.refreshRate;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayModeCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDisplayModeCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "parameters";
    // parameters -> Field -> VkDisplayModeParametersKHR
    os << YAML::Value << t.parameters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayModePropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "displayMode";
    // displayMode -> Field -> VkDisplayModeKHR
    os << YAML::Value << t.displayMode;
    os << YAML::Key << "parameters";
    // parameters -> Field -> VkDisplayModeParametersKHR
    os << YAML::Value << t.parameters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPlaneCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "supportedAlpha";
    // supportedAlpha -> Field -> VkDisplayPlaneAlphaFlagsKHR
    os << YAML::Value << t.supportedAlpha;
    os << YAML::Key << "minSrcPosition";
    // minSrcPosition -> Field -> VkOffset2D
    os << YAML::Value << t.minSrcPosition;
    os << YAML::Key << "maxSrcPosition";
    // maxSrcPosition -> Field -> VkOffset2D
    os << YAML::Value << t.maxSrcPosition;
    os << YAML::Key << "minSrcExtent";
    // minSrcExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minSrcExtent;
    os << YAML::Key << "maxSrcExtent";
    // maxSrcExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxSrcExtent;
    os << YAML::Key << "minDstPosition";
    // minDstPosition -> Field -> VkOffset2D
    os << YAML::Value << t.minDstPosition;
    os << YAML::Key << "maxDstPosition";
    // maxDstPosition -> Field -> VkOffset2D
    os << YAML::Value << t.maxDstPosition;
    os << YAML::Key << "minDstExtent";
    // minDstExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minDstExtent;
    os << YAML::Key << "maxDstExtent";
    // maxDstExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxDstExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPlanePropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "currentDisplay";
    // currentDisplay -> Field -> VkDisplayKHR
    os << YAML::Value << t.currentDisplay;
    os << YAML::Key << "currentStackIndex";
    // currentStackIndex -> Field -> uint32_t
    os << YAML::Value << t.currentStackIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "display";
    // display -> Field -> VkDisplayKHR
    os << YAML::Value << t.display;
    os << YAML::Key << "displayName";
    // displayName -> Field -> string
    os << YAML::Value << t.displayName;
    os << YAML::Key << "physicalDimensions";
    // physicalDimensions -> Field -> VkExtent2D
    os << YAML::Value << t.physicalDimensions;
    os << YAML::Key << "physicalResolution";
    // physicalResolution -> Field -> VkExtent2D
    os << YAML::Value << t.physicalResolution;
    os << YAML::Key << "supportedTransforms";
    // supportedTransforms -> Field -> VkSurfaceTransformFlagsKHR
    os << YAML::Value << t.supportedTransforms;
    os << YAML::Key << "planeReorderPossible";
    // planeReorderPossible -> Field -> VkBool32
    os << YAML::Value << t.planeReorderPossible;
    os << YAML::Key << "persistentContent";
    // persistentContent -> Field -> VkBool32
    os << YAML::Value << t.persistentContent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplaySurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDisplaySurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "displayMode";
    // displayMode -> Field -> VkDisplayModeKHR
    os << YAML::Value << t.displayMode;
    os << YAML::Key << "planeIndex";
    // planeIndex -> Field -> uint32_t
    os << YAML::Value << t.planeIndex;
    os << YAML::Key << "planeStackIndex";
    // planeStackIndex -> Field -> uint32_t
    os << YAML::Value << t.planeStackIndex;
    os << YAML::Key << "transform";
    // transform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.transform;
    os << YAML::Key << "globalAlpha";
    // globalAlpha -> Field -> float
    os << YAML::Value << t.globalAlpha;
    os << YAML::Key << "alphaMode";
    // alphaMode -> Field -> VkDisplayPlaneAlphaFlagBitsKHR
    os << YAML::Value << t.alphaMode;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPresentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcRect";
    // srcRect -> Field -> VkRect2D
    os << YAML::Value << t.srcRect;
    os << YAML::Key << "dstRect";
    // dstRect -> Field -> VkRect2D
    os << YAML::Value << t.dstRect;
    os << YAML::Key << "persistent";
    // persistent -> Field -> VkBool32
    os << YAML::Value << t.persistent;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_XLIB_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkXlibSurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkXlibSurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "dpy";
    // non-dereferenced pointer
    os << YAML::Value << t.dpy;
    os << YAML::Key << "window";
    // window -> Field -> Window
    os << YAML::Value << t.window;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_XLIB_KHR

#ifdef VK_USE_PLATFORM_XCB_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkXcbSurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkXcbSurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "connection";
    // non-dereferenced pointer
    os << YAML::Value << t.connection;
    os << YAML::Key << "window";
    // window -> Field -> xcb_window_t
    os << YAML::Value << t.window;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_XCB_KHR

#ifdef VK_USE_PLATFORM_WAYLAND_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkWaylandSurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkWaylandSurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "display";
    // non-dereferenced pointer
    os << YAML::Value << t.display;
    os << YAML::Key << "surface";
    // non-dereferenced pointer
    os << YAML::Value << t.surface;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WAYLAND_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkAndroidSurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAndroidSurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "window";
    // non-dereferenced pointer
    os << YAML::Value << t.window;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkWin32SurfaceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkWin32SurfaceCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "hinstance";
    // hinstance -> Field -> HINSTANCE
    os << YAML::Value << t.hinstance;
    os << YAML::Key << "hwnd";
    // hwnd -> Field -> HWND
    os << YAML::Value << t.hwnd;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyQueryResultStatusPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queryResultStatusSupport";
    // queryResultStatusSupport -> Field -> VkBool32
    os << YAML::Value << t.queryResultStatusSupport;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyVideoPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoCodecOperations";
    // videoCodecOperations -> Field -> VkVideoCodecOperationFlagsKHR
    os << YAML::Value << t.videoCodecOperations;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoCodecOperation";
    // videoCodecOperation -> Field -> VkVideoCodecOperationFlagBitsKHR
    os << YAML::Value << t.videoCodecOperation;
    os << YAML::Key << "chromaSubsampling";
    // chromaSubsampling -> Field -> VkVideoChromaSubsamplingFlagsKHR
    os << YAML::Value << t.chromaSubsampling;
    os << YAML::Key << "lumaBitDepth";
    // lumaBitDepth -> Field -> VkVideoComponentBitDepthFlagsKHR
    os << YAML::Value << t.lumaBitDepth;
    os << YAML::Key << "chromaBitDepth";
    // chromaBitDepth -> Field -> VkVideoComponentBitDepthFlagsKHR
    os << YAML::Value << t.chromaBitDepth;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoProfileListInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "profileCount";
    // profileCount -> Field -> uint32_t
    os << YAML::Value << t.profileCount;
    os << YAML::Key << "pProfiles";
    // pProfiles -> Field -> ConstDynamicArray(VkVideoProfileInfoKHR)
    if (t.profileCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoProfileInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.profileCount); ++i) {
                os << t.pProfiles[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoCapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "minBitstreamBufferOffsetAlignment";
    // minBitstreamBufferOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minBitstreamBufferOffsetAlignment;
    os << YAML::Key << "minBitstreamBufferSizeAlignment";
    // minBitstreamBufferSizeAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minBitstreamBufferSizeAlignment;
    os << YAML::Key << "pictureAccessGranularity";
    // pictureAccessGranularity -> Field -> VkExtent2D
    os << YAML::Value << t.pictureAccessGranularity;
    os << YAML::Key << "minCodedExtent";
    // minCodedExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minCodedExtent;
    os << YAML::Key << "maxCodedExtent";
    // maxCodedExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxCodedExtent;
    os << YAML::Key << "maxDpbSlots";
    // maxDpbSlots -> Field -> uint32_t
    os << YAML::Value << t.maxDpbSlots;
    os << YAML::Key << "maxActiveReferencePictures";
    // maxActiveReferencePictures -> Field -> uint32_t
    os << YAML::Value << t.maxActiveReferencePictures;
    os << YAML::Key << "stdHeaderVersion";
    // stdHeaderVersion -> Field -> VkExtensionProperties
    os << YAML::Value << t.stdHeaderVersion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoFormatInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageUsage";
    // imageUsage -> Field -> VkImageUsageFlags
    os << YAML::Value << t.imageUsage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoFormatPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "componentMapping";
    // componentMapping -> Field -> VkComponentMapping
    os << YAML::Value << t.componentMapping;
    os << YAML::Key << "imageCreateFlags";
    // imageCreateFlags -> Field -> VkImageCreateFlags
    os << YAML::Value << t.imageCreateFlags;
    os << YAML::Key << "imageType";
    // imageType -> Field -> VkImageType
    os << YAML::Value << t.imageType;
    os << YAML::Key << "imageTiling";
    // imageTiling -> Field -> VkImageTiling
    os << YAML::Value << t.imageTiling;
    os << YAML::Key << "imageUsageFlags";
    // imageUsageFlags -> Field -> VkImageUsageFlags
    os << YAML::Value << t.imageUsageFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoPictureResourceInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "codedOffset";
    // codedOffset -> Field -> VkOffset2D
    os << YAML::Value << t.codedOffset;
    os << YAML::Key << "codedExtent";
    // codedExtent -> Field -> VkExtent2D
    os << YAML::Value << t.codedExtent;
    os << YAML::Key << "baseArrayLayer";
    // baseArrayLayer -> Field -> uint32_t
    os << YAML::Value << t.baseArrayLayer;
    os << YAML::Key << "imageViewBinding";
    // imageViewBinding -> Field -> VkImageView
    os << YAML::Value << t.imageViewBinding;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoReferenceSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "slotIndex";
    // slotIndex -> Field -> int32_t
    os << YAML::Value << t.slotIndex;
    os << YAML::Key << "pPictureResource";
    // pointer
    if (t.pPictureResource != nullptr) {
        os << YAML::Value << *t.pPictureResource;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoSessionMemoryRequirementsKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryBindIndex";
    // memoryBindIndex -> Field -> uint32_t
    os << YAML::Value << t.memoryBindIndex;
    os << YAML::Key << "memoryRequirements";
    // memoryRequirements -> Field -> VkMemoryRequirements
    os << YAML::Value << t.memoryRequirements;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindVideoSessionMemoryInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryBindIndex";
    // memoryBindIndex -> Field -> uint32_t
    os << YAML::Value << t.memoryBindIndex;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::Key << "memorySize";
    // memorySize -> Field -> VkDeviceSize
    os << YAML::Value << t.memorySize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoSessionCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queueFamilyIndex";
    // queueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndex;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoSessionCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "pVideoProfile";
    // pointer
    if (t.pVideoProfile != nullptr) {
        os << YAML::Value << *t.pVideoProfile;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pictureFormat";
    // pictureFormat -> Field -> VkFormat
    os << YAML::Value << t.pictureFormat;
    os << YAML::Key << "maxCodedExtent";
    // maxCodedExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxCodedExtent;
    os << YAML::Key << "referencePictureFormat";
    // referencePictureFormat -> Field -> VkFormat
    os << YAML::Value << t.referencePictureFormat;
    os << YAML::Key << "maxDpbSlots";
    // maxDpbSlots -> Field -> uint32_t
    os << YAML::Value << t.maxDpbSlots;
    os << YAML::Key << "maxActiveReferencePictures";
    // maxActiveReferencePictures -> Field -> uint32_t
    os << YAML::Value << t.maxActiveReferencePictures;
    os << YAML::Key << "pStdHeaderVersion";
    // pointer
    if (t.pStdHeaderVersion != nullptr) {
        os << YAML::Value << *t.pStdHeaderVersion;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoSessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoSessionParametersCreateFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "videoSessionParametersTemplate";
    // videoSessionParametersTemplate -> Field -> VkVideoSessionParametersKHR
    os << YAML::Value << t.videoSessionParametersTemplate;
    os << YAML::Key << "videoSession";
    // videoSession -> Field -> VkVideoSessionKHR
    os << YAML::Value << t.videoSession;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoSessionParametersUpdateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "updateSequenceCount";
    // updateSequenceCount -> Field -> uint32_t
    os << YAML::Value << t.updateSequenceCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoBeginCodingInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoBeginCodingFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "videoSession";
    // videoSession -> Field -> VkVideoSessionKHR
    os << YAML::Value << t.videoSession;
    os << YAML::Key << "videoSessionParameters";
    // videoSessionParameters -> Field -> VkVideoSessionParametersKHR
    os << YAML::Value << t.videoSessionParameters;
    os << YAML::Key << "referenceSlotCount";
    // referenceSlotCount -> Field -> uint32_t
    os << YAML::Value << t.referenceSlotCount;
    os << YAML::Key << "pReferenceSlots";
    // pReferenceSlots -> Field -> ConstDynamicArray(VkVideoReferenceSlotInfoKHR)
    if (t.referenceSlotCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoReferenceSlotInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.referenceSlotCount); ++i) {
                os << t.pReferenceSlots[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEndCodingInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEndCodingFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoCodingControlInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoCodingControlFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoDecodeCapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeUsageInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoUsageHints";
    // videoUsageHints -> Field -> VkVideoDecodeUsageFlagsKHR
    os << YAML::Value << t.videoUsageHints;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoDecodeFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "srcBuffer";
    // srcBuffer -> Field -> VkBuffer
    os << YAML::Value << t.srcBuffer;
    os << YAML::Key << "srcBufferOffset";
    // srcBufferOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.srcBufferOffset;
    os << YAML::Key << "srcBufferRange";
    // srcBufferRange -> Field -> VkDeviceSize
    os << YAML::Value << t.srcBufferRange;
    os << YAML::Key << "dstPictureResource";
    // dstPictureResource -> Field -> VkVideoPictureResourceInfoKHR
    os << YAML::Value << t.dstPictureResource;
    os << YAML::Key << "pSetupReferenceSlot";
    // pointer
    if (t.pSetupReferenceSlot != nullptr) {
        os << YAML::Value << *t.pSetupReferenceSlot;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "referenceSlotCount";
    // referenceSlotCount -> Field -> uint32_t
    os << YAML::Value << t.referenceSlotCount;
    os << YAML::Key << "pReferenceSlots";
    // pReferenceSlots -> Field -> ConstDynamicArray(VkVideoReferenceSlotInfoKHR)
    if (t.referenceSlotCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoReferenceSlotInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.referenceSlotCount); ++i) {
                os << t.pReferenceSlots[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeH264CapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH264LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::Key << "maxSliceCount";
    // maxSliceCount -> Field -> uint32_t
    os << YAML::Value << t.maxSliceCount;
    os << YAML::Key << "maxPPictureL0ReferenceCount";
    // maxPPictureL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxPPictureL0ReferenceCount;
    os << YAML::Key << "maxBPictureL0ReferenceCount";
    // maxBPictureL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxBPictureL0ReferenceCount;
    os << YAML::Key << "maxL1ReferenceCount";
    // maxL1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxL1ReferenceCount;
    os << YAML::Key << "maxTemporalLayerCount";
    // maxTemporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.maxTemporalLayerCount;
    os << YAML::Key << "expectDyadicTemporalLayerPattern";
    // expectDyadicTemporalLayerPattern -> Field -> VkBool32
    os << YAML::Value << t.expectDyadicTemporalLayerPattern;
    os << YAML::Key << "minQp";
    // minQp -> Field -> int32_t
    os << YAML::Value << t.minQp;
    os << YAML::Key << "maxQp";
    // maxQp -> Field -> int32_t
    os << YAML::Value << t.maxQp;
    os << YAML::Key << "prefersGopRemainingFrames";
    // prefersGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.prefersGopRemainingFrames;
    os << YAML::Key << "requiresGopRemainingFrames";
    // requiresGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.requiresGopRemainingFrames;
    os << YAML::Key << "stdSyntaxFlags";
    // stdSyntaxFlags -> Field -> VkVideoEncodeH264StdFlagsKHR
    os << YAML::Value << t.stdSyntaxFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264QpKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "qpI";
    // qpI -> Field -> int32_t
    os << YAML::Value << t.qpI;
    os << YAML::Key << "qpP";
    // qpP -> Field -> int32_t
    os << YAML::Value << t.qpP;
    os << YAML::Key << "qpB";
    // qpB -> Field -> int32_t
    os << YAML::Value << t.qpB;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264QualityLevelPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "preferredRateControlFlags";
    // preferredRateControlFlags -> Field -> VkVideoEncodeH264RateControlFlagsKHR
    os << YAML::Value << t.preferredRateControlFlags;
    os << YAML::Key << "preferredGopFrameCount";
    // preferredGopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredGopFrameCount;
    os << YAML::Key << "preferredIdrPeriod";
    // preferredIdrPeriod -> Field -> uint32_t
    os << YAML::Value << t.preferredIdrPeriod;
    os << YAML::Key << "preferredConsecutiveBFrameCount";
    // preferredConsecutiveBFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredConsecutiveBFrameCount;
    os << YAML::Key << "preferredTemporalLayerCount";
    // preferredTemporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.preferredTemporalLayerCount;
    os << YAML::Key << "preferredConstantQp";
    // preferredConstantQp -> Field -> VkVideoEncodeH264QpKHR
    os << YAML::Value << t.preferredConstantQp;
    os << YAML::Key << "preferredMaxL0ReferenceCount";
    // preferredMaxL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxL0ReferenceCount;
    os << YAML::Key << "preferredMaxL1ReferenceCount";
    // preferredMaxL1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxL1ReferenceCount;
    os << YAML::Key << "preferredStdEntropyCodingModeFlag";
    // preferredStdEntropyCodingModeFlag -> Field -> VkBool32
    os << YAML::Value << t.preferredStdEntropyCodingModeFlag;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264SessionCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMaxLevelIdc";
    // useMaxLevelIdc -> Field -> VkBool32
    os << YAML::Value << t.useMaxLevelIdc;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH264LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264SessionParametersAddInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdSPSCount";
    // stdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdSPSCount;
    os << YAML::Key << "pStdSPSs";
    // pStdSPSs -> Field -> ConstDynamicArray(StdVideoH264SequenceParameterSet)
    if (t.stdSPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH264SequenceParameterSet"); }
    }
    os << YAML::Key << "stdPPSCount";
    // stdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdPPSCount;
    os << YAML::Key << "pStdPPSs";
    // pStdPPSs -> Field -> ConstDynamicArray(StdVideoH264PictureParameterSet)
    if (t.stdPPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH264PictureParameterSet"); }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxStdSPSCount";
    // maxStdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdSPSCount;
    os << YAML::Key << "maxStdPPSCount";
    // maxStdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdPPSCount;
    os << YAML::Key << "pParametersAddInfo";
    // pointer
    if (t.pParametersAddInfo != nullptr) {
        os << YAML::Value << *t.pParametersAddInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264SessionParametersGetInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "writeStdSPS";
    // writeStdSPS -> Field -> VkBool32
    os << YAML::Value << t.writeStdSPS;
    os << YAML::Key << "writeStdPPS";
    // writeStdPPS -> Field -> VkBool32
    os << YAML::Value << t.writeStdPPS;
    os << YAML::Key << "stdSPSId";
    // stdSPSId -> Field -> uint32_t
    os << YAML::Value << t.stdSPSId;
    os << YAML::Key << "stdPPSId";
    // stdPPSId -> Field -> uint32_t
    os << YAML::Value << t.stdPPSId;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264SessionParametersFeedbackInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hasStdSPSOverrides";
    // hasStdSPSOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasStdSPSOverrides;
    os << YAML::Key << "hasStdPPSOverrides";
    // hasStdPPSOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasStdPPSOverrides;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264NaluSliceInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "constantQp";
    // constantQp -> Field -> int32_t
    os << YAML::Value << t.constantQp;
    os << YAML::Key << "pStdSliceHeader";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSliceHeader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "naluSliceEntryCount";
    // naluSliceEntryCount -> Field -> uint32_t
    os << YAML::Value << t.naluSliceEntryCount;
    os << YAML::Key << "pNaluSliceEntries";
    // pNaluSliceEntries -> Field -> ConstDynamicArray(VkVideoEncodeH264NaluSliceInfoKHR)
    if (t.naluSliceEntryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoEncodeH264NaluSliceInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.naluSliceEntryCount); ++i) {
                os << t.pNaluSliceEntries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "generatePrefixNalu";
    // generatePrefixNalu -> Field -> VkBool32
    os << YAML::Value << t.generatePrefixNalu;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfileIdc";
    // stdProfileIdc -> Field -> StdVideoH264ProfileIdc
    os << YAML::Value << t.stdProfileIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264RateControlInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeH264RateControlFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "gopFrameCount";
    // gopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.gopFrameCount;
    os << YAML::Key << "idrPeriod";
    // idrPeriod -> Field -> uint32_t
    os << YAML::Value << t.idrPeriod;
    os << YAML::Key << "consecutiveBFrameCount";
    // consecutiveBFrameCount -> Field -> uint32_t
    os << YAML::Value << t.consecutiveBFrameCount;
    os << YAML::Key << "temporalLayerCount";
    // temporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.temporalLayerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264FrameSizeKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "frameISize";
    // frameISize -> Field -> uint32_t
    os << YAML::Value << t.frameISize;
    os << YAML::Key << "framePSize";
    // framePSize -> Field -> uint32_t
    os << YAML::Value << t.framePSize;
    os << YAML::Key << "frameBSize";
    // frameBSize -> Field -> uint32_t
    os << YAML::Value << t.frameBSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264RateControlLayerInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMinQp";
    // useMinQp -> Field -> VkBool32
    os << YAML::Value << t.useMinQp;
    os << YAML::Key << "minQp";
    // minQp -> Field -> VkVideoEncodeH264QpKHR
    os << YAML::Value << t.minQp;
    os << YAML::Key << "useMaxQp";
    // useMaxQp -> Field -> VkBool32
    os << YAML::Value << t.useMaxQp;
    os << YAML::Key << "maxQp";
    // maxQp -> Field -> VkVideoEncodeH264QpKHR
    os << YAML::Value << t.maxQp;
    os << YAML::Key << "useMaxFrameSize";
    // useMaxFrameSize -> Field -> VkBool32
    os << YAML::Value << t.useMaxFrameSize;
    os << YAML::Key << "maxFrameSize";
    // maxFrameSize -> Field -> VkVideoEncodeH264FrameSizeKHR
    os << YAML::Value << t.maxFrameSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264GopRemainingFrameInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useGopRemainingFrames";
    // useGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.useGopRemainingFrames;
    os << YAML::Key << "gopRemainingI";
    // gopRemainingI -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingI;
    os << YAML::Key << "gopRemainingP";
    // gopRemainingP -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingP;
    os << YAML::Key << "gopRemainingB";
    // gopRemainingB -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingB;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeH265CapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH265LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::Key << "maxSliceSegmentCount";
    // maxSliceSegmentCount -> Field -> uint32_t
    os << YAML::Value << t.maxSliceSegmentCount;
    os << YAML::Key << "maxTiles";
    // maxTiles -> Field -> VkExtent2D
    os << YAML::Value << t.maxTiles;
    os << YAML::Key << "ctbSizes";
    // ctbSizes -> Field -> VkVideoEncodeH265CtbSizeFlagsKHR
    os << YAML::Value << t.ctbSizes;
    os << YAML::Key << "transformBlockSizes";
    // transformBlockSizes -> Field -> VkVideoEncodeH265TransformBlockSizeFlagsKHR
    os << YAML::Value << t.transformBlockSizes;
    os << YAML::Key << "maxPPictureL0ReferenceCount";
    // maxPPictureL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxPPictureL0ReferenceCount;
    os << YAML::Key << "maxBPictureL0ReferenceCount";
    // maxBPictureL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxBPictureL0ReferenceCount;
    os << YAML::Key << "maxL1ReferenceCount";
    // maxL1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxL1ReferenceCount;
    os << YAML::Key << "maxSubLayerCount";
    // maxSubLayerCount -> Field -> uint32_t
    os << YAML::Value << t.maxSubLayerCount;
    os << YAML::Key << "expectDyadicTemporalSubLayerPattern";
    // expectDyadicTemporalSubLayerPattern -> Field -> VkBool32
    os << YAML::Value << t.expectDyadicTemporalSubLayerPattern;
    os << YAML::Key << "minQp";
    // minQp -> Field -> int32_t
    os << YAML::Value << t.minQp;
    os << YAML::Key << "maxQp";
    // maxQp -> Field -> int32_t
    os << YAML::Value << t.maxQp;
    os << YAML::Key << "prefersGopRemainingFrames";
    // prefersGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.prefersGopRemainingFrames;
    os << YAML::Key << "requiresGopRemainingFrames";
    // requiresGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.requiresGopRemainingFrames;
    os << YAML::Key << "stdSyntaxFlags";
    // stdSyntaxFlags -> Field -> VkVideoEncodeH265StdFlagsKHR
    os << YAML::Value << t.stdSyntaxFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265SessionCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMaxLevelIdc";
    // useMaxLevelIdc -> Field -> VkBool32
    os << YAML::Value << t.useMaxLevelIdc;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH265LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265QpKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "qpI";
    // qpI -> Field -> int32_t
    os << YAML::Value << t.qpI;
    os << YAML::Key << "qpP";
    // qpP -> Field -> int32_t
    os << YAML::Value << t.qpP;
    os << YAML::Key << "qpB";
    // qpB -> Field -> int32_t
    os << YAML::Value << t.qpB;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265QualityLevelPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "preferredRateControlFlags";
    // preferredRateControlFlags -> Field -> VkVideoEncodeH265RateControlFlagsKHR
    os << YAML::Value << t.preferredRateControlFlags;
    os << YAML::Key << "preferredGopFrameCount";
    // preferredGopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredGopFrameCount;
    os << YAML::Key << "preferredIdrPeriod";
    // preferredIdrPeriod -> Field -> uint32_t
    os << YAML::Value << t.preferredIdrPeriod;
    os << YAML::Key << "preferredConsecutiveBFrameCount";
    // preferredConsecutiveBFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredConsecutiveBFrameCount;
    os << YAML::Key << "preferredSubLayerCount";
    // preferredSubLayerCount -> Field -> uint32_t
    os << YAML::Value << t.preferredSubLayerCount;
    os << YAML::Key << "preferredConstantQp";
    // preferredConstantQp -> Field -> VkVideoEncodeH265QpKHR
    os << YAML::Value << t.preferredConstantQp;
    os << YAML::Key << "preferredMaxL0ReferenceCount";
    // preferredMaxL0ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxL0ReferenceCount;
    os << YAML::Key << "preferredMaxL1ReferenceCount";
    // preferredMaxL1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxL1ReferenceCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265SessionParametersAddInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdVPSCount";
    // stdVPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdVPSCount;
    os << YAML::Key << "pStdVPSs";
    // pStdVPSs -> Field -> ConstDynamicArray(StdVideoH265VideoParameterSet)
    if (t.stdVPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265VideoParameterSet"); }
    }
    os << YAML::Key << "stdSPSCount";
    // stdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdSPSCount;
    os << YAML::Key << "pStdSPSs";
    // pStdSPSs -> Field -> ConstDynamicArray(StdVideoH265SequenceParameterSet)
    if (t.stdSPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265SequenceParameterSet"); }
    }
    os << YAML::Key << "stdPPSCount";
    // stdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdPPSCount;
    os << YAML::Key << "pStdPPSs";
    // pStdPPSs -> Field -> ConstDynamicArray(StdVideoH265PictureParameterSet)
    if (t.stdPPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265PictureParameterSet"); }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxStdVPSCount";
    // maxStdVPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdVPSCount;
    os << YAML::Key << "maxStdSPSCount";
    // maxStdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdSPSCount;
    os << YAML::Key << "maxStdPPSCount";
    // maxStdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdPPSCount;
    os << YAML::Key << "pParametersAddInfo";
    // pointer
    if (t.pParametersAddInfo != nullptr) {
        os << YAML::Value << *t.pParametersAddInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265SessionParametersGetInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "writeStdVPS";
    // writeStdVPS -> Field -> VkBool32
    os << YAML::Value << t.writeStdVPS;
    os << YAML::Key << "writeStdSPS";
    // writeStdSPS -> Field -> VkBool32
    os << YAML::Value << t.writeStdSPS;
    os << YAML::Key << "writeStdPPS";
    // writeStdPPS -> Field -> VkBool32
    os << YAML::Value << t.writeStdPPS;
    os << YAML::Key << "stdVPSId";
    // stdVPSId -> Field -> uint32_t
    os << YAML::Value << t.stdVPSId;
    os << YAML::Key << "stdSPSId";
    // stdSPSId -> Field -> uint32_t
    os << YAML::Value << t.stdSPSId;
    os << YAML::Key << "stdPPSId";
    // stdPPSId -> Field -> uint32_t
    os << YAML::Value << t.stdPPSId;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265SessionParametersFeedbackInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hasStdVPSOverrides";
    // hasStdVPSOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasStdVPSOverrides;
    os << YAML::Key << "hasStdSPSOverrides";
    // hasStdSPSOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasStdSPSOverrides;
    os << YAML::Key << "hasStdPPSOverrides";
    // hasStdPPSOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasStdPPSOverrides;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265NaluSliceSegmentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "constantQp";
    // constantQp -> Field -> int32_t
    os << YAML::Value << t.constantQp;
    os << YAML::Key << "pStdSliceSegmentHeader";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSliceSegmentHeader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "naluSliceSegmentEntryCount";
    // naluSliceSegmentEntryCount -> Field -> uint32_t
    os << YAML::Value << t.naluSliceSegmentEntryCount;
    os << YAML::Key << "pNaluSliceSegmentEntries";
    // pNaluSliceSegmentEntries -> Field -> ConstDynamicArray(VkVideoEncodeH265NaluSliceSegmentInfoKHR)
    if (t.naluSliceSegmentEntryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoEncodeH265NaluSliceSegmentInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.naluSliceSegmentEntryCount); ++i) {
                os << t.pNaluSliceSegmentEntries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfileIdc";
    // stdProfileIdc -> Field -> StdVideoH265ProfileIdc
    os << YAML::Value << t.stdProfileIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265RateControlInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeH265RateControlFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "gopFrameCount";
    // gopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.gopFrameCount;
    os << YAML::Key << "idrPeriod";
    // idrPeriod -> Field -> uint32_t
    os << YAML::Value << t.idrPeriod;
    os << YAML::Key << "consecutiveBFrameCount";
    // consecutiveBFrameCount -> Field -> uint32_t
    os << YAML::Value << t.consecutiveBFrameCount;
    os << YAML::Key << "subLayerCount";
    // subLayerCount -> Field -> uint32_t
    os << YAML::Value << t.subLayerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265FrameSizeKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "frameISize";
    // frameISize -> Field -> uint32_t
    os << YAML::Value << t.frameISize;
    os << YAML::Key << "framePSize";
    // framePSize -> Field -> uint32_t
    os << YAML::Value << t.framePSize;
    os << YAML::Key << "frameBSize";
    // frameBSize -> Field -> uint32_t
    os << YAML::Value << t.frameBSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265RateControlLayerInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMinQp";
    // useMinQp -> Field -> VkBool32
    os << YAML::Value << t.useMinQp;
    os << YAML::Key << "minQp";
    // minQp -> Field -> VkVideoEncodeH265QpKHR
    os << YAML::Value << t.minQp;
    os << YAML::Key << "useMaxQp";
    // useMaxQp -> Field -> VkBool32
    os << YAML::Value << t.useMaxQp;
    os << YAML::Key << "maxQp";
    // maxQp -> Field -> VkVideoEncodeH265QpKHR
    os << YAML::Value << t.maxQp;
    os << YAML::Key << "useMaxFrameSize";
    // useMaxFrameSize -> Field -> VkBool32
    os << YAML::Value << t.useMaxFrameSize;
    os << YAML::Key << "maxFrameSize";
    // maxFrameSize -> Field -> VkVideoEncodeH265FrameSizeKHR
    os << YAML::Value << t.maxFrameSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265GopRemainingFrameInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useGopRemainingFrames";
    // useGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.useGopRemainingFrames;
    os << YAML::Key << "gopRemainingI";
    // gopRemainingI -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingI;
    os << YAML::Key << "gopRemainingP";
    // gopRemainingP -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingP;
    os << YAML::Key << "gopRemainingB";
    // gopRemainingB -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingB;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfileIdc";
    // stdProfileIdc -> Field -> StdVideoH264ProfileIdc
    os << YAML::Value << t.stdProfileIdc;
    os << YAML::Key << "pictureLayout";
    // pictureLayout -> Field -> VkVideoDecodeH264PictureLayoutFlagBitsKHR
    os << YAML::Value << t.pictureLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH264LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::Key << "fieldOffsetGranularity";
    // fieldOffsetGranularity -> Field -> VkOffset2D
    os << YAML::Value << t.fieldOffsetGranularity;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264SessionParametersAddInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdSPSCount";
    // stdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdSPSCount;
    os << YAML::Key << "pStdSPSs";
    // pStdSPSs -> Field -> ConstDynamicArray(StdVideoH264SequenceParameterSet)
    if (t.stdSPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH264SequenceParameterSet"); }
    }
    os << YAML::Key << "stdPPSCount";
    // stdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdPPSCount;
    os << YAML::Key << "pStdPPSs";
    // pStdPPSs -> Field -> ConstDynamicArray(StdVideoH264PictureParameterSet)
    if (t.stdPPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH264PictureParameterSet"); }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxStdSPSCount";
    // maxStdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdSPSCount;
    os << YAML::Key << "maxStdPPSCount";
    // maxStdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdPPSCount;
    os << YAML::Key << "pParametersAddInfo";
    // pointer
    if (t.pParametersAddInfo != nullptr) {
        os << YAML::Value << *t.pParametersAddInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "sliceCount";
    // sliceCount -> Field -> uint32_t
    os << YAML::Value << t.sliceCount;
    os << YAML::Key << "pSliceOffsets";
    // pSliceOffsets -> Field -> ConstDynamicArray(uint32_t)
    if (t.sliceCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.sliceCount); ++i) {
                os << t.pSliceOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "handle";
    // handle -> Field -> HANDLE
    os << YAML::Value << t.handle;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMemoryWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pAttributes";
    // non-dereferenced pointer
    os << YAML::Value << t.pAttributes;
    os << YAML::Key << "dwAccess";
    // dwAccess -> Field -> DWORD
    os << YAML::Value << t.dwAccess;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryWin32HandlePropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryGetWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "fd";
    // fd -> Field -> int
    os << YAML::Value << t.fd;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryFdPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryGetFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkWin32KeyedMutexAcquireReleaseInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "acquireCount";
    // acquireCount -> Field -> uint32_t
    os << YAML::Value << t.acquireCount;
    os << YAML::Key << "pAcquireSyncs";
    // pAcquireSyncs -> Field -> ConstDynamicArray(VkDeviceMemory)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceMemory");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireSyncs[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pAcquireKeys";
    // pAcquireKeys -> Field -> ConstDynamicArray(uint64_t)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireKeys[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pAcquireTimeouts";
    // pAcquireTimeouts -> Field -> ConstDynamicArray(uint32_t)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireTimeouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "releaseCount";
    // releaseCount -> Field -> uint32_t
    os << YAML::Value << t.releaseCount;
    os << YAML::Key << "pReleaseSyncs";
    // pReleaseSyncs -> Field -> ConstDynamicArray(VkDeviceMemory)
    if (t.releaseCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceMemory");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.releaseCount); ++i) {
                os << t.pReleaseSyncs[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pReleaseKeys";
    // pReleaseKeys -> Field -> ConstDynamicArray(uint64_t)
    if (t.releaseCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.releaseCount); ++i) {
                os << t.pReleaseKeys[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportSemaphoreWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSemaphoreImportFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "handle";
    // handle -> Field -> HANDLE
    os << YAML::Value << t.handle;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportSemaphoreWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pAttributes";
    // non-dereferenced pointer
    os << YAML::Value << t.pAttributes;
    os << YAML::Key << "dwAccess";
    // dwAccess -> Field -> DWORD
    os << YAML::Value << t.dwAccess;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkD3D12FenceSubmitInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "waitSemaphoreValuesCount";
    // waitSemaphoreValuesCount -> Field -> uint32_t
    os << YAML::Value << t.waitSemaphoreValuesCount;
    os << YAML::Key << "pWaitSemaphoreValues";
    // pWaitSemaphoreValues -> Field -> ConstDynamicArray(uint64_t)
    if (t.waitSemaphoreValuesCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.waitSemaphoreValuesCount); ++i) {
                os << t.pWaitSemaphoreValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "signalSemaphoreValuesCount";
    // signalSemaphoreValuesCount -> Field -> uint32_t
    os << YAML::Value << t.signalSemaphoreValuesCount;
    os << YAML::Key << "pSignalSemaphoreValues";
    // pSignalSemaphoreValues -> Field -> ConstDynamicArray(uint64_t)
    if (t.signalSemaphoreValuesCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.signalSemaphoreValuesCount); ++i) {
                os << t.pSignalSemaphoreValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreGetWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportSemaphoreFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSemaphoreImportFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "fd";
    // fd -> Field -> int
    os << YAML::Value << t.fd;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreGetFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRectLayerKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "offset";
    // offset -> Field -> VkOffset2D
    os << YAML::Value << t.offset;
    os << YAML::Key << "extent";
    // extent -> Field -> VkExtent2D
    os << YAML::Value << t.extent;
    os << YAML::Key << "layer";
    // layer -> Field -> uint32_t
    os << YAML::Value << t.layer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentRegionKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "rectangleCount";
    // rectangleCount -> Field -> uint32_t
    os << YAML::Value << t.rectangleCount;
    os << YAML::Key << "pRectangles";
    // pRectangles -> Field -> ConstDynamicArray(VkRectLayerKHR)
    if (t.rectangleCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRectLayerKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.rectangleCount); ++i) {
                os << t.pRectangles[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentRegionsKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pRegions";
    // pRegions -> Field -> ConstDynamicArray(VkPresentRegionKHR)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentRegionKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pRegions[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSharedPresentSurfaceCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sharedPresentSupportedUsageFlags";
    // sharedPresentSupportedUsageFlags -> Field -> VkImageUsageFlags
    os << YAML::Value << t.sharedPresentSupportedUsageFlags;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportFenceWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fence";
    // fence -> Field -> VkFence
    os << YAML::Value << t.fence;
    os << YAML::Key << "flags";
    // flags -> Field -> VkFenceImportFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalFenceHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "handle";
    // handle -> Field -> HANDLE
    os << YAML::Value << t.handle;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportFenceWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pAttributes";
    // non-dereferenced pointer
    os << YAML::Value << t.pAttributes;
    os << YAML::Key << "dwAccess";
    // dwAccess -> Field -> DWORD
    os << YAML::Value << t.dwAccess;
    os << YAML::Key << "name";
    // name -> Field -> LPCWSTR
    os << YAML::Value << t.name;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkFenceGetWin32HandleInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fence";
    // fence -> Field -> VkFence
    os << YAML::Value << t.fence;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalFenceHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportFenceFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fence";
    // fence -> Field -> VkFence
    os << YAML::Value << t.fence;
    os << YAML::Key << "flags";
    // flags -> Field -> VkFenceImportFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalFenceHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "fd";
    // fd -> Field -> int
    os << YAML::Value << t.fd;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFenceGetFdInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fence";
    // fence -> Field -> VkFence
    os << YAML::Value << t.fence;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalFenceHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePerformanceQueryFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "performanceCounterQueryPools";
    // performanceCounterQueryPools -> Field -> VkBool32
    os << YAML::Value << t.performanceCounterQueryPools;
    os << YAML::Key << "performanceCounterMultipleQueryPools";
    // performanceCounterMultipleQueryPools -> Field -> VkBool32
    os << YAML::Value << t.performanceCounterMultipleQueryPools;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePerformanceQueryPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "allowCommandBufferQueryCopies";
    // allowCommandBufferQueryCopies -> Field -> VkBool32
    os << YAML::Value << t.allowCommandBufferQueryCopies;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceCounterKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "unit";
    // unit -> Field -> VkPerformanceCounterUnitKHR
    os << YAML::Value << t.unit;
    os << YAML::Key << "scope";
    // scope -> Field -> VkPerformanceCounterScopeKHR
    os << YAML::Value << t.scope;
    os << YAML::Key << "storage";
    // storage -> Field -> VkPerformanceCounterStorageKHR
    os << YAML::Value << t.storage;
    os << YAML::Key << "uuid";
    // uuid -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.uuid[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceCounterDescriptionKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPerformanceCounterDescriptionFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "name";
    // name -> Field -> FixedArray(char)
    os << YAML::Value << t.name;
    os << YAML::Key << "category";
    // category -> Field -> FixedArray(char)
    os << YAML::Value << t.category;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueryPoolPerformanceCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queueFamilyIndex";
    // queueFamilyIndex -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndex;
    os << YAML::Key << "counterIndexCount";
    // counterIndexCount -> Field -> uint32_t
    os << YAML::Value << t.counterIndexCount;
    os << YAML::Key << "pCounterIndices";
    // pCounterIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.counterIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.counterIndexCount); ++i) {
                os << t.pCounterIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceCounterResultKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "int32";
    // int32 -> Field -> int32_t
    os << YAML::Value << t.int32;
    os << YAML::Key << "int64";
    // int64 -> Field -> int64_t
    os << YAML::Value << t.int64;
    os << YAML::Key << "uint32";
    // uint32 -> Field -> uint32_t
    os << YAML::Value << t.uint32;
    os << YAML::Key << "uint64";
    // uint64 -> Field -> uint64_t
    os << YAML::Value << t.uint64;
    os << YAML::Key << "float32";
    // float32 -> Field -> float
    os << YAML::Value << t.float32;
    os << YAML::Key << "float64";
    // float64 -> Field -> double
    os << YAML::Value << t.float64;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAcquireProfilingLockInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAcquireProfilingLockFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "timeout";
    // timeout -> Field -> uint64_t
    os << YAML::Value << t.timeout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceQuerySubmitInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "counterPassIndex";
    // counterPassIndex -> Field -> uint32_t
    os << YAML::Value << t.counterPassIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSurfaceInfo2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "surface";
    // surface -> Field -> VkSurfaceKHR
    os << YAML::Value << t.surface;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilities2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "surfaceCapabilities";
    // surfaceCapabilities -> Field -> VkSurfaceCapabilitiesKHR
    os << YAML::Value << t.surfaceCapabilities;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceFormat2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "surfaceFormat";
    // surfaceFormat -> Field -> VkSurfaceFormatKHR
    os << YAML::Value << t.surfaceFormat;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayProperties2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "displayProperties";
    // displayProperties -> Field -> VkDisplayPropertiesKHR
    os << YAML::Value << t.displayProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPlaneProperties2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "displayPlaneProperties";
    // displayPlaneProperties -> Field -> VkDisplayPlanePropertiesKHR
    os << YAML::Value << t.displayPlaneProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayModeProperties2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "displayModeProperties";
    // displayModeProperties -> Field -> VkDisplayModePropertiesKHR
    os << YAML::Value << t.displayModeProperties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPlaneInfo2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mode";
    // mode -> Field -> VkDisplayModeKHR
    os << YAML::Value << t.mode;
    os << YAML::Key << "planeIndex";
    // planeIndex -> Field -> uint32_t
    os << YAML::Value << t.planeIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPlaneCapabilities2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "capabilities";
    // capabilities -> Field -> VkDisplayPlaneCapabilitiesKHR
    os << YAML::Value << t.capabilities;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderBfloat16FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderBFloat16Type";
    // shaderBFloat16Type -> Field -> VkBool32
    os << YAML::Value << t.shaderBFloat16Type;
    os << YAML::Key << "shaderBFloat16DotProduct";
    // shaderBFloat16DotProduct -> Field -> VkBool32
    os << YAML::Value << t.shaderBFloat16DotProduct;
    os << YAML::Key << "shaderBFloat16CooperativeMatrix";
    // shaderBFloat16CooperativeMatrix -> Field -> VkBool32
    os << YAML::Value << t.shaderBFloat16CooperativeMatrix;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePortabilitySubsetFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "constantAlphaColorBlendFactors";
    // constantAlphaColorBlendFactors -> Field -> VkBool32
    os << YAML::Value << t.constantAlphaColorBlendFactors;
    os << YAML::Key << "events";
    // events -> Field -> VkBool32
    os << YAML::Value << t.events;
    os << YAML::Key << "imageViewFormatReinterpretation";
    // imageViewFormatReinterpretation -> Field -> VkBool32
    os << YAML::Value << t.imageViewFormatReinterpretation;
    os << YAML::Key << "imageViewFormatSwizzle";
    // imageViewFormatSwizzle -> Field -> VkBool32
    os << YAML::Value << t.imageViewFormatSwizzle;
    os << YAML::Key << "imageView2DOn3DImage";
    // imageView2DOn3DImage -> Field -> VkBool32
    os << YAML::Value << t.imageView2DOn3DImage;
    os << YAML::Key << "multisampleArrayImage";
    // multisampleArrayImage -> Field -> VkBool32
    os << YAML::Value << t.multisampleArrayImage;
    os << YAML::Key << "mutableComparisonSamplers";
    // mutableComparisonSamplers -> Field -> VkBool32
    os << YAML::Value << t.mutableComparisonSamplers;
    os << YAML::Key << "pointPolygons";
    // pointPolygons -> Field -> VkBool32
    os << YAML::Value << t.pointPolygons;
    os << YAML::Key << "samplerMipLodBias";
    // samplerMipLodBias -> Field -> VkBool32
    os << YAML::Value << t.samplerMipLodBias;
    os << YAML::Key << "separateStencilMaskRef";
    // separateStencilMaskRef -> Field -> VkBool32
    os << YAML::Value << t.separateStencilMaskRef;
    os << YAML::Key << "shaderSampleRateInterpolationFunctions";
    // shaderSampleRateInterpolationFunctions -> Field -> VkBool32
    os << YAML::Value << t.shaderSampleRateInterpolationFunctions;
    os << YAML::Key << "tessellationIsolines";
    // tessellationIsolines -> Field -> VkBool32
    os << YAML::Value << t.tessellationIsolines;
    os << YAML::Key << "tessellationPointMode";
    // tessellationPointMode -> Field -> VkBool32
    os << YAML::Value << t.tessellationPointMode;
    os << YAML::Key << "triangleFans";
    // triangleFans -> Field -> VkBool32
    os << YAML::Value << t.triangleFans;
    os << YAML::Key << "vertexAttributeAccessBeyondStride";
    // vertexAttributeAccessBeyondStride -> Field -> VkBool32
    os << YAML::Value << t.vertexAttributeAccessBeyondStride;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePortabilitySubsetPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minVertexInputBindingStrideAlignment";
    // minVertexInputBindingStrideAlignment -> Field -> uint32_t
    os << YAML::Value << t.minVertexInputBindingStrideAlignment;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderClockFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSubgroupClock";
    // shaderSubgroupClock -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupClock;
    os << YAML::Key << "shaderDeviceClock";
    // shaderDeviceClock -> Field -> VkBool32
    os << YAML::Value << t.shaderDeviceClock;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfileIdc";
    // stdProfileIdc -> Field -> StdVideoH265ProfileIdc
    os << YAML::Value << t.stdProfileIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxLevelIdc";
    // maxLevelIdc -> Field -> StdVideoH265LevelIdc
    os << YAML::Value << t.maxLevelIdc;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265SessionParametersAddInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdVPSCount";
    // stdVPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdVPSCount;
    os << YAML::Key << "pStdVPSs";
    // pStdVPSs -> Field -> ConstDynamicArray(StdVideoH265VideoParameterSet)
    if (t.stdVPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265VideoParameterSet"); }
    }
    os << YAML::Key << "stdSPSCount";
    // stdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdSPSCount;
    os << YAML::Key << "pStdSPSs";
    // pStdSPSs -> Field -> ConstDynamicArray(StdVideoH265SequenceParameterSet)
    if (t.stdSPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265SequenceParameterSet"); }
    }
    os << YAML::Key << "stdPPSCount";
    // stdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.stdPPSCount;
    os << YAML::Key << "pStdPPSs";
    // pStdPPSs -> Field -> ConstDynamicArray(StdVideoH265PictureParameterSet)
    if (t.stdPPSCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoH265PictureParameterSet"); }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxStdVPSCount";
    // maxStdVPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdVPSCount;
    os << YAML::Key << "maxStdSPSCount";
    // maxStdSPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdSPSCount;
    os << YAML::Key << "maxStdPPSCount";
    // maxStdPPSCount -> Field -> uint32_t
    os << YAML::Value << t.maxStdPPSCount;
    os << YAML::Key << "pParametersAddInfo";
    // pointer
    if (t.pParametersAddInfo != nullptr) {
        os << YAML::Value << *t.pParametersAddInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "sliceSegmentCount";
    // sliceSegmentCount -> Field -> uint32_t
    os << YAML::Value << t.sliceSegmentCount;
    os << YAML::Key << "pSliceSegmentOffsets";
    // pSliceSegmentOffsets -> Field -> ConstDynamicArray(uint32_t)
    if (t.sliceSegmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.sliceSegmentCount); ++i) {
                os << t.pSliceSegmentOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFragmentShadingRateAttachmentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pFragmentShadingRateAttachment";
    // pointer
    if (t.pFragmentShadingRateAttachment != nullptr) {
        os << YAML::Value << *t.pFragmentShadingRateAttachment;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "shadingRateAttachmentTexelSize";
    // shadingRateAttachmentTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.shadingRateAttachmentTexelSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineFragmentShadingRateStateCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentSize";
    // fragmentSize -> Field -> VkExtent2D
    os << YAML::Value << t.fragmentSize;
    os << YAML::Key << "combinerOps";
    // combinerOps -> Field -> FixedArray(VkFragmentShadingRateCombinerOpKHR)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFragmentShadingRateCombinerOpKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.combinerOps[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShadingRateFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineFragmentShadingRate";
    // pipelineFragmentShadingRate -> Field -> VkBool32
    os << YAML::Value << t.pipelineFragmentShadingRate;
    os << YAML::Key << "primitiveFragmentShadingRate";
    // primitiveFragmentShadingRate -> Field -> VkBool32
    os << YAML::Value << t.primitiveFragmentShadingRate;
    os << YAML::Key << "attachmentFragmentShadingRate";
    // attachmentFragmentShadingRate -> Field -> VkBool32
    os << YAML::Value << t.attachmentFragmentShadingRate;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShadingRatePropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minFragmentShadingRateAttachmentTexelSize";
    // minFragmentShadingRateAttachmentTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.minFragmentShadingRateAttachmentTexelSize;
    os << YAML::Key << "maxFragmentShadingRateAttachmentTexelSize";
    // maxFragmentShadingRateAttachmentTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxFragmentShadingRateAttachmentTexelSize;
    os << YAML::Key << "maxFragmentShadingRateAttachmentTexelSizeAspectRatio";
    // maxFragmentShadingRateAttachmentTexelSizeAspectRatio -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
    os << YAML::Key << "primitiveFragmentShadingRateWithMultipleViewports";
    // primitiveFragmentShadingRateWithMultipleViewports -> Field -> VkBool32
    os << YAML::Value << t.primitiveFragmentShadingRateWithMultipleViewports;
    os << YAML::Key << "layeredShadingRateAttachments";
    // layeredShadingRateAttachments -> Field -> VkBool32
    os << YAML::Value << t.layeredShadingRateAttachments;
    os << YAML::Key << "fragmentShadingRateNonTrivialCombinerOps";
    // fragmentShadingRateNonTrivialCombinerOps -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateNonTrivialCombinerOps;
    os << YAML::Key << "maxFragmentSize";
    // maxFragmentSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxFragmentSize;
    os << YAML::Key << "maxFragmentSizeAspectRatio";
    // maxFragmentSizeAspectRatio -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentSizeAspectRatio;
    os << YAML::Key << "maxFragmentShadingRateCoverageSamples";
    // maxFragmentShadingRateCoverageSamples -> Field -> uint32_t
    os << YAML::Value << t.maxFragmentShadingRateCoverageSamples;
    os << YAML::Key << "maxFragmentShadingRateRasterizationSamples";
    // maxFragmentShadingRateRasterizationSamples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.maxFragmentShadingRateRasterizationSamples;
    os << YAML::Key << "fragmentShadingRateWithShaderDepthStencilWrites";
    // fragmentShadingRateWithShaderDepthStencilWrites -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithShaderDepthStencilWrites;
    os << YAML::Key << "fragmentShadingRateWithSampleMask";
    // fragmentShadingRateWithSampleMask -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithSampleMask;
    os << YAML::Key << "fragmentShadingRateWithShaderSampleMask";
    // fragmentShadingRateWithShaderSampleMask -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithShaderSampleMask;
    os << YAML::Key << "fragmentShadingRateWithConservativeRasterization";
    // fragmentShadingRateWithConservativeRasterization -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithConservativeRasterization;
    os << YAML::Key << "fragmentShadingRateWithFragmentShaderInterlock";
    // fragmentShadingRateWithFragmentShaderInterlock -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithFragmentShaderInterlock;
    os << YAML::Key << "fragmentShadingRateWithCustomSampleLocations";
    // fragmentShadingRateWithCustomSampleLocations -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateWithCustomSampleLocations;
    os << YAML::Key << "fragmentShadingRateStrictMultiplyCombiner";
    // fragmentShadingRateStrictMultiplyCombiner -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateStrictMultiplyCombiner;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShadingRateKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampleCounts";
    // sampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampleCounts;
    os << YAML::Key << "fragmentSize";
    // fragmentSize -> Field -> VkExtent2D
    os << YAML::Value << t.fragmentSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingFragmentShadingRateAttachmentInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "imageLayout";
    // imageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.imageLayout;
    os << YAML::Key << "shadingRateAttachmentTexelSize";
    // shadingRateAttachmentTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.shadingRateAttachmentTexelSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderQuadControlFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderQuadControl";
    // shaderQuadControl -> Field -> VkBool32
    os << YAML::Value << t.shaderQuadControl;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceProtectedCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supportsProtected";
    // supportsProtected -> Field -> VkBool32
    os << YAML::Value << t.supportsProtected;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentWaitFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentWait";
    // presentWait -> Field -> VkBool32
    os << YAML::Value << t.presentWait;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineExecutableInfo";
    // pipelineExecutableInfo -> Field -> VkBool32
    os << YAML::Value << t.pipelineExecutableInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineExecutablePropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stages";
    // stages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stages;
    os << YAML::Key << "name";
    // name -> Field -> FixedArray(char)
    os << YAML::Value << t.name;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "subgroupSize";
    // subgroupSize -> Field -> uint32_t
    os << YAML::Value << t.subgroupSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineExecutableInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::Key << "executableIndex";
    // executableIndex -> Field -> uint32_t
    os << YAML::Value << t.executableIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineExecutableStatisticValueKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "b32";
    // b32 -> Field -> VkBool32
    os << YAML::Value << t.b32;
    os << YAML::Key << "i64";
    // i64 -> Field -> int64_t
    os << YAML::Value << t.i64;
    os << YAML::Key << "u64";
    // u64 -> Field -> uint64_t
    os << YAML::Value << t.u64;
    os << YAML::Key << "f64";
    // f64 -> Field -> double
    os << YAML::Value << t.f64;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineExecutableStatisticKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "name";
    // name -> Field -> FixedArray(char)
    os << YAML::Value << t.name;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "format";
    // format -> Field -> VkPipelineExecutableStatisticFormatKHR
    os << YAML::Value << t.format;
    os << YAML::Key << "value";
    // value -> Field -> VkPipelineExecutableStatisticValueKHR
    os << YAML::Value << t.value;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineExecutableInternalRepresentationKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "name";
    // name -> Field -> FixedArray(char)
    os << YAML::Value << t.name;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "isText";
    // isText -> Field -> VkBool32
    os << YAML::Value << t.isText;
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> size_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineLibraryCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "libraryCount";
    // libraryCount -> Field -> uint32_t
    os << YAML::Value << t.libraryCount;
    os << YAML::Key << "pLibraries";
    // pLibraries -> Field -> ConstDynamicArray(VkPipeline)
    if (t.libraryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipeline");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.libraryCount); ++i) {
                os << t.pLibraries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentIdKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pPresentIds";
    // pPresentIds -> Field -> ConstDynamicArray(uint64_t)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pPresentIds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentIdFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentId";
    // presentId -> Field -> VkBool32
    os << YAML::Value << t.presentId;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "dstBuffer";
    // dstBuffer -> Field -> VkBuffer
    os << YAML::Value << t.dstBuffer;
    os << YAML::Key << "dstBufferOffset";
    // dstBufferOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.dstBufferOffset;
    os << YAML::Key << "dstBufferRange";
    // dstBufferRange -> Field -> VkDeviceSize
    os << YAML::Value << t.dstBufferRange;
    os << YAML::Key << "srcPictureResource";
    // srcPictureResource -> Field -> VkVideoPictureResourceInfoKHR
    os << YAML::Value << t.srcPictureResource;
    os << YAML::Key << "pSetupReferenceSlot";
    // pointer
    if (t.pSetupReferenceSlot != nullptr) {
        os << YAML::Value << *t.pSetupReferenceSlot;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "referenceSlotCount";
    // referenceSlotCount -> Field -> uint32_t
    os << YAML::Value << t.referenceSlotCount;
    os << YAML::Key << "pReferenceSlots";
    // pReferenceSlots -> Field -> ConstDynamicArray(VkVideoReferenceSlotInfoKHR)
    if (t.referenceSlotCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoReferenceSlotInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.referenceSlotCount); ++i) {
                os << t.pReferenceSlots[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "precedingExternallyEncodedBytes";
    // precedingExternallyEncodedBytes -> Field -> uint32_t
    os << YAML::Value << t.precedingExternallyEncodedBytes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeCapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "rateControlModes";
    // rateControlModes -> Field -> VkVideoEncodeRateControlModeFlagsKHR
    os << YAML::Value << t.rateControlModes;
    os << YAML::Key << "maxRateControlLayers";
    // maxRateControlLayers -> Field -> uint32_t
    os << YAML::Value << t.maxRateControlLayers;
    os << YAML::Key << "maxBitrate";
    // maxBitrate -> Field -> uint64_t
    os << YAML::Value << t.maxBitrate;
    os << YAML::Key << "maxQualityLevels";
    // maxQualityLevels -> Field -> uint32_t
    os << YAML::Value << t.maxQualityLevels;
    os << YAML::Key << "encodeInputPictureGranularity";
    // encodeInputPictureGranularity -> Field -> VkExtent2D
    os << YAML::Value << t.encodeInputPictureGranularity;
    os << YAML::Key << "supportedEncodeFeedbackFlags";
    // supportedEncodeFeedbackFlags -> Field -> VkVideoEncodeFeedbackFlagsKHR
    os << YAML::Value << t.supportedEncodeFeedbackFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueryPoolVideoEncodeFeedbackCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "encodeFeedbackFlags";
    // encodeFeedbackFlags -> Field -> VkVideoEncodeFeedbackFlagsKHR
    os << YAML::Value << t.encodeFeedbackFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeUsageInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoUsageHints";
    // videoUsageHints -> Field -> VkVideoEncodeUsageFlagsKHR
    os << YAML::Value << t.videoUsageHints;
    os << YAML::Key << "videoContentHints";
    // videoContentHints -> Field -> VkVideoEncodeContentFlagsKHR
    os << YAML::Value << t.videoContentHints;
    os << YAML::Key << "tuningMode";
    // tuningMode -> Field -> VkVideoEncodeTuningModeKHR
    os << YAML::Value << t.tuningMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeRateControlLayerInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "averageBitrate";
    // averageBitrate -> Field -> uint64_t
    os << YAML::Value << t.averageBitrate;
    os << YAML::Key << "maxBitrate";
    // maxBitrate -> Field -> uint64_t
    os << YAML::Value << t.maxBitrate;
    os << YAML::Key << "frameRateNumerator";
    // frameRateNumerator -> Field -> uint32_t
    os << YAML::Value << t.frameRateNumerator;
    os << YAML::Key << "frameRateDenominator";
    // frameRateDenominator -> Field -> uint32_t
    os << YAML::Value << t.frameRateDenominator;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeRateControlInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeRateControlFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "rateControlMode";
    // rateControlMode -> Field -> VkVideoEncodeRateControlModeFlagBitsKHR
    os << YAML::Value << t.rateControlMode;
    os << YAML::Key << "layerCount";
    // layerCount -> Field -> uint32_t
    os << YAML::Value << t.layerCount;
    os << YAML::Key << "pLayers";
    // pLayers -> Field -> ConstDynamicArray(VkVideoEncodeRateControlLayerInfoKHR)
    if (t.layerCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkVideoEncodeRateControlLayerInfoKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.layerCount); ++i) {
                os << t.pLayers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "virtualBufferSizeInMs";
    // virtualBufferSizeInMs -> Field -> uint32_t
    os << YAML::Value << t.virtualBufferSizeInMs;
    os << YAML::Key << "initialVirtualBufferSizeInMs";
    // initialVirtualBufferSizeInMs -> Field -> uint32_t
    os << YAML::Value << t.initialVirtualBufferSizeInMs;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pVideoProfile";
    // pointer
    if (t.pVideoProfile != nullptr) {
        os << YAML::Value << *t.pVideoProfile;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "qualityLevel";
    // qualityLevel -> Field -> uint32_t
    os << YAML::Value << t.qualityLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeQualityLevelPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "preferredRateControlMode";
    // preferredRateControlMode -> Field -> VkVideoEncodeRateControlModeFlagBitsKHR
    os << YAML::Value << t.preferredRateControlMode;
    os << YAML::Key << "preferredRateControlLayerCount";
    // preferredRateControlLayerCount -> Field -> uint32_t
    os << YAML::Value << t.preferredRateControlLayerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeQualityLevelInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "qualityLevel";
    // qualityLevel -> Field -> uint32_t
    os << YAML::Value << t.qualityLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeSessionParametersGetInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoSessionParameters";
    // videoSessionParameters -> Field -> VkVideoSessionParametersKHR
    os << YAML::Value << t.videoSessionParameters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeSessionParametersFeedbackInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hasOverrides";
    // hasOverrides -> Field -> VkBool32
    os << YAML::Value << t.hasOverrides;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentShaderBarycentric";
    // fragmentShaderBarycentric -> Field -> VkBool32
    os << YAML::Value << t.fragmentShaderBarycentric;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "triStripVertexOrderIndependentOfProvokingVertex";
    // triStripVertexOrderIndependentOfProvokingVertex -> Field -> VkBool32
    os << YAML::Value << t.triStripVertexOrderIndependentOfProvokingVertex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSubgroupUniformControlFlow";
    // shaderSubgroupUniformControlFlow -> Field -> VkBool32
    os << YAML::Value << t.shaderSubgroupUniformControlFlow;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "workgroupMemoryExplicitLayout";
    // workgroupMemoryExplicitLayout -> Field -> VkBool32
    os << YAML::Value << t.workgroupMemoryExplicitLayout;
    os << YAML::Key << "workgroupMemoryExplicitLayoutScalarBlockLayout";
    // workgroupMemoryExplicitLayoutScalarBlockLayout -> Field -> VkBool32
    os << YAML::Value << t.workgroupMemoryExplicitLayoutScalarBlockLayout;
    os << YAML::Key << "workgroupMemoryExplicitLayout8BitAccess";
    // workgroupMemoryExplicitLayout8BitAccess -> Field -> VkBool32
    os << YAML::Value << t.workgroupMemoryExplicitLayout8BitAccess;
    os << YAML::Key << "workgroupMemoryExplicitLayout16BitAccess";
    // workgroupMemoryExplicitLayout16BitAccess -> Field -> VkBool32
    os << YAML::Value << t.workgroupMemoryExplicitLayout16BitAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rayTracingMaintenance1";
    // rayTracingMaintenance1 -> Field -> VkBool32
    os << YAML::Value << t.rayTracingMaintenance1;
    os << YAML::Key << "rayTracingPipelineTraceRaysIndirect2";
    // rayTracingPipelineTraceRaysIndirect2 -> Field -> VkBool32
    os << YAML::Value << t.rayTracingPipelineTraceRaysIndirect2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTraceRaysIndirectCommand2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "raygenShaderRecordAddress";
    // raygenShaderRecordAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.raygenShaderRecordAddress);
    os << YAML::Key << "raygenShaderRecordSize";
    // raygenShaderRecordSize -> Field -> VkDeviceSize
    os << YAML::Value << t.raygenShaderRecordSize;
    os << YAML::Key << "missShaderBindingTableAddress";
    // missShaderBindingTableAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.missShaderBindingTableAddress);
    os << YAML::Key << "missShaderBindingTableSize";
    // missShaderBindingTableSize -> Field -> VkDeviceSize
    os << YAML::Value << t.missShaderBindingTableSize;
    os << YAML::Key << "missShaderBindingTableStride";
    // missShaderBindingTableStride -> Field -> VkDeviceSize
    os << YAML::Value << t.missShaderBindingTableStride;
    os << YAML::Key << "hitShaderBindingTableAddress";
    // hitShaderBindingTableAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.hitShaderBindingTableAddress);
    os << YAML::Key << "hitShaderBindingTableSize";
    // hitShaderBindingTableSize -> Field -> VkDeviceSize
    os << YAML::Value << t.hitShaderBindingTableSize;
    os << YAML::Key << "hitShaderBindingTableStride";
    // hitShaderBindingTableStride -> Field -> VkDeviceSize
    os << YAML::Value << t.hitShaderBindingTableStride;
    os << YAML::Key << "callableShaderBindingTableAddress";
    // callableShaderBindingTableAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.callableShaderBindingTableAddress);
    os << YAML::Key << "callableShaderBindingTableSize";
    // callableShaderBindingTableSize -> Field -> VkDeviceSize
    os << YAML::Value << t.callableShaderBindingTableSize;
    os << YAML::Key << "callableShaderBindingTableStride";
    // callableShaderBindingTableStride -> Field -> VkDeviceSize
    os << YAML::Value << t.callableShaderBindingTableStride;
    os << YAML::Key << "width";
    // width -> Field -> uint32_t
    os << YAML::Value << t.width;
    os << YAML::Key << "height";
    // height -> Field -> uint32_t
    os << YAML::Value << t.height;
    os << YAML::Key << "depth";
    // depth -> Field -> uint32_t
    os << YAML::Value << t.depth;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderUntypedPointersFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderUntypedPointers";
    // shaderUntypedPointers -> Field -> VkBool32
    os << YAML::Value << t.shaderUntypedPointers;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderMaximalReconvergence";
    // shaderMaximalReconvergence -> Field -> VkBool32
    os << YAML::Value << t.shaderMaximalReconvergence;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilitiesPresentId2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentId2Supported";
    // presentId2Supported -> Field -> VkBool32
    os << YAML::Value << t.presentId2Supported;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentId2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pPresentIds";
    // pPresentIds -> Field -> ConstDynamicArray(uint64_t)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pPresentIds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentId2FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentId2";
    // presentId2 -> Field -> VkBool32
    os << YAML::Value << t.presentId2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilitiesPresentWait2KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentWait2Supported";
    // presentWait2Supported -> Field -> VkBool32
    os << YAML::Value << t.presentWait2Supported;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentWait2FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentWait2";
    // presentWait2 -> Field -> VkBool32
    os << YAML::Value << t.presentWait2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentWait2InfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentId";
    // presentId -> Field -> uint64_t
    os << YAML::Value << t.presentId;
    os << YAML::Key << "timeout";
    // timeout -> Field -> uint64_t
    os << YAML::Value << t.timeout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rayTracingPositionFetch";
    // rayTracingPositionFetch -> Field -> VkBool32
    os << YAML::Value << t.rayTracingPositionFetch;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineBinaryFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBinaries";
    // pipelineBinaries -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaries;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePipelineBinaryPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBinaryInternalCache";
    // pipelineBinaryInternalCache -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaryInternalCache;
    os << YAML::Key << "pipelineBinaryInternalCacheControl";
    // pipelineBinaryInternalCacheControl -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaryInternalCacheControl;
    os << YAML::Key << "pipelineBinaryPrefersInternalCache";
    // pipelineBinaryPrefersInternalCache -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaryPrefersInternalCache;
    os << YAML::Key << "pipelineBinaryPrecompiledInternalCache";
    // pipelineBinaryPrecompiledInternalCache -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaryPrecompiledInternalCache;
    os << YAML::Key << "pipelineBinaryCompressedData";
    // pipelineBinaryCompressedData -> Field -> VkBool32
    os << YAML::Value << t.pipelineBinaryCompressedData;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDevicePipelineBinaryInternalCacheControlKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "disableInternalCache";
    // disableInternalCache -> Field -> VkBool32
    os << YAML::Value << t.disableInternalCache;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryKeyKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "keySize";
    // keySize -> Field -> uint32_t
    os << YAML::Value << t.keySize;
    os << YAML::Key << "key";
    // key -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR); ++i) {
                os << t.key[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryDataKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> size_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryKeysAndDataKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "binaryCount";
    // binaryCount -> Field -> uint32_t
    os << YAML::Value << t.binaryCount;
    os << YAML::Key << "pPipelineBinaryKeys";
    // pPipelineBinaryKeys -> Field -> ConstDynamicArray(VkPipelineBinaryKeyKHR)
    if (t.binaryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineBinaryKeyKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.binaryCount); ++i) {
                os << t.pPipelineBinaryKeys[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pPipelineBinaryData";
    // pPipelineBinaryData -> Field -> ConstDynamicArray(VkPipelineBinaryDataKHR)
    if (t.binaryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineBinaryDataKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.binaryCount); ++i) {
                os << t.pPipelineBinaryData[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pKeysAndDataInfo";
    // pointer
    if (t.pKeysAndDataInfo != nullptr) {
        os << YAML::Value << *t.pKeysAndDataInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::Key << "pPipelineCreateInfo";
    // pointer
    if (t.pPipelineCreateInfo != nullptr) {
        os << YAML::Value << *t.pPipelineCreateInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "binaryCount";
    // binaryCount -> Field -> uint32_t
    os << YAML::Value << t.binaryCount;
    os << YAML::Key << "pPipelineBinaries";
    // pPipelineBinaries -> Field -> ConstDynamicArray(VkPipelineBinaryKHR)
    if (t.binaryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineBinaryKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.binaryCount); ++i) {
                os << t.pPipelineBinaries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkReleaseCapturedPipelineDataInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryDataInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBinary";
    // pipelineBinary -> Field -> VkPipelineBinaryKHR
    os << YAML::Value << t.pipelineBinary;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineBinaryHandlesInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBinaryCount";
    // pipelineBinaryCount -> Field -> uint32_t
    os << YAML::Value << t.pipelineBinaryCount;
    os << YAML::Key << "pPipelineBinaries";
    // pPipelineBinaries -> Field -> DynamicArray(VkPipelineBinaryKHR)
    if (t.pipelineBinaryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineBinaryKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.pipelineBinaryCount); ++i) {
                os << t.pPipelineBinaries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfacePresentModeKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentMode";
    // presentMode -> Field -> VkPresentModeKHR
    os << YAML::Value << t.presentMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfacePresentScalingCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supportedPresentScaling";
    // supportedPresentScaling -> Field -> VkPresentScalingFlagsKHR
    os << YAML::Value << t.supportedPresentScaling;
    os << YAML::Key << "supportedPresentGravityX";
    // supportedPresentGravityX -> Field -> VkPresentGravityFlagsKHR
    os << YAML::Value << t.supportedPresentGravityX;
    os << YAML::Key << "supportedPresentGravityY";
    // supportedPresentGravityY -> Field -> VkPresentGravityFlagsKHR
    os << YAML::Value << t.supportedPresentGravityY;
    os << YAML::Key << "minScaledImageExtent";
    // minScaledImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minScaledImageExtent;
    os << YAML::Key << "maxScaledImageExtent";
    // maxScaledImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxScaledImageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfacePresentModeCompatibilityKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentModeCount";
    // presentModeCount -> Field -> uint32_t
    os << YAML::Value << t.presentModeCount;
    os << YAML::Key << "pPresentModes";
    // pPresentModes -> Field -> DynamicArray(VkPresentModeKHR)
    if (t.presentModeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentModeKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.presentModeCount); ++i) {
                os << t.pPresentModes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSwapchainMaintenance1FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainMaintenance1";
    // swapchainMaintenance1 -> Field -> VkBool32
    os << YAML::Value << t.swapchainMaintenance1;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainPresentFenceInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pFences";
    // pFences -> Field -> ConstDynamicArray(VkFence)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFence");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pFences[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainPresentModesCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentModeCount";
    // presentModeCount -> Field -> uint32_t
    os << YAML::Value << t.presentModeCount;
    os << YAML::Key << "pPresentModes";
    // pPresentModes -> Field -> ConstDynamicArray(VkPresentModeKHR)
    if (t.presentModeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentModeKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.presentModeCount); ++i) {
                os << t.pPresentModes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainPresentModeInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pPresentModes";
    // pPresentModes -> Field -> ConstDynamicArray(VkPresentModeKHR)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentModeKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pPresentModes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainPresentScalingCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "scalingBehavior";
    // scalingBehavior -> Field -> VkPresentScalingFlagsKHR
    os << YAML::Value << t.scalingBehavior;
    os << YAML::Key << "presentGravityX";
    // presentGravityX -> Field -> VkPresentGravityFlagsKHR
    os << YAML::Value << t.presentGravityX;
    os << YAML::Key << "presentGravityY";
    // presentGravityY -> Field -> VkPresentGravityFlagsKHR
    os << YAML::Value << t.presentGravityY;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkReleaseSwapchainImagesInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::Key << "imageIndexCount";
    // imageIndexCount -> Field -> uint32_t
    os << YAML::Value << t.imageIndexCount;
    os << YAML::Key << "pImageIndices";
    // pImageIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.imageIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.imageIndexCount); ++i) {
                os << t.pImageIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceInternallySynchronizedQueuesFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "internallySynchronizedQueues";
    // internallySynchronizedQueues -> Field -> VkBool32
    os << YAML::Value << t.internallySynchronizedQueues;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCooperativeMatrixPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "MSize";
    // MSize -> Field -> uint32_t
    os << YAML::Value << t.MSize;
    os << YAML::Key << "NSize";
    // NSize -> Field -> uint32_t
    os << YAML::Value << t.NSize;
    os << YAML::Key << "KSize";
    // KSize -> Field -> uint32_t
    os << YAML::Value << t.KSize;
    os << YAML::Key << "AType";
    // AType -> Field -> VkComponentTypeKHR
    os << YAML::Value << t.AType;
    os << YAML::Key << "BType";
    // BType -> Field -> VkComponentTypeKHR
    os << YAML::Value << t.BType;
    os << YAML::Key << "CType";
    // CType -> Field -> VkComponentTypeKHR
    os << YAML::Value << t.CType;
    os << YAML::Key << "ResultType";
    // ResultType -> Field -> VkComponentTypeKHR
    os << YAML::Value << t.ResultType;
    os << YAML::Key << "saturatingAccumulation";
    // saturatingAccumulation -> Field -> VkBool32
    os << YAML::Value << t.saturatingAccumulation;
    os << YAML::Key << "scope";
    // scope -> Field -> VkScopeKHR
    os << YAML::Value << t.scope;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCooperativeMatrixFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cooperativeMatrix";
    // cooperativeMatrix -> Field -> VkBool32
    os << YAML::Value << t.cooperativeMatrix;
    os << YAML::Key << "cooperativeMatrixRobustBufferAccess";
    // cooperativeMatrixRobustBufferAccess -> Field -> VkBool32
    os << YAML::Value << t.cooperativeMatrixRobustBufferAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCooperativeMatrixPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cooperativeMatrixSupportedStages";
    // cooperativeMatrixSupportedStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.cooperativeMatrixSupportedStages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "computeDerivativeGroupQuads";
    // computeDerivativeGroupQuads -> Field -> VkBool32
    os << YAML::Value << t.computeDerivativeGroupQuads;
    os << YAML::Key << "computeDerivativeGroupLinear";
    // computeDerivativeGroupLinear -> Field -> VkBool32
    os << YAML::Value << t.computeDerivativeGroupLinear;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "meshAndTaskShaderDerivatives";
    // meshAndTaskShaderDerivatives -> Field -> VkBool32
    os << YAML::Value << t.meshAndTaskShaderDerivatives;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfile";
    // stdProfile -> Field -> StdVideoAV1Profile
    os << YAML::Value << t.stdProfile;
    os << YAML::Key << "filmGrainSupport";
    // filmGrainSupport -> Field -> VkBool32
    os << YAML::Value << t.filmGrainSupport;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxLevel";
    // maxLevel -> Field -> StdVideoAV1Level
    os << YAML::Value << t.maxLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdSequenceHeader";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSequenceHeader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "referenceNameSlotIndices";
    // referenceNameSlotIndices -> Field -> FixedArray(int32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("int32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR); ++i) {
                os << t.referenceNameSlotIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "frameHeaderOffset";
    // frameHeaderOffset -> Field -> uint32_t
    os << YAML::Value << t.frameHeaderOffset;
    os << YAML::Key << "tileCount";
    // tileCount -> Field -> uint32_t
    os << YAML::Value << t.tileCount;
    os << YAML::Key << "pTileOffsets";
    // pTileOffsets -> Field -> ConstDynamicArray(uint32_t)
    if (t.tileCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.tileCount); ++i) {
                os << t.pTileOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pTileSizes";
    // pTileSizes -> Field -> ConstDynamicArray(uint32_t)
    if (t.tileCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.tileCount); ++i) {
                os << t.pTileSizes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoEncodeAV1FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoEncodeAV1";
    // videoEncodeAV1 -> Field -> VkBool32
    os << YAML::Value << t.videoEncodeAV1;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeAV1CapabilityFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "maxLevel";
    // maxLevel -> Field -> StdVideoAV1Level
    os << YAML::Value << t.maxLevel;
    os << YAML::Key << "codedPictureAlignment";
    // codedPictureAlignment -> Field -> VkExtent2D
    os << YAML::Value << t.codedPictureAlignment;
    os << YAML::Key << "maxTiles";
    // maxTiles -> Field -> VkExtent2D
    os << YAML::Value << t.maxTiles;
    os << YAML::Key << "minTileSize";
    // minTileSize -> Field -> VkExtent2D
    os << YAML::Value << t.minTileSize;
    os << YAML::Key << "maxTileSize";
    // maxTileSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxTileSize;
    os << YAML::Key << "superblockSizes";
    // superblockSizes -> Field -> VkVideoEncodeAV1SuperblockSizeFlagsKHR
    os << YAML::Value << t.superblockSizes;
    os << YAML::Key << "maxSingleReferenceCount";
    // maxSingleReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxSingleReferenceCount;
    os << YAML::Key << "singleReferenceNameMask";
    // singleReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.singleReferenceNameMask;
    os << YAML::Key << "maxUnidirectionalCompoundReferenceCount";
    // maxUnidirectionalCompoundReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxUnidirectionalCompoundReferenceCount;
    os << YAML::Key << "maxUnidirectionalCompoundGroup1ReferenceCount";
    // maxUnidirectionalCompoundGroup1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxUnidirectionalCompoundGroup1ReferenceCount;
    os << YAML::Key << "unidirectionalCompoundReferenceNameMask";
    // unidirectionalCompoundReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.unidirectionalCompoundReferenceNameMask;
    os << YAML::Key << "maxBidirectionalCompoundReferenceCount";
    // maxBidirectionalCompoundReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxBidirectionalCompoundReferenceCount;
    os << YAML::Key << "maxBidirectionalCompoundGroup1ReferenceCount";
    // maxBidirectionalCompoundGroup1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxBidirectionalCompoundGroup1ReferenceCount;
    os << YAML::Key << "maxBidirectionalCompoundGroup2ReferenceCount";
    // maxBidirectionalCompoundGroup2ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxBidirectionalCompoundGroup2ReferenceCount;
    os << YAML::Key << "bidirectionalCompoundReferenceNameMask";
    // bidirectionalCompoundReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.bidirectionalCompoundReferenceNameMask;
    os << YAML::Key << "maxTemporalLayerCount";
    // maxTemporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.maxTemporalLayerCount;
    os << YAML::Key << "maxSpatialLayerCount";
    // maxSpatialLayerCount -> Field -> uint32_t
    os << YAML::Value << t.maxSpatialLayerCount;
    os << YAML::Key << "maxOperatingPoints";
    // maxOperatingPoints -> Field -> uint32_t
    os << YAML::Value << t.maxOperatingPoints;
    os << YAML::Key << "minQIndex";
    // minQIndex -> Field -> uint32_t
    os << YAML::Value << t.minQIndex;
    os << YAML::Key << "maxQIndex";
    // maxQIndex -> Field -> uint32_t
    os << YAML::Value << t.maxQIndex;
    os << YAML::Key << "prefersGopRemainingFrames";
    // prefersGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.prefersGopRemainingFrames;
    os << YAML::Key << "requiresGopRemainingFrames";
    // requiresGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.requiresGopRemainingFrames;
    os << YAML::Key << "stdSyntaxFlags";
    // stdSyntaxFlags -> Field -> VkVideoEncodeAV1StdFlagsKHR
    os << YAML::Value << t.stdSyntaxFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1QIndexKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "intraQIndex";
    // intraQIndex -> Field -> uint32_t
    os << YAML::Value << t.intraQIndex;
    os << YAML::Key << "predictiveQIndex";
    // predictiveQIndex -> Field -> uint32_t
    os << YAML::Value << t.predictiveQIndex;
    os << YAML::Key << "bipredictiveQIndex";
    // bipredictiveQIndex -> Field -> uint32_t
    os << YAML::Value << t.bipredictiveQIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1QualityLevelPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "preferredRateControlFlags";
    // preferredRateControlFlags -> Field -> VkVideoEncodeAV1RateControlFlagsKHR
    os << YAML::Value << t.preferredRateControlFlags;
    os << YAML::Key << "preferredGopFrameCount";
    // preferredGopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredGopFrameCount;
    os << YAML::Key << "preferredKeyFramePeriod";
    // preferredKeyFramePeriod -> Field -> uint32_t
    os << YAML::Value << t.preferredKeyFramePeriod;
    os << YAML::Key << "preferredConsecutiveBipredictiveFrameCount";
    // preferredConsecutiveBipredictiveFrameCount -> Field -> uint32_t
    os << YAML::Value << t.preferredConsecutiveBipredictiveFrameCount;
    os << YAML::Key << "preferredTemporalLayerCount";
    // preferredTemporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.preferredTemporalLayerCount;
    os << YAML::Key << "preferredConstantQIndex";
    // preferredConstantQIndex -> Field -> VkVideoEncodeAV1QIndexKHR
    os << YAML::Value << t.preferredConstantQIndex;
    os << YAML::Key << "preferredMaxSingleReferenceCount";
    // preferredMaxSingleReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxSingleReferenceCount;
    os << YAML::Key << "preferredSingleReferenceNameMask";
    // preferredSingleReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.preferredSingleReferenceNameMask;
    os << YAML::Key << "preferredMaxUnidirectionalCompoundReferenceCount";
    // preferredMaxUnidirectionalCompoundReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxUnidirectionalCompoundReferenceCount;
    os << YAML::Key << "preferredMaxUnidirectionalCompoundGroup1ReferenceCount";
    // preferredMaxUnidirectionalCompoundGroup1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxUnidirectionalCompoundGroup1ReferenceCount;
    os << YAML::Key << "preferredUnidirectionalCompoundReferenceNameMask";
    // preferredUnidirectionalCompoundReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.preferredUnidirectionalCompoundReferenceNameMask;
    os << YAML::Key << "preferredMaxBidirectionalCompoundReferenceCount";
    // preferredMaxBidirectionalCompoundReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxBidirectionalCompoundReferenceCount;
    os << YAML::Key << "preferredMaxBidirectionalCompoundGroup1ReferenceCount";
    // preferredMaxBidirectionalCompoundGroup1ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxBidirectionalCompoundGroup1ReferenceCount;
    os << YAML::Key << "preferredMaxBidirectionalCompoundGroup2ReferenceCount";
    // preferredMaxBidirectionalCompoundGroup2ReferenceCount -> Field -> uint32_t
    os << YAML::Value << t.preferredMaxBidirectionalCompoundGroup2ReferenceCount;
    os << YAML::Key << "preferredBidirectionalCompoundReferenceNameMask";
    // preferredBidirectionalCompoundReferenceNameMask -> Field -> uint32_t
    os << YAML::Value << t.preferredBidirectionalCompoundReferenceNameMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1SessionCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMaxLevel";
    // useMaxLevel -> Field -> VkBool32
    os << YAML::Value << t.useMaxLevel;
    os << YAML::Key << "maxLevel";
    // maxLevel -> Field -> StdVideoAV1Level
    os << YAML::Value << t.maxLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1SessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdSequenceHeader";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSequenceHeader;
    os << YAML::Key << "pStdDecoderModelInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdDecoderModelInfo;
    os << YAML::Key << "stdOperatingPointCount";
    // stdOperatingPointCount -> Field -> uint32_t
    os << YAML::Value << t.stdOperatingPointCount;
    os << YAML::Key << "pStdOperatingPoints";
    // pStdOperatingPoints -> Field -> ConstDynamicArray(StdVideoEncodeAV1OperatingPointInfo)
    if (t.stdOperatingPointCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        { os << YAML::Comment("StdVideoEncodeAV1OperatingPointInfo"); }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "predictionMode";
    // predictionMode -> Field -> VkVideoEncodeAV1PredictionModeKHR
    os << YAML::Value << t.predictionMode;
    os << YAML::Key << "rateControlGroup";
    // rateControlGroup -> Field -> VkVideoEncodeAV1RateControlGroupKHR
    os << YAML::Value << t.rateControlGroup;
    os << YAML::Key << "constantQIndex";
    // constantQIndex -> Field -> uint32_t
    os << YAML::Value << t.constantQIndex;
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "referenceNameSlotIndices";
    // referenceNameSlotIndices -> Field -> FixedArray(int32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("int32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR); ++i) {
                os << t.referenceNameSlotIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "primaryReferenceCdfOnly";
    // primaryReferenceCdfOnly -> Field -> VkBool32
    os << YAML::Value << t.primaryReferenceCdfOnly;
    os << YAML::Key << "generateObuExtensionHeader";
    // generateObuExtensionHeader -> Field -> VkBool32
    os << YAML::Value << t.generateObuExtensionHeader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1DpbSlotInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdReferenceInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdReferenceInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfile";
    // stdProfile -> Field -> StdVideoAV1Profile
    os << YAML::Value << t.stdProfile;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1FrameSizeKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "intraFrameSize";
    // intraFrameSize -> Field -> uint32_t
    os << YAML::Value << t.intraFrameSize;
    os << YAML::Key << "predictiveFrameSize";
    // predictiveFrameSize -> Field -> uint32_t
    os << YAML::Value << t.predictiveFrameSize;
    os << YAML::Key << "bipredictiveFrameSize";
    // bipredictiveFrameSize -> Field -> uint32_t
    os << YAML::Value << t.bipredictiveFrameSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1GopRemainingFrameInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useGopRemainingFrames";
    // useGopRemainingFrames -> Field -> VkBool32
    os << YAML::Value << t.useGopRemainingFrames;
    os << YAML::Key << "gopRemainingIntra";
    // gopRemainingIntra -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingIntra;
    os << YAML::Key << "gopRemainingPredictive";
    // gopRemainingPredictive -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingPredictive;
    os << YAML::Key << "gopRemainingBipredictive";
    // gopRemainingBipredictive -> Field -> uint32_t
    os << YAML::Value << t.gopRemainingBipredictive;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1RateControlInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkVideoEncodeAV1RateControlFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "gopFrameCount";
    // gopFrameCount -> Field -> uint32_t
    os << YAML::Value << t.gopFrameCount;
    os << YAML::Key << "keyFramePeriod";
    // keyFramePeriod -> Field -> uint32_t
    os << YAML::Value << t.keyFramePeriod;
    os << YAML::Key << "consecutiveBipredictiveFrameCount";
    // consecutiveBipredictiveFrameCount -> Field -> uint32_t
    os << YAML::Value << t.consecutiveBipredictiveFrameCount;
    os << YAML::Key << "temporalLayerCount";
    // temporalLayerCount -> Field -> uint32_t
    os << YAML::Value << t.temporalLayerCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1RateControlLayerInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "useMinQIndex";
    // useMinQIndex -> Field -> VkBool32
    os << YAML::Value << t.useMinQIndex;
    os << YAML::Key << "minQIndex";
    // minQIndex -> Field -> VkVideoEncodeAV1QIndexKHR
    os << YAML::Value << t.minQIndex;
    os << YAML::Key << "useMaxQIndex";
    // useMaxQIndex -> Field -> VkBool32
    os << YAML::Value << t.useMaxQIndex;
    os << YAML::Key << "maxQIndex";
    // maxQIndex -> Field -> VkVideoEncodeAV1QIndexKHR
    os << YAML::Value << t.maxQIndex;
    os << YAML::Key << "useMaxFrameSize";
    // useMaxFrameSize -> Field -> VkBool32
    os << YAML::Value << t.useMaxFrameSize;
    os << YAML::Key << "maxFrameSize";
    // maxFrameSize -> Field -> VkVideoEncodeAV1FrameSizeKHR
    os << YAML::Value << t.maxFrameSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoDecodeVP9FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoDecodeVP9";
    // videoDecodeVP9 -> Field -> VkBool32
    os << YAML::Value << t.videoDecodeVP9;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeVP9ProfileInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stdProfile";
    // stdProfile -> Field -> StdVideoVP9Profile
    os << YAML::Value << t.stdProfile;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeVP9CapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxLevel";
    // maxLevel -> Field -> StdVideoVP9Level
    os << YAML::Value << t.maxLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeVP9PictureInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdPictureInfo";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPictureInfo;
    os << YAML::Key << "referenceNameSlotIndices";
    // referenceNameSlotIndices -> Field -> FixedArray(int32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("int32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_VIDEO_VP9_REFERENCES_PER_FRAME_KHR); ++i) {
                os << t.referenceNameSlotIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "uncompressedHeaderOffset";
    // uncompressedHeaderOffset -> Field -> uint32_t
    os << YAML::Value << t.uncompressedHeaderOffset;
    os << YAML::Key << "compressedHeaderOffset";
    // compressedHeaderOffset -> Field -> uint32_t
    os << YAML::Value << t.compressedHeaderOffset;
    os << YAML::Key << "tilesOffset";
    // tilesOffset -> Field -> uint32_t
    os << YAML::Value << t.tilesOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoMaintenance1FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoMaintenance1";
    // videoMaintenance1 -> Field -> VkBool32
    os << YAML::Value << t.videoMaintenance1;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoInlineQueryInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queryPool";
    // queryPool -> Field -> VkQueryPool
    os << YAML::Value << t.queryPool;
    os << YAML::Key << "firstQuery";
    // firstQuery -> Field -> uint32_t
    os << YAML::Value << t.firstQuery;
    os << YAML::Key << "queryCount";
    // queryCount -> Field -> uint32_t
    os << YAML::Value << t.queryCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceUnifiedImageLayoutsFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "unifiedImageLayouts";
    // unifiedImageLayouts -> Field -> VkBool32
    os << YAML::Value << t.unifiedImageLayouts;
    os << YAML::Key << "unifiedImageLayoutsVideo";
    // unifiedImageLayoutsVideo -> Field -> VkBool32
    os << YAML::Value << t.unifiedImageLayoutsVideo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentFeedbackLoopInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "feedbackLoopEnable";
    // feedbackLoopEnable -> Field -> VkBool32
    os << YAML::Value << t.feedbackLoopEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCalibratedTimestampInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "timeDomain";
    // timeDomain -> Field -> VkTimeDomainKHR
    os << YAML::Value << t.timeDomain;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSetDescriptorBufferOffsetsInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "firstSet";
    // firstSet -> Field -> uint32_t
    os << YAML::Value << t.firstSet;
    os << YAML::Key << "setCount";
    // setCount -> Field -> uint32_t
    os << YAML::Value << t.setCount;
    os << YAML::Key << "pBufferIndices";
    // pBufferIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.setCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.setCount); ++i) {
                os << t.pBufferIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pOffsets";
    // pOffsets -> Field -> ConstDynamicArray(VkDeviceSize)
    if (t.setCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceSize");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.setCount); ++i) {
                os << t.pOffsets[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stageFlags";
    // stageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.stageFlags;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "set";
    // set -> Field -> uint32_t
    os << YAML::Value << t.set;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkStridedDeviceAddressRangeKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "address";
    // address -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.address);
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "stride";
    // stride -> Field -> VkDeviceSize
    os << YAML::Value << t.stride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyMemoryIndirectCommandKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcAddress";
    // srcAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.srcAddress);
    os << YAML::Key << "dstAddress";
    // dstAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.dstAddress);
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyMemoryIndirectInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcCopyFlags";
    // srcCopyFlags -> Field -> VkAddressCopyFlagsKHR
    os << YAML::Value << t.srcCopyFlags;
    os << YAML::Key << "dstCopyFlags";
    // dstCopyFlags -> Field -> VkAddressCopyFlagsKHR
    os << YAML::Value << t.dstCopyFlags;
    os << YAML::Key << "copyCount";
    // copyCount -> Field -> uint32_t
    os << YAML::Value << t.copyCount;
    os << YAML::Key << "copyAddressRange";
    // copyAddressRange -> Field -> VkStridedDeviceAddressRangeKHR
    os << YAML::Value << t.copyAddressRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyMemoryToImageIndirectCommandKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "srcAddress";
    // srcAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.srcAddress);
    os << YAML::Key << "bufferRowLength";
    // bufferRowLength -> Field -> uint32_t
    os << YAML::Value << t.bufferRowLength;
    os << YAML::Key << "bufferImageHeight";
    // bufferImageHeight -> Field -> uint32_t
    os << YAML::Value << t.bufferImageHeight;
    os << YAML::Key << "imageSubresource";
    // imageSubresource -> Field -> VkImageSubresourceLayers
    os << YAML::Value << t.imageSubresource;
    os << YAML::Key << "imageOffset";
    // imageOffset -> Field -> VkOffset3D
    os << YAML::Value << t.imageOffset;
    os << YAML::Key << "imageExtent";
    // imageExtent -> Field -> VkExtent3D
    os << YAML::Value << t.imageExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyMemoryToImageIndirectInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcCopyFlags";
    // srcCopyFlags -> Field -> VkAddressCopyFlagsKHR
    os << YAML::Value << t.srcCopyFlags;
    os << YAML::Key << "copyCount";
    // copyCount -> Field -> uint32_t
    os << YAML::Value << t.copyCount;
    os << YAML::Key << "copyAddressRange";
    // copyAddressRange -> Field -> VkStridedDeviceAddressRangeKHR
    os << YAML::Value << t.copyAddressRange;
    os << YAML::Key << "dstImage";
    // dstImage -> Field -> VkImage
    os << YAML::Value << t.dstImage;
    os << YAML::Key << "dstImageLayout";
    // dstImageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.dstImageLayout;
    os << YAML::Key << "pImageSubresources";
    // pImageSubresources -> Field -> ConstDynamicArray(VkImageSubresourceLayers)
    if (t.copyCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageSubresourceLayers");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.copyCount); ++i) {
                os << t.pImageSubresources[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCopyMemoryIndirectFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "indirectMemoryCopy";
    // indirectMemoryCopy -> Field -> VkBool32
    os << YAML::Value << t.indirectMemoryCopy;
    os << YAML::Key << "indirectMemoryToImageCopy";
    // indirectMemoryToImageCopy -> Field -> VkBool32
    os << YAML::Value << t.indirectMemoryToImageCopy;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCopyMemoryIndirectPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supportedQueues";
    // supportedQueues -> Field -> VkQueueFlags
    os << YAML::Value << t.supportedQueues;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeIntraRefreshCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "intraRefreshModes";
    // intraRefreshModes -> Field -> VkVideoEncodeIntraRefreshModeFlagsKHR
    os << YAML::Value << t.intraRefreshModes;
    os << YAML::Key << "maxIntraRefreshCycleDuration";
    // maxIntraRefreshCycleDuration -> Field -> uint32_t
    os << YAML::Value << t.maxIntraRefreshCycleDuration;
    os << YAML::Key << "maxIntraRefreshActiveReferencePictures";
    // maxIntraRefreshActiveReferencePictures -> Field -> uint32_t
    os << YAML::Value << t.maxIntraRefreshActiveReferencePictures;
    os << YAML::Key << "partitionIndependentIntraRefreshRegions";
    // partitionIndependentIntraRefreshRegions -> Field -> VkBool32
    os << YAML::Value << t.partitionIndependentIntraRefreshRegions;
    os << YAML::Key << "nonRectangularIntraRefreshRegions";
    // nonRectangularIntraRefreshRegions -> Field -> VkBool32
    os << YAML::Value << t.nonRectangularIntraRefreshRegions;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeSessionIntraRefreshCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "intraRefreshMode";
    // intraRefreshMode -> Field -> VkVideoEncodeIntraRefreshModeFlagBitsKHR
    os << YAML::Value << t.intraRefreshMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeIntraRefreshInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "intraRefreshCycleDuration";
    // intraRefreshCycleDuration -> Field -> uint32_t
    os << YAML::Value << t.intraRefreshCycleDuration;
    os << YAML::Key << "intraRefreshIndex";
    // intraRefreshIndex -> Field -> uint32_t
    os << YAML::Value << t.intraRefreshIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoReferenceIntraRefreshInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dirtyIntraRefreshRegions";
    // dirtyIntraRefreshRegions -> Field -> uint32_t
    os << YAML::Value << t.dirtyIntraRefreshRegions;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoEncodeIntraRefreshFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoEncodeIntraRefresh";
    // videoEncodeIntraRefresh -> Field -> VkBool32
    os << YAML::Value << t.videoEncodeIntraRefresh;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeQuantizationMapCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxQuantizationMapExtent";
    // maxQuantizationMapExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxQuantizationMapExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoFormatQuantizationMapPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "quantizationMapTexelSize";
    // quantizationMapTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.quantizationMapTexelSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeQuantizationMapInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "quantizationMap";
    // quantizationMap -> Field -> VkImageView
    os << YAML::Value << t.quantizationMap;
    os << YAML::Key << "quantizationMapExtent";
    // quantizationMapExtent -> Field -> VkExtent2D
    os << YAML::Value << t.quantizationMapExtent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "quantizationMapTexelSize";
    // quantizationMapTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.quantizationMapTexelSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoEncodeQuantizationMap";
    // videoEncodeQuantizationMap -> Field -> VkBool32
    os << YAML::Value << t.videoEncodeQuantizationMap;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH264QuantizationMapCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minQpDelta";
    // minQpDelta -> Field -> int32_t
    os << YAML::Value << t.minQpDelta;
    os << YAML::Key << "maxQpDelta";
    // maxQpDelta -> Field -> int32_t
    os << YAML::Value << t.maxQpDelta;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeH265QuantizationMapCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minQpDelta";
    // minQpDelta -> Field -> int32_t
    os << YAML::Value << t.minQpDelta;
    os << YAML::Key << "maxQpDelta";
    // maxQpDelta -> Field -> int32_t
    os << YAML::Value << t.maxQpDelta;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoFormatH265QuantizationMapPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "compatibleCtbSizes";
    // compatibleCtbSizes -> Field -> VkVideoEncodeH265CtbSizeFlagsKHR
    os << YAML::Value << t.compatibleCtbSizes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoEncodeAV1QuantizationMapCapabilitiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minQIndexDelta";
    // minQIndexDelta -> Field -> int32_t
    os << YAML::Value << t.minQIndexDelta;
    os << YAML::Key << "maxQIndexDelta";
    // maxQIndexDelta -> Field -> int32_t
    os << YAML::Value << t.maxQIndexDelta;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoFormatAV1QuantizationMapPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "compatibleSuperblockSizes";
    // compatibleSuperblockSizes -> Field -> VkVideoEncodeAV1SuperblockSizeFlagsKHR
    os << YAML::Value << t.compatibleSuperblockSizes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderRelaxedExtendedInstruction";
    // shaderRelaxedExtendedInstruction -> Field -> VkBool32
    os << YAML::Value << t.shaderRelaxedExtendedInstruction;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance7FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance7";
    // maintenance7 -> Field -> VkBool32
    os << YAML::Value << t.maintenance7;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance7PropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "robustFragmentShadingRateAttachmentAccess";
    // robustFragmentShadingRateAttachmentAccess -> Field -> VkBool32
    os << YAML::Value << t.robustFragmentShadingRateAttachmentAccess;
    os << YAML::Key << "separateDepthStencilAttachmentAccess";
    // separateDepthStencilAttachmentAccess -> Field -> VkBool32
    os << YAML::Value << t.separateDepthStencilAttachmentAccess;
    os << YAML::Key << "maxDescriptorSetTotalUniformBuffersDynamic";
    // maxDescriptorSetTotalUniformBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetTotalUniformBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetTotalStorageBuffersDynamic";
    // maxDescriptorSetTotalStorageBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetTotalStorageBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetTotalBuffersDynamic";
    // maxDescriptorSetTotalBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetTotalBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindTotalUniformBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindTotalStorageBuffersDynamic;
    os << YAML::Key << "maxDescriptorSetUpdateAfterBindTotalBuffersDynamic";
    // maxDescriptorSetUpdateAfterBindTotalBuffersDynamic -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetUpdateAfterBindTotalBuffersDynamic;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLayeredApiPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vendorID";
    // vendorID -> Field -> uint32_t
    os << YAML::Value << t.vendorID;
    os << YAML::Key << "deviceID";
    // deviceID -> Field -> uint32_t
    os << YAML::Value << t.deviceID;
    os << YAML::Key << "layeredAPI";
    // layeredAPI -> Field -> VkPhysicalDeviceLayeredApiKHR
    os << YAML::Value << t.layeredAPI;
    os << YAML::Key << "deviceName";
    // deviceName -> Field -> FixedArray(char)
    os << YAML::Value << t.deviceName;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLayeredApiPropertiesListKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "layeredApiCount";
    // layeredApiCount -> Field -> uint32_t
    os << YAML::Value << t.layeredApiCount;
    os << YAML::Key << "pLayeredApis";
    // pLayeredApis -> Field -> DynamicArray(VkPhysicalDeviceLayeredApiPropertiesKHR)
    if (t.layeredApiCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPhysicalDeviceLayeredApiPropertiesKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.layeredApiCount); ++i) {
                os << t.pLayeredApis[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceLayeredApiVulkanPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "properties";
    // properties -> Field -> VkPhysicalDeviceProperties2
    os << YAML::Value << t.properties;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryBarrierAccessFlags3KHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcAccessMask3";
    // srcAccessMask3 -> Field -> VkAccessFlags3KHR
    os << YAML::Value << t.srcAccessMask3;
    os << YAML::Key << "dstAccessMask3";
    // dstAccessMask3 -> Field -> VkAccessFlags3KHR
    os << YAML::Value << t.dstAccessMask3;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance8FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance8";
    // maintenance8 -> Field -> VkBool32
    os << YAML::Value << t.maintenance8;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderFmaFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderFmaFloat16";
    // shaderFmaFloat16 -> Field -> VkBool32
    os << YAML::Value << t.shaderFmaFloat16;
    os << YAML::Key << "shaderFmaFloat32";
    // shaderFmaFloat32 -> Field -> VkBool32
    os << YAML::Value << t.shaderFmaFloat32;
    os << YAML::Key << "shaderFmaFloat64";
    // shaderFmaFloat64 -> Field -> VkBool32
    os << YAML::Value << t.shaderFmaFloat64;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance9FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance9";
    // maintenance9 -> Field -> VkBool32
    os << YAML::Value << t.maintenance9;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance9PropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image2DViewOf3DSparse";
    // image2DViewOf3DSparse -> Field -> VkBool32
    os << YAML::Value << t.image2DViewOf3DSparse;
    os << YAML::Key << "defaultVertexAttributeValue";
    // defaultVertexAttributeValue -> Field -> VkDefaultVertexAttributeValueKHR
    os << YAML::Value << t.defaultVertexAttributeValue;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyOwnershipTransferPropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "optimalImageTransferToQueueFamilies";
    // optimalImageTransferToQueueFamilies -> Field -> uint32_t
    os << YAML::Value << t.optimalImageTransferToQueueFamilies;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVideoMaintenance2FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "videoMaintenance2";
    // videoMaintenance2 -> Field -> VkBool32
    os << YAML::Value << t.videoMaintenance2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH264InlineSessionParametersInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdSPS";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSPS;
    os << YAML::Key << "pStdPPS";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPPS;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeH265InlineSessionParametersInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdVPS";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdVPS;
    os << YAML::Key << "pStdSPS";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSPS;
    os << YAML::Key << "pStdPPS";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdPPS;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVideoDecodeAV1InlineSessionParametersInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pStdSequenceHeader";
    // non-dereferenced pointer
    os << YAML::Value << t.pStdSequenceHeader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthClampZeroOne";
    // depthClampZeroOne -> Field -> VkBool32
    os << YAML::Value << t.depthClampZeroOne;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRobustness2FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "robustBufferAccess2";
    // robustBufferAccess2 -> Field -> VkBool32
    os << YAML::Value << t.robustBufferAccess2;
    os << YAML::Key << "robustImageAccess2";
    // robustImageAccess2 -> Field -> VkBool32
    os << YAML::Value << t.robustImageAccess2;
    os << YAML::Key << "nullDescriptor";
    // nullDescriptor -> Field -> VkBool32
    os << YAML::Value << t.nullDescriptor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRobustness2PropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "robustStorageBufferAccessSizeAlignment";
    // robustStorageBufferAccessSizeAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.robustStorageBufferAccessSizeAlignment;
    os << YAML::Key << "robustUniformBufferAccessSizeAlignment";
    // robustUniformBufferAccessSizeAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.robustUniformBufferAccessSizeAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentModeFifoLatestReadyFeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentModeFifoLatestReady";
    // presentModeFifoLatestReady -> Field -> VkBool32
    os << YAML::Value << t.presentModeFifoLatestReady;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance10FeaturesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maintenance10";
    // maintenance10 -> Field -> VkBool32
    os << YAML::Value << t.maintenance10;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMaintenance10PropertiesKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rgba4OpaqueBlackSwizzled";
    // rgba4OpaqueBlackSwizzled -> Field -> VkBool32
    os << YAML::Value << t.rgba4OpaqueBlackSwizzled;
    os << YAML::Key << "resolveSrgbFormatAppliesTransferFunction";
    // resolveSrgbFormatAppliesTransferFunction -> Field -> VkBool32
    os << YAML::Value << t.resolveSrgbFormatAppliesTransferFunction;
    os << YAML::Key << "resolveSrgbFormatSupportsTransferFunctionControl";
    // resolveSrgbFormatSupportsTransferFunctionControl -> Field -> VkBool32
    os << YAML::Value << t.resolveSrgbFormatSupportsTransferFunctionControl;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingEndInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingAttachmentFlagsInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkRenderingAttachmentFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkResolveImageModeInfoKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkResolveImageFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "resolveMode";
    // resolveMode -> Field -> VkResolveModeFlagBits
    os << YAML::Value << t.resolveMode;
    os << YAML::Key << "stencilResolveMode";
    // stencilResolveMode -> Field -> VkResolveModeFlagBits
    os << YAML::Value << t.stencilResolveMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugReportCallbackCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDebugReportFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "pfnCallback";
    // pointer
    if (t.pfnCallback != nullptr) {
        os << YAML::Value << *t.pfnCallback;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pUserData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationStateRasterizationOrderAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rasterizationOrder";
    // rasterizationOrder -> Field -> VkRasterizationOrderAMD
    os << YAML::Value << t.rasterizationOrder;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugMarkerObjectNameInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "objectType";
    // objectType -> Field -> VkDebugReportObjectTypeEXT
    os << YAML::Value << t.objectType;
    os << YAML::Key << "object";
    // object -> Field -> uint64_t
    os << YAML::Value << t.object;
    os << YAML::Key << "pObjectName";
    // pObjectName -> Field -> string
    os << YAML::Value << t.pObjectName;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugMarkerObjectTagInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "objectType";
    // objectType -> Field -> VkDebugReportObjectTypeEXT
    os << YAML::Value << t.objectType;
    os << YAML::Key << "object";
    // object -> Field -> uint64_t
    os << YAML::Value << t.object;
    os << YAML::Key << "tagName";
    // tagName -> Field -> uint64_t
    os << YAML::Value << t.tagName;
    os << YAML::Key << "tagSize";
    // tagSize -> Field -> size_t
    os << YAML::Value << t.tagSize;
    os << YAML::Key << "pTag";
    if (t.tagSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pTag;
            for (uint64_t i = 0; i < t.tagSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugMarkerMarkerInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pMarkerName";
    // pMarkerName -> Field -> string
    os << YAML::Value << t.pMarkerName;
    os << YAML::Key << "color";
    // color -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.color[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDedicatedAllocationImageCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dedicatedAllocation";
    // dedicatedAllocation -> Field -> VkBool32
    os << YAML::Value << t.dedicatedAllocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDedicatedAllocationBufferCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dedicatedAllocation";
    // dedicatedAllocation -> Field -> VkBool32
    os << YAML::Value << t.dedicatedAllocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDedicatedAllocationMemoryAllocateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTransformFeedbackFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "transformFeedback";
    // transformFeedback -> Field -> VkBool32
    os << YAML::Value << t.transformFeedback;
    os << YAML::Key << "geometryStreams";
    // geometryStreams -> Field -> VkBool32
    os << YAML::Value << t.geometryStreams;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTransformFeedbackPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxTransformFeedbackStreams";
    // maxTransformFeedbackStreams -> Field -> uint32_t
    os << YAML::Value << t.maxTransformFeedbackStreams;
    os << YAML::Key << "maxTransformFeedbackBuffers";
    // maxTransformFeedbackBuffers -> Field -> uint32_t
    os << YAML::Value << t.maxTransformFeedbackBuffers;
    os << YAML::Key << "maxTransformFeedbackBufferSize";
    // maxTransformFeedbackBufferSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxTransformFeedbackBufferSize;
    os << YAML::Key << "maxTransformFeedbackStreamDataSize";
    // maxTransformFeedbackStreamDataSize -> Field -> uint32_t
    os << YAML::Value << t.maxTransformFeedbackStreamDataSize;
    os << YAML::Key << "maxTransformFeedbackBufferDataSize";
    // maxTransformFeedbackBufferDataSize -> Field -> uint32_t
    os << YAML::Value << t.maxTransformFeedbackBufferDataSize;
    os << YAML::Key << "maxTransformFeedbackBufferDataStride";
    // maxTransformFeedbackBufferDataStride -> Field -> uint32_t
    os << YAML::Value << t.maxTransformFeedbackBufferDataStride;
    os << YAML::Key << "transformFeedbackQueries";
    // transformFeedbackQueries -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackQueries;
    os << YAML::Key << "transformFeedbackStreamsLinesTriangles";
    // transformFeedbackStreamsLinesTriangles -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackStreamsLinesTriangles;
    os << YAML::Key << "transformFeedbackRasterizationStreamSelect";
    // transformFeedbackRasterizationStreamSelect -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackRasterizationStreamSelect;
    os << YAML::Key << "transformFeedbackDraw";
    // transformFeedbackDraw -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackDraw;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationStateStreamCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineRasterizationStateStreamCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "rasterizationStream";
    // rasterizationStream -> Field -> uint32_t
    os << YAML::Value << t.rasterizationStream;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCuModuleCreateInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> size_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCuModuleTexturingModeCreateInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "use64bitTexturing";
    // use64bitTexturing -> Field -> VkBool32
    os << YAML::Value << t.use64bitTexturing;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCuFunctionCreateInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "module";
    // module -> Field -> VkCuModuleNVX
    os << YAML::Value << t.module;
    os << YAML::Key << "pName";
    // pName -> Field -> string
    os << YAML::Value << t.pName;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCuLaunchInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "function";
    // function -> Field -> VkCuFunctionNVX
    os << YAML::Value << t.function;
    os << YAML::Key << "gridDimX";
    // gridDimX -> Field -> uint32_t
    os << YAML::Value << t.gridDimX;
    os << YAML::Key << "gridDimY";
    // gridDimY -> Field -> uint32_t
    os << YAML::Value << t.gridDimY;
    os << YAML::Key << "gridDimZ";
    // gridDimZ -> Field -> uint32_t
    os << YAML::Value << t.gridDimZ;
    os << YAML::Key << "blockDimX";
    // blockDimX -> Field -> uint32_t
    os << YAML::Value << t.blockDimX;
    os << YAML::Key << "blockDimY";
    // blockDimY -> Field -> uint32_t
    os << YAML::Value << t.blockDimY;
    os << YAML::Key << "blockDimZ";
    // blockDimZ -> Field -> uint32_t
    os << YAML::Value << t.blockDimZ;
    os << YAML::Key << "sharedMemBytes";
    // sharedMemBytes -> Field -> uint32_t
    os << YAML::Value << t.sharedMemBytes;
    os << YAML::Key << "paramCount";
    // paramCount -> Field -> size_t
    os << YAML::Value << t.paramCount;
    os << YAML::Key << "pParams";
    if (t.paramCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pParams;
            for (uint64_t i = 0; i < t.paramCount; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::Key << "extraCount";
    // extraCount -> Field -> size_t
    os << YAML::Value << t.extraCount;
    os << YAML::Key << "pExtras";
    if (t.extraCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pExtras;
            for (uint64_t i = 0; i < t.extraCount; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewHandleInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "descriptorType";
    // descriptorType -> Field -> VkDescriptorType
    os << YAML::Value << t.descriptorType;
    os << YAML::Key << "sampler";
    // sampler -> Field -> VkSampler
    os << YAML::Value << t.sampler;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewAddressPropertiesNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceAddress";
    // deviceAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.deviceAddress);
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTextureLODGatherFormatPropertiesAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "supportsTextureGatherLODBiasAMD";
    // supportsTextureGatherLODBiasAMD -> Field -> VkBool32
    os << YAML::Value << t.supportsTextureGatherLODBiasAMD;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShaderResourceUsageAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "numUsedVgprs";
    // numUsedVgprs -> Field -> uint32_t
    os << YAML::Value << t.numUsedVgprs;
    os << YAML::Key << "numUsedSgprs";
    // numUsedSgprs -> Field -> uint32_t
    os << YAML::Value << t.numUsedSgprs;
    os << YAML::Key << "ldsSizePerLocalWorkGroup";
    // ldsSizePerLocalWorkGroup -> Field -> uint32_t
    os << YAML::Value << t.ldsSizePerLocalWorkGroup;
    os << YAML::Key << "ldsUsageSizeInBytes";
    // ldsUsageSizeInBytes -> Field -> size_t
    os << YAML::Value << t.ldsUsageSizeInBytes;
    os << YAML::Key << "scratchMemUsageInBytes";
    // scratchMemUsageInBytes -> Field -> size_t
    os << YAML::Value << t.scratchMemUsageInBytes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShaderStatisticsInfoAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "shaderStageMask";
    // shaderStageMask -> Field -> VkShaderStageFlags
    os << YAML::Value << t.shaderStageMask;
    os << YAML::Key << "resourceUsage";
    // resourceUsage -> Field -> VkShaderResourceUsageAMD
    os << YAML::Value << t.resourceUsage;
    os << YAML::Key << "numPhysicalVgprs";
    // numPhysicalVgprs -> Field -> uint32_t
    os << YAML::Value << t.numPhysicalVgprs;
    os << YAML::Key << "numPhysicalSgprs";
    // numPhysicalSgprs -> Field -> uint32_t
    os << YAML::Value << t.numPhysicalSgprs;
    os << YAML::Key << "numAvailableVgprs";
    // numAvailableVgprs -> Field -> uint32_t
    os << YAML::Value << t.numAvailableVgprs;
    os << YAML::Key << "numAvailableSgprs";
    // numAvailableSgprs -> Field -> uint32_t
    os << YAML::Value << t.numAvailableSgprs;
    os << YAML::Key << "computeWorkGroupSize";
    // computeWorkGroupSize -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.computeWorkGroupSize[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_GGP
YAML::Emitter &operator<<(YAML::Emitter &os, const VkStreamDescriptorSurfaceCreateInfoGGP &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkStreamDescriptorSurfaceCreateFlagsGGP
    os << YAML::Value << t.flags;
    os << YAML::Key << "streamDescriptor";
    // streamDescriptor -> Field -> GgpStreamDescriptor
    os << YAML::Value << t.streamDescriptor;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_GGP

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCornerSampledImageFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cornerSampledImage";
    // cornerSampledImage -> Field -> VkBool32
    os << YAML::Value << t.cornerSampledImage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalImageFormatPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "imageFormatProperties";
    // imageFormatProperties -> Field -> VkImageFormatProperties
    os << YAML::Value << t.imageFormatProperties;
    os << YAML::Key << "externalMemoryFeatures";
    // externalMemoryFeatures -> Field -> VkExternalMemoryFeatureFlagsNV
    os << YAML::Value << t.externalMemoryFeatures;
    os << YAML::Key << "exportFromImportedHandleTypes";
    // exportFromImportedHandleTypes -> Field -> VkExternalMemoryHandleTypeFlagsNV
    os << YAML::Value << t.exportFromImportedHandleTypes;
    os << YAML::Key << "compatibleHandleTypes";
    // compatibleHandleTypes -> Field -> VkExternalMemoryHandleTypeFlagsNV
    os << YAML::Value << t.compatibleHandleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalMemoryImageCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalMemoryHandleTypeFlagsNV
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMemoryAllocateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleTypes";
    // handleTypes -> Field -> VkExternalMemoryHandleTypeFlagsNV
    os << YAML::Value << t.handleTypes;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryWin32HandleInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagsNV
    os << YAML::Value << t.handleType;
    os << YAML::Key << "handle";
    // handle -> Field -> HANDLE
    os << YAML::Value << t.handle;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMemoryWin32HandleInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pAttributes";
    // non-dereferenced pointer
    os << YAML::Value << t.pAttributes;
    os << YAML::Key << "dwAccess";
    // dwAccess -> Field -> DWORD
    os << YAML::Value << t.dwAccess;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkWin32KeyedMutexAcquireReleaseInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "acquireCount";
    // acquireCount -> Field -> uint32_t
    os << YAML::Value << t.acquireCount;
    os << YAML::Key << "pAcquireSyncs";
    // pAcquireSyncs -> Field -> ConstDynamicArray(VkDeviceMemory)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceMemory");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireSyncs[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pAcquireKeys";
    // pAcquireKeys -> Field -> ConstDynamicArray(uint64_t)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireKeys[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pAcquireTimeoutMilliseconds";
    // pAcquireTimeoutMilliseconds -> Field -> ConstDynamicArray(uint32_t)
    if (t.acquireCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.acquireCount); ++i) {
                os << t.pAcquireTimeoutMilliseconds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "releaseCount";
    // releaseCount -> Field -> uint32_t
    os << YAML::Value << t.releaseCount;
    os << YAML::Key << "pReleaseSyncs";
    // pReleaseSyncs -> Field -> ConstDynamicArray(VkDeviceMemory)
    if (t.releaseCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceMemory");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.releaseCount); ++i) {
                os << t.pReleaseSyncs[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pReleaseKeys";
    // pReleaseKeys -> Field -> ConstDynamicArray(uint64_t)
    if (t.releaseCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.releaseCount); ++i) {
                os << t.pReleaseKeys[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkValidationFlagsEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "disabledValidationCheckCount";
    // disabledValidationCheckCount -> Field -> uint32_t
    os << YAML::Value << t.disabledValidationCheckCount;
    os << YAML::Key << "pDisabledValidationChecks";
    // pDisabledValidationChecks -> Field -> ConstDynamicArray(VkValidationCheckEXT)
    if (t.disabledValidationCheckCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkValidationCheckEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.disabledValidationCheckCount); ++i) {
                os << t.pDisabledValidationChecks[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_VI_NN
YAML::Emitter &operator<<(YAML::Emitter &os, const VkViSurfaceCreateInfoNN &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkViSurfaceCreateFlagsNN
    os << YAML::Value << t.flags;
    os << YAML::Key << "window";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_VI_NN

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewASTCDecodeModeEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "decodeMode";
    // decodeMode -> Field -> VkFormat
    os << YAML::Value << t.decodeMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceASTCDecodeFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "decodeModeSharedExponent";
    // decodeModeSharedExponent -> Field -> VkBool32
    os << YAML::Value << t.decodeModeSharedExponent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkConditionalRenderingBeginInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkConditionalRenderingFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceConditionalRenderingFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "conditionalRendering";
    // conditionalRendering -> Field -> VkBool32
    os << YAML::Value << t.conditionalRendering;
    os << YAML::Key << "inheritedConditionalRendering";
    // inheritedConditionalRendering -> Field -> VkBool32
    os << YAML::Value << t.inheritedConditionalRendering;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceConditionalRenderingInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "conditionalRenderingEnable";
    // conditionalRenderingEnable -> Field -> VkBool32
    os << YAML::Value << t.conditionalRenderingEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkViewportWScalingNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "xcoeff";
    // xcoeff -> Field -> float
    os << YAML::Value << t.xcoeff;
    os << YAML::Key << "ycoeff";
    // ycoeff -> Field -> float
    os << YAML::Value << t.ycoeff;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportWScalingStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "viewportWScalingEnable";
    // viewportWScalingEnable -> Field -> VkBool32
    os << YAML::Value << t.viewportWScalingEnable;
    os << YAML::Key << "viewportCount";
    // viewportCount -> Field -> uint32_t
    os << YAML::Value << t.viewportCount;
    os << YAML::Key << "pViewportWScalings";
    // pViewportWScalings -> Field -> ConstDynamicArray(VkViewportWScalingNV)
    if (t.viewportCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkViewportWScalingNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewportCount); ++i) {
                os << t.pViewportWScalings[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilities2EXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minImageCount";
    // minImageCount -> Field -> uint32_t
    os << YAML::Value << t.minImageCount;
    os << YAML::Key << "maxImageCount";
    // maxImageCount -> Field -> uint32_t
    os << YAML::Value << t.maxImageCount;
    os << YAML::Key << "currentExtent";
    // currentExtent -> Field -> VkExtent2D
    os << YAML::Value << t.currentExtent;
    os << YAML::Key << "minImageExtent";
    // minImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.minImageExtent;
    os << YAML::Key << "maxImageExtent";
    // maxImageExtent -> Field -> VkExtent2D
    os << YAML::Value << t.maxImageExtent;
    os << YAML::Key << "maxImageArrayLayers";
    // maxImageArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.maxImageArrayLayers;
    os << YAML::Key << "supportedTransforms";
    // supportedTransforms -> Field -> VkSurfaceTransformFlagsKHR
    os << YAML::Value << t.supportedTransforms;
    os << YAML::Key << "currentTransform";
    // currentTransform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.currentTransform;
    os << YAML::Key << "supportedCompositeAlpha";
    // supportedCompositeAlpha -> Field -> VkCompositeAlphaFlagsKHR
    os << YAML::Value << t.supportedCompositeAlpha;
    os << YAML::Key << "supportedUsageFlags";
    // supportedUsageFlags -> Field -> VkImageUsageFlags
    os << YAML::Value << t.supportedUsageFlags;
    os << YAML::Key << "supportedSurfaceCounters";
    // supportedSurfaceCounters -> Field -> VkSurfaceCounterFlagsEXT
    os << YAML::Value << t.supportedSurfaceCounters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayPowerInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "powerState";
    // powerState -> Field -> VkDisplayPowerStateEXT
    os << YAML::Value << t.powerState;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceEventInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceEvent";
    // deviceEvent -> Field -> VkDeviceEventTypeEXT
    os << YAML::Value << t.deviceEvent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayEventInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "displayEvent";
    // displayEvent -> Field -> VkDisplayEventTypeEXT
    os << YAML::Value << t.displayEvent;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainCounterCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "surfaceCounters";
    // surfaceCounters -> Field -> VkSurfaceCounterFlagsEXT
    os << YAML::Value << t.surfaceCounters;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRefreshCycleDurationGOOGLE &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "refreshDuration";
    // refreshDuration -> Field -> uint64_t
    os << YAML::Value << t.refreshDuration;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPastPresentationTimingGOOGLE &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "presentID";
    // presentID -> Field -> uint32_t
    os << YAML::Value << t.presentID;
    os << YAML::Key << "desiredPresentTime";
    // desiredPresentTime -> Field -> uint64_t
    os << YAML::Value << t.desiredPresentTime;
    os << YAML::Key << "actualPresentTime";
    // actualPresentTime -> Field -> uint64_t
    os << YAML::Value << t.actualPresentTime;
    os << YAML::Key << "earliestPresentTime";
    // earliestPresentTime -> Field -> uint64_t
    os << YAML::Value << t.earliestPresentTime;
    os << YAML::Key << "presentMargin";
    // presentMargin -> Field -> uint64_t
    os << YAML::Value << t.presentMargin;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentTimeGOOGLE &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "presentID";
    // presentID -> Field -> uint32_t
    os << YAML::Value << t.presentID;
    os << YAML::Key << "desiredPresentTime";
    // desiredPresentTime -> Field -> uint64_t
    os << YAML::Value << t.desiredPresentTime;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentTimesInfoGOOGLE &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pTimes";
    // pTimes -> Field -> ConstDynamicArray(VkPresentTimeGOOGLE)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentTimeGOOGLE");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pTimes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "perViewPositionAllComponents";
    // perViewPositionAllComponents -> Field -> VkBool32
    os << YAML::Value << t.perViewPositionAllComponents;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMultiviewPerViewAttributesInfoNVX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "perViewAttributes";
    // perViewAttributes -> Field -> VkBool32
    os << YAML::Value << t.perViewAttributes;
    os << YAML::Key << "perViewAttributesPositionXOnly";
    // perViewAttributesPositionXOnly -> Field -> VkBool32
    os << YAML::Value << t.perViewAttributesPositionXOnly;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkViewportSwizzleNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> VkViewportCoordinateSwizzleNV
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> VkViewportCoordinateSwizzleNV
    os << YAML::Value << t.y;
    os << YAML::Key << "z";
    // z -> Field -> VkViewportCoordinateSwizzleNV
    os << YAML::Value << t.z;
    os << YAML::Key << "w";
    // w -> Field -> VkViewportCoordinateSwizzleNV
    os << YAML::Value << t.w;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportSwizzleStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineViewportSwizzleStateCreateFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "viewportCount";
    // viewportCount -> Field -> uint32_t
    os << YAML::Value << t.viewportCount;
    os << YAML::Key << "pViewportSwizzles";
    // pViewportSwizzles -> Field -> ConstDynamicArray(VkViewportSwizzleNV)
    if (t.viewportCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkViewportSwizzleNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewportCount); ++i) {
                os << t.pViewportSwizzles[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDiscardRectanglePropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxDiscardRectangles";
    // maxDiscardRectangles -> Field -> uint32_t
    os << YAML::Value << t.maxDiscardRectangles;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineDiscardRectangleStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineDiscardRectangleStateCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "discardRectangleMode";
    // discardRectangleMode -> Field -> VkDiscardRectangleModeEXT
    os << YAML::Value << t.discardRectangleMode;
    os << YAML::Key << "discardRectangleCount";
    // discardRectangleCount -> Field -> uint32_t
    os << YAML::Value << t.discardRectangleCount;
    os << YAML::Key << "pDiscardRectangles";
    // pDiscardRectangles -> Field -> ConstDynamicArray(VkRect2D)
    if (t.discardRectangleCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRect2D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.discardRectangleCount); ++i) {
                os << t.pDiscardRectangles[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "primitiveOverestimationSize";
    // primitiveOverestimationSize -> Field -> float
    os << YAML::Value << t.primitiveOverestimationSize;
    os << YAML::Key << "maxExtraPrimitiveOverestimationSize";
    // maxExtraPrimitiveOverestimationSize -> Field -> float
    os << YAML::Value << t.maxExtraPrimitiveOverestimationSize;
    os << YAML::Key << "extraPrimitiveOverestimationSizeGranularity";
    // extraPrimitiveOverestimationSizeGranularity -> Field -> float
    os << YAML::Value << t.extraPrimitiveOverestimationSizeGranularity;
    os << YAML::Key << "primitiveUnderestimation";
    // primitiveUnderestimation -> Field -> VkBool32
    os << YAML::Value << t.primitiveUnderestimation;
    os << YAML::Key << "conservativePointAndLineRasterization";
    // conservativePointAndLineRasterization -> Field -> VkBool32
    os << YAML::Value << t.conservativePointAndLineRasterization;
    os << YAML::Key << "degenerateTrianglesRasterized";
    // degenerateTrianglesRasterized -> Field -> VkBool32
    os << YAML::Value << t.degenerateTrianglesRasterized;
    os << YAML::Key << "degenerateLinesRasterized";
    // degenerateLinesRasterized -> Field -> VkBool32
    os << YAML::Value << t.degenerateLinesRasterized;
    os << YAML::Key << "fullyCoveredFragmentShaderInputVariable";
    // fullyCoveredFragmentShaderInputVariable -> Field -> VkBool32
    os << YAML::Value << t.fullyCoveredFragmentShaderInputVariable;
    os << YAML::Key << "conservativeRasterizationPostDepthCoverage";
    // conservativeRasterizationPostDepthCoverage -> Field -> VkBool32
    os << YAML::Value << t.conservativeRasterizationPostDepthCoverage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationConservativeStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineRasterizationConservativeStateCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "conservativeRasterizationMode";
    // conservativeRasterizationMode -> Field -> VkConservativeRasterizationModeEXT
    os << YAML::Value << t.conservativeRasterizationMode;
    os << YAML::Key << "extraPrimitiveOverestimationSize";
    // extraPrimitiveOverestimationSize -> Field -> float
    os << YAML::Value << t.extraPrimitiveOverestimationSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDepthClipEnableFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthClipEnable";
    // depthClipEnable -> Field -> VkBool32
    os << YAML::Value << t.depthClipEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationDepthClipStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineRasterizationDepthClipStateCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "depthClipEnable";
    // depthClipEnable -> Field -> VkBool32
    os << YAML::Value << t.depthClipEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkXYColorEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> float
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> float
    os << YAML::Value << t.y;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHdrMetadataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "displayPrimaryRed";
    // displayPrimaryRed -> Field -> VkXYColorEXT
    os << YAML::Value << t.displayPrimaryRed;
    os << YAML::Key << "displayPrimaryGreen";
    // displayPrimaryGreen -> Field -> VkXYColorEXT
    os << YAML::Value << t.displayPrimaryGreen;
    os << YAML::Key << "displayPrimaryBlue";
    // displayPrimaryBlue -> Field -> VkXYColorEXT
    os << YAML::Value << t.displayPrimaryBlue;
    os << YAML::Key << "whitePoint";
    // whitePoint -> Field -> VkXYColorEXT
    os << YAML::Value << t.whitePoint;
    os << YAML::Key << "maxLuminance";
    // maxLuminance -> Field -> float
    os << YAML::Value << t.maxLuminance;
    os << YAML::Key << "minLuminance";
    // minLuminance -> Field -> float
    os << YAML::Value << t.minLuminance;
    os << YAML::Key << "maxContentLightLevel";
    // maxContentLightLevel -> Field -> float
    os << YAML::Value << t.maxContentLightLevel;
    os << YAML::Key << "maxFrameAverageLightLevel";
    // maxFrameAverageLightLevel -> Field -> float
    os << YAML::Value << t.maxFrameAverageLightLevel;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "relaxedLineRasterization";
    // relaxedLineRasterization -> Field -> VkBool32
    os << YAML::Value << t.relaxedLineRasterization;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_IOS_MVK
YAML::Emitter &operator<<(YAML::Emitter &os, const VkIOSSurfaceCreateInfoMVK &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkIOSSurfaceCreateFlagsMVK
    os << YAML::Value << t.flags;
    os << YAML::Key << "pView";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_IOS_MVK

#ifdef VK_USE_PLATFORM_MACOS_MVK
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMacOSSurfaceCreateInfoMVK &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMacOSSurfaceCreateFlagsMVK
    os << YAML::Value << t.flags;
    os << YAML::Key << "pView";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_MACOS_MVK

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugUtilsLabelEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pLabelName";
    // pLabelName -> Field -> string
    os << YAML::Value << t.pLabelName;
    os << YAML::Key << "color";
    // color -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(4); ++i) {
                os << t.color[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugUtilsObjectNameInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "objectType";
    // objectType -> Field -> VkObjectType
    os << YAML::Value << t.objectType;
    os << YAML::Key << "objectHandle";
    // objectHandle -> Field -> uint64_t
    os << YAML::Value << t.objectHandle;
    os << YAML::Key << "pObjectName";
    // pObjectName -> Field -> string
    os << YAML::Value << t.pObjectName;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugUtilsMessengerCallbackDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDebugUtilsMessengerCallbackDataFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "pMessageIdName";
    // pMessageIdName -> Field -> string
    os << YAML::Value << t.pMessageIdName;
    os << YAML::Key << "messageIdNumber";
    // messageIdNumber -> Field -> int32_t
    os << YAML::Value << t.messageIdNumber;
    os << YAML::Key << "pMessage";
    // pMessage -> Field -> string
    os << YAML::Value << t.pMessage;
    os << YAML::Key << "queueLabelCount";
    // queueLabelCount -> Field -> uint32_t
    os << YAML::Value << t.queueLabelCount;
    os << YAML::Key << "pQueueLabels";
    // pQueueLabels -> Field -> ConstDynamicArray(VkDebugUtilsLabelEXT)
    if (t.queueLabelCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDebugUtilsLabelEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueLabelCount); ++i) {
                os << t.pQueueLabels[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "cmdBufLabelCount";
    // cmdBufLabelCount -> Field -> uint32_t
    os << YAML::Value << t.cmdBufLabelCount;
    os << YAML::Key << "pCmdBufLabels";
    // pCmdBufLabels -> Field -> ConstDynamicArray(VkDebugUtilsLabelEXT)
    if (t.cmdBufLabelCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDebugUtilsLabelEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.cmdBufLabelCount); ++i) {
                os << t.pCmdBufLabels[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "objectCount";
    // objectCount -> Field -> uint32_t
    os << YAML::Value << t.objectCount;
    os << YAML::Key << "pObjects";
    // pObjects -> Field -> ConstDynamicArray(VkDebugUtilsObjectNameInfoEXT)
    if (t.objectCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDebugUtilsObjectNameInfoEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.objectCount); ++i) {
                os << t.pObjects[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugUtilsMessengerCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDebugUtilsMessengerCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "messageSeverity";
    // messageSeverity -> Field -> VkDebugUtilsMessageSeverityFlagsEXT
    os << YAML::Value << t.messageSeverity;
    os << YAML::Key << "messageType";
    // messageType -> Field -> VkDebugUtilsMessageTypeFlagsEXT
    os << YAML::Value << t.messageType;
    os << YAML::Key << "pfnUserCallback";
    // pointer
    if (t.pfnUserCallback != nullptr) {
        os << YAML::Value << *t.pfnUserCallback;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pUserData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDebugUtilsObjectTagInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "objectType";
    // objectType -> Field -> VkObjectType
    os << YAML::Value << t.objectType;
    os << YAML::Key << "objectHandle";
    // objectHandle -> Field -> uint64_t
    os << YAML::Value << t.objectHandle;
    os << YAML::Key << "tagName";
    // tagName -> Field -> uint64_t
    os << YAML::Value << t.tagName;
    os << YAML::Key << "tagSize";
    // tagSize -> Field -> size_t
    os << YAML::Value << t.tagSize;
    os << YAML::Key << "pTag";
    if (t.tagSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pTag;
            for (uint64_t i = 0; i < t.tagSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkAndroidHardwareBufferUsageANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "androidHardwareBufferUsage";
    // androidHardwareBufferUsage -> Field -> uint64_t
    os << YAML::Value << t.androidHardwareBufferUsage;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkAndroidHardwareBufferPropertiesANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "allocationSize";
    // allocationSize -> Field -> VkDeviceSize
    os << YAML::Value << t.allocationSize;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkAndroidHardwareBufferFormatPropertiesANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "externalFormat";
    // externalFormat -> Field -> uint64_t
    os << YAML::Value << t.externalFormat;
    os << YAML::Key << "formatFeatures";
    // formatFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.formatFeatures;
    os << YAML::Key << "samplerYcbcrConversionComponents";
    // samplerYcbcrConversionComponents -> Field -> VkComponentMapping
    os << YAML::Value << t.samplerYcbcrConversionComponents;
    os << YAML::Key << "suggestedYcbcrModel";
    // suggestedYcbcrModel -> Field -> VkSamplerYcbcrModelConversion
    os << YAML::Value << t.suggestedYcbcrModel;
    os << YAML::Key << "suggestedYcbcrRange";
    // suggestedYcbcrRange -> Field -> VkSamplerYcbcrRange
    os << YAML::Value << t.suggestedYcbcrRange;
    os << YAML::Key << "suggestedXChromaOffset";
    // suggestedXChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.suggestedXChromaOffset;
    os << YAML::Key << "suggestedYChromaOffset";
    // suggestedYChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.suggestedYChromaOffset;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportAndroidHardwareBufferInfoANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // non-dereferenced pointer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryGetAndroidHardwareBufferInfoANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExternalFormatANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "externalFormat";
    // externalFormat -> Field -> uint64_t
    os << YAML::Value << t.externalFormat;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_USE_PLATFORM_ANDROID_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkAndroidHardwareBufferFormatProperties2ANDROID &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "externalFormat";
    // externalFormat -> Field -> uint64_t
    os << YAML::Value << t.externalFormat;
    os << YAML::Key << "formatFeatures";
    // formatFeatures -> Field -> VkFormatFeatureFlags2
    os << YAML::Value << t.formatFeatures;
    os << YAML::Key << "samplerYcbcrConversionComponents";
    // samplerYcbcrConversionComponents -> Field -> VkComponentMapping
    os << YAML::Value << t.samplerYcbcrConversionComponents;
    os << YAML::Key << "suggestedYcbcrModel";
    // suggestedYcbcrModel -> Field -> VkSamplerYcbcrModelConversion
    os << YAML::Value << t.suggestedYcbcrModel;
    os << YAML::Key << "suggestedYcbcrRange";
    // suggestedYcbcrRange -> Field -> VkSamplerYcbcrRange
    os << YAML::Value << t.suggestedYcbcrRange;
    os << YAML::Key << "suggestedXChromaOffset";
    // suggestedXChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.suggestedXChromaOffset;
    os << YAML::Key << "suggestedYChromaOffset";
    // suggestedYChromaOffset -> Field -> VkChromaLocation
    os << YAML::Value << t.suggestedYChromaOffset;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_ANDROID_KHR

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderEnqueueFeaturesAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderEnqueue";
    // shaderEnqueue -> Field -> VkBool32
    os << YAML::Value << t.shaderEnqueue;
    os << YAML::Key << "shaderMeshEnqueue";
    // shaderMeshEnqueue -> Field -> VkBool32
    os << YAML::Value << t.shaderMeshEnqueue;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderEnqueuePropertiesAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxExecutionGraphDepth";
    // maxExecutionGraphDepth -> Field -> uint32_t
    os << YAML::Value << t.maxExecutionGraphDepth;
    os << YAML::Key << "maxExecutionGraphShaderOutputNodes";
    // maxExecutionGraphShaderOutputNodes -> Field -> uint32_t
    os << YAML::Value << t.maxExecutionGraphShaderOutputNodes;
    os << YAML::Key << "maxExecutionGraphShaderPayloadSize";
    // maxExecutionGraphShaderPayloadSize -> Field -> uint32_t
    os << YAML::Value << t.maxExecutionGraphShaderPayloadSize;
    os << YAML::Key << "maxExecutionGraphShaderPayloadCount";
    // maxExecutionGraphShaderPayloadCount -> Field -> uint32_t
    os << YAML::Value << t.maxExecutionGraphShaderPayloadCount;
    os << YAML::Key << "executionGraphDispatchAddressAlignment";
    // executionGraphDispatchAddressAlignment -> Field -> uint32_t
    os << YAML::Value << t.executionGraphDispatchAddressAlignment;
    os << YAML::Key << "maxExecutionGraphWorkgroupCount";
    // maxExecutionGraphWorkgroupCount -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.maxExecutionGraphWorkgroupCount[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "maxExecutionGraphWorkgroups";
    // maxExecutionGraphWorkgroups -> Field -> uint32_t
    os << YAML::Value << t.maxExecutionGraphWorkgroups;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExecutionGraphPipelineScratchSizeAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minSize";
    // minSize -> Field -> VkDeviceSize
    os << YAML::Value << t.minSize;
    os << YAML::Key << "maxSize";
    // maxSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxSize;
    os << YAML::Key << "sizeGranularity";
    // sizeGranularity -> Field -> VkDeviceSize
    os << YAML::Value << t.sizeGranularity;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExecutionGraphPipelineCreateInfoAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "stageCount";
    // stageCount -> Field -> uint32_t
    os << YAML::Value << t.stageCount;
    os << YAML::Key << "pStages";
    // pStages -> Field -> ConstDynamicArray(VkPipelineShaderStageCreateInfo)
    if (t.stageCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineShaderStageCreateInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.stageCount); ++i) {
                os << t.pStages[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pLibraryInfo";
    // pointer
    if (t.pLibraryInfo != nullptr) {
        os << YAML::Value << *t.pLibraryInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "basePipelineHandle";
    // basePipelineHandle -> Field -> VkPipeline
    os << YAML::Value << t.basePipelineHandle;
    os << YAML::Key << "basePipelineIndex";
    // basePipelineIndex -> Field -> int32_t
    os << YAML::Value << t.basePipelineIndex;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceOrHostAddressConstAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "deviceAddress";
    // deviceAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.deviceAddress);
    os << YAML::Key << "hostAddress";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkDispatchGraphInfoAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "nodeIndex";
    // nodeIndex -> Field -> uint32_t
    os << YAML::Value << t.nodeIndex;
    os << YAML::Key << "payloadCount";
    // payloadCount -> Field -> uint32_t
    os << YAML::Value << t.payloadCount;
    os << YAML::Key << "payloads";
    // payloads -> Field -> VkDeviceOrHostAddressConstAMDX
    os << YAML::Value << t.payloads;
    os << YAML::Key << "payloadStride";
    // payloadStride -> Field -> uint64_t
    os << YAML::Value << t.payloadStride;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkDispatchGraphCountInfoAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "count";
    // count -> Field -> uint32_t
    os << YAML::Value << t.count;
    os << YAML::Key << "infos";
    // infos -> Field -> VkDeviceOrHostAddressConstAMDX
    os << YAML::Value << t.infos;
    os << YAML::Key << "stride";
    // stride -> Field -> uint64_t
    os << YAML::Value << t.stride;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineShaderStageNodeCreateInfoAMDX &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pName";
    // pName -> Field -> string
    os << YAML::Value << t.pName;
    os << YAML::Key << "index";
    // index -> Field -> uint32_t
    os << YAML::Value << t.index;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHostAddressRangeEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "address";
    if (t.size == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.address;
            for (uint64_t i = 0; i < t.size; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::Key << "size";
    // size -> Field -> size_t
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHostAddressRangeConstEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "address";
    if (t.size == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.address;
            for (uint64_t i = 0; i < t.size; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::Key << "size";
    // size -> Field -> size_t
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceAddressRangeEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "address";
    // address -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.address);
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTexelBufferDescriptorInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "addressRange";
    // addressRange -> Field -> VkDeviceAddressRangeEXT
    os << YAML::Value << t.addressRange;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageDescriptorInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pView";
    // pointer
    if (t.pView != nullptr) {
        os << YAML::Value << *t.pView;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "layout";
    // layout -> Field -> VkImageLayout
    os << YAML::Value << t.layout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTensorViewCreateInfoARM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkTensorViewCreateFlagsARM
    os << YAML::Value << t.flags;
    os << YAML::Key << "tensor";
    // tensor -> Field -> VkTensorARM
    os << YAML::Value << t.tensor;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkResourceDescriptorDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "pImage";
    // pointer
    if (t.pImage != nullptr) {
        os << YAML::Value << *t.pImage;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pTexelBuffer";
    // pointer
    if (t.pTexelBuffer != nullptr) {
        os << YAML::Value << *t.pTexelBuffer;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pAddressRange";
    // pointer
    if (t.pAddressRange != nullptr) {
        os << YAML::Value << *t.pAddressRange;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pTensorARM";
    // pointer
    if (t.pTensorARM != nullptr) {
        os << YAML::Value << *t.pTensorARM;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkResourceDescriptorInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkDescriptorType
    os << YAML::Value << t.type;
    os << YAML::Key << "data";
    // data -> Field -> VkResourceDescriptorDataEXT
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindHeapInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "heapRange";
    // heapRange -> Field -> VkDeviceAddressRangeEXT
    os << YAML::Value << t.heapRange;
    os << YAML::Key << "reservedRangeOffset";
    // reservedRangeOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.reservedRangeOffset;
    os << YAML::Key << "reservedRangeSize";
    // reservedRangeSize -> Field -> VkDeviceSize
    os << YAML::Value << t.reservedRangeSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPushDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "data";
    // data -> Field -> VkHostAddressRangeConstEXT
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceConstantOffsetEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "heapArrayStride";
    // heapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.heapArrayStride;
    os << YAML::Key << "pEmbeddedSampler";
    // pointer
    if (t.pEmbeddedSampler != nullptr) {
        os << YAML::Value << *t.pEmbeddedSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "samplerHeapOffset";
    // samplerHeapOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapOffset;
    os << YAML::Key << "samplerHeapArrayStride";
    // samplerHeapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapArrayStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourcePushIndexEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "pushOffset";
    // pushOffset -> Field -> uint32_t
    os << YAML::Value << t.pushOffset;
    os << YAML::Key << "heapIndexStride";
    // heapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.heapIndexStride;
    os << YAML::Key << "heapArrayStride";
    // heapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.heapArrayStride;
    os << YAML::Key << "pEmbeddedSampler";
    // pointer
    if (t.pEmbeddedSampler != nullptr) {
        os << YAML::Value << *t.pEmbeddedSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "useCombinedImageSamplerIndex";
    // useCombinedImageSamplerIndex -> Field -> VkBool32
    os << YAML::Value << t.useCombinedImageSamplerIndex;
    os << YAML::Key << "samplerHeapOffset";
    // samplerHeapOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapOffset;
    os << YAML::Key << "samplerPushOffset";
    // samplerPushOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerPushOffset;
    os << YAML::Key << "samplerHeapIndexStride";
    // samplerHeapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapIndexStride;
    os << YAML::Key << "samplerHeapArrayStride";
    // samplerHeapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapArrayStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceIndirectIndexEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "pushOffset";
    // pushOffset -> Field -> uint32_t
    os << YAML::Value << t.pushOffset;
    os << YAML::Key << "addressOffset";
    // addressOffset -> Field -> uint32_t
    os << YAML::Value << t.addressOffset;
    os << YAML::Key << "heapIndexStride";
    // heapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.heapIndexStride;
    os << YAML::Key << "heapArrayStride";
    // heapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.heapArrayStride;
    os << YAML::Key << "pEmbeddedSampler";
    // pointer
    if (t.pEmbeddedSampler != nullptr) {
        os << YAML::Value << *t.pEmbeddedSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "useCombinedImageSamplerIndex";
    // useCombinedImageSamplerIndex -> Field -> VkBool32
    os << YAML::Value << t.useCombinedImageSamplerIndex;
    os << YAML::Key << "samplerHeapOffset";
    // samplerHeapOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapOffset;
    os << YAML::Key << "samplerPushOffset";
    // samplerPushOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerPushOffset;
    os << YAML::Key << "samplerAddressOffset";
    // samplerAddressOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerAddressOffset;
    os << YAML::Key << "samplerHeapIndexStride";
    // samplerHeapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapIndexStride;
    os << YAML::Key << "samplerHeapArrayStride";
    // samplerHeapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapArrayStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceHeapDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "pushOffset";
    // pushOffset -> Field -> uint32_t
    os << YAML::Value << t.pushOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceIndirectAddressEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "pushOffset";
    // pushOffset -> Field -> uint32_t
    os << YAML::Value << t.pushOffset;
    os << YAML::Key << "addressOffset";
    // addressOffset -> Field -> uint32_t
    os << YAML::Value << t.addressOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceShaderRecordIndexEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "shaderRecordOffset";
    // shaderRecordOffset -> Field -> uint32_t
    os << YAML::Value << t.shaderRecordOffset;
    os << YAML::Key << "heapIndexStride";
    // heapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.heapIndexStride;
    os << YAML::Key << "heapArrayStride";
    // heapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.heapArrayStride;
    os << YAML::Key << "pEmbeddedSampler";
    // pointer
    if (t.pEmbeddedSampler != nullptr) {
        os << YAML::Value << *t.pEmbeddedSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "useCombinedImageSamplerIndex";
    // useCombinedImageSamplerIndex -> Field -> VkBool32
    os << YAML::Value << t.useCombinedImageSamplerIndex;
    os << YAML::Key << "samplerHeapOffset";
    // samplerHeapOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapOffset;
    os << YAML::Key << "samplerShaderRecordOffset";
    // samplerShaderRecordOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerShaderRecordOffset;
    os << YAML::Key << "samplerHeapIndexStride";
    // samplerHeapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapIndexStride;
    os << YAML::Key << "samplerHeapArrayStride";
    // samplerHeapArrayStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapArrayStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceIndirectIndexArrayEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "heapOffset";
    // heapOffset -> Field -> uint32_t
    os << YAML::Value << t.heapOffset;
    os << YAML::Key << "pushOffset";
    // pushOffset -> Field -> uint32_t
    os << YAML::Value << t.pushOffset;
    os << YAML::Key << "addressOffset";
    // addressOffset -> Field -> uint32_t
    os << YAML::Value << t.addressOffset;
    os << YAML::Key << "heapIndexStride";
    // heapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.heapIndexStride;
    os << YAML::Key << "pEmbeddedSampler";
    // pointer
    if (t.pEmbeddedSampler != nullptr) {
        os << YAML::Value << *t.pEmbeddedSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "useCombinedImageSamplerIndex";
    // useCombinedImageSamplerIndex -> Field -> VkBool32
    os << YAML::Value << t.useCombinedImageSamplerIndex;
    os << YAML::Key << "samplerHeapOffset";
    // samplerHeapOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapOffset;
    os << YAML::Key << "samplerPushOffset";
    // samplerPushOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerPushOffset;
    os << YAML::Key << "samplerAddressOffset";
    // samplerAddressOffset -> Field -> uint32_t
    os << YAML::Value << t.samplerAddressOffset;
    os << YAML::Key << "samplerHeapIndexStride";
    // samplerHeapIndexStride -> Field -> uint32_t
    os << YAML::Value << t.samplerHeapIndexStride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorMappingSourceDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "constantOffset";
    // constantOffset -> Field -> VkDescriptorMappingSourceConstantOffsetEXT
    os << YAML::Value << t.constantOffset;
    os << YAML::Key << "pushIndex";
    // pushIndex -> Field -> VkDescriptorMappingSourcePushIndexEXT
    os << YAML::Value << t.pushIndex;
    os << YAML::Key << "indirectIndex";
    // indirectIndex -> Field -> VkDescriptorMappingSourceIndirectIndexEXT
    os << YAML::Value << t.indirectIndex;
    os << YAML::Key << "indirectIndexArray";
    // indirectIndexArray -> Field -> VkDescriptorMappingSourceIndirectIndexArrayEXT
    os << YAML::Value << t.indirectIndexArray;
    os << YAML::Key << "heapData";
    // heapData -> Field -> VkDescriptorMappingSourceHeapDataEXT
    os << YAML::Value << t.heapData;
    os << YAML::Key << "pushDataOffset";
    // pushDataOffset -> Field -> uint32_t
    os << YAML::Value << t.pushDataOffset;
    os << YAML::Key << "pushAddressOffset";
    // pushAddressOffset -> Field -> uint32_t
    os << YAML::Value << t.pushAddressOffset;
    os << YAML::Key << "indirectAddress";
    // indirectAddress -> Field -> VkDescriptorMappingSourceIndirectAddressEXT
    os << YAML::Value << t.indirectAddress;
    os << YAML::Key << "shaderRecordIndex";
    // shaderRecordIndex -> Field -> VkDescriptorMappingSourceShaderRecordIndexEXT
    os << YAML::Value << t.shaderRecordIndex;
    os << YAML::Key << "shaderRecordDataOffset";
    // shaderRecordDataOffset -> Field -> uint32_t
    os << YAML::Value << t.shaderRecordDataOffset;
    os << YAML::Key << "shaderRecordAddressOffset";
    // shaderRecordAddressOffset -> Field -> uint32_t
    os << YAML::Value << t.shaderRecordAddressOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorSetAndBindingMappingEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorSet";
    // descriptorSet -> Field -> uint32_t
    os << YAML::Value << t.descriptorSet;
    os << YAML::Key << "firstBinding";
    // firstBinding -> Field -> uint32_t
    os << YAML::Value << t.firstBinding;
    os << YAML::Key << "bindingCount";
    // bindingCount -> Field -> uint32_t
    os << YAML::Value << t.bindingCount;
    os << YAML::Key << "resourceMask";
    // resourceMask -> Field -> VkSpirvResourceTypeFlagsEXT
    os << YAML::Value << t.resourceMask;
    os << YAML::Key << "source";
    // source -> Field -> VkDescriptorMappingSourceEXT
    os << YAML::Value << t.source;
    os << YAML::Key << "sourceData";
    // sourceData -> Field -> VkDescriptorMappingSourceDataEXT
    os << YAML::Value << t.sourceData;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShaderDescriptorSetAndBindingMappingInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mappingCount";
    // mappingCount -> Field -> uint32_t
    os << YAML::Value << t.mappingCount;
    os << YAML::Key << "pMappings";
    // pMappings -> Field -> ConstDynamicArray(VkDescriptorSetAndBindingMappingEXT)
    if (t.mappingCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorSetAndBindingMappingEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.mappingCount); ++i) {
                os << t.pMappings[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkOpaqueCaptureDataCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pData";
    // pointer
    if (t.pData != nullptr) {
        os << YAML::Value << *t.pData;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorHeapFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorHeap";
    // descriptorHeap -> Field -> VkBool32
    os << YAML::Value << t.descriptorHeap;
    os << YAML::Key << "descriptorHeapCaptureReplay";
    // descriptorHeapCaptureReplay -> Field -> VkBool32
    os << YAML::Value << t.descriptorHeapCaptureReplay;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorHeapPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "samplerHeapAlignment";
    // samplerHeapAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.samplerHeapAlignment;
    os << YAML::Key << "resourceHeapAlignment";
    // resourceHeapAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.resourceHeapAlignment;
    os << YAML::Key << "maxSamplerHeapSize";
    // maxSamplerHeapSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxSamplerHeapSize;
    os << YAML::Key << "maxResourceHeapSize";
    // maxResourceHeapSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxResourceHeapSize;
    os << YAML::Key << "minSamplerHeapReservedRange";
    // minSamplerHeapReservedRange -> Field -> VkDeviceSize
    os << YAML::Value << t.minSamplerHeapReservedRange;
    os << YAML::Key << "minSamplerHeapReservedRangeWithEmbedded";
    // minSamplerHeapReservedRangeWithEmbedded -> Field -> VkDeviceSize
    os << YAML::Value << t.minSamplerHeapReservedRangeWithEmbedded;
    os << YAML::Key << "minResourceHeapReservedRange";
    // minResourceHeapReservedRange -> Field -> VkDeviceSize
    os << YAML::Value << t.minResourceHeapReservedRange;
    os << YAML::Key << "samplerDescriptorSize";
    // samplerDescriptorSize -> Field -> VkDeviceSize
    os << YAML::Value << t.samplerDescriptorSize;
    os << YAML::Key << "imageDescriptorSize";
    // imageDescriptorSize -> Field -> VkDeviceSize
    os << YAML::Value << t.imageDescriptorSize;
    os << YAML::Key << "bufferDescriptorSize";
    // bufferDescriptorSize -> Field -> VkDeviceSize
    os << YAML::Value << t.bufferDescriptorSize;
    os << YAML::Key << "samplerDescriptorAlignment";
    // samplerDescriptorAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.samplerDescriptorAlignment;
    os << YAML::Key << "imageDescriptorAlignment";
    // imageDescriptorAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.imageDescriptorAlignment;
    os << YAML::Key << "bufferDescriptorAlignment";
    // bufferDescriptorAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.bufferDescriptorAlignment;
    os << YAML::Key << "maxPushDataSize";
    // maxPushDataSize -> Field -> VkDeviceSize
    os << YAML::Value << t.maxPushDataSize;
    os << YAML::Key << "imageCaptureReplayOpaqueDataSize";
    // imageCaptureReplayOpaqueDataSize -> Field -> size_t
    os << YAML::Value << t.imageCaptureReplayOpaqueDataSize;
    os << YAML::Key << "maxDescriptorHeapEmbeddedSamplers";
    // maxDescriptorHeapEmbeddedSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorHeapEmbeddedSamplers;
    os << YAML::Key << "samplerYcbcrConversionCount";
    // samplerYcbcrConversionCount -> Field -> uint32_t
    os << YAML::Value << t.samplerYcbcrConversionCount;
    os << YAML::Key << "sparseDescriptorHeaps";
    // sparseDescriptorHeaps -> Field -> VkBool32
    os << YAML::Value << t.sparseDescriptorHeaps;
    os << YAML::Key << "protectedDescriptorHeaps";
    // protectedDescriptorHeaps -> Field -> VkBool32
    os << YAML::Value << t.protectedDescriptorHeaps;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceDescriptorHeapInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pSamplerHeapBindInfo";
    // pointer
    if (t.pSamplerHeapBindInfo != nullptr) {
        os << YAML::Value << *t.pSamplerHeapBindInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pResourceHeapBindInfo";
    // pointer
    if (t.pResourceHeapBindInfo != nullptr) {
        os << YAML::Value << *t.pResourceHeapBindInfo;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerCustomBorderColorIndexCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "index";
    // index -> Field -> uint32_t
    os << YAML::Value << t.index;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerCustomBorderColorCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "customBorderColor";
    // customBorderColor -> Field -> VkClearColorValue
    os << YAML::Value << t.customBorderColor;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkIndirectCommandsLayoutPushDataTokenNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pushDataOffset";
    // pushDataOffset -> Field -> uint32_t
    os << YAML::Value << t.pushDataOffset;
    os << YAML::Key << "pushDataSize";
    // pushDataSize -> Field -> uint32_t
    os << YAML::Value << t.pushDataSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubsampledImageFormatPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subsampledImageDescriptorCount";
    // subsampledImageDescriptorCount -> Field -> uint32_t
    os << YAML::Value << t.subsampledImageDescriptorCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorHeapTensorPropertiesARM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "tensorDescriptorSize";
    // tensorDescriptorSize -> Field -> VkDeviceSize
    os << YAML::Value << t.tensorDescriptorSize;
    os << YAML::Key << "tensorDescriptorAlignment";
    // tensorDescriptorAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.tensorDescriptorAlignment;
    os << YAML::Key << "tensorCaptureReplayOpaqueDataSize";
    // tensorCaptureReplayOpaqueDataSize -> Field -> size_t
    os << YAML::Value << t.tensorCaptureReplayOpaqueDataSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentSampleCountInfoAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "colorAttachmentCount";
    // colorAttachmentCount -> Field -> uint32_t
    os << YAML::Value << t.colorAttachmentCount;
    os << YAML::Key << "pColorAttachmentSamples";
    // pColorAttachmentSamples -> Field -> ConstDynamicArray(VkSampleCountFlagBits)
    if (t.colorAttachmentCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSampleCountFlagBits");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.colorAttachmentCount); ++i) {
                os << t.pColorAttachmentSamples[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "depthStencilAttachmentSamples";
    // depthStencilAttachmentSamples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.depthStencilAttachmentSamples;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSampleLocationEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "x";
    // x -> Field -> float
    os << YAML::Value << t.x;
    os << YAML::Key << "y";
    // y -> Field -> float
    os << YAML::Value << t.y;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSampleLocationsInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampleLocationsPerPixel";
    // sampleLocationsPerPixel -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.sampleLocationsPerPixel;
    os << YAML::Key << "sampleLocationGridSize";
    // sampleLocationGridSize -> Field -> VkExtent2D
    os << YAML::Value << t.sampleLocationGridSize;
    os << YAML::Key << "sampleLocationsCount";
    // sampleLocationsCount -> Field -> uint32_t
    os << YAML::Value << t.sampleLocationsCount;
    os << YAML::Key << "pSampleLocations";
    // pSampleLocations -> Field -> ConstDynamicArray(VkSampleLocationEXT)
    if (t.sampleLocationsCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSampleLocationEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.sampleLocationsCount); ++i) {
                os << t.pSampleLocations[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAttachmentSampleLocationsEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "attachmentIndex";
    // attachmentIndex -> Field -> uint32_t
    os << YAML::Value << t.attachmentIndex;
    os << YAML::Key << "sampleLocationsInfo";
    // sampleLocationsInfo -> Field -> VkSampleLocationsInfoEXT
    os << YAML::Value << t.sampleLocationsInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSubpassSampleLocationsEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "subpassIndex";
    // subpassIndex -> Field -> uint32_t
    os << YAML::Value << t.subpassIndex;
    os << YAML::Key << "sampleLocationsInfo";
    // sampleLocationsInfo -> Field -> VkSampleLocationsInfoEXT
    os << YAML::Value << t.sampleLocationsInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassSampleLocationsBeginInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "attachmentInitialSampleLocationsCount";
    // attachmentInitialSampleLocationsCount -> Field -> uint32_t
    os << YAML::Value << t.attachmentInitialSampleLocationsCount;
    os << YAML::Key << "pAttachmentInitialSampleLocations";
    // pAttachmentInitialSampleLocations -> Field -> ConstDynamicArray(VkAttachmentSampleLocationsEXT)
    if (t.attachmentInitialSampleLocationsCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAttachmentSampleLocationsEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.attachmentInitialSampleLocationsCount); ++i) {
                os << t.pAttachmentInitialSampleLocations[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "postSubpassSampleLocationsCount";
    // postSubpassSampleLocationsCount -> Field -> uint32_t
    os << YAML::Value << t.postSubpassSampleLocationsCount;
    os << YAML::Key << "pPostSubpassSampleLocations";
    // pPostSubpassSampleLocations -> Field -> ConstDynamicArray(VkSubpassSampleLocationsEXT)
    if (t.postSubpassSampleLocationsCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubpassSampleLocationsEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.postSubpassSampleLocationsCount); ++i) {
                os << t.pPostSubpassSampleLocations[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineSampleLocationsStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampleLocationsEnable";
    // sampleLocationsEnable -> Field -> VkBool32
    os << YAML::Value << t.sampleLocationsEnable;
    os << YAML::Key << "sampleLocationsInfo";
    // sampleLocationsInfo -> Field -> VkSampleLocationsInfoEXT
    os << YAML::Value << t.sampleLocationsInfo;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceSampleLocationsPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampleLocationSampleCounts";
    // sampleLocationSampleCounts -> Field -> VkSampleCountFlags
    os << YAML::Value << t.sampleLocationSampleCounts;
    os << YAML::Key << "maxSampleLocationGridSize";
    // maxSampleLocationGridSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxSampleLocationGridSize;
    os << YAML::Key << "sampleLocationCoordinateRange";
    // sampleLocationCoordinateRange -> Field -> FixedArray(float)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.sampleLocationCoordinateRange[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "sampleLocationSubPixelBits";
    // sampleLocationSubPixelBits -> Field -> uint32_t
    os << YAML::Value << t.sampleLocationSubPixelBits;
    os << YAML::Key << "variableSampleLocations";
    // variableSampleLocations -> Field -> VkBool32
    os << YAML::Value << t.variableSampleLocations;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMultisamplePropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxSampleLocationGridSize";
    // maxSampleLocationGridSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxSampleLocationGridSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "advancedBlendCoherentOperations";
    // advancedBlendCoherentOperations -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendCoherentOperations;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "advancedBlendMaxColorAttachments";
    // advancedBlendMaxColorAttachments -> Field -> uint32_t
    os << YAML::Value << t.advancedBlendMaxColorAttachments;
    os << YAML::Key << "advancedBlendIndependentBlend";
    // advancedBlendIndependentBlend -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendIndependentBlend;
    os << YAML::Key << "advancedBlendNonPremultipliedSrcColor";
    // advancedBlendNonPremultipliedSrcColor -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendNonPremultipliedSrcColor;
    os << YAML::Key << "advancedBlendNonPremultipliedDstColor";
    // advancedBlendNonPremultipliedDstColor -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendNonPremultipliedDstColor;
    os << YAML::Key << "advancedBlendCorrelatedOverlap";
    // advancedBlendCorrelatedOverlap -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendCorrelatedOverlap;
    os << YAML::Key << "advancedBlendAllOperations";
    // advancedBlendAllOperations -> Field -> VkBool32
    os << YAML::Value << t.advancedBlendAllOperations;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineColorBlendAdvancedStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "srcPremultiplied";
    // srcPremultiplied -> Field -> VkBool32
    os << YAML::Value << t.srcPremultiplied;
    os << YAML::Key << "dstPremultiplied";
    // dstPremultiplied -> Field -> VkBool32
    os << YAML::Value << t.dstPremultiplied;
    os << YAML::Key << "blendOverlap";
    // blendOverlap -> Field -> VkBlendOverlapEXT
    os << YAML::Value << t.blendOverlap;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCoverageToColorStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCoverageToColorStateCreateFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "coverageToColorEnable";
    // coverageToColorEnable -> Field -> VkBool32
    os << YAML::Value << t.coverageToColorEnable;
    os << YAML::Key << "coverageToColorLocation";
    // coverageToColorLocation -> Field -> uint32_t
    os << YAML::Value << t.coverageToColorLocation;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCoverageModulationStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCoverageModulationStateCreateFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "coverageModulationMode";
    // coverageModulationMode -> Field -> VkCoverageModulationModeNV
    os << YAML::Value << t.coverageModulationMode;
    os << YAML::Key << "coverageModulationTableEnable";
    // coverageModulationTableEnable -> Field -> VkBool32
    os << YAML::Value << t.coverageModulationTableEnable;
    os << YAML::Key << "coverageModulationTableCount";
    // coverageModulationTableCount -> Field -> uint32_t
    os << YAML::Value << t.coverageModulationTableCount;
    os << YAML::Key << "pCoverageModulationTable";
    // pCoverageModulationTable -> Field -> ConstDynamicArray(float)
    if (t.coverageModulationTableCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.coverageModulationTableCount); ++i) {
                os << t.pCoverageModulationTable[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderSMBuiltinsPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSMCount";
    // shaderSMCount -> Field -> uint32_t
    os << YAML::Value << t.shaderSMCount;
    os << YAML::Key << "shaderWarpsPerSM";
    // shaderWarpsPerSM -> Field -> uint32_t
    os << YAML::Value << t.shaderWarpsPerSM;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderSMBuiltins";
    // shaderSMBuiltins -> Field -> VkBool32
    os << YAML::Value << t.shaderSMBuiltins;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrmFormatModifierPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "drmFormatModifier";
    // drmFormatModifier -> Field -> uint64_t
    os << YAML::Value << t.drmFormatModifier;
    os << YAML::Key << "drmFormatModifierPlaneCount";
    // drmFormatModifierPlaneCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierPlaneCount;
    os << YAML::Key << "drmFormatModifierTilingFeatures";
    // drmFormatModifierTilingFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.drmFormatModifierTilingFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrmFormatModifierPropertiesListEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifierCount";
    // drmFormatModifierCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierCount;
    os << YAML::Key << "pDrmFormatModifierProperties";
    // pDrmFormatModifierProperties -> Field -> DynamicArray(VkDrmFormatModifierPropertiesEXT)
    if (t.drmFormatModifierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDrmFormatModifierPropertiesEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.drmFormatModifierCount); ++i) {
                os << t.pDrmFormatModifierProperties[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImageDrmFormatModifierInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifier";
    // drmFormatModifier -> Field -> uint64_t
    os << YAML::Value << t.drmFormatModifier;
    os << YAML::Key << "sharingMode";
    // sharingMode -> Field -> VkSharingMode
    os << YAML::Value << t.sharingMode;
    os << YAML::Key << "queueFamilyIndexCount";
    // queueFamilyIndexCount -> Field -> uint32_t
    os << YAML::Value << t.queueFamilyIndexCount;
    os << YAML::Key << "pQueueFamilyIndices";
    // pQueueFamilyIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.queueFamilyIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.queueFamilyIndexCount); ++i) {
                os << t.pQueueFamilyIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageDrmFormatModifierListCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifierCount";
    // drmFormatModifierCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierCount;
    os << YAML::Key << "pDrmFormatModifiers";
    // pDrmFormatModifiers -> Field -> ConstDynamicArray(uint64_t)
    if (t.drmFormatModifierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.drmFormatModifierCount); ++i) {
                os << t.pDrmFormatModifiers[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageDrmFormatModifierExplicitCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifier";
    // drmFormatModifier -> Field -> uint64_t
    os << YAML::Value << t.drmFormatModifier;
    os << YAML::Key << "drmFormatModifierPlaneCount";
    // drmFormatModifierPlaneCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierPlaneCount;
    os << YAML::Key << "pPlaneLayouts";
    // pPlaneLayouts -> Field -> ConstDynamicArray(VkSubresourceLayout)
    if (t.drmFormatModifierPlaneCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkSubresourceLayout");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.drmFormatModifierPlaneCount); ++i) {
                os << t.pPlaneLayouts[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageDrmFormatModifierPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifier";
    // drmFormatModifier -> Field -> uint64_t
    os << YAML::Value << t.drmFormatModifier;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrmFormatModifierProperties2EXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "drmFormatModifier";
    // drmFormatModifier -> Field -> uint64_t
    os << YAML::Value << t.drmFormatModifier;
    os << YAML::Key << "drmFormatModifierPlaneCount";
    // drmFormatModifierPlaneCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierPlaneCount;
    os << YAML::Key << "drmFormatModifierTilingFeatures";
    // drmFormatModifierTilingFeatures -> Field -> VkFormatFeatureFlags2
    os << YAML::Value << t.drmFormatModifierTilingFeatures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrmFormatModifierPropertiesList2EXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "drmFormatModifierCount";
    // drmFormatModifierCount -> Field -> uint32_t
    os << YAML::Value << t.drmFormatModifierCount;
    os << YAML::Key << "pDrmFormatModifierProperties";
    // pDrmFormatModifierProperties -> Field -> DynamicArray(VkDrmFormatModifierProperties2EXT)
    if (t.drmFormatModifierCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDrmFormatModifierProperties2EXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.drmFormatModifierCount); ++i) {
                os << t.pDrmFormatModifierProperties[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkValidationCacheCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkValidationCacheCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "initialDataSize";
    // initialDataSize -> Field -> size_t
    os << YAML::Value << t.initialDataSize;
    os << YAML::Key << "pInitialData";
    if (t.initialDataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pInitialData;
            for (uint64_t i = 0; i < t.initialDataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShaderModuleValidationCacheCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "validationCache";
    // validationCache -> Field -> VkValidationCacheEXT
    os << YAML::Value << t.validationCache;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkShadingRatePaletteNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "shadingRatePaletteEntryCount";
    // shadingRatePaletteEntryCount -> Field -> uint32_t
    os << YAML::Value << t.shadingRatePaletteEntryCount;
    os << YAML::Key << "pShadingRatePaletteEntries";
    // pShadingRatePaletteEntries -> Field -> ConstDynamicArray(VkShadingRatePaletteEntryNV)
    if (t.shadingRatePaletteEntryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkShadingRatePaletteEntryNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.shadingRatePaletteEntryCount); ++i) {
                os << t.pShadingRatePaletteEntries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportShadingRateImageStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shadingRateImageEnable";
    // shadingRateImageEnable -> Field -> VkBool32
    os << YAML::Value << t.shadingRateImageEnable;
    os << YAML::Key << "viewportCount";
    // viewportCount -> Field -> uint32_t
    os << YAML::Value << t.viewportCount;
    os << YAML::Key << "pShadingRatePalettes";
    // pShadingRatePalettes -> Field -> ConstDynamicArray(VkShadingRatePaletteNV)
    if (t.viewportCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkShadingRatePaletteNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.viewportCount); ++i) {
                os << t.pShadingRatePalettes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShadingRateImageFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shadingRateImage";
    // shadingRateImage -> Field -> VkBool32
    os << YAML::Value << t.shadingRateImage;
    os << YAML::Key << "shadingRateCoarseSampleOrder";
    // shadingRateCoarseSampleOrder -> Field -> VkBool32
    os << YAML::Value << t.shadingRateCoarseSampleOrder;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShadingRateImagePropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shadingRateTexelSize";
    // shadingRateTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.shadingRateTexelSize;
    os << YAML::Key << "shadingRatePaletteSize";
    // shadingRatePaletteSize -> Field -> uint32_t
    os << YAML::Value << t.shadingRatePaletteSize;
    os << YAML::Key << "shadingRateMaxCoarseSamples";
    // shadingRateMaxCoarseSamples -> Field -> uint32_t
    os << YAML::Value << t.shadingRateMaxCoarseSamples;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCoarseSampleLocationNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "pixelX";
    // pixelX -> Field -> uint32_t
    os << YAML::Value << t.pixelX;
    os << YAML::Key << "pixelY";
    // pixelY -> Field -> uint32_t
    os << YAML::Value << t.pixelY;
    os << YAML::Key << "sample";
    // sample -> Field -> uint32_t
    os << YAML::Value << t.sample;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCoarseSampleOrderCustomNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "shadingRate";
    // shadingRate -> Field -> VkShadingRatePaletteEntryNV
    os << YAML::Value << t.shadingRate;
    os << YAML::Key << "sampleCount";
    // sampleCount -> Field -> uint32_t
    os << YAML::Value << t.sampleCount;
    os << YAML::Key << "sampleLocationCount";
    // sampleLocationCount -> Field -> uint32_t
    os << YAML::Value << t.sampleLocationCount;
    os << YAML::Key << "pSampleLocations";
    // pSampleLocations -> Field -> ConstDynamicArray(VkCoarseSampleLocationNV)
    if (t.sampleLocationCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkCoarseSampleLocationNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.sampleLocationCount); ++i) {
                os << t.pSampleLocations[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportCoarseSampleOrderStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampleOrderType";
    // sampleOrderType -> Field -> VkCoarseSampleOrderTypeNV
    os << YAML::Value << t.sampleOrderType;
    os << YAML::Key << "customSampleOrderCount";
    // customSampleOrderCount -> Field -> uint32_t
    os << YAML::Value << t.customSampleOrderCount;
    os << YAML::Key << "pCustomSampleOrders";
    // pCustomSampleOrders -> Field -> ConstDynamicArray(VkCoarseSampleOrderCustomNV)
    if (t.customSampleOrderCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkCoarseSampleOrderCustomNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.customSampleOrderCount); ++i) {
                os << t.pCustomSampleOrders[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRayTracingShaderGroupCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkRayTracingShaderGroupTypeKHR
    os << YAML::Value << t.type;
    os << YAML::Key << "generalShader";
    // generalShader -> Field -> uint32_t
    os << YAML::Value << t.generalShader;
    os << YAML::Key << "closestHitShader";
    // closestHitShader -> Field -> uint32_t
    os << YAML::Value << t.closestHitShader;
    os << YAML::Key << "anyHitShader";
    // anyHitShader -> Field -> uint32_t
    os << YAML::Value << t.anyHitShader;
    os << YAML::Key << "intersectionShader";
    // intersectionShader -> Field -> uint32_t
    os << YAML::Value << t.intersectionShader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRayTracingPipelineCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCreateFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "stageCount";
    // stageCount -> Field -> uint32_t
    os << YAML::Value << t.stageCount;
    os << YAML::Key << "pStages";
    // pStages -> Field -> ConstDynamicArray(VkPipelineShaderStageCreateInfo)
    if (t.stageCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineShaderStageCreateInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.stageCount); ++i) {
                os << t.pStages[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "groupCount";
    // groupCount -> Field -> uint32_t
    os << YAML::Value << t.groupCount;
    os << YAML::Key << "pGroups";
    // pGroups -> Field -> ConstDynamicArray(VkRayTracingShaderGroupCreateInfoNV)
    if (t.groupCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRayTracingShaderGroupCreateInfoNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.groupCount); ++i) {
                os << t.pGroups[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "maxRecursionDepth";
    // maxRecursionDepth -> Field -> uint32_t
    os << YAML::Value << t.maxRecursionDepth;
    os << YAML::Key << "layout";
    // layout -> Field -> VkPipelineLayout
    os << YAML::Value << t.layout;
    os << YAML::Key << "basePipelineHandle";
    // basePipelineHandle -> Field -> VkPipeline
    os << YAML::Value << t.basePipelineHandle;
    os << YAML::Key << "basePipelineIndex";
    // basePipelineIndex -> Field -> int32_t
    os << YAML::Value << t.basePipelineIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeometryTrianglesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vertexData";
    // vertexData -> Field -> VkBuffer
    os << YAML::Value << t.vertexData;
    os << YAML::Key << "vertexOffset";
    // vertexOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.vertexOffset;
    os << YAML::Key << "vertexCount";
    // vertexCount -> Field -> uint32_t
    os << YAML::Value << t.vertexCount;
    os << YAML::Key << "vertexStride";
    // vertexStride -> Field -> VkDeviceSize
    os << YAML::Value << t.vertexStride;
    os << YAML::Key << "vertexFormat";
    // vertexFormat -> Field -> VkFormat
    os << YAML::Value << t.vertexFormat;
    os << YAML::Key << "indexData";
    // indexData -> Field -> VkBuffer
    os << YAML::Value << t.indexData;
    os << YAML::Key << "indexOffset";
    // indexOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.indexOffset;
    os << YAML::Key << "indexCount";
    // indexCount -> Field -> uint32_t
    os << YAML::Value << t.indexCount;
    os << YAML::Key << "indexType";
    // indexType -> Field -> VkIndexType
    os << YAML::Value << t.indexType;
    os << YAML::Key << "transformData";
    // transformData -> Field -> VkBuffer
    os << YAML::Value << t.transformData;
    os << YAML::Key << "transformOffset";
    // transformOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.transformOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeometryAABBNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "aabbData";
    // aabbData -> Field -> VkBuffer
    os << YAML::Value << t.aabbData;
    os << YAML::Key << "numAABBs";
    // numAABBs -> Field -> uint32_t
    os << YAML::Value << t.numAABBs;
    os << YAML::Key << "stride";
    // stride -> Field -> uint32_t
    os << YAML::Value << t.stride;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeometryDataNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "triangles";
    // triangles -> Field -> VkGeometryTrianglesNV
    os << YAML::Value << t.triangles;
    os << YAML::Key << "aabbs";
    // aabbs -> Field -> VkGeometryAABBNV
    os << YAML::Value << t.aabbs;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeometryNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "geometryType";
    // geometryType -> Field -> VkGeometryTypeKHR
    os << YAML::Value << t.geometryType;
    os << YAML::Key << "geometry";
    // geometry -> Field -> VkGeometryDataNV
    os << YAML::Value << t.geometry;
    os << YAML::Key << "flags";
    // flags -> Field -> VkGeometryFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkAccelerationStructureTypeNV
    os << YAML::Value << t.type;
    os << YAML::Key << "flags";
    // flags -> Field -> VkBuildAccelerationStructureFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "instanceCount";
    // instanceCount -> Field -> uint32_t
    os << YAML::Value << t.instanceCount;
    os << YAML::Key << "geometryCount";
    // geometryCount -> Field -> uint32_t
    os << YAML::Value << t.geometryCount;
    os << YAML::Key << "pGeometries";
    // pGeometries -> Field -> ConstDynamicArray(VkGeometryNV)
    if (t.geometryCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkGeometryNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.geometryCount); ++i) {
                os << t.pGeometries[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "compactedSize";
    // compactedSize -> Field -> VkDeviceSize
    os << YAML::Value << t.compactedSize;
    os << YAML::Key << "info";
    // info -> Field -> VkAccelerationStructureInfoNV
    os << YAML::Value << t.info;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindAccelerationStructureMemoryInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "accelerationStructure";
    // accelerationStructure -> Field -> VkAccelerationStructureNV
    os << YAML::Value << t.accelerationStructure;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "memoryOffset";
    // memoryOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.memoryOffset;
    os << YAML::Key << "deviceIndexCount";
    // deviceIndexCount -> Field -> uint32_t
    os << YAML::Value << t.deviceIndexCount;
    os << YAML::Key << "pDeviceIndices";
    // pDeviceIndices -> Field -> ConstDynamicArray(uint32_t)
    if (t.deviceIndexCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.deviceIndexCount); ++i) {
                os << t.pDeviceIndices[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkWriteDescriptorSetAccelerationStructureNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "accelerationStructureCount";
    // accelerationStructureCount -> Field -> uint32_t
    os << YAML::Value << t.accelerationStructureCount;
    os << YAML::Key << "pAccelerationStructures";
    // pAccelerationStructures -> Field -> ConstDynamicArray(VkAccelerationStructureNV)
    if (t.accelerationStructureCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkAccelerationStructureNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.accelerationStructureCount); ++i) {
                os << t.pAccelerationStructures[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureMemoryRequirementsInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkAccelerationStructureMemoryRequirementsTypeNV
    os << YAML::Value << t.type;
    os << YAML::Key << "accelerationStructure";
    // accelerationStructure -> Field -> VkAccelerationStructureNV
    os << YAML::Value << t.accelerationStructure;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRayTracingPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderGroupHandleSize";
    // shaderGroupHandleSize -> Field -> uint32_t
    os << YAML::Value << t.shaderGroupHandleSize;
    os << YAML::Key << "maxRecursionDepth";
    // maxRecursionDepth -> Field -> uint32_t
    os << YAML::Value << t.maxRecursionDepth;
    os << YAML::Key << "maxShaderGroupStride";
    // maxShaderGroupStride -> Field -> uint32_t
    os << YAML::Value << t.maxShaderGroupStride;
    os << YAML::Key << "shaderGroupBaseAlignment";
    // shaderGroupBaseAlignment -> Field -> uint32_t
    os << YAML::Value << t.shaderGroupBaseAlignment;
    os << YAML::Key << "maxGeometryCount";
    // maxGeometryCount -> Field -> uint64_t
    os << YAML::Value << t.maxGeometryCount;
    os << YAML::Key << "maxInstanceCount";
    // maxInstanceCount -> Field -> uint64_t
    os << YAML::Value << t.maxInstanceCount;
    os << YAML::Key << "maxTriangleCount";
    // maxTriangleCount -> Field -> uint64_t
    os << YAML::Value << t.maxTriangleCount;
    os << YAML::Key << "maxDescriptorSetAccelerationStructures";
    // maxDescriptorSetAccelerationStructures -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetAccelerationStructures;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkTransformMatrixKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "matrix";
    // matrix -> Field -> FixedArray(FixedArray(float))
    {
        os << YAML::Value;
        {
            os << YAML::Comment("float");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << YAML::BeginSeq;
                for (uint64_t j = 0; j < uint64_t(4); ++j) {
                    os << t.matrix[i][j];
                }  // for j
                os << YAML::EndSeq;
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAabbPositionsKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "minX";
    // minX -> Field -> float
    os << YAML::Value << t.minX;
    os << YAML::Key << "minY";
    // minY -> Field -> float
    os << YAML::Value << t.minY;
    os << YAML::Key << "minZ";
    // minZ -> Field -> float
    os << YAML::Value << t.minZ;
    os << YAML::Key << "maxX";
    // maxX -> Field -> float
    os << YAML::Value << t.maxX;
    os << YAML::Key << "maxY";
    // maxY -> Field -> float
    os << YAML::Value << t.maxY;
    os << YAML::Key << "maxZ";
    // maxZ -> Field -> float
    os << YAML::Value << t.maxZ;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureInstanceKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "transform";
    // transform -> Field -> VkTransformMatrixKHR
    os << YAML::Value << t.transform;
    os << YAML::Key << "instanceCustomIndex";
    // instanceCustomIndex -> Field -> uint32_t
    os << YAML::Value << t.instanceCustomIndex;
    os << YAML::Key << "mask";
    // mask -> Field -> uint32_t
    os << YAML::Value << t.mask;
    os << YAML::Key << "instanceShaderBindingTableRecordOffset";
    // instanceShaderBindingTableRecordOffset -> Field -> uint32_t
    os << YAML::Value << t.instanceShaderBindingTableRecordOffset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkGeometryInstanceFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "accelerationStructureReference";
    // accelerationStructureReference -> Field -> uint64_t
    os << YAML::Value << t.accelerationStructureReference;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "representativeFragmentTest";
    // representativeFragmentTest -> Field -> VkBool32
    os << YAML::Value << t.representativeFragmentTest;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRepresentativeFragmentTestStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "representativeFragmentTestEnable";
    // representativeFragmentTestEnable -> Field -> VkBool32
    os << YAML::Value << t.representativeFragmentTestEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImageViewImageFormatInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageViewType";
    // imageViewType -> Field -> VkImageViewType
    os << YAML::Value << t.imageViewType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFilterCubicImageViewImageFormatPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "filterCubic";
    // filterCubic -> Field -> VkBool32
    os << YAML::Value << t.filterCubic;
    os << YAML::Key << "filterCubicMinmax";
    // filterCubicMinmax -> Field -> VkBool32
    os << YAML::Value << t.filterCubicMinmax;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryHostPointerInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "pHostPointer";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryHostPointerPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExternalMemoryHostPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minImportedHostPointerAlignment";
    // minImportedHostPointerAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minImportedHostPointerAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCompilerControlCreateInfoAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "compilerControlFlags";
    // compilerControlFlags -> Field -> VkPipelineCompilerControlFlagsAMD
    os << YAML::Value << t.compilerControlFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderCorePropertiesAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderEngineCount";
    // shaderEngineCount -> Field -> uint32_t
    os << YAML::Value << t.shaderEngineCount;
    os << YAML::Key << "shaderArraysPerEngineCount";
    // shaderArraysPerEngineCount -> Field -> uint32_t
    os << YAML::Value << t.shaderArraysPerEngineCount;
    os << YAML::Key << "computeUnitsPerShaderArray";
    // computeUnitsPerShaderArray -> Field -> uint32_t
    os << YAML::Value << t.computeUnitsPerShaderArray;
    os << YAML::Key << "simdPerComputeUnit";
    // simdPerComputeUnit -> Field -> uint32_t
    os << YAML::Value << t.simdPerComputeUnit;
    os << YAML::Key << "wavefrontsPerSimd";
    // wavefrontsPerSimd -> Field -> uint32_t
    os << YAML::Value << t.wavefrontsPerSimd;
    os << YAML::Key << "wavefrontSize";
    // wavefrontSize -> Field -> uint32_t
    os << YAML::Value << t.wavefrontSize;
    os << YAML::Key << "sgprsPerSimd";
    // sgprsPerSimd -> Field -> uint32_t
    os << YAML::Value << t.sgprsPerSimd;
    os << YAML::Key << "minSgprAllocation";
    // minSgprAllocation -> Field -> uint32_t
    os << YAML::Value << t.minSgprAllocation;
    os << YAML::Key << "maxSgprAllocation";
    // maxSgprAllocation -> Field -> uint32_t
    os << YAML::Value << t.maxSgprAllocation;
    os << YAML::Key << "sgprAllocationGranularity";
    // sgprAllocationGranularity -> Field -> uint32_t
    os << YAML::Value << t.sgprAllocationGranularity;
    os << YAML::Key << "vgprsPerSimd";
    // vgprsPerSimd -> Field -> uint32_t
    os << YAML::Value << t.vgprsPerSimd;
    os << YAML::Key << "minVgprAllocation";
    // minVgprAllocation -> Field -> uint32_t
    os << YAML::Value << t.minVgprAllocation;
    os << YAML::Key << "maxVgprAllocation";
    // maxVgprAllocation -> Field -> uint32_t
    os << YAML::Value << t.maxVgprAllocation;
    os << YAML::Key << "vgprAllocationGranularity";
    // vgprAllocationGranularity -> Field -> uint32_t
    os << YAML::Value << t.vgprAllocationGranularity;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceMemoryOverallocationCreateInfoAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "overallocationBehavior";
    // overallocationBehavior -> Field -> VkMemoryOverallocationBehaviorAMD
    os << YAML::Value << t.overallocationBehavior;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxVertexAttribDivisor";
    // maxVertexAttribDivisor -> Field -> uint32_t
    os << YAML::Value << t.maxVertexAttribDivisor;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_GGP
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentFrameTokenGGP &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "frameToken";
    // frameToken -> Field -> GgpFrameToken
    os << YAML::Value << t.frameToken;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_GGP

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMeshShaderFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "taskShader";
    // taskShader -> Field -> VkBool32
    os << YAML::Value << t.taskShader;
    os << YAML::Key << "meshShader";
    // meshShader -> Field -> VkBool32
    os << YAML::Value << t.meshShader;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMeshShaderPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxDrawMeshTasksCount";
    // maxDrawMeshTasksCount -> Field -> uint32_t
    os << YAML::Value << t.maxDrawMeshTasksCount;
    os << YAML::Key << "maxTaskWorkGroupInvocations";
    // maxTaskWorkGroupInvocations -> Field -> uint32_t
    os << YAML::Value << t.maxTaskWorkGroupInvocations;
    os << YAML::Key << "maxTaskWorkGroupSize";
    // maxTaskWorkGroupSize -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.maxTaskWorkGroupSize[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "maxTaskTotalMemorySize";
    // maxTaskTotalMemorySize -> Field -> uint32_t
    os << YAML::Value << t.maxTaskTotalMemorySize;
    os << YAML::Key << "maxTaskOutputCount";
    // maxTaskOutputCount -> Field -> uint32_t
    os << YAML::Value << t.maxTaskOutputCount;
    os << YAML::Key << "maxMeshWorkGroupInvocations";
    // maxMeshWorkGroupInvocations -> Field -> uint32_t
    os << YAML::Value << t.maxMeshWorkGroupInvocations;
    os << YAML::Key << "maxMeshWorkGroupSize";
    // maxMeshWorkGroupSize -> Field -> FixedArray(uint32_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(3); ++i) {
                os << t.maxMeshWorkGroupSize[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "maxMeshTotalMemorySize";
    // maxMeshTotalMemorySize -> Field -> uint32_t
    os << YAML::Value << t.maxMeshTotalMemorySize;
    os << YAML::Key << "maxMeshOutputVertices";
    // maxMeshOutputVertices -> Field -> uint32_t
    os << YAML::Value << t.maxMeshOutputVertices;
    os << YAML::Key << "maxMeshOutputPrimitives";
    // maxMeshOutputPrimitives -> Field -> uint32_t
    os << YAML::Value << t.maxMeshOutputPrimitives;
    os << YAML::Key << "maxMeshMultiviewViewCount";
    // maxMeshMultiviewViewCount -> Field -> uint32_t
    os << YAML::Value << t.maxMeshMultiviewViewCount;
    os << YAML::Key << "meshOutputPerVertexGranularity";
    // meshOutputPerVertexGranularity -> Field -> uint32_t
    os << YAML::Value << t.meshOutputPerVertexGranularity;
    os << YAML::Key << "meshOutputPerPrimitiveGranularity";
    // meshOutputPerPrimitiveGranularity -> Field -> uint32_t
    os << YAML::Value << t.meshOutputPerPrimitiveGranularity;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDrawMeshTasksIndirectCommandNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "taskCount";
    // taskCount -> Field -> uint32_t
    os << YAML::Value << t.taskCount;
    os << YAML::Key << "firstTask";
    // firstTask -> Field -> uint32_t
    os << YAML::Value << t.firstTask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderImageFootprintFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageFootprint";
    // imageFootprint -> Field -> VkBool32
    os << YAML::Value << t.imageFootprint;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportExclusiveScissorStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "exclusiveScissorCount";
    // exclusiveScissorCount -> Field -> uint32_t
    os << YAML::Value << t.exclusiveScissorCount;
    os << YAML::Key << "pExclusiveScissors";
    // pExclusiveScissors -> Field -> ConstDynamicArray(VkRect2D)
    if (t.exclusiveScissorCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkRect2D");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.exclusiveScissorCount); ++i) {
                os << t.pExclusiveScissors[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExclusiveScissorFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "exclusiveScissor";
    // exclusiveScissor -> Field -> VkBool32
    os << YAML::Value << t.exclusiveScissor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyCheckpointPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "checkpointExecutionStageMask";
    // checkpointExecutionStageMask -> Field -> VkPipelineStageFlags
    os << YAML::Value << t.checkpointExecutionStageMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCheckpointDataNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stage";
    // stage -> Field -> VkPipelineStageFlagBits
    os << YAML::Value << t.stage;
    os << YAML::Key << "pCheckpointMarker";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueueFamilyCheckpointProperties2NV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "checkpointExecutionStageMask";
    // checkpointExecutionStageMask -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.checkpointExecutionStageMask;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCheckpointData2NV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stage";
    // stage -> Field -> VkPipelineStageFlags2
    os << YAML::Value << t.stage;
    os << YAML::Key << "pCheckpointMarker";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentTimingFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentTiming";
    // presentTiming -> Field -> VkBool32
    os << YAML::Value << t.presentTiming;
    os << YAML::Key << "presentAtAbsoluteTime";
    // presentAtAbsoluteTime -> Field -> VkBool32
    os << YAML::Value << t.presentAtAbsoluteTime;
    os << YAML::Key << "presentAtRelativeTime";
    // presentAtRelativeTime -> Field -> VkBool32
    os << YAML::Value << t.presentAtRelativeTime;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentTimingSurfaceCapabilitiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentTimingSupported";
    // presentTimingSupported -> Field -> VkBool32
    os << YAML::Value << t.presentTimingSupported;
    os << YAML::Key << "presentAtAbsoluteTimeSupported";
    // presentAtAbsoluteTimeSupported -> Field -> VkBool32
    os << YAML::Value << t.presentAtAbsoluteTimeSupported;
    os << YAML::Key << "presentAtRelativeTimeSupported";
    // presentAtRelativeTimeSupported -> Field -> VkBool32
    os << YAML::Value << t.presentAtRelativeTimeSupported;
    os << YAML::Key << "presentStageQueries";
    // presentStageQueries -> Field -> VkPresentStageFlagsEXT
    os << YAML::Value << t.presentStageQueries;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainCalibratedTimestampInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::Key << "presentStage";
    // presentStage -> Field -> VkPresentStageFlagsEXT
    os << YAML::Value << t.presentStage;
    os << YAML::Key << "timeDomainId";
    // timeDomainId -> Field -> uint64_t
    os << YAML::Value << t.timeDomainId;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainTimingPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "refreshDuration";
    // refreshDuration -> Field -> uint64_t
    os << YAML::Value << t.refreshDuration;
    os << YAML::Key << "refreshInterval";
    // refreshInterval -> Field -> uint64_t
    os << YAML::Value << t.refreshInterval;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainTimeDomainPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "timeDomainCount";
    // timeDomainCount -> Field -> uint32_t
    os << YAML::Value << t.timeDomainCount;
    os << YAML::Key << "pTimeDomains";
    // pTimeDomains -> Field -> DynamicArray(VkTimeDomainKHR)
    if (t.timeDomainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkTimeDomainKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.timeDomainCount); ++i) {
                os << t.pTimeDomains[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pTimeDomainIds";
    // pTimeDomainIds -> Field -> DynamicArray(uint64_t)
    if (t.timeDomainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint64_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.timeDomainCount); ++i) {
                os << t.pTimeDomainIds[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPastPresentationTimingInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPastPresentationTimingFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "swapchain";
    // swapchain -> Field -> VkSwapchainKHR
    os << YAML::Value << t.swapchain;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentStageTimeEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "stage";
    // stage -> Field -> VkPresentStageFlagsEXT
    os << YAML::Value << t.stage;
    os << YAML::Key << "time";
    // time -> Field -> uint64_t
    os << YAML::Value << t.time;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPastPresentationTimingEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentId";
    // presentId -> Field -> uint64_t
    os << YAML::Value << t.presentId;
    os << YAML::Key << "targetTime";
    // targetTime -> Field -> uint64_t
    os << YAML::Value << t.targetTime;
    os << YAML::Key << "presentStageCount";
    // presentStageCount -> Field -> uint32_t
    os << YAML::Value << t.presentStageCount;
    os << YAML::Key << "pPresentStages";
    // pPresentStages -> Field -> DynamicArray(VkPresentStageTimeEXT)
    if (t.presentStageCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentStageTimeEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.presentStageCount); ++i) {
                os << t.pPresentStages[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "timeDomain";
    // timeDomain -> Field -> VkTimeDomainKHR
    os << YAML::Value << t.timeDomain;
    os << YAML::Key << "timeDomainId";
    // timeDomainId -> Field -> uint64_t
    os << YAML::Value << t.timeDomainId;
    os << YAML::Key << "reportComplete";
    // reportComplete -> Field -> VkBool32
    os << YAML::Value << t.reportComplete;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPastPresentationTimingPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "timingPropertiesCounter";
    // timingPropertiesCounter -> Field -> uint64_t
    os << YAML::Value << t.timingPropertiesCounter;
    os << YAML::Key << "timeDomainsCounter";
    // timeDomainsCounter -> Field -> uint64_t
    os << YAML::Value << t.timeDomainsCounter;
    os << YAML::Key << "presentationTimingCount";
    // presentationTimingCount -> Field -> uint32_t
    os << YAML::Value << t.presentationTimingCount;
    os << YAML::Key << "pPresentationTimings";
    // pPresentationTimings -> Field -> DynamicArray(VkPastPresentationTimingEXT)
    if (t.presentationTimingCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPastPresentationTimingEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.presentationTimingCount); ++i) {
                os << t.pPresentationTimings[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentTimingInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPresentTimingInfoFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "targetTime";
    // targetTime -> Field -> uint64_t
    os << YAML::Value << t.targetTime;
    os << YAML::Key << "timeDomainId";
    // timeDomainId -> Field -> uint64_t
    os << YAML::Value << t.timeDomainId;
    os << YAML::Key << "presentStageQueries";
    // presentStageQueries -> Field -> VkPresentStageFlagsEXT
    os << YAML::Value << t.presentStageQueries;
    os << YAML::Key << "targetTimeDomainPresentStage";
    // targetTimeDomainPresentStage -> Field -> VkPresentStageFlagsEXT
    os << YAML::Value << t.targetTimeDomainPresentStage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPresentTimingsInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "swapchainCount";
    // swapchainCount -> Field -> uint32_t
    os << YAML::Value << t.swapchainCount;
    os << YAML::Key << "pTimingInfos";
    // pTimingInfos -> Field -> ConstDynamicArray(VkPresentTimingInfoEXT)
    if (t.swapchainCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPresentTimingInfoEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.swapchainCount); ++i) {
                os << t.pTimingInfos[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderIntegerFunctions2";
    // shaderIntegerFunctions2 -> Field -> VkBool32
    os << YAML::Value << t.shaderIntegerFunctions2;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceValueDataINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "value32";
    // value32 -> Field -> uint32_t
    os << YAML::Value << t.value32;
    os << YAML::Key << "value64";
    // value64 -> Field -> uint64_t
    os << YAML::Value << t.value64;
    os << YAML::Key << "valueFloat";
    // valueFloat -> Field -> float
    os << YAML::Value << t.valueFloat;
    os << YAML::Key << "valueBool";
    // valueBool -> Field -> VkBool32
    os << YAML::Value << t.valueBool;
    os << YAML::Key << "valueString";
    // valueString -> Field -> string
    os << YAML::Value << t.valueString;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceValueINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "type";
    // type -> Field -> VkPerformanceValueTypeINTEL
    os << YAML::Value << t.type;
    os << YAML::Key << "data";
    // data -> Field -> VkPerformanceValueDataINTEL
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkInitializePerformanceApiInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pUserData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueryPoolPerformanceQueryCreateInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "performanceCountersSampling";
    // performanceCountersSampling -> Field -> VkQueryPoolSamplingModeINTEL
    os << YAML::Value << t.performanceCountersSampling;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceMarkerInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "marker";
    // marker -> Field -> uint64_t
    os << YAML::Value << t.marker;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceStreamMarkerInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "marker";
    // marker -> Field -> uint32_t
    os << YAML::Value << t.marker;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceOverrideInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkPerformanceOverrideTypeINTEL
    os << YAML::Value << t.type;
    os << YAML::Key << "enable";
    // enable -> Field -> VkBool32
    os << YAML::Value << t.enable;
    os << YAML::Key << "parameter";
    // parameter -> Field -> uint64_t
    os << YAML::Value << t.parameter;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerformanceConfigurationAcquireInfoINTEL &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkPerformanceConfigurationTypeINTEL
    os << YAML::Value << t.type;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePCIBusInfoPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pciDomain";
    // pciDomain -> Field -> uint32_t
    os << YAML::Value << t.pciDomain;
    os << YAML::Key << "pciBus";
    // pciBus -> Field -> uint32_t
    os << YAML::Value << t.pciBus;
    os << YAML::Key << "pciDevice";
    // pciDevice -> Field -> uint32_t
    os << YAML::Value << t.pciDevice;
    os << YAML::Key << "pciFunction";
    // pciFunction -> Field -> uint32_t
    os << YAML::Value << t.pciFunction;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDisplayNativeHdrSurfaceCapabilitiesAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "localDimmingSupport";
    // localDimmingSupport -> Field -> VkBool32
    os << YAML::Value << t.localDimmingSupport;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainDisplayNativeHdrCreateInfoAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "localDimmingEnable";
    // localDimmingEnable -> Field -> VkBool32
    os << YAML::Value << t.localDimmingEnable;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImagePipeSurfaceCreateInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImagePipeSurfaceCreateFlagsFUCHSIA
    os << YAML::Value << t.flags;
    os << YAML::Key << "imagePipeHandle";
    // imagePipeHandle -> Field -> zx_handle_t
    os << YAML::Value << t.imagePipeHandle;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMetalSurfaceCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkMetalSurfaceCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "pLayer";
    // non-dereferenced pointer
    os << YAML::Value << t.pLayer;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentDensityMapFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentDensityMap";
    // fragmentDensityMap -> Field -> VkBool32
    os << YAML::Value << t.fragmentDensityMap;
    os << YAML::Key << "fragmentDensityMapDynamic";
    // fragmentDensityMapDynamic -> Field -> VkBool32
    os << YAML::Value << t.fragmentDensityMapDynamic;
    os << YAML::Key << "fragmentDensityMapNonSubsampledImages";
    // fragmentDensityMapNonSubsampledImages -> Field -> VkBool32
    os << YAML::Value << t.fragmentDensityMapNonSubsampledImages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentDensityMapPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minFragmentDensityTexelSize";
    // minFragmentDensityTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.minFragmentDensityTexelSize;
    os << YAML::Key << "maxFragmentDensityTexelSize";
    // maxFragmentDensityTexelSize -> Field -> VkExtent2D
    os << YAML::Value << t.maxFragmentDensityTexelSize;
    os << YAML::Key << "fragmentDensityInvocations";
    // fragmentDensityInvocations -> Field -> VkBool32
    os << YAML::Value << t.fragmentDensityInvocations;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassFragmentDensityMapCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentDensityMapAttachment";
    // fragmentDensityMapAttachment -> Field -> VkAttachmentReference
    os << YAML::Value << t.fragmentDensityMapAttachment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderingFragmentDensityMapAttachmentInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "imageLayout";
    // imageLayout -> Field -> VkImageLayout
    os << YAML::Value << t.imageLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderCoreProperties2AMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderCoreFeatures";
    // shaderCoreFeatures -> Field -> VkShaderCorePropertiesFlagsAMD
    os << YAML::Value << t.shaderCoreFeatures;
    os << YAML::Key << "activeComputeUnitCount";
    // activeComputeUnitCount -> Field -> uint32_t
    os << YAML::Value << t.activeComputeUnitCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCoherentMemoryFeaturesAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceCoherentMemory";
    // deviceCoherentMemory -> Field -> VkBool32
    os << YAML::Value << t.deviceCoherentMemory;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderImageInt64Atomics";
    // shaderImageInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderImageInt64Atomics;
    os << YAML::Key << "sparseImageInt64Atomics";
    // sparseImageInt64Atomics -> Field -> VkBool32
    os << YAML::Value << t.sparseImageInt64Atomics;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMemoryBudgetPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "heapBudget";
    // heapBudget -> Field -> FixedArray(VkDeviceSize)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceSize");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_MEMORY_HEAPS); ++i) {
                os << t.heapBudget[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "heapUsage";
    // heapUsage -> Field -> FixedArray(VkDeviceSize)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDeviceSize");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_MAX_MEMORY_HEAPS); ++i) {
                os << t.heapUsage[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMemoryPriorityFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryPriority";
    // memoryPriority -> Field -> VkBool32
    os << YAML::Value << t.memoryPriority;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryPriorityAllocateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "priority";
    // priority -> Field -> float
    os << YAML::Value << t.priority;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dedicatedAllocationImageAliasing";
    // dedicatedAllocationImageAliasing -> Field -> VkBool32
    os << YAML::Value << t.dedicatedAllocationImageAliasing;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "bufferDeviceAddress";
    // bufferDeviceAddress -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddress;
    os << YAML::Key << "bufferDeviceAddressCaptureReplay";
    // bufferDeviceAddressCaptureReplay -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressCaptureReplay;
    os << YAML::Key << "bufferDeviceAddressMultiDevice";
    // bufferDeviceAddressMultiDevice -> Field -> VkBool32
    os << YAML::Value << t.bufferDeviceAddressMultiDevice;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferDeviceAddressCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceAddress";
    // deviceAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.deviceAddress);
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkValidationFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "enabledValidationFeatureCount";
    // enabledValidationFeatureCount -> Field -> uint32_t
    os << YAML::Value << t.enabledValidationFeatureCount;
    os << YAML::Key << "pEnabledValidationFeatures";
    // pEnabledValidationFeatures -> Field -> ConstDynamicArray(VkValidationFeatureEnableEXT)
    if (t.enabledValidationFeatureCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkValidationFeatureEnableEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.enabledValidationFeatureCount); ++i) {
                os << t.pEnabledValidationFeatures[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "disabledValidationFeatureCount";
    // disabledValidationFeatureCount -> Field -> uint32_t
    os << YAML::Value << t.disabledValidationFeatureCount;
    os << YAML::Key << "pDisabledValidationFeatures";
    // pDisabledValidationFeatures -> Field -> ConstDynamicArray(VkValidationFeatureDisableEXT)
    if (t.disabledValidationFeatureCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkValidationFeatureDisableEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.disabledValidationFeatureCount); ++i) {
                os << t.pDisabledValidationFeatures[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCooperativeMatrixPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "MSize";
    // MSize -> Field -> uint32_t
    os << YAML::Value << t.MSize;
    os << YAML::Key << "NSize";
    // NSize -> Field -> uint32_t
    os << YAML::Value << t.NSize;
    os << YAML::Key << "KSize";
    // KSize -> Field -> uint32_t
    os << YAML::Value << t.KSize;
    os << YAML::Key << "AType";
    // AType -> Field -> VkComponentTypeNV
    os << YAML::Value << t.AType;
    os << YAML::Key << "BType";
    // BType -> Field -> VkComponentTypeNV
    os << YAML::Value << t.BType;
    os << YAML::Key << "CType";
    // CType -> Field -> VkComponentTypeNV
    os << YAML::Value << t.CType;
    os << YAML::Key << "DType";
    // DType -> Field -> VkComponentTypeNV
    os << YAML::Value << t.DType;
    os << YAML::Key << "scope";
    // scope -> Field -> VkScopeNV
    os << YAML::Value << t.scope;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCooperativeMatrixFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cooperativeMatrix";
    // cooperativeMatrix -> Field -> VkBool32
    os << YAML::Value << t.cooperativeMatrix;
    os << YAML::Key << "cooperativeMatrixRobustBufferAccess";
    // cooperativeMatrixRobustBufferAccess -> Field -> VkBool32
    os << YAML::Value << t.cooperativeMatrixRobustBufferAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCooperativeMatrixPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cooperativeMatrixSupportedStages";
    // cooperativeMatrixSupportedStages -> Field -> VkShaderStageFlags
    os << YAML::Value << t.cooperativeMatrixSupportedStages;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCoverageReductionModeFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "coverageReductionMode";
    // coverageReductionMode -> Field -> VkBool32
    os << YAML::Value << t.coverageReductionMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineCoverageReductionStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkPipelineCoverageReductionStateCreateFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "coverageReductionMode";
    // coverageReductionMode -> Field -> VkCoverageReductionModeNV
    os << YAML::Value << t.coverageReductionMode;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkFramebufferMixedSamplesCombinationNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "coverageReductionMode";
    // coverageReductionMode -> Field -> VkCoverageReductionModeNV
    os << YAML::Value << t.coverageReductionMode;
    os << YAML::Key << "rasterizationSamples";
    // rasterizationSamples -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.rasterizationSamples;
    os << YAML::Key << "depthStencilSamples";
    // depthStencilSamples -> Field -> VkSampleCountFlags
    os << YAML::Value << t.depthStencilSamples;
    os << YAML::Key << "colorSamples";
    // colorSamples -> Field -> VkSampleCountFlags
    os << YAML::Value << t.colorSamples;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentShaderSampleInterlock";
    // fragmentShaderSampleInterlock -> Field -> VkBool32
    os << YAML::Value << t.fragmentShaderSampleInterlock;
    os << YAML::Key << "fragmentShaderPixelInterlock";
    // fragmentShaderPixelInterlock -> Field -> VkBool32
    os << YAML::Value << t.fragmentShaderPixelInterlock;
    os << YAML::Key << "fragmentShaderShadingRateInterlock";
    // fragmentShaderShadingRateInterlock -> Field -> VkBool32
    os << YAML::Value << t.fragmentShaderShadingRateInterlock;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "ycbcrImageArrays";
    // ycbcrImageArrays -> Field -> VkBool32
    os << YAML::Value << t.ycbcrImageArrays;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProvokingVertexFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "provokingVertexLast";
    // provokingVertexLast -> Field -> VkBool32
    os << YAML::Value << t.provokingVertexLast;
    os << YAML::Key << "transformFeedbackPreservesProvokingVertex";
    // transformFeedbackPreservesProvokingVertex -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackPreservesProvokingVertex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceProvokingVertexPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "provokingVertexModePerPipeline";
    // provokingVertexModePerPipeline -> Field -> VkBool32
    os << YAML::Value << t.provokingVertexModePerPipeline;
    os << YAML::Key << "transformFeedbackPreservesTriangleFanProvokingVertex";
    // transformFeedbackPreservesTriangleFanProvokingVertex -> Field -> VkBool32
    os << YAML::Value << t.transformFeedbackPreservesTriangleFanProvokingVertex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "provokingVertexMode";
    // provokingVertexMode -> Field -> VkProvokingVertexModeEXT
    os << YAML::Value << t.provokingVertexMode;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceFullScreenExclusiveInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fullScreenExclusive";
    // fullScreenExclusive -> Field -> VkFullScreenExclusiveEXT
    os << YAML::Value << t.fullScreenExclusive;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilitiesFullScreenExclusiveEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fullScreenExclusiveSupported";
    // fullScreenExclusiveSupported -> Field -> VkBool32
    os << YAML::Value << t.fullScreenExclusiveSupported;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceFullScreenExclusiveWin32InfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hmonitor";
    // hmonitor -> Field -> HMONITOR
    os << YAML::Value << t.hmonitor;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_WIN32_KHR

YAML::Emitter &operator<<(YAML::Emitter &os, const VkHeadlessSurfaceCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkHeadlessSurfaceCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderBufferFloat32Atomics";
    // shaderBufferFloat32Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat32Atomics;
    os << YAML::Key << "shaderBufferFloat32AtomicAdd";
    // shaderBufferFloat32AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat32AtomicAdd;
    os << YAML::Key << "shaderBufferFloat64Atomics";
    // shaderBufferFloat64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat64Atomics;
    os << YAML::Key << "shaderBufferFloat64AtomicAdd";
    // shaderBufferFloat64AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat64AtomicAdd;
    os << YAML::Key << "shaderSharedFloat32Atomics";
    // shaderSharedFloat32Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat32Atomics;
    os << YAML::Key << "shaderSharedFloat32AtomicAdd";
    // shaderSharedFloat32AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat32AtomicAdd;
    os << YAML::Key << "shaderSharedFloat64Atomics";
    // shaderSharedFloat64Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat64Atomics;
    os << YAML::Key << "shaderSharedFloat64AtomicAdd";
    // shaderSharedFloat64AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat64AtomicAdd;
    os << YAML::Key << "shaderImageFloat32Atomics";
    // shaderImageFloat32Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderImageFloat32Atomics;
    os << YAML::Key << "shaderImageFloat32AtomicAdd";
    // shaderImageFloat32AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderImageFloat32AtomicAdd;
    os << YAML::Key << "sparseImageFloat32Atomics";
    // sparseImageFloat32Atomics -> Field -> VkBool32
    os << YAML::Value << t.sparseImageFloat32Atomics;
    os << YAML::Key << "sparseImageFloat32AtomicAdd";
    // sparseImageFloat32AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.sparseImageFloat32AtomicAdd;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "extendedDynamicState";
    // extendedDynamicState -> Field -> VkBool32
    os << YAML::Value << t.extendedDynamicState;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMapMemoryPlacedFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryMapPlaced";
    // memoryMapPlaced -> Field -> VkBool32
    os << YAML::Value << t.memoryMapPlaced;
    os << YAML::Key << "memoryMapRangePlaced";
    // memoryMapRangePlaced -> Field -> VkBool32
    os << YAML::Value << t.memoryMapRangePlaced;
    os << YAML::Key << "memoryUnmapReserve";
    // memoryUnmapReserve -> Field -> VkBool32
    os << YAML::Value << t.memoryUnmapReserve;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMapMemoryPlacedPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minPlacedMemoryMapAlignment";
    // minPlacedMemoryMapAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.minPlacedMemoryMapAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryMapPlacedInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pPlacedAddress";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderBufferFloat16Atomics";
    // shaderBufferFloat16Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat16Atomics;
    os << YAML::Key << "shaderBufferFloat16AtomicAdd";
    // shaderBufferFloat16AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat16AtomicAdd;
    os << YAML::Key << "shaderBufferFloat16AtomicMinMax";
    // shaderBufferFloat16AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat16AtomicMinMax;
    os << YAML::Key << "shaderBufferFloat32AtomicMinMax";
    // shaderBufferFloat32AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat32AtomicMinMax;
    os << YAML::Key << "shaderBufferFloat64AtomicMinMax";
    // shaderBufferFloat64AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderBufferFloat64AtomicMinMax;
    os << YAML::Key << "shaderSharedFloat16Atomics";
    // shaderSharedFloat16Atomics -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat16Atomics;
    os << YAML::Key << "shaderSharedFloat16AtomicAdd";
    // shaderSharedFloat16AtomicAdd -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat16AtomicAdd;
    os << YAML::Key << "shaderSharedFloat16AtomicMinMax";
    // shaderSharedFloat16AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat16AtomicMinMax;
    os << YAML::Key << "shaderSharedFloat32AtomicMinMax";
    // shaderSharedFloat32AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat32AtomicMinMax;
    os << YAML::Key << "shaderSharedFloat64AtomicMinMax";
    // shaderSharedFloat64AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderSharedFloat64AtomicMinMax;
    os << YAML::Key << "shaderImageFloat32AtomicMinMax";
    // shaderImageFloat32AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.shaderImageFloat32AtomicMinMax;
    os << YAML::Key << "sparseImageFloat32AtomicMinMax";
    // sparseImageFloat32AtomicMinMax -> Field -> VkBool32
    os << YAML::Value << t.sparseImageFloat32AtomicMinMax;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxGraphicsShaderGroupCount";
    // maxGraphicsShaderGroupCount -> Field -> uint32_t
    os << YAML::Value << t.maxGraphicsShaderGroupCount;
    os << YAML::Key << "maxIndirectSequenceCount";
    // maxIndirectSequenceCount -> Field -> uint32_t
    os << YAML::Value << t.maxIndirectSequenceCount;
    os << YAML::Key << "maxIndirectCommandsTokenCount";
    // maxIndirectCommandsTokenCount -> Field -> uint32_t
    os << YAML::Value << t.maxIndirectCommandsTokenCount;
    os << YAML::Key << "maxIndirectCommandsStreamCount";
    // maxIndirectCommandsStreamCount -> Field -> uint32_t
    os << YAML::Value << t.maxIndirectCommandsStreamCount;
    os << YAML::Key << "maxIndirectCommandsTokenOffset";
    // maxIndirectCommandsTokenOffset -> Field -> uint32_t
    os << YAML::Value << t.maxIndirectCommandsTokenOffset;
    os << YAML::Key << "maxIndirectCommandsStreamStride";
    // maxIndirectCommandsStreamStride -> Field -> uint32_t
    os << YAML::Value << t.maxIndirectCommandsStreamStride;
    os << YAML::Key << "minSequencesCountBufferOffsetAlignment";
    // minSequencesCountBufferOffsetAlignment -> Field -> uint32_t
    os << YAML::Value << t.minSequencesCountBufferOffsetAlignment;
    os << YAML::Key << "minSequencesIndexBufferOffsetAlignment";
    // minSequencesIndexBufferOffsetAlignment -> Field -> uint32_t
    os << YAML::Value << t.minSequencesIndexBufferOffsetAlignment;
    os << YAML::Key << "minIndirectCommandsBufferOffsetAlignment";
    // minIndirectCommandsBufferOffsetAlignment -> Field -> uint32_t
    os << YAML::Value << t.minIndirectCommandsBufferOffsetAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceGeneratedCommands";
    // deviceGeneratedCommands -> Field -> VkBool32
    os << YAML::Value << t.deviceGeneratedCommands;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGraphicsShaderGroupCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "stageCount";
    // stageCount -> Field -> uint32_t
    os << YAML::Value << t.stageCount;
    os << YAML::Key << "pStages";
    // pStages -> Field -> ConstDynamicArray(VkPipelineShaderStageCreateInfo)
    if (t.stageCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipelineShaderStageCreateInfo");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.stageCount); ++i) {
                os << t.pStages[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pVertexInputState";
    // pointer
    if (t.pVertexInputState != nullptr) {
        os << YAML::Value << *t.pVertexInputState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pTessellationState";
    // pointer
    if (t.pTessellationState != nullptr) {
        os << YAML::Value << *t.pTessellationState;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGraphicsPipelineShaderGroupsCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "groupCount";
    // groupCount -> Field -> uint32_t
    os << YAML::Value << t.groupCount;
    os << YAML::Key << "pGroups";
    // pGroups -> Field -> ConstDynamicArray(VkGraphicsShaderGroupCreateInfoNV)
    if (t.groupCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkGraphicsShaderGroupCreateInfoNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.groupCount); ++i) {
                os << t.pGroups[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pipelineCount";
    // pipelineCount -> Field -> uint32_t
    os << YAML::Value << t.pipelineCount;
    os << YAML::Key << "pPipelines";
    // pPipelines -> Field -> ConstDynamicArray(VkPipeline)
    if (t.pipelineCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkPipeline");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.pipelineCount); ++i) {
                os << t.pPipelines[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindShaderGroupIndirectCommandNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "groupIndex";
    // groupIndex -> Field -> uint32_t
    os << YAML::Value << t.groupIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindIndexBufferIndirectCommandNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "bufferAddress";
    // bufferAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.bufferAddress);
    os << YAML::Key << "size";
    // size -> Field -> uint32_t
    os << YAML::Value << t.size;
    os << YAML::Key << "indexType";
    // indexType -> Field -> VkIndexType
    os << YAML::Value << t.indexType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBindVertexBufferIndirectCommandNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "bufferAddress";
    // bufferAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.bufferAddress);
    os << YAML::Key << "size";
    // size -> Field -> uint32_t
    os << YAML::Value << t.size;
    os << YAML::Key << "stride";
    // stride -> Field -> uint32_t
    os << YAML::Value << t.stride;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSetStateFlagsIndirectCommandNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "data";
    // data -> Field -> uint32_t
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkIndirectCommandsStreamNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::Key << "offset";
    // offset -> Field -> VkDeviceSize
    os << YAML::Value << t.offset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkIndirectCommandsLayoutTokenNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "tokenType";
    // tokenType -> Field -> VkIndirectCommandsTokenTypeNV
    os << YAML::Value << t.tokenType;
    os << YAML::Key << "stream";
    // stream -> Field -> uint32_t
    os << YAML::Value << t.stream;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::Key << "vertexBindingUnit";
    // vertexBindingUnit -> Field -> uint32_t
    os << YAML::Value << t.vertexBindingUnit;
    os << YAML::Key << "vertexDynamicStride";
    // vertexDynamicStride -> Field -> VkBool32
    os << YAML::Value << t.vertexDynamicStride;
    os << YAML::Key << "pushconstantPipelineLayout";
    // pushconstantPipelineLayout -> Field -> VkPipelineLayout
    os << YAML::Value << t.pushconstantPipelineLayout;
    os << YAML::Key << "pushconstantShaderStageFlags";
    // pushconstantShaderStageFlags -> Field -> VkShaderStageFlags
    os << YAML::Value << t.pushconstantShaderStageFlags;
    os << YAML::Key << "pushconstantOffset";
    // pushconstantOffset -> Field -> uint32_t
    os << YAML::Value << t.pushconstantOffset;
    os << YAML::Key << "pushconstantSize";
    // pushconstantSize -> Field -> uint32_t
    os << YAML::Value << t.pushconstantSize;
    os << YAML::Key << "indirectStateFlags";
    // indirectStateFlags -> Field -> VkIndirectStateFlagsNV
    os << YAML::Value << t.indirectStateFlags;
    os << YAML::Key << "indexTypeCount";
    // indexTypeCount -> Field -> uint32_t
    os << YAML::Value << t.indexTypeCount;
    os << YAML::Key << "pIndexTypes";
    // pIndexTypes -> Field -> ConstDynamicArray(VkIndexType)
    if (t.indexTypeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkIndexType");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.indexTypeCount); ++i) {
                os << t.pIndexTypes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "pIndexTypeValues";
    // pIndexTypeValues -> Field -> ConstDynamicArray(uint32_t)
    if (t.indexTypeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.indexTypeCount); ++i) {
                os << t.pIndexTypeValues[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkIndirectCommandsLayoutCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkIndirectCommandsLayoutUsageFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "tokenCount";
    // tokenCount -> Field -> uint32_t
    os << YAML::Value << t.tokenCount;
    os << YAML::Key << "pTokens";
    // pTokens -> Field -> ConstDynamicArray(VkIndirectCommandsLayoutTokenNV)
    if (t.tokenCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkIndirectCommandsLayoutTokenNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.tokenCount); ++i) {
                os << t.pTokens[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "streamCount";
    // streamCount -> Field -> uint32_t
    os << YAML::Value << t.streamCount;
    os << YAML::Key << "pStreamStrides";
    // pStreamStrides -> Field -> ConstDynamicArray(uint32_t)
    if (t.streamCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("uint32_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.streamCount); ++i) {
                os << t.pStreamStrides[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeneratedCommandsInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::Key << "indirectCommandsLayout";
    // indirectCommandsLayout -> Field -> VkIndirectCommandsLayoutNV
    os << YAML::Value << t.indirectCommandsLayout;
    os << YAML::Key << "streamCount";
    // streamCount -> Field -> uint32_t
    os << YAML::Value << t.streamCount;
    os << YAML::Key << "pStreams";
    // pStreams -> Field -> ConstDynamicArray(VkIndirectCommandsStreamNV)
    if (t.streamCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkIndirectCommandsStreamNV");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.streamCount); ++i) {
                os << t.pStreams[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "sequencesCount";
    // sequencesCount -> Field -> uint32_t
    os << YAML::Value << t.sequencesCount;
    os << YAML::Key << "preprocessBuffer";
    // preprocessBuffer -> Field -> VkBuffer
    os << YAML::Value << t.preprocessBuffer;
    os << YAML::Key << "preprocessOffset";
    // preprocessOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.preprocessOffset;
    os << YAML::Key << "preprocessSize";
    // preprocessSize -> Field -> VkDeviceSize
    os << YAML::Value << t.preprocessSize;
    os << YAML::Key << "sequencesCountBuffer";
    // sequencesCountBuffer -> Field -> VkBuffer
    os << YAML::Value << t.sequencesCountBuffer;
    os << YAML::Key << "sequencesCountOffset";
    // sequencesCountOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.sequencesCountOffset;
    os << YAML::Key << "sequencesIndexBuffer";
    // sequencesIndexBuffer -> Field -> VkBuffer
    os << YAML::Value << t.sequencesIndexBuffer;
    os << YAML::Key << "sequencesIndexOffset";
    // sequencesIndexOffset -> Field -> VkDeviceSize
    os << YAML::Value << t.sequencesIndexOffset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGeneratedCommandsMemoryRequirementsInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pipelineBindPoint";
    // pipelineBindPoint -> Field -> VkPipelineBindPoint
    os << YAML::Value << t.pipelineBindPoint;
    os << YAML::Key << "pipeline";
    // pipeline -> Field -> VkPipeline
    os << YAML::Value << t.pipeline;
    os << YAML::Key << "indirectCommandsLayout";
    // indirectCommandsLayout -> Field -> VkIndirectCommandsLayoutNV
    os << YAML::Value << t.indirectCommandsLayout;
    os << YAML::Key << "maxSequencesCount";
    // maxSequencesCount -> Field -> uint32_t
    os << YAML::Value << t.maxSequencesCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceInheritedViewportScissorFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "inheritedViewportScissor2D";
    // inheritedViewportScissor2D -> Field -> VkBool32
    os << YAML::Value << t.inheritedViewportScissor2D;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceViewportScissorInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "viewportScissor2D";
    // viewportScissor2D -> Field -> VkBool32
    os << YAML::Value << t.viewportScissor2D;
    os << YAML::Key << "viewportDepthCount";
    // viewportDepthCount -> Field -> uint32_t
    os << YAML::Value << t.viewportDepthCount;
    os << YAML::Key << "pViewportDepths";
    // pointer
    if (t.pViewportDepths != nullptr) {
        os << YAML::Value << *t.pViewportDepths;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "texelBufferAlignment";
    // texelBufferAlignment -> Field -> VkBool32
    os << YAML::Value << t.texelBufferAlignment;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassTransformBeginInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "transform";
    // transform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.transform;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCommandBufferInheritanceRenderPassTransformInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "transform";
    // transform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.transform;
    os << YAML::Key << "renderArea";
    // renderArea -> Field -> VkRect2D
    os << YAML::Value << t.renderArea;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDepthBiasControlFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthBiasControl";
    // depthBiasControl -> Field -> VkBool32
    os << YAML::Value << t.depthBiasControl;
    os << YAML::Key << "leastRepresentableValueForceUnormRepresentation";
    // leastRepresentableValueForceUnormRepresentation -> Field -> VkBool32
    os << YAML::Value << t.leastRepresentableValueForceUnormRepresentation;
    os << YAML::Key << "floatRepresentation";
    // floatRepresentation -> Field -> VkBool32
    os << YAML::Value << t.floatRepresentation;
    os << YAML::Key << "depthBiasExact";
    // depthBiasExact -> Field -> VkBool32
    os << YAML::Value << t.depthBiasExact;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDepthBiasInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthBiasConstantFactor";
    // depthBiasConstantFactor -> Field -> float
    os << YAML::Value << t.depthBiasConstantFactor;
    os << YAML::Key << "depthBiasClamp";
    // depthBiasClamp -> Field -> float
    os << YAML::Value << t.depthBiasClamp;
    os << YAML::Key << "depthBiasSlopeFactor";
    // depthBiasSlopeFactor -> Field -> float
    os << YAML::Value << t.depthBiasSlopeFactor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDepthBiasRepresentationInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthBiasRepresentation";
    // depthBiasRepresentation -> Field -> VkDepthBiasRepresentationEXT
    os << YAML::Value << t.depthBiasRepresentation;
    os << YAML::Key << "depthBiasExact";
    // depthBiasExact -> Field -> VkBool32
    os << YAML::Value << t.depthBiasExact;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceMemoryReport";
    // deviceMemoryReport -> Field -> VkBool32
    os << YAML::Value << t.deviceMemoryReport;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceMemoryReportCallbackDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceMemoryReportFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "type";
    // type -> Field -> VkDeviceMemoryReportEventTypeEXT
    os << YAML::Value << t.type;
    os << YAML::Key << "memoryObjectId";
    // memoryObjectId -> Field -> uint64_t
    os << YAML::Value << t.memoryObjectId;
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "objectType";
    // objectType -> Field -> VkObjectType
    os << YAML::Value << t.objectType;
    os << YAML::Key << "objectHandle";
    // objectHandle -> Field -> uint64_t
    os << YAML::Value << t.objectHandle;
    os << YAML::Key << "heapIndex";
    // heapIndex -> Field -> uint32_t
    os << YAML::Value << t.heapIndex;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceDeviceMemoryReportCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceMemoryReportFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "pfnUserCallback";
    // pointer
    if (t.pfnUserCallback != nullptr) {
        os << YAML::Value << *t.pfnUserCallback;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pUserData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCustomBorderColorPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxCustomBorderColorSamplers";
    // maxCustomBorderColorSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxCustomBorderColorSamplers;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCustomBorderColorFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "customBorderColors";
    // customBorderColors -> Field -> VkBool32
    os << YAML::Value << t.customBorderColors;
    os << YAML::Key << "customBorderColorWithoutFormat";
    // customBorderColorWithoutFormat -> Field -> VkBool32
    os << YAML::Value << t.customBorderColorWithoutFormat;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTextureCompressionASTC3DFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "textureCompressionASTC_3D";
    // textureCompressionASTC_3D -> Field -> VkBool32
    os << YAML::Value << t.textureCompressionASTC_3D;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePresentBarrierFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentBarrier";
    // presentBarrier -> Field -> VkBool32
    os << YAML::Value << t.presentBarrier;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSurfaceCapabilitiesPresentBarrierNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentBarrierSupported";
    // presentBarrierSupported -> Field -> VkBool32
    os << YAML::Value << t.presentBarrierSupported;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSwapchainPresentBarrierCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "presentBarrierEnable";
    // presentBarrierEnable -> Field -> VkBool32
    os << YAML::Value << t.presentBarrierEnable;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDiagnosticsConfigFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "diagnosticsConfig";
    // diagnosticsConfig -> Field -> VkBool32
    os << YAML::Value << t.diagnosticsConfig;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceDiagnosticsConfigCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceDiagnosticsConfigFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkCudaModuleCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "dataSize";
    // dataSize -> Field -> size_t
    os << YAML::Value << t.dataSize;
    os << YAML::Key << "pData";
    if (t.dataSize == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pData;
            for (uint64_t i = 0; i < t.dataSize; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkCudaFunctionCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "module";
    // module -> Field -> VkCudaModuleNV
    os << YAML::Value << t.module;
    os << YAML::Key << "pName";
    // pName -> Field -> string
    os << YAML::Value << t.pName;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkCudaLaunchInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "function";
    // function -> Field -> VkCudaFunctionNV
    os << YAML::Value << t.function;
    os << YAML::Key << "gridDimX";
    // gridDimX -> Field -> uint32_t
    os << YAML::Value << t.gridDimX;
    os << YAML::Key << "gridDimY";
    // gridDimY -> Field -> uint32_t
    os << YAML::Value << t.gridDimY;
    os << YAML::Key << "gridDimZ";
    // gridDimZ -> Field -> uint32_t
    os << YAML::Value << t.gridDimZ;
    os << YAML::Key << "blockDimX";
    // blockDimX -> Field -> uint32_t
    os << YAML::Value << t.blockDimX;
    os << YAML::Key << "blockDimY";
    // blockDimY -> Field -> uint32_t
    os << YAML::Value << t.blockDimY;
    os << YAML::Key << "blockDimZ";
    // blockDimZ -> Field -> uint32_t
    os << YAML::Value << t.blockDimZ;
    os << YAML::Key << "sharedMemBytes";
    // sharedMemBytes -> Field -> uint32_t
    os << YAML::Value << t.sharedMemBytes;
    os << YAML::Key << "paramCount";
    // paramCount -> Field -> size_t
    os << YAML::Value << t.paramCount;
    os << YAML::Key << "pParams";
    if (t.paramCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pParams;
            for (uint64_t i = 0; i < t.paramCount; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::Key << "extraCount";
    // extraCount -> Field -> size_t
    os << YAML::Value << t.extraCount;
    os << YAML::Key << "pExtras";
    if (t.extraCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value << YAML::BeginSeq;
        {
            const uint8_t *p = (const uint8_t *)t.pExtras;
            for (uint64_t i = 0; i < t.extraCount; ++i) {
                os << crash_diagnostic_layer::Uint8ToStr(p[i]);
            }
        }
        os << YAML::EndSeq;
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCudaKernelLaunchFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "cudaKernelLaunchFeatures";
    // cudaKernelLaunchFeatures -> Field -> VkBool32
    os << YAML::Value << t.cudaKernelLaunchFeatures;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS
YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceCudaKernelLaunchPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "computeCapabilityMinor";
    // computeCapabilityMinor -> Field -> uint32_t
    os << YAML::Value << t.computeCapabilityMinor;
    os << YAML::Key << "computeCapabilityMajor";
    // computeCapabilityMajor -> Field -> uint32_t
    os << YAML::Value << t.computeCapabilityMajor;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_ENABLE_BETA_EXTENSIONS

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTileShadingFeaturesQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "tileShading";
    // tileShading -> Field -> VkBool32
    os << YAML::Value << t.tileShading;
    os << YAML::Key << "tileShadingFragmentStage";
    // tileShadingFragmentStage -> Field -> VkBool32
    os << YAML::Value << t.tileShadingFragmentStage;
    os << YAML::Key << "tileShadingColorAttachments";
    // tileShadingColorAttachments -> Field -> VkBool32
    os << YAML::Value << t.tileShadingColorAttachments;
    os << YAML::Key << "tileShadingDepthAttachments";
    // tileShadingDepthAttachments -> Field -> VkBool32
    os << YAML::Value << t.tileShadingDepthAttachments;
    os << YAML::Key << "tileShadingStencilAttachments";
    // tileShadingStencilAttachments -> Field -> VkBool32
    os << YAML::Value << t.tileShadingStencilAttachments;
    os << YAML::Key << "tileShadingInputAttachments";
    // tileShadingInputAttachments -> Field -> VkBool32
    os << YAML::Value << t.tileShadingInputAttachments;
    os << YAML::Key << "tileShadingSampledAttachments";
    // tileShadingSampledAttachments -> Field -> VkBool32
    os << YAML::Value << t.tileShadingSampledAttachments;
    os << YAML::Key << "tileShadingPerTileDraw";
    // tileShadingPerTileDraw -> Field -> VkBool32
    os << YAML::Value << t.tileShadingPerTileDraw;
    os << YAML::Key << "tileShadingPerTileDispatch";
    // tileShadingPerTileDispatch -> Field -> VkBool32
    os << YAML::Value << t.tileShadingPerTileDispatch;
    os << YAML::Key << "tileShadingDispatchTile";
    // tileShadingDispatchTile -> Field -> VkBool32
    os << YAML::Value << t.tileShadingDispatchTile;
    os << YAML::Key << "tileShadingApron";
    // tileShadingApron -> Field -> VkBool32
    os << YAML::Value << t.tileShadingApron;
    os << YAML::Key << "tileShadingAnisotropicApron";
    // tileShadingAnisotropicApron -> Field -> VkBool32
    os << YAML::Value << t.tileShadingAnisotropicApron;
    os << YAML::Key << "tileShadingAtomicOps";
    // tileShadingAtomicOps -> Field -> VkBool32
    os << YAML::Value << t.tileShadingAtomicOps;
    os << YAML::Key << "tileShadingImageProcessing";
    // tileShadingImageProcessing -> Field -> VkBool32
    os << YAML::Value << t.tileShadingImageProcessing;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceTileShadingPropertiesQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxApronSize";
    // maxApronSize -> Field -> uint32_t
    os << YAML::Value << t.maxApronSize;
    os << YAML::Key << "preferNonCoherent";
    // preferNonCoherent -> Field -> VkBool32
    os << YAML::Value << t.preferNonCoherent;
    os << YAML::Key << "tileGranularity";
    // tileGranularity -> Field -> VkExtent2D
    os << YAML::Value << t.tileGranularity;
    os << YAML::Key << "maxTileShadingRate";
    // maxTileShadingRate -> Field -> VkExtent2D
    os << YAML::Value << t.maxTileShadingRate;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkRenderPassTileShadingCreateInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkTileShadingRenderPassFlagsQCOM
    os << YAML::Value << t.flags;
    os << YAML::Key << "tileApronSize";
    // tileApronSize -> Field -> VkExtent2D
    os << YAML::Value << t.tileApronSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerTileBeginInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPerTileEndInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDispatchTileInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkQueryLowLatencySupportNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "pQueriedLowLatencyData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalObjectCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "exportObjectType";
    // exportObjectType -> Field -> VkExportMetalObjectTypeFlagBitsEXT
    os << YAML::Value << t.exportObjectType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalObjectsInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalDeviceInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mtlDevice";
    // mtlDevice -> Field -> MTLDevice_id
    os << YAML::Value << t.mtlDevice;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalCommandQueueInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "queue";
    // queue -> Field -> VkQueue
    os << YAML::Value << t.queue;
    os << YAML::Key << "mtlCommandQueue";
    // mtlCommandQueue -> Field -> MTLCommandQueue_id
    os << YAML::Value << t.mtlCommandQueue;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalBufferInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "mtlBuffer";
    // mtlBuffer -> Field -> MTLBuffer_id
    os << YAML::Value << t.mtlBuffer;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMetalBufferInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mtlBuffer";
    // mtlBuffer -> Field -> MTLBuffer_id
    os << YAML::Value << t.mtlBuffer;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalTextureInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::Key << "bufferView";
    // bufferView -> Field -> VkBufferView
    os << YAML::Value << t.bufferView;
    os << YAML::Key << "plane";
    // plane -> Field -> VkImageAspectFlagBits
    os << YAML::Value << t.plane;
    os << YAML::Key << "mtlTexture";
    // mtlTexture -> Field -> MTLTexture_id
    os << YAML::Value << t.mtlTexture;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMetalTextureInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "plane";
    // plane -> Field -> VkImageAspectFlagBits
    os << YAML::Value << t.plane;
    os << YAML::Key << "mtlTexture";
    // mtlTexture -> Field -> MTLTexture_id
    os << YAML::Value << t.mtlTexture;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalIOSurfaceInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::Key << "ioSurface";
    // ioSurface -> Field -> IOSurfaceRef
    os << YAML::Value << t.ioSurface;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMetalIOSurfaceInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "ioSurface";
    // ioSurface -> Field -> IOSurfaceRef
    os << YAML::Value << t.ioSurface;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkExportMetalSharedEventInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "event";
    // event -> Field -> VkEvent
    os << YAML::Value << t.event;
    os << YAML::Key << "mtlSharedEvent";
    // mtlSharedEvent -> Field -> MTLSharedEvent_id
    os << YAML::Value << t.mtlSharedEvent;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

#ifdef VK_USE_PLATFORM_METAL_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMetalSharedEventInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mtlSharedEvent";
    // mtlSharedEvent -> Field -> MTLSharedEvent_id
    os << YAML::Value << t.mtlSharedEvent;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_METAL_EXT

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorBufferPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "combinedImageSamplerDescriptorSingleArray";
    // combinedImageSamplerDescriptorSingleArray -> Field -> VkBool32
    os << YAML::Value << t.combinedImageSamplerDescriptorSingleArray;
    os << YAML::Key << "bufferlessPushDescriptors";
    // bufferlessPushDescriptors -> Field -> VkBool32
    os << YAML::Value << t.bufferlessPushDescriptors;
    os << YAML::Key << "allowSamplerImageViewPostSubmitCreation";
    // allowSamplerImageViewPostSubmitCreation -> Field -> VkBool32
    os << YAML::Value << t.allowSamplerImageViewPostSubmitCreation;
    os << YAML::Key << "descriptorBufferOffsetAlignment";
    // descriptorBufferOffsetAlignment -> Field -> VkDeviceSize
    os << YAML::Value << t.descriptorBufferOffsetAlignment;
    os << YAML::Key << "maxDescriptorBufferBindings";
    // maxDescriptorBufferBindings -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorBufferBindings;
    os << YAML::Key << "maxResourceDescriptorBufferBindings";
    // maxResourceDescriptorBufferBindings -> Field -> uint32_t
    os << YAML::Value << t.maxResourceDescriptorBufferBindings;
    os << YAML::Key << "maxSamplerDescriptorBufferBindings";
    // maxSamplerDescriptorBufferBindings -> Field -> uint32_t
    os << YAML::Value << t.maxSamplerDescriptorBufferBindings;
    os << YAML::Key << "maxEmbeddedImmutableSamplerBindings";
    // maxEmbeddedImmutableSamplerBindings -> Field -> uint32_t
    os << YAML::Value << t.maxEmbeddedImmutableSamplerBindings;
    os << YAML::Key << "maxEmbeddedImmutableSamplers";
    // maxEmbeddedImmutableSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxEmbeddedImmutableSamplers;
    os << YAML::Key << "bufferCaptureReplayDescriptorDataSize";
    // bufferCaptureReplayDescriptorDataSize -> Field -> size_t
    os << YAML::Value << t.bufferCaptureReplayDescriptorDataSize;
    os << YAML::Key << "imageCaptureReplayDescriptorDataSize";
    // imageCaptureReplayDescriptorDataSize -> Field -> size_t
    os << YAML::Value << t.imageCaptureReplayDescriptorDataSize;
    os << YAML::Key << "imageViewCaptureReplayDescriptorDataSize";
    // imageViewCaptureReplayDescriptorDataSize -> Field -> size_t
    os << YAML::Value << t.imageViewCaptureReplayDescriptorDataSize;
    os << YAML::Key << "samplerCaptureReplayDescriptorDataSize";
    // samplerCaptureReplayDescriptorDataSize -> Field -> size_t
    os << YAML::Value << t.samplerCaptureReplayDescriptorDataSize;
    os << YAML::Key << "accelerationStructureCaptureReplayDescriptorDataSize";
    // accelerationStructureCaptureReplayDescriptorDataSize -> Field -> size_t
    os << YAML::Value << t.accelerationStructureCaptureReplayDescriptorDataSize;
    os << YAML::Key << "samplerDescriptorSize";
    // samplerDescriptorSize -> Field -> size_t
    os << YAML::Value << t.samplerDescriptorSize;
    os << YAML::Key << "combinedImageSamplerDescriptorSize";
    // combinedImageSamplerDescriptorSize -> Field -> size_t
    os << YAML::Value << t.combinedImageSamplerDescriptorSize;
    os << YAML::Key << "sampledImageDescriptorSize";
    // sampledImageDescriptorSize -> Field -> size_t
    os << YAML::Value << t.sampledImageDescriptorSize;
    os << YAML::Key << "storageImageDescriptorSize";
    // storageImageDescriptorSize -> Field -> size_t
    os << YAML::Value << t.storageImageDescriptorSize;
    os << YAML::Key << "uniformTexelBufferDescriptorSize";
    // uniformTexelBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.uniformTexelBufferDescriptorSize;
    os << YAML::Key << "robustUniformTexelBufferDescriptorSize";
    // robustUniformTexelBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.robustUniformTexelBufferDescriptorSize;
    os << YAML::Key << "storageTexelBufferDescriptorSize";
    // storageTexelBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.storageTexelBufferDescriptorSize;
    os << YAML::Key << "robustStorageTexelBufferDescriptorSize";
    // robustStorageTexelBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.robustStorageTexelBufferDescriptorSize;
    os << YAML::Key << "uniformBufferDescriptorSize";
    // uniformBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.uniformBufferDescriptorSize;
    os << YAML::Key << "robustUniformBufferDescriptorSize";
    // robustUniformBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.robustUniformBufferDescriptorSize;
    os << YAML::Key << "storageBufferDescriptorSize";
    // storageBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.storageBufferDescriptorSize;
    os << YAML::Key << "robustStorageBufferDescriptorSize";
    // robustStorageBufferDescriptorSize -> Field -> size_t
    os << YAML::Value << t.robustStorageBufferDescriptorSize;
    os << YAML::Key << "inputAttachmentDescriptorSize";
    // inputAttachmentDescriptorSize -> Field -> size_t
    os << YAML::Value << t.inputAttachmentDescriptorSize;
    os << YAML::Key << "accelerationStructureDescriptorSize";
    // accelerationStructureDescriptorSize -> Field -> size_t
    os << YAML::Value << t.accelerationStructureDescriptorSize;
    os << YAML::Key << "maxSamplerDescriptorBufferRange";
    // maxSamplerDescriptorBufferRange -> Field -> VkDeviceSize
    os << YAML::Value << t.maxSamplerDescriptorBufferRange;
    os << YAML::Key << "maxResourceDescriptorBufferRange";
    // maxResourceDescriptorBufferRange -> Field -> VkDeviceSize
    os << YAML::Value << t.maxResourceDescriptorBufferRange;
    os << YAML::Key << "samplerDescriptorBufferAddressSpaceSize";
    // samplerDescriptorBufferAddressSpaceSize -> Field -> VkDeviceSize
    os << YAML::Value << t.samplerDescriptorBufferAddressSpaceSize;
    os << YAML::Key << "resourceDescriptorBufferAddressSpaceSize";
    // resourceDescriptorBufferAddressSpaceSize -> Field -> VkDeviceSize
    os << YAML::Value << t.resourceDescriptorBufferAddressSpaceSize;
    os << YAML::Key << "descriptorBufferAddressSpaceSize";
    // descriptorBufferAddressSpaceSize -> Field -> VkDeviceSize
    os << YAML::Value << t.descriptorBufferAddressSpaceSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "combinedImageSamplerDensityMapDescriptorSize";
    // combinedImageSamplerDensityMapDescriptorSize -> Field -> size_t
    os << YAML::Value << t.combinedImageSamplerDensityMapDescriptorSize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDescriptorBufferFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "descriptorBuffer";
    // descriptorBuffer -> Field -> VkBool32
    os << YAML::Value << t.descriptorBuffer;
    os << YAML::Key << "descriptorBufferCaptureReplay";
    // descriptorBufferCaptureReplay -> Field -> VkBool32
    os << YAML::Value << t.descriptorBufferCaptureReplay;
    os << YAML::Key << "descriptorBufferImageLayoutIgnored";
    // descriptorBufferImageLayoutIgnored -> Field -> VkBool32
    os << YAML::Value << t.descriptorBufferImageLayoutIgnored;
    os << YAML::Key << "descriptorBufferPushDescriptors";
    // descriptorBufferPushDescriptors -> Field -> VkBool32
    os << YAML::Value << t.descriptorBufferPushDescriptors;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorAddressInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "address";
    // address -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.address);
    os << YAML::Key << "range";
    // range -> Field -> VkDeviceSize
    os << YAML::Value << t.range;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorBufferBindingInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "address";
    // address -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.address);
    os << YAML::Key << "usage";
    // usage -> Field -> VkBufferUsageFlags
    os << YAML::Value << t.usage;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorBufferBindingPushDescriptorBufferHandleEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "pSampler";
    // pointer
    if (t.pSampler != nullptr) {
        os << YAML::Value << *t.pSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pCombinedImageSampler";
    // pointer
    if (t.pCombinedImageSampler != nullptr) {
        os << YAML::Value << *t.pCombinedImageSampler;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pInputAttachmentImage";
    // pointer
    if (t.pInputAttachmentImage != nullptr) {
        os << YAML::Value << *t.pInputAttachmentImage;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pSampledImage";
    // pointer
    if (t.pSampledImage != nullptr) {
        os << YAML::Value << *t.pSampledImage;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pStorageImage";
    // pointer
    if (t.pStorageImage != nullptr) {
        os << YAML::Value << *t.pStorageImage;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pUniformTexelBuffer";
    // pointer
    if (t.pUniformTexelBuffer != nullptr) {
        os << YAML::Value << *t.pUniformTexelBuffer;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pStorageTexelBuffer";
    // pointer
    if (t.pStorageTexelBuffer != nullptr) {
        os << YAML::Value << *t.pStorageTexelBuffer;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pUniformBuffer";
    // pointer
    if (t.pUniformBuffer != nullptr) {
        os << YAML::Value << *t.pUniformBuffer;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pStorageBuffer";
    // pointer
    if (t.pStorageBuffer != nullptr) {
        os << YAML::Value << *t.pStorageBuffer;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "accelerationStructure";
    // accelerationStructure -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.accelerationStructure);
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDescriptorGetInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "type";
    // type -> Field -> VkDescriptorType
    os << YAML::Value << t.type;
    os << YAML::Key << "data";
    // data -> Field -> VkDescriptorDataEXT
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCaptureDescriptorDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "buffer";
    // buffer -> Field -> VkBuffer
    os << YAML::Value << t.buffer;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCaptureDescriptorDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "image";
    // image -> Field -> VkImage
    os << YAML::Value << t.image;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageViewCaptureDescriptorDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageView";
    // imageView -> Field -> VkImageView
    os << YAML::Value << t.imageView;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSamplerCaptureDescriptorDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "sampler";
    // sampler -> Field -> VkSampler
    os << YAML::Value << t.sampler;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkOpaqueCaptureDescriptorDataCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "opaqueCaptureDescriptorData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureCaptureDescriptorDataInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "accelerationStructure";
    // accelerationStructure -> Field -> VkAccelerationStructureKHR
    os << YAML::Value << t.accelerationStructure;
    os << YAML::Key << "accelerationStructureNV";
    // accelerationStructureNV -> Field -> VkAccelerationStructureNV
    os << YAML::Value << t.accelerationStructureNV;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "graphicsPipelineLibrary";
    // graphicsPipelineLibrary -> Field -> VkBool32
    os << YAML::Value << t.graphicsPipelineLibrary;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "graphicsPipelineLibraryFastLinking";
    // graphicsPipelineLibraryFastLinking -> Field -> VkBool32
    os << YAML::Value << t.graphicsPipelineLibraryFastLinking;
    os << YAML::Key << "graphicsPipelineLibraryIndependentInterpolationDecoration";
    // graphicsPipelineLibraryIndependentInterpolationDecoration -> Field -> VkBool32
    os << YAML::Value << t.graphicsPipelineLibraryIndependentInterpolationDecoration;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkGraphicsPipelineLibraryCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkGraphicsPipelineLibraryFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shaderEarlyAndLateFragmentTests";
    // shaderEarlyAndLateFragmentTests -> Field -> VkBool32
    os << YAML::Value << t.shaderEarlyAndLateFragmentTests;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentShadingRateEnums";
    // fragmentShadingRateEnums -> Field -> VkBool32
    os << YAML::Value << t.fragmentShadingRateEnums;
    os << YAML::Key << "supersampleFragmentShadingRates";
    // supersampleFragmentShadingRates -> Field -> VkBool32
    os << YAML::Value << t.supersampleFragmentShadingRates;
    os << YAML::Key << "noInvocationFragmentShadingRates";
    // noInvocationFragmentShadingRates -> Field -> VkBool32
    os << YAML::Value << t.noInvocationFragmentShadingRates;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxFragmentShadingRateInvocationCount";
    // maxFragmentShadingRateInvocationCount -> Field -> VkSampleCountFlagBits
    os << YAML::Value << t.maxFragmentShadingRateInvocationCount;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineFragmentShadingRateEnumStateCreateInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "shadingRateType";
    // shadingRateType -> Field -> VkFragmentShadingRateTypeNV
    os << YAML::Value << t.shadingRateType;
    os << YAML::Key << "shadingRate";
    // shadingRate -> Field -> VkFragmentShadingRateNV
    os << YAML::Value << t.shadingRate;
    os << YAML::Key << "combinerOps";
    // combinerOps -> Field -> FixedArray(VkFragmentShadingRateCombinerOpKHR)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("VkFragmentShadingRateCombinerOpKHR");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(2); ++i) {
                os << t.combinerOps[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceOrHostAddressConstKHR &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "deviceAddress";
    // deviceAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.deviceAddress);
    os << YAML::Key << "hostAddress";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureGeometryMotionTrianglesDataNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vertexData";
    // vertexData -> Field -> VkDeviceOrHostAddressConstKHR
    os << YAML::Value << t.vertexData;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureMotionInfoNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "maxInstances";
    // maxInstances -> Field -> uint32_t
    os << YAML::Value << t.maxInstances;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAccelerationStructureMotionInfoFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureMatrixMotionInstanceNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "transformT0";
    // transformT0 -> Field -> VkTransformMatrixKHR
    os << YAML::Value << t.transformT0;
    os << YAML::Key << "transformT1";
    // transformT1 -> Field -> VkTransformMatrixKHR
    os << YAML::Value << t.transformT1;
    os << YAML::Key << "instanceCustomIndex";
    // instanceCustomIndex -> Field -> uint32_t
    os << YAML::Value << t.instanceCustomIndex;
    os << YAML::Key << "mask";
    // mask -> Field -> uint32_t
    os << YAML::Value << t.mask;
    os << YAML::Key << "instanceShaderBindingTableRecordOffset";
    // instanceShaderBindingTableRecordOffset -> Field -> uint32_t
    os << YAML::Value << t.instanceShaderBindingTableRecordOffset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkGeometryInstanceFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "accelerationStructureReference";
    // accelerationStructureReference -> Field -> uint64_t
    os << YAML::Value << t.accelerationStructureReference;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkSRTDataNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sx";
    // sx -> Field -> float
    os << YAML::Value << t.sx;
    os << YAML::Key << "a";
    // a -> Field -> float
    os << YAML::Value << t.a;
    os << YAML::Key << "b";
    // b -> Field -> float
    os << YAML::Value << t.b;
    os << YAML::Key << "pvx";
    // pvx -> Field -> float
    os << YAML::Value << t.pvx;
    os << YAML::Key << "sy";
    // sy -> Field -> float
    os << YAML::Value << t.sy;
    os << YAML::Key << "c";
    // c -> Field -> float
    os << YAML::Value << t.c;
    os << YAML::Key << "pvy";
    // pvy -> Field -> float
    os << YAML::Value << t.pvy;
    os << YAML::Key << "sz";
    // sz -> Field -> float
    os << YAML::Value << t.sz;
    os << YAML::Key << "pvz";
    // pvz -> Field -> float
    os << YAML::Value << t.pvz;
    os << YAML::Key << "qx";
    // qx -> Field -> float
    os << YAML::Value << t.qx;
    os << YAML::Key << "qy";
    // qy -> Field -> float
    os << YAML::Value << t.qy;
    os << YAML::Key << "qz";
    // qz -> Field -> float
    os << YAML::Value << t.qz;
    os << YAML::Key << "qw";
    // qw -> Field -> float
    os << YAML::Value << t.qw;
    os << YAML::Key << "tx";
    // tx -> Field -> float
    os << YAML::Value << t.tx;
    os << YAML::Key << "ty";
    // ty -> Field -> float
    os << YAML::Value << t.ty;
    os << YAML::Key << "tz";
    // tz -> Field -> float
    os << YAML::Value << t.tz;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureSRTMotionInstanceNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "transformT0";
    // transformT0 -> Field -> VkSRTDataNV
    os << YAML::Value << t.transformT0;
    os << YAML::Key << "transformT1";
    // transformT1 -> Field -> VkSRTDataNV
    os << YAML::Value << t.transformT1;
    os << YAML::Key << "instanceCustomIndex";
    // instanceCustomIndex -> Field -> uint32_t
    os << YAML::Value << t.instanceCustomIndex;
    os << YAML::Key << "mask";
    // mask -> Field -> uint32_t
    os << YAML::Value << t.mask;
    os << YAML::Key << "instanceShaderBindingTableRecordOffset";
    // instanceShaderBindingTableRecordOffset -> Field -> uint32_t
    os << YAML::Value << t.instanceShaderBindingTableRecordOffset;
    os << YAML::Key << "flags";
    // flags -> Field -> VkGeometryInstanceFlagsKHR
    os << YAML::Value << t.flags;
    os << YAML::Key << "accelerationStructureReference";
    // accelerationStructureReference -> Field -> uint64_t
    os << YAML::Value << t.accelerationStructureReference;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureMotionInstanceDataNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "staticInstance";
    // staticInstance -> Field -> VkAccelerationStructureInstanceKHR
    os << YAML::Value << t.staticInstance;
    os << YAML::Key << "matrixMotionInstance";
    // matrixMotionInstance -> Field -> VkAccelerationStructureMatrixMotionInstanceNV
    os << YAML::Value << t.matrixMotionInstance;
    os << YAML::Key << "srtMotionInstance";
    // srtMotionInstance -> Field -> VkAccelerationStructureSRTMotionInstanceNV
    os << YAML::Value << t.srtMotionInstance;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkAccelerationStructureMotionInstanceNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "type";
    // type -> Field -> VkAccelerationStructureMotionInstanceTypeNV
    os << YAML::Value << t.type;
    os << YAML::Key << "flags";
    // flags -> Field -> VkAccelerationStructureMotionInstanceFlagsNV
    os << YAML::Value << t.flags;
    os << YAML::Key << "data";
    // data -> Field -> VkAccelerationStructureMotionInstanceDataNV
    os << YAML::Value << t.data;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRayTracingMotionBlurFeaturesNV &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rayTracingMotionBlur";
    // rayTracingMotionBlur -> Field -> VkBool32
    os << YAML::Value << t.rayTracingMotionBlur;
    os << YAML::Key << "rayTracingMotionBlurPipelineTraceRaysIndirect";
    // rayTracingMotionBlurPipelineTraceRaysIndirect -> Field -> VkBool32
    os << YAML::Value << t.rayTracingMotionBlurPipelineTraceRaysIndirect;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "ycbcr2plane444Formats";
    // ycbcr2plane444Formats -> Field -> VkBool32
    os << YAML::Value << t.ycbcr2plane444Formats;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentDensityMap2FeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "fragmentDensityMapDeferred";
    // fragmentDensityMapDeferred -> Field -> VkBool32
    os << YAML::Value << t.fragmentDensityMapDeferred;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFragmentDensityMap2PropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "subsampledLoads";
    // subsampledLoads -> Field -> VkBool32
    os << YAML::Value << t.subsampledLoads;
    os << YAML::Key << "subsampledCoarseReconstructionEarlyAccess";
    // subsampledCoarseReconstructionEarlyAccess -> Field -> VkBool32
    os << YAML::Value << t.subsampledCoarseReconstructionEarlyAccess;
    os << YAML::Key << "maxSubsampledArrayLayers";
    // maxSubsampledArrayLayers -> Field -> uint32_t
    os << YAML::Value << t.maxSubsampledArrayLayers;
    os << YAML::Key << "maxDescriptorSetSubsampledSamplers";
    // maxDescriptorSetSubsampledSamplers -> Field -> uint32_t
    os << YAML::Value << t.maxDescriptorSetSubsampledSamplers;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkCopyCommandTransformInfoQCOM &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "transform";
    // transform -> Field -> VkSurfaceTransformFlagBitsKHR
    os << YAML::Value << t.transform;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceImageCompressionControlFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageCompressionControl";
    // imageCompressionControl -> Field -> VkBool32
    os << YAML::Value << t.imageCompressionControl;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCompressionControlEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkImageCompressionFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "compressionControlPlaneCount";
    // compressionControlPlaneCount -> Field -> uint32_t
    os << YAML::Value << t.compressionControlPlaneCount;
    os << YAML::Key << "pFixedRateFlags";
    // pFixedRateFlags -> Field -> DynamicArray(VkImageCompressionFixedRateFlagsEXT)
    if (t.compressionControlPlaneCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkImageCompressionFixedRateFlagsEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.compressionControlPlaneCount); ++i) {
                os << t.pFixedRateFlags[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkImageCompressionPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "imageCompressionFlags";
    // imageCompressionFlags -> Field -> VkImageCompressionFlagsEXT
    os << YAML::Value << t.imageCompressionFlags;
    os << YAML::Key << "imageCompressionFixedRateFlags";
    // imageCompressionFixedRateFlags -> Field -> VkImageCompressionFixedRateFlagsEXT
    os << YAML::Value << t.imageCompressionFixedRateFlags;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "attachmentFeedbackLoopLayout";
    // attachmentFeedbackLoopLayout -> Field -> VkBool32
    os << YAML::Value << t.attachmentFeedbackLoopLayout;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevice4444FormatsFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "formatA4R4G4B4";
    // formatA4R4G4B4 -> Field -> VkBool32
    os << YAML::Value << t.formatA4R4G4B4;
    os << YAML::Key << "formatA4B4G4R4";
    // formatA4B4G4R4 -> Field -> VkBool32
    os << YAML::Value << t.formatA4B4G4R4;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceFaultFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "deviceFault";
    // deviceFault -> Field -> VkBool32
    os << YAML::Value << t.deviceFault;
    os << YAML::Key << "deviceFaultVendorBinary";
    // deviceFaultVendorBinary -> Field -> VkBool32
    os << YAML::Value << t.deviceFaultVendorBinary;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceFaultCountsEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "addressInfoCount";
    // addressInfoCount -> Field -> uint32_t
    os << YAML::Value << t.addressInfoCount;
    os << YAML::Key << "vendorInfoCount";
    // vendorInfoCount -> Field -> uint32_t
    os << YAML::Value << t.vendorInfoCount;
    os << YAML::Key << "vendorBinarySize";
    // vendorBinarySize -> Field -> VkDeviceSize
    os << YAML::Value << t.vendorBinarySize;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceFaultAddressInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "addressType";
    // addressType -> Field -> VkDeviceFaultAddressTypeEXT
    os << YAML::Value << t.addressType;
    os << YAML::Key << "reportedAddress";
    // reportedAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.reportedAddress);
    os << YAML::Key << "addressPrecision";
    // addressPrecision -> Field -> VkDeviceSize
    os << YAML::Value << t.addressPrecision;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceFaultVendorInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "vendorFaultCode";
    // vendorFaultCode -> Field -> uint64_t
    os << YAML::Value << t.vendorFaultCode;
    os << YAML::Key << "vendorFaultData";
    // vendorFaultData -> Field -> uint64_t
    os << YAML::Value << t.vendorFaultData;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceFaultInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "description";
    // description -> Field -> FixedArray(char)
    os << YAML::Value << t.description;
    os << YAML::Key << "pAddressInfos";
    // pointer
    if (t.pAddressInfos != nullptr) {
        os << YAML::Value << *t.pAddressInfos;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pVendorInfos";
    // pointer
    if (t.pVendorInfos != nullptr) {
        os << YAML::Value << *t.pVendorInfos;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "pVendorBinaryData";
    // void
    os << YAML::Value << "NOT_AVAILABLE";
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceFaultVendorBinaryHeaderVersionOneEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "headerSize";
    // headerSize -> Field -> uint32_t
    os << YAML::Value << t.headerSize;
    os << YAML::Key << "headerVersion";
    // headerVersion -> Field -> VkDeviceFaultVendorBinaryHeaderVersionEXT
    os << YAML::Value << t.headerVersion;
    os << YAML::Key << "vendorID";
    // vendorID -> Field -> uint32_t
    os << YAML::Value << t.vendorID;
    os << YAML::Key << "deviceID";
    // deviceID -> Field -> uint32_t
    os << YAML::Value << t.deviceID;
    os << YAML::Key << "driverVersion";
    // driverVersion -> Field -> uint32_t
    os << YAML::Value << t.driverVersion;
    os << YAML::Key << "pipelineCacheUUID";
    // pipelineCacheUUID -> Field -> FixedArray(uint8_t)
    {
        os << YAML::Value;
        {
            os << YAML::Comment("uint8_t");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(VK_UUID_SIZE); ++i) {
                os << t.pipelineCacheUUID[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::Key << "applicationNameOffset";
    // applicationNameOffset -> Field -> uint32_t
    os << YAML::Value << t.applicationNameOffset;
    os << YAML::Key << "applicationVersion";
    // applicationVersion -> Field -> uint32_t
    os << YAML::Value << t.applicationVersion;
    os << YAML::Key << "engineNameOffset";
    // engineNameOffset -> Field -> uint32_t
    os << YAML::Value << t.engineNameOffset;
    os << YAML::Key << "engineVersion";
    // engineVersion -> Field -> uint32_t
    os << YAML::Value << t.engineVersion;
    os << YAML::Key << "apiVersion";
    // apiVersion -> Field -> uint32_t
    os << YAML::Value << t.apiVersion;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "rasterizationOrderColorAttachmentAccess";
    // rasterizationOrderColorAttachmentAccess -> Field -> VkBool32
    os << YAML::Value << t.rasterizationOrderColorAttachmentAccess;
    os << YAML::Key << "rasterizationOrderDepthAttachmentAccess";
    // rasterizationOrderDepthAttachmentAccess -> Field -> VkBool32
    os << YAML::Value << t.rasterizationOrderDepthAttachmentAccess;
    os << YAML::Key << "rasterizationOrderStencilAttachmentAccess";
    // rasterizationOrderStencilAttachmentAccess -> Field -> VkBool32
    os << YAML::Value << t.rasterizationOrderStencilAttachmentAccess;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "formatRgba10x6WithoutYCbCrSampler";
    // formatRgba10x6WithoutYCbCrSampler -> Field -> VkBool32
    os << YAML::Value << t.formatRgba10x6WithoutYCbCrSampler;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
YAML::Emitter &operator<<(YAML::Emitter &os, const VkDirectFBSurfaceCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDirectFBSurfaceCreateFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "dfb";
    // pointer
    if (t.dfb != nullptr) {
        os << YAML::Value << *t.dfb;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::Key << "surface";
    // pointer
    if (t.surface != nullptr) {
        os << YAML::Value << *t.surface;
    } else {
        os << YAML::Value << "nullptr";
    }
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_DIRECTFB_EXT

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mutableDescriptorType";
    // mutableDescriptorType -> Field -> VkBool32
    os << YAML::Value << t.mutableDescriptorType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMutableDescriptorTypeListEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "descriptorTypeCount";
    // descriptorTypeCount -> Field -> uint32_t
    os << YAML::Value << t.descriptorTypeCount;
    os << YAML::Key << "pDescriptorTypes";
    // pDescriptorTypes -> Field -> ConstDynamicArray(VkDescriptorType)
    if (t.descriptorTypeCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkDescriptorType");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.descriptorTypeCount); ++i) {
                os << t.pDescriptorTypes[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkMutableDescriptorTypeCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "mutableDescriptorTypeListCount";
    // mutableDescriptorTypeListCount -> Field -> uint32_t
    os << YAML::Value << t.mutableDescriptorTypeListCount;
    os << YAML::Key << "pMutableDescriptorTypeLists";
    // pMutableDescriptorTypeLists -> Field -> ConstDynamicArray(VkMutableDescriptorTypeListEXT)
    if (t.mutableDescriptorTypeListCount == 0) {
        os << YAML::Value << "nullptr";
    } else {
        os << YAML::Value;
        {
            os << YAML::Comment("VkMutableDescriptorTypeListEXT");
            os << YAML::BeginSeq;
            for (uint64_t i = 0; i < uint64_t(t.mutableDescriptorTypeListCount); ++i) {
                os << t.pMutableDescriptorTypeLists[i];
            }  // for i
            os << YAML::EndSeq;
        }
    }
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "vertexInputDynamicState";
    // vertexInputDynamicState -> Field -> VkBool32
    os << YAML::Value << t.vertexInputDynamicState;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVertexInputBindingDescription2EXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "stride";
    // stride -> Field -> uint32_t
    os << YAML::Value << t.stride;
    os << YAML::Key << "inputRate";
    // inputRate -> Field -> VkVertexInputRate
    os << YAML::Value << t.inputRate;
    os << YAML::Key << "divisor";
    // divisor -> Field -> uint32_t
    os << YAML::Value << t.divisor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkVertexInputAttributeDescription2EXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "location";
    // location -> Field -> uint32_t
    os << YAML::Value << t.location;
    os << YAML::Key << "binding";
    // binding -> Field -> uint32_t
    os << YAML::Value << t.binding;
    os << YAML::Key << "format";
    // format -> Field -> VkFormat
    os << YAML::Value << t.format;
    os << YAML::Key << "offset";
    // offset -> Field -> uint32_t
    os << YAML::Value << t.offset;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDrmPropertiesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "hasPrimary";
    // hasPrimary -> Field -> VkBool32
    os << YAML::Value << t.hasPrimary;
    os << YAML::Key << "hasRender";
    // hasRender -> Field -> VkBool32
    os << YAML::Value << t.hasRender;
    os << YAML::Key << "primaryMajor";
    // primaryMajor -> Field -> int64_t
    os << YAML::Value << t.primaryMajor;
    os << YAML::Key << "primaryMinor";
    // primaryMinor -> Field -> int64_t
    os << YAML::Value << t.primaryMinor;
    os << YAML::Key << "renderMajor";
    // renderMajor -> Field -> int64_t
    os << YAML::Value << t.renderMajor;
    os << YAML::Key << "renderMinor";
    // renderMinor -> Field -> int64_t
    os << YAML::Value << t.renderMinor;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceAddressBindingReportFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "reportAddressBinding";
    // reportAddressBinding -> Field -> VkBool32
    os << YAML::Value << t.reportAddressBinding;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkDeviceAddressBindingCallbackDataEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "flags";
    // flags -> Field -> VkDeviceAddressBindingFlagsEXT
    os << YAML::Value << t.flags;
    os << YAML::Key << "baseAddress";
    // baseAddress -> Field -> VkDeviceAddress
    os << YAML::Value << crash_diagnostic_layer::Uint64ToStr(t.baseAddress);
    os << YAML::Key << "size";
    // size -> Field -> VkDeviceSize
    os << YAML::Value << t.size;
    os << YAML::Key << "bindingType";
    // bindingType -> Field -> VkDeviceAddressBindingTypeEXT
    os << YAML::Value << t.bindingType;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDeviceDepthClipControlFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "depthClipControl";
    // depthClipControl -> Field -> VkBool32
    os << YAML::Value << t.depthClipControl;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPipelineViewportDepthClipControlCreateInfoEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "negativeOneToOne";
    // negativeOneToOne -> Field -> VkBool32
    os << YAML::Value << t.negativeOneToOne;
    os << YAML::EndMap;
    return os;
}

YAML::Emitter &operator<<(YAML::Emitter &os, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "primitiveTopologyListRestart";
    // primitiveTopologyListRestart -> Field -> VkBool32
    os << YAML::Value << t.primitiveTopologyListRestart;
    os << YAML::Key << "primitiveTopologyPatchListRestart";
    // primitiveTopologyPatchListRestart -> Field -> VkBool32
    os << YAML::Value << t.primitiveTopologyPatchListRestart;
    os << YAML::EndMap;
    return os;
}

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryZirconHandleInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "handle";
    // handle -> Field -> zx_handle_t
    os << YAML::Value << t.handle;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryZirconHandlePropertiesFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkMemoryGetZirconHandleInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memory";
    // memory -> Field -> VkDeviceMemory
    os << YAML::Value << t.memory;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalMemoryHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportSemaphoreZirconHandleInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "flags";
    // flags -> Field -> VkSemaphoreImportFlags
    os << YAML::Value << t.flags;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::Key << "zirconHandle";
    // zirconHandle -> Field -> zx_handle_t
    os << YAML::Value << t.zirconHandle;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSemaphoreGetZirconHandleInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "semaphore";
    // semaphore -> Field -> VkSemaphore
    os << YAML::Value << t.semaphore;
    os << YAML::Key << "handleType";
    // handleType -> Field -> VkExternalSemaphoreHandleTypeFlagBits
    os << YAML::Value << t.handleType;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCollectionCreateInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "collectionToken";
    // collectionToken -> Field -> zx_handle_t
    os << YAML::Value << t.collectionToken;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkImportMemoryBufferCollectionFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "collection";
    // collection -> Field -> VkBufferCollectionFUCHSIA
    os << YAML::Value << t.collection;
    os << YAML::Key << "index";
    // index -> Field -> uint32_t
    os << YAML::Value << t.index;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCollectionImageCreateInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "collection";
    // collection -> Field -> VkBufferCollectionFUCHSIA
    os << YAML::Value << t.collection;
    os << YAML::Key << "index";
    // index -> Field -> uint32_t
    os << YAML::Value << t.index;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCollectionConstraintsInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "minBufferCount";
    // minBufferCount -> Field -> uint32_t
    os << YAML::Value << t.minBufferCount;
    os << YAML::Key << "maxBufferCount";
    // maxBufferCount -> Field -> uint32_t
    os << YAML::Value << t.maxBufferCount;
    os << YAML::Key << "minBufferCountForCamping";
    // minBufferCountForCamping -> Field -> uint32_t
    os << YAML::Value << t.minBufferCountForCamping;
    os << YAML::Key << "minBufferCountForDedicatedSlack";
    // minBufferCountForDedicatedSlack -> Field -> uint32_t
    os << YAML::Value << t.minBufferCountForDedicatedSlack;
    os << YAML::Key << "minBufferCountForSharedSlack";
    // minBufferCountForSharedSlack -> Field -> uint32_t
    os << YAML::Value << t.minBufferCountForSharedSlack;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferConstraintsInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "createInfo";
    // createInfo -> Field -> VkBufferCreateInfo
    os << YAML::Value << t.createInfo;
    os << YAML::Key << "requiredFormatFeatures";
    // requiredFormatFeatures -> Field -> VkFormatFeatureFlags
    os << YAML::Value << t.requiredFormatFeatures;
    os << YAML::Key << "bufferCollectionConstraints";
    // bufferCollectionConstraints -> Field -> VkBufferCollectionConstraintsInfoFUCHSIA
    os << YAML::Value << t.bufferCollectionConstraints;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCollectionBufferCreateInfoFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "collection";
    // collection -> Field -> VkBufferCollectionFUCHSIA
    os << YAML::Value << t.collection;
    os << YAML::Key << "index";
    // index -> Field -> uint32_t
    os << YAML::Value << t.index;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkSysmemColorSpaceFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "colorSpace";
    // colorSpace -> Field -> uint32_t
    os << YAML::Value << t.colorSpace;
    os << YAML::EndMap;
    return os;
}
#endif  // VK_USE_PLATFORM_FUCHSIA

#ifdef VK_USE_PLATFORM_FUCHSIA
YAML::Emitter &operator<<(YAML::Emitter &os, const VkBufferCollectionPropertiesFUCHSIA &t) {
    os << YAML::BeginMap;
    os << YAML::Key << "sType";
    // sType -> Field -> VkStructureType
    os << YAML::Value << t.sType;
    os << YAML::Key << "pNext";
    // pNext -> Field -> ConstNextPtr(void)
    os << YAML::Value << YAML::BeginSeq;
    PrintNextPtr(os, t.pNext);
    os << YAML::EndSeq;
    os << YAML::Key << "memoryTypeBits";
    // memoryTypeBits -> Field -> uint32_t
    os << YAML::Value << t.memoryTypeBits;
    os << YAML::Key << "bufferCount";
    // bufferCount -> Field -> uint32_t
    os << YAML::Value << t.bufferCount;
    os << YAML::Key << "createInfoIndex";
    // createInfoIndex -> Field -> uint32_t
    os << YAML::Value << t.createInfoIndex;
    os << YAML::Key << "sysmemPixelFormat";
    // sysmemPixelFormat -> Field -> uint64_t
    os << YAML::Value << t.sysmemPixelF