/* DO NOT EDIT BY HAND!!!                                           */
/* This file is generated by                                        */
/*       contrib/shell_utils/make-precompose.h.pl UnicodeData.txt   */

/* UnicodeData.txt is got from                                      */
/* http://www.unicode.org/Public/UNIDATA/UnicodeData.txt            */

#define SBASE 0xAC00
#define LBASE 0x1100
#define VBASE 0x1161
#define TBASE 0x11A7
#define LCOUNT 19
#define VCOUNT 21
#define TCOUNT 28
#define NCOUNT 588     /* (VCOUNT * TCOUNT) */
#define SCOUNT 11172   /* (LCOUNT * NCOUNT) */

#define PRECOMP_COUNT 955
#define DECOMP_COUNT 955
#define MAXCOMBLEN 3

#define PRECOMP_SP_COUNT 25
#define DECOMP_SP_COUNT 25
#define MAXCOMBSPLEN 4

#define COMBBUFLEN 4  /* max(MAXCOMBLEN,MAXCOMBSPLEN) */

static const struct {
  unsigned int replacement;
  unsigned int base;
  unsigned int comb;
} precompositions[] = {
/*{ 0x0000226E, 0x0000003C, 0x00000338 },*/   /* NOT LESS-THAN */
/*{ 0x00002260, 0x0000003D, 0x00000338 },*/   /* NOT EQUAL TO */
/*{ 0x0000226F, 0x0000003E, 0x00000338 },*/   /* NOT GREATER-THAN */
  { 0x000000C0, 0x00000041, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH GRAVE */
  { 0x000000C1, 0x00000041, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH ACUTE */
  { 0x000000C2, 0x00000041, 0x00000302 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
  { 0x000000C3, 0x00000041, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH TILDE */
  { 0x00000100, 0x00000041, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH MACRON */
  { 0x00000102, 0x00000041, 0x00000306 },     /* LATIN CAPITAL LETTER A WITH BREVE */
  { 0x00000226, 0x00000041, 0x00000307 },     /* LATIN CAPITAL LETTER A WITH DOT ABOVE */
  { 0x000000C4, 0x00000041, 0x00000308 },     /* LATIN CAPITAL LETTER A WITH DIAERESIS */
  { 0x00001EA2, 0x00000041, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH HOOK ABOVE */
  { 0x000000C5, 0x00000041, 0x0000030A },     /* LATIN CAPITAL LETTER A WITH RING ABOVE */
  { 0x000001CD, 0x00000041, 0x0000030C },     /* LATIN CAPITAL LETTER A WITH CARON */
  { 0x00000200, 0x00000041, 0x0000030F },     /* LATIN CAPITAL LETTER A WITH DOUBLE GRAVE */
  { 0x00000202, 0x00000041, 0x00000311 },     /* LATIN CAPITAL LETTER A WITH INVERTED BREVE */
  { 0x00001EA0, 0x00000041, 0x00000323 },     /* LATIN CAPITAL LETTER A WITH DOT BELOW */
  { 0x00001E00, 0x00000041, 0x00000325 },     /* LATIN CAPITAL LETTER A WITH RING BELOW */
  { 0x00000104, 0x00000041, 0x00000328 },     /* LATIN CAPITAL LETTER A WITH OGONEK */
  { 0x00001E02, 0x00000042, 0x00000307 },     /* LATIN CAPITAL LETTER B WITH DOT ABOVE */
  { 0x00001E04, 0x00000042, 0x00000323 },     /* LATIN CAPITAL LETTER B WITH DOT BELOW */
  { 0x00001E06, 0x00000042, 0x00000331 },     /* LATIN CAPITAL LETTER B WITH LINE BELOW */
  { 0x00000106, 0x00000043, 0x00000301 },     /* LATIN CAPITAL LETTER C WITH ACUTE */
  { 0x00000108, 0x00000043, 0x00000302 },     /* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
  { 0x0000010A, 0x00000043, 0x00000307 },     /* LATIN CAPITAL LETTER C WITH DOT ABOVE */
  { 0x0000010C, 0x00000043, 0x0000030C },     /* LATIN CAPITAL LETTER C WITH CARON */
  { 0x000000C7, 0x00000043, 0x00000327 },     /* LATIN CAPITAL LETTER C WITH CEDILLA */
  { 0x00001E0A, 0x00000044, 0x00000307 },     /* LATIN CAPITAL LETTER D WITH DOT ABOVE */
  { 0x0000010E, 0x00000044, 0x0000030C },     /* LATIN CAPITAL LETTER D WITH CARON */
  { 0x00001E0C, 0x00000044, 0x00000323 },     /* LATIN CAPITAL LETTER D WITH DOT BELOW */
  { 0x00001E10, 0x00000044, 0x00000327 },     /* LATIN CAPITAL LETTER D WITH CEDILLA */
  { 0x00001E12, 0x00000044, 0x0000032D },     /* LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */
  { 0x00001E0E, 0x00000044, 0x00000331 },     /* LATIN CAPITAL LETTER D WITH LINE BELOW */
  { 0x000000C8, 0x00000045, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH GRAVE */
  { 0x000000C9, 0x00000045, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH ACUTE */
  { 0x000000CA, 0x00000045, 0x00000302 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
  { 0x00001EBC, 0x00000045, 0x00000303 },     /* LATIN CAPITAL LETTER E WITH TILDE */
  { 0x00000112, 0x00000045, 0x00000304 },     /* LATIN CAPITAL LETTER E WITH MACRON */
  { 0x00000114, 0x00000045, 0x00000306 },     /* LATIN CAPITAL LETTER E WITH BREVE */
  { 0x00000116, 0x00000045, 0x00000307 },     /* LATIN CAPITAL LETTER E WITH DOT ABOVE */
  { 0x000000CB, 0x00000045, 0x00000308 },     /* LATIN CAPITAL LETTER E WITH DIAERESIS */
  { 0x00001EBA, 0x00000045, 0x00000309 },     /* LATIN CAPITAL LETTER E WITH HOOK ABOVE */
  { 0x0000011A, 0x00000045, 0x0000030C },     /* LATIN CAPITAL LETTER E WITH CARON */
  { 0x00000204, 0x00000045, 0x0000030F },     /* LATIN CAPITAL LETTER E WITH DOUBLE GRAVE */
  { 0x00000206, 0x00000045, 0x00000311 },     /* LATIN CAPITAL LETTER E WITH INVERTED BREVE */
  { 0x00001EB8, 0x00000045, 0x00000323 },     /* LATIN CAPITAL LETTER E WITH DOT BELOW */
  { 0x00000228, 0x00000045, 0x00000327 },     /* LATIN CAPITAL LETTER E WITH CEDILLA */
  { 0x00000118, 0x00000045, 0x00000328 },     /* LATIN CAPITAL LETTER E WITH OGONEK */
  { 0x00001E18, 0x00000045, 0x0000032D },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */
  { 0x00001E1A, 0x00000045, 0x00000330 },     /* LATIN CAPITAL LETTER E WITH TILDE BELOW */
  { 0x00001E1E, 0x00000046, 0x00000307 },     /* LATIN CAPITAL LETTER F WITH DOT ABOVE */
  { 0x000001F4, 0x00000047, 0x00000301 },     /* LATIN CAPITAL LETTER G WITH ACUTE */
  { 0x0000011C, 0x00000047, 0x00000302 },     /* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
  { 0x00001E20, 0x00000047, 0x00000304 },     /* LATIN CAPITAL LETTER G WITH MACRON */
  { 0x0000011E, 0x00000047, 0x00000306 },     /* LATIN CAPITAL LETTER G WITH BREVE */
  { 0x00000120, 0x00000047, 0x00000307 },     /* LATIN CAPITAL LETTER G WITH DOT ABOVE */
  { 0x000001E6, 0x00000047, 0x0000030C },     /* LATIN CAPITAL LETTER G WITH CARON */
  { 0x00000122, 0x00000047, 0x00000327 },     /* LATIN CAPITAL LETTER G WITH CEDILLA */
  { 0x00000124, 0x00000048, 0x00000302 },     /* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
  { 0x00001E22, 0x00000048, 0x00000307 },     /* LATIN CAPITAL LETTER H WITH DOT ABOVE */
  { 0x00001E26, 0x00000048, 0x00000308 },     /* LATIN CAPITAL LETTER H WITH DIAERESIS */
  { 0x0000021E, 0x00000048, 0x0000030C },     /* LATIN CAPITAL LETTER H WITH CARON */
  { 0x00001E24, 0x00000048, 0x00000323 },     /* LATIN CAPITAL LETTER H WITH DOT BELOW */
  { 0x00001E28, 0x00000048, 0x00000327 },     /* LATIN CAPITAL LETTER H WITH CEDILLA */
  { 0x00001E2A, 0x00000048, 0x0000032E },     /* LATIN CAPITAL LETTER H WITH BREVE BELOW */
  { 0x000000CC, 0x00000049, 0x00000300 },     /* LATIN CAPITAL LETTER I WITH GRAVE */
  { 0x000000CD, 0x00000049, 0x00000301 },     /* LATIN CAPITAL LETTER I WITH ACUTE */
  { 0x000000CE, 0x00000049, 0x00000302 },     /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
  { 0x00000128, 0x00000049, 0x00000303 },     /* LATIN CAPITAL LETTER I WITH TILDE */
  { 0x0000012A, 0x00000049, 0x00000304 },     /* LATIN CAPITAL LETTER I WITH MACRON */
  { 0x0000012C, 0x00000049, 0x00000306 },     /* LATIN CAPITAL LETTER I WITH BREVE */
  { 0x00000130, 0x00000049, 0x00000307 },     /* LATIN CAPITAL LETTER I WITH DOT ABOVE */
  { 0x000000CF, 0x00000049, 0x00000308 },     /* LATIN CAPITAL LETTER I WITH DIAERESIS */
  { 0x00001EC8, 0x00000049, 0x00000309 },     /* LATIN CAPITAL LETTER I WITH HOOK ABOVE */
  { 0x000001CF, 0x00000049, 0x0000030C },     /* LATIN CAPITAL LETTER I WITH CARON */
  { 0x00000208, 0x00000049, 0x0000030F },     /* LATIN CAPITAL LETTER I WITH DOUBLE GRAVE */
  { 0x0000020A, 0x00000049, 0x00000311 },     /* LATIN CAPITAL LETTER I WITH INVERTED BREVE */
  { 0x00001ECA, 0x00000049, 0x00000323 },     /* LATIN CAPITAL LETTER I WITH DOT BELOW */
  { 0x0000012E, 0x00000049, 0x00000328 },     /* LATIN CAPITAL LETTER I WITH OGONEK */
  { 0x00001E2C, 0x00000049, 0x00000330 },     /* LATIN CAPITAL LETTER I WITH TILDE BELOW */
  { 0x00000134, 0x0000004A, 0x00000302 },     /* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
  { 0x00001E30, 0x0000004B, 0x00000301 },     /* LATIN CAPITAL LETTER K WITH ACUTE */
  { 0x000001E8, 0x0000004B, 0x0000030C },     /* LATIN CAPITAL LETTER K WITH CARON */
  { 0x00001E32, 0x0000004B, 0x00000323 },     /* LATIN CAPITAL LETTER K WITH DOT BELOW */
  { 0x00000136, 0x0000004B, 0x00000327 },     /* LATIN CAPITAL LETTER K WITH CEDILLA */
  { 0x00001E34, 0x0000004B, 0x00000331 },     /* LATIN CAPITAL LETTER K WITH LINE BELOW */
  { 0x00000139, 0x0000004C, 0x00000301 },     /* LATIN CAPITAL LETTER L WITH ACUTE */
  { 0x0000013D, 0x0000004C, 0x0000030C },     /* LATIN CAPITAL LETTER L WITH CARON */
  { 0x00001E36, 0x0000004C, 0x00000323 },     /* LATIN CAPITAL LETTER L WITH DOT BELOW */
  { 0x0000013B, 0x0000004C, 0x00000327 },     /* LATIN CAPITAL LETTER L WITH CEDILLA */
  { 0x00001E3C, 0x0000004C, 0x0000032D },     /* LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */
  { 0x00001E3A, 0x0000004C, 0x00000331 },     /* LATIN CAPITAL LETTER L WITH LINE BELOW */
  { 0x00001E3E, 0x0000004D, 0x00000301 },     /* LATIN CAPITAL LETTER M WITH ACUTE */
  { 0x00001E40, 0x0000004D, 0x00000307 },     /* LATIN CAPITAL LETTER M WITH DOT ABOVE */
  { 0x00001E42, 0x0000004D, 0x00000323 },     /* LATIN CAPITAL LETTER M WITH DOT BELOW */
  { 0x000001F8, 0x0000004E, 0x00000300 },     /* LATIN CAPITAL LETTER N WITH GRAVE */
  { 0x00000143, 0x0000004E, 0x00000301 },     /* LATIN CAPITAL LETTER N WITH ACUTE */
  { 0x000000D1, 0x0000004E, 0x00000303 },     /* LATIN CAPITAL LETTER N WITH TILDE */
  { 0x00001E44, 0x0000004E, 0x00000307 },     /* LATIN CAPITAL LETTER N WITH DOT ABOVE */
  { 0x00000147, 0x0000004E, 0x0000030C },     /* LATIN CAPITAL LETTER N WITH CARON */
  { 0x00001E46, 0x0000004E, 0x00000323 },     /* LATIN CAPITAL LETTER N WITH DOT BELOW */
  { 0x00000145, 0x0000004E, 0x00000327 },     /* LATIN CAPITAL LETTER N WITH CEDILLA */
  { 0x00001E4A, 0x0000004E, 0x0000032D },     /* LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */
  { 0x00001E48, 0x0000004E, 0x00000331 },     /* LATIN CAPITAL LETTER N WITH LINE BELOW */
  { 0x000000D2, 0x0000004F, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH GRAVE */
  { 0x000000D3, 0x0000004F, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH ACUTE */
  { 0x000000D4, 0x0000004F, 0x00000302 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
  { 0x000000D5, 0x0000004F, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH TILDE */
  { 0x0000014C, 0x0000004F, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH MACRON */
  { 0x0000014E, 0x0000004F, 0x00000306 },     /* LATIN CAPITAL LETTER O WITH BREVE */
  { 0x0000022E, 0x0000004F, 0x00000307 },     /* LATIN CAPITAL LETTER O WITH DOT ABOVE */
  { 0x000000D6, 0x0000004F, 0x00000308 },     /* LATIN CAPITAL LETTER O WITH DIAERESIS */
  { 0x00001ECE, 0x0000004F, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH HOOK ABOVE */
  { 0x00000150, 0x0000004F, 0x0000030B },     /* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
  { 0x000001D1, 0x0000004F, 0x0000030C },     /* LATIN CAPITAL LETTER O WITH CARON */
  { 0x0000020C, 0x0000004F, 0x0000030F },     /* LATIN CAPITAL LETTER O WITH DOUBLE GRAVE */
  { 0x0000020E, 0x0000004F, 0x00000311 },     /* LATIN CAPITAL LETTER O WITH INVERTED BREVE */
  { 0x000001A0, 0x0000004F, 0x0000031B },     /* LATIN CAPITAL LETTER O WITH HORN */
  { 0x00001ECC, 0x0000004F, 0x00000323 },     /* LATIN CAPITAL LETTER O WITH DOT BELOW */
  { 0x000001EA, 0x0000004F, 0x00000328 },     /* LATIN CAPITAL LETTER O WITH OGONEK */
  { 0x00001E54, 0x00000050, 0x00000301 },     /* LATIN CAPITAL LETTER P WITH ACUTE */
  { 0x00001E56, 0x00000050, 0x00000307 },     /* LATIN CAPITAL LETTER P WITH DOT ABOVE */
  { 0x00000154, 0x00000052, 0x00000301 },     /* LATIN CAPITAL LETTER R WITH ACUTE */
  { 0x00001E58, 0x00000052, 0x00000307 },     /* LATIN CAPITAL LETTER R WITH DOT ABOVE */
  { 0x00000158, 0x00000052, 0x0000030C },     /* LATIN CAPITAL LETTER R WITH CARON */
  { 0x00000210, 0x00000052, 0x0000030F },     /* LATIN CAPITAL LETTER R WITH DOUBLE GRAVE */
  { 0x00000212, 0x00000052, 0x00000311 },     /* LATIN CAPITAL LETTER R WITH INVERTED BREVE */
  { 0x00001E5A, 0x00000052, 0x00000323 },     /* LATIN CAPITAL LETTER R WITH DOT BELOW */
  { 0x00000156, 0x00000052, 0x00000327 },     /* LATIN CAPITAL LETTER R WITH CEDILLA */
  { 0x00001E5E, 0x00000052, 0x00000331 },     /* LATIN CAPITAL LETTER R WITH LINE BELOW */
  { 0x0000015A, 0x00000053, 0x00000301 },     /* LATIN CAPITAL LETTER S WITH ACUTE */
  { 0x0000015C, 0x00000053, 0x00000302 },     /* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
  { 0x00001E60, 0x00000053, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH DOT ABOVE */
  { 0x00000160, 0x00000053, 0x0000030C },     /* LATIN CAPITAL LETTER S WITH CARON */
  { 0x00001E62, 0x00000053, 0x00000323 },     /* LATIN CAPITAL LETTER S WITH DOT BELOW */
  { 0x00000218, 0x00000053, 0x00000326 },     /* LATIN CAPITAL LETTER S WITH COMMA BELOW */
  { 0x0000015E, 0x00000053, 0x00000327 },     /* LATIN CAPITAL LETTER S WITH CEDILLA */
  { 0x00001E6A, 0x00000054, 0x00000307 },     /* LATIN CAPITAL LETTER T WITH DOT ABOVE */
  { 0x00000164, 0x00000054, 0x0000030C },     /* LATIN CAPITAL LETTER T WITH CARON */
  { 0x00001E6C, 0x00000054, 0x00000323 },     /* LATIN CAPITAL LETTER T WITH DOT BELOW */
  { 0x0000021A, 0x00000054, 0x00000326 },     /* LATIN CAPITAL LETTER T WITH COMMA BELOW */
  { 0x00000162, 0x00000054, 0x00000327 },     /* LATIN CAPITAL LETTER T WITH CEDILLA */
  { 0x00001E70, 0x00000054, 0x0000032D },     /* LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */
  { 0x00001E6E, 0x00000054, 0x00000331 },     /* LATIN CAPITAL LETTER T WITH LINE BELOW */
  { 0x000000D9, 0x00000055, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH GRAVE */
  { 0x000000DA, 0x00000055, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH ACUTE */
  { 0x000000DB, 0x00000055, 0x00000302 },     /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
  { 0x00000168, 0x00000055, 0x00000303 },     /* LATIN CAPITAL LETTER U WITH TILDE */
  { 0x0000016A, 0x00000055, 0x00000304 },     /* LATIN CAPITAL LETTER U WITH MACRON */
  { 0x0000016C, 0x00000055, 0x00000306 },     /* LATIN CAPITAL LETTER U WITH BREVE */
  { 0x000000DC, 0x00000055, 0x00000308 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS */
  { 0x00001EE6, 0x00000055, 0x00000309 },     /* LATIN CAPITAL LETTER U WITH HOOK ABOVE */
  { 0x0000016E, 0x00000055, 0x0000030A },     /* LATIN CAPITAL LETTER U WITH RING ABOVE */
  { 0x00000170, 0x00000055, 0x0000030B },     /* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
  { 0x000001D3, 0x00000055, 0x0000030C },     /* LATIN CAPITAL LETTER U WITH CARON */
  { 0x00000214, 0x00000055, 0x0000030F },     /* LATIN CAPITAL LETTER U WITH DOUBLE GRAVE */
  { 0x00000216, 0x00000055, 0x00000311 },     /* LATIN CAPITAL LETTER U WITH INVERTED BREVE */
  { 0x000001AF, 0x00000055, 0x0000031B },     /* LATIN CAPITAL LETTER U WITH HORN */
  { 0x00001EE4, 0x00000055, 0x00000323 },     /* LATIN CAPITAL LETTER U WITH DOT BELOW */
  { 0x00001E72, 0x00000055, 0x00000324 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS BELOW */
  { 0x00000172, 0x00000055, 0x00000328 },     /* LATIN CAPITAL LETTER U WITH OGONEK */
  { 0x00001E76, 0x00000055, 0x0000032D },     /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */
  { 0x00001E74, 0x00000055, 0x00000330 },     /* LATIN CAPITAL LETTER U WITH TILDE BELOW */
  { 0x00001E7C, 0x00000056, 0x00000303 },     /* LATIN CAPITAL LETTER V WITH TILDE */
  { 0x00001E7E, 0x00000056, 0x00000323 },     /* LATIN CAPITAL LETTER V WITH DOT BELOW */
  { 0x00001E80, 0x00000057, 0x00000300 },     /* LATIN CAPITAL LETTER W WITH GRAVE */
  { 0x00001E82, 0x00000057, 0x00000301 },     /* LATIN CAPITAL LETTER W WITH ACUTE */
  { 0x00000174, 0x00000057, 0x00000302 },     /* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */
  { 0x00001E86, 0x00000057, 0x00000307 },     /* LATIN CAPITAL LETTER W WITH DOT ABOVE */
  { 0x00001E84, 0x00000057, 0x00000308 },     /* LATIN CAPITAL LETTER W WITH DIAERESIS */
  { 0x00001E88, 0x00000057, 0x00000323 },     /* LATIN CAPITAL LETTER W WITH DOT BELOW */
  { 0x00001E8A, 0x00000058, 0x00000307 },     /* LATIN CAPITAL LETTER X WITH DOT ABOVE */
  { 0x00001E8C, 0x00000058, 0x00000308 },     /* LATIN CAPITAL LETTER X WITH DIAERESIS */
  { 0x00001EF2, 0x00000059, 0x00000300 },     /* LATIN CAPITAL LETTER Y WITH GRAVE */
  { 0x000000DD, 0x00000059, 0x00000301 },     /* LATIN CAPITAL LETTER Y WITH ACUTE */
  { 0x00000176, 0x00000059, 0x00000302 },     /* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */
  { 0x00001EF8, 0x00000059, 0x00000303 },     /* LATIN CAPITAL LETTER Y WITH TILDE */
  { 0x00000232, 0x00000059, 0x00000304 },     /* LATIN CAPITAL LETTER Y WITH MACRON */
  { 0x00001E8E, 0x00000059, 0x00000307 },     /* LATIN CAPITAL LETTER Y WITH DOT ABOVE */
  { 0x00000178, 0x00000059, 0x00000308 },     /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
  { 0x00001EF6, 0x00000059, 0x00000309 },     /* LATIN CAPITAL LETTER Y WITH HOOK ABOVE */
  { 0x00001EF4, 0x00000059, 0x00000323 },     /* LATIN CAPITAL LETTER Y WITH DOT BELOW */
  { 0x00000179, 0x0000005A, 0x00000301 },     /* LATIN CAPITAL LETTER Z WITH ACUTE */
  { 0x00001E90, 0x0000005A, 0x00000302 },     /* LATIN CAPITAL LETTER Z WITH CIRCUMFLEX */
  { 0x0000017B, 0x0000005A, 0x00000307 },     /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
  { 0x0000017D, 0x0000005A, 0x0000030C },     /* LATIN CAPITAL LETTER Z WITH CARON */
  { 0x00001E92, 0x0000005A, 0x00000323 },     /* LATIN CAPITAL LETTER Z WITH DOT BELOW */
  { 0x00001E94, 0x0000005A, 0x00000331 },     /* LATIN CAPITAL LETTER Z WITH LINE BELOW */
  { 0x000000E0, 0x00000061, 0x00000300 },     /* LATIN SMALL LETTER A WITH GRAVE */
  { 0x000000E1, 0x00000061, 0x00000301 },     /* LATIN SMALL LETTER A WITH ACUTE */
  { 0x000000E2, 0x00000061, 0x00000302 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
  { 0x000000E3, 0x00000061, 0x00000303 },     /* LATIN SMALL LETTER A WITH TILDE */
  { 0x00000101, 0x00000061, 0x00000304 },     /* LATIN SMALL LETTER A WITH MACRON */
  { 0x00000103, 0x00000061, 0x00000306 },     /* LATIN SMALL LETTER A WITH BREVE */
  { 0x00000227, 0x00000061, 0x00000307 },     /* LATIN SMALL LETTER A WITH DOT ABOVE */
  { 0x000000E4, 0x00000061, 0x00000308 },     /* LATIN SMALL LETTER A WITH DIAERESIS */
  { 0x00001EA3, 0x00000061, 0x00000309 },     /* LATIN SMALL LETTER A WITH HOOK ABOVE */
  { 0x000000E5, 0x00000061, 0x0000030A },     /* LATIN SMALL LETTER A WITH RING ABOVE */
  { 0x000001CE, 0x00000061, 0x0000030C },     /* LATIN SMALL LETTER A WITH CARON */
  { 0x00000201, 0x00000061, 0x0000030F },     /* LATIN SMALL LETTER A WITH DOUBLE GRAVE */
  { 0x00000203, 0x00000061, 0x00000311 },     /* LATIN SMALL LETTER A WITH INVERTED BREVE */
  { 0x00001EA1, 0x00000061, 0x00000323 },     /* LATIN SMALL LETTER A WITH DOT BELOW */
  { 0x00001E01, 0x00000061, 0x00000325 },     /* LATIN SMALL LETTER A WITH RING BELOW */
  { 0x00000105, 0x00000061, 0x00000328 },     /* LATIN SMALL LETTER A WITH OGONEK */
  { 0x00001E03, 0x00000062, 0x00000307 },     /* LATIN SMALL LETTER B WITH DOT ABOVE */
  { 0x00001E05, 0x00000062, 0x00000323 },     /* LATIN SMALL LETTER B WITH DOT BELOW */
  { 0x00001E07, 0x00000062, 0x00000331 },     /* LATIN SMALL LETTER B WITH LINE BELOW */
  { 0x00000107, 0x00000063, 0x00000301 },     /* LATIN SMALL LETTER C WITH ACUTE */
  { 0x00000109, 0x00000063, 0x00000302 },     /* LATIN SMALL LETTER C WITH CIRCUMFLEX */
  { 0x0000010B, 0x00000063, 0x00000307 },     /* LATIN SMALL LETTER C WITH DOT ABOVE */
  { 0x0000010D, 0x00000063, 0x0000030C },     /* LATIN SMALL LETTER C WITH CARON */
  { 0x000000E7, 0x00000063, 0x00000327 },     /* LATIN SMALL LETTER C WITH CEDILLA */
  { 0x00001E0B, 0x00000064, 0x00000307 },     /* LATIN SMALL LETTER D WITH DOT ABOVE */
  { 0x0000010F, 0x00000064, 0x0000030C },     /* LATIN SMALL LETTER D WITH CARON */
  { 0x00001E0D, 0x00000064, 0x00000323 },     /* LATIN SMALL LETTER D WITH DOT BELOW */
  { 0x00001E11, 0x00000064, 0x00000327 },     /* LATIN SMALL LETTER D WITH CEDILLA */
  { 0x00001E13, 0x00000064, 0x0000032D },     /* LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW */
  { 0x00001E0F, 0x00000064, 0x00000331 },     /* LATIN SMALL LETTER D WITH LINE BELOW */
  { 0x000000E8, 0x00000065, 0x00000300 },     /* LATIN SMALL LETTER E WITH GRAVE */
  { 0x000000E9, 0x00000065, 0x00000301 },     /* LATIN SMALL LETTER E WITH ACUTE */
  { 0x000000EA, 0x00000065, 0x00000302 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
  { 0x00001EBD, 0x00000065, 0x00000303 },     /* LATIN SMALL LETTER E WITH TILDE */
  { 0x00000113, 0x00000065, 0x00000304 },     /* LATIN SMALL LETTER E WITH MACRON */
  { 0x00000115, 0x00000065, 0x00000306 },     /* LATIN SMALL LETTER E WITH BREVE */
  { 0x00000117, 0x00000065, 0x00000307 },     /* LATIN SMALL LETTER E WITH DOT ABOVE */
  { 0x000000EB, 0x00000065, 0x00000308 },     /* LATIN SMALL LETTER E WITH DIAERESIS */
  { 0x00001EBB, 0x00000065, 0x00000309 },     /* LATIN SMALL LETTER E WITH HOOK ABOVE */
  { 0x0000011B, 0x00000065, 0x0000030C },     /* LATIN SMALL LETTER E WITH CARON */
  { 0x00000205, 0x00000065, 0x0000030F },     /* LATIN SMALL LETTER E WITH DOUBLE GRAVE */
  { 0x00000207, 0x00000065, 0x00000311 },     /* LATIN SMALL LETTER E WITH INVERTED BREVE */
  { 0x00001EB9, 0x00000065, 0x00000323 },     /* LATIN SMALL LETTER E WITH DOT BELOW */
  { 0x00000229, 0x00000065, 0x00000327 },     /* LATIN SMALL LETTER E WITH CEDILLA */
  { 0x00000119, 0x00000065, 0x00000328 },     /* LATIN SMALL LETTER E WITH OGONEK */
  { 0x00001E19, 0x00000065, 0x0000032D },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW */
  { 0x00001E1B, 0x00000065, 0x00000330 },     /* LATIN SMALL LETTER E WITH TILDE BELOW */
  { 0x00001E1F, 0x00000066, 0x00000307 },     /* LATIN SMALL LETTER F WITH DOT ABOVE */
  { 0x000001F5, 0x00000067, 0x00000301 },     /* LATIN SMALL LETTER G WITH ACUTE */
  { 0x0000011D, 0x00000067, 0x00000302 },     /* LATIN SMALL LETTER G WITH CIRCUMFLEX */
  { 0x00001E21, 0x00000067, 0x00000304 },     /* LATIN SMALL LETTER G WITH MACRON */
  { 0x0000011F, 0x00000067, 0x00000306 },     /* LATIN SMALL LETTER G WITH BREVE */
  { 0x00000121, 0x00000067, 0x00000307 },     /* LATIN SMALL LETTER G WITH DOT ABOVE */
  { 0x000001E7, 0x00000067, 0x0000030C },     /* LATIN SMALL LETTER G WITH CARON */
  { 0x00000123, 0x00000067, 0x00000327 },     /* LATIN SMALL LETTER G WITH CEDILLA */
  { 0x00000125, 0x00000068, 0x00000302 },     /* LATIN SMALL LETTER H WITH CIRCUMFLEX */
  { 0x00001E23, 0x00000068, 0x00000307 },     /* LATIN SMALL LETTER H WITH DOT ABOVE */
  { 0x00001E27, 0x00000068, 0x00000308 },     /* LATIN SMALL LETTER H WITH DIAERESIS */
  { 0x0000021F, 0x00000068, 0x0000030C },     /* LATIN SMALL LETTER H WITH CARON */
  { 0x00001E25, 0x00000068, 0x00000323 },     /* LATIN SMALL LETTER H WITH DOT BELOW */
  { 0x00001E29, 0x00000068, 0x00000327 },     /* LATIN SMALL LETTER H WITH CEDILLA */
  { 0x00001E2B, 0x00000068, 0x0000032E },     /* LATIN SMALL LETTER H WITH BREVE BELOW */
  { 0x00001E96, 0x00000068, 0x00000331 },     /* LATIN SMALL LETTER H WITH LINE BELOW */
  { 0x000000EC, 0x00000069, 0x00000300 },     /* LATIN SMALL LETTER I WITH GRAVE */
  { 0x000000ED, 0x00000069, 0x00000301 },     /* LATIN SMALL LETTER I WITH ACUTE */
  { 0x000000EE, 0x00000069, 0x00000302 },     /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
  { 0x00000129, 0x00000069, 0x00000303 },     /* LATIN SMALL LETTER I WITH TILDE */
  { 0x0000012B, 0x00000069, 0x00000304 },     /* LATIN SMALL LETTER I WITH MACRON */
  { 0x0000012D, 0x00000069, 0x00000306 },     /* LATIN SMALL LETTER I WITH BREVE */
  { 0x000000EF, 0x00000069, 0x00000308 },     /* LATIN SMALL LETTER I WITH DIAERESIS */
  { 0x00001EC9, 0x00000069, 0x00000309 },     /* LATIN SMALL LETTER I WITH HOOK ABOVE */
  { 0x000001D0, 0x00000069, 0x0000030C },     /* LATIN SMALL LETTER I WITH CARON */
  { 0x00000209, 0x00000069, 0x0000030F },     /* LATIN SMALL LETTER I WITH DOUBLE GRAVE */
  { 0x0000020B, 0x00000069, 0x00000311 },     /* LATIN SMALL LETTER I WITH INVERTED BREVE */
  { 0x00001ECB, 0x00000069, 0x00000323 },     /* LATIN SMALL LETTER I WITH DOT BELOW */
  { 0x0000012F, 0x00000069, 0x00000328 },     /* LATIN SMALL LETTER I WITH OGONEK */
  { 0x00001E2D, 0x00000069, 0x00000330 },     /* LATIN SMALL LETTER I WITH TILDE BELOW */
  { 0x00000135, 0x0000006A, 0x00000302 },     /* LATIN SMALL LETTER J WITH CIRCUMFLEX */
  { 0x000001F0, 0x0000006A, 0x0000030C },     /* LATIN SMALL LETTER J WITH CARON */
  { 0x00001E31, 0x0000006B, 0x00000301 },     /* LATIN SMALL LETTER K WITH ACUTE */
  { 0x000001E9, 0x0000006B, 0x0000030C },     /* LATIN SMALL LETTER K WITH CARON */
  { 0x00001E33, 0x0000006B, 0x00000323 },     /* LATIN SMALL LETTER K WITH DOT BELOW */
  { 0x00000137, 0x0000006B, 0x00000327 },     /* LATIN SMALL LETTER K WITH CEDILLA */
  { 0x00001E35, 0x0000006B, 0x00000331 },     /* LATIN SMALL LETTER K WITH LINE BELOW */
  { 0x0000013A, 0x0000006C, 0x00000301 },     /* LATIN SMALL LETTER L WITH ACUTE */
  { 0x0000013E, 0x0000006C, 0x0000030C },     /* LATIN SMALL LETTER L WITH CARON */
  { 0x00001E37, 0x0000006C, 0x00000323 },     /* LATIN SMALL LETTER L WITH DOT BELOW */
  { 0x0000013C, 0x0000006C, 0x00000327 },     /* LATIN SMALL LETTER L WITH CEDILLA */
  { 0x00001E3D, 0x0000006C, 0x0000032D },     /* LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW */
  { 0x00001E3B, 0x0000006C, 0x00000331 },     /* LATIN SMALL LETTER L WITH LINE BELOW */
  { 0x00001E3F, 0x0000006D, 0x00000301 },     /* LATIN SMALL LETTER M WITH ACUTE */
  { 0x00001E41, 0x0000006D, 0x00000307 },     /* LATIN SMALL LETTER M WITH DOT ABOVE */
  { 0x00001E43, 0x0000006D, 0x00000323 },     /* LATIN SMALL LETTER M WITH DOT BELOW */
  { 0x000001F9, 0x0000006E, 0x00000300 },     /* LATIN SMALL LETTER N WITH GRAVE */
  { 0x00000144, 0x0000006E, 0x00000301 },     /* LATIN SMALL LETTER N WITH ACUTE */
  { 0x000000F1, 0x0000006E, 0x00000303 },     /* LATIN SMALL LETTER N WITH TILDE */
  { 0x00001E45, 0x0000006E, 0x00000307 },     /* LATIN SMALL LETTER N WITH DOT ABOVE */
  { 0x00000148, 0x0000006E, 0x0000030C },     /* LATIN SMALL LETTER N WITH CARON */
  { 0x00001E47, 0x0000006E, 0x00000323 },     /* LATIN SMALL LETTER N WITH DOT BELOW */
  { 0x00000146, 0x0000006E, 0x00000327 },     /* LATIN SMALL LETTER N WITH CEDILLA */
  { 0x00001E4B, 0x0000006E, 0x0000032D },     /* LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW */
  { 0x00001E49, 0x0000006E, 0x00000331 },     /* LATIN SMALL LETTER N WITH LINE BELOW */
  { 0x000000F2, 0x0000006F, 0x00000300 },     /* LATIN SMALL LETTER O WITH GRAVE */
  { 0x000000F3, 0x0000006F, 0x00000301 },     /* LATIN SMALL LETTER O WITH ACUTE */
  { 0x000000F4, 0x0000006F, 0x00000302 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
  { 0x000000F5, 0x0000006F, 0x00000303 },     /* LATIN SMALL LETTER O WITH TILDE */
  { 0x0000014D, 0x0000006F, 0x00000304 },     /* LATIN SMALL LETTER O WITH MACRON */
  { 0x0000014F, 0x0000006F, 0x00000306 },     /* LATIN SMALL LETTER O WITH BREVE */
  { 0x0000022F, 0x0000006F, 0x00000307 },     /* LATIN SMALL LETTER O WITH DOT ABOVE */
  { 0x000000F6, 0x0000006F, 0x00000308 },     /* LATIN SMALL LETTER O WITH DIAERESIS */
  { 0x00001ECF, 0x0000006F, 0x00000309 },     /* LATIN SMALL LETTER O WITH HOOK ABOVE */
  { 0x00000151, 0x0000006F, 0x0000030B },     /* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
  { 0x000001D2, 0x0000006F, 0x0000030C },     /* LATIN SMALL LETTER O WITH CARON */
  { 0x0000020D, 0x0000006F, 0x0000030F },     /* LATIN SMALL LETTER O WITH DOUBLE GRAVE */
  { 0x0000020F, 0x0000006F, 0x00000311 },     /* LATIN SMALL LETTER O WITH INVERTED BREVE */
  { 0x000001A1, 0x0000006F, 0x0000031B },     /* LATIN SMALL LETTER O WITH HORN */
  { 0x00001ECD, 0x0000006F, 0x00000323 },     /* LATIN SMALL LETTER O WITH DOT BELOW */
  { 0x000001EB, 0x0000006F, 0x00000328 },     /* LATIN SMALL LETTER O WITH OGONEK */
  { 0x00001E55, 0x00000070, 0x00000301 },     /* LATIN SMALL LETTER P WITH ACUTE */
  { 0x00001E57, 0x00000070, 0x00000307 },     /* LATIN SMALL LETTER P WITH DOT ABOVE */
  { 0x00000155, 0x00000072, 0x00000301 },     /* LATIN SMALL LETTER R WITH ACUTE */
  { 0x00001E59, 0x00000072, 0x00000307 },     /* LATIN SMALL LETTER R WITH DOT ABOVE */
  { 0x00000159, 0x00000072, 0x0000030C },     /* LATIN SMALL LETTER R WITH CARON */
  { 0x00000211, 0x00000072, 0x0000030F },     /* LATIN SMALL LETTER R WITH DOUBLE GRAVE */
  { 0x00000213, 0x00000072, 0x00000311 },     /* LATIN SMALL LETTER R WITH INVERTED BREVE */
  { 0x00001E5B, 0x00000072, 0x00000323 },     /* LATIN SMALL LETTER R WITH DOT BELOW */
  { 0x00000157, 0x00000072, 0x00000327 },     /* LATIN SMALL LETTER R WITH CEDILLA */
  { 0x00001E5F, 0x00000072, 0x00000331 },     /* LATIN SMALL LETTER R WITH LINE BELOW */
  { 0x0000015B, 0x00000073, 0x00000301 },     /* LATIN SMALL LETTER S WITH ACUTE */
  { 0x0000015D, 0x00000073, 0x00000302 },     /* LATIN SMALL LETTER S WITH CIRCUMFLEX */
  { 0x00001E61, 0x00000073, 0x00000307 },     /* LATIN SMALL LETTER S WITH DOT ABOVE */
  { 0x00000161, 0x00000073, 0x0000030C },     /* LATIN SMALL LETTER S WITH CARON */
  { 0x00001E63, 0x00000073, 0x00000323 },     /* LATIN SMALL LETTER S WITH DOT BELOW */
  { 0x00000219, 0x00000073, 0x00000326 },     /* LATIN SMALL LETTER S WITH COMMA BELOW */
  { 0x0000015F, 0x00000073, 0x00000327 },     /* LATIN SMALL LETTER S WITH CEDILLA */
  { 0x00001E6B, 0x00000074, 0x00000307 },     /* LATIN SMALL LETTER T WITH DOT ABOVE */
  { 0x00001E97, 0x00000074, 0x00000308 },     /* LATIN SMALL LETTER T WITH DIAERESIS */
  { 0x00000165, 0x00000074, 0x0000030C },     /* LATIN SMALL LETTER T WITH CARON */
  { 0x00001E6D, 0x00000074, 0x00000323 },     /* LATIN SMALL LETTER T WITH DOT BELOW */
  { 0x0000021B, 0x00000074, 0x00000326 },     /* LATIN SMALL LETTER T WITH COMMA BELOW */
  { 0x00000163, 0x00000074, 0x00000327 },     /* LATIN SMALL LETTER T WITH CEDILLA */
  { 0x00001E71, 0x00000074, 0x0000032D },     /* LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW */
  { 0x00001E6F, 0x00000074, 0x00000331 },     /* LATIN SMALL LETTER T WITH LINE BELOW */
  { 0x000000F9, 0x00000075, 0x00000300 },     /* LATIN SMALL LETTER U WITH GRAVE */
  { 0x000000FA, 0x00000075, 0x00000301 },     /* LATIN SMALL LETTER U WITH ACUTE */
  { 0x000000FB, 0x00000075, 0x00000302 },     /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
  { 0x00000169, 0x00000075, 0x00000303 },     /* LATIN SMALL LETTER U WITH TILDE */
  { 0x0000016B, 0x00000075, 0x00000304 },     /* LATIN SMALL LETTER U WITH MACRON */
  { 0x0000016D, 0x00000075, 0x00000306 },     /* LATIN SMALL LETTER U WITH BREVE */
  { 0x000000FC, 0x00000075, 0x00000308 },     /* LATIN SMALL LETTER U WITH DIAERESIS */
  { 0x00001EE7, 0x00000075, 0x00000309 },     /* LATIN SMALL LETTER U WITH HOOK ABOVE */
  { 0x0000016F, 0x00000075, 0x0000030A },     /* LATIN SMALL LETTER U WITH RING ABOVE */
  { 0x00000171, 0x00000075, 0x0000030B },     /* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
  { 0x000001D4, 0x00000075, 0x0000030C },     /* LATIN SMALL LETTER U WITH CARON */
  { 0x00000215, 0x00000075, 0x0000030F },     /* LATIN SMALL LETTER U WITH DOUBLE GRAVE */
  { 0x00000217, 0x00000075, 0x00000311 },     /* LATIN SMALL LETTER U WITH INVERTED BREVE */
  { 0x000001B0, 0x00000075, 0x0000031B },     /* LATIN SMALL LETTER U WITH HORN */
  { 0x00001EE5, 0x00000075, 0x00000323 },     /* LATIN SMALL LETTER U WITH DOT BELOW */
  { 0x00001E73, 0x00000075, 0x00000324 },     /* LATIN SMALL LETTER U WITH DIAERESIS BELOW */
  { 0x00000173, 0x00000075, 0x00000328 },     /* LATIN SMALL LETTER U WITH OGONEK */
  { 0x00001E77, 0x00000075, 0x0000032D },     /* LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW */
  { 0x00001E75, 0x00000075, 0x00000330 },     /* LATIN SMALL LETTER U WITH TILDE BELOW */
  { 0x00001E7D, 0x00000076, 0x00000303 },     /* LATIN SMALL LETTER V WITH TILDE */
  { 0x00001E7F, 0x00000076, 0x00000323 },     /* LATIN SMALL LETTER V WITH DOT BELOW */
  { 0x00001E81, 0x00000077, 0x00000300 },     /* LATIN SMALL LETTER W WITH GRAVE */
  { 0x00001E83, 0x00000077, 0x00000301 },     /* LATIN SMALL LETTER W WITH ACUTE */
  { 0x00000175, 0x00000077, 0x00000302 },     /* LATIN SMALL LETTER W WITH CIRCUMFLEX */
  { 0x00001E87, 0x00000077, 0x00000307 },     /* LATIN SMALL LETTER W WITH DOT ABOVE */
  { 0x00001E85, 0x00000077, 0x00000308 },     /* LATIN SMALL LETTER W WITH DIAERESIS */
  { 0x00001E98, 0x00000077, 0x0000030A },     /* LATIN SMALL LETTER W WITH RING ABOVE */
  { 0x00001E89, 0x00000077, 0x00000323 },     /* LATIN SMALL LETTER W WITH DOT BELOW */
  { 0x00001E8B, 0x00000078, 0x00000307 },     /* LATIN SMALL LETTER X WITH DOT ABOVE */
  { 0x00001E8D, 0x00000078, 0x00000308 },     /* LATIN SMALL LETTER X WITH DIAERESIS */
  { 0x00001EF3, 0x00000079, 0x00000300 },     /* LATIN SMALL LETTER Y WITH GRAVE */
  { 0x000000FD, 0x00000079, 0x00000301 },     /* LATIN SMALL LETTER Y WITH ACUTE */
  { 0x00000177, 0x00000079, 0x00000302 },     /* LATIN SMALL LETTER Y WITH CIRCUMFLEX */
  { 0x00001EF9, 0x00000079, 0x00000303 },     /* LATIN SMALL LETTER Y WITH TILDE */
  { 0x00000233, 0x00000079, 0x00000304 },     /* LATIN SMALL LETTER Y WITH MACRON */
  { 0x00001E8F, 0x00000079, 0x00000307 },     /* LATIN SMALL LETTER Y WITH DOT ABOVE */
  { 0x000000FF, 0x00000079, 0x00000308 },     /* LATIN SMALL LETTER Y WITH DIAERESIS */
  { 0x00001EF7, 0x00000079, 0x00000309 },     /* LATIN SMALL LETTER Y WITH HOOK ABOVE */
  { 0x00001E99, 0x00000079, 0x0000030A },     /* LATIN SMALL LETTER Y WITH RING ABOVE */
  { 0x00001EF5, 0x00000079, 0x00000323 },     /* LATIN SMALL LETTER Y WITH DOT BELOW */
  { 0x0000017A, 0x0000007A, 0x00000301 },     /* LATIN SMALL LETTER Z WITH ACUTE */
  { 0x00001E91, 0x0000007A, 0x00000302 },     /* LATIN SMALL LETTER Z WITH CIRCUMFLEX */
  { 0x0000017C, 0x0000007A, 0x00000307 },     /* LATIN SMALL LETTER Z WITH DOT ABOVE */
  { 0x0000017E, 0x0000007A, 0x0000030C },     /* LATIN SMALL LETTER Z WITH CARON */
  { 0x00001E93, 0x0000007A, 0x00000323 },     /* LATIN SMALL LETTER Z WITH DOT BELOW */
  { 0x00001E95, 0x0000007A, 0x00000331 },     /* LATIN SMALL LETTER Z WITH LINE BELOW */
  { 0x00001FED, 0x000000A8, 0x00000300 },     /* GREEK DIALYTIKA AND VARIA */
  { 0x00000385, 0x000000A8, 0x00000301 },     /* GREEK DIALYTIKA TONOS */
  { 0x00001FC1, 0x000000A8, 0x00000342 },     /* GREEK DIALYTIKA AND PERISPOMENI */
  { 0x00001EA6, 0x000000C2, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EA4, 0x000000C2, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EAA, 0x000000C2, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE */
  { 0x00001EA8, 0x000000C2, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x000001DE, 0x000000C4, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON */
  { 0x000001FA, 0x000000C5, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */
  { 0x000001FC, 0x000000C6, 0x00000301 },     /* LATIN CAPITAL LETTER AE WITH ACUTE */
  { 0x000001E2, 0x000000C6, 0x00000304 },     /* LATIN CAPITAL LETTER AE WITH MACRON */
  { 0x00001E08, 0x000000C7, 0x00000301 },     /* LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE */
  { 0x00001EC0, 0x000000CA, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EBE, 0x000000CA, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EC4, 0x000000CA, 0x00000303 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE */
  { 0x00001EC2, 0x000000CA, 0x00000309 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001E2E, 0x000000CF, 0x00000301 },     /* LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE */
  { 0x00001ED2, 0x000000D4, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE */
  { 0x00001ED0, 0x000000D4, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE */
  { 0x00001ED6, 0x000000D4, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE */
  { 0x00001ED4, 0x000000D4, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001E4C, 0x000000D5, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH TILDE AND ACUTE */
  { 0x0000022C, 0x000000D5, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH TILDE AND MACRON */
  { 0x00001E4E, 0x000000D5, 0x00000308 },     /* LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS */
  { 0x0000022A, 0x000000D6, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON */
  { 0x000001FE, 0x000000D8, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */
  { 0x000001DB, 0x000000DC, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE */
  { 0x000001D7, 0x000000DC, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE */
  { 0x000001D5, 0x000000DC, 0x00000304 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON */
  { 0x000001D9, 0x000000DC, 0x0000030C },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON */
  { 0x00001EA7, 0x000000E2, 0x00000300 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EA5, 0x000000E2, 0x00000301 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EAB, 0x000000E2, 0x00000303 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE */
  { 0x00001EA9, 0x000000E2, 0x00000309 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x000001DF, 0x000000E4, 0x00000304 },     /* LATIN SMALL LETTER A WITH DIAERESIS AND MACRON */
  { 0x000001FB, 0x000000E5, 0x00000301 },     /* LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */
  { 0x000001FD, 0x000000E6, 0x00000301 },     /* LATIN SMALL LETTER AE WITH ACUTE */
  { 0x000001E3, 0x000000E6, 0x00000304 },     /* LATIN SMALL LETTER AE WITH MACRON */
  { 0x00001E09, 0x000000E7, 0x00000301 },     /* LATIN SMALL LETTER C WITH CEDILLA AND ACUTE */
  { 0x00001EC1, 0x000000EA, 0x00000300 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EBF, 0x000000EA, 0x00000301 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EC5, 0x000000EA, 0x00000303 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE */
  { 0x00001EC3, 0x000000EA, 0x00000309 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001E2F, 0x000000EF, 0x00000301 },     /* LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE */
  { 0x00001ED3, 0x000000F4, 0x00000300 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE */
  { 0x00001ED1, 0x000000F4, 0x00000301 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE */
  { 0x00001ED7, 0x000000F4, 0x00000303 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE */
  { 0x00001ED5, 0x000000F4, 0x00000309 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001E4D, 0x000000F5, 0x00000301 },     /* LATIN SMALL LETTER O WITH TILDE AND ACUTE */
  { 0x0000022D, 0x000000F5, 0x00000304 },     /* LATIN SMALL LETTER O WITH TILDE AND MACRON */
  { 0x00001E4F, 0x000000F5, 0x00000308 },     /* LATIN SMALL LETTER O WITH TILDE AND DIAERESIS */
  { 0x0000022B, 0x000000F6, 0x00000304 },     /* LATIN SMALL LETTER O WITH DIAERESIS AND MACRON */
  { 0x000001FF, 0x000000F8, 0x00000301 },     /* LATIN SMALL LETTER O WITH STROKE AND ACUTE */
  { 0x000001DC, 0x000000FC, 0x00000300 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE */
  { 0x000001D8, 0x000000FC, 0x00000301 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE */
  { 0x000001D6, 0x000000FC, 0x00000304 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND MACRON */
  { 0x000001DA, 0x000000FC, 0x0000030C },     /* LATIN SMALL LETTER U WITH DIAERESIS AND CARON */
  { 0x00001EB0, 0x00000102, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH BREVE AND GRAVE */
  { 0x00001EAE, 0x00000102, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH BREVE AND ACUTE */
  { 0x00001EB4, 0x00000102, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH BREVE AND TILDE */
  { 0x00001EB2, 0x00000102, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE */
  { 0x00001EB1, 0x00000103, 0x00000300 },     /* LATIN SMALL LETTER A WITH BREVE AND GRAVE */
  { 0x00001EAF, 0x00000103, 0x00000301 },     /* LATIN SMALL LETTER A WITH BREVE AND ACUTE */
  { 0x00001EB5, 0x00000103, 0x00000303 },     /* LATIN SMALL LETTER A WITH BREVE AND TILDE */
  { 0x00001EB3, 0x00000103, 0x00000309 },     /* LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE */
  { 0x00001E14, 0x00000112, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH MACRON AND GRAVE */
  { 0x00001E16, 0x00000112, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH MACRON AND ACUTE */
  { 0x00001E15, 0x00000113, 0x00000300 },     /* LATIN SMALL LETTER E WITH MACRON AND GRAVE */
  { 0x00001E17, 0x00000113, 0x00000301 },     /* LATIN SMALL LETTER E WITH MACRON AND ACUTE */
  { 0x00001E50, 0x0000014C, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH MACRON AND GRAVE */
  { 0x00001E52, 0x0000014C, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH MACRON AND ACUTE */
  { 0x00001E51, 0x0000014D, 0x00000300 },     /* LATIN SMALL LETTER O WITH MACRON AND GRAVE */
  { 0x00001E53, 0x0000014D, 0x00000301 },     /* LATIN SMALL LETTER O WITH MACRON AND ACUTE */
  { 0x00001E64, 0x0000015A, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE */
  { 0x00001E65, 0x0000015B, 0x00000307 },     /* LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE */
  { 0x00001E66, 0x00000160, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE */
  { 0x00001E67, 0x00000161, 0x00000307 },     /* LATIN SMALL LETTER S WITH CARON AND DOT ABOVE */
  { 0x00001E78, 0x00000168, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH TILDE AND ACUTE */
  { 0x00001E79, 0x00000169, 0x00000301 },     /* LATIN SMALL LETTER U WITH TILDE AND ACUTE */
  { 0x00001E7A, 0x0000016A, 0x00000308 },     /* LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS */
  { 0x00001E7B, 0x0000016B, 0x00000308 },     /* LATIN SMALL LETTER U WITH MACRON AND DIAERESIS */
  { 0x00001E9B, 0x0000017F, 0x00000307 },     /* LATIN SMALL LETTER LONG S WITH DOT ABOVE */
  { 0x00001EDC, 0x000001A0, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH HORN AND GRAVE */
  { 0x00001EDA, 0x000001A0, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH HORN AND ACUTE */
  { 0x00001EE0, 0x000001A0, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH HORN AND TILDE */
  { 0x00001EDE, 0x000001A0, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE */
  { 0x00001EE2, 0x000001A0, 0x00000323 },     /* LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW */
  { 0x00001EDD, 0x000001A1, 0x00000300 },     /* LATIN SMALL LETTER O WITH HORN AND GRAVE */
  { 0x00001EDB, 0x000001A1, 0x00000301 },     /* LATIN SMALL LETTER O WITH HORN AND ACUTE */
  { 0x00001EE1, 0x000001A1, 0x00000303 },     /* LATIN SMALL LETTER O WITH HORN AND TILDE */
  { 0x00001EDF, 0x000001A1, 0x00000309 },     /* LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */
  { 0x00001EE3, 0x000001A1, 0x00000323 },     /* LATIN SMALL LETTER O WITH HORN AND DOT BELOW */
  { 0x00001EEA, 0x000001AF, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH HORN AND GRAVE */
  { 0x00001EE8, 0x000001AF, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH HORN AND ACUTE */
  { 0x00001EEE, 0x000001AF, 0x00000303 },     /* LATIN CAPITAL LETTER U WITH HORN AND TILDE */
  { 0x00001EEC, 0x000001AF, 0x00000309 },     /* LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE */
  { 0x00001EF0, 0x000001AF, 0x00000323 },     /* LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW */
  { 0x00001EEB, 0x000001B0, 0x00000300 },     /* LATIN SMALL LETTER U WITH HORN AND GRAVE */
  { 0x00001EE9, 0x000001B0, 0x00000301 },     /* LATIN SMALL LETTER U WITH HORN AND ACUTE */
  { 0x00001EEF, 0x000001B0, 0x00000303 },     /* LATIN SMALL LETTER U WITH HORN AND TILDE */
  { 0x00001EED, 0x000001B0, 0x00000309 },     /* LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE */
  { 0x00001EF1, 0x000001B0, 0x00000323 },     /* LATIN SMALL LETTER U WITH HORN AND DOT BELOW */
  { 0x000001EE, 0x000001B7, 0x0000030C },     /* LATIN CAPITAL LETTER EZH WITH CARON */
  { 0x000001EC, 0x000001EA, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH OGONEK AND MACRON */
  { 0x000001ED, 0x000001EB, 0x00000304 },     /* LATIN SMALL LETTER O WITH OGONEK AND MACRON */
  { 0x000001E0, 0x00000226, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON */
  { 0x000001E1, 0x00000227, 0x00000304 },     /* LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON */
  { 0x00001E1C, 0x00000228, 0x00000306 },     /* LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  { 0x00001E1D, 0x00000229, 0x00000306 },     /* LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  { 0x00000230, 0x0000022E, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON */
  { 0x00000231, 0x0000022F, 0x00000304 },     /* LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON */
  { 0x000001EF, 0x00000292, 0x0000030C },     /* LATIN SMALL LETTER EZH WITH CARON */
  { 0x00000344, 0x00000308, 0x00000301 },     /* COMBINING GREEK DIALYTIKA TONOS */
  { 0x00001FBA, 0x00000391, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH VARIA */
  { 0x00000386, 0x00000391, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH TONOS */
  { 0x00001FB9, 0x00000391, 0x00000304 },     /* GREEK CAPITAL LETTER ALPHA WITH MACRON */
  { 0x00001FB8, 0x00000391, 0x00000306 },     /* GREEK CAPITAL LETTER ALPHA WITH VRACHY */
  { 0x00001F08, 0x00000391, 0x00000313 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI */
  { 0x00001F09, 0x00000391, 0x00000314 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA */
  { 0x00001FBC, 0x00000391, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI */
  { 0x00001FC8, 0x00000395, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH VARIA */
  { 0x00000388, 0x00000395, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH TONOS */
  { 0x00001F18, 0x00000395, 0x00000313 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI */
  { 0x00001F19, 0x00000395, 0x00000314 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA */
  { 0x00001FCA, 0x00000397, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH VARIA */
  { 0x00000389, 0x00000397, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH TONOS */
  { 0x00001F28, 0x00000397, 0x00000313 },     /* GREEK CAPITAL LETTER ETA WITH PSILI */
  { 0x00001F29, 0x00000397, 0x00000314 },     /* GREEK CAPITAL LETTER ETA WITH DASIA */
  { 0x00001FCC, 0x00000397, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI */
  { 0x00001FDA, 0x00000399, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH VARIA */
  { 0x0000038A, 0x00000399, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH TONOS */
  { 0x00001FD9, 0x00000399, 0x00000304 },     /* GREEK CAPITAL LETTER IOTA WITH MACRON */
  { 0x00001FD8, 0x00000399, 0x00000306 },     /* GREEK CAPITAL LETTER IOTA WITH VRACHY */
  { 0x000003AA, 0x00000399, 0x00000308 },     /* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */
  { 0x00001F38, 0x00000399, 0x00000313 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI */
  { 0x00001F39, 0x00000399, 0x00000314 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA */
  { 0x00001FF8, 0x0000039F, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH VARIA */
  { 0x0000038C, 0x0000039F, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH TONOS */
  { 0x00001F48, 0x0000039F, 0x00000313 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI */
  { 0x00001F49, 0x0000039F, 0x00000314 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA */
  { 0x00001FEC, 0x000003A1, 0x00000314 },     /* GREEK CAPITAL LETTER RHO WITH DASIA */
  { 0x00001FEA, 0x000003A5, 0x00000300 },     /* GREEK CAPITAL LETTER UPSILON WITH VARIA */
  { 0x0000038E, 0x000003A5, 0x00000301 },     /* GREEK CAPITAL LETTER UPSILON WITH TONOS */
  { 0x00001FE9, 0x000003A5, 0x00000304 },     /* GREEK CAPITAL LETTER UPSILON WITH MACRON */
  { 0x00001FE8, 0x000003A5, 0x00000306 },     /* GREEK CAPITAL LETTER UPSILON WITH VRACHY */
  { 0x000003AB, 0x000003A5, 0x00000308 },     /* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */
  { 0x00001F59, 0x000003A5, 0x00000314 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA */
  { 0x00001FFA, 0x000003A9, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH VARIA */
  { 0x0000038F, 0x000003A9, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH TONOS */
  { 0x00001F68, 0x000003A9, 0x00000313 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI */
  { 0x00001F69, 0x000003A9, 0x00000314 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA */
  { 0x00001FFC, 0x000003A9, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI */
  { 0x00001FB4, 0x000003AC, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI */
  { 0x00001FC4, 0x000003AE, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI */
  { 0x00001F70, 0x000003B1, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH VARIA */
  { 0x000003AC, 0x000003B1, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH TONOS */
  { 0x00001FB1, 0x000003B1, 0x00000304 },     /* GREEK SMALL LETTER ALPHA WITH MACRON */
  { 0x00001FB0, 0x000003B1, 0x00000306 },     /* GREEK SMALL LETTER ALPHA WITH VRACHY */
  { 0x00001F00, 0x000003B1, 0x00000313 },     /* GREEK SMALL LETTER ALPHA WITH PSILI */
  { 0x00001F01, 0x000003B1, 0x00000314 },     /* GREEK SMALL LETTER ALPHA WITH DASIA */
  { 0x00001FB6, 0x000003B1, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH PERISPOMENI */
  { 0x00001FB3, 0x000003B1, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI */
  { 0x00001F72, 0x000003B5, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH VARIA */
  { 0x000003AD, 0x000003B5, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH TONOS */
  { 0x00001F10, 0x000003B5, 0x00000313 },     /* GREEK SMALL LETTER EPSILON WITH PSILI */
  { 0x00001F11, 0x000003B5, 0x00000314 },     /* GREEK SMALL LETTER EPSILON WITH DASIA */
  { 0x00001F74, 0x000003B7, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH VARIA */
  { 0x000003AE, 0x000003B7, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH TONOS */
  { 0x00001F20, 0x000003B7, 0x00000313 },     /* GREEK SMALL LETTER ETA WITH PSILI */
  { 0x00001F21, 0x000003B7, 0x00000314 },     /* GREEK SMALL LETTER ETA WITH DASIA */
  { 0x00001FC6, 0x000003B7, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH PERISPOMENI */
  { 0x00001FC3, 0x000003B7, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI */
  { 0x00001F76, 0x000003B9, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH VARIA */
  { 0x000003AF, 0x000003B9, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH TONOS */
  { 0x00001FD1, 0x000003B9, 0x00000304 },     /* GREEK SMALL LETTER IOTA WITH MACRON */
  { 0x00001FD0, 0x000003B9, 0x00000306 },     /* GREEK SMALL LETTER IOTA WITH VRACHY */
  { 0x000003CA, 0x000003B9, 0x00000308 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA */
  { 0x00001F30, 0x000003B9, 0x00000313 },     /* GREEK SMALL LETTER IOTA WITH PSILI */
  { 0x00001F31, 0x000003B9, 0x00000314 },     /* GREEK SMALL LETTER IOTA WITH DASIA */
  { 0x00001FD6, 0x000003B9, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH PERISPOMENI */
  { 0x00001F78, 0x000003BF, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH VARIA */
  { 0x000003CC, 0x000003BF, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH TONOS */
  { 0x00001F40, 0x000003BF, 0x00000313 },     /* GREEK SMALL LETTER OMICRON WITH PSILI */
  { 0x00001F41, 0x000003BF, 0x00000314 },     /* GREEK SMALL LETTER OMICRON WITH DASIA */
  { 0x00001FE4, 0x000003C1, 0x00000313 },     /* GREEK SMALL LETTER RHO WITH PSILI */
  { 0x00001FE5, 0x000003C1, 0x00000314 },     /* GREEK SMALL LETTER RHO WITH DASIA */
  { 0x00001F7A, 0x000003C5, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH VARIA */
  { 0x000003CD, 0x000003C5, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH TONOS */
  { 0x00001FE1, 0x000003C5, 0x00000304 },     /* GREEK SMALL LETTER UPSILON WITH MACRON */
  { 0x00001FE0, 0x000003C5, 0x00000306 },     /* GREEK SMALL LETTER UPSILON WITH VRACHY */
  { 0x000003CB, 0x000003C5, 0x00000308 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */
  { 0x00001F50, 0x000003C5, 0x00000313 },     /* GREEK SMALL LETTER UPSILON WITH PSILI */
  { 0x00001F51, 0x000003C5, 0x00000314 },     /* GREEK SMALL LETTER UPSILON WITH DASIA */
  { 0x00001FE6, 0x000003C5, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH PERISPOMENI */
  { 0x00001F7C, 0x000003C9, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH VARIA */
  { 0x000003CE, 0x000003C9, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH TONOS */
  { 0x00001F60, 0x000003C9, 0x00000313 },     /* GREEK SMALL LETTER OMEGA WITH PSILI */
  { 0x00001F61, 0x000003C9, 0x00000314 },     /* GREEK SMALL LETTER OMEGA WITH DASIA */
  { 0x00001FF6, 0x000003C9, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH PERISPOMENI */
  { 0x00001FF3, 0x000003C9, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI */
  { 0x00001FD2, 0x000003CA, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA */
  { 0x00000390, 0x000003CA, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */
  { 0x00001FD7, 0x000003CA, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI */
  { 0x00001FE2, 0x000003CB, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA */
  { 0x000003B0, 0x000003CB, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */
  { 0x00001FE7, 0x000003CB, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI */
  { 0x00001FF4, 0x000003CE, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI */
  { 0x000003D3, 0x000003D2, 0x00000301 },     /* GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
  { 0x000003D4, 0x000003D2, 0x00000308 },     /* GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL */
  { 0x00000407, 0x00000406, 0x00000308 },     /* CYRILLIC CAPITAL LETTER YI */
  { 0x000004D0, 0x00000410, 0x00000306 },     /* CYRILLIC CAPITAL LETTER A WITH BREVE */
  { 0x000004D2, 0x00000410, 0x00000308 },     /* CYRILLIC CAPITAL LETTER A WITH DIAERESIS */
  { 0x00000403, 0x00000413, 0x00000301 },     /* CYRILLIC CAPITAL LETTER GJE */
  { 0x00000400, 0x00000415, 0x00000300 },     /* CYRILLIC CAPITAL LETTER IE WITH GRAVE */
  { 0x000004D6, 0x00000415, 0x00000306 },     /* CYRILLIC CAPITAL LETTER IE WITH BREVE */
  { 0x00000401, 0x00000415, 0x00000308 },     /* CYRILLIC CAPITAL LETTER IO */
  { 0x000004C1, 0x00000416, 0x00000306 },     /* CYRILLIC CAPITAL LETTER ZHE WITH BREVE */
  { 0x000004DC, 0x00000416, 0x00000308 },     /* CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS */
  { 0x000004DE, 0x00000417, 0x00000308 },     /* CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS */
  { 0x0000040D, 0x00000418, 0x00000300 },     /* CYRILLIC CAPITAL LETTER I WITH GRAVE */
  { 0x000004E2, 0x00000418, 0x00000304 },     /* CYRILLIC CAPITAL LETTER I WITH MACRON */
  { 0x00000419, 0x00000418, 0x00000306 },     /* CYRILLIC CAPITAL LETTER SHORT I */
  { 0x000004E4, 0x00000418, 0x00000308 },     /* CYRILLIC CAPITAL LETTER I WITH DIAERESIS */
  { 0x0000040C, 0x0000041A, 0x00000301 },     /* CYRILLIC CAPITAL LETTER KJE */
  { 0x000004E6, 0x0000041E, 0x00000308 },     /* CYRILLIC CAPITAL LETTER O WITH DIAERESIS */
  { 0x000004EE, 0x00000423, 0x00000304 },     /* CYRILLIC CAPITAL LETTER U WITH MACRON */
  { 0x0000040E, 0x00000423, 0x00000306 },     /* CYRILLIC CAPITAL LETTER SHORT U */
  { 0x000004F0, 0x00000423, 0x00000308 },     /* CYRILLIC CAPITAL LETTER U WITH DIAERESIS */
  { 0x000004F2, 0x00000423, 0x0000030B },     /* CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE */
  { 0x000004F4, 0x00000427, 0x00000308 },     /* CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS */
  { 0x000004F8, 0x0000042B, 0x00000308 },     /* CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS */
  { 0x000004EC, 0x0000042D, 0x00000308 },     /* CYRILLIC CAPITAL LETTER E WITH DIAERESIS */
  { 0x000004D1, 0x00000430, 0x00000306 },     /* CYRILLIC SMALL LETTER A WITH BREVE */
  { 0x000004D3, 0x00000430, 0x00000308 },     /* CYRILLIC SMALL LETTER A WITH DIAERESIS */
  { 0x00000453, 0x00000433, 0x00000301 },     /* CYRILLIC SMALL LETTER GJE */
  { 0x00000450, 0x00000435, 0x00000300 },     /* CYRILLIC SMALL LETTER IE WITH GRAVE */
  { 0x000004D7, 0x00000435, 0x00000306 },     /* CYRILLIC SMALL LETTER IE WITH BREVE */
  { 0x00000451, 0x00000435, 0x00000308 },     /* CYRILLIC SMALL LETTER IO */
  { 0x000004C2, 0x00000436, 0x00000306 },     /* CYRILLIC SMALL LETTER ZHE WITH BREVE */
  { 0x000004DD, 0x00000436, 0x00000308 },     /* CYRILLIC SMALL LETTER ZHE WITH DIAERESIS */
  { 0x000004DF, 0x00000437, 0x00000308 },     /* CYRILLIC SMALL LETTER ZE WITH DIAERESIS */
  { 0x0000045D, 0x00000438, 0x00000300 },     /* CYRILLIC SMALL LETTER I WITH GRAVE */
  { 0x000004E3, 0x00000438, 0x00000304 },     /* CYRILLIC SMALL LETTER I WITH MACRON */
  { 0x00000439, 0x00000438, 0x00000306 },     /* CYRILLIC SMALL LETTER SHORT I */
  { 0x000004E5, 0x00000438, 0x00000308 },     /* CYRILLIC SMALL LETTER I WITH DIAERESIS */
  { 0x0000045C, 0x0000043A, 0x00000301 },     /* CYRILLIC SMALL LETTER KJE */
  { 0x000004E7, 0x0000043E, 0x00000308 },     /* CYRILLIC SMALL LETTER O WITH DIAERESIS */
  { 0x000004EF, 0x00000443, 0x00000304 },     /* CYRILLIC SMALL LETTER U WITH MACRON */
  { 0x0000045E, 0x00000443, 0x00000306 },     /* CYRILLIC SMALL LETTER SHORT U */
  { 0x000004F1, 0x00000443, 0x00000308 },     /* CYRILLIC SMALL LETTER U WITH DIAERESIS */
  { 0x000004F3, 0x00000443, 0x0000030B },     /* CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE */
  { 0x000004F5, 0x00000447, 0x00000308 },     /* CYRILLIC SMALL LETTER CHE WITH DIAERESIS */
  { 0x000004F9, 0x0000044B, 0x00000308 },     /* CYRILLIC SMALL LETTER YERU WITH DIAERESIS */
  { 0x000004ED, 0x0000044D, 0x00000308 },     /* CYRILLIC SMALL LETTER E WITH DIAERESIS */
  { 0x00000457, 0x00000456, 0x00000308 },     /* CYRILLIC SMALL LETTER YI */
  { 0x00000476, 0x00000474, 0x0000030F },     /* CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  { 0x00000477, 0x00000475, 0x0000030F },     /* CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  { 0x000004DA, 0x000004D8, 0x00000308 },     /* CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS */
  { 0x000004DB, 0x000004D9, 0x00000308 },     /* CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS */
  { 0x000004EA, 0x000004E8, 0x00000308 },     /* CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS */
  { 0x000004EB, 0x000004E9, 0x00000308 },     /* CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS */
  { 0x0000FB2E, 0x000005D0, 0x000005B7 },     /* HEBREW LETTER ALEF WITH PATAH */
  { 0x0000FB2F, 0x000005D0, 0x000005B8 },     /* HEBREW LETTER ALEF WITH QAMATS */
  { 0x0000FB30, 0x000005D0, 0x000005BC },     /* HEBREW LETTER ALEF WITH MAPIQ */
  { 0x0000FB31, 0x000005D1, 0x000005BC },     /* HEBREW LETTER BET WITH DAGESH */
  { 0x0000FB4C, 0x000005D1, 0x000005BF },     /* HEBREW LETTER BET WITH RAFE */
  { 0x0000FB32, 0x000005D2, 0x000005BC },     /* HEBREW LETTER GIMEL WITH DAGESH */
  { 0x0000FB33, 0x000005D3, 0x000005BC },     /* HEBREW LETTER DALET WITH DAGESH */
  { 0x0000FB34, 0x000005D4, 0x000005BC },     /* HEBREW LETTER HE WITH MAPIQ */
  { 0x0000FB4B, 0x000005D5, 0x000005B9 },     /* HEBREW LETTER VAV WITH HOLAM */
  { 0x0000FB35, 0x000005D5, 0x000005BC },     /* HEBREW LETTER VAV WITH DAGESH */
  { 0x0000FB36, 0x000005D6, 0x000005BC },     /* HEBREW LETTER ZAYIN WITH DAGESH */
  { 0x0000FB38, 0x000005D8, 0x000005BC },     /* HEBREW LETTER TET WITH DAGESH */
  { 0x0000FB1D, 0x000005D9, 0x000005B4 },     /* HEBREW LETTER YOD WITH HIRIQ */
  { 0x0000FB39, 0x000005D9, 0x000005BC },     /* HEBREW LETTER YOD WITH DAGESH */
  { 0x0000FB3A, 0x000005DA, 0x000005BC },     /* HEBREW LETTER FINAL KAF WITH DAGESH */
  { 0x0000FB3B, 0x000005DB, 0x000005BC },     /* HEBREW LETTER KAF WITH DAGESH */
  { 0x0000FB4D, 0x000005DB, 0x000005BF },     /* HEBREW LETTER KAF WITH RAFE */
  { 0x0000FB3C, 0x000005DC, 0x000005BC },     /* HEBREW LETTER LAMED WITH DAGESH */
  { 0x0000FB3E, 0x000005DE, 0x000005BC },     /* HEBREW LETTER MEM WITH DAGESH */
  { 0x0000FB40, 0x000005E0, 0x000005BC },     /* HEBREW LETTER NUN WITH DAGESH */
  { 0x0000FB41, 0x000005E1, 0x000005BC },     /* HEBREW LETTER SAMEKH WITH DAGESH */
  { 0x0000FB43, 0x000005E3, 0x000005BC },     /* HEBREW LETTER FINAL PE WITH DAGESH */
  { 0x0000FB44, 0x000005E4, 0x000005BC },     /* HEBREW LETTER PE WITH DAGESH */
  { 0x0000FB4E, 0x000005E4, 0x000005BF },     /* HEBREW LETTER PE WITH RAFE */
  { 0x0000FB46, 0x000005E6, 0x000005BC },     /* HEBREW LETTER TSADI WITH DAGESH */
  { 0x0000FB47, 0x000005E7, 0x000005BC },     /* HEBREW LETTER QOF WITH DAGESH */
  { 0x0000FB48, 0x000005E8, 0x000005BC },     /* HEBREW LETTER RESH WITH DAGESH */
  { 0x0000FB49, 0x000005E9, 0x000005BC },     /* HEBREW LETTER SHIN WITH DAGESH */
  { 0x0000FB2A, 0x000005E9, 0x000005C1 },     /* HEBREW LETTER SHIN WITH SHIN DOT */
  { 0x0000FB2B, 0x000005E9, 0x000005C2 },     /* HEBREW LETTER SHIN WITH SIN DOT */
  { 0x0000FB4A, 0x000005EA, 0x000005BC },     /* HEBREW LETTER TAV WITH DAGESH */
  { 0x0000FB1F, 0x000005F2, 0x000005B7 },     /* HEBREW LIGATURE YIDDISH YOD YOD PATAH */
  { 0x00000622, 0x00000627, 0x00000653 },     /* ARABIC LETTER ALEF WITH MADDA ABOVE */
  { 0x00000623, 0x00000627, 0x00000654 },     /* ARABIC LETTER ALEF WITH HAMZA ABOVE */
  { 0x00000625, 0x00000627, 0x00000655 },     /* ARABIC LETTER ALEF WITH HAMZA BELOW */
  { 0x00000624, 0x00000648, 0x00000654 },     /* ARABIC LETTER WAW WITH HAMZA ABOVE */
  { 0x00000626, 0x0000064A, 0x00000654 },     /* ARABIC LETTER YEH WITH HAMZA ABOVE */
  { 0x000006C2, 0x000006C1, 0x00000654 },     /* ARABIC LETTER HEH GOAL WITH HAMZA ABOVE */
  { 0x000006D3, 0x000006D2, 0x00000654 },     /* ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */
  { 0x000006C0, 0x000006D5, 0x00000654 },     /* ARABIC LETTER HEH WITH YEH ABOVE */
  { 0x00000958, 0x00000915, 0x0000093C },     /* DEVANAGARI LETTER QA */
  { 0x00000959, 0x00000916, 0x0000093C },     /* DEVANAGARI LETTER KHHA */
  { 0x0000095A, 0x00000917, 0x0000093C },     /* DEVANAGARI LETTER GHHA */
  { 0x0000095B, 0x0000091C, 0x0000093C },     /* DEVANAGARI LETTER ZA */
  { 0x0000095C, 0x00000921, 0x0000093C },     /* DEVANAGARI LETTER DDDHA */
  { 0x0000095D, 0x00000922, 0x0000093C },     /* DEVANAGARI LETTER RHA */
  { 0x00000929, 0x00000928, 0x0000093C },     /* DEVANAGARI LETTER NNNA */
  { 0x0000095E, 0x0000092B, 0x0000093C },     /* DEVANAGARI LETTER FA */
  { 0x0000095F, 0x0000092F, 0x0000093C },     /* DEVANAGARI LETTER YYA */
  { 0x00000931, 0x00000930, 0x0000093C },     /* DEVANAGARI LETTER RRA */
  { 0x00000934, 0x00000933, 0x0000093C },     /* DEVANAGARI LETTER LLLA */
  { 0x000009DC, 0x000009A1, 0x000009BC },     /* BENGALI LETTER RRA */
  { 0x000009DD, 0x000009A2, 0x000009BC },     /* BENGALI LETTER RHA */
  { 0x000009DF, 0x000009AF, 0x000009BC },     /* BENGALI LETTER YYA */
  { 0x000009CB, 0x000009C7, 0x000009BE },     /* BENGALI VOWEL SIGN O */
  { 0x000009CC, 0x000009C7, 0x000009D7 },     /* BENGALI VOWEL SIGN AU */
  { 0x00000A59, 0x00000A16, 0x00000A3C },     /* GURMUKHI LETTER KHHA */
  { 0x00000A5A, 0x00000A17, 0x00000A3C },     /* GURMUKHI LETTER GHHA */
  { 0x00000A5B, 0x00000A1C, 0x00000A3C },     /* GURMUKHI LETTER ZA */
  { 0x00000A5E, 0x00000A2B, 0x00000A3C },     /* GURMUKHI LETTER FA */
  { 0x00000A33, 0x00000A32, 0x00000A3C },     /* GURMUKHI LETTER LLA */
  { 0x00000A36, 0x00000A38, 0x00000A3C },     /* GURMUKHI LETTER SHA */
  { 0x00000B5C, 0x00000B21, 0x00000B3C },     /* ORIYA LETTER RRA */
  { 0x00000B5D, 0x00000B22, 0x00000B3C },     /* ORIYA LETTER RHA */
  { 0x00000B4B, 0x00000B47, 0x00000B3E },     /* ORIYA VOWEL SIGN O */
  { 0x00000B48, 0x00000B47, 0x00000B56 },     /* ORIYA VOWEL SIGN AI */
  { 0x00000B4C, 0x00000B47, 0x00000B57 },     /* ORIYA VOWEL SIGN AU */
  { 0x00000B94, 0x00000B92, 0x00000BD7 },     /* TAMIL LETTER AU */
  { 0x00000BCA, 0x00000BC6, 0x00000BBE },     /* TAMIL VOWEL SIGN O */
  { 0x00000BCC, 0x00000BC6, 0x00000BD7 },     /* TAMIL VOWEL SIGN AU */
  { 0x00000BCB, 0x00000BC7, 0x00000BBE },     /* TAMIL VOWEL SIGN OO */
  { 0x00000C48, 0x00000C46, 0x00000C56 },     /* TELUGU VOWEL SIGN AI */
  { 0x00000CC0, 0x00000CBF, 0x00000CD5 },     /* KANNADA VOWEL SIGN II */
  { 0x00000CCA, 0x00000CC6, 0x00000CC2 },     /* KANNADA VOWEL SIGN O */
  { 0x00000CC7, 0x00000CC6, 0x00000CD5 },     /* KANNADA VOWEL SIGN EE */
  { 0x00000CC8, 0x00000CC6, 0x00000CD6 },     /* KANNADA VOWEL SIGN AI */
  { 0x00000CCB, 0x00000CCA, 0x00000CD5 },     /* KANNADA VOWEL SIGN OO */
  { 0x00000D4A, 0x00000D46, 0x00000D3E },     /* MALAYALAM VOWEL SIGN O */
  { 0x00000D4C, 0x00000D46, 0x00000D57 },     /* MALAYALAM VOWEL SIGN AU */
  { 0x00000D4B, 0x00000D47, 0x00000D3E },     /* MALAYALAM VOWEL SIGN OO */
  { 0x00000DDA, 0x00000DD9, 0x00000DCA },     /* SINHALA VOWEL SIGN DIGA KOMBUVA */
  { 0x00000DDC, 0x00000DD9, 0x00000DCF },     /* SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA */
  { 0x00000DDE, 0x00000DD9, 0x00000DDF },     /* SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA */
  { 0x00000DDD, 0x00000DDC, 0x00000DCA },     /* SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA */
  { 0x00000F69, 0x00000F40, 0x00000FB5 },     /* TIBETAN LETTER KSSA */
  { 0x00000F43, 0x00000F42, 0x00000FB7 },     /* TIBETAN LETTER GHA */
  { 0x00000F4D, 0x00000F4C, 0x00000FB7 },     /* TIBETAN LETTER DDHA */
  { 0x00000F52, 0x00000F51, 0x00000FB7 },     /* TIBETAN LETTER DHA */
  { 0x00000F57, 0x00000F56, 0x00000FB7 },     /* TIBETAN LETTER BHA */
  { 0x00000F5C, 0x00000F5B, 0x00000FB7 },     /* TIBETAN LETTER DZHA */
  { 0x00000F73, 0x00000F71, 0x00000F72 },     /* TIBETAN VOWEL SIGN II */
  { 0x00000F75, 0x00000F71, 0x00000F74 },     /* TIBETAN VOWEL SIGN UU */
  { 0x00000F81, 0x00000F71, 0x00000F80 },     /* TIBETAN VOWEL SIGN REVERSED II */
  { 0x00000FB9, 0x00000F90, 0x00000FB5 },     /* TIBETAN SUBJOINED LETTER KSSA */
  { 0x00000F93, 0x00000F92, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER GHA */
  { 0x00000F9D, 0x00000F9C, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DDHA */
  { 0x00000FA2, 0x00000FA1, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DHA */
  { 0x00000FA7, 0x00000FA6, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER BHA */
  { 0x00000FAC, 0x00000FAB, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DZHA */
  { 0x00000F76, 0x00000FB2, 0x00000F80 },     /* TIBETAN VOWEL SIGN VOCALIC R */
  { 0x00000F78, 0x00000FB3, 0x00000F80 },     /* TIBETAN VOWEL SIGN VOCALIC L */
  { 0x00001026, 0x00001025, 0x0000102E },     /* MYANMAR LETTER UU */
  { 0x00001B06, 0x00001B05, 0x00001B35 },     /* BALINESE LETTER AKARA TEDUNG */
  { 0x00001B08, 0x00001B07, 0x00001B35 },     /* BALINESE LETTER IKARA TEDUNG */
  { 0x00001B0A, 0x00001B09, 0x00001B35 },     /* BALINESE LETTER UKARA TEDUNG */
  { 0x00001B0C, 0x00001B0B, 0x00001B35 },     /* BALINESE LETTER RA REPA TEDUNG */
  { 0x00001B0E, 0x00001B0D, 0x00001B35 },     /* BALINESE LETTER LA LENGA TEDUNG */
  { 0x00001B12, 0x00001B11, 0x00001B35 },     /* BALINESE LETTER OKARA TEDUNG */
  { 0x00001B3B, 0x00001B3A, 0x00001B35 },     /* BALINESE VOWEL SIGN RA REPA TEDUNG */
  { 0x00001B3D, 0x00001B3C, 0x00001B35 },     /* BALINESE VOWEL SIGN LA LENGA TEDUNG */
  { 0x00001B40, 0x00001B3E, 0x00001B35 },     /* BALINESE VOWEL SIGN TALING TEDUNG */
  { 0x00001B41, 0x00001B3F, 0x00001B35 },     /* BALINESE VOWEL SIGN TALING REPA TEDUNG */
  { 0x00001B43, 0x00001B42, 0x00001B35 },     /* BALINESE VOWEL SIGN PEPET TEDUNG */
  { 0x00001E38, 0x00001E36, 0x00000304 },     /* LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON */
  { 0x00001E39, 0x00001E37, 0x00000304 },     /* LATIN SMALL LETTER L WITH DOT BELOW AND MACRON */
  { 0x00001E5C, 0x00001E5A, 0x00000304 },     /* LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON */
  { 0x00001E5D, 0x00001E5B, 0x00000304 },     /* LATIN SMALL LETTER R WITH DOT BELOW AND MACRON */
  { 0x00001E68, 0x00001E62, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE */
  { 0x00001E69, 0x00001E63, 0x00000307 },     /* LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */
  { 0x00001EAC, 0x00001EA0, 0x00000302 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EB6, 0x00001EA0, 0x00000306 },     /* LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW */
  { 0x00001EAD, 0x00001EA1, 0x00000302 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EB7, 0x00001EA1, 0x00000306 },     /* LATIN SMALL LETTER A WITH BREVE AND DOT BELOW */
  { 0x00001EC6, 0x00001EB8, 0x00000302 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EC7, 0x00001EB9, 0x00000302 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001ED8, 0x00001ECC, 0x00000302 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001ED9, 0x00001ECD, 0x00000302 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001F02, 0x00001F00, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA */
  { 0x00001F04, 0x00001F00, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA */
  { 0x00001F06, 0x00001F00, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI */
  { 0x00001F80, 0x00001F00, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001F03, 0x00001F01, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA */
  { 0x00001F05, 0x00001F01, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA */
  { 0x00001F07, 0x00001F01, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI */
  { 0x00001F81, 0x00001F01, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001F82, 0x00001F02, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F83, 0x00001F03, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F84, 0x00001F04, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F85, 0x00001F05, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F86, 0x00001F06, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F87, 0x00001F07, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F0A, 0x00001F08, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA */
  { 0x00001F0C, 0x00001F08, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA */
  { 0x00001F0E, 0x00001F08, 0x00000342 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI */
  { 0x00001F88, 0x00001F08, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001F0B, 0x00001F09, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA */
  { 0x00001F0D, 0x00001F09, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA */
  { 0x00001F0F, 0x00001F09, 0x00000342 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI */
  { 0x00001F89, 0x00001F09, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001F8A, 0x00001F0A, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F8B, 0x00001F0B, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F8C, 0x00001F0C, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F8D, 0x00001F0D, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F8E, 0x00001F0E, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F8F, 0x00001F0F, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F12, 0x00001F10, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA */
  { 0x00001F14, 0x00001F10, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA */
  { 0x00001F13, 0x00001F11, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA */
  { 0x00001F15, 0x00001F11, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA */
  { 0x00001F1A, 0x00001F18, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA */
  { 0x00001F1C, 0x00001F18, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA */
  { 0x00001F1B, 0x00001F19, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA */
  { 0x00001F1D, 0x00001F19, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA */
  { 0x00001F22, 0x00001F20, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH PSILI AND VARIA */
  { 0x00001F24, 0x00001F20, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH PSILI AND OXIA */
  { 0x00001F26, 0x00001F20, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI */
  { 0x00001F90, 0x00001F20, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001F23, 0x00001F21, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH DASIA AND VARIA */
  { 0x00001F25, 0x00001F21, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH DASIA AND OXIA */
  { 0x00001F27, 0x00001F21, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI */
  { 0x00001F91, 0x00001F21, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001F92, 0x00001F22, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F93, 0x00001F23, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F94, 0x00001F24, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F95, 0x00001F25, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F96, 0x00001F26, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F97, 0x00001F27, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F2A, 0x00001F28, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA */
  { 0x00001F2C, 0x00001F28, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA */
  { 0x00001F2E, 0x00001F28, 0x00000342 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI */
  { 0x00001F98, 0x00001F28, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001F2B, 0x00001F29, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA */
  { 0x00001F2D, 0x00001F29, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA */
  { 0x00001F2F, 0x00001F29, 0x00000342 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI */
  { 0x00001F99, 0x00001F29, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001F9A, 0x00001F2A, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F9B, 0x00001F2B, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F9C, 0x00001F2C, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F9D, 0x00001F2D, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F9E, 0x00001F2E, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F9F, 0x00001F2F, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F32, 0x00001F30, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND VARIA */
  { 0x00001F34, 0x00001F30, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND OXIA */
  { 0x00001F36, 0x00001F30, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI */
  { 0x00001F33, 0x00001F31, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND VARIA */
  { 0x00001F35, 0x00001F31, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND OXIA */
  { 0x00001F37, 0x00001F31, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI */
  { 0x00001F3A, 0x00001F38, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA */
  { 0x00001F3C, 0x00001F38, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA */
  { 0x00001F3E, 0x00001F38, 0x00000342 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI */
  { 0x00001F3B, 0x00001F39, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA */
  { 0x00001F3D, 0x00001F39, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA */
  { 0x00001F3F, 0x00001F39, 0x00000342 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI */
  { 0x00001F42, 0x00001F40, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA */
  { 0x00001F44, 0x00001F40, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA */
  { 0x00001F43, 0x00001F41, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA */
  { 0x00001F45, 0x00001F41, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA */
  { 0x00001F4A, 0x00001F48, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA */
  { 0x00001F4C, 0x00001F48, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA */
  { 0x00001F4B, 0x00001F49, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA */
  { 0x00001F4D, 0x00001F49, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA */
  { 0x00001F52, 0x00001F50, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA */
  { 0x00001F54, 0x00001F50, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA */
  { 0x00001F56, 0x00001F50, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI */
  { 0x00001F53, 0x00001F51, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA */
  { 0x00001F55, 0x00001F51, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA */
  { 0x00001F57, 0x00001F51, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI */
  { 0x00001F5B, 0x00001F59, 0x00000300 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA */
  { 0x00001F5D, 0x00001F59, 0x00000301 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA */
  { 0x00001F5F, 0x00001F59, 0x00000342 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI */
  { 0x00001F62, 0x00001F60, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA */
  { 0x00001F64, 0x00001F60, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA */
  { 0x00001F66, 0x00001F60, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI */
  { 0x00001FA0, 0x00001F60, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001F63, 0x00001F61, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA */
  { 0x00001F65, 0x00001F61, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA */
  { 0x00001F67, 0x00001F61, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI */
  { 0x00001FA1, 0x00001F61, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001FA2, 0x00001F62, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001FA3, 0x00001F63, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001FA4, 0x00001F64, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001FA5, 0x00001F65, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001FA6, 0x00001F66, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FA7, 0x00001F67, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F6A, 0x00001F68, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA */
  { 0x00001F6C, 0x00001F68, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA */
  { 0x00001F6E, 0x00001F68, 0x00000342 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI */
  { 0x00001FA8, 0x00001F68, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001F6B, 0x00001F69, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA */
  { 0x00001F6D, 0x00001F69, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA */
  { 0x00001F6F, 0x00001F69, 0x00000342 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI */
  { 0x00001FA9, 0x00001F69, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001FAA, 0x00001F6A, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001FAB, 0x00001F6B, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001FAC, 0x00001F6C, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001FAD, 0x00001F6D, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001FAE, 0x00001F6E, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001FAF, 0x00001F6F, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001FB2, 0x00001F70, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FC2, 0x00001F74, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FF2, 0x00001F7C, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FB7, 0x00001FB6, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FCD, 0x00001FBF, 0x00000300 },     /* GREEK PSILI AND VARIA */
  { 0x00001FCE, 0x00001FBF, 0x00000301 },     /* GREEK PSILI AND OXIA */
  { 0x00001FCF, 0x00001FBF, 0x00000342 },     /* GREEK PSILI AND PERISPOMENI */
  { 0x00001FC7, 0x00001FC6, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FF7, 0x00001FF6, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FDD, 0x00001FFE, 0x00000300 },     /* GREEK DASIA AND VARIA */
  { 0x00001FDE, 0x00001FFE, 0x00000301 },     /* GREEK DASIA AND OXIA */
  { 0x00001FDF, 0x00001FFE, 0x00000342 },     /* GREEK DASIA AND PERISPOMENI */
/*{ 0x0000219A, 0x00002190, 0x00000338 },*/   /* LEFTWARDS ARROW WITH STROKE */
/*{ 0x0000219B, 0x00002192, 0x00000338 },*/   /* RIGHTWARDS ARROW WITH STROKE */
/*{ 0x000021AE, 0x00002194, 0x00000338 },*/   /* LEFT RIGHT ARROW WITH STROKE */
/*{ 0x000021CD, 0x000021D0, 0x00000338 },*/   /* LEFTWARDS DOUBLE ARROW WITH STROKE */
/*{ 0x000021CF, 0x000021D2, 0x00000338 },*/   /* RIGHTWARDS DOUBLE ARROW WITH STROKE */
/*{ 0x000021CE, 0x000021D4, 0x00000338 },*/   /* LEFT RIGHT DOUBLE ARROW WITH STROKE */
/*{ 0x00002204, 0x00002203, 0x00000338 },*/   /* THERE DOES NOT EXIST */
/*{ 0x00002209, 0x00002208, 0x00000338 },*/   /* NOT AN ELEMENT OF */
/*{ 0x0000220C, 0x0000220B, 0x00000338 },*/   /* DOES NOT CONTAIN AS MEMBER */
/*{ 0x00002224, 0x00002223, 0x00000338 },*/   /* DOES NOT DIVIDE */
/*{ 0x00002226, 0x00002225, 0x00000338 },*/   /* NOT PARALLEL TO */
/*{ 0x00002241, 0x0000223C, 0x00000338 },*/   /* NOT TILDE */
/*{ 0x00002244, 0x00002243, 0x00000338 },*/   /* NOT ASYMPTOTICALLY EQUAL TO */
/*{ 0x00002247, 0x00002245, 0x00000338 },*/   /* NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO */
/*{ 0x00002249, 0x00002248, 0x00000338 },*/   /* NOT ALMOST EQUAL TO */
/*{ 0x0000226D, 0x0000224D, 0x00000338 },*/   /* NOT EQUIVALENT TO */
/*{ 0x00002262, 0x00002261, 0x00000338 },*/   /* NOT IDENTICAL TO */
/*{ 0x00002270, 0x00002264, 0x00000338 },*/   /* NEITHER LESS-THAN NOR EQUAL TO */
/*{ 0x00002271, 0x00002265, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR EQUAL TO */
/*{ 0x00002274, 0x00002272, 0x00000338 },*/   /* NEITHER LESS-THAN NOR EQUIVALENT TO */
/*{ 0x00002275, 0x00002273, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR EQUIVALENT TO */
/*{ 0x00002278, 0x00002276, 0x00000338 },*/   /* NEITHER LESS-THAN NOR GREATER-THAN */
/*{ 0x00002279, 0x00002277, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR LESS-THAN */
/*{ 0x00002280, 0x0000227A, 0x00000338 },*/   /* DOES NOT PRECEDE */
/*{ 0x00002281, 0x0000227B, 0x00000338 },*/   /* DOES NOT SUCCEED */
/*{ 0x000022E0, 0x0000227C, 0x00000338 },*/   /* DOES NOT PRECEDE OR EQUAL */
/*{ 0x000022E1, 0x0000227D, 0x00000338 },*/   /* DOES NOT SUCCEED OR EQUAL */
/*{ 0x00002284, 0x00002282, 0x00000338 },*/   /* NOT A SUBSET OF */
/*{ 0x00002285, 0x00002283, 0x00000338 },*/   /* NOT A SUPERSET OF */
/*{ 0x00002288, 0x00002286, 0x00000338 },*/   /* NEITHER A SUBSET OF NOR EQUAL TO */
/*{ 0x00002289, 0x00002287, 0x00000338 },*/   /* NEITHER A SUPERSET OF NOR EQUAL TO */
/*{ 0x000022E2, 0x00002291, 0x00000338 },*/   /* NOT SQUARE IMAGE OF OR EQUAL TO */
/*{ 0x000022E3, 0x00002292, 0x00000338 },*/   /* NOT SQUARE ORIGINAL OF OR EQUAL TO */
/*{ 0x000022AC, 0x000022A2, 0x00000338 },*/   /* DOES NOT PROVE */
/*{ 0x000022AD, 0x000022A8, 0x00000338 },*/   /* NOT TRUE */
/*{ 0x000022AE, 0x000022A9, 0x00000338 },*/   /* DOES NOT FORCE */
/*{ 0x000022AF, 0x000022AB, 0x00000338 },*/   /* NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE */
/*{ 0x000022EA, 0x000022B2, 0x00000338 },*/   /* NOT NORMAL SUBGROUP OF */
/*{ 0x000022EB, 0x000022B3, 0x00000338 },*/   /* DOES NOT CONTAIN AS NORMAL SUBGROUP */
/*{ 0x000022EC, 0x000022B4, 0x00000338 },*/   /* NOT NORMAL SUBGROUP OF OR EQUAL TO */
/*{ 0x000022ED, 0x000022B5, 0x00000338 },*/   /* DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL */
/*{ 0x00002ADC, 0x00002ADD, 0x00000338 },*/   /* FORKING */
  { 0x00003094, 0x00003046, 0x00003099 },     /* HIRAGANA LETTER VU */
  { 0x0000304C, 0x0000304B, 0x00003099 },     /* HIRAGANA LETTER GA */
  { 0x0000304E, 0x0000304D, 0x00003099 },     /* HIRAGANA LETTER GI */
  { 0x00003050, 0x0000304F, 0x00003099 },     /* HIRAGANA LETTER GU */
  { 0x00003052, 0x00003051, 0x00003099 },     /* HIRAGANA LETTER GE */
  { 0x00003054, 0x00003053, 0x00003099 },     /* HIRAGANA LETTER GO */
  { 0x00003056, 0x00003055, 0x00003099 },     /* HIRAGANA LETTER ZA */
  { 0x00003058, 0x00003057, 0x00003099 },     /* HIRAGANA LETTER ZI */
  { 0x0000305A, 0x00003059, 0x00003099 },     /* HIRAGANA LETTER ZU */
  { 0x0000305C, 0x0000305B, 0x00003099 },     /* HIRAGANA LETTER ZE */
  { 0x0000305E, 0x0000305D, 0x00003099 },     /* HIRAGANA LETTER ZO */
  { 0x00003060, 0x0000305F, 0x00003099 },     /* HIRAGANA LETTER DA */
  { 0x00003062, 0x00003061, 0x00003099 },     /* HIRAGANA LETTER DI */
  { 0x00003065, 0x00003064, 0x00003099 },     /* HIRAGANA LETTER DU */
  { 0x00003067, 0x00003066, 0x00003099 },     /* HIRAGANA LETTER DE */
  { 0x00003069, 0x00003068, 0x00003099 },     /* HIRAGANA LETTER DO */
  { 0x00003070, 0x0000306F, 0x00003099 },     /* HIRAGANA LETTER BA */
  { 0x00003071, 0x0000306F, 0x0000309A },     /* HIRAGANA LETTER PA */
  { 0x00003073, 0x00003072, 0x00003099 },     /* HIRAGANA LETTER BI */
  { 0x00003074, 0x00003072, 0x0000309A },     /* HIRAGANA LETTER PI */
  { 0x00003076, 0x00003075, 0x00003099 },     /* HIRAGANA LETTER BU */
  { 0x00003077, 0x00003075, 0x0000309A },     /* HIRAGANA LETTER PU */
  { 0x00003079, 0x00003078, 0x00003099 },     /* HIRAGANA LETTER BE */
  { 0x0000307A, 0x00003078, 0x0000309A },     /* HIRAGANA LETTER PE */
  { 0x0000307C, 0x0000307B, 0x00003099 },     /* HIRAGANA LETTER BO */
  { 0x0000307D, 0x0000307B, 0x0000309A },     /* HIRAGANA LETTER PO */
  { 0x0000309E, 0x0000309D, 0x00003099 },     /* HIRAGANA VOICED ITERATION MARK */
  { 0x000030F4, 0x000030A6, 0x00003099 },     /* KATAKANA LETTER VU */
  { 0x000030AC, 0x000030AB, 0x00003099 },     /* KATAKANA LETTER GA */
  { 0x000030AE, 0x000030AD, 0x00003099 },     /* KATAKANA LETTER GI */
  { 0x000030B0, 0x000030AF, 0x00003099 },     /* KATAKANA LETTER GU */
  { 0x000030B2, 0x000030B1, 0x00003099 },     /* KATAKANA LETTER GE */
  { 0x000030B4, 0x000030B3, 0x00003099 },     /* KATAKANA LETTER GO */
  { 0x000030B6, 0x000030B5, 0x00003099 },     /* KATAKANA LETTER ZA */
  { 0x000030B8, 0x000030B7, 0x00003099 },     /* KATAKANA LETTER ZI */
  { 0x000030BA, 0x000030B9, 0x00003099 },     /* KATAKANA LETTER ZU */
  { 0x000030BC, 0x000030BB, 0x00003099 },     /* KATAKANA LETTER ZE */
  { 0x000030BE, 0x000030BD, 0x00003099 },     /* KATAKANA LETTER ZO */
  { 0x000030C0, 0x000030BF, 0x00003099 },     /* KATAKANA LETTER DA */
  { 0x000030C2, 0x000030C1, 0x00003099 },     /* KATAKANA LETTER DI */
  { 0x000030C5, 0x000030C4, 0x00003099 },     /* KATAKANA LETTER DU */
  { 0x000030C7, 0x000030C6, 0x00003099 },     /* KATAKANA LETTER DE */
  { 0x000030C9, 0x000030C8, 0x00003099 },     /* KATAKANA LETTER DO */
  { 0x000030D0, 0x000030CF, 0x00003099 },     /* KATAKANA LETTER BA */
  { 0x000030D1, 0x000030CF, 0x0000309A },     /* KATAKANA LETTER PA */
  { 0x000030D3, 0x000030D2, 0x00003099 },     /* KATAKANA LETTER BI */
  { 0x000030D4, 0x000030D2, 0x0000309A },     /* KATAKANA LETTER PI */
  { 0x000030D6, 0x000030D5, 0x00003099 },     /* KATAKANA LETTER BU */
  { 0x000030D7, 0x000030D5, 0x0000309A },     /* KATAKANA LETTER PU */
  { 0x000030D9, 0x000030D8, 0x00003099 },     /* KATAKANA LETTER BE */
  { 0x000030DA, 0x000030D8, 0x0000309A },     /* KATAKANA LETTER PE */
  { 0x000030DC, 0x000030DB, 0x00003099 },     /* KATAKANA LETTER BO */
  { 0x000030DD, 0x000030DB, 0x0000309A },     /* KATAKANA LETTER PO */
  { 0x000030F7, 0x000030EF, 0x00003099 },     /* KATAKANA LETTER VA */
  { 0x000030F8, 0x000030F0, 0x00003099 },     /* KATAKANA LETTER VI */
  { 0x000030F9, 0x000030F1, 0x00003099 },     /* KATAKANA LETTER VE */
  { 0x000030FA, 0x000030F2, 0x00003099 },     /* KATAKANA LETTER VO */
  { 0x000030FE, 0x000030FD, 0x00003099 },     /* KATAKANA VOICED ITERATION MARK */
  { 0x0000FB2C, 0x0000FB49, 0x000005C1 },     /* HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT */
  { 0x0000FB2D, 0x0000FB49, 0x000005C2 },     /* HEBREW LETTER SHIN WITH DAGESH AND SIN DOT */
/*{ 0x0001109A, 0x00011099, 0x000110BA },*/   /* KAITHI LETTER DDDHA */
/*{ 0x0001109C, 0x0001109B, 0x000110BA },*/   /* KAITHI LETTER RHA */
/*{ 0x000110AB, 0x000110A5, 0x000110BA },*/   /* KAITHI LETTER VA */
/*{ 0x0001112E, 0x00011131, 0x00011127 },*/   /* CHAKMA VOWEL SIGN O */
/*{ 0x0001112F, 0x00011132, 0x00011127 },*/   /* CHAKMA VOWEL SIGN AU */
/*{ 0x0001134B, 0x00011347, 0x0001133E },*/   /* GRANTHA VOWEL SIGN OO */
/*{ 0x0001134C, 0x00011347, 0x00011357 },*/   /* GRANTHA VOWEL SIGN AU */
/*{ 0x000114BC, 0x000114B9, 0x000114B0 },*/   /* TIRHUTA VOWEL SIGN O */
/*{ 0x000114BB, 0x000114B9, 0x000114BA },*/   /* TIRHUTA VOWEL SIGN AI */
/*{ 0x000114BE, 0x000114B9, 0x000114BD },*/   /* TIRHUTA VOWEL SIGN AU */
/*{ 0x000115BA, 0x000115B8, 0x000115AF },*/   /* SIDDHAM VOWEL SIGN O */
/*{ 0x000115BB, 0x000115B9, 0x000115AF },*/   /* SIDDHAM VOWEL SIGN AU */
/*{ 0x0001D15E, 0x0001D157, 0x0001D165 },*/   /* MUSICAL SYMBOL HALF NOTE */
/*{ 0x0001D15F, 0x0001D158, 0x0001D165 },*/   /* MUSICAL SYMBOL QUARTER NOTE */
/*{ 0x0001D160, 0x0001D15F, 0x0001D16E },*/   /* MUSICAL SYMBOL EIGHTH NOTE */
/*{ 0x0001D161, 0x0001D15F, 0x0001D16F },*/   /* MUSICAL SYMBOL SIXTEENTH NOTE */
/*{ 0x0001D162, 0x0001D15F, 0x0001D170 },*/   /* MUSICAL SYMBOL THIRTY-SECOND NOTE */
/*{ 0x0001D163, 0x0001D15F, 0x0001D171 },*/   /* MUSICAL SYMBOL SIXTY-FOURTH NOTE */
/*{ 0x0001D164, 0x0001D15F, 0x0001D172 },*/   /* MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE */
/*{ 0x0001D1BB, 0x0001D1B9, 0x0001D165 },*/   /* MUSICAL SYMBOL MINIMA */
/*{ 0x0001D1BC, 0x0001D1BA, 0x0001D165 },*/   /* MUSICAL SYMBOL MINIMA BLACK */
/*{ 0x0001D1BD, 0x0001D1BB, 0x0001D16E },*/   /* MUSICAL SYMBOL SEMIMINIMA WHITE */
/*{ 0x0001D1BF, 0x0001D1BB, 0x0001D16F },*/   /* MUSICAL SYMBOL FUSA WHITE */
/*{ 0x0001D1BE, 0x0001D1BC, 0x0001D16E },*/   /* MUSICAL SYMBOL SEMIMINIMA BLACK */
/*{ 0x0001D1C0, 0x0001D1BC, 0x0001D16F },*/   /* MUSICAL SYMBOL FUSA BLACK */
};

static const struct {
  unsigned int replacement;
  unsigned int base;
  unsigned int comb;
} decompositions[] = {
  { 0x000000C0, 0x00000041, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH GRAVE */
  { 0x000000C1, 0x00000041, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH ACUTE */
  { 0x000000C2, 0x00000041, 0x00000302 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX */
  { 0x000000C3, 0x00000041, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH TILDE */
  { 0x000000C4, 0x00000041, 0x00000308 },     /* LATIN CAPITAL LETTER A WITH DIAERESIS */
  { 0x000000C5, 0x00000041, 0x0000030A },     /* LATIN CAPITAL LETTER A WITH RING ABOVE */
  { 0x000000C7, 0x00000043, 0x00000327 },     /* LATIN CAPITAL LETTER C WITH CEDILLA */
  { 0x000000C8, 0x00000045, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH GRAVE */
  { 0x000000C9, 0x00000045, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH ACUTE */
  { 0x000000CA, 0x00000045, 0x00000302 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX */
  { 0x000000CB, 0x00000045, 0x00000308 },     /* LATIN CAPITAL LETTER E WITH DIAERESIS */
  { 0x000000CC, 0x00000049, 0x00000300 },     /* LATIN CAPITAL LETTER I WITH GRAVE */
  { 0x000000CD, 0x00000049, 0x00000301 },     /* LATIN CAPITAL LETTER I WITH ACUTE */
  { 0x000000CE, 0x00000049, 0x00000302 },     /* LATIN CAPITAL LETTER I WITH CIRCUMFLEX */
  { 0x000000CF, 0x00000049, 0x00000308 },     /* LATIN CAPITAL LETTER I WITH DIAERESIS */
  { 0x000000D1, 0x0000004E, 0x00000303 },     /* LATIN CAPITAL LETTER N WITH TILDE */
  { 0x000000D2, 0x0000004F, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH GRAVE */
  { 0x000000D3, 0x0000004F, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH ACUTE */
  { 0x000000D4, 0x0000004F, 0x00000302 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX */
  { 0x000000D5, 0x0000004F, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH TILDE */
  { 0x000000D6, 0x0000004F, 0x00000308 },     /* LATIN CAPITAL LETTER O WITH DIAERESIS */
  { 0x000000D9, 0x00000055, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH GRAVE */
  { 0x000000DA, 0x00000055, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH ACUTE */
  { 0x000000DB, 0x00000055, 0x00000302 },     /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX */
  { 0x000000DC, 0x00000055, 0x00000308 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS */
  { 0x000000DD, 0x00000059, 0x00000301 },     /* LATIN CAPITAL LETTER Y WITH ACUTE */
  { 0x000000E0, 0x00000061, 0x00000300 },     /* LATIN SMALL LETTER A WITH GRAVE */
  { 0x000000E1, 0x00000061, 0x00000301 },     /* LATIN SMALL LETTER A WITH ACUTE */
  { 0x000000E2, 0x00000061, 0x00000302 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX */
  { 0x000000E3, 0x00000061, 0x00000303 },     /* LATIN SMALL LETTER A WITH TILDE */
  { 0x000000E4, 0x00000061, 0x00000308 },     /* LATIN SMALL LETTER A WITH DIAERESIS */
  { 0x000000E5, 0x00000061, 0x0000030A },     /* LATIN SMALL LETTER A WITH RING ABOVE */
  { 0x000000E7, 0x00000063, 0x00000327 },     /* LATIN SMALL LETTER C WITH CEDILLA */
  { 0x000000E8, 0x00000065, 0x00000300 },     /* LATIN SMALL LETTER E WITH GRAVE */
  { 0x000000E9, 0x00000065, 0x00000301 },     /* LATIN SMALL LETTER E WITH ACUTE */
  { 0x000000EA, 0x00000065, 0x00000302 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX */
  { 0x000000EB, 0x00000065, 0x00000308 },     /* LATIN SMALL LETTER E WITH DIAERESIS */
  { 0x000000EC, 0x00000069, 0x00000300 },     /* LATIN SMALL LETTER I WITH GRAVE */
  { 0x000000ED, 0x00000069, 0x00000301 },     /* LATIN SMALL LETTER I WITH ACUTE */
  { 0x000000EE, 0x00000069, 0x00000302 },     /* LATIN SMALL LETTER I WITH CIRCUMFLEX */
  { 0x000000EF, 0x00000069, 0x00000308 },     /* LATIN SMALL LETTER I WITH DIAERESIS */
  { 0x000000F1, 0x0000006E, 0x00000303 },     /* LATIN SMALL LETTER N WITH TILDE */
  { 0x000000F2, 0x0000006F, 0x00000300 },     /* LATIN SMALL LETTER O WITH GRAVE */
  { 0x000000F3, 0x0000006F, 0x00000301 },     /* LATIN SMALL LETTER O WITH ACUTE */
  { 0x000000F4, 0x0000006F, 0x00000302 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX */
  { 0x000000F5, 0x0000006F, 0x00000303 },     /* LATIN SMALL LETTER O WITH TILDE */
  { 0x000000F6, 0x0000006F, 0x00000308 },     /* LATIN SMALL LETTER O WITH DIAERESIS */
  { 0x000000F9, 0x00000075, 0x00000300 },     /* LATIN SMALL LETTER U WITH GRAVE */
  { 0x000000FA, 0x00000075, 0x00000301 },     /* LATIN SMALL LETTER U WITH ACUTE */
  { 0x000000FB, 0x00000075, 0x00000302 },     /* LATIN SMALL LETTER U WITH CIRCUMFLEX */
  { 0x000000FC, 0x00000075, 0x00000308 },     /* LATIN SMALL LETTER U WITH DIAERESIS */
  { 0x000000FD, 0x00000079, 0x00000301 },     /* LATIN SMALL LETTER Y WITH ACUTE */
  { 0x000000FF, 0x00000079, 0x00000308 },     /* LATIN SMALL LETTER Y WITH DIAERESIS */
  { 0x00000100, 0x00000041, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH MACRON */
  { 0x00000101, 0x00000061, 0x00000304 },     /* LATIN SMALL LETTER A WITH MACRON */
  { 0x00000102, 0x00000041, 0x00000306 },     /* LATIN CAPITAL LETTER A WITH BREVE */
  { 0x00000103, 0x00000061, 0x00000306 },     /* LATIN SMALL LETTER A WITH BREVE */
  { 0x00000104, 0x00000041, 0x00000328 },     /* LATIN CAPITAL LETTER A WITH OGONEK */
  { 0x00000105, 0x00000061, 0x00000328 },     /* LATIN SMALL LETTER A WITH OGONEK */
  { 0x00000106, 0x00000043, 0x00000301 },     /* LATIN CAPITAL LETTER C WITH ACUTE */
  { 0x00000107, 0x00000063, 0x00000301 },     /* LATIN SMALL LETTER C WITH ACUTE */
  { 0x00000108, 0x00000043, 0x00000302 },     /* LATIN CAPITAL LETTER C WITH CIRCUMFLEX */
  { 0x00000109, 0x00000063, 0x00000302 },     /* LATIN SMALL LETTER C WITH CIRCUMFLEX */
  { 0x0000010A, 0x00000043, 0x00000307 },     /* LATIN CAPITAL LETTER C WITH DOT ABOVE */
  { 0x0000010B, 0x00000063, 0x00000307 },     /* LATIN SMALL LETTER C WITH DOT ABOVE */
  { 0x0000010C, 0x00000043, 0x0000030C },     /* LATIN CAPITAL LETTER C WITH CARON */
  { 0x0000010D, 0x00000063, 0x0000030C },     /* LATIN SMALL LETTER C WITH CARON */
  { 0x0000010E, 0x00000044, 0x0000030C },     /* LATIN CAPITAL LETTER D WITH CARON */
  { 0x0000010F, 0x00000064, 0x0000030C },     /* LATIN SMALL LETTER D WITH CARON */
  { 0x00000112, 0x00000045, 0x00000304 },     /* LATIN CAPITAL LETTER E WITH MACRON */
  { 0x00000113, 0x00000065, 0x00000304 },     /* LATIN SMALL LETTER E WITH MACRON */
  { 0x00000114, 0x00000045, 0x00000306 },     /* LATIN CAPITAL LETTER E WITH BREVE */
  { 0x00000115, 0x00000065, 0x00000306 },     /* LATIN SMALL LETTER E WITH BREVE */
  { 0x00000116, 0x00000045, 0x00000307 },     /* LATIN CAPITAL LETTER E WITH DOT ABOVE */
  { 0x00000117, 0x00000065, 0x00000307 },     /* LATIN SMALL LETTER E WITH DOT ABOVE */
  { 0x00000118, 0x00000045, 0x00000328 },     /* LATIN CAPITAL LETTER E WITH OGONEK */
  { 0x00000119, 0x00000065, 0x00000328 },     /* LATIN SMALL LETTER E WITH OGONEK */
  { 0x0000011A, 0x00000045, 0x0000030C },     /* LATIN CAPITAL LETTER E WITH CARON */
  { 0x0000011B, 0x00000065, 0x0000030C },     /* LATIN SMALL LETTER E WITH CARON */
  { 0x0000011C, 0x00000047, 0x00000302 },     /* LATIN CAPITAL LETTER G WITH CIRCUMFLEX */
  { 0x0000011D, 0x00000067, 0x00000302 },     /* LATIN SMALL LETTER G WITH CIRCUMFLEX */
  { 0x0000011E, 0x00000047, 0x00000306 },     /* LATIN CAPITAL LETTER G WITH BREVE */
  { 0x0000011F, 0x00000067, 0x00000306 },     /* LATIN SMALL LETTER G WITH BREVE */
  { 0x00000120, 0x00000047, 0x00000307 },     /* LATIN CAPITAL LETTER G WITH DOT ABOVE */
  { 0x00000121, 0x00000067, 0x00000307 },     /* LATIN SMALL LETTER G WITH DOT ABOVE */
  { 0x00000122, 0x00000047, 0x00000327 },     /* LATIN CAPITAL LETTER G WITH CEDILLA */
  { 0x00000123, 0x00000067, 0x00000327 },     /* LATIN SMALL LETTER G WITH CEDILLA */
  { 0x00000124, 0x00000048, 0x00000302 },     /* LATIN CAPITAL LETTER H WITH CIRCUMFLEX */
  { 0x00000125, 0x00000068, 0x00000302 },     /* LATIN SMALL LETTER H WITH CIRCUMFLEX */
  { 0x00000128, 0x00000049, 0x00000303 },     /* LATIN CAPITAL LETTER I WITH TILDE */
  { 0x00000129, 0x00000069, 0x00000303 },     /* LATIN SMALL LETTER I WITH TILDE */
  { 0x0000012A, 0x00000049, 0x00000304 },     /* LATIN CAPITAL LETTER I WITH MACRON */
  { 0x0000012B, 0x00000069, 0x00000304 },     /* LATIN SMALL LETTER I WITH MACRON */
  { 0x0000012C, 0x00000049, 0x00000306 },     /* LATIN CAPITAL LETTER I WITH BREVE */
  { 0x0000012D, 0x00000069, 0x00000306 },     /* LATIN SMALL LETTER I WITH BREVE */
  { 0x0000012E, 0x00000049, 0x00000328 },     /* LATIN CAPITAL LETTER I WITH OGONEK */
  { 0x0000012F, 0x00000069, 0x00000328 },     /* LATIN SMALL LETTER I WITH OGONEK */
  { 0x00000130, 0x00000049, 0x00000307 },     /* LATIN CAPITAL LETTER I WITH DOT ABOVE */
  { 0x00000134, 0x0000004A, 0x00000302 },     /* LATIN CAPITAL LETTER J WITH CIRCUMFLEX */
  { 0x00000135, 0x0000006A, 0x00000302 },     /* LATIN SMALL LETTER J WITH CIRCUMFLEX */
  { 0x00000136, 0x0000004B, 0x00000327 },     /* LATIN CAPITAL LETTER K WITH CEDILLA */
  { 0x00000137, 0x0000006B, 0x00000327 },     /* LATIN SMALL LETTER K WITH CEDILLA */
  { 0x00000139, 0x0000004C, 0x00000301 },     /* LATIN CAPITAL LETTER L WITH ACUTE */
  { 0x0000013A, 0x0000006C, 0x00000301 },     /* LATIN SMALL LETTER L WITH ACUTE */
  { 0x0000013B, 0x0000004C, 0x00000327 },     /* LATIN CAPITAL LETTER L WITH CEDILLA */
  { 0x0000013C, 0x0000006C, 0x00000327 },     /* LATIN SMALL LETTER L WITH CEDILLA */
  { 0x0000013D, 0x0000004C, 0x0000030C },     /* LATIN CAPITAL LETTER L WITH CARON */
  { 0x0000013E, 0x0000006C, 0x0000030C },     /* LATIN SMALL LETTER L WITH CARON */
  { 0x00000143, 0x0000004E, 0x00000301 },     /* LATIN CAPITAL LETTER N WITH ACUTE */
  { 0x00000144, 0x0000006E, 0x00000301 },     /* LATIN SMALL LETTER N WITH ACUTE */
  { 0x00000145, 0x0000004E, 0x00000327 },     /* LATIN CAPITAL LETTER N WITH CEDILLA */
  { 0x00000146, 0x0000006E, 0x00000327 },     /* LATIN SMALL LETTER N WITH CEDILLA */
  { 0x00000147, 0x0000004E, 0x0000030C },     /* LATIN CAPITAL LETTER N WITH CARON */
  { 0x00000148, 0x0000006E, 0x0000030C },     /* LATIN SMALL LETTER N WITH CARON */
  { 0x0000014C, 0x0000004F, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH MACRON */
  { 0x0000014D, 0x0000006F, 0x00000304 },     /* LATIN SMALL LETTER O WITH MACRON */
  { 0x0000014E, 0x0000004F, 0x00000306 },     /* LATIN CAPITAL LETTER O WITH BREVE */
  { 0x0000014F, 0x0000006F, 0x00000306 },     /* LATIN SMALL LETTER O WITH BREVE */
  { 0x00000150, 0x0000004F, 0x0000030B },     /* LATIN CAPITAL LETTER O WITH DOUBLE ACUTE */
  { 0x00000151, 0x0000006F, 0x0000030B },     /* LATIN SMALL LETTER O WITH DOUBLE ACUTE */
  { 0x00000154, 0x00000052, 0x00000301 },     /* LATIN CAPITAL LETTER R WITH ACUTE */
  { 0x00000155, 0x00000072, 0x00000301 },     /* LATIN SMALL LETTER R WITH ACUTE */
  { 0x00000156, 0x00000052, 0x00000327 },     /* LATIN CAPITAL LETTER R WITH CEDILLA */
  { 0x00000157, 0x00000072, 0x00000327 },     /* LATIN SMALL LETTER R WITH CEDILLA */
  { 0x00000158, 0x00000052, 0x0000030C },     /* LATIN CAPITAL LETTER R WITH CARON */
  { 0x00000159, 0x00000072, 0x0000030C },     /* LATIN SMALL LETTER R WITH CARON */
  { 0x0000015A, 0x00000053, 0x00000301 },     /* LATIN CAPITAL LETTER S WITH ACUTE */
  { 0x0000015B, 0x00000073, 0x00000301 },     /* LATIN SMALL LETTER S WITH ACUTE */
  { 0x0000015C, 0x00000053, 0x00000302 },     /* LATIN CAPITAL LETTER S WITH CIRCUMFLEX */
  { 0x0000015D, 0x00000073, 0x00000302 },     /* LATIN SMALL LETTER S WITH CIRCUMFLEX */
  { 0x0000015E, 0x00000053, 0x00000327 },     /* LATIN CAPITAL LETTER S WITH CEDILLA */
  { 0x0000015F, 0x00000073, 0x00000327 },     /* LATIN SMALL LETTER S WITH CEDILLA */
  { 0x00000160, 0x00000053, 0x0000030C },     /* LATIN CAPITAL LETTER S WITH CARON */
  { 0x00000161, 0x00000073, 0x0000030C },     /* LATIN SMALL LETTER S WITH CARON */
  { 0x00000162, 0x00000054, 0x00000327 },     /* LATIN CAPITAL LETTER T WITH CEDILLA */
  { 0x00000163, 0x00000074, 0x00000327 },     /* LATIN SMALL LETTER T WITH CEDILLA */
  { 0x00000164, 0x00000054, 0x0000030C },     /* LATIN CAPITAL LETTER T WITH CARON */
  { 0x00000165, 0x00000074, 0x0000030C },     /* LATIN SMALL LETTER T WITH CARON */
  { 0x00000168, 0x00000055, 0x00000303 },     /* LATIN CAPITAL LETTER U WITH TILDE */
  { 0x00000169, 0x00000075, 0x00000303 },     /* LATIN SMALL LETTER U WITH TILDE */
  { 0x0000016A, 0x00000055, 0x00000304 },     /* LATIN CAPITAL LETTER U WITH MACRON */
  { 0x0000016B, 0x00000075, 0x00000304 },     /* LATIN SMALL LETTER U WITH MACRON */
  { 0x0000016C, 0x00000055, 0x00000306 },     /* LATIN CAPITAL LETTER U WITH BREVE */
  { 0x0000016D, 0x00000075, 0x00000306 },     /* LATIN SMALL LETTER U WITH BREVE */
  { 0x0000016E, 0x00000055, 0x0000030A },     /* LATIN CAPITAL LETTER U WITH RING ABOVE */
  { 0x0000016F, 0x00000075, 0x0000030A },     /* LATIN SMALL LETTER U WITH RING ABOVE */
  { 0x00000170, 0x00000055, 0x0000030B },     /* LATIN CAPITAL LETTER U WITH DOUBLE ACUTE */
  { 0x00000171, 0x00000075, 0x0000030B },     /* LATIN SMALL LETTER U WITH DOUBLE ACUTE */
  { 0x00000172, 0x00000055, 0x00000328 },     /* LATIN CAPITAL LETTER U WITH OGONEK */
  { 0x00000173, 0x00000075, 0x00000328 },     /* LATIN SMALL LETTER U WITH OGONEK */
  { 0x00000174, 0x00000057, 0x00000302 },     /* LATIN CAPITAL LETTER W WITH CIRCUMFLEX */
  { 0x00000175, 0x00000077, 0x00000302 },     /* LATIN SMALL LETTER W WITH CIRCUMFLEX */
  { 0x00000176, 0x00000059, 0x00000302 },     /* LATIN CAPITAL LETTER Y WITH CIRCUMFLEX */
  { 0x00000177, 0x00000079, 0x00000302 },     /* LATIN SMALL LETTER Y WITH CIRCUMFLEX */
  { 0x00000178, 0x00000059, 0x00000308 },     /* LATIN CAPITAL LETTER Y WITH DIAERESIS */
  { 0x00000179, 0x0000005A, 0x00000301 },     /* LATIN CAPITAL LETTER Z WITH ACUTE */
  { 0x0000017A, 0x0000007A, 0x00000301 },     /* LATIN SMALL LETTER Z WITH ACUTE */
  { 0x0000017B, 0x0000005A, 0x00000307 },     /* LATIN CAPITAL LETTER Z WITH DOT ABOVE */
  { 0x0000017C, 0x0000007A, 0x00000307 },     /* LATIN SMALL LETTER Z WITH DOT ABOVE */
  { 0x0000017D, 0x0000005A, 0x0000030C },     /* LATIN CAPITAL LETTER Z WITH CARON */
  { 0x0000017E, 0x0000007A, 0x0000030C },     /* LATIN SMALL LETTER Z WITH CARON */
  { 0x000001A0, 0x0000004F, 0x0000031B },     /* LATIN CAPITAL LETTER O WITH HORN */
  { 0x000001A1, 0x0000006F, 0x0000031B },     /* LATIN SMALL LETTER O WITH HORN */
  { 0x000001AF, 0x00000055, 0x0000031B },     /* LATIN CAPITAL LETTER U WITH HORN */
  { 0x000001B0, 0x00000075, 0x0000031B },     /* LATIN SMALL LETTER U WITH HORN */
  { 0x000001CD, 0x00000041, 0x0000030C },     /* LATIN CAPITAL LETTER A WITH CARON */
  { 0x000001CE, 0x00000061, 0x0000030C },     /* LATIN SMALL LETTER A WITH CARON */
  { 0x000001CF, 0x00000049, 0x0000030C },     /* LATIN CAPITAL LETTER I WITH CARON */
  { 0x000001D0, 0x00000069, 0x0000030C },     /* LATIN SMALL LETTER I WITH CARON */
  { 0x000001D1, 0x0000004F, 0x0000030C },     /* LATIN CAPITAL LETTER O WITH CARON */
  { 0x000001D2, 0x0000006F, 0x0000030C },     /* LATIN SMALL LETTER O WITH CARON */
  { 0x000001D3, 0x00000055, 0x0000030C },     /* LATIN CAPITAL LETTER U WITH CARON */
  { 0x000001D4, 0x00000075, 0x0000030C },     /* LATIN SMALL LETTER U WITH CARON */
  { 0x000001D5, 0x000000DC, 0x00000304 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON */
  { 0x000001D6, 0x000000FC, 0x00000304 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND MACRON */
  { 0x000001D7, 0x000000DC, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE */
  { 0x000001D8, 0x000000FC, 0x00000301 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE */
  { 0x000001D9, 0x000000DC, 0x0000030C },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON */
  { 0x000001DA, 0x000000FC, 0x0000030C },     /* LATIN SMALL LETTER U WITH DIAERESIS AND CARON */
  { 0x000001DB, 0x000000DC, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE */
  { 0x000001DC, 0x000000FC, 0x00000300 },     /* LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE */
  { 0x000001DE, 0x000000C4, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON */
  { 0x000001DF, 0x000000E4, 0x00000304 },     /* LATIN SMALL LETTER A WITH DIAERESIS AND MACRON */
  { 0x000001E0, 0x00000226, 0x00000304 },     /* LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON */
  { 0x000001E1, 0x00000227, 0x00000304 },     /* LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON */
  { 0x000001E2, 0x000000C6, 0x00000304 },     /* LATIN CAPITAL LETTER AE WITH MACRON */
  { 0x000001E3, 0x000000E6, 0x00000304 },     /* LATIN SMALL LETTER AE WITH MACRON */
  { 0x000001E6, 0x00000047, 0x0000030C },     /* LATIN CAPITAL LETTER G WITH CARON */
  { 0x000001E7, 0x00000067, 0x0000030C },     /* LATIN SMALL LETTER G WITH CARON */
  { 0x000001E8, 0x0000004B, 0x0000030C },     /* LATIN CAPITAL LETTER K WITH CARON */
  { 0x000001E9, 0x0000006B, 0x0000030C },     /* LATIN SMALL LETTER K WITH CARON */
  { 0x000001EA, 0x0000004F, 0x00000328 },     /* LATIN CAPITAL LETTER O WITH OGONEK */
  { 0x000001EB, 0x0000006F, 0x00000328 },     /* LATIN SMALL LETTER O WITH OGONEK */
  { 0x000001EC, 0x000001EA, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH OGONEK AND MACRON */
  { 0x000001ED, 0x000001EB, 0x00000304 },     /* LATIN SMALL LETTER O WITH OGONEK AND MACRON */
  { 0x000001EE, 0x000001B7, 0x0000030C },     /* LATIN CAPITAL LETTER EZH WITH CARON */
  { 0x000001EF, 0x00000292, 0x0000030C },     /* LATIN SMALL LETTER EZH WITH CARON */
  { 0x000001F0, 0x0000006A, 0x0000030C },     /* LATIN SMALL LETTER J WITH CARON */
  { 0x000001F4, 0x00000047, 0x00000301 },     /* LATIN CAPITAL LETTER G WITH ACUTE */
  { 0x000001F5, 0x00000067, 0x00000301 },     /* LATIN SMALL LETTER G WITH ACUTE */
  { 0x000001F8, 0x0000004E, 0x00000300 },     /* LATIN CAPITAL LETTER N WITH GRAVE */
  { 0x000001F9, 0x0000006E, 0x00000300 },     /* LATIN SMALL LETTER N WITH GRAVE */
  { 0x000001FA, 0x000000C5, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE */
  { 0x000001FB, 0x000000E5, 0x00000301 },     /* LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE */
  { 0x000001FC, 0x000000C6, 0x00000301 },     /* LATIN CAPITAL LETTER AE WITH ACUTE */
  { 0x000001FD, 0x000000E6, 0x00000301 },     /* LATIN SMALL LETTER AE WITH ACUTE */
  { 0x000001FE, 0x000000D8, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH STROKE AND ACUTE */
  { 0x000001FF, 0x000000F8, 0x00000301 },     /* LATIN SMALL LETTER O WITH STROKE AND ACUTE */
  { 0x00000200, 0x00000041, 0x0000030F },     /* LATIN CAPITAL LETTER A WITH DOUBLE GRAVE */
  { 0x00000201, 0x00000061, 0x0000030F },     /* LATIN SMALL LETTER A WITH DOUBLE GRAVE */
  { 0x00000202, 0x00000041, 0x00000311 },     /* LATIN CAPITAL LETTER A WITH INVERTED BREVE */
  { 0x00000203, 0x00000061, 0x00000311 },     /* LATIN SMALL LETTER A WITH INVERTED BREVE */
  { 0x00000204, 0x00000045, 0x0000030F },     /* LATIN CAPITAL LETTER E WITH DOUBLE GRAVE */
  { 0x00000205, 0x00000065, 0x0000030F },     /* LATIN SMALL LETTER E WITH DOUBLE GRAVE */
  { 0x00000206, 0x00000045, 0x00000311 },     /* LATIN CAPITAL LETTER E WITH INVERTED BREVE */
  { 0x00000207, 0x00000065, 0x00000311 },     /* LATIN SMALL LETTER E WITH INVERTED BREVE */
  { 0x00000208, 0x00000049, 0x0000030F },     /* LATIN CAPITAL LETTER I WITH DOUBLE GRAVE */
  { 0x00000209, 0x00000069, 0x0000030F },     /* LATIN SMALL LETTER I WITH DOUBLE GRAVE */
  { 0x0000020A, 0x00000049, 0x00000311 },     /* LATIN CAPITAL LETTER I WITH INVERTED BREVE */
  { 0x0000020B, 0x00000069, 0x00000311 },     /* LATIN SMALL LETTER I WITH INVERTED BREVE */
  { 0x0000020C, 0x0000004F, 0x0000030F },     /* LATIN CAPITAL LETTER O WITH DOUBLE GRAVE */
  { 0x0000020D, 0x0000006F, 0x0000030F },     /* LATIN SMALL LETTER O WITH DOUBLE GRAVE */
  { 0x0000020E, 0x0000004F, 0x00000311 },     /* LATIN CAPITAL LETTER O WITH INVERTED BREVE */
  { 0x0000020F, 0x0000006F, 0x00000311 },     /* LATIN SMALL LETTER O WITH INVERTED BREVE */
  { 0x00000210, 0x00000052, 0x0000030F },     /* LATIN CAPITAL LETTER R WITH DOUBLE GRAVE */
  { 0x00000211, 0x00000072, 0x0000030F },     /* LATIN SMALL LETTER R WITH DOUBLE GRAVE */
  { 0x00000212, 0x00000052, 0x00000311 },     /* LATIN CAPITAL LETTER R WITH INVERTED BREVE */
  { 0x00000213, 0x00000072, 0x00000311 },     /* LATIN SMALL LETTER R WITH INVERTED BREVE */
  { 0x00000214, 0x00000055, 0x0000030F },     /* LATIN CAPITAL LETTER U WITH DOUBLE GRAVE */
  { 0x00000215, 0x00000075, 0x0000030F },     /* LATIN SMALL LETTER U WITH DOUBLE GRAVE */
  { 0x00000216, 0x00000055, 0x00000311 },     /* LATIN CAPITAL LETTER U WITH INVERTED BREVE */
  { 0x00000217, 0x00000075, 0x00000311 },     /* LATIN SMALL LETTER U WITH INVERTED BREVE */
  { 0x00000218, 0x00000053, 0x00000326 },     /* LATIN CAPITAL LETTER S WITH COMMA BELOW */
  { 0x00000219, 0x00000073, 0x00000326 },     /* LATIN SMALL LETTER S WITH COMMA BELOW */
  { 0x0000021A, 0x00000054, 0x00000326 },     /* LATIN CAPITAL LETTER T WITH COMMA BELOW */
  { 0x0000021B, 0x00000074, 0x00000326 },     /* LATIN SMALL LETTER T WITH COMMA BELOW */
  { 0x0000021E, 0x00000048, 0x0000030C },     /* LATIN CAPITAL LETTER H WITH CARON */
  { 0x0000021F, 0x00000068, 0x0000030C },     /* LATIN SMALL LETTER H WITH CARON */
  { 0x00000226, 0x00000041, 0x00000307 },     /* LATIN CAPITAL LETTER A WITH DOT ABOVE */
  { 0x00000227, 0x00000061, 0x00000307 },     /* LATIN SMALL LETTER A WITH DOT ABOVE */
  { 0x00000228, 0x00000045, 0x00000327 },     /* LATIN CAPITAL LETTER E WITH CEDILLA */
  { 0x00000229, 0x00000065, 0x00000327 },     /* LATIN SMALL LETTER E WITH CEDILLA */
  { 0x0000022A, 0x000000D6, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON */
  { 0x0000022B, 0x000000F6, 0x00000304 },     /* LATIN SMALL LETTER O WITH DIAERESIS AND MACRON */
  { 0x0000022C, 0x000000D5, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH TILDE AND MACRON */
  { 0x0000022D, 0x000000F5, 0x00000304 },     /* LATIN SMALL LETTER O WITH TILDE AND MACRON */
  { 0x0000022E, 0x0000004F, 0x00000307 },     /* LATIN CAPITAL LETTER O WITH DOT ABOVE */
  { 0x0000022F, 0x0000006F, 0x00000307 },     /* LATIN SMALL LETTER O WITH DOT ABOVE */
  { 0x00000230, 0x0000022E, 0x00000304 },     /* LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON */
  { 0x00000231, 0x0000022F, 0x00000304 },     /* LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON */
  { 0x00000232, 0x00000059, 0x00000304 },     /* LATIN CAPITAL LETTER Y WITH MACRON */
  { 0x00000233, 0x00000079, 0x00000304 },     /* LATIN SMALL LETTER Y WITH MACRON */
  { 0x00000344, 0x00000308, 0x00000301 },     /* COMBINING GREEK DIALYTIKA TONOS */
  { 0x00000385, 0x000000A8, 0x00000301 },     /* GREEK DIALYTIKA TONOS */
  { 0x00000386, 0x00000391, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH TONOS */
  { 0x00000388, 0x00000395, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH TONOS */
  { 0x00000389, 0x00000397, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH TONOS */
  { 0x0000038A, 0x00000399, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH TONOS */
  { 0x0000038C, 0x0000039F, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH TONOS */
  { 0x0000038E, 0x000003A5, 0x00000301 },     /* GREEK CAPITAL LETTER UPSILON WITH TONOS */
  { 0x0000038F, 0x000003A9, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH TONOS */
  { 0x00000390, 0x000003CA, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS */
  { 0x000003AA, 0x00000399, 0x00000308 },     /* GREEK CAPITAL LETTER IOTA WITH DIALYTIKA */
  { 0x000003AB, 0x000003A5, 0x00000308 },     /* GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA */
  { 0x000003AC, 0x000003B1, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH TONOS */
  { 0x000003AD, 0x000003B5, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH TONOS */
  { 0x000003AE, 0x000003B7, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH TONOS */
  { 0x000003AF, 0x000003B9, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH TONOS */
  { 0x000003B0, 0x000003CB, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS */
  { 0x000003CA, 0x000003B9, 0x00000308 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA */
  { 0x000003CB, 0x000003C5, 0x00000308 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA */
  { 0x000003CC, 0x000003BF, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH TONOS */
  { 0x000003CD, 0x000003C5, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH TONOS */
  { 0x000003CE, 0x000003C9, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH TONOS */
  { 0x000003D3, 0x000003D2, 0x00000301 },     /* GREEK UPSILON WITH ACUTE AND HOOK SYMBOL */
  { 0x000003D4, 0x000003D2, 0x00000308 },     /* GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL */
  { 0x00000400, 0x00000415, 0x00000300 },     /* CYRILLIC CAPITAL LETTER IE WITH GRAVE */
  { 0x00000401, 0x00000415, 0x00000308 },     /* CYRILLIC CAPITAL LETTER IO */
  { 0x00000403, 0x00000413, 0x00000301 },     /* CYRILLIC CAPITAL LETTER GJE */
  { 0x00000407, 0x00000406, 0x00000308 },     /* CYRILLIC CAPITAL LETTER YI */
  { 0x0000040C, 0x0000041A, 0x00000301 },     /* CYRILLIC CAPITAL LETTER KJE */
  { 0x0000040D, 0x00000418, 0x00000300 },     /* CYRILLIC CAPITAL LETTER I WITH GRAVE */
  { 0x0000040E, 0x00000423, 0x00000306 },     /* CYRILLIC CAPITAL LETTER SHORT U */
  { 0x00000419, 0x00000418, 0x00000306 },     /* CYRILLIC CAPITAL LETTER SHORT I */
  { 0x00000439, 0x00000438, 0x00000306 },     /* CYRILLIC SMALL LETTER SHORT I */
  { 0x00000450, 0x00000435, 0x00000300 },     /* CYRILLIC SMALL LETTER IE WITH GRAVE */
  { 0x00000451, 0x00000435, 0x00000308 },     /* CYRILLIC SMALL LETTER IO */
  { 0x00000453, 0x00000433, 0x00000301 },     /* CYRILLIC SMALL LETTER GJE */
  { 0x00000457, 0x00000456, 0x00000308 },     /* CYRILLIC SMALL LETTER YI */
  { 0x0000045C, 0x0000043A, 0x00000301 },     /* CYRILLIC SMALL LETTER KJE */
  { 0x0000045D, 0x00000438, 0x00000300 },     /* CYRILLIC SMALL LETTER I WITH GRAVE */
  { 0x0000045E, 0x00000443, 0x00000306 },     /* CYRILLIC SMALL LETTER SHORT U */
  { 0x00000476, 0x00000474, 0x0000030F },     /* CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  { 0x00000477, 0x00000475, 0x0000030F },     /* CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT */
  { 0x000004C1, 0x00000416, 0x00000306 },     /* CYRILLIC CAPITAL LETTER ZHE WITH BREVE */
  { 0x000004C2, 0x00000436, 0x00000306 },     /* CYRILLIC SMALL LETTER ZHE WITH BREVE */
  { 0x000004D0, 0x00000410, 0x00000306 },     /* CYRILLIC CAPITAL LETTER A WITH BREVE */
  { 0x000004D1, 0x00000430, 0x00000306 },     /* CYRILLIC SMALL LETTER A WITH BREVE */
  { 0x000004D2, 0x00000410, 0x00000308 },     /* CYRILLIC CAPITAL LETTER A WITH DIAERESIS */
  { 0x000004D3, 0x00000430, 0x00000308 },     /* CYRILLIC SMALL LETTER A WITH DIAERESIS */
  { 0x000004D6, 0x00000415, 0x00000306 },     /* CYRILLIC CAPITAL LETTER IE WITH BREVE */
  { 0x000004D7, 0x00000435, 0x00000306 },     /* CYRILLIC SMALL LETTER IE WITH BREVE */
  { 0x000004DA, 0x000004D8, 0x00000308 },     /* CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS */
  { 0x000004DB, 0x000004D9, 0x00000308 },     /* CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS */
  { 0x000004DC, 0x00000416, 0x00000308 },     /* CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS */
  { 0x000004DD, 0x00000436, 0x00000308 },     /* CYRILLIC SMALL LETTER ZHE WITH DIAERESIS */
  { 0x000004DE, 0x00000417, 0x00000308 },     /* CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS */
  { 0x000004DF, 0x00000437, 0x00000308 },     /* CYRILLIC SMALL LETTER ZE WITH DIAERESIS */
  { 0x000004E2, 0x00000418, 0x00000304 },     /* CYRILLIC CAPITAL LETTER I WITH MACRON */
  { 0x000004E3, 0x00000438, 0x00000304 },     /* CYRILLIC SMALL LETTER I WITH MACRON */
  { 0x000004E4, 0x00000418, 0x00000308 },     /* CYRILLIC CAPITAL LETTER I WITH DIAERESIS */
  { 0x000004E5, 0x00000438, 0x00000308 },     /* CYRILLIC SMALL LETTER I WITH DIAERESIS */
  { 0x000004E6, 0x0000041E, 0x00000308 },     /* CYRILLIC CAPITAL LETTER O WITH DIAERESIS */
  { 0x000004E7, 0x0000043E, 0x00000308 },     /* CYRILLIC SMALL LETTER O WITH DIAERESIS */
  { 0x000004EA, 0x000004E8, 0x00000308 },     /* CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS */
  { 0x000004EB, 0x000004E9, 0x00000308 },     /* CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS */
  { 0x000004EC, 0x0000042D, 0x00000308 },     /* CYRILLIC CAPITAL LETTER E WITH DIAERESIS */
  { 0x000004ED, 0x0000044D, 0x00000308 },     /* CYRILLIC SMALL LETTER E WITH DIAERESIS */
  { 0x000004EE, 0x00000423, 0x00000304 },     /* CYRILLIC CAPITAL LETTER U WITH MACRON */
  { 0x000004EF, 0x00000443, 0x00000304 },     /* CYRILLIC SMALL LETTER U WITH MACRON */
  { 0x000004F0, 0x00000423, 0x00000308 },     /* CYRILLIC CAPITAL LETTER U WITH DIAERESIS */
  { 0x000004F1, 0x00000443, 0x00000308 },     /* CYRILLIC SMALL LETTER U WITH DIAERESIS */
  { 0x000004F2, 0x00000423, 0x0000030B },     /* CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE */
  { 0x000004F3, 0x00000443, 0x0000030B },     /* CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE */
  { 0x000004F4, 0x00000427, 0x00000308 },     /* CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS */
  { 0x000004F5, 0x00000447, 0x00000308 },     /* CYRILLIC SMALL LETTER CHE WITH DIAERESIS */
  { 0x000004F8, 0x0000042B, 0x00000308 },     /* CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS */
  { 0x000004F9, 0x0000044B, 0x00000308 },     /* CYRILLIC SMALL LETTER YERU WITH DIAERESIS */
  { 0x00000622, 0x00000627, 0x00000653 },     /* ARABIC LETTER ALEF WITH MADDA ABOVE */
  { 0x00000623, 0x00000627, 0x00000654 },     /* ARABIC LETTER ALEF WITH HAMZA ABOVE */
  { 0x00000624, 0x00000648, 0x00000654 },     /* ARABIC LETTER WAW WITH HAMZA ABOVE */
  { 0x00000625, 0x00000627, 0x00000655 },     /* ARABIC LETTER ALEF WITH HAMZA BELOW */
  { 0x00000626, 0x0000064A, 0x00000654 },     /* ARABIC LETTER YEH WITH HAMZA ABOVE */
  { 0x000006C0, 0x000006D5, 0x00000654 },     /* ARABIC LETTER HEH WITH YEH ABOVE */
  { 0x000006C2, 0x000006C1, 0x00000654 },     /* ARABIC LETTER HEH GOAL WITH HAMZA ABOVE */
  { 0x000006D3, 0x000006D2, 0x00000654 },     /* ARABIC LETTER YEH BARREE WITH HAMZA ABOVE */
  { 0x00000929, 0x00000928, 0x0000093C },     /* DEVANAGARI LETTER NNNA */
  { 0x00000931, 0x00000930, 0x0000093C },     /* DEVANAGARI LETTER RRA */
  { 0x00000934, 0x00000933, 0x0000093C },     /* DEVANAGARI LETTER LLLA */
  { 0x00000958, 0x00000915, 0x0000093C },     /* DEVANAGARI LETTER QA */
  { 0x00000959, 0x00000916, 0x0000093C },     /* DEVANAGARI LETTER KHHA */
  { 0x0000095A, 0x00000917, 0x0000093C },     /* DEVANAGARI LETTER GHHA */
  { 0x0000095B, 0x0000091C, 0x0000093C },     /* DEVANAGARI LETTER ZA */
  { 0x0000095C, 0x00000921, 0x0000093C },     /* DEVANAGARI LETTER DDDHA */
  { 0x0000095D, 0x00000922, 0x0000093C },     /* DEVANAGARI LETTER RHA */
  { 0x0000095E, 0x0000092B, 0x0000093C },     /* DEVANAGARI LETTER FA */
  { 0x0000095F, 0x0000092F, 0x0000093C },     /* DEVANAGARI LETTER YYA */
  { 0x000009CB, 0x000009C7, 0x000009BE },     /* BENGALI VOWEL SIGN O */
  { 0x000009CC, 0x000009C7, 0x000009D7 },     /* BENGALI VOWEL SIGN AU */
  { 0x000009DC, 0x000009A1, 0x000009BC },     /* BENGALI LETTER RRA */
  { 0x000009DD, 0x000009A2, 0x000009BC },     /* BENGALI LETTER RHA */
  { 0x000009DF, 0x000009AF, 0x000009BC },     /* BENGALI LETTER YYA */
  { 0x00000A33, 0x00000A32, 0x00000A3C },     /* GURMUKHI LETTER LLA */
  { 0x00000A36, 0x00000A38, 0x00000A3C },     /* GURMUKHI LETTER SHA */
  { 0x00000A59, 0x00000A16, 0x00000A3C },     /* GURMUKHI LETTER KHHA */
  { 0x00000A5A, 0x00000A17, 0x00000A3C },     /* GURMUKHI LETTER GHHA */
  { 0x00000A5B, 0x00000A1C, 0x00000A3C },     /* GURMUKHI LETTER ZA */
  { 0x00000A5E, 0x00000A2B, 0x00000A3C },     /* GURMUKHI LETTER FA */
  { 0x00000B48, 0x00000B47, 0x00000B56 },     /* ORIYA VOWEL SIGN AI */
  { 0x00000B4B, 0x00000B47, 0x00000B3E },     /* ORIYA VOWEL SIGN O */
  { 0x00000B4C, 0x00000B47, 0x00000B57 },     /* ORIYA VOWEL SIGN AU */
  { 0x00000B5C, 0x00000B21, 0x00000B3C },     /* ORIYA LETTER RRA */
  { 0x00000B5D, 0x00000B22, 0x00000B3C },     /* ORIYA LETTER RHA */
  { 0x00000B94, 0x00000B92, 0x00000BD7 },     /* TAMIL LETTER AU */
  { 0x00000BCA, 0x00000BC6, 0x00000BBE },     /* TAMIL VOWEL SIGN O */
  { 0x00000BCB, 0x00000BC7, 0x00000BBE },     /* TAMIL VOWEL SIGN OO */
  { 0x00000BCC, 0x00000BC6, 0x00000BD7 },     /* TAMIL VOWEL SIGN AU */
  { 0x00000C48, 0x00000C46, 0x00000C56 },     /* TELUGU VOWEL SIGN AI */
  { 0x00000CC0, 0x00000CBF, 0x00000CD5 },     /* KANNADA VOWEL SIGN II */
  { 0x00000CC7, 0x00000CC6, 0x00000CD5 },     /* KANNADA VOWEL SIGN EE */
  { 0x00000CC8, 0x00000CC6, 0x00000CD6 },     /* KANNADA VOWEL SIGN AI */
  { 0x00000CCA, 0x00000CC6, 0x00000CC2 },     /* KANNADA VOWEL SIGN O */
  { 0x00000CCB, 0x00000CCA, 0x00000CD5 },     /* KANNADA VOWEL SIGN OO */
  { 0x00000D4A, 0x00000D46, 0x00000D3E },     /* MALAYALAM VOWEL SIGN O */
  { 0x00000D4B, 0x00000D47, 0x00000D3E },     /* MALAYALAM VOWEL SIGN OO */
  { 0x00000D4C, 0x00000D46, 0x00000D57 },     /* MALAYALAM VOWEL SIGN AU */
  { 0x00000DDA, 0x00000DD9, 0x00000DCA },     /* SINHALA VOWEL SIGN DIGA KOMBUVA */
  { 0x00000DDC, 0x00000DD9, 0x00000DCF },     /* SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA */
  { 0x00000DDD, 0x00000DDC, 0x00000DCA },     /* SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA */
  { 0x00000DDE, 0x00000DD9, 0x00000DDF },     /* SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA */
  { 0x00000F43, 0x00000F42, 0x00000FB7 },     /* TIBETAN LETTER GHA */
  { 0x00000F4D, 0x00000F4C, 0x00000FB7 },     /* TIBETAN LETTER DDHA */
  { 0x00000F52, 0x00000F51, 0x00000FB7 },     /* TIBETAN LETTER DHA */
  { 0x00000F57, 0x00000F56, 0x00000FB7 },     /* TIBETAN LETTER BHA */
  { 0x00000F5C, 0x00000F5B, 0x00000FB7 },     /* TIBETAN LETTER DZHA */
  { 0x00000F69, 0x00000F40, 0x00000FB5 },     /* TIBETAN LETTER KSSA */
  { 0x00000F73, 0x00000F71, 0x00000F72 },     /* TIBETAN VOWEL SIGN II */
  { 0x00000F75, 0x00000F71, 0x00000F74 },     /* TIBETAN VOWEL SIGN UU */
  { 0x00000F76, 0x00000FB2, 0x00000F80 },     /* TIBETAN VOWEL SIGN VOCALIC R */
  { 0x00000F78, 0x00000FB3, 0x00000F80 },     /* TIBETAN VOWEL SIGN VOCALIC L */
  { 0x00000F81, 0x00000F71, 0x00000F80 },     /* TIBETAN VOWEL SIGN REVERSED II */
  { 0x00000F93, 0x00000F92, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER GHA */
  { 0x00000F9D, 0x00000F9C, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DDHA */
  { 0x00000FA2, 0x00000FA1, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DHA */
  { 0x00000FA7, 0x00000FA6, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER BHA */
  { 0x00000FAC, 0x00000FAB, 0x00000FB7 },     /* TIBETAN SUBJOINED LETTER DZHA */
  { 0x00000FB9, 0x00000F90, 0x00000FB5 },     /* TIBETAN SUBJOINED LETTER KSSA */
  { 0x00001026, 0x00001025, 0x0000102E },     /* MYANMAR LETTER UU */
  { 0x00001B06, 0x00001B05, 0x00001B35 },     /* BALINESE LETTER AKARA TEDUNG */
  { 0x00001B08, 0x00001B07, 0x00001B35 },     /* BALINESE LETTER IKARA TEDUNG */
  { 0x00001B0A, 0x00001B09, 0x00001B35 },     /* BALINESE LETTER UKARA TEDUNG */
  { 0x00001B0C, 0x00001B0B, 0x00001B35 },     /* BALINESE LETTER RA REPA TEDUNG */
  { 0x00001B0E, 0x00001B0D, 0x00001B35 },     /* BALINESE LETTER LA LENGA TEDUNG */
  { 0x00001B12, 0x00001B11, 0x00001B35 },     /* BALINESE LETTER OKARA TEDUNG */
  { 0x00001B3B, 0x00001B3A, 0x00001B35 },     /* BALINESE VOWEL SIGN RA REPA TEDUNG */
  { 0x00001B3D, 0x00001B3C, 0x00001B35 },     /* BALINESE VOWEL SIGN LA LENGA TEDUNG */
  { 0x00001B40, 0x00001B3E, 0x00001B35 },     /* BALINESE VOWEL SIGN TALING TEDUNG */
  { 0x00001B41, 0x00001B3F, 0x00001B35 },     /* BALINESE VOWEL SIGN TALING REPA TEDUNG */
  { 0x00001B43, 0x00001B42, 0x00001B35 },     /* BALINESE VOWEL SIGN PEPET TEDUNG */
  { 0x00001E00, 0x00000041, 0x00000325 },     /* LATIN CAPITAL LETTER A WITH RING BELOW */
  { 0x00001E01, 0x00000061, 0x00000325 },     /* LATIN SMALL LETTER A WITH RING BELOW */
  { 0x00001E02, 0x00000042, 0x00000307 },     /* LATIN CAPITAL LETTER B WITH DOT ABOVE */
  { 0x00001E03, 0x00000062, 0x00000307 },     /* LATIN SMALL LETTER B WITH DOT ABOVE */
  { 0x00001E04, 0x00000042, 0x00000323 },     /* LATIN CAPITAL LETTER B WITH DOT BELOW */
  { 0x00001E05, 0x00000062, 0x00000323 },     /* LATIN SMALL LETTER B WITH DOT BELOW */
  { 0x00001E06, 0x00000042, 0x00000331 },     /* LATIN CAPITAL LETTER B WITH LINE BELOW */
  { 0x00001E07, 0x00000062, 0x00000331 },     /* LATIN SMALL LETTER B WITH LINE BELOW */
  { 0x00001E08, 0x000000C7, 0x00000301 },     /* LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE */
  { 0x00001E09, 0x000000E7, 0x00000301 },     /* LATIN SMALL LETTER C WITH CEDILLA AND ACUTE */
  { 0x00001E0A, 0x00000044, 0x00000307 },     /* LATIN CAPITAL LETTER D WITH DOT ABOVE */
  { 0x00001E0B, 0x00000064, 0x00000307 },     /* LATIN SMALL LETTER D WITH DOT ABOVE */
  { 0x00001E0C, 0x00000044, 0x00000323 },     /* LATIN CAPITAL LETTER D WITH DOT BELOW */
  { 0x00001E0D, 0x00000064, 0x00000323 },     /* LATIN SMALL LETTER D WITH DOT BELOW */
  { 0x00001E0E, 0x00000044, 0x00000331 },     /* LATIN CAPITAL LETTER D WITH LINE BELOW */
  { 0x00001E0F, 0x00000064, 0x00000331 },     /* LATIN SMALL LETTER D WITH LINE BELOW */
  { 0x00001E10, 0x00000044, 0x00000327 },     /* LATIN CAPITAL LETTER D WITH CEDILLA */
  { 0x00001E11, 0x00000064, 0x00000327 },     /* LATIN SMALL LETTER D WITH CEDILLA */
  { 0x00001E12, 0x00000044, 0x0000032D },     /* LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW */
  { 0x00001E13, 0x00000064, 0x0000032D },     /* LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW */
  { 0x00001E14, 0x00000112, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH MACRON AND GRAVE */
  { 0x00001E15, 0x00000113, 0x00000300 },     /* LATIN SMALL LETTER E WITH MACRON AND GRAVE */
  { 0x00001E16, 0x00000112, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH MACRON AND ACUTE */
  { 0x00001E17, 0x00000113, 0x00000301 },     /* LATIN SMALL LETTER E WITH MACRON AND ACUTE */
  { 0x00001E18, 0x00000045, 0x0000032D },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW */
  { 0x00001E19, 0x00000065, 0x0000032D },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW */
  { 0x00001E1A, 0x00000045, 0x00000330 },     /* LATIN CAPITAL LETTER E WITH TILDE BELOW */
  { 0x00001E1B, 0x00000065, 0x00000330 },     /* LATIN SMALL LETTER E WITH TILDE BELOW */
  { 0x00001E1C, 0x00000228, 0x00000306 },     /* LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE */
  { 0x00001E1D, 0x00000229, 0x00000306 },     /* LATIN SMALL LETTER E WITH CEDILLA AND BREVE */
  { 0x00001E1E, 0x00000046, 0x00000307 },     /* LATIN CAPITAL LETTER F WITH DOT ABOVE */
  { 0x00001E1F, 0x00000066, 0x00000307 },     /* LATIN SMALL LETTER F WITH DOT ABOVE */
  { 0x00001E20, 0x00000047, 0x00000304 },     /* LATIN CAPITAL LETTER G WITH MACRON */
  { 0x00001E21, 0x00000067, 0x00000304 },     /* LATIN SMALL LETTER G WITH MACRON */
  { 0x00001E22, 0x00000048, 0x00000307 },     /* LATIN CAPITAL LETTER H WITH DOT ABOVE */
  { 0x00001E23, 0x00000068, 0x00000307 },     /* LATIN SMALL LETTER H WITH DOT ABOVE */
  { 0x00001E24, 0x00000048, 0x00000323 },     /* LATIN CAPITAL LETTER H WITH DOT BELOW */
  { 0x00001E25, 0x00000068, 0x00000323 },     /* LATIN SMALL LETTER H WITH DOT BELOW */
  { 0x00001E26, 0x00000048, 0x00000308 },     /* LATIN CAPITAL LETTER H WITH DIAERESIS */
  { 0x00001E27, 0x00000068, 0x00000308 },     /* LATIN SMALL LETTER H WITH DIAERESIS */
  { 0x00001E28, 0x00000048, 0x00000327 },     /* LATIN CAPITAL LETTER H WITH CEDILLA */
  { 0x00001E29, 0x00000068, 0x00000327 },     /* LATIN SMALL LETTER H WITH CEDILLA */
  { 0x00001E2A, 0x00000048, 0x0000032E },     /* LATIN CAPITAL LETTER H WITH BREVE BELOW */
  { 0x00001E2B, 0x00000068, 0x0000032E },     /* LATIN SMALL LETTER H WITH BREVE BELOW */
  { 0x00001E2C, 0x00000049, 0x00000330 },     /* LATIN CAPITAL LETTER I WITH TILDE BELOW */
  { 0x00001E2D, 0x00000069, 0x00000330 },     /* LATIN SMALL LETTER I WITH TILDE BELOW */
  { 0x00001E2E, 0x000000CF, 0x00000301 },     /* LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE */
  { 0x00001E2F, 0x000000EF, 0x00000301 },     /* LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE */
  { 0x00001E30, 0x0000004B, 0x00000301 },     /* LATIN CAPITAL LETTER K WITH ACUTE */
  { 0x00001E31, 0x0000006B, 0x00000301 },     /* LATIN SMALL LETTER K WITH ACUTE */
  { 0x00001E32, 0x0000004B, 0x00000323 },     /* LATIN CAPITAL LETTER K WITH DOT BELOW */
  { 0x00001E33, 0x0000006B, 0x00000323 },     /* LATIN SMALL LETTER K WITH DOT BELOW */
  { 0x00001E34, 0x0000004B, 0x00000331 },     /* LATIN CAPITAL LETTER K WITH LINE BELOW */
  { 0x00001E35, 0x0000006B, 0x00000331 },     /* LATIN SMALL LETTER K WITH LINE BELOW */
  { 0x00001E36, 0x0000004C, 0x00000323 },     /* LATIN CAPITAL LETTER L WITH DOT BELOW */
  { 0x00001E37, 0x0000006C, 0x00000323 },     /* LATIN SMALL LETTER L WITH DOT BELOW */
  { 0x00001E38, 0x00001E36, 0x00000304 },     /* LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON */
  { 0x00001E39, 0x00001E37, 0x00000304 },     /* LATIN SMALL LETTER L WITH DOT BELOW AND MACRON */
  { 0x00001E3A, 0x0000004C, 0x00000331 },     /* LATIN CAPITAL LETTER L WITH LINE BELOW */
  { 0x00001E3B, 0x0000006C, 0x00000331 },     /* LATIN SMALL LETTER L WITH LINE BELOW */
  { 0x00001E3C, 0x0000004C, 0x0000032D },     /* LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW */
  { 0x00001E3D, 0x0000006C, 0x0000032D },     /* LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW */
  { 0x00001E3E, 0x0000004D, 0x00000301 },     /* LATIN CAPITAL LETTER M WITH ACUTE */
  { 0x00001E3F, 0x0000006D, 0x00000301 },     /* LATIN SMALL LETTER M WITH ACUTE */
  { 0x00001E40, 0x0000004D, 0x00000307 },     /* LATIN CAPITAL LETTER M WITH DOT ABOVE */
  { 0x00001E41, 0x0000006D, 0x00000307 },     /* LATIN SMALL LETTER M WITH DOT ABOVE */
  { 0x00001E42, 0x0000004D, 0x00000323 },     /* LATIN CAPITAL LETTER M WITH DOT BELOW */
  { 0x00001E43, 0x0000006D, 0x00000323 },     /* LATIN SMALL LETTER M WITH DOT BELOW */
  { 0x00001E44, 0x0000004E, 0x00000307 },     /* LATIN CAPITAL LETTER N WITH DOT ABOVE */
  { 0x00001E45, 0x0000006E, 0x00000307 },     /* LATIN SMALL LETTER N WITH DOT ABOVE */
  { 0x00001E46, 0x0000004E, 0x00000323 },     /* LATIN CAPITAL LETTER N WITH DOT BELOW */
  { 0x00001E47, 0x0000006E, 0x00000323 },     /* LATIN SMALL LETTER N WITH DOT BELOW */
  { 0x00001E48, 0x0000004E, 0x00000331 },     /* LATIN CAPITAL LETTER N WITH LINE BELOW */
  { 0x00001E49, 0x0000006E, 0x00000331 },     /* LATIN SMALL LETTER N WITH LINE BELOW */
  { 0x00001E4A, 0x0000004E, 0x0000032D },     /* LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW */
  { 0x00001E4B, 0x0000006E, 0x0000032D },     /* LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW */
  { 0x00001E4C, 0x000000D5, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH TILDE AND ACUTE */
  { 0x00001E4D, 0x000000F5, 0x00000301 },     /* LATIN SMALL LETTER O WITH TILDE AND ACUTE */
  { 0x00001E4E, 0x000000D5, 0x00000308 },     /* LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS */
  { 0x00001E4F, 0x000000F5, 0x00000308 },     /* LATIN SMALL LETTER O WITH TILDE AND DIAERESIS */
  { 0x00001E50, 0x0000014C, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH MACRON AND GRAVE */
  { 0x00001E51, 0x0000014D, 0x00000300 },     /* LATIN SMALL LETTER O WITH MACRON AND GRAVE */
  { 0x00001E52, 0x0000014C, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH MACRON AND ACUTE */
  { 0x00001E53, 0x0000014D, 0x00000301 },     /* LATIN SMALL LETTER O WITH MACRON AND ACUTE */
  { 0x00001E54, 0x00000050, 0x00000301 },     /* LATIN CAPITAL LETTER P WITH ACUTE */
  { 0x00001E55, 0x00000070, 0x00000301 },     /* LATIN SMALL LETTER P WITH ACUTE */
  { 0x00001E56, 0x00000050, 0x00000307 },     /* LATIN CAPITAL LETTER P WITH DOT ABOVE */
  { 0x00001E57, 0x00000070, 0x00000307 },     /* LATIN SMALL LETTER P WITH DOT ABOVE */
  { 0x00001E58, 0x00000052, 0x00000307 },     /* LATIN CAPITAL LETTER R WITH DOT ABOVE */
  { 0x00001E59, 0x00000072, 0x00000307 },     /* LATIN SMALL LETTER R WITH DOT ABOVE */
  { 0x00001E5A, 0x00000052, 0x00000323 },     /* LATIN CAPITAL LETTER R WITH DOT BELOW */
  { 0x00001E5B, 0x00000072, 0x00000323 },     /* LATIN SMALL LETTER R WITH DOT BELOW */
  { 0x00001E5C, 0x00001E5A, 0x00000304 },     /* LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON */
  { 0x00001E5D, 0x00001E5B, 0x00000304 },     /* LATIN SMALL LETTER R WITH DOT BELOW AND MACRON */
  { 0x00001E5E, 0x00000052, 0x00000331 },     /* LATIN CAPITAL LETTER R WITH LINE BELOW */
  { 0x00001E5F, 0x00000072, 0x00000331 },     /* LATIN SMALL LETTER R WITH LINE BELOW */
  { 0x00001E60, 0x00000053, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH DOT ABOVE */
  { 0x00001E61, 0x00000073, 0x00000307 },     /* LATIN SMALL LETTER S WITH DOT ABOVE */
  { 0x00001E62, 0x00000053, 0x00000323 },     /* LATIN CAPITAL LETTER S WITH DOT BELOW */
  { 0x00001E63, 0x00000073, 0x00000323 },     /* LATIN SMALL LETTER S WITH DOT BELOW */
  { 0x00001E64, 0x0000015A, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE */
  { 0x00001E65, 0x0000015B, 0x00000307 },     /* LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE */
  { 0x00001E66, 0x00000160, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE */
  { 0x00001E67, 0x00000161, 0x00000307 },     /* LATIN SMALL LETTER S WITH CARON AND DOT ABOVE */
  { 0x00001E68, 0x00001E62, 0x00000307 },     /* LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE */
  { 0x00001E69, 0x00001E63, 0x00000307 },     /* LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE */
  { 0x00001E6A, 0x00000054, 0x00000307 },     /* LATIN CAPITAL LETTER T WITH DOT ABOVE */
  { 0x00001E6B, 0x00000074, 0x00000307 },     /* LATIN SMALL LETTER T WITH DOT ABOVE */
  { 0x00001E6C, 0x00000054, 0x00000323 },     /* LATIN CAPITAL LETTER T WITH DOT BELOW */
  { 0x00001E6D, 0x00000074, 0x00000323 },     /* LATIN SMALL LETTER T WITH DOT BELOW */
  { 0x00001E6E, 0x00000054, 0x00000331 },     /* LATIN CAPITAL LETTER T WITH LINE BELOW */
  { 0x00001E6F, 0x00000074, 0x00000331 },     /* LATIN SMALL LETTER T WITH LINE BELOW */
  { 0x00001E70, 0x00000054, 0x0000032D },     /* LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW */
  { 0x00001E71, 0x00000074, 0x0000032D },     /* LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW */
  { 0x00001E72, 0x00000055, 0x00000324 },     /* LATIN CAPITAL LETTER U WITH DIAERESIS BELOW */
  { 0x00001E73, 0x00000075, 0x00000324 },     /* LATIN SMALL LETTER U WITH DIAERESIS BELOW */
  { 0x00001E74, 0x00000055, 0x00000330 },     /* LATIN CAPITAL LETTER U WITH TILDE BELOW */
  { 0x00001E75, 0x00000075, 0x00000330 },     /* LATIN SMALL LETTER U WITH TILDE BELOW */
  { 0x00001E76, 0x00000055, 0x0000032D },     /* LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW */
  { 0x00001E77, 0x00000075, 0x0000032D },     /* LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW */
  { 0x00001E78, 0x00000168, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH TILDE AND ACUTE */
  { 0x00001E79, 0x00000169, 0x00000301 },     /* LATIN SMALL LETTER U WITH TILDE AND ACUTE */
  { 0x00001E7A, 0x0000016A, 0x00000308 },     /* LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS */
  { 0x00001E7B, 0x0000016B, 0x00000308 },     /* LATIN SMALL LETTER U WITH MACRON AND DIAERESIS */
  { 0x00001E7C, 0x00000056, 0x00000303 },     /* LATIN CAPITAL LETTER V WITH TILDE */
  { 0x00001E7D, 0x00000076, 0x00000303 },     /* LATIN SMALL LETTER V WITH TILDE */
  { 0x00001E7E, 0x00000056, 0x00000323 },     /* LATIN CAPITAL LETTER V WITH DOT BELOW */
  { 0x00001E7F, 0x00000076, 0x00000323 },     /* LATIN SMALL LETTER V WITH DOT BELOW */
  { 0x00001E80, 0x00000057, 0x00000300 },     /* LATIN CAPITAL LETTER W WITH GRAVE */
  { 0x00001E81, 0x00000077, 0x00000300 },     /* LATIN SMALL LETTER W WITH GRAVE */
  { 0x00001E82, 0x00000057, 0x00000301 },     /* LATIN CAPITAL LETTER W WITH ACUTE */
  { 0x00001E83, 0x00000077, 0x00000301 },     /* LATIN SMALL LETTER W WITH ACUTE */
  { 0x00001E84, 0x00000057, 0x00000308 },     /* LATIN CAPITAL LETTER W WITH DIAERESIS */
  { 0x00001E85, 0x00000077, 0x00000308 },     /* LATIN SMALL LETTER W WITH DIAERESIS */
  { 0x00001E86, 0x00000057, 0x00000307 },     /* LATIN CAPITAL LETTER W WITH DOT ABOVE */
  { 0x00001E87, 0x00000077, 0x00000307 },     /* LATIN SMALL LETTER W WITH DOT ABOVE */
  { 0x00001E88, 0x00000057, 0x00000323 },     /* LATIN CAPITAL LETTER W WITH DOT BELOW */
  { 0x00001E89, 0x00000077, 0x00000323 },     /* LATIN SMALL LETTER W WITH DOT BELOW */
  { 0x00001E8A, 0x00000058, 0x00000307 },     /* LATIN CAPITAL LETTER X WITH DOT ABOVE */
  { 0x00001E8B, 0x00000078, 0x00000307 },     /* LATIN SMALL LETTER X WITH DOT ABOVE */
  { 0x00001E8C, 0x00000058, 0x00000308 },     /* LATIN CAPITAL LETTER X WITH DIAERESIS */
  { 0x00001E8D, 0x00000078, 0x00000308 },     /* LATIN SMALL LETTER X WITH DIAERESIS */
  { 0x00001E8E, 0x00000059, 0x00000307 },     /* LATIN CAPITAL LETTER Y WITH DOT ABOVE */
  { 0x00001E8F, 0x00000079, 0x00000307 },     /* LATIN SMALL LETTER Y WITH DOT ABOVE */
  { 0x00001E90, 0x0000005A, 0x00000302 },     /* LATIN CAPITAL LETTER Z WITH CIRCUMFLEX */
  { 0x00001E91, 0x0000007A, 0x00000302 },     /* LATIN SMALL LETTER Z WITH CIRCUMFLEX */
  { 0x00001E92, 0x0000005A, 0x00000323 },     /* LATIN CAPITAL LETTER Z WITH DOT BELOW */
  { 0x00001E93, 0x0000007A, 0x00000323 },     /* LATIN SMALL LETTER Z WITH DOT BELOW */
  { 0x00001E94, 0x0000005A, 0x00000331 },     /* LATIN CAPITAL LETTER Z WITH LINE BELOW */
  { 0x00001E95, 0x0000007A, 0x00000331 },     /* LATIN SMALL LETTER Z WITH LINE BELOW */
  { 0x00001E96, 0x00000068, 0x00000331 },     /* LATIN SMALL LETTER H WITH LINE BELOW */
  { 0x00001E97, 0x00000074, 0x00000308 },     /* LATIN SMALL LETTER T WITH DIAERESIS */
  { 0x00001E98, 0x00000077, 0x0000030A },     /* LATIN SMALL LETTER W WITH RING ABOVE */
  { 0x00001E99, 0x00000079, 0x0000030A },     /* LATIN SMALL LETTER Y WITH RING ABOVE */
  { 0x00001E9B, 0x0000017F, 0x00000307 },     /* LATIN SMALL LETTER LONG S WITH DOT ABOVE */
  { 0x00001EA0, 0x00000041, 0x00000323 },     /* LATIN CAPITAL LETTER A WITH DOT BELOW */
  { 0x00001EA1, 0x00000061, 0x00000323 },     /* LATIN SMALL LETTER A WITH DOT BELOW */
  { 0x00001EA2, 0x00000041, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH HOOK ABOVE */
  { 0x00001EA3, 0x00000061, 0x00000309 },     /* LATIN SMALL LETTER A WITH HOOK ABOVE */
  { 0x00001EA4, 0x000000C2, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EA5, 0x000000E2, 0x00000301 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EA6, 0x000000C2, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EA7, 0x000000E2, 0x00000300 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EA8, 0x000000C2, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001EA9, 0x000000E2, 0x00000309 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001EAA, 0x000000C2, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE */
  { 0x00001EAB, 0x000000E2, 0x00000303 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE */
  { 0x00001EAC, 0x00001EA0, 0x00000302 },     /* LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EAD, 0x00001EA1, 0x00000302 },     /* LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EAE, 0x00000102, 0x00000301 },     /* LATIN CAPITAL LETTER A WITH BREVE AND ACUTE */
  { 0x00001EAF, 0x00000103, 0x00000301 },     /* LATIN SMALL LETTER A WITH BREVE AND ACUTE */
  { 0x00001EB0, 0x00000102, 0x00000300 },     /* LATIN CAPITAL LETTER A WITH BREVE AND GRAVE */
  { 0x00001EB1, 0x00000103, 0x00000300 },     /* LATIN SMALL LETTER A WITH BREVE AND GRAVE */
  { 0x00001EB2, 0x00000102, 0x00000309 },     /* LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE */
  { 0x00001EB3, 0x00000103, 0x00000309 },     /* LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE */
  { 0x00001EB4, 0x00000102, 0x00000303 },     /* LATIN CAPITAL LETTER A WITH BREVE AND TILDE */
  { 0x00001EB5, 0x00000103, 0x00000303 },     /* LATIN SMALL LETTER A WITH BREVE AND TILDE */
  { 0x00001EB6, 0x00001EA0, 0x00000306 },     /* LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW */
  { 0x00001EB7, 0x00001EA1, 0x00000306 },     /* LATIN SMALL LETTER A WITH BREVE AND DOT BELOW */
  { 0x00001EB8, 0x00000045, 0x00000323 },     /* LATIN CAPITAL LETTER E WITH DOT BELOW */
  { 0x00001EB9, 0x00000065, 0x00000323 },     /* LATIN SMALL LETTER E WITH DOT BELOW */
  { 0x00001EBA, 0x00000045, 0x00000309 },     /* LATIN CAPITAL LETTER E WITH HOOK ABOVE */
  { 0x00001EBB, 0x00000065, 0x00000309 },     /* LATIN SMALL LETTER E WITH HOOK ABOVE */
  { 0x00001EBC, 0x00000045, 0x00000303 },     /* LATIN CAPITAL LETTER E WITH TILDE */
  { 0x00001EBD, 0x00000065, 0x00000303 },     /* LATIN SMALL LETTER E WITH TILDE */
  { 0x00001EBE, 0x000000CA, 0x00000301 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EBF, 0x000000EA, 0x00000301 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE */
  { 0x00001EC0, 0x000000CA, 0x00000300 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EC1, 0x000000EA, 0x00000300 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE */
  { 0x00001EC2, 0x000000CA, 0x00000309 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001EC3, 0x000000EA, 0x00000309 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001EC4, 0x000000CA, 0x00000303 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE */
  { 0x00001EC5, 0x000000EA, 0x00000303 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE */
  { 0x00001EC6, 0x00001EB8, 0x00000302 },     /* LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EC7, 0x00001EB9, 0x00000302 },     /* LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EC8, 0x00000049, 0x00000309 },     /* LATIN CAPITAL LETTER I WITH HOOK ABOVE */
  { 0x00001EC9, 0x00000069, 0x00000309 },     /* LATIN SMALL LETTER I WITH HOOK ABOVE */
  { 0x00001ECA, 0x00000049, 0x00000323 },     /* LATIN CAPITAL LETTER I WITH DOT BELOW */
  { 0x00001ECB, 0x00000069, 0x00000323 },     /* LATIN SMALL LETTER I WITH DOT BELOW */
  { 0x00001ECC, 0x0000004F, 0x00000323 },     /* LATIN CAPITAL LETTER O WITH DOT BELOW */
  { 0x00001ECD, 0x0000006F, 0x00000323 },     /* LATIN SMALL LETTER O WITH DOT BELOW */
  { 0x00001ECE, 0x0000004F, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH HOOK ABOVE */
  { 0x00001ECF, 0x0000006F, 0x00000309 },     /* LATIN SMALL LETTER O WITH HOOK ABOVE */
  { 0x00001ED0, 0x000000D4, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE */
  { 0x00001ED1, 0x000000F4, 0x00000301 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE */
  { 0x00001ED2, 0x000000D4, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE */
  { 0x00001ED3, 0x000000F4, 0x00000300 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE */
  { 0x00001ED4, 0x000000D4, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001ED5, 0x000000F4, 0x00000309 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE */
  { 0x00001ED6, 0x000000D4, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE */
  { 0x00001ED7, 0x000000F4, 0x00000303 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE */
  { 0x00001ED8, 0x00001ECC, 0x00000302 },     /* LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001ED9, 0x00001ECD, 0x00000302 },     /* LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW */
  { 0x00001EDA, 0x000001A0, 0x00000301 },     /* LATIN CAPITAL LETTER O WITH HORN AND ACUTE */
  { 0x00001EDB, 0x000001A1, 0x00000301 },     /* LATIN SMALL LETTER O WITH HORN AND ACUTE */
  { 0x00001EDC, 0x000001A0, 0x00000300 },     /* LATIN CAPITAL LETTER O WITH HORN AND GRAVE */
  { 0x00001EDD, 0x000001A1, 0x00000300 },     /* LATIN SMALL LETTER O WITH HORN AND GRAVE */
  { 0x00001EDE, 0x000001A0, 0x00000309 },     /* LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE */
  { 0x00001EDF, 0x000001A1, 0x00000309 },     /* LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE */
  { 0x00001EE0, 0x000001A0, 0x00000303 },     /* LATIN CAPITAL LETTER O WITH HORN AND TILDE */
  { 0x00001EE1, 0x000001A1, 0x00000303 },     /* LATIN SMALL LETTER O WITH HORN AND TILDE */
  { 0x00001EE2, 0x000001A0, 0x00000323 },     /* LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW */
  { 0x00001EE3, 0x000001A1, 0x00000323 },     /* LATIN SMALL LETTER O WITH HORN AND DOT BELOW */
  { 0x00001EE4, 0x00000055, 0x00000323 },     /* LATIN CAPITAL LETTER U WITH DOT BELOW */
  { 0x00001EE5, 0x00000075, 0x00000323 },     /* LATIN SMALL LETTER U WITH DOT BELOW */
  { 0x00001EE6, 0x00000055, 0x00000309 },     /* LATIN CAPITAL LETTER U WITH HOOK ABOVE */
  { 0x00001EE7, 0x00000075, 0x00000309 },     /* LATIN SMALL LETTER U WITH HOOK ABOVE */
  { 0x00001EE8, 0x000001AF, 0x00000301 },     /* LATIN CAPITAL LETTER U WITH HORN AND ACUTE */
  { 0x00001EE9, 0x000001B0, 0x00000301 },     /* LATIN SMALL LETTER U WITH HORN AND ACUTE */
  { 0x00001EEA, 0x000001AF, 0x00000300 },     /* LATIN CAPITAL LETTER U WITH HORN AND GRAVE */
  { 0x00001EEB, 0x000001B0, 0x00000300 },     /* LATIN SMALL LETTER U WITH HORN AND GRAVE */
  { 0x00001EEC, 0x000001AF, 0x00000309 },     /* LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE */
  { 0x00001EED, 0x000001B0, 0x00000309 },     /* LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE */
  { 0x00001EEE, 0x000001AF, 0x00000303 },     /* LATIN CAPITAL LETTER U WITH HORN AND TILDE */
  { 0x00001EEF, 0x000001B0, 0x00000303 },     /* LATIN SMALL LETTER U WITH HORN AND TILDE */
  { 0x00001EF0, 0x000001AF, 0x00000323 },     /* LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW */
  { 0x00001EF1, 0x000001B0, 0x00000323 },     /* LATIN SMALL LETTER U WITH HORN AND DOT BELOW */
  { 0x00001EF2, 0x00000059, 0x00000300 },     /* LATIN CAPITAL LETTER Y WITH GRAVE */
  { 0x00001EF3, 0x00000079, 0x00000300 },     /* LATIN SMALL LETTER Y WITH GRAVE */
  { 0x00001EF4, 0x00000059, 0x00000323 },     /* LATIN CAPITAL LETTER Y WITH DOT BELOW */
  { 0x00001EF5, 0x00000079, 0x00000323 },     /* LATIN SMALL LETTER Y WITH DOT BELOW */
  { 0x00001EF6, 0x00000059, 0x00000309 },     /* LATIN CAPITAL LETTER Y WITH HOOK ABOVE */
  { 0x00001EF7, 0x00000079, 0x00000309 },     /* LATIN SMALL LETTER Y WITH HOOK ABOVE */
  { 0x00001EF8, 0x00000059, 0x00000303 },     /* LATIN CAPITAL LETTER Y WITH TILDE */
  { 0x00001EF9, 0x00000079, 0x00000303 },     /* LATIN SMALL LETTER Y WITH TILDE */
  { 0x00001F00, 0x000003B1, 0x00000313 },     /* GREEK SMALL LETTER ALPHA WITH PSILI */
  { 0x00001F01, 0x000003B1, 0x00000314 },     /* GREEK SMALL LETTER ALPHA WITH DASIA */
  { 0x00001F02, 0x00001F00, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA */
  { 0x00001F03, 0x00001F01, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA */
  { 0x00001F04, 0x00001F00, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA */
  { 0x00001F05, 0x00001F01, 0x00000301 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA */
  { 0x00001F06, 0x00001F00, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI */
  { 0x00001F07, 0x00001F01, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI */
  { 0x00001F08, 0x00000391, 0x00000313 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI */
  { 0x00001F09, 0x00000391, 0x00000314 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA */
  { 0x00001F0A, 0x00001F08, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA */
  { 0x00001F0B, 0x00001F09, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA */
  { 0x00001F0C, 0x00001F08, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA */
  { 0x00001F0D, 0x00001F09, 0x00000301 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA */
  { 0x00001F0E, 0x00001F08, 0x00000342 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI */
  { 0x00001F0F, 0x00001F09, 0x00000342 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI */
  { 0x00001F10, 0x000003B5, 0x00000313 },     /* GREEK SMALL LETTER EPSILON WITH PSILI */
  { 0x00001F11, 0x000003B5, 0x00000314 },     /* GREEK SMALL LETTER EPSILON WITH DASIA */
  { 0x00001F12, 0x00001F10, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA */
  { 0x00001F13, 0x00001F11, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA */
  { 0x00001F14, 0x00001F10, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA */
  { 0x00001F15, 0x00001F11, 0x00000301 },     /* GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA */
  { 0x00001F18, 0x00000395, 0x00000313 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI */
  { 0x00001F19, 0x00000395, 0x00000314 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA */
  { 0x00001F1A, 0x00001F18, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA */
  { 0x00001F1B, 0x00001F19, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA */
  { 0x00001F1C, 0x00001F18, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA */
  { 0x00001F1D, 0x00001F19, 0x00000301 },     /* GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA */
  { 0x00001F20, 0x000003B7, 0x00000313 },     /* GREEK SMALL LETTER ETA WITH PSILI */
  { 0x00001F21, 0x000003B7, 0x00000314 },     /* GREEK SMALL LETTER ETA WITH DASIA */
  { 0x00001F22, 0x00001F20, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH PSILI AND VARIA */
  { 0x00001F23, 0x00001F21, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH DASIA AND VARIA */
  { 0x00001F24, 0x00001F20, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH PSILI AND OXIA */
  { 0x00001F25, 0x00001F21, 0x00000301 },     /* GREEK SMALL LETTER ETA WITH DASIA AND OXIA */
  { 0x00001F26, 0x00001F20, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI */
  { 0x00001F27, 0x00001F21, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI */
  { 0x00001F28, 0x00000397, 0x00000313 },     /* GREEK CAPITAL LETTER ETA WITH PSILI */
  { 0x00001F29, 0x00000397, 0x00000314 },     /* GREEK CAPITAL LETTER ETA WITH DASIA */
  { 0x00001F2A, 0x00001F28, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA */
  { 0x00001F2B, 0x00001F29, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA */
  { 0x00001F2C, 0x00001F28, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA */
  { 0x00001F2D, 0x00001F29, 0x00000301 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA */
  { 0x00001F2E, 0x00001F28, 0x00000342 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI */
  { 0x00001F2F, 0x00001F29, 0x00000342 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI */
  { 0x00001F30, 0x000003B9, 0x00000313 },     /* GREEK SMALL LETTER IOTA WITH PSILI */
  { 0x00001F31, 0x000003B9, 0x00000314 },     /* GREEK SMALL LETTER IOTA WITH DASIA */
  { 0x00001F32, 0x00001F30, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND VARIA */
  { 0x00001F33, 0x00001F31, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND VARIA */
  { 0x00001F34, 0x00001F30, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND OXIA */
  { 0x00001F35, 0x00001F31, 0x00000301 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND OXIA */
  { 0x00001F36, 0x00001F30, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI */
  { 0x00001F37, 0x00001F31, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI */
  { 0x00001F38, 0x00000399, 0x00000313 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI */
  { 0x00001F39, 0x00000399, 0x00000314 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA */
  { 0x00001F3A, 0x00001F38, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA */
  { 0x00001F3B, 0x00001F39, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA */
  { 0x00001F3C, 0x00001F38, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA */
  { 0x00001F3D, 0x00001F39, 0x00000301 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA */
  { 0x00001F3E, 0x00001F38, 0x00000342 },     /* GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI */
  { 0x00001F3F, 0x00001F39, 0x00000342 },     /* GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI */
  { 0x00001F40, 0x000003BF, 0x00000313 },     /* GREEK SMALL LETTER OMICRON WITH PSILI */
  { 0x00001F41, 0x000003BF, 0x00000314 },     /* GREEK SMALL LETTER OMICRON WITH DASIA */
  { 0x00001F42, 0x00001F40, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA */
  { 0x00001F43, 0x00001F41, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA */
  { 0x00001F44, 0x00001F40, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA */
  { 0x00001F45, 0x00001F41, 0x00000301 },     /* GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA */
  { 0x00001F48, 0x0000039F, 0x00000313 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI */
  { 0x00001F49, 0x0000039F, 0x00000314 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA */
  { 0x00001F4A, 0x00001F48, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA */
  { 0x00001F4B, 0x00001F49, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA */
  { 0x00001F4C, 0x00001F48, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA */
  { 0x00001F4D, 0x00001F49, 0x00000301 },     /* GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA */
  { 0x00001F50, 0x000003C5, 0x00000313 },     /* GREEK SMALL LETTER UPSILON WITH PSILI */
  { 0x00001F51, 0x000003C5, 0x00000314 },     /* GREEK SMALL LETTER UPSILON WITH DASIA */
  { 0x00001F52, 0x00001F50, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA */
  { 0x00001F53, 0x00001F51, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA */
  { 0x00001F54, 0x00001F50, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA */
  { 0x00001F55, 0x00001F51, 0x00000301 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA */
  { 0x00001F56, 0x00001F50, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI */
  { 0x00001F57, 0x00001F51, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI */
  { 0x00001F59, 0x000003A5, 0x00000314 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA */
  { 0x00001F5B, 0x00001F59, 0x00000300 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA */
  { 0x00001F5D, 0x00001F59, 0x00000301 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA */
  { 0x00001F5F, 0x00001F59, 0x00000342 },     /* GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI */
  { 0x00001F60, 0x000003C9, 0x00000313 },     /* GREEK SMALL LETTER OMEGA WITH PSILI */
  { 0x00001F61, 0x000003C9, 0x00000314 },     /* GREEK SMALL LETTER OMEGA WITH DASIA */
  { 0x00001F62, 0x00001F60, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA */
  { 0x00001F63, 0x00001F61, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA */
  { 0x00001F64, 0x00001F60, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA */
  { 0x00001F65, 0x00001F61, 0x00000301 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA */
  { 0x00001F66, 0x00001F60, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI */
  { 0x00001F67, 0x00001F61, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI */
  { 0x00001F68, 0x000003A9, 0x00000313 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI */
  { 0x00001F69, 0x000003A9, 0x00000314 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA */
  { 0x00001F6A, 0x00001F68, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA */
  { 0x00001F6B, 0x00001F69, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA */
  { 0x00001F6C, 0x00001F68, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA */
  { 0x00001F6D, 0x00001F69, 0x00000301 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA */
  { 0x00001F6E, 0x00001F68, 0x00000342 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI */
  { 0x00001F6F, 0x00001F69, 0x00000342 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI */
  { 0x00001F70, 0x000003B1, 0x00000300 },     /* GREEK SMALL LETTER ALPHA WITH VARIA */
  { 0x00001F72, 0x000003B5, 0x00000300 },     /* GREEK SMALL LETTER EPSILON WITH VARIA */
  { 0x00001F74, 0x000003B7, 0x00000300 },     /* GREEK SMALL LETTER ETA WITH VARIA */
  { 0x00001F76, 0x000003B9, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH VARIA */
  { 0x00001F78, 0x000003BF, 0x00000300 },     /* GREEK SMALL LETTER OMICRON WITH VARIA */
  { 0x00001F7A, 0x000003C5, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH VARIA */
  { 0x00001F7C, 0x000003C9, 0x00000300 },     /* GREEK SMALL LETTER OMEGA WITH VARIA */
  { 0x00001F80, 0x00001F00, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001F81, 0x00001F01, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001F82, 0x00001F02, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F83, 0x00001F03, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F84, 0x00001F04, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F85, 0x00001F05, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F86, 0x00001F06, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F87, 0x00001F07, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F88, 0x00001F08, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001F89, 0x00001F09, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001F8A, 0x00001F0A, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F8B, 0x00001F0B, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F8C, 0x00001F0C, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F8D, 0x00001F0D, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F8E, 0x00001F0E, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F8F, 0x00001F0F, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F90, 0x00001F20, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001F91, 0x00001F21, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001F92, 0x00001F22, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F93, 0x00001F23, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001F94, 0x00001F24, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F95, 0x00001F25, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001F96, 0x00001F26, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F97, 0x00001F27, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001F98, 0x00001F28, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001F99, 0x00001F29, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001F9A, 0x00001F2A, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F9B, 0x00001F2B, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001F9C, 0x00001F2C, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F9D, 0x00001F2D, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001F9E, 0x00001F2E, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001F9F, 0x00001F2F, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001FA0, 0x00001F60, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI */
  { 0x00001FA1, 0x00001F61, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI */
  { 0x00001FA2, 0x00001F62, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI */
  { 0x00001FA3, 0x00001F63, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI */
  { 0x00001FA4, 0x00001F64, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI */
  { 0x00001FA5, 0x00001F65, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI */
  { 0x00001FA6, 0x00001F66, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FA7, 0x00001F67, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FA8, 0x00001F68, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI */
  { 0x00001FA9, 0x00001F69, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI */
  { 0x00001FAA, 0x00001F6A, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI */
  { 0x00001FAB, 0x00001F6B, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI */
  { 0x00001FAC, 0x00001F6C, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI */
  { 0x00001FAD, 0x00001F6D, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI */
  { 0x00001FAE, 0x00001F6E, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001FAF, 0x00001F6F, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI */
  { 0x00001FB0, 0x000003B1, 0x00000306 },     /* GREEK SMALL LETTER ALPHA WITH VRACHY */
  { 0x00001FB1, 0x000003B1, 0x00000304 },     /* GREEK SMALL LETTER ALPHA WITH MACRON */
  { 0x00001FB2, 0x00001F70, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FB3, 0x000003B1, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI */
  { 0x00001FB4, 0x000003AC, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI */
  { 0x00001FB6, 0x000003B1, 0x00000342 },     /* GREEK SMALL LETTER ALPHA WITH PERISPOMENI */
  { 0x00001FB7, 0x00001FB6, 0x00000345 },     /* GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FB8, 0x00000391, 0x00000306 },     /* GREEK CAPITAL LETTER ALPHA WITH VRACHY */
  { 0x00001FB9, 0x00000391, 0x00000304 },     /* GREEK CAPITAL LETTER ALPHA WITH MACRON */
  { 0x00001FBA, 0x00000391, 0x00000300 },     /* GREEK CAPITAL LETTER ALPHA WITH VARIA */
  { 0x00001FBC, 0x00000391, 0x00000345 },     /* GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI */
  { 0x00001FC1, 0x000000A8, 0x00000342 },     /* GREEK DIALYTIKA AND PERISPOMENI */
  { 0x00001FC2, 0x00001F74, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FC3, 0x000003B7, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI */
  { 0x00001FC4, 0x000003AE, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI */
  { 0x00001FC6, 0x000003B7, 0x00000342 },     /* GREEK SMALL LETTER ETA WITH PERISPOMENI */
  { 0x00001FC7, 0x00001FC6, 0x00000345 },     /* GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FC8, 0x00000395, 0x00000300 },     /* GREEK CAPITAL LETTER EPSILON WITH VARIA */
  { 0x00001FCA, 0x00000397, 0x00000300 },     /* GREEK CAPITAL LETTER ETA WITH VARIA */
  { 0x00001FCC, 0x00000397, 0x00000345 },     /* GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI */
  { 0x00001FCD, 0x00001FBF, 0x00000300 },     /* GREEK PSILI AND VARIA */
  { 0x00001FCE, 0x00001FBF, 0x00000301 },     /* GREEK PSILI AND OXIA */
  { 0x00001FCF, 0x00001FBF, 0x00000342 },     /* GREEK PSILI AND PERISPOMENI */
  { 0x00001FD0, 0x000003B9, 0x00000306 },     /* GREEK SMALL LETTER IOTA WITH VRACHY */
  { 0x00001FD1, 0x000003B9, 0x00000304 },     /* GREEK SMALL LETTER IOTA WITH MACRON */
  { 0x00001FD2, 0x000003CA, 0x00000300 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA */
  { 0x00001FD6, 0x000003B9, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH PERISPOMENI */
  { 0x00001FD7, 0x000003CA, 0x00000342 },     /* GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI */
  { 0x00001FD8, 0x00000399, 0x00000306 },     /* GREEK CAPITAL LETTER IOTA WITH VRACHY */
  { 0x00001FD9, 0x00000399, 0x00000304 },     /* GREEK CAPITAL LETTER IOTA WITH MACRON */
  { 0x00001FDA, 0x00000399, 0x00000300 },     /* GREEK CAPITAL LETTER IOTA WITH VARIA */
  { 0x00001FDD, 0x00001FFE, 0x00000300 },     /* GREEK DASIA AND VARIA */
  { 0x00001FDE, 0x00001FFE, 0x00000301 },     /* GREEK DASIA AND OXIA */
  { 0x00001FDF, 0x00001FFE, 0x00000342 },     /* GREEK DASIA AND PERISPOMENI */
  { 0x00001FE0, 0x000003C5, 0x00000306 },     /* GREEK SMALL LETTER UPSILON WITH VRACHY */
  { 0x00001FE1, 0x000003C5, 0x00000304 },     /* GREEK SMALL LETTER UPSILON WITH MACRON */
  { 0x00001FE2, 0x000003CB, 0x00000300 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA */
  { 0x00001FE4, 0x000003C1, 0x00000313 },     /* GREEK SMALL LETTER RHO WITH PSILI */
  { 0x00001FE5, 0x000003C1, 0x00000314 },     /* GREEK SMALL LETTER RHO WITH DASIA */
  { 0x00001FE6, 0x000003C5, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH PERISPOMENI */
  { 0x00001FE7, 0x000003CB, 0x00000342 },     /* GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI */
  { 0x00001FE8, 0x000003A5, 0x00000306 },     /* GREEK CAPITAL LETTER UPSILON WITH VRACHY */
  { 0x00001FE9, 0x000003A5, 0x00000304 },     /* GREEK CAPITAL LETTER UPSILON WITH MACRON */
  { 0x00001FEA, 0x000003A5, 0x00000300 },     /* GREEK CAPITAL LETTER UPSILON WITH VARIA */
  { 0x00001FEC, 0x000003A1, 0x00000314 },     /* GREEK CAPITAL LETTER RHO WITH DASIA */
  { 0x00001FED, 0x000000A8, 0x00000300 },     /* GREEK DIALYTIKA AND VARIA */
  { 0x00001FF2, 0x00001F7C, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI */
  { 0x00001FF3, 0x000003C9, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI */
  { 0x00001FF4, 0x000003CE, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI */
  { 0x00001FF6, 0x000003C9, 0x00000342 },     /* GREEK SMALL LETTER OMEGA WITH PERISPOMENI */
  { 0x00001FF7, 0x00001FF6, 0x00000345 },     /* GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI */
  { 0x00001FF8, 0x0000039F, 0x00000300 },     /* GREEK CAPITAL LETTER OMICRON WITH VARIA */
  { 0x00001FFA, 0x000003A9, 0x00000300 },     /* GREEK CAPITAL LETTER OMEGA WITH VARIA */
  { 0x00001FFC, 0x000003A9, 0x00000345 },     /* GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI */
/*{ 0x0000219A, 0x00002190, 0x00000338 },*/   /* LEFTWARDS ARROW WITH STROKE */
/*{ 0x0000219B, 0x00002192, 0x00000338 },*/   /* RIGHTWARDS ARROW WITH STROKE */
/*{ 0x000021AE, 0x00002194, 0x00000338 },*/   /* LEFT RIGHT ARROW WITH STROKE */
/*{ 0x000021CD, 0x000021D0, 0x00000338 },*/   /* LEFTWARDS DOUBLE ARROW WITH STROKE */
/*{ 0x000021CE, 0x000021D4, 0x00000338 },*/   /* LEFT RIGHT DOUBLE ARROW WITH STROKE */
/*{ 0x000021CF, 0x000021D2, 0x00000338 },*/   /* RIGHTWARDS DOUBLE ARROW WITH STROKE */
/*{ 0x00002204, 0x00002203, 0x00000338 },*/   /* THERE DOES NOT EXIST */
/*{ 0x00002209, 0x00002208, 0x00000338 },*/   /* NOT AN ELEMENT OF */
/*{ 0x0000220C, 0x0000220B, 0x00000338 },*/   /* DOES NOT CONTAIN AS MEMBER */
/*{ 0x00002224, 0x00002223, 0x00000338 },*/   /* DOES NOT DIVIDE */
/*{ 0x00002226, 0x00002225, 0x00000338 },*/   /* NOT PARALLEL TO */
/*{ 0x00002241, 0x0000223C, 0x00000338 },*/   /* NOT TILDE */
/*{ 0x00002244, 0x00002243, 0x00000338 },*/   /* NOT ASYMPTOTICALLY EQUAL TO */
/*{ 0x00002247, 0x00002245, 0x00000338 },*/   /* NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO */
/*{ 0x00002249, 0x00002248, 0x00000338 },*/   /* NOT ALMOST EQUAL TO */
/*{ 0x00002260, 0x0000003D, 0x00000338 },*/   /* NOT EQUAL TO */
/*{ 0x00002262, 0x00002261, 0x00000338 },*/   /* NOT IDENTICAL TO */
/*{ 0x0000226D, 0x0000224D, 0x00000338 },*/   /* NOT EQUIVALENT TO */
/*{ 0x0000226E, 0x0000003C, 0x00000338 },*/   /* NOT LESS-THAN */
/*{ 0x0000226F, 0x0000003E, 0x00000338 },*/   /* NOT GREATER-THAN */
/*{ 0x00002270, 0x00002264, 0x00000338 },*/   /* NEITHER LESS-THAN NOR EQUAL TO */
/*{ 0x00002271, 0x00002265, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR EQUAL TO */
/*{ 0x00002274, 0x00002272, 0x00000338 },*/   /* NEITHER LESS-THAN NOR EQUIVALENT TO */
/*{ 0x00002275, 0x00002273, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR EQUIVALENT TO */
/*{ 0x00002278, 0x00002276, 0x00000338 },*/   /* NEITHER LESS-THAN NOR GREATER-THAN */
/*{ 0x00002279, 0x00002277, 0x00000338 },*/   /* NEITHER GREATER-THAN NOR LESS-THAN */
/*{ 0x00002280, 0x0000227A, 0x00000338 },*/   /* DOES NOT PRECEDE */
/*{ 0x00002281, 0x0000227B, 0x00000338 },*/   /* DOES NOT SUCCEED */
/*{ 0x00002284, 0x00002282, 0x00000338 },*/   /* NOT A SUBSET OF */
/*{ 0x00002285, 0x00002283, 0x00000338 },*/   /* NOT A SUPERSET OF */
/*{ 0x00002288, 0x00002286, 0x00000338 },*/   /* NEITHER A SUBSET OF NOR EQUAL TO */
/*{ 0x00002289, 0x00002287, 0x00000338 },*/   /* NEITHER A SUPERSET OF NOR EQUAL TO */
/*{ 0x000022AC, 0x000022A2, 0x00000338 },*/   /* DOES NOT PROVE */
/*{ 0x000022AD, 0x000022A8, 0x00000338 },*/   /* NOT TRUE */
/*{ 0x000022AE, 0x000022A9, 0x00000338 },*/   /* DOES NOT FORCE */
/*{ 0x000022AF, 0x000022AB, 0x00000338 },*/   /* NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE */
/*{ 0x000022E0, 0x0000227C, 0x00000338 },*/   /* DOES NOT PRECEDE OR EQUAL */
/*{ 0x000022E1, 0x0000227D, 0x00000338 },*/   /* DOES NOT SUCCEED OR EQUAL */
/*{ 0x000022E2, 0x00002291, 0x00000338 },*/   /* NOT SQUARE IMAGE OF OR EQUAL TO */
/*{ 0x000022E3, 0x00002292, 0x00000338 },*/   /* NOT SQUARE ORIGINAL OF OR EQUAL TO */
/*{ 0x000022EA, 0x000022B2, 0x00000338 },*/   /* NOT NORMAL SUBGROUP OF */
/*{ 0x000022EB, 0x000022B3, 0x00000338 },*/   /* DOES NOT CONTAIN AS NORMAL SUBGROUP */
/*{ 0x000022EC, 0x000022B4, 0x00000338 },*/   /* NOT NORMAL SUBGROUP OF OR EQUAL TO */
/*{ 0x000022ED, 0x000022B5, 0x00000338 },*/   /* DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL */
/*{ 0x00002ADC, 0x00002ADD, 0x00000338 },*/   /* FORKING */
  { 0x0000304C, 0x0000304B, 0x00003099 },     /* HIRAGANA LETTER GA */
  { 0x0000304E, 0x0000304D, 0x00003099 },     /* HIRAGANA LETTER GI */
  { 0x00003050, 0x0000304F, 0x00003099 },     /* HIRAGANA LETTER GU */
  { 0x00003052, 0x00003051, 0x00003099 },     /* HIRAGANA LETTER GE */
  { 0x00003054, 0x00003053, 0x00003099 },     /* HIRAGANA LETTER GO */
  { 0x00003056, 0x00003055, 0x00003099 },     /* HIRAGANA LETTER ZA */
  { 0x00003058, 0x00003057, 0x00003099 },     /* HIRAGANA LETTER ZI */
  { 0x0000305A, 0x00003059, 0x00003099 },     /* HIRAGANA LETTER ZU */
  { 0x0000305C, 0x0000305B, 0x00003099 },     /* HIRAGANA LETTER ZE */
  { 0x0000305E, 0x0000305D, 0x00003099 },     /* HIRAGANA LETTER ZO */
  { 0x00003060, 0x0000305F, 0x00003099 },     /* HIRAGANA LETTER DA */
  { 0x00003062, 0x00003061, 0x00003099 },     /* HIRAGANA LETTER DI */
  { 0x00003065, 0x00003064, 0x00003099 },     /* HIRAGANA LETTER DU */
  { 0x00003067, 0x00003066, 0x00003099 },     /* HIRAGANA LETTER DE */
  { 0x00003069, 0x00003068, 0x00003099 },     /* HIRAGANA LETTER DO */
  { 0x00003070, 0x0000306F, 0x00003099 },     /* HIRAGANA LETTER BA */
  { 0x00003071, 0x0000306F, 0x0000309A },     /* HIRAGANA LETTER PA */
  { 0x00003073, 0x00003072, 0x00003099 },     /* HIRAGANA LETTER BI */
  { 0x00003074, 0x00003072, 0x0000309A },     /* HIRAGANA LETTER PI */
  { 0x00003076, 0x00003075, 0x00003099 },     /* HIRAGANA LETTER BU */
  { 0x00003077, 0x00003075, 0x0000309A },     /* HIRAGANA LETTER PU */
  { 0x00003079, 0x00003078, 0x00003099 },     /* HIRAGANA LETTER BE */
  { 0x0000307A, 0x00003078, 0x0000309A },     /* HIRAGANA LETTER PE */
  { 0x0000307C, 0x0000307B, 0x00003099 },     /* HIRAGANA LETTER BO */
  { 0x0000307D, 0x0000307B, 0x0000309A },     /* HIRAGANA LETTER PO */
  { 0x00003094, 0x00003046, 0x00003099 },     /* HIRAGANA LETTER VU */
  { 0x0000309E, 0x0000309D, 0x00003099 },     /* HIRAGANA VOICED ITERATION MARK */
  { 0x000030AC, 0x000030AB, 0x00003099 },     /* KATAKANA LETTER GA */
  { 0x000030AE, 0x000030AD, 0x00003099 },     /* KATAKANA LETTER GI */
  { 0x000030B0, 0x000030AF, 0x00003099 },     /* KATAKANA LETTER GU */
  { 0x000030B2, 0x000030B1, 0x00003099 },     /* KATAKANA LETTER GE */
  { 0x000030B4, 0x000030B3, 0x00003099 },     /* KATAKANA LETTER GO */
  { 0x000030B6, 0x000030B5, 0x00003099 },     /* KATAKANA LETTER ZA */
  { 0x000030B8, 0x000030B7, 0x00003099 },     /* KATAKANA LETTER ZI */
  { 0x000030BA, 0x000030B9, 0x00003099 },     /* KATAKANA LETTER ZU */
  { 0x000030BC, 0x000030BB, 0x00003099 },     /* KATAKANA LETTER ZE */
  { 0x000030BE, 0x000030BD, 0x00003099 },     /* KATAKANA LETTER ZO */
  { 0x000030C0, 0x000030BF, 0x00003099 },     /* KATAKANA LETTER DA */
  { 0x000030C2, 0x000030C1, 0x00003099 },     /* KATAKANA LETTER DI */
  { 0x000030C5, 0x000030C4, 0x00003099 },     /* KATAKANA LETTER DU */
  { 0x000030C7, 0x000030C6, 0x00003099 },     /* KATAKANA LETTER DE */
  { 0x000030C9, 0x000030C8, 0x00003099 },     /* KATAKANA LETTER DO */
  { 0x000030D0, 0x000030CF, 0x00003099 },     /* KATAKANA LETTER BA */
  { 0x000030D1, 0x000030CF, 0x0000309A },     /* KATAKANA LETTER PA */
  { 0x000030D3, 0x000030D2, 0x00003099 },     /* KATAKANA LETTER BI */
  { 0x000030D4, 0x000030D2, 0x0000309A },     /* KATAKANA LETTER PI */
  { 0x000030D6, 0x000030D5, 0x00003099 },     /* KATAKANA LETTER BU */
  { 0x000030D7, 0x000030D5, 0x0000309A },     /* KATAKANA LETTER PU */
  { 0x000030D9, 0x000030D8, 0x00003099 },     /* KATAKANA LETTER BE */
  { 0x000030DA, 0x000030D8, 0x0000309A },     /* KATAKANA LETTER PE */
  { 0x000030DC, 0x000030DB, 0x00003099 },     /* KATAKANA LETTER BO */
  { 0x000030DD, 0x000030DB, 0x0000309A },     /* KATAKANA LETTER PO */
  { 0x000030F4, 0x000030A6, 0x00003099 },     /* KATAKANA LETTER VU */
  { 0x000030F7, 0x000030EF, 0x00003099 },     /* KATAKANA LETTER VA */
  { 0x000030F8, 0x000030F0, 0x00003099 },     /* KATAKANA LETTER VI */
  { 0x000030F9, 0x000030F1, 0x00003099 },     /* KATAKANA LETTER VE */
  { 0x000030FA, 0x000030F2, 0x00003099 },     /* KATAKANA LETTER VO */
  { 0x000030FE, 0x000030FD, 0x00003099 },     /* KATAKANA VOICED ITERATION MARK */
  { 0x0000FB1D, 0x000005D9, 0x000005B4 },     /* HEBREW LETTER YOD WITH HIRIQ */
  { 0x0000FB1F, 0x000005F2, 0x000005B7 },     /* HEBREW LIGATURE YIDDISH YOD YOD PATAH */
  { 0x0000FB2A, 0x000005E9, 0x000005C1 },     /* HEBREW LETTER SHIN WITH SHIN DOT */
  { 0x0000FB2B, 0x000005E9, 0x000005C2 },     /* HEBREW LETTER SHIN WITH SIN DOT */
  { 0x0000FB2C, 0x0000FB49, 0x000005C1 },     /* HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT */
  { 0x0000FB2D, 0x0000FB49, 0x000005C2 },     /* HEBREW LETTER SHIN WITH DAGESH AND SIN DOT */
  { 0x0000FB2E, 0x000005D0, 0x000005B7 },     /* HEBREW LETTER ALEF WITH PATAH */
  { 0x0000FB2F, 0x000005D0, 0x000005B8 },     /* HEBREW LETTER ALEF WITH QAMATS */
  { 0x0000FB30, 0x000005D0, 0x000005BC },     /* HEBREW LETTER ALEF WITH MAPIQ */
  { 0x0000FB31, 0x000005D1, 0x000005BC },     /* HEBREW LETTER BET WITH DAGESH */
  { 0x0000FB32, 0x000005D2, 0x000005BC },     /* HEBREW LETTER GIMEL WITH DAGESH */
  { 0x0000FB33, 0x000005D3, 0x000005BC },     /* HEBREW LETTER DALET WITH DAGESH */
  { 0x0000FB34, 0x000005D4, 0x000005BC },     /* HEBREW LETTER HE WITH MAPIQ */
  { 0x0000FB35, 0x000005D5, 0x000005BC },     /* HEBREW LETTER VAV WITH DAGESH */
  { 0x0000FB36, 0x000005D6, 0x000005BC },     /* HEBREW LETTER ZAYIN WITH DAGESH */
  { 0x0000FB38, 0x000005D8, 0x000005BC },     /* HEBREW LETTER TET WITH DAGESH */
  { 0x0000FB39, 0x000005D9, 0x000005BC },     /* HEBREW LETTER YOD WITH DAGESH */
  { 0x0000FB3A, 0x000005DA, 0x000005BC },     /* HEBREW LETTER FINAL KAF WITH DAGESH */
  { 0x0000FB3B, 0x000005DB, 0x000005BC },     /* HEBREW LETTER KAF WITH DAGESH */
  { 0x0000FB3C, 0x000005DC, 0x000005BC },     /* HEBREW LETTER LAMED WITH DAGESH */
  { 0x0000FB3E, 0x000005DE, 0x000005BC },     /* HEBREW LETTER MEM WITH DAGESH */
  { 0x0000FB40, 0x000005E0, 0x000005BC },     /* HEBREW LETTER NUN WITH DAGESH */
  { 0x0000FB41, 0x000005E1, 0x000005BC },     /* HEBREW LETTER SAMEKH WITH DAGESH */
  { 0x0000FB43, 0x000005E3, 0x000005BC },     /* HEBREW LETTER FINAL PE WITH DAGESH */
  { 0x0000FB44, 0x000005E4, 0x000005BC },     /* HEBREW LETTER PE WITH DAGESH */
  { 0x0000FB46, 0x000005E6, 0x000005BC },     /* HEBREW LETTER TSADI WITH DAGESH */
  { 0x0000FB47, 0x000005E7, 0x000005BC },     /* HEBREW LETTER QOF WITH DAGESH */
  { 0x0000FB48, 0x000005E8, 0x000005BC },     /* HEBREW LETTER RESH WITH DAGESH */
  { 0x0000FB49, 0x000005E9, 0x000005BC },     /* HEBREW LETTER SHIN WITH DAGESH */
  { 0x0000FB4A, 0x000005EA, 0x000005BC },     /* HEBREW LETTER TAV WITH DAGESH */
  { 0x0000FB4B, 0x000005D5, 0x000005B9 },     /* HEBREW LETTER VAV WITH HOLAM */
  { 0x0000FB4C, 0x000005D1, 0x000005BF },     /* HEBREW LETTER BET WITH RAFE */
  { 0x0000FB4D, 0x000005DB, 0x000005BF },     /* HEBREW LETTER KAF WITH RAFE */
  { 0x0000FB4E, 0x000005E4, 0x000005BF },     /* HEBREW LETTER PE WITH RAFE */
/*{ 0x0001109A, 0x00011099, 0x000110BA },*/   /* KAITHI LETTER DDDHA */
/*{ 0x0001109C, 0x0001109B, 0x000110BA },*/   /* KAITHI LETTER RHA */
/*{ 0x000110AB, 0x000110A5, 0x000110BA },*/   /* KAITHI LETTER VA */
/*{ 0x0001112E, 0x00011131, 0x00011127 },*/   /* CHAKMA VOWEL SIGN O */
/*{ 0x0001112F, 0x00011132, 0x00011127 },*/   /* CHAKMA VOWEL SIGN AU */
/*{ 0x0001134B, 0x00011347, 0x0001133E },*/   /* GRANTHA VOWEL SIGN OO */
/*{ 0x0001134C, 0x00011347, 0x00011357 },*/   /* GRANTHA VOWEL SIGN AU */
/*{ 0x000114BB, 0x000114B9, 0x000114BA },*/   /* TIRHUTA VOWEL SIGN AI */
/*{ 0x000114BC, 0x000114B9, 0x000114B0 },*/   /* TIRHUTA VOWEL SIGN O */
/*{ 0x000114BE, 0x000114B9, 0x000114BD },*/   /* TIRHUTA VOWEL SIGN AU */
/*{ 0x000115BA, 0x000115B8, 0x000115AF },*/   /* SIDDHAM VOWEL SIGN O */
/*{ 0x000115BB, 0x000115B9, 0x000115AF },*/   /* SIDDHAM VOWEL SIGN AU */
/*{ 0x0001D15E, 0x0001D157, 0x0001D165 },*/   /* MUSICAL SYMBOL HALF NOTE */
/*{ 0x0001D15F, 0x0001D158, 0x0001D165 },*/   /* MUSICAL SYMBOL QUARTER NOTE */
/*{ 0x0001D160, 0x0001D15F, 0x0001D16E },*/   /* MUSICAL SYMBOL EIGHTH NOTE */
/*{ 0x0001D161, 0x0001D15F, 0x0001D16F },*/   /* MUSICAL SYMBOL SIXTEENTH NOTE */
/*{ 0x0001D162, 0x0001D15F, 0x0001D170 },*/   /* MUSICAL SYMBOL THIRTY-SECOND NOTE */
/*{ 0x0001D163, 0x0001D15F, 0x0001D171 },*/   /* MUSICAL SYMBOL SIXTY-FOURTH NOTE */
/*{ 0x0001D164, 0x0001D15F, 0x0001D172 },*/   /* MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE */
/*{ 0x0001D1BB, 0x0001D1B9, 0x0001D165 },*/   /* MUSICAL SYMBOL MINIMA */
/*{ 0x0001D1BC, 0x0001D1BA, 0x0001D165 },*/   /* MUSICAL SYMBOL MINIMA BLACK */
/*{ 0x0001D1BD, 0x0001D1BB, 0x0001D16E },*/   /* MUSICAL SYMBOL SEMIMINIMA WHITE */
/*{ 0x0001D1BE, 0x0001D1BC, 0x0001D16E },*/   /* MUSICAL SYMBOL SEMIMINIMA BLACK */
/*{ 0x0001D1BF, 0x0001D1BB, 0x0001D16F },*/   /* MUSICAL SYMBOL FUSA WHITE */
/*{ 0x0001D1C0, 0x0001D1BC, 0x0001D16F },*/   /* MUSICAL SYMBOL FUSA BLACK */
};

static const struct {
  unsigned int replacement_sp;
  unsigned int base_sp;
  unsigned int comb_sp;
} precompositions_sp[] = {
  { 0xD804DC9A, 0xD804DC99, 0xD804DCBA },     /* KAITHI LETTER DDDHA */
  { 0xD804DC9C, 0xD804DC9B, 0xD804DCBA },     /* KAITHI LETTER RHA */
  { 0xD804DCAB, 0xD804DCA5, 0xD804DCBA },     /* KAITHI LETTER VA */
  { 0xD804DD2E, 0xD804DD31, 0xD804DD27 },     /* CHAKMA VOWEL SIGN O */
  { 0xD804DD2F, 0xD804DD32, 0xD804DD27 },     /* CHAKMA VOWEL SIGN AU */
  { 0xD804DF4B, 0xD804DF47, 0xD804DF3E },     /* GRANTHA VOWEL SIGN OO */
  { 0xD804DF4C, 0xD804DF47, 0xD804DF57 },     /* GRANTHA VOWEL SIGN AU */
  { 0xD805DCBC, 0xD805DCB9, 0xD805DCB0 },     /* TIRHUTA VOWEL SIGN O */
  { 0xD805DCBB, 0xD805DCB9, 0xD805DCBA },     /* TIRHUTA VOWEL SIGN AI */
  { 0xD805DCBE, 0xD805DCB9, 0xD805DCBD },     /* TIRHUTA VOWEL SIGN AU */
  { 0xD805DDBA, 0xD805DDB8, 0xD805DDAF },     /* SIDDHAM VOWEL SIGN O */
  { 0xD805DDBB, 0xD805DDB9, 0xD805DDAF },     /* SIDDHAM VOWEL SIGN AU */
  { 0xD834DD5E, 0xD834DD57, 0xD834DD65 },     /* MUSICAL SYMBOL HALF NOTE */
  { 0xD834DD5F, 0xD834DD58, 0xD834DD65 },     /* MUSICAL SYMBOL QUARTER NOTE */
  { 0xD834DD60, 0xD834DD5F, 0xD834DD6E },     /* MUSICAL SYMBOL EIGHTH NOTE */
  { 0xD834DD61, 0xD834DD5F, 0xD834DD6F },     /* MUSICAL SYMBOL SIXTEENTH NOTE */
  { 0xD834DD62, 0xD834DD5F, 0xD834DD70 },     /* MUSICAL SYMBOL THIRTY-SECOND NOTE */
  { 0xD834DD63, 0xD834DD5F, 0xD834DD71 },     /* MUSICAL SYMBOL SIXTY-FOURTH NOTE */
  { 0xD834DD64, 0xD834DD5F, 0xD834DD72 },     /* MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE */
  { 0xD834DDBB, 0xD834DDB9, 0xD834DD65 },     /* MUSICAL SYMBOL MINIMA */
  { 0xD834DDBC, 0xD834DDBA, 0xD834DD65 },     /* MUSICAL SYMBOL MINIMA BLACK */
  { 0xD834DDBD, 0xD834DDBB, 0xD834DD6E },     /* MUSICAL SYMBOL SEMIMINIMA WHITE */
  { 0xD834DDBF, 0xD834DDBB, 0xD834DD6F },     /* MUSICAL SYMBOL FUSA WHITE */
  { 0xD834DDBE, 0xD834DDBC, 0xD834DD6E },     /* MUSICAL SYMBOL SEMIMINIMA BLACK */
  { 0xD834DDC0, 0xD834DDBC, 0xD834DD6F },     /* MUSICAL SYMBOL FUSA BLACK */
};

static const struct {
  unsigned int replacement_sp;
  unsigned int base_sp;
  unsigned int comb_sp;
} decompositions_sp[] = {
  { 0xD804DC9A, 0xD804DC99, 0xD804DCBA },     /* KAITHI LETTER DDDHA */
  { 0xD804DC9C, 0xD804DC9B, 0xD804DCBA },     /* KAITHI LETTER RHA */
  { 0xD804DCAB, 0xD804DCA5, 0xD804DCBA },     /* KAITHI LETTER VA */
  { 0xD804DD2E, 0xD804DD31, 0xD804DD27 },     /* CHAKMA VOWEL SIGN O */
  { 0xD804DD2F, 0xD804DD32, 0xD804DD27 },     /* CHAKMA VOWEL SIGN AU */
  { 0xD804DF4B, 0xD804DF47, 0xD804DF3E },     /* GRANTHA VOWEL SIGN OO */
  { 0xD804DF4C, 0xD804DF47, 0xD804DF57 },     /* GRANTHA VOWEL SIGN AU */
  { 0xD805DCBB, 0xD805DCB9, 0xD805DCBA },     /* TIRHUTA VOWEL SIGN AI */
  { 0xD805DCBC, 0xD805DCB9, 0xD805DCB0 },     /* TIRHUTA VOWEL SIGN O */
  { 0xD805DCBE, 0xD805DCB9, 0xD805DCBD },     /* TIRHUTA VOWEL SIGN AU */
  { 0xD805DDBA, 0xD805DDB8, 0xD805DDAF },     /* SIDDHAM VOWEL SIGN O */
  { 0xD805DDBB, 0xD805DDB9, 0xD805DDAF },     /* SIDDHAM VOWEL SIGN AU */
  { 0xD834DD5E, 0xD834DD57, 0xD834DD65 },     /* MUSICAL SYMBOL HALF NOTE */
  { 0xD834DD5F, 0xD834DD58, 0xD834DD65 },     /* MUSICAL SYMBOL QUARTER NOTE */
  { 0xD834DD60, 0xD834DD5F, 0xD834DD6E },     /* MUSICAL SYMBOL EIGHTH NOTE */
  { 0xD834DD61, 0xD834DD5F, 0xD834DD6F },     /* MUSICAL SYMBOL SIXTEENTH NOTE */
  { 0xD834DD62, 0xD834DD5F, 0xD834DD70 },     /* MUSICAL SYMBOL THIRTY-SECOND NOTE */
  { 0xD834DD63, 0xD834DD5F, 0xD834DD71 },     /* MUSICAL SYMBOL SIXTY-FOURTH NOTE */
  { 0xD834DD64, 0xD834DD5F, 0xD834DD72 },     /* MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE */
  { 0xD834DDBB, 0xD834DDB9, 0xD834DD65 },     /* MUSICAL SYMBOL MINIMA */
  { 0xD834DDBC, 0xD834DDBA, 0xD834DD65 },     /* MUSICAL SYMBOL MINIMA BLACK */
  { 0xD834DDBD, 0xD834DDBB, 0xD834DD6E },     /* MUSICAL SYMBOL SEMIMINIMA WHITE */
  { 0xD834DDBE, 0xD834DDBC, 0xD834DD6E },     /* MUSICAL SYMBOL SEMIMINIMA BLACK */
  { 0xD834DDBF, 0xD834DDBB, 0xD834DD6F },     /* MUSICAL SYMBOL FUSA WHITE */
  { 0xD834DDC0, 0xD834DDBC, 0xD834DD6F },     /* MUSICAL SYMBOL FUSA BLACK */
};

/* EOF */
