/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -igc
/*
  +----------------------------------------------------------------------+
  | PHP Version 5                                                        |
  +----------------------------------------------------------------------+
  | Copyright (c) 1997-2015 The PHP Group                                |
  +----------------------------------------------------------------------+
  | This source file is subject to version 3.01 of the PHP license,      |
  | that is bundled with this package in the file LICENSE, and is        |
  | available through the world-wide-web at the following url:           |
  | http://www.php.net/license/3_01.txt                                  |
  | If you did not receive a copy of the PHP license and are unable to   |
  | obtain it through the world-wide-web, please send a note to          |
  | license@php.net so we can mail you a copy immediately.               |
  +----------------------------------------------------------------------+
  | Author: Jakub Zelenka <bukka@php.net>                                |
  +----------------------------------------------------------------------+
*/

#include "php.h"
#include "php_json_scanner.h"
#include "php_json_scanner_defs.h"
#include "php_json_parser.h"
#include "json_parser.tab.h"

#define	YYCTYPE     php_json_ctype
#define	YYCURSOR    s->cursor
#define	YYLIMIT     s->limit
#define	YYMARKER    s->marker
#define	YYCTXMARKER s->ctxmarker

#define YYGETCONDITION()        s->state
#define YYSETCONDITION(yystate) s->state = yystate

#define	YYFILL(n)

#define PHP_JSON_CONDITION_SET(condition) YYSETCONDITION(yyc##condition)
#define PHP_JSON_CONDITION_GOTO(condition) goto yyc_##condition

#define PHP_JSON_SCANNER_COPY_ESC() php_json_scanner_copy_string(s, 0)
#define PHP_JSON_SCANNER_COPY_UTF() php_json_scanner_copy_string(s, 5)
#define PHP_JSON_SCANNER_COPY_UTF_SP() php_json_scanner_copy_string(s, 11)

#define PHP_JSON_INT_MAX_LENGTH (MAX_LENGTH_OF_LONG - 1)


static void php_json_scanner_copy_string(php_json_scanner *s, int esc_size)
{
	size_t len = s->cursor - s->str_start - esc_size - 1;
	if (len) {
		memcpy(s->pstr, s->str_start, len);
		s->pstr += len;
	}
}

static int php_json_hex_to_int(char code)
{
	if (code >= '0' && code <= '9') {
		return code - '0';
	} else if (code >= 'A' && code <= 'F') {
		return code - ('A' - 10);
	} else if (code >= 'a' && code <= 'f') {
		return code - ('a' - 10);
	} else {
		/* this should never happened (just to suppress compiler warning) */
		return -1;
	}
}

static int php_json_ucs2_to_int_ex(php_json_scanner *s, int size, int start)
{
	int i, code = 0;
	php_json_ctype *pc = s->cursor - start;
	for (i = 0; i < size; i++) {
		code |= php_json_hex_to_int(*(pc--)) << (i * 4);
	}
	return code;
}

static int php_json_ucs2_to_int(php_json_scanner *s, int size)
{
	return php_json_ucs2_to_int_ex(s, size, 1);
}

void php_json_scanner_init(php_json_scanner *s, char *str, size_t str_len, int options)
{
	s->cursor = (php_json_ctype *) str;
	s->limit = (php_json_ctype *) str + str_len;
	s->options = options;
	PHP_JSON_CONDITION_SET(JS);
}

int php_json_scan(php_json_scanner *s)
{
	ZVAL_NULL(&s->value);
	
std:
	s->token = s->cursor;


	{
		YYCTYPE yych;
		unsigned int yyaccept = 0;
		static void *yyctable[3] = {
			&&yyc_JS,
			&&yyc_STR_P1,
			&&yyc_STR_P2,
		};
		goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_JS:
		{
			static const unsigned char yybm[] = {
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,  64,   0,   0,   0,  64,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				 64,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				128, 128, 128, 128, 128, 128, 128, 128, 
				128, 128,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
				  0,   0,   0,   0,   0,   0,   0,   0, 
			};
			yych = *YYCURSOR;
			{
				static void *yytarget[256] = {
					&&yy2,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy6,  &&yy9,  &&yy4,  &&yy4,  &&yy10, &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy6,  &&yy4,  &&yy11, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy13, &&yy15, &&yy4,  &&yy4,
					&&yy16, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18, &&yy18,
					&&yy18, &&yy18, &&yy20, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy22, &&yy4,  &&yy24, &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy26, &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy27, &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy28, &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy29, &&yy4,  &&yy31, &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
					&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
				};
				goto *yytarget[yych];
			}
yy2:
			++YYCURSOR;
			{
		if (s->limit < s->cursor) {
			return PHP_JSON_T_EOI;
		} else {
			s->errcode = PHP_JSON_ERROR_SYNTAX;
			return PHP_JSON_T_ERROR;
		}
	}
yy4:
			++YYCURSOR;
yy5:
			{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy6:
			yych = *++YYCURSOR;
yy7:
			if (yybm[0+yych] & 64) {
				goto yy6;
			}
yy8:
			{ goto std; }
yy9:
			++YYCURSOR;
			goto yy8;
yy10:
			yych = *++YYCURSOR;
			if (yych == '\n') goto yy9;
			goto yy7;
yy11:
			++YYCURSOR;
			{
		s->str_start = s->cursor;
		s->str_esc = 0;
		PHP_JSON_CONDITION_SET(STR_P1);
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy13:
			++YYCURSOR;
			{ return ','; }
yy15:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy5;
			if (yych <= '0') goto yy16;
			if (yych <= '9') goto yy18;
			goto yy5;
yy16:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych == '.') goto yy33;
			} else {
				if (yych <= 'E') goto yy35;
				if (yych == 'e') goto yy35;
			}
yy17:
			{
		zend_bool bigint = 0, negative = s->token[0] == '-';
		size_t digits = (size_t) (s->cursor - s->token - negative);
		if (digits >= PHP_JSON_INT_MAX_LENGTH) {
			if (digits == PHP_JSON_INT_MAX_LENGTH) {
				int cmp = strncmp((char *) (s->token + negative), LONG_MIN_DIGITS, PHP_JSON_INT_MAX_LENGTH);
				if (!(cmp < 0 || (cmp == 0 && negative))) {
					bigint = 1;
				}
			} else {
				bigint = 1;
			}
		}
		if (!bigint) {
			ZVAL_LONG(&s->value, ZEND_STRTOL((char *) s->token, NULL, 10));
			return PHP_JSON_T_INT;
		} else if (s->options & PHP_JSON_BIGINT_AS_STRING) {
			ZVAL_STRINGL(&s->value, (char *) s->token, s->cursor - s->token);
			return PHP_JSON_T_STRING;
		} else {
			ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
			return PHP_JSON_T_DOUBLE;
		}
	}
yy18:
			yyaccept = 0;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yybm[0+yych] & 128) {
				goto yy18;
			}
			if (yych <= 'D') {
				if (yych == '.') goto yy33;
				goto yy17;
			} else {
				if (yych <= 'E') goto yy35;
				if (yych == 'e') goto yy35;
				goto yy17;
			}
yy20:
			++YYCURSOR;
			{ return ':'; }
yy22:
			++YYCURSOR;
			{ return '['; }
yy24:
			++YYCURSOR;
			{ return ']'; }
yy26:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'a') goto yy36;
			goto yy5;
yy27:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'u') goto yy37;
			goto yy5;
yy28:
			yyaccept = 1;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych == 'r') goto yy38;
			goto yy5;
yy29:
			++YYCURSOR;
			{ return '{'; }
yy31:
			++YYCURSOR;
			{ return '}'; }
yy33:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy34;
			if (yych <= '9') goto yy39;
yy34:
			YYCURSOR = YYMARKER;
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy17;
				} else {
					goto yy5;
				}
			} else {
				goto yy41;
			}
yy35:
			yych = *++YYCURSOR;
			if (yych <= ',') {
				if (yych == '+') goto yy42;
				goto yy34;
			} else {
				if (yych <= '-') goto yy42;
				if (yych <= '/') goto yy34;
				if (yych <= '9') goto yy43;
				goto yy34;
			}
yy36:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy45;
			goto yy34;
yy37:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy46;
			goto yy34;
yy38:
			yych = *++YYCURSOR;
			if (yych == 'u') goto yy47;
			goto yy34;
yy39:
			yyaccept = 2;
			yych = *(YYMARKER = ++YYCURSOR);
			if (yych <= 'D') {
				if (yych <= '/') goto yy41;
				if (yych <= '9') goto yy39;
			} else {
				if (yych <= 'E') goto yy35;
				if (yych == 'e') goto yy35;
			}
yy41:
			{
		ZVAL_DOUBLE(&s->value, zend_strtod((char *) s->token, NULL));
		return PHP_JSON_T_DOUBLE;
	}
yy42:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy34;
			if (yych >= ':') goto yy34;
yy43:
			yych = *++YYCURSOR;
			if (yych <= '/') goto yy41;
			if (yych <= '9') goto yy43;
			goto yy41;
yy45:
			yych = *++YYCURSOR;
			if (yych == 's') goto yy48;
			goto yy34;
yy46:
			yych = *++YYCURSOR;
			if (yych == 'l') goto yy49;
			goto yy34;
yy47:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy51;
			goto yy34;
yy48:
			yych = *++YYCURSOR;
			if (yych == 'e') goto yy53;
			goto yy34;
yy49:
			++YYCURSOR;
			{
		ZVAL_NULL(&s->value);
		return PHP_JSON_T_NUL;
	}
yy51:
			++YYCURSOR;
			{
		ZVAL_TRUE(&s->value);
		return PHP_JSON_T_TRUE;
	}
yy53:
			++YYCURSOR;
			{
		ZVAL_FALSE(&s->value);
		return PHP_JSON_T_FALSE;
	}
		}
/* *********************************** */
yyc_STR_P1:
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57, &&yy57,
				&&yy59, &&yy59, &&yy61, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy63, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59, &&yy59,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67,
				&&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67,
				&&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67,
				&&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67, &&yy67,
				&&yy68, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy69,
				&&yy69, &&yy69, &&yy69, &&yy69, &&yy69, &&yy70, &&yy69, &&yy69,
				&&yy71, &&yy72, &&yy72, &&yy72, &&yy73, &&yy65, &&yy65, &&yy65,
				&&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65, &&yy65
			};
			goto *yytarget[yych];
		}
yy57:
		++YYCURSOR;
		{
		s->errcode = PHP_JSON_ERROR_CTRL_CHAR;
		return PHP_JSON_T_ERROR;
	}
yy59:
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P1); }
yy61:
		++YYCURSOR;
		{
		zend_string *str;
		size_t len = s->cursor - s->str_start - s->str_esc - 1;
		if (len == 0) {
			PHP_JSON_CONDITION_SET(JS);
			ZVAL_EMPTY_STRING(&s->value);
			return PHP_JSON_T_ESTRING;
		}
		str = zend_string_alloc(len, 0);
		str->val[len] = '\0';
		ZVAL_STR(&s->value, str);
		if (s->str_esc) {
			s->pstr = (php_json_ctype *) Z_STRVAL(s->value);
			s->cursor = s->str_start;
			PHP_JSON_CONDITION_SET(STR_P2);
			PHP_JSON_CONDITION_GOTO(STR_P2);
		} else {
			memcpy(Z_STRVAL(s->value), s->str_start, len);
			PHP_JSON_CONDITION_SET(JS);
			return PHP_JSON_T_STRING;
		}
	}
yy63:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy74, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy74,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy74, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy74, &&yy64, &&yy64, &&yy64, &&yy74, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy74, &&yy64,
				&&yy64, &&yy64, &&yy74, &&yy64, &&yy74, &&yy76, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64,
				&&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64, &&yy64
			};
			goto *yytarget[yych];
		}
yy64:
		{
		s->errcode = PHP_JSON_ERROR_SYNTAX;
		return PHP_JSON_T_ERROR;
	}
yy65:
		++YYCURSOR;
yy66:
		{
		s->errcode = PHP_JSON_ERROR_UTF8;
		return PHP_JSON_T_ERROR;
	}
yy67:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy66;
		if (yych <= 0xBF) goto yy59;
		goto yy66;
yy68:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x9F) goto yy66;
		if (yych <= 0xBF) goto yy78;
		goto yy66;
yy69:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy66;
		if (yych <= 0xBF) goto yy78;
		goto yy66;
yy70:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy66;
		if (yych <= 0x9F) goto yy78;
		goto yy66;
yy71:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x8F) goto yy66;
		if (yych <= 0xBF) goto yy79;
		goto yy66;
yy72:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy66;
		if (yych <= 0xBF) goto yy79;
		goto yy66;
yy73:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x7F) goto yy66;
		if (yych <= 0x8F) goto yy79;
		goto yy66;
yy74:
		++YYCURSOR;
		{
		s->str_esc++;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy76:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy80, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81, &&yy81,
				&&yy81, &&yy81, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy81, &&yy81, &&yy81, &&yy82, &&yy81, &&yy81, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy81, &&yy81, &&yy81, &&yy82, &&yy81, &&yy81, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77
			};
			goto *yytarget[yych];
		}
yy77:
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy64;
			} else {
				goto yy66;
			}
		} else {
			goto yy96;
		}
yy78:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy77;
		if (yych <= 0xBF) goto yy59;
		goto yy77;
yy79:
		yych = *++YYCURSOR;
		if (yych <= 0x7F) goto yy77;
		if (yych <= 0xBF) goto yy78;
		goto yy77;
yy80:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy83, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84, &&yy84,
				&&yy85, &&yy85, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77
			};
			goto *yytarget[yych];
		}
yy81:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy85;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy85;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy85;
			goto yy77;
		}
yy82:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy86, &&yy86, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy86, &&yy86, &&yy85, &&yy85, &&yy85, &&yy85, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy86, &&yy86, &&yy85, &&yy85, &&yy85, &&yy85, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77,
				&&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77, &&yy77
			};
			goto *yytarget[yych];
		}
yy83:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '7') goto yy87;
			if (yych <= '9') goto yy88;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy88;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy88;
			goto yy77;
		}
yy84:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy88;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy88;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy88;
			goto yy77;
		}
yy85:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy89;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy89;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy89;
			goto yy77;
		}
yy86:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy90;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy90;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy90;
			goto yy77;
		}
yy87:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy91;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy91;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy91;
			goto yy77;
		}
yy88:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy93;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy93;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy93;
			goto yy77;
		}
yy89:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy95;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy95;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy95;
			goto yy77;
		}
yy90:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych <= '9') goto yy97;
			goto yy77;
		} else {
			if (yych <= 'F') goto yy97;
			if (yych <= '`') goto yy77;
			if (yych <= 'f') goto yy97;
			goto yy77;
		}
yy91:
		++YYCURSOR;
		{
		s->str_esc += 5;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy93:
		++YYCURSOR;
		{
		s->str_esc += 4;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy95:
		++YYCURSOR;
yy96:
		{
		s->str_esc += 3;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
yy97:
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy96;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy77;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy100;
		if (yych != 'd') goto yy77;
yy100:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy77;
		if (yych <= 'F') goto yy101;
		if (yych <= 'b') goto yy77;
		if (yych >= 'g') goto yy77;
yy101:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych >= ':') goto yy77;
		} else {
			if (yych <= 'F') goto yy102;
			if (yych <= '`') goto yy77;
			if (yych >= 'g') goto yy77;
		}
yy102:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy77;
			if (yych >= ':') goto yy77;
		} else {
			if (yych <= 'F') goto yy103;
			if (yych <= '`') goto yy77;
			if (yych >= 'g') goto yy77;
		}
yy103:
		++YYCURSOR;
		{
		s->str_esc += 8;
		PHP_JSON_CONDITION_GOTO(STR_P1);
	}
/* *********************************** */
yyc_STR_P2:
		yych = *YYCURSOR;
		if (yych == '"') goto yy109;
		if (yych == '\\') goto yy111;
		++YYCURSOR;
		{ PHP_JSON_CONDITION_GOTO(STR_P2); }
yy109:
		++YYCURSOR;
		YYSETCONDITION(yycJS);
		{
		PHP_JSON_SCANNER_COPY_ESC();
		return PHP_JSON_T_STRING;
	}
yy111:
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'u') goto yy113;
yy112:
		{
		char esc;
		PHP_JSON_SCANNER_COPY_ESC();
		switch (*s->cursor) {
			case 'b':
				esc = '\b';
				break;
			case 'f':
				esc = '\f';
				break;
			case 'n':
				esc = '\n';
				break;
			case 'r':
				esc = '\r';
				break;
			case 't':
				esc = '\t';
				break;
			case '\\':
			case '/':
			case '"':
				esc = *s->cursor;
				break;
			default:
				s->errcode = PHP_JSON_ERROR_SYNTAX;
				return PHP_JSON_T_ERROR;
		}
		*(s->pstr++) = esc;
		++YYCURSOR;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy113:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy115, &&yy116, &&yy116, &&yy116, &&yy116, &&yy116, &&yy116, &&yy116,
				&&yy116, &&yy116, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy116, &&yy116, &&yy116, &&yy117, &&yy116, &&yy116, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy116, &&yy116, &&yy116, &&yy117, &&yy116, &&yy116, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114
			};
			goto *yytarget[yych];
		}
yy114:
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy112;
		} else {
			goto yy131;
		}
yy115:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy118, &&yy119, &&yy119, &&yy119, &&yy119, &&yy119, &&yy119, &&yy119,
				&&yy120, &&yy120, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114
			};
			goto *yytarget[yych];
		}
yy116:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy120;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy120;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy120;
			goto yy114;
		}
yy117:
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120, &&yy120,
				&&yy121, &&yy121, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy121, &&yy121, &&yy120, &&yy120, &&yy120, &&yy120, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy121, &&yy121, &&yy120, &&yy120, &&yy120, &&yy120, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114,
				&&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114, &&yy114
			};
			goto *yytarget[yych];
		}
yy118:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '7') goto yy122;
			if (yych <= '9') goto yy123;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy123;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy123;
			goto yy114;
		}
yy119:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy123;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy123;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy123;
			goto yy114;
		}
yy120:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy124;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy124;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy124;
			goto yy114;
		}
yy121:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy125;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy125;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy125;
			goto yy114;
		}
yy122:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy126;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy126;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy126;
			goto yy114;
		}
yy123:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy128;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy128;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy128;
			goto yy114;
		}
yy124:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy130;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy130;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy130;
			goto yy114;
		}
yy125:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych <= '9') goto yy132;
			goto yy114;
		} else {
			if (yych <= 'F') goto yy132;
			if (yych <= '`') goto yy114;
			if (yych <= 'f') goto yy132;
			goto yy114;
		}
yy126:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 2);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) utf16;
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy128:
		++YYCURSOR;
		{
		int utf16 = php_json_ucs2_to_int(s, 3);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xc0 | (utf16 >> 6));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy130:
		++YYCURSOR;
yy131:
		{
		int utf16 = php_json_ucs2_to_int(s, 4);
		PHP_JSON_SCANNER_COPY_UTF();
		*(s->pstr++) = (char) (0xe0 | (utf16 >> 12));
		*(s->pstr++) = (char) (0x80 | ((utf16 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf16 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
yy132:
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych != '\\') goto yy131;
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy114;
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy135;
		if (yych != 'd') goto yy114;
yy135:
		yych = *++YYCURSOR;
		if (yych <= 'B') goto yy114;
		if (yych <= 'F') goto yy136;
		if (yych <= 'b') goto yy114;
		if (yych >= 'g') goto yy114;
yy136:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych >= ':') goto yy114;
		} else {
			if (yych <= 'F') goto yy137;
			if (yych <= '`') goto yy114;
			if (yych >= 'g') goto yy114;
		}
yy137:
		yych = *++YYCURSOR;
		if (yych <= '@') {
			if (yych <= '/') goto yy114;
			if (yych >= ':') goto yy114;
		} else {
			if (yych <= 'F') goto yy138;
			if (yych <= '`') goto yy114;
			if (yych >= 'g') goto yy114;
		}
yy138:
		++YYCURSOR;
		{
		int utf32, utf16_hi, utf16_lo;
		utf16_hi = php_json_ucs2_to_int(s, 4);
		utf16_lo = php_json_ucs2_to_int_ex(s, 4, 7);
		utf32 = ((utf16_lo & 0x3FF) << 10) + (utf16_hi & 0x3FF) + 0x10000;
		PHP_JSON_SCANNER_COPY_UTF_SP();
		*(s->pstr++) = (char) (0xf0 | (utf32 >> 18));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 12) & 0x3f));
		*(s->pstr++) = (char) (0x80 | ((utf32 >> 6) & 0x3f));
		*(s->pstr++) = (char) (0x80 | (utf32 & 0x3f));
		s->str_start = s->cursor;
		PHP_JSON_CONDITION_GOTO(STR_P2);
	}
	}


}

real_world/php20150211_json_scanner.re:337:26: warning: unreachable rule in condition 'STR_P1' (shadowed by rules at lines 205, 229, 233, 255, 256) [-Wunreachable-rules]
real_world/php20150211_json_scanner.re:337:26: warning: unreachable rule in condition 'STR_P2' (shadowed by rules at lines 298, 331, 335) [-Wunreachable-rules]
real_world/php20150211_json_scanner.re:100:0: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
