.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH TEGRA __drivermansuffix__ __vendorversion__
.SH NAME
opentegra \- video driver for NVIDIA Tegra
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qopentegra\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B opentegra
is an __xservername__ driver for NVIDIA Tegra SoCs.  It sits on top of
the Linux kernel NVIDIA Tegra DRM driver.  The following framebuffer
depths are supported: 8, 15, 16, 24.  All visual types are supported for
depth 8, and TrueColor visual is supported for the other depths.  RandR
1.2 is supported.
.SH SUPPORTED HARDWARE
The 
.B opentegra
driver supports all NVIDIA Tegra hardware that is supported by the Linux
kernel DRM driver.
.B opentegra
uses the Linux DRM KMS ioctls and dumb object create/map.
.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to
this driver.
.PP
For this driver it is not required to specify modes in the screen 
section of the config file.  The
.B opentegra
driver can pick up the currently used video mode from the kernel
driver and will use it if there are no video modes configured.
.PP
The following driver 
.B Options
are supported:
.TP
.BI "Option \*qdevice\*q \*q" string \*q
The DRI device to use. Default: /dev/dri/card0.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  Default: on.
.TP
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__),
X(__miscmansuffix__)
.SH AUTHORS
Authors include: Dave Airlie
