[![crates.io](https://img.shields.io/crates/v/bindgen.svg)](https://crates.io/crates/bindgen)
[![docs.rs](https://docs.rs/bindgen/badge.svg)](https://docs.rs/bindgen/)

# `bindgen`

**`bindgen` automatically generates Rust FFI bindings to C (and some C++) libraries.**

For example, given the C header `doggo.h`:

```c
typedef struct Doggo {
    int many;
    char wow;
} Doggo;

void eleven_out_of_ten_majestic_af(Doggo* pupper);
```

`bindgen` produces Rust FFI code allowing you to call into the `doggo` library's
functions and use its types:

```rust
/* automatically generated by rust-bindgen 0.99.9 */

#[repr(C)]
pub struct Doggo {
    pub many: ::std::os::raw::c_int,
    pub wow: ::std::os::raw::c_char,
}

extern "C" {
    pub fn eleven_out_of_ten_majestic_af(pupper: *mut Doggo);
}
```

## Users Guide

[📚 Read the `bindgen` users guide here! 📚](https://rust-lang.github.io/rust-bindgen)

## MSRV

The `bindgen` minimum supported Rust version is **1.60.0**.

The `bindgen-cli` minimum supported Rust version is **1.64.0**.

No MSRV bump policy has been established yet, so MSRV may increase in any release.

The MSRV is the minimum Rust version that can be used to *compile* each crate. However, `bindgen` and `bindgen-cli` can generate bindings that are compatible with Rust versions below the current MSRV.

Most of the time, the `bindgen-cli` crate will have a more recent MSRV than `bindgen` as crates such as `clap` require it. 

## API Reference

[API reference documentation is on docs.rs](https://docs.rs/bindgen)

## Environment Variables

In addition to the [library API](https://docs.rs/bindgen) and [executable command-line API][bindgen-cmdline],
`bindgen` can be controlled through environment variables.

End-users should set these environment variables to modify `bindgen`'s behavior without modifying the source code of direct consumers of `bindgen`.

- `BINDGEN_EXTRA_CLANG_ARGS`: extra arguments to pass to `clang`
    - Arguments are whitespace-separated
    - Use shell-style quoting to pass through whitespace
    - Examples:
        - Specify alternate sysroot: `--sysroot=/path/to/sysroot`
        - Add include search path with spaces: `-I"/path/with spaces"`
- `BINDGEN_EXTRA_CLANG_ARGS_<TARGET>`: similar to `BINDGEN_EXTRA_CLANG_ARGS`,
   but used to set per-target arguments to pass to clang. Useful to set system include
   directories in a target-specific way in cross-compilation environments with multiple targets.
   Has precedence over `BINDGEN_EXTRA_CLANG_ARGS`.

Additionally, `bindgen` uses `libclang` to parse C and C++ header files.
To modify how `bindgen` searches for `libclang`, see the [`clang-sys` documentation][clang-sys-env].
For more details on how `bindgen` uses `libclang`, see the [`bindgen` users guide][bindgen-book-clang].

## Releases

We don't follow a specific release calendar, but if you need a release please
file an issue requesting that (ping `@emilio` for increased effectiveness).

## Contributing

[See `CONTRIBUTING.md` for hacking on `bindgen`!](./CONTRIBUTING.md)

[bindgen-cmdline]: https://rust-lang.github.io/rust-bindgen/command-line-usage.html
[clang-sys-env]: https://github.com/KyleMayes/clang-sys#environment-variables
[bindgen-book-clang]: https://rust-lang.github.io/rust-bindgen/requirements.html#clang
