.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XStoreBytes __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XStoreBytes, XStoreBuffer, XFetchBytes, XFetchBuffer, XRotateBuffers \- manipulate cut and paste buffers
.SH SYNTAX
.HP
int XStoreBytes\^(\^Display *\fIdisplay\fP\^, _Xconst char *\fIbytes\fP\^, int
\^\fInbytes\fP\^);
.HP
int XStoreBuffer\^(\^Display *\fIdisplay\fP\^, _Xconst char *\fIbytes\fP\^, int
\^\fInbytes\fP\^, int \fIbuffer\fP\^);
.HP
char *XFetchBytes\^(\^Display *\fIdisplay\fP\^, int *\fInbytes_return\fP\^);
.HP
char *XFetchBuffer\^(\^Display *\fIdisplay\fP\^, int *\fInbytes_return\fP\^,
int \fIbuffer\fP\^);
.HP
int XRotateBuffers\^(\^Display *\fIdisplay\fP\^, int \fIrotate\fP\^);
.SH ARGUMENTS
.IP \fIbuffer\fP 1i
Specifies the buffer in which you want to store the bytes
or from which you want the stored data returned.
.IP \fIbytes\fP 1i
Specifies the bytes, which are not necessarily ASCII or null-terminated.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fInbytes\fP 1i
Specifies the number of bytes to be stored.
.IP \fInbytes_return\fP 1i
Returns the number of bytes in the buffer.
.IP \fIrotate\fP 1i
Specifies how much to rotate the cut buffers.
.SH DESCRIPTION
The data can have embedded null characters
and need not be null-terminated.
The cut buffer's contents can be retrieved later by
any client calling
.BR XFetchBytes .
.LP
.B XStoreBytes
can generate a
.B BadAlloc
error.
.LP
If an invalid buffer is specified, the call has no effect.
The data can have embedded null characters
and need not be null-terminated.
.LP
.B XStoreBuffer
can generate a
.B BadAlloc
error.
.LP
The
.B XFetchBytes
function
returns the number of bytes in the nbytes_return argument,
if the buffer contains data.
Otherwise, the function
returns NULL and sets nbytes to 0.
The appropriate amount of storage is allocated and the pointer returned.
The client must free this storage when finished with it by calling
.BR XFree .
.LP
The
.B XFetchBuffer
function returns zero to the nbytes_return argument
if there is no data in the buffer or if an invalid
buffer is specified.
.LP
.B XFetchBuffer
can generate a
.B BadValue
error.
.LP
The
.B XRotateBuffers
function rotates the cut
buffers, such that buffer 0 becomes buffer n,
buffer 1 becomes n + 1 mod 8, and so on.
This cut buffer numbering is global to the display.
Note that
.B XRotateBuffers
generates
.B BadMatch
errors if any of the eight buffers have not been created.
.LP
.B XRotateBuffers
can generate a
.B BadMatch
error.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.B BadMatch
Some argument or pair of arguments has the correct type and range but fails
to match in some other way required by the request.
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
.BR XFree (__libmansuffix__)
.br
\fI\*(xL\fP
