.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XExposeEvent __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XExposeEvent \- Expose event structure
.SH STRUCTURES
The structure for
.B Expose
events contains:
.LP
.EX
typedef struct {
        int type;       /\&* Expose */
        unsigned long serial;   /\&* # of last request processed by server */
        Bool send_event;        /\&* true if this came from a SendEvent request */
        Display *display;       /\&* Display the event was read from */
        Window window;
        int x, y;
        int width, height;
        int count;      /\&* if nonzero, at least this many more */
} XExposeEvent;
.EE
.LP
When you receive this event,
the structure members are set as follows.
.LP
The type member is set to the event type constant name that uniquely identifies
it.
For example, when the X server reports a
.B GraphicsExpose
event to a client application, it sends an
.B XGraphicsExposeEvent
structure with the type member set to
.BR GraphicsExpose .
The display member is set to a pointer to the display the event was read on.
The send_event member is set to
.B True
if the event came from a
.B SendEvent
protocol request.
The serial member is set from the serial number reported in the protocol
but expanded from the 16-bit least-significant bits to a full 32-bit value.
The window member is set to the window that is most useful to toolkit
dispatchers.
.LP
The window member is set to the exposed (damaged) window.
The x and y members are set to the coordinates relative to the window's origin
and indicate the upper-left corner of the rectangle.
The width and height members are set to the size (extent) of the rectangle.
The count member is set to the number of
.B Expose
events that are to follow.
If count is zero, no more
.B Expose
events follow for this window.
However, if count is nonzero, at least that number of
.B Expose
events (and possibly more) follow for this window.
Simple applications that do not want to optimize redisplay by distinguishing
between subareas of its window can just ignore all
.B Expose
events with nonzero counts and perform full redisplays
on events with zero counts.
.SH "SEE ALSO"
.BR XAnyEvent (__libmansuffix__),
.BR XButtonEvent (__libmansuffix__),
.BR XCreateWindowEvent (__libmansuffix__),
.BR XCirculateEvent (__libmansuffix__),
.BR XCirculateRequestEvent (__libmansuffix__),
.BR XColormapEvent (__libmansuffix__),
.BR XConfigureEvent (__libmansuffix__),
.BR XConfigureRequestEvent (__libmansuffix__),
.BR XCrossingEvent (__libmansuffix__),
.BR XDestroyWindowEvent (__libmansuffix__),
.BR XErrorEvent (__libmansuffix__),
.BR XFocusChangeEvent (__libmansuffix__),
.BR XGraphicsExposeEvent (__libmansuffix__),
.BR XGravityEvent (__libmansuffix__),
.BR XKeymapEvent (__libmansuffix__),
.BR XMapEvent (__libmansuffix__),
.BR XMapRequestEvent (__libmansuffix__),
.BR XPropertyEvent (__libmansuffix__),
.BR XReparentEvent (__libmansuffix__),
.BR XResizeRequestEvent (__libmansuffix__),
.BR XSelectionClearEvent (__libmansuffix__),
.BR XSelectionEvent (__libmansuffix__),
.BR XSelectionRequestEvent (__libmansuffix__),
.BR XUnmapEvent (__libmansuffix__),
.BR XVisibilityEvent (__libmansuffix__)
.br
\fI\*(xL\fP
