/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};

static gint ValaMethodCall_private_offset;
static gpointer vala_method_call_parent_class = NULL;
static ValaCallableExpressionIface * vala_method_call_vala_callable_expression_parent_iface = NULL;

static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_add_argument (ValaCallableExpression* base,
                                         ValaExpression* arg);
static ValaList* vala_method_call_real_get_argument_list (ValaCallableExpression* base);
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static void vala_method_call_real_get_error_types (ValaCodeNode* base,
                                            ValaCollection* collection,
                                            ValaSourceReference* source_reference);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);
static GType vala_method_call_get_type_once (void);

static inline gpointer
vala_method_call_get_instance_private (ValaMethodCall* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethodCall_private_offset);
}

static ValaExpression*
vala_method_call_real_get_call (ValaCallableExpression* base)
{
	ValaExpression* result;
	ValaMethodCall* self;
	ValaExpression* _tmp0_;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}

static gboolean
vala_method_call_real_get_is_yield_expression (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_yield_expression;
	return result;
}

static void
vala_method_call_real_set_is_yield_expression (ValaCallableExpression* base,
                                               gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_yield_expression = value;
}

gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_assert;
	return result;
}

static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}

gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_constructv_chainup;
	return result;
}

static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}

static gboolean
vala_method_call_real_get_is_chainup (ValaCallableExpression* base)
{
	gboolean result;
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	result = self->priv->_is_chainup;
	return result;
}

static void
vala_method_call_real_set_is_chainup (ValaCallableExpression* base,
                                      gboolean value)
{
	ValaMethodCall* self;
	self = (ValaMethodCall*) base;
	self->priv->_is_chainup = value;
}

/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	_tmp0_ = _vala_code_node_ref0 (call);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	return self;
}

ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}

/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
static void
vala_method_call_real_add_argument (ValaCallableExpression* base,
                                    ValaExpression* arg)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the argument list.
 *
 * @return argument list
 */
static ValaList*
vala_method_call_real_get_argument_list (ValaCallableExpression* base)
{
	ValaMethodCall * self;
	ValaList* _tmp0_;
	ValaList* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = self->priv->argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		gint _expr_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_expr_list = _tmp2_;
		_tmp3_ = _expr_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_expr_size = _tmp5_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* expr = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp6_ = _expr_index;
			_tmp7_ = _expr_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _expr_list;
			_tmp9_ = vala_list_get (_tmp8_, _expr_index);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
	}
}

static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		ValaExpression* _tmp2_;
		_tmp2_ = _vala_code_node_ref0 (new_node);
		_vala_code_node_unref0 (self->priv->_call);
		self->priv->_call = _tmp2_;
	}
	_tmp3_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp3_, old_node);
	if (index >= 0) {
		ValaList* _tmp4_;
		_tmp4_ = self->priv->argument_list;
		vala_list_set (_tmp4_, index, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}

static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean result;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = method_type;
	if (_tmp4_ != NULL) {
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean _tmp10_;
		_tmp5_ = method_type;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strcmp0 (_tmp9_, "GLib.N_") == 0;
		_g_free0 (_tmp9_);
		if (_tmp10_) {
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			gboolean _tmp14_;
			_tmp11_ = self->priv->argument_list;
			_tmp12_ = vala_list_get (_tmp11_, 0);
			_tmp13_ = (ValaExpression*) _tmp12_;
			_tmp14_ = vala_expression_is_constant (_tmp13_);
			_vala_code_node_unref0 (_tmp13_);
			result = _tmp14_;
			return result;
		} else {
			ValaMethodType* _tmp15_;
			ValaMethod* _tmp16_;
			ValaMethod* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gboolean _tmp20_;
			_tmp15_ = method_type;
			_tmp16_ = vala_method_type_get_method_symbol (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_strcmp0 (_tmp19_, "GLib.NC_") == 0;
			_g_free0 (_tmp19_);
			if (_tmp20_) {
				gboolean _tmp21_ = FALSE;
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 0);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				if (_tmp25_) {
					ValaList* _tmp26_;
					gpointer _tmp27_;
					ValaExpression* _tmp28_;
					_tmp26_ = self->priv->argument_list;
					_tmp27_ = vala_list_get (_tmp26_, 1);
					_tmp28_ = (ValaExpression*) _tmp27_;
					_tmp21_ = vala_expression_is_constant (_tmp28_);
					_vala_code_node_unref0 (_tmp28_);
				} else {
					_tmp21_ = FALSE;
				}
				result = _tmp21_;
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}

static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaExpression* arg = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaExpression* _tmp8_;
			_arg_index = _arg_index + 1;
			_tmp4_ = _arg_index;
			_tmp5_ = _arg_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _arg_list;
			_tmp7_ = vala_list_get (_tmp6_, _arg_index);
			arg = (ValaExpression*) _tmp7_;
			_tmp8_ = arg;
			if (!vala_expression_is_accessible (_tmp8_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp9_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp10_ = _tmp9_;
	result = vala_expression_is_accessible (_tmp10_, sym);
	return result;
}

static void
vala_method_call_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference)
{
	ValaMethodCall * self;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	if (source_reference == NULL) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp1_ = _tmp0_;
		source_reference = _tmp1_;
	}
	_tmp2_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_expression_get_value_type (_tmp3_);
	_tmp5_ = _tmp4_;
	mtype = _tmp5_;
	_tmp6_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp6_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_;
		_tmp7_ = mtype;
		_tmp8_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp9_ = _tmp8_;
		m = _tmp9_;
		_tmp12_ = m;
		_tmp13_ = vala_method_get_coroutine (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_) {
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp15_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp16_ = _tmp15_;
			_tmp11_ = !_tmp16_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp20_ = _tmp19_;
			_tmp10_ = g_strcmp0 (_tmp20_, "end") != 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			ValaMethod* _tmp21_;
			_tmp21_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp21_, collection, source_reference);
		}
	} else {
		gboolean _tmp22_ = FALSE;
		ValaDataType* _tmp23_;
		_tmp23_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp23_)) {
			ValaDataType* _tmp24_;
			ValaTypeSymbol* _tmp25_;
			ValaTypeSymbol* _tmp26_;
			_tmp24_ = mtype;
			_tmp25_ = vala_data_type_get_type_symbol (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp22_ = VALA_IS_CLASS (_tmp26_);
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp27_;
			ValaTypeSymbol* _tmp28_;
			ValaTypeSymbol* _tmp29_;
			ValaMethod* m = NULL;
			ValaClass* _tmp30_;
			ValaCreationMethod* _tmp31_;
			ValaCreationMethod* _tmp32_;
			ValaMethod* _tmp33_;
			_tmp27_ = mtype;
			_tmp28_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp29_ = _tmp28_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_CLASS, ValaClass);
			_tmp30_ = cl;
			_tmp31_ = vala_class_get_default_construction_method (_tmp30_);
			_tmp32_ = _tmp31_;
			m = (ValaMethod*) _tmp32_;
			_tmp33_ = m;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp33_, collection, source_reference);
		} else {
			ValaDataType* _tmp34_;
			_tmp34_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp34_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp35_;
				ValaDelegate* _tmp36_;
				ValaDelegate* _tmp37_;
				ValaDelegate* _tmp38_;
				_tmp35_ = mtype;
				_tmp36_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp37_ = _tmp36_;
				d = _tmp37_;
				_tmp38_ = d;
				vala_code_node_get_error_types ((ValaCodeNode*) _tmp38_, collection, source_reference);
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp39_;
		gint _expr_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _expr_index = 0;
		_tmp39_ = self->priv->argument_list;
		_expr_list = _tmp39_;
		_tmp40_ = _expr_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_expr_size = _tmp42_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			ValaExpression* expr = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_expr_index = _expr_index + 1;
			_tmp43_ = _expr_index;
			_tmp44_ = _expr_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _expr_list;
			_tmp46_ = vala_list_get (_tmp45_, _expr_index);
			expr = (ValaExpression*) _tmp46_;
			_tmp47_ = expr;
			vala_code_node_get_error_types ((ValaCodeNode*) _tmp47_, collection, source_reference);
			_vala_code_node_unref0 (expr);
		}
	}
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp110_;
	ValaExpression* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	gboolean _tmp115_ = FALSE;
	ValaProfile _tmp116_;
	ValaProfile _tmp117_;
	gboolean gobject_chainup = FALSE;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp143_;
	gboolean _tmp144_;
	gboolean _tmp246_ = FALSE;
	ValaExpression* _tmp247_;
	ValaExpression* _tmp248_;
	gboolean _tmp323_ = FALSE;
	gboolean _tmp324_;
	gboolean _tmp325_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp340_;
	ValaDataType* _tmp341_;
	ValaDataType* _tmp342_;
	ValaList* params = NULL;
	ValaDataType* _tmp343_;
	ValaList* _tmp344_;
	ValaList* _tmp345_;
	ValaDataType* _tmp346_;
	ValaExpression* last_arg = NULL;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp408_;
	ValaIterator* _tmp409_;
	gboolean _tmp459_ = FALSE;
	ValaDataType* _tmp460_;
	gboolean _tmp480_ = FALSE;
	ValaDataType* _tmp481_;
	gboolean force_lambda_method_closure = FALSE;
	gboolean _tmp561_ = FALSE;
	gboolean _tmp562_;
	gboolean _tmp563_;
	ValaDataType* _tmp583_;
	ValaDataType* _tmp594_;
	ValaDataType* _tmp595_;
	ValaDataType* _tmp596_;
	ValaDataType* _tmp597_;
	ValaDataType* _tmp598_;
	ValaDataType* _tmp599_;
	ValaList* _tmp600_;
	ValaDataType* _tmp601_;
	ValaDataType* _tmp602_;
	gboolean _tmp603_;
	gboolean _tmp604_;
	ValaDataType* _tmp627_;
	ValaSemanticAnalyzer* _tmp906_;
	ValaSemanticAnalyzer* _tmp907_;
	ValaDataType* _tmp908_;
	ValaList* _tmp909_;
	ValaList* _tmp910_;
	ValaList* _tmp911_;
	ValaIterator* _tmp912_;
	gboolean _tmp971_ = FALSE;
	gboolean _tmp972_ = FALSE;
	ValaCreationMethod* _tmp973_;
	ValaDataType* _tmp1001_;
	ValaDataType* _tmp1002_;
	gboolean _tmp1003_;
	gboolean _tmp1004_;
	gboolean _tmp1065_;
	gboolean _tmp1066_;
	gboolean result;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	if (VALA_IS_MEMBER_ACCESS (_tmp6_)) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_member_access_get_null_safe_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		vala_code_node_set_error ((ValaCodeNode*) self, !VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression), context));
		_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		result = !_tmp12_;
		return result;
	}
	_tmp13_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp14_ = _tmp13_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp14_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_value_type (_tmp16_);
	_tmp18_ = _tmp17_;
	if (VALA_IS_DELEGATE_TYPE (_tmp18_)) {
		ValaExpression* _tmp19_;
		ValaExpression* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		_tmp19_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_expression_get_value_type (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (_tmp22_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp23_;
	} else {
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp24_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp25_ = _tmp24_;
		if (VALA_IS_MEMBER_ACCESS (_tmp25_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaMemberAccess* _tmp28_;
			gboolean _tmp29_;
			gboolean _tmp30_;
			ValaMemberAccess* _tmp39_;
			ValaList* _tmp40_;
			ValaList* _tmp41_;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gboolean _tmp95_ = FALSE;
			ValaMemberAccess* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			_tmp26_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp27_ = _tmp26_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp28_ = ma;
			_tmp29_ = vala_member_access_get_prototype_access (_tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_) {
				ValaSourceReference* _tmp31_;
				ValaSourceReference* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaSymbol* _tmp35_;
				ValaSymbol* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_symbol_get_full_name (_tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp32_, "Access to instance member `%s' denied", _tmp38_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp39_ = ma;
			_tmp40_ = vala_member_access_get_type_arguments (_tmp39_);
			_tmp41_ = _vala_iterable_ref0 (_tmp40_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp41_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaExpression* _tmp46_;
				ValaExpression* _tmp47_;
				ValaDataType* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				ValaMemberAccess* _tmp51_;
				ValaExpression* _tmp52_;
				ValaExpression* _tmp53_;
				ValaSymbol* _tmp54_;
				ValaSymbol* _tmp55_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp66_;
				ValaSymbol* _tmp67_;
				ValaSymbol* _tmp68_;
				gboolean _tmp69_ = FALSE;
				ValaMethod* _tmp70_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_inner (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_expression_get_value_type (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _vala_code_node_ref0 (_tmp49_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp50_;
				_tmp51_ = ma;
				_tmp52_ = vala_member_access_get_inner (_tmp51_);
				_tmp53_ = _tmp52_;
				_tmp54_ = vala_expression_get_symbol_reference (_tmp53_);
				_tmp55_ = _tmp54_;
				if (VALA_IS_SIGNAL (_tmp55_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp56_;
					ValaExpression* _tmp57_;
					ValaExpression* _tmp58_;
					ValaMemberAccess* _tmp59_;
					_tmp56_ = ma;
					_tmp57_ = vala_member_access_get_inner (_tmp56_);
					_tmp58_ = _tmp57_;
					sig = VALA_IS_MEMBER_ACCESS (_tmp58_) ? ((ValaMemberAccess*) _tmp58_) : NULL;
					_tmp59_ = sig;
					if (_tmp59_ != NULL) {
						ValaMemberAccess* _tmp60_;
						ValaExpression* _tmp61_;
						ValaExpression* _tmp62_;
						ValaDataType* _tmp63_;
						ValaDataType* _tmp64_;
						ValaDataType* _tmp65_;
						_tmp60_ = sig;
						_tmp61_ = vala_member_access_get_inner (_tmp60_);
						_tmp62_ = _tmp61_;
						_tmp63_ = vala_expression_get_value_type (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = _vala_code_node_ref0 (_tmp64_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp65_;
					}
				}
				_tmp66_ = ma;
				_tmp67_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp66_);
				_tmp68_ = _tmp67_;
				m = VALA_IS_METHOD (_tmp68_) ? ((ValaMethod*) _tmp68_) : NULL;
				_tmp70_ = m;
				if (_tmp70_ != NULL) {
					ValaMethod* _tmp71_;
					gboolean _tmp72_;
					gboolean _tmp73_;
					_tmp71_ = m;
					_tmp72_ = vala_method_get_coroutine (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp69_ = _tmp73_;
				} else {
					_tmp69_ = FALSE;
				}
				if (_tmp69_) {
					gboolean _tmp74_ = FALSE;
					ValaMemberAccess* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp75_ = ma;
					_tmp76_ = vala_member_access_get_member_name (_tmp75_);
					_tmp77_ = _tmp76_;
					if (g_strcmp0 (_tmp77_, "begin") == 0) {
						_tmp74_ = TRUE;
					} else {
						ValaMemberAccess* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						_tmp78_ = ma;
						_tmp79_ = vala_member_access_get_member_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp74_ = g_strcmp0 (_tmp80_, "end") == 0;
					}
					if (_tmp74_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp81_;
						ValaExpression* _tmp82_;
						ValaExpression* _tmp83_;
						gboolean _tmp84_ = FALSE;
						ValaMemberAccess* _tmp85_;
						_tmp81_ = ma;
						_tmp82_ = vala_member_access_get_inner (_tmp81_);
						_tmp83_ = _tmp82_;
						method_access = VALA_IS_MEMBER_ACCESS (_tmp83_) ? ((ValaMemberAccess*) _tmp83_) : NULL;
						_tmp85_ = method_access;
						if (_tmp85_ != NULL) {
							ValaMemberAccess* _tmp86_;
							ValaExpression* _tmp87_;
							ValaExpression* _tmp88_;
							_tmp86_ = method_access;
							_tmp87_ = vala_member_access_get_inner (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp84_ = _tmp88_ != NULL;
						} else {
							_tmp84_ = FALSE;
						}
						if (_tmp84_) {
							ValaMemberAccess* _tmp89_;
							ValaExpression* _tmp90_;
							ValaExpression* _tmp91_;
							ValaDataType* _tmp92_;
							ValaDataType* _tmp93_;
							ValaDataType* _tmp94_;
							_tmp89_ = method_access;
							_tmp90_ = vala_member_access_get_inner (_tmp89_);
							_tmp91_ = _tmp90_;
							_tmp92_ = vala_expression_get_value_type (_tmp91_);
							_tmp93_ = _tmp92_;
							_tmp94_ = _vala_code_node_ref0 (_tmp93_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp94_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
					}
				}
			}
			_tmp96_ = ma;
			_tmp97_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp96_);
			_tmp98_ = _tmp97_;
			if (_tmp98_ != NULL) {
				ValaMemberAccess* _tmp99_;
				ValaSymbol* _tmp100_;
				ValaSymbol* _tmp101_;
				_tmp99_ = ma;
				_tmp100_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp95_ = vala_code_node_has_attribute ((ValaCodeNode*) _tmp101_, "Assert");
			} else {
				_tmp95_ = FALSE;
			}
			if (_tmp95_) {
				ValaList* _tmp102_;
				gint _tmp103_;
				gint _tmp104_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp102_ = self->priv->argument_list;
				_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
				_tmp104_ = _tmp103_;
				if (_tmp104_ == 1) {
					ValaList* _tmp105_;
					gpointer _tmp106_;
					ValaExpression* _tmp107_;
					ValaSourceReference* _tmp108_;
					ValaSourceReference* _tmp109_;
					_tmp105_ = self->priv->argument_list;
					_tmp106_ = vala_list_get (_tmp105_, 0);
					_tmp107_ = (ValaExpression*) _tmp106_;
					_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp107_);
					_tmp109_ = _tmp108_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp109_);
					_vala_code_node_unref0 (_tmp107_);
				}
			}
		}
	}
	_tmp110_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_expression_get_value_type (_tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _vala_code_node_ref0 (_tmp113_);
	mtype = _tmp114_;
	_tmp116_ = vala_code_context_get_profile (context);
	_tmp117_ = _tmp116_;
	if (_tmp117_ == VALA_PROFILE_GOBJECT) {
		ValaExpression* _tmp118_;
		ValaExpression* _tmp119_;
		ValaSymbol* _tmp120_;
		ValaSymbol* _tmp121_;
		ValaSemanticAnalyzer* _tmp122_;
		ValaSemanticAnalyzer* _tmp123_;
		ValaClass* _tmp124_;
		_tmp118_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_expression_get_symbol_reference (_tmp119_);
		_tmp121_ = _tmp120_;
		_tmp122_ = vala_code_context_get_analyzer (context);
		_tmp123_ = _tmp122_;
		_tmp124_ = _tmp123_->object_type;
		_tmp115_ = _tmp121_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_SYMBOL, ValaSymbol);
	} else {
		_tmp115_ = FALSE;
	}
	gobject_chainup = _tmp115_;
	vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, gobject_chainup);
	if (!gobject_chainup) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp125_;
		ValaExpression* _tmp126_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp137_ = FALSE;
		ValaMemberAccess* _tmp138_;
		_tmp125_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp126_ = _tmp125_;
		expr = _tmp126_;
		_tmp127_ = expr;
		ma = VALA_IS_MEMBER_ACCESS (_tmp127_) ? ((ValaMemberAccess*) _tmp127_) : NULL;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = VALA_IS_CREATION_METHOD (_tmp132_);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			expr = _tmp135_;
			_tmp136_ = expr;
			ma = VALA_IS_MEMBER_ACCESS (_tmp136_) ? ((ValaMemberAccess*) _tmp136_) : NULL;
		}
		_tmp138_ = ma;
		if (_tmp138_ != NULL) {
			ValaMemberAccess* _tmp139_;
			const gchar* _tmp140_;
			const gchar* _tmp141_;
			_tmp139_ = ma;
			_tmp140_ = vala_member_access_get_member_name (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp137_ = g_strcmp0 (_tmp141_, "this") == 0;
		} else {
			_tmp137_ = FALSE;
		}
		if (_tmp137_) {
			vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
		} else {
			ValaExpression* _tmp142_;
			_tmp142_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp142_)) {
				vala_callable_expression_set_is_chainup ((ValaCallableExpression*) self, TRUE);
			}
		}
	}
	base_cm = NULL;
	_tmp143_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp144_ = _tmp143_;
	if (_tmp144_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp145_;
		ValaSemanticAnalyzer* _tmp146_;
		ValaMethod* _tmp147_;
		ValaCreationMethod* _tmp148_;
		ValaCreationMethod* _tmp156_;
		ValaDataType* _tmp157_;
		gboolean _tmp226_ = FALSE;
		gboolean _tmp227_ = FALSE;
		ValaCreationMethod* _tmp228_;
		_tmp145_ = vala_code_context_get_analyzer (context);
		_tmp146_ = _tmp145_;
		_tmp147_ = vala_semantic_analyzer_find_current_method (_tmp146_);
		cm = VALA_IS_CREATION_METHOD (_tmp147_) ? ((ValaCreationMethod*) _tmp147_) : NULL;
		_tmp148_ = cm;
		if (_tmp148_ == NULL) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp150_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp151_;
			gboolean _tmp152_;
			gboolean _tmp153_;
			_tmp151_ = cm;
			_tmp152_ = vala_creation_method_get_chain_up (_tmp151_);
			_tmp153_ = _tmp152_;
			if (_tmp153_) {
				ValaSourceReference* _tmp154_;
				ValaSourceReference* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp155_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp156_ = cm;
		vala_creation_method_set_chain_up (_tmp156_, TRUE);
		_tmp157_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp157_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp158_;
			ValaTypeSymbol* _tmp159_;
			ValaTypeSymbol* _tmp160_;
			ValaClass* _tmp161_;
			ValaCreationMethod* _tmp162_;
			ValaCreationMethod* _tmp163_;
			ValaCreationMethod* _tmp164_;
			_tmp158_ = mtype;
			_tmp159_ = vala_data_type_get_type_symbol ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp160_ = _tmp159_;
			cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_CLASS, ValaClass);
			_tmp161_ = cl;
			_tmp162_ = vala_class_get_default_construction_method (_tmp161_);
			_tmp163_ = _tmp162_;
			base_cm = _tmp163_;
			_tmp164_ = base_cm;
			if (_tmp164_ == NULL) {
				ValaSourceReference* _tmp165_;
				ValaSourceReference* _tmp166_;
				ValaClass* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp165_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp166_ = _tmp165_;
				_tmp167_ = cl;
				_tmp168_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp167_);
				_tmp169_ = _tmp168_;
				vala_report_error (_tmp166_, "chain up to `%s' not supported", _tmp169_);
				_g_free0 (_tmp169_);
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp170_;
				gboolean _tmp171_;
				gboolean _tmp172_;
				_tmp170_ = base_cm;
				_tmp171_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp170_);
				_tmp172_ = _tmp171_;
				if (!_tmp172_) {
					ValaSourceReference* _tmp173_;
					ValaSourceReference* _tmp174_;
					ValaCreationMethod* _tmp175_;
					gchar* _tmp176_;
					gchar* _tmp177_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp174_ = _tmp173_;
					_tmp175_ = base_cm;
					_tmp176_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					vala_report_error (_tmp174_, "chain up to `%s' not supported", _tmp177_);
					_g_free0 (_tmp177_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
		} else {
			gboolean _tmp178_ = FALSE;
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			ValaSymbol* _tmp181_;
			ValaSymbol* _tmp182_;
			_tmp179_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
			_tmp182_ = _tmp181_;
			if (VALA_IS_CREATION_METHOD (_tmp182_)) {
				ValaExpression* _tmp183_;
				ValaExpression* _tmp184_;
				ValaSymbol* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				ValaSymbol* _tmp188_;
				_tmp183_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp184_ = _tmp183_;
				_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
				_tmp186_ = _tmp185_;
				_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp178_ = VALA_IS_CLASS (_tmp188_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaExpression* _tmp189_;
				ValaExpression* _tmp190_;
				ValaSymbol* _tmp191_;
				ValaSymbol* _tmp192_;
				ValaCreationMethod* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_tmp189_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp190_ = _tmp189_;
				_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
				_tmp192_ = _tmp191_;
				base_cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp192_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
				_tmp193_ = base_cm;
				_tmp194_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp193_);
				_tmp195_ = _tmp194_;
				if (!_tmp195_) {
					ValaSourceReference* _tmp196_;
					ValaSourceReference* _tmp197_;
					ValaCreationMethod* _tmp198_;
					gchar* _tmp199_;
					gchar* _tmp200_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp197_ = _tmp196_;
					_tmp198_ = base_cm;
					_tmp199_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp198_);
					_tmp200_ = _tmp199_;
					vala_report_error (_tmp197_, "chain up to `%s' not supported", _tmp200_);
					_g_free0 (_tmp200_);
					result = FALSE;
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				if (gobject_chainup) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp201_;
					ValaSymbol* _tmp202_;
					ValaSymbol* _tmp203_;
					gboolean _tmp204_ = FALSE;
					ValaClass* _tmp205_;
					ValaExpression* _tmp212_;
					ValaExpression* _tmp213_;
					ValaSemanticAnalyzer* _tmp214_;
					ValaSemanticAnalyzer* _tmp215_;
					ValaClass* _tmp216_;
					ValaSourceReference* _tmp217_;
					ValaSourceReference* _tmp218_;
					ValaObjectType* _tmp219_;
					ValaObjectType* _tmp220_;
					ValaExpression* _tmp221_;
					ValaExpression* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					ValaDataType* _tmp225_;
					_tmp201_ = cm;
					_tmp202_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp201_);
					_tmp203_ = _tmp202_;
					cl = VALA_IS_CLASS (_tmp203_) ? ((ValaClass*) _tmp203_) : NULL;
					_tmp205_ = cl;
					if (_tmp205_ == NULL) {
						_tmp204_ = TRUE;
					} else {
						ValaClass* _tmp206_;
						ValaSemanticAnalyzer* _tmp207_;
						ValaSemanticAnalyzer* _tmp208_;
						ValaClass* _tmp209_;
						_tmp206_ = cl;
						_tmp207_ = vala_code_context_get_analyzer (context);
						_tmp208_ = _tmp207_;
						_tmp209_ = _tmp208_->object_type;
						_tmp204_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp206_, (ValaTypeSymbol*) _tmp209_);
					}
					if (_tmp204_) {
						ValaSourceReference* _tmp210_;
						ValaSourceReference* _tmp211_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						vala_report_error (_tmp211_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp212_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp213_ = _tmp212_;
					_tmp214_ = vala_code_context_get_analyzer (context);
					_tmp215_ = _tmp214_;
					_tmp216_ = _tmp215_->object_type;
					_tmp217_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp218_ = _tmp217_;
					_tmp219_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp216_, _tmp218_);
					_tmp220_ = _tmp219_;
					vala_expression_set_value_type (_tmp213_, (ValaDataType*) _tmp220_);
					_vala_code_node_unref0 (_tmp220_);
					_tmp221_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
					_tmp222_ = _tmp221_;
					_tmp223_ = vala_expression_get_value_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp225_ = _vala_code_node_ref0 (_tmp224_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp225_;
				}
			}
		}
		_tmp228_ = base_cm;
		if (_tmp228_ != NULL) {
			ValaSourceReference* _tmp229_;
			ValaSourceReference* _tmp230_;
			ValaSourceFile* _tmp231_;
			ValaSourceFile* _tmp232_;
			ValaCreationMethod* _tmp233_;
			ValaSourceReference* _tmp234_;
			ValaSourceReference* _tmp235_;
			ValaSourceFile* _tmp236_;
			ValaSourceFile* _tmp237_;
			_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp230_ = _tmp229_;
			_tmp231_ = vala_source_reference_get_file (_tmp230_);
			_tmp232_ = _tmp231_;
			_tmp233_ = base_cm;
			_tmp234_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp233_);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_source_reference_get_file (_tmp235_);
			_tmp237_ = _tmp236_;
			_tmp227_ = _tmp232_ != _tmp237_;
		} else {
			_tmp227_ = FALSE;
		}
		if (_tmp227_) {
			ValaCreationMethod* _tmp238_;
			ValaSymbolAccessibility _tmp239_;
			ValaSymbolAccessibility _tmp240_;
			_tmp238_ = base_cm;
			_tmp239_ = vala_symbol_get_access ((ValaSymbol*) _tmp238_);
			_tmp240_ = _tmp239_;
			_tmp226_ = _tmp240_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
		} else {
			_tmp226_ = FALSE;
		}
		if (_tmp226_) {
			ValaSourceReference* _tmp241_;
			ValaSourceReference* _tmp242_;
			ValaCreationMethod* _tmp243_;
			gchar* _tmp244_;
			gchar* _tmp245_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp241_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp242_ = _tmp241_;
			_tmp243_ = base_cm;
			_tmp244_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp243_);
			_tmp245_ = _tmp244_;
			vala_report_error (_tmp242_, "chain up to private `%s' not possible", _tmp245_);
			_g_free0 (_tmp245_);
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp247_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp248_ = _tmp247_;
	if (VALA_IS_MEMBER_ACCESS (_tmp248_)) {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_ = FALSE;
		ValaExpression* _tmp251_;
		ValaExpression* _tmp252_;
		ValaSymbol* _tmp253_;
		ValaSymbol* _tmp254_;
		_tmp251_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_expression_get_symbol_reference (_tmp252_);
		_tmp254_ = _tmp253_;
		if (VALA_IS_CREATION_METHOD (_tmp254_)) {
			ValaExpression* _tmp255_;
			ValaExpression* _tmp256_;
			ValaSymbol* _tmp257_;
			ValaSymbol* _tmp258_;
			ValaSymbol* _tmp259_;
			ValaSymbol* _tmp260_;
			_tmp255_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp256_ = _tmp255_;
			_tmp257_ = vala_expression_get_symbol_reference (_tmp256_);
			_tmp258_ = _tmp257_;
			_tmp259_ = vala_symbol_get_parent_symbol (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp250_ = VALA_IS_STRUCT (_tmp260_);
		} else {
			_tmp250_ = FALSE;
		}
		if (_tmp250_) {
			_tmp249_ = TRUE;
		} else {
			ValaExpression* _tmp261_;
			ValaExpression* _tmp262_;
			ValaSymbol* _tmp263_;
			ValaSymbol* _tmp264_;
			_tmp261_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp262_ = _tmp261_;
			_tmp263_ = vala_expression_get_symbol_reference (_tmp262_);
			_tmp264_ = _tmp263_;
			_tmp249_ = VALA_IS_STRUCT (_tmp264_);
		}
		_tmp246_ = _tmp249_;
	} else {
		_tmp246_ = FALSE;
	}
	if (_tmp246_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp265_;
		ValaExpression* _tmp266_;
		ValaSymbol* _tmp267_;
		ValaSymbol* _tmp268_;
		gboolean _tmp269_ = FALSE;
		gboolean _tmp270_ = FALSE;
		ValaStruct* _tmp271_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp282_;
		ValaExpression* _tmp283_;
		ValaSourceReference* _tmp284_;
		ValaSourceReference* _tmp285_;
		ValaObjectCreationExpression* _tmp286_;
		ValaObjectCreationExpression* _tmp287_;
		ValaObjectCreationExpression* _tmp288_;
		gboolean _tmp289_;
		gboolean _tmp290_;
		ValaObjectCreationExpression* _tmp301_;
		ValaDataType* _tmp302_;
		ValaDataType* _tmp303_;
		ValaSemanticAnalyzer* _tmp304_;
		ValaSemanticAnalyzer* _tmp305_;
		ValaList* _tmp306_;
		ValaCodeNode* _tmp307_;
		ValaCodeNode* _tmp308_;
		ValaObjectCreationExpression* _tmp309_;
		ValaObjectCreationExpression* _tmp310_;
		_tmp265_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp266_ = _tmp265_;
		_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
		_tmp268_ = _tmp267_;
		st = VALA_IS_STRUCT (_tmp268_) ? ((ValaStruct*) _tmp268_) : NULL;
		_tmp271_ = st;
		if (_tmp271_ != NULL) {
			ValaStruct* _tmp272_;
			ValaCreationMethod* _tmp273_;
			ValaCreationMethod* _tmp274_;
			_tmp272_ = st;
			_tmp273_ = vala_struct_get_default_construction_method (_tmp272_);
			_tmp274_ = _tmp273_;
			_tmp270_ = _tmp274_ == NULL;
		} else {
			_tmp270_ = FALSE;
		}
		if (_tmp270_) {
			gboolean _tmp275_ = FALSE;
			gboolean _tmp276_ = FALSE;
			ValaStruct* _tmp277_;
			_tmp277_ = st;
			if (vala_struct_is_boolean_type (_tmp277_)) {
				_tmp276_ = TRUE;
			} else {
				ValaStruct* _tmp278_;
				_tmp278_ = st;
				_tmp276_ = vala_struct_is_integer_type (_tmp278_);
			}
			if (_tmp276_) {
				_tmp275_ = TRUE;
			} else {
				ValaStruct* _tmp279_;
				_tmp279_ = st;
				_tmp275_ = vala_struct_is_floating_type (_tmp279_);
			}
			_tmp269_ = _tmp275_;
		} else {
			_tmp269_ = FALSE;
		}
		if (_tmp269_) {
			ValaSourceReference* _tmp280_;
			ValaSourceReference* _tmp281_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp280_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp281_ = _tmp280_;
			vala_report_error (_tmp281_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp282_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp283_ = _tmp282_;
		_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp285_ = _tmp284_;
		_tmp286_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp283_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp285_);
		struct_creation_expression = _tmp286_;
		_tmp287_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp287_, TRUE);
		_tmp288_ = struct_creation_expression;
		_tmp289_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp290_ = _tmp289_;
		vala_callable_expression_set_is_chainup ((ValaCallableExpression*) _tmp288_, _tmp290_);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp291_;
			gint _arg_size = 0;
			ValaList* _tmp292_;
			gint _tmp293_;
			gint _tmp294_;
			gint _arg_index = 0;
			_tmp291_ = self->priv->argument_list;
			_arg_list = _tmp291_;
			_tmp292_ = _arg_list;
			_tmp293_ = vala_collection_get_size ((ValaCollection*) _tmp292_);
			_tmp294_ = _tmp293_;
			_arg_size = _tmp294_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp295_;
				gint _tmp296_;
				ValaExpression* arg = NULL;
				ValaList* _tmp297_;
				gpointer _tmp298_;
				ValaObjectCreationExpression* _tmp299_;
				ValaExpression* _tmp300_;
				_arg_index = _arg_index + 1;
				_tmp295_ = _arg_index;
				_tmp296_ = _arg_size;
				if (!(_tmp295_ < _tmp296_)) {
					break;
				}
				_tmp297_ = _arg_list;
				_tmp298_ = vala_list_get (_tmp297_, _arg_index);
				arg = (ValaExpression*) _tmp298_;
				_tmp299_ = struct_creation_expression;
				_tmp300_ = arg;
				vala_callable_expression_add_argument ((ValaCallableExpression*) _tmp299_, _tmp300_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp301_ = struct_creation_expression;
		_tmp302_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp303_ = _tmp302_;
		vala_expression_set_target_type ((ValaExpression*) _tmp301_, _tmp303_);
		_tmp304_ = vala_code_context_get_analyzer (context);
		_tmp305_ = _tmp304_;
		_tmp306_ = _tmp305_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp306_, (ValaCodeNode*) self);
		_tmp307_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp308_ = _tmp307_;
		_tmp309_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp308_, (ValaExpression*) self, (ValaExpression*) _tmp309_);
		_tmp310_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp310_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp311_ = FALSE;
		gboolean _tmp312_ = FALSE;
		gboolean _tmp313_;
		gboolean _tmp314_;
		_tmp313_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
		_tmp314_ = _tmp313_;
		if (!_tmp314_) {
			ValaExpression* _tmp315_;
			ValaExpression* _tmp316_;
			_tmp315_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp316_ = _tmp315_;
			_tmp312_ = VALA_IS_MEMBER_ACCESS (_tmp316_);
		} else {
			_tmp312_ = FALSE;
		}
		if (_tmp312_) {
			ValaExpression* _tmp317_;
			ValaExpression* _tmp318_;
			ValaSymbol* _tmp319_;
			ValaSymbol* _tmp320_;
			_tmp317_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp318_ = _tmp317_;
			_tmp319_ = vala_expression_get_symbol_reference (_tmp318_);
			_tmp320_ = _tmp319_;
			_tmp311_ = VALA_IS_CREATION_METHOD (_tmp320_);
		} else {
			_tmp311_ = FALSE;
		}
		if (_tmp311_) {
			ValaSourceReference* _tmp321_;
			ValaSourceReference* _tmp322_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp321_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp322_ = _tmp321_;
			vala_report_error (_tmp322_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp324_ = vala_callable_expression_get_is_chainup ((ValaCallableExpression*) self);
	_tmp325_ = _tmp324_;
	if (!_tmp325_) {
		ValaDataType* _tmp326_;
		_tmp326_ = mtype;
		_tmp323_ = VALA_IS_OBJECT_TYPE (_tmp326_);
	} else {
		_tmp323_ = FALSE;
	}
	if (_tmp323_) {
		ValaSourceReference* _tmp327_;
		ValaSourceReference* _tmp328_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp328_ = _tmp327_;
		vala_report_error (_tmp328_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp329_ = FALSE;
		ValaDataType* _tmp330_;
		_tmp330_ = mtype;
		if (_tmp330_ != NULL) {
			ValaDataType* _tmp331_;
			_tmp331_ = mtype;
			_tmp329_ = vala_data_type_is_invokable (_tmp331_);
		} else {
			_tmp329_ = FALSE;
		}
		if (_tmp329_) {
		} else {
			ValaExpression* _tmp332_;
			ValaExpression* _tmp333_;
			ValaSymbol* _tmp334_;
			ValaSymbol* _tmp335_;
			_tmp332_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_expression_get_symbol_reference (_tmp333_);
			_tmp335_ = _tmp334_;
			if (VALA_IS_CLASS (_tmp335_)) {
				ValaSourceReference* _tmp336_;
				ValaSourceReference* _tmp337_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp336_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp337_ = _tmp336_;
				vala_report_error (_tmp337_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp338_;
				ValaSourceReference* _tmp339_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp338_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp339_ = _tmp338_;
				vala_report_error (_tmp339_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp340_ = mtype;
	_tmp341_ = vala_data_type_get_return_type (_tmp340_);
	_tmp342_ = _vala_code_node_ref0 (_tmp341_);
	ret_type = _tmp342_;
	_tmp343_ = mtype;
	_tmp344_ = vala_data_type_get_parameters (_tmp343_);
	_tmp345_ = _vala_iterable_ref0 (_tmp344_);
	params = _tmp345_;
	_tmp346_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp346_)) {
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp347_;
		ValaExpression* _tmp348_;
		ValaMethod* m = NULL;
		ValaDataType* _tmp349_;
		ValaMethod* _tmp350_;
		ValaMethod* _tmp351_;
		ValaMethod* _tmp352_;
		gboolean _tmp353_;
		gboolean _tmp354_;
		gint n_type_params = 0;
		ValaMethod* _tmp386_;
		ValaList* _tmp387_;
		gint _tmp388_;
		gint _tmp389_;
		gint n_type_args = 0;
		ValaMemberAccess* _tmp390_;
		ValaList* _tmp391_;
		gint _tmp392_;
		gint _tmp393_;
		gboolean _tmp394_ = FALSE;
		_tmp347_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp348_ = _tmp347_;
		ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
		_tmp349_ = mtype;
		_tmp350_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp349_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp351_ = _tmp350_;
		m = _tmp351_;
		_tmp352_ = m;
		_tmp353_ = vala_method_get_coroutine (_tmp352_);
		_tmp354_ = _tmp353_;
		if (_tmp354_) {
			gboolean _tmp355_;
			gboolean _tmp356_;
			_tmp355_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
			_tmp356_ = _tmp355_;
			if (!_tmp356_) {
				ValaMemberAccess* _tmp357_;
				const gchar* _tmp358_;
				const gchar* _tmp359_;
				_tmp357_ = ma;
				_tmp358_ = vala_member_access_get_member_name (_tmp357_);
				_tmp359_ = _tmp358_;
				if (g_strcmp0 (_tmp359_, "end") != 0) {
					ValaMemberAccess* _tmp360_;
					const gchar* _tmp361_;
					const gchar* _tmp362_;
					ValaMethod* _tmp366_;
					ValaList* _tmp367_;
					ValaList* _tmp368_;
					ValaVoidType* _tmp369_;
					_tmp360_ = ma;
					_tmp361_ = vala_member_access_get_member_name (_tmp360_);
					_tmp362_ = _tmp361_;
					if (g_strcmp0 (_tmp362_, "begin") != 0) {
						ValaMemberAccess* _tmp363_;
						ValaSourceReference* _tmp364_;
						ValaSourceReference* _tmp365_;
						_tmp363_ = ma;
						_tmp364_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp363_);
						_tmp365_ = _tmp364_;
						vala_report_deprecated (_tmp365_, "implicit .begin is deprecated");
					}
					_tmp366_ = m;
					_tmp367_ = vala_method_get_async_begin_parameters (_tmp366_);
					_tmp368_ = _vala_iterable_ref0 (_tmp367_);
					_vala_iterable_unref0 (params);
					params = _tmp368_;
					_tmp369_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp369_;
				} else {
					ValaMethod* _tmp370_;
					ValaList* _tmp371_;
					ValaList* _tmp372_;
					_tmp370_ = m;
					_tmp371_ = vala_method_get_async_end_parameters (_tmp370_);
					_tmp372_ = _vala_iterable_ref0 (_tmp371_);
					_vala_iterable_unref0 (params);
					params = _tmp372_;
				}
			} else {
				gboolean _tmp373_ = FALSE;
				ValaMemberAccess* _tmp374_;
				const gchar* _tmp375_;
				const gchar* _tmp376_;
				_tmp374_ = ma;
				_tmp375_ = vala_member_access_get_member_name (_tmp374_);
				_tmp376_ = _tmp375_;
				if (g_strcmp0 (_tmp376_, "begin") == 0) {
					_tmp373_ = TRUE;
				} else {
					ValaMemberAccess* _tmp377_;
					const gchar* _tmp378_;
					const gchar* _tmp379_;
					_tmp377_ = ma;
					_tmp378_ = vala_member_access_get_member_name (_tmp377_);
					_tmp379_ = _tmp378_;
					_tmp373_ = g_strcmp0 (_tmp379_, "end") == 0;
				}
				if (_tmp373_) {
					ValaMemberAccess* _tmp380_;
					ValaSourceReference* _tmp381_;
					ValaSourceReference* _tmp382_;
					ValaMemberAccess* _tmp383_;
					const gchar* _tmp384_;
					const gchar* _tmp385_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp380_ = ma;
					_tmp381_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp380_);
					_tmp382_ = _tmp381_;
					_tmp383_ = ma;
					_tmp384_ = vala_member_access_get_member_name (_tmp383_);
					_tmp385_ = _tmp384_;
					vala_report_error (_tmp382_, "use of `%s' not allowed in yield statement", _tmp385_);
				}
			}
		}
		_tmp386_ = m;
		_tmp387_ = vala_method_get_type_parameters (_tmp386_);
		_tmp388_ = vala_collection_get_size ((ValaCollection*) _tmp387_);
		_tmp389_ = _tmp388_;
		n_type_params = _tmp389_;
		_tmp390_ = ma;
		_tmp391_ = vala_member_access_get_type_arguments (_tmp390_);
		_tmp392_ = vala_collection_get_size ((ValaCollection*) _tmp391_);
		_tmp393_ = _tmp392_;
		n_type_args = _tmp393_;
		if (n_type_args > 0) {
			_tmp394_ = n_type_args < n_type_params;
		} else {
			_tmp394_ = FALSE;
		}
		if (_tmp394_) {
			ValaMemberAccess* _tmp395_;
			ValaSourceReference* _tmp396_;
			ValaSourceReference* _tmp397_;
			ValaMethod* _tmp398_;
			gchar* _tmp399_;
			gchar* _tmp400_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp395_ = ma;
			_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp395_);
			_tmp397_ = _tmp396_;
			_tmp398_ = m;
			_tmp399_ = vala_code_node_to_string ((ValaCodeNode*) _tmp398_);
			_tmp400_ = _tmp399_;
			vala_report_error (_tmp397_, "too few type arguments for `%s'", _tmp400_);
			_g_free0 (_tmp400_);
			result = FALSE;
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			gboolean _tmp401_ = FALSE;
			if (n_type_args > 0) {
				_tmp401_ = n_type_args > n_type_params;
			} else {
				_tmp401_ = FALSE;
			}
			if (_tmp401_) {
				ValaMemberAccess* _tmp402_;
				ValaSourceReference* _tmp403_;
				ValaSourceReference* _tmp404_;
				ValaMethod* _tmp405_;
				gchar* _tmp406_;
				gchar* _tmp407_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp402_ = ma;
				_tmp403_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp402_);
				_tmp404_ = _tmp403_;
				_tmp405_ = m;
				_tmp406_ = vala_code_node_to_string ((ValaCodeNode*) _tmp405_);
				_tmp407_ = _tmp406_;
				vala_report_error (_tmp404_, "too many type arguments for `%s'", _tmp407_);
				_g_free0 (_tmp407_);
				result = FALSE;
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	last_arg = NULL;
	_tmp408_ = self->priv->argument_list;
	_tmp409_ = vala_iterable_iterator ((ValaIterable*) _tmp408_);
	arg_it = _tmp409_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp410_;
		gint _param_size = 0;
		ValaList* _tmp411_;
		gint _tmp412_;
		gint _tmp413_;
		gint _param_index = 0;
		_tmp410_ = params;
		_param_list = _tmp410_;
		_tmp411_ = _param_list;
		_tmp412_ = vala_collection_get_size ((ValaCollection*) _tmp411_);
		_tmp413_ = _tmp412_;
		_param_size = _tmp413_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp414_;
			gint _tmp415_;
			ValaParameter* param = NULL;
			ValaList* _tmp416_;
			gpointer _tmp417_;
			ValaParameter* _tmp418_;
			ValaParameter* _tmp419_;
			gboolean _tmp420_;
			gboolean _tmp421_;
			ValaParameter* _tmp422_;
			gboolean _tmp423_;
			gboolean _tmp424_;
			ValaIterator* _tmp442_;
			_param_index = _param_index + 1;
			_tmp414_ = _param_index;
			_tmp415_ = _param_size;
			if (!(_tmp414_ < _tmp415_)) {
				break;
			}
			_tmp416_ = _param_list;
			_tmp417_ = vala_list_get (_tmp416_, _param_index);
			param = (ValaParameter*) _tmp417_;
			_tmp418_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp418_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp419_ = param;
			_tmp420_ = vala_parameter_get_ellipsis (_tmp419_);
			_tmp421_ = _tmp420_;
			if (_tmp421_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp422_ = param;
			_tmp423_ = vala_parameter_get_params_array (_tmp422_);
			_tmp424_ = _tmp423_;
			if (_tmp424_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp425_;
				ValaDataType* _tmp426_;
				ValaDataType* _tmp427_;
				ValaArrayType* _tmp428_;
				_tmp425_ = param;
				_tmp426_ = vala_variable_get_variable_type ((ValaVariable*) _tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp427_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp428_;
				while (TRUE) {
					ValaIterator* _tmp429_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp430_;
					gpointer _tmp431_;
					ValaExpression* _tmp432_;
					ValaArrayType* _tmp433_;
					ValaDataType* _tmp434_;
					ValaDataType* _tmp435_;
					ValaExpression* _tmp436_;
					ValaDataType* _tmp437_;
					ValaDataType* _tmp438_;
					ValaArrayType* _tmp439_;
					gboolean _tmp440_;
					gboolean _tmp441_;
					_tmp429_ = arg_it;
					if (!vala_iterator_next (_tmp429_)) {
						break;
					}
					_tmp430_ = arg_it;
					_tmp431_ = vala_iterator_get (_tmp430_);
					arg = (ValaExpression*) _tmp431_;
					_tmp432_ = arg;
					_tmp433_ = array_type;
					_tmp434_ = vala_array_type_get_element_type (_tmp433_);
					_tmp435_ = _tmp434_;
					vala_expression_set_target_type (_tmp432_, _tmp435_);
					_tmp436_ = arg;
					_tmp437_ = vala_expression_get_target_type (_tmp436_);
					_tmp438_ = _tmp437_;
					_tmp439_ = array_type;
					_tmp440_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp439_);
					_tmp441_ = _tmp440_;
					vala_data_type_set_value_owned (_tmp438_, _tmp441_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp442_ = arg_it;
			if (vala_iterator_next (_tmp442_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp443_;
				gpointer _tmp444_;
				ValaExpression* _tmp445_;
				ValaParameter* _tmp446_;
				ValaDataType* _tmp447_;
				ValaDataType* _tmp448_;
				ValaExpression* _tmp449_;
				ValaExpression* _tmp450_;
				ValaDataType* _tmp451_;
				ValaDataType* _tmp452_;
				ValaDataType* _tmp453_;
				ValaList* _tmp454_;
				ValaDataType* _tmp455_;
				ValaDataType* _tmp456_;
				ValaExpression* _tmp457_;
				ValaExpression* _tmp458_;
				_tmp443_ = arg_it;
				_tmp444_ = vala_iterator_get (_tmp443_);
				arg = (ValaExpression*) _tmp444_;
				_tmp445_ = arg;
				_tmp446_ = param;
				_tmp447_ = vala_variable_get_variable_type ((ValaVariable*) _tmp446_);
				_tmp448_ = _tmp447_;
				vala_expression_set_formal_target_type (_tmp445_, _tmp448_);
				_tmp449_ = arg;
				_tmp450_ = arg;
				_tmp451_ = vala_expression_get_formal_target_type (_tmp450_);
				_tmp452_ = _tmp451_;
				_tmp453_ = target_object_type;
				_tmp454_ = method_type_args;
				_tmp455_ = vala_data_type_get_actual_type (_tmp452_, _tmp453_, _tmp454_, (ValaCodeNode*) self);
				_tmp456_ = _tmp455_;
				vala_expression_set_target_type (_tmp449_, _tmp456_);
				_vala_code_node_unref0 (_tmp456_);
				_tmp457_ = arg;
				_tmp458_ = _vala_code_node_ref0 (_tmp457_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp458_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp460_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp460_)) {
		ValaDataType* _tmp461_;
		ValaMethod* _tmp462_;
		ValaMethod* _tmp463_;
		_tmp461_ = mtype;
		_tmp462_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp463_ = _tmp462_;
		_tmp459_ = vala_code_node_has_attribute ((ValaCodeNode*) _tmp463_, "Print");
	} else {
		_tmp459_ = FALSE;
	}
	if (_tmp459_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp464_;
		ValaSourceReference* _tmp465_;
		ValaTemplate* _tmp466_;
		ValaList* _tmp478_;
		ValaTemplate* _tmp479_;
		_tmp464_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp465_ = _tmp464_;
		_tmp466_ = vala_template_new (_tmp465_);
		template = _tmp466_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp467_;
			gint _arg_size = 0;
			ValaList* _tmp468_;
			gint _tmp469_;
			gint _tmp470_;
			gint _arg_index = 0;
			_tmp467_ = self->priv->argument_list;
			_arg_list = _tmp467_;
			_tmp468_ = _arg_list;
			_tmp469_ = vala_collection_get_size ((ValaCollection*) _tmp468_);
			_tmp470_ = _tmp469_;
			_arg_size = _tmp470_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp471_;
				gint _tmp472_;
				ValaExpression* arg = NULL;
				ValaList* _tmp473_;
				gpointer _tmp474_;
				ValaExpression* _tmp475_;
				ValaTemplate* _tmp476_;
				ValaExpression* _tmp477_;
				_arg_index = _arg_index + 1;
				_tmp471_ = _arg_index;
				_tmp472_ = _arg_size;
				if (!(_tmp471_ < _tmp472_)) {
					break;
				}
				_tmp473_ = _arg_list;
				_tmp474_ = vala_list_get (_tmp473_, _arg_index);
				arg = (ValaExpression*) _tmp474_;
				_tmp475_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp475_, NULL);
				_tmp476_ = template;
				_tmp477_ = arg;
				vala_template_add_expression (_tmp476_, _tmp477_);
				_vala_code_node_unref0 (arg);
			}
		}
		_tmp478_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp478_);
		_tmp479_ = template;
		vala_callable_expression_add_argument ((ValaCallableExpression*) self, (ValaExpression*) _tmp479_);
		_vala_code_node_unref0 (template);
	}
	_tmp481_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp481_)) {
		ValaDataType* _tmp482_;
		ValaMethod* _tmp483_;
		ValaMethod* _tmp484_;
		gboolean _tmp485_;
		gboolean _tmp486_;
		_tmp482_ = mtype;
		_tmp483_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp482_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp484_ = _tmp483_;
		_tmp485_ = vala_method_get_printf_format (_tmp484_);
		_tmp486_ = _tmp485_;
		_tmp480_ = _tmp486_;
	} else {
		_tmp480_ = FALSE;
	}
	if (_tmp480_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp487_;
		ValaStringLiteral* _tmp536_;
		format_literal = NULL;
		_tmp487_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp487_)) {
		} else {
			ValaExpression* _tmp488_;
			_tmp488_ = last_arg;
			if (_tmp488_ != NULL) {
				ValaExpression* _tmp489_;
				ValaStringLiteral* _tmp490_;
				gboolean _tmp491_ = FALSE;
				ValaStringLiteral* _tmp492_;
				_tmp489_ = last_arg;
				_tmp490_ = vala_string_literal_get_format_literal (_tmp489_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp490_;
				_tmp492_ = format_literal;
				if (_tmp492_ == NULL) {
					ValaList* _tmp493_;
					gint _tmp494_;
					gint _tmp495_;
					ValaList* _tmp496_;
					gint _tmp497_;
					gint _tmp498_;
					_tmp493_ = self->priv->argument_list;
					_tmp494_ = vala_collection_get_size ((ValaCollection*) _tmp493_);
					_tmp495_ = _tmp494_;
					_tmp496_ = params;
					_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
					_tmp498_ = _tmp497_;
					_tmp491_ = _tmp495_ == (_tmp498_ - 1);
				} else {
					_tmp491_ = FALSE;
				}
				if (_tmp491_) {
					ValaStringLiteral* _tmp499_;
					ValaStringLiteral* _tmp500_;
					ValaSemanticAnalyzer* _tmp501_;
					ValaSemanticAnalyzer* _tmp502_;
					ValaDataType* _tmp503_;
					ValaDataType* _tmp504_;
					ValaDataType* _tmp505_;
					ValaList* _tmp506_;
					ValaList* _tmp507_;
					gint _tmp508_;
					gint _tmp509_;
					ValaStringLiteral* _tmp510_;
					ValaList* _tmp511_;
					ValaIterator* _tmp512_;
					_tmp499_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp499_;
					_tmp500_ = format_literal;
					_tmp501_ = vala_code_context_get_analyzer (context);
					_tmp502_ = _tmp501_;
					_tmp503_ = _tmp502_->string_type;
					_tmp504_ = vala_data_type_copy (_tmp503_);
					_tmp505_ = _tmp504_;
					vala_expression_set_target_type ((ValaExpression*) _tmp500_, _tmp505_);
					_vala_code_node_unref0 (_tmp505_);
					_tmp506_ = self->priv->argument_list;
					_tmp507_ = self->priv->argument_list;
					_tmp508_ = vala_collection_get_size ((ValaCollection*) _tmp507_);
					_tmp509_ = _tmp508_;
					_tmp510_ = format_literal;
					vala_list_insert (_tmp506_, _tmp509_ - 1, (ValaExpression*) _tmp510_);
					_tmp511_ = self->priv->argument_list;
					_tmp512_ = vala_iterable_iterator ((ValaIterable*) _tmp511_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp512_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp513_;
						gint _param_size = 0;
						ValaList* _tmp514_;
						gint _tmp515_;
						gint _tmp516_;
						gint _param_index = 0;
						_tmp513_ = params;
						_param_list = _tmp513_;
						_tmp514_ = _param_list;
						_tmp515_ = vala_collection_get_size ((ValaCollection*) _tmp514_);
						_tmp516_ = _tmp515_;
						_param_size = _tmp516_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp517_;
							gint _tmp518_;
							ValaParameter* param = NULL;
							ValaList* _tmp519_;
							gpointer _tmp520_;
							gboolean _tmp521_ = FALSE;
							ValaParameter* _tmp522_;
							gboolean _tmp523_;
							gboolean _tmp524_;
							ValaIterator* _tmp528_;
							_param_index = _param_index + 1;
							_tmp517_ = _param_index;
							_tmp518_ = _param_size;
							if (!(_tmp517_ < _tmp518_)) {
								break;
							}
							_tmp519_ = _param_list;
							_tmp520_ = vala_list_get (_tmp519_, _param_index);
							param = (ValaParameter*) _tmp520_;
							_tmp522_ = param;
							_tmp523_ = vala_parameter_get_ellipsis (_tmp522_);
							_tmp524_ = _tmp523_;
							if (_tmp524_) {
								_tmp521_ = TRUE;
							} else {
								ValaParameter* _tmp525_;
								gboolean _tmp526_;
								gboolean _tmp527_;
								_tmp525_ = param;
								_tmp526_ = vala_parameter_get_params_array (_tmp525_);
								_tmp527_ = _tmp526_;
								_tmp521_ = _tmp527_;
							}
							if (_tmp521_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp528_ = arg_it;
							vala_iterator_next (_tmp528_);
							_vala_code_node_unref0 (param);
						}
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp529_;
				ValaExpression* _tmp530_;
				ValaMemberAccess* _tmp531_;
				_tmp529_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
				_tmp530_ = _tmp529_;
				ma = VALA_IS_MEMBER_ACCESS (_tmp530_) ? ((ValaMemberAccess*) _tmp530_) : NULL;
				_tmp531_ = ma;
				if (_tmp531_ != NULL) {
					ValaMemberAccess* _tmp532_;
					ValaExpression* _tmp533_;
					ValaExpression* _tmp534_;
					ValaStringLiteral* _tmp535_;
					_tmp532_ = ma;
					_tmp533_ = vala_member_access_get_inner (_tmp532_);
					_tmp534_ = _tmp533_;
					_tmp535_ = vala_string_literal_get_format_literal (_tmp534_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp535_;
				}
			}
		}
		_tmp536_ = format_literal;
		if (_tmp536_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp537_;
			gchar* _tmp538_;
			ValaSemanticAnalyzer* _tmp539_;
			ValaSemanticAnalyzer* _tmp540_;
			const gchar* _tmp541_;
			ValaIterator* _tmp542_;
			ValaSourceReference* _tmp543_;
			ValaSourceReference* _tmp544_;
			_tmp537_ = format_literal;
			_tmp538_ = vala_string_literal_eval (_tmp537_);
			format = _tmp538_;
			_tmp539_ = vala_code_context_get_analyzer (context);
			_tmp540_ = _tmp539_;
			_tmp541_ = format;
			_tmp542_ = arg_it;
			_tmp543_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp544_ = _tmp543_;
			if (!vala_semantic_analyzer_check_print_format (_tmp540_, _tmp541_, _tmp542_, _tmp544_)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	force_lambda_method_closure = FALSE;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp545_;
		gint _arg_size = 0;
		ValaList* _tmp546_;
		gint _tmp547_;
		gint _tmp548_;
		gint _arg_index = 0;
		_tmp545_ = self->priv->argument_list;
		_arg_list = _tmp545_;
		_tmp546_ = _arg_list;
		_tmp547_ = vala_collection_get_size ((ValaCollection*) _tmp546_);
		_tmp548_ = _tmp547_;
		_arg_size = _tmp548_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp549_;
			gint _tmp550_;
			ValaExpression* arg = NULL;
			ValaList* _tmp551_;
			gpointer _tmp552_;
			ValaExpression* _tmp553_;
			gboolean _tmp554_ = FALSE;
			ValaExpression* _tmp555_;
			_arg_index = _arg_index + 1;
			_tmp549_ = _arg_index;
			_tmp550_ = _arg_size;
			if (!(_tmp549_ < _tmp550_)) {
				break;
			}
			_tmp551_ = _arg_list;
			_tmp552_ = vala_list_get (_tmp551_, _arg_index);
			arg = (ValaExpression*) _tmp552_;
			_tmp553_ = arg;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp553_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp555_ = arg;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp555_)) {
				ValaExpression* _tmp556_;
				ValaMethod* _tmp557_;
				ValaMethod* _tmp558_;
				gboolean _tmp559_;
				gboolean _tmp560_;
				_tmp556_ = arg;
				_tmp557_ = vala_lambda_expression_get_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp556_, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression));
				_tmp558_ = _tmp557_;
				_tmp559_ = vala_method_get_closure (_tmp558_);
				_tmp560_ = _tmp559_;
				_tmp554_ = _tmp560_;
			} else {
				_tmp554_ = FALSE;
			}
			if (_tmp554_) {
				force_lambda_method_closure = TRUE;
			}
			_vala_code_node_unref0 (arg);
		}
	}
	_tmp562_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp563_ = _tmp562_;
	if (!_tmp563_) {
		_tmp561_ = force_lambda_method_closure;
	} else {
		_tmp561_ = FALSE;
	}
	if (_tmp561_) {
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp564_;
			gint _arg_size = 0;
			ValaList* _tmp565_;
			gint _tmp566_;
			gint _tmp567_;
			gint _arg_index = 0;
			_tmp564_ = self->priv->argument_list;
			_arg_list = _tmp564_;
			_tmp565_ = _arg_list;
			_tmp566_ = vala_collection_get_size ((ValaCollection*) _tmp565_);
			_tmp567_ = _tmp566_;
			_arg_size = _tmp567_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp568_;
				gint _tmp569_;
				ValaExpression* arg = NULL;
				ValaList* _tmp570_;
				gpointer _tmp571_;
				ValaLambdaExpression* lambda = NULL;
				ValaExpression* _tmp572_;
				gboolean _tmp573_ = FALSE;
				ValaLambdaExpression* _tmp574_;
				_arg_index = _arg_index + 1;
				_tmp568_ = _arg_index;
				_tmp569_ = _arg_size;
				if (!(_tmp568_ < _tmp569_)) {
					break;
				}
				_tmp570_ = _arg_list;
				_tmp571_ = vala_list_get (_tmp570_, _arg_index);
				arg = (ValaExpression*) _tmp571_;
				_tmp572_ = arg;
				lambda = VALA_IS_LAMBDA_EXPRESSION (_tmp572_) ? ((ValaLambdaExpression*) _tmp572_) : NULL;
				_tmp574_ = lambda;
				if (_tmp574_ != NULL) {
					ValaLambdaExpression* _tmp575_;
					ValaMethod* _tmp576_;
					ValaMethod* _tmp577_;
					ValaMemberBinding _tmp578_;
					ValaMemberBinding _tmp579_;
					_tmp575_ = lambda;
					_tmp576_ = vala_lambda_expression_get_method (_tmp575_);
					_tmp577_ = _tmp576_;
					_tmp578_ = vala_method_get_binding (_tmp577_);
					_tmp579_ = _tmp578_;
					_tmp573_ = _tmp579_ != VALA_MEMBER_BINDING_STATIC;
				} else {
					_tmp573_ = FALSE;
				}
				if (_tmp573_) {
					ValaLambdaExpression* _tmp580_;
					ValaMethod* _tmp581_;
					ValaMethod* _tmp582_;
					_tmp580_ = lambda;
					_tmp581_ = vala_lambda_expression_get_method (_tmp580_);
					_tmp582_ = _tmp581_;
					vala_method_set_closure (_tmp582_, TRUE);
				}
				_vala_code_node_unref0 (arg);
			}
		}
	}
	_tmp583_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp583_)) {
		gboolean _tmp584_ = FALSE;
		gboolean _tmp585_ = FALSE;
		ValaCodeNode* _tmp586_;
		ValaCodeNode* _tmp587_;
		_tmp586_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp587_ = _tmp586_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp587_)) {
			ValaCodeNode* _tmp588_;
			ValaCodeNode* _tmp589_;
			_tmp588_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp589_ = _tmp588_;
			_tmp585_ = !VALA_IS_FOR_STATEMENT (_tmp589_);
		} else {
			_tmp585_ = FALSE;
		}
		if (_tmp585_) {
			ValaCodeNode* _tmp590_;
			ValaCodeNode* _tmp591_;
			_tmp590_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp591_ = _tmp590_;
			_tmp584_ = !VALA_IS_YIELD_STATEMENT (_tmp591_);
		} else {
			_tmp584_ = FALSE;
		}
		if (_tmp584_) {
			ValaSourceReference* _tmp592_;
			ValaSourceReference* _tmp593_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp593_ = _tmp592_;
			vala_report_error (_tmp593_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp594_ = ret_type;
	_tmp595_ = vala_data_type_copy (_tmp594_);
	_tmp596_ = _tmp595_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp596_);
	_vala_code_node_unref0 (_tmp596_);
	_tmp597_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp598_ = _tmp597_;
	_tmp599_ = target_object_type;
	_tmp600_ = method_type_args;
	_tmp601_ = vala_data_type_get_actual_type (_tmp598_, _tmp599_, _tmp600_, (ValaCodeNode*) self);
	_tmp602_ = _tmp601_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp602_);
	_vala_code_node_unref0 (_tmp602_);
	_tmp603_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp604_ = _tmp603_;
	if (_tmp604_) {
		gboolean _tmp605_ = FALSE;
		ValaDataType* _tmp606_;
		gboolean _tmp614_ = FALSE;
		ValaSemanticAnalyzer* _tmp615_;
		ValaSemanticAnalyzer* _tmp616_;
		ValaMethod* _tmp617_;
		ValaMethod* _tmp618_;
		_tmp606_ = mtype;
		if (!VALA_IS_METHOD_TYPE (_tmp606_)) {
			_tmp605_ = TRUE;
		} else {
			ValaDataType* _tmp607_;
			ValaMethod* _tmp608_;
			ValaMethod* _tmp609_;
			gboolean _tmp610_;
			gboolean _tmp611_;
			_tmp607_ = mtype;
			_tmp608_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp607_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
			_tmp609_ = _tmp608_;
			_tmp610_ = vala_method_get_coroutine (_tmp609_);
			_tmp611_ = _tmp610_;
			_tmp605_ = !_tmp611_;
		}
		if (_tmp605_) {
			ValaSourceReference* _tmp612_;
			ValaSourceReference* _tmp613_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp612_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp613_ = _tmp612_;
			vala_report_error (_tmp613_, "yield expression requires async method");
		}
		_tmp615_ = vala_code_context_get_analyzer (context);
		_tmp616_ = _tmp615_;
		_tmp617_ = vala_semantic_analyzer_get_current_method (_tmp616_);
		_tmp618_ = _tmp617_;
		if (_tmp618_ == NULL) {
			_tmp614_ = TRUE;
		} else {
			ValaSemanticAnalyzer* _tmp619_;
			ValaSemanticAnalyzer* _tmp620_;
			ValaMethod* _tmp621_;
			ValaMethod* _tmp622_;
			gboolean _tmp623_;
			gboolean _tmp624_;
			_tmp619_ = vala_code_context_get_analyzer (context);
			_tmp620_ = _tmp619_;
			_tmp621_ = vala_semantic_analyzer_get_current_method (_tmp620_);
			_tmp622_ = _tmp621_;
			_tmp623_ = vala_method_get_coroutine (_tmp622_);
			_tmp624_ = _tmp623_;
			_tmp614_ = !_tmp624_;
		}
		if (_tmp614_) {
			ValaSourceReference* _tmp625_;
			ValaSourceReference* _tmp626_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp625_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp626_ = _tmp625_;
			vala_report_error (_tmp626_, "yield expression not available outside async method");
		}
	}
	_tmp627_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp627_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp628_;
		ValaMethod* _tmp629_;
		ValaMethod* _tmp630_;
		ValaMethod* _tmp631_;
		gboolean _tmp632_;
		gboolean _tmp633_;
		ValaMethod* _tmp636_;
		gboolean _tmp637_;
		gboolean _tmp638_;
		gboolean _tmp664_ = FALSE;
		gboolean _tmp665_ = FALSE;
		gboolean _tmp666_ = FALSE;
		gboolean _tmp667_;
		gboolean _tmp668_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp680_;
		ValaSymbol* _tmp681_;
		ValaSymbol* _tmp682_;
		gboolean _tmp683_ = FALSE;
		ValaSignal* _tmp684_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp697_;
		ValaSymbol* _tmp698_;
		ValaSymbol* _tmp699_;
		gboolean _tmp700_ = FALSE;
		ValaDynamicSignal* _tmp701_;
		gboolean _tmp746_ = FALSE;
		ValaMethod* _tmp747_;
		gboolean _tmp891_ = FALSE;
		ValaMethod* _tmp892_;
		_tmp628_ = mtype;
		_tmp629_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp628_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp630_ = _tmp629_;
		m = _tmp630_;
		_tmp631_ = m;
		_tmp632_ = vala_method_get_returns_floating_reference (_tmp631_);
		_tmp633_ = _tmp632_;
		if (_tmp633_) {
			ValaDataType* _tmp634_;
			ValaDataType* _tmp635_;
			_tmp634_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp635_ = _tmp634_;
			vala_data_type_set_floating_reference (_tmp635_, TRUE);
		}
		_tmp636_ = m;
		_tmp637_ = vala_method_get_returns_modified_pointer (_tmp636_);
		_tmp638_ = _tmp637_;
		if (_tmp638_) {
			ValaExpression* inner = NULL;
			ValaExpression* _tmp639_;
			ValaExpression* _tmp640_;
			ValaExpression* _tmp641_;
			ValaExpression* _tmp642_;
			ValaExpression* _tmp643_;
			ValaProperty* prop = NULL;
			ValaExpression* _tmp644_;
			ValaSymbol* _tmp645_;
			ValaSymbol* _tmp646_;
			gboolean _tmp647_ = FALSE;
			ValaProperty* _tmp648_;
			_tmp639_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp640_ = _tmp639_;
			_tmp641_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp640_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp642_ = _tmp641_;
			inner = _tmp642_;
			_tmp643_ = inner;
			vala_expression_set_lvalue (_tmp643_, TRUE);
			_tmp644_ = inner;
			_tmp645_ = vala_expression_get_symbol_reference (_tmp644_);
			_tmp646_ = _tmp645_;
			prop = VALA_IS_PROPERTY (_tmp646_) ? ((ValaProperty*) _tmp646_) : NULL;
			_tmp648_ = prop;
			if (_tmp648_ != NULL) {
				gboolean _tmp649_ = FALSE;
				ValaProperty* _tmp650_;
				ValaPropertyAccessor* _tmp651_;
				ValaPropertyAccessor* _tmp652_;
				_tmp650_ = prop;
				_tmp651_ = vala_property_get_set_accessor (_tmp650_);
				_tmp652_ = _tmp651_;
				if (_tmp652_ == NULL) {
					_tmp649_ = TRUE;
				} else {
					ValaProperty* _tmp653_;
					ValaPropertyAccessor* _tmp654_;
					ValaPropertyAccessor* _tmp655_;
					gboolean _tmp656_;
					gboolean _tmp657_;
					_tmp653_ = prop;
					_tmp654_ = vala_property_get_set_accessor (_tmp653_);
					_tmp655_ = _tmp654_;
					_tmp656_ = vala_property_accessor_get_writable (_tmp655_);
					_tmp657_ = _tmp656_;
					_tmp649_ = !_tmp657_;
				}
				_tmp647_ = _tmp649_;
			} else {
				_tmp647_ = FALSE;
			}
			if (_tmp647_) {
				ValaExpression* _tmp658_;
				ValaSourceReference* _tmp659_;
				ValaSourceReference* _tmp660_;
				ValaProperty* _tmp661_;
				gchar* _tmp662_;
				gchar* _tmp663_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp658_ = inner;
				_tmp659_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp658_);
				_tmp660_ = _tmp659_;
				_tmp661_ = prop;
				_tmp662_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp661_);
				_tmp663_ = _tmp662_;
				vala_report_error (_tmp660_, "Property `%s' is read-only", _tmp663_);
				_g_free0 (_tmp663_);
			}
		}
		_tmp667_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp668_ = _tmp667_;
		if (_tmp668_) {
			ValaDataType* _tmp669_;
			ValaDataType* _tmp670_;
			gboolean _tmp671_;
			gboolean _tmp672_;
			_tmp669_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp670_ = _tmp669_;
			_tmp671_ = vala_data_type_get_nullable (_tmp670_);
			_tmp672_ = _tmp671_;
			_tmp666_ = !_tmp672_;
		} else {
			_tmp666_ = FALSE;
		}
		if (_tmp666_) {
			ValaDataType* _tmp673_;
			ValaDataType* _tmp674_;
			gboolean _tmp675_;
			gboolean _tmp676_;
			_tmp673_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp674_ = _tmp673_;
			_tmp675_ = vala_data_type_get_floating_reference (_tmp674_);
			_tmp676_ = _tmp675_;
			_tmp665_ = _tmp676_;
		} else {
			_tmp665_ = FALSE;
		}
		if (_tmp665_) {
			ValaDataType* _tmp677_;
			_tmp677_ = ret_type;
			_tmp664_ = VALA_IS_OBJECT_TYPE (_tmp677_);
		} else {
			_tmp664_ = FALSE;
		}
		if (_tmp664_) {
			ValaDataType* _tmp678_;
			ValaDataType* _tmp679_;
			_tmp678_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp679_ = _tmp678_;
			vala_data_type_set_nullable (_tmp679_, TRUE);
		}
		_tmp680_ = m;
		_tmp681_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp680_);
		_tmp682_ = _tmp681_;
		sig = VALA_IS_SIGNAL (_tmp682_) ? ((ValaSignal*) _tmp682_) : NULL;
		_tmp684_ = sig;
		if (_tmp684_ != NULL) {
			ValaMethod* _tmp685_;
			const gchar* _tmp686_;
			const gchar* _tmp687_;
			_tmp685_ = m;
			_tmp686_ = vala_symbol_get_name ((ValaSymbol*) _tmp685_);
			_tmp687_ = _tmp686_;
			_tmp683_ = g_strcmp0 (_tmp687_, "disconnect") == 0;
		} else {
			_tmp683_ = FALSE;
		}
		if (_tmp683_) {
			gboolean _tmp688_ = FALSE;
			ValaList* _tmp689_;
			gboolean _tmp690_;
			gboolean _tmp691_;
			_tmp689_ = self->priv->argument_list;
			_tmp690_ = vala_collection_get_is_empty ((ValaCollection*) _tmp689_);
			_tmp691_ = _tmp690_;
			if (!_tmp691_) {
				ValaList* _tmp692_;
				gpointer _tmp693_;
				ValaExpression* _tmp694_;
				_tmp692_ = self->priv->argument_list;
				_tmp693_ = vala_list_get (_tmp692_, 0);
				_tmp694_ = (ValaExpression*) _tmp693_;
				_tmp688_ = VALA_IS_LAMBDA_EXPRESSION (_tmp694_);
				_vala_code_node_unref0 (_tmp694_);
			} else {
				_tmp688_ = FALSE;
			}
			if (_tmp688_) {
				ValaSourceReference* _tmp695_;
				ValaSourceReference* _tmp696_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp695_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp696_ = _tmp695_;
				vala_report_error (_tmp696_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_iterator_unref0 (arg_it);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp697_ = m;
		_tmp698_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp697_);
		_tmp699_ = _tmp698_;
		dynamic_sig = VALA_IS_DYNAMIC_SIGNAL (_tmp699_) ? ((ValaDynamicSignal*) _tmp699_) : NULL;
		_tmp701_ = dynamic_sig;
		if (_tmp701_ != NULL) {
			ValaDynamicSignal* _tmp702_;
			ValaExpression* _tmp703_;
			ValaExpression* _tmp704_;
			_tmp702_ = dynamic_sig;
			_tmp703_ = vala_dynamic_signal_get_handler (_tmp702_);
			_tmp704_ = _tmp703_;
			_tmp700_ = _tmp704_ != NULL;
		} else {
			_tmp700_ = FALSE;
		}
		if (_tmp700_) {
			ValaDynamicSignal* _tmp705_;
			ValaDynamicSignal* _tmp706_;
			ValaExpression* _tmp707_;
			ValaExpression* _tmp708_;
			ValaDataType* _tmp709_;
			ValaDataType* _tmp710_;
			ValaDataType* _tmp711_;
			ValaDataType* _tmp712_;
			ValaDataType* _tmp713_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp731_;
			ValaExpression* _tmp732_;
			ValaExpression* _tmp733_;
			ValaDynamicSignal* _tmp734_;
			ValaDynamicSignal* _tmp735_;
			ValaSymbol* _tmp736_;
			ValaSymbol* _tmp737_;
			ValaObjectType* _tmp738_;
			ValaObjectType* _tmp739_;
			ValaDelegate* _tmp740_;
			ValaDelegate* _tmp741_;
			ValaSourceReference* _tmp742_;
			ValaSourceReference* _tmp743_;
			ValaDelegateType* _tmp744_;
			ValaDelegateType* _tmp745_;
			_tmp705_ = dynamic_sig;
			_tmp706_ = dynamic_sig;
			_tmp707_ = vala_dynamic_signal_get_handler (_tmp706_);
			_tmp708_ = _tmp707_;
			_tmp709_ = vala_expression_get_value_type (_tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_data_type_get_return_type (_tmp710_);
			_tmp712_ = vala_data_type_copy (_tmp711_);
			_tmp713_ = _tmp712_;
			vala_callable_set_return_type ((ValaCallable*) _tmp705_, _tmp713_);
			_vala_code_node_unref0 (_tmp713_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp714_;
				ValaExpression* _tmp715_;
				ValaExpression* _tmp716_;
				ValaDataType* _tmp717_;
				ValaDataType* _tmp718_;
				ValaList* _tmp719_;
				gint _param_size = 0;
				ValaList* _tmp720_;
				gint _tmp721_;
				gint _tmp722_;
				gint _param_index = 0;
				_tmp714_ = dynamic_sig;
				_tmp715_ = vala_dynamic_signal_get_handler (_tmp714_);
				_tmp716_ = _tmp715_;
				_tmp717_ = vala_expression_get_value_type (_tmp716_);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_data_type_get_parameters (_tmp718_);
				_param_list = _tmp719_;
				_tmp720_ = _param_list;
				_tmp721_ = vala_collection_get_size ((ValaCollection*) _tmp720_);
				_tmp722_ = _tmp721_;
				_param_size = _tmp722_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp723_;
					gint _tmp724_;
					ValaParameter* param = NULL;
					ValaList* _tmp725_;
					gpointer _tmp726_;
					_param_index = _param_index + 1;
					_tmp723_ = _param_index;
					_tmp724_ = _param_size;
					if (!(_tmp723_ < _tmp724_)) {
						break;
					}
					_tmp725_ = _param_list;
					_tmp726_ = vala_list_get (_tmp725_, _param_index);
					param = (ValaParameter*) _tmp726_;
					if (first) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp727_;
						ValaParameter* _tmp728_;
						ValaParameter* _tmp729_;
						ValaParameter* _tmp730_;
						_tmp727_ = dynamic_sig;
						_tmp728_ = param;
						_tmp729_ = vala_parameter_copy (_tmp728_);
						_tmp730_ = _tmp729_;
						vala_callable_add_parameter ((ValaCallable*) _tmp727_, _tmp730_);
						_vala_code_node_unref0 (_tmp730_);
					}
					_vala_code_node_unref0 (param);
				}
			}
			_tmp731_ = dynamic_sig;
			_tmp732_ = vala_dynamic_signal_get_handler (_tmp731_);
			_tmp733_ = _tmp732_;
			_tmp734_ = dynamic_sig;
			_tmp735_ = dynamic_sig;
			_tmp736_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp735_);
			_tmp737_ = _tmp736_;
			_tmp738_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp737_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), NULL);
			_tmp739_ = _tmp738_;
			_tmp740_ = vala_signal_get_delegate ((ValaSignal*) _tmp734_, (ValaDataType*) _tmp739_, (ValaCodeNode*) self);
			_tmp741_ = _tmp740_;
			_tmp742_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp743_ = _tmp742_;
			_tmp744_ = vala_delegate_type_new (_tmp741_, _tmp743_);
			_tmp745_ = _tmp744_;
			vala_expression_set_target_type (_tmp733_, (ValaDataType*) _tmp745_);
			_vala_code_node_unref0 (_tmp745_);
			_vala_code_node_unref0 (_tmp741_);
			_vala_code_node_unref0 (_tmp739_);
		}
		_tmp747_ = m;
		if (_tmp747_ != NULL) {
			ValaMethod* _tmp748_;
			_tmp748_ = m;
			_tmp746_ = vala_method_has_type_parameters (_tmp748_);
		} else {
			_tmp746_ = FALSE;
		}
		if (_tmp746_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp749_;
			ValaExpression* _tmp750_;
			ValaMemberAccess* _tmp751_;
			ValaList* _tmp752_;
			gint _tmp753_;
			gint _tmp754_;
			_tmp749_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp750_ = _tmp749_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp750_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp751_ = ma;
			_tmp752_ = vala_member_access_get_type_arguments (_tmp751_);
			_tmp753_ = vala_collection_get_size ((ValaCollection*) _tmp752_);
			_tmp754_ = _tmp753_;
			if (_tmp754_ == 0) {
				ValaList* _tmp857_;
				ValaIterator* _tmp858_;
				ValaDataType* _tmp885_;
				ValaDataType* _tmp886_;
				ValaDataType* _tmp887_;
				ValaList* _tmp888_;
				ValaDataType* _tmp889_;
				ValaDataType* _tmp890_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp755_;
					ValaList* _tmp756_;
					gint _type_param_size = 0;
					ValaList* _tmp757_;
					gint _tmp758_;
					gint _tmp759_;
					gint _type_param_index = 0;
					_tmp755_ = m;
					_tmp756_ = vala_method_get_type_parameters (_tmp755_);
					_type_param_list = _tmp756_;
					_tmp757_ = _type_param_list;
					_tmp758_ = vala_collection_get_size ((ValaCollection*) _tmp757_);
					_tmp759_ = _tmp758_;
					_type_param_size = _tmp759_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp760_;
						gint _tmp761_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp762_;
						gpointer _tmp763_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp764_;
						ValaIterator* _tmp765_;
						gboolean _tmp837_ = FALSE;
						ValaDataType* _tmp838_;
						ValaDataType* _tmp848_;
						ValaMemberAccess* _tmp855_;
						ValaDataType* _tmp856_;
						_type_param_index = _type_param_index + 1;
						_tmp760_ = _type_param_index;
						_tmp761_ = _type_param_size;
						if (!(_tmp760_ < _tmp761_)) {
							break;
						}
						_tmp762_ = _type_param_list;
						_tmp763_ = vala_list_get (_tmp762_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp763_;
						type_arg = NULL;
						_tmp764_ = self->priv->argument_list;
						_tmp765_ = vala_iterable_iterator ((ValaIterable*) _tmp764_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp765_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp766_;
							gint _param_size = 0;
							ValaList* _tmp767_;
							gint _tmp768_;
							gint _tmp769_;
							gint _param_index = 0;
							_tmp766_ = params;
							_param_list = _tmp766_;
							_tmp767_ = _param_list;
							_tmp768_ = vala_collection_get_size ((ValaCollection*) _tmp767_);
							_tmp769_ = _tmp768_;
							_param_size = _tmp769_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp770_;
								gint _tmp771_;
								ValaParameter* param = NULL;
								ValaList* _tmp772_;
								gpointer _tmp773_;
								gboolean _tmp774_ = FALSE;
								ValaParameter* _tmp775_;
								gboolean _tmp776_;
								gboolean _tmp777_;
								ValaIterator* _tmp781_;
								_param_index = _param_index + 1;
								_tmp770_ = _param_index;
								_tmp771_ = _param_size;
								if (!(_tmp770_ < _tmp771_)) {
									break;
								}
								_tmp772_ = _param_list;
								_tmp773_ = vala_list_get (_tmp772_, _param_index);
								param = (ValaParameter*) _tmp773_;
								_tmp775_ = param;
								_tmp776_ = vala_parameter_get_ellipsis (_tmp775_);
								_tmp777_ = _tmp776_;
								if (_tmp777_) {
									_tmp774_ = TRUE;
								} else {
									ValaParameter* _tmp778_;
									gboolean _tmp779_;
									gboolean _tmp780_;
									_tmp778_ = param;
									_tmp779_ = vala_parameter_get_params_array (_tmp778_);
									_tmp780_ = _tmp779_;
									_tmp774_ = _tmp780_;
								}
								if (_tmp774_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp781_ = arg_it;
								if (vala_iterator_next (_tmp781_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp782_;
									gpointer _tmp783_;
									gboolean _tmp784_ = FALSE;
									gboolean _tmp785_ = FALSE;
									ValaParameter* _tmp786_;
									ValaExpression* _tmp787_;
									ValaExpression* _tmp788_;
									ValaDataType* _tmp828_;
									ValaExpression* _tmp829_;
									ValaExpression* _tmp830_;
									ValaDataType* _tmp831_;
									ValaDataType* _tmp832_;
									ValaDataType* _tmp833_;
									ValaList* _tmp834_;
									ValaDataType* _tmp835_;
									ValaDataType* _tmp836_;
									_tmp782_ = arg_it;
									_tmp783_ = vala_iterator_get (_tmp782_);
									arg = (ValaExpression*) _tmp783_;
									_tmp786_ = param;
									_tmp787_ = vala_variable_get_initializer ((ValaVariable*) _tmp786_);
									_tmp788_ = _tmp787_;
									if (VALA_IS_SIZEOF_EXPRESSION (_tmp788_)) {
										ValaExpression* _tmp789_;
										_tmp789_ = arg;
										_tmp785_ = VALA_IS_SIZEOF_EXPRESSION (_tmp789_);
									} else {
										_tmp785_ = FALSE;
									}
									if (_tmp785_) {
										ValaParameter* _tmp790_;
										ValaExpression* _tmp791_;
										ValaExpression* _tmp792_;
										ValaDataType* _tmp793_;
										ValaDataType* _tmp794_;
										ValaTypeSymbol* _tmp795_;
										ValaTypeSymbol* _tmp796_;
										ValaTypeParameter* _tmp797_;
										_tmp790_ = param;
										_tmp791_ = vala_variable_get_initializer ((ValaVariable*) _tmp790_);
										_tmp792_ = _tmp791_;
										_tmp793_ = vala_sizeof_expression_get_type_reference (G_TYPE_CHECK_INSTANCE_CAST (_tmp792_, VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression));
										_tmp794_ = _tmp793_;
										_tmp795_ = vala_data_type_get_type_symbol (_tmp794_);
										_tmp796_ = _tmp795_;
										_tmp797_ = type_param;
										_tmp784_ = _tmp796_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp797_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
									} else {
										_tmp784_ = FALSE;
									}
									if (_tmp784_) {
										ValaExpression* _tmp798_;
										ValaDataType* _tmp799_;
										ValaDataType* _tmp800_;
										ValaDataType* _tmp801_;
										_tmp798_ = arg;
										_tmp799_ = vala_sizeof_expression_get_type_reference (G_TYPE_CHECK_INSTANCE_CAST (_tmp798_, VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression));
										_tmp800_ = _tmp799_;
										_tmp801_ = vala_data_type_copy (_tmp800_);
										_vala_code_node_unref0 (type_arg);
										type_arg = _tmp801_;
									} else {
										gboolean _tmp802_ = FALSE;
										gboolean _tmp803_ = FALSE;
										ValaParameter* _tmp804_;
										ValaExpression* _tmp805_;
										ValaExpression* _tmp806_;
										_tmp804_ = param;
										_tmp805_ = vala_variable_get_initializer ((ValaVariable*) _tmp804_);
										_tmp806_ = _tmp805_;
										if (VALA_IS_TYPEOF_EXPRESSION (_tmp806_)) {
											ValaExpression* _tmp807_;
											_tmp807_ = arg;
											_tmp803_ = VALA_IS_TYPEOF_EXPRESSION (_tmp807_);
										} else {
											_tmp803_ = FALSE;
										}
										if (_tmp803_) {
											ValaParameter* _tmp808_;
											ValaExpression* _tmp809_;
											ValaExpression* _tmp810_;
											ValaDataType* _tmp811_;
											ValaDataType* _tmp812_;
											ValaTypeSymbol* _tmp813_;
											ValaTypeSymbol* _tmp814_;
											ValaTypeParameter* _tmp815_;
											_tmp808_ = param;
											_tmp809_ = vala_variable_get_initializer ((ValaVariable*) _tmp808_);
											_tmp810_ = _tmp809_;
											_tmp811_ = vala_typeof_expression_get_type_reference (G_TYPE_CHECK_INSTANCE_CAST (_tmp810_, VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression));
											_tmp812_ = _tmp811_;
											_tmp813_ = vala_data_type_get_type_symbol (_tmp812_);
											_tmp814_ = _tmp813_;
											_tmp815_ = type_param;
											_tmp802_ = _tmp814_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp815_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
										} else {
											_tmp802_ = FALSE;
										}
										if (_tmp802_) {
											ValaExpression* _tmp816_;
											ValaDataType* _tmp817_;
											ValaDataType* _tmp818_;
											ValaDataType* _tmp819_;
											_tmp816_ = arg;
											_tmp817_ = vala_typeof_expression_get_type_reference (G_TYPE_CHECK_INSTANCE_CAST (_tmp816_, VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression));
											_tmp818_ = _tmp817_;
											_tmp819_ = vala_data_type_copy (_tmp818_);
											_vala_code_node_unref0 (type_arg);
											type_arg = _tmp819_;
										} else {
											ValaParameter* _tmp820_;
											ValaDataType* _tmp821_;
											ValaDataType* _tmp822_;
											ValaTypeParameter* _tmp823_;
											ValaExpression* _tmp824_;
											ValaDataType* _tmp825_;
											ValaDataType* _tmp826_;
											ValaDataType* _tmp827_;
											_tmp820_ = param;
											_tmp821_ = vala_variable_get_variable_type ((ValaVariable*) _tmp820_);
											_tmp822_ = _tmp821_;
											_tmp823_ = type_param;
											_tmp824_ = arg;
											_tmp825_ = vala_expression_get_value_type (_tmp824_);
											_tmp826_ = _tmp825_;
											_tmp827_ = vala_data_type_infer_type_argument (_tmp822_, _tmp823_, _tmp826_);
											_vala_code_node_unref0 (type_arg);
											type_arg = _tmp827_;
										}
									}
									_tmp828_ = type_arg;
									if (_tmp828_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp829_ = arg;
									_tmp830_ = arg;
									_tmp831_ = vala_expression_get_formal_target_type (_tmp830_);
									_tmp832_ = _tmp831_;
									_tmp833_ = target_object_type;
									_tmp834_ = method_type_args;
									_tmp835_ = vala_data_type_get_actual_type (_tmp832_, _tmp833_, _tmp834_, (ValaCodeNode*) self);
									_tmp836_ = _tmp835_;
									vala_expression_set_target_type (_tmp829_, _tmp836_);
									_vala_code_node_unref0 (_tmp836_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
						}
						_tmp838_ = type_arg;
						if (_tmp838_ == NULL) {
							ValaDataType* _tmp839_;
							ValaDataType* _tmp840_;
							_tmp839_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp840_ = _tmp839_;
							_tmp837_ = _tmp840_ != NULL;
						} else {
							_tmp837_ = FALSE;
						}
						if (_tmp837_) {
							ValaMethod* _tmp841_;
							ValaDataType* _tmp842_;
							ValaDataType* _tmp843_;
							ValaTypeParameter* _tmp844_;
							ValaDataType* _tmp845_;
							ValaDataType* _tmp846_;
							ValaDataType* _tmp847_;
							_tmp841_ = m;
							_tmp842_ = vala_callable_get_return_type ((ValaCallable*) _tmp841_);
							_tmp843_ = _tmp842_;
							_tmp844_ = type_param;
							_tmp845_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp846_ = _tmp845_;
							_tmp847_ = vala_data_type_infer_type_argument (_tmp843_, _tmp844_, _tmp846_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp847_;
						}
						_tmp848_ = type_arg;
						if (_tmp848_ == NULL) {
							ValaMemberAccess* _tmp849_;
							ValaSourceReference* _tmp850_;
							ValaSourceReference* _tmp851_;
							ValaTypeParameter* _tmp852_;
							gchar* _tmp853_;
							gchar* _tmp854_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp849_ = ma;
							_tmp850_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp849_);
							_tmp851_ = _tmp850_;
							_tmp852_ = type_param;
							_tmp853_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp852_);
							_tmp854_ = _tmp853_;
							vala_report_error (_tmp851_, "cannot infer generic type argument for type parameter `%s'", _tmp854_);
							_g_free0 (_tmp854_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterator_unref0 (arg_it);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp855_ = ma;
						_tmp856_ = type_arg;
						vala_member_access_add_type_argument (_tmp855_, _tmp856_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
				}
				_tmp857_ = self->priv->argument_list;
				_tmp858_ = vala_iterable_iterator ((ValaIterable*) _tmp857_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp858_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp859_;
					gint _param_size = 0;
					ValaList* _tmp860_;
					gint _tmp861_;
					gint _tmp862_;
					gint _param_index = 0;
					_tmp859_ = params;
					_param_list = _tmp859_;
					_tmp860_ = _param_list;
					_tmp861_ = vala_collection_get_size ((ValaCollection*) _tmp860_);
					_tmp862_ = _tmp861_;
					_param_size = _tmp862_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp863_;
						gint _tmp864_;
						ValaParameter* param = NULL;
						ValaList* _tmp865_;
						gpointer _tmp866_;
						gboolean _tmp867_ = FALSE;
						ValaParameter* _tmp868_;
						gboolean _tmp869_;
						gboolean _tmp870_;
						ValaIterator* _tmp874_;
						_param_index = _param_index + 1;
						_tmp863_ = _param_index;
						_tmp864_ = _param_size;
						if (!(_tmp863_ < _tmp864_)) {
							break;
						}
						_tmp865_ = _param_list;
						_tmp866_ = vala_list_get (_tmp865_, _param_index);
						param = (ValaParameter*) _tmp866_;
						_tmp868_ = param;
						_tmp869_ = vala_parameter_get_ellipsis (_tmp868_);
						_tmp870_ = _tmp869_;
						if (_tmp870_) {
							_tmp867_ = TRUE;
						} else {
							ValaParameter* _tmp871_;
							gboolean _tmp872_;
							gboolean _tmp873_;
							_tmp871_ = param;
							_tmp872_ = vala_parameter_get_params_array (_tmp871_);
							_tmp873_ = _tmp872_;
							_tmp867_ = _tmp873_;
						}
						if (_tmp867_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp874_ = arg_it;
						if (vala_iterator_next (_tmp874_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp875_;
							gpointer _tmp876_;
							ValaExpression* _tmp877_;
							ValaExpression* _tmp878_;
							ValaDataType* _tmp879_;
							ValaDataType* _tmp880_;
							ValaDataType* _tmp881_;
							ValaList* _tmp882_;
							ValaDataType* _tmp883_;
							ValaDataType* _tmp884_;
							_tmp875_ = arg_it;
							_tmp876_ = vala_iterator_get (_tmp875_);
							arg = (ValaExpression*) _tmp876_;
							_tmp877_ = arg;
							_tmp878_ = arg;
							_tmp879_ = vala_expression_get_formal_target_type (_tmp878_);
							_tmp880_ = _tmp879_;
							_tmp881_ = target_object_type;
							_tmp882_ = method_type_args;
							_tmp883_ = vala_data_type_get_actual_type (_tmp880_, _tmp881_, _tmp882_, (ValaCodeNode*) self);
							_tmp884_ = _tmp883_;
							vala_expression_set_target_type (_tmp877_, _tmp884_);
							_vala_code_node_unref0 (_tmp884_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
				}
				_tmp885_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp886_ = _tmp885_;
				_tmp887_ = target_object_type;
				_tmp888_ = method_type_args;
				_tmp889_ = vala_data_type_get_actual_type (_tmp886_, _tmp887_, _tmp888_, (ValaCodeNode*) self);
				_tmp890_ = _tmp889_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp890_);
				_vala_code_node_unref0 (_tmp890_);
			}
		}
		_tmp892_ = m;
		if (_tmp892_ != NULL) {
			ValaMethod* _tmp893_;
			gboolean _tmp894_;
			gboolean _tmp895_;
			_tmp893_ = m;
			_tmp894_ = vala_method_get_coroutine (_tmp893_);
			_tmp895_ = _tmp894_;
			_tmp891_ = _tmp895_;
		} else {
			_tmp891_ = FALSE;
		}
		if (_tmp891_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp896_;
			ValaExpression* _tmp897_;
			ValaMemberAccess* _tmp898_;
			const gchar* _tmp899_;
			const gchar* _tmp900_;
			_tmp896_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
			_tmp897_ = _tmp896_;
			ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp897_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
			_tmp898_ = ma;
			_tmp899_ = vala_member_access_get_member_name (_tmp898_);
			_tmp900_ = _tmp899_;
			if (g_strcmp0 (_tmp900_, "end") == 0) {
				ValaMethod* _tmp901_;
				ValaMethod* _tmp902_;
				ValaSourceReference* _tmp903_;
				ValaSourceReference* _tmp904_;
				ValaMethodType* _tmp905_;
				_tmp901_ = m;
				_tmp902_ = vala_method_get_end_method (_tmp901_);
				_tmp903_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp904_ = _tmp903_;
				_tmp905_ = vala_method_type_new (_tmp902_, _tmp904_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp905_;
			}
		}
	}
	_tmp906_ = vala_code_context_get_analyzer (context);
	_tmp907_ = _tmp906_;
	_tmp908_ = mtype;
	_tmp909_ = params;
	_tmp910_ = self->priv->argument_list;
	if (!vala_semantic_analyzer_check_arguments (_tmp907_, (ValaExpression*) self, _tmp908_, _tmp909_, _tmp910_)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	_tmp911_ = self->priv->argument_list;
	_tmp912_ = vala_iterable_iterator ((ValaIterable*) _tmp911_);
	_vala_iterator_unref0 (arg_it);
	arg_it = _tmp912_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp913_;
		gint _param_size = 0;
		ValaList* _tmp914_;
		gint _tmp915_;
		gint _tmp916_;
		gint _param_index = 0;
		_tmp913_ = params;
		_param_list = _tmp913_;
		_tmp914_ = _param_list;
		_tmp915_ = vala_collection_get_size ((ValaCollection*) _tmp914_);
		_tmp916_ = _tmp915_;
		_param_size = _tmp916_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp917_;
			gint _tmp918_;
			ValaParameter* param = NULL;
			ValaList* _tmp919_;
			gpointer _tmp920_;
			gboolean _tmp921_ = FALSE;
			ValaParameter* _tmp922_;
			gboolean _tmp923_;
			gboolean _tmp924_;
			ValaIterator* _tmp928_;
			_param_index = _param_index + 1;
			_tmp917_ = _param_index;
			_tmp918_ = _param_size;
			if (!(_tmp917_ < _tmp918_)) {
				break;
			}
			_tmp919_ = _param_list;
			_tmp920_ = vala_list_get (_tmp919_, _param_index);
			param = (ValaParameter*) _tmp920_;
			_tmp922_ = param;
			_tmp923_ = vala_parameter_get_ellipsis (_tmp922_);
			_tmp924_ = _tmp923_;
			if (_tmp924_) {
				_tmp921_ = TRUE;
			} else {
				ValaParameter* _tmp925_;
				gboolean _tmp926_;
				gboolean _tmp927_;
				_tmp925_ = param;
				_tmp926_ = vala_parameter_get_params_array (_tmp925_);
				_tmp927_ = _tmp926_;
				_tmp921_ = _tmp927_;
			}
			if (_tmp921_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp928_ = arg_it;
			if (vala_iterator_next (_tmp928_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp929_;
				gpointer _tmp930_;
				ValaParameter* _tmp931_;
				ValaExpression* _tmp932_;
				ValaExpression* _tmp933_;
				ValaExpression* _tmp934_;
				ValaSizeofExpression* sizeof_expr = NULL;
				ValaExpression* _tmp935_;
				gboolean _tmp936_ = FALSE;
				ValaSizeofExpression* _tmp937_;
				ValaTypeofExpression* typeof_expr = NULL;
				ValaExpression* _tmp953_;
				gboolean _tmp954_ = FALSE;
				ValaTypeofExpression* _tmp955_;
				_tmp929_ = arg_it;
				_tmp930_ = vala_iterator_get (_tmp929_);
				arg = (ValaExpression*) _tmp930_;
				_tmp931_ = param;
				_tmp932_ = vala_variable_get_initializer ((ValaVariable*) _tmp931_);
				_tmp933_ = _tmp932_;
				_tmp934_ = arg;
				if (_tmp933_ != _tmp934_) {
					_vala_code_node_unref0 (arg);
					_vala_code_node_unref0 (param);
					continue;
				}
				_tmp935_ = arg;
				sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp935_) ? ((ValaSizeofExpression*) _tmp935_) : NULL;
				_tmp937_ = sizeof_expr;
				if (_tmp937_ != NULL) {
					ValaSizeofExpression* _tmp938_;
					ValaDataType* _tmp939_;
					ValaDataType* _tmp940_;
					_tmp938_ = sizeof_expr;
					_tmp939_ = vala_sizeof_expression_get_type_reference (_tmp938_);
					_tmp940_ = _tmp939_;
					_tmp936_ = VALA_IS_GENERIC_TYPE (_tmp940_);
				} else {
					_tmp936_ = FALSE;
				}
				if (_tmp936_) {
					ValaDataType* sizeof_type = NULL;
					ValaSizeofExpression* _tmp941_;
					ValaDataType* _tmp942_;
					ValaDataType* _tmp943_;
					ValaDataType* _tmp944_;
					ValaList* _tmp945_;
					ValaDataType* _tmp946_;
					ValaExpression* _tmp947_;
					ValaDataType* _tmp948_;
					ValaSourceReference* _tmp949_;
					ValaSourceReference* _tmp950_;
					ValaSizeofExpression* _tmp951_;
					ValaSizeofExpression* _tmp952_;
					_tmp941_ = sizeof_expr;
					_tmp942_ = vala_sizeof_expression_get_type_reference (_tmp941_);
					_tmp943_ = _tmp942_;
					_tmp944_ = target_object_type;
					_tmp945_ = method_type_args;
					_tmp946_ = vala_data_type_get_actual_type (_tmp943_, _tmp944_, _tmp945_, (ValaCodeNode*) self);
					sizeof_type = _tmp946_;
					_tmp947_ = arg;
					_tmp948_ = sizeof_type;
					_tmp949_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp950_ = _tmp949_;
					_tmp951_ = vala_sizeof_expression_new (_tmp948_, _tmp950_);
					_tmp952_ = _tmp951_;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp947_, (ValaExpression*) _tmp952_);
					_vala_code_node_unref0 (_tmp952_);
					_vala_code_node_unref0 (sizeof_type);
				}
				_tmp953_ = arg;
				typeof_expr = VALA_IS_TYPEOF_EXPRESSION (_tmp953_) ? ((ValaTypeofExpression*) _tmp953_) : NULL;
				_tmp955_ = typeof_expr;
				if (_tmp955_ != NULL) {
					ValaTypeofExpression* _tmp956_;
					ValaDataType* _tmp957_;
					ValaDataType* _tmp958_;
					_tmp956_ = typeof_expr;
					_tmp957_ = vala_typeof_expression_get_type_reference (_tmp956_);
					_tmp958_ = _tmp957_;
					_tmp954_ = VALA_IS_GENERIC_TYPE (_tmp958_);
				} else {
					_tmp954_ = FALSE;
				}
				if (_tmp954_) {
					ValaDataType* typeof_type = NULL;
					ValaTypeofExpression* _tmp959_;
					ValaDataType* _tmp960_;
					ValaDataType* _tmp961_;
					ValaDataType* _tmp962_;
					ValaList* _tmp963_;
					ValaDataType* _tmp964_;
					ValaExpression* _tmp965_;
					ValaDataType* _tmp966_;
					ValaSourceReference* _tmp967_;
					ValaSourceReference* _tmp968_;
					ValaTypeofExpression* _tmp969_;
					ValaTypeofExpression* _tmp970_;
					_tmp959_ = typeof_expr;
					_tmp960_ = vala_typeof_expression_get_type_reference (_tmp959_);
					_tmp961_ = _tmp960_;
					_tmp962_ = target_object_type;
					_tmp963_ = method_type_args;
					_tmp964_ = vala_data_type_get_actual_type (_tmp961_, _tmp962_, _tmp963_, (ValaCodeNode*) self);
					typeof_type = _tmp964_;
					_tmp965_ = arg;
					_tmp966_ = typeof_type;
					_tmp967_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp968_ = _tmp967_;
					_tmp969_ = vala_typeof_expression_new (_tmp966_, _tmp968_);
					_tmp970_ = _tmp969_;
					vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp965_, (ValaExpression*) _tmp970_);
					_vala_code_node_unref0 (_tmp970_);
					_vala_code_node_unref0 (typeof_type);
				}
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
	}
	_tmp973_ = base_cm;
	if (_tmp973_ != NULL) {
		ValaCreationMethod* _tmp974_;
		_tmp974_ = base_cm;
		_tmp972_ = vala_method_is_variadic ((ValaMethod*) _tmp974_);
	} else {
		_tmp972_ = FALSE;
	}
	if (_tmp972_) {
		ValaList* _tmp975_;
		gint _tmp976_;
		gint _tmp977_;
		ValaCreationMethod* _tmp978_;
		ValaList* _tmp979_;
		gint _tmp980_;
		gint _tmp981_;
		_tmp975_ = self->priv->argument_list;
		_tmp976_ = vala_collection_get_size ((ValaCollection*) _tmp975_);
		_tmp977_ = _tmp976_;
		_tmp978_ = base_cm;
		_tmp979_ = vala_callable_get_parameters ((ValaCallable*) _tmp978_);
		_tmp980_ = vala_collection_get_size ((ValaCollection*) _tmp979_);
		_tmp981_ = _tmp980_;
		_tmp971_ = _tmp977_ == _tmp981_;
	} else {
		_tmp971_ = FALSE;
	}
	if (_tmp971_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp982_;
		ValaList* _tmp983_;
		gint _tmp984_;
		gint _tmp985_;
		gpointer _tmp986_;
		gboolean _tmp987_ = FALSE;
		ValaExpression* _tmp988_;
		ValaDataType* _tmp989_;
		ValaDataType* _tmp990_;
		_tmp982_ = self->priv->argument_list;
		_tmp983_ = self->priv->argument_list;
		_tmp984_ = vala_collection_get_size ((ValaCollection*) _tmp983_);
		_tmp985_ = _tmp984_;
		_tmp986_ = vala_list_get (_tmp982_, _tmp985_ - 1);
		this_last_arg = (ValaExpression*) _tmp986_;
		_tmp988_ = this_last_arg;
		_tmp989_ = vala_expression_get_value_type (_tmp988_);
		_tmp990_ = _tmp989_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp990_)) {
			ValaExpression* _tmp991_;
			ValaDataType* _tmp992_;
			ValaDataType* _tmp993_;
			ValaTypeSymbol* _tmp994_;
			ValaTypeSymbol* _tmp995_;
			ValaSemanticAnalyzer* _tmp996_;
			ValaSemanticAnalyzer* _tmp997_;
			ValaDataType* _tmp998_;
			ValaTypeSymbol* _tmp999_;
			ValaTypeSymbol* _tmp1000_;
			_tmp991_ = this_last_arg;
			_tmp992_ = vala_expression_get_value_type (_tmp991_);
			_tmp993_ = _tmp992_;
			_tmp994_ = vala_data_type_get_type_symbol (_tmp993_);
			_tmp995_ = _tmp994_;
			_tmp996_ = vala_code_context_get_analyzer (context);
			_tmp997_ = _tmp996_;
			_tmp998_ = _tmp997_->va_list_type;
			_tmp999_ = vala_data_type_get_type_symbol (_tmp998_);
			_tmp1000_ = _tmp999_;
			_tmp987_ = _tmp995_ == _tmp1000_;
		} else {
			_tmp987_ = FALSE;
		}
		if (_tmp987_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp1001_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1002_ = _tmp1001_;
	vala_code_node_check ((ValaCodeNode*) _tmp1002_, context);
	_tmp1003_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1004_ = _tmp1003_;
	if (_tmp1004_) {
		gboolean _tmp1005_ = FALSE;
		ValaCodeNode* _tmp1006_;
		ValaCodeNode* _tmp1007_;
		_tmp1006_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp1007_ = _tmp1006_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp1007_)) {
			_tmp1005_ = TRUE;
		} else {
			ValaCodeNode* _tmp1008_;
			ValaCodeNode* _tmp1009_;
			_tmp1008_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp1009_ = _tmp1008_;
			_tmp1005_ = VALA_IS_EXPRESSION_STATEMENT (_tmp1009_);
		}
		if (_tmp1005_) {
		} else {
			ValaSemanticAnalyzer* _tmp1010_;
			ValaSemanticAnalyzer* _tmp1011_;
			ValaSymbol* _tmp1012_;
			ValaSymbol* _tmp1013_;
			_tmp1010_ = vala_code_context_get_analyzer (context);
			_tmp1011_ = _tmp1010_;
			_tmp1012_ = vala_semantic_analyzer_get_current_symbol (_tmp1011_);
			_tmp1013_ = _tmp1012_;
			if (!VALA_IS_BLOCK (_tmp1013_)) {
				ValaSourceReference* _tmp1014_;
				ValaSourceReference* _tmp1015_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1014_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1015_ = _tmp1014_;
				vala_report_error (_tmp1015_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp1016_;
				ValaCodeNode* _tmp1017_;
				ValaCodeNode* _tmp1018_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp1019_;
				ValaDataType* _tmp1020_;
				ValaDataType* _tmp1021_;
				ValaDataType* _tmp1022_;
				gchar* _tmp1023_;
				gchar* _tmp1024_;
				ValaSourceReference* _tmp1025_;
				ValaSourceReference* _tmp1026_;
				ValaLocalVariable* _tmp1027_;
				ValaLocalVariable* _tmp1028_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp1029_;
				ValaSourceReference* _tmp1030_;
				ValaSourceReference* _tmp1031_;
				ValaDeclarationStatement* _tmp1032_;
				ValaDataType* _tmp1033_;
				ValaDataType* _tmp1034_;
				ValaSemanticAnalyzer* _tmp1038_;
				ValaSemanticAnalyzer* _tmp1039_;
				ValaBlock* _tmp1040_;
				ValaDeclarationStatement* _tmp1041_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp1042_;
				ValaDataType* _tmp1043_;
				ValaDataType* _tmp1044_;
				ValaExpression* _tmp1045_;
				ValaExpression* _tmp1046_;
				ValaDataType* _tmp1047_;
				ValaDataType* _tmp1048_;
				ValaLocalVariable* _tmp1049_;
				ValaDeclarationStatement* _tmp1050_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp1051_;
				ValaSemanticAnalyzer* _tmp1052_;
				ValaSymbol* _tmp1053_;
				ValaSymbol* _tmp1054_;
				ValaBlock* _tmp1055_;
				ValaBlock* _tmp1056_;
				ValaLocalVariable* _tmp1057_;
				ValaSemanticAnalyzer* _tmp1058_;
				ValaSemanticAnalyzer* _tmp1059_;
				ValaBlock* _tmp1060_;
				ValaLocalVariable* _tmp1061_;
				ValaCodeNode* _tmp1062_;
				ValaExpression* _tmp1063_;
				ValaExpression* _tmp1064_;
				_tmp1016_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp1017_ = _tmp1016_;
				_tmp1018_ = _vala_code_node_ref0 (_tmp1017_);
				old_parent_node = _tmp1018_;
				_tmp1019_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1020_ = _tmp1019_;
				_tmp1021_ = vala_data_type_copy (_tmp1020_);
				_tmp1022_ = _tmp1021_;
				_tmp1023_ = vala_code_node_get_temp_name ();
				_tmp1024_ = _tmp1023_;
				_tmp1025_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1026_ = _tmp1025_;
				_tmp1027_ = vala_local_variable_new (_tmp1022_, _tmp1024_, NULL, _tmp1026_);
				_tmp1028_ = _tmp1027_;
				_g_free0 (_tmp1024_);
				_vala_code_node_unref0 (_tmp1022_);
				local = _tmp1028_;
				_tmp1029_ = local;
				_tmp1030_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1031_ = _tmp1030_;
				_tmp1032_ = vala_declaration_statement_new ((ValaSymbol*) _tmp1029_, _tmp1031_);
				decl = _tmp1032_;
				_tmp1033_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1034_ = _tmp1033_;
				if (_tmp1034_ == NULL) {
					ValaLocalVariable* _tmp1035_;
					ValaDataType* _tmp1036_;
					ValaDataType* _tmp1037_;
					_tmp1035_ = local;
					_tmp1036_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1035_);
					_tmp1037_ = _tmp1036_;
					vala_data_type_set_floating_reference (_tmp1037_, FALSE);
				}
				_tmp1038_ = vala_code_context_get_analyzer (context);
				_tmp1039_ = _tmp1038_;
				_tmp1040_ = _tmp1039_->insert_block;
				_tmp1041_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp1040_, (ValaStatement*) _tmp1041_);
				_tmp1042_ = local;
				_tmp1043_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1044_ = _tmp1043_;
				_tmp1045_ = vala_semantic_analyzer_create_temp_access (_tmp1042_, _tmp1044_);
				temp_access = _tmp1045_;
				_tmp1046_ = temp_access;
				_tmp1047_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp1048_ = _tmp1047_;
				vala_expression_set_formal_target_type (_tmp1046_, _tmp1048_);
				vala_expression_set_formal_target_type ((ValaExpression*) self, NULL);
				_tmp1049_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp1049_, (ValaExpression*) self);
				_tmp1050_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp1050_, context);
				_tmp1051_ = vala_code_context_get_analyzer (context);
				_tmp1052_ = _tmp1051_;
				_tmp1053_ = vala_semantic_analyzer_get_current_symbol (_tmp1052_);
				_tmp1054_ = _tmp1053_;
				_tmp1055_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1054_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp1055_;
				_tmp1056_ = block;
				_tmp1057_ = local;
				vala_block_remove_local_variable (_tmp1056_, _tmp1057_);
				_tmp1058_ = vala_code_context_get_analyzer (context);
				_tmp1059_ = _tmp1058_;
				_tmp1060_ = _tmp1059_->insert_block;
				_tmp1061_ = local;
				vala_block_add_local_variable (_tmp1060_, _tmp1061_);
				_tmp1062_ = old_parent_node;
				_tmp1063_ = temp_access;
				vala_code_node_replace_expression (_tmp1062_, (ValaExpression*) self, _tmp1063_);
				_tmp1064_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp1064_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp1065_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1066_ = _tmp1065_;
	result = !_tmp1066_;
	_vala_iterator_unref0 (arg_it);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}

static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	method_type = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = VALA_IS_SIGNAL (_tmp10_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaExpression* _tmp11_;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		_tmp11_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp14_ = _tmp13_;
		vala_code_node_emit ((ValaCodeNode*) _tmp14_, codegen);
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
		_tmp16_ = _tmp15_;
		vala_code_node_emit ((ValaCodeNode*) _tmp16_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp17_;
		gint _expr_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _expr_index = 0;
		_tmp17_ = self->priv->argument_list;
		_expr_list = _tmp17_;
		_tmp18_ = _expr_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_expr_size = _tmp20_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaExpression* expr = NULL;
			ValaList* _tmp23_;
			gpointer _tmp24_;
			ValaExpression* _tmp25_;
			_expr_index = _expr_index + 1;
			_tmp21_ = _expr_index;
			_tmp22_ = _expr_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _expr_list;
			_tmp24_ = vala_list_get (_tmp23_, _expr_index);
			expr = (ValaExpression*) _tmp24_;
			_tmp25_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp25_, codegen);
			_vala_code_node_unref0 (expr);
		}
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		gint _arg_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_arg_list = _tmp2_;
		_tmp3_ = _arg_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_arg_size = _tmp5_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = vala_list_get (_tmp8_, _arg_index);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
	}
}

ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaStringLiteral* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	mtype = VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL;
	_tmp4_ = mtype;
	if (_tmp4_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = mtype;
		_tmp6_ = vala_method_type_get_method_symbol (_tmp5_);
		_tmp7_ = _tmp6_;
		format_arg = vala_method_get_format_arg_index (_tmp7_);
		if (format_arg >= 0) {
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_tmp9_ = self->priv->argument_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_tmp8_ = format_arg < _tmp11_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			ValaStringLiteral* _tmp15_;
			ValaStringLiteral* _tmp16_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, format_arg);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_string_literal_get_format_literal (_tmp14_);
			_tmp16_ = _tmp15_;
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp16_;
			return result;
		}
	}
	result = NULL;
	return result;
}

static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	GString* b = NULL;
	GString* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* result;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = vala_callable_expression_get_is_yield_expression ((ValaCallableExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_callable_expression_get_call ((ValaCallableExpression*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		gint _expr_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_expr_list = _tmp10_;
		_tmp11_ = _expr_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_expr_size = _tmp13_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* expr = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			GString* _tmp19_;
			ValaExpression* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_expr_index = _expr_index + 1;
			_tmp14_ = _expr_index;
			_tmp15_ = _expr_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _expr_list;
			_tmp17_ = vala_list_get (_tmp16_, _expr_index);
			expr = (ValaExpression*) _tmp17_;
			if (!first) {
				GString* _tmp18_;
				_tmp18_ = b;
				g_string_append (_tmp18_, ", ");
			}
			_tmp19_ = b;
			_tmp20_ = expr;
			_tmp21_ = vala_code_node_to_string ((ValaCodeNode*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_string_append (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
	}
	_tmp23_ = b;
	g_string_append_c (_tmp23_, ')');
	_tmp24_ = b;
	_tmp25_ = _tmp24_->str;
	_tmp26_ = g_strdup (_tmp25_);
	result = _tmp26_;
	_g_string_free0 (b);
	return result;
}

static void
vala_method_call_class_init (ValaMethodCallClass * klass,
                             gpointer klass_data)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethodCall_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_call_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}

static void
vala_method_call_vala_callable_expression_interface_init (ValaCallableExpressionIface * iface,
                                                          gpointer iface_data)
{
	vala_method_call_vala_callable_expression_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_argument = (void (*) (ValaCallableExpression*, ValaExpression*)) vala_method_call_real_add_argument;
	iface->get_argument_list = (ValaList* (*) (ValaCallableExpression*)) vala_method_call_real_get_argument_list;
	iface->get_call = vala_method_call_real_get_call;
	iface->get_is_yield_expression = vala_method_call_real_get_is_yield_expression;
	iface->set_is_yield_expression = vala_method_call_real_set_is_yield_expression;
	iface->get_is_chainup = vala_method_call_real_get_is_chainup;
	iface->set_is_chainup = vala_method_call_real_set_is_chainup;
}

static void
vala_method_call_instance_init (ValaMethodCall * self,
                                gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_call_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}

static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}

/**
 * Represents an invocation expression in the source code.
 */
static GType
vala_method_call_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
	static const GInterfaceInfo vala_callable_expression_info = { (GInterfaceInitFunc) vala_method_call_vala_callable_expression_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_method_call_type_id;
	vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
	g_type_add_interface_static (vala_method_call_type_id, VALA_TYPE_CALLABLE_EXPRESSION, &vala_callable_expression_info);
	ValaMethodCall_private_offset = g_type_add_instance_private (vala_method_call_type_id, sizeof (ValaMethodCallPrivate));
	return vala_method_call_type_id;
}

GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__once = 0;
	if (g_once_init_enter (&vala_method_call_type_id__once)) {
		GType vala_method_call_type_id;
		vala_method_call_type_id = vala_method_call_get_type_once ();
		g_once_init_leave (&vala_method_call_type_id__once, vala_method_call_type_id);
	}
	return vala_method_call_type_id__once;
}

