#ifndef _CMD_DEFS_H_
#define _CMD_DEFS_H_
#include "packet.h"

enum pdl_cmd_type{
	MIN_CMD = 0,
	CONNECT = MIN_CMD,
	ERASE_FLASH,
	ERASE_PARTITION,
	ERASE_ALL,
	START_DATA,
	MID_DATA,
	END_DATA,
	EXEC_DATA,
	READ_FLASH,
	READ_PARTITION,
	NORMAL_RESET,
	READ_CHIPID,
	SET_BAUDRATE,
	FORMAT_FLASH,
	READ_PARTITION_TABLE,
	READ_IMAGE_ATTR,
	GET_VERSION,
	SET_FACTMODE,
	SET_CALIBMODE,
	SET_PDL_DBG,
	CHECK_PARTITION_TABLE,
	POWER_OFF,
	IMAGE_LIST,
	GET_SWCFG_REG,
	SET_SWCFG_REG,
	GET_HWCFG_REG,
	SET_HWCFG_REG,
	EXIT_AND_RELOAD,
	GET_SECURITY,
	HW_TEST,
	GET_PDL_LOG,
	DOWNLOAD_FINISH,
	MAX_CMD
};

enum pdl_rsp {
	ACK = 0,
	//from PC command
	PACKET_ERROR,
	INVALID_CMD,
	UNKNOWN_CMD,
	INVALID_ADDR,
	INVALID_BAUDRATE,
	INVALID_PARTITION,
	INVALID_SIZE,
	WAIT_TIMEOUT,
	//from phone
	VERIFY_ERROR,
	CHECKSUM_ERROR,
	OPERATION_FAILED,
	//phone internal
	DEVICE_ERROR, //DDR,NAND init errors
	NO_MEMORY,
	DEVICE_INCOMPATIBLE,
	HW_TEST_ERROR,
	MD5_ERROR,
	ACK_AGAIN_ERASE,
	ACK_AGAIN_FLASH,
	MAX_RSP
};

#define PDL_DBG_PDL		(0x1<<0)
#define PDL_DBG_USB_EP0		(0x1<<1)
#define PDL_DBG_USB_SERIAL	(0x1<<2)
#define PDL_DBG_RW_CHECK	(0x1<<3)
#define PDL_DBG_FACTORY_PART	(0x1<<4)
#define PDL_DBG_PDL_VERBOSE	(0x1<<5)
#define PDL_EXTENDED_STATUS	(0x1<<7)

#endif

