//Auto-generated by kalyptus. DO NOT EDIT.
namespace Plasma {
    using Plasma;
    using System;
    using Kimono;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  @class PackageStructure plasma/packagestructure.h <Plasma/PackageStructure>
    ///  PackageStructure defines what is in a package. This information is used
    ///  to create packages and provides a way to programatically refer to contents.
    ///  An example usage of this class might be:
    ///  @code
    ///     PackageStructure structure;
    ///     structure.addDirectoryDefinition("images", "pics/", i18n("Images"));
    ///     List<string> mimetypes;
    ///     mimetypes << "image/svg" << "image/png" << "image/jpeg";
    ///     structure.setMimetypes("images", mimetypes);
    ///     structure.addDirectoryDefinition("scripts", "code/", i18n("Executable Scripts"));
    ///     mimetypes.clear();
    ///     mimetypes << "text/\*";
    ///     structure.setMimetypes("scripts", mimetypes);
    ///     structure.addFileDefinition("mainscript", "code/main.js", i18n("Main Script File"));
    ///     structure.setRequired("mainscript", true);
    ///  @endcode
    ///  One may also choose to create a subclass of PackageStructure and include the setup
    ///  in the constructor.
    ///  Either way, PackageStructure creates a sort of "contract" between the packager and
    ///  the application which is also self-documenting.
    ///  See <see cref="IPackageStructureSignals"></see> for signals emitted by PackageStructure
    /// </remarks>        <short> A description of the expected file structure of a given package type.</short>
    [SmokeClass("Plasma::PackageStructure")]
    public class PackageStructure : QObject, IDisposable {
        protected PackageStructure(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(PackageStructure), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static PackageStructure() {
            staticInterceptor = new SmokeInvocation(typeof(PackageStructure), null);
        }
        /// <remarks>
        ///  Default constructor for a package structure definition
        ///  @arg type the type of package. This is often application specific.
        /// </remarks>        <short>    Default constructor for a package structure definition </short>
        public PackageStructure(QObject parent, string type) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("PackageStructure#$", "PackageStructure(QObject*, const QString&)", typeof(void), typeof(QObject), parent, typeof(string), type);
        }
        public PackageStructure(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("PackageStructure#", "PackageStructure(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public PackageStructure() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("PackageStructure", "PackageStructure()", typeof(void));
        }
        /// <remarks>
        ///  Type of package this structure describes
        /// </remarks>        <short>    Type of package this structure describes </short>
        public string type() {
            return (string) interceptor.Invoke("type", "type() const", typeof(string));
        }
        /// <remarks>
        ///  The directories defined for this package
        /// </remarks>        <short>    The directories defined for this package </short>
        public List<string> Directories() {
            return (List<string>) interceptor.Invoke("directories", "directories() const", typeof(List<string>));
        }
        /// <remarks>
        ///  The required directories defined for this package
        /// </remarks>        <short>    The required directories defined for this package </short>
        public List<string> RequiredDirectories() {
            return (List<string>) interceptor.Invoke("requiredDirectories", "requiredDirectories() const", typeof(List<string>));
        }
        /// <remarks>
        ///  The individual files, by key, that are defined for this package
        /// </remarks>        <short>    The individual files, by key, that are defined for this package </short>
        public List<string> Files() {
            return (List<string>) interceptor.Invoke("files", "files() const", typeof(List<string>));
        }
        /// <remarks>
        ///  The individual required files, by key, that are defined for this package
        /// </remarks>        <short>    The individual required files, by key, that are defined for this package </short>
        public List<string> RequiredFiles() {
            return (List<string>) interceptor.Invoke("requiredFiles", "requiredFiles() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Adds a directory to the structure of the package. It is added as
        ///  a not-required element with no associated mimetypes.
        /// <param> name="key" used as an internal label for this directory
        /// </param><param> name="path" the path within the package for this directory
        /// </param><param> name="name" the user visible (translated) name for the directory
        /// </param></remarks>        <short>    Adds a directory to the structure of the package.</short>
        public void AddDirectoryDefinition(string key, string path, string name) {
            interceptor.Invoke("addDirectoryDefinition$$$", "addDirectoryDefinition(const char*, const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), path, typeof(string), name);
        }
        /// <remarks>
        ///  Adds a file to the structure of the package. It is added as
        ///  a not-required element with no associated mimetypes.
        /// <param> name="key" used as an internal label for this file
        /// </param><param> name="path" the path within the package for this file
        /// </param><param> name="name" the user visible (translated) name for the file
        /// </param></remarks>        <short>    Adds a file to the structure of the package.</short>
        public void AddFileDefinition(string key, string path, string name) {
            interceptor.Invoke("addFileDefinition$$$", "addFileDefinition(const char*, const QString&, const QString&)", typeof(void), typeof(string), key, typeof(string), path, typeof(string), name);
        }
        /// <remarks>
        /// </remarks>        <return> path relative to the package root for the given entry
        /// </return>
        ///         <short>   </short>
        public string Path(string key) {
            return (string) interceptor.Invoke("path$", "path(const char*) const", typeof(string), typeof(string), key);
        }
        /// <remarks>
        ///  Get the list of files of a given type.
        ///  @arg key the type of file to look for
        /// </remarks>        <return> list of files by name
        /// </return>
        ///         <short>    Get the list of files of a given type.</short>
        public List<string> EntryList(string key) {
            return (List<string>) interceptor.Invoke("entryList$", "entryList(const char*)", typeof(List<string>), typeof(string), key);
        }
        /// <remarks>
        /// </remarks>        <return> user visible name for the given entry
        /// </return>
        ///         <short>   </short>
        public string Name(string key) {
            return (string) interceptor.Invoke("name$", "name(const char*) const", typeof(string), typeof(string), key);
        }
        /// <remarks>
        ///  Sets whether or not a given part of the structure is required or not.
        ///  The path must already have been added using addDirectoryDefinition
        ///  or addFileDefinition.
        /// <param> name="key" the entry within the package
        /// </param><param> name="required" true if this entry is required, false if not
        ///      </param></remarks>        <short>    Sets whether or not a given part of the structure is required or not.</short>
        public void SetRequired(string key, bool required) {
            interceptor.Invoke("setRequired$$", "setRequired(const char*, bool)", typeof(void), typeof(string), key, typeof(bool), required);
        }
        /// <remarks>
        /// </remarks>        <return> true if the item at path exists and is required
        /// </return>
        ///         <short>   </short>
        public bool IsRequired(string key) {
            return (bool) interceptor.Invoke("isRequired$", "isRequired(const char*) const", typeof(bool), typeof(string), key);
        }
        /// <remarks>
        ///  Defines the default mimetypes for any definitions that do not have
        ///  associated mimetypes. Handy for packages with only one or predominantly
        ///  one file type.
        /// <param> name="mimetypes" a list of mimetypes
        /// </param></remarks>        <short>    Defines the default mimetypes for any definitions that do not have  associated mimetypes.</short>
        public void SetDefaultMimetypes(List<string> mimetypes) {
            interceptor.Invoke("setDefaultMimetypes?", "setDefaultMimetypes(QStringList)", typeof(void), typeof(List<string>), mimetypes);
        }
        /// <remarks>
        ///  Define mimetypes for a given part of the structure
        ///  The path must already have been added using addDirectoryDefinition
        ///  or addFileDefinition.
        /// <param> name="key" the entry within the package
        /// </param><param> name="mimetypes" a list of mimetypes
        /// </param></remarks>        <short>    Define mimetypes for a given part of the structure  The path must already have been added using addDirectoryDefinition  or addFileDefinition.</short>
        public void SetMimetypes(string key, List<string> mimetypes) {
            interceptor.Invoke("setMimetypes$?", "setMimetypes(const char*, QStringList)", typeof(void), typeof(string), key, typeof(List<string>), mimetypes);
        }
        /// <remarks>
        /// </remarks>        <return> the mimetypes associated with the path, if any
        /// </return>
        ///         <short>   </short>
        public List<string> Mimetypes(string key) {
            return (List<string>) interceptor.Invoke("mimetypes$", "mimetypes(const char*) const", typeof(List<string>), typeof(string), key);
        }
        /// <remarks>
        ///  Sets the path to the package. Useful for package formats
        ///  which do not have well defined contents prior to installation.
        ///      </remarks>        <short>    Sets the path to the package.</short>
        public void SetPath(string path) {
            interceptor.Invoke("setPath$", "setPath(const QString&)", typeof(void), typeof(string), path);
        }
        /// <remarks>
        /// </remarks>        <return> the path to the package, or string() if none
        ///      </return>
        ///         <short>   </short>
        public string Path() {
            return (string) interceptor.Invoke("path", "path() const", typeof(string));
        }
        /// <remarks>
        ///  Read a package structure from a config file.
        ///      </remarks>        <short>    Read a package structure from a config file.</short>
        public void Read(KConfigBase config) {
            interceptor.Invoke("read#", "read(const KConfigBase*)", typeof(void), typeof(KConfigBase), config);
        }
        /// <remarks>
        ///  Write this package structure to a config file.
        ///      </remarks>        <short>    Write this package structure to a config file.</short>
        public void Write(KConfigBase config) {
            interceptor.Invoke("write#", "write(KConfigBase*) const", typeof(void), typeof(KConfigBase), config);
        }
        /// <remarks>
        ///  Installs a package matching this package structure. By default installs a
        ///  native Plasma.Package.
        /// <param> name="archivePath" path to the package archive file
        /// </param><param> name="packageRoot" path to the directory where the package should be
        ///                     installed to
        /// </param></remarks>        <return> true on successful installation, false otherwise
        /// </return>
        ///         <short>    Installs a package matching this package structure.</short>
        [SmokeMethod("installPackage(const QString&, const QString&)")]
        public virtual bool InstallPackage(string archivePath, string packageRoot) {
            return (bool) interceptor.Invoke("installPackage$$", "installPackage(const QString&, const QString&)", typeof(bool), typeof(string), archivePath, typeof(string), packageRoot);
        }
        /// <remarks>
        ///  Uninstalls a package matching this package structure.
        ///  @arg packageName the name of the package to remove
        ///  @arg packageRoot path to the directory where the package should be installed to
        /// </remarks>        <return> true on successful removal of the package, false otherwise
        ///      </return>
        ///         <short>    Uninstalls a package matching this package structure.</short>
        [SmokeMethod("uninstallPackage(const QString&, const QString&)")]
        public virtual bool UninstallPackage(string packageName, string packageRoot) {
            return (bool) interceptor.Invoke("uninstallPackage$$", "uninstallPackage(const QString&, const QString&)", typeof(bool), typeof(string), packageName, typeof(string), packageRoot);
        }
        /// <remarks>
        ///  When called, the package plugin should display a window to the user
        ///  that they can use to browser, select and then install widgets supported by
        ///  this package plugin with.
        ///  The user interface may be an in-process dialog or an out-of-process application.
        ///  When the process is complete, the newWidgetBrowserFinished() signal must be
        ///  emitted.
        /// <param> name="parent" the parent widget to use for the widget
        ///      </param></remarks>        <short>    When called, the package plugin should display a window to the user  that they can use to browser, select and then install widgets supported by  this package plugin with.</short>
        [SmokeMethod("createNewWidgetBrowser(QWidget*)")]
        public virtual void CreateNewWidgetBrowser(QWidget parent) {
            interceptor.Invoke("createNewWidgetBrowser#", "createNewWidgetBrowser(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        [SmokeMethod("createNewWidgetBrowser()")]
        public virtual void CreateNewWidgetBrowser() {
            interceptor.Invoke("createNewWidgetBrowser", "createNewWidgetBrowser()", typeof(void));
        }
        /// <remarks>
        /// </remarks>        <return> the prefix inserted between the base path and content entries
        ///      </return>
        ///         <short>   </short>
        public string ContentsPrefix() {
            return (string) interceptor.Invoke("contentsPrefix", "contentsPrefix() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> preferred package root. This defaults to plasma/plasmoids/
        ///      </return>
        ///         <short>   </short>
        public string DefaultPackageRoot() {
            return (string) interceptor.Invoke("defaultPackageRoot", "defaultPackageRoot() const", typeof(string));
        }
        /// <remarks>
        /// </remarks>        <return> service prefix used in desktop files. This defaults to plasma-applet-
        ///      </return>
        ///         <short>   </short>
        public string ServicePrefix() {
            return (string) interceptor.Invoke("servicePrefix", "servicePrefix() const", typeof(string));
        }
        /// <remarks>
        ///  Sets service prefix.
        ///      </remarks>        <short>    Sets service prefix.</short>
        public void SetServicePrefix(string servicePrefix) {
            interceptor.Invoke("setServicePrefix$", "setServicePrefix(const QString&)", typeof(void), typeof(string), servicePrefix);
        }
        /// <remarks>
        /// </remarks>        <return> the package metadata object.
        ///       </return>
        ///         <short>   </short>
        [SmokeMethod("metadata()")]
        public virtual Plasma.PackageMetadata Metadata() {
            return (Plasma.PackageMetadata) interceptor.Invoke("metadata", "metadata()", typeof(Plasma.PackageMetadata));
        }
        /// <remarks>
        /// </remarks>        <return> true if paths/symlinks outside the package itself should be followed.
        ///  By default this is set to false for security reasons.
        ///      </return>
        ///         <short>   </short>
        public bool AllowExternalPaths() {
            return (bool) interceptor.Invoke("allowExternalPaths", "allowExternalPaths() const", typeof(bool));
        }
        /// <remarks>
        ///  Sets whether or not external paths/symlinks can be followed by a package
        ///  @arg allow true if paths/symlinks outside of the package should be followed,
        ///              false if they should be rejected.
        ///      </remarks>        <short>    Sets whether or not external paths/symlinks can be followed by a package  @arg allow true if paths/symlinks outside of the package should be followed,              false if they should be rejected.</short>
        protected void SetAllowExternalPaths(bool allow) {
            interceptor.Invoke("setAllowExternalPaths$", "setAllowExternalPaths(bool)", typeof(void), typeof(bool), allow);
        }
        /// <remarks>
        ///  Sets the prefix that all the contents in this package should
        ///  appear under. This defaults to "contents/" and is added automatically
        ///  between the base path and the entries as defined by the package
        ///  structure
        ///  @arg prefix the directory prefix to use
        ///      </remarks>        <short>    Sets the prefix that all the contents in this package should  appear under.</short>
        protected void SetContentsPrefix(string prefix) {
            interceptor.Invoke("setContentsPrefix$", "setContentsPrefix(const QString&)", typeof(void), typeof(string), prefix);
        }
        /// <remarks>
        ///  Sets preferred package root.
        ///      </remarks>        <short>    Sets preferred package root.</short>
        protected void SetDefaultPackageRoot(string packageRoot) {
            interceptor.Invoke("setDefaultPackageRoot$", "setDefaultPackageRoot(const QString&)", typeof(void), typeof(string), packageRoot);
        }
        /// <remarks>
        ///  Called whenever the path changes so that subclasses may take
        ///  package specific actions.
        ///      </remarks>        <short>    Called whenever the path changes so that subclasses may take  package specific actions.</short>
        [SmokeMethod("pathChanged()")]
        protected virtual void PathChanged() {
            interceptor.Invoke("pathChanged", "pathChanged()", typeof(void));
        }
        ~PackageStructure() {
            interceptor.Invoke("~PackageStructure", "~PackageStructure()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~PackageStructure", "~PackageStructure()", typeof(void));
        }
        /// <remarks>
        ///  Loads a package format by name.
        ///  @arg format If not empty, attempts to locate the given format, either
        ///              from built-ins or via plugins.
        /// </remarks>        <return> a package that matches the format, if available. The caller
        ///          is responsible for deleting the object.
        ///      </return>
        ///         <short>    Loads a package format by name.</short>
        public static Plasma.PackageStructure Load(string packageFormat) {
            return (Plasma.PackageStructure) staticInterceptor.Invoke("load$", "load(const QString&)", typeof(Plasma.PackageStructure), typeof(string), packageFormat);
        }
        protected new IPackageStructureSignals Emit {
            get { return (IPackageStructureSignals) Q_EMIT; }
        }
    }

    public interface IPackageStructureSignals : IQObjectSignals {
        /// <remarks>
        ///  Emitted when the new widget browser process completes.
        ///      </remarks>        <short>    Emitted when the new widget browser process completes.</short>
        [Q_SIGNAL("void newWidgetBrowserFinished()")]
        void NewWidgetBrowserFinished();
    }
}
