.\"
.\" "$Id: lpstat.man 12854 2015-08-28 14:08:00Z msweet $"
.\"
.\" lpstat man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH lpstat 1 "CUPS" "12 June 2014" "Apple Inc."
.SH NAME
lpstat \- print cups status information
.SH SYNOPSIS
.B lpstat
[
.B \-E
] [
.B \-H
] [
.B \-U
.I username
] [
\fB\-h \fIhostname\fR[\fB:\fIport\fR]
] [
.B \-l
] [
.B \-W
.I which-jobs
] [
.B \-a
[
.I destination(s)
] ] [
.B \-c
[
.I class(es)
] ] [
.B \-d
] [
.B \-o
[
.I destination(s)
] ] [
.B \-p
[
.I printer(s)
] ] [
.B \-r
] [
.B \-R
] [
.B \-s
] [
.B \-t
] [
.B \-u
[
.I user(s)
] ] [
.B \-v
[
.I printer(s)
] ]
.SH DESCRIPTION
\fBlpstat\fR displays status information about the current classes, jobs, and printers.
When run with no arguments, \fBlpstat\fR will list active jobs queued by the current user.
.SH OPTIONS
The \fBlpstat\fR command supports the following options:
.TP 5
.B \-E
Forces encryption when connecting to the server.
.TP 5
.B \-H
Shows the server hostname and port.
.TP 5
.B \-R
Shows the ranking of print jobs.
.TP 5
\fB\-U \fIusername\fR
Specifies an alternate username.
.TP 5
\fB\-W \fIwhich-jobs\fR
Specifies which jobs to show, "completed" or "not-completed" (the default).
This option \fImust\fR appear before the \fI-o\fR option and/or any printer names, otherwise the default ("not-completed") value will be used in the request to the scheduler.
.TP 5
\fB\-a \fR[\fIprinter(s)\fR]
Shows the accepting state of printer queues.
If no printers are specified then all printers are listed.
.TP 5
\fB\-c \fR[\fIclass(es)\fR]
Shows the printer classes and the printers that belong to them.
If no classes are specified then all classes are listed.
.TP 5
.B \-d
Shows the current default destination.
.TP 5
\fB\-h \fIserver\fR[\fB:\fIport\fR]
Specifies an alternate server.
.TP 5
.B \-l
Shows a long listing of printers, classes, or jobs.
.TP 5
\fB\-o \fR[\fIdestination(s)\fR]
Shows the jobs queued on the specified destinations.
If no destinations are specified all jobs are shown.
.TP 5
\fB\-p \fR[\fIprinter(s)\fR]
Shows the printers and whether they are enabled for printing.
If no printers are specified then all printers are listed.
.TP 5
.B \-r
Shows whether the CUPS server is running.
.TP 5
.B \-s
Shows a status summary, including the default destination, a list of classes and their member printers, and a list of printers and their associated devices.
This is equivalent to using the \fI\-d\fR, \fI\-c\fR, and \fI\-v\fR options.
.TP 5
.B \-t
Shows all status information.
This is equivalent to using the \fI\-r\fR, \fI\-d\fR, \fI\-c\fR, \fI\-v\fR, \fI\-a\fR, \fI\-p\fR, and \fI\-o\fR options.
.TP 5
\fB\-u \fR[\fIuser(s)\fR]
Shows a list of print jobs queued by the specified users.
If no users are specified, lists the jobs queued by the current user.
.TP 5
\fB\-v \fR[\fIprinter(s)\fR]
Shows the printers and what device they are attached to.
If no printers are specified then all printers are listed.
.SH CONFORMING TO
Unlike the System V printing system, CUPS allows printer names to contain any printable character except SPACE, TAB, "/", and "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The \fI\-h\fR, \fI\-E\fR, \fI\-U\fR, and \fI\-W\fR options are unique to CUPS.
.LP
The Solaris \fI\-f\fR, \fI\-P\fR, and \fI\-S\fR options are silently ignored.
.SH SEE ALSO
.BR cancel (1),
.BR lp (1),
.BR lpq (1),
.BR lpr (1),
.BR lprm (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2015 by Apple Inc.
.\"
.\" End of "$Id: lpstat.man 12854 2015-08-28 14:08:00Z msweet $".
.\"
