/*
 * hidparser.h: HID Parser header file
 *
 * This file is part of the MGE UPS SYSTEMS HID Parser.
 *
 * Copyright (C) 1998-2003 MGE UPS SYSTEMS,
 *		Written by Luc Descotils.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------- */

#ifndef NUT_HID_PARSER_H_SEEN
#define NUT_HID_PARSER_H_SEEN 1


#ifdef __cplusplus
/* *INDENT-OFF* */
extern "C" {
/* *INDENT-ON* */
#endif /* __cplusplus */

/* "config.h" is generated by autotools and lacks a header guard, so
 * we use an unambiguously named macro we know we must have, as one.
 * It must be the first header: be sure to know all about system config.
 */
#ifndef NUT_NETVERSION
# include "config.h"
#endif

#include "hidtypes.h"

/* Include "usb-common.h" or "libshut.h" as appropriate, to define the 
 * usb_ctrl_* types used below according to the backend USB API version
 */
#if (defined SHUT_MODE) && SHUT_MODE
# include "libshut.h"
#else	/* !SHUT_MODE => USB */
# include "usb-common.h"
#endif	/* SHUT_MODE / USB */

/*
 * Parse_ReportDesc
 * -------------------------------------------------------------------------- */
HIDDesc_t *Parse_ReportDesc(const usb_ctrl_charbuf ReportDesc, const usb_ctrl_charbufsize n);

/*
 * Free_ReportDesc
 * -------------------------------------------------------------------------- */
void Free_ReportDesc(HIDDesc_t *pDesc_arg);

/*
 * FindObject
 * -------------------------------------------------------------------------- */
int FindObject(HIDDesc_t *pDesc_arg, HIDData_t *pData);

HIDData_t *FindObject_with_Path(HIDDesc_t *pDesc_arg, HIDPath_t *Path, uint8_t Type);

HIDData_t *FindObject_with_ID(HIDDesc_t *pDesc_arg, uint8_t ReportID, uint8_t Offset, uint8_t Type);

HIDData_t *FindObject_with_ID_Node(HIDDesc_t *pDesc_arg, uint8_t ReportID, HIDNode_t Node);
/*
 * GetValue
 * -------------------------------------------------------------------------- */
void GetValue(const unsigned char *Buf, HIDData_t *pData, long *pValue);

/*
 * SetValue
 * -------------------------------------------------------------------------- */
void SetValue(const HIDData_t *pData, unsigned char *Buf, long Value);


#ifdef __cplusplus
/* *INDENT-OFF* */
} /* extern "C" */
/* *INDENT-ON* */
#endif /* __cplusplus */

#endif	/* NUT_HID_PARSER_H_SEEN */
