// Generated by gmmproc 2.84.0 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gdkmm/event.h>
#include <gdkmm/private/event_p.h>


/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <https://www.gnu.org/licenses/>.
 */

#include <gdkmm/device.h>
#include <gdkmm/devicetool.h>
#include <gdkmm/display.h>
#include <gdkmm/drop.h>
#include <gdkmm/seat.h>
#include <gdkmm/surface.h>

using Type = Gdk::Event::Type;

namespace Gdk
{

std::vector<double> Event::get_axes() const
{
  double* axes = nullptr;
  guint n_axes = 0;
  if (!gdk_event_get_axes(const_cast<GdkEvent*>(gobj()), &axes, &n_axes))
    return {};

  return std::vector<double>(axes, axes + n_axes);
}

std::vector<TimeCoord> Event::get_history() const
{
  guint n_coords = 0;
  GdkTimeCoord* coords = gdk_event_get_history(const_cast<GdkEvent*>(gobj()), &n_coords);
  return Glib::ArrayHandler<TimeCoord, TimeCoordTraits>::array_to_vector(
    coords, n_coords, Glib::OWNERSHIP_DEEP);
}

} // name space Gdk

namespace
{
} // anonymous namespace

// static
GType Glib::Value<Gdk::KeyMatch>::value_type()
{
  return gdk_key_match_get_type();
}

// static
GType Glib::Value<Gdk::ScrollRelativeDirection>::value_type()
{
  return gdk_scroll_relative_direction_get_type();
}

// static
GType Glib::Value<Gdk::Event::Type>::value_type()
{
  return gdk_event_type_get_type();
}


/* Why reinterpret_cast<Event*>(gobject) is needed:
 *
 * A Event instance is in fact always a GdkEvent instance.
 * Unfortunately, GdkEvent cannot be a member of Event,
 * because it is an opaque struct.  Also, the C interface does not provide
 * any hooks to install a destroy notification handler, thus we cannot
 * wrap it dynamically either.
 *
 * The cast works because Event does not have any member data, and
 * it is impossible to derive from it.  This is ensured by using final on the
 * class and by using = delete on the default constructor.
 */

namespace Glib
{

Glib::RefPtr<Gdk::Event> wrap(GdkEvent* object, bool take_copy)
{
  if(take_copy && object)
    gdk_event_ref(object);

  // See the comment at the top of this file, if you want to know why the cast works.
  return Glib::make_refptr_for_instance<Gdk::Event>(reinterpret_cast<Gdk::Event*>(object));
}

} // namespace Glib


namespace Gdk
{

void Event::reference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gdk_event_ref(reinterpret_cast<GdkEvent*>(const_cast<Event*>(this)));
}

void Event::unreference() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  gdk_event_unref(reinterpret_cast<GdkEvent*>(const_cast<Event*>(this)));
}

GdkEvent* Event::gobj()
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<GdkEvent*>(this);
}

const GdkEvent* Event::gobj() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  return reinterpret_cast<const GdkEvent*>(this);
}

GdkEvent* Event::gobj_copy() const
{
  // See the comment at the top of this file, if you want to know why the cast works.
  const auto gobject = reinterpret_cast<GdkEvent*>(const_cast<Event*>(this));
  gdk_event_ref(gobject);
  return gobject;
}


Type Event::get_event_type() const
{
  return static_cast<Type>(gdk_event_get_event_type(const_cast<GdkEvent*>(gobj())));
}

Glib::RefPtr<Surface> Event::get_surface()
{
  auto retvalue = Glib::wrap(gdk_event_get_surface(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Event::get_surface() const
{
  return const_cast<Event*>(this)->get_surface();
}

Glib::RefPtr<Seat> Event::get_seat()
{
  auto retvalue = Glib::wrap(gdk_event_get_seat(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Seat> Event::get_seat() const
{
  return const_cast<Event*>(this)->get_seat();
}

Glib::RefPtr<Device> Event::get_device()
{
  auto retvalue = Glib::wrap(gdk_event_get_device(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Device> Event::get_device() const
{
  return const_cast<Event*>(this)->get_device();
}

Glib::RefPtr<DeviceTool> Event::get_device_tool()
{
  auto retvalue = Glib::wrap(gdk_event_get_device_tool(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const DeviceTool> Event::get_device_tool() const
{
  return const_cast<Event*>(this)->get_device_tool();
}

guint32 Event::get_time() const
{
  return gdk_event_get_time(const_cast<GdkEvent*>(gobj()));
}

Glib::RefPtr<Display> Event::get_display()
{
  auto retvalue = Glib::wrap(gdk_event_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Display> Event::get_display() const
{
  return const_cast<Event*>(this)->get_display();
}

const EventSequence* Event::get_event_sequence() const
{
  return reinterpret_cast<const EventSequence*>(gdk_event_get_event_sequence(const_cast<GdkEvent*>(gobj())));
}

ModifierType Event::get_modifier_state() const
{
  return static_cast<ModifierType>(gdk_event_get_modifier_state(const_cast<GdkEvent*>(gobj())));
}

bool Event::get_position(double& x, double& y) const
{
  return gdk_event_get_position(const_cast<GdkEvent*>(gobj()), &(x), &(y));
}

bool Event::get_axis(Gdk::AxisUse axis_use, double& value) const
{
  return gdk_event_get_axis(const_cast<GdkEvent*>(gobj()), static_cast<GdkAxisUse>(axis_use), &(value));
}

bool Event::get_pointer_emulated() const
{
  return gdk_event_get_pointer_emulated(const_cast<GdkEvent*>(gobj()));
}

guint Event::get_button() const
{
  return gdk_button_event_get_button(const_cast<GdkEvent*>(gobj()));
}

ScrollDirection Event::get_direction() const
{
  return static_cast<ScrollDirection>(gdk_scroll_event_get_direction(const_cast<GdkEvent*>(gobj())));
}

void Event::get_deltas(double& delta_x, double& delta_y) const
{
  gdk_scroll_event_get_deltas(const_cast<GdkEvent*>(gobj()), &(delta_x), &(delta_y));
}

ScrollUnit Event::get_scroll_unit() const
{
  return static_cast<ScrollUnit>(gdk_scroll_event_get_unit(const_cast<GdkEvent*>(gobj())));
}

bool Event::is_scroll_stop() const
{
  return gdk_scroll_event_is_stop(const_cast<GdkEvent*>(gobj()));
}

ScrollRelativeDirection Event::get_relative_direction() const
{
  return static_cast<ScrollRelativeDirection>(gdk_scroll_event_get_relative_direction(const_cast<GdkEvent*>(gobj())));
}

guint Event::get_keyval() const
{
  return gdk_key_event_get_keyval(const_cast<GdkEvent*>(gobj()));
}

guint Event::get_keycode() const
{
  return gdk_key_event_get_keycode(const_cast<GdkEvent*>(gobj()));
}

ModifierType Event::get_consumed_modifiers() const
{
  return static_cast<ModifierType>(gdk_key_event_get_consumed_modifiers(const_cast<GdkEvent*>(gobj())));
}

guint Event::get_layout() const
{
  return gdk_key_event_get_layout(const_cast<GdkEvent*>(gobj()));
}

guint Event::get_level() const
{
  return gdk_key_event_get_level(const_cast<GdkEvent*>(gobj()));
}

bool Event::is_modifier() const
{
  return gdk_key_event_is_modifier(const_cast<GdkEvent*>(gobj()));
}

bool Event::get_focus_in() const
{
  return gdk_focus_event_get_in(const_cast<GdkEvent*>(gobj()));
}

bool Event::get_touch_emulating_pointer() const
{
  return gdk_touch_event_get_emulating_pointer(const_cast<GdkEvent*>(gobj()));
}

CrossingMode Event::get_crossing_mode() const
{
  return static_cast<CrossingMode>(gdk_crossing_event_get_mode(const_cast<GdkEvent*>(gobj())));
}

NotifyType Event::get_crossing_detail() const
{
  return static_cast<NotifyType>(gdk_crossing_event_get_detail(const_cast<GdkEvent*>(gobj())));
}

bool Event::get_crossing_focus() const
{
  return gdk_crossing_event_get_focus(const_cast<GdkEvent*>(gobj()));
}

TouchpadGesturePhase Event::get_touchpad_gesture_phase() const
{
  return static_cast<TouchpadGesturePhase>(gdk_touchpad_event_get_gesture_phase(const_cast<GdkEvent*>(gobj())));
}

guint Event::get_touchpad_n_fingers() const
{
  return gdk_touchpad_event_get_n_fingers(const_cast<GdkEvent*>(gobj()));
}

void Event::get_touchpad_deltas(double& dx, double& dy) const
{
  gdk_touchpad_event_get_deltas(const_cast<GdkEvent*>(gobj()), &(dx), &(dy));
}

double Event::get_touchpad_pinch_angle_delta() const
{
  return gdk_touchpad_event_get_pinch_angle_delta(const_cast<GdkEvent*>(gobj()));
}

double Event::get_touchpad_pinch_scale() const
{
  return gdk_touchpad_event_get_pinch_scale(const_cast<GdkEvent*>(gobj()));
}

guint Event::get_pad_button() const
{
  return gdk_pad_event_get_button(const_cast<GdkEvent*>(gobj()));
}

void Event::get_pad_axis_value(guint& index, double& value) const
{
  gdk_pad_event_get_axis_value(const_cast<GdkEvent*>(gobj()), &(index), &(value));
}

void Event::get_pad_group_mode(guint& group, guint& mode) const
{
  gdk_pad_event_get_group_mode(const_cast<GdkEvent*>(gobj()), &(group), &(mode));
}

Glib::RefPtr<Drop> Event::get_dnd_drop()
{
  auto retvalue = Glib::wrap(gdk_dnd_event_get_drop(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Drop> Event::get_dnd_drop() const
{
  return const_cast<Event*>(this)->get_dnd_drop();
}

Glib::RefPtr<Surface> Event::get_grab_broken_grab_surface()
{
  auto retvalue = Glib::wrap(gdk_grab_broken_event_get_grab_surface(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Surface> Event::get_grab_broken_grab_surface() const
{
  return const_cast<Event*>(this)->get_grab_broken_grab_surface();
}

bool Event::get_grab_broken_implicit() const
{
  return gdk_grab_broken_event_get_implicit(const_cast<GdkEvent*>(gobj()));
}

bool Event::triggers_context_menu() const
{
  return gdk_event_triggers_context_menu(const_cast<GdkEvent*>(gobj()));
}

bool Event::get_distance(const Glib::RefPtr<const Event>& event2, double& distance) const
{
  return gdk_events_get_distance(const_cast<GdkEvent*>(gobj()), const_cast<GdkEvent*>(Glib::unwrap(event2)), &(distance));
}

bool Event::get_angle(const Glib::RefPtr<const Event>& event2, double& angle) const
{
  return gdk_events_get_angle(const_cast<GdkEvent*>(gobj()), const_cast<GdkEvent*>(Glib::unwrap(event2)), &(angle));
}

bool Event::get_center(const Glib::RefPtr<const Event>& event2, double& x, double& y) const
{
  return gdk_events_get_center(const_cast<GdkEvent*>(gobj()), const_cast<GdkEvent*>(Glib::unwrap(event2)), &(x), &(y));
}

KeyMatch Event::matches(guint keyval, ModifierType modifiers) const
{
  return static_cast<KeyMatch>(gdk_key_event_matches(const_cast<GdkEvent*>(gobj()), keyval, static_cast<GdkModifierType>(modifiers)));
}

bool Event::get_match(guint& keyval, ModifierType& modifiers) const
{
  return gdk_key_event_get_match(const_cast<GdkEvent*>(gobj()), &(keyval), ((GdkModifierType*) &(modifiers)));
}


} // namespace Gdk


