##
## Author: Hank Anderson <hank@statease.com>
## Description: Ported from portion of OpenBLAS/Makefile.system
##              Sets Fortran related variables.

if (${F_COMPILER} STREQUAL "FLANG" AND NOT CMAKE_Fortran_COMPILER_ID STREQUAL "LLVMFlang")
  # This is for classic Flang. LLVM Flang is handled with gfortran below.
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_FLANG")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-fopenmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
  set(FCOMMON_OPT "${FCOMMON_OPT} -Mrecursive -Kieee")
endif ()

if (${F_COMPILER} STREQUAL "G77")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_G77")
  set(FCOMMON_OPT "${FCOMMON_OPT} -Wall")
  if (NOT NO_BINARY_MODE)
    if (BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
    else ()
      set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
    endif ()
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "G95")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_G95")
  set(FCOMMON_OPT "${FCOMMON_OPT} -Wall")
  if (NOT NO_BINARY_MODE)
    if (BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
    else ()
      set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
    endif ()
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "GFORTRAN" OR ${F_COMPILER} STREQUAL "F95" OR CMAKE_Fortran_COMPILER_ID STREQUAL "LLVMFlang")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_GFORT")
  if (NOT CMAKE_Fortran_COMPILER_ID STREQUAL "LLVMFlang")
    # ensure reentrancy of lapack codes
    set(FCOMMON_OPT "${FCOMMON_OPT} -Wall -frecursive")
    # work around ABI violation in passing string arguments from C
    set(FCOMMON_OPT "${FCOMMON_OPT} -fno-optimize-sibling-calls")
    if (NOT NO_LAPACK)
      # Don't include -lgfortran, when NO_LAPACK=1 or lsbcc
      set(EXTRALIB "${EXTRALIB} -lgfortran")
    endif ()
  endif ()
  if (NO_BINARY_MODE)
    if (MIPS64)
      if (BINARY64)
        set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=64")
        if (INTERFACE64)
          set(FCOMMON_OPT "${FCOMMON_OPT} -fdefault-integer-8")
	endif ()
      else ()
        set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=n32")
      endif ()
    endif ()
    if (LOONGARCH64)
      if (BINARY64)
        if (NOT CMAKE_Fortran_COMPILER_ID MATCHES "LLVMFlang.*")
	  CHECK_C_COMPILER_FLAG("-mabi=lp64d" COMPILER_SUPPORT_LP64D_ABI)
          if(COMPILER_SUPPORT_LP64D_ABI)
	    set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=lp64d")
	  else()
	    set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=lp64")
	  endif ()
        endif ()
        if (INTERFACE64) 
          set(FCOMMON_OPT "${FCOMMON_OPT} -fdefault-integer-8") 
        endif () 
      else ()
        if (NOT CMAKE_Fortran_COMPILER_ID MATCHES "LLVMFlang.*")
	  CHECK_C_COMPILER_FLAG("-mabi=ilp32d" COMPILER_SUPPORT_ILP32D_ABI)
	  if(COMPILER_SUPPORT_ILP32D_ABI)
	    set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=ilp32d")
	  else()
	    set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=lp32")
          endif ()
	endif ()
      endif ()
    endif ()
    if (RISCV64)
      if (BINARY64)
        if (INTERFACE64)
          set(FCOMMON_OPT "${FCOMMON_OPT} -fdefault-integer-8")
        endif ()
      endif ()
    endif ()
    if (ARM64 AND INTERFACE64)
          set(FCOMMON_OPT "${FCOMMON_OPT} -fdefault-integer-8")
    endif ()
  else ()
    if (BINARY64)
      if (NOT CMAKE_Fortran_COMPILER_ID MATCHES "LLVMFlang.*")
      set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
      endif ()
      if (INTERFACE64)
        if (CMAKE_Fortran_COMPILER_ID STREQUAL "Intel")
          if (WIN32)
            set(FCOMMON_OPT "${FCOMMON_OPT} /integer-size:64")
          else ()
            set(FCOMMON_OPT "${FCOMMON_OPT} -integer-size 64")
          endif ()
        else ()
          set(FCOMMON_OPT "${FCOMMON_OPT} -fdefault-integer-8")
        endif ()
      endif ()
    else ()
        if (NOT CMAKE_Fortran_COMPILER_ID MATCHES "LLVMFlang.*")
           set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
	endif ()
    endif ()
  endif ()

  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-fopenmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "INTEL" OR CMAKE_Fortran_COMPILER_ID MATCHES "Intel")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_INTEL")
  if (INTERFACE64)
    set(FCOMMON_OPT "${FCOMMON_OPT} -i8")
  endif ()
  set(FCOMMON_OPT "${FCOMMON_OPT} -recursive -fp-model=consistent")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-openmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "FUJITSU")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_FUJITSU")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-openmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "IBM")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_IBM")
  set(FCOMMON_OPT "${FCOMMON_OPT} -qrecur")
  if (BINARY64)
    set(FCOMMON_OPT "${FCOMMON_OPT} -q64")
    if (INTERFACE64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -qintsize=8")
    endif ()
  else ()
    set(FCOMMON_OPT "${FCOMMON_OPT} -q32")
  endif ()
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-openmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "PGI" OR ${F_COMPILER} STREQUAL "PGF95")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_PGI")
  set(COMMON_PROF "${COMMON_PROF} -DPGICOMPILER")
  if (BINARY64)
    if (INTERFACE64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -i8")
    endif ()
    set(FCOMMON_OPT "${FCOMMON_OPT} -tp p7-64")
  else ()
    set(FCOMMON_OPT "${FCOMMON_OPT} -tp p7")
  endif ()
  set(FCOMMON_OPT "${FCOMMON_OPT} -Mrecursive")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-mp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "PATHSCALE")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_PATHSCALE")
  if (BINARY64)
    if (INTERFACE64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -i8")
    endif ()
  endif ()

  if (NOT MIPS64)
    if (NOT BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
    else ()
      set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
    endif ()
  else ()
    if (BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=64")
    else ()
    set(FCOMMON_OPT "${FCOMMON_OPT} -mabi=n32")
    endif ()
  endif ()

  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-mp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "OPEN64")

  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_OPEN64")
  if (BINARY64)
    if (INTERFACE64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -i8")
    endif ()
  endif ()

  if (MIPS64)

    if (NOT BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -n32")
    else ()
      set(FCOMMON_OPT "${FCOMMON_OPT} -n64")
    endif ()

    if (${CORE} STREQUAL "LOONGSON3A")
      set(FCOMMON_OPT "${FCOMMON_OPT} -loongson3 -static")
    endif ()

    if (${CORE} STREQUAL "LOONGSON3B")
    set(FCOMMON_OPT "${FCOMMON_OPT} -loongson3 -static")
    endif ()
  else ()
    if (NOT BINARY64)
      set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
    else ()
      set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
    endif ()
  endif ()

  if (USE_OPENMP)
    set(FEXTRALIB "${FEXTRALIB} -lstdc++")
    set(OpenMP_Fortran_FLAGS "-mp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "SUN")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_SUN")
  if (X86)
    set(FCOMMON_OPT "${FCOMMON_OPT} -m32")
  else ()
    set(FCOMMON_OPT "${FCOMMON_OPT} -m64")
  endif ()
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-xopenmp=parallel" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "COMPAQ")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_COMPAQ")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-openmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "CRAY")
	set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_CRAYFC")
  set(FCOMMON_OPT "${FCOMMON_OPT} -hnopattern")
  if (INTERFACE64)
    set (FCOMMON_OPT "${FCOMMON_OPT} -s integer64")
  endif ()
  if (NOT USE_OPENMP)
    set(FCOMMON_OPT "${FCOMMON_OPT} -fno-openmp")
  else ()
    set(OpenMP_Fortran_FLAGS "-fopenmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

if (${F_COMPILER} STREQUAL "NAGFOR")
  set(CCOMMON_OPT "${CCOMMON_OPT} -DF_INTERFACE_NAG")
  if (INTERFACE64)
    set(FCOMMON_OPT "${FCOMMON_OPT} -i8")
  endif ()
  # Options from Makefile.system
  # -dcfuns: Enable non-standard double precision complex intrinsic functions
  # -ieee=full: enables all IEEE arithmetic facilities including non-stop arithmetic.
  # -w=obs: Suppress warning messages about obsolescent features
  # -thread_safe: Compile code for safe execution in a multi-threaded environment.
  # -recursive: Specifies that procedures are RECURSIVE by default.
  set(FCOMMON_OPT "${FCOMMON_OPT} -dcfuns -recursive -ieee=full -w=obs -thread_safe")
  # Options from Reference-LAPACK
  # Suppress compiler banner and summary
  set(FCOMMON_OPT "${FCOMMON_OPT} -quiet")
  # Disable other common warnings
  # -w=x77: Suppress warning messages about Fortran 77 features
  # -w=ques: Suppress warning messages about questionable usage
  # -w=unused: Suppress warning messages about unused variables
  set(FCOMMON_OPT "${FCOMMON_OPT} -w=x77 -w=ques -w=unused")
  if (USE_OPENMP)
    set(OpenMP_Fortran_FLAGS "-openmp" CACHE STRING "OpenMP Fortran compiler flags")
  endif ()
endif ()

# from the root Makefile - this is for lapack-netlib to compile the correct secnd file.
if (${F_COMPILER} STREQUAL "GFORTRAN")
  set(TIMER "INT_ETIME")
else ()
  set(TIMER "NONE")
endif ()

