# Find GSS.framework
# This will define :
#
# GSSFRAMEWORK_FOUND
# GSSFRAMEWORK_INCLUDE_DIR
# GSSFRAMEWORK_LIBRARIES
# GSSFRAMEWORK_LDFLAGS
#

find_path(GSSFRAMEWORK_INCLUDE_DIR NAMES GSS.h)
find_library(GSSFRAMEWORK_LIBRARIES NAMES GSS)
if(GSSFRAMEWORK_INCLUDE_DIR AND GSSFRAMEWORK_LIBRARIES)
	if(NOT CoreFoundation_FIND_QUIETLY)
		message(STATUS "Found GSS.framework ${GSSFRAMEWORK_LIBRARIES}")
	endif()
	set(GSSFRAMEWORK_FOUND TRUE)
	set(GSSFRAMEWORK_LDFLAGS "-framework GSS")
endif()

if(GSS_FIND_REQUIRED AND NOT GSSFRAMEWORK_FOUND)
	message(FATAL_ERROR "CoreFoundation not found")
endif()

mark_as_advanced(
	GSSFRAMEWORK_INCLUDE_DIR
	GSSFRAMEWORK_LIBRARIES
	GSSFRAMEWORK_LDFLAGS
)
