#ifndef PROGRESSBAR_H
#define PROGRESSBAR_H
/*
 * Create a squashfs filesystem.  This is a highly compressed read only
 * filesystem.
 *
 * Copyright (c) 2012, 2013, 2014, 2022, 2025
 * Phillip Lougher <phillip@squashfs.org.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2,
 * or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * progressbar.h
 */

extern void inc_progress_bar();
extern void dec_progress_bar(int count);
extern void progress_bar_size(int count);
extern void enable_progress_bar();
extern void disable_progress_bar();
extern void init_progress_bar();
extern void set_progressbar_state(int);
extern void progressbar_percentage();
extern void progress_bar_metadata(int inodes);
extern void inc_meta_progress_bar();
extern void progressbar_finish();
#endif
