.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_error.mdoc -- description of zip_error_t
.\" Copyright (C) 2025 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_ERROR" "5" "May 5, 2025" "NiH" "File Formats Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_error\fR
\- error information
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_error_t error\fR;
.SH "DESCRIPTION"
A
\fBzip_error\fR
represents information about an error.
It is usually allocated directly on the stack or as member of another structure, not via a pointer.
.PP
It is initialized with
zip_error_init(3)
or
zip_error_init_with_code(3).
.PP
The type of error can be accessed with
zip_error_code_zip(3)
and
zip_error_code_system(3).
It can be converted to a human readable string with
zip_error_strerror(3).
.PP
After use, it should be cleaned up with
zip_error_fini(3).
.SH "SEE ALSO"
zip_error_code_system(3),
zip_error_code_zip(3),
zip_error_fini(3),
zip_error_init(3),
zip_error_init_with_code(3),
zip_error_strerror(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
