// Copyright (c) 2020 The Khronos Group Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and/or associated documentation files (the "Materials"),
// to deal in the Materials without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Materials, and to permit persons to whom the
// Materials are furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Materials.
//
// THE MATERIALS ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM,OUT OF OR IN CONNECTION WITH THE MATERIALS OR THE USE OR OTHER DEALINGS
// IN THE MATERIALS.

// The header is for SPIR-V to LLVM IR internal definitions, that are not a part
// of Khronos SPIR-V specification.

#include "spirv/unified1/spirv.hpp"

#ifndef spirv_internal_HPP
#define spirv_internal_HPP

namespace spv {
namespace internal {

enum InternalSourceLanguageNonSemanticDI {
  ISourceLanguagePython = 200,
  ISourceLanguageJulia = 201,
  ISourceLanguageRust = 202,
  ISourceLanguageD = 203,
  ISourceLanguageFortran77 = 204,
  ISourceLanguageFortran90 = 205,
  ISourceLanguageFortran95 = 206,
  ISourceLanguageFortran2003 = 207,
  ISourceLanguageFortran2008 = 208,
  ISourceLanguageFortran2018 = 209,
  ISourceLanguageC = 210,
  ISourceLanguageC99 = 211,
  ISourceLanguageC11 = 212,
  ISourceLanguageC17 = 213,
  ISourceLanguageCPP = 214,
  ISourceLanguageCPP03 = 215,
  ISourceLanguageCPP11 = 216,
  ISourceLanguageCPP14 = 217,
  ISourceLanguageCPP17 = 218,
  ISourceLanguageCPP20 = 219,
};

enum InternalLinkageType {
    ILTPrev = LinkageTypeMax - 2,
    ILTInternal
};

enum InternalOp {
  IOpTypeTokenINTEL = 6113,
  IOpTypeJointMatrixINTEL = 6119,
  IOpJointMatrixLoadINTEL = 6120,
  IOpJointMatrixStoreINTEL = 6121,
  IOpJointMatrixMadINTEL = 6122,
  IOpJointMatrixSUMadINTEL = 6128,
  IOpJointMatrixUSMadINTEL = 6129,
  IOpJointMatrixUUMadINTEL = 6130,
  IOpTaskSequenceCreateINTEL = 6163,
  IOpTaskSequenceAsyncINTEL = 6164,
  IOpTaskSequenceGetINTEL = 6165,
  IOpTaskSequenceReleaseINTEL = 6166,
  IOpTypeJointMatrixINTELv2 = 6184,
  IOpCooperativeMatrixLoadCheckedINTEL = 6193,
  IOpCooperativeMatrixStoreCheckedINTEL = 6194,
  IOpCooperativeMatrixConstructCheckedINTEL = 6195,
  IOpCooperativeMatrixLoadOffsetINTEL = 6239,
  IOpCooperativeMatrixStoreOffsetINTEL = 6240,
  IOpJointMatrixWorkItemLengthINTEL = 6410,
  IOpTypeTaskSequenceINTEL = 6199,
  IOpMaskedGatherINTEL = 6428,
  IOpMaskedScatterINTEL = 6429,
  IOpJointMatrixGetElementCoordINTEL = 6440,
  IOpCooperativeMatrixApplyFunctionINTEL = 6448,
  IOpCooperativeMatrixPrefetchINTEL = 6449,
  IOpConvertHandleToImageINTEL = 6529,
  IOpConvertHandleToSamplerINTEL = 6530,
  IOpConvertHandleToSampledImageINTEL = 6531,
  IOpPrev = OpMax - 2,
  IOpForward
};

enum InternalDecoration {
  IDecRuntimeAlignedINTEL = 5940,
  IDecCallableFunctionINTEL = 6087,
  IDecHostAccessINTEL = 6147,
  IDecInitModeINTEL = 6148,
  IDecImplementInCSRINTEL = 6149,
  IDecArgumentAttributeINTEL = 6409,
};

enum InternalCapability {
  ICapTokenTypeINTEL = 6112,
  ICapabilityJointMatrixINTEL = 6118,
  ICapabilityHWThreadQueryINTEL = 6134,
  ICapGlobalVariableDecorationsINTEL = 6146,
  ICapabilityTaskSequenceINTEL = 6162,
  ICapabilityCooperativeMatrixCheckedInstructionsINTEL = 6192,
  ICapabilityBFloat16ArithmeticINTEL = 6226,
  ICapabilityCooperativeMatrixOffsetInstructionsINTEL = 6238,
  ICapabilityAtomicBFloat16AddINTEL = 6255,
  ICapabilityAtomicBFloat16MinMaxINTEL = 6256,
  ICapabilityCooperativeMatrixPrefetchINTEL = 6411,
  ICapabilityMaskedGatherScatterINTEL = 6427,
  ICapabilityJointMatrixWIInstructionsINTEL = 6435,
  ICapabilityCooperativeMatrixInvocationInstructionsINTEL = 6435,
  ICapabilityJointMatrixTF32ComponentTypeINTEL = 6436,
  ICapabilityJointMatrixBF16ComponentTypeINTEL = 6437,
  ICapabilityJointMatrixPackedInt2ComponentTypeINTEL = 6438,
  ICapabilityJointMatrixPackedInt4ComponentTypeINTEL = 6439,
  ICapabilitySubgroupRequirementsINTEL = 6445,
  ICapabilityBindlessImagesINTEL = 6528
};

enum InternalExecutionMode {
  IExecModeNamedSubgroupSizeINTEL = 6446,
};

constexpr LinkageType LinkageTypeInternal =
    static_cast<LinkageType>(ILTInternal);

enum InternalJointMatrixLayout {
  RowMajor = 0,
  ColumnMajor = 1,
  PackedA = 2,
  PackedB = 3
};

enum InternalJointMatrixUse { MatrixA = 0, MatrixB = 1, Accumulator = 2 };

enum InternalJointMatrixCTI {
  None = 0,
  TF32 = 1,
  Bfloat16 = 2,
  PackedInt2 = 3,
  PackedInt4 = 4
};

enum InternalBuiltIn {
  IBuiltInSubDeviceIDINTEL = 6135,
  IBuiltInGlobalHWThreadIDINTEL = 6136,
};

#define _SPIRV_OP(x, y) constexpr x x##y = static_cast<x>(I##x##y);
_SPIRV_OP(Capability, JointMatrixINTEL)
_SPIRV_OP(Capability, JointMatrixWIInstructionsINTEL)
_SPIRV_OP(Capability, JointMatrixTF32ComponentTypeINTEL)
_SPIRV_OP(Capability, JointMatrixBF16ComponentTypeINTEL)
_SPIRV_OP(Capability, JointMatrixPackedInt2ComponentTypeINTEL)
_SPIRV_OP(Capability, JointMatrixPackedInt4ComponentTypeINTEL)
_SPIRV_OP(Op, TypeJointMatrixINTEL)
_SPIRV_OP(Op, TypeJointMatrixINTELv2)
_SPIRV_OP(Op, JointMatrixLoadINTEL)
_SPIRV_OP(Op, JointMatrixStoreINTEL)
_SPIRV_OP(Op, JointMatrixMadINTEL)
_SPIRV_OP(Op, JointMatrixSUMadINTEL)
_SPIRV_OP(Op, JointMatrixUSMadINTEL)
_SPIRV_OP(Op, JointMatrixUUMadINTEL)
_SPIRV_OP(Op, JointMatrixWorkItemLengthINTEL)
_SPIRV_OP(Op, JointMatrixGetElementCoordINTEL)

_SPIRV_OP(Capability, CooperativeMatrixPrefetchINTEL)
_SPIRV_OP(Op, CooperativeMatrixPrefetchINTEL)

_SPIRV_OP(Capability, CooperativeMatrixCheckedInstructionsINTEL)
_SPIRV_OP(Op, CooperativeMatrixLoadCheckedINTEL)
_SPIRV_OP(Op, CooperativeMatrixStoreCheckedINTEL)
_SPIRV_OP(Op, CooperativeMatrixConstructCheckedINTEL)

_SPIRV_OP(Capability, CooperativeMatrixOffsetInstructionsINTEL)
_SPIRV_OP(Op, CooperativeMatrixLoadOffsetINTEL)
_SPIRV_OP(Op, CooperativeMatrixStoreOffsetINTEL)

_SPIRV_OP(Capability, CooperativeMatrixInvocationInstructionsINTEL)
_SPIRV_OP(Op, CooperativeMatrixApplyFunctionINTEL)

_SPIRV_OP(Capability, HWThreadQueryINTEL)
_SPIRV_OP(BuiltIn, SubDeviceIDINTEL)
_SPIRV_OP(BuiltIn, GlobalHWThreadIDINTEL)

_SPIRV_OP(Capability, MaskedGatherScatterINTEL)
_SPIRV_OP(Op, MaskedGatherINTEL)
_SPIRV_OP(Op, MaskedScatterINTEL)

_SPIRV_OP(Capability, SubgroupRequirementsINTEL)

_SPIRV_OP(Capability, TaskSequenceINTEL)
_SPIRV_OP(Op, TaskSequenceCreateINTEL)
_SPIRV_OP(Op, TaskSequenceAsyncINTEL)
_SPIRV_OP(Op, TaskSequenceGetINTEL)
_SPIRV_OP(Op, TaskSequenceReleaseINTEL)
_SPIRV_OP(Op, TypeTaskSequenceINTEL)

_SPIRV_OP(Capability, BindlessImagesINTEL)
_SPIRV_OP(Op, ConvertHandleToImageINTEL)
_SPIRV_OP(Op, ConvertHandleToSamplerINTEL)
_SPIRV_OP(Op, ConvertHandleToSampledImageINTEL)

_SPIRV_OP(Capability, AtomicBFloat16AddINTEL)
_SPIRV_OP(Capability, AtomicBFloat16MinMaxINTEL)
#undef _SPIRV_OP

constexpr SourceLanguage SourceLanguagePython =
    static_cast<SourceLanguage>(ISourceLanguagePython);
constexpr SourceLanguage SourceLanguageJulia =
    static_cast<SourceLanguage>(ISourceLanguageJulia);
constexpr SourceLanguage SourceLanguageRust =
    static_cast<SourceLanguage>(ISourceLanguageRust);
constexpr SourceLanguage SourceLanguageD =
    static_cast<SourceLanguage>(ISourceLanguageD);
constexpr SourceLanguage SourceLanguageFortran77 =
    static_cast<SourceLanguage>(ISourceLanguageFortran77);
constexpr SourceLanguage SourceLanguageFortran90 =
    static_cast<SourceLanguage>(ISourceLanguageFortran90);
constexpr SourceLanguage SourceLanguageFortran95 =
    static_cast<SourceLanguage>(ISourceLanguageFortran95);
constexpr SourceLanguage SourceLanguageFortran2003 =
    static_cast<SourceLanguage>(ISourceLanguageFortran2003);
constexpr SourceLanguage SourceLanguageFortran2008 =
    static_cast<SourceLanguage>(ISourceLanguageFortran2008);
constexpr SourceLanguage SourceLanguageFortran2018 =
    static_cast<SourceLanguage>(ISourceLanguageFortran2018);
constexpr SourceLanguage SourceLanguageC =
    static_cast<SourceLanguage>(ISourceLanguageC);
constexpr SourceLanguage SourceLanguageC99 =
    static_cast<SourceLanguage>(ISourceLanguageC99);
constexpr SourceLanguage SourceLanguageC11 =
    static_cast<SourceLanguage>(ISourceLanguageC11);
constexpr SourceLanguage SourceLanguageC17 =
    static_cast<SourceLanguage>(ISourceLanguageC17);
constexpr SourceLanguage SourceLanguageCPP =
    static_cast<SourceLanguage>(ISourceLanguageCPP);
constexpr SourceLanguage SourceLanguageCPP03 =
    static_cast<SourceLanguage>(ISourceLanguageCPP03);
constexpr SourceLanguage SourceLanguageCPP11 =
    static_cast<SourceLanguage>(ISourceLanguageCPP11);
constexpr SourceLanguage SourceLanguageCPP14 =
    static_cast<SourceLanguage>(ISourceLanguageCPP14);
constexpr SourceLanguage SourceLanguageCPP17 =
    static_cast<SourceLanguage>(ISourceLanguageCPP17);
constexpr SourceLanguage SourceLanguageCPP20 =
    static_cast<SourceLanguage>(ISourceLanguageCPP20);

constexpr Op OpForward = static_cast<Op>(IOpForward);
constexpr Op OpTypeTokenINTEL = static_cast<Op>(IOpTypeTokenINTEL);

constexpr Decoration DecorationRuntimeAlignedINTEL =
    static_cast<Decoration>(IDecRuntimeAlignedINTEL);
constexpr Decoration DecorationHostAccessINTEL =
    static_cast<Decoration>(IDecHostAccessINTEL);
constexpr Decoration DecorationInitModeINTEL =
    static_cast<Decoration>(IDecInitModeINTEL);
constexpr Decoration DecorationImplementInCSRINTEL =
    static_cast<Decoration>(IDecImplementInCSRINTEL);
constexpr Decoration DecorationArgumentAttributeINTEL =
    static_cast<Decoration>(IDecArgumentAttributeINTEL);

constexpr Capability CapabilityTokenTypeINTEL =
    static_cast<Capability>(ICapTokenTypeINTEL);
constexpr Capability CapabilityGlobalVariableDecorationsINTEL =
    static_cast<Capability>(ICapGlobalVariableDecorationsINTEL);
constexpr Capability CapabilityBFloat16ArithmeticINTEL =
    static_cast<Capability>(ICapabilityBFloat16ArithmeticINTEL);

constexpr ExecutionMode ExecutionModeNamedSubgroupSizeINTEL =
    static_cast<ExecutionMode>(IExecModeNamedSubgroupSizeINTEL);

} // namespace internal
} // namespace spv

#endif // #ifndef spirv_internal_HPP
