/* The Utah Teapot.  Martin Newell, 1975.

   Since GLUtesselator doesn't exist in the iOS build, we use these
   triangles there instead of generating the teapot from Newell's
   original Bezier patches, because I didn't feel like re-implementing
   that code.
 */

static const GLfloat teapot_triangles[] = {
	1.368074,2.435437,-0.227403,	1.381968,2.4,-0.229712,	1.4,2.4,0,
	1.4,2.4,0,	1.385925,2.435437,0,	1.368074,2.435437,-0.227403,
	1.316296,2.435437,-0.442166,	1.329664,2.4,-0.446656,	1.381968,2.4,-0.229712,
	1.381968,2.4,-0.229712,	1.368074,2.435437,-0.227403,	1.316296,2.435437,-0.442166,
	1.233252,2.435437,-0.641628,	1.245776,2.4,-0.648144,	1.329664,2.4,-0.446656,
	1.329664,2.4,-0.446656,	1.316296,2.435437,-0.442166,	1.233252,2.435437,-0.641628,
	1.121601,2.435437,-0.823129,	1.132992,2.4,-0.831488,	1.245776,2.4,-0.648144,
	1.245776,2.4,-0.648144,	1.233252,2.435437,-0.641628,	1.121601,2.435437,-0.823129,
	0.984007,2.435437,-0.984007,	0.994,2.4,-0.994,	1.132992,2.4,-0.831488,
	1.132992,2.4,-0.831488,	1.121601,2.435437,-0.823129,	0.984007,2.435437,-0.984007,
	0.823129,2.435437,-1.121601,	0.831488,2.4,-1.132992,	0.994,2.4,-0.994,
	0.994,2.4,-0.994,	0.984007,2.435437,-0.984007,	0.823129,2.435437,-1.121601,
	0.641628,2.435437,-1.233252,	0.648144,2.4,-1.245776,	0.831488,2.4,-1.132992,
	0.831488,2.4,-1.132992,	0.823129,2.435437,-1.121601,	0.641628,2.435437,-1.233252,
	0.442166,2.435437,-1.316296,	0.446656,2.4,-1.329664,	0.648144,2.4,-1.245776,
	0.648144,2.4,-1.245776,	0.641628,2.435437,-1.233252,	0.442166,2.435437,-1.316296,
	0.227403,2.435437,-1.368074,	0.229712,2.4,-1.381968,	0.446656,2.4,-1.329664,
	0.446656,2.4,-1.329664,	0.442166,2.435437,-1.316296,	0.227403,2.435437,-1.368074,
	0,2.435437,-1.385925,	0,2.4,-1.4,	0.229712,2.4,-1.381968,
	0.229712,2.4,-1.381968,	0.227403,2.435437,-1.368074,	0,2.435437,-1.385925,
	1.36262,2.463,-0.226496,	1.368074,2.435437,-0.227403,	1.385925,2.435437,0,
	1.385925,2.435437,0,	1.3804,2.463,0,	1.36262,2.463,-0.226496,
	1.311049,2.463,-0.440403,	1.316296,2.435437,-0.442166,	1.368074,2.435437,-0.227403,
	1.368074,2.435437,-0.227403,	1.36262,2.463,-0.226496,	1.311049,2.463,-0.440403,
	1.228335,2.463,-0.63907,	1.233252,2.435437,-0.641628,	1.316296,2.435437,-0.442166,
	1.316296,2.435437,-0.442166,	1.311049,2.463,-0.440403,	1.228335,2.463,-0.63907,
	1.11713,2.463,-0.819847,	1.121601,2.435437,-0.823129,	1.233252,2.435437,-0.641628,
	1.233252,2.435437,-0.641628,	1.228335,2.463,-0.63907,	1.11713,2.463,-0.819847,
	0.980084,2.463,-0.980084,	0.984007,2.435437,-0.984007,	1.121601,2.435437,-0.823129,
	1.121601,2.435437,-0.823129,	1.11713,2.463,-0.819847,	0.980084,2.463,-0.980084,
	0.819847,2.463,-1.11713,	0.823129,2.435437,-1.121601,	0.984007,2.435437,-0.984007,
	0.984007,2.435437,-0.984007,	0.980084,2.463,-0.980084,	0.819847,2.463,-1.11713,
	0.63907,2.463,-1.228335,	0.641628,2.435437,-1.233252,	0.823129,2.435437,-1.121601,
	0.823129,2.435437,-1.121601,	0.819847,2.463,-1.11713,	0.63907,2.463,-1.228335,
	0.440403,2.463,-1.311049,	0.442166,2.435437,-1.316296,	0.641628,2.435437,-1.233252,
	0.641628,2.435437,-1.233252,	0.63907,2.463,-1.228335,	0.440403,2.463,-1.311049,
	0.226496,2.463,-1.36262,	0.227403,2.435437,-1.368074,	0.442166,2.435437,-1.316296,
	0.442166,2.435437,-1.316296,	0.440403,2.463,-1.311049,	0.226496,2.463,-1.36262,
	0,2.463,-1.3804,	0,2.435437,-1.385925,	0.227403,2.435437,-1.368074,
	0.227403,2.435437,-1.368074,	0.226496,2.463,-1.36262,	0,2.463,-1.3804,
	1.364422,2.482687,-0.226795,	1.36262,2.463,-0.226496,	1.3804,2.463,0,
	1.3804,2.463,0,	1.382225,2.482687,0,	1.364422,2.482687,-0.226795,
	1.312782,2.482687,-0.440985,	1.311049,2.463,-0.440403,	1.36262,2.463,-0.226496,
	1.36262,2.463,-0.226496,	1.364422,2.482687,-0.226795,	1.312782,2.482687,-0.440985,
	1.229959,2.482687,-0.639915,	1.228335,2.463,-0.63907,	1.311049,2.463,-0.440403,
	1.311049,2.463,-0.440403,	1.312782,2.482687,-0.440985,	1.229959,2.482687,-0.639915,
	1.118607,2.482687,-0.820931,	1.11713,2.463,-0.819847,	1.228335,2.463,-0.63907,
	1.228335,2.463,-0.63907,	1.229959,2.482687,-0.639915,	1.118607,2.482687,-0.820931,
	0.98138,2.482687,-0.98138,	0.980084,2.463,-0.980084,	1.11713,2.463,-0.819847,
	1.11713,2.463,-0.819847,	1.118607,2.482687,-0.820931,	0.98138,2.482687,-0.98138,
	0.820931,2.482687,-1.118607,	0.819847,2.463,-1.11713,	0.980084,2.463,-0.980084,
	0.980084,2.463,-0.980084,	0.98138,2.482687,-0.98138,	0.820931,2.482687,-1.118607,
	0.639915,2.482687,-1.229959,	0.63907,2.463,-1.228335,	0.819847,2.463,-1.11713,
	0.819847,2.463,-1.11713,	0.820931,2.482687,-1.118607,	0.639915,2.482687,-1.229959,
	0.440985,2.482687,-1.312782,	0.440403,2.463,-1.311049,	0.63907,2.463,-1.228335,
	0.63907,2.463,-1.228335,	0.639915,2.482687,-1.229959,	0.440985,2.482687,-1.312782,
	0.226795,2.482687,-1.364422,	0.226496,2.463,-1.36262,	0.440403,2.463,-1.311049,
	0.440403,2.463,-1.311049,	0.440985,2.482687,-1.312782,	0.226795,2.482687,-1.364422,
	0,2.482687,-1.382225,	0,2.463,-1.3804,	0.226496,2.463,-1.36262,
	0.226496,2.463,-1.36262,	0.226795,2.482687,-1.364422,	0,2.482687,-1.382225,
	1.372294,2.4945,-0.228104,	1.364422,2.482687,-0.226795,	1.382225,2.482687,0,
	1.382225,2.482687,0,	1.3902,2.4945,0,	1.372294,2.4945,-0.228104,
	1.320356,2.4945,-0.443529,	1.312782,2.482687,-0.440985,	1.364422,2.482687,-0.226795,
	1.364422,2.482687,-0.226795,	1.372294,2.4945,-0.228104,	1.320356,2.4945,-0.443529,
	1.237056,2.4945,-0.643607,	1.229959,2.482687,-0.639915,	1.312782,2.482687,-0.440985,
	1.312782,2.482687,-0.440985,	1.320356,2.4945,-0.443529,	1.237056,2.4945,-0.643607,
	1.125061,2.4945,-0.825668,	1.118607,2.482687,-0.820931,	1.229959,2.482687,-0.639915,
	1.229959,2.482687,-0.639915,	1.237056,2.4945,-0.643607,	1.125061,2.4945,-0.825668,
	0.987042,2.4945,-0.987042,	0.98138,2.482687,-0.98138,	1.118607,2.482687,-0.820931,
	1.118607,2.482687,-0.820931,	1.125061,2.4945,-0.825668,	0.987042,2.4945,-0.987042,
	0.825668,2.4945,-1.125061,	0.820931,2.482687,-1.118607,	0.98138,2.482687,-0.98138,
	0.98138,2.482687,-0.98138,	0.987042,2.4945,-0.987042,	0.825668,2.4945,-1.125061,
	0.643607,2.4945,-1.237056,	0.639915,2.482687,-1.229959,	0.820931,2.482687,-1.118607,
	0.820931,2.482687,-1.118607,	0.825668,2.4945,-1.125061,	0.643607,2.4945,-1.237056,
	0.443529,2.4945,-1.320356,	0.440985,2.482687,-1.312782,	0.639915,2.482687,-1.229959,
	0.639915,2.482687,-1.229959,	0.643607,2.4945,-1.237056,	0.443529,2.4945,-1.320356,
	0.228104,2.4945,-1.372294,	0.226795,2.482687,-1.364422,	0.440985,2.482687,-1.312782,
	0.440985,2.482687,-1.312782,	0.443529,2.4945,-1.320356,	0.228104,2.4945,-1.372294,
	0,2.4945,-1.3902,	0,2.482687,-1.382225,	0.226795,2.482687,-1.364422,
	0.226795,2.482687,-1.364422,	0.228104,2.4945,-1.372294,	0,2.4945,-1.3902,
	1.385053,2.498438,-0.230225,	1.372294,2.4945,-0.228104,	1.3902,2.4945,0,
	1.3902,2.4945,0,	1.403125,2.498438,0,	1.385053,2.498438,-0.230225,
	1.332632,2.498438,-0.447653,	1.320356,2.4945,-0.443529,	1.372294,2.4945,-0.228104,
	1.372294,2.4945,-0.228104,	1.385053,2.498438,-0.230225,	1.332632,2.498438,-0.447653,
	1.248557,2.498438,-0.649591,	1.237056,2.4945,-0.643607,	1.320356,2.4945,-0.443529,
	1.320356,2.4945,-0.443529,	1.332632,2.498438,-0.447653,	1.248557,2.498438,-0.649591,
	1.135521,2.498438,-0.833344,	1.125061,2.4945,-0.825668,	1.237056,2.4945,-0.643607,
	1.237056,2.4945,-0.643607,	1.248557,2.498438,-0.649591,	1.135521,2.498438,-0.833344,
	0.996219,2.498438,-0.996219,	0.987042,2.4945,-0.987042,	1.125061,2.4945,-0.825668,
	1.125061,2.4945,-0.825668,	1.135521,2.498438,-0.833344,	0.996219,2.498438,-0.996219,
	0.833344,2.498438,-1.135521,	0.825668,2.4945,-1.125061,	0.987042,2.4945,-0.987042,
	0.987042,2.4945,-0.987042,	0.996219,2.498438,-0.996219,	0.833344,2.498438,-1.135521,
	0.649591,2.498438,-1.248557,	0.643607,2.4945,-1.237056,	0.825668,2.4945,-1.125061,
	0.825668,2.4945,-1.125061,	0.833344,2.498438,-1.135521,	0.649591,2.498438,-1.248557,
	0.447653,2.498438,-1.332632,	0.443529,2.4945,-1.320356,	0.643607,2.4945,-1.237056,
	0.643607,2.4945,-1.237056,	0.649591,2.498438,-1.248557,	0.447653,2.498438,-1.332632,
	0.230225,2.498438,-1.385053,	0.228104,2.4945,-1.372294,	0.443529,2.4945,-1.320356,
	0.443529,2.4945,-1.320356,	0.447653,2.498438,-1.332632,	0.230225,2.498438,-1.385053,
	0,2.498438,-1.403125,	0,2.4945,-1.3902,	0.228104,2.4945,-1.372294,
	0.228104,2.4945,-1.372294,	0.230225,2.498438,-1.385053,	0,2.498438,-1.403125,
	1.401513,2.4945,-0.232961,	1.385053,2.498438,-0.230225,	1.403125,2.498438,0,
	1.403125,2.498438,0,	1.4198,2.4945,0,	1.401513,2.4945,-0.232961,
	1.348469,2.4945,-0.452973,	1.332632,2.498438,-0.447653,	1.385053,2.498438,-0.230225,
	1.385053,2.498438,-0.230225,	1.401513,2.4945,-0.232961,	1.348469,2.4945,-0.452973,
	1.263395,2.4945,-0.657311,	1.248557,2.498438,-0.649591,	1.332632,2.498438,-0.447653,
	1.332632,2.498438,-0.447653,	1.348469,2.4945,-0.452973,	1.263395,2.4945,-0.657311,
	1.149016,2.4945,-0.843248,	1.135521,2.498438,-0.833344,	1.248557,2.498438,-0.649591,
	1.248557,2.498438,-0.649591,	1.263395,2.4945,-0.657311,	1.149016,2.4945,-0.843248,
	1.008058,2.4945,-1.008058,	0.996219,2.498438,-0.996219,	1.135521,2.498438,-0.833344,
	1.135521,2.498438,-0.833344,	1.149016,2.4945,-0.843248,	1.008058,2.4945,-1.008058,
	0.843248,2.4945,-1.149016,	0.833344,2.498438,-1.135521,	0.996219,2.498438,-0.996219,
	0.996219,2.498438,-0.996219,	1.008058,2.4945,-1.008058,	0.843248,2.4945,-1.149016,
	0.657311,2.4945,-1.263395,	0.649591,2.498438,-1.248557,	0.833344,2.498438,-1.135521,
	0.833344,2.498438,-1.135521,	0.843248,2.4945,-1.149016,	0.657311,2.4945,-1.263395,
	0.452973,2.4945,-1.348469,	0.447653,2.498438,-1.332632,	0.649591,2.498438,-1.248557,
	0.649591,2.498438,-1.248557,	0.657311,2.4945,-1.263395,	0.452973,2.4945,-1.348469,
	0.232961,2.4945,-1.401513,	0.230225,2.498438,-1.385053,	0.447653,2.498438,-1.332632,
	0.447653,2.498438,-1.332632,	0.452973,2.4945,-1.348469,	0.232961,2.4945,-1.401513,
	0,2.4945,-1.4198,	0,2.498438,-1.403125,	0.230225,2.498438,-1.385053,
	0.230225,2.498438,-1.385053,	0.232961,2.4945,-1.401513,	0,2.4945,-1.4198,
	1.42049,2.482687,-0.236115,	1.401513,2.4945,-0.232961,	1.4198,2.4945,0,
	1.4198,2.4945,0,	1.439025,2.482687,0,	1.42049,2.482687,-0.236115,
	1.366728,2.482687,-0.459107,	1.348469,2.4945,-0.452973,	1.401513,2.4945,-0.232961,
	1.401513,2.4945,-0.232961,	1.42049,2.482687,-0.236115,	1.366728,2.482687,-0.459107,
	1.280502,2.482687,-0.666211,	1.263395,2.4945,-0.657311,	1.348469,2.4945,-0.452973,
	1.348469,2.4945,-0.452973,	1.366728,2.482687,-0.459107,	1.280502,2.482687,-0.666211,
	1.164574,2.482687,-0.854666,	1.149016,2.4945,-0.843248,	1.263395,2.4945,-0.657311,
	1.263395,2.4945,-0.657311,	1.280502,2.482687,-0.666211,	1.164574,2.482687,-0.854666,
	1.021708,2.482687,-1.021708,	1.008058,2.4945,-1.008058,	1.149016,2.4945,-0.843248,
	1.149016,2.4945,-0.843248,	1.164574,2.482687,-0.854666,	1.021708,2.482687,-1.021708,
	0.854666,2.482687,-1.164574,	0.843248,2.4945,-1.149016,	1.008058,2.4945,-1.008058,
	1.008058,2.4945,-1.008058,	1.021708,2.482687,-1.021708,	0.854666,2.482687,-1.164574,
	0.666211,2.482687,-1.280502,	0.657311,2.4945,-1.263395,	0.843248,2.4945,-1.149016,
	0.843248,2.4945,-1.149016,	0.854666,2.482687,-1.164574,	0.666211,2.482687,-1.280502,
	0.459107,2.482687,-1.366728,	0.452973,2.4945,-1.348469,	0.657311,2.4945,-1.263395,
	0.657311,2.4945,-1.263395,	0.666211,2.482687,-1.280502,	0.459107,2.482687,-1.366728,
	0.236115,2.482687,-1.42049,	0.232961,2.4945,-1.401513,	0.452973,2.4945,-1.348469,
	0.452973,2.4945,-1.348469,	0.459107,2.482687,-1.366728,	0.236115,2.482687,-1.42049,
	0,2.482687,-1.439025,	0,2.4945,-1.4198,	0.232961,2.4945,-1.401513,
	0.232961,2.4945,-1.401513,	0.236115,2.482687,-1.42049,	0,2.482687,-1.439025,
	1.4408,2.463,-0.239491,	1.42049,2.482687,-0.236115,	1.439025,2.482687,0,
	1.439025,2.482687,0,	1.4596,2.463,0,	1.4408,2.463,-0.239491,
	1.38627,2.463,-0.465671,	1.366728,2.482687,-0.459107,	1.42049,2.482687,-0.236115,
	1.42049,2.482687,-0.236115,	1.4408,2.463,-0.239491,	1.38627,2.463,-0.465671,
	1.29881,2.463,-0.675736,	1.280502,2.482687,-0.666211,	1.366728,2.482687,-0.459107,
	1.366728,2.482687,-0.459107,	1.38627,2.463,-0.465671,	1.29881,2.463,-0.675736,
	1.181225,2.463,-0.866886,	1.164574,2.482687,-0.854666,	1.280502,2.482687,-0.666211,
	1.280502,2.482687,-0.666211,	1.29881,2.463,-0.675736,	1.181225,2.463,-0.866886,
	1.036316,2.463,-1.036316,	1.021708,2.482687,-1.021708,	1.164574,2.482687,-0.854666,
	1.164574,2.482687,-0.854666,	1.181225,2.463,-0.866886,	1.036316,2.463,-1.036316,
	0.866886,2.463,-1.181225,	0.854666,2.482687,-1.164574,	1.021708,2.482687,-1.021708,
	1.021708,2.482687,-1.021708,	1.036316,2.463,-1.036316,	0.866886,2.463,-1.181225,
	0.675736,2.463,-1.29881,	0.666211,2.482687,-1.280502,	0.854666,2.482687,-1.164574,
	0.854666,2.482687,-1.164574,	0.866886,2.463,-1.181225,	0.675736,2.463,-1.29881,
	0.465671,2.463,-1.38627,	0.459107,2.482687,-1.366728,	0.666211,2.482687,-1.280502,
	0.666211,2.482687,-1.280502,	0.675736,2.463,-1.29881,	0.465671,2.463,-1.38627,
	0.239491,2.463,-1.4408,	0.236115,2.482687,-1.42049,	0.459107,2.482687,-1.366728,
	0.459107,2.482687,-1.366728,	0.465671,2.463,-1.38627,	0.239491,2.463,-1.4408,
	0,2.463,-1.4596,	0,2.482687,-1.439025,	0.236115,2.482687,-1.42049,
	0.236115,2.482687,-1.42049,	0.239491,2.463,-1.4408,	0,2.463,-1.4596,
	1.461258,2.435437,-0.242892,	1.4408,2.463,-0.239491,	1.4596,2.463,0,
	1.4596,2.463,0,	1.480325,2.435437,0,	1.461258,2.435437,-0.242892,
	1.405953,2.435437,-0.472283,	1.38627,2.463,-0.465671,	1.4408,2.463,-0.239491,
	1.4408,2.463,-0.239491,	1.461258,2.435437,-0.242892,	1.405953,2.435437,-0.472283,
	1.317252,2.435437,-0.685331,	1.29881,2.463,-0.675736,	1.38627,2.463,-0.465671,
	1.38627,2.463,-0.465671,	1.405953,2.435437,-0.472283,	1.317252,2.435437,-0.685331,
	1.197997,2.435437,-0.879195,	1.181225,2.463,-0.866886,	1.29881,2.463,-0.675736,
	1.29881,2.463,-0.675736,	1.317252,2.435437,-0.685331,	1.197997,2.435437,-0.879195,
	1.051031,2.435437,-1.051031,	1.036316,2.463,-1.036316,	1.181225,2.463,-0.866886,
	1.181225,2.463,-0.866886,	1.197997,2.435437,-0.879195,	1.051031,2.435437,-1.051031,
	0.879195,2.435437,-1.197997,	0.866886,2.463,-1.181225,	1.036316,2.463,-1.036316,
	1.036316,2.463,-1.036316,	1.051031,2.435437,-1.051031,	0.879195,2.435437,-1.197997,
	0.685331,2.435437,-1.317252,	0.675736,2.463,-1.29881,	0.866886,2.463,-1.181225,
	0.866886,2.463,-1.181225,	0.879195,2.435437,-1.197997,	0.685331,2.435437,-1.317252,
	0.472283,2.435437,-1.405953,	0.465671,2.463,-1.38627,	0.675736,2.463,-1.29881,
	0.675736,2.463,-1.29881,	0.685331,2.435437,-1.317252,	0.472283,2.435437,-1.405953,
	0.242892,2.435437,-1.461258,	0.239491,2.463,-1.4408,	0.465671,2.463,-1.38627,
	0.465671,2.463,-1.38627,	0.472283,2.435437,-1.405953,	0.242892,2.435437,-1.461258,
	0,2.435437,-1.480325,	0,2.463,-1.4596,	0.239491,2.463,-1.4408,
	0.239491,2.463,-1.4408,	0.242892,2.435437,-1.461258,	0,2.435437,-1.480325,
	1.48068,2.4,-0.24612,	1.461258,2.435437,-0.242892,	1.480325,2.435437,0,
	1.480325,2.435437,0,	1.5,2.4,0,	1.48068,2.4,-0.24612,
	1.42464,2.4,-0.47856,	1.405953,2.435437,-0.472283,	1.461258,2.435437,-0.242892,
	1.461258,2.435437,-0.242892,	1.48068,2.4,-0.24612,	1.42464,2.4,-0.47856,
	1.33476,2.4,-0.69444,	1.317252,2.435437,-0.685331,	1.405953,2.435437,-0.472283,
	1.405953,2.435437,-0.472283,	1.42464,2.4,-0.47856,	1.33476,2.4,-0.69444,
	1.21392,2.4,-0.89088,	1.197997,2.435437,-0.879195,	1.317252,2.435437,-0.685331,
	1.317252,2.435437,-0.685331,	1.33476,2.4,-0.69444,	1.21392,2.4,-0.89088,
	1.065,2.4,-1.065,	1.051031,2.435437,-1.051031,	1.197997,2.435437,-0.879195,
	1.197997,2.435437,-0.879195,	1.21392,2.4,-0.89088,	1.065,2.4,-1.065,
	0.89088,2.4,-1.21392,	0.879195,2.435437,-1.197997,	1.051031,2.435437,-1.051031,
	1.051031,2.435437,-1.051031,	1.065,2.4,-1.065,	0.89088,2.4,-1.21392,
	0.69444,2.4,-1.33476,	0.685331,2.435437,-1.317252,	0.879195,2.435437,-1.197997,
	0.879195,2.435437,-1.197997,	0.89088,2.4,-1.21392,	0.69444,2.4,-1.33476,
	0.47856,2.4,-1.42464,	0.472283,2.435437,-1.405953,	0.685331,2.435437,-1.317252,
	0.685331,2.435437,-1.317252,	0.69444,2.4,-1.33476,	0.47856,2.4,-1.42464,
	0.24612,2.4,-1.48068,	0.242892,2.435437,-1.461258,	0.472283,2.435437,-1.405953,
	0.472283,2.435437,-1.405953,	0.47856,2.4,-1.42464,	0.24612,2.4,-1.48068,
	0,2.4,-1.5,	0,2.435437,-1.480325,	0.242892,2.435437,-1.461258,
	0.242892,2.435437,-1.461258,	0.24612,2.4,-1.48068,	0,2.4,-1.5,
	-0.227403,2.435437,-1.368074,	-0.229712,2.4,-1.381968,	0,2.4,-1.4,
	0,2.4,-1.4,	0,2.435437,-1.385925,	-0.227403,2.435437,-1.368074,
	-0.442166,2.435437,-1.316296,	-0.446656,2.4,-1.329664,	-0.229712,2.4,-1.381968,
	-0.229712,2.4,-1.381968,	-0.227403,2.435437,-1.368074,	-0.442166,2.435437,-1.316296,
	-0.641628,2.435437,-1.233252,	-0.648144,2.4,-1.245776,	-0.446656,2.4,-1.329664,
	-0.446656,2.4,-1.329664,	-0.442166,2.435437,-1.316296,	-0.641628,2.435437,-1.233252,
	-0.823129,2.435437,-1.121601,	-0.831488,2.4,-1.132992,	-0.648144,2.4,-1.245776,
	-0.648144,2.4,-1.245776,	-0.641628,2.435437,-1.233252,	-0.823129,2.435437,-1.121601,
	-0.984007,2.435437,-0.984007,	-0.994,2.4,-0.994,	-0.831488,2.4,-1.132992,
	-0.831488,2.4,-1.132992,	-0.823129,2.435437,-1.121601,	-0.984007,2.435437,-0.984007,
	-1.121601,2.435437,-0.823129,	-1.132992,2.4,-0.831488,	-0.994,2.4,-0.994,
	-0.994,2.4,-0.994,	-0.984007,2.435437,-0.984007,	-1.121601,2.435437,-0.823129,
	-1.233252,2.435437,-0.641628,	-1.245776,2.4,-0.648144,	-1.132992,2.4,-0.831488,
	-1.132992,2.4,-0.831488,	-1.121601,2.435437,-0.823129,	-1.233252,2.435437,-0.641628,
	-1.316296,2.435437,-0.442166,	-1.329664,2.4,-0.446656,	-1.245776,2.4,-0.648144,
	-1.245776,2.4,-0.648144,	-1.233252,2.435437,-0.641628,	-1.316296,2.435437,-0.442166,
	-1.368074,2.435437,-0.227403,	-1.381968,2.4,-0.229712,	-1.329664,2.4,-0.446656,
	-1.329664,2.4,-0.446656,	-1.316296,2.435437,-0.442166,	-1.368074,2.435437,-0.227403,
	-1.385925,2.435437,0,	-1.4,2.4,0,	-1.381968,2.4,-0.229712,
	-1.381968,2.4,-0.229712,	-1.368074,2.435437,-0.227403,	-1.385925,2.435437,0,
	-0.226496,2.463,-1.36262,	-0.227403,2.435437,-1.368074,	0,2.435437,-1.385925,
	0,2.435437,-1.385925,	0,2.463,-1.3804,	-0.226496,2.463,-1.36262,
	-0.440403,2.463,-1.311049,	-0.442166,2.435437,-1.316296,	-0.227403,2.435437,-1.368074,
	-0.227403,2.435437,-1.368074,	-0.226496,2.463,-1.36262,	-0.440403,2.463,-1.311049,
	-0.63907,2.463,-1.228335,	-0.641628,2.435437,-1.233252,	-0.442166,2.435437,-1.316296,
	-0.442166,2.435437,-1.316296,	-0.440403,2.463,-1.311049,	-0.63907,2.463,-1.228335,
	-0.819847,2.463,-1.11713,	-0.823129,2.435437,-1.121601,	-0.641628,2.435437,-1.233252,
	-0.641628,2.435437,-1.233252,	-0.63907,2.463,-1.228335,	-0.819847,2.463,-1.11713,
	-0.980084,2.463,-0.980084,	-0.984007,2.435437,-0.984007,	-0.823129,2.435437,-1.121601,
	-0.823129,2.435437,-1.121601,	-0.819847,2.463,-1.11713,	-0.980084,2.463,-0.980084,
	-1.11713,2.463,-0.819847,	-1.121601,2.435437,-0.823129,	-0.984007,2.435437,-0.984007,
	-0.984007,2.435437,-0.984007,	-0.980084,2.463,-0.980084,	-1.11713,2.463,-0.819847,
	-1.228335,2.463,-0.63907,	-1.233252,2.435437,-0.641628,	-1.121601,2.435437,-0.823129,
	-1.121601,2.435437,-0.823129,	-1.11713,2.463,-0.819847,	-1.228335,2.463,-0.63907,
	-1.311049,2.463,-0.440403,	-1.316296,2.435437,-0.442166,	-1.233252,2.435437,-0.641628,
	-1.233252,2.435437,-0.641628,	-1.228335,2.463,-0.63907,	-1.311049,2.463,-0.440403,
	-1.36262,2.463,-0.226496,	-1.368074,2.435437,-0.227403,	-1.316296,2.435437,-0.442166,
	-1.316296,2.435437,-0.442166,	-1.311049,2.463,-0.440403,	-1.36262,2.463,-0.226496,
	-1.3804,2.463,0,	-1.385925,2.435437,0,	-1.368074,2.435437,-0.227403,
	-1.368074,2.435437,-0.227403,	-1.36262,2.463,-0.226496,	-1.3804,2.463,0,
	-0.226795,2.482687,-1.364422,	-0.226496,2.463,-1.36262,	0,2.463,-1.3804,
	0,2.463,-1.3804,	0,2.482687,-1.382225,	-0.226795,2.482687,-1.364422,
	-0.440985,2.482687,-1.312782,	-0.440403,2.463,-1.311049,	-0.226496,2.463,-1.36262,
	-0.226496,2.463,-1.36262,	-0.226795,2.482687,-1.364422,	-0.440985,2.482687,-1.312782,
	-0.639915,2.482687,-1.229959,	-0.63907,2.463,-1.228335,	-0.440403,2.463,-1.311049,
	-0.440403,2.463,-1.311049,	-0.440985,2.482687,-1.312782,	-0.639915,2.482687,-1.229959,
	-0.820931,2.482687,-1.118607,	-0.819847,2.463,-1.11713,	-0.63907,2.463,-1.228335,
	-0.63907,2.463,-1.228335,	-0.639915,2.482687,-1.229959,	-0.820931,2.482687,-1.118607,
	-0.98138,2.482687,-0.98138,	-0.980084,2.463,-0.980084,	-0.819847,2.463,-1.11713,
	-0.819847,2.463,-1.11713,	-0.820931,2.482687,-1.118607,	-0.98138,2.482687,-0.98138,
	-1.118607,2.482687,-0.820931,	-1.11713,2.463,-0.819847,	-0.980084,2.463,-0.980084,
	-0.980084,2.463,-0.980084,	-0.98138,2.482687,-0.98138,	-1.118607,2.482687,-0.820931,
	-1.229959,2.482687,-0.639915,	-1.228335,2.463,-0.63907,	-1.11713,2.463,-0.819847,
	-1.11713,2.463,-0.819847,	-1.118607,2.482687,-0.820931,	-1.229959,2.482687,-0.639915,
	-1.312782,2.482687,-0.440985,	-1.311049,2.463,-0.440403,	-1.228335,2.463,-0.63907,
	-1.228335,2.463,-0.63907,	-1.229959,2.482687,-0.639915,	-1.312782,2.482687,-0.440985,
	-1.364422,2.482687,-0.226795,	-1.36262,2.463,-0.226496,	-1.311049,2.463,-0.440403,
	-1.311049,2.463,-0.440403,	-1.312782,2.482687,-0.440985,	-1.364422,2.482687,-0.226795,
	-1.382225,2.482687,0,	-1.3804,2.463,0,	-1.36262,2.463,-0.226496,
	-1.36262,2.463,-0.226496,	-1.364422,2.482687,-0.226795,	-1.382225,2.482687,0,
	-0.228104,2.4945,-1.372294,	-0.226795,2.482687,-1.364422,	0,2.482687,-1.382225,
	0,2.482687,-1.382225,	0,2.4945,-1.3902,	-0.228104,2.4945,-1.372294,
	-0.443529,2.4945,-1.320356,	-0.440985,2.482687,-1.312782,	-0.226795,2.482687,-1.364422,
	-0.226795,2.482687,-1.364422,	-0.228104,2.4945,-1.372294,	-0.443529,2.4945,-1.320356,
	-0.643607,2.4945,-1.237056,	-0.639915,2.482687,-1.229959,	-0.440985,2.482687,-1.312782,
	-0.440985,2.482687,-1.312782,	-0.443529,2.4945,-1.320356,	-0.643607,2.4945,-1.237056,
	-0.825668,2.4945,-1.125061,	-0.820931,2.482687,-1.118607,	-0.639915,2.482687,-1.229959,
	-0.639915,2.482687,-1.229959,	-0.643607,2.4945,-1.237056,	-0.825668,2.4945,-1.125061,
	-0.987042,2.4945,-0.987042,	-0.98138,2.482687,-0.98138,	-0.820931,2.482687,-1.118607,
	-0.820931,2.482687,-1.118607,	-0.825668,2.4945,-1.125061,	-0.987042,2.4945,-0.987042,
	-1.125061,2.4945,-0.825668,	-1.118607,2.482687,-0.820931,	-0.98138,2.482687,-0.98138,
	-0.98138,2.482687,-0.98138,	-0.987042,2.4945,-0.987042,	-1.125061,2.4945,-0.825668,
	-1.237056,2.4945,-0.643607,	-1.229959,2.482687,-0.639915,	-1.118607,2.482687,-0.820931,
	-1.118607,2.482687,-0.820931,	-1.125061,2.4945,-0.825668,	-1.237056,2.4945,-0.643607,
	-1.320356,2.4945,-0.443529,	-1.312782,2.482687,-0.440985,	-1.229959,2.482687,-0.639915,
	-1.229959,2.482687,-0.639915,	-1.237056,2.4945,-0.643607,	-1.320356,2.4945,-0.443529,
	-1.372294,2.4945,-0.228104,	-1.364422,2.482687,-0.226795,	-1.312782,2.482687,-0.440985,
	-1.312782,2.482687,-0.440985,	-1.320356,2.4945,-0.443529,	-1.372294,2.4945,-0.228104,
	-1.3902,2.4945,0,	-1.382225,2.482687,0,	-1.364422,2.482687,-0.226795,
	-1.364422,2.482687,-0.226795,	-1.372294,2.4945,-0.228104,	-1.3902,2.4945,0,
	-0.230225,2.498438,-1.385053,	-0.228104,2.4945,-1.372294,	0,2.4945,-1.3902,
	0,2.4945,-1.3902,	0,2.498438,-1.403125,	-0.230225,2.498438,-1.385053,
	-0.447653,2.498438,-1.332632,	-0.443529,2.4945,-1.320356,	-0.228104,2.4945,-1.372294,
	-0.228104,2.4945,-1.372294,	-0.230225,2.498438,-1.385053,	-0.447653,2.498438,-1.332632,
	-0.649591,2.498438,-1.248557,	-0.643607,2.4945,-1.237056,	-0.443529,2.4945,-1.320356,
	-0.443529,2.4945,-1.320356,	-0.447653,2.498438,-1.332632,	-0.649591,2.498438,-1.248557,
	-0.833344,2.498438,-1.135521,	-0.825668,2.4945,-1.125061,	-0.643607,2.4945,-1.237056,
	-0.643607,2.4945,-1.237056,	-0.649591,2.498438,-1.248557,	-0.833344,2.498438,-1.135521,
	-0.996219,2.498438,-0.996219,	-0.987042,2.4945,-0.987042,	-0.825668,2.4945,-1.125061,
	-0.825668,2.4945,-1.125061,	-0.833344,2.498438,-1.135521,	-0.996219,2.498438,-0.996219,
	-1.135521,2.498438,-0.833344,	-1.125061,2.4945,-0.825668,	-0.987042,2.4945,-0.987042,
	-0.987042,2.4945,-0.987042,	-0.996219,2.498438,-0.996219,	-1.135521,2.498438,-0.833344,
	-1.248557,2.498438,-0.649591,	-1.237056,2.4945,-0.643607,	-1.125061,2.4945,-0.825668,
	-1.125061,2.4945,-0.825668,	-1.135521,2.498438,-0.833344,	-1.248557,2.498438,-0.649591,
	-1.332632,2.498438,-0.447653,	-1.320356,2.4945,-0.443529,	-1.237056,2.4945,-0.643607,
	-1.237056,2.4945,-0.643607,	-1.248557,2.498438,-0.649591,	-1.332632,2.498438,-0.447653,
	-1.385053,2.498438,-0.230225,	-1.372294,2.4945,-0.228104,	-1.320356,2.4945,-0.443529,
	-1.320356,2.4945,-0.443529,	-1.332632,2.498438,-0.447653,	-1.385053,2.498438,-0.230225,
	-1.403125,2.498438,0,	-1.3902,2.4945,0,	-1.372294,2.4945,-0.228104,
	-1.372294,2.4945,-0.228104,	-1.385053,2.498438,-0.230225,	-1.403125,2.498438,0,
	-0.232961,2.4945,-1.401513,	-0.230225,2.498438,-1.385053,	0,2.498438,-1.403125,
	0,2.498438,-1.403125,	0,2.4945,-1.4198,	-0.232961,2.4945,-1.401513,
	-0.452973,2.4945,-1.348469,	-0.447653,2.498438,-1.332632,	-0.230225,2.498438,-1.385053,
	-0.230225,2.498438,-1.385053,	-0.232961,2.4945,-1.401513,	-0.452973,2.4945,-1.348469,
	-0.657311,2.4945,-1.263395,	-0.649591,2.498438,-1.248557,	-0.447653,2.498438,-1.332632,
	-0.447653,2.498438,-1.332632,	-0.452973,2.4945,-1.348469,	-0.657311,2.4945,-1.263395,
	-0.843248,2.4945,-1.149016,	-0.833344,2.498438,-1.135521,	-0.649591,2.498438,-1.248557,
	-0.649591,2.498438,-1.248557,	-0.657311,2.4945,-1.263395,	-0.843248,2.4945,-1.149016,
	-1.008058,2.4945,-1.008058,	-0.996219,2.498438,-0.996219,	-0.833344,2.498438,-1.135521,
	-0.833344,2.498438,-1.135521,	-0.843248,2.4945,-1.149016,	-1.008058,2.4945,-1.008058,
	-1.149016,2.4945,-0.843248,	-1.135521,2.498438,-0.833344,	-0.996219,2.498438,-0.996219,
	-0.996219,2.498438,-0.996219,	-1.008058,2.4945,-1.008058,	-1.149016,2.4945,-0.843248,
	-1.263395,2.4945,-0.657311,	-1.248557,2.498438,-0.649591,	-1.135521,2.498438,-0.833344,
	-1.135521,2.498438,-0.833344,	-1.149016,2.4945,-0.843248,	-1.263395,2.4945,-0.657311,
	-1.348469,2.4945,-0.452973,	-1.332632,2.498438,-0.447653,	-1.248557,2.498438,-0.649591,
	-1.248557,2.498438,-0.649591,	-1.263395,2.4945,-0.657311,	-1.348469,2.4945,-0.452973,
	-1.401513,2.4945,-0.232961,	-1.385053,2.498438,-0.230225,	-1.332632,2.498438,-0.447653,
	-1.332632,2.498438,-0.447653,	-1.348469,2.4945,-0.452973,	-1.401513,2.4945,-0.232961,
	-1.4198,2.4945,0,	-1.403125,2.498438,0,	-1.385053,2.498438,-0.230225,
	-1.385053,2.498438,-0.230225,	-1.401513,2.4945,-0.232961,	-1.4198,2.4945,0,
	-0.236115,2.482687,-1.42049,	-0.232961,2.4945,-1.401513,	0,2.4945,-1.4198,
	0,2.4945,-1.4198,	0,2.482687,-1.439025,	-0.236115,2.482687,-1.42049,
	-0.459107,2.482687,-1.366728,	-0.452973,2.4945,-1.348469,	-0.232961,2.4945,-1.401513,
	-0.232961,2.4945,-1.401513,	-0.236115,2.482687,-1.42049,	-0.459107,2.482687,-1.366728,
	-0.666211,2.482687,-1.280502,	-0.657311,2.4945,-1.263395,	-0.452973,2.4945,-1.348469,
	-0.452973,2.4945,-1.348469,	-0.459107,2.482687,-1.366728,	-0.666211,2.482687,-1.280502,
	-0.854666,2.482687,-1.164574,	-0.843248,2.4945,-1.149016,	-0.657311,2.4945,-1.263395,
	-0.657311,2.4945,-1.263395,	-0.666211,2.482687,-1.280502,	-0.854666,2.482687,-1.164574,
	-1.021708,2.482687,-1.021708,	-1.008058,2.4945,-1.008058,	-0.843248,2.4945,-1.149016,
	-0.843248,2.4945,-1.149016,	-0.854666,2.482687,-1.164574,	-1.021708,2.482687,-1.021708,
	-1.164574,2.482687,-0.854666,	-1.149016,2.4945,-0.843248,	-1.008058,2.4945,-1.008058,
	-1.008058,2.4945,-1.008058,	-1.021708,2.482687,-1.021708,	-1.164574,2.482687,-0.854666,
	-1.280502,2.482687,-0.666211,	-1.263395,2.4945,-0.657311,	-1.149016,2.4945,-0.843248,
	-1.149016,2.4945,-0.843248,	-1.164574,2.482687,-0.854666,	-1.280502,2.482687,-0.666211,
	-1.366728,2.482687,-0.459107,	-1.348469,2.4945,-0.452973,	-1.263395,2.4945,-0.657311,
	-1.263395,2.4945,-0.657311,	-1.280502,2.482687,-0.666211,	-1.366728,2.482687,-0.459107,
	-1.42049,2.482687,-0.236115,	-1.401513,2.4945,-0.232961,	-1.348469,2.4945,-0.452973,
	-1.348469,2.4945,-0.452973,	-1.366728,2.482687,-0.459107,	-1.42049,2.482687,-0.236115,
	-1.439025,2.482687,0,	-1.4198,2.4945,0,	-1.401513,2.4945,-0.232961,
	-1.401513,2.4945,-0.232961,	-1.42049,2.482687,-0.236115,	-1.439025,2.482687,0,
	-0.239491,2.463,-1.4408,	-0.236115,2.482687,-1.42049,	0,2.482687,-1.439025,
	0,2.482687,-1.439025,	0,2.463,-1.4596,	-0.239491,2.463,-1.4408,
	-0.465671,2.463,-1.38627,	-0.459107,2.482687,-1.366728,	-0.236115,2.482687,-1.42049,
	-0.236115,2.482687,-1.42049,	-0.239491,2.463,-1.4408,	-0.465671,2.463,-1.38627,
	-0.675736,2.463,-1.29881,	-0.666211,2.482687,-1.280502,	-0.459107,2.482687,-1.366728,
	-0.459107,2.482687,-1.366728,	-0.465671,2.463,-1.38627,	-0.675736,2.463,-1.29881,
	-0.866886,2.463,-1.181225,	-0.854666,2.482687,-1.164574,	-0.666211,2.482687,-1.280502,
	-0.666211,2.482687,-1.280502,	-0.675736,2.463,-1.29881,	-0.866886,2.463,-1.181225,
	-1.036316,2.463,-1.036316,	-1.021708,2.482687,-1.021708,	-0.854666,2.482687,-1.164574,
	-0.854666,2.482687,-1.164574,	-0.866886,2.463,-1.181225,	-1.036316,2.463,-1.036316,
	-1.181225,2.463,-0.866886,	-1.164574,2.482687,-0.854666,	-1.021708,2.482687,-1.021708,
	-1.021708,2.482687,-1.021708,	-1.036316,2.463,-1.036316,	-1.181225,2.463,-0.866886,
	-1.29881,2.463,-0.675736,	-1.280502,2.482687,-0.666211,	-1.164574,2.482687,-0.854666,
	-1.164574,2.482687,-0.854666,	-1.181225,2.463,-0.866886,	-1.29881,2.463,-0.675736,
	-1.38627,2.463,-0.465671,	-1.366728,2.482687,-0.459107,	-1.280502,2.482687,-0.666211,
	-1.280502,2.482687,-0.666211,	-1.29881,2.463,-0.675736,	-1.38627,2.463,-0.465671,
	-1.4408,2.463,-0.239491,	-1.42049,2.482687,-0.236115,	-1.366728,2.482687,-0.459107,
	-1.366728,2.482687,-0.459107,	-1.38627,2.463,-0.465671,	-1.4408,2.463,-0.239491,
	-1.4596,2.463,0,	-1.439025,2.482687,0,	-1.42049,2.482687,-0.236115,
	-1.42049,2.482687,-0.236115,	-1.4408,2.463,-0.239491,	-1.4596,2.463,0,
	-0.242892,2.435437,-1.461258,	-0.239491,2.463,-1.4408,	0,2.463,-1.4596,
	0,2.463,-1.4596,	0,2.435437,-1.480325,	-0.242892,2.435437,-1.461258,
	-0.472283,2.435437,-1.405953,	-0.465671,2.463,-1.38627,	-0.239491,2.463,-1.4408,
	-0.239491,2.463,-1.4408,	-0.242892,2.435437,-1.461258,	-0.472283,2.435437,-1.405953,
	-0.685331,2.435437,-1.317252,	-0.675736,2.463,-1.29881,	-0.465671,2.463,-1.38627,
	-0.465671,2.463,-1.38627,	-0.472283,2.435437,-1.405953,	-0.685331,2.435437,-1.317252,
	-0.879195,2.435437,-1.197997,	-0.866886,2.463,-1.181225,	-0.675736,2.463,-1.29881,
	-0.675736,2.463,-1.29881,	-0.685331,2.435437,-1.317252,	-0.879195,2.435437,-1.197997,
	-1.051031,2.435437,-1.051031,	-1.036316,2.463,-1.036316,	-0.866886,2.463,-1.181225,
	-0.866886,2.463,-1.181225,	-0.879195,2.435437,-1.197997,	-1.051031,2.435437,-1.051031,
	-1.197997,2.435437,-0.879195,	-1.181225,2.463,-0.866886,	-1.036316,2.463,-1.036316,
	-1.036316,2.463,-1.036316,	-1.051031,2.435437,-1.051031,	-1.197997,2.435437,-0.879195,
	-1.317252,2.435437,-0.685331,	-1.29881,2.463,-0.675736,	-1.181225,2.463,-0.866886,
	-1.181225,2.463,-0.866886,	-1.197997,2.435437,-0.879195,	-1.317252,2.435437,-0.685331,
	-1.405953,2.435437,-0.472283,	-1.38627,2.463,-0.465671,	-1.29881,2.463,-0.675736,
	-1.29881,2.463,-0.675736,	-1.317252,2.435437,-0.685331,	-1.405953,2.435437,-0.472283,
	-1.461258,2.435437,-0.242892,	-1.4408,2.463,-0.239491,	-1.38627,2.463,-0.465671,
	-1.38627,2.463,-0.465671,	-1.405953,2.435437,-0.472283,	-1.461258,2.435437,-0.242892,
	-1.480325,2.435437,0,	-1.4596,2.463,0,	-1.4408,2.463,-0.239491,
	-1.4408,2.463,-0.239491,	-1.461258,2.435437,-0.242892,	-1.480325,2.435437,0,
	-0.24612,2.4,-1.48068,	-0.242892,2.435437,-1.461258,	0,2.435437,-1.480325,
	0,2.435437,-1.480325,	0,2.4,-1.5,	-0.24612,2.4,-1.48068,
	-0.47856,2.4,-1.42464,	-0.472283,2.435437,-1.405953,	-0.242892,2.435437,-1.461258,
	-0.242892,2.435437,-1.461258,	-0.24612,2.4,-1.48068,	-0.47856,2.4,-1.42464,
	-0.69444,2.4,-1.33476,	-0.685331,2.435437,-1.317252,	-0.472283,2.435437,-1.405953,
	-0.472283,2.435437,-1.405953,	-0.47856,2.4,-1.42464,	-0.69444,2.4,-1.33476,
	-0.89088,2.4,-1.21392,	-0.879195,2.435437,-1.197997,	-0.685331,2.435437,-1.317252,
	-0.685331,2.435437,-1.317252,	-0.69444,2.4,-1.33476,	-0.89088,2.4,-1.21392,
	-1.065,2.4,-1.065,	-1.051031,2.435437,-1.051031,	-0.879195,2.435437,-1.197997,
	-0.879195,2.435437,-1.197997,	-0.89088,2.4,-1.21392,	-1.065,2.4,-1.065,
	-1.21392,2.4,-0.89088,	-1.197997,2.435437,-0.879195,	-1.051031,2.435437,-1.051031,
	-1.051031,2.435437,-1.051031,	-1.065,2.4,-1.065,	-1.21392,2.4,-0.89088,
	-1.33476,2.4,-0.69444,	-1.317252,2.435437,-0.685331,	-1.197997,2.435437,-0.879195,
	-1.197997,2.435437,-0.879195,	-1.21392,2.4,-0.89088,	-1.33476,2.4,-0.69444,
	-1.42464,2.4,-0.47856,	-1.405953,2.435437,-0.472283,	-1.317252,2.435437,-0.685331,
	-1.317252,2.435437,-0.685331,	-1.33476,2.4,-0.69444,	-1.42464,2.4,-0.47856,
	-1.48068,2.4,-0.24612,	-1.461258,2.435437,-0.242892,	-1.405953,2.435437,-0.472283,
	-1.405953,2.435437,-0.472283,	-1.42464,2.4,-0.47856,	-1.48068,2.4,-0.24612,
	-1.5,2.4,0,	-1.480325,2.435437,0,	-1.461258,2.435437,-0.242892,
	-1.461258,2.435437,-0.242892,	-1.48068,2.4,-0.24612,	-1.5,2.4,0,
	-1.368074,2.435437,0.227403,	-1.381968,2.4,0.229712,	-1.4,2.4,0,
	-1.4,2.4,0,	-1.385925,2.435437,0,	-1.368074,2.435437,0.227403,
	-1.316296,2.435437,0.442166,	-1.329664,2.4,0.446656,	-1.381968,2.4,0.229712,
	-1.381968,2.4,0.229712,	-1.368074,2.435437,0.227403,	-1.316296,2.435437,0.442166,
	-1.233252,2.435437,0.641628,	-1.245776,2.4,0.648144,	-1.329664,2.4,0.446656,
	-1.329664,2.4,0.446656,	-1.316296,2.435437,0.442166,	-1.233252,2.435437,0.641628,
	-1.121601,2.435437,0.823129,	-1.132992,2.4,0.831488,	-1.245776,2.4,0.648144,
	-1.245776,2.4,0.648144,	-1.233252,2.435437,0.641628,	-1.121601,2.435437,0.823129,
	-0.984007,2.435437,0.984007,	-0.994,2.4,0.994,	-1.132992,2.4,0.831488,
	-1.132992,2.4,0.831488,	-1.121601,2.435437,0.823129,	-0.984007,2.435437,0.984007,
	-0.823129,2.435437,1.121601,	-0.831488,2.4,1.132992,	-0.994,2.4,0.994,
	-0.994,2.4,0.994,	-0.984007,2.435437,0.984007,	-0.823129,2.435437,1.121601,
	-0.641628,2.435437,1.233252,	-0.648144,2.4,1.245776,	-0.831488,2.4,1.132992,
	-0.831488,2.4,1.132992,	-0.823129,2.435437,1.121601,	-0.641628,2.435437,1.233252,
	-0.442166,2.435437,1.316296,	-0.446656,2.4,1.329664,	-0.648144,2.4,1.245776,
	-0.648144,2.4,1.245776,	-0.641628,2.435437,1.233252,	-0.442166,2.435437,1.316296,
	-0.227403,2.435437,1.368074,	-0.229712,2.4,1.381968,	-0.446656,2.4,1.329664,
	-0.446656,2.4,1.329664,	-0.442166,2.435437,1.316296,	-0.227403,2.435437,1.368074,
	0,2.435437,1.385925,	0,2.4,1.4,	-0.229712,2.4,1.381968,
	-0.229712,2.4,1.381968,	-0.227403,2.435437,1.368074,	0,2.435437,1.385925,
	-1.36262,2.463,0.226496,	-1.368074,2.435437,0.227403,	-1.385925,2.435437,0,
	-1.385925,2.435437,0,	-1.3804,2.463,0,	-1.36262,2.463,0.226496,
	-1.311049,2.463,0.440403,	-1.316296,2.435437,0.442166,	-1.368074,2.435437,0.227403,
	-1.368074,2.435437,0.227403,	-1.36262,2.463,0.226496,	-1.311049,2.463,0.440403,
	-1.228335,2.463,0.63907,	-1.233252,2.435437,0.641628,	-1.316296,2.435437,0.442166,
	-1.316296,2.435437,0.442166,	-1.311049,2.463,0.440403,	-1.228335,2.463,0.63907,
	-1.11713,2.463,0.819847,	-1.121601,2.435437,0.823129,	-1.233252,2.435437,0.641628,
	-1.233252,2.435437,0.641628,	-1.228335,2.463,0.63907,	-1.11713,2.463,0.819847,
	-0.980084,2.463,0.980084,	-0.984007,2.435437,0.984007,	-1.121601,2.435437,0.823129,
	-1.121601,2.435437,0.823129,	-1.11713,2.463,0.819847,	-0.980084,2.463,0.980084,
	-0.819847,2.463,1.11713,	-0.823129,2.435437,1.121601,	-0.984007,2.435437,0.984007,
	-0.984007,2.435437,0.984007,	-0.980084,2.463,0.980084,	-0.819847,2.463,1.11713,
	-0.63907,2.463,1.228335,	-0.641628,2.435437,1.233252,	-0.823129,2.435437,1.121601,
	-0.823129,2.435437,1.121601,	-0.819847,2.463,1.11713,	-0.63907,2.463,1.228335,
	-0.440403,2.463,1.311049,	-0.442166,2.435437,1.316296,	-0.641628,2.435437,1.233252,
	-0.641628,2.435437,1.233252,	-0.63907,2.463,1.228335,	-0.440403,2.463,1.311049,
	-0.226496,2.463,1.36262,	-0.227403,2.435437,1.368074,	-0.442166,2.435437,1.316296,
	-0.442166,2.435437,1.316296,	-0.440403,2.463,1.311049,	-0.226496,2.463,1.36262,
	0,2.463,1.3804,	0,2.435437,1.385925,	-0.227403,2.435437,1.368074,
	-0.227403,2.435437,1.368074,	-0.226496,2.463,1.36262,	0,2.463,1.3804,
	-1.364422,2.482687,0.226795,	-1.36262,2.463,0.226496,	-1.3804,2.463,0,
	-1.3804,2.463,0,	-1.382225,2.482687,0,	-1.364422,2.482687,0.226795,
	-1.312782,2.482687,0.440985,	-1.311049,2.463,0.440403,	-1.36262,2.463,0.226496,
	-1.36262,2.463,0.226496,	-1.364422,2.482687,0.226795,	-1.312782,2.482687,0.440985,
	-1.229959,2.482687,0.639915,	-1.228335,2.463,0.63907,	-1.311049,2.463,0.440403,
	-1.311049,2.463,0.440403,	-1.312782,2.482687,0.440985,	-1.229959,2.482687,0.639915,
	-1.118607,2.482687,0.820931,	-1.11713,2.463,0.819847,	-1.228335,2.463,0.63907,
	-1.228335,2.463,0.63907,	-1.229959,2.482687,0.639915,	-1.118607,2.482687,0.820931,
	-0.98138,2.482687,0.98138,	-0.980084,2.463,0.980084,	-1.11713,2.463,0.819847,
	-1.11713,2.463,0.819847,	-1.118607,2.482687,0.820931,	-0.98138,2.482687,0.98138,
	-0.820931,2.482687,1.118607,	-0.819847,2.463,1.11713,	-0.980084,2.463,0.980084,
	-0.980084,2.463,0.980084,	-0.98138,2.482687,0.98138,	-0.820931,2.482687,1.118607,
	-0.639915,2.482687,1.229959,	-0.63907,2.463,1.228335,	-0.819847,2.463,1.11713,
	-0.819847,2.463,1.11713,	-0.820931,2.482687,1.118607,	-0.639915,2.482687,1.229959,
	-0.440985,2.482687,1.312782,	-0.440403,2.463,1.311049,	-0.63907,2.463,1.228335,
	-0.63907,2.463,1.228335,	-0.639915,2.482687,1.229959,	-0.440985,2.482687,1.312782,
	-0.226795,2.482687,1.364422,	-0.226496,2.463,1.36262,	-0.440403,2.463,1.311049,
	-0.440403,2.463,1.311049,	-0.440985,2.482687,1.312782,	-0.226795,2.482687,1.364422,
	0,2.482687,1.382225,	0,2.463,1.3804,	-0.226496,2.463,1.36262,
	-0.226496,2.463,1.36262,	-0.226795,2.482687,1.364422,	0,2.482687,1.382225,
	-1.372294,2.4945,0.228104,	-1.364422,2.482687,0.226795,	-1.382225,2.482687,0,
	-1.382225,2.482687,0,	-1.3902,2.4945,0,	-1.372294,2.4945,0.228104,
	-1.320356,2.4945,0.443529,	-1.312782,2.482687,0.440985,	-1.364422,2.482687,0.226795,
	-1.364422,2.482687,0.226795,	-1.372294,2.4945,0.228104,	-1.320356,2.4945,0.443529,
	-1.237056,2.4945,0.643607,	-1.229959,2.482687,0.639915,	-1.312782,2.482687,0.440985,
	-1.312782,2.482687,0.440985,	-1.320356,2.4945,0.443529,	-1.237056,2.4945,0.643607,
	-1.125061,2.4945,0.825668,	-1.118607,2.482687,0.820931,	-1.229959,2.482687,0.639915,
	-1.229959,2.482687,0.639915,	-1.237056,2.4945,0.643607,	-1.125061,2.4945,0.825668,
	-0.987042,2.4945,0.987042,	-0.98138,2.482687,0.98138,	-1.118607,2.482687,0.820931,
	-1.118607,2.482687,0.820931,	-1.125061,2.4945,0.825668,	-0.987042,2.4945,0.987042,
	-0.825668,2.4945,1.125061,	-0.820931,2.482687,1.118607,	-0.98138,2.482687,0.98138,
	-0.98138,2.482687,0.98138,	-0.987042,2.4945,0.987042,	-0.825668,2.4945,1.125061,
	-0.643607,2.4945,1.237056,	-0.639915,2.482687,1.229959,	-0.820931,2.482687,1.118607,
	-0.820931,2.482687,1.118607,	-0.825668,2.4945,1.125061,	-0.643607,2.4945,1.237056,
	-0.443529,2.4945,1.320356,	-0.440985,2.482687,1.312782,	-0.639915,2.482687,1.229959,
	-0.639915,2.482687,1.229959,	-0.643607,2.4945,1.237056,	-0.443529,2.4945,1.320356,
	-0.228104,2.4945,1.372294,	-0.226795,2.482687,1.364422,	-0.440985,2.482687,1.312782,
	-0.440985,2.482687,1.312782,	-0.443529,2.4945,1.320356,	-0.228104,2.4945,1.372294,
	0,2.4945,1.3902,	0,2.482687,1.382225,	-0.226795,2.482687,1.364422,
	-0.226795,2.482687,1.364422,	-0.228104,2.4945,1.372294,	0,2.4945,1.3902,
	-1.385053,2.498438,0.230225,	-1.372294,2.4945,0.228104,	-1.3902,2.4945,0,
	-1.3902,2.4945,0,	-1.403125,2.498438,0,	-1.385053,2.498438,0.230225,
	-1.332632,2.498438,0.447653,	-1.320356,2.4945,0.443529,	-1.372294,2.4945,0.228104,
	-1.372294,2.4945,0.228104,	-1.385053,2.498438,0.230225,	-1.332632,2.498438,0.447653,
	-1.248557,2.498438,0.649591,	-1.237056,2.4945,0.643607,	-1.320356,2.4945,0.443529,
	-1.320356,2.4945,0.443529,	-1.332632,2.498438,0.447653,	-1.248557,2.498438,0.649591,
	-1.135521,2.498438,0.833344,	-1.125061,2.4945,0.825668,	-1.237056,2.4945,0.643607,
	-1.237056,2.4945,0.643607,	-1.248557,2.498438,0.649591,	-1.135521,2.498438,0.833344,
	-0.996219,2.498438,0.996219,	-0.987042,2.4945,0.987042,	-1.125061,2.4945,0.825668,
	-1.125061,2.4945,0.825668,	-1.135521,2.498438,0.833344,	-0.996219,2.498438,0.996219,
	-0.833344,2.498438,1.135521,	-0.825668,2.4945,1.125061,	-0.987042,2.4945,0.987042,
	-0.987042,2.4945,0.987042,	-0.996219,2.498438,0.996219,	-0.833344,2.498438,1.135521,
	-0.649591,2.498438,1.248557,	-0.643607,2.4945,1.237056,	-0.825668,2.4945,1.125061,
	-0.825668,2.4945,1.125061,	-0.833344,2.498438,1.135521,	-0.649591,2.498438,1.248557,
	-0.447653,2.498438,1.332632,	-0.443529,2.4945,1.320356,	-0.643607,2.4945,1.237056,
	-0.643607,2.4945,1.237056,	-0.649591,2.498438,1.248557,	-0.447653,2.498438,1.332632,
	-0.230225,2.498438,1.385053,	-0.228104,2.4945,1.372294,	-0.443529,2.4945,1.320356,
	-0.443529,2.4945,1.320356,	-0.447653,2.498438,1.332632,	-0.230225,2.498438,1.385053,
	0,2.498438,1.403125,	0,2.4945,1.3902,	-0.228104,2.4945,1.372294,
	-0.228104,2.4945,1.372294,	-0.230225,2.498438,1.385053,	0,2.498438,1.403125,
	-1.401513,2.4945,0.232961,	-1.385053,2.498438,0.230225,	-1.403125,2.498438,0,
	-1.403125,2.498438,0,	-1.4198,2.4945,0,	-1.401513,2.4945,0.232961,
	-1.348469,2.4945,0.452973,	-1.332632,2.498438,0.447653,	-1.385053,2.498438,0.230225,
	-1.385053,2.498438,0.230225,	-1.401513,2.4945,0.232961,	-1.348469,2.4945,0.452973,
	-1.263395,2.4945,0.657311,	-1.248557,2.498438,0.649591,	-1.332632,2.498438,0.447653,
	-1.332632,2.498438,0.447653,	-1.348469,2.4945,0.452973,	-1.263395,2.4945,0.657311,
	-1.149016,2.4945,0.843248,	-1.135521,2.498438,0.833344,	-1.248557,2.498438,0.649591,
	-1.248557,2.498438,0.649591,	-1.263395,2.4945,0.657311,	-1.149016,2.4945,0.843248,
	-1.008058,2.4945,1.008058,	-0.996219,2.498438,0.996219,	-1.135521,2.498438,0.833344,
	-1.135521,2.498438,0.833344,	-1.149016,2.4945,0.843248,	-1.008058,2.4945,1.008058,
	-0.843248,2.4945,1.149016,	-0.833344,2.498438,1.135521,	-0.996219,2.498438,0.996219,
	-0.996219,2.498438,0.996219,	-1.008058,2.4945,1.008058,	-0.843248,2.4945,1.149016,
	-0.657311,2.4945,1.263395,	-0.649591,2.498438,1.248557,	-0.833344,2.498438,1.135521,
	-0.833344,2.498438,1.135521,	-0.843248,2.4945,1.149016,	-0.657311,2.4945,1.263395,
	-0.452973,2.4945,1.348469,	-0.447653,2.498438,1.332632,	-0.649591,2.498438,1.248557,
	-0.649591,2.498438,1.248557,	-0.657311,2.4945,1.263395,	-0.452973,2.4945,1.348469,
	-0.232961,2.4945,1.401513,	-0.230225,2.498438,1.385053,	-0.447653,2.498438,1.332632,
	-0.447653,2.498438,1.332632,	-0.452973,2.4945,1.348469,	-0.232961,2.4945,1.401513,
	0,2.4945,1.4198,	0,2.498438,1.403125,	-0.230225,2.498438,1.385053,
	-0.230225,2.498438,1.385053,	-0.232961,2.4945,1.401513,	0,2.4945,1.4198,
	-1.42049,2.482687,0.236115,	-1.401513,2.4945,0.232961,	-1.4198,2.4945,0,
	-1.4198,2.4945,0,	-1.439025,2.482687,0,	-1.42049,2.482687,0.236115,
	-1.366728,2.482687,0.459107,	-1.348469,2.4945,0.452973,	-1.401513,2.4945,0.232961,
	-1.401513,2.4945,0.232961,	-1.42049,2.482687,0.236115,	-1.366728,2.482687,0.459107,
	-1.280502,2.482687,0.666211,	-1.263395,2.4945,0.657311,	-1.348469,2.4945,0.452973,
	-1.348469,2.4945,0.452973,	-1.366728,2.482687,0.459107,	-1.280502,2.482687,0.666211,
	-1.164574,2.482687,0.854666,	-1.149016,2.4945,0.843248,	-1.263395,2.4945,0.657311,
	-1.263395,2.4945,0.657311,	-1.280502,2.482687,0.666211,	-1.164574,2.482687,0.854666,
	-1.021708,2.482687,1.021708,	-1.008058,2.4945,1.008058,	-1.149016,2.4945,0.843248,
	-1.149016,2.4945,0.843248,	-1.164574,2.482687,0.854666,	-1.021708,2.482687,1.021708,
	-0.854666,2.482687,1.164574,	-0.843248,2.4945,1.149016,	-1.008058,2.4945,1.008058,
	-1.008058,2.4945,1.008058,	-1.021708,2.482687,1.021708,	-0.854666,2.482687,1.164574,
	-0.666211,2.482687,1.280502,	-0.657311,2.4945,1.263395,	-0.843248,2.4945,1.149016,
	-0.843248,2.4945,1.149016,	-0.854666,2.482687,1.164574,	-0.666211,2.482687,1.280502,
	-0.459107,2.482687,1.366728,	-0.452973,2.4945,1.348469,	-0.657311,2.4945,1.263395,
	-0.657311,2.4945,1.263395,	-0.666211,2.482687,1.280502,	-0.459107,2.482687,1.366728,
	-0.236115,2.482687,1.42049,	-0.232961,2.4945,1.401513,	-0.452973,2.4945,1.348469,
	-0.452973,2.4945,1.348469,	-0.459107,2.482687,1.366728,	-0.236115,2.482687,1.42049,
	0,2.482687,1.439025,	0,2.4945,1.4198,	-0.232961,2.4945,1.401513,
	-0.232961,2.4945,1.401513,	-0.236115,2.482687,1.42049,	0,2.482687,1.439025,
	-1.4408,2.463,0.239491,	-1.42049,2.482687,0.236115,	-1.439025,2.482687,0,
	-1.439025,2.482687,0,	-1.4596,2.463,0,	-1.4408,2.463,0.239491,
	-1.38627,2.463,0.465671,	-1.366728,2.482687,0.459107,	-1.42049,2.482687,0.236115,
	-1.42049,2.482687,0.236115,	-1.4408,2.463,0.239491,	-1.38627,2.463,0.465671,
	-1.29881,2.463,0.675736,	-1.280502,2.482687,0.666211,	-1.366728,2.482687,0.459107,
	-1.366728,2.482687,0.459107,	-1.38627,2.463,0.465671,	-1.29881,2.463,0.675736,
	-1.181225,2.463,0.866886,	-1.164574,2.482687,0.854666,	-1.280502,2.482687,0.666211,
	-1.280502,2.482687,0.666211,	-1.29881,2.463,0.675736,	-1.181225,2.463,0.866886,
	-1.036316,2.463,1.036316,	-1.021708,2.482687,1.021708,	-1.164574,2.482687,0.854666,
	-1.164574,2.482687,0.854666,	-1.181225,2.463,0.866886,	-1.036316,2.463,1.036316,
	-0.866886,2.463,1.181225,	-0.854666,2.482687,1.164574,	-1.021708,2.482687,1.021708,
	-1.021708,2.482687,1.021708,	-1.036316,2.463,1.036316,	-0.866886,2.463,1.181225,
	-0.675736,2.463,1.29881,	-0.666211,2.482687,1.280502,	-0.854666,2.482687,1.164574,
	-0.854666,2.482687,1.164574,	-0.866886,2.463,1.181225,	-0.675736,2.463,1.29881,
	-0.465671,2.463,1.38627,	-0.459107,2.482687,1.366728,	-0.666211,2.482687,1.280502,
	-0.666211,2.482687,1.280502,	-0.675736,2.463,1.29881,	-0.465671,2.463,1.38627,
	-0.239491,2.463,1.4408,	-0.236115,2.482687,1.42049,	-0.459107,2.482687,1.366728,
	-0.459107,2.482687,1.366728,	-0.465671,2.463,1.38627,	-0.239491,2.463,1.4408,
	0,2.463,1.4596,	0,2.482687,1.439025,	-0.236115,2.482687,1.42049,
	-0.236115,2.482687,1.42049,	-0.239491,2.463,1.4408,	0,2.463,1.4596,
	-1.461258,2.435437,0.242892,	-1.4408,2.463,0.239491,	-1.4596,2.463,0,
	-1.4596,2.463,0,	-1.480325,2.435437,0,	-1.461258,2.435437,0.242892,
	-1.405953,2.435437,0.472283,	-1.38627,2.463,0.465671,	-1.4408,2.463,0.239491,
	-1.4408,2.463,0.239491,	-1.461258,2.435437,0.242892,	-1.405953,2.435437,0.472283,
	-1.317252,2.435437,0.685331,	-1.29881,2.463,0.675736,	-1.38627,2.463,0.465671,
	-1.38627,2.463,0.465671,	-1.405953,2.435437,0.472283,	-1.317252,2.435437,0.685331,
	-1.197997,2.435437,0.879195,	-1.181225,2.463,0.866886,	-1.29881,2.463,0.675736,
	-1.29881,2.463,0.675736,	-1.317252,2.435437,0.685331,	-1.197997,2.435437,0.879195,
	-1.051031,2.435437,1.051031,	-1.036316,2.463,1.036316,	-1.181225,2.463,0.866886,
	-1.181225,2.463,0.866886,	-1.197997,2.435437,0.879195,	-1.051031,2.435437,1.051031,
	-0.879195,2.435437,1.197997,	-0.866886,2.463,1.181225,	-1.036316,2.463,1.036316,
	-1.036316,2.463,1.036316,	-1.051031,2.435437,1.051031,	-0.879195,2.435437,1.197997,
	-0.685331,2.435437,1.317252,	-0.675736,2.463,1.29881,	-0.866886,2.463,1.181225,
	-0.866886,2.463,1.181225,	-0.879195,2.435437,1.197997,	-0.685331,2.435437,1.317252,
	-0.472283,2.435437,1.405953,	-0.465671,2.463,1.38627,	-0.675736,2.463,1.29881,
	-0.675736,2.463,1.29881,	-0.685331,2.435437,1.317252,	-0.472283,2.435437,1.405953,
	-0.242892,2.435437,1.461258,	-0.239491,2.463,1.4408,	-0.465671,2.463,1.38627,
	-0.465671,2.463,1.38627,	-0.472283,2.435437,1.405953,	-0.242892,2.435437,1.461258,
	0,2.435437,1.480325,	0,2.463,1.4596,	-0.239491,2.463,1.4408,
	-0.239491,2.463,1.4408,	-0.242892,2.435437,1.461258,	0,2.435437,1.480325,
	-1.48068,2.4,0.24612,	-1.461258,2.435437,0.242892,	-1.480325,2.435437,0,
	-1.480325,2.435437,0,	-1.5,2.4,0,	-1.48068,2.4,0.24612,
	-1.42464,2.4,0.47856,	-1.405953,2.435437,0.472283,	-1.461258,2.435437,0.242892,
	-1.461258,2.435437,0.242892,	-1.48068,2.4,0.24612,	-1.42464,2.4,0.47856,
	-1.33476,2.4,0.69444,	-1.317252,2.435437,0.685331,	-1.405953,2.435437,0.472283,
	-1.405953,2.435437,0.472283,	-1.42464,2.4,0.47856,	-1.33476,2.4,0.69444,
	-1.21392,2.4,0.89088,	-1.197997,2.435437,0.879195,	-1.317252,2.435437,0.685331,
	-1.317252,2.435437,0.685331,	-1.33476,2.4,0.69444,	-1.21392,2.4,0.89088,
	-1.065,2.4,1.065,	-1.051031,2.435437,1.051031,	-1.197997,2.435437,0.879195,
	-1.197997,2.435437,0.879195,	-1.21392,2.4,0.89088,	-1.065,2.4,1.065,
	-0.89088,2.4,1.21392,	-0.879195,2.435437,1.197997,	-1.051031,2.435437,1.051031,
	-1.051031,2.435437,1.051031,	-1.065,2.4,1.065,	-0.89088,2.4,1.21392,
	-0.69444,2.4,1.33476,	-0.685331,2.435437,1.317252,	-0.879195,2.435437,1.197997,
	-0.879195,2.435437,1.197997,	-0.89088,2.4,1.21392,	-0.69444,2.4,1.33476,
	-0.47856,2.4,1.42464,	-0.472283,2.435437,1.405953,	-0.685331,2.435437,1.317252,
	-0.685331,2.435437,1.317252,	-0.69444,2.4,1.33476,	-0.47856,2.4,1.42464,
	-0.24612,2.4,1.48068,	-0.242892,2.435437,1.461258,	-0.472283,2.435437,1.405953,
	-0.472283,2.435437,1.405953,	-0.47856,2.4,1.42464,	-0.24612,2.4,1.48068,
	0,2.4,1.5,	0,2.435437,1.480325,	-0.242892,2.435437,1.461258,
	-0.242892,2.435437,1.461258,	-0.24612,2.4,1.48068,	0,2.4,1.5,
	0.227403,2.435437,1.368074,	0.229712,2.4,1.381968,	0,2.4,1.4,
	0,2.4,1.4,	0,2.435437,1.385925,	0.227403,2.435437,1.368074,
	0.442166,2.435437,1.316296,	0.446656,2.4,1.329664,	0.229712,2.4,1.381968,
	0.229712,2.4,1.381968,	0.227403,2.435437,1.368074,	0.442166,2.435437,1.316296,
	0.641628,2.435437,1.233252,	0.648144,2.4,1.245776,	0.446656,2.4,1.329664,
	0.446656,2.4,1.329664,	0.442166,2.435437,1.316296,	0.641628,2.435437,1.233252,
	0.823129,2.435437,1.121601,	0.831488,2.4,1.132992,	0.648144,2.4,1.245776,
	0.648144,2.4,1.245776,	0.641628,2.435437,1.233252,	0.823129,2.435437,1.121601,
	0.984007,2.435437,0.984007,	0.994,2.4,0.994,	0.831488,2.4,1.132992,
	0.831488,2.4,1.132992,	0.823129,2.435437,1.121601,	0.984007,2.435437,0.984007,
	1.121601,2.435437,0.823129,	1.132992,2.4,0.831488,	0.994,2.4,0.994,
	0.994,2.4,0.994,	0.984007,2.435437,0.984007,	1.121601,2.435437,0.823129,
	1.233252,2.435437,0.641628,	1.245776,2.4,0.648144,	1.132992,2.4,0.831488,
	1.132992,2.4,0.831488,	1.121601,2.435437,0.823129,	1.233252,2.435437,0.641628,
	1.316296,2.435437,0.442166,	1.329664,2.4,0.446656,	1.245776,2.4,0.648144,
	1.245776,2.4,0.648144,	1.233252,2.435437,0.641628,	1.316296,2.435437,0.442166,
	1.368074,2.435437,0.227403,	1.381968,2.4,0.229712,	1.329664,2.4,0.446656,
	1.329664,2.4,0.446656,	1.316296,2.435437,0.442166,	1.368074,2.435437,0.227403,
	1.385925,2.435437,0,	1.4,2.4,0,	1.381968,2.4,0.229712,
	1.381968,2.4,0.229712,	1.368074,2.435437,0.227403,	1.385925,2.435437,0,
	0.226496,2.463,1.36262,	0.227403,2.435437,1.368074,	0,2.435437,1.385925,
	0,2.435437,1.385925,	0,2.463,1.3804,	0.226496,2.463,1.36262,
	0.440403,2.463,1.311049,	0.442166,2.435437,1.316296,	0.227403,2.435437,1.368074,
	0.227403,2.435437,1.368074,	0.226496,2.463,1.36262,	0.440403,2.463,1.311049,
	0.63907,2.463,1.228335,	0.641628,2.435437,1.233252,	0.442166,2.435437,1.316296,
	0.442166,2.435437,1.316296,	0.440403,2.463,1.311049,	0.63907,2.463,1.228335,
	0.819847,2.463,1.11713,	0.823129,2.435437,1.121601,	0.641628,2.435437,1.233252,
	0.641628,2.435437,1.233252,	0.63907,2.463,1.228335,	0.819847,2.463,1.11713,
	0.980084,2.463,0.980084,	0.984007,2.435437,0.984007,	0.823129,2.435437,1.121601,
	0.823129,2.435437,1.121601,	0.819847,2.463,1.11713,	0.980084,2.463,0.980084,
	1.11713,2.463,0.819847,	1.121601,2.435437,0.823129,	0.984007,2.435437,0.984007,
	0.984007,2.435437,0.984007,	0.980084,2.463,0.980084,	1.11713,2.463,0.819847,
	1.228335,2.463,0.63907,	1.233252,2.435437,0.641628,	1.121601,2.435437,0.823129,
	1.121601,2.435437,0.823129,	1.11713,2.463,0.819847,	1.228335,2.463,0.63907,
	1.311049,2.463,0.440403,	1.316296,2.435437,0.442166,	1.233252,2.435437,0.641628,
	1.233252,2.435437,0.641628,	1.228335,2.463,0.63907,	1.311049,2.463,0.440403,
	1.36262,2.463,0.226496,	1.368074,2.435437,0.227403,	1.316296,2.435437,0.442166,
	1.316296,2.435437,0.442166,	1.311049,2.463,0.440403,	1.36262,2.463,0.226496,
	1.3804,2.463,0,	1.385925,2.435437,0,	1.368074,2.435437,0.227403,
	1.368074,2.435437,0.227403,	1.36262,2.463,0.226496,	1.3804,2.463,0,
	0.226795,2.482687,1.364422,	0.226496,2.463,1.36262,	0,2.463,1.3804,
	0,2.463,1.3804,	0,2.482687,1.382225,	0.226795,2.482687,1.364422,
	0.440985,2.482687,1.312782,	0.440403,2.463,1.311049,	0.226496,2.463,1.36262,
	0.226496,2.463,1.36262,	0.226795,2.482687,1.364422,	0.440985,2.482687,1.312782,
	0.639915,2.482687,1.229959,	0.63907,2.463,1.228335,	0.440403,2.463,1.311049,
	0.440403,2.463,1.311049,	0.440985,2.482687,1.312782,	0.639915,2.482687,1.229959,
	0.820931,2.482687,1.118607,	0.819847,2.463,1.11713,	0.63907,2.463,1.228335,
	0.63907,2.463,1.228335,	0.639915,2.482687,1.229959,	0.820931,2.482687,1.118607,
	0.98138,2.482687,0.98138,	0.980084,2.463,0.980084,	0.819847,2.463,1.11713,
	0.819847,2.463,1.11713,	0.820931,2.482687,1.118607,	0.98138,2.482687,0.98138,
	1.118607,2.482687,0.820931,	1.11713,2.463,0.819847,	0.980084,2.463,0.980084,
	0.980084,2.463,0.980084,	0.98138,2.482687,0.98138,	1.118607,2.482687,0.820931,
	1.229959,2.482687,0.639915,	1.228335,2.463,0.63907,	1.11713,2.463,0.819847,
	1.11713,2.463,0.819847,	1.118607,2.482687,0.820931,	1.229959,2.482687,0.639915,
	1.312782,2.482687,0.440985,	1.311049,2.463,0.440403,	1.228335,2.463,0.63907,
	1.228335,2.463,0.63907,	1.229959,2.482687,0.639915,	1.312782,2.482687,0.440985,
	1.364422,2.482687,0.226795,	1.36262,2.463,0.226496,	1.311049,2.463,0.440403,
	1.311049,2.463,0.440403,	1.312782,2.482687,0.440985,	1.364422,2.482687,0.226795,
	1.382225,2.482687,0,	1.3804,2.463,0,	1.36262,2.463,0.226496,
	1.36262,2.463,0.226496,	1.364422,2.482687,0.226795,	1.382225,2.482687,0,
	0.228104,2.4945,1.372294,	0.226795,2.482687,1.364422,	0,2.482687,1.382225,
	0,2.482687,1.382225,	0,2.4945,1.3902,	0.228104,2.4945,1.372294,
	0.443529,2.4945,1.320356,	0.440985,2.482687,1.312782,	0.226795,2.482687,1.364422,
	0.226795,2.482687,1.364422,	0.228104,2.4945,1.372294,	0.443529,2.4945,1.320356,
	0.643607,2.4945,1.237056,	0.639915,2.482687,1.229959,	0.440985,2.482687,1.312782,
	0.440985,2.482687,1.312782,	0.443529,2.4945,1.320356,	0.643607,2.4945,1.237056,
	0.825668,2.4945,1.125061,	0.820931,2.482687,1.118607,	0.639915,2.482687,1.229959,
	0.639915,2.482687,1.229959,	0.643607,2.4945,1.237056,	0.825668,2.4945,1.125061,
	0.987042,2.4945,0.987042,	0.98138,2.482687,0.98138,	0.820931,2.482687,1.118607,
	0.820931,2.482687,1.118607,	0.825668,2.4945,1.125061,	0.987042,2.4945,0.987042,
	1.125061,2.4945,0.825668,	1.118607,2.482687,0.820931,	0.98138,2.482687,0.98138,
	0.98138,2.482687,0.98138,	0.987042,2.4945,0.987042,	1.125061,2.4945,0.825668,
	1.237056,2.4945,0.643607,	1.229959,2.482687,0.639915,	1.118607,2.482687,0.820931,
	1.118607,2.482687,0.820931,	1.125061,2.4945,0.825668,	1.237056,2.4945,0.643607,
	1.320356,2.4945,0.443529,	1.312782,2.482687,0.440985,	1.229959,2.482687,0.639915,
	1.229959,2.482687,0.639915,	1.237056,2.4945,0.643607,	1.320356,2.4945,0.443529,
	1.372294,2.4945,0.228104,	1.364422,2.482687,0.226795,	1.312782,2.482687,0.440985,
	1.312782,2.482687,0.440985,	1.320356,2.4945,0.443529,	1.372294,2.4945,0.228104,
	1.3902,2.4945,0,	1.382225,2.482687,0,	1.364422,2.482687,0.226795,
	1.364422,2.482687,0.226795,	1.372294,2.4945,0.228104,	1.3902,2.4945,0,
	0.230225,2.498438,1.385053,	0.228104,2.4945,1.372294,	0,2.4945,1.3902,
	0,2.4945,1.3902,	0,2.498438,1.403125,	0.230225,2.498438,1.385053,
	0.447653,2.498438,1.332632,	0.443529,2.4945,1.320356,	0.228104,2.4945,1.372294,
	0.228104,2.4945,1.372294,	0.230225,2.498438,1.385053,	0.447653,2.498438,1.332632,
	0.649591,2.498438,1.248557,	0.643607,2.4945,1.237056,	0.443529,2.4945,1.320356,
	0.443529,2.4945,1.320356,	0.447653,2.498438,1.332632,	0.649591,2.498438,1.248557,
	0.833344,2.498438,1.135521,	0.825668,2.4945,1.125061,	0.643607,2.4945,1.237056,
	0.643607,2.4945,1.237056,	0.649591,2.498438,1.248557,	0.833344,2.498438,1.135521,
	0.996219,2.498438,0.996219,	0.987042,2.4945,0.987042,	0.825668,2.4945,1.125061,
	0.825668,2.4945,1.125061,	0.833344,2.498438,1.135521,	0.996219,2.498438,0.996219,
	1.135521,2.498438,0.833344,	1.125061,2.4945,0.825668,	0.987042,2.4945,0.987042,
	0.987042,2.4945,0.987042,	0.996219,2.498438,0.996219,	1.135521,2.498438,0.833344,
	1.248557,2.498438,0.649591,	1.237056,2.4945,0.643607,	1.125061,2.4945,0.825668,
	1.125061,2.4945,0.825668,	1.135521,2.498438,0.833344,	1.248557,2.498438,0.649591,
	1.332632,2.498438,0.447653,	1.320356,2.4945,0.443529,	1.237056,2.4945,0.643607,
	1.237056,2.4945,0.643607,	1.248557,2.498438,0.649591,	1.332632,2.498438,0.447653,
	1.385053,2.498438,0.230225,	1.372294,2.4945,0.228104,	1.320356,2.4945,0.443529,
	1.320356,2.4945,0.443529,	1.332632,2.498438,0.447653,	1.385053,2.498438,0.230225,
	1.403125,2.498438,0,	1.3902,2.4945,0,	1.372294,2.4945,0.228104,
	1.372294,2.4945,0.228104,	1.385053,2.498438,0.230225,	1.403125,2.498438,0,
	0.232961,2.4945,1.401513,	0.230225,2.498438,1.385053,	0,2.498438,1.403125,
	0,2.498438,1.403125,	0,2.4945,1.4198,	0.232961,2.4945,1.401513,
	0.452973,2.4945,1.348469,	0.447653,2.498438,1.332632,	0.230225,2.498438,1.385053,
	0.230225,2.498438,1.385053,	0.232961,2.4945,1.401513,	0.452973,2.4945,1.348469,
	0.657311,2.4945,1.263395,	0.649591,2.498438,1.248557,	0.447653,2.498438,1.332632,
	0.447653,2.498438,1.332632,	0.452973,2.4945,1.348469,	0.657311,2.4945,1.263395,
	0.843248,2.4945,1.149016,	0.833344,2.498438,1.135521,	0.649591,2.498438,1.248557,
	0.649591,2.498438,1.248557,	0.657311,2.4945,1.263395,	0.843248,2.4945,1.149016,
	1.008058,2.4945,1.008058,	0.996219,2.498438,0.996219,	0.833344,2.498438,1.135521,
	0.833344,2.498438,1.135521,	0.843248,2.4945,1.149016,	1.008058,2.4945,1.008058,
	1.149016,2.4945,0.843248,	1.135521,2.498438,0.833344,	0.996219,2.498438,0.996219,
	0.996219,2.498438,0.996219,	1.008058,2.4945,1.008058,	1.149016,2.4945,0.843248,
	1.263395,2.4945,0.657311,	1.248557,2.498438,0.649591,	1.135521,2.498438,0.833344,
	1.135521,2.498438,0.833344,	1.149016,2.4945,0.843248,	1.263395,2.4945,0.657311,
	1.348469,2.4945,0.452973,	1.332632,2.498438,0.447653,	1.248557,2.498438,0.649591,
	1.248557,2.498438,0.649591,	1.263395,2.4945,0.657311,	1.348469,2.4945,0.452973,
	1.401513,2.4945,0.232961,	1.385053,2.498438,0.230225,	1.332632,2.498438,0.447653,
	1.332632,2.498438,0.447653,	1.348469,2.4945,0.452973,	1.401513,2.4945,0.232961,
	1.4198,2.4945,0,	1.403125,2.498438,0,	1.385053,2.498438,0.230225,
	1.385053,2.498438,0.230225,	1.401513,2.4945,0.232961,	1.4198,2.4945,0,
	0.236115,2.482687,1.42049,	0.232961,2.4945,1.401513,	0,2.4945,1.4198,
	0,2.4945,1.4198,	0,2.482687,1.439025,	0.236115,2.482687,1.42049,
	0.459107,2.482687,1.366728,	0.452973,2.4945,1.348469,	0.232961,2.4945,1.401513,
	0.232961,2.4945,1.401513,	0.236115,2.482687,1.42049,	0.459107,2.482687,1.366728,
	0.666211,2.482687,1.280502,	0.657311,2.4945,1.263395,	0.452973,2.4945,1.348469,
	0.452973,2.4945,1.348469,	0.459107,2.482687,1.366728,	0.666211,2.482687,1.280502,
	0.854666,2.482687,1.164574,	0.843248,2.4945,1.149016,	0.657311,2.4945,1.263395,
	0.657311,2.4945,1.263395,	0.666211,2.482687,1.280502,	0.854666,2.482687,1.164574,
	1.021708,2.482687,1.021708,	1.008058,2.4945,1.008058,	0.843248,2.4945,1.149016,
	0.843248,2.4945,1.149016,	0.854666,2.482687,1.164574,	1.021708,2.482687,1.021708,
	1.164574,2.482687,0.854666,	1.149016,2.4945,0.843248,	1.008058,2.4945,1.008058,
	1.008058,2.4945,1.008058,	1.021708,2.482687,1.021708,	1.164574,2.482687,0.854666,
	1.280502,2.482687,0.666211,	1.263395,2.4945,0.657311,	1.149016,2.4945,0.843248,
	1.149016,2.4945,0.843248,	1.164574,2.482687,0.854666,	1.280502,2.482687,0.666211,
	1.366728,2.482687,0.459107,	1.348469,2.4945,0.452973,	1.263395,2.4945,0.657311,
	1.263395,2.4945,0.657311,	1.280502,2.482687,0.666211,	1.366728,2.482687,0.459107,
	1.42049,2.482687,0.236115,	1.401513,2.4945,0.232961,	1.348469,2.4945,0.452973,
	1.348469,2.4945,0.452973,	1.366728,2.482687,0.459107,	1.42049,2.482687,0.236115,
	1.439025,2.482687,0,	1.4198,2.4945,0,	1.401513,2.4945,0.232961,
	1.401513,2.4945,0.232961,	1.42049,2.482687,0.236115,	1.439025,2.482687,0,
	0.239491,2.463,1.4408,	0.236115,2.482687,1.42049,	0,2.482687,1.439025,
	0,2.482687,1.439025,	0,2.463,1.4596,	0.239491,2.463,1.4408,
	0.465671,2.463,1.38627,	0.459107,2.482687,1.366728,	0.236115,2.482687,1.42049,
	0.236115,2.482687,1.42049,	0.239491,2.463,1.4408,	0.465671,2.463,1.38627,
	0.675736,2.463,1.29881,	0.666211,2.482687,1.280502,	0.459107,2.482687,1.366728,
	0.459107,2.482687,1.366728,	0.465671,2.463,1.38627,	0.675736,2.463,1.29881,
	0.866886,2.463,1.181225,	0.854666,2.482687,1.164574,	0.666211,2.482687,1.280502,
	0.666211,2.482687,1.280502,	0.675736,2.463,1.29881,	0.866886,2.463,1.181225,
	1.036316,2.463,1.036316,	1.021708,2.482687,1.021708,	0.854666,2.482687,1.164574,
	0.854666,2.482687,1.164574,	0.866886,2.463,1.181225,	1.036316,2.463,1.036316,
	1.181225,2.463,0.866886,	1.164574,2.482687,0.854666,	1.021708,2.482687,1.021708,
	1.021708,2.482687,1.021708,	1.036316,2.463,1.036316,	1.181225,2.463,0.866886,
	1.29881,2.463,0.675736,	1.280502,2.482687,0.666211,	1.164574,2.482687,0.854666,
	1.164574,2.482687,0.854666,	1.181225,2.463,0.866886,	1.29881,2.463,0.675736,
	1.38627,2.463,0.465671,	1.366728,2.482687,0.459107,	1.280502,2.482687,0.666211,
	1.280502,2.482687,0.666211,	1.29881,2.463,0.675736,	1.38627,2.463,0.465671,
	1.4408,2.463,0.239491,	1.42049,2.482687,0.236115,	1.366728,2.482687,0.459107,
	1.366728,2.482687,0.459107,	1.38627,2.463,0.465671,	1.4408,2.463,0.239491,
	1.4596,2.463,0,	1.439025,2.482687,0,	1.42049,2.482687,0.236115,
	1.42049,2.482687,0.236115,	1.4408,2.463,0.239491,	1.4596,2.463,0,
	0.242892,2.435437,1.461258,	0.239491,2.463,1.4408,	0,2.463,1.4596,
	0,2.463,1.4596,	0,2.435437,1.480325,	0.242892,2.435437,1.461258,
	0.472283,2.435437,1.405953,	0.465671,2.463,1.38627,	0.239491,2.463,1.4408,
	0.239491,2.463,1.4408,	0.242892,2.435437,1.461258,	0.472283,2.435437,1.405953,
	0.685331,2.435437,1.317252,	0.675736,2.463,1.29881,	0.465671,2.463,1.38627,
	0.465671,2.463,1.38627,	0.472283,2.435437,1.405953,	0.685331,2.435437,1.317252,
	0.879195,2.435437,1.197997,	0.866886,2.463,1.181225,	0.675736,2.463,1.29881,
	0.675736,2.463,1.29881,	0.685331,2.435437,1.317252,	0.879195,2.435437,1.197997,
	1.051031,2.435437,1.051031,	1.036316,2.463,1.036316,	0.866886,2.463,1.181225,
	0.866886,2.463,1.181225,	0.879195,2.435437,1.197997,	1.051031,2.435437,1.051031,
	1.197997,2.435437,0.879195,	1.181225,2.463,0.866886,	1.036316,2.463,1.036316,
	1.036316,2.463,1.036316,	1.051031,2.435437,1.051031,	1.197997,2.435437,0.879195,
	1.317252,2.435437,0.685331,	1.29881,2.463,0.675736,	1.181225,2.463,0.866886,
	1.181225,2.463,0.866886,	1.197997,2.435437,0.879195,	1.317252,2.435437,0.685331,
	1.405953,2.435437,0.472283,	1.38627,2.463,0.465671,	1.29881,2.463,0.675736,
	1.29881,2.463,0.675736,	1.317252,2.435437,0.685331,	1.405953,2.435437,0.472283,
	1.461258,2.435437,0.242892,	1.4408,2.463,0.239491,	1.38627,2.463,0.465671,
	1.38627,2.463,0.465671,	1.405953,2.435437,0.472283,	1.461258,2.435437,0.242892,
	1.480325,2.435437,0,	1.4596,2.463,0,	1.4408,2.463,0.239491,
	1.4408,2.463,0.239491,	1.461258,2.435437,0.242892,	1.480325,2.435437,0,
	0.24612,2.4,1.48068,	0.242892,2.435437,1.461258,	0,2.435437,1.480325,
	0,2.435437,1.480325,	0,2.4,1.5,	0.24612,2.4,1.48068,
	0.47856,2.4,1.42464,	0.472283,2.435437,1.405953,	0.242892,2.435437,1.461258,
	0.242892,2.435437,1.461258,	0.24612,2.4,1.48068,	0.47856,2.4,1.42464,
	0.69444,2.4,1.33476,	0.685331,2.435437,1.317252,	0.472283,2.435437,1.405953,
	0.472283,2.435437,1.405953,	0.47856,2.4,1.42464,	0.69444,2.4,1.33476,
	0.89088,2.4,1.21392,	0.879195,2.435437,1.197997,	0.685331,2.435437,1.317252,
	0.685331,2.435437,1.317252,	0.69444,2.4,1.33476,	0.89088,2.4,1.21392,
	1.065,2.4,1.065,	1.051031,2.435437,1.051031,	0.879195,2.435437,1.197997,
	0.879195,2.435437,1.197997,	0.89088,2.4,1.21392,	1.065,2.4,1.065,
	1.21392,2.4,0.89088,	1.197997,2.435437,0.879195,	1.051031,2.435437,1.051031,
	1.051031,2.435437,1.051031,	1.065,2.4,1.065,	1.21392,2.4,0.89088,
	1.33476,2.4,0.69444,	1.317252,2.435437,0.685331,	1.197997,2.435437,0.879195,
	1.197997,2.435437,0.879195,	1.21392,2.4,0.89088,	1.33476,2.4,0.69444,
	1.42464,2.4,0.47856,	1.405953,2.435437,0.472283,	1.317252,2.435437,0.685331,
	1.317252,2.435437,0.685331,	1.33476,2.4,0.69444,	1.42464,2.4,0.47856,
	1.48068,2.4,0.24612,	1.461258,2.435437,0.242892,	1.405953,2.435437,0.472283,
	1.405953,2.435437,0.472283,	1.42464,2.4,0.47856,	1.48068,2.4,0.24612,
	1.5,2.4,0,	1.480325,2.435437,0,	1.461258,2.435437,0.242892,
	1.461258,2.435437,0.242892,	1.48068,2.4,0.24612,	1.5,2.4,0,
	1.554467,2.242575,-0.258385,	1.48068,2.4,-0.24612,	1.5,2.4,0,
	1.5,2.4,0,	1.57475,2.242575,0,	1.554467,2.242575,-0.258385,
	1.495635,2.242575,-0.502408,	1.42464,2.4,-0.47856,	1.48068,2.4,-0.24612,
	1.48068,2.4,-0.24612,	1.554467,2.242575,-0.258385,	1.495635,2.242575,-0.502408,
	1.401276,2.242575,-0.729046,	1.33476,2.4,-0.69444,	1.42464,2.4,-0.47856,
	1.42464,2.4,-0.47856,	1.495635,2.242575,-0.502408,	1.401276,2.242575,-0.729046,
	1.274414,2.242575,-0.935276,	1.21392,2.4,-0.89088,	1.33476,2.4,-0.69444,
	1.33476,2.4,-0.69444,	1.401276,2.242575,-0.729046,	1.274414,2.242575,-0.935276,
	1.118073,2.242575,-1.118073,	1.065,2.4,-1.065,	1.21392,2.4,-0.89088,
	1.21392,2.4,-0.89088,	1.274414,2.242575,-0.935276,	1.118073,2.242575,-1.118073,
	0.935276,2.242575,-1.274414,	0.89088,2.4,-1.21392,	1.065,2.4,-1.065,
	1.065,2.4,-1.065,	1.118073,2.242575,-1.118073,	0.935276,2.242575,-1.274414,
	0.729046,2.242575,-1.401276,	0.69444,2.4,-1.33476,	0.89088,2.4,-1.21392,
	0.89088,2.4,-1.21392,	0.935276,2.242575,-1.274414,	0.729046,2.242575,-1.401276,
	0.502408,2.242575,-1.495635,	0.47856,2.4,-1.42464,	0.69444,2.4,-1.33476,
	0.69444,2.4,-1.33476,	0.729046,2.242575,-1.401276,	0.502408,2.242575,-1.495635,
	0.258385,2.242575,-1.554467,	0.24612,2.4,-1.48068,	0.47856,2.4,-1.42464,
	0.47856,2.4,-1.42464,	0.502408,2.242575,-1.495635,	0.258385,2.242575,-1.554467,
	0,2.242575,-1.57475,	0,2.4,-1.5,	0.24612,2.4,-1.48068,
	0.24612,2.4,-1.48068,	0.258385,2.242575,-1.554467,	0,2.242575,-1.57475,
	1.626774,2.0856,-0.270404,	1.554467,2.242575,-0.258385,	1.57475,2.242575,0,
	1.57475,2.242575,0,	1.648,2.0856,0,	1.626774,2.0856,-0.270404,
	1.565204,2.0856,-0.525778,	1.495635,2.242575,-0.502408,	1.554467,2.242575,-0.258385,
	1.554467,2.242575,-0.258385,	1.626774,2.0856,-0.270404,	1.565204,2.0856,-0.525778,
	1.466456,2.0856,-0.762958,	1.401276,2.242575,-0.729046,	1.495635,2.242575,-0.502408,
	1.495635,2.242575,-0.502408,	1.565204,2.0856,-0.525778,	1.466456,2.0856,-0.762958,
	1.333693,2.0856,-0.97878,	1.274414,2.242575,-0.935276,	1.401276,2.242575,-0.729046,
	1.401276,2.242575,-0.729046,	1.466456,2.0856,-0.762958,	1.333693,2.0856,-0.97878,
	1.17008,2.0856,-1.17008,	1.118073,2.242575,-1.118073,	1.274414,2.242575,-0.935276,
	1.274414,2.242575,-0.935276,	1.333693,2.0856,-0.97878,	1.17008,2.0856,-1.17008,
	0.97878,2.0856,-1.333693,	0.935276,2.242575,-1.274414,	1.118073,2.242575,-1.118073,
	1.118073,2.242575,-1.118073,	1.17008,2.0856,-1.17008,	0.97878,2.0856,-1.333693,
	0.762958,2.0856,-1.466456,	0.729046,2.242575,-1.401276,	0.935276,2.242575,-1.274414,
	0.935276,2.242575,-1.274414,	0.97878,2.0856,-1.333693,	0.762958,2.0856,-1.466456,
	0.525778,2.0856,-1.565204,	0.502408,2.242575,-1.495635,	0.729046,2.242575,-1.401276,
	0.729046,2.242575,-1.401276,	0.762958,2.0856,-1.466456,	0.525778,2.0856,-1.565204,
	0.270404,2.0856,-1.626774,	0.258385,2.242575,-1.554467,	0.502408,2.242575,-1.495635,
	0.502408,2.242575,-1.495635,	0.525778,2.0856,-1.565204,	0.270404,2.0856,-1.626774,
	0,2.0856,-1.648,	0,2.242575,-1.57475,	0.258385,2.242575,-1.554467,
	0.258385,2.242575,-1.554467,	0.270404,2.0856,-1.626774,	0,2.0856,-1.648,
	1.696119,1.929525,-0.28193,	1.626774,2.0856,-0.270404,	1.648,2.0856,0,
	1.648,2.0856,0,	1.71825,1.929525,0,	1.696119,1.929525,-0.28193,
	1.631925,1.929525,-0.54819,	1.565204,2.0856,-0.525778,	1.626774,2.0856,-0.270404,
	1.626774,2.0856,-0.270404,	1.696119,1.929525,-0.28193,	1.631925,1.929525,-0.54819,
	1.528968,1.929525,-0.795481,	1.466456,2.0856,-0.762958,	1.565204,2.0856,-0.525778,
	1.565204,2.0856,-0.525778,	1.631925,1.929525,-0.54819,	1.528968,1.929525,-0.795481,
	1.390545,1.929525,-1.020503,	1.333693,2.0856,-0.97878,	1.466456,2.0856,-0.762958,
	1.466456,2.0856,-0.762958,	1.528968,1.929525,-0.795481,	1.390545,1.929525,-1.020503,
	1.219958,1.929525,-1.219958,	1.17008,2.0856,-1.17008,	1.333693,2.0856,-0.97878,
	1.333693,2.0856,-0.97878,	1.390545,1.929525,-1.020503,	1.219958,1.929525,-1.219958,
	1.020503,1.929525,-1.390545,	0.97878,2.0856,-1.333693,	1.17008,2.0856,-1.17008,
	1.17008,2.0856,-1.17008,	1.219958,1.929525,-1.219958,	1.020503,1.929525,-1.390545,
	0.795481,1.929525,-1.528968,	0.762958,2.0856,-1.466456,	0.97878,2.0856,-1.333693,
	0.97878,2.0856,-1.333693,	1.020503,1.929525,-1.390545,	0.795481,1.929525,-1.528968,
	0.54819,1.929525,-1.631925,	0.525778,2.0856,-1.565204,	0.762958,2.0856,-1.466456,
	0.762958,2.0856,-1.466456,	0.795481,1.929525,-1.528968,	0.54819,1.929525,-1.631925,
	0.28193,1.929525,-1.696119,	0.270404,2.0856,-1.626774,	0.525778,2.0856,-1.565204,
	0.525778,2.0856,-1.565204,	0.54819,1.929525,-1.631925,	0.28193,1.929525,-1.696119,
	0,1.929525,-1.71825,	0,2.0856,-1.648,	0.270404,2.0856,-1.626774,
	0.270404,2.0856,-1.626774,	0.28193,1.929525,-1.696119,	0,1.929525,-1.71825,
	1.761022,1.7748,-0.292719,	1.696119,1.929525,-0.28193,	1.71825,1.929525,0,
	1.71825,1.929525,0,	1.784,1.7748,0,	1.761022,1.7748,-0.292719,
	1.694372,1.7748,-0.569167,	1.631925,1.929525,-0.54819,	1.696119,1.929525,-0.28193,
	1.696119,1.929525,-0.28193,	1.761022,1.7748,-0.292719,	1.694372,1.7748,-0.569167,
	1.587475,1.7748,-0.825921,	1.528968,1.929525,-0.795481,	1.631925,1.929525,-0.54819,
	1.631925,1.929525,-0.54819,	1.694372,1.7748,-0.569167,	1.587475,1.7748,-0.825921,
	1.443756,1.7748,-1.059553,	1.390545,1.929525,-1.020503,	1.528968,1.929525,-0.795481,
	1.528968,1.929525,-0.795481,	1.587475,1.7748,-0.825921,	1.443756,1.7748,-1.059553,
	1.26664,1.7748,-1.26664,	1.219958,1.929525,-1.219958,	1.390545,1.929525,-1.020503,
	1.390545,1.929525,-1.020503,	1.443756,1.7748,-1.059553,	1.26664,1.7748,-1.26664,
	1.059553,1.7748,-1.443756,	1.020503,1.929525,-1.390545,	1.219958,1.929525,-1.219958,
	1.219958,1.929525,-1.219958,	1.26664,1.7748,-1.26664,	1.059553,1.7748,-1.443756,
	0.825921,1.7748,-1.587475,	0.795481,1.929525,-1.528968,	1.020503,1.929525,-1.390545,
	1.020503,1.929525,-1.390545,	1.059553,1.7748,-1.443756,	0.825921,1.7748,-1.587475,
	0.569167,1.7748,-1.694372,	0.54819,1.929525,-1.631925,	0.795481,1.929525,-1.528968,
	0.795481,1.929525,-1.528968,	0.825921,1.7748,-1.587475,	0.569167,1.7748,-1.694372,
	0.292719,1.7748,-1.761022,	0.28193,1.929525,-1.696119,	0.54819,1.929525,-1.631925,
	0.54819,1.929525,-1.631925,	0.569167,1.7748,-1.694372,	0.292719,1.7748,-1.761022,
	0,1.7748,-1.784,	0,1.929525,-1.71825,	0.28193,1.929525,-1.696119,
	0.28193,1.929525,-1.696119,	0.292719,1.7748,-1.761022,	0,1.7748,-1.784,
	1.820003,1.621875,-0.302523,	1.761022,1.7748,-0.292719,	1.784,1.7748,0,
	1.784,1.7748,0,	1.84375,1.621875,0,	1.820003,1.621875,-0.302523,
	1.75112,1.621875,-0.58823,	1.694372,1.7748,-0.569167,	1.761022,1.7748,-0.292719,
	1.761022,1.7748,-0.292719,	1.820003,1.621875,-0.302523,	1.75112,1.621875,-0.58823,
	1.640643,1.621875,-0.853583,	1.587475,1.7748,-0.825921,	1.694372,1.7748,-0.569167,
	1.694372,1.7748,-0.569167,	1.75112,1.621875,-0.58823,	1.640643,1.621875,-0.853583,
	1.49211,1.621875,-1.09504,	1.443756,1.7748,-1.059553,	1.587475,1.7748,-0.825921,
	1.587475,1.7748,-0.825921,	1.640643,1.621875,-0.853583,	1.49211,1.621875,-1.09504,
	1.309063,1.621875,-1.309063,	1.26664,1.7748,-1.26664,	1.443756,1.7748,-1.059553,
	1.443756,1.7748,-1.059553,	1.49211,1.621875,-1.09504,	1.309063,1.621875,-1.309063,
	1.09504,1.621875,-1.49211,	1.059553,1.7748,-1.443756,	1.26664,1.7748,-1.26664,
	1.26664,1.7748,-1.26664,	1.309063,1.621875,-1.309063,	1.09504,1.621875,-1.49211,
	0.853583,1.621875,-1.640643,	0.825921,1.7748,-1.587475,	1.059553,1.7748,-1.443756,
	1.059553,1.7748,-1.443756,	1.09504,1.621875,-1.49211,	0.853583,1.621875,-1.640643,
	0.58823,1.621875,-1.75112,	0.569167,1.7748,-1.694372,	0.825921,1.7748,-1.587475,
	0.825921,1.7748,-1.587475,	0.853583,1.621875,-1.640643,	0.58823,1.621875,-1.75112,
	0.302522,1.621875,-1.820003,	0.292719,1.7748,-1.761022,	0.569167,1.7748,-1.694372,
	0.569167,1.7748,-1.694372,	0.58823,1.621875,-1.75112,	0.302522,1.621875,-1.820003,
	0,1.621875,-1.84375,	0,1.7748,-1.784,	0.292719,1.7748,-1.761022,
	0.292719,1.7748,-1.761022,	0.302522,1.621875,-1.820003,	0,1.621875,-1.84375,
	1.87158,1.4712,-0.311096,	1.820003,1.621875,-0.302523,	1.84375,1.621875,0,
	1.84375,1.621875,0,	1.896,1.4712,0,	1.87158,1.4712,-0.311096,
	1.800745,1.4712,-0.6049,	1.75112,1.621875,-0.58823,	1.820003,1.621875,-0.302523,
	1.820003,1.621875,-0.302523,	1.87158,1.4712,-0.311096,	1.800745,1.4712,-0.6049,
	1.687137,1.4712,-0.877772,	1.640643,1.621875,-0.853583,	1.75112,1.621875,-0.58823,
	1.75112,1.621875,-0.58823,	1.800745,1.4712,-0.6049,	1.687137,1.4712,-0.877772,
	1.534395,1.4712,-1.126072,	1.49211,1.621875,-1.09504,	1.640643,1.621875,-0.853583,
	1.640643,1.621875,-0.853583,	1.687137,1.4712,-0.877772,	1.534395,1.4712,-1.126072,
	1.34616,1.4712,-1.34616,	1.309063,1.621875,-1.309063,	1.49211,1.621875,-1.09504,
	1.49211,1.621875,-1.09504,	1.534395,1.4712,-1.126072,	1.34616,1.4712,-1.34616,
	1.126072,1.4712,-1.534395,	1.09504,1.621875,-1.49211,	1.309063,1.621875,-1.309063,
	1.309063,1.621875,-1.309063,	1.34616,1.4712,-1.34616,	1.126072,1.4712,-1.534395,
	0.877772,1.4712,-1.687137,	0.853583,1.621875,-1.640643,	1.09504,1.621875,-1.49211,
	1.09504,1.621875,-1.49211,	1.126072,1.4712,-1.534395,	0.877772,1.4712,-1.687137,
	0.6049,1.4712,-1.800745,	0.58823,1.621875,-1.75112,	0.853583,1.621875,-1.640643,
	0.853583,1.621875,-1.640643,	0.877772,1.4712,-1.687137,	0.6049,1.4712,-1.800745,
	0.311096,1.4712,-1.87158,	0.302522,1.621875,-1.820003,	0.58823,1.621875,-1.75112,
	0.58823,1.621875,-1.75112,	0.6049,1.4712,-1.800745,	0.311096,1.4712,-1.87158,
	0,1.4712,-1.896,	0,1.621875,-1.84375,	0.302522,1.621875,-1.820003,
	0.302522,1.621875,-1.820003,	0.311096,1.4712,-1.87158,	0,1.4712,-1.896,
	1.914272,1.323225,-0.318192,	1.87158,1.4712,-0.311096,	1.896,1.4712,0,
	1.896,1.4712,0,	1.93925,1.323225,0,	1.914272,1.323225,-0.318192,
	1.841822,1.323225,-0.618698,	1.800745,1.4712,-0.6049,	1.87158,1.4712,-0.311096,
	1.87158,1.4712,-0.311096,	1.914272,1.323225,-0.318192,	1.841822,1.323225,-0.618698,
	1.725622,1.323225,-0.897795,	1.687137,1.4712,-0.877772,	1.800745,1.4712,-0.6049,
	1.800745,1.4712,-0.6049,	1.841822,1.323225,-0.618698,	1.725622,1.323225,-0.897795,
	1.569396,1.323225,-1.151759,	1.534395,1.4712,-1.126072,	1.687137,1.4712,-0.877772,
	1.687137,1.4712,-0.877772,	1.725622,1.323225,-0.897795,	1.569396,1.323225,-1.151759,
	1.376867,1.323225,-1.376868,	1.34616,1.4712,-1.34616,	1.534395,1.4712,-1.126072,
	1.534395,1.4712,-1.126072,	1.569396,1.323225,-1.151759,	1.376867,1.323225,-1.376868,
	1.151759,1.323225,-1.569396,	1.126072,1.4712,-1.534395,	1.34616,1.4712,-1.34616,
	1.34616,1.4712,-1.34616,	1.376867,1.323225,-1.376868,	1.151759,1.323225,-1.569396,
	0.897795,1.323225,-1.725622,	0.877772,1.4712,-1.687137,	1.126072,1.4712,-1.534395,
	1.126072,1.4712,-1.534395,	1.151759,1.323225,-1.569396,	0.897795,1.323225,-1.725622,
	0.618698,1.323225,-1.841822,	0.6049,1.4712,-1.800745,	0.877772,1.4712,-1.687137,
	0.877772,1.4712,-1.687137,	0.897795,1.323225,-1.725622,	0.618698,1.323225,-1.841822,
	0.318192,1.323225,-1.914272,	0.311096,1.4712,-1.87158,	0.6049,1.4712,-1.800745,
	0.6049,1.4712,-1.800745,	0.618698,1.323225,-1.841822,	0.318192,1.323225,-1.914272,
	0,1.323225,-1.93925,	0,1.4712,-1.896,	0.311096,1.4712,-1.87158,
	0.311096,1.4712,-1.87158,	0.318192,1.323225,-1.914272,	0,1.323225,-1.93925,
	1.946601,1.1784,-0.323566,	1.914272,1.323225,-0.318192,	1.93925,1.323225,0,
	1.93925,1.323225,0,	1.972,1.1784,0,	1.946601,1.1784,-0.323566,
	1.872927,1.1784,-0.629147,	1.841822,1.323225,-0.618698,	1.914272,1.323225,-0.318192,
	1.914272,1.323225,-0.318192,	1.946601,1.1784,-0.323566,	1.872927,1.1784,-0.629147,
	1.754764,1.1784,-0.912957,	1.725622,1.323225,-0.897795,	1.841822,1.323225,-0.618698,
	1.841822,1.323225,-0.618698,	1.872927,1.1784,-0.629147,	1.754764,1.1784,-0.912957,
	1.5959,1.1784,-1.17121,	1.569396,1.323225,-1.151759,	1.725622,1.323225,-0.897795,
	1.725622,1.323225,-0.897795,	1.754764,1.1784,-0.912957,	1.5959,1.1784,-1.17121,
	1.40012,1.1784,-1.40012,	1.376867,1.323225,-1.376868,	1.569396,1.323225,-1.151759,
	1.569396,1.323225,-1.151759,	1.5959,1.1784,-1.17121,	1.40012,1.1784,-1.40012,
	1.17121,1.1784,-1.5959,	1.151759,1.323225,-1.569396,	1.376867,1.323225,-1.376868,
	1.376867,1.323225,-1.376868,	1.40012,1.1784,-1.40012,	1.17121,1.1784,-1.5959,
	0.912957,1.1784,-1.754764,	0.897795,1.323225,-1.725622,	1.151759,1.323225,-1.569396,
	1.151759,1.323225,-1.569396,	1.17121,1.1784,-1.5959,	0.912957,1.1784,-1.754764,
	0.629147,1.1784,-1.872927,	0.618698,1.323225,-1.841822,	0.897795,1.323225,-1.725622,
	0.897795,1.323225,-1.725622,	0.912957,1.1784,-1.754764,	0.629147,1.1784,-1.872927,
	0.323566,1.1784,-1.946601,	0.318192,1.323225,-1.914272,	0.618698,1.323225,-1.841822,
	0.618698,1.323225,-1.841822,	0.629147,1.1784,-1.872927,	0.323566,1.1784,-1.946601,
	0,1.1784,-1.972,	0,1.323225,-1.93925,	0.318192,1.323225,-1.914272,
	0.318192,1.323225,-1.914272,	0.323566,1.1784,-1.946601,	0,1.1784,-1.972,
	1.967083,1.037175,-0.32697,	1.946601,1.1784,-0.323566,	1.972,1.1784,0,
	1.972,1.1784,0,	1.99275,1.037175,0,	1.967083,1.037175,-0.32697,
	1.892634,1.037175,-0.635767,	1.872927,1.1784,-0.629147,	1.946601,1.1784,-0.323566,
	1.946601,1.1784,-0.323566,	1.967083,1.037175,-0.32697,	1.892634,1.037175,-0.635767,
	1.773229,1.037175,-0.922564,	1.754764,1.1784,-0.912957,	1.872927,1.1784,-0.629147,
	1.872927,1.1784,-0.629147,	1.892634,1.037175,-0.635767,	1.773229,1.037175,-0.922564,
	1.612693,1.037175,-1.183534,	1.5959,1.1784,-1.17121,	1.754764,1.1784,-0.912957,
	1.754764,1.1784,-0.912957,	1.773229,1.037175,-0.922564,	1.612693,1.037175,-1.183534,
	1.414853,1.037175,-1.414853,	1.40012,1.1784,-1.40012,	1.5959,1.1784,-1.17121,
	1.5959,1.1784,-1.17121,	1.612693,1.037175,-1.183534,	1.414853,1.037175,-1.414853,
	1.183534,1.037175,-1.612693,	1.17121,1.1784,-1.5959,	1.40012,1.1784,-1.40012,
	1.40012,1.1784,-1.40012,	1.414853,1.037175,-1.414853,	1.183534,1.037175,-1.612693,
	0.922564,1.037175,-1.773229,	0.912957,1.1784,-1.754764,	1.17121,1.1784,-1.5959,
	1.17121,1.1784,-1.5959,	1.183534,1.037175,-1.612693,	0.922564,1.037175,-1.773229,
	0.635767,1.037175,-1.892634,	0.629147,1.1784,-1.872927,	0.912957,1.1784,-1.754764,
	0.912957,1.1784,-1.754764,	0.922564,1.037175,-1.773229,	0.635767,1.037175,-1.892634,
	0.32697,1.037175,-1.967083,	0.323566,1.1784,-1.946601,	0.629147,1.1784,-1.872927,
	0.629147,1.1784,-1.872927,	0.635767,1.037175,-1.892634,	0.32697,1.037175,-1.967083,
	0,1.037175,-1.99275,	0,1.1784,-1.972,	0.323566,1.1784,-1.946601,
	0.323566,1.1784,-1.946601,	0.32697,1.037175,-1.967083,	0,1.037175,-1.99275,
	1.97424,0.9,-0.32816,	1.967083,1.037175,-0.32697,	1.99275,1.037175,0,
	1.99275,1.037175,0,	2,0.9,0,	1.97424,0.9,-0.32816,
	1.89952,0.9,-0.63808,	1.892634,1.037175,-0.635767,	1.967083,1.037175,-0.32697,
	1.967083,1.037175,-0.32697,	1.97424,0.9,-0.32816,	1.89952,0.9,-0.63808,
	1.77968,0.9,-0.92592,	1.773229,1.037175,-0.922564,	1.892634,1.037175,-0.635767,
	1.892634,1.037175,-0.635767,	1.89952,0.9,-0.63808,	1.77968,0.9,-0.92592,
	1.61856,0.9,-1.18784,	1.612693,1.037175,-1.183534,	1.773229,1.037175,-0.922564,
	1.773229,1.037175,-0.922564,	1.77968,0.9,-0.92592,	1.61856,0.9,-1.18784,
	1.42,0.9,-1.42,	1.414853,1.037175,-1.414853,	1.612693,1.037175,-1.183534,
	1.612693,1.037175,-1.183534,	1.61856,0.9,-1.18784,	1.42,0.9,-1.42,
	1.18784,0.9,-1.61856,	1.183534,1.037175,-1.612693,	1.414853,1.037175,-1.414853,
	1.414853,1.037175,-1.414853,	1.42,0.9,-1.42,	1.18784,0.9,-1.61856,
	0.92592,0.9,-1.77968,	0.922564,1.037175,-1.773229,	1.183534,1.037175,-1.612693,
	1.183534,1.037175,-1.612693,	1.18784,0.9,-1.61856,	0.92592,0.9,-1.77968,
	0.63808,0.9,-1.89952,	0.635767,1.037175,-1.892634,	0.922564,1.037175,-1.773229,
	0.922564,1.037175,-1.773229,	0.92592,0.9,-1.77968,	0.63808,0.9,-1.89952,
	0.32816,0.9,-1.97424,	0.32697,1.037175,-1.967083,	0.635767,1.037175,-1.892634,
	0.635767,1.037175,-1.892634,	0.63808,0.9,-1.89952,	0.32816,0.9,-1.97424,
	0,0.9,-2,	0,1.037175,-1.99275,	0.32697,1.037175,-1.967083,
	0.32697,1.037175,-1.967083,	0.32816,0.9,-1.97424,	0,0.9,-2,
	-0.258385,2.242575,-1.554467,	-0.24612,2.4,-1.48068,	0,2.4,-1.5,
	0,2.4,-1.5,	0,2.242575,-1.57475,	-0.258385,2.242575,-1.554467,
	-0.502408,2.242575,-1.495635,	-0.47856,2.4,-1.42464,	-0.24612,2.4,-1.48068,
	-0.24612,2.4,-1.48068,	-0.258385,2.242575,-1.554467,	-0.502408,2.242575,-1.495635,
	-0.729046,2.242575,-1.401276,	-0.69444,2.4,-1.33476,	-0.47856,2.4,-1.42464,
	-0.47856,2.4,-1.42464,	-0.502408,2.242575,-1.495635,	-0.729046,2.242575,-1.401276,
	-0.935276,2.242575,-1.274414,	-0.89088,2.4,-1.21392,	-0.69444,2.4,-1.33476,
	-0.69444,2.4,-1.33476,	-0.729046,2.242575,-1.401276,	-0.935276,2.242575,-1.274414,
	-1.118073,2.242575,-1.118073,	-1.065,2.4,-1.065,	-0.89088,2.4,-1.21392,
	-0.89088,2.4,-1.21392,	-0.935276,2.242575,-1.274414,	-1.118073,2.242575,-1.118073,
	-1.274414,2.242575,-0.935276,	-1.21392,2.4,-0.89088,	-1.065,2.4,-1.065,
	-1.065,2.4,-1.065,	-1.118073,2.242575,-1.118073,	-1.274414,2.242575,-0.935276,
	-1.401276,2.242575,-0.729046,	-1.33476,2.4,-0.69444,	-1.21392,2.4,-0.89088,
	-1.21392,2.4,-0.89088,	-1.274414,2.242575,-0.935276,	-1.401276,2.242575,-0.729046,
	-1.495635,2.242575,-0.502408,	-1.42464,2.4,-0.47856,	-1.33476,2.4,-0.69444,
	-1.33476,2.4,-0.69444,	-1.401276,2.242575,-0.729046,	-1.495635,2.242575,-0.502408,
	-1.554467,2.242575,-0.258385,	-1.48068,2.4,-0.24612,	-1.42464,2.4,-0.47856,
	-1.42464,2.4,-0.47856,	-1.495635,2.242575,-0.502408,	-1.554467,2.242575,-0.258385,
	-1.57475,2.242575,0,	-1.5,2.4,0,	-1.48068,2.4,-0.24612,
	-1.48068,2.4,-0.24612,	-1.554467,2.242575,-0.258385,	-1.57475,2.242575,0,
	-0.270404,2.0856,-1.626774,	-0.258385,2.242575,-1.554467,	0,2.242575,-1.57475,
	0,2.242575,-1.57475,	0,2.0856,-1.648,	-0.270404,2.0856,-1.626774,
	-0.525778,2.0856,-1.565204,	-0.502408,2.242575,-1.495635,	-0.258385,2.242575,-1.554467,
	-0.258385,2.242575,-1.554467,	-0.270404,2.0856,-1.626774,	-0.525778,2.0856,-1.565204,
	-0.762958,2.0856,-1.466456,	-0.729046,2.242575,-1.401276,	-0.502408,2.242575,-1.495635,
	-0.502408,2.242575,-1.495635,	-0.525778,2.0856,-1.565204,	-0.762958,2.0856,-1.466456,
	-0.97878,2.0856,-1.333693,	-0.935276,2.242575,-1.274414,	-0.729046,2.242575,-1.401276,
	-0.729046,2.242575,-1.401276,	-0.762958,2.0856,-1.466456,	-0.97878,2.0856,-1.333693,
	-1.17008,2.0856,-1.17008,	-1.118073,2.242575,-1.118073,	-0.935276,2.242575,-1.274414,
	-0.935276,2.242575,-1.274414,	-0.97878,2.0856,-1.333693,	-1.17008,2.0856,-1.17008,
	-1.333693,2.0856,-0.97878,	-1.274414,2.242575,-0.935276,	-1.118073,2.242575,-1.118073,
	-1.118073,2.242575,-1.118073,	-1.17008,2.0856,-1.17008,	-1.333693,2.0856,-0.97878,
	-1.466456,2.0856,-0.762958,	-1.401276,2.242575,-0.729046,	-1.274414,2.242575,-0.935276,
	-1.274414,2.242575,-0.935276,	-1.333693,2.0856,-0.97878,	-1.466456,2.0856,-0.762958,
	-1.565204,2.0856,-0.525778,	-1.495635,2.242575,-0.502408,	-1.401276,2.242575,-0.729046,
	-1.401276,2.242575,-0.729046,	-1.466456,2.0856,-0.762958,	-1.565204,2.0856,-0.525778,
	-1.626774,2.0856,-0.270404,	-1.554467,2.242575,-0.258385,	-1.495635,2.242575,-0.502408,
	-1.495635,2.242575,-0.502408,	-1.565204,2.0856,-0.525778,	-1.626774,2.0856,-0.270404,
	-1.648,2.0856,0,	-1.57475,2.242575,0,	-1.554467,2.242575,-0.258385,
	-1.554467,2.242575,-0.258385,	-1.626774,2.0856,-0.270404,	-1.648,2.0856,0,
	-0.28193,1.929525,-1.696119,	-0.270404,2.0856,-1.626774,	0,2.0856,-1.648,
	0,2.0856,-1.648,	0,1.929525,-1.71825,	-0.28193,1.929525,-1.696119,
	-0.54819,1.929525,-1.631925,	-0.525778,2.0856,-1.565204,	-0.270404,2.0856,-1.626774,
	-0.270404,2.0856,-1.626774,	-0.28193,1.929525,-1.696119,	-0.54819,1.929525,-1.631925,
	-0.795481,1.929525,-1.528968,	-0.762958,2.0856,-1.466456,	-0.525778,2.0856,-1.565204,
	-0.525778,2.0856,-1.565204,	-0.54819,1.929525,-1.631925,	-0.795481,1.929525,-1.528968,
	-1.020503,1.929525,-1.390545,	-0.97878,2.0856,-1.333693,	-0.762958,2.0856,-1.466456,
	-0.762958,2.0856,-1.466456,	-0.795481,1.929525,-1.528968,	-1.020503,1.929525,-1.390545,
	-1.219958,1.929525,-1.219958,	-1.17008,2.0856,-1.17008,	-0.97878,2.0856,-1.333693,
	-0.97878,2.0856,-1.333693,	-1.020503,1.929525,-1.390545,	-1.219958,1.929525,-1.219958,
	-1.390545,1.929525,-1.020503,	-1.333693,2.0856,-0.97878,	-1.17008,2.0856,-1.17008,
	-1.17008,2.0856,-1.17008,	-1.219958,1.929525,-1.219958,	-1.390545,1.929525,-1.020503,
	-1.528968,1.929525,-0.795481,	-1.466456,2.0856,-0.762958,	-1.333693,2.0856,-0.97878,
	-1.333693,2.0856,-0.97878,	-1.390545,1.929525,-1.020503,	-1.528968,1.929525,-0.795481,
	-1.631925,1.929525,-0.54819,	-1.565204,2.0856,-0.525778,	-1.466456,2.0856,-0.762958,
	-1.466456,2.0856,-0.762958,	-1.528968,1.929525,-0.795481,	-1.631925,1.929525,-0.54819,
	-1.696119,1.929525,-0.28193,	-1.626774,2.0856,-0.270404,	-1.565204,2.0856,-0.525778,
	-1.565204,2.0856,-0.525778,	-1.631925,1.929525,-0.54819,	-1.696119,1.929525,-0.28193,
	-1.71825,1.929525,0,	-1.648,2.0856,0,	-1.626774,2.0856,-0.270404,
	-1.626774,2.0856,-0.270404,	-1.696119,1.929525,-0.28193,	-1.71825,1.929525,0,
	-0.292719,1.7748,-1.761022,	-0.28193,1.929525,-1.696119,	0,1.929525,-1.71825,
	0,1.929525,-1.71825,	0,1.7748,-1.784,	-0.292719,1.7748,-1.761022,
	-0.569167,1.7748,-1.694372,	-0.54819,1.929525,-1.631925,	-0.28193,1.929525,-1.696119,
	-0.28193,1.929525,-1.696119,	-0.292719,1.7748,-1.761022,	-0.569167,1.7748,-1.694372,
	-0.825921,1.7748,-1.587475,	-0.795481,1.929525,-1.528968,	-0.54819,1.929525,-1.631925,
	-0.54819,1.929525,-1.631925,	-0.569167,1.7748,-1.694372,	-0.825921,1.7748,-1.587475,
	-1.059553,1.7748,-1.443756,	-1.020503,1.929525,-1.390545,	-0.795481,1.929525,-1.528968,
	-0.795481,1.929525,-1.528968,	-0.825921,1.7748,-1.587475,	-1.059553,1.7748,-1.443756,
	-1.26664,1.7748,-1.26664,	-1.219958,1.929525,-1.219958,	-1.020503,1.929525,-1.390545,
	-1.020503,1.929525,-1.390545,	-1.059553,1.7748,-1.443756,	-1.26664,1.7748,-1.26664,
	-1.443756,1.7748,-1.059553,	-1.390545,1.929525,-1.020503,	-1.219958,1.929525,-1.219958,
	-1.219958,1.929525,-1.219958,	-1.26664,1.7748,-1.26664,	-1.443756,1.7748,-1.059553,
	-1.587475,1.7748,-0.825921,	-1.528968,1.929525,-0.795481,	-1.390545,1.929525,-1.020503,
	-1.390545,1.929525,-1.020503,	-1.443756,1.7748,-1.059553,	-1.587475,1.7748,-0.825921,
	-1.694372,1.7748,-0.569167,	-1.631925,1.929525,-0.54819,	-1.528968,1.929525,-0.795481,
	-1.528968,1.929525,-0.795481,	-1.587475,1.7748,-0.825921,	-1.694372,1.7748,-0.569167,
	-1.761022,1.7748,-0.292719,	-1.696119,1.929525,-0.28193,	-1.631925,1.929525,-0.54819,
	-1.631925,1.929525,-0.54819,	-1.694372,1.7748,-0.569167,	-1.761022,1.7748,-0.292719,
	-1.784,1.7748,0,	-1.71825,1.929525,0,	-1.696119,1.929525,-0.28193,
	-1.696119,1.929525,-0.28193,	-1.761022,1.7748,-0.292719,	-1.784,1.7748,0,
	-0.302523,1.621875,-1.820003,	-0.292719,1.7748,-1.761022,	0,1.7748,-1.784,
	0,1.7748,-1.784,	0,1.621875,-1.84375,	-0.302523,1.621875,-1.820003,
	-0.58823,1.621875,-1.75112,	-0.569167,1.7748,-1.694372,	-0.292719,1.7748,-1.761022,
	-0.292719,1.7748,-1.761022,	-0.302523,1.621875,-1.820003,	-0.58823,1.621875,-1.75112,
	-0.853583,1.621875,-1.640643,	-0.825921,1.7748,-1.587475,	-0.569167,1.7748,-1.694372,
	-0.569167,1.7748,-1.694372,	-0.58823,1.621875,-1.75112,	-0.853583,1.621875,-1.640643,
	-1.09504,1.621875,-1.49211,	-1.059553,1.7748,-1.443756,	-0.825921,1.7748,-1.587475,
	-0.825921,1.7748,-1.587475,	-0.853583,1.621875,-1.640643,	-1.09504,1.621875,-1.49211,
	-1.309063,1.621875,-1.309063,	-1.26664,1.7748,-1.26664,	-1.059553,1.7748,-1.443756,
	-1.059553,1.7748,-1.443756,	-1.09504,1.621875,-1.49211,	-1.309063,1.621875,-1.309063,
	-1.49211,1.621875,-1.09504,	-1.443756,1.7748,-1.059553,	-1.26664,1.7748,-1.26664,
	-1.26664,1.7748,-1.26664,	-1.309063,1.621875,-1.309063,	-1.49211,1.621875,-1.09504,
	-1.640643,1.621875,-0.853583,	-1.587475,1.7748,-0.825921,	-1.443756,1.7748,-1.059553,
	-1.443756,1.7748,-1.059553,	-1.49211,1.621875,-1.09504,	-1.640643,1.621875,-0.853583,
	-1.75112,1.621875,-0.58823,	-1.694372,1.7748,-0.569167,	-1.587475,1.7748,-0.825921,
	-1.587475,1.7748,-0.825921,	-1.640643,1.621875,-0.853583,	-1.75112,1.621875,-0.58823,
	-1.820003,1.621875,-0.302522,	-1.761022,1.7748,-0.292719,	-1.694372,1.7748,-0.569167,
	-1.694372,1.7748,-0.569167,	-1.75112,1.621875,-0.58823,	-1.820003,1.621875,-0.302522,
	-1.84375,1.621875,0,	-1.784,1.7748,0,	-1.761022,1.7748,-0.292719,
	-1.761022,1.7748,-0.292719,	-1.820003,1.621875,-0.302522,	-1.84375,1.621875,0,
	-0.311096,1.4712,-1.87158,	-0.302523,1.621875,-1.820003,	0,1.621875,-1.84375,
	0,1.621875,-1.84375,	0,1.4712,-1.896,	-0.311096,1.4712,-1.87158,
	-0.6049,1.4712,-1.800745,	-0.58823,1.621875,-1.75112,	-0.302523,1.621875,-1.820003,
	-0.302523,1.621875,-1.820003,	-0.311096,1.4712,-1.87158,	-0.6049,1.4712,-1.800745,
	-0.877772,1.4712,-1.687137,	-0.853583,1.621875,-1.640643,	-0.58823,1.621875,-1.75112,
	-0.58823,1.621875,-1.75112,	-0.6049,1.4712,-1.800745,	-0.877772,1.4712,-1.687137,
	-1.126072,1.4712,-1.534395,	-1.09504,1.621875,-1.49211,	-0.853583,1.621875,-1.640643,
	-0.853583,1.621875,-1.640643,	-0.877772,1.4712,-1.687137,	-1.126072,1.4712,-1.534395,
	-1.34616,1.4712,-1.34616,	-1.309063,1.621875,-1.309063,	-1.09504,1.621875,-1.49211,
	-1.09504,1.621875,-1.49211,	-1.126072,1.4712,-1.534395,	-1.34616,1.4712,-1.34616,
	-1.534395,1.4712,-1.126072,	-1.49211,1.621875,-1.09504,	-1.309063,1.621875,-1.309063,
	-1.309063,1.621875,-1.309063,	-1.34616,1.4712,-1.34616,	-1.534395,1.4712,-1.126072,
	-1.687137,1.4712,-0.877772,	-1.640643,1.621875,-0.853583,	-1.49211,1.621875,-1.09504,
	-1.49211,1.621875,-1.09504,	-1.534395,1.4712,-1.126072,	-1.687137,1.4712,-0.877772,
	-1.800745,1.4712,-0.6049,	-1.75112,1.621875,-0.58823,	-1.640643,1.621875,-0.853583,
	-1.640643,1.621875,-0.853583,	-1.687137,1.4712,-0.877772,	-1.800745,1.4712,-0.6049,
	-1.87158,1.4712,-0.311096,	-1.820003,1.621875,-0.302522,	-1.75112,1.621875,-0.58823,
	-1.75112,1.621875,-0.58823,	-1.800745,1.4712,-0.6049,	-1.87158,1.4712,-0.311096,
	-1.896,1.4712,0,	-1.84375,1.621875,0,	-1.820003,1.621875,-0.302522,
	-1.820003,1.621875,-0.302522,	-1.87158,1.4712,-0.311096,	-1.896,1.4712,0,
	-0.318192,1.323225,-1.914272,	-0.311096,1.4712,-1.87158,	0,1.4712,-1.896,
	0,1.4712,-1.896,	0,1.323225,-1.93925,	-0.318192,1.323225,-1.914272,
	-0.618698,1.323225,-1.841822,	-0.6049,1.4712,-1.800745,	-0.311096,1.4712,-1.87158,
	-0.311096,1.4712,-1.87158,	-0.318192,1.323225,-1.914272,	-0.618698,1.323225,-1.841822,
	-0.897795,1.323225,-1.725622,	-0.877772,1.4712,-1.687137,	-0.6049,1.4712,-1.800745,
	-0.6049,1.4712,-1.800745,	-0.618698,1.323225,-1.841822,	-0.897795,1.323225,-1.725622,
	-1.151759,1.323225,-1.569396,	-1.126072,1.4712,-1.534395,	-0.877772,1.4712,-1.687137,
	-0.877772,1.4712,-1.687137,	-0.897795,1.323225,-1.725622,	-1.151759,1.323225,-1.569396,
	-1.376868,1.323225,-1.376867,	-1.34616,1.4712,-1.34616,	-1.126072,1.4712,-1.534395,
	-1.126072,1.4712,-1.534395,	-1.151759,1.323225,-1.569396,	-1.376868,1.323225,-1.376867,
	-1.569396,1.323225,-1.151759,	-1.534395,1.4712,-1.126072,	-1.34616,1.4712,-1.34616,
	-1.34616,1.4712,-1.34616,	-1.376868,1.323225,-1.376867,	-1.569396,1.323225,-1.151759,
	-1.725622,1.323225,-0.897795,	-1.687137,1.4712,-0.877772,	-1.534395,1.4712,-1.126072,
	-1.534395,1.4712,-1.126072,	-1.569396,1.323225,-1.151759,	-1.725622,1.323225,-0.897795,
	-1.841822,1.323225,-0.618698,	-1.800745,1.4712,-0.6049,	-1.687137,1.4712,-0.877772,
	-1.687137,1.4712,-0.877772,	-1.725622,1.323225,-0.897795,	-1.841822,1.323225,-0.618698,
	-1.914272,1.323225,-0.318192,	-1.87158,1.4712,-0.311096,	-1.800745,1.4712,-0.6049,
	-1.800745,1.4712,-0.6049,	-1.841822,1.323225,-0.618698,	-1.914272,1.323225,-0.318192,
	-1.93925,1.323225,0,	-1.896,1.4712,0,	-1.87158,1.4712,-0.311096,
	-1.87158,1.4712,-0.311096,	-1.914272,1.323225,-0.318192,	-1.93925,1.323225,0,
	-0.323566,1.1784,-1.946601,	-0.318192,1.323225,-1.914272,	0,1.323225,-1.93925,
	0,1.323225,-1.93925,	0,1.1784,-1.972,	-0.323566,1.1784,-1.946601,
	-0.629147,1.1784,-1.872927,	-0.618698,1.323225,-1.841822,	-0.318192,1.323225,-1.914272,
	-0.318192,1.323225,-1.914272,	-0.323566,1.1784,-1.946601,	-0.629147,1.1784,-1.872927,
	-0.912957,1.1784,-1.754764,	-0.897795,1.323225,-1.725622,	-0.618698,1.323225,-1.841822,
	-0.618698,1.323225,-1.841822,	-0.629147,1.1784,-1.872927,	-0.912957,1.1784,-1.754764,
	-1.17121,1.1784,-1.5959,	-1.151759,1.323225,-1.569396,	-0.897795,1.323225,-1.725622,
	-0.897795,1.323225,-1.725622,	-0.912957,1.1784,-1.754764,	-1.17121,1.1784,-1.5959,
	-1.40012,1.1784,-1.40012,	-1.376868,1.323225,-1.376867,	-1.151759,1.323225,-1.569396,
	-1.151759,1.323225,-1.569396,	-1.17121,1.1784,-1.5959,	-1.40012,1.1784,-1.40012,
	-1.5959,1.1784,-1.17121,	-1.569396,1.323225,-1.151759,	-1.376868,1.323225,-1.376867,
	-1.376868,1.323225,-1.376867,	-1.40012,1.1784,-1.40012,	-1.5959,1.1784,-1.17121,
	-1.754764,1.1784,-0.912957,	-1.725622,1.323225,-0.897795,	-1.569396,1.323225,-1.151759,
	-1.569396,1.323225,-1.151759,	-1.5959,1.1784,-1.17121,	-1.754764,1.1784,-0.912957,
	-1.872927,1.1784,-0.629147,	-1.841822,1.323225,-0.618698,	-1.725622,1.323225,-0.897795,
	-1.725622,1.323225,-0.897795,	-1.754764,1.1784,-0.912957,	-1.872927,1.1784,-0.629147,
	-1.946601,1.1784,-0.323566,	-1.914272,1.323225,-0.318192,	-1.841822,1.323225,-0.618698,
	-1.841822,1.323225,-0.618698,	-1.872927,1.1784,-0.629147,	-1.946601,1.1784,-0.323566,
	-1.972,1.1784,0,	-1.93925,1.323225,0,	-1.914272,1.323225,-0.318192,
	-1.914272,1.323225,-0.318192,	-1.946601,1.1784,-0.323566,	-1.972,1.1784,0,
	-0.32697,1.037175,-1.967083,	-0.323566,1.1784,-1.946601,	0,1.1784,-1.972,
	0,1.1784,-1.972,	0,1.037175,-1.99275,	-0.32697,1.037175,-1.967083,
	-0.635767,1.037175,-1.892634,	-0.629147,1.1784,-1.872927,	-0.323566,1.1784,-1.946601,
	-0.323566,1.1784,-1.946601,	-0.32697,1.037175,-1.967083,	-0.635767,1.037175,-1.892634,
	-0.922564,1.037175,-1.773229,	-0.912957,1.1784,-1.754764,	-0.629147,1.1784,-1.872927,
	-0.629147,1.1784,-1.872927,	-0.635767,1.037175,-1.892634,	-0.922564,1.037175,-1.773229,
	-1.183534,1.037175,-1.612693,	-1.17121,1.1784,-1.5959,	-0.912957,1.1784,-1.754764,
	-0.912957,1.1784,-1.754764,	-0.922564,1.037175,-1.773229,	-1.183534,1.037175,-1.612693,
	-1.414853,1.037175,-1.414853,	-1.40012,1.1784,-1.40012,	-1.17121,1.1784,-1.5959,
	-1.17121,1.1784,-1.5959,	-1.183534,1.037175,-1.612693,	-1.414853,1.037175,-1.414853,
	-1.612693,1.037175,-1.183534,	-1.5959,1.1784,-1.17121,	-1.40012,1.1784,-1.40012,
	-1.40012,1.1784,-1.40012,	-1.414853,1.037175,-1.414853,	-1.612693,1.037175,-1.183534,
	-1.773229,1.037175,-0.922564,	-1.754764,1.1784,-0.912957,	-1.5959,1.1784,-1.17121,
	-1.5959,1.1784,-1.17121,	-1.612693,1.037175,-1.183534,	-1.773229,1.037175,-0.922564,
	-1.892634,1.037175,-0.635767,	-1.872927,1.1784,-0.629147,	-1.754764,1.1784,-0.912957,
	-1.754764,1.1784,-0.912957,	-1.773229,1.037175,-0.922564,	-1.892634,1.037175,-0.635767,
	-1.967083,1.037175,-0.32697,	-1.946601,1.1784,-0.323566,	-1.872927,1.1784,-0.629147,
	-1.872927,1.1784,-0.629147,	-1.892634,1.037175,-0.635767,	-1.967083,1.037175,-0.32697,
	-1.99275,1.037175,0,	-1.972,1.1784,0,	-1.946601,1.1784,-0.323566,
	-1.946601,1.1784,-0.323566,	-1.967083,1.037175,-0.32697,	-1.99275,1.037175,0,
	-0.32816,0.9,-1.97424,	-0.32697,1.037175,-1.967083,	0,1.037175,-1.99275,
	0,1.037175,-1.99275,	0,0.9,-2,	-0.32816,0.9,-1.97424,
	-0.63808,0.9,-1.89952,	-0.635767,1.037175,-1.892634,	-0.32697,1.037175,-1.967083,
	-0.32697,1.037175,-1.967083,	-0.32816,0.9,-1.97424,	-0.63808,0.9,-1.89952,
	-0.92592,0.9,-1.77968,	-0.922564,1.037175,-1.773229,	-0.635767,1.037175,-1.892634,
	-0.635767,1.037175,-1.892634,	-0.63808,0.9,-1.89952,	-0.92592,0.9,-1.77968,
	-1.18784,0.9,-1.61856,	-1.183534,1.037175,-1.612693,	-0.922564,1.037175,-1.773229,
	-0.922564,1.037175,-1.773229,	-0.92592,0.9,-1.77968,	-1.18784,0.9,-1.61856,
	-1.42,0.9,-1.42,	-1.414853,1.037175,-1.414853,	-1.183534,1.037175,-1.612693,
	-1.183534,1.037175,-1.612693,	-1.18784,0.9,-1.61856,	-1.42,0.9,-1.42,
	-1.61856,0.9,-1.18784,	-1.612693,1.037175,-1.183534,	-1.414853,1.037175,-1.414853,
	-1.414853,1.037175,-1.414853,	-1.42,0.9,-1.42,	-1.61856,0.9,-1.18784,
	-1.77968,0.9,-0.92592,	-1.773229,1.037175,-0.922564,	-1.612693,1.037175,-1.183534,
	-1.612693,1.037175,-1.183534,	-1.61856,0.9,-1.18784,	-1.77968,0.9,-0.92592,
	-1.89952,0.9,-0.63808,	-1.892634,1.037175,-0.635767,	-1.773229,1.037175,-0.922564,
	-1.773229,1.037175,-0.922564,	-1.77968,0.9,-0.92592,	-1.89952,0.9,-0.63808,
	-1.97424,0.9,-0.32816,	-1.967083,1.037175,-0.32697,	-1.892634,1.037175,-0.635767,
	-1.892634,1.037175,-0.635767,	-1.89952,0.9,-0.63808,	-1.97424,0.9,-0.32816,
	-2,0.9,0,	-1.99275,1.037175,0,	-1.967083,1.037175,-0.32697,
	-1.967083,1.037175,-0.32697,	-1.97424,0.9,-0.32816,	-2,0.9,0,
	-1.554467,2.242575,0.258385,	-1.48068,2.4,0.24612,	-1.5,2.4,0,
	-1.5,2.4,0,	-1.57475,2.242575,0,	-1.554467,2.242575,0.258385,
	-1.495635,2.242575,0.502408,	-1.42464,2.4,0.47856,	-1.48068,2.4,0.24612,
	-1.48068,2.4,0.24612,	-1.554467,2.242575,0.258385,	-1.495635,2.242575,0.502408,
	-1.401276,2.242575,0.729046,	-1.33476,2.4,0.69444,	-1.42464,2.4,0.47856,
	-1.42464,2.4,0.47856,	-1.495635,2.242575,0.502408,	-1.401276,2.242575,0.729046,
	-1.274414,2.242575,0.935276,	-1.21392,2.4,0.89088,	-1.33476,2.4,0.69444,
	-1.33476,2.4,0.69444,	-1.401276,2.242575,0.729046,	-1.274414,2.242575,0.935276,
	-1.118073,2.242575,1.118073,	-1.065,2.4,1.065,	-1.21392,2.4,0.89088,
	-1.21392,2.4,0.89088,	-1.274414,2.242575,0.935276,	-1.118073,2.242575,1.118073,
	-0.935276,2.242575,1.274414,	-0.89088,2.4,1.21392,	-1.065,2.4,1.065,
	-1.065,2.4,1.065,	-1.118073,2.242575,1.118073,	-0.935276,2.242575,1.274414,
	-0.729046,2.242575,1.401276,	-0.69444,2.4,1.33476,	-0.89088,2.4,1.21392,
	-0.89088,2.4,1.21392,	-0.935276,2.242575,1.274414,	-0.729046,2.242575,1.401276,
	-0.502408,2.242575,1.495635,	-0.47856,2.4,1.42464,	-0.69444,2.4,1.33476,
	-0.69444,2.4,1.33476,	-0.729046,2.242575,1.401276,	-0.502408,2.242575,1.495635,
	-0.258385,2.242575,1.554467,	-0.24612,2.4,1.48068,	-0.47856,2.4,1.42464,
	-0.47856,2.4,1.42464,	-0.502408,2.242575,1.495635,	-0.258385,2.242575,1.554467,
	0,2.242575,1.57475,	0,2.4,1.5,	-0.24612,2.4,1.48068,
	-0.24612,2.4,1.48068,	-0.258385,2.242575,1.554467,	0,2.242575,1.57475,
	-1.626774,2.0856,0.270404,	-1.554467,2.242575,0.258385,	-1.57475,2.242575,0,
	-1.57475,2.242575,0,	-1.648,2.0856,0,	-1.626774,2.0856,0.270404,
	-1.565204,2.0856,0.525778,	-1.495635,2.242575,0.502408,	-1.554467,2.242575,0.258385,
	-1.554467,2.242575,0.258385,	-1.626774,2.0856,0.270404,	-1.565204,2.0856,0.525778,
	-1.466456,2.0856,0.762958,	-1.401276,2.242575,0.729046,	-1.495635,2.242575,0.502408,
	-1.495635,2.242575,0.502408,	-1.565204,2.0856,0.525778,	-1.466456,2.0856,0.762958,
	-1.333693,2.0856,0.97878,	-1.274414,2.242575,0.935276,	-1.401276,2.242575,0.729046,
	-1.401276,2.242575,0.729046,	-1.466456,2.0856,0.762958,	-1.333693,2.0856,0.97878,
	-1.17008,2.0856,1.17008,	-1.118073,2.242575,1.118073,	-1.274414,2.242575,0.935276,
	-1.274414,2.242575,0.935276,	-1.333693,2.0856,0.97878,	-1.17008,2.0856,1.17008,
	-0.97878,2.0856,1.333693,	-0.935276,2.242575,1.274414,	-1.118073,2.242575,1.118073,
	-1.118073,2.242575,1.118073,	-1.17008,2.0856,1.17008,	-0.97878,2.0856,1.333693,
	-0.762958,2.0856,1.466456,	-0.729046,2.242575,1.401276,	-0.935276,2.242575,1.274414,
	-0.935276,2.242575,1.274414,	-0.97878,2.0856,1.333693,	-0.762958,2.0856,1.466456,
	-0.525778,2.0856,1.565204,	-0.502408,2.242575,1.495635,	-0.729046,2.242575,1.401276,
	-0.729046,2.242575,1.401276,	-0.762958,2.0856,1.466456,	-0.525778,2.0856,1.565204,
	-0.270404,2.0856,1.626774,	-0.258385,2.242575,1.554467,	-0.502408,2.242575,1.495635,
	-0.502408,2.242575,1.495635,	-0.525778,2.0856,1.565204,	-0.270404,2.0856,1.626774,
	0,2.0856,1.648,	0,2.242575,1.57475,	-0.258385,2.242575,1.554467,
	-0.258385,2.242575,1.554467,	-0.270404,2.0856,1.626774,	0,2.0856,1.648,
	-1.696119,1.929525,0.28193,	-1.626774,2.0856,0.270404,	-1.648,2.0856,0,
	-1.648,2.0856,0,	-1.71825,1.929525,0,	-1.696119,1.929525,0.28193,
	-1.631925,1.929525,0.54819,	-1.565204,2.0856,0.525778,	-1.626774,2.0856,0.270404,
	-1.626774,2.0856,0.270404,	-1.696119,1.929525,0.28193,	-1.631925,1.929525,0.54819,
	-1.528968,1.929525,0.795481,	-1.466456,2.0856,0.762958,	-1.565204,2.0856,0.525778,
	-1.565204,2.0856,0.525778,	-1.631925,1.929525,0.54819,	-1.528968,1.929525,0.795481,
	-1.390545,1.929525,1.020503,	-1.333693,2.0856,0.97878,	-1.466456,2.0856,0.762958,
	-1.466456,2.0856,0.762958,	-1.528968,1.929525,0.795481,	-1.390545,1.929525,1.020503,
	-1.219958,1.929525,1.219958,	-1.17008,2.0856,1.17008,	-1.333693,2.0856,0.97878,
	-1.333693,2.0856,0.97878,	-1.390545,1.929525,1.020503,	-1.219958,1.929525,1.219958,
	-1.020503,1.929525,1.390545,	-0.97878,2.0856,1.333693,	-1.17008,2.0856,1.17008,
	-1.17008,2.0856,1.17008,	-1.219958,1.929525,1.219958,	-1.020503,1.929525,1.390545,
	-0.795481,1.929525,1.528968,	-0.762958,2.0856,1.466456,	-0.97878,2.0856,1.333693,
	-0.97878,2.0856,1.333693,	-1.020503,1.929525,1.390545,	-0.795481,1.929525,1.528968,
	-0.54819,1.929525,1.631925,	-0.525778,2.0856,1.565204,	-0.762958,2.0856,1.466456,
	-0.762958,2.0856,1.466456,	-0.795481,1.929525,1.528968,	-0.54819,1.929525,1.631925,
	-0.28193,1.929525,1.696119,	-0.270404,2.0856,1.626774,	-0.525778,2.0856,1.565204,
	-0.525778,2.0856,1.565204,	-0.54819,1.929525,1.631925,	-0.28193,1.929525,1.696119,
	0,1.929525,1.71825,	0,2.0856,1.648,	-0.270404,2.0856,1.626774,
	-0.270404,2.0856,1.626774,	-0.28193,1.929525,1.696119,	0,1.929525,1.71825,
	-1.761022,1.7748,0.292719,	-1.696119,1.929525,0.28193,	-1.71825,1.929525,0,
	-1.71825,1.929525,0,	-1.784,1.7748,0,	-1.761022,1.7748,0.292719,
	-1.694372,1.7748,0.569167,	-1.631925,1.929525,0.54819,	-1.696119,1.929525,0.28193,
	-1.696119,1.929525,0.28193,	-1.761022,1.7748,0.292719,	-1.694372,1.7748,0.569167,
	-1.587475,1.7748,0.825921,	-1.528968,1.929525,0.795481,	-1.631925,1.929525,0.54819,
	-1.631925,1.929525,0.54819,	-1.694372,1.7748,0.569167,	-1.587475,1.7748,0.825921,
	-1.443756,1.7748,1.059553,	-1.390545,1.929525,1.020503,	-1.528968,1.929525,0.795481,
	-1.528968,1.929525,0.795481,	-1.587475,1.7748,0.825921,	-1.443756,1.7748,1.059553,
	-1.26664,1.7748,1.26664,	-1.219958,1.929525,1.219958,	-1.390545,1.929525,1.020503,
	-1.390545,1.929525,1.020503,	-1.443756,1.7748,1.059553,	-1.26664,1.7748,1.26664,
	-1.059553,1.7748,1.443756,	-1.020503,1.929525,1.390545,	-1.219958,1.929525,1.219958,
	-1.219958,1.929525,1.219958,	-1.26664,1.7748,1.26664,	-1.059553,1.7748,1.443756,
	-0.825921,1.7748,1.587475,	-0.795481,1.929525,1.528968,	-1.020503,1.929525,1.390545,
	-1.020503,1.929525,1.390545,	-1.059553,1.7748,1.443756,	-0.825921,1.7748,1.587475,
	-0.569167,1.7748,1.694372,	-0.54819,1.929525,1.631925,	-0.795481,1.929525,1.528968,
	-0.795481,1.929525,1.528968,	-0.825921,1.7748,1.587475,	-0.569167,1.7748,1.694372,
	-0.292719,1.7748,1.761022,	-0.28193,1.929525,1.696119,	-0.54819,1.929525,1.631925,
	-0.54819,1.929525,1.631925,	-0.569167,1.7748,1.694372,	-0.292719,1.7748,1.761022,
	0,1.7748,1.784,	0,1.929525,1.71825,	-0.28193,1.929525,1.696119,
	-0.28193,1.929525,1.696119,	-0.292719,1.7748,1.761022,	0,1.7748,1.784,
	-1.820003,1.621875,0.302523,	-1.761022,1.7748,0.292719,	-1.784,1.7748,0,
	-1.784,1.7748,0,	-1.84375,1.621875,0,	-1.820003,1.621875,0.302523,
	-1.75112,1.621875,0.58823,	-1.694372,1.7748,0.569167,	-1.761022,1.7748,0.292719,
	-1.761022,1.7748,0.292719,	-1.820003,1.621875,0.302523,	-1.75112,1.621875,0.58823,
	-1.640643,1.621875,0.853583,	-1.587475,1.7748,0.825921,	-1.694372,1.7748,0.569167,
	-1.694372,1.7748,0.569167,	-1.75112,1.621875,0.58823,	-1.640643,1.621875,0.853583,
	-1.49211,1.621875,1.09504,	-1.443756,1.7748,1.059553,	-1.587475,1.7748,0.825921,
	-1.587475,1.7748,0.825921,	-1.640643,1.621875,0.853583,	-1.49211,1.621875,1.09504,
	-1.309063,1.621875,1.309063,	-1.26664,1.7748,1.26664,	-1.443756,1.7748,1.059553,
	-1.443756,1.7748,1.059553,	-1.49211,1.621875,1.09504,	-1.309063,1.621875,1.309063,
	-1.09504,1.621875,1.49211,	-1.059553,1.7748,1.443756,	-1.26664,1.7748,1.26664,
	-1.26664,1.7748,1.26664,	-1.309063,1.621875,1.309063,	-1.09504,1.621875,1.49211,
	-0.853583,1.621875,1.640643,	-0.825921,1.7748,1.587475,	-1.059553,1.7748,1.443756,
	-1.059553,1.7748,1.443756,	-1.09504,1.621875,1.49211,	-0.853583,1.621875,1.640643,
	-0.58823,1.621875,1.75112,	-0.569167,1.7748,1.694372,	-0.825921,1.7748,1.587475,
	-0.825921,1.7748,1.587475,	-0.853583,1.621875,1.640643,	-0.58823,1.621875,1.75112,
	-0.302522,1.621875,1.820003,	-0.292719,1.7748,1.761022,	-0.569167,1.7748,1.694372,
	-0.569167,1.7748,1.694372,	-0.58823,1.621875,1.75112,	-0.302522,1.621875,1.820003,
	0,1.621875,1.84375,	0,1.7748,1.784,	-0.292719,1.7748,1.761022,
	-0.292719,1.7748,1.761022,	-0.302522,1.621875,1.820003,	0,1.621875,1.84375,
	-1.87158,1.4712,0.311096,	-1.820003,1.621875,0.302523,	-1.84375,1.621875,0,
	-1.84375,1.621875,0,	-1.896,1.4712,0,	-1.87158,1.4712,0.311096,
	-1.800745,1.4712,0.6049,	-1.75112,1.621875,0.58823,	-1.820003,1.621875,0.302523,
	-1.820003,1.621875,0.302523,	-1.87158,1.4712,0.311096,	-1.800745,1.4712,0.6049,
	-1.687137,1.4712,0.877772,	-1.640643,1.621875,0.853583,	-1.75112,1.621875,0.58823,
	-1.75112,1.621875,0.58823,	-1.800745,1.4712,0.6049,	-1.687137,1.4712,0.877772,
	-1.534395,1.4712,1.126072,	-1.49211,1.621875,1.09504,	-1.640643,1.621875,0.853583,
	-1.640643,1.621875,0.853583,	-1.687137,1.4712,0.877772,	-1.534395,1.4712,1.126072,
	-1.34616,1.4712,1.34616,	-1.309063,1.621875,1.309063,	-1.49211,1.621875,1.09504,
	-1.49211,1.621875,1.09504,	-1.534395,1.4712,1.126072,	-1.34616,1.4712,1.34616,
	-1.126072,1.4712,1.534395,	-1.09504,1.621875,1.49211,	-1.309063,1.621875,1.309063,
	-1.309063,1.621875,1.309063,	-1.34616,1.4712,1.34616,	-1.126072,1.4712,1.534395,
	-0.877772,1.4712,1.687137,	-0.853583,1.621875,1.640643,	-1.09504,1.621875,1.49211,
	-1.09504,1.621875,1.49211,	-1.126072,1.4712,1.534395,	-0.877772,1.4712,1.687137,
	-0.6049,1.4712,1.800745,	-0.58823,1.621875,1.75112,	-0.853583,1.621875,1.640643,
	-0.853583,1.621875,1.640643,	-0.877772,1.4712,1.687137,	-0.6049,1.4712,1.800745,
	-0.311096,1.4712,1.87158,	-0.302522,1.621875,1.820003,	-0.58823,1.621875,1.75112,
	-0.58823,1.621875,1.75112,	-0.6049,1.4712,1.800745,	-0.311096,1.4712,1.87158,
	0,1.4712,1.896,	0,1.621875,1.84375,	-0.302522,1.621875,1.820003,
	-0.302522,1.621875,1.820003,	-0.311096,1.4712,1.87158,	0,1.4712,1.896,
	-1.914272,1.323225,0.318192,	-1.87158,1.4712,0.311096,	-1.896,1.4712,0,
	-1.896,1.4712,0,	-1.93925,1.323225,0,	-1.914272,1.323225,0.318192,
	-1.841822,1.323225,0.618698,	-1.800745,1.4712,0.6049,	-1.87158,1.4712,0.311096,
	-1.87158,1.4712,0.311096,	-1.914272,1.323225,0.318192,	-1.841822,1.323225,0.618698,
	-1.725622,1.323225,0.897795,	-1.687137,1.4712,0.877772,	-1.800745,1.4712,0.6049,
	-1.800745,1.4712,0.6049,	-1.841822,1.323225,0.618698,	-1.725622,1.323225,0.897795,
	-1.569396,1.323225,1.151759,	-1.534395,1.4712,1.126072,	-1.687137,1.4712,0.877772,
	-1.687137,1.4712,0.877772,	-1.725622,1.323225,0.897795,	-1.569396,1.323225,1.151759,
	-1.376867,1.323225,1.376868,	-1.34616,1.4712,1.34616,	-1.534395,1.4712,1.126072,
	-1.534395,1.4712,1.126072,	-1.569396,1.323225,1.151759,	-1.376867,1.323225,1.376868,
	-1.151759,1.323225,1.569396,	-1.126072,1.4712,1.534395,	-1.34616,1.4712,1.34616,
	-1.34616,1.4712,1.34616,	-1.376867,1.323225,1.376868,	-1.151759,1.323225,1.569396,
	-0.897795,1.323225,1.725622,	-0.877772,1.4712,1.687137,	-1.126072,1.4712,1.534395,
	-1.126072,1.4712,1.534395,	-1.151759,1.323225,1.569396,	-0.897795,1.323225,1.725622,
	-0.618698,1.323225,1.841822,	-0.6049,1.4712,1.800745,	-0.877772,1.4712,1.687137,
	-0.877772,1.4712,1.687137,	-0.897795,1.323225,1.725622,	-0.618698,1.323225,1.841822,
	-0.318192,1.323225,1.914272,	-0.311096,1.4712,1.87158,	-0.6049,1.4712,1.800745,
	-0.6049,1.4712,1.800745,	-0.618698,1.323225,1.841822,	-0.318192,1.323225,1.914272,
	0,1.323225,1.93925,	0,1.4712,1.896,	-0.311096,1.4712,1.87158,
	-0.311096,1.4712,1.87158,	-0.318192,1.323225,1.914272,	0,1.323225,1.93925,
	-1.946601,1.1784,0.323566,	-1.914272,1.323225,0.318192,	-1.93925,1.323225,0,
	-1.93925,1.323225,0,	-1.972,1.1784,0,	-1.946601,1.1784,0.323566,
	-1.872927,1.1784,0.629147,	-1.841822,1.323225,0.618698,	-1.914272,1.323225,0.318192,
	-1.914272,1.323225,0.318192,	-1.946601,1.1784,0.323566,	-1.872927,1.1784,0.629147,
	-1.754764,1.1784,0.912957,	-1.725622,1.323225,0.897795,	-1.841822,1.323225,0.618698,
	-1.841822,1.323225,0.618698,	-1.872927,1.1784,0.629147,	-1.754764,1.1784,0.912957,
	-1.5959,1.1784,1.17121,	-1.569396,1.323225,1.151759,	-1.725622,1.323225,0.897795,
	-1.725622,1.323225,0.897795,	-1.754764,1.1784,0.912957,	-1.5959,1.1784,1.17121,
	-1.40012,1.1784,1.40012,	-1.376867,1.323225,1.376868,	-1.569396,1.323225,1.151759,
	-1.569396,1.323225,1.151759,	-1.5959,1.1784,1.17121,	-1.40012,1.1784,1.40012,
	-1.17121,1.1784,1.5959,	-1.151759,1.323225,1.569396,	-1.376867,1.323225,1.376868,
	-1.376867,1.323225,1.376868,	-1.40012,1.1784,1.40012,	-1.17121,1.1784,1.5959,
	-0.912957,1.1784,1.754764,	-0.897795,1.323225,1.725622,	-1.151759,1.323225,1.569396,
	-1.151759,1.323225,1.569396,	-1.17121,1.1784,1.5959,	-0.912957,1.1784,1.754764,
	-0.629147,1.1784,1.872927,	-0.618698,1.323225,1.841822,	-0.897795,1.323225,1.725622,
	-0.897795,1.323225,1.725622,	-0.912957,1.1784,1.754764,	-0.629147,1.1784,1.872927,
	-0.323566,1.1784,1.946601,	-0.318192,1.323225,1.914272,	-0.618698,1.323225,1.841822,
	-0.618698,1.323225,1.841822,	-0.629147,1.1784,1.872927,	-0.323566,1.1784,1.946601,
	0,1.1784,1.972,	0,1.323225,1.93925,	-0.318192,1.323225,1.914272,
	-0.318192,1.323225,1.914272,	-0.323566,1.1784,1.946601,	0,1.1784,1.972,
	-1.967083,1.037175,0.32697,	-1.946601,1.1784,0.323566,	-1.972,1.1784,0,
	-1.972,1.1784,0,	-1.99275,1.037175,0,	-1.967083,1.037175,0.32697,
	-1.892634,1.037175,0.635767,	-1.872927,1.1784,0.629147,	-1.946601,1.1784,0.323566,
	-1.946601,1.1784,0.323566,	-1.967083,1.037175,0.32697,	-1.892634,1.037175,0.635767,
	-1.773229,1.037175,0.922564,	-1.754764,1.1784,0.912957,	-1.872927,1.1784,0.629147,
	-1.872927,1.1784,0.629147,	-1.892634,1.037175,0.635767,	-1.773229,1.037175,0.922564,
	-1.612693,1.037175,1.183534,	-1.5959,1.1784,1.17121,	-1.754764,1.1784,0.912957,
	-1.754764,1.1784,0.912957,	-1.773229,1.037175,0.922564,	-1.612693,1.037175,1.183534,
	-1.414853,1.037175,1.414853,	-1.40012,1.1784,1.40012,	-1.5959,1.1784,1.17121,
	-1.5959,1.1784,1.17121,	-1.612693,1.037175,1.183534,	-1.414853,1.037175,1.414853,
	-1.183534,1.037175,1.612693,	-1.17121,1.1784,1.5959,	-1.40012,1.1784,1.40012,
	-1.40012,1.1784,1.40012,	-1.414853,1.037175,1.414853,	-1.183534,1.037175,1.612693,
	-0.922564,1.037175,1.773229,	-0.912957,1.1784,1.754764,	-1.17121,1.1784,1.5959,
	-1.17121,1.1784,1.5959,	-1.183534,1.037175,1.612693,	-0.922564,1.037175,1.773229,
	-0.635767,1.037175,1.892634,	-0.629147,1.1784,1.872927,	-0.912957,1.1784,1.754764,
	-0.912957,1.1784,1.754764,	-0.922564,1.037175,1.773229,	-0.635767,1.037175,1.892634,
	-0.32697,1.037175,1.967083,	-0.323566,1.1784,1.946601,	-0.629147,1.1784,1.872927,
	-0.629147,1.1784,1.872927,	-0.635767,1.037175,1.892634,	-0.32697,1.037175,1.967083,
	0,1.037175,1.99275,	0,1.1784,1.972,	-0.323566,1.1784,1.946601,
	-0.323566,1.1784,1.946601,	-0.32697,1.037175,1.967083,	0,1.037175,1.99275,
	-1.97424,0.9,0.32816,	-1.967083,1.037175,0.32697,	-1.99275,1.037175,0,
	-1.99275,1.037175,0,	-2,0.9,0,	-1.97424,0.9,0.32816,
	-1.89952,0.9,0.63808,	-1.892634,1.037175,0.635767,	-1.967083,1.037175,0.32697,
	-1.967083,1.037175,0.32697,	-1.97424,0.9,0.32816,	-1.89952,0.9,0.63808,
	-1.77968,0.9,0.92592,	-1.773229,1.037175,0.922564,	-1.892634,1.037175,0.635767,
	-1.892634,1.037175,0.635767,	-1.89952,0.9,0.63808,	-1.77968,0.9,0.92592,
	-1.61856,0.9,1.18784,	-1.612693,1.037175,1.183534,	-1.773229,1.037175,0.922564,
	-1.773229,1.037175,0.922564,	-1.77968,0.9,0.92592,	-1.61856,0.9,1.18784,
	-1.42,0.9,1.42,	-1.414853,1.037175,1.414853,	-1.612693,1.037175,1.183534,
	-1.612693,1.037175,1.183534,	-1.61856,0.9,1.18784,	-1.42,0.9,1.42,
	-1.18784,0.9,1.61856,	-1.183534,1.037175,1.612693,	-1.414853,1.037175,1.414853,
	-1.414853,1.037175,1.414853,	-1.42,0.9,1.42,	-1.18784,0.9,1.61856,
	-0.92592,0.9,1.77968,	-0.922564,1.037175,1.773229,	-1.183534,1.037175,1.612693,
	-1.183534,1.037175,1.612693,	-1.18784,0.9,1.61856,	-0.92592,0.9,1.77968,
	-0.63808,0.9,1.89952,	-0.635767,1.037175,1.892634,	-0.922564,1.037175,1.773229,
	-0.922564,1.037175,1.773229,	-0.92592,0.9,1.77968,	-0.63808,0.9,1.89952,
	-0.32816,0.9,1.97424,	-0.32697,1.037175,1.967083,	-0.635767,1.037175,1.892634,
	-0.635767,1.037175,1.892634,	-0.63808,0.9,1.89952,	-0.32816,0.9,1.97424,
	0,0.9,2,	0,1.037175,1.99275,	-0.32697,1.037175,1.967083,
	-0.32697,1.037175,1.967083,	-0.32816,0.9,1.97424,	0,0.9,2,
	0.258385,2.242575,1.554467,	0.24612,2.4,1.48068,	0,2.4,1.5,
	0,2.4,1.5,	0,2.242575,1.57475,	0.258385,2.242575,1.554467,
	0.502408,2.242575,1.495635,	0.47856,2.4,1.42464,	0.24612,2.4,1.48068,
	0.24612,2.4,1.48068,	0.258385,2.242575,1.554467,	0.502408,2.242575,1.495635,
	0.729046,2.242575,1.401276,	0.69444,2.4,1.33476,	0.47856,2.4,1.42464,
	0.47856,2.4,1.42464,	0.502408,2.242575,1.495635,	0.729046,2.242575,1.401276,
	0.935276,2.242575,1.274414,	0.89088,2.4,1.21392,	0.69444,2.4,1.33476,
	0.69444,2.4,1.33476,	0.729046,2.242575,1.401276,	0.935276,2.242575,1.274414,
	1.118073,2.242575,1.118073,	1.065,2.4,1.065,	0.89088,2.4,1.21392,
	0.89088,2.4,1.21392,	0.935276,2.242575,1.274414,	1.118073,2.242575,1.118073,
	1.274414,2.242575,0.935276,	1.21392,2.4,0.89088,	1.065,2.4,1.065,
	1.065,2.4,1.065,	1.118073,2.242575,1.118073,	1.274414,2.242575,0.935276,
	1.401276,2.242575,0.729046,	1.33476,2.4,0.69444,	1.21392,2.4,0.89088,
	1.21392,2.4,0.89088,	1.274414,2.242575,0.935276,	1.401276,2.242575,0.729046,
	1.495635,2.242575,0.502408,	1.42464,2.4,0.47856,	1.33476,2.4,0.69444,
	1.33476,2.4,0.69444,	1.401276,2.242575,0.729046,	1.495635,2.242575,0.502408,
	1.554467,2.242575,0.258385,	1.48068,2.4,0.24612,	1.42464,2.4,0.47856,
	1.42464,2.4,0.47856,	1.495635,2.242575,0.502408,	1.554467,2.242575,0.258385,
	1.57475,2.242575,0,	1.5,2.4,0,	1.48068,2.4,0.24612,
	1.48068,2.4,0.24612,	1.554467,2.242575,0.258385,	1.57475,2.242575,0,
	0.270404,2.0856,1.626774,	0.258385,2.242575,1.554467,	0,2.242575,1.57475,
	0,2.242575,1.57475,	0,2.0856,1.648,	0.270404,2.0856,1.626774,
	0.525778,2.0856,1.565204,	0.502408,2.242575,1.495635,	0.258385,2.242575,1.554467,
	0.258385,2.242575,1.554467,	0.270404,2.0856,1.626774,	0.525778,2.0856,1.565204,
	0.762958,2.0856,1.466456,	0.729046,2.242575,1.401276,	0.502408,2.242575,1.495635,
	0.502408,2.242575,1.495635,	0.525778,2.0856,1.565204,	0.762958,2.0856,1.466456,
	0.97878,2.0856,1.333693,	0.935276,2.242575,1.274414,	0.729046,2.242575,1.401276,
	0.729046,2.242575,1.401276,	0.762958,2.0856,1.466456,	0.97878,2.0856,1.333693,
	1.17008,2.0856,1.17008,	1.118073,2.242575,1.118073,	0.935276,2.242575,1.274414,
	0.935276,2.242575,1.274414,	0.97878,2.0856,1.333693,	1.17008,2.0856,1.17008,
	1.333693,2.0856,0.97878,	1.274414,2.242575,0.935276,	1.118073,2.242575,1.118073,
	1.118073,2.242575,1.118073,	1.17008,2.0856,1.17008,	1.333693,2.0856,0.97878,
	1.466456,2.0856,0.762958,	1.401276,2.242575,0.729046,	1.274414,2.242575,0.935276,
	1.274414,2.242575,0.935276,	1.333693,2.0856,0.97878,	1.466456,2.0856,0.762958,
	1.565204,2.0856,0.525778,	1.495635,2.242575,0.502408,	1.401276,2.242575,0.729046,
	1.401276,2.242575,0.729046,	1.466456,2.0856,0.762958,	1.565204,2.0856,0.525778,
	1.626774,2.0856,0.270404,	1.554467,2.242575,0.258385,	1.495635,2.242575,0.502408,
	1.495635,2.242575,0.502408,	1.565204,2.0856,0.525778,	1.626774,2.0856,0.270404,
	1.648,2.0856,0,	1.57475,2.242575,0,	1.554467,2.242575,0.258385,
	1.554467,2.242575,0.258385,	1.626774,2.0856,0.270404,	1.648,2.0856,0,
	0.28193,1.929525,1.696119,	0.270404,2.0856,1.626774,	0,2.0856,1.648,
	0,2.0856,1.648,	0,1.929525,1.71825,	0.28193,1.929525,1.696119,
	0.54819,1.929525,1.631925,	0.525778,2.0856,1.565204,	0.270404,2.0856,1.626774,
	0.270404,2.0856,1.626774,	0.28193,1.929525,1.696119,	0.54819,1.929525,1.631925,
	0.795481,1.929525,1.528968,	0.762958,2.0856,1.466456,	0.525778,2.0856,1.565204,
	0.525778,2.0856,1.565204,	0.54819,1.929525,1.631925,	0.795481,1.929525,1.528968,
	1.020503,1.929525,1.390545,	0.97878,2.0856,1.333693,	0.762958,2.0856,1.466456,
	0.762958,2.0856,1.466456,	0.795481,1.929525,1.528968,	1.020503,1.929525,1.390545,
	1.219958,1.929525,1.219958,	1.17008,2.0856,1.17008,	0.97878,2.0856,1.333693,
	0.97878,2.0856,1.333693,	1.020503,1.929525,1.390545,	1.219958,1.929525,1.219958,
	1.390545,1.929525,1.020503,	1.333693,2.0856,0.97878,	1.17008,2.0856,1.17008,
	1.17008,2.0856,1.17008,	1.219958,1.929525,1.219958,	1.390545,1.929525,1.020503,
	1.528968,1.929525,0.795481,	1.466456,2.0856,0.762958,	1.333693,2.0856,0.97878,
	1.333693,2.0856,0.97878,	1.390545,1.929525,1.020503,	1.528968,1.929525,0.795481,
	1.631925,1.929525,0.54819,	1.565204,2.0856,0.525778,	1.466456,2.0856,0.762958,
	1.466456,2.0856,0.762958,	1.528968,1.929525,0.795481,	1.631925,1.929525,0.54819,
	1.696119,1.929525,0.28193,	1.626774,2.0856,0.270404,	1.565204,2.0856,0.525778,
	1.565204,2.0856,0.525778,	1.631925,1.929525,0.54819,	1.696119,1.929525,0.28193,
	1.71825,1.929525,0,	1.648,2.0856,0,	1.626774,2.0856,0.270404,
	1.626774,2.0856,0.270404,	1.696119,1.929525,0.28193,	1.71825,1.929525,0,
	0.292719,1.7748,1.761022,	0.28193,1.929525,1.696119,	0,1.929525,1.71825,
	0,1.929525,1.71825,	0,1.7748,1.784,	0.292719,1.7748,1.761022,
	0.569167,1.7748,1.694372,	0.54819,1.929525,1.631925,	0.28193,1.929525,1.696119,
	0.28193,1.929525,1.696119,	0.292719,1.7748,1.761022,	0.569167,1.7748,1.694372,
	0.825921,1.7748,1.587475,	0.795481,1.929525,1.528968,	0.54819,1.929525,1.631925,
	0.54819,1.929525,1.631925,	0.569167,1.7748,1.694372,	0.825921,1.7748,1.587475,
	1.059553,1.7748,1.443756,	1.020503,1.929525,1.390545,	0.795481,1.929525,1.528968,
	0.795481,1.929525,1.528968,	0.825921,1.7748,1.587475,	1.059553,1.7748,1.443756,
	1.26664,1.7748,1.26664,	1.219958,1.929525,1.219958,	1.020503,1.929525,1.390545,
	1.020503,1.929525,1.390545,	1.059553,1.7748,1.443756,	1.26664,1.7748,1.26664,
	1.443756,1.7748,1.059553,	1.390545,1.929525,1.020503,	1.219958,1.929525,1.219958,
	1.219958,1.929525,1.219958,	1.26664,1.7748,1.26664,	1.443756,1.7748,1.059553,
	1.587475,1.7748,0.825921,	1.528968,1.929525,0.795481,	1.390545,1.929525,1.020503,
	1.390545,1.929525,1.020503,	1.443756,1.7748,1.059553,	1.587475,1.7748,0.825921,
	1.694372,1.7748,0.569167,	1.631925,1.929525,0.54819,	1.528968,1.929525,0.795481,
	1.528968,1.929525,0.795481,	1.587475,1.7748,0.825921,	1.694372,1.7748,0.569167,
	1.761022,1.7748,0.292719,	1.696119,1.929525,0.28193,	1.631925,1.929525,0.54819,
	1.631925,1.929525,0.54819,	1.694372,1.7748,0.569167,	1.761022,1.7748,0.292719,
	1.784,1.7748,0,	1.71825,1.929525,0,	1.696119,1.929525,0.28193,
	1.696119,1.929525,0.28193,	1.761022,1.7748,0.292719,	1.784,1.7748,0,
	0.302523,1.621875,1.820003,	0.292719,1.7748,1.761022,	0,1.7748,1.784,
	0,1.7748,1.784,	0,1.621875,1.84375,	0.302523,1.621875,1.820003,
	0.58823,1.621875,1.75112,	0.569167,1.7748,1.694372,	0.292719,1.7748,1.761022,
	0.292719,1.7748,1.761022,	0.302523,1.621875,1.820003,	0.58823,1.621875,1.75112,
	0.853583,1.621875,1.640643,	0.825921,1.7748,1.587475,	0.569167,1.7748,1.694372,
	0.569167,1.7748,1.694372,	0.58823,1.621875,1.75112,	0.853583,1.621875,1.640643,
	1.09504,1.621875,1.49211,	1.059553,1.7748,1.443756,	0.825921,1.7748,1.587475,
	0.825921,1.7748,1.587475,	0.853583,1.621875,1.640643,	1.09504,1.621875,1.49211,
	1.309063,1.621875,1.309063,	1.26664,1.7748,1.26664,	1.059553,1.7748,1.443756,
	1.059553,1.7748,1.443756,	1.09504,1.621875,1.49211,	1.309063,1.621875,1.309063,
	1.49211,1.621875,1.09504,	1.443756,1.7748,1.059553,	1.26664,1.7748,1.26664,
	1.26664,1.7748,1.26664,	1.309063,1.621875,1.309063,	1.49211,1.621875,1.09504,
	1.640643,1.621875,0.853583,	1.587475,1.7748,0.825921,	1.443756,1.7748,1.059553,
	1.443756,1.7748,1.059553,	1.49211,1.621875,1.09504,	1.640643,1.621875,0.853583,
	1.75112,1.621875,0.58823,	1.694372,1.7748,0.569167,	1.587475,1.7748,0.825921,
	1.587475,1.7748,0.825921,	1.640643,1.621875,0.853583,	1.75112,1.621875,0.58823,
	1.820003,1.621875,0.302522,	1.761022,1.7748,0.292719,	1.694372,1.7748,0.569167,
	1.694372,1.7748,0.569167,	1.75112,1.621875,0.58823,	1.820003,1.621875,0.302522,
	1.84375,1.621875,0,	1.784,1.7748,0,	1.761022,1.7748,0.292719,
	1.761022,1.7748,0.292719,	1.820003,1.621875,0.302522,	1.84375,1.621875,0,
	0.311096,1.4712,1.87158,	0.302523,1.621875,1.820003,	0,1.621875,1.84375,
	0,1.621875,1.84375,	0,1.4712,1.896,	0.311096,1.4712,1.87158,
	0.6049,1.4712,1.800745,	0.58823,1.621875,1.75112,	0.302523,1.621875,1.820003,
	0.302523,1.621875,1.820003,	0.311096,1.4712,1.87158,	0.6049,1.4712,1.800745,
	0.877772,1.4712,1.687137,	0.853583,1.621875,1.640643,	0.58823,1.621875,1.75112,
	0.58823,1.621875,1.75112,	0.6049,1.4712,1.800745,	0.877772,1.4712,1.687137,
	1.126072,1.4712,1.534395,	1.09504,1.621875,1.49211,	0.853583,1.621875,1.640643,
	0.853583,1.621875,1.640643,	0.877772,1.4712,1.687137,	1.126072,1.4712,1.534395,
	1.34616,1.4712,1.34616,	1.309063,1.621875,1.309063,	1.09504,1.621875,1.49211,
	1.09504,1.621875,1.49211,	1.126072,1.4712,1.534395,	1.34616,1.4712,1.34616,
	1.534395,1.4712,1.126072,	1.49211,1.621875,1.09504,	1.309063,1.621875,1.309063,
	1.309063,1.621875,1.309063,	1.34616,1.4712,1.34616,	1.534395,1.4712,1.126072,
	1.687137,1.4712,0.877772,	1.640643,1.621875,0.853583,	1.49211,1.621875,1.09504,
	1.49211,1.621875,1.09504,	1.534395,1.4712,1.126072,	1.687137,1.4712,0.877772,
	1.800745,1.4712,0.6049,	1.75112,1.621875,0.58823,	1.640643,1.621875,0.853583,
	1.640643,1.621875,0.853583,	1.687137,1.4712,0.877772,	1.800745,1.4712,0.6049,
	1.87158,1.4712,0.311096,	1.820003,1.621875,0.302522,	1.75112,1.621875,0.58823,
	1.75112,1.621875,0.58823,	1.800745,1.4712,0.6049,	1.87158,1.4712,0.311096,
	1.896,1.4712,0,	1.84375,1.621875,0,	1.820003,1.621875,0.302522,
	1.820003,1.621875,0.302522,	1.87158,1.4712,0.311096,	1.896,1.4712,0,
	0.318192,1.323225,1.914272,	0.311096,1.4712,1.87158,	0,1.4712,1.896,
	0,1.4712,1.896,	0,1.323225,1.93925,	0.318192,1.323225,1.914272,
	0.618698,1.323225,1.841822,	0.6049,1.4712,1.800745,	0.311096,1.4712,1.87158,
	0.311096,1.4712,1.87158,	0.318192,1.323225,1.914272,	0.618698,1.323225,1.841822,
	0.897795,1.323225,1.725622,	0.877772,1.4712,1.687137,	0.6049,1.4712,1.800745,
	0.6049,1.4712,1.800745,	0.618698,1.323225,1.841822,	0.897795,1.323225,1.725622,
	1.151759,1.323225,1.569396,	1.126072,1.4712,1.534395,	0.877772,1.4712,1.687137,
	0.877772,1.4712,1.687137,	0.897795,1.323225,1.725622,	1.151759,1.323225,1.569396,
	1.376868,1.323225,1.376867,	1.34616,1.4712,1.34616,	1.126072,1.4712,1.534395,
	1.126072,1.4712,1.534395,	1.151759,1.323225,1.569396,	1.376868,1.323225,1.376867,
	1.569396,1.323225,1.151759,	1.534395,1.4712,1.126072,	1.34616,1.4712,1.34616,
	1.34616,1.4712,1.34616,	1.376868,1.323225,1.376867,	1.569396,1.323225,1.151759,
	1.725622,1.323225,0.897795,	1.687137,1.4712,0.877772,	1.534395,1.4712,1.126072,
	1.534395,1.4712,1.126072,	1.569396,1.323225,1.151759,	1.725622,1.323225,0.897795,
	1.841822,1.323225,0.618698,	1.800745,1.4712,0.6049,	1.687137,1.4712,0.877772,
	1.687137,1.4712,0.877772,	1.725622,1.323225,0.897795,	1.841822,1.323225,0.618698,
	1.914272,1.323225,0.318192,	1.87158,1.4712,0.311096,	1.800745,1.4712,0.6049,
	1.800745,1.4712,0.6049,	1.841822,1.323225,0.618698,	1.914272,1.323225,0.318192,
	1.93925,1.323225,0,	1.896,1.4712,0,	1.87158,1.4712,0.311096,
	1.87158,1.4712,0.311096,	1.914272,1.323225,0.318192,	1.93925,1.323225,0,
	0.323566,1.1784,1.946601,	0.318192,1.323225,1.914272,	0,1.323225,1.93925,
	0,1.323225,1.93925,	0,1.1784,1.972,	0.323566,1.1784,1.946601,
	0.629147,1.1784,1.872927,	0.618698,1.323225,1.841822,	0.318192,1.323225,1.914272,
	0.318192,1.323225,1.914272,	0.323566,1.1784,1.946601,	0.629147,1.1784,1.872927,
	0.912957,1.1784,1.754764,	0.897795,1.323225,1.725622,	0.618698,1.323225,1.841822,
	0.618698,1.323225,1.841822,	0.629147,1.1784,1.872927,	0.912957,1.1784,1.754764,
	1.17121,1.1784,1.5959,	1.151759,1.323225,1.569396,	0.897795,1.323225,1.725622,
	0.897795,1.323225,1.725622,	0.912957,1.1784,1.754764,	1.17121,1.1784,1.5959,
	1.40012,1.1784,1.40012,	1.376868,1.323225,1.376867,	1.151759,1.323225,1.569396,
	1.151759,1.323225,1.569396,	1.17121,1.1784,1.5959,	1.40012,1.1784,1.40012,
	1.5959,1.1784,1.17121,	1.569396,1.323225,1.151759,	1.376868,1.323225,1.376867,
	1.376868,1.323225,1.376867,	1.40012,1.1784,1.40012,	1.5959,1.1784,1.17121,
	1.754764,1.1784,0.912957,	1.725622,1.323225,0.897795,	1.569396,1.323225,1.151759,
	1.569396,1.323225,1.151759,	1.5959,1.1784,1.17121,	1.754764,1.1784,0.912957,
	1.872927,1.1784,0.629147,	1.841822,1.323225,0.618698,	1.725622,1.323225,0.897795,
	1.725622,1.323225,0.897795,	1.754764,1.1784,0.912957,	1.872927,1.1784,0.629147,
	1.946601,1.1784,0.323566,	1.914272,1.323225,0.318192,	1.841822,1.323225,0.618698,
	1.841822,1.323225,0.618698,	1.872927,1.1784,0.629147,	1.946601,1.1784,0.323566,
	1.972,1.1784,0,	1.93925,1.323225,0,	1.914272,1.323225,0.318192,
	1.914272,1.323225,0.318192,	1.946601,1.1784,0.323566,	1.972,1.1784,0,
	0.32697,1.037175,1.967083,	0.323566,1.1784,1.946601,	0,1.1784,1.972,
	0,1.1784,1.972,	0,1.037175,1.99275,	0.32697,1.037175,1.967083,
	0.635767,1.037175,1.892634,	0.629147,1.1784,1.872927,	0.323566,1.1784,1.946601,
	0.323566,1.1784,1.946601,	0.32697,1.037175,1.967083,	0.635767,1.037175,1.892634,
	0.922564,1.037175,1.773229,	0.912957,1.1784,1.754764,	0.629147,1.1784,1.872927,
	0.629147,1.1784,1.872927,	0.635767,1.037175,1.892634,	0.922564,1.037175,1.773229,
	1.183534,1.037175,1.612693,	1.17121,1.1784,1.5959,	0.912957,1.1784,1.754764,
	0.912957,1.1784,1.754764,	0.922564,1.037175,1.773229,	1.183534,1.037175,1.612693,
	1.414853,1.037175,1.414853,	1.40012,1.1784,1.40012,	1.17121,1.1784,1.5959,
	1.17121,1.1784,1.5959,	1.183534,1.037175,1.612693,	1.414853,1.037175,1.414853,
	1.612693,1.037175,1.183534,	1.5959,1.1784,1.17121,	1.40012,1.1784,1.40012,
	1.40012,1.1784,1.40012,	1.414853,1.037175,1.414853,	1.612693,1.037175,1.183534,
	1.773229,1.037175,0.922564,	1.754764,1.1784,0.912957,	1.5959,1.1784,1.17121,
	1.5959,1.1784,1.17121,	1.612693,1.037175,1.183534,	1.773229,1.037175,0.922564,
	1.892634,1.037175,0.635767,	1.872927,1.1784,0.629147,	1.754764,1.1784,0.912957,
	1.754764,1.1784,0.912957,	1.773229,1.037175,0.922564,	1.892634,1.037175,0.635767,
	1.967083,1.037175,0.32697,	1.946601,1.1784,0.323566,	1.872927,1.1784,0.629147,
	1.872927,1.1784,0.629147,	1.892634,1.037175,0.635767,	1.967083,1.037175,0.32697,
	1.99275,1.037175,0,	1.972,1.1784,0,	1.946601,1.1784,0.323566,
	1.946601,1.1784,0.323566,	1.967083,1.037175,0.32697,	1.99275,1.037175,0,
	0.32816,0.9,1.97424,	0.32697,1.037175,1.967083,	0,1.037175,1.99275,
	0,1.037175,1.99275,	0,0.9,2,	0.32816,0.9,1.97424,
	0.63808,0.9,1.89952,	0.635767,1.037175,1.892634,	0.32697,1.037175,1.967083,
	0.32697,1.037175,1.967083,	0.32816,0.9,1.97424,	0.63808,0.9,1.89952,
	0.92592,0.9,1.77968,	0.922564,1.037175,1.773229,	0.635767,1.037175,1.892634,
	0.635767,1.037175,1.892634,	0.63808,0.9,1.89952,	0.92592,0.9,1.77968,
	1.18784,0.9,1.61856,	1.183534,1.037175,1.612693,	0.922564,1.037175,1.773229,
	0.922564,1.037175,1.773229,	0.92592,0.9,1.77968,	1.18784,0.9,1.61856,
	1.42,0.9,1.42,	1.414853,1.037175,1.414853,	1.183534,1.037175,1.612693,
	1.183534,1.037175,1.612693,	1.18784,0.9,1.61856,	1.42,0.9,1.42,
	1.61856,0.9,1.18784,	1.612693,1.037175,1.183534,	1.414853,1.037175,1.414853,
	1.414853,1.037175,1.414853,	1.42,0.9,1.42,	1.61856,0.9,1.18784,
	1.77968,0.9,0.92592,	1.773229,1.037175,0.922564,	1.612693,1.037175,1.183534,
	1.612693,1.037175,1.183534,	1.61856,0.9,1.18784,	1.77968,0.9,0.92592,
	1.89952,0.9,0.63808,	1.892634,1.037175,0.635767,	1.773229,1.037175,0.922564,
	1.773229,1.037175,0.922564,	1.77968,0.9,0.92592,	1.89952,0.9,0.63808,
	1.97424,0.9,0.32816,	1.967083,1.037175,0.32697,	1.892634,1.037175,0.635767,
	1.892634,1.037175,0.635767,	1.89952,0.9,0.63808,	1.97424,0.9,0.32816,
	2,0.9,0,	1.99275,1.037175,0,	1.967083,1.037175,0.32697,
	1.967083,1.037175,0.32697,	1.97424,0.9,0.32816,	2,0.9,0,
	1.96042,0.771675,-0.325863,	1.97424,0.9,-0.32816,	2,0.9,0,
	2,0.9,0,	1.986,0.771675,0,	1.96042,0.771675,-0.325863,
	1.886223,0.771675,-0.633613,	1.89952,0.9,-0.63808,	1.97424,0.9,-0.32816,
	1.97424,0.9,-0.32816,	1.96042,0.771675,-0.325863,	1.886223,0.771675,-0.633613,
	1.767222,0.771675,-0.919439,	1.77968,0.9,-0.92592,	1.89952,0.9,-0.63808,
	1.89952,0.9,-0.63808,	1.886223,0.771675,-0.633613,	1.767222,0.771675,-0.919439,
	1.60723,0.771675,-1.179525,	1.61856,0.9,-1.18784,	1.77968,0.9,-0.92592,
	1.77968,0.9,-0.92592,	1.767222,0.771675,-0.919439,	1.60723,0.771675,-1.179525,
	1.41006,0.771675,-1.41006,	1.42,0.9,-1.42,	1.61856,0.9,-1.18784,
	1.61856,0.9,-1.18784,	1.60723,0.771675,-1.179525,	1.41006,0.771675,-1.41006,
	1.179525,0.771675,-1.60723,	1.18784,0.9,-1.61856,	1.42,0.9,-1.42,
	1.42,0.9,-1.42,	1.41006,0.771675,-1.41006,	1.179525,0.771675,-1.60723,
	0.919439,0.771675,-1.767222,	0.92592,0.9,-1.77968,	1.18784,0.9,-1.61856,
	1.18784,0.9,-1.61856,	1.179525,0.771675,-1.60723,	0.919439,0.771675,-1.767222,
	0.633613,0.771675,-1.886223,	0.63808,0.9,-1.89952,	0.92592,0.9,-1.77968,
	0.92592,0.9,-1.77968,	0.919439,0.771675,-1.767222,	0.633613,0.771675,-1.886223,
	0.325863,0.771675,-1.96042,	0.32816,0.9,-1.97424,	0.63808,0.9,-1.89952,
	0.63808,0.9,-1.89952,	0.633613,0.771675,-1.886223,	0.325863,0.771675,-1.96042,
	0,0.771675,-1.986,	0,0.9,-2,	0.32816,0.9,-1.97424,
	0.32816,0.9,-1.97424,	0.325863,0.771675,-1.96042,	0,0.771675,-1.986,
	1.92291,0.6564,-0.319628,	1.96042,0.771675,-0.325863,	1.986,0.771675,0,
	1.986,0.771675,0,	1.948,0.6564,0,	1.92291,0.6564,-0.319628,
	1.850132,0.6564,-0.62149,	1.886223,0.771675,-0.633613,	1.96042,0.771675,-0.325863,
	1.96042,0.771675,-0.325863,	1.92291,0.6564,-0.319628,	1.850132,0.6564,-0.62149,
	1.733408,0.6564,-0.901846,	1.767222,0.771675,-0.919439,	1.886223,0.771675,-0.633613,
	1.886223,0.771675,-0.633613,	1.850132,0.6564,-0.62149,	1.733408,0.6564,-0.901846,
	1.576477,0.6564,-1.156956,	1.60723,0.771675,-1.179525,	1.767222,0.771675,-0.919439,
	1.767222,0.771675,-0.919439,	1.733408,0.6564,-0.901846,	1.576477,0.6564,-1.156956,
	1.38308,0.6564,-1.38308,	1.41006,0.771675,-1.41006,	1.60723,0.771675,-1.179525,
	1.60723,0.771675,-1.179525,	1.576477,0.6564,-1.156956,	1.38308,0.6564,-1.38308,
	1.156956,0.6564,-1.576477,	1.179525,0.771675,-1.60723,	1.41006,0.771675,-1.41006,
	1.41006,0.771675,-1.41006,	1.38308,0.6564,-1.38308,	1.156956,0.6564,-1.576477,
	0.901846,0.6564,-1.733408,	0.919439,0.771675,-1.767222,	1.179525,0.771675,-1.60723,
	1.179525,0.771675,-1.60723,	1.156956,0.6564,-1.576477,	0.901846,0.6564,-1.733408,
	0.62149,0.6564,-1.850132,	0.633613,0.771675,-1.886223,	0.919439,0.771675,-1.767222,
	0.919439,0.771675,-1.767222,	0.901846,0.6564,-1.733408,	0.62149,0.6564,-1.850132,
	0.319628,0.6564,-1.92291,	0.325863,0.771675,-1.96042,	0.633613,0.771675,-1.886223,
	0.633613,0.771675,-1.886223,	0.62149,0.6564,-1.850132,	0.319628,0.6564,-1.92291,
	0,0.6564,-1.948,	0,0.771675,-1.986,	0.325863,0.771675,-1.96042,
	0.325863,0.771675,-1.96042,	0.319628,0.6564,-1.92291,	0,0.6564,-1.948,
	1.867631,0.553725,-0.310439,	1.92291,0.6564,-0.319628,	1.948,0.6564,0,
	1.948,0.6564,0,	1.892,0.553725,0,	1.867631,0.553725,-0.310439,
	1.796946,0.553725,-0.603624,	1.850132,0.6564,-0.62149,	1.92291,0.6564,-0.319628,
	1.92291,0.6564,-0.319628,	1.867631,0.553725,-0.310439,	1.796946,0.553725,-0.603624,
	1.683577,0.553725,-0.87592,	1.733408,0.6564,-0.901846,	1.850132,0.6564,-0.62149,
	1.850132,0.6564,-0.62149,	1.796946,0.553725,-0.603624,	1.683577,0.553725,-0.87592,
	1.531158,0.553725,-1.123697,	1.576477,0.6564,-1.156956,	1.733408,0.6564,-0.901846,
	1.733408,0.6564,-0.901846,	1.683577,0.553725,-0.87592,	1.531158,0.553725,-1.123697,
	1.34332,0.553725,-1.34332,	1.38308,0.6564,-1.38308,	1.576477,0.6564,-1.156956,
	1.576477,0.6564,-1.156956,	1.531158,0.553725,-1.123697,	1.34332,0.553725,-1.34332,
	1.123697,0.553725,-1.531158,	1.156956,0.6564,-1.576477,	1.38308,0.6564,-1.38308,
	1.38308,0.6564,-1.38308,	1.34332,0.553725,-1.34332,	1.123697,0.553725,-1.531158,
	0.87592,0.553725,-1.683577,	0.901846,0.6564,-1.733408,	1.156956,0.6564,-1.576477,
	1.156956,0.6564,-1.576477,	1.123697,0.553725,-1.531158,	0.87592,0.553725,-1.683577,
	0.603624,0.553725,-1.796946,	0.62149,0.6564,-1.850132,	0.901846,0.6564,-1.733408,
	0.901846,0.6564,-1.733408,	0.87592,0.553725,-1.683577,	0.603624,0.553725,-1.796946,
	0.310439,0.553725,-1.867631,	0.319628,0.6564,-1.92291,	0.62149,0.6564,-1.850132,
	0.62149,0.6564,-1.850132,	0.603624,0.553725,-1.796946,	0.310439,0.553725,-1.867631,
	0,0.553725,-1.892,	0,0.6564,-1.948,	0.319628,0.6564,-1.92291,
	0.319628,0.6564,-1.92291,	0.310439,0.553725,-1.867631,	0,0.553725,-1.892,
	1.800507,0.4632,-0.299282,	1.867631,0.553725,-0.310439,	1.892,0.553725,0,
	1.892,0.553725,0,	1.824,0.4632,0,	1.800507,0.4632,-0.299282,
	1.732362,0.4632,-0.581929,	1.796946,0.553725,-0.603624,	1.867631,0.553725,-0.310439,
	1.867631,0.553725,-0.310439,	1.800507,0.4632,-0.299282,	1.732362,0.4632,-0.581929,
	1.623068,0.4632,-0.844439,	1.683577,0.553725,-0.87592,	1.796946,0.553725,-0.603624,
	1.796946,0.553725,-0.603624,	1.732362,0.4632,-0.581929,	1.623068,0.4632,-0.844439,
	1.476127,0.4632,-1.08331,	1.531158,0.553725,-1.123697,	1.683577,0.553725,-0.87592,
	1.683577,0.553725,-0.87592,	1.623068,0.4632,-0.844439,	1.476127,0.4632,-1.08331,
	1.29504,0.4632,-1.29504,	1.34332,0.553725,-1.34332,	1.531158,0.553725,-1.123697,
	1.531158,0.553725,-1.123697,	1.476127,0.4632,-1.08331,	1.29504,0.4632,-1.29504,
	1.08331,0.4632,-1.476127,	1.123697,0.553725,-1.531158,	1.34332,0.553725,-1.34332,
	1.34332,0.553725,-1.34332,	1.29504,0.4632,-1.29504,	1.08331,0.4632,-1.476127,
	0.844439,0.4632,-1.623068,	0.87592,0.553725,-1.683577,	1.123697,0.553725,-1.531158,
	1.123697,0.553725,-1.531158,	1.08331,0.4632,-1.476127,	0.844439,0.4632,-1.623068,
	0.581929,0.4632,-1.732362,	0.603624,0.553725,-1.796946,	0.87592,0.553725,-1.683577,
	0.87592,0.553725,-1.683577,	0.844439,0.4632,-1.623068,	0.581929,0.4632,-1.732362,
	0.299282,0.4632,-1.800507,	0.310439,0.553725,-1.867631,	0.603624,0.553725,-1.796946,
	0.603624,0.553725,-1.796946,	0.581929,0.4632,-1.732362,	0.299282,0.4632,-1.800507,
	0,0.4632,-1.824,	0,0.553725,-1.892,	0.310439,0.553725,-1.867631,
	0.310439,0.553725,-1.867631,	0.299282,0.4632,-1.800507,	0,0.4632,-1.824,
	1.72746,0.384375,-0.28714,	1.800507,0.4632,-0.299282,	1.824,0.4632,0,
	1.824,0.4632,0,	1.75,0.384375,0,	1.72746,0.384375,-0.28714,
	1.66208,0.384375,-0.55832,	1.732362,0.4632,-0.581929,	1.800507,0.4632,-0.299282,
	1.800507,0.4632,-0.299282,	1.72746,0.384375,-0.28714,	1.66208,0.384375,-0.55832,
	1.55722,0.384375,-0.81018,	1.623068,0.4632,-0.844439,	1.732362,0.4632,-0.581929,
	1.732362,0.4632,-0.581929,	1.66208,0.384375,-0.55832,	1.55722,0.384375,-0.81018,
	1.41624,0.384375,-1.03936,	1.476127,0.4632,-1.08331,	1.623068,0.4632,-0.844439,
	1.623068,0.4632,-0.844439,	1.55722,0.384375,-0.81018,	1.41624,0.384375,-1.03936,
	1.2425,0.384375,-1.2425,	1.29504,0.4632,-1.29504,	1.476127,0.4632,-1.08331,
	1.476127,0.4632,-1.08331,	1.41624,0.384375,-1.03936,	1.2425,0.384375,-1.2425,
	1.03936,0.384375,-1.41624,	1.08331,0.4632,-1.476127,	1.29504,0.4632,-1.29504,
	1.29504,0.4632,-1.29504,	1.2425,0.384375,-1.2425,	1.03936,0.384375,-1.41624,
	0.81018,0.384375,-1.55722,	0.844439,0.4632,-1.623068,	1.08331,0.4632,-1.476127,
	1.08331,0.4632,-1.476127,	1.03936,0.384375,-1.41624,	0.81018,0.384375,-1.55722,
	0.55832,0.384375,-1.66208,	0.581929,0.4632,-1.732362,	0.844439,0.4632,-1.623068,
	0.844439,0.4632,-1.623068,	0.81018,0.384375,-1.55722,	0.55832,0.384375,-1.66208,
	0.28714,0.384375,-1.72746,	0.299282,0.4632,-1.800507,	0.581929,0.4632,-1.732362,
	0.581929,0.4632,-1.732362,	0.55832,0.384375,-1.66208,	0.28714,0.384375,-1.72746,
	0,0.384375,-1.75,	0,0.4632,-1.824,	0.299282,0.4632,-1.800507,
	0.299282,0.4632,-1.800507,	0.28714,0.384375,-1.72746,	0,0.384375,-1.75,
	1.654413,0.3168,-0.274998,	1.72746,0.384375,-0.28714,	1.75,0.384375,0,
	1.75,0.384375,0,	1.676,0.3168,0,	1.654413,0.3168,-0.274998,
	1.591798,0.3168,-0.534711,	1.66208,0.384375,-0.55832,	1.72746,0.384375,-0.28714,
	1.72746,0.384375,-0.28714,	1.654413,0.3168,-0.274998,	1.591798,0.3168,-0.534711,
	1.491372,0.3168,-0.775921,	1.55722,0.384375,-0.81018,	1.66208,0.384375,-0.55832,
	1.66208,0.384375,-0.55832,	1.591798,0.3168,-0.534711,	1.491372,0.3168,-0.775921,
	1.356353,0.3168,-0.99541,	1.41624,0.384375,-1.03936,	1.55722,0.384375,-0.81018,
	1.55722,0.384375,-0.81018,	1.491372,0.3168,-0.775921,	1.356353,0.3168,-0.99541,
	1.18996,0.3168,-1.18996,	1.2425,0.384375,-1.2425,	1.41624,0.384375,-1.03936,
	1.41624,0.384375,-1.03936,	1.356353,0.3168,-0.99541,	1.18996,0.3168,-1.18996,
	0.99541,0.3168,-1.356353,	1.03936,0.384375,-1.41624,	1.2425,0.384375,-1.2425,
	1.2425,0.384375,-1.2425,	1.18996,0.3168,-1.18996,	0.99541,0.3168,-1.356353,
	0.775921,0.3168,-1.491372,	0.81018,0.384375,-1.55722,	1.03936,0.384375,-1.41624,
	1.03936,0.384375,-1.41624,	0.99541,0.3168,-1.356353,	0.775921,0.3168,-1.491372,
	0.534711,0.3168,-1.591798,	0.55832,0.384375,-1.66208,	0.81018,0.384375,-1.55722,
	0.81018,0.384375,-1.55722,	0.775921,0.3168,-1.491372,	0.534711,0.3168,-1.591798,
	0.274998,0.3168,-1.654413,	0.28714,0.384375,-1.72746,	0.55832,0.384375,-1.66208,
	0.55832,0.384375,-1.66208,	0.534711,0.3168,-1.591798,	0.274998,0.3168,-1.654413,
	0,0.3168,-1.676,	0,0.384375,-1.75,	0.28714,0.384375,-1.72746,
	0.28714,0.384375,-1.72746,	0.274998,0.3168,-1.654413,	0,0.3168,-1.676,
	1.587289,0.260025,-0.263841,	1.654413,0.3168,-0.274998,	1.676,0.3168,0,
	1.676,0.3168,0,	1.608,0.260025,0,	1.587289,0.260025,-0.263841,
	1.527214,0.260025,-0.513016,	1.591798,0.3168,-0.534711,	1.654413,0.3168,-0.274998,
	1.654413,0.3168,-0.274998,	1.587289,0.260025,-0.263841,	1.527214,0.260025,-0.513016,
	1.430863,0.260025,-0.74444,	1.491372,0.3168,-0.775921,	1.591798,0.3168,-0.534711,
	1.591798,0.3168,-0.534711,	1.527214,0.260025,-0.513016,	1.430863,0.260025,-0.74444,
	1.301322,0.260025,-0.955023,	1.356353,0.3168,-0.99541,	1.491372,0.3168,-0.775921,
	1.491372,0.3168,-0.775921,	1.430863,0.260025,-0.74444,	1.301322,0.260025,-0.955023,
	1.14168,0.260025,-1.14168,	1.18996,0.3168,-1.18996,	1.356353,0.3168,-0.99541,
	1.356353,0.3168,-0.99541,	1.301322,0.260025,-0.955023,	1.14168,0.260025,-1.14168,
	0.955023,0.260025,-1.301322,	0.99541,0.3168,-1.356353,	1.18996,0.3168,-1.18996,
	1.18996,0.3168,-1.18996,	1.14168,0.260025,-1.14168,	0.955023,0.260025,-1.301322,
	0.74444,0.260025,-1.430863,	0.775921,0.3168,-1.491372,	0.99541,0.3168,-1.356353,
	0.99541,0.3168,-1.356353,	0.955023,0.260025,-1.301322,	0.74444,0.260025,-1.430863,
	0.513016,0.260025,-1.527214,	0.534711,0.3168,-1.591798,	0.775921,0.3168,-1.491372,
	0.775921,0.3168,-1.491372,	0.74444,0.260025,-1.430863,	0.513016,0.260025,-1.527214,
	0.263841,0.260025,-1.587289,	0.274998,0.3168,-1.654413,	0.534711,0.3168,-1.591798,
	0.534711,0.3168,-1.591798,	0.513016,0.260025,-1.527214,	0.263841,0.260025,-1.587289,
	0,0.260025,-1.608,	0,0.3168,-1.676,	0.274998,0.3168,-1.654413,
	0.274998,0.3168,-1.654413,	0.263841,0.260025,-1.587289,	0,0.260025,-1.608,
	1.53201,0.2136,-0.254652,	1.587289,0.260025,-0.263841,	1.608,0.260025,0,
	1.608,0.260025,0,	1.552,0.2136,0,	1.53201,0.2136,-0.254652,
	1.474028,0.2136,-0.49515,	1.527214,0.260025,-0.513016,	1.587289,0.260025,-0.263841,
	1.587289,0.260025,-0.263841,	1.53201,0.2136,-0.254652,	1.474028,0.2136,-0.49515,
	1.381032,0.2136,-0.718514,	1.430863,0.260025,-0.74444,	1.527214,0.260025,-0.513016,
	1.527214,0.260025,-0.513016,	1.474028,0.2136,-0.49515,	1.381032,0.2136,-0.718514,
	1.256003,0.2136,-0.921764,	1.301322,0.260025,-0.955023,	1.430863,0.260025,-0.74444,
	1.430863,0.260025,-0.74444,	1.381032,0.2136,-0.718514,	1.256003,0.2136,-0.921764,
	1.10192,0.2136,-1.10192,	1.14168,0.260025,-1.14168,	1.301322,0.260025,-0.955023,
	1.301322,0.260025,-0.955023,	1.256003,0.2136,-0.921764,	1.10192,0.2136,-1.10192,
	0.921764,0.2136,-1.256003,	0.955023,0.260025,-1.301322,	1.14168,0.260025,-1.14168,
	1.14168,0.260025,-1.14168,	1.10192,0.2136,-1.10192,	0.921764,0.2136,-1.256003,
	0.718514,0.2136,-1.381032,	0.74444,0.260025,-1.430863,	0.955023,0.260025,-1.301322,
	0.955023,0.260025,-1.301322,	0.921764,0.2136,-1.256003,	0.718514,0.2136,-1.381032,
	0.49515,0.2136,-1.474028,	0.513016,0.260025,-1.527214,	0.74444,0.260025,-1.430863,
	0.74444,0.260025,-1.430863,	0.718514,0.2136,-1.381032,	0.49515,0.2136,-1.474028,
	0.254652,0.2136,-1.53201,	0.263841,0.260025,-1.587289,	0.513016,0.260025,-1.527214,
	0.513016,0.260025,-1.527214,	0.49515,0.2136,-1.474028,	0.254652,0.2136,-1.53201,
	0,0.2136,-1.552,	0,0.260025,-1.608,	0.263841,0.260025,-1.587289,
	0.263841,0.260025,-1.587289,	0.254652,0.2136,-1.53201,	0,0.2136,-1.552,
	1.4945,0.177075,-0.248417,	1.53201,0.2136,-0.254652,	1.552,0.2136,0,
	1.552,0.2136,0,	1.514,0.177075,0,	1.4945,0.177075,-0.248417,
	1.437937,0.177075,-0.483027,	1.474028,0.2136,-0.49515,	1.53201,0.2136,-0.254652,
	1.53201,0.2136,-0.254652,	1.4945,0.177075,-0.248417,	1.437937,0.177075,-0.483027,
	1.347218,0.177075,-0.700921,	1.381032,0.2136,-0.718514,	1.474028,0.2136,-0.49515,
	1.474028,0.2136,-0.49515,	1.437937,0.177075,-0.483027,	1.347218,0.177075,-0.700921,
	1.22525,0.177075,-0.899195,	1.256003,0.2136,-0.921764,	1.381032,0.2136,-0.718514,
	1.381032,0.2136,-0.718514,	1.347218,0.177075,-0.700921,	1.22525,0.177075,-0.899195,
	1.07494,0.177075,-1.07494,	1.10192,0.2136,-1.10192,	1.256003,0.2136,-0.921764,
	1.256003,0.2136,-0.921764,	1.22525,0.177075,-0.899195,	1.07494,0.177075,-1.07494,
	0.899195,0.177075,-1.22525,	0.921764,0.2136,-1.256003,	1.10192,0.2136,-1.10192,
	1.10192,0.2136,-1.10192,	1.07494,0.177075,-1.07494,	0.899195,0.177075,-1.22525,
	0.700921,0.177075,-1.347218,	0.718514,0.2136,-1.381032,	0.921764,0.2136,-1.256003,
	0.921764,0.2136,-1.256003,	0.899195,0.177075,-1.22525,	0.700921,0.177075,-1.347218,
	0.483027,0.177075,-1.437937,	0.49515,0.2136,-1.474028,	0.718514,0.2136,-1.381032,
	0.718514,0.2136,-1.381032,	0.700921,0.177075,-1.347218,	0.483027,0.177075,-1.437937,
	0.248417,0.177075,-1.4945,	0.254652,0.2136,-1.53201,	0.49515,0.2136,-1.474028,
	0.49515,0.2136,-1.474028,	0.483027,0.177075,-1.437937,	0.248417,0.177075,-1.4945,
	0,0.177075,-1.514,	0,0.2136,-1.552,	0.254652,0.2136,-1.53201,
	0.254652,0.2136,-1.53201,	0.248417,0.177075,-1.4945,	0,0.177075,-1.514,
	1.48068,0.15,-0.24612,	1.4945,0.177075,-0.248417,	1.514,0.177075,0,
	1.514,0.177075,0,	1.5,0.15,0,	1.48068,0.15,-0.24612,
	1.42464,0.15,-0.47856,	1.437937,0.177075,-0.483027,	1.4945,0.177075,-0.248417,
	1.4945,0.177075,-0.248417,	1.48068,0.15,-0.24612,	1.42464,0.15,-0.47856,
	1.33476,0.15,-0.69444,	1.347218,0.177075,-0.700921,	1.437937,0.177075,-0.483027,
	1.437937,0.177075,-0.483027,	1.42464,0.15,-0.47856,	1.33476,0.15,-0.69444,
	1.21392,0.15,-0.89088,	1.22525,0.177075,-0.899195,	1.347218,0.177075,-0.700921,
	1.347218,0.177075,-0.700921,	1.33476,0.15,-0.69444,	1.21392,0.15,-0.89088,
	1.065,0.15,-1.065,	1.07494,0.177075,-1.07494,	1.22525,0.177075,-0.899195,
	1.22525,0.177075,-0.899195,	1.21392,0.15,-0.89088,	1.065,0.15,-1.065,
	0.89088,0.15,-1.21392,	0.899195,0.177075,-1.22525,	1.07494,0.177075,-1.07494,
	1.07494,0.177075,-1.07494,	1.065,0.15,-1.065,	0.89088,0.15,-1.21392,
	0.69444,0.15,-1.33476,	0.700921,0.177075,-1.347218,	0.899195,0.177075,-1.22525,
	0.899195,0.177075,-1.22525,	0.89088,0.15,-1.21392,	0.69444,0.15,-1.33476,
	0.47856,0.15,-1.42464,	0.483027,0.177075,-1.437937,	0.700921,0.177075,-1.347218,
	0.700921,0.177075,-1.347218,	0.69444,0.15,-1.33476,	0.47856,0.15,-1.42464,
	0.24612,0.15,-1.48068,	0.248417,0.177075,-1.4945,	0.483027,0.177075,-1.437937,
	0.483027,0.177075,-1.437937,	0.47856,0.15,-1.42464,	0.24612,0.15,-1.48068,
	0,0.15,-1.5,	0,0.177075,-1.514,	0.248417,0.177075,-1.4945,
	0.248417,0.177075,-1.4945,	0.24612,0.15,-1.48068,	0,0.15,-1.5,
	-0.325863,0.771675,-1.96042,	-0.32816,0.9,-1.97424,	0,0.9,-2,
	0,0.9,-2,	0,0.771675,-1.986,	-0.325863,0.771675,-1.96042,
	-0.633613,0.771675,-1.886223,	-0.63808,0.9,-1.89952,	-0.32816,0.9,-1.97424,
	-0.32816,0.9,-1.97424,	-0.325863,0.771675,-1.96042,	-0.633613,0.771675,-1.886223,
	-0.919439,0.771675,-1.767222,	-0.92592,0.9,-1.77968,	-0.63808,0.9,-1.89952,
	-0.63808,0.9,-1.89952,	-0.633613,0.771675,-1.886223,	-0.919439,0.771675,-1.767222,
	-1.179525,0.771675,-1.60723,	-1.18784,0.9,-1.61856,	-0.92592,0.9,-1.77968,
	-0.92592,0.9,-1.77968,	-0.919439,0.771675,-1.767222,	-1.179525,0.771675,-1.60723,
	-1.41006,0.771675,-1.41006,	-1.42,0.9,-1.42,	-1.18784,0.9,-1.61856,
	-1.18784,0.9,-1.61856,	-1.179525,0.771675,-1.60723,	-1.41006,0.771675,-1.41006,
	-1.60723,0.771675,-1.179525,	-1.61856,0.9,-1.18784,	-1.42,0.9,-1.42,
	-1.42,0.9,-1.42,	-1.41006,0.771675,-1.41006,	-1.60723,0.771675,-1.179525,
	-1.767222,0.771675,-0.919439,	-1.77968,0.9,-0.92592,	-1.61856,0.9,-1.18784,
	-1.61856,0.9,-1.18784,	-1.60723,0.771675,-1.179525,	-1.767222,0.771675,-0.919439,
	-1.886223,0.771675,-0.633613,	-1.89952,0.9,-0.63808,	-1.77968,0.9,-0.92592,
	-1.77968,0.9,-0.92592,	-1.767222,0.771675,-0.919439,	-1.886223,0.771675,-0.633613,
	-1.96042,0.771675,-0.325863,	-1.97424,0.9,-0.32816,	-1.89952,0.9,-0.63808,
	-1.89952,0.9,-0.63808,	-1.886223,0.771675,-0.633613,	-1.96042,0.771675,-0.325863,
	-1.986,0.771675,0,	-2,0.9,0,	-1.97424,0.9,-0.32816,
	-1.97424,0.9,-0.32816,	-1.96042,0.771675,-0.325863,	-1.986,0.771675,0,
	-0.319628,0.6564,-1.92291,	-0.325863,0.771675,-1.96042,	0,0.771675,-1.986,
	0,0.771675,-1.986,	0,0.6564,-1.948,	-0.319628,0.6564,-1.92291,
	-0.62149,0.6564,-1.850132,	-0.633613,0.771675,-1.886223,	-0.325863,0.771675,-1.96042,
	-0.325863,0.771675,-1.96042,	-0.319628,0.6564,-1.92291,	-0.62149,0.6564,-1.850132,
	-0.901846,0.6564,-1.733408,	-0.919439,0.771675,-1.767222,	-0.633613,0.771675,-1.886223,
	-0.633613,0.771675,-1.886223,	-0.62149,0.6564,-1.850132,	-0.901846,0.6564,-1.733408,
	-1.156956,0.6564,-1.576477,	-1.179525,0.771675,-1.60723,	-0.919439,0.771675,-1.767222,
	-0.919439,0.771675,-1.767222,	-0.901846,0.6564,-1.733408,	-1.156956,0.6564,-1.576477,
	-1.38308,0.6564,-1.38308,	-1.41006,0.771675,-1.41006,	-1.179525,0.771675,-1.60723,
	-1.179525,0.771675,-1.60723,	-1.156956,0.6564,-1.576477,	-1.38308,0.6564,-1.38308,
	-1.576477,0.6564,-1.156956,	-1.60723,0.771675,-1.179525,	-1.41006,0.771675,-1.41006,
	-1.41006,0.771675,-1.41006,	-1.38308,0.6564,-1.38308,	-1.576477,0.6564,-1.156956,
	-1.733408,0.6564,-0.901846,	-1.767222,0.771675,-0.919439,	-1.60723,0.771675,-1.179525,
	-1.60723,0.771675,-1.179525,	-1.576477,0.6564,-1.156956,	-1.733408,0.6564,-0.901846,
	-1.850132,0.6564,-0.62149,	-1.886223,0.771675,-0.633613,	-1.767222,0.771675,-0.919439,
	-1.767222,0.771675,-0.919439,	-1.733408,0.6564,-0.901846,	-1.850132,0.6564,-0.62149,
	-1.92291,0.6564,-0.319628,	-1.96042,0.771675,-0.325863,	-1.886223,0.771675,-0.633613,
	-1.886223,0.771675,-0.633613,	-1.850132,0.6564,-0.62149,	-1.92291,0.6564,-0.319628,
	-1.948,0.6564,0,	-1.986,0.771675,0,	-1.96042,0.771675,-0.325863,
	-1.96042,0.771675,-0.325863,	-1.92291,0.6564,-0.319628,	-1.948,0.6564,0,
	-0.310439,0.553725,-1.867631,	-0.319628,0.6564,-1.92291,	0,0.6564,-1.948,
	0,0.6564,-1.948,	0,0.553725,-1.892,	-0.310439,0.553725,-1.867631,
	-0.603624,0.553725,-1.796946,	-0.62149,0.6564,-1.850132,	-0.319628,0.6564,-1.92291,
	-0.319628,0.6564,-1.92291,	-0.310439,0.553725,-1.867631,	-0.603624,0.553725,-1.796946,
	-0.87592,0.553725,-1.683577,	-0.901846,0.6564,-1.733408,	-0.62149,0.6564,-1.850132,
	-0.62149,0.6564,-1.850132,	-0.603624,0.553725,-1.796946,	-0.87592,0.553725,-1.683577,
	-1.123697,0.553725,-1.531158,	-1.156956,0.6564,-1.576477,	-0.901846,0.6564,-1.733408,
	-0.901846,0.6564,-1.733408,	-0.87592,0.553725,-1.683577,	-1.123697,0.553725,-1.531158,
	-1.34332,0.553725,-1.34332,	-1.38308,0.6564,-1.38308,	-1.156956,0.6564,-1.576477,
	-1.156956,0.6564,-1.576477,	-1.123697,0.553725,-1.531158,	-1.34332,0.553725,-1.34332,
	-1.531158,0.553725,-1.123697,	-1.576477,0.6564,-1.156956,	-1.38308,0.6564,-1.38308,
	-1.38308,0.6564,-1.38308,	-1.34332,0.553725,-1.34332,	-1.531158,0.553725,-1.123697,
	-1.683577,0.553725,-0.87592,	-1.733408,0.6564,-0.901846,	-1.576477,0.6564,-1.156956,
	-1.576477,0.6564,-1.156956,	-1.531158,0.553725,-1.123697,	-1.683577,0.553725,-0.87592,
	-1.796946,0.553725,-0.603624,	-1.850132,0.6564,-0.62149,	-1.733408,0.6564,-0.901846,
	-1.733408,0.6564,-0.901846,	-1.683577,0.553725,-0.87592,	-1.796946,0.553725,-0.603624,
	-1.867631,0.553725,-0.310439,	-1.92291,0.6564,-0.319628,	-1.850132,0.6564,-0.62149,
	-1.850132,0.6564,-0.62149,	-1.796946,0.553725,-0.603624,	-1.867631,0.553725,-0.310439,
	-1.892,0.553725,0,	-1.948,0.6564,0,	-1.92291,0.6564,-0.319628,
	-1.92291,0.6564,-0.319628,	-1.867631,0.553725,-0.310439,	-1.892,0.553725,0,
	-0.299282,0.4632,-1.800507,	-0.310439,0.553725,-1.867631,	0,0.553725,-1.892,
	0,0.553725,-1.892,	0,0.4632,-1.824,	-0.299282,0.4632,-1.800507,
	-0.581929,0.4632,-1.732362,	-0.603624,0.553725,-1.796946,	-0.310439,0.553725,-1.867631,
	-0.310439,0.553725,-1.867631,	-0.299282,0.4632,-1.800507,	-0.581929,0.4632,-1.732362,
	-0.844439,0.4632,-1.623068,	-0.87592,0.553725,-1.683577,	-0.603624,0.553725,-1.796946,
	-0.603624,0.553725,-1.796946,	-0.581929,0.4632,-1.732362,	-0.844439,0.4632,-1.623068,
	-1.08331,0.4632,-1.476127,	-1.123697,0.553725,-1.531158,	-0.87592,0.553725,-1.683577,
	-0.87592,0.553725,-1.683577,	-0.844439,0.4632,-1.623068,	-1.08331,0.4632,-1.476127,
	-1.29504,0.4632,-1.29504,	-1.34332,0.553725,-1.34332,	-1.123697,0.553725,-1.531158,
	-1.123697,0.553725,-1.531158,	-1.08331,0.4632,-1.476127,	-1.29504,0.4632,-1.29504,
	-1.476127,0.4632,-1.08331,	-1.531158,0.553725,-1.123697,	-1.34332,0.553725,-1.34332,
	-1.34332,0.553725,-1.34332,	-1.29504,0.4632,-1.29504,	-1.476127,0.4632,-1.08331,
	-1.623068,0.4632,-0.844439,	-1.683577,0.553725,-0.87592,	-1.531158,0.553725,-1.123697,
	-1.531158,0.553725,-1.123697,	-1.476127,0.4632,-1.08331,	-1.623068,0.4632,-0.844439,
	-1.732362,0.4632,-0.581929,	-1.796946,0.553725,-0.603624,	-1.683577,0.553725,-0.87592,
	-1.683577,0.553725,-0.87592,	-1.623068,0.4632,-0.844439,	-1.732362,0.4632,-0.581929,
	-1.800507,0.4632,-0.299282,	-1.867631,0.553725,-0.310439,	-1.796946,0.553725,-0.603624,
	-1.796946,0.553725,-0.603624,	-1.732362,0.4632,-0.581929,	-1.800507,0.4632,-0.299282,
	-1.824,0.4632,0,	-1.892,0.553725,0,	-1.867631,0.553725,-0.310439,
	-1.867631,0.553725,-0.310439,	-1.800507,0.4632,-0.299282,	-1.824,0.4632,0,
	-0.28714,0.384375,-1.72746,	-0.299282,0.4632,-1.800507,	0,0.4632,-1.824,
	0,0.4632,-1.824,	0,0.384375,-1.75,	-0.28714,0.384375,-1.72746,
	-0.55832,0.384375,-1.66208,	-0.581929,0.4632,-1.732362,	-0.299282,0.4632,-1.800507,
	-0.299282,0.4632,-1.800507,	-0.28714,0.384375,-1.72746,	-0.55832,0.384375,-1.66208,
	-0.81018,0.384375,-1.55722,	-0.844439,0.4632,-1.623068,	-0.581929,0.4632,-1.732362,
	-0.581929,0.4632,-1.732362,	-0.55832,0.384375,-1.66208,	-0.81018,0.384375,-1.55722,
	-1.03936,0.384375,-1.41624,	-1.08331,0.4632,-1.476127,	-0.844439,0.4632,-1.623068,
	-0.844439,0.4632,-1.623068,	-0.81018,0.384375,-1.55722,	-1.03936,0.384375,-1.41624,
	-1.2425,0.384375,-1.2425,	-1.29504,0.4632,-1.29504,	-1.08331,0.4632,-1.476127,
	-1.08331,0.4632,-1.476127,	-1.03936,0.384375,-1.41624,	-1.2425,0.384375,-1.2425,
	-1.41624,0.384375,-1.03936,	-1.476127,0.4632,-1.08331,	-1.29504,0.4632,-1.29504,
	-1.29504,0.4632,-1.29504,	-1.2425,0.384375,-1.2425,	-1.41624,0.384375,-1.03936,
	-1.55722,0.384375,-0.81018,	-1.623068,0.4632,-0.844439,	-1.476127,0.4632,-1.08331,
	-1.476127,0.4632,-1.08331,	-1.41624,0.384375,-1.03936,	-1.55722,0.384375,-0.81018,
	-1.66208,0.384375,-0.55832,	-1.732362,0.4632,-0.581929,	-1.623068,0.4632,-0.844439,
	-1.623068,0.4632,-0.844439,	-1.55722,0.384375,-0.81018,	-1.66208,0.384375,-0.55832,
	-1.72746,0.384375,-0.28714,	-1.800507,0.4632,-0.299282,	-1.732362,0.4632,-0.581929,
	-1.732362,0.4632,-0.581929,	-1.66208,0.384375,-0.55832,	-1.72746,0.384375,-0.28714,
	-1.75,0.384375,0,	-1.824,0.4632,0,	-1.800507,0.4632,-0.299282,
	-1.800507,0.4632,-0.299282,	-1.72746,0.384375,-0.28714,	-1.75,0.384375,0,
	-0.274998,0.3168,-1.654413,	-0.28714,0.384375,-1.72746,	0,0.384375,-1.75,
	0,0.384375,-1.75,	0,0.3168,-1.676,	-0.274998,0.3168,-1.654413,
	-0.534711,0.3168,-1.591798,	-0.55832,0.384375,-1.66208,	-0.28714,0.384375,-1.72746,
	-0.28714,0.384375,-1.72746,	-0.274998,0.3168,-1.654413,	-0.534711,0.3168,-1.591798,
	-0.775921,0.3168,-1.491372,	-0.81018,0.384375,-1.55722,	-0.55832,0.384375,-1.66208,
	-0.55832,0.384375,-1.66208,	-0.534711,0.3168,-1.591798,	-0.775921,0.3168,-1.491372,
	-0.99541,0.3168,-1.356353,	-1.03936,0.384375,-1.41624,	-0.81018,0.384375,-1.55722,
	-0.81018,0.384375,-1.55722,	-0.775921,0.3168,-1.491372,	-0.99541,0.3168,-1.356353,
	-1.18996,0.3168,-1.18996,	-1.2425,0.384375,-1.2425,	-1.03936,0.384375,-1.41624,
	-1.03936,0.384375,-1.41624,	-0.99541,0.3168,-1.356353,	-1.18996,0.3168,-1.18996,
	-1.356353,0.3168,-0.99541,	-1.41624,0.384375,-1.03936,	-1.2425,0.384375,-1.2425,
	-1.2425,0.384375,-1.2425,	-1.18996,0.3168,-1.18996,	-1.356353,0.3168,-0.99541,
	-1.491372,0.3168,-0.775921,	-1.55722,0.384375,-0.81018,	-1.41624,0.384375,-1.03936,
	-1.41624,0.384375,-1.03936,	-1.356353,0.3168,-0.99541,	-1.491372,0.3168,-0.775921,
	-1.591798,0.3168,-0.534711,	-1.66208,0.384375,-0.55832,	-1.55722,0.384375,-0.81018,
	-1.55722,0.384375,-0.81018,	-1.491372,0.3168,-0.775921,	-1.591798,0.3168,-0.534711,
	-1.654413,0.3168,-0.274998,	-1.72746,0.384375,-0.28714,	-1.66208,0.384375,-0.55832,
	-1.66208,0.384375,-0.55832,	-1.591798,0.3168,-0.534711,	-1.654413,0.3168,-0.274998,
	-1.676,0.3168,0,	-1.75,0.384375,0,	-1.72746,0.384375,-0.28714,
	-1.72746,0.384375,-0.28714,	-1.654413,0.3168,-0.274998,	-1.676,0.3168,0,
	-0.263841,0.260025,-1.587289,	-0.274998,0.3168,-1.654413,	0,0.3168,-1.676,
	0,0.3168,-1.676,	0,0.260025,-1.608,	-0.263841,0.260025,-1.587289,
	-0.513016,0.260025,-1.527214,	-0.534711,0.3168,-1.591798,	-0.274998,0.3168,-1.654413,
	-0.274998,0.3168,-1.654413,	-0.263841,0.260025,-1.587289,	-0.513016,0.260025,-1.527214,
	-0.74444,0.260025,-1.430863,	-0.775921,0.3168,-1.491372,	-0.534711,0.3168,-1.591798,
	-0.534711,0.3168,-1.591798,	-0.513016,0.260025,-1.527214,	-0.74444,0.260025,-1.430863,
	-0.955023,0.260025,-1.301322,	-0.99541,0.3168,-1.356353,	-0.775921,0.3168,-1.491372,
	-0.775921,0.3168,-1.491372,	-0.74444,0.260025,-1.430863,	-0.955023,0.260025,-1.301322,
	-1.14168,0.260025,-1.14168,	-1.18996,0.3168,-1.18996,	-0.99541,0.3168,-1.356353,
	-0.99541,0.3168,-1.356353,	-0.955023,0.260025,-1.301322,	-1.14168,0.260025,-1.14168,
	-1.301322,0.260025,-0.955023,	-1.356353,0.3168,-0.99541,	-1.18996,0.3168,-1.18996,
	-1.18996,0.3168,-1.18996,	-1.14168,0.260025,-1.14168,	-1.301322,0.260025,-0.955023,
	-1.430863,0.260025,-0.74444,	-1.491372,0.3168,-0.775921,	-1.356353,0.3168,-0.99541,
	-1.356353,0.3168,-0.99541,	-1.301322,0.260025,-0.955023,	-1.430863,0.260025,-0.74444,
	-1.527214,0.260025,-0.513016,	-1.591798,0.3168,-0.534711,	-1.491372,0.3168,-0.775921,
	-1.491372,0.3168,-0.775921,	-1.430863,0.260025,-0.74444,	-1.527214,0.260025,-0.513016,
	-1.587289,0.260025,-0.263841,	-1.654413,0.3168,-0.274998,	-1.591798,0.3168,-0.534711,
	-1.591798,0.3168,-0.534711,	-1.527214,0.260025,-0.513016,	-1.587289,0.260025,-0.263841,
	-1.608,0.260025,0,	-1.676,0.3168,0,	-1.654413,0.3168,-0.274998,
	-1.654413,0.3168,-0.274998,	-1.587289,0.260025,-0.263841,	-1.608,0.260025,0,
	-0.254652,0.2136,-1.53201,	-0.263841,0.260025,-1.587289,	0,0.260025,-1.608,
	0,0.260025,-1.608,	0,0.2136,-1.552,	-0.254652,0.2136,-1.53201,
	-0.49515,0.2136,-1.474028,	-0.513016,0.260025,-1.527214,	-0.263841,0.260025,-1.587289,
	-0.263841,0.260025,-1.587289,	-0.254652,0.2136,-1.53201,	-0.49515,0.2136,-1.474028,
	-0.718514,0.2136,-1.381032,	-0.74444,0.260025,-1.430863,	-0.513016,0.260025,-1.527214,
	-0.513016,0.260025,-1.527214,	-0.49515,0.2136,-1.474028,	-0.718514,0.2136,-1.381032,
	-0.921764,0.2136,-1.256003,	-0.955023,0.260025,-1.301322,	-0.74444,0.260025,-1.430863,
	-0.74444,0.260025,-1.430863,	-0.718514,0.2136,-1.381032,	-0.921764,0.2136,-1.256003,
	-1.10192,0.2136,-1.10192,	-1.14168,0.260025,-1.14168,	-0.955023,0.260025,-1.301322,
	-0.955023,0.260025,-1.301322,	-0.921764,0.2136,-1.256003,	-1.10192,0.2136,-1.10192,
	-1.256003,0.2136,-0.921764,	-1.301322,0.260025,-0.955023,	-1.14168,0.260025,-1.14168,
	-1.14168,0.260025,-1.14168,	-1.10192,0.2136,-1.10192,	-1.256003,0.2136,-0.921764,
	-1.381032,0.2136,-0.718514,	-1.430863,0.260025,-0.74444,	-1.301322,0.260025,-0.955023,
	-1.301322,0.260025,-0.955023,	-1.256003,0.2136,-0.921764,	-1.381032,0.2136,-0.718514,
	-1.474028,0.2136,-0.49515,	-1.527214,0.260025,-0.513016,	-1.430863,0.260025,-0.74444,
	-1.430863,0.260025,-0.74444,	-1.381032,0.2136,-0.718514,	-1.474028,0.2136,-0.49515,
	-1.53201,0.2136,-0.254652,	-1.587289,0.260025,-0.263841,	-1.527214,0.260025,-0.513016,
	-1.527214,0.260025,-0.513016,	-1.474028,0.2136,-0.49515,	-1.53201,0.2136,-0.254652,
	-1.552,0.2136,0,	-1.608,0.260025,0,	-1.587289,0.260025,-0.263841,
	-1.587289,0.260025,-0.263841,	-1.53201,0.2136,-0.254652,	-1.552,0.2136,0,
	-0.248417,0.177075,-1.4945,	-0.254652,0.2136,-1.53201,	0,0.2136,-1.552,
	0,0.2136,-1.552,	0,0.177075,-1.514,	-0.248417,0.177075,-1.4945,
	-0.483027,0.177075,-1.437937,	-0.49515,0.2136,-1.474028,	-0.254652,0.2136,-1.53201,
	-0.254652,0.2136,-1.53201,	-0.248417,0.177075,-1.4945,	-0.483027,0.177075,-1.437937,
	-0.700921,0.177075,-1.347218,	-0.718514,0.2136,-1.381032,	-0.49515,0.2136,-1.474028,
	-0.49515,0.2136,-1.474028,	-0.483027,0.177075,-1.437937,	-0.700921,0.177075,-1.347218,
	-0.899195,0.177075,-1.22525,	-0.921764,0.2136,-1.256003,	-0.718514,0.2136,-1.381032,
	-0.718514,0.2136,-1.381032,	-0.700921,0.177075,-1.347218,	-0.899195,0.177075,-1.22525,
	-1.07494,0.177075,-1.07494,	-1.10192,0.2136,-1.10192,	-0.921764,0.2136,-1.256003,
	-0.921764,0.2136,-1.256003,	-0.899195,0.177075,-1.22525,	-1.07494,0.177075,-1.07494,
	-1.22525,0.177075,-0.899195,	-1.256003,0.2136,-0.921764,	-1.10192,0.2136,-1.10192,
	-1.10192,0.2136,-1.10192,	-1.07494,0.177075,-1.07494,	-1.22525,0.177075,-0.899195,
	-1.347218,0.177075,-0.700921,	-1.381032,0.2136,-0.718514,	-1.256003,0.2136,-0.921764,
	-1.256003,0.2136,-0.921764,	-1.22525,0.177075,-0.899195,	-1.347218,0.177075,-0.700921,
	-1.437937,0.177075,-0.483027,	-1.474028,0.2136,-0.49515,	-1.381032,0.2136,-0.718514,
	-1.381032,0.2136,-0.718514,	-1.347218,0.177075,-0.700921,	-1.437937,0.177075,-0.483027,
	-1.4945,0.177075,-0.248417,	-1.53201,0.2136,-0.254652,	-1.474028,0.2136,-0.49515,
	-1.474028,0.2136,-0.49515,	-1.437937,0.177075,-0.483027,	-1.4945,0.177075,-0.248417,
	-1.514,0.177075,0,	-1.552,0.2136,0,	-1.53201,0.2136,-0.254652,
	-1.53201,0.2136,-0.254652,	-1.4945,0.177075,-0.248417,	-1.514,0.177075,0,
	-0.24612,0.15,-1.48068,	-0.248417,0.177075,-1.4945,	0,0.177075,-1.514,
	0,0.177075,-1.514,	0,0.15,-1.5,	-0.24612,0.15,-1.48068,
	-0.47856,0.15,-1.42464,	-0.483027,0.177075,-1.437937,	-0.248417,0.177075,-1.4945,
	-0.248417,0.177075,-1.4945,	-0.24612,0.15,-1.48068,	-0.47856,0.15,-1.42464,
	-0.69444,0.15,-1.33476,	-0.700921,0.177075,-1.347218,	-0.483027,0.177075,-1.437937,
	-0.483027,0.177075,-1.437937,	-0.47856,0.15,-1.42464,	-0.69444,0.15,-1.33476,
	-0.89088,0.15,-1.21392,	-0.899195,0.177075,-1.22525,	-0.700921,0.177075,-1.347218,
	-0.700921,0.177075,-1.347218,	-0.69444,0.15,-1.33476,	-0.89088,0.15,-1.21392,
	-1.065,0.15,-1.065,	-1.07494,0.177075,-1.07494,	-0.899195,0.177075,-1.22525,
	-0.899195,0.177075,-1.22525,	-0.89088,0.15,-1.21392,	-1.065,0.15,-1.065,
	-1.21392,0.15,-0.89088,	-1.22525,0.177075,-0.899195,	-1.07494,0.177075,-1.07494,
	-1.07494,0.177075,-1.07494,	-1.065,0.15,-1.065,	-1.21392,0.15,-0.89088,
	-1.33476,0.15,-0.69444,	-1.347218,0.177075,-0.700921,	-1.22525,0.177075,-0.899195,
	-1.22525,0.177075,-0.899195,	-1.21392,0.15,-0.89088,	-1.33476,0.15,-0.69444,
	-1.42464,0.15,-0.47856,	-1.437937,0.177075,-0.483027,	-1.347218,0.177075,-0.700921,
	-1.347218,0.177075,-0.700921,	-1.33476,0.15,-0.69444,	-1.42464,0.15,-0.47856,
	-1.48068,0.15,-0.24612,	-1.4945,0.177075,-0.248417,	-1.437937,0.177075,-0.483027,
	-1.437937,0.177075,-0.483027,	-1.42464,0.15,-0.47856,	-1.48068,0.15,-0.24612,
	-1.5,0.15,0,	-1.514,0.177075,0,	-1.4945,0.177075,-0.248417,
	-1.4945,0.177075,-0.248417,	-1.48068,0.15,-0.24612,	-1.5,0.15,0,
	-1.96042,0.771675,0.325863,	-1.97424,0.9,0.32816,	-2,0.9,0,
	-2,0.9,0,	-1.986,0.771675,0,	-1.96042,0.771675,0.325863,
	-1.886223,0.771675,0.633613,	-1.89952,0.9,0.63808,	-1.97424,0.9,0.32816,
	-1.97424,0.9,0.32816,	-1.96042,0.771675,0.325863,	-1.886223,0.771675,0.633613,
	-1.767222,0.771675,0.919439,	-1.77968,0.9,0.92592,	-1.89952,0.9,0.63808,
	-1.89952,0.9,0.63808,	-1.886223,0.771675,0.633613,	-1.767222,0.771675,0.919439,
	-1.60723,0.771675,1.179525,	-1.61856,0.9,1.18784,	-1.77968,0.9,0.92592,
	-1.77968,0.9,0.92592,	-1.767222,0.771675,0.919439,	-1.60723,0.771675,1.179525,
	-1.41006,0.771675,1.41006,	-1.42,0.9,1.42,	-1.61856,0.9,1.18784,
	-1.61856,0.9,1.18784,	-1.60723,0.771675,1.179525,	-1.41006,0.771675,1.41006,
	-1.179525,0.771675,1.60723,	-1.18784,0.9,1.61856,	-1.42,0.9,1.42,
	-1.42,0.9,1.42,	-1.41006,0.771675,1.41006,	-1.179525,0.771675,1.60723,
	-0.919439,0.771675,1.767222,	-0.92592,0.9,1.77968,	-1.18784,0.9,1.61856,
	-1.18784,0.9,1.61856,	-1.179525,0.771675,1.60723,	-0.919439,0.771675,1.767222,
	-0.633613,0.771675,1.886223,	-0.63808,0.9,1.89952,	-0.92592,0.9,1.77968,
	-0.92592,0.9,1.77968,	-0.919439,0.771675,1.767222,	-0.633613,0.771675,1.886223,
	-0.325863,0.771675,1.96042,	-0.32816,0.9,1.97424,	-0.63808,0.9,1.89952,
	-0.63808,0.9,1.89952,	-0.633613,0.771675,1.886223,	-0.325863,0.771675,1.96042,
	0,0.771675,1.986,	0,0.9,2,	-0.32816,0.9,1.97424,
	-0.32816,0.9,1.97424,	-0.325863,0.771675,1.96042,	0,0.771675,1.986,
	-1.92291,0.6564,0.319628,	-1.96042,0.771675,0.325863,	-1.986,0.771675,0,
	-1.986,0.771675,0,	-1.948,0.6564,0,	-1.92291,0.6564,0.319628,
	-1.850132,0.6564,0.62149,	-1.886223,0.771675,0.633613,	-1.96042,0.771675,0.325863,
	-1.96042,0.771675,0.325863,	-1.92291,0.6564,0.319628,	-1.850132,0.6564,0.62149,
	-1.733408,0.6564,0.901846,	-1.767222,0.771675,0.919439,	-1.886223,0.771675,0.633613,
	-1.886223,0.771675,0.633613,	-1.850132,0.6564,0.62149,	-1.733408,0.6564,0.901846,
	-1.576477,0.6564,1.156956,	-1.60723,0.771675,1.179525,	-1.767222,0.771675,0.919439,
	-1.767222,0.771675,0.919439,	-1.733408,0.6564,0.901846,	-1.576477,0.6564,1.156956,
	-1.38308,0.6564,1.38308,	-1.41006,0.771675,1.41006,	-1.60723,0.771675,1.179525,
	-1.60723,0.771675,1.179525,	-1.576477,0.6564,1.156956,	-1.38308,0.6564,1.38308,
	-1.156956,0.6564,1.576477,	-1.179525,0.771675,1.60723,	-1.41006,0.771675,1.41006,
	-1.41006,0.771675,1.41006,	-1.38308,0.6564,1.38308,	-1.156956,0.6564,1.576477,
	-0.901846,0.6564,1.733408,	-0.919439,0.771675,1.767222,	-1.179525,0.771675,1.60723,
	-1.179525,0.771675,1.60723,	-1.156956,0.6564,1.576477,	-0.901846,0.6564,1.733408,
	-0.62149,0.6564,1.850132,	-0.633613,0.771675,1.886223,	-0.919439,0.771675,1.767222,
	-0.919439,0.771675,1.767222,	-0.901846,0.6564,1.733408,	-0.62149,0.6564,1.850132,
	-0.319628,0.6564,1.92291,	-0.325863,0.771675,1.96042,	-0.633613,0.771675,1.886223,
	-0.633613,0.771675,1.886223,	-0.62149,0.6564,1.850132,	-0.319628,0.6564,1.92291,
	0,0.6564,1.948,	0,0.771675,1.986,	-0.325863,0.771675,1.96042,
	-0.325863,0.771675,1.96042,	-0.319628,0.6564,1.92291,	0,0.6564,1.948,
	-1.867631,0.553725,0.310439,	-1.92291,0.6564,0.319628,	-1.948,0.6564,0,
	-1.948,0.6564,0,	-1.892,0.553725,0,	-1.867631,0.553725,0.310439,
	-1.796946,0.553725,0.603624,	-1.850132,0.6564,0.62149,	-1.92291,0.6564,0.319628,
	-1.92291,0.6564,0.319628,	-1.867631,0.553725,0.310439,	-1.796946,0.553725,0.603624,
	-1.683577,0.553725,0.87592,	-1.733408,0.6564,0.901846,	-1.850132,0.6564,0.62149,
	-1.850132,0.6564,0.62149,	-1.796946,0.553725,0.603624,	-1.683577,0.553725,0.87592,
	-1.531158,0.553725,1.123697,	-1.576477,0.6564,1.156956,	-1.733408,0.6564,0.901846,
	-1.733408,0.6564,0.901846,	-1.683577,0.553725,0.87592,	-1.531158,0.553725,1.123697,
	-1.34332,0.553725,1.34332,	-1.38308,0.6564,1.38308,	-1.576477,0.6564,1.156956,
	-1.576477,0.6564,1.156956,	-1.531158,0.553725,1.123697,	-1.34332,0.553725,1.34332,
	-1.123697,0.553725,1.531158,	-1.156956,0.6564,1.576477,	-1.38308,0.6564,1.38308,
	-1.38308,0.6564,1.38308,	-1.34332,0.553725,1.34332,	-1.123697,0.553725,1.531158,
	-0.87592,0.553725,1.683577,	-0.901846,0.6564,1.733408,	-1.156956,0.6564,1.576477,
	-1.156956,0.6564,1.576477,	-1.123697,0.553725,1.531158,	-0.87592,0.553725,1.683577,
	-0.603624,0.553725,1.796946,	-0.62149,0.6564,1.850132,	-0.901846,0.6564,1.733408,
	-0.901846,0.6564,1.733408,	-0.87592,0.553725,1.683577,	-0.603624,0.553725,1.796946,
	-0.310439,0.553725,1.867631,	-0.319628,0.6564,1.92291,	-0.62149,0.6564,1.850132,
	-0.62149,0.6564,1.850132,	-0.603624,0.553725,1.796946,	-0.310439,0.553725,1.867631,
	0,0.553725,1.892,	0,0.6564,1.948,	-0.319628,0.6564,1.92291,
	-0.319628,0.6564,1.92291,	-0.310439,0.553725,1.867631,	0,0.553725,1.892,
	-1.800507,0.4632,0.299282,	-1.867631,0.553725,0.310439,	-1.892,0.553725,0,
	-1.892,0.553725,0,	-1.824,0.4632,0,	-1.800507,0.4632,0.299282,
	-1.732362,0.4632,0.581929,	-1.796946,0.553725,0.603624,	-1.867631,0.553725,0.310439,
	-1.867631,0.553725,0.310439,	-1.800507,0.4632,0.299282,	-1.732362,0.4632,0.581929,
	-1.623068,0.4632,0.844439,	-1.683577,0.553725,0.87592,	-1.796946,0.553725,0.603624,
	-1.796946,0.553725,0.603624,	-1.732362,0.4632,0.581929,	-1.623068,0.4632,0.844439,
	-1.476127,0.4632,1.08331,	-1.531158,0.553725,1.123697,	-1.683577,0.553725,0.87592,
	-1.683577,0.553725,0.87592,	-1.623068,0.4632,0.844439,	-1.476127,0.4632,1.08331,
	-1.29504,0.4632,1.29504,	-1.34332,0.553725,1.34332,	-1.531158,0.553725,1.123697,
	-1.531158,0.553725,1.123697,	-1.476127,0.4632,1.08331,	-1.29504,0.4632,1.29504,
	-1.08331,0.4632,1.476127,	-1.123697,0.553725,1.531158,	-1.34332,0.553725,1.34332,
	-1.34332,0.553725,1.34332,	-1.29504,0.4632,1.29504,	-1.08331,0.4632,1.476127,
	-0.844439,0.4632,1.623068,	-0.87592,0.553725,1.683577,	-1.123697,0.553725,1.531158,
	-1.123697,0.553725,1.531158,	-1.08331,0.4632,1.476127,	-0.844439,0.4632,1.623068,
	-0.581929,0.4632,1.732362,	-0.603624,0.553725,1.796946,	-0.87592,0.553725,1.683577,
	-0.87592,0.553725,1.683577,	-0.844439,0.4632,1.623068,	-0.581929,0.4632,1.732362,
	-0.299282,0.4632,1.800507,	-0.310439,0.553725,1.867631,	-0.603624,0.553725,1.796946,
	-0.603624,0.553725,1.796946,	-0.581929,0.4632,1.732362,	-0.299282,0.4632,1.800507,
	0,0.4632,1.824,	0,0.553725,1.892,	-0.310439,0.553725,1.867631,
	-0.310439,0.553725,1.867631,	-0.299282,0.4632,1.800507,	0,0.4632,1.824,
	-1.72746,0.384375,0.28714,	-1.800507,0.4632,0.299282,	-1.824,0.4632,0,
	-1.824,0.4632,0,	-1.75,0.384375,0,	-1.72746,0.384375,0.28714,
	-1.66208,0.384375,0.55832,	-1.732362,0.4632,0.581929,	-1.800507,0.4632,0.299282,
	-1.800507,0.4632,0.299282,	-1.72746,0.384375,0.28714,	-1.66208,0.384375,0.55832,
	-1.55722,0.384375,0.81018,	-1.623068,0.4632,0.844439,	-1.732362,0.4632,0.581929,
	-1.732362,0.4632,0.581929,	-1.66208,0.384375,0.55832,	-1.55722,0.384375,0.81018,
	-1.41624,0.384375,1.03936,	-1.476127,0.4632,1.08331,	-1.623068,0.4632,0.844439,
	-1.623068,0.4632,0.844439,	-1.55722,0.384375,0.81018,	-1.41624,0.384375,1.03936,
	-1.2425,0.384375,1.2425,	-1.29504,0.4632,1.29504,	-1.476127,0.4632,1.08331,
	-1.476127,0.4632,1.08331,	-1.41624,0.384375,1.03936,	-1.2425,0.384375,1.2425,
	-1.03936,0.384375,1.41624,	-1.08331,0.4632,1.476127,	-1.29504,0.4632,1.29504,
	-1.29504,0.4632,1.29504,	-1.2425,0.384375,1.2425,	-1.03936,0.384375,1.41624,
	-0.81018,0.384375,1.55722,	-0.844439,0.4632,1.623068,	-1.08331,0.4632,1.476127,
	-1.08331,0.4632,1.476127,	-1.03936,0.384375,1.41624,	-0.81018,0.384375,1.55722,
	-0.55832,0.384375,1.66208,	-0.581929,0.4632,1.732362,	-0.844439,0.4632,1.623068,
	-0.844439,0.4632,1.623068,	-0.81018,0.384375,1.55722,	-0.55832,0.384375,1.66208,
	-0.28714,0.384375,1.72746,	-0.299282,0.4632,1.800507,	-0.581929,0.4632,1.732362,
	-0.581929,0.4632,1.732362,	-0.55832,0.384375,1.66208,	-0.28714,0.384375,1.72746,
	0,0.384375,1.75,	0,0.4632,1.824,	-0.299282,0.4632,1.800507,
	-0.299282,0.4632,1.800507,	-0.28714,0.384375,1.72746,	0,0.384375,1.75,
	-1.654413,0.3168,0.274998,	-1.72746,0.384375,0.28714,	-1.75,0.384375,0,
	-1.75,0.384375,0,	-1.676,0.3168,0,	-1.654413,0.3168,0.274998,
	-1.591798,0.3168,0.534711,	-1.66208,0.384375,0.55832,	-1.72746,0.384375,0.28714,
	-1.72746,0.384375,0.28714,	-1.654413,0.3168,0.274998,	-1.591798,0.3168,0.534711,
	-1.491372,0.3168,0.775921,	-1.55722,0.384375,0.81018,	-1.66208,0.384375,0.55832,
	-1.66208,0.384375,0.55832,	-1.591798,0.3168,0.534711,	-1.491372,0.3168,0.775921,
	-1.356353,0.3168,0.99541,	-1.41624,0.384375,1.03936,	-1.55722,0.384375,0.81018,
	-1.55722,0.384375,0.81018,	-1.491372,0.3168,0.775921,	-1.356353,0.3168,0.99541,
	-1.18996,0.3168,1.18996,	-1.2425,0.384375,1.2425,	-1.41624,0.384375,1.03936,
	-1.41624,0.384375,1.03936,	-1.356353,0.3168,0.99541,	-1.18996,0.3168,1.18996,
	-0.99541,0.3168,1.356353,	-1.03936,0.384375,1.41624,	-1.2425,0.384375,1.2425,
	-1.2425,0.384375,1.2425,	-1.18996,0.3168,1.18996,	-0.99541,0.3168,1.356353,
	-0.775921,0.3168,1.491372,	-0.81018,0.384375,1.55722,	-1.03936,0.384375,1.41624,
	-1.03936,0.384375,1.41624,	-0.99541,0.3168,1.356353,	-0.775921,0.3168,1.491372,
	-0.534711,0.3168,1.591798,	-0.55832,0.384375,1.66208,	-0.81018,0.384375,1.55722,
	-0.81018,0.384375,1.55722,	-0.775921,0.3168,1.491372,	-0.534711,0.3168,1.591798,
	-0.274998,0.3168,1.654413,	-0.28714,0.384375,1.72746,	-0.55832,0.384375,1.66208,
	-0.55832,0.384375,1.66208,	-0.534711,0.3168,1.591798,	-0.274998,0.3168,1.654413,
	0,0.3168,1.676,	0,0.384375,1.75,	-0.28714,0.384375,1.72746,
	-0.28714,0.384375,1.72746,	-0.274998,0.3168,1.654413,	0,0.3168,1.676,
	-1.587289,0.260025,0.263841,	-1.654413,0.3168,0.274998,	-1.676,0.3168,0,
	-1.676,0.3168,0,	-1.608,0.260025,0,	-1.587289,0.260025,0.263841,
	-1.527214,0.260025,0.513016,	-1.591798,0.3168,0.534711,	-1.654413,0.3168,0.274998,
	-1.654413,0.3168,0.274998,	-1.587289,0.260025,0.263841,	-1.527214,0.260025,0.513016,
	-1.430863,0.260025,0.74444,	-1.491372,0.3168,0.775921,	-1.591798,0.3168,0.534711,
	-1.591798,0.3168,0.534711,	-1.527214,0.260025,0.513016,	-1.430863,0.260025,0.74444,
	-1.301322,0.260025,0.955023,	-1.356353,0.3168,0.99541,	-1.491372,0.3168,0.775921,
	-1.491372,0.3168,0.775921,	-1.430863,0.260025,0.74444,	-1.301322,0.260025,0.955023,
	-1.14168,0.260025,1.14168,	-1.18996,0.3168,1.18996,	-1.356353,0.3168,0.99541,
	-1.356353,0.3168,0.99541,	-1.301322,0.260025,0.955023,	-1.14168,0.260025,1.14168,
	-0.955023,0.260025,1.301322,	-0.99541,0.3168,1.356353,	-1.18996,0.3168,1.18996,
	-1.18996,0.3168,1.18996,	-1.14168,0.260025,1.14168,	-0.955023,0.260025,1.301322,
	-0.74444,0.260025,1.430863,	-0.775921,0.3168,1.491372,	-0.99541,0.3168,1.356353,
	-0.99541,0.3168,1.356353,	-0.955023,0.260025,1.301322,	-0.74444,0.260025,1.430863,
	-0.513016,0.260025,1.527214,	-0.534711,0.3168,1.591798,	-0.775921,0.3168,1.491372,
	-0.775921,0.3168,1.491372,	-0.74444,0.260025,1.430863,	-0.513016,0.260025,1.527214,
	-0.263841,0.260025,1.587289,	-0.274998,0.3168,1.654413,	-0.534711,0.3168,1.591798,
	-0.534711,0.3168,1.591798,	-0.513016,0.260025,1.527214,	-0.263841,0.260025,1.587289,
	0,0.260025,1.608,	0,0.3168,1.676,	-0.274998,0.3168,1.654413,
	-0.274998,0.3168,1.654413,	-0.263841,0.260025,1.587289,	0,0.260025,1.608,
	-1.53201,0.2136,0.254652,	-1.587289,0.260025,0.263841,	-1.608,0.260025,0,
	-1.608,0.260025,0,	-1.552,0.2136,0,	-1.53201,0.2136,0.254652,
	-1.474028,0.2136,0.49515,	-1.527214,0.260025,0.513016,	-1.587289,0.260025,0.263841,
	-1.587289,0.260025,0.263841,	-1.53201,0.2136,0.254652,	-1.474028,0.2136,0.49515,
	-1.381032,0.2136,0.718514,	-1.430863,0.260025,0.74444,	-1.527214,0.260025,0.513016,
	-1.527214,0.260025,0.513016,	-1.474028,0.2136,0.49515,	-1.381032,0.2136,0.718514,
	-1.256003,0.2136,0.921764,	-1.301322,0.260025,0.955023,	-1.430863,0.260025,0.74444,
	-1.430863,0.260025,0.74444,	-1.381032,0.2136,0.718514,	-1.256003,0.2136,0.921764,
	-1.10192,0.2136,1.10192,	-1.14168,0.260025,1.14168,	-1.301322,0.260025,0.955023,
	-1.301322,0.260025,0.955023,	-1.256003,0.2136,0.921764,	-1.10192,0.2136,1.10192,
	-0.921764,0.2136,1.256003,	-0.955023,0.260025,1.301322,	-1.14168,0.260025,1.14168,
	-1.14168,0.260025,1.14168,	-1.10192,0.2136,1.10192,	-0.921764,0.2136,1.256003,
	-0.718514,0.2136,1.381032,	-0.74444,0.260025,1.430863,	-0.955023,0.260025,1.301322,
	-0.955023,0.260025,1.301322,	-0.921764,0.2136,1.256003,	-0.718514,0.2136,1.381032,
	-0.49515,0.2136,1.474028,	-0.513016,0.260025,1.527214,	-0.74444,0.260025,1.430863,
	-0.74444,0.260025,1.430863,	-0.718514,0.2136,1.381032,	-0.49515,0.2136,1.474028,
	-0.254652,0.2136,1.53201,	-0.263841,0.260025,1.587289,	-0.513016,0.260025,1.527214,
	-0.513016,0.260025,1.527214,	-0.49515,0.2136,1.474028,	-0.254652,0.2136,1.53201,
	0,0.2136,1.552,	0,0.260025,1.608,	-0.263841,0.260025,1.587289,
	-0.263841,0.260025,1.587289,	-0.254652,0.2136,1.53201,	0,0.2136,1.552,
	-1.4945,0.177075,0.248417,	-1.53201,0.2136,0.254652,	-1.552,0.2136,0,
	-1.552,0.2136,0,	-1.514,0.177075,0,	-1.4945,0.177075,0.248417,
	-1.437937,0.177075,0.483027,	-1.474028,0.2136,0.49515,	-1.53201,0.2136,0.254652,
	-1.53201,0.2136,0.254652,	-1.4945,0.177075,0.248417,	-1.437937,0.177075,0.483027,
	-1.347218,0.177075,0.700921,	-1.381032,0.2136,0.718514,	-1.474028,0.2136,0.49515,
	-1.474028,0.2136,0.49515,	-1.437937,0.177075,0.483027,	-1.347218,0.177075,0.700921,
	-1.22525,0.177075,0.899195,	-1.256003,0.2136,0.921764,	-1.381032,0.2136,0.718514,
	-1.381032,0.2136,0.718514,	-1.347218,0.177075,0.700921,	-1.22525,0.177075,0.899195,
	-1.07494,0.177075,1.07494,	-1.10192,0.2136,1.10192,	-1.256003,0.2136,0.921764,
	-1.256003,0.2136,0.921764,	-1.22525,0.177075,0.899195,	-1.07494,0.177075,1.07494,
	-0.899195,0.177075,1.22525,	-0.921764,0.2136,1.256003,	-1.10192,0.2136,1.10192,
	-1.10192,0.2136,1.10192,	-1.07494,0.177075,1.07494,	-0.899195,0.177075,1.22525,
	-0.700921,0.177075,1.347218,	-0.718514,0.2136,1.381032,	-0.921764,0.2136,1.256003,
	-0.921764,0.2136,1.256003,	-0.899195,0.177075,1.22525,	-0.700921,0.177075,1.347218,
	-0.483027,0.177075,1.437937,	-0.49515,0.2136,1.474028,	-0.718514,0.2136,1.381032,
	-0.718514,0.2136,1.381032,	-0.700921,0.177075,1.347218,	-0.483027,0.177075,1.437937,
	-0.248417,0.177075,1.4945,	-0.254652,0.2136,1.53201,	-0.49515,0.2136,1.474028,
	-0.49515,0.2136,1.474028,	-0.483027,0.177075,1.437937,	-0.248417,0.177075,1.4945,
	0,0.177075,1.514,	0,0.2136,1.552,	-0.254652,0.2136,1.53201,
	-0.254652,0.2136,1.53201,	-0.248417,0.177075,1.4945,	0,0.177075,1.514,
	-1.48068,0.15,0.24612,	-1.4945,0.177075,0.248417,	-1.514,0.177075,0,
	-1.514,0.177075,0,	-1.5,0.15,0,	-1.48068,0.15,0.24612,
	-1.42464,0.15,0.47856,	-1.437937,0.177075,0.483027,	-1.4945,0.177075,0.248417,
	-1.4945,0.177075,0.248417,	-1.48068,0.15,0.24612,	-1.42464,0.15,0.47856,
	-1.33476,0.15,0.69444,	-1.347218,0.177075,0.700921,	-1.437937,0.177075,0.483027,
	-1.437937,0.177075,0.483027,	-1.42464,0.15,0.47856,	-1.33476,0.15,0.69444,
	-1.21392,0.15,0.89088,	-1.22525,0.177075,0.899195,	-1.347218,0.177075,0.700921,
	-1.347218,0.177075,0.700921,	-1.33476,0.15,0.69444,	-1.21392,0.15,0.89088,
	-1.065,0.15,1.065,	-1.07494,0.177075,1.07494,	-1.22525,0.177075,0.899195,
	-1.22525,0.177075,0.899195,	-1.21392,0.15,0.89088,	-1.065,0.15,1.065,
	-0.89088,0.15,1.21392,	-0.899195,0.177075,1.22525,	-1.07494,0.177075,1.07494,
	-1.07494,0.177075,1.07494,	-1.065,0.15,1.065,	-0.89088,0.15,1.21392,
	-0.69444,0.15,1.33476,	-0.700921,0.177075,1.347218,	-0.899195,0.177075,1.22525,
	-0.899195,0.177075,1.22525,	-0.89088,0.15,1.21392,	-0.69444,0.15,1.33476,
	-0.47856,0.15,1.42464,	-0.483027,0.177075,1.437937,	-0.700921,0.177075,1.347218,
	-0.700921,0.177075,1.347218,	-0.69444,0.15,1.33476,	-0.47856,0.15,1.42464,
	-0.24612,0.15,1.48068,	-0.248417,0.177075,1.4945,	-0.483027,0.177075,1.437937,
	-0.483027,0.177075,1.437937,	-0.47856,0.15,1.42464,	-0.24612,0.15,1.48068,
	0,0.15,1.5,	0,0.177075,1.514,	-0.248417,0.177075,1.4945,
	-0.248417,0.177075,1.4945,	-0.24612,0.15,1.48068,	0,0.15,1.5,
	0.325863,0.771675,1.96042,	0.32816,0.9,1.97424,	0,0.9,2,
	0,0.9,2,	0,0.771675,1.986,	0.325863,0.771675,1.96042,
	0.633613,0.771675,1.886223,	0.63808,0.9,1.89952,	0.32816,0.9,1.97424,
	0.32816,0.9,1.97424,	0.325863,0.771675,1.96042,	0.633613,0.771675,1.886223,
	0.919439,0.771675,1.767222,	0.92592,0.9,1.77968,	0.63808,0.9,1.89952,
	0.63808,0.9,1.89952,	0.633613,0.771675,1.886223,	0.919439,0.771675,1.767222,
	1.179525,0.771675,1.60723,	1.18784,0.9,1.61856,	0.92592,0.9,1.77968,
	0.92592,0.9,1.77968,	0.919439,0.771675,1.767222,	1.179525,0.771675,1.60723,
	1.41006,0.771675,1.41006,	1.42,0.9,1.42,	1.18784,0.9,1.61856,
	1.18784,0.9,1.61856,	1.179525,0.771675,1.60723,	1.41006,0.771675,1.41006,
	1.60723,0.771675,1.179525,	1.61856,0.9,1.18784,	1.42,0.9,1.42,
	1.42,0.9,1.42,	1.41006,0.771675,1.41006,	1.60723,0.771675,1.179525,
	1.767222,0.771675,0.919439,	1.77968,0.9,0.92592,	1.61856,0.9,1.18784,
	1.61856,0.9,1.18784,	1.60723,0.771675,1.179525,	1.767222,0.771675,0.919439,
	1.886223,0.771675,0.633613,	1.89952,0.9,0.63808,	1.77968,0.9,0.92592,
	1.77968,0.9,0.92592,	1.767222,0.771675,0.919439,	1.886223,0.771675,0.633613,
	1.96042,0.771675,0.325863,	1.97424,0.9,0.32816,	1.89952,0.9,0.63808,
	1.89952,0.9,0.63808,	1.886223,0.771675,0.633613,	1.96042,0.771675,0.325863,
	1.986,0.771675,0,	2,0.9,0,	1.97424,0.9,0.32816,
	1.97424,0.9,0.32816,	1.96042,0.771675,0.325863,	1.986,0.771675,0,
	0.319628,0.6564,1.92291,	0.325863,0.771675,1.96042,	0,0.771675,1.986,
	0,0.771675,1.986,	0,0.6564,1.948,	0.319628,0.6564,1.92291,
	0.62149,0.6564,1.850132,	0.633613,0.771675,1.886223,	0.325863,0.771675,1.96042,
	0.325863,0.771675,1.96042,	0.319628,0.6564,1.92291,	0.62149,0.6564,1.850132,
	0.901846,0.6564,1.733408,	0.919439,0.771675,1.767222,	0.633613,0.771675,1.886223,
	0.633613,0.771675,1.886223,	0.62149,0.6564,1.850132,	0.901846,0.6564,1.733408,
	1.156956,0.6564,1.576477,	1.179525,0.771675,1.60723,	0.919439,0.771675,1.767222,
	0.919439,0.771675,1.767222,	0.901846,0.6564,1.733408,	1.156956,0.6564,1.576477,
	1.38308,0.6564,1.38308,	1.41006,0.771675,1.41006,	1.179525,0.771675,1.60723,
	1.179525,0.771675,1.60723,	1.156956,0.6564,1.576477,	1.38308,0.6564,1.38308,
	1.576477,0.6564,1.156956,	1.60723,0.771675,1.179525,	1.41006,0.771675,1.41006,
	1.41006,0.771675,1.41006,	1.38308,0.6564,1.38308,	1.576477,0.6564,1.156956,
	1.733408,0.6564,0.901846,	1.767222,0.771675,0.919439,	1.60723,0.771675,1.179525,
	1.60723,0.771675,1.179525,	1.576477,0.6564,1.156956,	1.733408,0.6564,0.901846,
	1.850132,0.6564,0.62149,	1.886223,0.771675,0.633613,	1.767222,0.771675,0.919439,
	1.767222,0.771675,0.919439,	1.733408,0.6564,0.901846,	1.850132,0.6564,0.62149,
	1.92291,0.6564,0.319628,	1.96042,0.771675,0.325863,	1.886223,0.771675,0.633613,
	1.886223,0.771675,0.633613,	1.850132,0.6564,0.62149,	1.92291,0.6564,0.319628,
	1.948,0.6564,0,	1.986,0.771675,0,	1.96042,0.771675,0.325863,
	1.96042,0.771675,0.325863,	1.92291,0.6564,0.319628,	1.948,0.6564,0,
	0.310439,0.553725,1.867631,	0.319628,0.6564,1.92291,	0,0.6564,1.948,
	0,0.6564,1.948,	0,0.553725,1.892,	0.310439,0.553725,1.867631,
	0.603624,0.553725,1.796946,	0.62149,0.6564,1.850132,	0.319628,0.6564,1.92291,
	0.319628,0.6564,1.92291,	0.310439,0.553725,1.867631,	0.603624,0.553725,1.796946,
	0.87592,0.553725,1.683577,	0.901846,0.6564,1.733408,	0.62149,0.6564,1.850132,
	0.62149,0.6564,1.850132,	0.603624,0.553725,1.796946,	0.87592,0.553725,1.683577,
	1.123697,0.553725,1.531158,	1.156956,0.6564,1.576477,	0.901846,0.6564,1.733408,
	0.901846,0.6564,1.733408,	0.87592,0.553725,1.683577,	1.123697,0.553725,1.531158,
	1.34332,0.553725,1.34332,	1.38308,0.6564,1.38308,	1.156956,0.6564,1.576477,
	1.156956,0.6564,1.576477,	1.123697,0.553725,1.531158,	1.34332,0.553725,1.34332,
	1.531158,0.553725,1.123697,	1.576477,0.6564,1.156956,	1.38308,0.6564,1.38308,
	1.38308,0.6564,1.38308,	1.34332,0.553725,1.34332,	1.531158,0.553725,1.123697,
	1.683577,0.553725,0.87592,	1.733408,0.6564,0.901846,	1.576477,0.6564,1.156956,
	1.576477,0.6564,1.156956,	1.531158,0.553725,1.123697,	1.683577,0.553725,0.87592,
	1.796946,0.553725,0.603624,	1.850132,0.6564,0.62149,	1.733408,0.6564,0.901846,
	1.733408,0.6564,0.901846,	1.683577,0.553725,0.87592,	1.796946,0.553725,0.603624,
	1.867631,0.553725,0.310439,	1.92291,0.6564,0.319628,	1.850132,0.6564,0.62149,
	1.850132,0.6564,0.62149,	1.796946,0.553725,0.603624,	1.867631,0.553725,0.310439,
	1.892,0.553725,0,	1.948,0.6564,0,	1.92291,0.6564,0.319628,
	1.92291,0.6564,0.319628,	1.867631,0.553725,0.310439,	1.892,0.553725,0,
	0.299282,0.4632,1.800507,	0.310439,0.553725,1.867631,	0,0.553725,1.892,
	0,0.553725,1.892,	0,0.4632,1.824,	0.299282,0.4632,1.800507,
	0.581929,0.4632,1.732362,	0.603624,0.553725,1.796946,	0.310439,0.553725,1.867631,
	0.310439,0.553725,1.867631,	0.299282,0.4632,1.800507,	0.581929,0.4632,1.732362,
	0.844439,0.4632,1.623068,	0.87592,0.553725,1.683577,	0.603624,0.553725,1.796946,
	0.603624,0.553725,1.796946,	0.581929,0.4632,1.732362,	0.844439,0.4632,1.623068,
	1.08331,0.4632,1.476127,	1.123697,0.553725,1.531158,	0.87592,0.553725,1.683577,
	0.87592,0.553725,1.683577,	0.844439,0.4632,1.623068,	1.08331,0.4632,1.476127,
	1.29504,0.4632,1.29504,	1.34332,0.553725,1.34332,	1.123697,0.553725,1.531158,
	1.123697,0.553725,1.531158,	1.08331,0.4632,1.476127,	1.29504,0.4632,1.29504,
	1.476127,0.4632,1.08331,	1.531158,0.553725,1.123697,	1.34332,0.553725,1.34332,
	1.34332,0.553725,1.34332,	1.29504,0.4632,1.29504,	1.476127,0.4632,1.08331,
	1.623068,0.4632,0.844439,	1.683577,0.553725,0.87592,	1.531158,0.553725,1.123697,
	1.531158,0.553725,1.123697,	1.476127,0.4632,1.08331,	1.623068,0.4632,0.844439,
	1.732362,0.4632,0.581929,	1.796946,0.553725,0.603624,	1.683577,0.553725,0.87592,
	1.683577,0.553725,0.87592,	1.623068,0.4632,0.844439,	1.732362,0.4632,0.581929,
	1.800507,0.4632,0.299282,	1.867631,0.553725,0.310439,	1.796946,0.553725,0.603624,
	1.796946,0.553725,0.603624,	1.732362,0.4632,0.581929,	1.800507,0.4632,0.299282,
	1.824,0.4632,0,	1.892,0.553725,0,	1.867631,0.553725,0.310439,
	1.867631,0.553725,0.310439,	1.800507,0.4632,0.299282,	1.824,0.4632,0,
	0.28714,0.384375,1.72746,	0.299282,0.4632,1.800507,	0,0.4632,1.824,
	0,0.4632,1.824,	0,0.384375,1.75,	0.28714,0.384375,1.72746,
	0.55832,0.384375,1.66208,	0.581929,0.4632,1.732362,	0.299282,0.4632,1.800507,
	0.299282,0.4632,1.800507,	0.28714,0.384375,1.72746,	0.55832,0.384375,1.66208,
	0.81018,0.384375,1.55722,	0.844439,0.4632,1.623068,	0.581929,0.4632,1.732362,
	0.581929,0.4632,1.732362,	0.55832,0.384375,1.66208,	0.81018,0.384375,1.55722,
	1.03936,0.384375,1.41624,	1.08331,0.4632,1.476127,	0.844439,0.4632,1.623068,
	0.844439,0.4632,1.623068,	0.81018,0.384375,1.55722,	1.03936,0.384375,1.41624,
	1.2425,0.384375,1.2425,	1.29504,0.4632,1.29504,	1.08331,0.4632,1.476127,
	1.08331,0.4632,1.476127,	1.03936,0.384375,1.41624,	1.2425,0.384375,1.2425,
	1.41624,0.384375,1.03936,	1.476127,0.4632,1.08331,	1.29504,0.4632,1.29504,
	1.29504,0.4632,1.29504,	1.2425,0.384375,1.2425,	1.41624,0.384375,1.03936,
	1.55722,0.384375,0.81018,	1.623068,0.4632,0.844439,	1.476127,0.4632,1.08331,
	1.476127,0.4632,1.08331,	1.41624,0.384375,1.03936,	1.55722,0.384375,0.81018,
	1.66208,0.384375,0.55832,	1.732362,0.4632,0.581929,	1.623068,0.4632,0.844439,
	1.623068,0.4632,0.844439,	1.55722,0.384375,0.81018,	1.66208,0.384375,0.55832,
	1.72746,0.384375,0.28714,	1.800507,0.4632,0.299282,	1.732362,0.4632,0.581929,
	1.732362,0.4632,0.581929,	1.66208,0.384375,0.55832,	1.72746,0.384375,0.28714,
	1.75,0.384375,0,	1.824,0.4632,0,	1.800507,0.4632,0.299282,
	1.800507,0.4632,0.299282,	1.72746,0.384375,0.28714,	1.75,0.384375,0,
	0.274998,0.3168,1.654413,	0.28714,0.384375,1.72746,	0,0.384375,1.75,
	0,0.384375,1.75,	0,0.3168,1.676,	0.274998,0.3168,1.654413,
	0.534711,0.3168,1.591798,	0.55832,0.384375,1.66208,	0.28714,0.384375,1.72746,
	0.28714,0.384375,1.72746,	0.274998,0.3168,1.654413,	0.534711,0.3168,1.591798,
	0.775921,0.3168,1.491372,	0.81018,0.384375,1.55722,	0.55832,0.384375,1.66208,
	0.55832,0.384375,1.66208,	0.534711,0.3168,1.591798,	0.775921,0.3168,1.491372,
	0.99541,0.3168,1.356353,	1.03936,0.384375,1.41624,	0.81018,0.384375,1.55722,
	0.81018,0.384375,1.55722,	0.775921,0.3168,1.491372,	0.99541,0.3168,1.356353,
	1.18996,0.3168,1.18996,	1.2425,0.384375,1.2425,	1.03936,0.384375,1.41624,
	1.03936,0.384375,1.41624,	0.99541,0.3168,1.356353,	1.18996,0.3168,1.18996,
	1.356353,0.3168,0.99541,	1.41624,0.384375,1.03936,	1.2425,0.384375,1.2425,
	1.2425,0.384375,1.2425,	1.18996,0.3168,1.18996,	1.356353,0.3168,0.99541,
	1.491372,0.3168,0.775921,	1.55722,0.384375,0.81018,	1.41624,0.384375,1.03936,
	1.41624,0.384375,1.03936,	1.356353,0.3168,0.99541,	1.491372,0.3168,0.775921,
	1.591798,0.3168,0.534711,	1.66208,0.384375,0.55832,	1.55722,0.384375,0.81018,
	1.55722,0.384375,0.81018,	1.491372,0.3168,0.775921,	1.591798,0.3168,0.534711,
	1.654413,0.3168,0.274998,	1.72746,0.384375,0.28714,	1.66208,0.384375,0.55832,
	1.66208,0.384375,0.55832,	1.591798,0.3168,0.534711,	1.654413,0.3168,0.274998,
	1.676,0.3168,0,	1.75,0.384375,0,	1.72746,0.384375,0.28714,
	1.72746,0.384375,0.28714,	1.654413,0.3168,0.274998,	1.676,0.3168,0,
	0.263841,0.260025,1.587289,	0.274998,0.3168,1.654413,	0,0.3168,1.676,
	0,0.3168,1.676,	0,0.260025,1.608,	0.263841,0.260025,1.587289,
	0.513016,0.260025,1.527214,	0.534711,0.3168,1.591798,	0.274998,0.3168,1.654413,
	0.274998,0.3168,1.654413,	0.263841,0.260025,1.587289,	0.513016,0.260025,1.527214,
	0.74444,0.260025,1.430863,	0.775921,0.3168,1.491372,	0.534711,0.3168,1.591798,
	0.534711,0.3168,1.591798,	0.513016,0.260025,1.527214,	0.74444,0.260025,1.430863,
	0.955023,0.260025,1.301322,	0.99541,0.3168,1.356353,	0.775921,0.3168,1.491372,
	0.775921,0.3168,1.491372,	0.74444,0.260025,1.430863,	0.955023,0.260025,1.301322,
	1.14168,0.260025,1.14168,	1.18996,0.3168,1.18996,	0.99541,0.3168,1.356353,
	0.99541,0.3168,1.356353,	0.955023,0.260025,1.301322,	1.14168,0.260025,1.14168,
	1.301322,0.260025,0.955023,	1.356353,0.3168,0.99541,	1.18996,0.3168,1.18996,
	1.18996,0.3168,1.18996,	1.14168,0.260025,1.14168,	1.301322,0.260025,0.955023,
	1.430863,0.260025,0.74444,	1.491372,0.3168,0.775921,	1.356353,0.3168,0.99541,
	1.356353,0.3168,0.99541,	1.301322,0.260025,0.955023,	1.430863,0.260025,0.74444,
	1.527214,0.260025,0.513016,	1.591798,0.3168,0.534711,	1.491372,0.3168,0.775921,
	1.491372,0.3168,0.775921,	1.430863,0.260025,0.74444,	1.527214,0.260025,0.513016,
	1.587289,0.260025,0.263841,	1.654413,0.3168,0.274998,	1.591798,0.3168,0.534711,
	1.591798,0.3168,0.534711,	1.527214,0.260025,0.513016,	1.587289,0.260025,0.263841,
	1.608,0.260025,0,	1.676,0.3168,0,	1.654413,0.3168,0.274998,
	1.654413,0.3168,0.274998,	1.587289,0.260025,0.263841,	1.608,0.260025,0,
	0.254652,0.2136,1.53201,	0.263841,0.260025,1.587289,	0,0.260025,1.608,
	0,0.260025,1.608,	0,0.2136,1.552,	0.254652,0.2136,1.53201,
	0.49515,0.2136,1.474028,	0.513016,0.260025,1.527214,	0.263841,0.260025,1.587289,
	0.263841,0.260025,1.587289,	0.254652,0.2136,1.53201,	0.49515,0.2136,1.474028,
	0.718514,0.2136,1.381032,	0.74444,0.260025,1.430863,	0.513016,0.260025,1.527214,
	0.513016,0.260025,1.527214,	0.49515,0.2136,1.474028,	0.718514,0.2136,1.381032,
	0.921764,0.2136,1.256003,	0.955023,0.260025,1.301322,	0.74444,0.260025,1.430863,
	0.74444,0.260025,1.430863,	0.718514,0.2136,1.381032,	0.921764,0.2136,1.256003,
	1.10192,0.2136,1.10192,	1.14168,0.260025,1.14168,	0.955023,0.260025,1.301322,
	0.955023,0.260025,1.301322,	0.921764,0.2136,1.256003,	1.10192,0.2136,1.10192,
	1.256003,0.2136,0.921764,	1.301322,0.260025,0.955023,	1.14168,0.260025,1.14168,
	1.14168,0.260025,1.14168,	1.10192,0.2136,1.10192,	1.256003,0.2136,0.921764,
	1.381032,0.2136,0.718514,	1.430863,0.260025,0.74444,	1.301322,0.260025,0.955023,
	1.301322,0.260025,0.955023,	1.256003,0.2136,0.921764,	1.381032,0.2136,0.718514,
	1.474028,0.2136,0.49515,	1.527214,0.260025,0.513016,	1.430863,0.260025,0.74444,
	1.430863,0.260025,0.74444,	1.381032,0.2136,0.718514,	1.474028,0.2136,0.49515,
	1.53201,0.2136,0.254652,	1.587289,0.260025,0.263841,	1.527214,0.260025,0.513016,
	1.527214,0.260025,0.513016,	1.474028,0.2136,0.49515,	1.53201,0.2136,0.254652,
	1.552,0.2136,0,	1.608,0.260025,0,	1.587289,0.260025,0.263841,
	1.587289,0.260025,0.263841,	1.53201,0.2136,0.254652,	1.552,0.2136,0,
	0.248417,0.177075,1.4945,	0.254652,0.2136,1.53201,	0,0.2136,1.552,
	0,0.2136,1.552,	0,0.177075,1.514,	0.248417,0.177075,1.4945,
	0.483027,0.177075,1.437937,	0.49515,0.2136,1.474028,	0.254652,0.2136,1.53201,
	0.254652,0.2136,1.53201,	0.248417,0.177075,1.4945,	0.483027,0.177075,1.437937,
	0.700921,0.177075,1.347218,	0.718514,0.2136,1.381032,	0.49515,0.2136,1.474028,
	0.49515,0.2136,1.474028,	0.483027,0.177075,1.437937,	0.700921,0.177075,1.347218,
	0.899195,0.177075,1.22525,	0.921764,0.2136,1.256003,	0.718514,0.2136,1.381032,
	0.718514,0.2136,1.381032,	0.700921,0.177075,1.347218,	0.899195,0.177075,1.22525,
	1.07494,0.177075,1.07494,	1.10192,0.2136,1.10192,	0.921764,0.2136,1.256003,
	0.921764,0.2136,1.256003,	0.899195,0.177075,1.22525,	1.07494,0.177075,1.07494,
	1.22525,0.177075,0.899195,	1.256003,0.2136,0.921764,	1.10192,0.2136,1.10192,
	1.10192,0.2136,1.10192,	1.07494,0.177075,1.07494,	1.22525,0.177075,0.899195,
	1.347218,0.177075,0.700921,	1.381032,0.2136,0.718514,	1.256003,0.2136,0.921764,
	1.256003,0.2136,0.921764,	1.22525,0.177075,0.899195,	1.347218,0.177075,0.700921,
	1.437937,0.177075,0.483027,	1.474028,0.2136,0.49515,	1.381032,0.2136,0.718514,
	1.381032,0.2136,0.718514,	1.347218,0.177075,0.700921,	1.437937,0.177075,0.483027,
	1.4945,0.177075,0.248417,	1.53201,0.2136,0.254652,	1.474028,0.2136,0.49515,
	1.474028,0.2136,0.49515,	1.437937,0.177075,0.483027,	1.4945,0.177075,0.248417,
	1.514,0.177075,0,	1.552,0.2136,0,	1.53201,0.2136,0.254652,
	1.53201,0.2136,0.254652,	1.4945,0.177075,0.248417,	1.514,0.177075,0,
	0.24612,0.15,1.48068,	0.248417,0.177075,1.4945,	0,0.177075,1.514,
	0,0.177075,1.514,	0,0.15,1.5,	0.24612,0.15,1.48068,
	0.47856,0.15,1.42464,	0.483027,0.177075,1.437937,	0.248417,0.177075,1.4945,
	0.248417,0.177075,1.4945,	0.24612,0.15,1.48068,	0.47856,0.15,1.42464,
	0.69444,0.15,1.33476,	0.700921,0.177075,1.347218,	0.483027,0.177075,1.437937,
	0.483027,0.177075,1.437937,	0.47856,0.15,1.42464,	0.69444,0.15,1.33476,
	0.89088,0.15,1.21392,	0.899195,0.177075,1.22525,	0.700921,0.177075,1.347218,
	0.700921,0.177075,1.347218,	0.69444,0.15,1.33476,	0.89088,0.15,1.21392,
	1.065,0.15,1.065,	1.07494,0.177075,1.07494,	0.899195,0.177075,1.22525,
	0.899195,0.177075,1.22525,	0.89088,0.15,1.21392,	1.065,0.15,1.065,
	1.21392,0.15,0.89088,	1.22525,0.177075,0.899195,	1.07494,0.177075,1.07494,
	1.07494,0.177075,1.07494,	1.065,0.15,1.065,	1.21392,0.15,0.89088,
	1.33476,0.15,0.69444,	1.347218,0.177075,0.700921,	1.22525,0.177075,0.899195,
	1.22525,0.177075,0.899195,	1.21392,0.15,0.89088,	1.33476,0.15,0.69444,
	1.42464,0.15,0.47856,	1.437937,0.177075,0.483027,	1.347218,0.177075,0.700921,
	1.347218,0.177075,0.700921,	1.33476,0.15,0.69444,	1.42464,0.15,0.47856,
	1.48068,0.15,0.24612,	1.4945,0.177075,0.248417,	1.437937,0.177075,0.483027,
	1.437937,0.177075,0.483027,	1.42464,0.15,0.47856,	1.48068,0.15,0.24612,
	1.5,0.15,0,	1.514,0.177075,0,	1.4945,0.177075,0.248417,
	1.4945,0.177075,0.248417,	1.48068,0.15,0.24612,	1.5,0.15,0,
	-1.800455,2.031069,-0.081,	-1.5972,2.0313,-0.081,	-1.6,2.025,0,
	-1.6,2.025,0,	-1.8009,2.024775,0,	-1.800455,2.031069,-0.081,
	-1.799246,2.048152,-0.144,	-1.5896,2.0484,-0.144,	-1.5972,2.0313,-0.081,
	-1.5972,2.0313,-0.081,	-1.800455,2.031069,-0.081,	-1.799246,2.048152,-0.144,
	-1.797466,2.073326,-0.189,	-1.5784,2.0736,-0.189,	-1.5896,2.0484,-0.144,
	-1.5896,2.0484,-0.144,	-1.799246,2.048152,-0.144,	-1.797466,2.073326,-0.189,
	-1.795303,2.103896,-0.216,	-1.5648,2.1042,-0.216,	-1.5784,2.0736,-0.189,
	-1.5784,2.0736,-0.189,	-1.797466,2.073326,-0.189,	-1.795303,2.103896,-0.216,
	-1.79295,2.137163,-0.225,	-1.55,2.1375,-0.225,	-1.5648,2.1042,-0.216,
	-1.5648,2.1042,-0.216,	-1.795303,2.103896,-0.216,	-1.79295,2.137163,-0.225,
	-1.790597,2.170429,-0.216,	-1.5352,2.1708,-0.216,	-1.55,2.1375,-0.225,
	-1.55,2.1375,-0.225,	-1.79295,2.137163,-0.225,	-1.790597,2.170429,-0.216,
	-1.788434,2.200999,-0.189,	-1.5216,2.2014,-0.189,	-1.5352,2.1708,-0.216,
	-1.5352,2.1708,-0.216,	-1.790597,2.170429,-0.216,	-1.788434,2.200999,-0.189,
	-1.786654,2.226173,-0.144,	-1.5104,2.2266,-0.144,	-1.5216,2.2014,-0.189,
	-1.5216,2.2014,-0.189,	-1.788434,2.200999,-0.189,	-1.786654,2.226173,-0.144,
	-1.785445,2.243256,-0.081,	-1.5028,2.2437,-0.081,	-1.5104,2.2266,-0.144,
	-1.5104,2.2266,-0.144,	-1.786654,2.226173,-0.144,	-1.785445,2.243256,-0.081,
	-1.785,2.24955,0,	-1.5,2.25,0,	-1.5028,2.2437,-0.081,
	-1.5028,2.2437,-0.081,	-1.785445,2.243256,-0.081,	-1.785,2.24955,0,
	-1.98479,2.02945,-0.081,	-1.800455,2.031069,-0.081,	-1.8009,2.024775,0,
	-1.8009,2.024775,0,	-1.9832,2.0232,0,	-1.98479,2.02945,-0.081,
	-1.989107,2.046413,-0.144,	-1.799246,2.048152,-0.144,	-1.800455,2.031069,-0.081,
	-1.800455,2.031069,-0.081,	-1.98479,2.02945,-0.081,	-1.989107,2.046413,-0.144,
	-1.995469,2.071411,-0.189,	-1.797466,2.073326,-0.189,	-1.799246,2.048152,-0.144,
	-1.799246,2.048152,-0.144,	-1.989107,2.046413,-0.144,	-1.995469,2.071411,-0.189,
	-2.003194,2.101766,-0.216,	-1.795303,2.103896,-0.216,	-1.797466,2.073326,-0.189,
	-1.797466,2.073326,-0.189,	-1.995469,2.071411,-0.189,	-2.003194,2.101766,-0.216,
	-2.0116,2.1348,-0.225,	-1.79295,2.137163,-0.225,	-1.795303,2.103896,-0.216,
	-1.795303,2.103896,-0.216,	-2.003194,2.101766,-0.216,	-2.0116,2.1348,-0.225,
	-2.020006,2.167834,-0.216,	-1.790597,2.170429,-0.216,	-1.79295,2.137163,-0.225,
	-1.79295,2.137163,-0.225,	-2.0116,2.1348,-0.225,	-2.020006,2.167834,-0.216,
	-2.027731,2.198189,-0.189,	-1.788434,2.200999,-0.189,	-1.790597,2.170429,-0.216,
	-1.790597,2.170429,-0.216,	-2.020006,2.167834,-0.216,	-2.027731,2.198189,-0.189,
	-2.034093,2.223187,-0.144,	-1.786654,2.226173,-0.144,	-1.788434,2.200999,-0.189,
	-1.788434,2.200999,-0.189,	-2.027731,2.198189,-0.189,	-2.034093,2.223187,-0.144,
	-2.03841,2.24015,-0.081,	-1.785445,2.243256,-0.081,	-1.786654,2.226173,-0.144,
	-1.786654,2.226173,-0.144,	-2.034093,2.223187,-0.144,	-2.03841,2.24015,-0.081,
	-2.04,2.2464,0,	-1.785,2.24955,0,	-1.785445,2.243256,-0.081,
	-1.785445,2.243256,-0.081,	-2.03841,2.24015,-0.081,	-2.04,2.2464,0,
	-2.149624,2.025055,-0.081,	-1.98479,2.02945,-0.081,	-1.9832,2.0232,0,
	-1.9832,2.0232,0,	-2.1463,2.018925,0,	-2.149624,2.025055,-0.081,
	-2.158645,2.041693,-0.144,	-1.989107,2.046413,-0.144,	-1.98479,2.02945,-0.081,
	-1.98479,2.02945,-0.081,	-2.149624,2.025055,-0.081,	-2.158645,2.041693,-0.144,
	-2.171939,2.066213,-0.189,	-1.995469,2.071411,-0.189,	-1.989107,2.046413,-0.144,
	-1.989107,2.046413,-0.144,	-2.158645,2.041693,-0.144,	-2.171939,2.066213,-0.189,
	-2.188082,2.095987,-0.216,	-2.003194,2.101766,-0.216,	-1.995469,2.071411,-0.189,
	-1.995469,2.071411,-0.189,	-2.171939,2.066213,-0.189,	-2.188082,2.095987,-0.216,
	-2.20565,2.128388,-0.225,	-2.0116,2.1348,-0.225,	-2.003194,2.101766,-0.216,
	-2.003194,2.101766,-0.216,	-2.188082,2.095987,-0.216,	-2.20565,2.128388,-0.225,
	-2.223218,2.160788,-0.216,	-2.020006,2.167834,-0.216,	-2.0116,2.1348,-0.225,
	-2.0116,2.1348,-0.225,	-2.20565,2.128388,-0.225,	-2.223218,2.160788,-0.216,
	-2.239361,2.190562,-0.189,	-2.027731,2.198189,-0.189,	-2.020006,2.167834,-0.216,
	-2.020006,2.167834,-0.216,	-2.223218,2.160788,-0.216,	-2.239361,2.190562,-0.189,
	-2.252655,2.215082,-0.144,	-2.034093,2.223187,-0.144,	-2.027731,2.198189,-0.189,
	-2.027731,2.198189,-0.189,	-2.239361,2.190562,-0.189,	-2.252655,2.215082,-0.144,
	-2.261676,2.23172,-0.081,	-2.03841,2.24015,-0.081,	-2.034093,2.223187,-0.144,
	-2.034093,2.223187,-0.144,	-2.252655,2.215082,-0.144,	-2.261676,2.23172,-0.081,
	-2.265,2.23785,0,	-2.04,2.2464,0,	-2.03841,2.24015,-0.081,
	-2.03841,2.24015,-0.081,	-2.261676,2.23172,-0.081,	-2.265,2.23785,0,
	-2.294371,2.016497,-0.081,	-2.149624,2.025055,-0.081,	-2.1463,2.018925,0,
	-2.1463,2.018925,0,	-2.2896,2.0106,0,	-2.294371,2.016497,-0.081,
	-2.307322,2.032502,-0.144,	-2.158645,2.041693,-0.144,	-2.149624,2.025055,-0.081,
	-2.149624,2.025055,-0.081,	-2.294371,2.016497,-0.081,	-2.307322,2.032502,-0.144,
	-2.326406,2.05609,-0.189,	-2.171939,2.066213,-0.189,	-2.158645,2.041693,-0.144,
	-2.158645,2.041693,-0.144,	-2.307322,2.032502,-0.144,	-2.326406,2.05609,-0.189,
	-2.349581,2.084731,-0.216,	-2.188082,2.095987,-0.216,	-2.171939,2.066213,-0.189,
	-2.171939,2.066213,-0.189,	-2.326406,2.05609,-0.189,	-2.349581,2.084731,-0.216,
	-2.3748,2.1159,-0.225,	-2.20565,2.128388,-0.225,	-2.188082,2.095987,-0.216,
	-2.188082,2.095987,-0.216,	-2.349581,2.084731,-0.216,	-2.3748,2.1159,-0.225,
	-2.400019,2.147069,-0.216,	-2.223218,2.160788,-0.216,	-2.20565,2.128388,-0.225,
	-2.20565,2.128388,-0.225,	-2.3748,2.1159,-0.225,	-2.400019,2.147069,-0.216,
	-2.423194,2.17571,-0.189,	-2.239361,2.190562,-0.189,	-2.223218,2.160788,-0.216,
	-2.223218,2.160788,-0.216,	-2.400019,2.147069,-0.216,	-2.423194,2.17571,-0.189,
	-2.442278,2.199298,-0.144,	-2.252655,2.215082,-0.144,	-2.239361,2.190562,-0.189,
	-2.239361,2.190562,-0.189,	-2.423194,2.17571,-0.189,	-2.442278,2.199298,-0.144,
	-2.455229,2.215303,-0.081,	-2.261676,2.23172,-0.081,	-2.252655,2.215082,-0.144,
	-2.252655,2.215082,-0.144,	-2.442278,2.199298,-0.144,	-2.455229,2.215303,-0.081,
	-2.46,2.2212,0,	-2.265,2.23785,0,	-2.261676,2.23172,-0.081,
	-2.261676,2.23172,-0.081,	-2.455229,2.215303,-0.081,	-2.46,2.2212,0,
	-2.41845,2.002387,-0.081,	-2.294371,2.016497,-0.081,	-2.2896,2.0106,0,
	-2.2896,2.0106,0,	-2.4125,1.996875,0,	-2.41845,2.002387,-0.081,
	-2.4346,2.01735,-0.144,	-2.307322,2.032502,-0.144,	-2.294371,2.016497,-0.081,
	-2.294371,2.016497,-0.081,	-2.41845,2.002387,-0.081,	-2.4346,2.01735,-0.144,
	-2.4584,2.0394,-0.189,	-2.326406,2.05609,-0.189,	-2.307322,2.032502,-0.144,
	-2.307322,2.032502,-0.144,	-2.4346,2.01735,-0.144,	-2.4584,2.0394,-0.189,
	-2.4873,2.066175,-0.216,	-2.349581,2.084731,-0.216,	-2.326406,2.05609,-0.189,
	-2.326406,2.05609,-0.189,	-2.4584,2.0394,-0.189,	-2.4873,2.066175,-0.216,
	-2.51875,2.095312,-0.225,	-2.3748,2.1159,-0.225,	-2.349581,2.084731,-0.216,
	-2.349581,2.084731,-0.216,	-2.4873,2.066175,-0.216,	-2.51875,2.095312,-0.225,
	-2.5502,2.12445,-0.216,	-2.400019,2.147069,-0.216,	-2.3748,2.1159,-0.225,
	-2.3748,2.1159,-0.225,	-2.51875,2.095312,-0.225,	-2.5502,2.12445,-0.216,
	-2.5791,2.151225,-0.189,	-2.423194,2.17571,-0.189,	-2.400019,2.147069,-0.216,
	-2.400019,2.147069,-0.216,	-2.5502,2.12445,-0.216,	-2.5791,2.151225,-0.189,
	-2.6029,2.173275,-0.144,	-2.442278,2.199298,-0.144,	-2.423194,2.17571,-0.189,
	-2.423194,2.17571,-0.189,	-2.5791,2.151225,-0.189,	-2.6029,2.173275,-0.144,
	-2.61905,2.188238,-0.081,	-2.455229,2.215303,-0.081,	-2.442278,2.199298,-0.144,
	-2.442278,2.199298,-0.144,	-2.6029,2.173275,-0.144,	-2.61905,2.188238,-0.081,
	-2.625,2.19375,0,	-2.46,2.2212,0,	-2.455229,2.215303,-0.081,
	-2.455229,2.215303,-0.081,	-2.61905,2.188238,-0.081,	-2.625,2.19375,0,
	-2.521277,1.981339,-0.081,	-2.41845,2.002387,-0.081,	-2.4125,1.996875,0,
	-2.4125,1.996875,0,	-2.5144,1.9764,0,	-2.521277,1.981339,-0.081,
	-2.539942,1.994746,-0.144,	-2.4346,2.01735,-0.144,	-2.41845,2.002387,-0.081,
	-2.41845,2.002387,-0.081,	-2.521277,1.981339,-0.081,	-2.539942,1.994746,-0.144,
	-2.56745,2.014502,-0.189,	-2.4584,2.0394,-0.189,	-2.4346,2.01735,-0.144,
	-2.4346,2.01735,-0.144,	-2.539942,1.994746,-0.144,	-2.56745,2.014502,-0.189,
	-2.600851,2.038493,-0.216,	-2.4873,2.066175,-0.216,	-2.4584,2.0394,-0.189,
	-2.4584,2.0394,-0.189,	-2.56745,2.014502,-0.189,	-2.600851,2.038493,-0.216,
	-2.6372,2.0646,-0.225,	-2.51875,2.095312,-0.225,	-2.4873,2.066175,-0.216,
	-2.4873,2.066175,-0.216,	-2.600851,2.038493,-0.216,	-2.6372,2.0646,-0.225,
	-2.673549,2.090707,-0.216,	-2.5502,2.12445,-0.216,	-2.51875,2.095312,-0.225,
	-2.51875,2.095312,-0.225,	-2.6372,2.0646,-0.225,	-2.673549,2.090707,-0.216,
	-2.70695,2.114698,-0.189,	-2.5791,2.151225,-0.189,	-2.5502,2.12445,-0.216,
	-2.5502,2.12445,-0.216,	-2.673549,2.090707,-0.216,	-2.70695,2.114698,-0.189,
	-2.734458,2.134454,-0.144,	-2.6029,2.173275,-0.144,	-2.5791,2.151225,-0.189,
	-2.5791,2.151225,-0.189,	-2.70695,2.114698,-0.189,	-2.734458,2.134454,-0.144,
	-2.753123,2.147861,-0.081,	-2.61905,2.188238,-0.081,	-2.6029,2.173275,-0.144,
	-2.6029,2.173275,-0.144,	-2.734458,2.134454,-0.144,	-2.753123,2.147861,-0.081,
	-2.76,2.1528,0,	-2.625,2.19375,0,	-2.61905,2.188238,-0.081,
	-2.61905,2.188238,-0.081,	-2.753123,2.147861,-0.081,	-2.76,2.1528,0,
	-2.602268,1.951964,-0.081,	-2.521277,1.981339,-0.081,	-2.5144,1.9764,0,
	-2.5144,1.9764,0,	-2.5947,1.947825,0,	-2.602268,1.951964,-0.081,
	-2.622811,1.963199,-0.144,	-2.539942,1.994746,-0.144,	-2.521277,1.981339,-0.081,
	-2.521277,1.981339,-0.081,	-2.602268,1.951964,-0.081,	-2.622811,1.963199,-0.144,
	-2.653085,1.979755,-0.189,	-2.56745,2.014502,-0.189,	-2.539942,1.994746,-0.144,
	-2.539942,1.994746,-0.144,	-2.622811,1.963199,-0.144,	-2.653085,1.979755,-0.189,
	-2.689846,1.999859,-0.216,	-2.600851,2.038493,-0.216,	-2.56745,2.014502,-0.189,
	-2.56745,2.014502,-0.189,	-2.653085,1.979755,-0.189,	-2.689846,1.999859,-0.216,
	-2.72985,2.021737,-0.225,	-2.6372,2.0646,-0.225,	-2.600851,2.038493,-0.216,
	-2.600851,2.038493,-0.216,	-2.689846,1.999859,-0.216,	-2.72985,2.021737,-0.225,
	-2.769854,2.043616,-0.216,	-2.673549,2.090707,-0.216,	-2.6372,2.0646,-0.225,
	-2.6372,2.0646,-0.225,	-2.72985,2.021737,-0.225,	-2.769854,2.043616,-0.216,
	-2.806615,2.06372,-0.189,	-2.70695,2.114698,-0.189,	-2.673549,2.090707,-0.216,
	-2.673549,2.090707,-0.216,	-2.769854,2.043616,-0.216,	-2.806615,2.06372,-0.189,
	-2.836889,2.080276,-0.144,	-2.734458,2.134454,-0.144,	-2.70695,2.114698,-0.189,
	-2.70695,2.114698,-0.189,	-2.806615,2.06372,-0.189,	-2.836889,2.080276,-0.144,
	-2.857432,2.091511,-0.081,	-2.753123,2.147861,-0.081,	-2.734458,2.134454,-0.144,
	-2.734458,2.134454,-0.144,	-2.836889,2.080276,-0.144,	-2.857432,2.091511,-0.081,
	-2.865,2.09565,0,	-2.76,2.1528,0,	-2.753123,2.147861,-0.081,
	-2.753123,2.147861,-0.081,	-2.857432,2.091511,-0.081,	-2.865,2.09565,0,
	-2.660842,1.912874,-0.081,	-2.602268,1.951964,-0.081,	-2.5947,1.947825,0,
	-2.5947,1.947825,0,	-2.6528,1.9098,0,	-2.660842,1.912874,-0.081,
	-2.682669,1.921219,-0.144,	-2.622811,1.963199,-0.144,	-2.602268,1.951964,-0.081,
	-2.602268,1.951964,-0.081,	-2.660842,1.912874,-0.081,	-2.682669,1.921219,-0.144,
	-2.714835,1.933517,-0.189,	-2.653085,1.979755,-0.189,	-2.622811,1.963199,-0.144,
	-2.622811,1.963199,-0.144,	-2.682669,1.921219,-0.144,	-2.714835,1.933517,-0.189,
	-2.753894,1.94845,-0.216,	-2.689846,1.999859,-0.216,	-2.653085,1.979755,-0.189,
	-2.653085,1.979755,-0.189,	-2.714835,1.933517,-0.189,	-2.753894,1.94845,-0.216,
	-2.7964,1.9647,-0.225,	-2.72985,2.021737,-0.225,	-2.689846,1.999859,-0.216,
	-2.689846,1.999859,-0.216,	-2.753894,1.94845,-0.216,	-2.7964,1.9647,-0.225,
	-2.838906,1.98095,-0.216,	-2.769854,2.043616,-0.216,	-2.72985,2.021737,-0.225,
	-2.72985,2.021737,-0.225,	-2.7964,1.9647,-0.225,	-2.838906,1.98095,-0.216,
	-2.877965,1.995883,-0.189,	-2.806615,2.06372,-0.189,	-2.769854,2.043616,-0.216,
	-2.769854,2.043616,-0.216,	-2.838906,1.98095,-0.216,	-2.877965,1.995883,-0.189,
	-2.910131,2.008181,-0.144,	-2.836889,2.080276,-0.144,	-2.806615,2.06372,-0.189,
	-2.806615,2.06372,-0.189,	-2.877965,1.995883,-0.189,	-2.910131,2.008181,-0.144,
	-2.931958,2.016526,-0.081,	-2.857432,2.091511,-0.081,	-2.836889,2.080276,-0.144,
	-2.836889,2.080276,-0.144,	-2.910131,2.008181,-0.144,	-2.931958,2.016526,-0.081,
	-2.94,2.0196,0,	-2.865,2.09565,0,	-2.857432,2.091511,-0.081,
	-2.857432,2.091511,-0.081,	-2.931958,2.016526,-0.081,	-2.94,2.0196,0,
	-2.696413,1.862682,-0.081,	-2.660842,1.912874,-0.081,	-2.6528,1.9098,0,
	-2.6528,1.9098,0,	-2.6881,1.860975,0,	-2.696413,1.862682,-0.081,
	-2.718978,1.867316,-0.144,	-2.682669,1.921219,-0.144,	-2.660842,1.912874,-0.081,
	-2.660842,1.912874,-0.081,	-2.696413,1.862682,-0.081,	-2.718978,1.867316,-0.144,
	-2.75223,1.874146,-0.189,	-2.714835,1.933517,-0.189,	-2.682669,1.921219,-0.144,
	-2.682669,1.921219,-0.144,	-2.718978,1.867316,-0.144,	-2.75223,1.874146,-0.189,
	-2.792609,1.882438,-0.216,	-2.753894,1.94845,-0.216,	-2.714835,1.933517,-0.189,
	-2.714835,1.933517,-0.189,	-2.75223,1.874146,-0.189,	-2.792609,1.882438,-0.216,
	-2.83655,1.891463,-0.225,	-2.7964,1.9647,-0.225,	-2.753894,1.94845,-0.216,
	-2.753894,1.94845,-0.216,	-2.792609,1.882438,-0.216,	-2.83655,1.891463,-0.225,
	-2.880491,1.900487,-0.216,	-2.838906,1.98095,-0.216,	-2.7964,1.9647,-0.225,
	-2.7964,1.9647,-0.225,	-2.83655,1.891463,-0.225,	-2.880491,1.900487,-0.216,
	-2.92087,1.908779,-0.189,	-2.877965,1.995883,-0.189,	-2.838906,1.98095,-0.216,
	-2.838906,1.98095,-0.216,	-2.880491,1.900487,-0.216,	-2.92087,1.908779,-0.189,
	-2.954122,1.915609,-0.144,	-2.910131,2.008181,-0.144,	-2.877965,1.995883,-0.189,
	-2.877965,1.995883,-0.189,	-2.92087,1.908779,-0.189,	-2.954122,1.915609,-0.144,
	-2.976687,1.920243,-0.081,	-2.931958,2.016526,-0.081,	-2.910131,2.008181,-0.144,
	-2.910131,2.008181,-0.144,	-2.954122,1.915609,-0.144,	-2.976687,1.920243,-0.081,
	-2.985,1.92195,0,	-2.94,2.0196,0,	-2.931958,2.016526,-0.081,
	-2.931958,2.016526,-0.081,	-2.976687,1.920243,-0.081,	-2.985,1.92195,0,
	-2.7084,1.8,-0.081,	-2.696413,1.862682,-0.081,	-2.6881,1.860975,0,
	-2.6881,1.860975,0,	-2.7,1.8,0,	-2.7084,1.8,-0.081,
	-2.7312,1.8,-0.144,	-2.718978,1.867316,-0.144,	-2.696413,1.862682,-0.081,
	-2.696413,1.862682,-0.081,	-2.7084,1.8,-0.081,	-2.7312,1.8,-0.144,
	-2.7648,1.8,-0.189,	-2.75223,1.874146,-0.189,	-2.718978,1.867316,-0.144,
	-2.718978,1.867316,-0.144,	-2.7312,1.8,-0.144,	-2.7648,1.8,-0.189,
	-2.8056,1.8,-0.216,	-2.792609,1.882438,-0.216,	-2.75223,1.874146,-0.189,
	-2.75223,1.874146,-0.189,	-2.7648,1.8,-0.189,	-2.8056,1.8,-0.216,
	-2.85,1.8,-0.225,	-2.83655,1.891463,-0.225,	-2.792609,1.882438,-0.216,
	-2.792609,1.882438,-0.216,	-2.8056,1.8,-0.216,	-2.85,1.8,-0.225,
	-2.8944,1.8,-0.216,	-2.880491,1.900487,-0.216,	-2.83655,1.891463,-0.225,
	-2.83655,1.891463,-0.225,	-2.85,1.8,-0.225,	-2.8944,1.8,-0.216,
	-2.9352,1.8,-0.189,	-2.92087,1.908779,-0.189,	-2.880491,1.900487,-0.216,
	-2.880491,1.900487,-0.216,	-2.8944,1.8,-0.216,	-2.9352,1.8,-0.189,
	-2.9688,1.8,-0.144,	-2.954122,1.915609,-0.144,	-2.92087,1.908779,-0.189,
	-2.92087,1.908779,-0.189,	-2.9352,1.8,-0.189,	-2.9688,1.8,-0.144,
	-2.9916,1.8,-0.081,	-2.976687,1.920243,-0.081,	-2.954122,1.915609,-0.144,
	-2.954122,1.915609,-0.144,	-2.9688,1.8,-0.144,	-2.9916,1.8,-0.081,
	-3,1.8,0,	-2.985,1.92195,0,	-2.976687,1.920243,-0.081,
	-2.976687,1.920243,-0.081,	-2.9916,1.8,-0.081,	-3,1.8,0,
	-1.785445,2.243256,0.081,	-1.5028,2.2437,0.081,	-1.5,2.25,0,
	-1.5,2.25,0,	-1.785,2.24955,0,	-1.785445,2.243256,0.081,
	-1.786654,2.226173,0.144,	-1.5104,2.2266,0.144,	-1.5028,2.2437,0.081,
	-1.5028,2.2437,0.081,	-1.785445,2.243256,0.081,	-1.786654,2.226173,0.144,
	-1.788434,2.200999,0.189,	-1.5216,2.2014,0.189,	-1.5104,2.2266,0.144,
	-1.5104,2.2266,0.144,	-1.786654,2.226173,0.144,	-1.788434,2.200999,0.189,
	-1.790597,2.170429,0.216,	-1.5352,2.1708,0.216,	-1.5216,2.2014,0.189,
	-1.5216,2.2014,0.189,	-1.788434,2.200999,0.189,	-1.790597,2.170429,0.216,
	-1.79295,2.137163,0.225,	-1.55,2.1375,0.225,	-1.5352,2.1708,0.216,
	-1.5352,2.1708,0.216,	-1.790597,2.170429,0.216,	-1.79295,2.137163,0.225,
	-1.795303,2.103896,0.216,	-1.5648,2.1042,0.216,	-1.55,2.1375,0.225,
	-1.55,2.1375,0.225,	-1.79295,2.137163,0.225,	-1.795303,2.103896,0.216,
	-1.797466,2.073326,0.189,	-1.5784,2.0736,0.189,	-1.5648,2.1042,0.216,
	-1.5648,2.1042,0.216,	-1.795303,2.103896,0.216,	-1.797466,2.073326,0.189,
	-1.799246,2.048152,0.144,	-1.5896,2.0484,0.144,	-1.5784,2.0736,0.189,
	-1.5784,2.0736,0.189,	-1.797466,2.073326,0.189,	-1.799246,2.048152,0.144,
	-1.800455,2.031069,0.081,	-1.5972,2.0313,0.081,	-1.5896,2.0484,0.144,
	-1.5896,2.0484,0.144,	-1.799246,2.048152,0.144,	-1.800455,2.031069,0.081,
	-1.8009,2.024775,0,	-1.6,2.025,0,	-1.5972,2.0313,0.081,
	-1.5972,2.0313,0.081,	-1.800455,2.031069,0.081,	-1.8009,2.024775,0,
	-2.03841,2.24015,0.081,	-1.785445,2.243256,0.081,	-1.785,2.24955,0,
	-1.785,2.24955,0,	-2.04,2.2464,0,	-2.03841,2.24015,0.081,
	-2.034093,2.223187,0.144,	-1.786654,2.226173,0.144,	-1.785445,2.243256,0.081,
	-1.785445,2.243256,0.081,	-2.03841,2.24015,0.081,	-2.034093,2.223187,0.144,
	-2.027731,2.198189,0.189,	-1.788434,2.200999,0.189,	-1.786654,2.226173,0.144,
	-1.786654,2.226173,0.144,	-2.034093,2.223187,0.144,	-2.027731,2.198189,0.189,
	-2.020006,2.167834,0.216,	-1.790597,2.170429,0.216,	-1.788434,2.200999,0.189,
	-1.788434,2.200999,0.189,	-2.027731,2.198189,0.189,	-2.020006,2.167834,0.216,
	-2.0116,2.1348,0.225,	-1.79295,2.137163,0.225,	-1.790597,2.170429,0.216,
	-1.790597,2.170429,0.216,	-2.020006,2.167834,0.216,	-2.0116,2.1348,0.225,
	-2.003194,2.101766,0.216,	-1.795303,2.103896,0.216,	-1.79295,2.137163,0.225,
	-1.79295,2.137163,0.225,	-2.0116,2.1348,0.225,	-2.003194,2.101766,0.216,
	-1.995469,2.071411,0.189,	-1.797466,2.073326,0.189,	-1.795303,2.103896,0.216,
	-1.795303,2.103896,0.216,	-2.003194,2.101766,0.216,	-1.995469,2.071411,0.189,
	-1.989107,2.046413,0.144,	-1.799246,2.048152,0.144,	-1.797466,2.073326,0.189,
	-1.797466,2.073326,0.189,	-1.995469,2.071411,0.189,	-1.989107,2.046413,0.144,
	-1.98479,2.02945,0.081,	-1.800455,2.031069,0.081,	-1.799246,2.048152,0.144,
	-1.799246,2.048152,0.144,	-1.989107,2.046413,0.144,	-1.98479,2.02945,0.081,
	-1.9832,2.0232,0,	-1.8009,2.024775,0,	-1.800455,2.031069,0.081,
	-1.800455,2.031069,0.081,	-1.98479,2.02945,0.081,	-1.9832,2.0232,0,
	-2.261676,2.23172,0.081,	-2.03841,2.24015,0.081,	-2.04,2.2464,0,
	-2.04,2.2464,0,	-2.265,2.23785,0,	-2.261676,2.23172,0.081,
	-2.252655,2.215082,0.144,	-2.034093,2.223187,0.144,	-2.03841,2.24015,0.081,
	-2.03841,2.24015,0.081,	-2.261676,2.23172,0.081,	-2.252655,2.215082,0.144,
	-2.239361,2.190562,0.189,	-2.027731,2.198189,0.189,	-2.034093,2.223187,0.144,
	-2.034093,2.223187,0.144,	-2.252655,2.215082,0.144,	-2.239361,2.190562,0.189,
	-2.223218,2.160788,0.216,	-2.020006,2.167834,0.216,	-2.027731,2.198189,0.189,
	-2.027731,2.198189,0.189,	-2.239361,2.190562,0.189,	-2.223218,2.160788,0.216,
	-2.20565,2.128387,0.225,	-2.0116,2.1348,0.225,	-2.020006,2.167834,0.216,
	-2.020006,2.167834,0.216,	-2.223218,2.160788,0.216,	-2.20565,2.128387,0.225,
	-2.188082,2.095987,0.216,	-2.003194,2.101766,0.216,	-2.0116,2.1348,0.225,
	-2.0116,2.1348,0.225,	-2.20565,2.128387,0.225,	-2.188082,2.095987,0.216,
	-2.171939,2.066213,0.189,	-1.995469,2.071411,0.189,	-2.003194,2.101766,0.216,
	-2.003194,2.101766,0.216,	-2.188082,2.095987,0.216,	-2.171939,2.066213,0.189,
	-2.158645,2.041693,0.144,	-1.989107,2.046413,0.144,	-1.995469,2.071411,0.189,
	-1.995469,2.071411,0.189,	-2.171939,2.066213,0.189,	-2.158645,2.041693,0.144,
	-2.149624,2.025055,0.081,	-1.98479,2.02945,0.081,	-1.989107,2.046413,0.144,
	-1.989107,2.046413,0.144,	-2.158645,2.041693,0.144,	-2.149624,2.025055,0.081,
	-2.1463,2.018925,0,	-1.9832,2.0232,0,	-1.98479,2.02945,0.081,
	-1.98479,2.02945,0.081,	-2.149624,2.025055,0.081,	-2.1463,2.018925,0,
	-2.455229,2.215303,0.081,	-2.261676,2.23172,0.081,	-2.265,2.23785,0,
	-2.265,2.23785,0,	-2.46,2.2212,0,	-2.455229,2.215303,0.081,
	-2.442278,2.199298,0.144,	-2.252655,2.215082,0.144,	-2.261676,2.23172,0.081,
	-2.261676,2.23172,0.081,	-2.455229,2.215303,0.081,	-2.442278,2.199298,0.144,
	-2.423194,2.17571,0.189,	-2.239361,2.190562,0.189,	-2.252655,2.215082,0.144,
	-2.252655,2.215082,0.144,	-2.442278,2.199298,0.144,	-2.423194,2.17571,0.189,
	-2.400019,2.147069,0.216,	-2.223218,2.160788,0.216,	-2.239361,2.190562,0.189,
	-2.239361,2.190562,0.189,	-2.423194,2.17571,0.189,	-2.400019,2.147069,0.216,
	-2.3748,2.1159,0.225,	-2.20565,2.128387,0.225,	-2.223218,2.160788,0.216,
	-2.223218,2.160788,0.216,	-2.400019,2.147069,0.216,	-2.3748,2.1159,0.225,
	-2.349581,2.084731,0.216,	-2.188082,2.095987,0.216,	-2.20565,2.128387,0.225,
	-2.20565,2.128387,0.225,	-2.3748,2.1159,0.225,	-2.349581,2.084731,0.216,
	-2.326406,2.05609,0.189,	-2.171939,2.066213,0.189,	-2.188082,2.095987,0.216,
	-2.188082,2.095987,0.216,	-2.349581,2.084731,0.216,	-2.326406,2.05609,0.189,
	-2.307322,2.032502,0.144,	-2.158645,2.041693,0.144,	-2.171939,2.066213,0.189,
	-2.171939,2.066213,0.189,	-2.326406,2.05609,0.189,	-2.307322,2.032502,0.144,
	-2.294371,2.016497,0.081,	-2.149624,2.025055,0.081,	-2.158645,2.041693,0.144,
	-2.158645,2.041693,0.144,	-2.307322,2.032502,0.144,	-2.294371,2.016497,0.081,
	-2.2896,2.0106,0,	-2.1463,2.018925,0,	-2.149624,2.025055,0.081,
	-2.149624,2.025055,0.081,	-2.294371,2.016497,0.081,	-2.2896,2.0106,0,
	-2.61905,2.188238,0.081,	-2.455229,2.215303,0.081,	-2.46,2.2212,0,
	-2.46,2.2212,0,	-2.625,2.19375,0,	-2.61905,2.188238,0.081,
	-2.6029,2.173275,0.144,	-2.442278,2.199298,0.144,	-2.455229,2.215303,0.081,
	-2.455229,2.215303,0.081,	-2.61905,2.188238,0.081,	-2.6029,2.173275,0.144,
	-2.5791,2.151225,0.189,	-2.423194,2.17571,0.189,	-2.442278,2.199298,0.144,
	-2.442278,2.199298,0.144,	-2.6029,2.173275,0.144,	-2.5791,2.151225,0.189,
	-2.5502,2.12445,0.216,	-2.400019,2.147069,0.216,	-2.423194,2.17571,0.189,
	-2.423194,2.17571,0.189,	-2.5791,2.151225,0.189,	-2.5502,2.12445,0.216,
	-2.51875,2.095312,0.225,	-2.3748,2.1159,0.225,	-2.400019,2.147069,0.216,
	-2.400019,2.147069,0.216,	-2.5502,2.12445,0.216,	-2.51875,2.095312,0.225,
	-2.4873,2.066175,0.216,	-2.349581,2.084731,0.216,	-2.3748,2.1159,0.225,
	-2.3748,2.1159,0.225,	-2.51875,2.095312,0.225,	-2.4873,2.066175,0.216,
	-2.4584,2.0394,0.189,	-2.326406,2.05609,0.189,	-2.349581,2.084731,0.216,
	-2.349581,2.084731,0.216,	-2.4873,2.066175,0.216,	-2.4584,2.0394,0.189,
	-2.4346,2.01735,0.144,	-2.307322,2.032502,0.144,	-2.326406,2.05609,0.189,
	-2.326406,2.05609,0.189,	-2.4584,2.0394,0.189,	-2.4346,2.01735,0.144,
	-2.41845,2.002388,0.081,	-2.294371,2.016497,0.081,	-2.307322,2.032502,0.144,
	-2.307322,2.032502,0.144,	-2.4346,2.01735,0.144,	-2.41845,2.002388,0.081,
	-2.4125,1.996875,0,	-2.2896,2.0106,0,	-2.294371,2.016497,0.081,
	-2.294371,2.016497,0.081,	-2.41845,2.002388,0.081,	-2.4125,1.996875,0,
	-2.753123,2.147861,0.081,	-2.61905,2.188238,0.081,	-2.625,2.19375,0,
	-2.625,2.19375,0,	-2.76,2.1528,0,	-2.753123,2.147861,0.081,
	-2.734458,2.134454,0.144,	-2.6029,2.173275,0.144,	-2.61905,2.188238,0.081,
	-2.61905,2.188238,0.081,	-2.753123,2.147861,0.081,	-2.734458,2.134454,0.144,
	-2.70695,2.114698,0.189,	-2.5791,2.151225,0.189,	-2.6029,2.173275,0.144,
	-2.6029,2.173275,0.144,	-2.734458,2.134454,0.144,	-2.70695,2.114698,0.189,
	-2.673549,2.090707,0.216,	-2.5502,2.12445,0.216,	-2.5791,2.151225,0.189,
	-2.5791,2.151225,0.189,	-2.70695,2.114698,0.189,	-2.673549,2.090707,0.216,
	-2.6372,2.0646,0.225,	-2.51875,2.095312,0.225,	-2.5502,2.12445,0.216,
	-2.5502,2.12445,0.216,	-2.673549,2.090707,0.216,	-2.6372,2.0646,0.225,
	-2.600851,2.038493,0.216,	-2.4873,2.066175,0.216,	-2.51875,2.095312,0.225,
	-2.51875,2.095312,0.225,	-2.6372,2.0646,0.225,	-2.600851,2.038493,0.216,
	-2.56745,2.014502,0.189,	-2.4584,2.0394,0.189,	-2.4873,2.066175,0.216,
	-2.4873,2.066175,0.216,	-2.600851,2.038493,0.216,	-2.56745,2.014502,0.189,
	-2.539942,1.994746,0.144,	-2.4346,2.01735,0.144,	-2.4584,2.0394,0.189,
	-2.4584,2.0394,0.189,	-2.56745,2.014502,0.189,	-2.539942,1.994746,0.144,
	-2.521277,1.981339,0.081,	-2.41845,2.002388,0.081,	-2.4346,2.01735,0.144,
	-2.4346,2.01735,0.144,	-2.539942,1.994746,0.144,	-2.521277,1.981339,0.081,
	-2.5144,1.9764,0,	-2.4125,1.996875,0,	-2.41845,2.002388,0.081,
	-2.41845,2.002388,0.081,	-2.521277,1.981339,0.081,	-2.5144,1.9764,0,
	-2.857432,2.091511,0.081,	-2.753123,2.147861,0.081,	-2.76,2.1528,0,
	-2.76,2.1528,0,	-2.865,2.09565,0,	-2.857432,2.091511,0.081,
	-2.836889,2.080276,0.144,	-2.734458,2.134454,0.144,	-2.753123,2.147861,0.081,
	-2.753123,2.147861,0.081,	-2.857432,2.091511,0.081,	-2.836889,2.080276,0.144,
	-2.806615,2.06372,0.189,	-2.70695,2.114698,0.189,	-2.734458,2.134454,0.144,
	-2.734458,2.134454,0.144,	-2.836889,2.080276,0.144,	-2.806615,2.06372,0.189,
	-2.769854,2.043616,0.216,	-2.673549,2.090707,0.216,	-2.70695,2.114698,0.189,
	-2.70695,2.114698,0.189,	-2.806615,2.06372,0.189,	-2.769854,2.043616,0.216,
	-2.72985,2.021737,0.225,	-2.6372,2.0646,0.225,	-2.673549,2.090707,0.216,
	-2.673549,2.090707,0.216,	-2.769854,2.043616,0.216,	-2.72985,2.021737,0.225,
	-2.689846,1.999859,0.216,	-2.600851,2.038493,0.216,	-2.6372,2.0646,0.225,
	-2.6372,2.0646,0.225,	-2.72985,2.021737,0.225,	-2.689846,1.999859,0.216,
	-2.653085,1.979755,0.189,	-2.56745,2.014502,0.189,	-2.600851,2.038493,0.216,
	-2.600851,2.038493,0.216,	-2.689846,1.999859,0.216,	-2.653085,1.979755,0.189,
	-2.622811,1.963199,0.144,	-2.539942,1.994746,0.144,	-2.56745,2.014502,0.189,
	-2.56745,2.014502,0.189,	-2.653085,1.979755,0.189,	-2.622811,1.963199,0.144,
	-2.602268,1.951964,0.081,	-2.521277,1.981339,0.081,	-2.539942,1.994746,0.144,
	-2.539942,1.994746,0.144,	-2.622811,1.963199,0.144,	-2.602268,1.951964,0.081,
	-2.5947,1.947825,0,	-2.5144,1.9764,0,	-2.521277,1.981339,0.081,
	-2.521277,1.981339,0.081,	-2.602268,1.951964,0.081,	-2.5947,1.947825,0,
	-2.931958,2.016526,0.081,	-2.857432,2.091511,0.081,	-2.865,2.09565,0,
	-2.865,2.09565,0,	-2.94,2.0196,0,	-2.931958,2.016526,0.081,
	-2.910131,2.008181,0.144,	-2.836889,2.080276,0.144,	-2.857432,2.091511,0.081,
	-2.857432,2.091511,0.081,	-2.931958,2.016526,0.081,	-2.910131,2.008181,0.144,
	-2.877965,1.995883,0.189,	-2.806615,2.06372,0.189,	-2.836889,2.080276,0.144,
	-2.836889,2.080276,0.144,	-2.910131,2.008181,0.144,	-2.877965,1.995883,0.189,
	-2.838906,1.98095,0.216,	-2.769854,2.043616,0.216,	-2.806615,2.06372,0.189,
	-2.806615,2.06372,0.189,	-2.877965,1.995883,0.189,	-2.838906,1.98095,0.216,
	-2.7964,1.9647,0.225,	-2.72985,2.021737,0.225,	-2.769854,2.043616,0.216,
	-2.769854,2.043616,0.216,	-2.838906,1.98095,0.216,	-2.7964,1.9647,0.225,
	-2.753894,1.94845,0.216,	-2.689846,1.999859,0.216,	-2.72985,2.021737,0.225,
	-2.72985,2.021737,0.225,	-2.7964,1.9647,0.225,	-2.753894,1.94845,0.216,
	-2.714835,1.933517,0.189,	-2.653085,1.979755,0.189,	-2.689846,1.999859,0.216,
	-2.689846,1.999859,0.216,	-2.753894,1.94845,0.216,	-2.714835,1.933517,0.189,
	-2.682669,1.921219,0.144,	-2.622811,1.963199,0.144,	-2.653085,1.979755,0.189,
	-2.653085,1.979755,0.189,	-2.714835,1.933517,0.189,	-2.682669,1.921219,0.144,
	-2.660842,1.912874,0.081,	-2.602268,1.951964,0.081,	-2.622811,1.963199,0.144,
	-2.622811,1.963199,0.144,	-2.682669,1.921219,0.144,	-2.660842,1.912874,0.081,
	-2.6528,1.9098,0,	-2.5947,1.947825,0,	-2.602268,1.951964,0.081,
	-2.602268,1.951964,0.081,	-2.660842,1.912874,0.081,	-2.6528,1.9098,0,
	-2.976687,1.920243,0.081,	-2.931958,2.016526,0.081,	-2.94,2.0196,0,
	-2.94,2.0196,0,	-2.985,1.92195,0,	-2.976687,1.920243,0.081,
	-2.954122,1.915609,0.144,	-2.910131,2.008181,0.144,	-2.931958,2.016526,0.081,
	-2.931958,2.016526,0.081,	-2.976687,1.920243,0.081,	-2.954122,1.915609,0.144,
	-2.92087,1.908779,0.189,	-2.877965,1.995883,0.189,	-2.910131,2.008181,0.144,
	-2.910131,2.008181,0.144,	-2.954122,1.915609,0.144,	-2.92087,1.908779,0.189,
	-2.880491,1.900487,0.216,	-2.838906,1.98095,0.216,	-2.877965,1.995883,0.189,
	-2.877965,1.995883,0.189,	-2.92087,1.908779,0.189,	-2.880491,1.900487,0.216,
	-2.83655,1.891463,0.225,	-2.7964,1.9647,0.225,	-2.838906,1.98095,0.216,
	-2.838906,1.98095,0.216,	-2.880491,1.900487,0.216,	-2.83655,1.891463,0.225,
	-2.792609,1.882438,0.216,	-2.753894,1.94845,0.216,	-2.7964,1.9647,0.225,
	-2.7964,1.9647,0.225,	-2.83655,1.891463,0.225,	-2.792609,1.882438,0.216,
	-2.75223,1.874146,0.189,	-2.714835,1.933517,0.189,	-2.753894,1.94845,0.216,
	-2.753894,1.94845,0.216,	-2.792609,1.882438,0.216,	-2.75223,1.874146,0.189,
	-2.718978,1.867316,0.144,	-2.682669,1.921219,0.144,	-2.714835,1.933517,0.189,
	-2.714835,1.933517,0.189,	-2.75223,1.874146,0.189,	-2.718978,1.867316,0.144,
	-2.696413,1.862682,0.081,	-2.660842,1.912874,0.081,	-2.682669,1.921219,0.144,
	-2.682669,1.921219,0.144,	-2.718978,1.867316,0.144,	-2.696413,1.862682,0.081,
	-2.6881,1.860975,0,	-2.6528,1.9098,0,	-2.660842,1.912874,0.081,
	-2.660842,1.912874,0.081,	-2.696413,1.862682,0.081,	-2.6881,1.860975,0,
	-2.9916,1.8,0.081,	-2.976687,1.920243,0.081,	-2.985,1.92195,0,
	-2.985,1.92195,0,	-3,1.8,0,	-2.9916,1.8,0.081,
	-2.9688,1.8,0.144,	-2.954122,1.915609,0.144,	-2.976687,1.920243,0.081,
	-2.976687,1.920243,0.081,	-2.9916,1.8,0.081,	-2.9688,1.8,0.144,
	-2.9352,1.8,0.189,	-2.92087,1.908779,0.189,	-2.954122,1.915609,0.144,
	-2.954122,1.915609,0.144,	-2.9688,1.8,0.144,	-2.9352,1.8,0.189,
	-2.8944,1.8,0.216,	-2.880491,1.900487,0.216,	-2.92087,1.908779,0.189,
	-2.92087,1.908779,0.189,	-2.9352,1.8,0.189,	-2.8944,1.8,0.216,
	-2.85,1.8,0.225,	-2.83655,1.891463,0.225,	-2.880491,1.900487,0.216,
	-2.880491,1.900487,0.216,	-2.8944,1.8,0.216,	-2.85,1.8,0.225,
	-2.8056,1.8,0.216,	-2.792609,1.882438,0.216,	-2.83655,1.891463,0.225,
	-2.83655,1.891463,0.225,	-2.85,1.8,0.225,	-2.8056,1.8,0.216,
	-2.7648,1.8,0.189,	-2.75223,1.874146,0.189,	-2.792609,1.882438,0.216,
	-2.792609,1.882438,0.216,	-2.8056,1.8,0.216,	-2.7648,1.8,0.189,
	-2.7312,1.8,0.144,	-2.718978,1.867316,0.144,	-2.75223,1.874146,0.189,
	-2.75223,1.874146,0.189,	-2.7648,1.8,0.189,	-2.7312,1.8,0.144,
	-2.7084,1.8,0.081,	-2.696413,1.862682,0.081,	-2.718978,1.867316,0.144,
	-2.718978,1.867316,0.144,	-2.7312,1.8,0.144,	-2.7084,1.8,0.081,
	-2.7,1.8,0,	-2.6881,1.860975,0,	-2.696413,1.862682,0.081,
	-2.696413,1.862682,0.081,	-2.7084,1.8,0.081,	-2.7,1.8,0,
	-2.702175,1.724519,-0.081,	-2.7084,1.8,-0.081,	-2.7,1.8,0,
	-2.7,1.8,0,	-2.6939,1.7262,0,	-2.702175,1.724519,-0.081,
	-2.724637,1.719956,-0.144,	-2.7312,1.8,-0.144,	-2.7084,1.8,-0.081,
	-2.7084,1.8,-0.081,	-2.702175,1.724519,-0.081,	-2.724637,1.719956,-0.144,
	-2.757739,1.713232,-0.189,	-2.7648,1.8,-0.189,	-2.7312,1.8,-0.144,
	-2.7312,1.8,-0.144,	-2.724637,1.719956,-0.144,	-2.757739,1.713232,-0.189,
	-2.797934,1.705067,-0.216,	-2.8056,1.8,-0.216,	-2.7648,1.8,-0.189,
	-2.7648,1.8,-0.189,	-2.757739,1.713232,-0.189,	-2.797934,1.705067,-0.216,
	-2.841675,1.696181,-0.225,	-2.85,1.8,-0.225,	-2.8056,1.8,-0.216,
	-2.8056,1.8,-0.216,	-2.797934,1.705067,-0.216,	-2.841675,1.696181,-0.225,
	-2.885416,1.687296,-0.216,	-2.8944,1.8,-0.216,	-2.85,1.8,-0.225,
	-2.85,1.8,-0.225,	-2.841675,1.696181,-0.225,	-2.885416,1.687296,-0.216,
	-2.925611,1.679131,-0.189,	-2.9352,1.8,-0.189,	-2.8944,1.8,-0.216,
	-2.8944,1.8,-0.216,	-2.885416,1.687296,-0.216,	-2.925611,1.679131,-0.189,
	-2.958713,1.672406,-0.144,	-2.9688,1.8,-0.144,	-2.9352,1.8,-0.189,
	-2.9352,1.8,-0.189,	-2.925611,1.679131,-0.189,	-2.958713,1.672406,-0.144,
	-2.981175,1.667844,-0.081,	-2.9916,1.8,-0.081,	-2.9688,1.8,-0.144,
	-2.9688,1.8,-0.144,	-2.958713,1.672406,-0.144,	-2.981175,1.667844,-0.081,
	-2.98945,1.666162,0,	-3,1.8,0,	-2.9916,1.8,-0.081,
	-2.9916,1.8,-0.081,	-2.981175,1.667844,-0.081,	-2.98945,1.666162,0,
	-2.683107,1.63861,-0.081,	-2.702175,1.724519,-0.081,	-2.6939,1.7262,0,
	-2.6939,1.7262,0,	-2.6752,1.6416,0,	-2.683107,1.63861,-0.081,
	-2.70457,1.630493,-0.144,	-2.724637,1.719956,-0.144,	-2.702175,1.724519,-0.081,
	-2.702175,1.724519,-0.081,	-2.683107,1.63861,-0.081,	-2.70457,1.630493,-0.144,
	-2.736198,1.618531,-0.189,	-2.757739,1.713232,-0.189,	-2.724637,1.719956,-0.144,
	-2.724637,1.719956,-0.144,	-2.70457,1.630493,-0.144,	-2.736198,1.618531,-0.189,
	-2.774605,1.604006,-0.216,	-2.797934,1.705067,-0.216,	-2.757739,1.713232,-0.189,
	-2.757739,1.713232,-0.189,	-2.736198,1.618531,-0.189,	-2.774605,1.604006,-0.216,
	-2.8164,1.5882,-0.225,	-2.841675,1.696181,-0.225,	-2.797934,1.705067,-0.216,
	-2.797934,1.705067,-0.216,	-2.774605,1.604006,-0.216,	-2.8164,1.5882,-0.225,
	-2.858195,1.572394,-0.216,	-2.885416,1.687296,-0.216,	-2.841675,1.696181,-0.225,
	-2.841675,1.696181,-0.225,	-2.8164,1.5882,-0.225,	-2.858195,1.572394,-0.216,
	-2.896602,1.557869,-0.189,	-2.925611,1.679131,-0.189,	-2.885416,1.687296,-0.216,
	-2.885416,1.687296,-0.216,	-2.858195,1.572394,-0.216,	-2.896602,1.557869,-0.189,
	-2.92823,1.545907,-0.144,	-2.958713,1.672406,-0.144,	-2.925611,1.679131,-0.189,
	-2.925611,1.679131,-0.189,	-2.896602,1.557869,-0.189,	-2.92823,1.545907,-0.144,
	-2.949693,1.53779,-0.081,	-2.981175,1.667844,-0.081,	-2.958713,1.672406,-0.144,
	-2.958713,1.672406,-0.144,	-2.92823,1.545907,-0.144,	-2.949693,1.53779,-0.081,
	-2.9576,1.5348,0,	-2.98945,1.666162,0,	-2.981175,1.667844,-0.081,
	-2.981175,1.667844,-0.081,	-2.949693,1.53779,-0.081,	-2.9576,1.5348,0,
	-2.650604,1.544903,-0.081,	-2.683107,1.63861,-0.081,	-2.6752,1.6416,0,
	-2.6752,1.6416,0,	-2.6433,1.5489,0,	-2.650604,1.544903,-0.081,
	-2.670428,1.534053,-0.144,	-2.70457,1.630493,-0.144,	-2.683107,1.63861,-0.081,
	-2.683107,1.63861,-0.081,	-2.650604,1.544903,-0.081,	-2.670428,1.534053,-0.144,
	-2.699644,1.518063,-0.189,	-2.736198,1.618531,-0.189,	-2.70457,1.630493,-0.144,
	-2.70457,1.630493,-0.144,	-2.670428,1.534053,-0.144,	-2.699644,1.518063,-0.189,
	-2.735119,1.498648,-0.216,	-2.774605,1.604006,-0.216,	-2.736198,1.618531,-0.189,
	-2.736198,1.618531,-0.189,	-2.699644,1.518063,-0.189,	-2.735119,1.498648,-0.216,
	-2.773725,1.477519,-0.225,	-2.8164,1.5882,-0.225,	-2.774605,1.604006,-0.216,
	-2.774605,1.604006,-0.216,	-2.735119,1.498648,-0.216,	-2.773725,1.477519,-0.225,
	-2.812331,1.45639,-0.216,	-2.858195,1.572394,-0.216,	-2.8164,1.5882,-0.225,
	-2.8164,1.5882,-0.225,	-2.773725,1.477519,-0.225,	-2.812331,1.45639,-0.216,
	-2.847806,1.436974,-0.189,	-2.896602,1.557869,-0.189,	-2.858195,1.572394,-0.216,
	-2.858195,1.572394,-0.216,	-2.812331,1.45639,-0.216,	-2.847806,1.436974,-0.189,
	-2.877022,1.420985,-0.144,	-2.92823,1.545907,-0.144,	-2.896602,1.557869,-0.189,
	-2.896602,1.557869,-0.189,	-2.847806,1.436974,-0.189,	-2.877022,1.420985,-0.144,
	-2.896846,1.410135,-0.081,	-2.949693,1.53779,-0.081,	-2.92823,1.545907,-0.144,
	-2.92823,1.545907,-0.144,	-2.877022,1.420985,-0.144,	-2.896846,1.410135,-0.081,
	-2.90415,1.406137,0,	-2.9576,1.5348,0,	-2.949693,1.53779,-0.081,
	-2.949693,1.53779,-0.081,	-2.896846,1.410135,-0.081,	-2.90415,1.406137,0,
	-2.604074,1.446029,-0.081,	-2.650604,1.544903,-0.081,	-2.6433,1.5489,0,
	-2.6433,1.5489,0,	-2.5976,1.4508,0,	-2.604074,1.446029,-0.081,
	-2.621645,1.433078,-0.144,	-2.670428,1.534053,-0.144,	-2.650604,1.544903,-0.081,
	-2.650604,1.544903,-0.081,	-2.604074,1.446029,-0.081,	-2.621645,1.433078,-0.144,
	-2.647539,1.413994,-0.189,	-2.699644,1.518063,-0.189,	-2.670428,1.534053,-0.144,
	-2.670428,1.534053,-0.144,	-2.621645,1.433078,-0.144,	-2.647539,1.413994,-0.189,
	-2.678982,1.390819,-0.216,	-2.735119,1.498648,-0.216,	-2.699644,1.518063,-0.189,
	-2.699644,1.518063,-0.189,	-2.647539,1.413994,-0.189,	-2.678982,1.390819,-0.216,
	-2.7132,1.3656,-0.225,	-2.773725,1.477519,-0.225,	-2.735119,1.498648,-0.216,
	-2.735119,1.498648,-0.216,	-2.678982,1.390819,-0.216,	-2.7132,1.3656,-0.225,
	-2.747418,1.340381,-0.216,	-2.812331,1.45639,-0.216,	-2.773725,1.477519,-0.225,
	-2.773725,1.477519,-0.225,	-2.7132,1.3656,-0.225,	-2.747418,1.340381,-0.216,
	-2.778861,1.317206,-0.189,	-2.847806,1.436974,-0.189,	-2.812331,1.45639,-0.216,
	-2.812331,1.45639,-0.216,	-2.747418,1.340381,-0.216,	-2.778861,1.317206,-0.189,
	-2.804755,1.298122,-0.144,	-2.877022,1.420985,-0.144,	-2.847806,1.436974,-0.189,
	-2.847806,1.436974,-0.189,	-2.778861,1.317206,-0.189,	-2.804755,1.298122,-0.144,
	-2.822326,1.285171,-0.081,	-2.896846,1.410135,-0.081,	-2.877022,1.420985,-0.144,
	-2.877022,1.420985,-0.144,	-2.804755,1.298122,-0.144,	-2.822326,1.285171,-0.081,
	-2.8288,1.2804,0,	-2.90415,1.406137,0,	-2.896846,1.410135,-0.081,
	-2.896846,1.410135,-0.081,	-2.822326,1.285171,-0.081,	-2.8288,1.2804,0,
	-2.542925,1.344619,-0.081,	-2.604074,1.446029,-0.081,	-2.5976,1.4508,0,
	-2.5976,1.4508,0,	-2.5375,1.35,0,	-2.542925,1.344619,-0.081,
	-2.55765,1.330013,-0.144,	-2.621645,1.433078,-0.144,	-2.604074,1.446029,-0.081,
	-2.604074,1.446029,-0.081,	-2.542925,1.344619,-0.081,	-2.55765,1.330013,-0.144,
	-2.57935,1.308488,-0.189,	-2.647539,1.413994,-0.189,	-2.621645,1.433078,-0.144,
	-2.621645,1.433078,-0.144,	-2.55765,1.330013,-0.144,	-2.57935,1.308488,-0.189,
	-2.6057,1.28235,-0.216,	-2.678982,1.390819,-0.216,	-2.647539,1.413994,-0.189,
	-2.647539,1.413994,-0.189,	-2.57935,1.308488,-0.189,	-2.6057,1.28235,-0.216,
	-2.634375,1.253906,-0.225,	-2.7132,1.3656,-0.225,	-2.678982,1.390819,-0.216,
	-2.678982,1.390819,-0.216,	-2.6057,1.28235,-0.216,	-2.634375,1.253906,-0.225,
	-2.66305,1.225463,-0.216,	-2.747418,1.340381,-0.216,	-2.7132,1.3656,-0.225,
	-2.7132,1.3656,-0.225,	-2.634375,1.253906,-0.225,	-2.66305,1.225463,-0.216,
	-2.6894,1.199325,-0.189,	-2.778861,1.317206,-0.189,	-2.747418,1.340381,-0.216,
	-2.747418,1.340381,-0.216,	-2.66305,1.225463,-0.216,	-2.6894,1.199325,-0.189,
	-2.7111,1.1778,-0.144,	-2.804755,1.298122,-0.144,	-2.778861,1.317206,-0.189,
	-2.778861,1.317206,-0.189,	-2.6894,1.199325,-0.189,	-2.7111,1.1778,-0.144,
	-2.725825,1.163194,-0.081,	-2.822326,1.285171,-0.081,	-2.804755,1.298122,-0.144,
	-2.804755,1.298122,-0.144,	-2.7111,1.1778,-0.144,	-2.725825,1.163194,-0.081,
	-2.73125,1.157813,0,	-2.8288,1.2804,0,	-2.822326,1.285171,-0.081,
	-2.822326,1.285171,-0.081,	-2.725825,1.163194,-0.081,	-2.73125,1.157813,0,
	-2.466566,1.243303,-0.081,	-2.542925,1.344619,-0.081,	-2.5375,1.35,0,
	-2.5375,1.35,0,	-2.4624,1.2492,0,	-2.466566,1.243303,-0.081,
	-2.477875,1.227298,-0.144,	-2.55765,1.330013,-0.144,	-2.542925,1.344619,-0.081,
	-2.542925,1.344619,-0.081,	-2.466566,1.243303,-0.081,	-2.477875,1.227298,-0.144,
	-2.494541,1.20371,-0.189,	-2.57935,1.308488,-0.189,	-2.55765,1.330013,-0.144,
	-2.55765,1.330013,-0.144,	-2.477875,1.227298,-0.144,	-2.494541,1.20371,-0.189,
	-2.514778,1.175069,-0.216,	-2.6057,1.28235,-0.216,	-2.57935,1.308488,-0.189,
	-2.57935,1.308488,-0.189,	-2.494541,1.20371,-0.189,	-2.514778,1.175069,-0.216,
	-2.5368,1.1439,-0.225,	-2.634375,1.253906,-0.225,	-2.6057,1.28235,-0.216,
	-2.6057,1.28235,-0.216,	-2.514778,1.175069,-0.216,	-2.5368,1.1439,-0.225,
	-2.558822,1.112731,-0.216,	-2.66305,1.225463,-0.216,	-2.634375,1.253906,-0.225,
	-2.634375,1.253906,-0.225,	-2.5368,1.1439,-0.225,	-2.558822,1.112731,-0.216,
	-2.579059,1.08409,-0.189,	-2.6894,1.199325,-0.189,	-2.66305,1.225463,-0.216,
	-2.66305,1.225463,-0.216,	-2.558822,1.112731,-0.216,	-2.579059,1.08409,-0.189,
	-2.595725,1.060502,-0.144,	-2.7111,1.1778,-0.144,	-2.6894,1.199325,-0.189,
	-2.6894,1.199325,-0.189,	-2.579059,1.08409,-0.189,	-2.595725,1.060502,-0.144,
	-2.607034,1.044497,-0.081,	-2.725825,1.163194,-0.081,	-2.7111,1.1778,-0.144,
	-2.7111,1.1778,-0.144,	-2.595725,1.060502,-0.144,	-2.607034,1.044497,-0.081,
	-2.6112,1.0386,0,	-2.73125,1.157813,0,	-2.725825,1.163194,-0.081,
	-2.725825,1.163194,-0.081,	-2.607034,1.044497,-0.081,	-2.6112,1.0386,0,
	-2.374406,1.144713,-0.081,	-2.466566,1.243303,-0.081,	-2.4624,1.2492,0,
	-2.4624,1.2492,0,	-2.3717,1.1511,0,	-2.374406,1.144713,-0.081,
	-2.381752,1.127376,-0.144,	-2.477875,1.227298,-0.144,	-2.466566,1.243303,-0.081,
	-2.466566,1.243303,-0.081,	-2.374406,1.144713,-0.081,	-2.381752,1.127376,-0.144,
	-2.392576,1.101828,-0.189,	-2.494541,1.20371,-0.189,	-2.477875,1.227298,-0.144,
	-2.477875,1.227298,-0.144,	-2.381752,1.127376,-0.144,	-2.392576,1.101828,-0.189,
	-2.405721,1.070804,-0.216,	-2.514778,1.175069,-0.216,	-2.494541,1.20371,-0.189,
	-2.494541,1.20371,-0.189,	-2.392576,1.101828,-0.189,	-2.405721,1.070804,-0.216,
	-2.420025,1.037044,-0.225,	-2.5368,1.1439,-0.225,	-2.514778,1.175069,-0.216,
	-2.514778,1.175069,-0.216,	-2.405721,1.070804,-0.216,	-2.420025,1.037044,-0.225,
	-2.434329,1.003283,-0.216,	-2.558822,1.112731,-0.216,	-2.5368,1.1439,-0.225,
	-2.5368,1.1439,-0.225,	-2.420025,1.037044,-0.225,	-2.434329,1.003283,-0.216,
	-2.447474,0.97226,-0.189,	-2.579059,1.08409,-0.189,	-2.558822,1.112731,-0.216,
	-2.558822,1.112731,-0.216,	-2.434329,1.003283,-0.216,	-2.447474,0.97226,-0.189,
	-2.458298,0.946711,-0.144,	-2.595725,1.060502,-0.144,	-2.579059,1.08409,-0.189,
	-2.579059,1.08409,-0.189,	-2.447474,0.97226,-0.189,	-2.458298,0.946711,-0.144,
	-2.465644,0.929375,-0.081,	-2.607034,1.044497,-0.081,	-2.595725,1.060502,-0.144,
	-2.595725,1.060502,-0.144,	-2.458298,0.946711,-0.144,	-2.465644,0.929375,-0.081,
	-2.46835,0.922987,0,	-2.6112,1.0386,0,	-2.607034,1.044497,-0.081,
	-2.607034,1.044497,-0.081,	-2.465644,0.929375,-0.081,	-2.46835,0.922987,0,
	-2.265853,1.051478,-0.081,	-2.374406,1.144713,-0.081,	-2.3717,1.1511,0,
	-2.3717,1.1511,0,	-2.2648,1.0584,0,	-2.265853,1.051478,-0.081,
	-2.26871,1.032691,-0.144,	-2.381752,1.127376,-0.144,	-2.374406,1.144713,-0.081,
	-2.374406,1.144713,-0.081,	-2.265853,1.051478,-0.081,	-2.26871,1.032691,-0.144,
	-2.272922,1.005005,-0.189,	-2.392576,1.101828,-0.189,	-2.381752,1.127376,-0.144,
	-2.381752,1.127376,-0.144,	-2.26871,1.032691,-0.144,	-2.272922,1.005005,-0.189,
	-2.278035,0.971386,-0.216,	-2.405721,1.070804,-0.216,	-2.392576,1.101828,-0.189,
	-2.392576,1.101828,-0.189,	-2.272922,1.005005,-0.189,	-2.278035,0.971386,-0.216,
	-2.2836,0.9348,-0.225,	-2.420025,1.037044,-0.225,	-2.405721,1.070804,-0.216,
	-2.405721,1.070804,-0.216,	-2.278035,0.971386,-0.216,	-2.2836,0.9348,-0.225,
	-2.289165,0.898214,-0.216,	-2.434329,1.003283,-0.216,	-2.420025,1.037044,-0.225,
	-2.420025,1.037044,-0.225,	-2.2836,0.9348,-0.225,	-2.289165,0.898214,-0.216,
	-2.294278,0.864595,-0.189,	-2.447474,0.97226,-0.189,	-2.434329,1.003283,-0.216,
	-2.434329,1.003283,-0.216,	-2.289165,0.898214,-0.216,	-2.294278,0.864595,-0.189,
	-2.29849,0.836909,-0.144,	-2.458298,0.946711,-0.144,	-2.447474,0.97226,-0.189,
	-2.447474,0.97226,-0.189,	-2.294278,0.864595,-0.189,	-2.29849,0.836909,-0.144,
	-2.301347,0.818122,-0.081,	-2.465644,0.929375,-0.081,	-2.458298,0.946711,-0.144,
	-2.458298,0.946711,-0.144,	-2.29849,0.836909,-0.144,	-2.301347,0.818122,-0.081,
	-2.3024,0.8112,0,	-2.46835,0.922987,0,	-2.465644,0.929375,-0.081,
	-2.465644,0.929375,-0.081,	-2.301347,0.818122,-0.081,	-2.3024,0.8112,0,
	-2.140315,0.966231,-0.081,	-2.265853,1.051478,-0.081,	-2.2648,1.0584,0,
	-2.2648,1.0584,0,	-2.1411,0.9738,0,	-2.140315,0.966231,-0.081,
	-2.138183,0.945685,-0.144,	-2.26871,1.032691,-0.144,	-2.265853,1.051478,-0.081,
	-2.265853,1.051478,-0.081,	-2.140315,0.966231,-0.081,	-2.138183,0.945685,-0.144,
	-2.135041,0.915407,-0.189,	-2.272922,1.005005,-0.189,	-2.26871,1.032691,-0.144,
	-2.26871,1.032691,-0.144,	-2.138183,0.945685,-0.144,	-2.135041,0.915407,-0.189,
	-2.131226,0.878641,-0.216,	-2.278035,0.971386,-0.216,	-2.272922,1.005005,-0.189,
	-2.272922,1.005005,-0.189,	-2.135041,0.915407,-0.189,	-2.131226,0.878641,-0.216,
	-2.127075,0.838631,-0.225,	-2.2836,0.9348,-0.225,	-2.278035,0.971386,-0.216,
	-2.278035,0.971386,-0.216,	-2.131226,0.878641,-0.216,	-2.127075,0.838631,-0.225,
	-2.122924,0.798621,-0.216,	-2.289165,0.898214,-0.216,	-2.2836,0.9348,-0.225,
	-2.2836,0.9348,-0.225,	-2.127075,0.838631,-0.225,	-2.122924,0.798621,-0.216,
	-2.119109,0.761855,-0.189,	-2.294278,0.864595,-0.189,	-2.289165,0.898214,-0.216,
	-2.289165,0.898214,-0.216,	-2.122924,0.798621,-0.216,	-2.119109,0.761855,-0.189,
	-2.115967,0.731578,-0.144,	-2.29849,0.836909,-0.144,	-2.294278,0.864595,-0.189,
	-2.294278,0.864595,-0.189,	-2.119109,0.761855,-0.189,	-2.115967,0.731578,-0.144,
	-2.113835,0.711032,-0.081,	-2.301347,0.818122,-0.081,	-2.29849,0.836909,-0.144,
	-2.29849,0.836909,-0.144,	-2.115967,0.731578,-0.144,	-2.113835,0.711032,-0.081,
	-2.11305,0.703463,0,	-2.3024,0.8112,0,	-2.301347,0.818122,-0.081,
	-2.301347,0.818122,-0.081,	-2.113835,0.711032,-0.081,	-2.11305,0.703463,0,
	-1.9972,0.8916,-0.081,	-2.140315,0.966231,-0.081,	-2.1411,0.9738,0,
	-2.1411,0.9738,0,	-2,0.9,0,	-1.9972,0.8916,-0.081,
	-1.9896,0.8688,-0.144,	-2.138183,0.945685,-0.144,	-2.140315,0.966231,-0.081,
	-2.140315,0.966231,-0.081,	-1.9972,0.8916,-0.081,	-1.9896,0.8688,-0.144,
	-1.9784,0.8352,-0.189,	-2.135041,0.915407,-0.189,	-2.138183,0.945685,-0.144,
	-2.138183,0.945685,-0.144,	-1.9896,0.8688,-0.144,	-1.9784,0.8352,-0.189,
	-1.9648,0.7944,-0.216,	-2.131226,0.878641,-0.216,	-2.135041,0.915407,-0.189,
	-2.135041,0.915407,-0.189,	-1.9784,0.8352,-0.189,	-1.9648,0.7944,-0.216,
	-1.95,0.75,-0.225,	-2.127075,0.838631,-0.225,	-2.131226,0.878641,-0.216,
	-2.131226,0.878641,-0.216,	-1.9648,0.7944,-0.216,	-1.95,0.75,-0.225,
	-1.9352,0.7056,-0.216,	-2.122924,0.798621,-0.216,	-2.127075,0.838631,-0.225,
	-2.127075,0.838631,-0.225,	-1.95,0.75,-0.225,	-1.9352,0.7056,-0.216,
	-1.9216,0.6648,-0.189,	-2.119109,0.761855,-0.189,	-2.122924,0.798621,-0.216,
	-2.122924,0.798621,-0.216,	-1.9352,0.7056,-0.216,	-1.9216,0.6648,-0.189,
	-1.9104,0.6312,-0.144,	-2.115967,0.731578,-0.144,	-2.119109,0.761855,-0.189,
	-2.119109,0.761855,-0.189,	-1.9216,0.6648,-0.189,	-1.9104,0.6312,-0.144,
	-1.9028,0.6084,-0.081,	-2.113835,0.711032,-0.081,	-2.115967,0.731578,-0.144,
	-2.115967,0.731578,-0.144,	-1.9104,0.6312,-0.144,	-1.9028,0.6084,-0.081,
	-1.9,0.6,0,	-2.11305,0.703463,0,	-2.113835,0.711032,-0.081,
	-2.113835,0.711032,-0.081,	-1.9028,0.6084,-0.081,	-1.9,0.6,0,
	-2.981175,1.667844,0.081,	-2.9916,1.8,0.081,	-3,1.8,0,
	-3,1.8,0,	-2.98945,1.666162,0,	-2.981175,1.667844,0.081,
	-2.958713,1.672406,0.144,	-2.9688,1.8,0.144,	-2.9916,1.8,0.081,
	-2.9916,1.8,0.081,	-2.981175,1.667844,0.081,	-2.958713,1.672406,0.144,
	-2.925611,1.679131,0.189,	-2.9352,1.8,0.189,	-2.9688,1.8,0.144,
	-2.9688,1.8,0.144,	-2.958713,1.672406,0.144,	-2.925611,1.679131,0.189,
	-2.885416,1.687296,0.216,	-2.8944,1.8,0.216,	-2.9352,1.8,0.189,
	-2.9352,1.8,0.189,	-2.925611,1.679131,0.189,	-2.885416,1.687296,0.216,
	-2.841675,1.696181,0.225,	-2.85,1.8,0.225,	-2.8944,1.8,0.216,
	-2.8944,1.8,0.216,	-2.885416,1.687296,0.216,	-2.841675,1.696181,0.225,
	-2.797934,1.705067,0.216,	-2.8056,1.8,0.216,	-2.85,1.8,0.225,
	-2.85,1.8,0.225,	-2.841675,1.696181,0.225,	-2.797934,1.705067,0.216,
	-2.757739,1.713232,0.189,	-2.7648,1.8,0.189,	-2.8056,1.8,0.216,
	-2.8056,1.8,0.216,	-2.797934,1.705067,0.216,	-2.757739,1.713232,0.189,
	-2.724637,1.719956,0.144,	-2.7312,1.8,0.144,	-2.7648,1.8,0.189,
	-2.7648,1.8,0.189,	-2.757739,1.713232,0.189,	-2.724637,1.719956,0.144,
	-2.702175,1.724519,0.081,	-2.7084,1.8,0.081,	-2.7312,1.8,0.144,
	-2.7312,1.8,0.144,	-2.724637,1.719956,0.144,	-2.702175,1.724519,0.081,
	-2.6939,1.7262,0,	-2.7,1.8,0,	-2.7084,1.8,0.081,
	-2.7084,1.8,0.081,	-2.702175,1.724519,0.081,	-2.6939,1.7262,0,
	-2.949693,1.53779,0.081,	-2.981175,1.667844,0.081,	-2.98945,1.666162,0,
	-2.98945,1.666162,0,	-2.9576,1.5348,0,	-2.949693,1.53779,0.081,
	-2.92823,1.545907,0.144,	-2.958713,1.672406,0.144,	-2.981175,1.667844,0.081,
	-2.981175,1.667844,0.081,	-2.949693,1.53779,0.081,	-2.92823,1.545907,0.144,
	-2.896602,1.557869,0.189,	-2.925611,1.679131,0.189,	-2.958713,1.672406,0.144,
	-2.958713,1.672406,0.144,	-2.92823,1.545907,0.144,	-2.896602,1.557869,0.189,
	-2.858195,1.572394,0.216,	-2.885416,1.687296,0.216,	-2.925611,1.679131,0.189,
	-2.925611,1.679131,0.189,	-2.896602,1.557869,0.189,	-2.858195,1.572394,0.216,
	-2.8164,1.5882,0.225,	-2.841675,1.696181,0.225,	-2.885416,1.687296,0.216,
	-2.885416,1.687296,0.216,	-2.858195,1.572394,0.216,	-2.8164,1.5882,0.225,
	-2.774605,1.604006,0.216,	-2.797934,1.705067,0.216,	-2.841675,1.696181,0.225,
	-2.841675,1.696181,0.225,	-2.8164,1.5882,0.225,	-2.774605,1.604006,0.216,
	-2.736198,1.618531,0.189,	-2.757739,1.713232,0.189,	-2.797934,1.705067,0.216,
	-2.797934,1.705067,0.216,	-2.774605,1.604006,0.216,	-2.736198,1.618531,0.189,
	-2.70457,1.630493,0.144,	-2.724637,1.719956,0.144,	-2.757739,1.713232,0.189,
	-2.757739,1.713232,0.189,	-2.736198,1.618531,0.189,	-2.70457,1.630493,0.144,
	-2.683107,1.63861,0.081,	-2.702175,1.724519,0.081,	-2.724637,1.719956,0.144,
	-2.724637,1.719956,0.144,	-2.70457,1.630493,0.144,	-2.683107,1.63861,0.081,
	-2.6752,1.6416,0,	-2.6939,1.7262,0,	-2.702175,1.724519,0.081,
	-2.702175,1.724519,0.081,	-2.683107,1.63861,0.081,	-2.6752,1.6416,0,
	-2.896846,1.410135,0.081,	-2.949693,1.53779,0.081,	-2.9576,1.5348,0,
	-2.9576,1.5348,0,	-2.90415,1.406137,0,	-2.896846,1.410135,0.081,
	-2.877022,1.420985,0.144,	-2.92823,1.545907,0.144,	-2.949693,1.53779,0.081,
	-2.949693,1.53779,0.081,	-2.896846,1.410135,0.081,	-2.877022,1.420985,0.144,
	-2.847806,1.436974,0.189,	-2.896602,1.557869,0.189,	-2.92823,1.545907,0.144,
	-2.92823,1.545907,0.144,	-2.877022,1.420985,0.144,	-2.847806,1.436974,0.189,
	-2.812331,1.45639,0.216,	-2.858195,1.572394,0.216,	-2.896602,1.557869,0.189,
	-2.896602,1.557869,0.189,	-2.847806,1.436974,0.189,	-2.812331,1.45639,0.216,
	-2.773725,1.477519,0.225,	-2.8164,1.5882,0.225,	-2.858195,1.572394,0.216,
	-2.858195,1.572394,0.216,	-2.812331,1.45639,0.216,	-2.773725,1.477519,0.225,
	-2.735119,1.498648,0.216,	-2.774605,1.604006,0.216,	-2.8164,1.5882,0.225,
	-2.8164,1.5882,0.225,	-2.773725,1.477519,0.225,	-2.735119,1.498648,0.216,
	-2.699644,1.518063,0.189,	-2.736198,1.618531,0.189,	-2.774605,1.604006,0.216,
	-2.774605,1.604006,0.216,	-2.735119,1.498648,0.216,	-2.699644,1.518063,0.189,
	-2.670428,1.534053,0.144,	-2.70457,1.630493,0.144,	-2.736198,1.618531,0.189,
	-2.736198,1.618531,0.189,	-2.699644,1.518063,0.189,	-2.670428,1.534053,0.144,
	-2.650604,1.544903,0.081,	-2.683107,1.63861,0.081,	-2.70457,1.630493,0.144,
	-2.70457,1.630493,0.144,	-2.670428,1.534053,0.144,	-2.650604,1.544903,0.081,
	-2.6433,1.5489,0,	-2.6752,1.6416,0,	-2.683107,1.63861,0.081,
	-2.683107,1.63861,0.081,	-2.650604,1.544903,0.081,	-2.6433,1.5489,0,
	-2.822326,1.285171,0.081,	-2.896846,1.410135,0.081,	-2.90415,1.406137,0,
	-2.90415,1.406137,0,	-2.8288,1.2804,0,	-2.822326,1.285171,0.081,
	-2.804755,1.298122,0.144,	-2.877022,1.420985,0.144,	-2.896846,1.410135,0.081,
	-2.896846,1.410135,0.081,	-2.822326,1.285171,0.081,	-2.804755,1.298122,0.144,
	-2.778861,1.317206,0.189,	-2.847806,1.436974,0.189,	-2.877022,1.420985,0.144,
	-2.877022,1.420985,0.144,	-2.804755,1.298122,0.144,	-2.778861,1.317206,0.189,
	-2.747418,1.340381,0.216,	-2.812331,1.45639,0.216,	-2.847806,1.436974,0.189,
	-2.847806,1.436974,0.189,	-2.778861,1.317206,0.189,	-2.747418,1.340381,0.216,
	-2.7132,1.3656,0.225,	-2.773725,1.477519,0.225,	-2.812331,1.45639,0.216,
	-2.812331,1.45639,0.216,	-2.747418,1.340381,0.216,	-2.7132,1.3656,0.225,
	-2.678982,1.390819,0.216,	-2.735119,1.498648,0.216,	-2.773725,1.477519,0.225,
	-2.773725,1.477519,0.225,	-2.7132,1.3656,0.225,	-2.678982,1.390819,0.216,
	-2.647539,1.413994,0.189,	-2.699644,1.518063,0.189,	-2.735119,1.498648,0.216,
	-2.735119,1.498648,0.216,	-2.678982,1.390819,0.216,	-2.647539,1.413994,0.189,
	-2.621645,1.433078,0.144,	-2.670428,1.534053,0.144,	-2.699644,1.518063,0.189,
	-2.699644,1.518063,0.189,	-2.647539,1.413994,0.189,	-2.621645,1.433078,0.144,
	-2.604074,1.446029,0.081,	-2.650604,1.544903,0.081,	-2.670428,1.534053,0.144,
	-2.670428,1.534053,0.144,	-2.621645,1.433078,0.144,	-2.604074,1.446029,0.081,
	-2.5976,1.4508,0,	-2.6433,1.5489,0,	-2.650604,1.544903,0.081,
	-2.650604,1.544903,0.081,	-2.604074,1.446029,0.081,	-2.5976,1.4508,0,
	-2.725825,1.163194,0.081,	-2.822326,1.285171,0.081,	-2.8288,1.2804,0,
	-2.8288,1.2804,0,	-2.73125,1.157813,0,	-2.725825,1.163194,0.081,
	-2.7111,1.1778,0.144,	-2.804755,1.298122,0.144,	-2.822326,1.285171,0.081,
	-2.822326,1.285171,0.081,	-2.725825,1.163194,0.081,	-2.7111,1.1778,0.144,
	-2.6894,1.199325,0.189,	-2.778861,1.317206,0.189,	-2.804755,1.298122,0.144,
	-2.804755,1.298122,0.144,	-2.7111,1.1778,0.144,	-2.6894,1.199325,0.189,
	-2.66305,1.225463,0.216,	-2.747418,1.340381,0.216,	-2.778861,1.317206,0.189,
	-2.778861,1.317206,0.189,	-2.6894,1.199325,0.189,	-2.66305,1.225463,0.216,
	-2.634375,1.253906,0.225,	-2.7132,1.3656,0.225,	-2.747418,1.340381,0.216,
	-2.747418,1.340381,0.216,	-2.66305,1.225463,0.216,	-2.634375,1.253906,0.225,
	-2.6057,1.28235,0.216,	-2.678982,1.390819,0.216,	-2.7132,1.3656,0.225,
	-2.7132,1.3656,0.225,	-2.634375,1.253906,0.225,	-2.6057,1.28235,0.216,
	-2.57935,1.308488,0.189,	-2.647539,1.413994,0.189,	-2.678982,1.390819,0.216,
	-2.678982,1.390819,0.216,	-2.6057,1.28235,0.216,	-2.57935,1.308488,0.189,
	-2.55765,1.330013,0.144,	-2.621645,1.433078,0.144,	-2.647539,1.413994,0.189,
	-2.647539,1.413994,0.189,	-2.57935,1.308488,0.189,	-2.55765,1.330013,0.144,
	-2.542925,1.344619,0.081,	-2.604074,1.446029,0.081,	-2.621645,1.433078,0.144,
	-2.621645,1.433078,0.144,	-2.55765,1.330013,0.144,	-2.542925,1.344619,0.081,
	-2.5375,1.35,0,	-2.5976,1.4508,0,	-2.604074,1.446029,0.081,
	-2.604074,1.446029,0.081,	-2.542925,1.344619,0.081,	-2.5375,1.35,0,
	-2.607034,1.044497,0.081,	-2.725825,1.163194,0.081,	-2.73125,1.157813,0,
	-2.73125,1.157813,0,	-2.6112,1.0386,0,	-2.607034,1.044497,0.081,
	-2.595725,1.060502,0.144,	-2.7111,1.1778,0.144,	-2.725825,1.163194,0.081,
	-2.725825,1.163194,0.081,	-2.607034,1.044497,0.081,	-2.595725,1.060502,0.144,
	-2.579059,1.08409,0.189,	-2.6894,1.199325,0.189,	-2.7111,1.1778,0.144,
	-2.7111,1.1778,0.144,	-2.595725,1.060502,0.144,	-2.579059,1.08409,0.189,
	-2.558822,1.112731,0.216,	-2.66305,1.225463,0.216,	-2.6894,1.199325,0.189,
	-2.6894,1.199325,0.189,	-2.579059,1.08409,0.189,	-2.558822,1.112731,0.216,
	-2.5368,1.1439,0.225,	-2.634375,1.253906,0.225,	-2.66305,1.225463,0.216,
	-2.66305,1.225463,0.216,	-2.558822,1.112731,0.216,	-2.5368,1.1439,0.225,
	-2.514778,1.175069,0.216,	-2.6057,1.28235,0.216,	-2.634375,1.253906,0.225,
	-2.634375,1.253906,0.225,	-2.5368,1.1439,0.225,	-2.514778,1.175069,0.216,
	-2.494541,1.20371,0.189,	-2.57935,1.308488,0.189,	-2.6057,1.28235,0.216,
	-2.6057,1.28235,0.216,	-2.514778,1.175069,0.216,	-2.494541,1.20371,0.189,
	-2.477875,1.227298,0.144,	-2.55765,1.330013,0.144,	-2.57935,1.308488,0.189,
	-2.57935,1.308488,0.189,	-2.494541,1.20371,0.189,	-2.477875,1.227298,0.144,
	-2.466566,1.243303,0.081,	-2.542925,1.344619,0.081,	-2.55765,1.330013,0.144,
	-2.55765,1.330013,0.144,	-2.477875,1.227298,0.144,	-2.466566,1.243303,0.081,
	-2.4624,1.2492,0,	-2.5375,1.35,0,	-2.542925,1.344619,0.081,
	-2.542925,1.344619,0.081,	-2.466566,1.243303,0.081,	-2.4624,1.2492,0,
	-2.465644,0.929375,0.081,	-2.607034,1.044497,0.081,	-2.6112,1.0386,0,
	-2.6112,1.0386,0,	-2.46835,0.922987,0,	-2.465644,0.929375,0.081,
	-2.458298,0.946711,0.144,	-2.595725,1.060502,0.144,	-2.607034,1.044497,0.081,
	-2.607034,1.044497,0.081,	-2.465644,0.929375,0.081,	-2.458298,0.946711,0.144,
	-2.447474,0.97226,0.189,	-2.579059,1.08409,0.189,	-2.595725,1.060502,0.144,
	-2.595725,1.060502,0.144,	-2.458298,0.946711,0.144,	-2.447474,0.97226,0.189,
	-2.434329,1.003283,0.216,	-2.558822,1.112731,0.216,	-2.579059,1.08409,0.189,
	-2.579059,1.08409,0.189,	-2.447474,0.97226,0.189,	-2.434329,1.003283,0.216,
	-2.420025,1.037044,0.225,	-2.5368,1.1439,0.225,	-2.558822,1.112731,0.216,
	-2.558822,1.112731,0.216,	-2.434329,1.003283,0.216,	-2.420025,1.037044,0.225,
	-2.405721,1.070804,0.216,	-2.514778,1.175069,0.216,	-2.5368,1.1439,0.225,
	-2.5368,1.1439,0.225,	-2.420025,1.037044,0.225,	-2.405721,1.070804,0.216,
	-2.392576,1.101828,0.189,	-2.494541,1.20371,0.189,	-2.514778,1.175069,0.216,
	-2.514778,1.175069,0.216,	-2.405721,1.070804,0.216,	-2.392576,1.101828,0.189,
	-2.381752,1.127376,0.144,	-2.477875,1.227298,0.144,	-2.494541,1.20371,0.189,
	-2.494541,1.20371,0.189,	-2.392576,1.101828,0.189,	-2.381752,1.127376,0.144,
	-2.374406,1.144713,0.081,	-2.466566,1.243303,0.081,	-2.477875,1.227298,0.144,
	-2.477875,1.227298,0.144,	-2.381752,1.127376,0.144,	-2.374406,1.144713,0.081,
	-2.3717,1.1511,0,	-2.4624,1.2492,0,	-2.466566,1.243303,0.081,
	-2.466566,1.243303,0.081,	-2.374406,1.144713,0.081,	-2.3717,1.1511,0,
	-2.301347,0.818122,0.081,	-2.465644,0.929375,0.081,	-2.46835,0.922987,0,
	-2.46835,0.922987,0,	-2.3024,0.8112,0,	-2.301347,0.818122,0.081,
	-2.29849,0.836909,0.144,	-2.458298,0.946711,0.144,	-2.465644,0.929375,0.081,
	-2.465644,0.929375,0.081,	-2.301347,0.818122,0.081,	-2.29849,0.836909,0.144,
	-2.294278,0.864595,0.189,	-2.447474,0.97226,0.189,	-2.458298,0.946711,0.144,
	-2.458298,0.946711,0.144,	-2.29849,0.836909,0.144,	-2.294278,0.864595,0.189,
	-2.289165,0.898214,0.216,	-2.434329,1.003283,0.216,	-2.447474,0.97226,0.189,
	-2.447474,0.97226,0.189,	-2.294278,0.864595,0.189,	-2.289165,0.898214,0.216,
	-2.2836,0.9348,0.225,	-2.420025,1.037044,0.225,	-2.434329,1.003283,0.216,
	-2.434329,1.003283,0.216,	-2.289165,0.898214,0.216,	-2.2836,0.9348,0.225,
	-2.278035,0.971386,0.216,	-2.405721,1.070804,0.216,	-2.420025,1.037044,0.225,
	-2.420025,1.037044,0.225,	-2.2836,0.9348,0.225,	-2.278035,0.971386,0.216,
	-2.272922,1.005005,0.189,	-2.392576,1.101828,0.189,	-2.405721,1.070804,0.216,
	-2.405721,1.070804,0.216,	-2.278035,0.971386,0.216,	-2.272922,1.005005,0.189,
	-2.26871,1.032691,0.144,	-2.381752,1.127376,0.144,	-2.392576,1.101828,0.189,
	-2.392576,1.101828,0.189,	-2.272922,1.005005,0.189,	-2.26871,1.032691,0.144,
	-2.265853,1.051478,0.081,	-2.374406,1.144713,0.081,	-2.381752,1.127376,0.144,
	-2.381752,1.127376,0.144,	-2.26871,1.032691,0.144,	-2.265853,1.051478,0.081,
	-2.2648,1.0584,0,	-2.3717,1.1511,0,	-2.374406,1.144713,0.081,
	-2.374406,1.144713,0.081,	-2.265853,1.051478,0.081,	-2.2648,1.0584,0,
	-2.113835,0.711032,0.081,	-2.301347,0.818122,0.081,	-2.3024,0.8112,0,
	-2.3024,0.8112,0,	-2.11305,0.703463,0,	-2.113835,0.711032,0.081,
	-2.115967,0.731578,0.144,	-2.29849,0.836909,0.144,	-2.301347,0.818122,0.081,
	-2.301347,0.818122,0.081,	-2.113835,0.711032,0.081,	-2.115967,0.731578,0.144,
	-2.119109,0.761855,0.189,	-2.294278,0.864595,0.189,	-2.29849,0.836909,0.144,
	-2.29849,0.836909,0.144,	-2.115967,0.731578,0.144,	-2.119109,0.761855,0.189,
	-2.122924,0.798621,0.216,	-2.289165,0.898214,0.216,	-2.294278,0.864595,0.189,
	-2.294278,0.864595,0.189,	-2.119109,0.761855,0.189,	-2.122924,0.798621,0.216,
	-2.127075,0.838631,0.225,	-2.2836,0.9348,0.225,	-2.289165,0.898214,0.216,
	-2.289165,0.898214,0.216,	-2.122924,0.798621,0.216,	-2.127075,0.838631,0.225,
	-2.131226,0.878641,0.216,	-2.278035,0.971386,0.216,	-2.2836,0.9348,0.225,
	-2.2836,0.9348,0.225,	-2.127075,0.838631,0.225,	-2.131226,0.878641,0.216,
	-2.135041,0.915407,0.189,	-2.272922,1.005005,0.189,	-2.278035,0.971386,0.216,
	-2.278035,0.971386,0.216,	-2.131226,0.878641,0.216,	-2.135041,0.915407,0.189,
	-2.138183,0.945685,0.144,	-2.26871,1.032691,0.144,	-2.272922,1.005005,0.189,
	-2.272922,1.005005,0.189,	-2.135041,0.915407,0.189,	-2.138183,0.945685,0.144,
	-2.140315,0.966231,0.081,	-2.265853,1.051478,0.081,	-2.26871,1.032691,0.144,
	-2.26871,1.032691,0.144,	-2.138183,0.945685,0.144,	-2.140315,0.966231,0.081,
	-2.1411,0.9738,0,	-2.2648,1.0584,0,	-2.265853,1.051478,0.081,
	-2.265853,1.051478,0.081,	-2.140315,0.966231,0.081,	-2.1411,0.9738,0,
	-1.9028,0.6084,0.081,	-2.113835,0.711032,0.081,	-2.11305,0.703463,0,
	-2.11305,0.703463,0,	-1.9,0.6,0,	-1.9028,0.6084,0.081,
	-1.9104,0.6312,0.144,	-2.115967,0.731578,0.144,	-2.113835,0.711032,0.081,
	-2.113835,0.711032,0.081,	-1.9028,0.6084,0.081,	-1.9104,0.6312,0.144,
	-1.9216,0.6648,0.189,	-2.119109,0.761855,0.189,	-2.115967,0.731578,0.144,
	-2.115967,0.731578,0.144,	-1.9104,0.6312,0.144,	-1.9216,0.6648,0.189,
	-1.9352,0.7056,0.216,	-2.122924,0.798621,0.216,	-2.119109,0.761855,0.189,
	-2.119109,0.761855,0.189,	-1.9216,0.6648,0.189,	-1.9352,0.7056,0.216,
	-1.95,0.75,0.225,	-2.127075,0.838631,0.225,	-2.122924,0.798621,0.216,
	-2.122924,0.798621,0.216,	-1.9352,0.7056,0.216,	-1.95,0.75,0.225,
	-1.9648,0.7944,0.216,	-2.131226,0.878641,0.216,	-2.127075,0.838631,0.225,
	-2.127075,0.838631,0.225,	-1.95,0.75,0.225,	-1.9648,0.7944,0.216,
	-1.9784,0.8352,0.189,	-2.135041,0.915407,0.189,	-2.131226,0.878641,0.216,
	-2.131226,0.878641,0.216,	-1.9648,0.7944,0.216,	-1.9784,0.8352,0.189,
	-1.9896,0.8688,0.144,	-2.138183,0.945685,0.144,	-2.135041,0.915407,0.189,
	-2.135041,0.915407,0.189,	-1.9784,0.8352,0.189,	-1.9896,0.8688,0.144,
	-1.9972,0.8916,0.081,	-2.140315,0.966231,0.081,	-2.138183,0.945685,0.144,
	-2.138183,0.945685,0.144,	-1.9896,0.8688,0.144,	-1.9972,0.8916,0.081,
	-2,0.9,0,	-2.1411,0.9738,0,	-2.140315,0.966231,0.081,
	-2.140315,0.966231,0.081,	-1.9972,0.8916,0.081,	-2,0.9,0,
	1.939394,1.423221,-0.1751,	1.7,1.4019,-0.1782,	1.7,1.425,0,
	1.7,1.425,0,	1.9359,1.4442,0,	1.939394,1.423221,-0.1751,
	1.948879,1.366278,-0.31129,	1.7,1.3392,-0.3168,	1.7,1.4019,-0.1782,
	1.7,1.4019,-0.1782,	1.939394,1.423221,-0.1751,	1.948879,1.366278,-0.31129,
	1.962857,1.282362,-0.408568,	1.7,1.2468,-0.4158,	1.7,1.3392,-0.3168,
	1.7,1.3392,-0.3168,	1.948879,1.366278,-0.31129,	1.962857,1.282362,-0.408568,
	1.97983,1.180464,-0.466934,	1.7,1.1346,-0.4752,	1.7,1.2468,-0.4158,
	1.7,1.2468,-0.4158,	1.962857,1.282362,-0.408568,	1.97983,1.180464,-0.466934,
	1.9983,1.069575,-0.48639,	1.7,1.0125,-0.495,	1.7,1.1346,-0.4752,
	1.7,1.1346,-0.4752,	1.97983,1.180464,-0.466934,	1.9983,1.069575,-0.48639,
	2.01677,0.958686,-0.466934,	1.7,0.8904,-0.4752,	1.7,1.0125,-0.495,
	1.7,1.0125,-0.495,	1.9983,1.069575,-0.48639,	2.01677,0.958686,-0.466934,
	2.033743,0.856788,-0.408568,	1.7,0.7782,-0.4158,	1.7,0.8904,-0.4752,
	1.7,0.8904,-0.4752,	2.01677,0.958686,-0.466934,	2.033743,0.856788,-0.408568,
	2.047721,0.772872,-0.31129,	1.7,0.6858,-0.3168,	1.7,0.7782,-0.4158,
	1.7,0.7782,-0.4158,	2.033743,0.856788,-0.408568,	2.047721,0.772872,-0.31129,
	2.057206,0.715929,-0.1751,	1.7,0.6231,-0.1782,	1.7,0.6858,-0.3168,
	1.7,0.6858,-0.3168,	2.047721,0.772872,-0.31129,	2.057206,0.715929,-0.1751,
	2.0607,0.69495,0,	1.7,0.6,0,	1.7,0.6231,-0.1782,
	1.7,0.6231,-0.1782,	2.057206,0.715929,-0.1751,	2.0607,0.69495,0,
	2.116979,1.47912,-0.166687,	1.939394,1.423221,-0.1751,	1.9359,1.4442,0,
	1.9359,1.4442,0,	2.1112,1.4976,0,	2.116979,1.47912,-0.166687,
	2.132666,1.42896,-0.296333,	1.948879,1.366278,-0.31129,	1.939394,1.423221,-0.1751,
	1.939394,1.423221,-0.1751,	2.116979,1.47912,-0.166687,	2.132666,1.42896,-0.296333,
	2.155782,1.35504,-0.388937,	1.962857,1.282362,-0.408568,	1.948879,1.366278,-0.31129,
	1.948879,1.366278,-0.31129,	2.132666,1.42896,-0.296333,	2.155782,1.35504,-0.388937,
	2.183853,1.26528,-0.444499,	1.97983,1.180464,-0.466934,	1.962857,1.282362,-0.408568,
	1.962857,1.282362,-0.408568,	2.155782,1.35504,-0.388937,	2.183853,1.26528,-0.444499,
	2.2144,1.1676,-0.46302,	1.9983,1.069575,-0.48639,	1.97983,1.180464,-0.466934,
	1.97983,1.180464,-0.466934,	2.183853,1.26528,-0.444499,	2.2144,1.1676,-0.46302,
	2.244947,1.06992,-0.444499,	2.01677,0.958686,-0.466934,	1.9983,1.069575,-0.48639,
	1.9983,1.069575,-0.48639,	2.2144,1.1676,-0.46302,	2.244947,1.06992,-0.444499,
	2.273018,0.98016,-0.388937,	2.033743,0.856788,-0.408568,	2.01677,0.958686,-0.466934,
	2.01677,0.958686,-0.466934,	2.244947,1.06992,-0.444499,	2.273018,0.98016,-0.388937,
	2.296134,0.90624,-0.296333,	2.047721,0.772872,-0.31129,	2.033743,0.856788,-0.408568,
	2.033743,0.856788,-0.408568,	2.273018,0.98016,-0.388937,	2.296134,0.90624,-0.296333,
	2.311821,0.85608,-0.166687,	2.057206,0.715929,-0.1751,	2.047721,0.772872,-0.31129,
	2.047721,0.772872,-0.31129,	2.296134,0.90624,-0.296333,	2.311821,0.85608,-0.166687,
	2.3176,0.8376,0,	2.0607,0.69495,0,	2.057206,0.715929,-0.1751,
	2.057206,0.715929,-0.1751,	2.311821,0.85608,-0.166687,	2.3176,0.8376,0,
	2.244457,1.563171,-0.154289,	2.116979,1.47912,-0.166687,	2.1112,1.4976,0,
	2.1112,1.4976,0,	2.2373,1.5789,0,	2.244457,1.563171,-0.154289,
	2.263882,1.520478,-0.274291,	2.132666,1.42896,-0.296333,	2.116979,1.47912,-0.166687,
	2.116979,1.47912,-0.166687,	2.244457,1.563171,-0.154289,	2.263882,1.520478,-0.274291,
	2.29251,1.457562,-0.360007,	2.155782,1.35504,-0.388937,	2.132666,1.42896,-0.296333,
	2.132666,1.42896,-0.296333,	2.263882,1.520478,-0.274291,	2.29251,1.457562,-0.360007,
	2.327271,1.381164,-0.411437,	2.183853,1.26528,-0.444499,	2.155782,1.35504,-0.388937,
	2.155782,1.35504,-0.388937,	2.29251,1.457562,-0.360007,	2.327271,1.381164,-0.411437,
	2.3651,1.298025,-0.42858,	2.2144,1.1676,-0.46302,	2.183853,1.26528,-0.444499,
	2.183853,1.26528,-0.444499,	2.327271,1.381164,-0.411437,	2.3651,1.298025,-0.42858,
	2.402929,1.214886,-0.411437,	2.244947,1.06992,-0.444499,	2.2144,1.1676,-0.46302,
	2.2144,1.1676,-0.46302,	2.3651,1.298025,-0.42858,	2.402929,1.214886,-0.411437,
	2.43769,1.138488,-0.360007,	2.273018,0.98016,-0.388937,	2.244947,1.06992,-0.444499,
	2.244947,1.06992,-0.444499,	2.402929,1.214886,-0.411437,	2.43769,1.138488,-0.360007,
	2.466318,1.075572,-0.274291,	2.296134,0.90624,-0.296333,	2.273018,0.98016,-0.388937,
	2.273018,0.98016,-0.388937,	2.43769,1.138488,-0.360007,	2.466318,1.075572,-0.274291,
	2.485743,1.032879,-0.154289,	2.311821,0.85608,-0.166687,	2.296134,0.90624,-0.296333,
	2.296134,0.90624,-0.296333,	2.466318,1.075572,-0.274291,	2.485743,1.032879,-0.154289,
	2.4929,1.01715,0,	2.3176,0.8376,0,	2.311821,0.85608,-0.166687,
	2.311821,0.85608,-0.166687,	2.485743,1.032879,-0.154289,	2.4929,1.01715,0,
	2.33353,1.668948,-0.139234,	2.244457,1.563171,-0.154289,	2.2373,1.5789,0,
	2.2373,1.5789,0,	2.3256,1.6818,0,	2.33353,1.668948,-0.139234,
	2.355053,1.634064,-0.247526,	2.263882,1.520478,-0.274291,	2.244457,1.563171,-0.154289,
	2.244457,1.563171,-0.154289,	2.33353,1.668948,-0.139234,	2.355053,1.634064,-0.247526,
	2.386771,1.582656,-0.324878,	2.29251,1.457562,-0.360007,	2.263882,1.520478,-0.274291,
	2.263882,1.520478,-0.274291,	2.355053,1.634064,-0.247526,	2.386771,1.582656,-0.324878,
	2.425286,1.520232,-0.37129,	2.327271,1.381164,-0.411437,	2.29251,1.457562,-0.360007,
	2.29251,1.457562,-0.360007,	2.386771,1.582656,-0.324878,	2.425286,1.520232,-0.37129,
	2.4672,1.4523,-0.38676,	2.3651,1.298025,-0.42858,	2.327271,1.381164,-0.411437,
	2.327271,1.381164,-0.411437,	2.425286,1.520232,-0.37129,	2.4672,1.4523,-0.38676,
	2.509114,1.384368,-0.37129,	2.402929,1.214886,-0.411437,	2.3651,1.298025,-0.42858,
	2.3651,1.298025,-0.42858,	2.4672,1.4523,-0.38676,	2.509114,1.384368,-0.37129,
	2.547629,1.321944,-0.324878,	2.43769,1.138488,-0.360007,	2.402929,1.214886,-0.411437,
	2.402929,1.214886,-0.411437,	2.509114,1.384368,-0.37129,	2.547629,1.321944,-0.324878,
	2.579347,1.270536,-0.247526,	2.466318,1.075572,-0.274291,	2.43769,1.138488,-0.360007,
	2.43769,1.138488,-0.360007,	2.547629,1.321944,-0.324878,	2.579347,1.270536,-0.247526,
	2.60087,1.235652,-0.139234,	2.485743,1.032879,-0.154289,	2.466318,1.075572,-0.274291,
	2.466318,1.075572,-0.274291,	2.579347,1.270536,-0.247526,	2.60087,1.235652,-0.139234,
	2.6088,1.2228,0,	2.4929,1.01715,0,	2.485743,1.032879,-0.154289,
	2.485743,1.032879,-0.154289,	2.60087,1.235652,-0.139234,	2.6088,1.2228,0,
	2.3959,1.790025,-0.12285,	2.33353,1.668948,-0.139234,	2.3256,1.6818,0,
	2.3256,1.6818,0,	2.3875,1.8,0,	2.3959,1.790025,-0.12285,
	2.4187,1.76295,-0.2184,	2.355053,1.634064,-0.247526,	2.33353,1.668948,-0.139234,
	2.33353,1.668948,-0.139234,	2.3959,1.790025,-0.12285,	2.4187,1.76295,-0.2184,
	2.4523,1.72305,-0.28665,	2.386771,1.582656,-0.324878,	2.355053,1.634064,-0.247526,
	2.355053,1.634064,-0.247526,	2.4187,1.76295,-0.2184,	2.4523,1.72305,-0.28665,
	2.4931,1.6746,-0.3276,	2.425286,1.520232,-0.37129,	2.386771,1.582656,-0.324878,
	2.386771,1.582656,-0.324878,	2.4523,1.72305,-0.28665,	2.4931,1.6746,-0.3276,
	2.5375,1.621875,-0.34125,	2.4672,1.4523,-0.38676,	2.425286,1.520232,-0.37129,
	2.425286,1.520232,-0.37129,	2.4931,1.6746,-0.3276,	2.5375,1.621875,-0.34125,
	2.5819,1.56915,-0.3276,	2.509114,1.384368,-0.37129,	2.4672,1.4523,-0.38676,
	2.4672,1.4523,-0.38676,	2.5375,1.621875,-0.34125,	2.5819,1.56915,-0.3276,
	2.6227,1.5207,-0.28665,	2.547629,1.321944,-0.324878,	2.509114,1.384368,-0.37129,
	2.509114,1.384368,-0.37129,	2.5819,1.56915,-0.3276,	2.6227,1.5207,-0.28665,
	2.6563,1.4808,-0.2184,	2.579347,1.270536,-0.247526,	2.547629,1.321944,-0.324878,
	2.547629,1.321944,-0.324878,	2.6227,1.5207,-0.28665,	2.6563,1.4808,-0.2184,
	2.6791,1.453725,-0.12285,	2.60087,1.235652,-0.139234,	2.579347,1.270536,-0.247526,
	2.579347,1.270536,-0.247526,	2.6563,1.4808,-0.2184,	2.6791,1.453725,-0.12285,
	2.6875,1.44375,0,	2.6088,1.2228,0,	2.60087,1.235652,-0.139234,
	2.60087,1.235652,-0.139234,	2.6791,1.453725,-0.12285,	2.6875,1.44375,0,
	2.44327,1.919976,-0.106466,	2.3959,1.790025,-0.12285,	2.3875,1.8,0,
	2.3875,1.8,0,	2.4344,1.9272,0,	2.44327,1.919976,-0.106466,
	2.467347,1.900368,-0.189274,	2.4187,1.76295,-0.2184,	2.3959,1.790025,-0.12285,
	2.3959,1.790025,-0.12285,	2.44327,1.919976,-0.106466,	2.467347,1.900368,-0.189274,
	2.502829,1.871472,-0.248422,	2.4523,1.72305,-0.28665,	2.4187,1.76295,-0.2184,
	2.4187,1.76295,-0.2184,	2.467347,1.900368,-0.189274,	2.502829,1.871472,-0.248422,
	2.545914,1.836384,-0.28391,	2.4931,1.6746,-0.3276,	2.4523,1.72305,-0.28665,
	2.4523,1.72305,-0.28665,	2.502829,1.871472,-0.248422,	2.545914,1.836384,-0.28391,
	2.5928,1.7982,-0.29574,	2.5375,1.621875,-0.34125,	2.4931,1.6746,-0.3276,
	2.4931,1.6746,-0.3276,	2.545914,1.836384,-0.28391,	2.5928,1.7982,-0.29574,
	2.639686,1.760016,-0.28391,	2.5819,1.56915,-0.3276,	2.5375,1.621875,-0.34125,
	2.5375,1.621875,-0.34125,	2.5928,1.7982,-0.29574,	2.639686,1.760016,-0.28391,
	2.682771,1.724928,-0.248422,	2.6227,1.5207,-0.28665,	2.5819,1.56915,-0.3276,
	2.5819,1.56915,-0.3276,	2.639686,1.760016,-0.28391,	2.682771,1.724928,-0.248422,
	2.718253,1.696032,-0.189274,	2.6563,1.4808,-0.2184,	2.6227,1.5207,-0.28665,
	2.6227,1.5207,-0.28665,	2.682771,1.724928,-0.248422,	2.718253,1.696032,-0.189274,
	2.74233,1.676424,-0.106466,	2.6791,1.453725,-0.12285,	2.6563,1.4808,-0.2184,
	2.6563,1.4808,-0.2184,	2.718253,1.696032,-0.189274,	2.74233,1.676424,-0.106466,
	2.7512,1.6692,0,	2.6875,1.44375,0,	2.6791,1.453725,-0.12285,
	2.6791,1.453725,-0.12285,	2.74233,1.676424,-0.106466,	2.7512,1.6692,0,
	2.487343,2.052375,-0.091411,	2.44327,1.919976,-0.106466,	2.4344,1.9272,0,
	2.4344,1.9272,0,	2.4777,2.0571,0,	2.487343,2.052375,-0.091411,
	2.513518,2.03955,-0.162509,	2.467347,1.900368,-0.189274,	2.44327,1.919976,-0.106466,
	2.44327,1.919976,-0.106466,	2.487343,2.052375,-0.091411,	2.513518,2.03955,-0.162509,
	2.55209,2.02065,-0.213293,	2.502829,1.871472,-0.248422,	2.467347,1.900368,-0.189274,
	2.467347,1.900368,-0.189274,	2.513518,2.03955,-0.162509,	2.55209,2.02065,-0.213293,
	2.598929,1.9977,-0.243763,	2.545914,1.836384,-0.28391,	2.502829,1.871472,-0.248422,
	2.502829,1.871472,-0.248422,	2.55209,2.02065,-0.213293,	2.598929,1.9977,-0.243763,
	2.6499,1.972725,-0.25392,	2.5928,1.7982,-0.29574,	2.545914,1.836384,-0.28391,
	2.545914,1.836384,-0.28391,	2.598929,1.9977,-0.243763,	2.6499,1.972725,-0.25392,
	2.700871,1.94775,-0.243763,	2.639686,1.760016,-0.28391,	2.5928,1.7982,-0.29574,
	2.5928,1.7982,-0.29574,	2.6499,1.972725,-0.25392,	2.700871,1.94775,-0.243763,
	2.74771,1.9248,-0.213293,	2.682771,1.724928,-0.248422,	2.639686,1.760016,-0.28391,
	2.639686,1.760016,-0.28391,	2.700871,1.94775,-0.243763,	2.74771,1.9248,-0.213293,
	2.786282,1.9059,-0.162509,	2.718253,1.696032,-0.189274,	2.682771,1.724928,-0.248422,
	2.682771,1.724928,-0.248422,	2.74771,1.9248,-0.213293,	2.786282,1.9059,-0.162509,
	2.812457,1.893075,-0.091411,	2.74233,1.676424,-0.106466,	2.718253,1.696032,-0.189274,
	2.718253,1.696032,-0.189274,	2.786282,1.9059,-0.162509,	2.812457,1.893075,-0.091411,
	2.8221,1.88835,0,	2.7512,1.6692,0,	2.74233,1.676424,-0.106466,
	2.74233,1.676424,-0.106466,	2.812457,1.893075,-0.091411,	2.8221,1.88835,0,
	2.539821,2.180796,-0.079013,	2.487343,2.052375,-0.091411,	2.4777,2.0571,0,
	2.4777,2.0571,0,	2.5288,2.1834,0,	2.539821,2.180796,-0.079013,
	2.569734,2.173728,-0.140467,	2.513518,2.03955,-0.162509,	2.487343,2.052375,-0.091411,
	2.487343,2.052375,-0.091411,	2.539821,2.180796,-0.079013,	2.569734,2.173728,-0.140467,
	2.613818,2.163312,-0.184363,	2.55209,2.02065,-0.213293,	2.513518,2.03955,-0.162509,
	2.513518,2.03955,-0.162509,	2.569734,2.173728,-0.140467,	2.613818,2.163312,-0.184363,
	2.667347,2.150664,-0.210701,	2.598929,1.9977,-0.243763,	2.55209,2.02065,-0.213293,
	2.55209,2.02065,-0.213293,	2.613818,2.163312,-0.184363,	2.667347,2.150664,-0.210701,
	2.7256,2.1369,-0.21948,	2.6499,1.972725,-0.25392,	2.598929,1.9977,-0.243763,
	2.598929,1.9977,-0.243763,	2.667347,2.150664,-0.210701,	2.7256,2.1369,-0.21948,
	2.783853,2.123136,-0.210701,	2.700871,1.94775,-0.243763,	2.6499,1.972725,-0.25392,
	2.6499,1.972725,-0.25392,	2.7256,2.1369,-0.21948,	2.783853,2.123136,-0.210701,
	2.837382,2.110488,-0.184363,	2.74771,1.9248,-0.213293,	2.700871,1.94775,-0.243763,
	2.700871,1.94775,-0.243763,	2.783853,2.123136,-0.210701,	2.837382,2.110488,-0.184363,
	2.881466,2.100072,-0.140467,	2.786282,1.9059,-0.162509,	2.74771,1.9248,-0.213293,
	2.74771,1.9248,-0.213293,	2.837382,2.110488,-0.184363,	2.881466,2.100072,-0.140467,
	2.911379,2.093004,-0.079013,	2.812457,1.893075,-0.091411,	2.786282,1.9059,-0.162509,
	2.786282,1.9059,-0.162509,	2.881466,2.100072,-0.140467,	2.911379,2.093004,-0.079013,
	2.9224,2.0904,0,	2.8221,1.88835,0,	2.812457,1.893075,-0.091411,
	2.812457,1.893075,-0.091411,	2.911379,2.093004,-0.079013,	2.9224,2.0904,0,
	2.612406,2.298813,-0.0706,	2.539821,2.180796,-0.079013,	2.5288,2.1834,0,
	2.5288,2.1834,0,	2.5991,2.2998,0,	2.612406,2.298813,-0.0706,
	2.648521,2.296134,-0.12551,	2.569734,2.173728,-0.140467,	2.539821,2.180796,-0.079013,
	2.539821,2.180796,-0.079013,	2.612406,2.298813,-0.0706,	2.648521,2.296134,-0.12551,
	2.701743,2.292186,-0.164732,	2.613818,2.163312,-0.184363,	2.569734,2.173728,-0.140467,
	2.569734,2.173728,-0.140467,	2.648521,2.296134,-0.12551,	2.701743,2.292186,-0.164732,
	2.76637,2.287392,-0.188266,	2.667347,2.150664,-0.210701,	2.613818,2.163312,-0.184363,
	2.613818,2.163312,-0.184363,	2.701743,2.292186,-0.164732,	2.76637,2.287392,-0.188266,
	2.8367,2.282175,-0.19611,	2.7256,2.1369,-0.21948,	2.667347,2.150664,-0.210701,
	2.667347,2.150664,-0.210701,	2.76637,2.287392,-0.188266,	2.8367,2.282175,-0.19611,
	2.90703,2.276958,-0.188266,	2.783853,2.123136,-0.210701,	2.7256,2.1369,-0.21948,
	2.7256,2.1369,-0.21948,	2.8367,2.282175,-0.19611,	2.90703,2.276958,-0.188266,
	2.971657,2.272164,-0.164732,	2.837382,2.110488,-0.184363,	2.783853,2.123136,-0.210701,
	2.783853,2.123136,-0.210701,	2.90703,2.276958,-0.188266,	2.971657,2.272164,-0.164732,
	3.024879,2.268216,-0.12551,	2.881466,2.100072,-0.140467,	2.837382,2.110488,-0.184363,
	2.837382,2.110488,-0.184363,	2.971657,2.272164,-0.164732,	3.024879,2.268216,-0.12551,
	3.060994,2.265537,-0.0706,	2.911379,2.093004,-0.079013,	2.881466,2.100072,-0.140467,
	2.881466,2.100072,-0.140467,	3.024879,2.268216,-0.12551,	3.060994,2.265537,-0.0706,
	3.0743,2.26455,0,	2.9224,2.0904,0,	2.911379,2.093004,-0.079013,
	2.911379,2.093004,-0.079013,	3.060994,2.265537,-0.0706,	3.0743,2.26455,0,
	2.7168,2.4,-0.0675,	2.612406,2.298813,-0.0706,	2.5991,2.2998,0,
	2.5991,2.2998,0,	2.7,2.4,0,	2.7168,2.4,-0.0675,
	2.7624,2.4,-0.12,	2.648521,2.296134,-0.12551,	2.612406,2.298813,-0.0706,
	2.612406,2.298813,-0.0706,	2.7168,2.4,-0.0675,	2.7624,2.4,-0.12,
	2.8296,2.4,-0.1575,	2.701743,2.292186,-0.164732,	2.648521,2.296134,-0.12551,
	2.648521,2.296134,-0.12551,	2.7624,2.4,-0.12,	2.8296,2.4,-0.1575,
	2.9112,2.4,-0.18,	2.76637,2.287392,-0.188266,	2.701743,2.292186,-0.164732,
	2.701743,2.292186,-0.164732,	2.8296,2.4,-0.1575,	2.9112,2.4,-0.18,
	3,2.4,-0.1875,	2.8367,2.282175,-0.19611,	2.76637,2.287392,-0.188266,
	2.76637,2.287392,-0.188266,	2.9112,2.4,-0.18,	3,2.4,-0.1875,
	3.0888,2.4,-0.18,	2.90703,2.276958,-0.188266,	2.8367,2.282175,-0.19611,
	2.8367,2.282175,-0.19611,	3,2.4,-0.1875,	3.0888,2.4,-0.18,
	3.1704,2.4,-0.1575,	2.971657,2.272164,-0.164732,	2.90703,2.276958,-0.188266,
	2.90703,2.276958,-0.188266,	3.0888,2.4,-0.18,	3.1704,2.4,-0.1575,
	3.2376,2.4,-0.12,	3.024879,2.268216,-0.12551,	2.971657,2.272164,-0.164732,
	2.971657,2.272164,-0.164732,	3.1704,2.4,-0.1575,	3.2376,2.4,-0.12,
	3.2832,2.4,-0.0675,	3.060994,2.265537,-0.0706,	3.024879,2.268216,-0.12551,
	3.024879,2.268216,-0.12551,	3.2376,2.4,-0.12,	3.2832,2.4,-0.0675,
	3.3,2.4,0,	3.0743,2.26455,0,	3.060994,2.265537,-0.0706,
	3.060994,2.265537,-0.0706,	3.2832,2.4,-0.0675,	3.3,2.4,0,
	2.057206,0.715929,0.1751,	1.7,0.6231,0.1782,	1.7,0.6,0,
	1.7,0.6,0,	2.0607,0.69495,0,	2.057206,0.715929,0.1751,
	2.047721,0.772872,0.31129,	1.7,0.6858,0.3168,	1.7,0.6231,0.1782,
	1.7,0.6231,0.1782,	2.057206,0.715929,0.1751,	2.047721,0.772872,0.31129,
	2.033743,0.856788,0.408568,	1.7,0.7782,0.4158,	1.7,0.6858,0.3168,
	1.7,0.6858,0.3168,	2.047721,0.772872,0.31129,	2.033743,0.856788,0.408568,
	2.01677,0.958686,0.466934,	1.7,0.8904,0.4752,	1.7,0.7782,0.4158,
	1.7,0.7782,0.4158,	2.033743,0.856788,0.408568,	2.01677,0.958686,0.466934,
	1.9983,1.069575,0.48639,	1.7,1.0125,0.495,	1.7,0.8904,0.4752,
	1.7,0.8904,0.4752,	2.01677,0.958686,0.466934,	1.9983,1.069575,0.48639,
	1.97983,1.180464,0.466934,	1.7,1.1346,0.4752,	1.7,1.0125,0.495,
	1.7,1.0125,0.495,	1.9983,1.069575,0.48639,	1.97983,1.180464,0.466934,
	1.962857,1.282362,0.408568,	1.7,1.2468,0.4158,	1.7,1.1346,0.4752,
	1.7,1.1346,0.4752,	1.97983,1.180464,0.466934,	1.962857,1.282362,0.408568,
	1.948879,1.366278,0.31129,	1.7,1.3392,0.3168,	1.7,1.2468,0.4158,
	1.7,1.2468,0.4158,	1.962857,1.282362,0.408568,	1.948879,1.366278,0.31129,
	1.939394,1.423221,0.1751,	1.7,1.4019,0.1782,	1.7,1.3392,0.3168,
	1.7,1.3392,0.3168,	1.948879,1.366278,0.31129,	1.939394,1.423221,0.1751,
	1.9359,1.4442,0,	1.7,1.425,0,	1.7,1.4019,0.1782,
	1.7,1.4019,0.1782,	1.939394,1.423221,0.1751,	1.9359,1.4442,0,
	2.311821,0.85608,0.166687,	2.057206,0.715929,0.1751,	2.0607,0.69495,0,
	2.0607,0.69495,0,	2.3176,0.8376,0,	2.311821,0.85608,0.166687,
	2.296134,0.90624,0.296333,	2.047721,0.772872,0.31129,	2.057206,0.715929,0.1751,
	2.057206,0.715929,0.1751,	2.311821,0.85608,0.166687,	2.296134,0.90624,0.296333,
	2.273018,0.98016,0.388937,	2.033743,0.856788,0.408568,	2.047721,0.772872,0.31129,
	2.047721,0.772872,0.31129,	2.296134,0.90624,0.296333,	2.273018,0.98016,0.388937,
	2.244947,1.06992,0.444499,	2.01677,0.958686,0.466934,	2.033743,0.856788,0.408568,
	2.033743,0.856788,0.408568,	2.273018,0.98016,0.388937,	2.244947,1.06992,0.444499,
	2.2144,1.1676,0.46302,	1.9983,1.069575,0.48639,	2.01677,0.958686,0.466934,
	2.01677,0.958686,0.466934,	2.244947,1.06992,0.444499,	2.2144,1.1676,0.46302,
	2.183853,1.26528,0.444499,	1.97983,1.180464,0.466934,	1.9983,1.069575,0.48639,
	1.9983,1.069575,0.48639,	2.2144,1.1676,0.46302,	2.183853,1.26528,0.444499,
	2.155782,1.35504,0.388937,	1.962857,1.282362,0.408568,	1.97983,1.180464,0.466934,
	1.97983,1.180464,0.466934,	2.183853,1.26528,0.444499,	2.155782,1.35504,0.388937,
	2.132666,1.42896,0.296333,	1.948879,1.366278,0.31129,	1.962857,1.282362,0.408568,
	1.962857,1.282362,0.408568,	2.155782,1.35504,0.388937,	2.132666,1.42896,0.296333,
	2.116979,1.47912,0.166687,	1.939394,1.423221,0.1751,	1.948879,1.366278,0.31129,
	1.948879,1.366278,0.31129,	2.132666,1.42896,0.296333,	2.116979,1.47912,0.166687,
	2.1112,1.4976,0,	1.9359,1.4442,0,	1.939394,1.423221,0.1751,
	1.939394,1.423221,0.1751,	2.116979,1.47912,0.166687,	2.1112,1.4976,0,
	2.485743,1.032879,0.154289,	2.311821,0.85608,0.166687,	2.3176,0.8376,0,
	2.3176,0.8376,0,	2.4929,1.01715,0,	2.485743,1.032879,0.154289,
	2.466318,1.075572,0.274291,	2.296134,0.90624,0.296333,	2.311821,0.85608,0.166687,
	2.311821,0.85608,0.166687,	2.485743,1.032879,0.154289,	2.466318,1.075572,0.274291,
	2.43769,1.138488,0.360007,	2.273018,0.98016,0.388937,	2.296134,0.90624,0.296333,
	2.296134,0.90624,0.296333,	2.466318,1.075572,0.274291,	2.43769,1.138488,0.360007,
	2.402929,1.214886,0.411437,	2.244947,1.06992,0.444499,	2.273018,0.98016,0.388937,
	2.273018,0.98016,0.388937,	2.43769,1.138488,0.360007,	2.402929,1.214886,0.411437,
	2.3651,1.298025,0.42858,	2.2144,1.1676,0.46302,	2.244947,1.06992,0.444499,
	2.244947,1.06992,0.444499,	2.402929,1.214886,0.411437,	2.3651,1.298025,0.42858,
	2.327271,1.381164,0.411437,	2.183853,1.26528,0.444499,	2.2144,1.1676,0.46302,
	2.2144,1.1676,0.46302,	2.3651,1.298025,0.42858,	2.327271,1.381164,0.411437,
	2.29251,1.457562,0.360007,	2.155782,1.35504,0.388937,	2.183853,1.26528,0.444499,
	2.183853,1.26528,0.444499,	2.327271,1.381164,0.411437,	2.29251,1.457562,0.360007,
	2.263882,1.520478,0.274291,	2.132666,1.42896,0.296333,	2.155782,1.35504,0.388937,
	2.155782,1.35504,0.388937,	2.29251,1.457562,0.360007,	2.263882,1.520478,0.274291,
	2.244457,1.563171,0.154289,	2.116979,1.47912,0.166687,	2.132666,1.42896,0.296333,
	2.132666,1.42896,0.296333,	2.263882,1.520478,0.274291,	2.244457,1.563171,0.154289,
	2.2373,1.5789,0,	2.1112,1.4976,0,	2.116979,1.47912,0.166687,
	2.116979,1.47912,0.166687,	2.244457,1.563171,0.154289,	2.2373,1.5789,0,
	2.60087,1.235652,0.139234,	2.485743,1.032879,0.154289,	2.4929,1.01715,0,
	2.4929,1.01715,0,	2.6088,1.2228,0,	2.60087,1.235652,0.139234,
	2.579347,1.270536,0.247526,	2.466318,1.075572,0.274291,	2.485743,1.032879,0.154289,
	2.485743,1.032879,0.154289,	2.60087,1.235652,0.139234,	2.579347,1.270536,0.247526,
	2.547629,1.321944,0.324878,	2.43769,1.138488,0.360007,	2.466318,1.075572,0.274291,
	2.466318,1.075572,0.274291,	2.579347,1.270536,0.247526,	2.547629,1.321944,0.324878,
	2.509114,1.384368,0.37129,	2.402929,1.214886,0.411437,	2.43769,1.138488,0.360007,
	2.43769,1.138488,0.360007,	2.547629,1.321944,0.324878,	2.509114,1.384368,0.37129,
	2.4672,1.4523,0.38676,	2.3651,1.298025,0.42858,	2.402929,1.214886,0.411437,
	2.402929,1.214886,0.411437,	2.509114,1.384368,0.37129,	2.4672,1.4523,0.38676,
	2.425286,1.520232,0.37129,	2.327271,1.381164,0.411437,	2.3651,1.298025,0.42858,
	2.3651,1.298025,0.42858,	2.4672,1.4523,0.38676,	2.425286,1.520232,0.37129,
	2.386771,1.582656,0.324878,	2.29251,1.457562,0.360007,	2.327271,1.381164,0.411437,
	2.327271,1.381164,0.411437,	2.425286,1.520232,0.37129,	2.386771,1.582656,0.324878,
	2.355053,1.634064,0.247526,	2.263882,1.520478,0.274291,	2.29251,1.457562,0.360007,
	2.29251,1.457562,0.360007,	2.386771,1.582656,0.324878,	2.355053,1.634064,0.247526,
	2.33353,1.668948,0.139234,	2.244457,1.563171,0.154289,	2.263882,1.520478,0.274291,
	2.263882,1.520478,0.274291,	2.355053,1.634064,0.247526,	2.33353,1.668948,0.139234,
	2.3256,1.6818,0,	2.2373,1.5789,0,	2.244457,1.563171,0.154289,
	2.244457,1.563171,0.154289,	2.33353,1.668948,0.139234,	2.3256,1.6818,0,
	2.6791,1.453725,0.12285,	2.60087,1.235652,0.139234,	2.6088,1.2228,0,
	2.6088,1.2228,0,	2.6875,1.44375,0,	2.6791,1.453725,0.12285,
	2.6563,1.4808,0.2184,	2.579347,1.270536,0.247526,	2.60087,1.235652,0.139234,
	2.60087,1.235652,0.139234,	2.6791,1.453725,0.12285,	2.6563,1.4808,0.2184,
	2.6227,1.5207,0.28665,	2.547629,1.321944,0.324878,	2.579347,1.270536,0.247526,
	2.579347,1.270536,0.247526,	2.6563,1.4808,0.2184,	2.6227,1.5207,0.28665,
	2.5819,1.56915,0.3276,	2.509114,1.384368,0.37129,	2.547629,1.321944,0.324878,
	2.547629,1.321944,0.324878,	2.6227,1.5207,0.28665,	2.5819,1.56915,0.3276,
	2.5375,1.621875,0.34125,	2.4672,1.4523,0.38676,	2.509114,1.384368,0.37129,
	2.509114,1.384368,0.37129,	2.5819,1.56915,0.3276,	2.5375,1.621875,0.34125,
	2.4931,1.6746,0.3276,	2.425286,1.520232,0.37129,	2.4672,1.4523,0.38676,
	2.4672,1.4523,0.38676,	2.5375,1.621875,0.34125,	2.4931,1.6746,0.3276,
	2.4523,1.72305,0.28665,	2.386771,1.582656,0.324878,	2.425286,1.520232,0.37129,
	2.425286,1.520232,0.37129,	2.4931,1.6746,0.3276,	2.4523,1.72305,0.28665,
	2.4187,1.76295,0.2184,	2.355053,1.634064,0.247526,	2.386771,1.582656,0.324878,
	2.386771,1.582656,0.324878,	2.4523,1.72305,0.28665,	2.4187,1.76295,0.2184,
	2.3959,1.790025,0.12285,	2.33353,1.668948,0.139234,	2.355053,1.634064,0.247526,
	2.355053,1.634064,0.247526,	2.4187,1.76295,0.2184,	2.3959,1.790025,0.12285,
	2.3875,1.8,0,	2.3256,1.6818,0,	2.33353,1.668948,0.139234,
	2.33353,1.668948,0.139234,	2.3959,1.790025,0.12285,	2.3875,1.8,0,
	2.74233,1.676424,0.106466,	2.6791,1.453725,0.12285,	2.6875,1.44375,0,
	2.6875,1.44375,0,	2.7512,1.6692,0,	2.74233,1.676424,0.106466,
	2.718253,1.696032,0.189274,	2.6563,1.4808,0.2184,	2.6791,1.453725,0.12285,
	2.6791,1.453725,0.12285,	2.74233,1.676424,0.106466,	2.718253,1.696032,0.189274,
	2.682771,1.724928,0.248422,	2.6227,1.5207,0.28665,	2.6563,1.4808,0.2184,
	2.6563,1.4808,0.2184,	2.718253,1.696032,0.189274,	2.682771,1.724928,0.248422,
	2.639686,1.760016,0.28391,	2.5819,1.56915,0.3276,	2.6227,1.5207,0.28665,
	2.6227,1.5207,0.28665,	2.682771,1.724928,0.248422,	2.639686,1.760016,0.28391,
	2.5928,1.7982,0.29574,	2.5375,1.621875,0.34125,	2.5819,1.56915,0.3276,
	2.5819,1.56915,0.3276,	2.639686,1.760016,0.28391,	2.5928,1.7982,0.29574,
	2.545914,1.836384,0.28391,	2.4931,1.6746,0.3276,	2.5375,1.621875,0.34125,
	2.5375,1.621875,0.34125,	2.5928,1.7982,0.29574,	2.545914,1.836384,0.28391,
	2.502829,1.871472,0.248422,	2.4523,1.72305,0.28665,	2.4931,1.6746,0.3276,
	2.4931,1.6746,0.3276,	2.545914,1.836384,0.28391,	2.502829,1.871472,0.248422,
	2.467347,1.900368,0.189274,	2.4187,1.76295,0.2184,	2.4523,1.72305,0.28665,
	2.4523,1.72305,0.28665,	2.502829,1.871472,0.248422,	2.467347,1.900368,0.189274,
	2.44327,1.919976,0.106466,	2.3959,1.790025,0.12285,	2.4187,1.76295,0.2184,
	2.4187,1.76295,0.2184,	2.467347,1.900368,0.189274,	2.44327,1.919976,0.106466,
	2.4344,1.9272,0,	2.3875,1.8,0,	2.3959,1.790025,0.12285,
	2.3959,1.790025,0.12285,	2.44327,1.919976,0.106466,	2.4344,1.9272,0,
	2.812457,1.893075,0.091411,	2.74233,1.676424,0.106466,	2.7512,1.6692,0,
	2.7512,1.6692,0,	2.8221,1.88835,0,	2.812457,1.893075,0.091411,
	2.786282,1.9059,0.162509,	2.718253,1.696032,0.189274,	2.74233,1.676424,0.106466,
	2.74233,1.676424,0.106466,	2.812457,1.893075,0.091411,	2.786282,1.9059,0.162509,
	2.74771,1.9248,0.213293,	2.682771,1.724928,0.248422,	2.718253,1.696032,0.189274,
	2.718253,1.696032,0.189274,	2.786282,1.9059,0.162509,	2.74771,1.9248,0.213293,
	2.700871,1.94775,0.243763,	2.639686,1.760016,0.28391,	2.682771,1.724928,0.248422,
	2.682771,1.724928,0.248422,	2.74771,1.9248,0.213293,	2.700871,1.94775,0.243763,
	2.6499,1.972725,0.25392,	2.5928,1.7982,0.29574,	2.639686,1.760016,0.28391,
	2.639686,1.760016,0.28391,	2.700871,1.94775,0.243763,	2.6499,1.972725,0.25392,
	2.598929,1.9977,0.243763,	2.545914,1.836384,0.28391,	2.5928,1.7982,0.29574,
	2.5928,1.7982,0.29574,	2.6499,1.972725,0.25392,	2.598929,1.9977,0.243763,
	2.55209,2.02065,0.213293,	2.502829,1.871472,0.248422,	2.545914,1.836384,0.28391,
	2.545914,1.836384,0.28391,	2.598929,1.9977,0.243763,	2.55209,2.02065,0.213293,
	2.513518,2.03955,0.162509,	2.467347,1.900368,0.189274,	2.502829,1.871472,0.248422,
	2.502829,1.871472,0.248422,	2.55209,2.02065,0.213293,	2.513518,2.03955,0.162509,
	2.487343,2.052375,0.091411,	2.44327,1.919976,0.106466,	2.467347,1.900368,0.189274,
	2.467347,1.900368,0.189274,	2.513518,2.03955,0.162509,	2.487343,2.052375,0.091411,
	2.4777,2.0571,0,	2.4344,1.9272,0,	2.44327,1.919976,0.106466,
	2.44327,1.919976,0.106466,	2.487343,2.052375,0.091411,	2.4777,2.0571,0,
	2.911379,2.093004,0.079013,	2.812457,1.893075,0.091411,	2.8221,1.88835,0,
	2.8221,1.88835,0,	2.9224,2.0904,0,	2.911379,2.093004,0.079013,
	2.881466,2.100072,0.140467,	2.786282,1.9059,0.162509,	2.812457,1.893075,0.091411,
	2.812457,1.893075,0.091411,	2.911379,2.093004,0.079013,	2.881466,2.100072,0.140467,
	2.837382,2.110488,0.184363,	2.74771,1.9248,0.213293,	2.786282,1.9059,0.162509,
	2.786282,1.9059,0.162509,	2.881466,2.100072,0.140467,	2.837382,2.110488,0.184363,
	2.783853,2.123136,0.210701,	2.700871,1.94775,0.243763,	2.74771,1.9248,0.213293,
	2.74771,1.9248,0.213293,	2.837382,2.110488,0.184363,	2.783853,2.123136,0.210701,
	2.7256,2.1369,0.21948,	2.6499,1.972725,0.25392,	2.700871,1.94775,0.243763,
	2.700871,1.94775,0.243763,	2.783853,2.123136,0.210701,	2.7256,2.1369,0.21948,
	2.667347,2.150664,0.210701,	2.598929,1.9977,0.243763,	2.6499,1.972725,0.25392,
	2.6499,1.972725,0.25392,	2.7256,2.1369,0.21948,	2.667347,2.150664,0.210701,
	2.613818,2.163312,0.184363,	2.55209,2.02065,0.213293,	2.598929,1.9977,0.243763,
	2.598929,1.9977,0.243763,	2.667347,2.150664,0.210701,	2.613818,2.163312,0.184363,
	2.569734,2.173728,0.140467,	2.513518,2.03955,0.162509,	2.55209,2.02065,0.213293,
	2.55209,2.02065,0.213293,	2.613818,2.163312,0.184363,	2.569734,2.173728,0.140467,
	2.539821,2.180796,0.079013,	2.487343,2.052375,0.091411,	2.513518,2.03955,0.162509,
	2.513518,2.03955,0.162509,	2.569734,2.173728,0.140467,	2.539821,2.180796,0.079013,
	2.5288,2.1834,0,	2.4777,2.0571,0,	2.487343,2.052375,0.091411,
	2.487343,2.052375,0.091411,	2.539821,2.180796,0.079013,	2.5288,2.1834,0,
	3.060994,2.265537,0.0706,	2.911379,2.093004,0.079013,	2.9224,2.0904,0,
	2.9224,2.0904,0,	3.0743,2.26455,0,	3.060994,2.265537,0.0706,
	3.024879,2.268216,0.12551,	2.881466,2.100072,0.140467,	2.911379,2.093004,0.079013,
	2.911379,2.093004,0.079013,	3.060994,2.265537,0.0706,	3.024879,2.268216,0.12551,
	2.971657,2.272164,0.164732,	2.837382,2.110488,0.184363,	2.881466,2.100072,0.140467,
	2.881466,2.100072,0.140467,	3.024879,2.268216,0.12551,	2.971657,2.272164,0.164732,
	2.90703,2.276958,0.188266,	2.783853,2.123136,0.210701,	2.837382,2.110488,0.184363,
	2.837382,2.110488,0.184363,	2.971657,2.272164,0.164732,	2.90703,2.276958,0.188266,
	2.8367,2.282175,0.19611,	2.7256,2.1369,0.21948,	2.783853,2.123136,0.210701,
	2.783853,2.123136,0.210701,	2.90703,2.276958,0.188266,	2.8367,2.282175,0.19611,
	2.76637,2.287392,0.188266,	2.667347,2.150664,0.210701,	2.7256,2.1369,0.21948,
	2.7256,2.1369,0.21948,	2.8367,2.282175,0.19611,	2.76637,2.287392,0.188266,
	2.701743,2.292186,0.164732,	2.613818,2.163312,0.184363,	2.667347,2.150664,0.210701,
	2.667347,2.150664,0.210701,	2.76637,2.287392,0.188266,	2.701743,2.292186,0.164732,
	2.648521,2.296134,0.12551,	2.569734,2.173728,0.140467,	2.613818,2.163312,0.184363,
	2.613818,2.163312,0.184363,	2.701743,2.292186,0.164732,	2.648521,2.296134,0.12551,
	2.612406,2.298813,0.0706,	2.539821,2.180796,0.079013,	2.569734,2.173728,0.140467,
	2.569734,2.173728,0.140467,	2.648521,2.296134,0.12551,	2.612406,2.298813,0.0706,
	2.5991,2.2998,0,	2.5288,2.1834,0,	2.539821,2.180796,0.079013,
	2.539821,2.180796,0.079013,	2.612406,2.298813,0.0706,	2.5991,2.2998,0,
	3.2832,2.4,0.0675,	3.060994,2.265537,0.0706,	3.0743,2.26455,0,
	3.0743,2.26455,0,	3.3,2.4,0,	3.2832,2.4,0.0675,
	3.2376,2.4,0.12,	3.024879,2.268216,0.12551,	3.060994,2.265537,0.0706,
	3.060994,2.265537,0.0706,	3.2832,2.4,0.0675,	3.2376,2.4,0.12,
	3.1704,2.4,0.1575,	2.971657,2.272164,0.164732,	3.024879,2.268216,0.12551,
	3.024879,2.268216,0.12551,	3.2376,2.4,0.12,	3.1704,2.4,0.1575,
	3.0888,2.4,0.18,	2.90703,2.276958,0.188266,	2.971657,2.272164,0.164732,
	2.971657,2.272164,0.164732,	3.1704,2.4,0.1575,	3.0888,2.4,0.18,
	3,2.4,0.1875,	2.8367,2.282175,0.19611,	2.90703,2.276958,0.188266,
	2.90703,2.276958,0.188266,	3.0888,2.4,0.18,	3,2.4,0.1875,
	2.9112,2.4,0.18,	2.76637,2.287392,0.188266,	2.8367,2.282175,0.19611,
	2.8367,2.282175,0.19611,	3,2.4,0.1875,	2.9112,2.4,0.18,
	2.8296,2.4,0.1575,	2.701743,2.292186,0.164732,	2.76637,2.287392,0.188266,
	2.76637,2.287392,0.188266,	2.9112,2.4,0.18,	2.8296,2.4,0.1575,
	2.7624,2.4,0.12,	2.648521,2.296134,0.12551,	2.701743,2.292186,0.164732,
	2.701743,2.292186,0.164732,	2.8296,2.4,0.1575,	2.7624,2.4,0.12,
	2.7168,2.4,0.0675,	2.612406,2.298813,0.0706,	2.648521,2.296134,0.12551,
	2.648521,2.296134,0.12551,	2.7624,2.4,0.12,	2.7168,2.4,0.0675,
	2.7,2.4,0,	2.5991,2.2998,0,	2.612406,2.298813,0.0706,
	2.612406,2.298813,0.0706,	2.7168,2.4,0.0675,	2.7,2.4,0,
	2.747407,2.420406,-0.066744,	2.7168,2.4,-0.0675,	2.7,2.4,0,
	2.7,2.4,0,	2.7298,2.42025,0,	2.747407,2.420406,-0.066744,
	2.795198,2.420829,-0.118656,	2.7624,2.4,-0.12,	2.7168,2.4,-0.0675,
	2.7168,2.4,-0.0675,	2.747407,2.420406,-0.066744,	2.795198,2.420829,-0.118656,
	2.865626,2.421453,-0.155736,	2.8296,2.4,-0.1575,	2.7624,2.4,-0.12,
	2.7624,2.4,-0.12,	2.795198,2.420829,-0.118656,	2.865626,2.421453,-0.155736,
	2.951146,2.42221,-0.177984,	2.9112,2.4,-0.18,	2.8296,2.4,-0.1575,
	2.8296,2.4,-0.1575,	2.865626,2.421453,-0.155736,	2.951146,2.42221,-0.177984,
	3.044212,2.423034,-0.1854,	3,2.4,-0.1875,	2.9112,2.4,-0.18,
	2.9112,2.4,-0.18,	2.951146,2.42221,-0.177984,	3.044212,2.423034,-0.1854,
	3.137279,2.423859,-0.177984,	3.0888,2.4,-0.18,	3,2.4,-0.1875,
	3,2.4,-0.1875,	3.044212,2.423034,-0.1854,	3.137279,2.423859,-0.177984,
	3.222799,2.424616,-0.155736,	3.1704,2.4,-0.1575,	3.0888,2.4,-0.18,
	3.0888,2.4,-0.18,	3.137279,2.423859,-0.177984,	3.222799,2.424616,-0.155736,
	3.293227,2.42524,-0.118656,	3.2376,2.4,-0.12,	3.1704,2.4,-0.1575,
	3.1704,2.4,-0.1575,	3.222799,2.424616,-0.155736,	3.293227,2.42524,-0.118656,
	3.341018,2.425663,-0.066744,	3.2832,2.4,-0.0675,	3.2376,2.4,-0.12,
	3.2376,2.4,-0.12,	3.293227,2.42524,-0.118656,	3.341018,2.425663,-0.066744,
	3.358625,2.425819,0,	3.3,2.4,0,	3.2832,2.4,-0.0675,
	3.2832,2.4,-0.0675,	3.341018,2.425663,-0.066744,	3.358625,2.425819,0,
	2.776365,2.436302,-0.064692,	2.747407,2.420406,-0.066744,	2.7298,2.42025,0,
	2.7298,2.42025,0,	2.7584,2.436,0,	2.776365,2.436302,-0.064692,
	2.825126,2.437123,-0.115008,	2.795198,2.420829,-0.118656,	2.747407,2.420406,-0.066744,
	2.747407,2.420406,-0.066744,	2.776365,2.436302,-0.064692,	2.825126,2.437123,-0.115008,
	2.896986,2.438333,-0.150948,	2.865626,2.421453,-0.155736,	2.795198,2.420829,-0.118656,
	2.795198,2.420829,-0.118656,	2.825126,2.437123,-0.115008,	2.896986,2.438333,-0.150948,
	2.984243,2.439802,-0.172512,	2.951146,2.42221,-0.177984,	2.865626,2.421453,-0.155736,
	2.865626,2.421453,-0.155736,	2.896986,2.438333,-0.150948,	2.984243,2.439802,-0.172512,
	3.0792,2.4414,-0.1797,	3.044212,2.423034,-0.1854,	2.951146,2.42221,-0.177984,
	2.951146,2.42221,-0.177984,	2.984243,2.439802,-0.172512,	3.0792,2.4414,-0.1797,
	3.174157,2.442998,-0.172512,	3.137279,2.423859,-0.177984,	3.044212,2.423034,-0.1854,
	3.044212,2.423034,-0.1854,	3.0792,2.4414,-0.1797,	3.174157,2.442998,-0.172512,
	3.261414,2.444467,-0.150948,	3.222799,2.424616,-0.155736,	3.137279,2.423859,-0.177984,
	3.137279,2.423859,-0.177984,	3.174157,2.442998,-0.172512,	3.261414,2.444467,-0.150948,
	3.333274,2.445677,-0.115008,	3.293227,2.42524,-0.118656,	3.222799,2.424616,-0.155736,
	3.222799,2.424616,-0.155736,	3.261414,2.444467,-0.150948,	3.333274,2.445677,-0.115008,
	3.382035,2.446498,-0.064692,	3.341018,2.425663,-0.066744,	3.293227,2.42524,-0.118656,
	3.293227,2.42524,-0.118656,	3.333274,2.445677,-0.115008,	3.382035,2.446498,-0.064692,
	3.4,2.4468,0,	3.358625,2.425819,0,	3.341018,2.425663,-0.066744,
	3.341018,2.425663,-0.066744,	3.382035,2.446498,-0.064692,	3.4,2.4468,0,
	2.802528,2.44768,-0.061668,	2.776365,2.436302,-0.064692,	2.7584,2.436,0,
	2.7584,2.436,0,	2.7846,2.44725,0,	2.802528,2.44768,-0.061668,
	2.851189,2.448847,-0.109632,	2.825126,2.437123,-0.115008,	2.776365,2.436302,-0.064692,
	2.776365,2.436302,-0.064692,	2.802528,2.44768,-0.061668,	2.851189,2.448847,-0.109632,
	2.922899,2.450567,-0.143892,	2.896986,2.438333,-0.150948,	2.825126,2.437123,-0.115008,
	2.825126,2.437123,-0.115008,	2.851189,2.448847,-0.109632,	2.922899,2.450567,-0.143892,
	3.009977,2.452655,-0.164448,	2.984243,2.439802,-0.172512,	2.896986,2.438333,-0.150948,
	2.896986,2.438333,-0.150948,	2.922899,2.450567,-0.143892,	3.009977,2.452655,-0.164448,
	3.104737,2.454928,-0.1713,	3.0792,2.4414,-0.1797,	2.984243,2.439802,-0.172512,
	2.984243,2.439802,-0.172512,	3.009977,2.452655,-0.164448,	3.104737,2.454928,-0.1713,
	3.199498,2.457201,-0.164448,	3.174157,2.442998,-0.172512,	3.0792,2.4414,-0.1797,
	3.0792,2.4414,-0.1797,	3.104737,2.454928,-0.1713,	3.199498,2.457201,-0.164448,
	3.286576,2.459289,-0.143892,	3.261414,2.444467,-0.150948,	3.174157,2.442998,-0.172512,
	3.174157,2.442998,-0.172512,	3.199498,2.457201,-0.164448,	3.286576,2.459289,-0.143892,
	3.358286,2.461009,-0.109632,	3.333274,2.445677,-0.115008,	3.261414,2.444467,-0.150948,
	3.261414,2.444467,-0.150948,	3.286576,2.459289,-0.143892,	3.358286,2.461009,-0.109632,
	3.406947,2.462176,-0.061668,	3.382035,2.446498,-0.064692,	3.333274,2.445677,-0.115008,
	3.333274,2.445677,-0.115008,	3.358286,2.461009,-0.109632,	3.406947,2.462176,-0.061668,
	3.424875,2.462606,0,	3.4,2.4468,0,	3.382035,2.446498,-0.064692,
	3.382035,2.446498,-0.064692,	3.406947,2.462176,-0.061668,	3.424875,2.462606,0,
	2.82475,2.454529,-0.057996,	2.802528,2.44768,-0.061668,	2.7846,2.44725,0,
	2.7846,2.44725,0,	2.8072,2.454,0,	2.82475,2.454529,-0.057996,
	2.872387,2.455966,-0.103104,	2.851189,2.448847,-0.109632,	2.802528,2.44768,-0.061668,
	2.802528,2.44768,-0.061668,	2.82475,2.454529,-0.057996,	2.872387,2.455966,-0.103104,
	2.942589,2.458082,-0.135324,	2.922899,2.450567,-0.143892,	2.851189,2.448847,-0.109632,
	2.851189,2.448847,-0.109632,	2.872387,2.455966,-0.103104,	2.942589,2.458082,-0.135324,
	3.027834,2.460653,-0.154656,	3.009977,2.452655,-0.164448,	2.922899,2.450567,-0.143892,
	2.922899,2.450567,-0.143892,	2.942589,2.458082,-0.135324,	3.027834,2.460653,-0.154656,
	3.1206,2.46345,-0.1611,	3.104737,2.454928,-0.1713,	3.009977,2.452655,-0.164448,
	3.009977,2.452655,-0.164448,	3.027834,2.460653,-0.154656,	3.1206,2.46345,-0.1611,
	3.213366,2.466247,-0.154656,	3.199498,2.457201,-0.164448,	3.104737,2.454928,-0.1713,
	3.104737,2.454928,-0.1713,	3.1206,2.46345,-0.1611,	3.213366,2.466247,-0.154656,
	3.298611,2.468818,-0.135324,	3.286576,2.459289,-0.143892,	3.199498,2.457201,-0.164448,
	3.199498,2.457201,-0.164448,	3.213366,2.466247,-0.154656,	3.298611,2.468818,-0.135324,
	3.368813,2.470934,-0.103104,	3.358286,2.461009,-0.109632,	3.286576,2.459289,-0.143892,
	3.286576,2.459289,-0.143892,	3.298611,2.468818,-0.135324,	3.368813,2.470934,-0.103104,
	3.41645,2.472371,-0.057996,	3.406947,2.462176,-0.061668,	3.358286,2.461009,-0.109632,
	3.358286,2.461009,-0.109632,	3.368813,2.470934,-0.103104,	3.41645,2.472371,-0.057996,
	3.434,2.4729,0,	3.424875,2.462606,0,	3.406947,2.462176,-0.061668,
	3.406947,2.462176,-0.061668,	3.41645,2.472371,-0.057996,	3.434,2.4729,0,
	2.841887,2.456841,-0.054,	2.82475,2.454529,-0.057996,	2.8072,2.454,0,
	2.8072,2.454,0,	2.825,2.45625,0,	2.841887,2.456841,-0.054,
	2.887725,2.458444,-0.096,	2.872387,2.455966,-0.103104,	2.82475,2.454529,-0.057996,
	2.82475,2.454529,-0.057996,	2.841887,2.456841,-0.054,	2.887725,2.458444,-0.096,
	2.955275,2.460806,-0.126,	2.942589,2.458082,-0.135324,	2.872387,2.455966,-0.103104,
	2.872387,2.455966,-0.103104,	2.887725,2.458444,-0.096,	2.955275,2.460806,-0.126,
	3.0373,2.463675,-0.144,	3.027834,2.460653,-0.154656,	2.942589,2.458082,-0.135324,
	2.942589,2.458082,-0.135324,	2.955275,2.460806,-0.126,	3.0373,2.463675,-0.144,
	3.126562,2.466797,-0.15,	3.1206,2.46345,-0.1611,	3.027834,2.460653,-0.154656,
	3.027834,2.460653,-0.154656,	3.0373,2.463675,-0.144,	3.126562,2.466797,-0.15,
	3.215825,2.469919,-0.144,	3.213366,2.466247,-0.154656,	3.1206,2.46345,-0.1611,
	3.1206,2.46345,-0.1611,	3.126562,2.466797,-0.15,	3.215825,2.469919,-0.144,
	3.29785,2.472787,-0.126,	3.298611,2.468818,-0.135324,	3.213366,2.466247,-0.154656,
	3.213366,2.466247,-0.154656,	3.215825,2.469919,-0.144,	3.29785,2.472787,-0.126,
	3.3654,2.47515,-0.096,	3.368813,2.470934,-0.103104,	3.298611,2.468818,-0.135324,
	3.298611,2.468818,-0.135324,	3.29785,2.472787,-0.126,	3.3654,2.47515,-0.096,
	3.411237,2.476753,-0.054,	3.41645,2.472371,-0.057996,	3.368813,2.470934,-0.103104,
	3.368813,2.470934,-0.103104,	3.3654,2.47515,-0.096,	3.411237,2.476753,-0.054,
	3.428125,2.477344,0,	3.434,2.4729,0,	3.41645,2.472371,-0.057996,
	3.41645,2.472371,-0.057996,	3.411237,2.476753,-0.054,	3.428125,2.477344,0,
	2.852794,2.454605,-0.050004,	2.841887,2.456841,-0.054,	2.825,2.45625,0,
	2.825,2.45625,0,	2.8368,2.454,0,	2.852794,2.454605,-0.050004,
	2.896205,2.456246,-0.088896,	2.887725,2.458444,-0.096,	2.841887,2.456841,-0.054,
	2.841887,2.456841,-0.054,	2.852794,2.454605,-0.050004,	2.896205,2.456246,-0.088896,
	2.960179,2.458666,-0.116676,	2.955275,2.460806,-0.126,	2.887725,2.458444,-0.096,
	2.887725,2.458444,-0.096,	2.896205,2.456246,-0.088896,	2.960179,2.458666,-0.116676,
	3.037862,2.461603,-0.133344,	3.0373,2.463675,-0.144,	2.955275,2.460806,-0.126,
	2.955275,2.460806,-0.126,	2.960179,2.458666,-0.116676,	3.037862,2.461603,-0.133344,
	3.1224,2.4648,-0.1389,	3.126562,2.466797,-0.15,	3.0373,2.463675,-0.144,
	3.0373,2.463675,-0.144,	3.037862,2.461603,-0.133344,	3.1224,2.4648,-0.1389,
	3.206938,2.467997,-0.133344,	3.215825,2.469919,-0.144,	3.126562,2.466797,-0.15,
	3.126562,2.466797,-0.15,	3.1224,2.4648,-0.1389,	3.206938,2.467997,-0.133344,
	3.284621,2.470934,-0.116676,	3.29785,2.472787,-0.126,	3.215825,2.469919,-0.144,
	3.215825,2.469919,-0.144,	3.206938,2.467997,-0.133344,	3.284621,2.470934,-0.116676,
	3.348595,2.473354,-0.088896,	3.3654,2.47515,-0.096,	3.29785,2.472787,-0.126,
	3.29785,2.472787,-0.126,	3.284621,2.470934,-0.116676,	3.348595,2.473354,-0.088896,
	3.392006,2.474995,-0.050004,	3.411237,2.476753,-0.054,	3.3654,2.47515,-0.096,
	3.3654,2.47515,-0.096,	3.348595,2.473354,-0.088896,	3.392006,2.474995,-0.050004,
	3.408,2.4756,0,	3.428125,2.477344,0,	3.411237,2.476753,-0.054,
	3.411237,2.476753,-0.054,	3.392006,2.474995,-0.050004,	3.408,2.4756,0,
	2.856323,2.447812,-0.046332,	2.852794,2.454605,-0.050004,	2.8368,2.454,0,
	2.8368,2.454,0,	2.8414,2.44725,0,	2.856323,2.447812,-0.046332,
	2.896829,2.449338,-0.082368,	2.896205,2.456246,-0.088896,	2.852794,2.454605,-0.050004,
	2.852794,2.454605,-0.050004,	2.856323,2.447812,-0.046332,	2.896829,2.449338,-0.082368,
	2.956523,2.451588,-0.108108,	2.960179,2.458666,-0.116676,	2.896205,2.456246,-0.088896,
	2.896205,2.456246,-0.088896,	2.896829,2.449338,-0.082368,	2.956523,2.451588,-0.108108,
	3.029007,2.454319,-0.123552,	3.037862,2.461603,-0.133344,	2.960179,2.458666,-0.116676,
	2.960179,2.458666,-0.116676,	2.956523,2.451588,-0.108108,	3.029007,2.454319,-0.123552,
	3.107887,2.457291,-0.1287,	3.1224,2.4648,-0.1389,	3.037862,2.461603,-0.133344,
	3.037862,2.461603,-0.133344,	3.029007,2.454319,-0.123552,	3.107887,2.457291,-0.1287,
	3.186768,2.460263,-0.123552,	3.206938,2.467997,-0.133344,	3.1224,2.4648,-0.1389,
	3.1224,2.4648,-0.1389,	3.107887,2.457291,-0.1287,	3.186768,2.460263,-0.123552,
	3.259252,2.462994,-0.108108,	3.284621,2.470934,-0.116676,	3.206938,2.467997,-0.133344,
	3.206938,2.467997,-0.133344,	3.186768,2.460263,-0.123552,	3.259252,2.462994,-0.108108,
	3.318946,2.465243,-0.082368,	3.348595,2.473354,-0.088896,	3.284621,2.470934,-0.116676,
	3.284621,2.470934,-0.116676,	3.259252,2.462994,-0.108108,	3.318946,2.465243,-0.082368,
	3.359452,2.466769,-0.046332,	3.392006,2.474995,-0.050004,	3.348595,2.473354,-0.088896,
	3.348595,2.473354,-0.088896,	3.318946,2.465243,-0.082368,	3.359452,2.466769,-0.046332,
	3.374375,2.467331,0,	3.408,2.4756,0,	3.392006,2.474995,-0.050004,
	3.392006,2.474995,-0.050004,	3.359452,2.466769,-0.046332,	3.374375,2.467331,0,
	2.851331,2.436454,-0.043308,	2.856323,2.447812,-0.046332,	2.8414,2.44725,0,
	2.8414,2.44725,0,	2.8376,2.436,0,	2.851331,2.436454,-0.043308,
	2.888602,2.437685,-0.076992,	2.896829,2.449338,-0.082368,	2.856323,2.447812,-0.046332,
	2.856323,2.447812,-0.046332,	2.851331,2.436454,-0.043308,	2.888602,2.437685,-0.076992,
	2.943526,2.439499,-0.101052,	2.956523,2.451588,-0.108108,	2.896829,2.449338,-0.082368,
	2.896829,2.449338,-0.082368,	2.888602,2.437685,-0.076992,	2.943526,2.439499,-0.101052,
	3.010221,2.441702,-0.115488,	3.029007,2.454319,-0.123552,	2.956523,2.451588,-0.108108,
	2.956523,2.451588,-0.108108,	2.943526,2.439499,-0.101052,	3.010221,2.441702,-0.115488,
	3.0828,2.4441,-0.1203,	3.107887,2.457291,-0.1287,	3.029007,2.454319,-0.123552,
	3.029007,2.454319,-0.123552,	3.010221,2.441702,-0.115488,	3.0828,2.4441,-0.1203,
	3.155379,2.446498,-0.115488,	3.186768,2.460263,-0.123552,	3.107887,2.457291,-0.1287,
	3.107887,2.457291,-0.1287,	3.0828,2.4441,-0.1203,	3.155379,2.446498,-0.115488,
	3.222074,2.448701,-0.101052,	3.259252,2.462994,-0.108108,	3.186768,2.460263,-0.123552,
	3.186768,2.460263,-0.123552,	3.155379,2.446498,-0.115488,	3.222074,2.448701,-0.101052,
	3.276998,2.450515,-0.076992,	3.318946,2.465243,-0.082368,	3.259252,2.462994,-0.108108,
	3.259252,2.462994,-0.108108,	3.222074,2.448701,-0.101052,	3.276998,2.450515,-0.076992,
	3.314269,2.451746,-0.043308,	3.359452,2.466769,-0.046332,	3.318946,2.465243,-0.082368,
	3.318946,2.465243,-0.082368,	3.276998,2.450515,-0.076992,	3.314269,2.451746,-0.043308,
	3.328,2.4522,0,	3.374375,2.467331,0,	3.359452,2.466769,-0.046332,
	3.359452,2.466769,-0.046332,	3.314269,2.451746,-0.043308,	3.328,2.4522,0,
	2.836672,2.420519,-0.041256,	2.851331,2.436454,-0.043308,	2.8376,2.436,0,
	2.8376,2.436,0,	2.8242,2.42025,0,	2.836672,2.420519,-0.041256,
	2.870524,2.42125,-0.073344,	2.888602,2.437685,-0.076992,	2.851331,2.436454,-0.043308,
	2.851331,2.436454,-0.043308,	2.836672,2.420519,-0.041256,	2.870524,2.42125,-0.073344,
	2.920412,2.422328,-0.096264,	2.943526,2.439499,-0.101052,	2.888602,2.437685,-0.076992,
	2.888602,2.437685,-0.076992,	2.870524,2.42125,-0.073344,	2.920412,2.422328,-0.096264,
	2.98099,2.423636,-0.110016,	3.010221,2.441702,-0.115488,	2.943526,2.439499,-0.101052,
	2.943526,2.439499,-0.101052,	2.920412,2.422328,-0.096264,	2.98099,2.423636,-0.110016,
	3.046912,2.425059,-0.1146,	3.0828,2.4441,-0.1203,	3.010221,2.441702,-0.115488,
	3.010221,2.441702,-0.115488,	2.98099,2.423636,-0.110016,	3.046912,2.425059,-0.1146,
	3.112835,2.426483,-0.110016,	3.155379,2.446498,-0.115488,	3.0828,2.4441,-0.1203,
	3.0828,2.4441,-0.1203,	3.046912,2.425059,-0.1146,	3.112835,2.426483,-0.110016,
	3.173413,2.427791,-0.096264,	3.222074,2.448701,-0.101052,	3.155379,2.446498,-0.115488,
	3.155379,2.446498,-0.115488,	3.112835,2.426483,-0.110016,	3.173413,2.427791,-0.096264,
	3.223301,2.428868,-0.073344,	3.276998,2.450515,-0.076992,	3.222074,2.448701,-0.101052,
	3.222074,2.448701,-0.101052,	3.173413,2.427791,-0.096264,	3.223301,2.428868,-0.073344,
	3.257153,2.429599,-0.041256,	3.314269,2.451746,-0.043308,	3.276998,2.450515,-0.076992,
	3.276998,2.450515,-0.076992,	3.223301,2.428868,-0.073344,	3.257153,2.429599,-0.041256,
	3.269625,2.429869,0,	3.328,2.4522,0,	3.314269,2.451746,-0.043308,
	3.314269,2.451746,-0.043308,	3.257153,2.429599,-0.041256,	3.269625,2.429869,0,
	2.8112,2.4,-0.0405,	2.836672,2.420519,-0.041256,	2.8242,2.42025,0,
	2.8242,2.42025,0,	2.8,2.4,0,	2.8112,2.4,-0.0405,
	2.8416,2.4,-0.072,	2.870524,2.42125,-0.073344,	2.836672,2.420519,-0.041256,
	2.836672,2.420519,-0.041256,	2.8112,2.4,-0.0405,	2.8416,2.4,-0.072,
	2.8864,2.4,-0.0945,	2.920412,2.422328,-0.096264,	2.870524,2.42125,-0.073344,
	2.870524,2.42125,-0.073344,	2.8416,2.4,-0.072,	2.8864,2.4,-0.0945,
	2.9408,2.4,-0.108,	2.98099,2.423636,-0.110016,	2.920412,2.422328,-0.096264,
	2.920412,2.422328,-0.096264,	2.8864,2.4,-0.0945,	2.9408,2.4,-0.108,
	3,2.4,-0.1125,	3.046912,2.425059,-0.1146,	2.98099,2.423636,-0.110016,
	2.98099,2.423636,-0.110016,	2.9408,2.4,-0.108,	3,2.4,-0.1125,
	3.0592,2.4,-0.108,	3.112835,2.426483,-0.110016,	3.046912,2.425059,-0.1146,
	3.046912,2.425059,-0.1146,	3,2.4,-0.1125,	3.0592,2.4,-0.108,
	3.1136,2.4,-0.0945,	3.173413,2.427791,-0.096264,	3.112835,2.426483,-0.110016,
	3.112835,2.426483,-0.110016,	3.0592,2.4,-0.108,	3.1136,2.4,-0.0945,
	3.1584,2.4,-0.072,	3.223301,2.428868,-0.073344,	3.173413,2.427791,-0.096264,
	3.173413,2.427791,-0.096264,	3.1136,2.4,-0.0945,	3.1584,2.4,-0.072,
	3.1888,2.4,-0.0405,	3.257153,2.429599,-0.041256,	3.223301,2.428868,-0.073344,
	3.223301,2.428868,-0.073344,	3.1584,2.4,-0.072,	3.1888,2.4,-0.0405,
	3.2,2.4,0,	3.269625,2.429869,0,	3.257153,2.429599,-0.041256,
	3.257153,2.429599,-0.041256,	3.1888,2.4,-0.0405,	3.2,2.4,0,
	3.341018,2.425663,0.066744,	3.2832,2.4,0.0675,	3.3,2.4,0,
	3.3,2.4,0,	3.358625,2.425819,0,	3.341018,2.425663,0.066744,
	3.293227,2.42524,0.118656,	3.2376,2.4,0.12,	3.2832,2.4,0.0675,
	3.2832,2.4,0.0675,	3.341018,2.425663,0.066744,	3.293227,2.42524,0.118656,
	3.222799,2.424616,0.155736,	3.1704,2.4,0.1575,	3.2376,2.4,0.12,
	3.2376,2.4,0.12,	3.293227,2.42524,0.118656,	3.222799,2.424616,0.155736,
	3.137279,2.423859,0.177984,	3.0888,2.4,0.18,	3.1704,2.4,0.1575,
	3.1704,2.4,0.1575,	3.222799,2.424616,0.155736,	3.137279,2.423859,0.177984,
	3.044212,2.423034,0.1854,	3,2.4,0.1875,	3.0888,2.4,0.18,
	3.0888,2.4,0.18,	3.137279,2.423859,0.177984,	3.044212,2.423034,0.1854,
	2.951146,2.42221,0.177984,	2.9112,2.4,0.18,	3,2.4,0.1875,
	3,2.4,0.1875,	3.044212,2.423034,0.1854,	2.951146,2.42221,0.177984,
	2.865626,2.421453,0.155736,	2.8296,2.4,0.1575,	2.9112,2.4,0.18,
	2.9112,2.4,0.18,	2.951146,2.42221,0.177984,	2.865626,2.421453,0.155736,
	2.795198,2.420829,0.118656,	2.7624,2.4,0.12,	2.8296,2.4,0.1575,
	2.8296,2.4,0.1575,	2.865626,2.421453,0.155736,	2.795198,2.420829,0.118656,
	2.747407,2.420406,0.066744,	2.7168,2.4,0.0675,	2.7624,2.4,0.12,
	2.7624,2.4,0.12,	2.795198,2.420829,0.118656,	2.747407,2.420406,0.066744,
	2.7298,2.42025,0,	2.7,2.4,0,	2.7168,2.4,0.0675,
	2.7168,2.4,0.0675,	2.747407,2.420406,0.066744,	2.7298,2.42025,0,
	3.382035,2.446498,0.064692,	3.341018,2.425663,0.066744,	3.358625,2.425819,0,
	3.358625,2.425819,0,	3.4,2.4468,0,	3.382035,2.446498,0.064692,
	3.333274,2.445677,0.115008,	3.293227,2.42524,0.118656,	3.341018,2.425663,0.066744,
	3.341018,2.425663,0.066744,	3.382035,2.446498,0.064692,	3.333274,2.445677,0.115008,
	3.261414,2.444467,0.150948,	3.222799,2.424616,0.155736,	3.293227,2.42524,0.118656,
	3.293227,2.42524,0.118656,	3.333274,2.445677,0.115008,	3.261414,2.444467,0.150948,
	3.174157,2.442998,0.172512,	3.137279,2.423859,0.177984,	3.222799,2.424616,0.155736,
	3.222799,2.424616,0.155736,	3.261414,2.444467,0.150948,	3.174157,2.442998,0.172512,
	3.0792,2.4414,0.1797,	3.044212,2.423034,0.1854,	3.137279,2.423859,0.177984,
	3.137279,2.423859,0.177984,	3.174157,2.442998,0.172512,	3.0792,2.4414,0.1797,
	2.984243,2.439802,0.172512,	2.951146,2.42221,0.177984,	3.044212,2.423034,0.1854,
	3.044212,2.423034,0.1854,	3.0792,2.4414,0.1797,	2.984243,2.439802,0.172512,
	2.896986,2.438333,0.150948,	2.865626,2.421453,0.155736,	2.951146,2.42221,0.177984,
	2.951146,2.42221,0.177984,	2.984243,2.439802,0.172512,	2.896986,2.438333,0.150948,
	2.825126,2.437123,0.115008,	2.795198,2.420829,0.118656,	2.865626,2.421453,0.155736,
	2.865626,2.421453,0.155736,	2.896986,2.438333,0.150948,	2.825126,2.437123,0.115008,
	2.776365,2.436302,0.064692,	2.747407,2.420406,0.066744,	2.795198,2.420829,0.118656,
	2.795198,2.420829,0.118656,	2.825126,2.437123,0.115008,	2.776365,2.436302,0.064692,
	2.7584,2.436,0,	2.7298,2.42025,0,	2.747407,2.420406,0.066744,
	2.747407,2.420406,0.066744,	2.776365,2.436302,0.064692,	2.7584,2.436,0,
	3.406947,2.462176,0.061668,	3.382035,2.446498,0.064692,	3.4,2.4468,0,
	3.4,2.4468,0,	3.424875,2.462606,0,	3.406947,2.462176,0.061668,
	3.358286,2.461009,0.109632,	3.333274,2.445677,0.115008,	3.382035,2.446498,0.064692,
	3.382035,2.446498,0.064692,	3.406947,2.462176,0.061668,	3.358286,2.461009,0.109632,
	3.286576,2.459289,0.143892,	3.261414,2.444467,0.150948,	3.333274,2.445677,0.115008,
	3.333274,2.445677,0.115008,	3.358286,2.461009,0.109632,	3.286576,2.459289,0.143892,
	3.199498,2.457201,0.164448,	3.174157,2.442998,0.172512,	3.261414,2.444467,0.150948,
	3.261414,2.444467,0.150948,	3.286576,2.459289,0.143892,	3.199498,2.457201,0.164448,
	3.104738,2.454928,0.1713,	3.0792,2.4414,0.1797,	3.174157,2.442998,0.172512,
	3.174157,2.442998,0.172512,	3.199498,2.457201,0.164448,	3.104738,2.454928,0.1713,
	3.009977,2.452655,0.164448,	2.984243,2.439802,0.172512,	3.0792,2.4414,0.1797,
	3.0792,2.4414,0.1797,	3.104738,2.454928,0.1713,	3.009977,2.452655,0.164448,
	2.922899,2.450567,0.143892,	2.896986,2.438333,0.150948,	2.984243,2.439802,0.172512,
	2.984243,2.439802,0.172512,	3.009977,2.452655,0.164448,	2.922899,2.450567,0.143892,
	2.851189,2.448847,0.109632,	2.825126,2.437123,0.115008,	2.896986,2.438333,0.150948,
	2.896986,2.438333,0.150948,	2.922899,2.450567,0.143892,	2.851189,2.448847,0.109632,
	2.802528,2.44768,0.061668,	2.776365,2.436302,0.064692,	2.825126,2.437123,0.115008,
	2.825126,2.437123,0.115008,	2.851189,2.448847,0.109632,	2.802528,2.44768,0.061668,
	2.7846,2.44725,0,	2.7584,2.436,0,	2.776365,2.436302,0.064692,
	2.776365,2.436302,0.064692,	2.802528,2.44768,0.061668,	2.7846,2.44725,0,
	3.41645,2.472371,0.057996,	3.406947,2.462176,0.061668,	3.424875,2.462606,0,
	3.424875,2.462606,0,	3.434,2.4729,0,	3.41645,2.472371,0.057996,
	3.368813,2.470934,0.103104,	3.358286,2.461009,0.109632,	3.406947,2.462176,0.061668,
	3.406947,2.462176,0.061668,	3.41645,2.472371,0.057996,	3.368813,2.470934,0.103104,
	3.298611,2.468818,0.135324,	3.286576,2.459289,0.143892,	3.358286,2.461009,0.109632,
	3.358286,2.461009,0.109632,	3.368813,2.470934,0.103104,	3.298611,2.468818,0.135324,
	3.213366,2.466247,0.154656,	3.199498,2.457201,0.164448,	3.286576,2.459289,0.143892,
	3.286576,2.459289,0.143892,	3.298611,2.468818,0.135324,	3.213366,2.466247,0.154656,
	3.1206,2.46345,0.1611,	3.104738,2.454928,0.1713,	3.199498,2.457201,0.164448,
	3.199498,2.457201,0.164448,	3.213366,2.466247,0.154656,	3.1206,2.46345,0.1611,
	3.027834,2.460653,0.154656,	3.009977,2.452655,0.164448,	3.104738,2.454928,0.1713,
	3.104738,2.454928,0.1713,	3.1206,2.46345,0.1611,	3.027834,2.460653,0.154656,
	2.942589,2.458082,0.135324,	2.922899,2.450567,0.143892,	3.009977,2.452655,0.164448,
	3.009977,2.452655,0.164448,	3.027834,2.460653,0.154656,	2.942589,2.458082,0.135324,
	2.872387,2.455966,0.103104,	2.851189,2.448847,0.109632,	2.922899,2.450567,0.143892,
	2.922899,2.450567,0.143892,	2.942589,2.458082,0.135324,	2.872387,2.455966,0.103104,
	2.82475,2.454529,0.057996,	2.802528,2.44768,0.061668,	2.851189,2.448847,0.109632,
	2.851189,2.448847,0.109632,	2.872387,2.455966,0.103104,	2.82475,2.454529,0.057996,
	2.8072,2.454,0,	2.7846,2.44725,0,	2.802528,2.44768,0.061668,
	2.802528,2.44768,0.061668,	2.82475,2.454529,0.057996,	2.8072,2.454,0,
	3.411237,2.476753,0.054,	3.41645,2.472371,0.057996,	3.434,2.4729,0,
	3.434,2.4729,0,	3.428125,2.477344,0,	3.411237,2.476753,0.054,
	3.3654,2.47515,0.096,	3.368813,2.470934,0.103104,	3.41645,2.472371,0.057996,
	3.41645,2.472371,0.057996,	3.411237,2.476753,0.054,	3.3654,2.47515,0.096,
	3.29785,2.472788,0.126,	3.298611,2.468818,0.135324,	3.368813,2.470934,0.103104,
	3.368813,2.470934,0.103104,	3.3654,2.47515,0.096,	3.29785,2.472788,0.126,
	3.215825,2.469919,0.144,	3.213366,2.466247,0.154656,	3.298611,2.468818,0.135324,
	3.298611,2.468818,0.135324,	3.29785,2.472788,0.126,	3.215825,2.469919,0.144,
	3.126562,2.466797,0.15,	3.1206,2.46345,0.1611,	3.213366,2.466247,0.154656,
	3.213366,2.466247,0.154656,	3.215825,2.469919,0.144,	3.126562,2.466797,0.15,
	3.0373,2.463675,0.144,	3.027834,2.460653,0.154656,	3.1206,2.46345,0.1611,
	3.1206,2.46345,0.1611,	3.126562,2.466797,0.15,	3.0373,2.463675,0.144,
	2.955275,2.460806,0.126,	2.942589,2.458082,0.135324,	3.027834,2.460653,0.154656,
	3.027834,2.460653,0.154656,	3.0373,2.463675,0.144,	2.955275,2.460806,0.126,
	2.887725,2.458444,0.096,	2.872387,2.455966,0.103104,	2.942589,2.458082,0.135324,
	2.942589,2.458082,0.135324,	2.955275,2.460806,0.126,	2.887725,2.458444,0.096,
	2.841887,2.456841,0.054,	2.82475,2.454529,0.057996,	2.872387,2.455966,0.103104,
	2.872387,2.455966,0.103104,	2.887725,2.458444,0.096,	2.841887,2.456841,0.054,
	2.825,2.45625,0,	2.8072,2.454,0,	2.82475,2.454529,0.057996,
	2.82475,2.454529,0.057996,	2.841887,2.456841,0.054,	2.825,2.45625,0,
	3.392006,2.474995,0.050004,	3.411237,2.476753,0.054,	3.428125,2.477344,0,
	3.428125,2.477344,0,	3.408,2.4756,0,	3.392006,2.474995,0.050004,
	3.348595,2.473354,0.088896,	3.3654,2.47515,0.096,	3.411237,2.476753,0.054,
	3.411237,2.476753,0.054,	3.392006,2.474995,0.050004,	3.348595,2.473354,0.088896,
	3.284621,2.470934,0.116676,	3.29785,2.472788,0.126,	3.3654,2.47515,0.096,
	3.3654,2.47515,0.096,	3.348595,2.473354,0.088896,	3.284621,2.470934,0.116676,
	3.206938,2.467997,0.133344,	3.215825,2.469919,0.144,	3.29785,2.472788,0.126,
	3.29785,2.472788,0.126,	3.284621,2.470934,0.116676,	3.206938,2.467997,0.133344,
	3.1224,2.4648,0.1389,	3.126562,2.466797,0.15,	3.215825,2.469919,0.144,
	3.215825,2.469919,0.144,	3.206938,2.467997,0.133344,	3.1224,2.4648,0.1389,
	3.037862,2.461603,0.133344,	3.0373,2.463675,0.144,	3.126562,2.466797,0.15,
	3.126562,2.466797,0.15,	3.1224,2.4648,0.1389,	3.037862,2.461603,0.133344,
	2.960179,2.458666,0.116676,	2.955275,2.460806,0.126,	3.0373,2.463675,0.144,
	3.0373,2.463675,0.144,	3.037862,2.461603,0.133344,	2.960179,2.458666,0.116676,
	2.896205,2.456246,0.088896,	2.887725,2.458444,0.096,	2.955275,2.460806,0.126,
	2.955275,2.460806,0.126,	2.960179,2.458666,0.116676,	2.896205,2.456246,0.088896,
	2.852794,2.454605,0.050004,	2.841887,2.456841,0.054,	2.887725,2.458444,0.096,
	2.887725,2.458444,0.096,	2.896205,2.456246,0.088896,	2.852794,2.454605,0.050004,
	2.8368,2.454,0,	2.825,2.45625,0,	2.841887,2.456841,0.054,
	2.841887,2.456841,0.054,	2.852794,2.454605,0.050004,	2.8368,2.454,0,
	3.359452,2.466769,0.046332,	3.392006,2.474995,0.050004,	3.408,2.4756,0,
	3.408,2.4756,0,	3.374375,2.467331,0,	3.359452,2.466769,0.046332,
	3.318946,2.465243,0.082368,	3.348595,2.473354,0.088896,	3.392006,2.474995,0.050004,
	3.392006,2.474995,0.050004,	3.359452,2.466769,0.046332,	3.318946,2.465243,0.082368,
	3.259252,2.462994,0.108108,	3.284621,2.470934,0.116676,	3.348595,2.473354,0.088896,
	3.348595,2.473354,0.088896,	3.318946,2.465243,0.082368,	3.259252,2.462994,0.108108,
	3.186768,2.460263,0.123552,	3.206938,2.467997,0.133344,	3.284621,2.470934,0.116676,
	3.284621,2.470934,0.116676,	3.259252,2.462994,0.108108,	3.186768,2.460263,0.123552,
	3.107887,2.457291,0.1287,	3.1224,2.4648,0.1389,	3.206938,2.467997,0.133344,
	3.206938,2.467997,0.133344,	3.186768,2.460263,0.123552,	3.107887,2.457291,0.1287,
	3.029007,2.454319,0.123552,	3.037862,2.461603,0.133344,	3.1224,2.4648,0.1389,
	3.1224,2.4648,0.1389,	3.107887,2.457291,0.1287,	3.029007,2.454319,0.123552,
	2.956523,2.451588,0.108108,	2.960179,2.458666,0.116676,	3.037862,2.461603,0.133344,
	3.037862,2.461603,0.133344,	3.029007,2.454319,0.123552,	2.956523,2.451588,0.108108,
	2.896829,2.449338,0.082368,	2.896205,2.456246,0.088896,	2.960179,2.458666,0.116676,
	2.960179,2.458666,0.116676,	2.956523,2.451588,0.108108,	2.896829,2.449338,0.082368,
	2.856323,2.447812,0.046332,	2.852794,2.454605,0.050004,	2.896205,2.456246,0.088896,
	2.896205,2.456246,0.088896,	2.896829,2.449338,0.082368,	2.856323,2.447812,0.046332,
	2.8414,2.44725,0,	2.8368,2.454,0,	2.852794,2.454605,0.050004,
	2.852794,2.454605,0.050004,	2.856323,2.447812,0.046332,	2.8414,2.44725,0,
	3.314269,2.451746,0.043308,	3.359452,2.466769,0.046332,	3.374375,2.467331,0,
	3.374375,2.467331,0,	3.328,2.4522,0,	3.314269,2.451746,0.043308,
	3.276998,2.450515,0.076992,	3.318946,2.465243,0.082368,	3.359452,2.466769,0.046332,
	3.359452,2.466769,0.046332,	3.314269,2.451746,0.043308,	3.276998,2.450515,0.076992,
	3.222074,2.448701,0.101052,	3.259252,2.462994,0.108108,	3.318946,2.465243,0.082368,
	3.318946,2.465243,0.082368,	3.276998,2.450515,0.076992,	3.222074,2.448701,0.101052,
	3.155379,2.446498,0.115488,	3.186768,2.460263,0.123552,	3.259252,2.462994,0.108108,
	3.259252,2.462994,0.108108,	3.222074,2.448701,0.101052,	3.155379,2.446498,0.115488,
	3.0828,2.4441,0.1203,	3.107887,2.457291,0.1287,	3.186768,2.460263,0.123552,
	3.186768,2.460263,0.123552,	3.155379,2.446498,0.115488,	3.0828,2.4441,0.1203,
	3.010221,2.441702,0.115488,	3.029007,2.454319,0.123552,	3.107887,2.457291,0.1287,
	3.107887,2.457291,0.1287,	3.0828,2.4441,0.1203,	3.010221,2.441702,0.115488,
	2.943526,2.439499,0.101052,	2.956523,2.451588,0.108108,	3.029007,2.454319,0.123552,
	3.029007,2.454319,0.123552,	3.010221,2.441702,0.115488,	2.943526,2.439499,0.101052,
	2.888602,2.437685,0.076992,	2.896829,2.449338,0.082368,	2.956523,2.451588,0.108108,
	2.956523,2.451588,0.108108,	2.943526,2.439499,0.101052,	2.888602,2.437685,0.076992,
	2.851331,2.436454,0.043308,	2.856323,2.447812,0.046332,	2.896829,2.449338,0.082368,
	2.896829,2.449338,0.082368,	2.888602,2.437685,0.076992,	2.851331,2.436454,0.043308,
	2.8376,2.436,0,	2.8414,2.44725,0,	2.856323,2.447812,0.046332,
	2.856323,2.447812,0.046332,	2.851331,2.436454,0.043308,	2.8376,2.436,0,
	3.257153,2.429599,0.041256,	3.314269,2.451746,0.043308,	3.328,2.4522,0,
	3.328,2.4522,0,	3.269625,2.429869,0,	3.257153,2.429599,0.041256,
	3.223301,2.428868,0.073344,	3.276998,2.450515,0.076992,	3.314269,2.451746,0.043308,
	3.314269,2.451746,0.043308,	3.257153,2.429599,0.041256,	3.223301,2.428868,0.073344,
	3.173413,2.427791,0.096264,	3.222074,2.448701,0.101052,	3.276998,2.450515,0.076992,
	3.276998,2.450515,0.076992,	3.223301,2.428868,0.073344,	3.173413,2.427791,0.096264,
	3.112835,2.426483,0.110016,	3.155379,2.446498,0.115488,	3.222074,2.448701,0.101052,
	3.222074,2.448701,0.101052,	3.173413,2.427791,0.096264,	3.112835,2.426483,0.110016,
	3.046912,2.425059,0.1146,	3.0828,2.4441,0.1203,	3.155379,2.446498,0.115488,
	3.155379,2.446498,0.115488,	3.112835,2.426483,0.110016,	3.046912,2.425059,0.1146,
	2.98099,2.423636,0.110016,	3.010221,2.441702,0.115488,	3.0828,2.4441,0.1203,
	3.0828,2.4441,0.1203,	3.046912,2.425059,0.1146,	2.98099,2.423636,0.110016,
	2.920412,2.422328,0.096264,	2.943526,2.439499,0.101052,	3.010221,2.441702,0.115488,
	3.010221,2.441702,0.115488,	2.98099,2.423636,0.110016,	2.920412,2.422328,0.096264,
	2.870524,2.42125,0.073344,	2.888602,2.437685,0.076992,	2.943526,2.439499,0.101052,
	2.943526,2.439499,0.101052,	2.920412,2.422328,0.096264,	2.870524,2.42125,0.073344,
	2.836672,2.420519,0.041256,	2.851331,2.436454,0.043308,	2.888602,2.437685,0.076992,
	2.888602,2.437685,0.076992,	2.870524,2.42125,0.073344,	2.836672,2.420519,0.041256,
	2.8242,2.42025,0,	2.8376,2.436,0,	2.851331,2.436454,0.043308,
	2.851331,2.436454,0.043308,	2.836672,2.420519,0.041256,	2.8242,2.42025,0,
	3.1888,2.4,0.0405,	3.257153,2.429599,0.041256,	3.269625,2.429869,0,
	3.269625,2.429869,0,	3.2,2.4,0,	3.1888,2.4,0.0405,
	3.1584,2.4,0.072,	3.223301,2.428868,0.073344,	3.257153,2.429599,0.041256,
	3.257153,2.429599,0.041256,	3.1888,2.4,0.0405,	3.1584,2.4,0.072,
	3.1136,2.4,0.0945,	3.173413,2.427791,0.096264,	3.223301,2.428868,0.073344,
	3.223301,2.428868,0.073344,	3.1584,2.4,0.072,	3.1136,2.4,0.0945,
	3.0592,2.4,0.108,	3.112835,2.426483,0.110016,	3.173413,2.427791,0.096264,
	3.173413,2.427791,0.096264,	3.1136,2.4,0.0945,	3.0592,2.4,0.108,
	3,2.4,0.1125,	3.046912,2.425059,0.1146,	3.112835,2.426483,0.110016,
	3.112835,2.426483,0.110016,	3.0592,2.4,0.108,	3,2.4,0.1125,
	2.9408,2.4,0.108,	2.98099,2.423636,0.110016,	3.046912,2.425059,0.1146,
	3.046912,2.425059,0.1146,	3,2.4,0.1125,	2.9408,2.4,0.108,
	2.8864,2.4,0.0945,	2.920412,2.422328,0.096264,	2.98099,2.423636,0.110016,
	2.98099,2.423636,0.110016,	2.9408,2.4,0.108,	2.8864,2.4,0.0945,
	2.8416,2.4,0.072,	2.870524,2.42125,0.073344,	2.920412,2.422328,0.096264,
	2.920412,2.422328,0.096264,	2.8864,2.4,0.0945,	2.8416,2.4,0.072,
	2.8112,2.4,0.0405,	2.836672,2.420519,0.041256,	2.870524,2.42125,0.073344,
	2.870524,2.42125,0.073344,	2.8416,2.4,0.072,	2.8112,2.4,0.0405,
	2.8,2.4,0,	2.8242,2.42025,0,	2.836672,2.420519,0.041256,
	2.836672,2.420519,0.041256,	2.8112,2.4,0.0405,	2.8,2.4,0,
	0,3.15,0,	0.1946,3.14145,0,	0.192107,3.14145,-0.032048,
	0,3.15,0,	0.192107,3.14145,-0.032048,	0.18487,3.14145,-0.062272,
	0,3.15,0,	0.18487,3.14145,-0.062272,	0.173255,3.14145,-0.090306,
	0,3.15,0,	0.173255,3.14145,-0.090306,	0.157626,3.14145,-0.115787,
	0,3.15,0,	0.157626,3.14145,-0.115787,	0.138348,3.14145,-0.138348,
	0,3.15,0,	0.138348,3.14145,-0.138348,	0.115787,3.14145,-0.157626,
	0,3.15,0,	0.115787,3.14145,-0.157626,	0.090306,3.14145,-0.173255,
	0,3.15,0,	0.090306,3.14145,-0.173255,	0.062272,3.14145,-0.18487,
	0,3.15,0,	0.062272,3.14145,-0.18487,	0.032048,3.14145,-0.192107,
	0,3.15,0,	0.032048,3.14145,-0.192107,	0,3.14145,-0.1946,
	0.304843,3.1176,-0.050855,	0.192107,3.14145,-0.032048,	0.1946,3.14145,0,
	0.1946,3.14145,0,	0.3088,3.1176,0,	0.304843,3.1176,-0.050855,
	0.29336,3.1176,-0.098814,	0.18487,3.14145,-0.062272,	0.192107,3.14145,-0.032048,
	0.192107,3.14145,-0.032048,	0.304843,3.1176,-0.050855,	0.29336,3.1176,-0.098814,
	0.274928,3.1176,-0.143301,	0.173255,3.14145,-0.090306,	0.18487,3.14145,-0.062272,
	0.18487,3.14145,-0.062272,	0.29336,3.1176,-0.098814,	0.274928,3.1176,-0.143301,
	0.250127,3.1176,-0.183734,	0.157626,3.14145,-0.115787,	0.173255,3.14145,-0.090306,
	0.173255,3.14145,-0.090306,	0.274928,3.1176,-0.143301,	0.250127,3.1176,-0.183734,
	0.219536,3.1176,-0.219536,	0.138348,3.14145,-0.138348,	0.157626,3.14145,-0.115787,
	0.157626,3.14145,-0.115787,	0.250127,3.1176,-0.183734,	0.219536,3.1176,-0.219536,
	0.183734,3.1176,-0.250127,	0.115787,3.14145,-0.157626,	0.138348,3.14145,-0.138348,
	0.138348,3.14145,-0.138348,	0.219536,3.1176,-0.219536,	0.183734,3.1176,-0.250127,
	0.143301,3.1176,-0.274928,	0.090306,3.14145,-0.173255,	0.115787,3.14145,-0.157626,
	0.115787,3.14145,-0.157626,	0.183734,3.1176,-0.250127,	0.143301,3.1176,-0.274928,
	0.098814,3.1176,-0.29336,	0.062272,3.14145,-0.18487,	0.090306,3.14145,-0.173255,
	0.090306,3.14145,-0.173255,	0.143301,3.1176,-0.274928,	0.098814,3.1176,-0.29336,
	0.050855,3.1176,-0.304843,	0.032048,3.14145,-0.192107,	0.062272,3.14145,-0.18487,
	0.062272,3.14145,-0.18487,	0.098814,3.1176,-0.29336,	0.050855,3.1176,-0.304843,
	0,3.1176,-0.3088,	0,3.14145,-0.1946,	0.032048,3.14145,-0.192107,
	0.032048,3.14145,-0.192107,	0.050855,3.1176,-0.304843,	0,3.1176,-0.3088,
	0.35361,3.08115,-0.058988,	0.304843,3.1176,-0.050855,	0.3088,3.1176,0,
	0.3088,3.1176,0,	0.3582,3.08115,0,	0.35361,3.08115,-0.058988,
	0.340289,3.08115,-0.114619,	0.29336,3.1176,-0.098814,	0.304843,3.1176,-0.050855,
	0.304843,3.1176,-0.050855,	0.35361,3.08115,-0.058988,	0.340289,3.08115,-0.114619,
	0.318907,3.08115,-0.166221,	0.274928,3.1176,-0.143301,	0.29336,3.1176,-0.098814,
	0.29336,3.1176,-0.098814,	0.340289,3.08115,-0.114619,	0.318907,3.08115,-0.166221,
	0.290138,3.08115,-0.213123,	0.250127,3.1176,-0.183734,	0.274928,3.1176,-0.143301,
	0.274928,3.1176,-0.143301,	0.318907,3.08115,-0.166221,	0.290138,3.08115,-0.213123,
	0.254653,3.08115,-0.254653,	0.219536,3.1176,-0.219536,	0.250127,3.1176,-0.183734,
	0.250127,3.1176,-0.183734,	0.290138,3.08115,-0.213123,	0.254653,3.08115,-0.254653,
	0.213123,3.08115,-0.290138,	0.183734,3.1176,-0.250127,	0.219536,3.1176,-0.219536,
	0.219536,3.1176,-0.219536,	0.254653,3.08115,-0.254653,	0.213123,3.08115,-0.290138,
	0.166221,3.08115,-0.318907,	0.143301,3.1176,-0.274928,	0.183734,3.1176,-0.250127,
	0.183734,3.1176,-0.250127,	0.213123,3.08115,-0.290138,	0.166221,3.08115,-0.318907,
	0.114619,3.08115,-0.340289,	0.098814,3.1176,-0.29336,	0.143301,3.1176,-0.274928,
	0.143301,3.1176,-0.274928,	0.166221,3.08115,-0.318907,	0.114619,3.08115,-0.340289,
	0.058988,3.08115,-0.35361,	0.050855,3.1176,-0.304843,	0.098814,3.1176,-0.29336,
	0.098814,3.1176,-0.29336,	0.114619,3.08115,-0.340289,	0.058988,3.08115,-0.35361,
	0,3.08115,-0.3582,	0,3.1176,-0.3088,	0.050855,3.1176,-0.304843,
	0.050855,3.1176,-0.304843,	0.058988,3.08115,-0.35361,	0,3.08115,-0.3582,
	0.353807,3.0348,-0.059016,	0.35361,3.08115,-0.058988,	0.3582,3.08115,0,
	0.3582,3.08115,0,	0.3584,3.0348,0,	0.353807,3.0348,-0.059016,
	0.340477,3.0348,-0.114676,	0.340289,3.08115,-0.114619,	0.35361,3.08115,-0.058988,
	0.35361,3.08115,-0.058988,	0.353807,3.0348,-0.059016,	0.340477,3.0348,-0.114676,
	0.319082,3.0348,-0.166306,	0.318907,3.08115,-0.166221,	0.340289,3.08115,-0.114619,
	0.340289,3.08115,-0.114619,	0.340477,3.0348,-0.114676,	0.319082,3.0348,-0.166306,
	0.290295,3.0348,-0.213234,	0.290138,3.08115,-0.213123,	0.318907,3.08115,-0.166221,
	0.318907,3.08115,-0.166221,	0.319082,3.0348,-0.166306,	0.290295,3.0348,-0.213234,
	0.254788,3.0348,-0.254788,	0.254653,3.08115,-0.254653,	0.290138,3.08115,-0.213123,
	0.290138,3.08115,-0.213123,	0.290295,3.0348,-0.213234,	0.254788,3.0348,-0.254788,
	0.213234,3.0348,-0.290295,	0.213123,3.08115,-0.290138,	0.254653,3.08115,-0.254653,
	0.254653,3.08115,-0.254653,	0.254788,3.0348,-0.254788,	0.213234,3.0348,-0.290295,
	0.166306,3.0348,-0.319082,	0.166221,3.08115,-0.318907,	0.213123,3.08115,-0.290138,
	0.213123,3.08115,-0.290138,	0.213234,3.0348,-0.290295,	0.166306,3.0348,-0.319082,
	0.114676,3.0348,-0.340477,	0.114619,3.08115,-0.340289,	0.166221,3.08115,-0.318907,
	0.166221,3.08115,-0.318907,	0.166306,3.0348,-0.319082,	0.114676,3.0348,-0.340477,
	0.059016,3.0348,-0.353807,	0.058988,3.08115,-0.35361,	0.114619,3.08115,-0.340289,
	0.114619,3.08115,-0.340289,	0.114676,3.0348,-0.340477,	0.059016,3.0348,-0.353807,
	0,3.0348,-0.3584,	0,3.08115,-0.3582,	0.058988,3.08115,-0.35361,
	0.058988,3.08115,-0.35361,	0.059016,3.0348,-0.353807,	0,3.0348,-0.3584,
	0.320834,2.98125,-0.053508,	0.353807,3.0348,-0.059016,	0.3584,3.0348,0,
	0.3584,3.0348,0,	0.325,2.98125,0,	0.320834,2.98125,-0.053508,
	0.308744,2.98125,-0.103976,	0.340477,3.0348,-0.114676,	0.353807,3.0348,-0.059016,
	0.353807,3.0348,-0.059016,	0.320834,2.98125,-0.053508,	0.308744,2.98125,-0.103976,
	0.28934,2.98125,-0.150793,	0.319082,3.0348,-0.166306,	0.340477,3.0348,-0.114676,
	0.340477,3.0348,-0.114676,	0.308744,2.98125,-0.103976,	0.28934,2.98125,-0.150793,
	0.263232,2.98125,-0.193348,	0.290295,3.0348,-0.213234,	0.319082,3.0348,-0.166306,
	0.319082,3.0348,-0.166306,	0.28934,2.98125,-0.150793,	0.263232,2.98125,-0.193348,
	0.231031,2.98125,-0.231031,	0.254788,3.0348,-0.254788,	0.290295,3.0348,-0.213234,
	0.290295,3.0348,-0.213234,	0.263232,2.98125,-0.193348,	0.231031,2.98125,-0.231031,
	0.193348,2.98125,-0.263232,	0.213234,3.0348,-0.290295,	0.254788,3.0348,-0.254788,
	0.254788,3.0348,-0.254788,	0.231031,2.98125,-0.231031,	0.193348,2.98125,-0.263232,
	0.150793,2.98125,-0.28934,	0.166306,3.0348,-0.319082,	0.213234,3.0348,-0.290295,
	0.213234,3.0348,-0.290295,	0.193348,2.98125,-0.263232,	0.150793,2.98125,-0.28934,
	0.103976,2.98125,-0.308744,	0.114676,3.0348,-0.340477,	0.166306,3.0348,-0.319082,
	0.166306,3.0348,-0.319082,	0.150793,2.98125,-0.28934,	0.103976,2.98125,-0.308744,
	0.053508,2.98125,-0.320834,	0.059016,3.0348,-0.353807,	0.114676,3.0348,-0.340477,
	0.114676,3.0348,-0.340477,	0.103976,2.98125,-0.308744,	0.053508,2.98125,-0.320834,
	0,2.98125,-0.325,	0,3.0348,-0.3584,	0.059016,3.0348,-0.353807,
	0.059016,3.0348,-0.353807,	0.053508,2.98125,-0.320834,	0,2.98125,-0.325,
	0.270092,2.9232,-0.045032,	0.320834,2.98125,-0.053508,	0.325,2.98125,0,
	0.325,2.98125,0,	0.2736,2.9232,0,	0.270092,2.9232,-0.045032,
	0.25991,2.9232,-0.087511,	0.308744,2.98125,-0.103976,	0.320834,2.98125,-0.053508,
	0.320834,2.98125,-0.053508,	0.270092,2.9232,-0.045032,	0.25991,2.9232,-0.087511,
	0.243569,2.9232,-0.12692,	0.28934,2.98125,-0.150793,	0.308744,2.98125,-0.103976,
	0.308744,2.98125,-0.103976,	0.25991,2.9232,-0.087511,	0.243569,2.9232,-0.12692,
	0.221585,2.9232,-0.162745,	0.263232,2.98125,-0.193348,	0.28934,2.98125,-0.150793,
	0.28934,2.98125,-0.150793,	0.243569,2.9232,-0.12692,	0.221585,2.9232,-0.162745,
	0.194472,2.9232,-0.194472,	0.231031,2.98125,-0.231031,	0.263232,2.98125,-0.193348,
	0.263232,2.98125,-0.193348,	0.221585,2.9232,-0.162745,	0.194472,2.9232,-0.194472,
	0.162745,2.9232,-0.221585,	0.193348,2.98125,-0.263232,	0.231031,2.98125,-0.231031,
	0.231031,2.98125,-0.231031,	0.194472,2.9232,-0.194472,	0.162745,2.9232,-0.221585,
	0.12692,2.9232,-0.243569,	0.150793,2.98125,-0.28934,	0.193348,2.98125,-0.263232,
	0.193348,2.98125,-0.263232,	0.162745,2.9232,-0.221585,	0.12692,2.9232,-0.243569,
	0.087511,2.9232,-0.25991,	0.103976,2.98125,-0.308744,	0.150793,2.98125,-0.28934,
	0.150793,2.98125,-0.28934,	0.12692,2.9232,-0.243569,	0.087511,2.9232,-0.25991,
	0.045032,2.9232,-0.270092,	0.053508,2.98125,-0.320834,	0.103976,2.98125,-0.308744,
	0.103976,2.98125,-0.308744,	0.087511,2.9232,-0.25991,	0.045032,2.9232,-0.270092,
	0,2.9232,-0.2736,	0,2.98125,-0.325,	0.053508,2.98125,-0.320834,
	0.053508,2.98125,-0.320834,	0.045032,2.9232,-0.270092,	0,2.9232,-0.2736,
	0.216979,2.86335,-0.036157,	0.270092,2.9232,-0.045032,	0.2736,2.9232,0,
	0.2736,2.9232,0,	0.2198,2.86335,0,	0.216979,2.86335,-0.036157,
	0.208794,2.86335,-0.07027,	0.25991,2.9232,-0.087511,	0.270092,2.9232,-0.045032,
	0.270092,2.9232,-0.045032,	0.216979,2.86335,-0.036157,	0.208794,2.86335,-0.07027,
	0.195658,2.86335,-0.101925,	0.243569,2.9232,-0.12692,	0.25991,2.9232,-0.087511,
	0.25991,2.9232,-0.087511,	0.208794,2.86335,-0.07027,	0.195658,2.86335,-0.101925,
	0.177989,2.86335,-0.130707,	0.221585,2.9232,-0.162745,	0.243569,2.9232,-0.12692,
	0.243569,2.9232,-0.12692,	0.195658,2.86335,-0.101925,	0.177989,2.86335,-0.130707,
	0.1562,2.86335,-0.1562,	0.194472,2.9232,-0.194472,	0.221585,2.9232,-0.162745,
	0.221585,2.9232,-0.162745,	0.177989,2.86335,-0.130707,	0.1562,2.86335,-0.1562,
	0.130707,2.86335,-0.177989,	0.162745,2.9232,-0.221585,	0.194472,2.9232,-0.194472,
	0.194472,2.9232,-0.194472,	0.1562,2.86335,-0.1562,	0.130707,2.86335,-0.177989,
	0.101925,2.86335,-0.195658,	0.12692,2.9232,-0.243569,	0.162745,2.9232,-0.221585,
	0.162745,2.9232,-0.221585,	0.130707,2.86335,-0.177989,	0.101925,2.86335,-0.195658,
	0.07027,2.86335,-0.208794,	0.087511,2.9232,-0.25991,	0.12692,2.9232,-0.243569,
	0.12692,2.9232,-0.243569,	0.101925,2.86335,-0.195658,	0.07027,2.86335,-0.208794,
	0.036157,2.86335,-0.216979,	0.045032,2.9232,-0.270092,	0.087511,2.9232,-0.25991,
	0.087511,2.9232,-0.25991,	0.07027,2.86335,-0.208794,	0.036157,2.86335,-0.216979,
	0,2.86335,-0.2198,	0,2.9232,-0.2736,	0.045032,2.9232,-0.270092,
	0.045032,2.9232,-0.270092,	0.036157,2.86335,-0.216979,	0,2.86335,-0.2198,
	0.176897,2.8044,-0.02945,	0.216979,2.86335,-0.036157,	0.2198,2.86335,0,
	0.2198,2.86335,0,	0.1792,2.8044,0,	0.176897,2.8044,-0.02945,
	0.170215,2.8044,-0.057246,	0.208794,2.86335,-0.07027,	0.216979,2.86335,-0.036157,
	0.216979,2.86335,-0.036157,	0.176897,2.8044,-0.02945,	0.170215,2.8044,-0.057246,
	0.159496,2.8044,-0.083047,	0.195658,2.86335,-0.101925,	0.208794,2.86335,-0.07027,
	0.208794,2.86335,-0.07027,	0.170215,2.8044,-0.057246,	0.159496,2.8044,-0.083047,
	0.145078,2.8044,-0.106513,	0.177989,2.86335,-0.130707,	0.195658,2.86335,-0.101925,
	0.195658,2.86335,-0.101925,	0.159496,2.8044,-0.083047,	0.145078,2.8044,-0.106513,
	0.127304,2.8044,-0.127304,	0.1562,2.86335,-0.1562,	0.177989,2.86335,-0.130707,
	0.177989,2.86335,-0.130707,	0.145078,2.8044,-0.106513,	0.127304,2.8044,-0.127304,
	0.106513,2.8044,-0.145078,	0.130707,2.86335,-0.177989,	0.1562,2.86335,-0.1562,
	0.1562,2.86335,-0.1562,	0.127304,2.8044,-0.127304,	0.106513,2.8044,-0.145078,
	0.083047,2.8044,-0.159496,	0.101925,2.86335,-0.195658,	0.130707,2.86335,-0.177989,
	0.130707,2.86335,-0.177989,	0.106513,2.8044,-0.145078,	0.083047,2.8044,-0.159496,
	0.057246,2.8044,-0.170215,	0.07027,2.86335,-0.208794,	0.101925,2.86335,-0.195658,
	0.101925,2.86335,-0.195658,	0.083047,2.8044,-0.159496,	0.057246,2.8044,-0.170215,
	0.02945,2.8044,-0.176897,	0.036157,2.86335,-0.216979,	0.07027,2.86335,-0.208794,
	0.07027,2.86335,-0.208794,	0.057246,2.8044,-0.170215,	0.02945,2.8044,-0.176897,
	0,2.8044,-0.1792,	0,2.86335,-0.2198,	0.036157,2.86335,-0.216979,
	0.036157,2.86335,-0.216979,	0.02945,2.8044,-0.176897,	0,2.8044,-0.1792,
	0.165245,2.74905,-0.02748,	0.176897,2.8044,-0.02945,	0.1792,2.8044,0,
	0.1792,2.8044,0,	0.1674,2.74905,0,	0.165245,2.74905,-0.02748,
	0.158995,2.74905,-0.053428,	0.170215,2.8044,-0.057246,	0.176897,2.8044,-0.02945,
	0.176897,2.8044,-0.02945,	0.165245,2.74905,-0.02748,	0.158995,2.74905,-0.053428,
	0.148969,2.74905,-0.077523,	0.159496,2.8044,-0.083047,	0.170215,2.8044,-0.057246,
	0.170215,2.8044,-0.057246,	0.158995,2.74905,-0.053428,	0.148969,2.74905,-0.077523,
	0.135489,2.74905,-0.099446,	0.145078,2.8044,-0.106513,	0.159496,2.8044,-0.083047,
	0.159496,2.8044,-0.083047,	0.148969,2.74905,-0.077523,	0.135489,2.74905,-0.099446,
	0.118874,2.74905,-0.118874,	0.127304,2.8044,-0.127304,	0.145078,2.8044,-0.106513,
	0.145078,2.8044,-0.106513,	0.135489,2.74905,-0.099446,	0.118874,2.74905,-0.118874,
	0.099446,2.74905,-0.135489,	0.106513,2.8044,-0.145078,	0.127304,2.8044,-0.127304,
	0.127304,2.8044,-0.127304,	0.118874,2.74905,-0.118874,	0.099446,2.74905,-0.135489,
	0.077523,2.74905,-0.148969,	0.083047,2.8044,-0.159496,	0.106513,2.8044,-0.145078,
	0.106513,2.8044,-0.145078,	0.099446,2.74905,-0.135489,	0.077523,2.74905,-0.148969,
	0.053428,2.74905,-0.158995,	0.057246,2.8044,-0.170215,	0.083047,2.8044,-0.159496,
	0.083047,2.8044,-0.159496,	0.077523,2.74905,-0.148969,	0.053428,2.74905,-0.158995,
	0.02748,2.74905,-0.165245,	0.02945,2.8044,-0.176897,	0.057246,2.8044,-0.170215,
	0.057246,2.8044,-0.170215,	0.053428,2.74905,-0.158995,	0.02748,2.74905,-0.165245,
	0,2.74905,-0.1674,	0,2.8044,-0.1792,	0.02945,2.8044,-0.176897,
	0.02945,2.8044,-0.176897,	0.02748,2.74905,-0.165245,	0,2.74905,-0.1674,
	0.197424,2.7,-0.032816,	0.165245,2.74905,-0.02748,	0.1674,2.74905,0,
	0.1674,2.74905,0,	0.2,2.7,0,	0.197424,2.7,-0.032816,
	0.189952,2.7,-0.063808,	0.158995,2.74905,-0.053428,	0.165245,2.74905,-0.02748,
	0.165245,2.74905,-0.02748,	0.197424,2.7,-0.032816,	0.189952,2.7,-0.063808,
	0.177968,2.7,-0.092592,	0.148969,2.74905,-0.077523,	0.158995,2.74905,-0.053428,
	0.158995,2.74905,-0.053428,	0.189952,2.7,-0.063808,	0.177968,2.7,-0.092592,
	0.161856,2.7,-0.118784,	0.135489,2.74905,-0.099446,	0.148969,2.74905,-0.077523,
	0.148969,2.74905,-0.077523,	0.177968,2.7,-0.092592,	0.161856,2.7,-0.118784,
	0.142,2.7,-0.142,	0.118874,2.74905,-0.118874,	0.135489,2.74905,-0.099446,
	0.135489,2.74905,-0.099446,	0.161856,2.7,-0.118784,	0.142,2.7,-0.142,
	0.118784,2.7,-0.161856,	0.099446,2.74905,-0.135489,	0.118874,2.74905,-0.118874,
	0.118874,2.74905,-0.118874,	0.142,2.7,-0.142,	0.118784,2.7,-0.161856,
	0.092592,2.7,-0.177968,	0.077523,2.74905,-0.148969,	0.099446,2.74905,-0.135489,
	0.099446,2.74905,-0.135489,	0.118784,2.7,-0.161856,	0.092592,2.7,-0.177968,
	0.063808,2.7,-0.189952,	0.053428,2.74905,-0.158995,	0.077523,2.74905,-0.148969,
	0.077523,2.74905,-0.148969,	0.092592,2.7,-0.177968,	0.063808,2.7,-0.189952,
	0.032816,2.7,-0.197424,	0.02748,2.74905,-0.165245,	0.053428,2.74905,-0.158995,
	0.053428,2.74905,-0.158995,	0.063808,2.7,-0.189952,	0.032816,2.7,-0.197424,
	0,2.7,-0.2,	0,2.74905,-0.1674,	0.02748,2.74905,-0.165245,
	0.02748,2.74905,-0.165245,	0.032816,2.7,-0.197424,	0,2.7,-0.2,
	0,3.15,0,	0,3.14145,-0.1946,	-0.032048,3.14145,-0.192107,
	0,3.15,0,	-0.032048,3.14145,-0.192107,	-0.062272,3.14145,-0.18487,
	0,3.15,0,	-0.062272,3.14145,-0.18487,	-0.090306,3.14145,-0.173255,
	0,3.15,0,	-0.090306,3.14145,-0.173255,	-0.115787,3.14145,-0.157626,
	0,3.15,0,	-0.115787,3.14145,-0.157626,	-0.138348,3.14145,-0.138348,
	0,3.15,0,	-0.138348,3.14145,-0.138348,	-0.157626,3.14145,-0.115787,
	0,3.15,0,	-0.157626,3.14145,-0.115787,	-0.173255,3.14145,-0.090306,
	0,3.15,0,	-0.173255,3.14145,-0.090306,	-0.18487,3.14145,-0.062272,
	0,3.15,0,	-0.18487,3.14145,-0.062272,	-0.192107,3.14145,-0.032048,
	0,3.15,0,	-0.192107,3.14145,-0.032048,	-0.1946,3.14145,0,
	-0.050855,3.1176,-0.304843,	-0.032048,3.14145,-0.192107,	0,3.14145,-0.1946,
	0,3.14145,-0.1946,	0,3.1176,-0.3088,	-0.050855,3.1176,-0.304843,
	-0.098814,3.1176,-0.29336,	-0.062272,3.14145,-0.18487,	-0.032048,3.14145,-0.192107,
	-0.032048,3.14145,-0.192107,	-0.050855,3.1176,-0.304843,	-0.098814,3.1176,-0.29336,
	-0.143301,3.1176,-0.274928,	-0.090306,3.14145,-0.173255,	-0.062272,3.14145,-0.18487,
	-0.062272,3.14145,-0.18487,	-0.098814,3.1176,-0.29336,	-0.143301,3.1176,-0.274928,
	-0.183734,3.1176,-0.250127,	-0.115787,3.14145,-0.157626,	-0.090306,3.14145,-0.173255,
	-0.090306,3.14145,-0.173255,	-0.143301,3.1176,-0.274928,	-0.183734,3.1176,-0.250127,
	-0.219536,3.1176,-0.219536,	-0.138348,3.14145,-0.138348,	-0.115787,3.14145,-0.157626,
	-0.115787,3.14145,-0.157626,	-0.183734,3.1176,-0.250127,	-0.219536,3.1176,-0.219536,
	-0.250127,3.1176,-0.183734,	-0.157626,3.14145,-0.115787,	-0.138348,3.14145,-0.138348,
	-0.138348,3.14145,-0.138348,	-0.219536,3.1176,-0.219536,	-0.250127,3.1176,-0.183734,
	-0.274928,3.1176,-0.143301,	-0.173255,3.14145,-0.090306,	-0.157626,3.14145,-0.115787,
	-0.157626,3.14145,-0.115787,	-0.250127,3.1176,-0.183734,	-0.274928,3.1176,-0.143301,
	-0.29336,3.1176,-0.098814,	-0.18487,3.14145,-0.062272,	-0.173255,3.14145,-0.090306,
	-0.173255,3.14145,-0.090306,	-0.274928,3.1176,-0.143301,	-0.29336,3.1176,-0.098814,
	-0.304843,3.1176,-0.050855,	-0.192107,3.14145,-0.032048,	-0.18487,3.14145,-0.062272,
	-0.18487,3.14145,-0.062272,	-0.29336,3.1176,-0.098814,	-0.304843,3.1176,-0.050855,
	-0.3088,3.1176,0,	-0.1946,3.14145,0,	-0.192107,3.14145,-0.032048,
	-0.192107,3.14145,-0.032048,	-0.304843,3.1176,-0.050855,	-0.3088,3.1176,0,
	-0.058988,3.08115,-0.35361,	-0.050855,3.1176,-0.304843,	0,3.1176,-0.3088,
	0,3.1176,-0.3088,	0,3.08115,-0.3582,	-0.058988,3.08115,-0.35361,
	-0.114619,3.08115,-0.340289,	-0.098814,3.1176,-0.29336,	-0.050855,3.1176,-0.304843,
	-0.050855,3.1176,-0.304843,	-0.058988,3.08115,-0.35361,	-0.114619,3.08115,-0.340289,
	-0.166221,3.08115,-0.318907,	-0.143301,3.1176,-0.274928,	-0.098814,3.1176,-0.29336,
	-0.098814,3.1176,-0.29336,	-0.114619,3.08115,-0.340289,	-0.166221,3.08115,-0.318907,
	-0.213123,3.08115,-0.290138,	-0.183734,3.1176,-0.250127,	-0.143301,3.1176,-0.274928,
	-0.143301,3.1176,-0.274928,	-0.166221,3.08115,-0.318907,	-0.213123,3.08115,-0.290138,
	-0.254653,3.08115,-0.254653,	-0.219536,3.1176,-0.219536,	-0.183734,3.1176,-0.250127,
	-0.183734,3.1176,-0.250127,	-0.213123,3.08115,-0.290138,	-0.254653,3.08115,-0.254653,
	-0.290138,3.08115,-0.213123,	-0.250127,3.1176,-0.183734,	-0.219536,3.1176,-0.219536,
	-0.219536,3.1176,-0.219536,	-0.254653,3.08115,-0.254653,	-0.290138,3.08115,-0.213123,
	-0.318907,3.08115,-0.166221,	-0.274928,3.1176,-0.143301,	-0.250127,3.1176,-0.183734,
	-0.250127,3.1176,-0.183734,	-0.290138,3.08115,-0.213123,	-0.318907,3.08115,-0.166221,
	-0.340289,3.08115,-0.114619,	-0.29336,3.1176,-0.098814,	-0.274928,3.1176,-0.143301,
	-0.274928,3.1176,-0.143301,	-0.318907,3.08115,-0.166221,	-0.340289,3.08115,-0.114619,
	-0.35361,3.08115,-0.058988,	-0.304843,3.1176,-0.050855,	-0.29336,3.1176,-0.098814,
	-0.29336,3.1176,-0.098814,	-0.340289,3.08115,-0.114619,	-0.35361,3.08115,-0.058988,
	-0.3582,3.08115,0,	-0.3088,3.1176,0,	-0.304843,3.1176,-0.050855,
	-0.304843,3.1176,-0.050855,	-0.35361,3.08115,-0.058988,	-0.3582,3.08115,0,
	-0.059016,3.0348,-0.353807,	-0.058988,3.08115,-0.35361,	0,3.08115,-0.3582,
	0,3.08115,-0.3582,	0,3.0348,-0.3584,	-0.059016,3.0348,-0.353807,
	-0.114676,3.0348,-0.340477,	-0.114619,3.08115,-0.340289,	-0.058988,3.08115,-0.35361,
	-0.058988,3.08115,-0.35361,	-0.059016,3.0348,-0.353807,	-0.114676,3.0348,-0.340477,
	-0.166306,3.0348,-0.319082,	-0.166221,3.08115,-0.318907,	-0.114619,3.08115,-0.340289,
	-0.114619,3.08115,-0.340289,	-0.114676,3.0348,-0.340477,	-0.166306,3.0348,-0.319082,
	-0.213234,3.0348,-0.290295,	-0.213123,3.08115,-0.290138,	-0.166221,3.08115,-0.318907,
	-0.166221,3.08115,-0.318907,	-0.166306,3.0348,-0.319082,	-0.213234,3.0348,-0.290295,
	-0.254788,3.0348,-0.254788,	-0.254653,3.08115,-0.254653,	-0.213123,3.08115,-0.290138,
	-0.213123,3.08115,-0.290138,	-0.213234,3.0348,-0.290295,	-0.254788,3.0348,-0.254788,
	-0.290295,3.0348,-0.213234,	-0.290138,3.08115,-0.213123,	-0.254653,3.08115,-0.254653,
	-0.254653,3.08115,-0.254653,	-0.254788,3.0348,-0.254788,	-0.290295,3.0348,-0.213234,
	-0.319082,3.0348,-0.166306,	-0.318907,3.08115,-0.166221,	-0.290138,3.08115,-0.213123,
	-0.290138,3.08115,-0.213123,	-0.290295,3.0348,-0.213234,	-0.319082,3.0348,-0.166306,
	-0.340477,3.0348,-0.114676,	-0.340289,3.08115,-0.114619,	-0.318907,3.08115,-0.166221,
	-0.318907,3.08115,-0.166221,	-0.319082,3.0348,-0.166306,	-0.340477,3.0348,-0.114676,
	-0.353807,3.0348,-0.059016,	-0.35361,3.08115,-0.058988,	-0.340289,3.08115,-0.114619,
	-0.340289,3.08115,-0.114619,	-0.340477,3.0348,-0.114676,	-0.353807,3.0348,-0.059016,
	-0.3584,3.0348,0,	-0.3582,3.08115,0,	-0.35361,3.08115,-0.058988,
	-0.35361,3.08115,-0.058988,	-0.353807,3.0348,-0.059016,	-0.3584,3.0348,0,
	-0.053508,2.98125,-0.320834,	-0.059016,3.0348,-0.353807,	0,3.0348,-0.3584,
	0,3.0348,-0.3584,	0,2.98125,-0.325,	-0.053508,2.98125,-0.320834,
	-0.103976,2.98125,-0.308744,	-0.114676,3.0348,-0.340477,	-0.059016,3.0348,-0.353807,
	-0.059016,3.0348,-0.353807,	-0.053508,2.98125,-0.320834,	-0.103976,2.98125,-0.308744,
	-0.150793,2.98125,-0.28934,	-0.166306,3.0348,-0.319082,	-0.114676,3.0348,-0.340477,
	-0.114676,3.0348,-0.340477,	-0.103976,2.98125,-0.308744,	-0.150793,2.98125,-0.28934,
	-0.193348,2.98125,-0.263232,	-0.213234,3.0348,-0.290295,	-0.166306,3.0348,-0.319082,
	-0.166306,3.0348,-0.319082,	-0.150793,2.98125,-0.28934,	-0.193348,2.98125,-0.263232,
	-0.231031,2.98125,-0.231031,	-0.254788,3.0348,-0.254788,	-0.213234,3.0348,-0.290295,
	-0.213234,3.0348,-0.290295,	-0.193348,2.98125,-0.263232,	-0.231031,2.98125,-0.231031,
	-0.263232,2.98125,-0.193348,	-0.290295,3.0348,-0.213234,	-0.254788,3.0348,-0.254788,
	-0.254788,3.0348,-0.254788,	-0.231031,2.98125,-0.231031,	-0.263232,2.98125,-0.193348,
	-0.28934,2.98125,-0.150793,	-0.319082,3.0348,-0.166306,	-0.290295,3.0348,-0.213234,
	-0.290295,3.0348,-0.213234,	-0.263232,2.98125,-0.193348,	-0.28934,2.98125,-0.150793,
	-0.308744,2.98125,-0.103976,	-0.340477,3.0348,-0.114676,	-0.319082,3.0348,-0.166306,
	-0.319082,3.0348,-0.166306,	-0.28934,2.98125,-0.150793,	-0.308744,2.98125,-0.103976,
	-0.320834,2.98125,-0.053508,	-0.353807,3.0348,-0.059016,	-0.340477,3.0348,-0.114676,
	-0.340477,3.0348,-0.114676,	-0.308744,2.98125,-0.103976,	-0.320834,2.98125,-0.053508,
	-0.325,2.98125,0,	-0.3584,3.0348,0,	-0.353807,3.0348,-0.059016,
	-0.353807,3.0348,-0.059016,	-0.320834,2.98125,-0.053508,	-0.325,2.98125,0,
	-0.045032,2.9232,-0.270092,	-0.053508,2.98125,-0.320834,	0,2.98125,-0.325,
	0,2.98125,-0.325,	0,2.9232,-0.2736,	-0.045032,2.9232,-0.270092,
	-0.087511,2.9232,-0.25991,	-0.103976,2.98125,-0.308744,	-0.053508,2.98125,-0.320834,
	-0.053508,2.98125,-0.320834,	-0.045032,2.9232,-0.270092,	-0.087511,2.9232,-0.25991,
	-0.12692,2.9232,-0.243569,	-0.150793,2.98125,-0.28934,	-0.103976,2.98125,-0.308744,
	-0.103976,2.98125,-0.308744,	-0.087511,2.9232,-0.25991,	-0.12692,2.9232,-0.243569,
	-0.162745,2.9232,-0.221585,	-0.193348,2.98125,-0.263232,	-0.150793,2.98125,-0.28934,
	-0.150793,2.98125,-0.28934,	-0.12692,2.9232,-0.243569,	-0.162745,2.9232,-0.221585,
	-0.194472,2.9232,-0.194472,	-0.231031,2.98125,-0.231031,	-0.193348,2.98125,-0.263232,
	-0.193348,2.98125,-0.263232,	-0.162745,2.9232,-0.221585,	-0.194472,2.9232,-0.194472,
	-0.221585,2.9232,-0.162745,	-0.263232,2.98125,-0.193348,	-0.231031,2.98125,-0.231031,
	-0.231031,2.98125,-0.231031,	-0.194472,2.9232,-0.194472,	-0.221585,2.9232,-0.162745,
	-0.243569,2.9232,-0.12692,	-0.28934,2.98125,-0.150793,	-0.263232,2.98125,-0.193348,
	-0.263232,2.98125,-0.193348,	-0.221585,2.9232,-0.162745,	-0.243569,2.9232,-0.12692,
	-0.25991,2.9232,-0.087511,	-0.308744,2.98125,-0.103976,	-0.28934,2.98125,-0.150793,
	-0.28934,2.98125,-0.150793,	-0.243569,2.9232,-0.12692,	-0.25991,2.9232,-0.087511,
	-0.270092,2.9232,-0.045032,	-0.320834,2.98125,-0.053508,	-0.308744,2.98125,-0.103976,
	-0.308744,2.98125,-0.103976,	-0.25991,2.9232,-0.087511,	-0.270092,2.9232,-0.045032,
	-0.2736,2.9232,0,	-0.325,2.98125,0,	-0.320834,2.98125,-0.053508,
	-0.320834,2.98125,-0.053508,	-0.270092,2.9232,-0.045032,	-0.2736,2.9232,0,
	-0.036157,2.86335,-0.216979,	-0.045032,2.9232,-0.270092,	0,2.9232,-0.2736,
	0,2.9232,-0.2736,	0,2.86335,-0.2198,	-0.036157,2.86335,-0.216979,
	-0.07027,2.86335,-0.208794,	-0.087511,2.9232,-0.25991,	-0.045032,2.9232,-0.270092,
	-0.045032,2.9232,-0.270092,	-0.036157,2.86335,-0.216979,	-0.07027,2.86335,-0.208794,
	-0.101925,2.86335,-0.195658,	-0.12692,2.9232,-0.243569,	-0.087511,2.9232,-0.25991,
	-0.087511,2.9232,-0.25991,	-0.07027,2.86335,-0.208794,	-0.101925,2.86335,-0.195658,
	-0.130707,2.86335,-0.177989,	-0.162745,2.9232,-0.221585,	-0.12692,2.9232,-0.243569,
	-0.12692,2.9232,-0.243569,	-0.101925,2.86335,-0.195658,	-0.130707,2.86335,-0.177989,
	-0.1562,2.86335,-0.1562,	-0.194472,2.9232,-0.194472,	-0.162745,2.9232,-0.221585,
	-0.162745,2.9232,-0.221585,	-0.130707,2.86335,-0.177989,	-0.1562,2.86335,-0.1562,
	-0.177989,2.86335,-0.130707,	-0.221585,2.9232,-0.162745,	-0.194472,2.9232,-0.194472,
	-0.194472,2.9232,-0.194472,	-0.1562,2.86335,-0.1562,	-0.177989,2.86335,-0.130707,
	-0.195658,2.86335,-0.101925,	-0.243569,2.9232,-0.12692,	-0.221585,2.9232,-0.162745,
	-0.221585,2.9232,-0.162745,	-0.177989,2.86335,-0.130707,	-0.195658,2.86335,-0.101925,
	-0.208794,2.86335,-0.07027,	-0.25991,2.9232,-0.087511,	-0.243569,2.9232,-0.12692,
	-0.243569,2.9232,-0.12692,	-0.195658,2.86335,-0.101925,	-0.208794,2.86335,-0.07027,
	-0.216979,2.86335,-0.036157,	-0.270092,2.9232,-0.045032,	-0.25991,2.9232,-0.087511,
	-0.25991,2.9232,-0.087511,	-0.208794,2.86335,-0.07027,	-0.216979,2.86335,-0.036157,
	-0.2198,2.86335,0,	-0.2736,2.9232,0,	-0.270092,2.9232,-0.045032,
	-0.270092,2.9232,-0.045032,	-0.216979,2.86335,-0.036157,	-0.2198,2.86335,0,
	-0.02945,2.8044,-0.176897,	-0.036157,2.86335,-0.216979,	0,2.86335,-0.2198,
	0,2.86335,-0.2198,	0,2.8044,-0.1792,	-0.02945,2.8044,-0.176897,
	-0.057246,2.8044,-0.170215,	-0.07027,2.86335,-0.208794,	-0.036157,2.86335,-0.216979,
	-0.036157,2.86335,-0.216979,	-0.02945,2.8044,-0.176897,	-0.057246,2.8044,-0.170215,
	-0.083047,2.8044,-0.159496,	-0.101925,2.86335,-0.195658,	-0.07027,2.86335,-0.208794,
	-0.07027,2.86335,-0.208794,	-0.057246,2.8044,-0.170215,	-0.083047,2.8044,-0.159496,
	-0.106513,2.8044,-0.145078,	-0.130707,2.86335,-0.177989,	-0.101925,2.86335,-0.195658,
	-0.101925,2.86335,-0.195658,	-0.083047,2.8044,-0.159496,	-0.106513,2.8044,-0.145078,
	-0.127304,2.8044,-0.127304,	-0.1562,2.86335,-0.1562,	-0.130707,2.86335,-0.177989,
	-0.130707,2.86335,-0.177989,	-0.106513,2.8044,-0.145078,	-0.127304,2.8044,-0.127304,
	-0.145078,2.8044,-0.106513,	-0.177989,2.86335,-0.130707,	-0.1562,2.86335,-0.1562,
	-0.1562,2.86335,-0.1562,	-0.127304,2.8044,-0.127304,	-0.145078,2.8044,-0.106513,
	-0.159496,2.8044,-0.083047,	-0.195658,2.86335,-0.101925,	-0.177989,2.86335,-0.130707,
	-0.177989,2.86335,-0.130707,	-0.145078,2.8044,-0.106513,	-0.159496,2.8044,-0.083047,
	-0.170215,2.8044,-0.057246,	-0.208794,2.86335,-0.07027,	-0.195658,2.86335,-0.101925,
	-0.195658,2.86335,-0.101925,	-0.159496,2.8044,-0.083047,	-0.170215,2.8044,-0.057246,
	-0.176897,2.8044,-0.02945,	-0.216979,2.86335,-0.036157,	-0.208794,2.86335,-0.07027,
	-0.208794,2.86335,-0.07027,	-0.170215,2.8044,-0.057246,	-0.176897,2.8044,-0.02945,
	-0.1792,2.8044,0,	-0.2198,2.86335,0,	-0.216979,2.86335,-0.036157,
	-0.216979,2.86335,-0.036157,	-0.176897,2.8044,-0.02945,	-0.1792,2.8044,0,
	-0.02748,2.74905,-0.165245,	-0.02945,2.8044,-0.176897,	0,2.8044,-0.1792,
	0,2.8044,-0.1792,	0,2.74905,-0.1674,	-0.02748,2.74905,-0.165245,
	-0.053428,2.74905,-0.158995,	-0.057246,2.8044,-0.170215,	-0.02945,2.8044,-0.176897,
	-0.02945,2.8044,-0.176897,	-0.02748,2.74905,-0.165245,	-0.053428,2.74905,-0.158995,
	-0.077523,2.74905,-0.148969,	-0.083047,2.8044,-0.159496,	-0.057246,2.8044,-0.170215,
	-0.057246,2.8044,-0.170215,	-0.053428,2.74905,-0.158995,	-0.077523,2.74905,-0.148969,
	-0.099446,2.74905,-0.135489,	-0.106513,2.8044,-0.145078,	-0.083047,2.8044,-0.159496,
	-0.083047,2.8044,-0.159496,	-0.077523,2.74905,-0.148969,	-0.099446,2.74905,-0.135489,
	-0.118874,2.74905,-0.118874,	-0.127304,2.8044,-0.127304,	-0.106513,2.8044,-0.145078,
	-0.106513,2.8044,-0.145078,	-0.099446,2.74905,-0.135489,	-0.118874,2.74905,-0.118874,
	-0.135489,2.74905,-0.099446,	-0.145078,2.8044,-0.106513,	-0.127304,2.8044,-0.127304,
	-0.127304,2.8044,-0.127304,	-0.118874,2.74905,-0.118874,	-0.135489,2.74905,-0.099446,
	-0.148969,2.74905,-0.077523,	-0.159496,2.8044,-0.083047,	-0.145078,2.8044,-0.106513,
	-0.145078,2.8044,-0.106513,	-0.135489,2.74905,-0.099446,	-0.148969,2.74905,-0.077523,
	-0.158995,2.74905,-0.053428,	-0.170215,2.8044,-0.057246,	-0.159496,2.8044,-0.083047,
	-0.159496,2.8044,-0.083047,	-0.148969,2.74905,-0.077523,	-0.158995,2.74905,-0.053428,
	-0.165245,2.74905,-0.02748,	-0.176897,2.8044,-0.02945,	-0.170215,2.8044,-0.057246,
	-0.170215,2.8044,-0.057246,	-0.158995,2.74905,-0.053428,	-0.165245,2.74905,-0.02748,
	-0.1674,2.74905,0,	-0.1792,2.8044,0,	-0.176897,2.8044,-0.02945,
	-0.176897,2.8044,-0.02945,	-0.165245,2.74905,-0.02748,	-0.1674,2.74905,0,
	-0.032816,2.7,-0.197424,	-0.02748,2.74905,-0.165245,	0,2.74905,-0.1674,
	0,2.74905,-0.1674,	0,2.7,-0.2,	-0.032816,2.7,-0.197424,
	-0.063808,2.7,-0.189952,	-0.053428,2.74905,-0.158995,	-0.02748,2.74905,-0.165245,
	-0.02748,2.74905,-0.165245,	-0.032816,2.7,-0.197424,	-0.063808,2.7,-0.189952,
	-0.092592,2.7,-0.177968,	-0.077523,2.74905,-0.148969,	-0.053428,2.74905,-0.158995,
	-0.053428,2.74905,-0.158995,	-0.063808,2.7,-0.189952,	-0.092592,2.7,-0.177968,
	-0.118784,2.7,-0.161856,	-0.099446,2.74905,-0.135489,	-0.077523,2.74905,-0.148969,
	-0.077523,2.74905,-0.148969,	-0.092592,2.7,-0.177968,	-0.118784,2.7,-0.161856,
	-0.142,2.7,-0.142,	-0.118874,2.74905,-0.118874,	-0.099446,2.74905,-0.135489,
	-0.099446,2.74905,-0.135489,	-0.118784,2.7,-0.161856,	-0.142,2.7,-0.142,
	-0.161856,2.7,-0.118784,	-0.135489,2.74905,-0.099446,	-0.118874,2.74905,-0.118874,
	-0.118874,2.74905,-0.118874,	-0.142,2.7,-0.142,	-0.161856,2.7,-0.118784,
	-0.177968,2.7,-0.092592,	-0.148969,2.74905,-0.077523,	-0.135489,2.74905,-0.099446,
	-0.135489,2.74905,-0.099446,	-0.161856,2.7,-0.118784,	-0.177968,2.7,-0.092592,
	-0.189952,2.7,-0.063808,	-0.158995,2.74905,-0.053428,	-0.148969,2.74905,-0.077523,
	-0.148969,2.74905,-0.077523,	-0.177968,2.7,-0.092592,	-0.189952,2.7,-0.063808,
	-0.197424,2.7,-0.032816,	-0.165245,2.74905,-0.02748,	-0.158995,2.74905,-0.053428,
	-0.158995,2.74905,-0.053428,	-0.189952,2.7,-0.063808,	-0.197424,2.7,-0.032816,
	-0.2,2.7,0,	-0.1674,2.74905,0,	-0.165245,2.74905,-0.02748,
	-0.165245,2.74905,-0.02748,	-0.197424,2.7,-0.032816,	-0.2,2.7,0,
	0,3.15,0,	-0.1946,3.14145,0,	-0.192107,3.14145,0.032048,
	0,3.15,0,	-0.192107,3.14145,0.032048,	-0.18487,3.14145,0.062272,
	0,3.15,0,	-0.18487,3.14145,0.062272,	-0.173255,3.14145,0.090306,
	0,3.15,0,	-0.173255,3.14145,0.090306,	-0.157626,3.14145,0.115787,
	0,3.15,0,	-0.157626,3.14145,0.115787,	-0.138348,3.14145,0.138348,
	0,3.15,0,	-0.138348,3.14145,0.138348,	-0.115787,3.14145,0.157626,
	0,3.15,0,	-0.115787,3.14145,0.157626,	-0.090306,3.14145,0.173255,
	0,3.15,0,	-0.090306,3.14145,0.173255,	-0.062272,3.14145,0.18487,
	0,3.15,0,	-0.062272,3.14145,0.18487,	-0.032048,3.14145,0.192107,
	0,3.15,0,	-0.032048,3.14145,0.192107,	0,3.14145,0.1946,
	-0.304843,3.1176,0.050855,	-0.192107,3.14145,0.032048,	-0.1946,3.14145,0,
	-0.1946,3.14145,0,	-0.3088,3.1176,0,	-0.304843,3.1176,0.050855,
	-0.29336,3.1176,0.098814,	-0.18487,3.14145,0.062272,	-0.192107,3.14145,0.032048,
	-0.192107,3.14145,0.032048,	-0.304843,3.1176,0.050855,	-0.29336,3.1176,0.098814,
	-0.274928,3.1176,0.143301,	-0.173255,3.14145,0.090306,	-0.18487,3.14145,0.062272,
	-0.18487,3.14145,0.062272,	-0.29336,3.1176,0.098814,	-0.274928,3.1176,0.143301,
	-0.250127,3.1176,0.183734,	-0.157626,3.14145,0.115787,	-0.173255,3.14145,0.090306,
	-0.173255,3.14145,0.090306,	-0.274928,3.1176,0.143301,	-0.250127,3.1176,0.183734,
	-0.219536,3.1176,0.219536,	-0.138348,3.14145,0.138348,	-0.157626,3.14145,0.115787,
	-0.157626,3.14145,0.115787,	-0.250127,3.1176,0.183734,	-0.219536,3.1176,0.219536,
	-0.183734,3.1176,0.250127,	-0.115787,3.14145,0.157626,	-0.138348,3.14145,0.138348,
	-0.138348,3.14145,0.138348,	-0.219536,3.1176,0.219536,	-0.183734,3.1176,0.250127,
	-0.143301,3.1176,0.274928,	-0.090306,3.14145,0.173255,	-0.115787,3.14145,0.157626,
	-0.115787,3.14145,0.157626,	-0.183734,3.1176,0.250127,	-0.143301,3.1176,0.274928,
	-0.098814,3.1176,0.29336,	-0.062272,3.14145,0.18487,	-0.090306,3.14145,0.173255,
	-0.090306,3.14145,0.173255,	-0.143301,3.1176,0.274928,	-0.098814,3.1176,0.29336,
	-0.050855,3.1176,0.304843,	-0.032048,3.14145,0.192107,	-0.062272,3.14145,0.18487,
	-0.062272,3.14145,0.18487,	-0.098814,3.1176,0.29336,	-0.050855,3.1176,0.304843,
	0,3.1176,0.3088,	0,3.14145,0.1946,	-0.032048,3.14145,0.192107,
	-0.032048,3.14145,0.192107,	-0.050855,3.1176,0.304843,	0,3.1176,0.3088,
	-0.35361,3.08115,0.058988,	-0.304843,3.1176,0.050855,	-0.3088,3.1176,0,
	-0.3088,3.1176,0,	-0.3582,3.08115,0,	-0.35361,3.08115,0.058988,
	-0.340289,3.08115,0.114619,	-0.29336,3.1176,0.098814,	-0.304843,3.1176,0.050855,
	-0.304843,3.1176,0.050855,	-0.35361,3.08115,0.058988,	-0.340289,3.08115,0.114619,
	-0.318907,3.08115,0.166221,	-0.274928,3.1176,0.143301,	-0.29336,3.1176,0.098814,
	-0.29336,3.1176,0.098814,	-0.340289,3.08115,0.114619,	-0.318907,3.08115,0.166221,
	-0.290138,3.08115,0.213123,	-0.250127,3.1176,0.183734,	-0.274928,3.1176,0.143301,
	-0.274928,3.1176,0.143301,	-0.318907,3.08115,0.166221,	-0.290138,3.08115,0.213123,
	-0.254653,3.08115,0.254653,	-0.219536,3.1176,0.219536,	-0.250127,3.1176,0.183734,
	-0.250127,3.1176,0.183734,	-0.290138,3.08115,0.213123,	-0.254653,3.08115,0.254653,
	-0.213123,3.08115,0.290138,	-0.183734,3.1176,0.250127,	-0.219536,3.1176,0.219536,
	-0.219536,3.1176,0.219536,	-0.254653,3.08115,0.254653,	-0.213123,3.08115,0.290138,
	-0.166221,3.08115,0.318907,	-0.143301,3.1176,0.274928,	-0.183734,3.1176,0.250127,
	-0.183734,3.1176,0.250127,	-0.213123,3.08115,0.290138,	-0.166221,3.08115,0.318907,
	-0.114619,3.08115,0.340289,	-0.098814,3.1176,0.29336,	-0.143301,3.1176,0.274928,
	-0.143301,3.1176,0.274928,	-0.166221,3.08115,0.318907,	-0.114619,3.08115,0.340289,
	-0.058988,3.08115,0.35361,	-0.050855,3.1176,0.304843,	-0.098814,3.1176,0.29336,
	-0.098814,3.1176,0.29336,	-0.114619,3.08115,0.340289,	-0.058988,3.08115,0.35361,
	0,3.08115,0.3582,	0,3.1176,0.3088,	-0.050855,3.1176,0.304843,
	-0.050855,3.1176,0.304843,	-0.058988,3.08115,0.35361,	0,3.08115,0.3582,
	-0.353807,3.0348,0.059016,	-0.35361,3.08115,0.058988,	-0.3582,3.08115,0,
	-0.3582,3.08115,0,	-0.3584,3.0348,0,	-0.353807,3.0348,0.059016,
	-0.340477,3.0348,0.114676,	-0.340289,3.08115,0.114619,	-0.35361,3.08115,0.058988,
	-0.35361,3.08115,0.058988,	-0.353807,3.0348,0.059016,	-0.340477,3.0348,0.114676,
	-0.319082,3.0348,0.166306,	-0.318907,3.08115,0.166221,	-0.340289,3.08115,0.114619,
	-0.340289,3.08115,0.114619,	-0.340477,3.0348,0.114676,	-0.319082,3.0348,0.166306,
	-0.290295,3.0348,0.213234,	-0.290138,3.08115,0.213123,	-0.318907,3.08115,0.166221,
	-0.318907,3.08115,0.166221,	-0.319082,3.0348,0.166306,	-0.290295,3.0348,0.213234,
	-0.254788,3.0348,0.254788,	-0.254653,3.08115,0.254653,	-0.290138,3.08115,0.213123,
	-0.290138,3.08115,0.213123,	-0.290295,3.0348,0.213234,	-0.254788,3.0348,0.254788,
	-0.213234,3.0348,0.290295,	-0.213123,3.08115,0.290138,	-0.254653,3.08115,0.254653,
	-0.254653,3.08115,0.254653,	-0.254788,3.0348,0.254788,	-0.213234,3.0348,0.290295,
	-0.166306,3.0348,0.319082,	-0.166221,3.08115,0.318907,	-0.213123,3.08115,0.290138,
	-0.213123,3.08115,0.290138,	-0.213234,3.0348,0.290295,	-0.166306,3.0348,0.319082,
	-0.114676,3.0348,0.340477,	-0.114619,3.08115,0.340289,	-0.166221,3.08115,0.318907,
	-0.166221,3.08115,0.318907,	-0.166306,3.0348,0.319082,	-0.114676,3.0348,0.340477,
	-0.059016,3.0348,0.353807,	-0.058988,3.08115,0.35361,	-0.114619,3.08115,0.340289,
	-0.114619,3.08115,0.340289,	-0.114676,3.0348,0.340477,	-0.059016,3.0348,0.353807,
	0,3.0348,0.3584,	0,3.08115,0.3582,	-0.058988,3.08115,0.35361,
	-0.058988,3.08115,0.35361,	-0.059016,3.0348,0.353807,	0,3.0348,0.3584,
	-0.320834,2.98125,0.053508,	-0.353807,3.0348,0.059016,	-0.3584,3.0348,0,
	-0.3584,3.0348,0,	-0.325,2.98125,0,	-0.320834,2.98125,0.053508,
	-0.308744,2.98125,0.103976,	-0.340477,3.0348,0.114676,	-0.353807,3.0348,0.059016,
	-0.353807,3.0348,0.059016,	-0.320834,2.98125,0.053508,	-0.308744,2.98125,0.103976,
	-0.28934,2.98125,0.150793,	-0.319082,3.0348,0.166306,	-0.340477,3.0348,0.114676,
	-0.340477,3.0348,0.114676,	-0.308744,2.98125,0.103976,	-0.28934,2.98125,0.150793,
	-0.263232,2.98125,0.193348,	-0.290295,3.0348,0.213234,	-0.319082,3.0348,0.166306,
	-0.319082,3.0348,0.166306,	-0.28934,2.98125,0.150793,	-0.263232,2.98125,0.193348,
	-0.231031,2.98125,0.231031,	-0.254788,3.0348,0.254788,	-0.290295,3.0348,0.213234,
	-0.290295,3.0348,0.213234,	-0.263232,2.98125,0.193348,	-0.231031,2.98125,0.231031,
	-0.193348,2.98125,0.263232,	-0.213234,3.0348,0.290295,	-0.254788,3.0348,0.254788,
	-0.254788,3.0348,0.254788,	-0.231031,2.98125,0.231031,	-0.193348,2.98125,0.263232,
	-0.150793,2.98125,0.28934,	-0.166306,3.0348,0.319082,	-0.213234,3.0348,0.290295,
	-0.213234,3.0348,0.290295,	-0.193348,2.98125,0.263232,	-0.150793,2.98125,0.28934,
	-0.103976,2.98125,0.308744,	-0.114676,3.0348,0.340477,	-0.166306,3.0348,0.319082,
	-0.166306,3.0348,0.319082,	-0.150793,2.98125,0.28934,	-0.103976,2.98125,0.308744,
	-0.053508,2.98125,0.320834,	-0.059016,3.0348,0.353807,	-0.114676,3.0348,0.340477,
	-0.114676,3.0348,0.340477,	-0.103976,2.98125,0.308744,	-0.053508,2.98125,0.320834,
	0,2.98125,0.325,	0,3.0348,0.3584,	-0.059016,3.0348,0.353807,
	-0.059016,3.0348,0.353807,	-0.053508,2.98125,0.320834,	0,2.98125,0.325,
	-0.270092,2.9232,0.045032,	-0.320834,2.98125,0.053508,	-0.325,2.98125,0,
	-0.325,2.98125,0,	-0.2736,2.9232,0,	-0.270092,2.9232,0.045032,
	-0.25991,2.9232,0.087511,	-0.308744,2.98125,0.103976,	-0.320834,2.98125,0.053508,
	-0.320834,2.98125,0.053508,	-0.270092,2.9232,0.045032,	-0.25991,2.9232,0.087511,
	-0.243569,2.9232,0.12692,	-0.28934,2.98125,0.150793,	-0.308744,2.98125,0.103976,
	-0.308744,2.98125,0.103976,	-0.25991,2.9232,0.087511,	-0.243569,2.9232,0.12692,
	-0.221585,2.9232,0.162745,	-0.263232,2.98125,0.193348,	-0.28934,2.98125,0.150793,
	-0.28934,2.98125,0.150793,	-0.243569,2.9232,0.12692,	-0.221585,2.9232,0.162745,
	-0.194472,2.9232,0.194472,	-0.231031,2.98125,0.231031,	-0.263232,2.98125,0.193348,
	-0.263232,2.98125,0.193348,	-0.221585,2.9232,0.162745,	-0.194472,2.9232,0.194472,
	-0.162745,2.9232,0.221585,	-0.193348,2.98125,0.263232,	-0.231031,2.98125,0.231031,
	-0.231031,2.98125,0.231031,	-0.194472,2.9232,0.194472,	-0.162745,2.9232,0.221585,
	-0.12692,2.9232,0.243569,	-0.150793,2.98125,0.28934,	-0.193348,2.98125,0.263232,
	-0.193348,2.98125,0.263232,	-0.162745,2.9232,0.221585,	-0.12692,2.9232,0.243569,
	-0.087511,2.9232,0.25991,	-0.103976,2.98125,0.308744,	-0.150793,2.98125,0.28934,
	-0.150793,2.98125,0.28934,	-0.12692,2.9232,0.243569,	-0.087511,2.9232,0.25991,
	-0.045032,2.9232,0.270092,	-0.053508,2.98125,0.320834,	-0.103976,2.98125,0.308744,
	-0.103976,2.98125,0.308744,	-0.087511,2.9232,0.25991,	-0.045032,2.9232,0.270092,
	0,2.9232,0.2736,	0,2.98125,0.325,	-0.053508,2.98125,0.320834,
	-0.053508,2.98125,0.320834,	-0.045032,2.9232,0.270092,	0,2.9232,0.2736,
	-0.216979,2.86335,0.036157,	-0.270092,2.9232,0.045032,	-0.2736,2.9232,0,
	-0.2736,2.9232,0,	-0.2198,2.86335,0,	-0.216979,2.86335,0.036157,
	-0.208794,2.86335,0.07027,	-0.25991,2.9232,0.087511,	-0.270092,2.9232,0.045032,
	-0.270092,2.9232,0.045032,	-0.216979,2.86335,0.036157,	-0.208794,2.86335,0.07027,
	-0.195658,2.86335,0.101925,	-0.243569,2.9232,0.12692,	-0.25991,2.9232,0.087511,
	-0.25991,2.9232,0.087511,	-0.208794,2.86335,0.07027,	-0.195658,2.86335,0.101925,
	-0.177989,2.86335,0.130707,	-0.221585,2.9232,0.162745,	-0.243569,2.9232,0.12692,
	-0.243569,2.9232,0.12692,	-0.195658,2.86335,0.101925,	-0.177989,2.86335,0.130707,
	-0.1562,2.86335,0.1562,	-0.194472,2.9232,0.194472,	-0.221585,2.9232,0.162745,
	-0.221585,2.9232,0.162745,	-0.177989,2.86335,0.130707,	-0.1562,2.86335,0.1562,
	-0.130707,2.86335,0.177989,	-0.162745,2.9232,0.221585,	-0.194472,2.9232,0.194472,
	-0.194472,2.9232,0.194472,	-0.1562,2.86335,0.1562,	-0.130707,2.86335,0.177989,
	-0.101925,2.86335,0.195658,	-0.12692,2.9232,0.243569,	-0.162745,2.9232,0.221585,
	-0.162745,2.9232,0.221585,	-0.130707,2.86335,0.177989,	-0.101925,2.86335,0.195658,
	-0.07027,2.86335,0.208794,	-0.087511,2.9232,0.25991,	-0.12692,2.9232,0.243569,
	-0.12692,2.9232,0.243569,	-0.101925,2.86335,0.195658,	-0.07027,2.86335,0.208794,
	-0.036157,2.86335,0.216979,	-0.045032,2.9232,0.270092,	-0.087511,2.9232,0.25991,
	-0.087511,2.9232,0.25991,	-0.07027,2.86335,0.208794,	-0.036157,2.86335,0.216979,
	0,2.86335,0.2198,	0,2.9232,0.2736,	-0.045032,2.9232,0.270092,
	-0.045032,2.9232,0.270092,	-0.036157,2.86335,0.216979,	0,2.86335,0.2198,
	-0.176897,2.8044,0.02945,	-0.216979,2.86335,0.036157,	-0.2198,2.86335,0,
	-0.2198,2.86335,0,	-0.1792,2.8044,0,	-0.176897,2.8044,0.02945,
	-0.170215,2.8044,0.057246,	-0.208794,2.86335,0.07027,	-0.216979,2.86335,0.036157,
	-0.216979,2.86335,0.036157,	-0.176897,2.8044,0.02945,	-0.170215,2.8044,0.057246,
	-0.159496,2.8044,0.083047,	-0.195658,2.86335,0.101925,	-0.208794,2.86335,0.07027,
	-0.208794,2.86335,0.07027,	-0.170215,2.8044,0.057246,	-0.159496,2.8044,0.083047,
	-0.145078,2.8044,0.106513,	-0.177989,2.86335,0.130707,	-0.195658,2.86335,0.101925,
	-0.195658,2.86335,0.101925,	-0.159496,2.8044,0.083047,	-0.145078,2.8044,0.106513,
	-0.127304,2.8044,0.127304,	-0.1562,2.86335,0.1562,	-0.177989,2.86335,0.130707,
	-0.177989,2.86335,0.130707,	-0.145078,2.8044,0.106513,	-0.127304,2.8044,0.127304,
	-0.106513,2.8044,0.145078,	-0.130707,2.86335,0.177989,	-0.1562,2.86335,0.1562,
	-0.1562,2.86335,0.1562,	-0.127304,2.8044,0.127304,	-0.106513,2.8044,0.145078,
	-0.083047,2.8044,0.159496,	-0.101925,2.86335,0.195658,	-0.130707,2.86335,0.177989,
	-0.130707,2.86335,0.177989,	-0.106513,2.8044,0.145078,	-0.083047,2.8044,0.159496,
	-0.057246,2.8044,0.170215,	-0.07027,2.86335,0.208794,	-0.101925,2.86335,0.195658,
	-0.101925,2.86335,0.195658,	-0.083047,2.8044,0.159496,	-0.057246,2.8044,0.170215,
	-0.02945,2.8044,0.176897,	-0.036157,2.86335,0.216979,	-0.07027,2.86335,0.208794,
	-0.07027,2.86335,0.208794,	-0.057246,2.8044,0.170215,	-0.02945,2.8044,0.176897,
	0,2.8044,0.1792,	0,2.86335,0.2198,	-0.036157,2.86335,0.216979,
	-0.036157,2.86335,0.216979,	-0.02945,2.8044,0.176897,	0,2.8044,0.1792,
	-0.165245,2.74905,0.02748,	-0.176897,2.8044,0.02945,	-0.1792,2.8044,0,
	-0.1792,2.8044,0,	-0.1674,2.74905,0,	-0.165245,2.74905,0.02748,
	-0.158995,2.74905,0.053428,	-0.170215,2.8044,0.057246,	-0.176897,2.8044,0.02945,
	-0.176897,2.8044,0.02945,	-0.165245,2.74905,0.02748,	-0.158995,2.74905,0.053428,
	-0.148969,2.74905,0.077523,	-0.159496,2.8044,0.083047,	-0.170215,2.8044,0.057246,
	-0.170215,2.8044,0.057246,	-0.158995,2.74905,0.053428,	-0.148969,2.74905,0.077523,
	-0.135489,2.74905,0.099446,	-0.145078,2.8044,0.106513,	-0.159496,2.8044,0.083047,
	-0.159496,2.8044,0.083047,	-0.148969,2.74905,0.077523,	-0.135489,2.74905,0.099446,
	-0.118874,2.74905,0.118874,	-0.127304,2.8044,0.127304,	-0.145078,2.8044,0.106513,
	-0.145078,2.8044,0.106513,	-0.135489,2.74905,0.099446,	-0.118874,2.74905,0.118874,
	-0.099446,2.74905,0.135489,	-0.106513,2.8044,0.145078,	-0.127304,2.8044,0.127304,
	-0.127304,2.8044,0.127304,	-0.118874,2.74905,0.118874,	-0.099446,2.74905,0.135489,
	-0.077523,2.74905,0.148969,	-0.083047,2.8044,0.159496,	-0.106513,2.8044,0.145078,
	-0.106513,2.8044,0.145078,	-0.099446,2.74905,0.135489,	-0.077523,2.74905,0.148969,
	-0.053428,2.74905,0.158995,	-0.057246,2.8044,0.170215,	-0.083047,2.8044,0.159496,
	-0.083047,2.8044,0.159496,	-0.077523,2.74905,0.148969,	-0.053428,2.74905,0.158995,
	-0.02748,2.74905,0.165245,	-0.02945,2.8044,0.176897,	-0.057246,2.8044,0.170215,
	-0.057246,2.8044,0.170215,	-0.053428,2.74905,0.158995,	-0.02748,2.74905,0.165245,
	0,2.74905,0.1674,	0,2.8044,0.1792,	-0.02945,2.8044,0.176897,
	-0.02945,2.8044,0.176897,	-0.02748,2.74905,0.165245,	0,2.74905,0.1674,
	-0.197424,2.7,0.032816,	-0.165245,2.74905,0.02748,	-0.1674,2.74905,0,
	-0.1674,2.74905,0,	-0.2,2.7,0,	-0.197424,2.7,0.032816,
	-0.189952,2.7,0.063808,	-0.158995,2.74905,0.053428,	-0.165245,2.74905,0.02748,
	-0.165245,2.74905,0.02748,	-0.197424,2.7,0.032816,	-0.189952,2.7,0.063808,
	-0.177968,2.7,0.092592,	-0.148969,2.74905,0.077523,	-0.158995,2.74905,0.053428,
	-0.158995,2.74905,0.053428,	-0.189952,2.7,0.063808,	-0.177968,2.7,0.092592,
	-0.161856,2.7,0.118784,	-0.135489,2.74905,0.099446,	-0.148969,2.74905,0.077523,
	-0.148969,2.74905,0.077523,	-0.177968,2.7,0.092592,	-0.161856,2.7,0.118784,
	-0.142,2.7,0.142,	-0.118874,2.74905,0.118874,	-0.135489,2.74905,0.099446,
	-0.135489,2.74905,0.099446,	-0.161856,2.7,0.118784,	-0.142,2.7,0.142,
	-0.118784,2.7,0.161856,	-0.099446,2.74905,0.135489,	-0.118874,2.74905,0.118874,
	-0.118874,2.74905,0.118874,	-0.142,2.7,0.142,	-0.118784,2.7,0.161856,
	-0.092592,2.7,0.177968,	-0.077523,2.74905,0.148969,	-0.099446,2.74905,0.135489,
	-0.099446,2.74905,0.135489,	-0.118784,2.7,0.161856,	-0.092592,2.7,0.177968,
	-0.063808,2.7,0.189952,	-0.053428,2.74905,0.158995,	-0.077523,2.74905,0.148969,
	-0.077523,2.74905,0.148969,	-0.092592,2.7,0.177968,	-0.063808,2.7,0.189952,
	-0.032816,2.7,0.197424,	-0.02748,2.74905,0.165245,	-0.053428,2.74905,0.158995,
	-0.053428,2.74905,0.158995,	-0.063808,2.7,0.189952,	-0.032816,2.7,0.197424,
	0,2.7,0.2,	0,2.74905,0.1674,	-0.02748,2.74905,0.165245,
	-0.02748,2.74905,0.165245,	-0.032816,2.7,0.197424,	0,2.7,0.2,
	0,3.15,0,	0,3.14145,0.1946,	0.032048,3.14145,0.192107,
	0,3.15,0,	0.032048,3.14145,0.192107,	0.062272,3.14145,0.18487,
	0,3.15,0,	0.062272,3.14145,0.18487,	0.090306,3.14145,0.173255,
	0,3.15,0,	0.090306,3.14145,0.173255,	0.115787,3.14145,0.157626,
	0,3.15,0,	0.115787,3.14145,0.157626,	0.138348,3.14145,0.138348,
	0,3.15,0,	0.138348,3.14145,0.138348,	0.157626,3.14145,0.115787,
	0,3.15,0,	0.157626,3.14145,0.115787,	0.173255,3.14145,0.090306,
	0,3.15,0,	0.173255,3.14145,0.090306,	0.18487,3.14145,0.062272,
	0,3.15,0,	0.18487,3.14145,0.062272,	0.192107,3.14145,0.032048,
	0,3.15,0,	0.192107,3.14145,0.032048,	0.1946,3.14145,0,
	0.050855,3.1176,0.304843,	0.032048,3.14145,0.192107,	0,3.14145,0.1946,
	0,3.14145,0.1946,	0,3.1176,0.3088,	0.050855,3.1176,0.304843,
	0.098814,3.1176,0.29336,	0.062272,3.14145,0.18487,	0.032048,3.14145,0.192107,
	0.032048,3.14145,0.192107,	0.050855,3.1176,0.304843,	0.098814,3.1176,0.29336,
	0.143301,3.1176,0.274928,	0.090306,3.14145,0.173255,	0.062272,3.14145,0.18487,
	0.062272,3.14145,0.18487,	0.098814,3.1176,0.29336,	0.143301,3.1176,0.274928,
	0.183734,3.1176,0.250127,	0.115787,3.14145,0.157626,	0.090306,3.14145,0.173255,
	0.090306,3.14145,0.173255,	0.143301,3.1176,0.274928,	0.183734,3.1176,0.250127,
	0.219536,3.1176,0.219536,	0.138348,3.14145,0.138348,	0.115787,3.14145,0.157626,
	0.115787,3.14145,0.157626,	0.183734,3.1176,0.250127,	0.219536,3.1176,0.219536,
	0.250127,3.1176,0.183734,	0.157626,3.14145,0.115787,	0.138348,3.14145,0.138348,
	0.138348,3.14145,0.138348,	0.219536,3.1176,0.219536,	0.250127,3.1176,0.183734,
	0.274928,3.1176,0.143301,	0.173255,3.14145,0.090306,	0.157626,3.14145,0.115787,
	0.157626,3.14145,0.115787,	0.250127,3.1176,0.183734,	0.274928,3.1176,0.143301,
	0.29336,3.1176,0.098814,	0.18487,3.14145,0.062272,	0.173255,3.14145,0.090306,
	0.173255,3.14145,0.090306,	0.274928,3.1176,0.143301,	0.29336,3.1176,0.098814,
	0.304843,3.1176,0.050855,	0.192107,3.14145,0.032048,	0.18487,3.14145,0.062272,
	0.18487,3.14145,0.062272,	0.29336,3.1176,0.098814,	0.304843,3.1176,0.050855,
	0.3088,3.1176,0,	0.1946,3.14145,0,	0.192107,3.14145,0.032048,
	0.192107,3.14145,0.032048,	0.304843,3.1176,0.050855,	0.3088,3.1176,0,
	0.058988,3.08115,0.35361,	0.050855,3.1176,0.304843,	0,3.1176,0.3088,
	0,3.1176,0.3088,	0,3.08115,0.3582,	0.058988,3.08115,0.35361,
	0.114619,3.08115,0.340289,	0.098814,3.1176,0.29336,	0.050855,3.1176,0.304843,
	0.050855,3.1176,0.304843,	0.058988,3.08115,0.35361,	0.114619,3.08115,0.340289,
	0.166221,3.08115,0.318907,	0.143301,3.1176,0.274928,	0.098814,3.1176,0.29336,
	0.098814,3.1176,0.29336,	0.114619,3.08115,0.340289,	0.166221,3.08115,0.318907,
	0.213123,3.08115,0.290138,	0.183734,3.1176,0.250127,	0.143301,3.1176,0.274928,
	0.143301,3.1176,0.274928,	0.166221,3.08115,0.318907,	0.213123,3.08115,0.290138,
	0.254653,3.08115,0.254653,	0.219536,3.1176,0.219536,	0.183734,3.1176,0.250127,
	0.183734,3.1176,0.250127,	0.213123,3.08115,0.290138,	0.254653,3.08115,0.254653,
	0.290138,3.08115,0.213123,	0.250127,3.1176,0.183734,	0.219536,3.1176,0.219536,
	0.219536,3.1176,0.219536,	0.254653,3.08115,0.254653,	0.290138,3.08115,0.213123,
	0.318907,3.08115,0.166221,	0.274928,3.1176,0.143301,	0.250127,3.1176,0.183734,
	0.250127,3.1176,0.183734,	0.290138,3.08115,0.213123,	0.318907,3.08115,0.166221,
	0.340289,3.08115,0.114619,	0.29336,3.1176,0.098814,	0.274928,3.1176,0.143301,
	0.274928,3.1176,0.143301,	0.318907,3.08115,0.166221,	0.340289,3.08115,0.114619,
	0.35361,3.08115,0.058988,	0.304843,3.1176,0.050855,	0.29336,3.1176,0.098814,
	0.29336,3.1176,0.098814,	0.340289,3.08115,0.114619,	0.35361,3.08115,0.058988,
	0.3582,3.08115,0,	0.3088,3.1176,0,	0.304843,3.1176,0.050855,
	0.304843,3.1176,0.050855,	0.35361,3.08115,0.058988,	0.3582,3.08115,0,
	0.059016,3.0348,0.353807,	0.058988,3.08115,0.35361,	0,3.08115,0.3582,
	0,3.08115,0.3582,	0,3.0348,0.3584,	0.059016,3.0348,0.353807,
	0.114676,3.0348,0.340477,	0.114619,3.08115,0.340289,	0.058988,3.08115,0.35361,
	0.058988,3.08115,0.35361,	0.059016,3.0348,0.353807,	0.114676,3.0348,0.340477,
	0.166306,3.0348,0.319082,	0.166221,3.08115,0.318907,	0.114619,3.08115,0.340289,
	0.114619,3.08115,0.340289,	0.114676,3.0348,0.340477,	0.166306,3.0348,0.319082,
	0.213234,3.0348,0.290295,	0.213123,3.08115,0.290138,	0.166221,3.08115,0.318907,
	0.166221,3.08115,0.318907,	0.166306,3.0348,0.319082,	0.213234,3.0348,0.290295,
	0.254788,3.0348,0.254788,	0.254653,3.08115,0.254653,	0.213123,3.08115,0.290138,
	0.213123,3.08115,0.290138,	0.213234,3.0348,0.290295,	0.254788,3.0348,0.254788,
	0.290295,3.0348,0.213234,	0.290138,3.08115,0.213123,	0.254653,3.08115,0.254653,
	0.254653,3.08115,0.254653,	0.254788,3.0348,0.254788,	0.290295,3.0348,0.213234,
	0.319082,3.0348,0.166306,	0.318907,3.08115,0.166221,	0.290138,3.08115,0.213123,
	0.290138,3.08115,0.213123,	0.290295,3.0348,0.213234,	0.319082,3.0348,0.166306,
	0.340477,3.0348,0.114676,	0.340289,3.08115,0.114619,	0.318907,3.08115,0.166221,
	0.318907,3.08115,0.166221,	0.319082,3.0348,0.166306,	0.340477,3.0348,0.114676,
	0.353807,3.0348,0.059016,	0.35361,3.08115,0.058988,	0.340289,3.08115,0.114619,
	0.340289,3.08115,0.114619,	0.340477,3.0348,0.114676,	0.353807,3.0348,0.059016,
	0.3584,3.0348,0,	0.3582,3.08115,0,	0.35361,3.08115,0.058988,
	0.35361,3.08115,0.058988,	0.353807,3.0348,0.059016,	0.3584,3.0348,0,
	0.053508,2.98125,0.320834,	0.059016,3.0348,0.353807,	0,3.0348,0.3584,
	0,3.0348,0.3584,	0,2.98125,0.325,	0.053508,2.98125,0.320834,
	0.103976,2.98125,0.308744,	0.114676,3.0348,0.340477,	0.059016,3.0348,0.353807,
	0.059016,3.0348,0.353807,	0.053508,2.98125,0.320834,	0.103976,2.98125,0.308744,
	0.150793,2.98125,0.28934,	0.166306,3.0348,0.319082,	0.114676,3.0348,0.340477,
	0.114676,3.0348,0.340477,	0.103976,2.98125,0.308744,	0.150793,2.98125,0.28934,
	0.193348,2.98125,0.263232,	0.213234,3.0348,0.290295,	0.166306,3.0348,0.319082,
	0.166306,3.0348,0.319082,	0.150793,2.98125,0.28934,	0.193348,2.98125,0.263232,
	0.231031,2.98125,0.231031,	0.254788,3.0348,0.254788,	0.213234,3.0348,0.290295,
	0.213234,3.0348,0.290295,	0.193348,2.98125,0.263232,	0.231031,2.98125,0.231031,
	0.263232,2.98125,0.193348,	0.290295,3.0348,0.213234,	0.254788,3.0348,0.254788,
	0.254788,3.0348,0.254788,	0.231031,2.98125,0.231031,	0.263232,2.98125,0.193348,
	0.28934,2.98125,0.150793,	0.319082,3.0348,0.166306,	0.290295,3.0348,0.213234,
	0.290295,3.0348,0.213234,	0.263232,2.98125,0.193348,	0.28934,2.98125,0.150793,
	0.308744,2.98125,0.103976,	0.340477,3.0348,0.114676,	0.319082,3.0348,0.166306,
	0.319082,3.0348,0.166306,	0.28934,2.98125,0.150793,	0.308744,2.98125,0.103976,
	0.320834,2.98125,0.053508,	0.353807,3.0348,0.059016,	0.340477,3.0348,0.114676,
	0.340477,3.0348,0.114676,	0.308744,2.98125,0.103976,	0.320834,2.98125,0.053508,
	0.325,2.98125,0,	0.3584,3.0348,0,	0.353807,3.0348,0.059016,
	0.353807,3.0348,0.059016,	0.320834,2.98125,0.053508,	0.325,2.98125,0,
	0.045032,2.9232,0.270092,	0.053508,2.98125,0.320834,	0,2.98125,0.325,
	0,2.98125,0.325,	0,2.9232,0.2736,	0.045032,2.9232,0.270092,
	0.087511,2.9232,0.25991,	0.103976,2.98125,0.308744,	0.053508,2.98125,0.320834,
	0.053508,2.98125,0.320834,	0.045032,2.9232,0.270092,	0.087511,2.9232,0.25991,
	0.12692,2.9232,0.243569,	0.150793,2.98125,0.28934,	0.103976,2.98125,0.308744,
	0.103976,2.98125,0.308744,	0.087511,2.9232,0.25991,	0.12692,2.9232,0.243569,
	0.162745,2.9232,0.221585,	0.193348,2.98125,0.263232,	0.150793,2.98125,0.28934,
	0.150793,2.98125,0.28934,	0.12692,2.9232,0.243569,	0.162745,2.9232,0.221585,
	0.194472,2.9232,0.194472,	0.231031,2.98125,0.231031,	0.193348,2.98125,0.263232,
	0.193348,2.98125,0.263232,	0.162745,2.9232,0.221585,	0.194472,2.9232,0.194472,
	0.221585,2.9232,0.162745,	0.263232,2.98125,0.193348,	0.231031,2.98125,0.231031,
	0.231031,2.98125,0.231031,	0.194472,2.9232,0.194472,	0.221585,2.9232,0.162745,
	0.243569,2.9232,0.12692,	0.28934,2.98125,0.150793,	0.263232,2.98125,0.193348,
	0.263232,2.98125,0.193348,	0.221585,2.9232,0.162745,	0.243569,2.9232,0.12692,
	0.25991,2.9232,0.087511,	0.308744,2.98125,0.103976,	0.28934,2.98125,0.150793,
	0.28934,2.98125,0.150793,	0.243569,2.9232,0.12692,	0.25991,2.9232,0.087511,
	0.270092,2.9232,0.045032,	0.320834,2.98125,0.053508,	0.308744,2.98125,0.103976,
	0.308744,2.98125,0.103976,	0.25991,2.9232,0.087511,	0.270092,2.9232,0.045032,
	0.2736,2.9232,0,	0.325,2.98125,0,	0.320834,2.98125,0.053508,
	0.320834,2.98125,0.053508,	0.270092,2.9232,0.045032,	0.2736,2.9232,0,
	0.036157,2.86335,0.216979,	0.045032,2.9232,0.270092,	0,2.9232,0.2736,
	0,2.9232,0.2736,	0,2.86335,0.2198,	0.036157,2.86335,0.216979,
	0.07027,2.86335,0.208794,	0.087511,2.9232,0.25991,	0.045032,2.9232,0.270092,
	0.045032,2.9232,0.270092,	0.036157,2.86335,0.216979,	0.07027,2.86335,0.208794,
	0.101925,2.86335,0.195658,	0.12692,2.9232,0.243569,	0.087511,2.9232,0.25991,
	0.087511,2.9232,0.25991,	0.07027,2.86335,0.208794,	0.101925,2.86335,0.195658,
	0.130707,2.86335,0.177989,	0.162745,2.9232,0.221585,	0.12692,2.9232,0.243569,
	0.12692,2.9232,0.243569,	0.101925,2.86335,0.195658,	0.130707,2.86335,0.177989,
	0.1562,2.86335,0.1562,	0.194472,2.9232,0.194472,	0.162745,2.9232,0.221585,
	0.162745,2.9232,0.221585,	0.130707,2.86335,0.177989,	0.1562,2.86335,0.1562,
	0.177989,2.86335,0.130707,	0.221585,2.9232,0.162745,	0.194472,2.9232,0.194472,
	0.194472,2.9232,0.194472,	0.1562,2.86335,0.1562,	0.177989,2.86335,0.130707,
	0.195658,2.86335,0.101925,	0.243569,2.9232,0.12692,	0.221585,2.9232,0.162745,
	0.221585,2.9232,0.162745,	0.177989,2.86335,0.130707,	0.195658,2.86335,0.101925,
	0.208794,2.86335,0.07027,	0.25991,2.9232,0.087511,	0.243569,2.9232,0.12692,
	0.243569,2.9232,0.12692,	0.195658,2.86335,0.101925,	0.208794,2.86335,0.07027,
	0.216979,2.86335,0.036157,	0.270092,2.9232,0.045032,	0.25991,2.9232,0.087511,
	0.25991,2.9232,0.087511,	0.208794,2.86335,0.07027,	0.216979,2.86335,0.036157,
	0.2198,2.86335,0,	0.2736,2.9232,0,	0.270092,2.9232,0.045032,
	0.270092,2.9232,0.045032,	0.216979,2.86335,0.036157,	0.2198,2.86335,0,
	0.02945,2.8044,0.176897,	0.036157,2.86335,0.216979,	0,2.86335,0.2198,
	0,2.86335,0.2198,	0,2.8044,0.1792,	0.02945,2.8044,0.176897,
	0.057246,2.8044,0.170215,	0.07027,2.86335,0.208794,	0.036157,2.86335,0.216979,
	0.036157,2.86335,0.216979,	0.02945,2.8044,0.176897,	0.057246,2.8044,0.170215,
	0.083047,2.8044,0.159496,	0.101925,2.86335,0.195658,	0.07027,2.86335,0.208794,
	0.07027,2.86335,0.208794,	0.057246,2.8044,0.170215,	0.083047,2.8044,0.159496,
	0.106513,2.8044,0.145078,	0.130707,2.86335,0.177989,	0.101925,2.86335,0.195658,
	0.101925,2.86335,0.195658,	0.083047,2.8044,0.159496,	0.106513,2.8044,0.145078,
	0.127304,2.8044,0.127304,	0.1562,2.86335,0.1562,	0.130707,2.86335,0.177989,
	0.130707,2.86335,0.177989,	0.106513,2.8044,0.145078,	0.127304,2.8044,0.127304,
	0.145078,2.8044,0.106513,	0.177989,2.86335,0.130707,	0.1562,2.86335,0.1562,
	0.1562,2.86335,0.1562,	0.127304,2.8044,0.127304,	0.145078,2.8044,0.106513,
	0.159496,2.8044,0.083047,	0.195658,2.86335,0.101925,	0.177989,2.86335,0.130707,
	0.177989,2.86335,0.130707,	0.145078,2.8044,0.106513,	0.159496,2.8044,0.083047,
	0.170215,2.8044,0.057246,	0.208794,2.86335,0.07027,	0.195658,2.86335,0.101925,
	0.195658,2.86335,0.101925,	0.159496,2.8044,0.083047,	0.170215,2.8044,0.057246,
	0.176897,2.8044,0.02945,	0.216979,2.86335,0.036157,	0.208794,2.86335,0.07027,
	0.208794,2.86335,0.07027,	0.170215,2.8044,0.057246,	0.176897,2.8044,0.02945,
	0.1792,2.8044,0,	0.2198,2.86335,0,	0.216979,2.86335,0.036157,
	0.216979,2.86335,0.036157,	0.176897,2.8044,0.02945,	0.1792,2.8044,0,
	0.02748,2.74905,0.165245,	0.02945,2.8044,0.176897,	0,2.8044,0.1792,
	0,2.8044,0.1792,	0,2.74905,0.1674,	0.02748,2.74905,0.165245,
	0.053428,2.74905,0.158995,	0.057246,2.8044,0.170215,	0.02945,2.8044,0.176897,
	0.02945,2.8044,0.176897,	0.02748,2.74905,0.165245,	0.053428,2.74905,0.158995,
	0.077523,2.74905,0.148969,	0.083047,2.8044,0.159496,	0.057246,2.8044,0.170215,
	0.057246,2.8044,0.170215,	0.053428,2.74905,0.158995,	0.077523,2.74905,0.148969,
	0.099446,2.74905,0.135489,	0.106513,2.8044,0.145078,	0.083047,2.8044,0.159496,
	0.083047,2.8044,0.159496,	0.077523,2.74905,0.148969,	0.099446,2.74905,0.135489,
	0.118874,2.74905,0.118874,	0.127304,2.8044,0.127304,	0.106513,2.8044,0.145078,
	0.106513,2.8044,0.145078,	0.099446,2.74905,0.135489,	0.118874,2.74905,0.118874,
	0.135489,2.74905,0.099446,	0.145078,2.8044,0.106513,	0.127304,2.8044,0.127304,
	0.127304,2.8044,0.127304,	0.118874,2.74905,0.118874,	0.135489,2.74905,0.099446,
	0.148969,2.74905,0.077523,	0.159496,2.8044,0.083047,	0.145078,2.8044,0.106513,
	0.145078,2.8044,0.106513,	0.135489,2.74905,0.099446,	0.148969,2.74905,0.077523,
	0.158995,2.74905,0.053428,	0.170215,2.8044,0.057246,	0.159496,2.8044,0.083047,
	0.159496,2.8044,0.083047,	0.148969,2.74905,0.077523,	0.158995,2.74905,0.053428,
	0.165245,2.74905,0.02748,	0.176897,2.8044,0.02945,	0.170215,2.8044,0.057246,
	0.170215,2.8044,0.057246,	0.158995,2.74905,0.053428,	0.165245,2.74905,0.02748,
	0.1674,2.74905,0,	0.1792,2.8044,0,	0.176897,2.8044,0.02945,
	0.176897,2.8044,0.02945,	0.165245,2.74905,0.02748,	0.1674,2.74905,0,
	0.032816,2.7,0.197424,	0.02748,2.74905,0.165245,	0,2.74905,0.1674,
	0,2.74905,0.1674,	0,2.7,0.2,	0.032816,2.7,0.197424,
	0.063808,2.7,0.189952,	0.053428,2.74905,0.158995,	0.02748,2.74905,0.165245,
	0.02748,2.74905,0.165245,	0.032816,2.7,0.197424,	0.063808,2.7,0.189952,
	0.092592,2.7,0.177968,	0.077523,2.74905,0.148969,	0.053428,2.74905,0.158995,
	0.053428,2.74905,0.158995,	0.063808,2.7,0.189952,	0.092592,2.7,0.177968,
	0.118784,2.7,0.161856,	0.099446,2.74905,0.135489,	0.077523,2.74905,0.148969,
	0.077523,2.74905,0.148969,	0.092592,2.7,0.177968,	0.118784,2.7,0.161856,
	0.142,2.7,0.142,	0.118874,2.74905,0.118874,	0.099446,2.74905,0.135489,
	0.099446,2.74905,0.135489,	0.118784,2.7,0.161856,	0.142,2.7,0.142,
	0.161856,2.7,0.118784,	0.135489,2.74905,0.099446,	0.118874,2.74905,0.118874,
	0.118874,2.74905,0.118874,	0.142,2.7,0.142,	0.161856,2.7,0.118784,
	0.177968,2.7,0.092592,	0.148969,2.74905,0.077523,	0.135489,2.74905,0.099446,
	0.135489,2.74905,0.099446,	0.161856,2.7,0.118784,	0.177968,2.7,0.092592,
	0.189952,2.7,0.063808,	0.158995,2.74905,0.053428,	0.148969,2.74905,0.077523,
	0.148969,2.74905,0.077523,	0.177968,2.7,0.092592,	0.189952,2.7,0.063808,
	0.197424,2.7,0.032816,	0.165245,2.74905,0.02748,	0.158995,2.74905,0.053428,
	0.158995,2.74905,0.053428,	0.189952,2.7,0.063808,	0.197424,2.7,0.032816,
	0.2,2.7,0,	0.1674,2.74905,0,	0.165245,2.74905,0.02748,
	0.165245,2.74905,0.02748,	0.197424,2.7,0.032816,	0.2,2.7,0,
	0.275801,2.6592,-0.045844,	0.197424,2.7,-0.032816,	0.2,2.7,0,
	0.2,2.7,0,	0.2794,2.6592,0,	0.275801,2.6592,-0.045844,
	0.265363,2.6592,-0.08914,	0.189952,2.7,-0.063808,	0.197424,2.7,-0.032816,
	0.197424,2.7,-0.032816,	0.275801,2.6592,-0.045844,	0.265363,2.6592,-0.08914,
	0.248621,2.6592,-0.129351,	0.177968,2.7,-0.092592,	0.189952,2.7,-0.063808,
	0.189952,2.7,-0.063808,	0.265363,2.6592,-0.08914,	0.248621,2.6592,-0.129351,
	0.226113,2.6592,-0.165941,	0.161856,2.7,-0.118784,	0.177968,2.7,-0.092592,
	0.177968,2.7,-0.092592,	0.248621,2.6592,-0.129351,	0.226113,2.6592,-0.165941,
	0.198374,2.6592,-0.198374,	0.142,2.7,-0.142,	0.161856,2.7,-0.118784,
	0.161856,2.7,-0.118784,	0.226113,2.6592,-0.165941,	0.198374,2.6592,-0.198374,
	0.165941,2.6592,-0.226113,	0.118784,2.7,-0.161856,	0.142,2.7,-0.142,
	0.142,2.7,-0.142,	0.198374,2.6592,-0.198374,	0.165941,2.6592,-0.226113,
	0.129351,2.6592,-0.248621,	0.092592,2.7,-0.177968,	0.118784,2.7,-0.161856,
	0.118784,2.7,-0.161856,	0.165941,2.6592,-0.226113,	0.129351,2.6592,-0.248621,
	0.08914,2.6592,-0.265363,	0.063808,2.7,-0.189952,	0.092592,2.7,-0.177968,
	0.092592,2.7,-0.177968,	0.129351,2.6592,-0.248621,	0.08914,2.6592,-0.265363,
	0.045844,2.6592,-0.275801,	0.032816,2.7,-0.197424,	0.063808,2.7,-0.189952,
	0.063808,2.7,-0.189952,	0.08914,2.6592,-0.265363,	0.045844,2.6592,-0.275801,
	0,2.6592,-0.2794,	0,2.7,-0.2,	0.032816,2.7,-0.197424,
	0.032816,2.7,-0.197424,	0.045844,2.6592,-0.275801,	0,2.6592,-0.2794,
	0.386161,2.6256,-0.064188,	0.275801,2.6592,-0.045844,	0.2794,2.6592,0,
	0.2794,2.6592,0,	0.3912,2.6256,0,	0.386161,2.6256,-0.064188,
	0.371546,2.6256,-0.124808,	0.265363,2.6592,-0.08914,	0.275801,2.6592,-0.045844,
	0.275801,2.6592,-0.045844,	0.386161,2.6256,-0.064188,	0.371546,2.6256,-0.124808,
	0.348105,2.6256,-0.18111,	0.248621,2.6592,-0.129351,	0.265363,2.6592,-0.08914,
	0.265363,2.6592,-0.08914,	0.371546,2.6256,-0.124808,	0.348105,2.6256,-0.18111,
	0.31659,2.6256,-0.232342,	0.226113,2.6592,-0.165941,	0.248621,2.6592,-0.129351,
	0.248621,2.6592,-0.129351,	0.348105,2.6256,-0.18111,	0.31659,2.6256,-0.232342,
	0.277752,2.6256,-0.277752,	0.198374,2.6592,-0.198374,	0.226113,2.6592,-0.165941,
	0.226113,2.6592,-0.165941,	0.31659,2.6256,-0.232342,	0.277752,2.6256,-0.277752,
	0.232342,2.6256,-0.31659,	0.165941,2.6592,-0.226113,	0.198374,2.6592,-0.198374,
	0.198374,2.6592,-0.198374,	0.277752,2.6256,-0.277752,	0.232342,2.6256,-0.31659,
	0.18111,2.6256,-0.348105,	0.129351,2.6592,-0.248621,	0.165941,2.6592,-0.226113,
	0.165941,2.6592,-0.226113,	0.232342,2.6256,-0.31659,	0.18111,2.6256,-0.348105,
	0.124808,2.6256,-0.371546,	0.08914,2.6592,-0.265363,	0.129351,2.6592,-0.248621,
	0.129351,2.6592,-0.248621,	0.18111,2.6256,-0.348105,	0.124808,2.6256,-0.371546,
	0.064188,2.6256,-0.386161,	0.045844,2.6592,-0.275801,	0.08914,2.6592,-0.265363,
	0.08914,2.6592,-0.265363,	0.124808,2.6256,-0.371546,	0.064188,2.6256,-0.386161,
	0,2.6256,-0.3912,	0,2.6592,-0.2794,	0.045844,2.6592,-0.275801,
	0.045844,2.6592,-0.275801,	0.064188,2.6256,-0.386161,	0,2.6256,-0.3912,
	0.519028,2.5974,-0.086273,	0.386161,2.6256,-0.064188,	0.3912,2.6256,0,
	0.3912,2.6256,0,	0.5258,2.5974,0,	0.519028,2.5974,-0.086273,
	0.499384,2.5974,-0.167751,	0.371546,2.6256,-0.124808,	0.386161,2.6256,-0.064188,
	0.386161,2.6256,-0.064188,	0.519028,2.5974,-0.086273,	0.499384,2.5974,-0.167751,
	0.467878,2.5974,-0.243424,	0.348105,2.6256,-0.18111,	0.371546,2.6256,-0.124808,
	0.371546,2.6256,-0.124808,	0.499384,2.5974,-0.167751,	0.467878,2.5974,-0.243424,
	0.425519,2.5974,-0.312283,	0.31659,2.6256,-0.232342,	0.348105,2.6256,-0.18111,
	0.348105,2.6256,-0.18111,	0.467878,2.5974,-0.243424,	0.425519,2.5974,-0.312283,
	0.373318,2.5974,-0.373318,	0.277752,2.6256,-0.277752,	0.31659,2.6256,-0.232342,
	0.31659,2.6256,-0.232342,	0.425519,2.5974,-0.312283,	0.373318,2.5974,-0.373318,
	0.312283,2.5974,-0.425519,	0.232342,2.6256,-0.31659,	0.277752,2.6256,-0.277752,
	0.277752,2.6256,-0.277752,	0.373318,2.5974,-0.373318,	0.312283,2.5974,-0.425519,
	0.243424,2.5974,-0.467878,	0.18111,2.6256,-0.348105,	0.232342,2.6256,-0.31659,
	0.232342,2.6256,-0.31659,	0.312283,2.5974,-0.425519,	0.243424,2.5974,-0.467878,
	0.167751,2.5974,-0.499384,	0.124808,2.6256,-0.371546,	0.18111,2.6256,-0.348105,
	0.18111,2.6256,-0.348105,	0.243424,2.5974,-0.467878,	0.167751,2.5974,-0.499384,
	0.086273,2.5974,-0.519028,	0.064188,2.6256,-0.386161,	0.124808,2.6256,-0.371546,
	0.124808,2.6256,-0.371546,	0.167751,2.5974,-0.499384,	0.086273,2.5974,-0.519028,
	0,2.5974,-0.5258,	0,2.6256,-0.3912,	0.064188,2.6256,-0.386161,
	0.064188,2.6256,-0.386161,	0.086273,2.5974,-0.519028,	0,2.5974,-0.5258,
	0.664924,2.5728,-0.110524,	0.519028,2.5974,-0.086273,	0.5258,2.5974,0,
	0.5258,2.5974,0,	0.6736,2.5728,0,	0.664924,2.5728,-0.110524,
	0.639758,2.5728,-0.214905,	0.499384,2.5974,-0.167751,	0.519028,2.5974,-0.086273,
	0.519028,2.5974,-0.086273,	0.664924,2.5728,-0.110524,	0.639758,2.5728,-0.214905,
	0.599396,2.5728,-0.31185,	0.467878,2.5974,-0.243424,	0.499384,2.5974,-0.167751,
	0.499384,2.5974,-0.167751,	0.639758,2.5728,-0.214905,	0.599396,2.5728,-0.31185,
	0.545131,2.5728,-0.400065,	0.425519,2.5974,-0.312283,	0.467878,2.5974,-0.243424,
	0.467878,2.5974,-0.243424,	0.599396,2.5728,-0.31185,	0.545131,2.5728,-0.400065,
	0.478256,2.5728,-0.478256,	0.373318,2.5974,-0.373318,	0.425519,2.5974,-0.312283,
	0.425519,2.5974,-0.312283,	0.545131,2.5728,-0.400065,	0.478256,2.5728,-0.478256,
	0.400065,2.5728,-0.545131,	0.312283,2.5974,-0.425519,	0.373318,2.5974,-0.373318,
	0.373318,2.5974,-0.373318,	0.478256,2.5728,-0.478256,	0.400065,2.5728,-0.545131,
	0.31185,2.5728,-0.599396,	0.243424,2.5974,-0.467878,	0.312283,2.5974,-0.425519,
	0.312283,2.5974,-0.425519,	0.400065,2.5728,-0.545131,	0.31185,2.5728,-0.599396,
	0.214905,2.5728,-0.639758,	0.167751,2.5974,-0.499384,	0.243424,2.5974,-0.467878,
	0.243424,2.5974,-0.467878,	0.31185,2.5728,-0.599396,	0.214905,2.5728,-0.639758,
	0.110524,2.5728,-0.664924,	0.086273,2.5974,-0.519028,	0.167751,2.5974,-0.499384,
	0.167751,2.5974,-0.499384,	0.214905,2.5728,-0.639758,	0.110524,2.5728,-0.664924,
	0,2.5728,-0.6736,	0,2.5974,-0.5258,	0.086273,2.5974,-0.519028,
	0.086273,2.5974,-0.519028,	0.110524,2.5728,-0.664924,	0,2.5728,-0.6736,
	0.814374,2.55,-0.135366,	0.664924,2.5728,-0.110524,	0.6736,2.5728,0,
	0.6736,2.5728,0,	0.825,2.55,0,	0.814374,2.55,-0.135366,
	0.783552,2.55,-0.263208,	0.639758,2.5728,-0.214905,	0.664924,2.5728,-0.110524,
	0.664924,2.5728,-0.110524,	0.814374,2.55,-0.135366,	0.783552,2.55,-0.263208,
	0.734118,2.55,-0.381942,	0.599396,2.5728,-0.31185,	0.639758,2.5728,-0.214905,
	0.639758,2.5728,-0.214905,	0.783552,2.55,-0.263208,	0.734118,2.55,-0.381942,
	0.667656,2.55,-0.489984,	0.545131,2.5728,-0.400065,	0.599396,2.5728,-0.31185,
	0.599396,2.5728,-0.31185,	0.734118,2.55,-0.381942,	0.667656,2.55,-0.489984,
	0.58575,2.55,-0.58575,	0.478256,2.5728,-0.478256,	0.545131,2.5728,-0.400065,
	0.545131,2.5728,-0.400065,	0.667656,2.55,-0.489984,	0.58575,2.55,-0.58575,
	0.489984,2.55,-0.667656,	0.400065,2.5728,-0.545131,	0.478256,2.5728,-0.478256,
	0.478256,2.5728,-0.478256,	0.58575,2.55,-0.58575,	0.489984,2.55,-0.667656,
	0.381942,2.55,-0.734118,	0.31185,2.5728,-0.599396,	0.400065,2.5728,-0.545131,
	0.400065,2.5728,-0.545131,	0.489984,2.55,-0.667656,	0.381942,2.55,-0.734118,
	0.263208,2.55,-0.783552,	0.214905,2.5728,-0.639758,	0.31185,2.5728,-0.599396,
	0.31185,2.5728,-0.599396,	0.381942,2.55,-0.734118,	0.263208,2.55,-0.783552,
	0.135366,2.55,-0.814374,	0.110524,2.5728,-0.664924,	0.214905,2.5728,-0.639758,
	0.214905,2.5728,-0.639758,	0.263208,2.55,-0.783552,	0.135366,2.55,-0.814374,
	0,2.55,-0.825,	0,2.5728,-0.6736,	0.110524,2.5728,-0.664924,
	0.110524,2.5728,-0.664924,	0.135366,2.55,-0.814374,	0,2.55,-0.825,
	0.957901,2.5272,-0.159223,	0.814374,2.55,-0.135366,	0.825,2.55,0,
	0.825,2.55,0,	0.9704,2.5272,0,	0.957901,2.5272,-0.159223,
	0.921647,2.5272,-0.309596,	0.783552,2.55,-0.263208,	0.814374,2.55,-0.135366,
	0.814374,2.55,-0.135366,	0.957901,2.5272,-0.159223,	0.921647,2.5272,-0.309596,
	0.863501,2.5272,-0.449256,	0.734118,2.55,-0.381942,	0.783552,2.55,-0.263208,
	0.783552,2.55,-0.263208,	0.921647,2.5272,-0.309596,	0.863501,2.5272,-0.449256,
	0.785325,2.5272,-0.57634,	0.667656,2.55,-0.489984,	0.734118,2.55,-0.381942,
	0.734118,2.55,-0.381942,	0.863501,2.5272,-0.449256,	0.785325,2.5272,-0.57634,
	0.688984,2.5272,-0.688984,	0.58575,2.55,-0.58575,	0.667656,2.55,-0.489984,
	0.667656,2.55,-0.489984,	0.785325,2.5272,-0.57634,	0.688984,2.5272,-0.688984,
	0.57634,2.5272,-0.785325,	0.489984,2.55,-0.667656,	0.58575,2.55,-0.58575,
	0.58575,2.55,-0.58575,	0.688984,2.5272,-0.688984,	0.57634,2.5272,-0.785325,
	0.449256,2.5272,-0.863501,	0.381942,2.55,-0.734118,	0.489984,2.55,-0.667656,
	0.489984,2.55,-0.667656,	0.57634,2.5272,-0.785325,	0.449256,2.5272,-0.863501,
	0.309596,2.5272,-0.921647,	0.263208,2.55,-0.783552,	0.381942,2.55,-0.734118,
	0.381942,2.55,-0.734118,	0.449256,2.5272,-0.863501,	0.309596,2.5272,-0.921647,
	0.159223,2.5272,-0.957901,	0.135366,2.55,-0.814374,	0.263208,2.55,-0.783552,
	0.263208,2.55,-0.783552,	0.309596,2.5272,-0.921647,	0.159223,2.5272,-0.957901,
	0,2.5272,-0.9704,	0,2.55,-0.825,	0.135366,2.55,-0.814374,
	0.135366,2.55,-0.814374,	0.159223,2.5272,-0.957901,	0,2.5272,-0.9704,
	1.086029,2.5026,-0.180521,	0.957901,2.5272,-0.159223,	0.9704,2.5272,0,
	0.9704,2.5272,0,	1.1002,2.5026,0,	1.086029,2.5026,-0.180521,
	1.044926,2.5026,-0.351008,	0.921647,2.5272,-0.309596,	0.957901,2.5272,-0.159223,
	0.957901,2.5272,-0.159223,	1.086029,2.5026,-0.180521,	1.044926,2.5026,-0.351008,
	0.979002,2.5026,-0.509349,	0.863501,2.5272,-0.449256,	0.921647,2.5272,-0.309596,
	0.921647,2.5272,-0.309596,	1.044926,2.5026,-0.351008,	0.979002,2.5026,-0.509349,
	0.89037,2.5026,-0.653431,	0.785325,2.5272,-0.57634,	0.863501,2.5272,-0.449256,
	0.863501,2.5272,-0.449256,	0.979002,2.5026,-0.509349,	0.89037,2.5026,-0.653431,
	0.781142,2.5026,-0.781142,	0.688984,2.5272,-0.688984,	0.785325,2.5272,-0.57634,
	0.785325,2.5272,-0.57634,	0.89037,2.5026,-0.653431,	0.781142,2.5026,-0.781142,
	0.653431,2.5026,-0.89037,	0.57634,2.5272,-0.785325,	0.688984,2.5272,-0.688984,
	0.688984,2.5272,-0.688984,	0.781142,2.5026,-0.781142,	0.653431,2.5026,-0.89037,
	0.509349,2.5026,-0.979002,	0.449256,2.5272,-0.863501,	0.57634,2.5272,-0.785325,
	0.57634,2.5272,-0.785325,	0.653431,2.5026,-0.89037,	0.509349,2.5026,-0.979002,
	0.351008,2.5026,-1.044926,	0.309596,2.5272,-0.921647,	0.449256,2.5272,-0.863501,
	0.449256,2.5272,-0.863501,	0.509349,2.5026,-0.979002,	0.351008,2.5026,-1.044926,
	0.180521,2.5026,-1.086029,	0.159223,2.5272,-0.957901,	0.309596,2.5272,-0.921647,
	0.309596,2.5272,-0.921647,	0.351008,2.5026,-1.044926,	0.180521,2.5026,-1.086029,
	0,2.5026,-1.1002,	0,2.5272,-0.9704,	0.159223,2.5272,-0.957901,
	0.159223,2.5272,-0.957901,	0.180521,2.5026,-1.086029,	0,2.5026,-1.1002,
	1.189282,2.4744,-0.197684,	1.086029,2.5026,-0.180521,	1.1002,2.5026,0,
	1.1002,2.5026,0,	1.2048,2.4744,0,	1.189282,2.4744,-0.197684,
	1.144271,2.4744,-0.384379,	1.044926,2.5026,-0.351008,	1.086029,2.5026,-0.180521,
	1.086029,2.5026,-0.180521,	1.189282,2.4744,-0.197684,	1.144271,2.4744,-0.384379,
	1.072079,2.4744,-0.557774,	0.979002,2.5026,-0.509349,	1.044926,2.5026,-0.351008,
	1.044926,2.5026,-0.351008,	1.144271,2.4744,-0.384379,	1.072079,2.4744,-0.557774,
	0.975021,2.4744,-0.715555,	0.89037,2.5026,-0.653431,	0.979002,2.5026,-0.509349,
	0.979002,2.5026,-0.509349,	1.072079,2.4744,-0.557774,	0.975021,2.4744,-0.715555,
	0.855408,2.4744,-0.855408,	0.781142,2.5026,-0.781142,	0.89037,2.5026,-0.653431,
	0.89037,2.5026,-0.653431,	0.975021,2.4744,-0.715555,	0.855408,2.4744,-0.855408,
	0.715555,2.4744,-0.975021,	0.653431,2.5026,-0.89037,	0.781142,2.5026,-0.781142,
	0.781142,2.5026,-0.781142,	0.855408,2.4744,-0.855408,	0.715555,2.4744,-0.975021,
	0.557774,2.4744,-1.072079,	0.509349,2.5026,-0.979002,	0.653431,2.5026,-0.89037,
	0.653431,2.5026,-0.89037,	0.715555,2.4744,-0.975021,	0.557774,2.4744,-1.072079,
	0.384379,2.4744,-1.144271,	0.351008,2.5026,-1.044926,	0.509349,2.5026,-0.979002,
	0.509349,2.5026,-0.979002,	0.557774,2.4744,-1.072079,	0.384379,2.4744,-1.144271,
	0.197684,2.4744,-1.189282,	0.180521,2.5026,-1.086029,	0.351008,2.5026,-1.044926,
	0.351008,2.5026,-1.044926,	0.384379,2.4744,-1.144271,	0.197684,2.4744,-1.189282,
	0,2.4744,-1.2048,	0,2.5026,-1.1002,	0.180521,2.5026,-1.086029,
	0.180521,2.5026,-1.086029,	0.197684,2.4744,-1.189282,	0,2.4744,-1.2048,
	1.258183,2.4408,-0.209136,	1.189282,2.4744,-0.197684,	1.2048,2.4744,0,
	1.2048,2.4744,0,	1.2746,2.4408,0,	1.258183,2.4408,-0.209136,
	1.210564,2.4408,-0.406648,	1.144271,2.4744,-0.384379,	1.189282,2.4744,-0.197684,
	1.189282,2.4744,-0.197684,	1.258183,2.4408,-0.209136,	1.210564,2.4408,-0.406648,
	1.13419,2.4408,-0.590089,	1.072079,2.4744,-0.557774,	1.144271,2.4744,-0.384379,
	1.144271,2.4744,-0.384379,	1.210564,2.4408,-0.406648,	1.13419,2.4408,-0.590089,
	1.031508,2.4408,-0.75701,	0.975021,2.4744,-0.715555,	1.072079,2.4744,-0.557774,
	1.072079,2.4744,-0.557774,	1.13419,2.4408,-0.590089,	1.031508,2.4408,-0.75701,
	0.904966,2.4408,-0.904966,	0.855408,2.4744,-0.855408,	0.975021,2.4744,-0.715555,
	0.975021,2.4744,-0.715555,	1.031508,2.4408,-0.75701,	0.904966,2.4408,-0.904966,
	0.75701,2.4408,-1.031508,	0.715555,2.4744,-0.975021,	0.855408,2.4744,-0.855408,
	0.855408,2.4744,-0.855408,	0.904966,2.4408,-0.904966,	0.75701,2.4408,-1.031508,
	0.590089,2.4408,-1.13419,	0.557774,2.4744,-1.072079,	0.715555,2.4744,-0.975021,
	0.715555,2.4744,-0.975021,	0.75701,2.4408,-1.031508,	0.590089,2.4408,-1.13419,
	0.406648,2.4408,-1.210564,	0.384379,2.4744,-1.144271,	0.557774,2.4744,-1.072079,
	0.557774,2.4744,-1.072079,	0.590089,2.4408,-1.13419,	0.406648,2.4408,-1.210564,
	0.209136,2.4408,-1.258183,	0.197684,2.4744,-1.189282,	0.384379,2.4744,-1.144271,
	0.384379,2.4744,-1.144271,	0.406648,2.4408,-1.210564,	0.209136,2.4408,-1.258183,
	0,2.4408,-1.2746,	0,2.4744,-1.2048,	0.197684,2.4744,-1.189282,
	0.197684,2.4744,-1.189282,	0.209136,2.4408,-1.258183,	0,2.4408,-1.2746,
	1.283256,2.4,-0.213304,	1.258183,2.4408,-0.209136,	1.2746,2.4408,0,
	1.2746,2.4408,0,	1.3,2.4,0,	1.283256,2.4,-0.213304,
	1.234688,2.4,-0.414752,	1.210564,2.4408,-0.406648,	1.258183,2.4408,-0.209136,
	1.258183,2.4408,-0.209136,	1.283256,2.4,-0.213304,	1.234688,2.4,-0.414752,
	1.156792,2.4,-0.601848,	1.13419,2.4408,-0.590089,	1.210564,2.4408,-0.406648,
	1.210564,2.4408,-0.406648,	1.234688,2.4,-0.414752,	1.156792,2.4,-0.601848,
	1.052064,2.4,-0.772096,	1.031508,2.4408,-0.75701,	1.13419,2.4408,-0.590089,
	1.13419,2.4408,-0.590089,	1.156792,2.4,-0.601848,	1.052064,2.4,-0.772096,
	0.923,2.4,-0.923,	0.904966,2.4408,-0.904966,	1.031508,2.4408,-0.75701,
	1.031508,2.4408,-0.75701,	1.052064,2.4,-0.772096,	0.923,2.4,-0.923,
	0.772096,2.4,-1.052064,	0.75701,2.4408,-1.031508,	0.904966,2.4408,-0.904966,
	0.904966,2.4408,-0.904966,	0.923,2.4,-0.923,	0.772096,2.4,-1.052064,
	0.601848,2.4,-1.156792,	0.590089,2.4408,-1.13419,	0.75701,2.4408,-1.031508,
	0.75701,2.4408,-1.031508,	0.772096,2.4,-1.052064,	0.601848,2.4,-1.156792,
	0.414752,2.4,-1.234688,	0.406648,2.4408,-1.210564,	0.590089,2.4408,-1.13419,
	0.590089,2.4408,-1.13419,	0.601848,2.4,-1.156792,	0.414752,2.4,-1.234688,
	0.213304,2.4,-1.283256,	0.209136,2.4408,-1.258183,	0.406648,2.4408,-1.210564,
	0.406648,2.4408,-1.210564,	0.414752,2.4,-1.234688,	0.213304,2.4,-1.283256,
	0,2.4,-1.3,	0,2.4408,-1.2746,	0.209136,2.4408,-1.258183,
	0.209136,2.4408,-1.258183,	0.213304,2.4,-1.283256,	0,2.4,-1.3,
	-0.045844,2.6592,-0.275801,	-0.032816,2.7,-0.197424,	0,2.7,-0.2,
	0,2.7,-0.2,	0,2.6592,-0.2794,	-0.045844,2.6592,-0.275801,
	-0.08914,2.6592,-0.265363,	-0.063808,2.7,-0.189952,	-0.032816,2.7,-0.197424,
	-0.032816,2.7,-0.197424,	-0.045844,2.6592,-0.275801,	-0.08914,2.6592,-0.265363,
	-0.129351,2.6592,-0.248621,	-0.092592,2.7,-0.177968,	-0.063808,2.7,-0.189952,
	-0.063808,2.7,-0.189952,	-0.08914,2.6592,-0.265363,	-0.129351,2.6592,-0.248621,
	-0.165941,2.6592,-0.226113,	-0.118784,2.7,-0.161856,	-0.092592,2.7,-0.177968,
	-0.092592,2.7,-0.177968,	-0.129351,2.6592,-0.248621,	-0.165941,2.6592,-0.226113,
	-0.198374,2.6592,-0.198374,	-0.142,2.7,-0.142,	-0.118784,2.7,-0.161856,
	-0.118784,2.7,-0.161856,	-0.165941,2.6592,-0.226113,	-0.198374,2.6592,-0.198374,
	-0.226113,2.6592,-0.165941,	-0.161856,2.7,-0.118784,	-0.142,2.7,-0.142,
	-0.142,2.7,-0.142,	-0.198374,2.6592,-0.198374,	-0.226113,2.6592,-0.165941,
	-0.248621,2.6592,-0.129351,	-0.177968,2.7,-0.092592,	-0.161856,2.7,-0.118784,
	-0.161856,2.7,-0.118784,	-0.226113,2.6592,-0.165941,	-0.248621,2.6592,-0.129351,
	-0.265363,2.6592,-0.08914,	-0.189952,2.7,-0.063808,	-0.177968,2.7,-0.092592,
	-0.177968,2.7,-0.092592,	-0.248621,2.6592,-0.129351,	-0.265363,2.6592,-0.08914,
	-0.275801,2.6592,-0.045844,	-0.197424,2.7,-0.032816,	-0.189952,2.7,-0.063808,
	-0.189952,2.7,-0.063808,	-0.265363,2.6592,-0.08914,	-0.275801,2.6592,-0.045844,
	-0.2794,2.6592,0,	-0.2,2.7,0,	-0.197424,2.7,-0.032816,
	-0.197424,2.7,-0.032816,	-0.275801,2.6592,-0.045844,	-0.2794,2.6592,0,
	-0.064188,2.6256,-0.386161,	-0.045844,2.6592,-0.275801,	0,2.6592,-0.2794,
	0,2.6592,-0.2794,	0,2.6256,-0.3912,	-0.064188,2.6256,-0.386161,
	-0.124808,2.6256,-0.371546,	-0.08914,2.6592,-0.265363,	-0.045844,2.6592,-0.275801,
	-0.045844,2.6592,-0.275801,	-0.064188,2.6256,-0.386161,	-0.124808,2.6256,-0.371546,
	-0.18111,2.6256,-0.348105,	-0.129351,2.6592,-0.248621,	-0.08914,2.6592,-0.265363,
	-0.08914,2.6592,-0.265363,	-0.124808,2.6256,-0.371546,	-0.18111,2.6256,-0.348105,
	-0.232342,2.6256,-0.31659,	-0.165941,2.6592,-0.226113,	-0.129351,2.6592,-0.248621,
	-0.129351,2.6592,-0.248621,	-0.18111,2.6256,-0.348105,	-0.232342,2.6256,-0.31659,
	-0.277752,2.6256,-0.277752,	-0.198374,2.6592,-0.198374,	-0.165941,2.6592,-0.226113,
	-0.165941,2.6592,-0.226113,	-0.232342,2.6256,-0.31659,	-0.277752,2.6256,-0.277752,
	-0.31659,2.6256,-0.232342,	-0.226113,2.6592,-0.165941,	-0.198374,2.6592,-0.198374,
	-0.198374,2.6592,-0.198374,	-0.277752,2.6256,-0.277752,	-0.31659,2.6256,-0.232342,
	-0.348105,2.6256,-0.18111,	-0.248621,2.6592,-0.129351,	-0.226113,2.6592,-0.165941,
	-0.226113,2.6592,-0.165941,	-0.31659,2.6256,-0.232342,	-0.348105,2.6256,-0.18111,
	-0.371546,2.6256,-0.124808,	-0.265363,2.6592,-0.08914,	-0.248621,2.6592,-0.129351,
	-0.248621,2.6592,-0.129351,	-0.348105,2.6256,-0.18111,	-0.371546,2.6256,-0.124808,
	-0.386161,2.6256,-0.064188,	-0.275801,2.6592,-0.045844,	-0.265363,2.6592,-0.08914,
	-0.265363,2.6592,-0.08914,	-0.371546,2.6256,-0.124808,	-0.386161,2.6256,-0.064188,
	-0.3912,2.6256,0,	-0.2794,2.6592,0,	-0.275801,2.6592,-0.045844,
	-0.275801,2.6592,-0.045844,	-0.386161,2.6256,-0.064188,	-0.3912,2.6256,0,
	-0.086273,2.5974,-0.519028,	-0.064188,2.6256,-0.386161,	0,2.6256,-0.3912,
	0,2.6256,-0.3912,	0,2.5974,-0.5258,	-0.086273,2.5974,-0.519028,
	-0.167751,2.5974,-0.499384,	-0.124808,2.6256,-0.371546,	-0.064188,2.6256,-0.386161,
	-0.064188,2.6256,-0.386161,	-0.086273,2.5974,-0.519028,	-0.167751,2.5974,-0.499384,
	-0.243424,2.5974,-0.467878,	-0.18111,2.6256,-0.348105,	-0.124808,2.6256,-0.371546,
	-0.124808,2.6256,-0.371546,	-0.167751,2.5974,-0.499384,	-0.243424,2.5974,-0.467878,
	-0.312283,2.5974,-0.425519,	-0.232342,2.6256,-0.31659,	-0.18111,2.6256,-0.348105,
	-0.18111,2.6256,-0.348105,	-0.243424,2.5974,-0.467878,	-0.312283,2.5974,-0.425519,
	-0.373318,2.5974,-0.373318,	-0.277752,2.6256,-0.277752,	-0.232342,2.6256,-0.31659,
	-0.232342,2.6256,-0.31659,	-0.312283,2.5974,-0.425519,	-0.373318,2.5974,-0.373318,
	-0.425519,2.5974,-0.312283,	-0.31659,2.6256,-0.232342,	-0.277752,2.6256,-0.277752,
	-0.277752,2.6256,-0.277752,	-0.373318,2.5974,-0.373318,	-0.425519,2.5974,-0.312283,
	-0.467878,2.5974,-0.243424,	-0.348105,2.6256,-0.18111,	-0.31659,2.6256,-0.232342,
	-0.31659,2.6256,-0.232342,	-0.425519,2.5974,-0.312283,	-0.467878,2.5974,-0.243424,
	-0.499384,2.5974,-0.167751,	-0.371546,2.6256,-0.124808,	-0.348105,2.6256,-0.18111,
	-0.348105,2.6256,-0.18111,	-0.467878,2.5974,-0.243424,	-0.499384,2.5974,-0.167751,
	-0.519028,2.5974,-0.086273,	-0.386161,2.6256,-0.064188,	-0.371546,2.6256,-0.124808,
	-0.371546,2.6256,-0.124808,	-0.499384,2.5974,-0.167751,	-0.519028,2.5974,-0.086273,
	-0.5258,2.5974,0,	-0.3912,2.6256,0,	-0.386161,2.6256,-0.064188,
	-0.386161,2.6256,-0.064188,	-0.519028,2.5974,-0.086273,	-0.5258,2.5974,0,
	-0.110524,2.5728,-0.664924,	-0.086273,2.5974,-0.519028,	0,2.5974,-0.5258,
	0,2.5974,-0.5258,	0,2.5728,-0.6736,	-0.110524,2.5728,-0.664924,
	-0.214905,2.5728,-0.639758,	-0.167751,2.5974,-0.499384,	-0.086273,2.5974,-0.519028,
	-0.086273,2.5974,-0.519028,	-0.110524,2.5728,-0.664924,	-0.214905,2.5728,-0.639758,
	-0.31185,2.5728,-0.599396,	-0.243424,2.5974,-0.467878,	-0.167751,2.5974,-0.499384,
	-0.167751,2.5974,-0.499384,	-0.214905,2.5728,-0.639758,	-0.31185,2.5728,-0.599396,
	-0.400065,2.5728,-0.545131,	-0.312283,2.5974,-0.425519,	-0.243424,2.5974,-0.467878,
	-0.243424,2.5974,-0.467878,	-0.31185,2.5728,-0.599396,	-0.400065,2.5728,-0.545131,
	-0.478256,2.5728,-0.478256,	-0.373318,2.5974,-0.373318,	-0.312283,2.5974,-0.425519,
	-0.312283,2.5974,-0.425519,	-0.400065,2.5728,-0.545131,	-0.478256,2.5728,-0.478256,
	-0.545131,2.5728,-0.400065,	-0.425519,2.5974,-0.312283,	-0.373318,2.5974,-0.373318,
	-0.373318,2.5974,-0.373318,	-0.478256,2.5728,-0.478256,	-0.545131,2.5728,-0.400065,
	-0.599396,2.5728,-0.31185,	-0.467878,2.5974,-0.243424,	-0.425519,2.5974,-0.312283,
	-0.425519,2.5974,-0.312283,	-0.545131,2.5728,-0.400065,	-0.599396,2.5728,-0.31185,
	-0.639758,2.5728,-0.214905,	-0.499384,2.5974,-0.167751,	-0.467878,2.5974,-0.243424,
	-0.467878,2.5974,-0.243424,	-0.599396,2.5728,-0.31185,	-0.639758,2.5728,-0.214905,
	-0.664924,2.5728,-0.110524,	-0.519028,2.5974,-0.086273,	-0.499384,2.5974,-0.167751,
	-0.499384,2.5974,-0.167751,	-0.639758,2.5728,-0.214905,	-0.664924,2.5728,-0.110524,
	-0.6736,2.5728,0,	-0.5258,2.5974,0,	-0.519028,2.5974,-0.086273,
	-0.519028,2.5974,-0.086273,	-0.664924,2.5728,-0.110524,	-0.6736,2.5728,0,
	-0.135366,2.55,-0.814374,	-0.110524,2.5728,-0.664924,	0,2.5728,-0.6736,
	0,2.5728,-0.6736,	0,2.55,-0.825,	-0.135366,2.55,-0.814374,
	-0.263208,2.55,-0.783552,	-0.214905,2.5728,-0.639758,	-0.110524,2.5728,-0.664924,
	-0.110524,2.5728,-0.664924,	-0.135366,2.55,-0.814374,	-0.263208,2.55,-0.783552,
	-0.381942,2.55,-0.734118,	-0.31185,2.5728,-0.599396,	-0.214905,2.5728,-0.639758,
	-0.214905,2.5728,-0.639758,	-0.263208,2.55,-0.783552,	-0.381942,2.55,-0.734118,
	-0.489984,2.55,-0.667656,	-0.400065,2.5728,-0.545131,	-0.31185,2.5728,-0.599396,
	-0.31185,2.5728,-0.599396,	-0.381942,2.55,-0.734118,	-0.489984,2.55,-0.667656,
	-0.58575,2.55,-0.58575,	-0.478256,2.5728,-0.478256,	-0.400065,2.5728,-0.545131,
	-0.400065,2.5728,-0.545131,	-0.489984,2.55,-0.667656,	-0.58575,2.55,-0.58575,
	-0.667656,2.55,-0.489984,	-0.545131,2.5728,-0.400065,	-0.478256,2.5728,-0.478256,
	-0.478256,2.5728,-0.478256,	-0.58575,2.55,-0.58575,	-0.667656,2.55,-0.489984,
	-0.734118,2.55,-0.381942,	-0.599396,2.5728,-0.31185,	-0.545131,2.5728,-0.400065,
	-0.545131,2.5728,-0.400065,	-0.667656,2.55,-0.489984,	-0.734118,2.55,-0.381942,
	-0.783552,2.55,-0.263208,	-0.639758,2.5728,-0.214905,	-0.599396,2.5728,-0.31185,
	-0.599396,2.5728,-0.31185,	-0.734118,2.55,-0.381942,	-0.783552,2.55,-0.263208,
	-0.814374,2.55,-0.135366,	-0.664924,2.5728,-0.110524,	-0.639758,2.5728,-0.214905,
	-0.639758,2.5728,-0.214905,	-0.783552,2.55,-0.263208,	-0.814374,2.55,-0.135366,
	-0.825,2.55,0,	-0.6736,2.5728,0,	-0.664924,2.5728,-0.110524,
	-0.664924,2.5728,-0.110524,	-0.814374,2.55,-0.135366,	-0.825,2.55,0,
	-0.159223,2.5272,-0.957901,	-0.135366,2.55,-0.814374,	0,2.55,-0.825,
	0,2.55,-0.825,	0,2.5272,-0.9704,	-0.159223,2.5272,-0.957901,
	-0.309596,2.5272,-0.921647,	-0.263208,2.55,-0.783552,	-0.135366,2.55,-0.814374,
	-0.135366,2.55,-0.814374,	-0.159223,2.5272,-0.957901,	-0.309596,2.5272,-0.921647,
	-0.449256,2.5272,-0.863501,	-0.381942,2.55,-0.734118,	-0.263208,2.55,-0.783552,
	-0.263208,2.55,-0.783552,	-0.309596,2.5272,-0.921647,	-0.449256,2.5272,-0.863501,
	-0.57634,2.5272,-0.785325,	-0.489984,2.55,-0.667656,	-0.381942,2.55,-0.734118,
	-0.381942,2.55,-0.734118,	-0.449256,2.5272,-0.863501,	-0.57634,2.5272,-0.785325,
	-0.688984,2.5272,-0.688984,	-0.58575,2.55,-0.58575,	-0.489984,2.55,-0.667656,
	-0.489984,2.55,-0.667656,	-0.57634,2.5272,-0.785325,	-0.688984,2.5272,-0.688984,
	-0.785325,2.5272,-0.57634,	-0.667656,2.55,-0.489984,	-0.58575,2.55,-0.58575,
	-0.58575,2.55,-0.58575,	-0.688984,2.5272,-0.688984,	-0.785325,2.5272,-0.57634,
	-0.863501,2.5272,-0.449256,	-0.734118,2.55,-0.381942,	-0.667656,2.55,-0.489984,
	-0.667656,2.55,-0.489984,	-0.785325,2.5272,-0.57634,	-0.863501,2.5272,-0.449256,
	-0.921647,2.5272,-0.309596,	-0.783552,2.55,-0.263208,	-0.734118,2.55,-0.381942,
	-0.734118,2.55,-0.381942,	-0.863501,2.5272,-0.449256,	-0.921647,2.5272,-0.309596,
	-0.957901,2.5272,-0.159223,	-0.814374,2.55,-0.135366,	-0.783552,2.55,-0.263208,
	-0.783552,2.55,-0.263208,	-0.921647,2.5272,-0.309596,	-0.957901,2.5272,-0.159223,
	-0.9704,2.5272,0,	-0.825,2.55,0,	-0.814374,2.55,-0.135366,
	-0.814374,2.55,-0.135366,	-0.957901,2.5272,-0.159223,	-0.9704,2.5272,0,
	-0.180521,2.5026,-1.086029,	-0.159223,2.5272,-0.957901,	0,2.5272,-0.9704,
	0,2.5272,-0.9704,	0,2.5026,-1.1002,	-0.180521,2.5026,-1.086029,
	-0.351008,2.5026,-1.044926,	-0.309596,2.5272,-0.921647,	-0.159223,2.5272,-0.957901,
	-0.159223,2.5272,-0.957901,	-0.180521,2.5026,-1.086029,	-0.351008,2.5026,-1.044926,
	-0.509349,2.5026,-0.979002,	-0.449256,2.5272,-0.863501,	-0.309596,2.5272,-0.921647,
	-0.309596,2.5272,-0.921647,	-0.351008,2.5026,-1.044926,	-0.509349,2.5026,-0.979002,
	-0.653431,2.5026,-0.89037,	-0.57634,2.5272,-0.785325,	-0.449256,2.5272,-0.863501,
	-0.449256,2.5272,-0.863501,	-0.509349,2.5026,-0.979002,	-0.653431,2.5026,-0.89037,
	-0.781142,2.5026,-0.781142,	-0.688984,2.5272,-0.688984,	-0.57634,2.5272,-0.785325,
	-0.57634,2.5272,-0.785325,	-0.653431,2.5026,-0.89037,	-0.781142,2.5026,-0.781142,
	-0.89037,2.5026,-0.653431,	-0.785325,2.5272,-0.57634,	-0.688984,2.5272,-0.688984,
	-0.688984,2.5272,-0.688984,	-0.781142,2.5026,-0.781142,	-0.89037,2.5026,-0.653431,
	-0.979002,2.5026,-0.509349,	-0.863501,2.5272,-0.449256,	-0.785325,2.5272,-0.57634,
	-0.785325,2.5272,-0.57634,	-0.89037,2.5026,-0.653431,	-0.979002,2.5026,-0.509349,
	-1.044926,2.5026,-0.351008,	-0.921647,2.5272,-0.309596,	-0.863501,2.5272,-0.449256,
	-0.863501,2.5272,-0.449256,	-0.979002,2.5026,-0.509349,	-1.044926,2.5026,-0.351008,
	-1.086029,2.5026,-0.180521,	-0.957901,2.5272,-0.159223,	-0.921647,2.5272,-0.309596,
	-0.921647,2.5272,-0.309596,	-1.044926,2.5026,-0.351008,	-1.086029,2.5026,-0.180521,
	-1.1002,2.5026,0,	-0.9704,2.5272,0,	-0.957901,2.5272,-0.159223,
	-0.957901,2.5272,-0.159223,	-1.086029,2.5026,-0.180521,	-1.1002,2.5026,0,
	-0.197684,2.4744,-1.189282,	-0.180521,2.5026,-1.086029,	0,2.5026,-1.1002,
	0,2.5026,-1.1002,	0,2.4744,-1.2048,	-0.197684,2.4744,-1.189282,
	-0.384379,2.4744,-1.144271,	-0.351008,2.5026,-1.044926,	-0.180521,2.5026,-1.086029,
	-0.180521,2.5026,-1.086029,	-0.197684,2.4744,-1.189282,	-0.384379,2.4744,-1.144271,
	-0.557774,2.4744,-1.072079,	-0.509349,2.5026,-0.979002,	-0.351008,2.5026,-1.044926,
	-0.351008,2.5026,-1.044926,	-0.384379,2.4744,-1.144271,	-0.557774,2.4744,-1.072079,
	-0.715555,2.4744,-0.975021,	-0.653431,2.5026,-0.89037,	-0.509349,2.5026,-0.979002,
	-0.509349,2.5026,-0.979002,	-0.557774,2.4744,-1.072079,	-0.715555,2.4744,-0.975021,
	-0.855408,2.4744,-0.855408,	-0.781142,2.5026,-0.781142,	-0.653431,2.5026,-0.89037,
	-0.653431,2.5026,-0.89037,	-0.715555,2.4744,-0.975021,	-0.855408,2.4744,-0.855408,
	-0.975021,2.4744,-0.715555,	-0.89037,2.5026,-0.653431,	-0.781142,2.5026,-0.781142,
	-0.781142,2.5026,-0.781142,	-0.855408,2.4744,-0.855408,	-0.975021,2.4744,-0.715555,
	-1.072079,2.4744,-0.557774,	-0.979002,2.5026,-0.509349,	-0.89037,2.5026,-0.653431,
	-0.89037,2.5026,-0.653431,	-0.975021,2.4744,-0.715555,	-1.072079,2.4744,-0.557774,
	-1.144271,2.4744,-0.384379,	-1.044926,2.5026,-0.351008,	-0.979002,2.5026,-0.509349,
	-0.979002,2.5026,-0.509349,	-1.072079,2.4744,-0.557774,	-1.144271,2.4744,-0.384379,
	-1.189282,2.4744,-0.197684,	-1.086029,2.5026,-0.180521,	-1.044926,2.5026,-0.351008,
	-1.044926,2.5026,-0.351008,	-1.144271,2.4744,-0.384379,	-1.189282,2.4744,-0.197684,
	-1.2048,2.4744,0,	-1.1002,2.5026,0,	-1.086029,2.5026,-0.180521,
	-1.086029,2.5026,-0.180521,	-1.189282,2.4744,-0.197684,	-1.2048,2.4744,0,
	-0.209136,2.4408,-1.258183,	-0.197684,2.4744,-1.189282,	0,2.4744,-1.2048,
	0,2.4744,-1.2048,	0,2.4408,-1.2746,	-0.209136,2.4408,-1.258183,
	-0.406648,2.4408,-1.210564,	-0.384379,2.4744,-1.144271,	-0.197684,2.4744,-1.189282,
	-0.197684,2.4744,-1.189282,	-0.209136,2.4408,-1.258183,	-0.406648,2.4408,-1.210564,
	-0.590089,2.4408,-1.13419,	-0.557774,2.4744,-1.072079,	-0.384379,2.4744,-1.144271,
	-0.384379,2.4744,-1.144271,	-0.406648,2.4408,-1.210564,	-0.590089,2.4408,-1.13419,
	-0.75701,2.4408,-1.031508,	-0.715555,2.4744,-0.975021,	-0.557774,2.4744,-1.072079,
	-0.557774,2.4744,-1.072079,	-0.590089,2.4408,-1.13419,	-0.75701,2.4408,-1.031508,
	-0.904966,2.4408,-0.904966,	-0.855408,2.4744,-0.855408,	-0.715555,2.4744,-0.975021,
	-0.715555,2.4744,-0.975021,	-0.75701,2.4408,-1.031508,	-0.904966,2.4408,-0.904966,
	-1.031508,2.4408,-0.75701,	-0.975021,2.4744,-0.715555,	-0.855408,2.4744,-0.855408,
	-0.855408,2.4744,-0.855408,	-0.904966,2.4408,-0.904966,	-1.031508,2.4408,-0.75701,
	-1.13419,2.4408,-0.590089,	-1.072079,2.4744,-0.557774,	-0.975021,2.4744,-0.715555,
	-0.975021,2.4744,-0.715555,	-1.031508,2.4408,-0.75701,	-1.13419,2.4408,-0.590089,
	-1.210564,2.4408,-0.406648,	-1.144271,2.4744,-0.384379,	-1.072079,2.4744,-0.557774,
	-1.072079,2.4744,-0.557774,	-1.13419,2.4408,-0.590089,	-1.210564,2.4408,-0.406648,
	-1.258183,2.4408,-0.209136,	-1.189282,2.4744,-0.197684,	-1.144271,2.4744,-0.384379,
	-1.144271,2.4744,-0.384379,	-1.210564,2.4408,-0.406648,	-1.258183,2.4408,-0.209136,
	-1.2746,2.4408,0,	-1.2048,2.4744,0,	-1.189282,2.4744,-0.197684,
	-1.189282,2.4744,-0.197684,	-1.258183,2.4408,-0.209136,	-1.2746,2.4408,0,
	-0.213304,2.4,-1.283256,	-0.209136,2.4408,-1.258183,	0,2.4408,-1.2746,
	0,2.4408,-1.2746,	0,2.4,-1.3,	-0.213304,2.4,-1.283256,
	-0.414752,2.4,-1.234688,	-0.406648,2.4408,-1.210564,	-0.209136,2.4408,-1.258183,
	-0.209136,2.4408,-1.258183,	-0.213304,2.4,-1.283256,	-0.414752,2.4,-1.234688,
	-0.601848,2.4,-1.156792,	-0.590089,2.4408,-1.13419,	-0.406648,2.4408,-1.210564,
	-0.406648,2.4408,-1.210564,	-0.414752,2.4,-1.234688,	-0.601848,2.4,-1.156792,
	-0.772096,2.4,-1.052064,	-0.75701,2.4408,-1.031508,	-0.590089,2.4408,-1.13419,
	-0.590089,2.4408,-1.13419,	-0.601848,2.4,-1.156792,	-0.772096,2.4,-1.052064,
	-0.923,2.4,-0.923,	-0.904966,2.4408,-0.904966,	-0.75701,2.4408,-1.031508,
	-0.75701,2.4408,-1.031508,	-0.772096,2.4,-1.052064,	-0.923,2.4,-0.923,
	-1.052064,2.4,-0.772096,	-1.031508,2.4408,-0.75701,	-0.904966,2.4408,-0.904966,
	-0.904966,2.4408,-0.904966,	-0.923,2.4,-0.923,	-1.052064,2.4,-0.772096,
	-1.156792,2.4,-0.601848,	-1.13419,2.4408,-0.590089,	-1.031508,2.4408,-0.75701,
	-1.031508,2.4408,-0.75701,	-1.052064,2.4,-0.772096,	-1.156792,2.4,-0.601848,
	-1.234688,2.4,-0.414752,	-1.210564,2.4408,-0.406648,	-1.13419,2.4408,-0.590089,
	-1.13419,2.4408,-0.590089,	-1.156792,2.4,-0.601848,	-1.234688,2.4,-0.414752,
	-1.283256,2.4,-0.213304,	-1.258183,2.4408,-0.209136,	-1.210564,2.4408,-0.406648,
	-1.210564,2.4408,-0.406648,	-1.234688,2.4,-0.414752,	-1.283256,2.4,-0.213304,
	-1.3,2.4,0,	-1.2746,2.4408,0,	-1.258183,2.4408,-0.209136,
	-1.258183,2.4408,-0.209136,	-1.283256,2.4,-0.213304,	-1.3,2.4,0,
	-0.275801,2.6592,0.045844,	-0.197424,2.7,0.032816,	-0.2,2.7,0,
	-0.2,2.7,0,	-0.2794,2.6592,0,	-0.275801,2.6592,0.045844,
	-0.265363,2.6592,0.08914,	-0.189952,2.7,0.063808,	-0.197424,2.7,0.032816,
	-0.197424,2.7,0.032816,	-0.275801,2.6592,0.045844,	-0.265363,2.6592,0.08914,
	-0.248621,2.6592,0.129351,	-0.177968,2.7,0.092592,	-0.189952,2.7,0.063808,
	-0.189952,2.7,0.063808,	-0.265363,2.6592,0.08914,	-0.248621,2.6592,0.129351,
	-0.226113,2.6592,0.165941,	-0.161856,2.7,0.118784,	-0.177968,2.7,0.092592,
	-0.177968,2.7,0.092592,	-0.248621,2.6592,0.129351,	-0.226113,2.6592,0.165941,
	-0.198374,2.6592,0.198374,	-0.142,2.7,0.142,	-0.161856,2.7,0.118784,
	-0.161856,2.7,0.118784,	-0.226113,2.6592,0.165941,	-0.198374,2.6592,0.198374,
	-0.165941,2.6592,0.226113,	-0.118784,2.7,0.161856,	-0.142,2.7,0.142,
	-0.142,2.7,0.142,	-0.198374,2.6592,0.198374,	-0.165941,2.6592,0.226113,
	-0.129351,2.6592,0.248621,	-0.092592,2.7,0.177968,	-0.118784,2.7,0.161856,
	-0.118784,2.7,0.161856,	-0.165941,2.6592,0.226113,	-0.129351,2.6592,0.248621,
	-0.08914,2.6592,0.265363,	-0.063808,2.7,0.189952,	-0.092592,2.7,0.177968,
	-0.092592,2.7,0.177968,	-0.129351,2.6592,0.248621,	-0.08914,2.6592,0.265363,
	-0.045844,2.6592,0.275801,	-0.032816,2.7,0.197424,	-0.063808,2.7,0.189952,
	-0.063808,2.7,0.189952,	-0.08914,2.6592,0.265363,	-0.045844,2.6592,0.275801,
	0,2.6592,0.2794,	0,2.7,0.2,	-0.032816,2.7,0.197424,
	-0.032816,2.7,0.197424,	-0.045844,2.6592,0.275801,	0,2.6592,0.2794,
	-0.386161,2.6256,0.064188,	-0.275801,2.6592,0.045844,	-0.2794,2.6592,0,
	-0.2794,2.6592,0,	-0.3912,2.6256,0,	-0.386161,2.6256,0.064188,
	-0.371546,2.6256,0.124808,	-0.265363,2.6592,0.08914,	-0.275801,2.6592,0.045844,
	-0.275801,2.6592,0.045844,	-0.386161,2.6256,0.064188,	-0.371546,2.6256,0.124808,
	-0.348105,2.6256,0.18111,	-0.248621,2.6592,0.129351,	-0.265363,2.6592,0.08914,
	-0.265363,2.6592,0.08914,	-0.371546,2.6256,0.124808,	-0.348105,2.6256,0.18111,
	-0.31659,2.6256,0.232342,	-0.226113,2.6592,0.165941,	-0.248621,2.6592,0.129351,
	-0.248621,2.6592,0.129351,	-0.348105,2.6256,0.18111,	-0.31659,2.6256,0.232342,
	-0.277752,2.6256,0.277752,	-0.198374,2.6592,0.198374,	-0.226113,2.6592,0.165941,
	-0.226113,2.6592,0.165941,	-0.31659,2.6256,0.232342,	-0.277752,2.6256,0.277752,
	-0.232342,2.6256,0.31659,	-0.165941,2.6592,0.226113,	-0.198374,2.6592,0.198374,
	-0.198374,2.6592,0.198374,	-0.277752,2.6256,0.277752,	-0.232342,2.6256,0.31659,
	-0.18111,2.6256,0.348105,	-0.129351,2.6592,0.248621,	-0.165941,2.6592,0.226113,
	-0.165941,2.6592,0.226113,	-0.232342,2.6256,0.31659,	-0.18111,2.6256,0.348105,
	-0.124808,2.6256,0.371546,	-0.08914,2.6592,0.265363,	-0.129351,2.6592,0.248621,
	-0.129351,2.6592,0.248621,	-0.18111,2.6256,0.348105,	-0.124808,2.6256,0.371546,
	-0.064188,2.6256,0.386161,	-0.045844,2.6592,0.275801,	-0.08914,2.6592,0.265363,
	-0.08914,2.6592,0.265363,	-0.124808,2.6256,0.371546,	-0.064188,2.6256,0.386161,
	0,2.6256,0.3912,	0,2.6592,0.2794,	-0.045844,2.6592,0.275801,
	-0.045844,2.6592,0.275801,	-0.064188,2.6256,0.386161,	0,2.6256,0.3912,
	-0.519028,2.5974,0.086273,	-0.386161,2.6256,0.064188,	-0.3912,2.6256,0,
	-0.3912,2.6256,0,	-0.5258,2.5974,0,	-0.519028,2.5974,0.086273,
	-0.499384,2.5974,0.167751,	-0.371546,2.6256,0.124808,	-0.386161,2.6256,0.064188,
	-0.386161,2.6256,0.064188,	-0.519028,2.5974,0.086273,	-0.499384,2.5974,0.167751,
	-0.467878,2.5974,0.243424,	-0.348105,2.6256,0.18111,	-0.371546,2.6256,0.124808,
	-0.371546,2.6256,0.124808,	-0.499384,2.5974,0.167751,	-0.467878,2.5974,0.243424,
	-0.425519,2.5974,0.312283,	-0.31659,2.6256,0.232342,	-0.348105,2.6256,0.18111,
	-0.348105,2.6256,0.18111,	-0.467878,2.5974,0.243424,	-0.425519,2.5974,0.312283,
	-0.373318,2.5974,0.373318,	-0.277752,2.6256,0.277752,	-0.31659,2.6256,0.232342,
	-0.31659,2.6256,0.232342,	-0.425519,2.5974,0.312283,	-0.373318,2.5974,0.373318,
	-0.312283,2.5974,0.425519,	-0.232342,2.6256,0.31659,	-0.277752,2.6256,0.277752,
	-0.277752,2.6256,0.277752,	-0.373318,2.5974,0.373318,	-0.312283,2.5974,0.425519,
	-0.243424,2.5974,0.467878,	-0.18111,2.6256,0.348105,	-0.232342,2.6256,0.31659,
	-0.232342,2.6256,0.31659,	-0.312283,2.5974,0.425519,	-0.243424,2.5974,0.467878,
	-0.167751,2.5974,0.499384,	-0.124808,2.6256,0.371546,	-0.18111,2.6256,0.348105,
	-0.18111,2.6256,0.348105,	-0.243424,2.5974,0.467878,	-0.167751,2.5974,0.499384,
	-0.086273,2.5974,0.519028,	-0.064188,2.6256,0.386161,	-0.124808,2.6256,0.371546,
	-0.124808,2.6256,0.371546,	-0.167751,2.5974,0.499384,	-0.086273,2.5974,0.519028,
	0,2.5974,0.5258,	0,2.6256,0.3912,	-0.064188,2.6256,0.386161,
	-0.064188,2.6256,0.386161,	-0.086273,2.5974,0.519028,	0,2.5974,0.5258,
	-0.664924,2.5728,0.110524,	-0.519028,2.5974,0.086273,	-0.5258,2.5974,0,
	-0.5258,2.5974,0,	-0.6736,2.5728,0,	-0.664924,2.5728,0.110524,
	-0.639758,2.5728,0.214905,	-0.499384,2.5974,0.167751,	-0.519028,2.5974,0.086273,
	-0.519028,2.5974,0.086273,	-0.664924,2.5728,0.110524,	-0.639758,2.5728,0.214905,
	-0.599396,2.5728,0.31185,	-0.467878,2.5974,0.243424,	-0.499384,2.5974,0.167751,
	-0.499384,2.5974,0.167751,	-0.639758,2.5728,0.214905,	-0.599396,2.5728,0.31185,
	-0.545131,2.5728,0.400065,	-0.425519,2.5974,0.312283,	-0.467878,2.5974,0.243424,
	-0.467878,2.5974,0.243424,	-0.599396,2.5728,0.31185,	-0.545131,2.5728,0.400065,
	-0.478256,2.5728,0.478256,	-0.373318,2.5974,0.373318,	-0.425519,2.5974,0.312283,
	-0.425519,2.5974,0.312283,	-0.545131,2.5728,0.400065,	-0.478256,2.5728,0.478256,
	-0.400065,2.5728,0.545131,	-0.312283,2.5974,0.425519,	-0.373318,2.5974,0.373318,
	-0.373318,2.5974,0.373318,	-0.478256,2.5728,0.478256,	-0.400065,2.5728,0.545131,
	-0.31185,2.5728,0.599396,	-0.243424,2.5974,0.467878,	-0.312283,2.5974,0.425519,
	-0.312283,2.5974,0.425519,	-0.400065,2.5728,0.545131,	-0.31185,2.5728,0.599396,
	-0.214905,2.5728,0.639758,	-0.167751,2.5974,0.499384,	-0.243424,2.5974,0.467878,
	-0.243424,2.5974,0.467878,	-0.31185,2.5728,0.599396,	-0.214905,2.5728,0.639758,
	-0.110524,2.5728,0.664924,	-0.086273,2.5974,0.519028,	-0.167751,2.5974,0.499384,
	-0.167751,2.5974,0.499384,	-0.214905,2.5728,0.639758,	-0.110524,2.5728,0.664924,
	0,2.5728,0.6736,	0,2.5974,0.5258,	-0.086273,2.5974,0.519028,
	-0.086273,2.5974,0.519028,	-0.110524,2.5728,0.664924,	0,2.5728,0.6736,
	-0.814374,2.55,0.135366,	-0.664924,2.5728,0.110524,	-0.6736,2.5728,0,
	-0.6736,2.5728,0,	-0.825,2.55,0,	-0.814374,2.55,0.135366,
	-0.783552,2.55,0.263208,	-0.639758,2.5728,0.214905,	-0.664924,2.5728,0.110524,
	-0.664924,2.5728,0.110524,	-0.814374,2.55,0.135366,	-0.783552,2.55,0.263208,
	-0.734118,2.55,0.381942,	-0.599396,2.5728,0.31185,	-0.639758,2.5728,0.214905,
	-0.639758,2.5728,0.214905,	-0.783552,2.55,0.263208,	-0.734118,2.55,0.381942,
	-0.667656,2.55,0.489984,	-0.545131,2.5728,0.400065,	-0.599396,2.5728,0.31185,
	-0.599396,2.5728,0.31185,	-0.734118,2.55,0.381942,	-0.667656,2.55,0.489984,
	-0.58575,2.55,0.58575,	-0.478256,2.5728,0.478256,	-0.545131,2.5728,0.400065,
	-0.545131,2.5728,0.400065,	-0.667656,2.55,0.489984,	-0.58575,2.55,0.58575,
	-0.489984,2.55,0.667656,	-0.400065,2.5728,0.545131,	-0.478256,2.5728,0.478256,
	-0.478256,2.5728,0.478256,	-0.58575,2.55,0.58575,	-0.489984,2.55,0.667656,
	-0.381942,2.55,0.734118,	-0.31185,2.5728,0.599396,	-0.400065,2.5728,0.545131,
	-0.400065,2.5728,0.545131,	-0.489984,2.55,0.667656,	-0.381942,2.55,0.734118,
	-0.263208,2.55,0.783552,	-0.214905,2.5728,0.639758,	-0.31185,2.5728,0.599396,
	-0.31185,2.5728,0.599396,	-0.381942,2.55,0.734118,	-0.263208,2.55,0.783552,
	-0.135366,2.55,0.814374,	-0.110524,2.5728,0.664924,	-0.214905,2.5728,0.639758,
	-0.214905,2.5728,0.639758,	-0.263208,2.55,0.783552,	-0.135366,2.55,0.814374,
	0,2.55,0.825,	0,2.5728,0.6736,	-0.110524,2.5728,0.664924,
	-0.110524,2.5728,0.664924,	-0.135366,2.55,0.814374,	0,2.55,0.825,
	-0.957901,2.5272,0.159223,	-0.814374,2.55,0.135366,	-0.825,2.55,0,
	-0.825,2.55,0,	-0.9704,2.5272,0,	-0.957901,2.5272,0.159223,
	-0.921647,2.5272,0.309596,	-0.783552,2.55,0.263208,	-0.814374,2.55,0.135366,
	-0.814374,2.55,0.135366,	-0.957901,2.5272,0.159223,	-0.921647,2.5272,0.309596,
	-0.863501,2.5272,0.449256,	-0.734118,2.55,0.381942,	-0.783552,2.55,0.263208,
	-0.783552,2.55,0.263208,	-0.921647,2.5272,0.309596,	-0.863501,2.5272,0.449256,
	-0.785325,2.5272,0.57634,	-0.667656,2.55,0.489984,	-0.734118,2.55,0.381942,
	-0.734118,2.55,0.381942,	-0.863501,2.5272,0.449256,	-0.785325,2.5272,0.57634,
	-0.688984,2.5272,0.688984,	-0.58575,2.55,0.58575,	-0.667656,2.55,0.489984,
	-0.667656,2.55,0.489984,	-0.785325,2.5272,0.57634,	-0.688984,2.5272,0.688984,
	-0.57634,2.5272,0.785325,	-0.489984,2.55,0.667656,	-0.58575,2.55,0.58575,
	-0.58575,2.55,0.58575,	-0.688984,2.5272,0.688984,	-0.57634,2.5272,0.785325,
	-0.449256,2.5272,0.863501,	-0.381942,2.55,0.734118,	-0.489984,2.55,0.667656,
	-0.489984,2.55,0.667656,	-0.57634,2.5272,0.785325,	-0.449256,2.5272,0.863501,
	-0.309596,2.5272,0.921647,	-0.263208,2.55,0.783552,	-0.381942,2.55,0.734118,
	-0.381942,2.55,0.734118,	-0.449256,2.5272,0.863501,	-0.309596,2.5272,0.921647,
	-0.159223,2.5272,0.957901,	-0.135366,2.55,0.814374,	-0.263208,2.55,0.783552,
	-0.263208,2.55,0.783552,	-0.309596,2.5272,0.921647,	-0.159223,2.5272,0.957901,
	0,2.5272,0.9704,	0,2.55,0.825,	-0.135366,2.55,0.814374,
	-0.135366,2.55,0.814374,	-0.159223,2.5272,0.957901,	0,2.5272,0.9704,
	-1.086029,2.5026,0.180521,	-0.957901,2.5272,0.159223,	-0.9704,2.5272,0,
	-0.9704,2.5272,0,	-1.1002,2.5026,0,	-1.086029,2.5026,0.180521,
	-1.044926,2.5026,0.351008,	-0.921647,2.5272,0.309596,	-0.957901,2.5272,0.159223,
	-0.957901,2.5272,0.159223,	-1.086029,2.5026,0.180521,	-1.044926,2.5026,0.351008,
	-0.979002,2.5026,0.509349,	-0.863501,2.5272,0.449256,	-0.921647,2.5272,0.309596,
	-0.921647,2.5272,0.309596,	-1.044926,2.5026,0.351008,	-0.979002,2.5026,0.509349,
	-0.89037,2.5026,0.653431,	-0.785325,2.5272,0.57634,	-0.863501,2.5272,0.449256,
	-0.863501,2.5272,0.449256,	-0.979002,2.5026,0.509349,	-0.89037,2.5026,0.653431,
	-0.781142,2.5026,0.781142,	-0.688984,2.5272,0.688984,	-0.785325,2.5272,0.57634,
	-0.785325,2.5272,0.57634,	-0.89037,2.5026,0.653431,	-0.781142,2.5026,0.781142,
	-0.653431,2.5026,0.89037,	-0.57634,2.5272,0.785325,	-0.688984,2.5272,0.688984,
	-0.688984,2.5272,0.688984,	-0.781142,2.5026,0.781142,	-0.653431,2.5026,0.89037,
	-0.509349,2.5026,0.979002,	-0.449256,2.5272,0.863501,	-0.57634,2.5272,0.785325,
	-0.57634,2.5272,0.785325,	-0.653431,2.5026,0.89037,	-0.509349,2.5026,0.979002,
	-0.351008,2.5026,1.044926,	-0.309596,2.5272,0.921647,	-0.449256,2.5272,0.863501,
	-0.449256,2.5272,0.863501,	-0.509349,2.5026,0.979002,	-0.351008,2.5026,1.044926,
	-0.180521,2.5026,1.086029,	-0.159223,2.5272,0.957901,	-0.309596,2.5272,0.921647,
	-0.309596,2.5272,0.921647,	-0.351008,2.5026,1.044926,	-0.180521,2.5026,1.086029,
	0,2.5026,1.1002,	0,2.5272,0.9704,	-0.159223,2.5272,0.957901,
	-0.159223,2.5272,0.957901,	-0.180521,2.5026,1.086029,	0,2.5026,1.1002,
	-1.189282,2.4744,0.197684,	-1.086029,2.5026,0.180521,	-1.1002,2.5026,0,
	-1.1002,2.5026,0,	-1.2048,2.4744,0,	-1.189282,2.4744,0.197684,
	-1.144271,2.4744,0.384379,	-1.044926,2.5026,0.351008,	-1.086029,2.5026,0.180521,
	-1.086029,2.5026,0.180521,	-1.189282,2.4744,0.197684,	-1.144271,2.4744,0.384379,
	-1.072079,2.4744,0.557774,	-0.979002,2.5026,0.509349,	-1.044926,2.5026,0.351008,
	-1.044926,2.5026,0.351008,	-1.144271,2.4744,0.384379,	-1.072079,2.4744,0.557774,
	-0.975021,2.4744,0.715555,	-0.89037,2.5026,0.653431,	-0.979002,2.5026,0.509349,
	-0.979002,2.5026,0.509349,	-1.072079,2.4744,0.557774,	-0.975021,2.4744,0.715555,
	-0.855408,2.4744,0.855408,	-0.781142,2.5026,0.781142,	-0.89037,2.5026,0.653431,
	-0.89037,2.5026,0.653431,	-0.975021,2.4744,0.715555,	-0.855408,2.4744,0.855408,
	-0.715555,2.4744,0.975021,	-0.653431,2.5026,0.89037,	-0.781142,2.5026,0.781142,
	-0.781142,2.5026,0.781142,	-0.855408,2.4744,0.855408,	-0.715555,2.4744,0.975021,
	-0.557774,2.4744,1.072079,	-0.509349,2.5026,0.979002,	-0.653431,2.5026,0.89037,
	-0.653431,2.5026,0.89037,	-0.715555,2.4744,0.975021,	-0.557774,2.4744,1.072079,
	-0.384379,2.4744,1.144271,	-0.351008,2.5026,1.044926,	-0.509349,2.5026,0.979002,
	-0.509349,2.5026,0.979002,	-0.557774,2.4744,1.072079,	-0.384379,2.4744,1.144271,
	-0.197684,2.4744,1.189282,	-0.180521,2.5026,1.086029,	-0.351008,2.5026,1.044926,
	-0.351008,2.5026,1.044926,	-0.384379,2.4744,1.144271,	-0.197684,2.4744,1.189282,
	0,2.4744,1.2048,	0,2.5026,1.1002,	-0.180521,2.5026,1.086029,
	-0.180521,2.5026,1.086029,	-0.197684,2.4744,1.189282,	0,2.4744,1.2048,
	-1.258183,2.4408,0.209136,	-1.189282,2.4744,0.197684,	-1.2048,2.4744,0,
	-1.2048,2.4744,0,	-1.2746,2.4408,0,	-1.258183,2.4408,0.209136,
	-1.210564,2.4408,0.406648,	-1.144271,2.4744,0.384379,	-1.189282,2.4744,0.197684,
	-1.189282,2.4744,0.197684,	-1.258183,2.4408,0.209136,	-1.210564,2.4408,0.406648,
	-1.13419,2.4408,0.590089,	-1.072079,2.4744,0.557774,	-1.144271,2.4744,0.384379,
	-1.144271,2.4744,0.384379,	-1.210564,2.4408,0.406648,	-1.13419,2.4408,0.590089,
	-1.031508,2.4408,0.75701,	-0.975021,2.4744,0.715555,	-1.072079,2.4744,0.557774,
	-1.072079,2.4744,0.557774,	-1.13419,2.4408,0.590089,	-1.031508,2.4408,0.75701,
	-0.904966,2.4408,0.904966,	-0.855408,2.4744,0.855408,	-0.975021,2.4744,0.715555,
	-0.975021,2.4744,0.715555,	-1.031508,2.4408,0.75701,	-0.904966,2.4408,0.904966,
	-0.75701,2.4408,1.031508,	-0.715555,2.4744,0.975021,	-0.855408,2.4744,0.855408,
	-0.855408,2.4744,0.855408,	-0.904966,2.4408,0.904966,	-0.75701,2.4408,1.031508,
	-0.590089,2.4408,1.13419,	-0.557774,2.4744,1.072079,	-0.715555,2.4744,0.975021,
	-0.715555,2.4744,0.975021,	-0.75701,2.4408,1.031508,	-0.590089,2.4408,1.13419,
	-0.406648,2.4408,1.210564,	-0.384379,2.4744,1.144271,	-0.557774,2.4744,1.072079,
	-0.557774,2.4744,1.072079,	-0.590089,2.4408,1.13419,	-0.406648,2.4408,1.210564,
	-0.209136,2.4408,1.258183,	-0.197684,2.4744,1.189282,	-0.384379,2.4744,1.144271,
	-0.384379,2.4744,1.144271,	-0.406648,2.4408,1.210564,	-0.209136,2.4408,1.258183,
	0,2.4408,1.2746,	0,2.4744,1.2048,	-0.197684,2.4744,1.189282,
	-0.197684,2.4744,1.189282,	-0.209136,2.4408,1.258183,	0,2.4408,1.2746,
	-1.283256,2.4,0.213304,	-1.258183,2.4408,0.209136,	-1.2746,2.4408,0,
	-1.2746,2.4408,0,	-1.3,2.4,0,	-1.283256,2.4,0.213304,
	-1.234688,2.4,0.414752,	-1.210564,2.4408,0.406648,	-1.258183,2.4408,0.209136,
	-1.258183,2.4408,0.209136,	-1.283256,2.4,0.213304,	-1.234688,2.4,0.414752,
	-1.156792,2.4,0.601848,	-1.13419,2.4408,0.590089,	-1.210564,2.4408,0.406648,
	-1.210564,2.4408,0.406648,	-1.234688,2.4,0.414752,	-1.156792,2.4,0.601848,
	-1.052064,2.4,0.772096,	-1.031508,2.4408,0.75701,	-1.13419,2.4408,0.590089,
	-1.13419,2.4408,0.590089,	-1.156792,2.4,0.601848,	-1.052064,2.4,0.772096,
	-0.923,2.4,0.923,	-0.904966,2.4408,0.904966,	-1.031508,2.4408,0.75701,
	-1.031508,2.4408,0.75701,	-1.052064,2.4,0.772096,	-0.923,2.4,0.923,
	-0.772096,2.4,1.052064,	-0.75701,2.4408,1.031508,	-0.904966,2.4408,0.904966,
	-0.904966,2.4408,0.904966,	-0.923,2.4,0.923,	-0.772096,2.4,1.052064,
	-0.601848,2.4,1.156792,	-0.590089,2.4408,1.13419,	-0.75701,2.4408,1.031508,
	-0.75701,2.4408,1.031508,	-0.772096,2.4,1.052064,	-0.601848,2.4,1.156792,
	-0.414752,2.4,1.234688,	-0.406648,2.4408,1.210564,	-0.590089,2.4408,1.13419,
	-0.590089,2.4408,1.13419,	-0.601848,2.4,1.156792,	-0.414752,2.4,1.234688,
	-0.213304,2.4,1.283256,	-0.209136,2.4408,1.258183,	-0.406648,2.4408,1.210564,
	-0.406648,2.4408,1.210564,	-0.414752,2.4,1.234688,	-0.213304,2.4,1.283256,
	0,2.4,1.3,	0,2.4408,1.2746,	-0.209136,2.4408,1.258183,
	-0.209136,2.4408,1.258183,	-0.213304,2.4,1.283256,	0,2.4,1.3,
	0.045844,2.6592,0.275801,	0.032816,2.7,0.197424,	0,2.7,0.2,
	0,2.7,0.2,	0,2.6592,0.2794,	0.045844,2.6592,0.275801,
	0.08914,2.6592,0.265363,	0.063808,2.7,0.189952,	0.032816,2.7,0.197424,
	0.032816,2.7,0.197424,	0.045844,2.6592,0.275801,	0.08914,2.6592,0.265363,
	0.129351,2.6592,0.248621,	0.092592,2.7,0.177968,	0.063808,2.7,0.189952,
	0.063808,2.7,0.189952,	0.08914,2.6592,0.265363,	0.129351,2.6592,0.248621,
	0.165941,2.6592,0.226113,	0.118784,2.7,0.161856,	0.092592,2.7,0.177968,
	0.092592,2.7,0.177968,	0.129351,2.6592,0.248621,	0.165941,2.6592,0.226113,
	0.198374,2.6592,0.198374,	0.142,2.7,0.142,	0.118784,2.7,0.161856,
	0.118784,2.7,0.161856,	0.165941,2.6592,0.226113,	0.198374,2.6592,0.198374,
	0.226113,2.6592,0.165941,	0.161856,2.7,0.118784,	0.142,2.7,0.142,
	0.142,2.7,0.142,	0.198374,2.6592,0.198374,	0.226113,2.6592,0.165941,
	0.248621,2.6592,0.129351,	0.177968,2.7,0.092592,	0.161856,2.7,0.118784,
	0.161856,2.7,0.118784,	0.226113,2.6592,0.165941,	0.248621,2.6592,0.129351,
	0.265363,2.6592,0.08914,	0.189952,2.7,0.063808,	0.177968,2.7,0.092592,
	0.177968,2.7,0.092592,	0.248621,2.6592,0.129351,	0.265363,2.6592,0.08914,
	0.275801,2.6592,0.045844,	0.197424,2.7,0.032816,	0.189952,2.7,0.063808,
	0.189952,2.7,0.063808,	0.265363,2.6592,0.08914,	0.275801,2.6592,0.045844,
	0.2794,2.6592,0,	0.2,2.7,0,	0.197424,2.7,0.032816,
	0.197424,2.7,0.032816,	0.275801,2.6592,0.045844,	0.2794,2.6592,0,
	0.064188,2.6256,0.386161,	0.045844,2.6592,0.275801,	0,2.6592,0.2794,
	0,2.6592,0.2794,	0,2.6256,0.3912,	0.064188,2.6256,0.386161,
	0.124808,2.6256,0.371546,	0.08914,2.6592,0.265363,	0.045844,2.6592,0.275801,
	0.045844,2.6592,0.275801,	0.064188,2.6256,0.386161,	0.124808,2.6256,0.371546,
	0.18111,2.6256,0.348105,	0.129351,2.6592,0.248621,	0.08914,2.6592,0.265363,
	0.08914,2.6592,0.265363,	0.124808,2.6256,0.371546,	0.18111,2.6256,0.348105,
	0.232342,2.6256,0.31659,	0.165941,2.6592,0.226113,	0.129351,2.6592,0.248621,
	0.129351,2.6592,0.248621,	0.18111,2.6256,0.348105,	0.232342,2.6256,0.31659,
	0.277752,2.6256,0.277752,	0.198374,2.6592,0.198374,	0.165941,2.6592,0.226113,
	0.165941,2.6592,0.226113,	0.232342,2.6256,0.31659,	0.277752,2.6256,0.277752,
	0.31659,2.6256,0.232342,	0.226113,2.6592,0.165941,	0.198374,2.6592,0.198374,
	0.198374,2.6592,0.198374,	0.277752,2.6256,0.277752,	0.31659,2.6256,0.232342,
	0.348105,2.6256,0.18111,	0.248621,2.6592,0.129351,	0.226113,2.6592,0.165941,
	0.226113,2.6592,0.165941,	0.31659,2.6256,0.232342,	0.348105,2.6256,0.18111,
	0.371546,2.6256,0.124808,	0.265363,2.6592,0.08914,	0.248621,2.6592,0.129351,
	0.248621,2.6592,0.129351,	0.348105,2.6256,0.18111,	0.371546,2.6256,0.124808,
	0.386161,2.6256,0.064188,	0.275801,2.6592,0.045844,	0.265363,2.6592,0.08914,
	0.265363,2.6592,0.08914,	0.371546,2.6256,0.124808,	0.386161,2.6256,0.064188,
	0.3912,2.6256,0,	0.2794,2.6592,0,	0.275801,2.6592,0.045844,
	0.275801,2.6592,0.045844,	0.386161,2.6256,0.064188,	0.3912,2.6256,0,
	0.086273,2.5974,0.519028,	0.064188,2.6256,0.386161,	0,2.6256,0.3912,
	0,2.6256,0.3912,	0,2.5974,0.5258,	0.086273,2.5974,0.519028,
	0.167751,2.5974,0.499384,	0.124808,2.6256,0.371546,	0.064188,2.6256,0.386161,
	0.064188,2.6256,0.386161,	0.086273,2.5974,0.519028,	0.167751,2.5974,0.499384,
	0.243424,2.5974,0.467878,	0.18111,2.6256,0.348105,	0.124808,2.6256,0.371546,
	0.124808,2.6256,0.371546,	0.167751,2.5974,0.499384,	0.243424,2.5974,0.467878,
	0.312283,2.5974,0.425519,	0.232342,2.6256,0.31659,	0.18111,2.6256,0.348105,
	0.18111,2.6256,0.348105,	0.243424,2.5974,0.467878,	0.312283,2.5974,0.425519,
	0.373318,2.5974,0.373318,	0.277752,2.6256,0.277752,	0.232342,2.6256,0.31659,
	0.232342,2.6256,0.31659,	0.312283,2.5974,0.425519,	0.373318,2.5974,0.373318,
	0.425519,2.5974,0.312283,	0.31659,2.6256,0.232342,	0.277752,2.6256,0.277752,
	0.277752,2.6256,0.277752,	0.373318,2.5974,0.373318,	0.425519,2.5974,0.312283,
	0.467878,2.5974,0.243424,	0.348105,2.6256,0.18111,	0.31659,2.6256,0.232342,
	0.31659,2.6256,0.232342,	0.425519,2.5974,0.312283,	0.467878,2.5974,0.243424,
	0.499384,2.5974,0.167751,	0.371546,2.6256,0.124808,	0.348105,2.6256,0.18111,
	0.348105,2.6256,0.18111,	0.467878,2.5974,0.243424,	0.499384,2.5974,0.167751,
	0.519028,2.5974,0.086273,	0.386161,2.6256,0.064188,	0.371546,2.6256,0.124808,
	0.371546,2.6256,0.124808,	0.499384,2.5974,0.167751,	0.519028,2.5974,0.086273,
	0.5258,2.5974,0,	0.3912,2.6256,0,	0.386161,2.6256,0.064188,
	0.386161,2.6256,0.064188,	0.519028,2.5974,0.086273,	0.5258,2.5974,0,
	0.110524,2.5728,0.664924,	0.086273,2.5974,0.519028,	0,2.5974,0.5258,
	0,2.5974,0.5258,	0,2.5728,0.6736,	0.110524,2.5728,0.664924,
	0.214905,2.5728,0.639758,	0.167751,2.5974,0.499384,	0.086273,2.5974,0.519028,
	0.086273,2.5974,0.519028,	0.110524,2.5728,0.664924,	0.214905,2.5728,0.639758,
	0.31185,2.5728,0.599396,	0.243424,2.5974,0.467878,	0.167751,2.5974,0.499384,
	0.167751,2.5974,0.499384,	0.214905,2.5728,0.639758,	0.31185,2.5728,0.599396,
	0.400065,2.5728,0.545131,	0.312283,2.5974,0.425519,	0.243424,2.5974,0.467878,
	0.243424,2.5974,0.467878,	0.31185,2.5728,0.599396,	0.400065,2.5728,0.545131,
	0.478256,2.5728,0.478256,	0.373318,2.5974,0.373318,	0.312283,2.5974,0.425519,
	0.312283,2.5974,0.425519,	0.400065,2.5728,0.545131,	0.478256,2.5728,0.478256,
	0.545131,2.5728,0.400065,	0.425519,2.5974,0.312283,	0.373318,2.5974,0.373318,
	0.373318,2.5974,0.373318,	0.478256,2.5728,0.478256,	0.545131,2.5728,0.400065,
	0.599396,2.5728,0.31185,	0.467878,2.5974,0.243424,	0.425519,2.5974,0.312283,
	0.425519,2.5974,0.312283,	0.545131,2.5728,0.400065,	0.599396,2.5728,0.31185,
	0.639758,2.5728,0.214905,	0.499384,2.5974,0.167751,	0.467878,2.5974,0.243424,
	0.467878,2.5974,0.243424,	0.599396,2.5728,0.31185,	0.639758,2.5728,0.214905,
	0.664924,2.5728,0.110524,	0.519028,2.5974,0.086273,	0.499384,2.5974,0.167751,
	0.499384,2.5974,0.167751,	0.639758,2.5728,0.214905,	0.664924,2.5728,0.110524,
	0.6736,2.5728,0,	0.5258,2.5974,0,	0.519028,2.5974,0.086273,
	0.519028,2.5974,0.086273,	0.664924,2.5728,0.110524,	0.6736,2.5728,0,
	0.135366,2.55,0.814374,	0.110524,2.5728,0.664924,	0,2.5728,0.6736,
	0,2.5728,0.6736,	0,2.55,0.825,	0.135366,2.55,0.814374,
	0.263208,2.55,0.783552,	0.214905,2.5728,0.639758,	0.110524,2.5728,0.664924,
	0.110524,2.5728,0.664924,	0.135366,2.55,0.814374,	0.263208,2.55,0.783552,
	0.381942,2.55,0.734118,	0.31185,2.5728,0.599396,	0.214905,2.5728,0.639758,
	0.214905,2.5728,0.639758,	0.263208,2.55,0.783552,	0.381942,2.55,0.734118,
	0.489984,2.55,0.667656,	0.400065,2.5728,0.545131,	0.31185,2.5728,0.599396,
	0.31185,2.5728,0.599396,	0.381942,2.55,0.734118,	0.489984,2.55,0.667656,
	0.58575,2.55,0.58575,	0.478256,2.5728,0.478256,	0.400065,2.5728,0.545131,
	0.400065,2.5728,0.545131,	0.489984,2.55,0.667656,	0.58575,2.55,0.58575,
	0.667656,2.55,0.489984,	0.545131,2.5728,0.400065,	0.478256,2.5728,0.478256,
	0.478256,2.5728,0.478256,	0.58575,2.55,0.58575,	0.667656,2.55,0.489984,
	0.734118,2.55,0.381942,	0.599396,2.5728,0.31185,	0.545131,2.5728,0.400065,
	0.545131,2.5728,0.400065,	0.667656,2.55,0.489984,	0.734118,2.55,0.381942,
	0.783552,2.55,0.263208,	0.639758,2.5728,0.214905,	0.599396,2.5728,0.31185,
	0.599396,2.5728,0.31185,	0.734118,2.55,0.381942,	0.783552,2.55,0.263208,
	0.814374,2.55,0.135366,	0.664924,2.5728,0.110524,	0.639758,2.5728,0.214905,
	0.639758,2.5728,0.214905,	0.783552,2.55,0.263208,	0.814374,2.55,0.135366,
	0.825,2.55,0,	0.6736,2.5728,0,	0.664924,2.5728,0.110524,
	0.664924,2.5728,0.110524,	0.814374,2.55,0.135366,	0.825,2.55,0,
	0.159223,2.5272,0.957901,	0.135366,2.55,0.814374,	0,2.55,0.825,
	0,2.55,0.825,	0,2.5272,0.9704,	0.159223,2.5272,0.957901,
	0.309596,2.5272,0.921647,	0.263208,2.55,0.783552,	0.135366,2.55,0.814374,
	0.135366,2.55,0.814374,	0.159223,2.5272,0.957901,	0.309596,2.5272,0.921647,
	0.449256,2.5272,0.863501,	0.381942,2.55,0.734118,	0.263208,2.55,0.783552,
	0.263208,2.55,0.783552,	0.309596,2.5272,0.921647,	0.449256,2.5272,0.863501,
	0.57634,2.5272,0.785325,	0.489984,2.55,0.667656,	0.381942,2.55,0.734118,
	0.381942,2.55,0.734118,	0.449256,2.5272,0.863501,	0.57634,2.5272,0.785325,
	0.688984,2.5272,0.688984,	0.58575,2.55,0.58575,	0.489984,2.55,0.667656,
	0.489984,2.55,0.667656,	0.57634,2.5272,0.785325,	0.688984,2.5272,0.688984,
	0.785325,2.5272,0.57634,	0.667656,2.55,0.489984,	0.58575,2.55,0.58575,
	0.58575,2.55,0.58575,	0.688984,2.5272,0.688984,	0.785325,2.5272,0.57634,
	0.863501,2.5272,0.449256,	0.734118,2.55,0.381942,	0.667656,2.55,0.489984,
	0.667656,2.55,0.489984,	0.785325,2.5272,0.57634,	0.863501,2.5272,0.449256,
	0.921647,2.5272,0.309596,	0.783552,2.55,0.263208,	0.734118,2.55,0.381942,
	0.734118,2.55,0.381942,	0.863501,2.5272,0.449256,	0.921647,2.5272,0.309596,
	0.957901,2.5272,0.159223,	0.814374,2.55,0.135366,	0.783552,2.55,0.263208,
	0.783552,2.55,0.263208,	0.921647,2.5272,0.309596,	0.957901,2.5272,0.159223,
	0.9704,2.5272,0,	0.825,2.55,0,	0.814374,2.55,0.135366,
	0.814374,2.55,0.135366,	0.957901,2.5272,0.159223,	0.9704,2.5272,0,
	0.180521,2.5026,1.086029,	0.159223,2.5272,0.957901,	0,2.5272,0.9704,
	0,2.5272,0.9704,	0,2.5026,1.1002,	0.180521,2.5026,1.086029,
	0.351008,2.5026,1.044926,	0.309596,2.5272,0.921647,	0.159223,2.5272,0.957901,
	0.159223,2.5272,0.957901,	0.180521,2.5026,1.086029,	0.351008,2.5026,1.044926,
	0.509349,2.5026,0.979002,	0.449256,2.5272,0.863501,	0.309596,2.5272,0.921647,
	0.309596,2.5272,0.921647,	0.351008,2.5026,1.044926,	0.509349,2.5026,0.979002,
	0.653431,2.5026,0.89037,	0.57634,2.5272,0.785325,	0.449256,2.5272,0.863501,
	0.449256,2.5272,0.863501,	0.509349,2.5026,0.979002,	0.653431,2.5026,0.89037,
	0.781142,2.5026,0.781142,	0.688984,2.5272,0.688984,	0.57634,2.5272,0.785325,
	0.57634,2.5272,0.785325,	0.653431,2.5026,0.89037,	0.781142,2.5026,0.781142,
	0.89037,2.5026,0.653431,	0.785325,2.5272,0.57634,	0.688984,2.5272,0.688984,
	0.688984,2.5272,0.688984,	0.781142,2.5026,0.781142,	0.89037,2.5026,0.653431,
	0.979002,2.5026,0.509349,	0.863501,2.5272,0.449256,	0.785325,2.5272,0.57634,
	0.785325,2.5272,0.57634,	0.89037,2.5026,0.653431,	0.979002,2.5026,0.509349,
	1.044926,2.5026,0.351008,	0.921647,2.5272,0.309596,	0.863501,2.5272,0.449256,
	0.863501,2.5272,0.449256,	0.979002,2.5026,0.509349,	1.044926,2.5026,0.351008,
	1.086029,2.5026,0.180521,	0.957901,2.5272,0.159223,	0.921647,2.5272,0.309596,
	0.921647,2.5272,0.309596,	1.044926,2.5026,0.351008,	1.086029,2.5026,0.180521,
	1.1002,2.5026,0,	0.9704,2.5272,0,	0.957901,2.5272,0.159223,
	0.957901,2.5272,0.159223,	1.086029,2.5026,0.180521,	1.1002,2.5026,0,
	0.197684,2.4744,1.189282,	0.180521,2.5026,1.086029,	0,2.5026,1.1002,
	0,2.5026,1.1002,	0,2.4744,1.2048,	0.197684,2.4744,1.189282,
	0.384379,2.4744,1.144271,	0.351008,2.5026,1.044926,	0.180521,2.5026,1.086029,
	0.180521,2.5026,1.086029,	0.197684,2.4744,1.189282,	0.384379,2.4744,1.144271,
	0.557774,2.4744,1.072079,	0.509349,2.5026,0.979002,	0.351008,2.5026,1.044926,
	0.351008,2.5026,1.044926,	0.384379,2.4744,1.144271,	0.557774,2.4744,1.072079,
	0.715555,2.4744,0.975021,	0.653431,2.5026,0.89037,	0.509349,2.5026,0.979002,
	0.509349,2.5026,0.979002,	0.557774,2.4744,1.072079,	0.715555,2.4744,0.975021,
	0.855408,2.4744,0.855408,	0.781142,2.5026,0.781142,	0.653431,2.5026,0.89037,
	0.653431,2.5026,0.89037,	0.715555,2.4744,0.975021,	0.855408,2.4744,0.855408,
	0.975021,2.4744,0.715555,	0.89037,2.5026,0.653431,	0.781142,2.5026,0.781142,
	0.781142,2.5026,0.781142,	0.855408,2.4744,0.855408,	0.975021,2.4744,0.715555,
	1.072079,2.4744,0.557774,	0.979002,2.5026,0.509349,	0.89037,2.5026,0.653431,
	0.89037,2.5026,0.653431,	0.975021,2.4744,0.715555,	1.072079,2.4744,0.557774,
	1.144271,2.4744,0.384379,	1.044926,2.5026,0.351008,	0.979002,2.5026,0.509349,
	0.979002,2.5026,0.509349,	1.072079,2.4744,0.557774,	1.144271,2.4744,0.384379,
	1.189282,2.4744,0.197684,	1.086029,2.5026,0.180521,	1.044926,2.5026,0.351008,
	1.044926,2.5026,0.351008,	1.144271,2.4744,0.384379,	1.189282,2.4744,0.197684,
	1.2048,2.4744,0,	1.1002,2.5026,0,	1.086029,2.5026,0.180521,
	1.086029,2.5026,0.180521,	1.189282,2.4744,0.197684,	1.2048,2.4744,0,
	0.209136,2.4408,1.258183,	0.197684,2.4744,1.189282,	0,2.4744,1.2048,
	0,2.4744,1.2048,	0,2.4408,1.2746,	0.209136,2.4408,1.258183,
	0.406648,2.4408,1.210564,	0.384379,2.4744,1.144271,	0.197684,2.4744,1.189282,
	0.197684,2.4744,1.189282,	0.209136,2.4408,1.258183,	0.406648,2.4408,1.210564,
	0.590089,2.4408,1.13419,	0.557774,2.4744,1.072079,	0.384379,2.4744,1.144271,
	0.384379,2.4744,1.144271,	0.406648,2.4408,1.210564,	0.590089,2.4408,1.13419,
	0.75701,2.4408,1.031508,	0.715555,2.4744,0.975021,	0.557774,2.4744,1.072079,
	0.557774,2.4744,1.072079,	0.590089,2.4408,1.13419,	0.75701,2.4408,1.031508,
	0.904966,2.4408,0.904966,	0.855408,2.4744,0.855408,	0.715555,2.4744,0.975021,
	0.715555,2.4744,0.975021,	0.75701,2.4408,1.031508,	0.904966,2.4408,0.904966,
	1.031508,2.4408,0.75701,	0.975021,2.4744,0.715555,	0.855408,2.4744,0.855408,
	0.855408,2.4744,0.855408,	0.904966,2.4408,0.904966,	1.031508,2.4408,0.75701,
	1.13419,2.4408,0.590089,	1.072079,2.4744,0.557774,	0.975021,2.4744,0.715555,
	0.975021,2.4744,0.715555,	1.031508,2.4408,0.75701,	1.13419,2.4408,0.590089,
	1.210564,2.4408,0.406648,	1.144271,2.4744,0.384379,	1.072079,2.4744,0.557774,
	1.072079,2.4744,0.557774,	1.13419,2.4408,0.590089,	1.210564,2.4408,0.406648,
	1.258183,2.4408,0.209136,	1.189282,2.4744,0.197684,	1.144271,2.4744,0.384379,
	1.144271,2.4744,0.384379,	1.210564,2.4408,0.406648,	1.258183,2.4408,0.209136,
	1.2746,2.4408,0,	1.2048,2.4744,0,	1.189282,2.4744,0.197684,
	1.189282,2.4744,0.197684,	1.258183,2.4408,0.209136,	1.2746,2.4408,0,
	0.213304,2.4,1.283256,	0.209136,2.4408,1.258183,	0,2.4408,1.2746,
	0,2.4408,1.2746,	0,2.4,1.3,	0.213304,2.4,1.283256,
	0.414752,2.4,1.234688,	0.406648,2.4408,1.210564,	0.209136,2.4408,1.258183,
	0.209136,2.4408,1.258183,	0.213304,2.4,1.283256,	0.414752,2.4,1.234688,
	0.601848,2.4,1.156792,	0.590089,2.4408,1.13419,	0.406648,2.4408,1.210564,
	0.406648,2.4408,1.210564,	0.414752,2.4,1.234688,	0.601848,2.4,1.156792,
	0.772096,2.4,1.052064,	0.75701,2.4408,1.031508,	0.590089,2.4408,1.13419,
	0.590089,2.4408,1.13419,	0.601848,2.4,1.156792,	0.772096,2.4,1.052064,
	0.923,2.4,0.923,	0.904966,2.4408,0.904966,	0.75701,2.4408,1.031508,
	0.75701,2.4408,1.031508,	0.772096,2.4,1.052064,	0.923,2.4,0.923,
	1.052064,2.4,0.772096,	1.031508,2.4408,0.75701,	0.904966,2.4408,0.904966,
	0.904966,2.4408,0.904966,	0.923,2.4,0.923,	1.052064,2.4,0.772096,
	1.156792,2.4,0.601848,	1.13419,2.4408,0.590089,	1.031508,2.4408,0.75701,
	1.031508,2.4408,0.75701,	1.052064,2.4,0.772096,	1.156792,2.4,0.601848,
	1.234688,2.4,0.414752,	1.210564,2.4408,0.406648,	1.13419,2.4408,0.590089,
	1.13419,2.4408,0.590089,	1.156792,2.4,0.601848,	1.234688,2.4,0.414752,
	1.283256,2.4,0.213304,	1.258183,2.4408,0.209136,	1.210564,2.4408,0.406648,
	1.210564,2.4408,0.406648,	1.234688,2.4,0.414752,	1.283256,2.4,0.213304,
	1.3,2.4,0,	1.2746,2.4408,0,	1.258183,2.4408,0.209136,
	1.258183,2.4408,0.209136,	1.283256,2.4,0.213304,	1.3,2.4,0,
	0,0,0,	0.388275,0.002175,0,	0.383274,0.002175,0.063708,
	0,0,0,	0.383274,0.002175,0.063708,	0.368768,0.002175,0.123875,
	0,0,0,	0.368768,0.002175,0.123875,	0.345503,0.002175,0.179756,
	0,0,0,	0.345503,0.002175,0.179756,	0.314223,0.002175,0.230604,
	0,0,0,	0.314223,0.002175,0.230604,	0.275675,0.002175,0.275675,
	0,0,0,	0.275675,0.002175,0.275675,	0.230604,0.002175,0.314223,
	0,0,0,	0.230604,0.002175,0.314223,	0.179756,0.002175,0.345503,
	0,0,0,	0.179756,0.002175,0.345503,	0.123875,0.002175,0.368768,
	0,0,0,	0.123875,0.002175,0.368768,	0.063708,0.002175,0.383274,
	0,0,0,	0.063708,0.002175,0.383274,	0,0.002175,0.388275,
	0.694143,0.0084,0.115381,	0.383274,0.002175,0.063708,	0.388275,0.002175,0,
	0.388275,0.002175,0,	0.7032,0.0084,0,	0.694143,0.0084,0.115381,
	0.667871,0.0084,0.224349,	0.368768,0.002175,0.123875,	0.383274,0.002175,0.063708,
	0.383274,0.002175,0.063708,	0.694143,0.0084,0.115381,	0.667871,0.0084,0.224349,
	0.625735,0.0084,0.325553,	0.345503,0.002175,0.179756,	0.368768,0.002175,0.123875,
	0.368768,0.002175,0.123875,	0.667871,0.0084,0.224349,	0.625735,0.0084,0.325553,
	0.569086,0.0084,0.417645,	0.314223,0.002175,0.230604,	0.345503,0.002175,0.179756,
	0.345503,0.002175,0.179756,	0.625735,0.0084,0.325553,	0.569086,0.0084,0.417645,
	0.499272,0.0084,0.499272,	0.275675,0.002175,0.275675,	0.314223,0.002175,0.230604,
	0.314223,0.002175,0.230604,	0.569086,0.0084,0.417645,	0.499272,0.0084,0.499272,
	0.417645,0.0084,0.569086,	0.230604,0.002175,0.314223,	0.275675,0.002175,0.275675,
	0.275675,0.002175,0.275675,	0.499272,0.0084,0.499272,	0.417645,0.0084,0.569086,
	0.325553,0.0084,0.625735,	0.179756,0.002175,0.345503,	0.230604,0.002175,0.314223,
	0.230604,0.002175,0.314223,	0.417645,0.0084,0.569086,	0.325553,0.0084,0.625735,
	0.224349,0.0084,0.667871,	0.123875,0.002175,0.368768,	0.179756,0.002175,0.345503,
	0.179756,0.002175,0.345503,	0.325553,0.0084,0.625735,	0.224349,0.0084,0.667871,
	0.115381,0.0084,0.694143,	0.063708,0.002175,0.383274,	0.123875,0.002175,0.368768,
	0.123875,0.002175,0.368768,	0.224349,0.0084,0.667871,	0.115381,0.0084,0.694143,
	0,0.0084,0.7032,	0,0.002175,0.388275,	0.063708,0.002175,0.383274,
	0.063708,0.002175,0.383274,	0.115381,0.0084,0.694143,	0,0.0084,0.7032,
	0.940158,0.018225,0.156274,	0.694143,0.0084,0.115381,	0.7032,0.0084,0,
	0.7032,0.0084,0,	0.952425,0.018225,0,	0.940158,0.018225,0.156274,
	0.904575,0.018225,0.303862,	0.667871,0.0084,0.224349,	0.694143,0.0084,0.115381,
	0.694143,0.0084,0.115381,	0.940158,0.018225,0.156274,	0.904575,0.018225,0.303862,
	0.847506,0.018225,0.440935,	0.625735,0.0084,0.325553,	0.667871,0.0084,0.224349,
	0.667871,0.0084,0.224349,	0.904575,0.018225,0.303862,	0.847506,0.018225,0.440935,
	0.770779,0.018225,0.565664,	0.569086,0.0084,0.417645,	0.625735,0.0084,0.325553,
	0.625735,0.0084,0.325553,	0.847506,0.018225,0.440935,	0.770779,0.018225,0.565664,
	0.676222,0.018225,0.676222,	0.499272,0.0084,0.499272,	0.569086,0.0084,0.417645,
	0.569086,0.0084,0.417645,	0.770779,0.018225,0.565664,	0.676222,0.018225,0.676222,
	0.565664,0.018225,0.770779,	0.417645,0.0084,0.569086,	0.499272,0.0084,0.499272,
	0.499272,0.0084,0.499272,	0.676222,0.018225,0.676222,	0.565664,0.018225,0.770779,
	0.440935,0.018225,0.847506,	0.325553,0.0084,0.625735,	0.417645,0.0084,0.569086,
	0.417645,0.0084,0.569086,	0.565664,0.018225,0.770779,	0.440935,0.018225,0.847506,
	0.303862,0.018225,0.904575,	0.224349,0.0084,0.667871,	0.325553,0.0084,0.625735,
	0.325553,0.0084,0.625735,	0.440935,0.018225,0.847506,	0.303862,0.018225,0.904575,
	0.156274,0.018225,0.940158,	0.115381,0.0084,0.694143,	0.224349,0.0084,0.667871,
	0.224349,0.0084,0.667871,	0.303862,0.018225,0.904575,	0.156274,0.018225,0.940158,
	0,0.018225,0.952425,	0,0.0084,0.7032,	0.115381,0.0084,0.694143,
	0.115381,0.0084,0.694143,	0.156274,0.018225,0.940158,	0,0.018225,0.952425,
	1.12887,0.0312,0.187642,	0.940158,0.018225,0.156274,	0.952425,0.018225,0,
	0.952425,0.018225,0,	1.1436,0.0312,0,	1.12887,0.0312,0.187642,
	1.086146,0.0312,0.364854,	0.904575,0.018225,0.303862,	0.940158,0.018225,0.156274,
	0.940158,0.018225,0.156274,	1.12887,0.0312,0.187642,	1.086146,0.0312,0.364854,
	1.017621,0.0312,0.529441,	0.847506,0.018225,0.440935,	0.904575,0.018225,0.303862,
	0.904575,0.018225,0.303862,	1.086146,0.0312,0.364854,	1.017621,0.0312,0.529441,
	0.925493,0.0312,0.679207,	0.770779,0.018225,0.565664,	0.847506,0.018225,0.440935,
	0.847506,0.018225,0.440935,	1.017621,0.0312,0.529441,	0.925493,0.0312,0.679207,
	0.811956,0.0312,0.811956,	0.676222,0.018225,0.676222,	0.770779,0.018225,0.565664,
	0.770779,0.018225,0.565664,	0.925493,0.0312,0.679207,	0.811956,0.0312,0.811956,
	0.679207,0.0312,0.925493,	0.565664,0.018225,0.770779,	0.676222,0.018225,0.676222,
	0.676222,0.018225,0.676222,	0.811956,0.0312,0.811956,	0.679207,0.0312,0.925493,
	0.529441,0.0312,1.017621,	0.440935,0.018225,0.847506,	0.565664,0.018225,0.770779,
	0.565664,0.018225,0.770779,	0.679207,0.0312,0.925493,	0.529441,0.0312,1.017621,
	0.364854,0.0312,1.086146,	0.303862,0.018225,0.904575,	0.440935,0.018225,0.847506,
	0.440935,0.018225,0.847506,	0.529441,0.0312,1.017621,	0.364854,0.0312,1.086146,
	0.187642,0.0312,1.12887,	0.156274,0.018225,0.940158,	0.303862,0.018225,0.904575,
	0.303862,0.018225,0.904575,	0.364854,0.0312,1.086146,	0.187642,0.0312,1.12887,
	0,0.0312,1.1436,	0,0.018225,0.952425,	0.156274,0.018225,0.940158,
	0.156274,0.018225,0.940158,	0.187642,0.0312,1.12887,	0,0.0312,1.1436,
	1.267832,0.046875,0.21074,	1.12887,0.0312,0.187642,	1.1436,0.0312,0,
	1.1436,0.0312,0,	1.284375,0.046875,0,	1.267832,0.046875,0.21074,
	1.219848,0.046875,0.409767,	1.086146,0.0312,0.364854,	1.12887,0.0312,0.187642,
	1.12887,0.0312,0.187642,	1.267832,0.046875,0.21074,	1.219848,0.046875,0.409767,
	1.142888,0.046875,0.594614,	1.017621,0.0312,0.529441,	1.086146,0.0312,0.364854,
	1.086146,0.0312,0.364854,	1.219848,0.046875,0.409767,	1.142888,0.046875,0.594614,
	1.039419,0.046875,0.762816,	0.925493,0.0312,0.679207,	1.017621,0.0312,0.529441,
	1.017621,0.0312,0.529441,	1.142888,0.046875,0.594614,	1.039419,0.046875,0.762816,
	0.911906,0.046875,0.911906,	0.811956,0.0312,0.811956,	0.925493,0.0312,0.679207,
	0.925493,0.0312,0.679207,	1.039419,0.046875,0.762816,	0.911906,0.046875,0.911906,
	0.762816,0.046875,1.039419,	0.679207,0.0312,0.925493,	0.811956,0.0312,0.811956,
	0.811956,0.0312,0.811956,	0.911906,0.046875,0.911906,	0.762816,0.046875,1.039419,
	0.594614,0.046875,1.142888,	0.529441,0.0312,1.017621,	0.679207,0.0312,0.925493,
	0.679207,0.0312,0.925493,	0.762816,0.046875,1.039419,	0.594614,0.046875,1.142888,
	0.409767,0.046875,1.219848,	0.364854,0.0312,1.086146,	0.529441,0.0312,1.017621,
	0.529441,0.0312,1.017621,	0.594614,0.046875,1.142888,	0.409767,0.046875,1.219848,
	0.21074,0.046875,1.267832,	0.187642,0.0312,1.12887,	0.364854,0.0312,1.086146,
	0.364854,0.0312,1.086146,	0.409767,0.046875,1.219848,	0.21074,0.046875,1.267832,
	0,0.046875,1.284375,	0,0.0312,1.1436,	0.187642,0.0312,1.12887,
	0.187642,0.0312,1.12887,	0.21074,0.046875,1.267832,	0,0.046875,1.284375,
	1.364595,0.0648,0.226824,	1.267832,0.046875,0.21074,	1.284375,0.046875,0,
	1.284375,0.046875,0,	1.3824,0.0648,0,	1.364595,0.0648,0.226824,
	1.312948,0.0648,0.441041,	1.219848,0.046875,0.409767,	1.267832,0.046875,0.21074,
	1.267832,0.046875,0.21074,	1.364595,0.0648,0.226824,	1.312948,0.0648,0.441041,
	1.230115,0.0648,0.639996,	1.142888,0.046875,0.594614,	1.219848,0.046875,0.409767,
	1.219848,0.046875,0.409767,	1.312948,0.0648,0.441041,	1.230115,0.0648,0.639996,
	1.118749,0.0648,0.821035,	1.039419,0.046875,0.762816,	1.142888,0.046875,0.594614,
	1.142888,0.046875,0.594614,	1.230115,0.0648,0.639996,	1.118749,0.0648,0.821035,
	0.981504,0.0648,0.981504,	0.911906,0.046875,0.911906,	1.039419,0.046875,0.762816,
	1.039419,0.046875,0.762816,	1.118749,0.0648,0.821035,	0.981504,0.0648,0.981504,
	0.821035,0.0648,1.118749,	0.762816,0.046875,1.039419,	0.911906,0.046875,0.911906,
	0.911906,0.046875,0.911906,	0.981504,0.0648,0.981504,	0.821035,0.0648,1.118749,
	0.639996,0.0648,1.230115,	0.594614,0.046875,1.142888,	0.762816,0.046875,1.039419,
	0.762816,0.046875,1.039419,	0.821035,0.0648,1.118749,	0.639996,0.0648,1.230115,
	0.441041,0.0648,1.312948,	0.409767,0.046875,1.219848,	0.594614,0.046875,1.142888,
	0.594614,0.046875,1.142888,	0.639996,0.0648,1.230115,	0.441041,0.0648,1.312948,
	0.226824,0.0648,1.364595,	0.21074,0.046875,1.267832,	0.409767,0.046875,1.219848,
	0.409767,0.046875,1.219848,	0.441041,0.0648,1.312948,	0.226824,0.0648,1.364595,
	0,0.0648,1.3824,	0,0.046875,1.284375,	0.21074,0.046875,1.267832,
	0.21074,0.046875,1.267832,	0.226824,0.0648,1.364595,	0,0.0648,1.3824,
	1.426709,0.084525,0.237149,	1.364595,0.0648,0.226824,	1.3824,0.0648,0,
	1.3824,0.0648,0,	1.445325,0.084525,0,	1.426709,0.084525,0.237149,
	1.372712,0.084525,0.461116,	1.312948,0.0648,0.441041,	1.364595,0.0648,0.226824,
	1.364595,0.0648,0.226824,	1.426709,0.084525,0.237149,	1.372712,0.084525,0.461116,
	1.286108,0.084525,0.669128,	1.230115,0.0648,0.639996,	1.312948,0.0648,0.441041,
	1.312948,0.0648,0.441041,	1.372712,0.084525,0.461116,	1.286108,0.084525,0.669128,
	1.169673,0.084525,0.858407,	1.118749,0.0648,0.821035,	1.230115,0.0648,0.639996,
	1.230115,0.0648,0.639996,	1.286108,0.084525,0.669128,	1.169673,0.084525,0.858407,
	1.026181,0.084525,1.026181,	0.981504,0.0648,0.981504,	1.118749,0.0648,0.821035,
	1.118749,0.0648,0.821035,	1.169673,0.084525,0.858407,	1.026181,0.084525,1.026181,
	0.858407,0.084525,1.169673,	0.821035,0.0648,1.118749,	0.981504,0.0648,0.981504,
	0.981504,0.0648,0.981504,	1.026181,0.084525,1.026181,	0.858407,0.084525,1.169673,
	0.669128,0.084525,1.286108,	0.639996,0.0648,1.230115,	0.821035,0.0648,1.118749,
	0.821035,0.0648,1.118749,	0.858407,0.084525,1.169673,	0.669128,0.084525,1.286108,
	0.461116,0.084525,1.372712,	0.441041,0.0648,1.312948,	0.639996,0.0648,1.230115,
	0.639996,0.0648,1.230115,	0.669128,0.084525,1.286108,	0.461116,0.084525,1.372712,
	0.237149,0.084525,1.426709,	0.226824,0.0648,1.364595,	0.441041,0.0648,1.312948,
	0.441041,0.0648,1.312948,	0.461116,0.084525,1.372712,	0.237149,0.084525,1.426709,
	0,0.084525,1.445325,	0,0.0648,1.3824,	0.226824,0.0648,1.364595,
	0.226824,0.0648,1.364595,	0.237149,0.084525,1.426709,	0,0.084525,1.445325,
	1.461727,0.1056,0.24297,	1.426709,0.084525,0.237149,	1.445325,0.084525,0,
	1.445325,0.084525,0,	1.4808,0.1056,0,	1.461727,0.1056,0.24297,
	1.406405,0.1056,0.472434,	1.372712,0.084525,0.461116,	1.426709,0.084525,0.237149,
	1.426709,0.084525,0.237149,	1.461727,0.1056,0.24297,	1.406405,0.1056,0.472434,
	1.317675,0.1056,0.685551,	1.286108,0.084525,0.669128,	1.372712,0.084525,0.461116,
	1.372712,0.084525,0.461116,	1.406405,0.1056,0.472434,	1.317675,0.1056,0.685551,
	1.198382,0.1056,0.879477,	1.169673,0.084525,0.858407,	1.286108,0.084525,0.669128,
	1.286108,0.084525,0.669128,	1.317675,0.1056,0.685551,	1.198382,0.1056,0.879477,
	1.051368,0.1056,1.051368,	1.026181,0.084525,1.026181,	1.169673,0.084525,0.858407,
	1.169673,0.084525,0.858407,	1.198382,0.1056,0.879477,	1.051368,0.1056,1.051368,
	0.879477,0.1056,1.198382,	0.858407,0.084525,1.169673,	1.026181,0.084525,1.026181,
	1.026181,0.084525,1.026181,	1.051368,0.1056,1.051368,	0.879477,0.1056,1.198382,
	0.685551,0.1056,1.317675,	0.669128,0.084525,1.286108,	0.858407,0.084525,1.169673,
	0.858407,0.084525,1.169673,	0.879477,0.1056,1.198382,	0.685551,0.1056,1.317675,
	0.472434,0.1056,1.406405,	0.461116,0.084525,1.372712,	0.669128,0.084525,1.286108,
	0.669128,0.084525,1.286108,	0.685551,0.1056,1.317675,	0.472434,0.1056,1.406405,
	0.24297,0.1056,1.461727,	0.237149,0.084525,1.426709,	0.461116,0.084525,1.372712,
	0.461116,0.084525,1.372712,	0.472434,0.1056,1.406405,	0.24297,0.1056,1.461727,
	0,0.1056,1.4808,	0,0.084525,1.445325,	0.237149,0.084525,1.426709,
	0.237149,0.084525,1.426709,	0.24297,0.1056,1.461727,	0,0.1056,1.4808,
	1.4772,0.127575,0.245542,	1.461727,0.1056,0.24297,	1.4808,0.1056,0,
	1.4808,0.1056,0,	1.496475,0.127575,0,	1.4772,0.127575,0.245542,
	1.421292,0.127575,0.477435,	1.406405,0.1056,0.472434,	1.461727,0.1056,0.24297,
	1.461727,0.1056,0.24297,	1.4772,0.127575,0.245542,	1.421292,0.127575,0.477435,
	1.331623,0.127575,0.692808,	1.317675,0.1056,0.685551,	1.406405,0.1056,0.472434,
	1.406405,0.1056,0.472434,	1.421292,0.127575,0.477435,	1.331623,0.127575,0.692808,
	1.211067,0.127575,0.888786,	1.198382,0.1056,0.879477,	1.317675,0.1056,0.685551,
	1.317675,0.1056,0.685551,	1.331623,0.127575,0.692808,	1.211067,0.127575,0.888786,
	1.062497,0.127575,1.062497,	1.051368,0.1056,1.051368,	1.198382,0.1056,0.879477,
	1.198382,0.1056,0.879477,	1.211067,0.127575,0.888786,	1.062497,0.127575,1.062497,
	0.888786,0.127575,1.211067,	0.879477,0.1056,1.198382,	1.051368,0.1056,1.051368,
	1.051368,0.1056,1.051368,	1.062497,0.127575,1.062497,	0.888786,0.127575,1.211067,
	0.692808,0.127575,1.331623,	0.685551,0.1056,1.317675,	0.879477,0.1056,1.198382,
	0.879477,0.1056,1.198382,	0.888786,0.127575,1.211067,	0.692808,0.127575,1.331623,
	0.477435,0.127575,1.421292,	0.472434,0.1056,1.406405,	0.685551,0.1056,1.317675,
	0.685551,0.1056,1.317675,	0.692808,0.127575,1.331623,	0.477435,0.127575,1.421292,
	0.245542,0.127575,1.4772,	0.24297,0.1056,1.461727,	0.472434,0.1056,1.406405,
	0.472434,0.1056,1.406405,	0.477435,0.127575,1.421292,	0.245542,0.127575,1.4772,
	0,0.127575,1.496475,	0,0.1056,1.4808,	0.24297,0.1056,1.461727,
	0.24297,0.1056,1.461727,	0.245542,0.127575,1.4772,	0,0.127575,1.496475,
	1.48068,0.15,0.24612,	1.4772,0.127575,0.245542,	1.496475,0.127575,0,
	1.496475,0.127575,0,	1.5,0.15,0,	1.48068,0.15,0.24612,
	1.42464,0.15,0.47856,	1.421292,0.127575,0.477435,	1.4772,0.127575,0.245542,
	1.4772,0.127575,0.245542,	1.48068,0.15,0.24612,	1.42464,0.15,0.47856,
	1.33476,0.15,0.69444,	1.331623,0.127575,0.692808,	1.421292,0.127575,0.477435,
	1.421292,0.127575,0.477435,	1.42464,0.15,0.47856,	1.33476,0.15,0.69444,
	1.21392,0.15,0.89088,	1.211067,0.127575,0.888786,	1.331623,0.127575,0.692808,
	1.331623,0.127575,0.692808,	1.33476,0.15,0.69444,	1.21392,0.15,0.89088,
	1.065,0.15,1.065,	1.062497,0.127575,1.062497,	1.211067,0.127575,0.888786,
	1.211067,0.127575,0.888786,	1.21392,0.15,0.89088,	1.065,0.15,1.065,
	0.89088,0.15,1.21392,	0.888786,0.127575,1.211067,	1.062497,0.127575,1.062497,
	1.062497,0.127575,1.062497,	1.065,0.15,1.065,	0.89088,0.15,1.21392,
	0.69444,0.15,1.33476,	0.692808,0.127575,1.331623,	0.888786,0.127575,1.211067,
	0.888786,0.127575,1.211067,	0.89088,0.15,1.21392,	0.69444,0.15,1.33476,
	0.47856,0.15,1.42464,	0.477435,0.127575,1.421292,	0.692808,0.127575,1.331623,
	0.692808,0.127575,1.331623,	0.69444,0.15,1.33476,	0.47856,0.15,1.42464,
	0.24612,0.15,1.48068,	0.245542,0.127575,1.4772,	0.477435,0.127575,1.421292,
	0.477435,0.127575,1.421292,	0.47856,0.15,1.42464,	0.24612,0.15,1.48068,
	0,0.15,1.5,	0,0.127575,1.496475,	0.245542,0.127575,1.4772,
	0.245542,0.127575,1.4772,	0.24612,0.15,1.48068,	0,0.15,1.5,
	0,0,0,	0,0.002175,0.388275,	-0.063708,0.002175,0.383274,
	0,0,0,	-0.063708,0.002175,0.383274,	-0.123875,0.002175,0.368768,
	0,0,0,	-0.123875,0.002175,0.368768,	-0.179756,0.002175,0.345503,
	0,0,0,	-0.179756,0.002175,0.345503,	-0.230604,0.002175,0.314223,
	0,0,0,	-0.230604,0.002175,0.314223,	-0.275675,0.002175,0.275675,
	0,0,0,	-0.275675,0.002175,0.275675,	-0.314223,0.002175,0.230604,
	0,0,0,	-0.314223,0.002175,0.230604,	-0.345503,0.002175,0.179756,
	0,0,0,	-0.345503,0.002175,0.179756,	-0.368768,0.002175,0.123875,
	0,0,0,	-0.368768,0.002175,0.123875,	-0.383274,0.002175,0.063708,
	0,0,0,	-0.383274,0.002175,0.063708,	-0.388275,0.002175,0,
	-0.115381,0.0084,0.694143,	-0.063708,0.002175,0.383274,	0,0.002175,0.388275,
	0,0.002175,0.388275,	0,0.0084,0.7032,	-0.115381,0.0084,0.694143,
	-0.224349,0.0084,0.667871,	-0.123875,0.002175,0.368768,	-0.063708,0.002175,0.383274,
	-0.063708,0.002175,0.383274,	-0.115381,0.0084,0.694143,	-0.224349,0.0084,0.667871,
	-0.325553,0.0084,0.625735,	-0.179756,0.002175,0.345503,	-0.123875,0.002175,0.368768,
	-0.123875,0.002175,0.368768,	-0.224349,0.0084,0.667871,	-0.325553,0.0084,0.625735,
	-0.417645,0.0084,0.569086,	-0.230604,0.002175,0.314223,	-0.179756,0.002175,0.345503,
	-0.179756,0.002175,0.345503,	-0.325553,0.0084,0.625735,	-0.417645,0.0084,0.569086,
	-0.499272,0.0084,0.499272,	-0.275675,0.002175,0.275675,	-0.230604,0.002175,0.314223,
	-0.230604,0.002175,0.314223,	-0.417645,0.0084,0.569086,	-0.499272,0.0084,0.499272,
	-0.569086,0.0084,0.417645,	-0.314223,0.002175,0.230604,	-0.275675,0.002175,0.275675,
	-0.275675,0.002175,0.275675,	-0.499272,0.0084,0.499272,	-0.569086,0.0084,0.417645,
	-0.625735,0.0084,0.325553,	-0.345503,0.002175,0.179756,	-0.314223,0.002175,0.230604,
	-0.314223,0.002175,0.230604,	-0.569086,0.0084,0.417645,	-0.625735,0.0084,0.325553,
	-0.667871,0.0084,0.224349,	-0.368768,0.002175,0.123875,	-0.345503,0.002175,0.179756,
	-0.345503,0.002175,0.179756,	-0.625735,0.0084,0.325553,	-0.667871,0.0084,0.224349,
	-0.694143,0.0084,0.115381,	-0.383274,0.002175,0.063708,	-0.368768,0.002175,0.123875,
	-0.368768,0.002175,0.123875,	-0.667871,0.0084,0.224349,	-0.694143,0.0084,0.115381,
	-0.7032,0.0084,0,	-0.388275,0.002175,0,	-0.383274,0.002175,0.063708,
	-0.383274,0.002175,0.063708,	-0.694143,0.0084,0.115381,	-0.7032,0.0084,0,
	-0.156274,0.018225,0.940158,	-0.115381,0.0084,0.694143,	0,0.0084,0.7032,
	0,0.0084,0.7032,	0,0.018225,0.952425,	-0.156274,0.018225,0.940158,
	-0.303862,0.018225,0.904575,	-0.224349,0.0084,0.667871,	-0.115381,0.0084,0.694143,
	-0.115381,0.0084,0.694143,	-0.156274,0.018225,0.940158,	-0.303862,0.018225,0.904575,
	-0.440935,0.018225,0.847506,	-0.325553,0.0084,0.625735,	-0.224349,0.0084,0.667871,
	-0.224349,0.0084,0.667871,	-0.303862,0.018225,0.904575,	-0.440935,0.018225,0.847506,
	-0.565664,0.018225,0.770779,	-0.417645,0.0084,0.569086,	-0.325553,0.0084,0.625735,
	-0.325553,0.0084,0.625735,	-0.440935,0.018225,0.847506,	-0.565664,0.018225,0.770779,
	-0.676222,0.018225,0.676222,	-0.499272,0.0084,0.499272,	-0.417645,0.0084,0.569086,
	-0.417645,0.0084,0.569086,	-0.565664,0.018225,0.770779,	-0.676222,0.018225,0.676222,
	-0.770779,0.018225,0.565664,	-0.569086,0.0084,0.417645,	-0.499272,0.0084,0.499272,
	-0.499272,0.0084,0.499272,	-0.676222,0.018225,0.676222,	-0.770779,0.018225,0.565664,
	-0.847506,0.018225,0.440935,	-0.625735,0.0084,0.325553,	-0.569086,0.0084,0.417645,
	-0.569086,0.0084,0.417645,	-0.770779,0.018225,0.565664,	-0.847506,0.018225,0.440935,
	-0.904575,0.018225,0.303862,	-0.667871,0.0084,0.224349,	-0.625735,0.0084,0.325553,
	-0.625735,0.0084,0.325553,	-0.847506,0.018225,0.440935,	-0.904575,0.018225,0.303862,
	-0.940158,0.018225,0.156274,	-0.694143,0.0084,0.115381,	-0.667871,0.0084,0.224349,
	-0.667871,0.0084,0.224349,	-0.904575,0.018225,0.303862,	-0.940158,0.018225,0.156274,
	-0.952425,0.018225,0,	-0.7032,0.0084,0,	-0.694143,0.0084,0.115381,
	-0.694143,0.0084,0.115381,	-0.940158,0.018225,0.156274,	-0.952425,0.018225,0,
	-0.187642,0.0312,1.12887,	-0.156274,0.018225,0.940158,	0,0.018225,0.952425,
	0,0.018225,0.952425,	0,0.0312,1.1436,	-0.187642,0.0312,1.12887,
	-0.364854,0.0312,1.086146,	-0.303862,0.018225,0.904575,	-0.156274,0.018225,0.940158,
	-0.156274,0.018225,0.940158,	-0.187642,0.0312,1.12887,	-0.364854,0.0312,1.086146,
	-0.529441,0.0312,1.017621,	-0.440935,0.018225,0.847506,	-0.303862,0.018225,0.904575,
	-0.303862,0.018225,0.904575,	-0.364854,0.0312,1.086146,	-0.529441,0.0312,1.017621,
	-0.679207,0.0312,0.925493,	-0.565664,0.018225,0.770779,	-0.440935,0.018225,0.847506,
	-0.440935,0.018225,0.847506,	-0.529441,0.0312,1.017621,	-0.679207,0.0312,0.925493,
	-0.811956,0.0312,0.811956,	-0.676222,0.018225,0.676222,	-0.565664,0.018225,0.770779,
	-0.565664,0.018225,0.770779,	-0.679207,0.0312,0.925493,	-0.811956,0.0312,0.811956,
	-0.925493,0.0312,0.679207,	-0.770779,0.018225,0.565664,	-0.676222,0.018225,0.676222,
	-0.676222,0.018225,0.676222,	-0.811956,0.0312,0.811956,	-0.925493,0.0312,0.679207,
	-1.017621,0.0312,0.529441,	-0.847506,0.018225,0.440935,	-0.770779,0.018225,0.565664,
	-0.770779,0.018225,0.565664,	-0.925493,0.0312,0.679207,	-1.017621,0.0312,0.529441,
	-1.086146,0.0312,0.364854,	-0.904575,0.018225,0.303862,	-0.847506,0.018225,0.440935,
	-0.847506,0.018225,0.440935,	-1.017621,0.0312,0.529441,	-1.086146,0.0312,0.364854,
	-1.12887,0.0312,0.187642,	-0.940158,0.018225,0.156274,	-0.904575,0.018225,0.303862,
	-0.904575,0.018225,0.303862,	-1.086146,0.0312,0.364854,	-1.12887,0.0312,0.187642,
	-1.1436,0.0312,0,	-0.952425,0.018225,0,	-0.940158,0.018225,0.156274,
	-0.940158,0.018225,0.156274,	-1.12887,0.0312,0.187642,	-1.1436,0.0312,0,
	-0.21074,0.046875,1.267832,	-0.187642,0.0312,1.12887,	0,0.0312,1.1436,
	0,0.0312,1.1436,	0,0.046875,1.284375,	-0.21074,0.046875,1.267832,
	-0.409767,0.046875,1.219848,	-0.364854,0.0312,1.086146,	-0.187642,0.0312,1.12887,
	-0.187642,0.0312,1.12887,	-0.21074,0.046875,1.267832,	-0.409767,0.046875,1.219848,
	-0.594614,0.046875,1.142888,	-0.529441,0.0312,1.017621,	-0.364854,0.0312,1.086146,
	-0.364854,0.0312,1.086146,	-0.409767,0.046875,1.219848,	-0.594614,0.046875,1.142888,
	-0.762816,0.046875,1.039419,	-0.679207,0.0312,0.925493,	-0.529441,0.0312,1.017621,
	-0.529441,0.0312,1.017621,	-0.594614,0.046875,1.142888,	-0.762816,0.046875,1.039419,
	-0.911906,0.046875,0.911906,	-0.811956,0.0312,0.811956,	-0.679207,0.0312,0.925493,
	-0.679207,0.0312,0.925493,	-0.762816,0.046875,1.039419,	-0.911906,0.046875,0.911906,
	-1.039419,0.046875,0.762816,	-0.925493,0.0312,0.679207,	-0.811956,0.0312,0.811956,
	-0.811956,0.0312,0.811956,	-0.911906,0.046875,0.911906,	-1.039419,0.046875,0.762816,
	-1.142888,0.046875,0.594614,	-1.017621,0.0312,0.529441,	-0.925493,0.0312,0.679207,
	-0.925493,0.0312,0.679207,	-1.039419,0.046875,0.762816,	-1.142888,0.046875,0.594614,
	-1.219848,0.046875,0.409767,	-1.086146,0.0312,0.364854,	-1.017621,0.0312,0.529441,
	-1.017621,0.0312,0.529441,	-1.142888,0.046875,0.594614,	-1.219848,0.046875,0.409767,
	-1.267832,0.046875,0.21074,	-1.12887,0.0312,0.187642,	-1.086146,0.0312,0.364854,
	-1.086146,0.0312,0.364854,	-1.219848,0.046875,0.409767,	-1.267832,0.046875,0.21074,
	-1.284375,0.046875,0,	-1.1436,0.0312,0,	-1.12887,0.0312,0.187642,
	-1.12887,0.0312,0.187642,	-1.267832,0.046875,0.21074,	-1.284375,0.046875,0,
	-0.226824,0.0648,1.364595,	-0.21074,0.046875,1.267832,	0,0.046875,1.284375,
	0,0.046875,1.284375,	0,0.0648,1.3824,	-0.226824,0.0648,1.364595,
	-0.441041,0.0648,1.312948,	-0.409767,0.046875,1.219848,	-0.21074,0.046875,1.267832,
	-0.21074,0.046875,1.267832,	-0.226824,0.0648,1.364595,	-0.441041,0.0648,1.312948,
	-0.639996,0.0648,1.230115,	-0.594614,0.046875,1.142888,	-0.409767,0.046875,1.219848,
	-0.409767,0.046875,1.219848,	-0.441041,0.0648,1.312948,	-0.639996,0.0648,1.230115,
	-0.821035,0.0648,1.118749,	-0.762816,0.046875,1.039419,	-0.594614,0.046875,1.142888,
	-0.594614,0.046875,1.142888,	-0.639996,0.0648,1.230115,	-0.821035,0.0648,1.118749,
	-0.981504,0.0648,0.981504,	-0.911906,0.046875,0.911906,	-0.762816,0.046875,1.039419,
	-0.762816,0.046875,1.039419,	-0.821035,0.0648,1.118749,	-0.981504,0.0648,0.981504,
	-1.118749,0.0648,0.821035,	-1.039419,0.046875,0.762816,	-0.911906,0.046875,0.911906,
	-0.911906,0.046875,0.911906,	-0.981504,0.0648,0.981504,	-1.118749,0.0648,0.821035,
	-1.230115,0.0648,0.639996,	-1.142888,0.046875,0.594614,	-1.039419,0.046875,0.762816,
	-1.039419,0.046875,0.762816,	-1.118749,0.0648,0.821035,	-1.230115,0.0648,0.639996,
	-1.312948,0.0648,0.441041,	-1.219848,0.046875,0.409767,	-1.142888,0.046875,0.594614,
	-1.142888,0.046875,0.594614,	-1.230115,0.0648,0.639996,	-1.312948,0.0648,0.441041,
	-1.364595,0.0648,0.226824,	-1.267832,0.046875,0.21074,	-1.219848,0.046875,0.409767,
	-1.219848,0.046875,0.409767,	-1.312948,0.0648,0.441041,	-1.364595,0.0648,0.226824,
	-1.3824,0.0648,0,	-1.284375,0.046875,0,	-1.267832,0.046875,0.21074,
	-1.267832,0.046875,0.21074,	-1.364595,0.0648,0.226824,	-1.3824,0.0648,0,
	-0.237149,0.084525,1.426709,	-0.226824,0.0648,1.364595,	0,0.0648,1.3824,
	0,0.0648,1.3824,	0,0.084525,1.445325,	-0.237149,0.084525,1.426709,
	-0.461116,0.084525,1.372712,	-0.441041,0.0648,1.312948,	-0.226824,0.0648,1.364595,
	-0.226824,0.0648,1.364595,	-0.237149,0.084525,1.426709,	-0.461116,0.084525,1.372712,
	-0.669128,0.084525,1.286108,	-0.639996,0.0648,1.230115,	-0.441041,0.0648,1.312948,
	-0.441041,0.0648,1.312948,	-0.461116,0.084525,1.372712,	-0.669128,0.084525,1.286108,
	-0.858407,0.084525,1.169673,	-0.821035,0.0648,1.118749,	-0.639996,0.0648,1.230115,
	-0.639996,0.0648,1.230115,	-0.669128,0.084525,1.286108,	-0.858407,0.084525,1.169673,
	-1.026181,0.084525,1.026181,	-0.981504,0.0648,0.981504,	-0.821035,0.0648,1.118749,
	-0.821035,0.0648,1.118749,	-0.858407,0.084525,1.169673,	-1.026181,0.084525,1.026181,
	-1.169673,0.084525,0.858407,	-1.118749,0.0648,0.821035,	-0.981504,0.0648,0.981504,
	-0.981504,0.0648,0.981504,	-1.026181,0.084525,1.026181,	-1.169673,0.084525,0.858407,
	-1.286108,0.084525,0.669128,	-1.230115,0.0648,0.639996,	-1.118749,0.0648,0.821035,
	-1.118749,0.0648,0.821035,	-1.169673,0.084525,0.858407,	-1.286108,0.084525,0.669128,
	-1.372712,0.084525,0.461116,	-1.312948,0.0648,0.441041,	-1.230115,0.0648,0.639996,
	-1.230115,0.0648,0.639996,	-1.286108,0.084525,0.669128,	-1.372712,0.084525,0.461116,
	-1.426709,0.084525,0.237149,	-1.364595,0.0648,0.226824,	-1.312948,0.0648,0.441041,
	-1.312948,0.0648,0.441041,	-1.372712,0.084525,0.461116,	-1.426709,0.084525,0.237149,
	-1.445325,0.084525,0,	-1.3824,0.0648,0,	-1.364595,0.0648,0.226824,
	-1.364595,0.0648,0.226824,	-1.426709,0.084525,0.237149,	-1.445325,0.084525,0,
	-0.24297,0.1056,1.461727,	-0.237149,0.084525,1.426709,	0,0.084525,1.445325,
	0,0.084525,1.445325,	0,0.1056,1.4808,	-0.24297,0.1056,1.461727,
	-0.472434,0.1056,1.406405,	-0.461116,0.084525,1.372712,	-0.237149,0.084525,1.426709,
	-0.237149,0.084525,1.426709,	-0.24297,0.1056,1.461727,	-0.472434,0.1056,1.406405,
	-0.685551,0.1056,1.317675,	-0.669128,0.084525,1.286108,	-0.461116,0.084525,1.372712,
	-0.461116,0.084525,1.372712,	-0.472434,0.1056,1.406405,	-0.685551,0.1056,1.317675,
	-0.879477,0.1056,1.198382,	-0.858407,0.084525,1.169673,	-0.669128,0.084525,1.286108,
	-0.669128,0.084525,1.286108,	-0.685551,0.1056,1.317675,	-0.879477,0.1056,1.198382,
	-1.051368,0.1056,1.051368,	-1.026181,0.084525,1.026181,	-0.858407,0.084525,1.169673,
	-0.858407,0.084525,1.169673,	-0.879477,0.1056,1.198382,	-1.051368,0.1056,1.051368,
	-1.198382,0.1056,0.879477,	-1.169673,0.084525,0.858407,	-1.026181,0.084525,1.026181,
	-1.026181,0.084525,1.026181,	-1.051368,0.1056,1.051368,	-1.198382,0.1056,0.879477,
	-1.317675,0.1056,0.685551,	-1.286108,0.084525,0.669128,	-1.169673,0.084525,0.858407,
	-1.169673,0.084525,0.858407,	-1.198382,0.1056,0.879477,	-1.317675,0.1056,0.685551,
	-1.406405,0.1056,0.472434,	-1.372712,0.084525,0.461116,	-1.286108,0.084525,0.669128,
	-1.286108,0.084525,0.669128,	-1.317675,0.1056,0.685551,	-1.406405,0.1056,0.472434,
	-1.461727,0.1056,0.24297,	-1.426709,0.084525,0.237149,	-1.372712,0.084525,0.461116,
	-1.372712,0.084525,0.461116,	-1.406405,0.1056,0.472434,	-1.461727,0.1056,0.24297,
	-1.4808,0.1056,0,	-1.445325,0.084525,0,	-1.426709,0.084525,0.237149,
	-1.426709,0.084525,0.237149,	-1.461727,0.1056,0.24297,	-1.4808,0.1056,0,
	-0.245542,0.127575,1.4772,	-0.24297,0.1056,1.461727,	0,0.1056,1.4808,
	0,0.1056,1.4808,	0,0.127575,1.496475,	-0.245542,0.127575,1.4772,
	-0.477435,0.127575,1.421292,	-0.472434,0.1056,1.406405,	-0.24297,0.1056,1.461727,
	-0.24297,0.1056,1.461727,	-0.245542,0.127575,1.4772,	-0.477435,0.127575,1.421292,
	-0.692808,0.127575,1.331623,	-0.685551,0.1056,1.317675,	-0.472434,0.1056,1.406405,
	-0.472434,0.1056,1.406405,	-0.477435,0.127575,1.421292,	-0.692808,0.127575,1.331623,
	-0.888786,0.127575,1.211067,	-0.879477,0.1056,1.198382,	-0.685551,0.1056,1.317675,
	-0.685551,0.1056,1.317675,	-0.692808,0.127575,1.331623,	-0.888786,0.127575,1.211067,
	-1.062497,0.127575,1.062497,	-1.051368,0.1056,1.051368,	-0.879477,0.1056,1.198382,
	-0.879477,0.1056,1.198382,	-0.888786,0.127575,1.211067,	-1.062497,0.127575,1.062497,
	-1.211067,0.127575,0.888786,	-1.198382,0.1056,0.879477,	-1.051368,0.1056,1.051368,
	-1.051368,0.1056,1.051368,	-1.062497,0.127575,1.062497,	-1.211067,0.127575,0.888786,
	-1.331623,0.127575,0.692808,	-1.317675,0.1056,0.685551,	-1.198382,0.1056,0.879477,
	-1.198382,0.1056,0.879477,	-1.211067,0.127575,0.888786,	-1.331623,0.127575,0.692808,
	-1.421292,0.127575,0.477435,	-1.406405,0.1056,0.472434,	-1.317675,0.1056,0.685551,
	-1.317675,0.1056,0.685551,	-1.331623,0.127575,0.692808,	-1.421292,0.127575,0.477435,
	-1.4772,0.127575,0.245542,	-1.461727,0.1056,0.24297,	-1.406405,0.1056,0.472434,
	-1.406405,0.1056,0.472434,	-1.421292,0.127575,0.477435,	-1.4772,0.127575,0.245542,
	-1.496475,0.127575,0,	-1.4808,0.1056,0,	-1.461727,0.1056,0.24297,
	-1.461727,0.1056,0.24297,	-1.4772,0.127575,0.245542,	-1.496475,0.127575,0,
	-0.24612,0.15,1.48068,	-0.245542,0.127575,1.4772,	0,0.127575,1.496475,
	0,0.127575,1.496475,	0,0.15,1.5,	-0.24612,0.15,1.48068,
	-0.47856,0.15,1.42464,	-0.477435,0.127575,1.421292,	-0.245542,0.127575,1.4772,
	-0.245542,0.127575,1.4772,	-0.24612,0.15,1.48068,	-0.47856,0.15,1.42464,
	-0.69444,0.15,1.33476,	-0.692808,0.127575,1.331623,	-0.477435,0.127575,1.421292,
	-0.477435,0.127575,1.421292,	-0.47856,0.15,1.42464,	-0.69444,0.15,1.33476,
	-0.89088,0.15,1.21392,	-0.888786,0.127575,1.211067,	-0.692808,0.127575,1.331623,
	-0.692808,0.127575,1.331623,	-0.69444,0.15,1.33476,	-0.89088,0.15,1.21392,
	-1.065,0.15,1.065,	-1.062497,0.127575,1.062497,	-0.888786,0.127575,1.211067,
	-0.888786,0.127575,1.211067,	-0.89088,0.15,1.21392,	-1.065,0.15,1.065,
	-1.21392,0.15,0.89088,	-1.211067,0.127575,0.888786,	-1.062497,0.127575,1.062497,
	-1.062497,0.127575,1.062497,	-1.065,0.15,1.065,	-1.21392,0.15,0.89088,
	-1.33476,0.15,0.69444,	-1.331623,0.127575,0.692808,	-1.211067,0.127575,0.888786,
	-1.211067,0.127575,0.888786,	-1.21392,0.15,0.89088,	-1.33476,0.15,0.69444,
	-1.42464,0.15,0.47856,	-1.421292,0.127575,0.477435,	-1.331623,0.127575,0.692808,
	-1.331623,0.127575,0.692808,	-1.33476,0.15,0.69444,	-1.42464,0.15,0.47856,
	-1.48068,0.15,0.24612,	-1.4772,0.127575,0.245542,	-1.421292,0.127575,0.477435,
	-1.421292,0.127575,0.477435,	-1.42464,0.15,0.47856,	-1.48068,0.15,0.24612,
	-1.5,0.15,0,	-1.496475,0.127575,0,	-1.4772,0.127575,0.245542,
	-1.4772,0.127575,0.245542,	-1.48068,0.15,0.24612,	-1.5,0.15,0,
	0,0,0,	-0.388275,0.002175,0,	-0.383274,0.002175,-0.063708,
	0,0,0,	-0.383274,0.002175,-0.063708,	-0.368768,0.002175,-0.123875,
	0,0,0,	-0.368768,0.002175,-0.123875,	-0.345503,0.002175,-0.179756,
	0,0,0,	-0.345503,0.002175,-0.179756,	-0.314223,0.002175,-0.230604,
	0,0,0,	-0.314223,0.002175,-0.230604,	-0.275675,0.002175,-0.275675,
	0,0,0,	-0.275675,0.002175,-0.275675,	-0.230604,0.002175,-0.314223,
	0,0,0,	-0.230604,0.002175,-0.314223,	-0.179756,0.002175,-0.345503,
	0,0,0,	-0.179756,0.002175,-0.345503,	-0.123875,0.002175,-0.368768,
	0,0,0,	-0.123875,0.002175,-0.368768,	-0.063708,0.002175,-0.383274,
	0,0,0,	-0.063708,0.002175,-0.383274,	0,0.002175,-0.388275,
	-0.694143,0.0084,-0.115381,	-0.383274,0.002175,-0.063708,	-0.388275,0.002175,0,
	-0.388275,0.002175,0,	-0.7032,0.0084,0,	-0.694143,0.0084,-0.115381,
	-0.667871,0.0084,-0.224349,	-0.368768,0.002175,-0.123875,	-0.383274,0.002175,-0.063708,
	-0.383274,0.002175,-0.063708,	-0.694143,0.0084,-0.115381,	-0.667871,0.0084,-0.224349,
	-0.625735,0.0084,-0.325553,	-0.345503,0.002175,-0.179756,	-0.368768,0.002175,-0.123875,
	-0.368768,0.002175,-0.123875,	-0.667871,0.0084,-0.224349,	-0.625735,0.0084,-0.325553,
	-0.569086,0.0084,-0.417645,	-0.314223,0.002175,-0.230604,	-0.345503,0.002175,-0.179756,
	-0.345503,0.002175,-0.179756,	-0.625735,0.0084,-0.325553,	-0.569086,0.0084,-0.417645,
	-0.499272,0.0084,-0.499272,	-0.275675,0.002175,-0.275675,	-0.314223,0.002175,-0.230604,
	-0.314223,0.002175,-0.230604,	-0.569086,0.0084,-0.417645,	-0.499272,0.0084,-0.499272,
	-0.417645,0.0084,-0.569086,	-0.230604,0.002175,-0.314223,	-0.275675,0.002175,-0.275675,
	-0.275675,0.002175,-0.275675,	-0.499272,0.0084,-0.499272,	-0.417645,0.0084,-0.569086,
	-0.325553,0.0084,-0.625735,	-0.179756,0.002175,-0.345503,	-0.230604,0.002175,-0.314223,
	-0.230604,0.002175,-0.314223,	-0.417645,0.0084,-0.569086,	-0.325553,0.0084,-0.625735,
	-0.224349,0.0084,-0.667871,	-0.123875,0.002175,-0.368768,	-0.179756,0.002175,-0.345503,
	-0.179756,0.002175,-0.345503,	-0.325553,0.0084,-0.625735,	-0.224349,0.0084,-0.667871,
	-0.115381,0.0084,-0.694143,	-0.063708,0.002175,-0.383274,	-0.123875,0.002175,-0.368768,
	-0.123875,0.002175,-0.368768,	-0.224349,0.0084,-0.667871,	-0.115381,0.0084,-0.694143,
	0,0.0084,-0.7032,	0,0.002175,-0.388275,	-0.063708,0.002175,-0.383274,
	-0.063708,0.002175,-0.383274,	-0.115381,0.0084,-0.694143,	0,0.0084,-0.7032,
	-0.940158,0.018225,-0.156274,	-0.694143,0.0084,-0.115381,	-0.7032,0.0084,0,
	-0.7032,0.0084,0,	-0.952425,0.018225,0,	-0.940158,0.018225,-0.156274,
	-0.904575,0.018225,-0.303862,	-0.667871,0.0084,-0.224349,	-0.694143,0.0084,-0.115381,
	-0.694143,0.0084,-0.115381,	-0.940158,0.018225,-0.156274,	-0.904575,0.018225,-0.303862,
	-0.847506,0.018225,-0.440935,	-0.625735,0.0084,-0.325553,	-0.667871,0.0084,-0.224349,
	-0.667871,0.0084,-0.224349,	-0.904575,0.018225,-0.303862,	-0.847506,0.018225,-0.440935,
	-0.770779,0.018225,-0.565664,	-0.569086,0.0084,-0.417645,	-0.625735,0.0084,-0.325553,
	-0.625735,0.0084,-0.325553,	-0.847506,0.018225,-0.440935,	-0.770779,0.018225,-0.565664,
	-0.676222,0.018225,-0.676222,	-0.499272,0.0084,-0.499272,	-0.569086,0.0084,-0.417645,
	-0.569086,0.0084,-0.417645,	-0.770779,0.018225,-0.565664,	-0.676222,0.018225,-0.676222,
	-0.565664,0.018225,-0.770779,	-0.417645,0.0084,-0.569086,	-0.499272,0.0084,-0.499272,
	-0.499272,0.0084,-0.499272,	-0.676222,0.018225,-0.676222,	-0.565664,0.018225,-0.770779,
	-0.440935,0.018225,-0.847506,	-0.325553,0.0084,-0.625735,	-0.417645,0.0084,-0.569086,
	-0.417645,0.0084,-0.569086,	-0.565664,0.018225,-0.770779,	-0.440935,0.018225,-0.847506,
	-0.303862,0.018225,-0.904575,	-0.224349,0.0084,-0.667871,	-0.325553,0.0084,-0.625735,
	-0.325553,0.0084,-0.625735,	-0.440935,0.018225,-0.847506,	-0.303862,0.018225,-0.904575,
	-0.156274,0.018225,-0.940158,	-0.115381,0.0084,-0.694143,	-0.224349,0.0084,-0.667871,
	-0.224349,0.0084,-0.667871,	-0.303862,0.018225,-0.904575,	-0.156274,0.018225,-0.940158,
	0,0.018225,-0.952425,	0,0.0084,-0.7032,	-0.115381,0.0084,-0.694143,
	-0.115381,0.0084,-0.694143,	-0.156274,0.018225,-0.940158,	0,0.018225,-0.952425,
	-1.12887,0.0312,-0.187642,	-0.940158,0.018225,-0.156274,	-0.952425,0.018225,0,
	-0.952425,0.018225,0,	-1.1436,0.0312,0,	-1.12887,0.0312,-0.187642,
	-1.086146,0.0312,-0.364854,	-0.904575,0.018225,-0.303862,	-0.940158,0.018225,-0.156274,
	-0.940158,0.018225,-0.156274,	-1.12887,0.0312,-0.187642,	-1.086146,0.0312,-0.364854,
	-1.017621,0.0312,-0.529441,	-0.847506,0.018225,-0.440935,	-0.904575,0.018225,-0.303862,
	-0.904575,0.018225,-0.303862,	-1.086146,0.0312,-0.364854,	-1.017621,0.0312,-0.529441,
	-0.925493,0.0312,-0.679207,	-0.770779,0.018225,-0.565664,	-0.847506,0.018225,-0.440935,
	-0.847506,0.018225,-0.440935,	-1.017621,0.0312,-0.529441,	-0.925493,0.0312,-0.679207,
	-0.811956,0.0312,-0.811956,	-0.676222,0.018225,-0.676222,	-0.770779,0.018225,-0.565664,
	-0.770779,0.018225,-0.565664,	-0.925493,0.0312,-0.679207,	-0.811956,0.0312,-0.811956,
	-0.679207,0.0312,-0.925493,	-0.565664,0.018225,-0.770779,	-0.676222,0.018225,-0.676222,
	-0.676222,0.018225,-0.676222,	-0.811956,0.0312,-0.811956,	-0.679207,0.0312,-0.925493,
	-0.529441,0.0312,-1.017621,	-0.440935,0.018225,-0.847506,	-0.565664,0.018225,-0.770779,
	-0.565664,0.018225,-0.770779,	-0.679207,0.0312,-0.925493,	-0.529441,0.0312,-1.017621,
	-0.364854,0.0312,-1.086146,	-0.303862,0.018225,-0.904575,	-0.440935,0.018225,-0.847506,
	-0.440935,0.018225,-0.847506,	-0.529441,0.0312,-1.017621,	-0.364854,0.0312,-1.086146,
	-0.187642,0.0312,-1.12887,	-0.156274,0.018225,-0.940158,	-0.303862,0.018225,-0.904575,
	-0.303862,0.018225,-0.904575,	-0.364854,0.0312,-1.086146,	-0.187642,0.0312,-1.12887,
	0,0.0312,-1.1436,	0,0.018225,-0.952425,	-0.156274,0.018225,-0.940158,
	-0.156274,0.018225,-0.940158,	-0.187642,0.0312,-1.12887,	0,0.0312,-1.1436,
	-1.267832,0.046875,-0.21074,	-1.12887,0.0312,-0.187642,	-1.1436,0.0312,0,
	-1.1436,0.0312,0,	-1.284375,0.046875,0,	-1.267832,0.046875,-0.21074,
	-1.219848,0.046875,-0.409767,	-1.086146,0.0312,-0.364854,	-1.12887,0.0312,-0.187642,
	-1.12887,0.0312,-0.187642,	-1.267832,0.046875,-0.21074,	-1.219848,0.046875,-0.409767,
	-1.142888,0.046875,-0.594614,	-1.017621,0.0312,-0.529441,	-1.086146,0.0312,-0.364854,
	-1.086146,0.0312,-0.364854,	-1.219848,0.046875,-0.409767,	-1.142888,0.046875,-0.594614,
	-1.039419,0.046875,-0.762816,	-0.925493,0.0312,-0.679207,	-1.017621,0.0312,-0.529441,
	-1.017621,0.0312,-0.529441,	-1.142888,0.046875,-0.594614,	-1.039419,0.046875,-0.762816,
	-0.911906,0.046875,-0.911906,	-0.811956,0.0312,-0.811956,	-0.925493,0.0312,-0.679207,
	-0.925493,0.0312,-0.679207,	-1.039419,0.046875,-0.762816,	-0.911906,0.046875,-0.911906,
	-0.762816,0.046875,-1.039419,	-0.679207,0.0312,-0.925493,	-0.811956,0.0312,-0.811956,
	-0.811956,0.0312,-0.811956,	-0.911906,0.046875,-0.911906,	-0.762816,0.046875,-1.039419,
	-0.594614,0.046875,-1.142888,	-0.529441,0.0312,-1.017621,	-0.679207,0.0312,-0.925493,
	-0.679207,0.0312,-0.925493,	-0.762816,0.046875,-1.039419,	-0.594614,0.046875,-1.142888,
	-0.409767,0.046875,-1.219848,	-0.364854,0.0312,-1.086146,	-0.529441,0.0312,-1.017621,
	-0.529441,0.0312,-1.017621,	-0.594614,0.046875,-1.142888,	-0.409767,0.046875,-1.219848,
	-0.21074,0.046875,-1.267832,	-0.187642,0.0312,-1.12887,	-0.364854,0.0312,-1.086146,
	-0.364854,0.0312,-1.086146,	-0.409767,0.046875,-1.219848,	-0.21074,0.046875,-1.267832,
	0,0.046875,-1.284375,	0,0.0312,-1.1436,	-0.187642,0.0312,-1.12887,
	-0.187642,0.0312,-1.12887,	-0.21074,0.046875,-1.267832,	0,0.046875,-1.284375,
	-1.364595,0.0648,-0.226824,	-1.267832,0.046875,-0.21074,	-1.284375,0.046875,0,
	-1.284375,0.046875,0,	-1.3824,0.0648,0,	-1.364595,0.0648,-0.226824,
	-1.312948,0.0648,-0.441041,	-1.219848,0.046875,-0.409767,	-1.267832,0.046875,-0.21074,
	-1.267832,0.046875,-0.21074,	-1.364595,0.0648,-0.226824,	-1.312948,0.0648,-0.441041,
	-1.230115,0.0648,-0.639996,	-1.142888,0.046875,-0.594614,	-1.219848,0.046875,-0.409767,
	-1.219848,0.046875,-0.409767,	-1.312948,0.0648,-0.441041,	-1.230115,0.0648,-0.639996,
	-1.118749,0.0648,-0.821035,	-1.039419,0.046875,-0.762816,	-1.142888,0.046875,-0.594614,
	-1.142888,0.046875,-0.594614,	-1.230115,0.0648,-0.639996,	-1.118749,0.0648,-0.821035,
	-0.981504,0.0648,-0.981504,	-0.911906,0.046875,-0.911906,	-1.039419,0.046875,-0.762816,
	-1.039419,0.046875,-0.762816,	-1.118749,0.0648,-0.821035,	-0.981504,0.0648,-0.981504,
	-0.821035,0.0648,-1.118749,	-0.762816,0.046875,-1.039419,	-0.911906,0.046875,-0.911906,
	-0.911906,0.046875,-0.911906,	-0.981504,0.0648,-0.981504,	-0.821035,0.0648,-1.118749,
	-0.639996,0.0648,-1.230115,	-0.594614,0.046875,-1.142888,	-0.762816,0.046875,-1.039419,
	-0.762816,0.046875,-1.039419,	-0.821035,0.0648,-1.118749,	-0.639996,0.0648,-1.230115,
	-0.441041,0.0648,-1.312948,	-0.409767,0.046875,-1.219848,	-0.594614,0.046875,-1.142888,
	-0.594614,0.046875,-1.142888,	-0.639996,0.0648,-1.230115,	-0.441041,0.0648,-1.312948,
	-0.226824,0.0648,-1.364595,	-0.21074,0.046875,-1.267832,	-0.409767,0.046875,-1.219848,
	-0.409767,0.046875,-1.219848,	-0.441041,0.0648,-1.312948,	-0.226824,0.0648,-1.364595,
	0,0.0648,-1.3824,	0,0.046875,-1.284375,	-0.21074,0.046875,-1.267832,
	-0.21074,0.046875,-1.267832,	-0.226824,0.0648,-1.364595,	0,0.0648,-1.3824,
	-1.426709,0.084525,-0.237149,	-1.364595,0.0648,-0.226824,	-1.3824,0.0648,0,
	-1.3824,0.0648,0,	-1.445325,0.084525,0,	-1.426709,0.084525,-0.237149,
	-1.372712,0.084525,-0.461116,	-1.312948,0.0648,-0.441041,	-1.364595,0.0648,-0.226824,
	-1.364595,0.0648,-0.226824,	-1.426709,0.084525,-0.237149,	-1.372712,0.084525,-0.461116,
	-1.286108,0.084525,-0.669128,	-1.230115,0.0648,-0.639996,	-1.312948,0.0648,-0.441041,
	-1.312948,0.0648,-0.441041,	-1.372712,0.084525,-0.461116,	-1.286108,0.084525,-0.669128,
	-1.169673,0.084525,-0.858407,	-1.118749,0.0648,-0.821035,	-1.230115,0.0648,-0.639996,
	-1.230115,0.0648,-0.639996,	-1.286108,0.084525,-0.669128,	-1.169673,0.084525,-0.858407,
	-1.026181,0.084525,-1.026181,	-0.981504,0.0648,-0.981504,	-1.118749,0.0648,-0.821035,
	-1.118749,0.0648,-0.821035,	-1.169673,0.084525,-0.858407,	-1.026181,0.084525,-1.026181,
	-0.858407,0.084525,-1.169673,	-0.821035,0.0648,-1.118749,	-0.981504,0.0648,-0.981504,
	-0.981504,0.0648,-0.981504,	-1.026181,0.084525,-1.026181,	-0.858407,0.084525,-1.169673,
	-0.669128,0.084525,-1.286108,	-0.639996,0.0648,-1.230115,	-0.821035,0.0648,-1.118749,
	-0.821035,0.0648,-1.118749,	-0.858407,0.084525,-1.169673,	-0.669128,0.084525,-1.286108,
	-0.461116,0.084525,-1.372712,	-0.441041,0.0648,-1.312948,	-0.639996,0.0648,-1.230115,
	-0.639996,0.0648,-1.230115,	-0.669128,0.084525,-1.286108,	-0.461116,0.084525,-1.372712,
	-0.237149,0.084525,-1.426709,	-0.226824,0.0648,-1.364595,	-0.441041,0.0648,-1.312948,
	-0.441041,0.0648,-1.312948,	-0.461116,0.084525,-1.372712,	-0.237149,0.084525,-1.426709,
	0,0.084525,-1.445325,	0,0.0648,-1.3824,	-0.226824,0.0648,-1.364595,
	-0.226824,0.0648,-1.364595,	-0.237149,0.084525,-1.426709,	0,0.084525,-1.445325,
	-1.461727,0.1056,-0.24297,	-1.426709,0.084525,-0.237149,	-1.445325,0.084525,0,
	-1.445325,0.084525,0,	-1.4808,0.1056,0,	-1.461727,0.1056,-0.24297,
	-1.406405,0.1056,-0.472434,	-1.372712,0.084525,-0.461116,	-1.426709,0.084525,-0.237149,
	-1.426709,0.084525,-0.237149,	-1.461727,0.1056,-0.24297,	-1.406405,0.1056,-0.472434,
	-1.317675,0.1056,-0.685551,	-1.286108,0.084525,-0.669128,	-1.372712,0.084525,-0.461116,
	-1.372712,0.084525,-0.461116,	-1.406405,0.1056,-0.472434,	-1.317675,0.1056,-0.685551,
	-1.198382,0.1056,-0.879477,	-1.169673,0.084525,-0.858407,	-1.286108,0.084525,-0.669128,
	-1.286108,0.084525,-0.669128,	-1.317675,0.1056,-0.685551,	-1.198382,0.1056,-0.879477,
	-1.051368,0.1056,-1.051368,	-1.026181,0.084525,-1.026181,	-1.169673,0.084525,-0.858407,
	-1.169673,0.084525,-0.858407,	-1.198382,0.1056,-0.879477,	-1.051368,0.1056,-1.051368,
	-0.879477,0.1056,-1.198382,	-0.858407,0.084525,-1.169673,	-1.026181,0.084525,-1.026181,
	-1.026181,0.084525,-1.026181,	-1.051368,0.1056,-1.051368,	-0.879477,0.1056,-1.198382,
	-0.685551,0.1056,-1.317675,	-0.669128,0.084525,-1.286108,	-0.858407,0.084525,-1.169673,
	-0.858407,0.084525,-1.169673,	-0.879477,0.1056,-1.198382,	-0.685551,0.1056,-1.317675,
	-0.472434,0.1056,-1.406405,	-0.461116,0.084525,-1.372712,	-0.669128,0.084525,-1.286108,
	-0.669128,0.084525,-1.286108,	-0.685551,0.1056,-1.317675,	-0.472434,0.1056,-1.406405,
	-0.24297,0.1056,-1.461727,	-0.237149,0.084525,-1.426709,	-0.461116,0.084525,-1.372712,
	-0.461116,0.084525,-1.372712,	-0.472434,0.1056,-1.406405,	-0.24297,0.1056,-1.461727,
	0,0.1056,-1.4808,	0,0.084525,-1.445325,	-0.237149,0.084525,-1.426709,
	-0.237149,0.084525,-1.426709,	-0.24297,0.1056,-1.461727,	0,0.1056,-1.4808,
	-1.4772,0.127575,-0.245542,	-1.461727,0.1056,-0.24297,	-1.4808,0.1056,0,
	-1.4808,0.1056,0,	-1.496475,0.127575,0,	-1.4772,0.127575,-0.245542,
	-1.421292,0.127575,-0.477435,	-1.406405,0.1056,-0.472434,	-1.461727,0.1056,-0.24297,
	-1.461727,0.1056,-0.24297,	-1.4772,0.127575,-0.245542,	-1.421292,0.127575,-0.477435,
	-1.331623,0.127575,-0.692808,	-1.317675,0.1056,-0.685551,	-1.406405,0.1056,-0.472434,
	-1.406405,0.1056,-0.472434,	-1.421292,0.127575,-0.477435,	-1.331623,0.127575,-0.692808,
	-1.211067,0.127575,-0.888786,	-1.198382,0.1056,-0.879477,	-1.317675,0.1056,-0.685551,
	-1.317675,0.1056,-0.685551,	-1.331623,0.127575,-0.692808,	-1.211067,0.127575,-0.888786,
	-1.062497,0.127575,-1.062497,	-1.051368,0.1056,-1.051368,	-1.198382,0.1056,-0.879477,
	-1.198382,0.1056,-0.879477,	-1.211067,0.127575,-0.888786,	-1.062497,0.127575,-1.062497,
	-0.888786,0.127575,-1.211067,	-0.879477,0.1056,-1.198382,	-1.051368,0.1056,-1.051368,
	-1.051368,0.1056,-1.051368,	-1.062497,0.127575,-1.062497,	-0.888786,0.127575,-1.211067,
	-0.692808,0.127575,-1.331623,	-0.685551,0.1056,-1.317675,	-0.879477,0.1056,-1.198382,
	-0.879477,0.1056,-1.198382,	-0.888786,0.127575,-1.211067,	-0.692808,0.127575,-1.331623,
	-0.477435,0.127575,-1.421292,	-0.472434,0.1056,-1.406405,	-0.685551,0.1056,-1.317675,
	-0.685551,0.1056,-1.317675,	-0.692808,0.127575,-1.331623,	-0.477435,0.127575,-1.421292,
	-0.245542,0.127575,-1.4772,	-0.24297,0.1056,-1.461727,	-0.472434,0.1056,-1.406405,
	-0.472434,0.1056,-1.406405,	-0.477435,0.127575,-1.421292,	-0.245542,0.127575,-1.4772,
	0,0.127575,-1.496475,	0,0.1056,-1.4808,	-0.24297,0.1056,-1.461727,
	-0.24297,0.1056,-1.461727,	-0.245542,0.127575,-1.4772,	0,0.127575,-1.496475,
	-1.48068,0.15,-0.24612,	-1.4772,0.127575,-0.245542,	-1.496475,0.127575,0,
	-1.496475,0.127575,0,	-1.5,0.15,0,	-1.48068,0.15,-0.24612,
	-1.42464,0.15,-0.47856,	-1.421292,0.127575,-0.477435,	-1.4772,0.127575,-0.245542,
	-1.4772,0.127575,-0.245542,	-1.48068,0.15,-0.24612,	-1.42464,0.15,-0.47856,
	-1.33476,0.15,-0.69444,	-1.331623,0.127575,-0.692808,	-1.421292,0.127575,-0.477435,
	-1.421292,0.127575,-0.477435,	-1.42464,0.15,-0.47856,	-1.33476,0.15,-0.69444,
	-1.21392,0.15,-0.89088,	-1.211067,0.127575,-0.888786,	-1.331623,0.127575,-0.692808,
	-1.331623,0.127575,-0.692808,	-1.33476,0.15,-0.69444,	-1.21392,0.15,-0.89088,
	-1.065,0.15,-1.065,	-1.062497,0.127575,-1.062497,	-1.211067,0.127575,-0.888786,
	-1.211067,0.127575,-0.888786,	-1.21392,0.15,-0.89088,	-1.065,0.15,-1.065,
	-0.89088,0.15,-1.21392,	-0.888786,0.127575,-1.211067,	-1.062497,0.127575,-1.062497,
	-1.062497,0.127575,-1.062497,	-1.065,0.15,-1.065,	-0.89088,0.15,-1.21392,
	-0.69444,0.15,-1.33476,	-0.692808,0.127575,-1.331623,	-0.888786,0.127575,-1.211067,
	-0.888786,0.127575,-1.211067,	-0.89088,0.15,-1.21392,	-0.69444,0.15,-1.33476,
	-0.47856,0.15,-1.42464,	-0.477435,0.127575,-1.421292,	-0.692808,0.127575,-1.331623,
	-0.692808,0.127575,-1.331623,	-0.69444,0.15,-1.33476,	-0.47856,0.15,-1.42464,
	-0.24612,0.15,-1.48068,	-0.245542,0.127575,-1.4772,	-0.477435,0.127575,-1.421292,
	-0.477435,0.127575,-1.421292,	-0.47856,0.15,-1.42464,	-0.24612,0.15,-1.48068,
	0,0.15,-1.5,	0,0.127575,-1.496475,	-0.245542,0.127575,-1.4772,
	-0.245542,0.127575,-1.4772,	-0.24612,0.15,-1.48068,	0,0.15,-1.5,
	0,0,0,	0,0.002175,-0.388275,	0.063708,0.002175,-0.383274,
	0,0,0,	0.063708,0.002175,-0.383274,	0.123875,0.002175,-0.368768,
	0,0,0,	0.123875,0.002175,-0.368768,	0.179756,0.002175,-0.345503,
	0,0,0,	0.179756,0.002175,-0.345503,	0.230604,0.002175,-0.314223,
	0,0,0,	0.230604,0.002175,-0.314223,	0.275675,0.002175,-0.275675,
	0,0,0,	0.275675,0.002175,-0.275675,	0.314223,0.002175,-0.230604,
	0,0,0,	0.314223,0.002175,-0.230604,	0.345503,0.002175,-0.179756,
	0,0,0,	0.345503,0.002175,-0.179756,	0.368768,0.002175,-0.123875,
	0,0,0,	0.368768,0.002175,-0.123875,	0.383274,0.002175,-0.063708,
	0,0,0,	0.383274,0.002175,-0.063708,	0.388275,0.002175,0,
	0.115381,0.0084,-0.694143,	0.063708,0.002175,-0.383274,	0,0.002175,-0.388275,
	0,0.002175,-0.388275,	0,0.0084,-0.7032,	0.115381,0.0084,-0.694143,
	0.224349,0.0084,-0.667871,	0.123875,0.002175,-0.368768,	0.063708,0.002175,-0.383274,
	0.063708,0.002175,-0.383274,	0.115381,0.0084,-0.694143,	0.224349,0.0084,-0.667871,
	0.325553,0.0084,-0.625735,	0.179756,0.002175,-0.345503,	0.123875,0.002175,-0.368768,
	0.123875,0.002175,-0.368768,	0.224349,0.0084,-0.667871,	0.325553,0.0084,-0.625735,
	0.417645,0.0084,-0.569086,	0.230604,0.002175,-0.314223,	0.179756,0.002175,-0.345503,
	0.179756,0.002175,-0.345503,	0.325553,0.0084,-0.625735,	0.417645,0.0084,-0.569086,
	0.499272,0.0084,-0.499272,	0.275675,0.002175,-0.275675,	0.230604,0.002175,-0.314223,
	0.230604,0.002175,-0.314223,	0.417645,0.0084,-0.569086,	0.499272,0.0084,-0.499272,
	0.569086,0.0084,-0.417645,	0.314223,0.002175,-0.230604,	0.275675,0.002175,-0.275675,
	0.275675,0.002175,-0.275675,	0.499272,0.0084,-0.499272,	0.569086,0.0084,-0.417645,
	0.625735,0.0084,-0.325553,	0.345503,0.002175,-0.179756,	0.314223,0.002175,-0.230604,
	0.314223,0.002175,-0.230604,	0.569086,0.0084,-0.417645,	0.625735,0.0084,-0.325553,
	0.667871,0.0084,-0.224349,	0.368768,0.002175,-0.123875,	0.345503,0.002175,-0.179756,
	0.345503,0.002175,-0.179756,	0.625735,0.0084,-0.325553,	0.667871,0.0084,-0.224349,
	0.694143,0.0084,-0.115381,	0.383274,0.002175,-0.063708,	0.368768,0.002175,-0.123875,
	0.368768,0.002175,-0.123875,	0.667871,0.0084,-0.224349,	0.694143,0.0084,-0.115381,
	0.7032,0.0084,0,	0.388275,0.002175,0,	0.383274,0.002175,-0.063708,
	0.383274,0.002175,-0.063708,	0.694143,0.0084,-0.115381,	0.7032,0.0084,0,
	0.156274,0.018225,-0.940158,	0.115381,0.0084,-0.694143,	0,0.0084,-0.7032,
	0,0.0084,-0.7032,	0,0.018225,-0.952425,	0.156274,0.018225,-0.940158,
	0.303862,0.018225,-0.904575,	0.224349,0.0084,-0.667871,	0.115381,0.0084,-0.694143,
	0.115381,0.0084,-0.694143,	0.156274,0.018225,-0.940158,	0.303862,0.018225,-0.904575,
	0.440935,0.018225,-0.847506,	0.325553,0.0084,-0.625735,	0.224349,0.0084,-0.667871,
	0.224349,0.0084,-0.667871,	0.303862,0.018225,-0.904575,	0.440935,0.018225,-0.847506,
	0.565664,0.018225,-0.770779,	0.417645,0.0084,-0.569086,	0.325553,0.0084,-0.625735,
	0.325553,0.0084,-0.625735,	0.440935,0.018225,-0.847506,	0.565664,0.018225,-0.770779,
	0.676222,0.018225,-0.676222,	0.499272,0.0084,-0.499272,	0.417645,0.0084,-0.569086,
	0.417645,0.0084,-0.569086,	0.565664,0.018225,-0.770779,	0.676222,0.018225,-0.676222,
	0.770779,0.018225,-0.565664,	0.569086,0.0084,-0.417645,	0.499272,0.0084,-0.499272,
	0.499272,0.0084,-0.499272,	0.676222,0.018225,-0.676222,	0.770779,0.018225,-0.565664,
	0.847506,0.018225,-0.440935,	0.625735,0.0084,-0.325553,	0.569086,0.0084,-0.417645,
	0.569086,0.0084,-0.417645,	0.770779,0.018225,-0.565664,	0.847506,0.018225,-0.440935,
	0.904575,0.018225,-0.303862,	0.667871,0.0084,-0.224349,	0.625735,0.0084,-0.325553,
	0.625735,0.0084,-0.325553,	0.847506,0.018225,-0.440935,	0.904575,0.018225,-0.303862,
	0.940158,0.018225,-0.156274,	0.694143,0.0084,-0.115381,	0.667871,0.0084,-0.224349,
	0.667871,0.0084,-0.224349,	0.904575,0.018225,-0.303862,	0.940158,0.018225,-0.156274,
	0.952425,0.018225,0,	0.7032,0.0084,0,	0.694143,0.0084,-0.115381,
	0.694143,0.0084,-0.115381,	0.940158,0.018225,-0.156274,	0.952425,0.018225,0,
	0.187642,0.0312,-1.12887,	0.156274,0.018225,-0.940158,	0,0.018225,-0.952425,
	0,0.018225,-0.952425,	0,0.0312,-1.1436,	0.187642,0.0312,-1.12887,
	0.364854,0.0312,-1.086146,	0.303862,0.018225,-0.904575,	0.156274,0.018225,-0.940158,
	0.156274,0.018225,-0.940158,	0.187642,0.0312,-1.12887,	0.364854,0.0312,-1.086146,
	0.529441,0.0312,-1.017621,	0.440935,0.018225,-0.847506,	0.303862,0.018225,-0.904575,
	0.303862,0.018225,-0.904575,	0.364854,0.0312,-1.086146,	0.529441,0.0312,-1.017621,
	0.679207,0.0312,-0.925493,	0.565664,0.018225,-0.770779,	0.440935,0.018225,-0.847506,
	0.440935,0.018225,-0.847506,	0.529441,0.0312,-1.017621,	0.679207,0.0312,-0.925493,
	0.811956,0.0312,-0.811956,	0.676222,0.018225,-0.676222,	0.565664,0.018225,-0.770779,
	0.565664,0.018225,-0.770779,	0.679207,0.0312,-0.925493,	0.811956,0.0312,-0.811956,
	0.925493,0.0312,-0.679207,	0.770779,0.018225,-0.565664,	0.676222,0.018225,-0.676222,
	0.676222,0.018225,-0.676222,	0.811956,0.0312,-0.811956,	0.925493,0.0312,-0.679207,
	1.017621,0.0312,-0.529441,	0.847506,0.018225,-0.440935,	0.770779,0.018225,-0.565664,
	0.770779,0.018225,-0.565664,	0.925493,0.0312,-0.679207,	1.017621,0.0312,-0.529441,
	1.086146,0.0312,-0.364854,	0.904575,0.018225,-0.303862,	0.847506,0.018225,-0.440935,
	0.847506,0.018225,-0.440935,	1.017621,0.0312,-0.529441,	1.086146,0.0312,-0.364854,
	1.12887,0.0312,-0.187642,	0.940158,0.018225,-0.156274,	0.904575,0.018225,-0.303862,
	0.904575,0.018225,-0.303862,	1.086146,0.0312,-0.364854,	1.12887,0.0312,-0.187642,
	1.1436,0.0312,0,	0.952425,0.018225,0,	0.940158,0.018225,-0.156274,
	0.940158,0.018225,-0.156274,	1.12887,0.0312,-0.187642,	1.1436,0.0312,0,
	0.21074,0.046875,-1.267832,	0.187642,0.0312,-1.12887,	0,0.0312,-1.1436,
	0,0.0312,-1.1436,	0,0.046875,-1.284375,	0.21074,0.046875,-1.267832,
	0.409767,0.046875,-1.219848,	0.364854,0.0312,-1.086146,	0.187642,0.0312,-1.12887,
	0.187642,0.0312,-1.12887,	0.21074,0.046875,-1.267832,	0.409767,0.046875,-1.219848,
	0.594614,0.046875,-1.142888,	0.529441,0.0312,-1.017621,	0.364854,0.0312,-1.086146,
	0.364854,0.0312,-1.086146,	0.409767,0.046875,-1.219848,	0.594614,0.046875,-1.142888,
	0.762816,0.046875,-1.039419,	0.679207,0.0312,-0.925493,	0.529441,0.0312,-1.017621,
	0.529441,0.0312,-1.017621,	0.594614,0.046875,-1.142888,	0.762816,0.046875,-1.039419,
	0.911906,0.046875,-0.911906,	0.811956,0.0312,-0.811956,	0.679207,0.0312,-0.925493,
	0.679207,0.0312,-0.925493,	0.762816,0.046875,-1.039419,	0.911906,0.046875,-0.911906,
	1.039419,0.046875,-0.762816,	0.925493,0.0312,-0.679207,	0.811956,0.0312,-0.811956,
	0.811956,0.0312,-0.811956,	0.911906,0.046875,-0.911906,	1.039419,0.046875,-0.762816,
	1.142888,0.046875,-0.594614,	1.017621,0.0312,-0.529441,	0.925493,0.0312,-0.679207,
	0.925493,0.0312,-0.679207,	1.039419,0.046875,-0.762816,	1.142888,0.046875,-0.594614,
	1.219848,0.046875,-0.409767,	1.086146,0.0312,-0.364854,	1.017621,0.0312,-0.529441,
	1.017621,0.0312,-0.529441,	1.142888,0.046875,-0.594614,	1.219848,0.046875,-0.409767,
	1.267832,0.046875,-0.21074,	1.12887,0.0312,-0.187642,	1.086146,0.0312,-0.364854,
	1.086146,0.0312,-0.364854,	1.219848,0.046875,-0.409767,	1.267832,0.046875,-0.21074,
	1.284375,0.046875,0,	1.1436,0.0312,0,	1.12887,0.0312,-0.187642,
	1.12887,0.0312,-0.187642,	1.267832,0.046875,-0.21074,	1.284375,0.046875,0,
	0.226824,0.0648,-1.364595,	0.21074,0.046875,-1.267832,	0,0.046875,-1.284375,
	0,0.046875,-1.284375,	0,0.0648,-1.3824,	0.226824,0.0648,-1.364595,
	0.441041,0.0648,-1.312948,	0.409767,0.046875,-1.219848,	0.21074,0.046875,-1.267832,
	0.21074,0.046875,-1.267832,	0.226824,0.0648,-1.364595,	0.441041,0.0648,-1.312948,
	0.639996,0.0648,-1.230115,	0.594614,0.046875,-1.142888,	0.409767,0.046875,-1.219848,
	0.409767,0.046875,-1.219848,	0.441041,0.0648,-1.312948,	0.639996,0.0648,-1.230115,
	0.821035,0.0648,-1.118749,	0.762816,0.046875,-1.039419,	0.594614,0.046875,-1.142888,
	0.594614,0.046875,-1.142888,	0.639996,0.0648,-1.230115,	0.821035,0.0648,-1.118749,
	0.981504,0.0648,-0.981504,	0.911906,0.046875,-0.911906,	0.762816,0.046875,-1.039419,
	0.762816,0.046875,-1.039419,	0.821035,0.0648,-1.118749,	0.981504,0.0648,-0.981504,
	1.118749,0.0648,-0.821035,	1.039419,0.046875,-0.762816,	0.911906,0.046875,-0.911906,
	0.911906,0.046875,-0.911906,	0.981504,0.0648,-0.981504,	1.118749,0.0648,-0.821035,
	1.230115,0.0648,-0.639996,	1.142888,0.046875,-0.594614,	1.039419,0.046875,-0.762816,
	1.039419,0.046875,-0.762816,	1.118749,0.0648,-0.821035,	1.230115,0.0648,-0.639996,
	1.312948,0.0648,-0.441041,	1.219848,0.046875,-0.409767,	1.142888,0.046875,-0.594614,
	1.142888,0.046875,-0.594614,	1.230115,0.0648,-0.639996,	1.312948,0.0648,-0.441041,
	1.364595,0.0648,-0.226824,	1.267832,0.046875,-0.21074,	1.219848,0.046875,-0.409767,
	1.219848,0.046875,-0.409767,	1.312948,0.0648,-0.441041,	1.364595,0.0648,-0.226824,
	1.3824,0.0648,0,	1.284375,0.046875,0,	1.267832,0.046875,-0.21074,
	1.267832,0.046875,-0.21074,	1.364595,0.0648,-0.226824,	1.3824,0.0648,0,
	0.237149,0.084525,-1.426709,	0.226824,0.0648,-1.364595,	0,0.0648,-1.3824,
	0,0.0648,-1.3824,	0,0.084525,-1.445325,	0.237149,0.084525,-1.426709,
	0.461116,0.084525,-1.372712,	0.441041,0.0648,-1.312948,	0.226824,0.0648,-1.364595,
	0.226824,0.0648,-1.364595,	0.237149,0.084525,-1.426709,	0.461116,0.084525,-1.372712,
	0.669128,0.084525,-1.286108,	0.639996,0.0648,-1.230115,	0.441041,0.0648,-1.312948,
	0.441041,0.0648,-1.312948,	0.461116,0.084525,-1.372712,	0.669128,0.084525,-1.286108,
	0.858407,0.084525,-1.169673,	0.821035,0.0648,-1.118749,	0.639996,0.0648,-1.230115,
	0.639996,0.0648,-1.230115,	0.669128,0.084525,-1.286108,	0.858407,0.084525,-1.169673,
	1.026181,0.084525,-1.026181,	0.981504,0.0648,-0.981504,	0.821035,0.0648,-1.118749,
	0.821035,0.0648,-1.118749,	0.858407,0.084525,-1.169673,	1.026181,0.084525,-1.026181,
	1.169673,0.084525,-0.858407,	1.118749,0.0648,-0.821035,	0.981504,0.0648,-0.981504,
	0.981504,0.0648,-0.981504,	1.026181,0.084525,-1.026181,	1.169673,0.084525,-0.858407,
	1.286108,0.084525,-0.669128,	1.230115,0.0648,-0.639996,	1.118749,0.0648,-0.821035,
	1.118749,0.0648,-0.821035,	1.169673,0.084525,-0.858407,	1.286108,0.084525,-0.669128,
	1.372712,0.084525,-0.461116,	1.312948,0.0648,-0.441041,	1.230115,0.0648,-0.639996,
	1.230115,0.0648,-0.639996,	1.286108,0.084525,-0.669128,	1.372712,0.084525,-0.461116,
	1.426709,0.084525,-0.237149,	1.364595,0.0648,-0.226824,	1.312948,0.0648,-0.441041,
	1.312948,0.0648,-0.441041,	1.372712,0.084525,-0.461116,	1.426709,0.084525,-0.237149,
	1.445325,0.084525,0,	1.3824,0.0648,0,	1.364595,0.0648,-0.226824,
	1.364595,0.0648,-0.226824,	1.426709,0.084525,-0.237149,	1.445325,0.084525,0,
	0.24297,0.1056,-1.461727,	0.237149,0.084525,-1.426709,	0,0.084525,-1.445325,
	0,0.084525,-1.445325,	0,0.1056,-1.4808,	0.24297,0.1056,-1.461727,
	0.472434,0.1056,-1.406405,	0.461116,0.084525,-1.372712,	0.237149,0.084525,-1.426709,
	0.237149,0.084525,-1.426709,	0.24297,0.1056,-1.461727,	0.472434,0.1056,-1.406405,
	0.685551,0.1056,-1.317675,	0.669128,0.084525,-1.286108,	0.461116,0.084525,-1.372712,
	0.461116,0.084525,-1.372712,	0.472434,0.1056,-1.406405,	0.685551,0.1056,-1.317675,
	0.879477,0.1056,-1.198382,	0.858407,0.084525,-1.169673,	0.669128,0.084525,-1.286108,
	0.669128,0.084525,-1.286108,	0.685551,0.1056,-1.317675,	0.879477,0.1056,-1.198382,
	1.051368,0.1056,-1.051368,	1.026181,0.084525,-1.026181,	0.858407,0.084525,-1.169673,
	0.858407,0.084525,-1.169673,	0.879477,0.1056,-1.198382,	1.051368,0.1056,-1.051368,
	1.198382,0.1056,-0.879477,	1.169673,0.084525,-0.858407,	1.026181,0.084525,-1.026181,
	1.026181,0.084525,-1.026181,	1.051368,0.1056,-1.051368,	1.198382,0.1056,-0.879477,
	1.317675,0.1056,-0.685551,	1.286108,0.084525,-0.669128,	1.169673,0.084525,-0.858407,
	1.169673,0.084525,-0.858407,	1.198382,0.1056,-0.879477,	1.317675,0.1056,-0.685551,
	1.406405,0.1056,-0.472434,	1.372712,0.084525,-0.461116,	1.286108,0.084525,-0.669128,
	1.286108,0.084525,-0.669128,	1.317675,0.1056,-0.685551,	1.406405,0.1056,-0.472434,
	1.461727,0.1056,-0.24297,	1.426709,0.084525,-0.237149,	1.372712,0.084525,-0.461116,
	1.372712,0.084525,-0.461116,	1.406405,0.1056,-0.472434,	1.461727,0.1056,-0.24297,
	1.4808,0.1056,0,	1.445325,0.084525,0,	1.426709,0.084525,-0.237149,
	1.426709,0.084525,-0.237149,	1.461727,0.1056,-0.24297,	1.4808,0.1056,0,
	0.245542,0.127575,-1.4772,	0.24297,0.1056,-1.461727,	0,0.1056,-1.4808,
	0,0.1056,-1.4808,	0,0.127575,-1.496475,	0.245542,0.127575,-1.4772,
	0.477435,0.127575,-1.421292,	0.472434,0.1056,-1.406405,	0.24297,0.1056,-1.461727,
	0.24297,0.1056,-1.461727,	0.245542,0.127575,-1.4772,	0.477435,0.127575,-1.421292,
	0.692808,0.127575,-1.331623,	0.685551,0.1056,-1.317675,	0.472434,0.1056,-1.406405,
	0.472434,0.1056,-1.406405,	0.477435,0.127575,-1.421292,	0.692808,0.127575,-1.331623,
	0.888786,0.127575,-1.211067,	0.879477,0.1056,-1.198382,	0.685551,0.1056,-1.317675,
	0.685551,0.1056,-1.317675,	0.692808,0.127575,-1.331623,	0.888786,0.127575,-1.211067,
	1.062497,0.127575,-1.062497,	1.051368,0.1056,-1.051368,	0.879477,0.1056,-1.198382,
	0.879477,0.1056,-1.198382,	0.888786,0.127575,-1.211067,	1.062497,0.127575,-1.062497,
	1.211067,0.127575,-0.888786,	1.198382,0.1056,-0.879477,	1.051368,0.1056,-1.051368,
	1.051368,0.1056,-1.051368,	1.062497,0.127575,-1.062497,	1.211067,0.127575,-0.888786,
	1.331623,0.127575,-0.692808,	1.317675,0.1056,-0.685551,	1.198382,0.1056,-0.879477,
	1.198382,0.1056,-0.879477,	1.211067,0.127575,-0.888786,	1.331623,0.127575,-0.692808,
	1.421292,0.127575,-0.477435,	1.406405,0.1056,-0.472434,	1.317675,0.1056,-0.685551,
	1.317675,0.1056,-0.685551,	1.331623,0.127575,-0.692808,	1.421292,0.127575,-0.477435,
	1.4772,0.127575,-0.245542,	1.461727,0.1056,-0.24297,	1.406405,0.1056,-0.472434,
	1.406405,0.1056,-0.472434,	1.421292,0.127575,-0.477435,	1.4772,0.127575,-0.245542,
	1.496475,0.127575,0,	1.4808,0.1056,0,	1.461727,0.1056,-0.24297,
	1.461727,0.1056,-0.24297,	1.4772,0.127575,-0.245542,	1.496475,0.127575,0,
	0.24612,0.15,-1.48068,	0.245542,0.127575,-1.4772,	0,0.127575,-1.496475,
	0,0.127575,-1.496475,	0,0.15,-1.5,	0.24612,0.15,-1.48068,
	0.47856,0.15,-1.42464,	0.477435,0.127575,-1.421292,	0.245542,0.127575,-1.4772,
	0.245542,0.127575,-1.4772,	0.24612,0.15,-1.48068,	0.47856,0.15,-1.42464,
	0.69444,0.15,-1.33476,	0.692808,0.127575,-1.331623,	0.477435,0.127575,-1.421292,
	0.477435,0.127575,-1.421292,	0.47856,0.15,-1.42464,	0.69444,0.15,-1.33476,
	0.89088,0.15,-1.21392,	0.888786,0.127575,-1.211067,	0.692808,0.127575,-1.331623,
	0.692808,0.127575,-1.331623,	0.69444,0.15,-1.33476,	0.89088,0.15,-1.21392,
	1.065,0.15,-1.065,	1.062497,0.127575,-1.062497,	0.888786,0.127575,-1.211067,
	0.888786,0.127575,-1.211067,	0.89088,0.15,-1.21392,	1.065,0.15,-1.065,
	1.21392,0.15,-0.89088,	1.211067,0.127575,-0.888786,	1.062497,0.127575,-1.062497,
	1.062497,0.127575,-1.062497,	1.065,0.15,-1.065,	1.21392,0.15,-0.89088,
	1.33476,0.15,-0.69444,	1.331623,0.127575,-0.692808,	1.211067,0.127575,-0.888786,
	1.211067,0.127575,-0.888786,	1.21392,0.15,-0.89088,	1.33476,0.15,-0.69444,
	1.42464,0.15,-0.47856,	1.421292,0.127575,-0.477435,	1.331623,0.127575,-0.692808,
	1.331623,0.127575,-0.692808,	1.33476,0.15,-0.69444,	1.42464,0.15,-0.47856,
	1.48068,0.15,-0.24612,	1.4772,0.127575,-0.245542,	1.421292,0.127575,-0.477435,
	1.421292,0.127575,-0.477435,	1.42464,0.15,-0.47856,	1.48068,0.15,-0.24612,
	1.5,0.15,0,	1.496475,0.127575,0,	1.4772,0.127575,-0.245542,
	1.4772,0.127575,-0.245542,	1.48068,0.15,-0.24612,	1.5,0.15,0
};
