/* dhparam.c: initial DH parameters for stunnel */
#include "prototypes.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void) {
    static unsigned char dhp_2048[] = {
        0xed, 0x54, 0xa1, 0x48, 0xd6, 0x40, 0xd0, 0xad, 0x48, 0x69, 0x8b, 0x8b,
        0x23, 0x0d, 0x2f, 0x73, 0x7c, 0x3c, 0xbf, 0x8d, 0x0d, 0x56, 0xbe, 0x11,
        0x87, 0x9b, 0x92, 0x1c, 0x37, 0xb8, 0xab, 0x77, 0xf1, 0x96, 0x5f, 0x1b,
        0x7e, 0x77, 0x35, 0xc6, 0x33, 0x49, 0xc8, 0xfa, 0x9b, 0xd9, 0x2a, 0xbe,
        0x1e, 0x00, 0x42, 0x84, 0xd3, 0xb7, 0xab, 0xfc, 0x24, 0x0d, 0xa9, 0xd2,
        0x20, 0x43, 0x99, 0x57, 0x4b, 0x18, 0x94, 0x38, 0x6f, 0xa6, 0x37, 0x90,
        0x56, 0xa7, 0x96, 0xc1, 0x52, 0xed, 0x8a, 0x10, 0x0f, 0x19, 0xd4, 0x7e,
        0x49, 0x6a, 0xfd, 0x0b, 0xd1, 0x32, 0x4e, 0xde, 0xbc, 0x6b, 0xee, 0x16,
        0x3a, 0x26, 0xef, 0x3b, 0x2b, 0x0f, 0x21, 0x61, 0xa0, 0xdc, 0xeb, 0x1a,
        0xc7, 0x9e, 0x10, 0x05, 0x70, 0xa6, 0xda, 0xd8, 0x8b, 0x5d, 0xb4, 0x37,
        0x4d, 0x1e, 0x65, 0xbb, 0x76, 0x7b, 0x7f, 0xb5, 0x6b, 0xb8, 0xc6, 0x44,
        0x07, 0x98, 0x89, 0xce, 0x3e, 0xab, 0x69, 0x3a, 0xb4, 0x15, 0xb1, 0x7f,
        0x14, 0x58, 0x37, 0x38, 0xb8, 0x12, 0xb6, 0x2b, 0x59, 0xbc, 0x6a, 0x3e,
        0x46, 0x25, 0x15, 0x80, 0x42, 0xba, 0x9e, 0x06, 0xa3, 0x36, 0x16, 0xdb,
        0x08, 0x48, 0x2c, 0x1b, 0xa2, 0xe8, 0x99, 0x8b, 0x4b, 0x29, 0xb3, 0x06,
        0x7d, 0xe9, 0x5a, 0x62, 0xbf, 0x20, 0x88, 0xa3, 0x93, 0x25, 0xd3, 0x47,
        0xe0, 0x82, 0xbc, 0x78, 0xc1, 0xdc, 0xb2, 0x6b, 0xfc, 0x05, 0x9e, 0xee,
        0xd9, 0x10, 0xd2, 0xc0, 0x37, 0x6b, 0x1e, 0x88, 0xa1, 0x88, 0x46, 0x78,
        0x95, 0x88, 0xeb, 0xd7, 0x17, 0xd6, 0xa6, 0x7d, 0xf0, 0xd8, 0xce, 0x28,
        0x9a, 0x9d, 0x17, 0xb8, 0x12, 0xbe, 0x07, 0xf9, 0x48, 0x8d, 0xe6, 0xbd,
        0x93, 0xd4, 0xb6, 0x2e, 0x12, 0xdc, 0xd3, 0x98, 0x87, 0x7a, 0xc3, 0x60,
        0x51, 0xfe, 0x4c, 0xcf
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.75 */
