include(RunCMake)

function(run_tutorial_step name)
  set(RunCMake_TEST_SOURCE_DIR ${Tutorial_SOURCE_DIR}/${name})
  set(RunCMake_TEST_BINARY_DIR ${RunCMake_BINARY_DIR}/${name}-build)
  if(Tutorial_USE_MYMATH)
    set(math MyMath)
  else()
    set(math NoMath)
  endif()
  set(config Release)
  if(RunCMake_GENERATOR_IS_MULTI_CONFIG)
    set(exe ${RunCMake_TEST_BINARY_DIR}/${config}/Tutorial)
  else()
    set(exe ${RunCMake_TEST_BINARY_DIR}/Tutorial)
    list(APPEND RunCMake_TEST_OPTIONS -DCMAKE_BUILD_TYPE=${config})
  endif()
  list(APPEND RunCMake_TEST_OPTIONS -DUSE_MYMATH:BOOL=${Tutorial_USE_MYMATH})
  run_cmake(${name}-configure)
  unset(RunCMake_TEST_OPTIONS)
  set(RunCMake_TEST_NO_CLEAN 1)
  set(RunCMake_TEST_OUTPUT_MERGE 1)
  run_cmake_command(${name}-build ${CMAKE_COMMAND} --build . --config ${config})
  unset(RunCMake_TEST_OUTPUT_MERGE)
  if(EXISTS ${RunCMake_SOURCE_DIR}/${name}-${math}-run-stdout.txt)
    set(RunCMake-stdout-file ${name}-${math}-run-stdout.txt)
  else()
    set(RunCMake-stdout-file Step-${math}-run-stdout.txt)
  endif()
  run_cmake_command(${name}-run ${exe} 25)
endfunction()

if(NOT Tutorial_USE_MYMATH)
  run_tutorial_step(Step2)
endif()
foreach(step RANGE 3 12)
  run_tutorial_step(Step${step})
endforeach()
run_tutorial_step(Complete)
