macro(VsDefaultCompilerFlags_check tgt)
  set(vcProjectFile "${RunCMake_TEST_BINARY_DIR}/${tgt}.vcxproj")
  if(NOT EXISTS "${vcProjectFile}")
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not exist.")
    return()
  endif()

  set(HAVE_ForceConformanceInForLoopScope 0)
  set(HAVE_RemoveUnreferencedCodeData 0)
  set(HAVE_TreatWChar_tAsBuiltInType 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<ForceConformanceInForLoopScope></ForceConformanceInForLoopScope>")
      set(HAVE_ForceConformanceInForLoopScope 1)
    endif()
    if(line MATCHES "^ *<RemoveUnreferencedCodeData></RemoveUnreferencedCodeData>")
      set(HAVE_RemoveUnreferencedCodeData 1)
    endif()
    if(line MATCHES "^ *<TreatWChar_tAsBuiltInType></TreatWChar_tAsBuiltInType>")
      set(HAVE_TreatWChar_tAsBuiltInType 1)
    endif()
  endforeach()

  if(NOT HAVE_ForceConformanceInForLoopScope)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <ForceConformanceInForLoopScope> property.")
    return()
  endif()

  if(NOT HAVE_RemoveUnreferencedCodeData)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <RemoveUnreferencedCodeData> property.")
    return()
  endif()

  if(NOT HAVE_TreatWChar_tAsBuiltInType)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <TreatWChar_tAsBuiltInType> property.")
    return()
  endif()
endmacro()

macro(VsDefaultLinkerFlags_check tgt needs_subsystem_console)
  set(HAVE_DataExecutionPrevention 0)
  set(HAVE_ImageHasSafeExceptionHandlers 0)
  set(HAVE_LinkErrorReporting 0)
  set(HAVE_RandomizedBaseAddress 0)
  set(HAVE_SubSystem 0)
  set(HAVE_SubSystem_Console 0)

  file(STRINGS "${vcProjectFile}" lines)
  foreach(line IN LISTS lines)
    if(line MATCHES "^ *<DataExecutionPrevention></DataExecutionPrevention>")
      set(HAVE_DataExecutionPrevention 1)
    endif()
    if(line MATCHES "^ *<ImageHasSafeExceptionHandlers></ImageHasSafeExceptionHandlers>")
      set(HAVE_ImageHasSafeExceptionHandlers 1)
    endif()
    if(line MATCHES "^ *<LinkErrorReporting></LinkErrorReporting>")
      set(HAVE_LinkErrorReporting 1)
    endif()
    if(line MATCHES "^ *<RandomizedBaseAddress></RandomizedBaseAddress>")
      set(HAVE_RandomizedBaseAddress 1)
    endif()
    if(line MATCHES "^ *<SubSystem></SubSystem>")
      set(HAVE_SubSystem 1)
    endif()
    if(line MATCHES "^ *<SubSystem>Console</SubSystem>")
      set(HAVE_SubSystem_Console 1)
    endif()
  endforeach()

  if(NOT HAVE_DataExecutionPrevention)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <DataExecutionPrevention> property.")
    return()
  endif()

  if(NOT HAVE_ImageHasSafeExceptionHandlers)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <ImageHasSafeExceptionHandlers> property.")
    return()
  endif()

  if(NOT HAVE_LinkErrorReporting)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <LinkErrorReporting> property.")
    return()
  endif()

  if(NOT HAVE_RandomizedBaseAddress)
    set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <RandomizedBaseAddress> property.")
    return()
  endif()

  if(${needs_subsystem_console})
    if(HAVE_SubSystem)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has a <SubSystem> property.")
      return()
    endif()

    if(NOT HAVE_SubSystem_Console)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SubSystem> property with 'Console' value.")
      return()
    endif()
  else()
    if(NOT HAVE_SubSystem)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj does not have a <SubSystem> property.")
      return()
    endif()

    if(HAVE_SubSystem_Console)
      set(RunCMake_TEST_FAILED "Project file ${tgt}.vcxproj has a <SubSystem> property with 'Console' value.")
      return()
    endif()
  endif()
endmacro()

VsDefaultCompilerFlags_check(emptyStatic)

VsDefaultCompilerFlags_check(emptyShared)
VsDefaultLinkerFlags_check(emptyShared OFF)

VsDefaultCompilerFlags_check(main)
VsDefaultLinkerFlags_check(main ON)
