/*  apc_modbus.h - Driver for APC Modbus UPS
 *  Copyright © 2023 Axel Gembe <axel@gembe.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef APC_MODBUS_H
#define APC_MODBUS_H

#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_PENDING (1 << 0)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_INPROGRESS (1 << 1)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_PASSED (1 << 2)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_FAILED (1 << 3)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_REFUSED (1 << 4)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_ABORTED (1 << 5)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_SOURCE_PROTOCOL (1 << 6)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_SOURCE_LOCALUI (1 << 7)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_SOURCE_INTERNAL (1 << 8)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_MOD_INVALIDSTATE (1 << 9)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_MOD_INTERNALFAULT (1 << 10)
#define APC_MODBUS_REPLACEBATTERYTESTSTATUS_BF_MOD_STATEOFCHARGENOTACCEPTABLE (1 << 11)

#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_REG 590
#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_MOG_PRESENT (1 << 0)
#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_SOG_0_PRESENT (1 << 1)
#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_SOG_1_PRESENT (1 << 2)
#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_SOG_2_PRESENT (1 << 3)
#define APC_MODBUS_SOGRELAYCONFIGSETTING_BF_SOG_3_PRESENT (1 << 4)

#define APC_MODBUS_UPSCOMMAND_BF_REG 1536
/* 0 - 2 are reserved */
#define APC_MODBUS_UPSCOMMAND_BF_RESTORE_FACTORY_SETTINGS (1 << 3)
#define APC_MODBUS_UPSCOMMAND_BF_OUTPUT_INTO_BYPASS (1 << 4)
#define APC_MODBUS_UPSCOMMAND_BF_OUTPUT_OUT_OF_BYPASS (1 << 5)
/* 6 - 8 are reserved */
#define APC_MODBUS_UPSCOMMAND_BF_CLEAR_FAULTS (1 << 9)
/* 10 - 12 are reserved */
#define APC_MODBUS_UPSCOMMAND_BF_RESET_STRINGS (1 << 13)
#define APC_MODBUS_UPSCOMMAND_BF_RESET_LOGS (1 << 14)

#define APC_MODBUS_OUTLETCOMMAND_BF_REG 1538
#define APC_MODBUS_OUTLETCOMMAND_BF_CMD_CANCEL						(1 << 0)
#define APC_MODBUS_OUTLETCOMMAND_BF_CMD_OUTPUT_ON					(1 << 1)
#define APC_MODBUS_OUTLETCOMMAND_BF_CMD_OUTPUT_OFF					(1 << 2)
#define APC_MODBUS_OUTLETCOMMAND_BF_CMD_OUTPUT_SHUTDOWN				(1 << 3)
#define APC_MODBUS_OUTLETCOMMAND_BF_CMD_OUTPUT_REBOOT				(1 << 4)
#define APC_MODBUS_OUTLETCOMMAND_BF_MOD_COLD_BOOT_ALLOWED			(1 << 5)
#define APC_MODBUS_OUTLETCOMMAND_BF_MOD_USE_ON_DELAY				(1 << 6)
#define APC_MODBUS_OUTLETCOMMAND_BF_MOD_USE_OFF_DELAY				(1 << 7)
#define APC_MODBUS_OUTLETCOMMAND_BF_TARGET_MAIN_OUTLET_GROUP		(1 << 8)
#define APC_MODBUS_OUTLETCOMMAND_BF_TARGET_SWITCHED_OUTLET_GROUP_0	(1 << 9)
#define APC_MODBUS_OUTLETCOMMAND_BF_TARGET_SWITCHED_OUTLET_GROUP_1	(1 << 10)
#define APC_MODBUS_OUTLETCOMMAND_BF_TARGET_SWITCHED_OUTLET_GROUP_2	(1 << 11)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_USB_PORT					(1 << 12)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_LOCAL_USER				(1 << 13)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_RJ45_PORT				(1 << 14)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_SMART_SLOT_1				(1 << 15)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_SMART_SLOT_2				(1 << 16)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_INTERNAL_NETWORK_1		(1 << 17)
#define APC_MODBUS_OUTLETCOMMAND_BF_SOURCE_INTERNAL_NETWORK_2		(1 << 18)

#define APC_MODBUS_REPLACEBATTERYTESTCOMMAND_BF_REG 1541
#define APC_MODBUS_REPLACEBATTERYTESTCOMMAND_BF_START	(1 << 0)
#define APC_MODBUS_REPLACEBATTERYTESTCOMMAND_BF_ABORT	(1 << 1)

#define APC_MODBUS_RUNTIMECALIBRATIONCOMMAND_BF_REG 1542
#define APC_MODBUS_RUNTIMECALIBRATIONCOMMAND_BF_START	(1 << 0)
#define APC_MODBUS_RUNTIMECALIBRATIONCOMMAND_BF_ABORT	(1 << 1)

#define APC_MODBUS_USERINTERFACECOMMAND_BF_REG 1543
#define APC_MODBUS_USERINTERFACECOMMAND_BF_SHORT_TEST						(1 << 0)
#define APC_MODBUS_USERINTERFACECOMMAND_BF_CONTINUOUS_TEST					(1 << 1)
#define APC_MODBUS_USERINTERFACECOMMAND_BF_MUTE_ALL_ACTIVE_AUDIBLE_ALARMS	(1 << 2)
#define APC_MODBUS_USERINTERFACECOMMAND_BF_CANCEL_MUTE						(1 << 3)
/* 4 is reserved */
#define APC_MODBUS_USERINTERFACECOMMAND_BF_ACKNOWLEDGE_BATTERY_ALARMS		(1 << 5)
#define APC_MODBUS_USERINTERFACECOMMAND_BF_ACKNOWLEDGE_SITE_WIRING_ALARM	(1 << 6)

#endif /* APC_MODBUS_H */
