/* list.c generated by valac 0.52.0, the Vala compiler
 * generated from list.vala, do not modify */

/* list.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "gee.h"
#include <glib-object.h>
#include <glib.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer gee_list_real_first (GeeList* self);
static gpointer gee_list_real_last (GeeList* self);
static void gee_list_real_insert_all (GeeList* self,
                               gint index,
                               GeeCollection* collection);
static void gee_list_real_sort (GeeList* self,
                         GCompareDataFunc compare_func,
                         gpointer compare_func_target,
                         GDestroyNotify compare_func_target_destroy_notify);
 G_GNUC_INTERNAL void gee_tim_sort_sort (GType g_type,
                        GBoxedCopyFunc g_dup_func,
                        GDestroyNotify g_destroy_func,
                        GeeList* list,
                        GCompareDataFunc compare,
                        gpointer compare_target);
static GType gee_list_get_type_once (void);

/**
 * Returns a ListIterator that can be used for iteration over this list.
 *
 * @return a ListIterator that can be used for iteration over this list
 */
GeeListIterator*
gee_list_list_iterator (GeeList* self)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->list_iterator) {
		return _iface_->list_iterator (self);
	}
	return NULL;
}

/**
 * Returns the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be returned
 *
 * @return      the item at the specified index in the list
 */
gpointer
gee_list_get (GeeList* self,
              gint index)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->get) {
		return _iface_->get (self, index);
	}
	return NULL;
}

/**
 * Sets the item at the specified index in this list.
 *
 * @param index zero-based index of the item to be set
 */
void
gee_list_set (GeeList* self,
              gint index,
              gconstpointer item)
{
	GeeListIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->set) {
		_iface_->set (self, index, item);
	}
}

/**
 * Returns the index of the first occurrence of the specified item in
 * this list.
 *
 * @return the index of the first occurrence of the specified item, or
 *         -1 if the item could not be found
 */
gint
gee_list_index_of (GeeList* self,
                   gconstpointer item)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->index_of) {
		return _iface_->index_of (self, item);
	}
	return -1;
}

/**
 * Inserts an item into this list at the specified position.
 *
 * @param index zero-based index at which item is inserted
 * @param item  item to insert into the list
 */
void
gee_list_insert (GeeList* self,
                 gint index,
                 gconstpointer item)
{
	GeeListIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->insert) {
		_iface_->insert (self, index, item);
	}
}

/**
 * Removes the item at the specified index of this list.
 *
 * @param index zero-based index of the item to be removed
 *
 * @return      the removed element
 */
gpointer
gee_list_remove_at (GeeList* self,
                    gint index)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->remove_at) {
		return _iface_->remove_at (self, index);
	}
	return NULL;
}

/**
 * Returns a slice of this list.
 *
 * @param start zero-based index of the slice's first element
 * @param stop  zero-based index of the position after the end of the slice
 *
 * @return A list containing a slice of this list
 */
GeeList*
gee_list_slice (GeeList* self,
                gint start,
                gint stop)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->slice) {
		return _iface_->slice (self, start, stop);
	}
	return NULL;
}

/**
 * Returns the first item of the list. Fails if the list is empty.
 *
 * @return      first item in the list
 */
static gpointer
gee_list_real_first (GeeList* self)
{
	gpointer _tmp0_;
	gpointer result = NULL;
	_tmp0_ = gee_list_get (self, 0);
	result = _tmp0_;
	return result;
}

gpointer
gee_list_first (GeeList* self)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->first) {
		return _iface_->first (self);
	}
	return NULL;
}

/**
 * Returns the last item of the list. Fails if the list is empty.
 *
 * @return      last item in the list
 */
static gpointer
gee_list_real_last (GeeList* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gpointer _tmp2_;
	gpointer result = NULL;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_list_get (self, _tmp1_ - 1);
	result = _tmp2_;
	return result;
}

gpointer
gee_list_last (GeeList* self)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->last) {
		return _iface_->last (self);
	}
	return NULL;
}

/**
 * Inserts items into this list for the input collection at the
 * specified position.
 *
 * @param index zero-based index of the items to be inserted
 * @param collection collection of items to be inserted
 */
static void
gee_list_real_insert_all (GeeList* self,
                          gint index,
                          GeeCollection* collection)
{
	g_return_if_fail (collection != NULL);
	{
		GeeIterator* _item_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			gpointer item = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gconstpointer _tmp4_;
			gint _tmp5_;
			_tmp1_ = _item_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _item_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			item = _tmp3_;
			_tmp4_ = item;
			gee_list_insert (self, index, _tmp4_);
			_tmp5_ = index;
			index = _tmp5_ + 1;
			((item == NULL) || (GEE_LIST_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_LIST_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
}

void
gee_list_insert_all (GeeList* self,
                     gint index,
                     GeeCollection* collection)
{
	GeeListIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->insert_all) {
		_iface_->insert_all (self, index, collection);
	}
}

/**
 * Sorts items by comparing with the specified compare function.
 *
 * @param compare_func compare function to use to compare items
 */
static void
gee_list_real_sort (GeeList* self,
                    GCompareDataFunc compare_func,
                    gpointer compare_func_target,
                    GDestroyNotify compare_func_target_destroy_notify)
{
	if (compare_func == NULL) {
		gpointer _tmp0_ = NULL;
		GDestroyNotify _tmp1_ = NULL;
		GCompareDataFunc _tmp2_;
		_tmp2_ = gee_functions_get_compare_func_for (GEE_LIST_GET_INTERFACE (self)->get_g_type (self), &_tmp0_, &_tmp1_);
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
		compare_func = NULL;
		compare_func_target = NULL;
		compare_func_target_destroy_notify = NULL;
		compare_func = _tmp2_;
		compare_func_target = _tmp0_;
		compare_func_target_destroy_notify = _tmp1_;
	}
	gee_tim_sort_sort (GEE_LIST_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_LIST_GET_INTERFACE (self)->get_g_dup_func (self), (GDestroyNotify) GEE_LIST_GET_INTERFACE (self)->get_g_destroy_func (self), self, compare_func, compare_func_target);
	(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
	compare_func = NULL;
	compare_func_target = NULL;
	compare_func_target_destroy_notify = NULL;
}

void
gee_list_sort (GeeList* self,
               GCompareDataFunc compare_func,
               gpointer compare_func_target,
               GDestroyNotify compare_func_target_destroy_notify)
{
	GeeListIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->sort) {
		_iface_->sort (self, compare_func, compare_func_target, compare_func_target_destroy_notify);
	}
}

/**
 * Returns an immutable empty list.
 *
 * @return an immutable empty list
 */
GeeList*
gee_list_empty (GType g_type,
                GBoxedCopyFunc g_dup_func,
                GDestroyNotify g_destroy_func)
{
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeBidirList* _tmp2_;
	GeeBidirList* _tmp3_;
	GeeList* _tmp4_;
	GeeList* result = NULL;
	_tmp0_ = gee_linked_list_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_abstract_bidir_list_get_read_only_view ((GeeAbstractBidirList*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GeeList*) _tmp3_;
	_g_object_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

GeeList*
gee_list_get_read_only_view (GeeList* self)
{
	GeeListIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GEE_LIST_GET_INTERFACE (self);
	if (_iface_->get_read_only_view) {
		return _iface_->get_read_only_view (self);
	}
	return NULL;
}

static void
gee_list_default_init (GeeListIface * iface,
                       gpointer iface_data)
{
	/**
	 * The read-only view of this list.
	 */
	g_object_interface_install_property (iface, g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->first = gee_list_real_first;
	iface->last = gee_list_real_last;
	iface->insert_all = gee_list_real_insert_all;
	iface->sort = gee_list_real_sort;
}

/**
 * An ordered collection.
 */
static GType
gee_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GeeListIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_list_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType gee_list_type_id;
	gee_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeList", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (gee_list_type_id, GEE_TYPE_COLLECTION);
	return gee_list_type_id;
}

GType
gee_list_get_type (void)
{
	static volatile gsize gee_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_list_type_id__volatile)) {
		GType gee_list_type_id;
		gee_list_type_id = gee_list_get_type_once ();
		g_once_init_leave (&gee_list_type_id__volatile, gee_list_type_id);
	}
	return gee_list_type_id__volatile;
}

