; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -fast-isel -mtriple=i686-unknown -mattr=+avx512cd | FileCheck %s
; RUN: llc < %s -fast-isel -mtriple=x86_64-unknown -mattr=+avx512cd | FileCheck %s

define <8 x i64> @test_mm512_broadcastmb_epi64(<8 x i64> %a, <8 x i64> %b) {
; CHECK-LABEL: test_mm512_broadcastmb_epi64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; CHECK-NEXT:    vpbroadcastmb2q %k0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = icmp eq <8 x i64> %a, %b
  %1 = bitcast <8 x i1> %0 to i8
  %conv.i = zext i8 %1 to i64
  %vecinit.i.i = insertelement <8 x i64> undef, i64 %conv.i, i32 0
  %vecinit7.i.i = shufflevector <8 x i64> %vecinit.i.i, <8 x i64> undef, <8 x i32> zeroinitializer
  ret <8 x i64> %vecinit7.i.i
}

define <8 x i64> @test_mm512_broadcastmw_epi32(<8 x i64> %a, <8 x i64> %b) {
; CHECK-LABEL: test_mm512_broadcastmw_epi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; CHECK-NEXT:    vpbroadcastmw2d %k0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
entry:
  %0 = bitcast <8 x i64> %a to <16 x i32>
  %1 = bitcast <8 x i64> %b to <16 x i32>
  %2 = icmp eq <16 x i32> %0, %1
  %3 = bitcast <16 x i1> %2 to i16
  %conv.i = zext i16 %3 to i32
  %vecinit.i.i = insertelement <16 x i32> undef, i32 %conv.i, i32 0
  %vecinit15.i.i = shufflevector <16 x i32> %vecinit.i.i, <16 x i32> undef, <16 x i32> zeroinitializer
  %4 = bitcast <16 x i32> %vecinit15.i.i to <8 x i64>
  ret <8 x i64> %4
}


