# SPDX-License-Identifier: Apache-2.0
# Copyright 2021 The Meson development team

import pickle
from pathlib import Path
from .generatorbase import GeneratorBase
from .model import ReferenceManual

class GeneratorPickle(GeneratorBase):
    def __init__(self, manual: ReferenceManual, outpath: Path) -> None:
        self.out = outpath
        super().__init__(manual)

    def generate(self) -> None:
        self.out.write_bytes(pickle.dumps(self.manual))
