/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0x9E, 0x60, 0xD9, 0xD9, 0x9A, 0x36, 0x72, 0x2B, 0x93, 0xC0,
        0x0C, 0x20, 0x0E, 0x8F, 0x83, 0xE0, 0xCE, 0x24, 0x3C, 0xE8,
        0x22, 0x6D, 0x4A, 0xE6, 0x2C, 0x37, 0x28, 0x19, 0xFE, 0x4A,
        0x2A, 0x70, 0x3D, 0x40, 0xCA, 0x4A, 0x23, 0xFC, 0x48, 0x65,
        0x45, 0x14, 0x9F, 0x41, 0x51, 0xDD, 0x94, 0x37, 0xA0, 0x13,
        0x92, 0x6E, 0x54, 0x8D, 0x81, 0xB5, 0xAC, 0x3C, 0x93, 0xCB,
        0x9A, 0x4A, 0x7E, 0x96, 0xB2, 0xB6, 0xFA, 0x31, 0x62, 0x55,
        0x54, 0x69, 0x1D, 0x5F, 0xEF, 0x34, 0xFD, 0xEA, 0x2E, 0x30,
        0x92, 0x5D, 0x59, 0x10, 0x04, 0x6B, 0x77, 0xB9, 0xE6, 0x41,
        0xCE, 0x0A, 0xAC, 0x79, 0x5C, 0x44, 0x4C, 0x04, 0x96, 0x53,
        0xE7, 0xC9, 0x07, 0x70, 0x09, 0xDD, 0xD1, 0x0D, 0x54, 0xC7,
        0x52, 0x18, 0x41, 0x64, 0xF1, 0xC3, 0x2F, 0x64, 0x71, 0x45,
        0xA2, 0x23, 0x2C, 0xDC, 0xCA, 0x9B, 0x76, 0x59, 0xA8, 0xAA,
        0xA3, 0x5E, 0x1D, 0xD7, 0x5B, 0x61, 0x50, 0x7D, 0x91, 0x80,
        0x2A, 0xC7, 0xD5, 0x86, 0xC3, 0x57, 0x4A, 0x66, 0x7B, 0x3A,
        0xB8, 0xC7, 0xFD, 0xDF, 0x23, 0x4A, 0x2E, 0x49, 0x57, 0xF6,
        0x9C, 0x7D, 0xC6, 0xFD, 0x7A, 0x37, 0x50, 0x38, 0x58, 0x80,
        0xDE, 0x98, 0xFA, 0x57, 0x1D, 0xF8, 0x22, 0x8D, 0x6C, 0x6A,
        0x34, 0x0F, 0x42, 0x96, 0x80, 0x48, 0x70, 0x64, 0x12, 0x1C,
        0x66, 0xB7, 0x69, 0x35, 0x80, 0x93, 0x2D, 0xE3, 0xAF, 0x57,
        0xA9, 0xBF, 0x99, 0x95, 0x73, 0x3B, 0x09, 0x74, 0xF6, 0x85,
        0x09, 0x5D, 0x3A, 0x4F, 0x3D, 0xB0, 0xFC, 0xF1, 0x09, 0xC2,
        0xE9, 0x24, 0x5E, 0x60, 0xDD, 0x7E, 0xF5, 0xB2, 0x9C, 0x96,
        0x92, 0x29, 0x0E, 0xC1, 0x69, 0x6D, 0x68, 0x32, 0x96, 0xDE,
        0x2D, 0xB1, 0x8B, 0xBE, 0x56, 0xE8, 0xFB, 0x5C, 0x78, 0xBB,
        0x7C, 0xFB, 0x29, 0x86, 0x36, 0x6B
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.62 */
