#!/usr/bin/perl

#   Copyright (C) 2016 Mauro Carvalho Chehab
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, version 2 of the License.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
# This small script parses register dumps generated by parse_cx231xx.pl
# 	for tda18271 tuner, like:
# OUT i2c channel#2 daddr 0x60 100kbps addr_len 1 sync len 1 = (saddr)25 37 02

use strict;

my %tda18271_reg = (
	0x00 => "ID byte                (R_ID)",
	0x01 => "Thermo byte            (R_TM)",
	0x02 => "Power level byte       (R_PL)",
	0x03 => "Easy Prog byte 1       (R_EP1)",
	0x04 => "Easy Prog byte 2       (R_EP2)",
	0x05 => "Easy Prog byte 3       (R_EP3)",
	0x06 => "Easy Prog byte 4       (R_EP4)",
	0x07 => "Easy Prog byte 5       (R_EP5)",
	0x08 => "Cal Post-Divider byte  (R_CPD)",
	0x09 => "Cal Divider byte 1     (R_CD1)",
	0x0a => "Cal Divider byte 2     (R_CD2)",
	0x0b => "Cal Divider byte 3     (R_CD3)",
	0x0c => "Main Post-Divider byte (R_MPD)",
	0x0d => "Main Divider byte 1    (R_MD1)",
	0x0e => "Main Divider byte 2    (R_MD2)",
	0x0f => "Main Divider byte 3    (R_MD3)",
	0x10 => "Extended byte 1        (R_EB1)",
	0x11 => "Extended byte 2        (R_EB2)",
	0x12 => "Extended byte 3        (R_EB3)",
	0x13 => "Extended byte 4        (R_EB4)",
	0x14 => "Extended byte 5        (R_EB5)",
	0x15 => "Extended byte 6        (R_EB6)",
	0x16 => "Extended byte 7        (R_EB7)",
	0x17 => "Extended byte 8        (R_EB8)",
	0x18 => "Extended byte 9        (R_EB9)",
	0x19 => "Extended byte 10       (R_EB10)",
	0x1a => "Extended byte 11       (R_EB11)",
	0x1b => "Extended byte 12       (R_EB12)",
	0x1c => "Extended byte 13       (R_EB13)",
	0x1d => "Extended byte 14       (R_EB14)",
	0x1e => "Extended byte 15       (R_EB15)",
	0x1f => "Extended byte 16       (R_EB16)",
	0x20 => "Extended byte 17       (R_EB17)",
	0x21 => "Extended byte 18       (R_EB18)",
	0x22 => "Extended byte 19       (R_EB19)",
	0x23 => "Extended byte 20       (R_EB20)",
	0x24 => "Extended byte 21       (R_EB21)",
	0x25 => "Extended byte 22       (R_EB22)",
	0x26 => "Extended byte 23       (R_EB23)",
);


# OUT i2c channel#2 daddr 0x60 100kbps addr_len 1 sync len 1 = (saddr)25 37 02

my $mb86a20s_cont;

while (<>) {
	my $org_line = $_;

	if (m/(IN|OUT)\s+i2c\s+channel#\d\s+daddr\s+0x10.*\=\s*\(saddr\)([\da-f].)\s+(.*)/) {
		my $type = $1;
		my $reg = $2;
		my $val = $3;
		my $err = "";

		if ($val =~ s/eRROR (.*)//) {
			$err = "\t// ERROR $1";
		}

		if ($reg eq "08" && $val eq "01") {
			print "\t// INCOMPLETE!!!\n" if ($mb86a20s_cont);
			printf "\n";
			$mb86a20s_cont = 0;
		}

		printf "(%-3s)mb86a20s:\t", $type if (!$mb86a20s_cont);

		if ($type eq "OUT") {
			printf "{ 0x%s, 0x%s },", $reg, $val;
		} else {
			printf "{ 0x%s } = 0x%s,", $reg, $val;
		}

		if ($reg eq "04" || $reg eq "50" ||
		    $reg eq "28" || $reg eq "29" || $reg eq "2a") {
			print " ";
			$mb86a20s_cont = 1;
		} else {
			$mb86a20s_cont = 0;
			print "$err\n";
		}
	}

	if (m/(IN|OUT)\s+i2c\s+channel#\d\s+daddr\s+0x60.*\=\s*\(saddr\)([\da-f].)\s+(.*)/) {
		my $type = $1;
		my $vals = $3;
		my $regval = hex($2);
		my $err = "";

		if ($vals =~ s/eRROR (.*)//) {
			$err = "\t// ERROR $1";
		}


		print "\t// INCOMPLETE!!!\n" if ($mb86a20s_cont);

		my $j = 0;
		while ($j + 2 <= length($vals)) {
			my $reg;
			my $val = hex(substr($vals, $j, 2));

			if (defined($tda18271_reg{$regval})) {
				$reg = $tda18271_reg{$regval};
			} else {
				$reg = sprintf "REG 0x%02x", $regval;
			}
			printf "(%-3s)tda18271_dump_regs: %s = 0x%02x$err\n", $type, $reg, $val;
			$regval++;
			$j += 3;
		}
	}
	print $_ if (m/cx231xx/);
}
