/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.media.IMediaBrowserServiceCompat;
import android.support.v4.media.IMediaBrowserServiceCompatCallbacks;
import android.support.v4.media.MediaDescriptionCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.os.ResultReceiver;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;

public final class MediaBrowserCompat {
    private final MediaBrowserImplBase mImpl;

    public MediaBrowserCompat(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
        this.mImpl = new MediaBrowserImplBase(context, serviceComponent, callback, rootHints);
    }

    public void connect() {
        this.mImpl.connect();
    }

    public void disconnect() {
        this.mImpl.disconnect();
    }

    public boolean isConnected() {
        return this.mImpl.isConnected();
    }

    @NonNull
    public ComponentName getServiceComponent() {
        return this.mImpl.getServiceComponent();
    }

    @NonNull
    public String getRoot() {
        return this.mImpl.getRoot();
    }

    @Nullable
    public Bundle getExtras() {
        return this.mImpl.getExtras();
    }

    @NonNull
    public MediaSessionCompat.Token getSessionToken() {
        return this.mImpl.getSessionToken();
    }

    public void subscribe(@NonNull String parentId, @NonNull SubscriptionCallback callback) {
        this.mImpl.subscribe(parentId, callback);
    }

    public void unsubscribe(@NonNull String parentId) {
        this.mImpl.unsubscribe(parentId);
    }

    public void getItem(@NonNull String mediaId, @NonNull ItemCallback cb) {
        this.mImpl.getItem(mediaId, cb);
    }

    static class MediaBrowserImplBase {
        private static final String TAG = "MediaBrowserCompat";
        private static final boolean DBG = false;
        private static final int CONNECT_STATE_DISCONNECTED = 0;
        private static final int CONNECT_STATE_CONNECTING = 1;
        private static final int CONNECT_STATE_CONNECTED = 2;
        private static final int CONNECT_STATE_SUSPENDED = 3;
        private final Context mContext;
        private final ComponentName mServiceComponent;
        private final ConnectionCallback mCallback;
        private final Bundle mRootHints;
        private final Handler mHandler = new Handler();
        private final ArrayMap<String, Subscription> mSubscriptions = new ArrayMap();
        private int mState = 0;
        private MediaServiceConnection mServiceConnection;
        private IMediaBrowserServiceCompat mServiceBinder;
        private IMediaBrowserServiceCompatCallbacks mServiceCallbacks;
        private String mRootId;
        private MediaSessionCompat.Token mMediaSessionToken;
        private Bundle mExtras;

        public MediaBrowserImplBase(Context context, ComponentName serviceComponent, ConnectionCallback callback, Bundle rootHints) {
            if (context == null) {
                throw new IllegalArgumentException("context must not be null");
            }
            if (serviceComponent == null) {
                throw new IllegalArgumentException("service component must not be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("connection callback must not be null");
            }
            this.mContext = context;
            this.mServiceComponent = serviceComponent;
            this.mCallback = callback;
            this.mRootHints = rootHints;
        }

        public void connect() {
            if (this.mState != 0) {
                throw new IllegalStateException("connect() called while not disconnected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            if (this.mServiceBinder != null) {
                throw new RuntimeException("mServiceBinder should be null. Instead it is " + this.mServiceBinder);
            }
            if (this.mServiceCallbacks != null) {
                throw new RuntimeException("mServiceCallbacks should be null. Instead it is " + this.mServiceCallbacks);
            }
            this.mState = 1;
            Intent intent = new Intent("android.media.browse.MediaBrowserServiceCompat");
            intent.setComponent(this.mServiceComponent);
            final MediaServiceConnection thisConnection = this.mServiceConnection = new MediaServiceConnection();
            boolean bound = false;
            try {
                bound = this.mContext.bindService(intent, (ServiceConnection)this.mServiceConnection, 1);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)("Failed binding to service " + this.mServiceComponent));
            }
            if (!bound) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (thisConnection == MediaBrowserImplBase.this.mServiceConnection) {
                            MediaBrowserImplBase.this.forceCloseConnection();
                            MediaBrowserImplBase.this.mCallback.onConnectionFailed();
                        }
                    }
                });
            }
        }

        public void disconnect() {
            if (this.mServiceCallbacks != null) {
                try {
                    this.mServiceBinder.disconnect(this.mServiceCallbacks);
                }
                catch (RemoteException ex) {
                    Log.w((String)TAG, (String)("RemoteException during connect for " + this.mServiceComponent));
                }
            }
            this.forceCloseConnection();
        }

        private void forceCloseConnection() {
            if (this.mServiceConnection != null) {
                this.mContext.unbindService((ServiceConnection)this.mServiceConnection);
            }
            this.mState = 0;
            this.mServiceConnection = null;
            this.mServiceBinder = null;
            this.mServiceCallbacks = null;
            this.mRootId = null;
            this.mMediaSessionToken = null;
        }

        public boolean isConnected() {
            return this.mState == 2;
        }

        @NonNull
        public ComponentName getServiceComponent() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getServiceComponent() called while not connected (state=" + this.mState + ")");
            }
            return this.mServiceComponent;
        }

        @NonNull
        public String getRoot() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getSessionToken() called while not connected(state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mRootId;
        }

        @Nullable
        public Bundle getExtras() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getExtras() called while not connected (state=" + MediaBrowserImplBase.getStateLabel(this.mState) + ")");
            }
            return this.mExtras;
        }

        @NonNull
        public MediaSessionCompat.Token getSessionToken() {
            if (!this.isConnected()) {
                throw new IllegalStateException("getSessionToken() called while not connected(state=" + this.mState + ")");
            }
            return this.mMediaSessionToken;
        }

        public void subscribe(@NonNull String parentId, @NonNull SubscriptionCallback callback) {
            boolean newSubscription;
            if (parentId == null) {
                throw new IllegalArgumentException("parentId is null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback is null");
            }
            Subscription sub = (Subscription)this.mSubscriptions.get(parentId);
            boolean bl = newSubscription = sub == null;
            if (newSubscription) {
                sub = new Subscription(parentId);
                this.mSubscriptions.put(parentId, sub);
            }
            sub.callback = callback;
            if (this.mState == 2) {
                try {
                    this.mServiceBinder.addSubscription(parentId, this.mServiceCallbacks);
                }
                catch (RemoteException ex) {
                    Log.d((String)TAG, (String)("addSubscription failed with RemoteException parentId=" + parentId));
                }
            }
        }

        public void unsubscribe(@NonNull String parentId) {
            if (TextUtils.isEmpty((CharSequence)parentId)) {
                throw new IllegalArgumentException("parentId is empty.");
            }
            Subscription sub = (Subscription)this.mSubscriptions.remove(parentId);
            if (this.mState == 2 && sub != null) {
                try {
                    this.mServiceBinder.removeSubscription(parentId, this.mServiceCallbacks);
                }
                catch (RemoteException ex) {
                    Log.d((String)TAG, (String)("removeSubscription failed with RemoteException parentId=" + parentId));
                }
            }
        }

        public void getItem(final @NonNull String mediaId, final @NonNull ItemCallback cb) {
            if (TextUtils.isEmpty((CharSequence)mediaId)) {
                throw new IllegalArgumentException("mediaId is empty.");
            }
            if (cb == null) {
                throw new IllegalArgumentException("cb is null.");
            }
            if (this.mState != 2) {
                Log.i((String)TAG, (String)"Not connected, unable to retrieve the MediaItem.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
                return;
            }
            ResultReceiver receiver = new ResultReceiver(this.mHandler){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode != 0 || resultData == null || !resultData.containsKey("media_item")) {
                        cb.onError(mediaId);
                        return;
                    }
                    Parcelable item = resultData.getParcelable("media_item");
                    if (!(item instanceof MediaItem)) {
                        cb.onError(mediaId);
                        return;
                    }
                    cb.onItemLoaded((MediaItem)item);
                }
            };
            try {
                this.mServiceBinder.getMediaItem(mediaId, receiver);
            }
            catch (RemoteException e) {
                Log.i((String)TAG, (String)"Remote error getting media item.");
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        cb.onError(mediaId);
                    }
                });
            }
        }

        private static String getStateLabel(int state) {
            switch (state) {
                case 0: {
                    return "CONNECT_STATE_DISCONNECTED";
                }
                case 1: {
                    return "CONNECT_STATE_CONNECTING";
                }
                case 2: {
                    return "CONNECT_STATE_CONNECTED";
                }
                case 3: {
                    return "CONNECT_STATE_SUSPENDED";
                }
            }
            return "UNKNOWN/" + state;
        }

        private final void onServiceConnected(final IMediaBrowserServiceCompatCallbacks callback, final String root, final MediaSessionCompat.Token session, final Bundle extra) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (!MediaBrowserImplBase.this.isCurrent(callback, "onConnect")) {
                        return;
                    }
                    if (MediaBrowserImplBase.this.mState != 1) {
                        Log.w((String)MediaBrowserImplBase.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(MediaBrowserImplBase.this.mState) + "... ignoring"));
                        return;
                    }
                    MediaBrowserImplBase.this.mRootId = root;
                    MediaBrowserImplBase.this.mMediaSessionToken = session;
                    MediaBrowserImplBase.this.mExtras = extra;
                    MediaBrowserImplBase.this.mState = 2;
                    MediaBrowserImplBase.this.mCallback.onConnected();
                    for (String id : MediaBrowserImplBase.this.mSubscriptions.keySet()) {
                        try {
                            MediaBrowserImplBase.this.mServiceBinder.addSubscription(id, MediaBrowserImplBase.this.mServiceCallbacks);
                        }
                        catch (RemoteException ex) {
                            Log.d((String)MediaBrowserImplBase.TAG, (String)("addSubscription failed with RemoteException parentId=" + id));
                        }
                    }
                }
            });
        }

        private final void onConnectionFailed(final IMediaBrowserServiceCompatCallbacks callback) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Log.e((String)MediaBrowserImplBase.TAG, (String)("onConnectFailed for " + MediaBrowserImplBase.this.mServiceComponent));
                    if (!MediaBrowserImplBase.this.isCurrent(callback, "onConnectFailed")) {
                        return;
                    }
                    if (MediaBrowserImplBase.this.mState != 1) {
                        Log.w((String)MediaBrowserImplBase.TAG, (String)("onConnect from service while mState=" + MediaBrowserImplBase.getStateLabel(MediaBrowserImplBase.this.mState) + "... ignoring"));
                        return;
                    }
                    MediaBrowserImplBase.this.forceCloseConnection();
                    MediaBrowserImplBase.this.mCallback.onConnectionFailed();
                }
            });
        }

        private final void onLoadChildren(final IMediaBrowserServiceCompatCallbacks callback, final String parentId, final List list) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    Subscription subscription;
                    if (!MediaBrowserImplBase.this.isCurrent(callback, "onLoadChildren")) {
                        return;
                    }
                    List<MediaItem> data = list;
                    if (data == null) {
                        data = Collections.emptyList();
                    }
                    if ((subscription = (Subscription)MediaBrowserImplBase.this.mSubscriptions.get(parentId)) == null) {
                        return;
                    }
                    subscription.callback.onChildrenLoaded(parentId, data);
                }
            });
        }

        private boolean isCurrent(IMediaBrowserServiceCompatCallbacks callback, String funcName) {
            if (this.mServiceCallbacks != callback) {
                if (this.mState != 0) {
                    Log.i((String)TAG, (String)(funcName + " for " + this.mServiceComponent + " with mServiceConnection=" + this.mServiceCallbacks + " this=" + this));
                }
                return false;
            }
            return true;
        }

        private ServiceCallbacks getNewServiceCallbacks() {
            return new ServiceCallbacks(this);
        }

        void dump() {
            Log.d((String)TAG, (String)"MediaBrowserCompat...");
            Log.d((String)TAG, (String)("  mServiceComponent=" + this.mServiceComponent));
            Log.d((String)TAG, (String)("  mCallback=" + this.mCallback));
            Log.d((String)TAG, (String)("  mRootHints=" + this.mRootHints));
            Log.d((String)TAG, (String)("  mState=" + MediaBrowserImplBase.getStateLabel(this.mState)));
            Log.d((String)TAG, (String)("  mServiceConnection=" + this.mServiceConnection));
            Log.d((String)TAG, (String)("  mServiceBinder=" + this.mServiceBinder));
            Log.d((String)TAG, (String)("  mServiceCallbacks=" + this.mServiceCallbacks));
            Log.d((String)TAG, (String)("  mRootId=" + this.mRootId));
            Log.d((String)TAG, (String)("  mMediaSessionToken=" + this.mMediaSessionToken));
        }

        private static class Subscription {
            final String id;
            SubscriptionCallback callback;

            Subscription(String id) {
                this.id = id;
            }
        }

        private static class ServiceCallbacks
        extends IMediaBrowserServiceCompatCallbacks.Stub {
            private WeakReference<MediaBrowserImplBase> mMediaBrowser;

            public ServiceCallbacks(MediaBrowserImplBase mediaBrowser) {
                this.mMediaBrowser = new WeakReference<MediaBrowserImplBase>(mediaBrowser);
            }

            @Override
            public void onConnect(String root, MediaSessionCompat.Token session, Bundle extras) {
                MediaBrowserImplBase mediaBrowser = (MediaBrowserImplBase)this.mMediaBrowser.get();
                if (mediaBrowser != null) {
                    mediaBrowser.onServiceConnected(this, root, session, extras);
                }
            }

            @Override
            public void onConnectFailed() {
                MediaBrowserImplBase mediaBrowser = (MediaBrowserImplBase)this.mMediaBrowser.get();
                if (mediaBrowser != null) {
                    mediaBrowser.onConnectionFailed(this);
                }
            }

            @Override
            public void onLoadChildren(String parentId, List list) {
                MediaBrowserImplBase mediaBrowser = (MediaBrowserImplBase)this.mMediaBrowser.get();
                if (mediaBrowser != null) {
                    mediaBrowser.onLoadChildren(this, parentId, list);
                }
            }
        }

        private class MediaServiceConnection
        implements ServiceConnection {
            private MediaServiceConnection() {
            }

            public void onServiceConnected(ComponentName name, IBinder binder) {
                if (!this.isCurrent("onServiceConnected")) {
                    return;
                }
                MediaBrowserImplBase.this.mServiceBinder = IMediaBrowserServiceCompat.Stub.asInterface(binder);
                MediaBrowserImplBase.this.mServiceCallbacks = MediaBrowserImplBase.this.getNewServiceCallbacks();
                MediaBrowserImplBase.this.mState = 1;
                try {
                    MediaBrowserImplBase.this.mServiceBinder.connect(MediaBrowserImplBase.this.mContext.getPackageName(), MediaBrowserImplBase.this.mRootHints, MediaBrowserImplBase.this.mServiceCallbacks);
                }
                catch (RemoteException ex) {
                    Log.w((String)MediaBrowserImplBase.TAG, (String)("RemoteException during connect for " + MediaBrowserImplBase.this.mServiceComponent));
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                if (!this.isCurrent("onServiceDisconnected")) {
                    return;
                }
                MediaBrowserImplBase.this.mServiceBinder = null;
                MediaBrowserImplBase.this.mServiceCallbacks = null;
                MediaBrowserImplBase.this.mState = 3;
                MediaBrowserImplBase.this.mCallback.onConnectionSuspended();
            }

            private boolean isCurrent(String funcName) {
                if (MediaBrowserImplBase.this.mServiceConnection != this) {
                    if (MediaBrowserImplBase.this.mState != 0) {
                        Log.i((String)MediaBrowserImplBase.TAG, (String)(funcName + " for " + MediaBrowserImplBase.this.mServiceComponent + " with mServiceConnection=" + MediaBrowserImplBase.this.mServiceConnection + " this=" + this));
                    }
                    return false;
                }
                return true;
            }
        }
    }

    public static abstract class ItemCallback {
        public void onItemLoaded(MediaItem item) {
        }

        public void onError(@NonNull String itemId) {
        }
    }

    public static abstract class SubscriptionCallback {
        public void onChildrenLoaded(@NonNull String parentId, @NonNull List<MediaItem> children) {
        }

        public void onError(@NonNull String parentId) {
        }
    }

    public static class ConnectionCallback {
        public void onConnected() {
        }

        public void onConnectionSuspended() {
        }

        public void onConnectionFailed() {
        }
    }

    public static class MediaItem
    implements Parcelable {
        private final int mFlags;
        private final MediaDescriptionCompat mDescription;
        public static final int FLAG_BROWSABLE = 1;
        public static final int FLAG_PLAYABLE = 2;
        public static final Parcelable.Creator<MediaItem> CREATOR = new Parcelable.Creator<MediaItem>(){

            public MediaItem createFromParcel(Parcel in) {
                return new MediaItem(in);
            }

            public MediaItem[] newArray(int size) {
                return new MediaItem[size];
            }
        };

        public MediaItem(@NonNull MediaDescriptionCompat description, int flags) {
            if (description == null) {
                throw new IllegalArgumentException("description cannot be null");
            }
            if (TextUtils.isEmpty((CharSequence)description.getMediaId())) {
                throw new IllegalArgumentException("description must have a non-empty media id");
            }
            this.mFlags = flags;
            this.mDescription = description;
        }

        private MediaItem(Parcel in) {
            this.mFlags = in.readInt();
            this.mDescription = (MediaDescriptionCompat)MediaDescriptionCompat.CREATOR.createFromParcel(in);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mFlags);
            this.mDescription.writeToParcel(out, flags);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("MediaItem{");
            sb.append("mFlags=").append(this.mFlags);
            sb.append(", mDescription=").append(this.mDescription);
            sb.append('}');
            return sb.toString();
        }

        public int getFlags() {
            return this.mFlags;
        }

        public boolean isBrowsable() {
            return (this.mFlags & 1) != 0;
        }

        public boolean isPlayable() {
            return (this.mFlags & 2) != 0;
        }

        @NonNull
        public MediaDescriptionCompat getDescription() {
            return this.mDescription;
        }

        @NonNull
        public String getMediaId() {
            return this.mDescription.getMediaId();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Flags {
        }
    }
}

