//    Copyright (C) 2010 Dirk Vanden Boer <dirk.vdb@gmail.com>
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "kffmpegthumbnailer.h"

#include <QImage>

extern "C"
{
    KDE_EXPORT ThumbCreator* new_creator()
    {
        return new KFFMpegThumbnailer();
    }
}


KFFMpegThumbnailer::KFFMpegThumbnailer()
{
    m_Thumbnailer.addFilter(&m_FilmStrip);
}

KFFMpegThumbnailer::~KFFMpegThumbnailer()
{
}

bool KFFMpegThumbnailer::create(const QString& path, int width, int /*heigth*/, QImage& img)
{
    try
    {
        std::vector<uint8_t> pixelBuffer;
        
        m_Thumbnailer.setThumbnailSize(width);    
        m_Thumbnailer.generateThumbnail(std::string(path.toUtf8()), Png, pixelBuffer);
        
        if (!img.loadFromData(&pixelBuffer.front(), pixelBuffer.size(), "PNG"))
        {
            return false;
        }
    }
    catch (std::exception& e)
    {
        return false;
    }
    
    return true;
}

ThumbCreator::Flags KFFMpegThumbnailer::flags() const
{
    return (Flags)(DrawFrame);
}

