/*
cc -g -o demo/classes libisofs/hfsplus_classes_test.c
*/
#include <stdint.h>
#include <string.h>
#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif

#include "hfsplus.h"

/* ======== Copy of original class pages : hfsplus_class_pages_old ======== */

/* Based on Unicode 3.2.0.  */

static uint16_t page03[256] = {
  [0x00] = 0x230,
  [0x01] = 0x230,
  [0x02] = 0x230,
  [0x03] = 0x230,
  [0x04] = 0x230,
  [0x05] = 0x230,
  [0x06] = 0x230,
  [0x07] = 0x230,
  [0x08] = 0x230,
  [0x09] = 0x230,
  [0x0a] = 0x230,
  [0x0b] = 0x230,
  [0x0c] = 0x230,
  [0x0d] = 0x230,
  [0x0e] = 0x230,
  [0x0f] = 0x230,
  [0x10] = 0x230,
  [0x11] = 0x230,
  [0x12] = 0x230,
  [0x13] = 0x230,
  [0x14] = 0x230,
  [0x15] = 0x232,
  [0x16] = 0x220,
  [0x17] = 0x220,
  [0x18] = 0x220,
  [0x19] = 0x220,
  [0x1a] = 0x232,
  [0x1b] = 0x216,
  [0x1c] = 0x220,
  [0x1d] = 0x220,
  [0x1e] = 0x220,
  [0x1f] = 0x220,
  [0x20] = 0x220,
  [0x21] = 0x202,
  [0x22] = 0x202,
  [0x23] = 0x220,
  [0x24] = 0x220,
  [0x25] = 0x220,
  [0x26] = 0x220,
  [0x27] = 0x202,
  [0x28] = 0x202,
  [0x29] = 0x220,
  [0x2a] = 0x220,
  [0x2b] = 0x220,
  [0x2c] = 0x220,
  [0x2d] = 0x220,
  [0x2e] = 0x220,
  [0x2f] = 0x220,
  [0x30] = 0x220,
  [0x31] = 0x220,
  [0x32] = 0x220,
  [0x33] = 0x220,
  [0x34] = 0x1,
  [0x35] = 0x1,
  [0x36] = 0x1,
  [0x37] = 0x1,
  [0x38] = 0x1,
  [0x39] = 0x220,
  [0x3a] = 0x220,
  [0x3b] = 0x220,
  [0x3c] = 0x220,
  [0x3d] = 0x230,
  [0x3e] = 0x230,
  [0x3f] = 0x230,
  [0x40] = 0x230,
  [0x41] = 0x230,
  [0x42] = 0x230,
  [0x43] = 0x230,
  [0x44] = 0x230,
  [0x45] = 0x240,
  [0x46] = 0x230,
  [0x47] = 0x220,
  [0x48] = 0x220,
  [0x49] = 0x220,
  [0x4a] = 0x230,
  [0x4b] = 0x230,
  [0x4c] = 0x230,
  [0x4d] = 0x220,
  [0x4e] = 0x220,
  [0x60] = 0x234,
  [0x61] = 0x234,
  [0x62] = 0x233,
  [0x63] = 0x230,
  [0x64] = 0x230,
  [0x65] = 0x230,
  [0x66] = 0x230,
  [0x67] = 0x230,
  [0x68] = 0x230,
  [0x69] = 0x230,
  [0x6a] = 0x230,
  [0x6b] = 0x230,
  [0x6c] = 0x230,
  [0x6d] = 0x230,
  [0x6e] = 0x230,
  [0x6f] = 0x230,
};

static uint16_t page04[256] = {
  [0x83] = 0x230,
  [0x84] = 0x230,
  [0x85] = 0x230,
  [0x86] = 0x230,
};

static uint16_t page05[256] = {
  [0x91] = 0x220,
  [0x92] = 0x230,
  [0x93] = 0x230,
  [0x94] = 0x230,
  [0x95] = 0x230,
  [0x96] = 0x220,
  [0x97] = 0x230,
  [0x98] = 0x230,
  [0x99] = 0x230,
  [0x9a] = 0x222,
  [0x9b] = 0x220,
  [0x9c] = 0x230,
  [0x9d] = 0x230,
  [0x9e] = 0x230,
  [0x9f] = 0x230,
  [0xa0] = 0x230,
  [0xa1] = 0x230,
  [0xa3] = 0x220,
  [0xa4] = 0x220,
  [0xa5] = 0x220,
  [0xa6] = 0x220,
  [0xa7] = 0x220,
  [0xa8] = 0x230,
  [0xa9] = 0x230,
  [0xaa] = 0x220,
  [0xab] = 0x230,
  [0xac] = 0x230,
  [0xad] = 0x222,
  [0xae] = 0x228,
  [0xaf] = 0x230,
  [0xb0] = 0x10,
  [0xb1] = 0x11,
  [0xb2] = 0x12,
  [0xb3] = 0x13,
  [0xb4] = 0x14,
  [0xb5] = 0x15,
  [0xb6] = 0x16,
  [0xb7] = 0x17,
  [0xb8] = 0x18,
  [0xb9] = 0x19,
  [0xbb] = 0x20,
  [0xbc] = 0x21,
  [0xbd] = 0x22,
  [0xbf] = 0x23,
  [0xc1] = 0x24,
  [0xc2] = 0x25,
  [0xc4] = 0x230,
};

static uint16_t page06[256] = {
  [0x4b] = 0x27,
  [0x4c] = 0x28,
  [0x4d] = 0x29,
  [0x4e] = 0x30,
  [0x4f] = 0x31,
  [0x50] = 0x32,
  [0x51] = 0x33,
  [0x52] = 0x34,
  [0x53] = 0x230,
  [0x54] = 0x230,
  [0x55] = 0x220,
  [0x70] = 0x35,
  [0xd6] = 0x230,
  [0xd7] = 0x230,
  [0xd8] = 0x230,
  [0xd9] = 0x230,
  [0xda] = 0x230,
  [0xdb] = 0x230,
  [0xdc] = 0x230,
  [0xdf] = 0x230,
  [0xe0] = 0x230,
  [0xe1] = 0x230,
  [0xe2] = 0x230,
  [0xe3] = 0x220,
  [0xe4] = 0x230,
  [0xe7] = 0x230,
  [0xe8] = 0x230,
  [0xea] = 0x220,
  [0xeb] = 0x230,
  [0xec] = 0x230,
  [0xed] = 0x220,
};

static uint16_t page07[256] = {
  [0x11] = 0x36,
  [0x30] = 0x230,
  [0x31] = 0x220,
  [0x32] = 0x230,
  [0x33] = 0x230,
  [0x34] = 0x220,
  [0x35] = 0x230,
  [0x36] = 0x230,
  [0x37] = 0x220,
  [0x38] = 0x220,
  [0x39] = 0x220,
  [0x3a] = 0x230,
  [0x3b] = 0x220,
  [0x3c] = 0x220,
  [0x3d] = 0x230,
  [0x3e] = 0x220,
  [0x3f] = 0x230,
  [0x40] = 0x230,
  [0x41] = 0x230,
  [0x42] = 0x220,
  [0x43] = 0x230,
  [0x44] = 0x220,
  [0x45] = 0x230,
  [0x46] = 0x220,
  [0x47] = 0x230,
  [0x48] = 0x220,
  [0x49] = 0x230,
  [0x4a] = 0x230,
};

static uint16_t page09[256] = {
  [0x3c] = 0x7,
  [0x4d] = 0x9,
  [0x51] = 0x230,
  [0x52] = 0x220,
  [0x53] = 0x230,
  [0x54] = 0x230,
  [0xbc] = 0x7,
  [0xcd] = 0x9,
};

static uint16_t page0a[256] = {
  [0x3c] = 0x7,
  [0x4d] = 0x9,
  [0xbc] = 0x7,
  [0xcd] = 0x9,
};

static uint16_t page0b[256] = {
  [0x3c] = 0x7,
  [0x4d] = 0x9,
  [0xcd] = 0x9,
};

static uint16_t page0c[256] = {
  [0x4d] = 0x9,
  [0x55] = 0x84,
  [0x56] = 0x91,
  [0xcd] = 0x9,
};

static uint16_t page0d[256] = {
  [0x4d] = 0x9,
  [0xca] = 0x9,
};

static uint16_t page0e[256] = {
  [0x38] = 0x103,
  [0x39] = 0x103,
  [0x3a] = 0x9,
  [0x48] = 0x107,
  [0x49] = 0x107,
  [0x4a] = 0x107,
  [0x4b] = 0x107,
  [0xb8] = 0x118,
  [0xb9] = 0x118,
  [0xc8] = 0x122,
  [0xc9] = 0x122,
  [0xca] = 0x122,
  [0xcb] = 0x122,
};

static uint16_t page0f[256] = {
  [0x18] = 0x220,
  [0x19] = 0x220,
  [0x35] = 0x220,
  [0x37] = 0x220,
  [0x39] = 0x216,
  [0x71] = 0x129,
  [0x72] = 0x130,
  [0x74] = 0x132,
  [0x7a] = 0x130,
  [0x7b] = 0x130,
  [0x7c] = 0x130,
  [0x7d] = 0x130,
  [0x80] = 0x130,
  [0x82] = 0x230,
  [0x83] = 0x230,
  [0x84] = 0x9,
  [0x86] = 0x230,
  [0x87] = 0x230,
  [0xc6] = 0x220,
};

static uint16_t page10[256] = {
  [0x37] = 0x7,
  [0x39] = 0x9,
};

static uint16_t page17[256] = {
  [0x14] = 0x9,
  [0x34] = 0x9,
  [0xd2] = 0x9,
};

static uint16_t page18[256] = {
  [0xa9] = 0x228,
};

static uint16_t page20[256] = {
  [0xd0] = 0x230,
  [0xd1] = 0x230,
  [0xd2] = 0x1,
  [0xd3] = 0x1,
  [0xd4] = 0x230,
  [0xd5] = 0x230,
  [0xd6] = 0x230,
  [0xd7] = 0x230,
  [0xd8] = 0x1,
  [0xd9] = 0x1,
  [0xda] = 0x1,
  [0xdb] = 0x230,
  [0xdc] = 0x230,
  [0xe1] = 0x230,
  [0xe5] = 0x1,
  [0xe6] = 0x1,
  [0xe7] = 0x230,
  [0xe8] = 0x220,
  [0xe9] = 0x230,
  [0xea] = 0x1,
};

static uint16_t page30[256] = {
  [0x2a] = 0x218,
  [0x2b] = 0x228,
  [0x2c] = 0x232,
  [0x2d] = 0x222,
  [0x2e] = 0x224,
  [0x2f] = 0x224,
  [0x99] = 0x8,
  [0x9a] = 0x8,
};

static uint16_t pagefb[256] = {
  [0x1e] = 0x26,
};

static uint16_t pagefe[256] = {
  [0x20] = 0x230,
  [0x21] = 0x230,
  [0x22] = 0x230,
  [0x23] = 0x230,
};

const uint16_t *hfsplus_class_pages_old[256] = {
  [0x03] = page03,
  [0x04] = page04,
  [0x05] = page05,
  [0x06] = page06,
  [0x07] = page07,
  [0x09] = page09,
  [0x0a] = page0a,
  [0x0b] = page0b,
  [0x0c] = page0c,
  [0x0d] = page0d,
  [0x0e] = page0e,
  [0x0f] = page0f,
  [0x10] = page10,
  [0x17] = page17,
  [0x18] = page18,
  [0x20] = page20,
  [0x30] = page30,
  [0xfb] = pagefb,
  [0xfe] = pagefe,
};


/* ================================ Test Setup =========================== */

/* The new implementation */
#include  "hfsplus_classes_ts.c"

static int compare_class_pages()
{
    int i, j;

    for (i = 0; i < 256; i++) {
        if (hfsplus_class_pages_old[i] == NULL) {
            if (hfsplus_class_pages[i] == NULL)
    continue;
            fprintf(stderr, "DIFF : i= %d , ts != NULL\n", i);
            return 0;
        } else if (hfsplus_class_pages[i] == NULL) {
            fprintf(stderr, "DIFF : i= %d , ts == NULL\n", i);
            return 0;
        }
        for (j = 0; j < 256; j++)
             if (hfsplus_class_pages_old[i][j] !=
                 hfsplus_class_pages[i][j]) {
                 fprintf(stderr, "DIFF : i= %d , j= %d : %4.4x !+ %4.4x\n",
                                 i, j, hfsplus_class_pages[i][j],
                                 hfsplus_class_pages[i][j]);
                     return 0;
                 }
    }
    return 1;
}

main()
{

 make_hfsplus_class_pages();

 /* <<< intentional deviations */
 /* hfsplus_class_pages[3][1] = 0xffff; */
 /* hfsplus_class_pages_old[3] = NULL; */

 compare_class_pages();

 exit(0);
}


