#ifndef TARGET_TOOL
#include <common.h>
#include <asm/arch/factory.h>
#include "clock_config.h"
#endif

#include "ddr.h"
#include "tgt_ap_clock_config.h"

static const struct clock_config clock_default_config = {
	/* Header */
	0, 			// MAGIC;
	CLOCK_VER_MAJOR,	// VERSION_MAJOR;
	CLOCK_VER_MINOR,	// VERSION_MINOR;
	/* PLL Freqs (MHz) */
	_TGT_AP_PLL_CPU_FREQ,	// PLL_FREQ_CPU; /* 05, 06 */
	_TGT_AP_PLL_BUS_FREQ,	// PLL_FREQ_BUS; /* 25, 26 */
	_TGT_AP_PLL_MEM_FREQ,	// PLL_FREQ_MEM; /* 65, 66 */
	_TGT_AP_PLL_USB_FREQ,	// PLL_FREQ_USB; /* 85, 86 */
	/* DDR Cal */
	0,			// DDR_CAL;
	/* DDR_FLAGS */
	DDR_FLAGS_ODT(_TGT_AP_DDR_ODT)	// 010 -- 120 Ohm
#if (_TGT_AP_DDR_CLOCK < 200)
	    | DDR_FLAGS_DLLOFF
#endif
#ifdef _TGT_AP_DDR_LOWPWR
	    | DDR_FLAGS_LOWPWR
#endif
	    | DDR_FLAGS_RON(_TGT_AP_DDR_RON),	// 00 -- 40 Ohm

	/* DDR_PARA */
	DDR_PARA_CHIP_BITS(_TGT_AP_DDR_CHIP_BITS)
	    | DDR_PARA_MEM_BITS(_TGT_AP_DDR_MEM_BITS)
	    | DDR_PARA_BANK_BITS(_TGT_AP_DDR_BANK_BITS)
	    | DDR_PARA_ROW_BITS(_TGT_AP_DDR_ROW_BITS )
	    | DDR_PARA_COL_BITS(_TGT_AP_DDR_COL_BITS),

	/* AP sysctrl */
	_TGT_AP_CLK_CPU,	// CLK_CPU;
	_TGT_AP_CLK_AXI,	// CLK_AXI;
	_TGT_AP_CLK_GCG,	// CLK_GCG;
	_TGT_AP_CLK_AHB1,	// CLK_AHB1;
	_TGT_AP_CLK_APB1,	// CLK_APB1;
	_TGT_AP_CLK_APB2,	// CLK_APB2;
	_TGT_AP_CLK_MEM,	// CLK_MEM;
	_TGT_AP_CLK_GPU,	// CLK_GPU;
	_TGT_AP_CLK_VPU,	// CLK_VPU;
	_TGT_AP_CLK_VOC,	// CLK_VOC;
	_TGT_AP_CLK_SFLSH,	// CLK_SFLSH;
	0,			// RESERVE;

	/* DDR timings, defined in target */
	DDR_CHAN_1_VALID_VAL,	// DDR_CHAN_1_VALID;
	DDR_TIMING_101H_VAL,	// DDR_TIMING_101H;
	DDR_TIMING_102H_VAL,	// DDR_TIMING_102H;
	DDR_TIMING_103H_VAL,	// DDR_TIMING_103H;
	DDR_TIMING_104H_VAL,	// DDR_TIMING_104H;
	DDR_TIMING_105H_VAL,	// DDR_TIMING_105H;
	DDR_TIMING_106H_VAL,	// DDR_TIMING_106H;
	DDR_TIMING_107H_VAL,	// DDR_TIMING_107H;
	DDR_TIMING_108H_VAL,	// DDR_TIMING_108H;
	DDR_TIMING_109H_VAL,	// DDR_TIMING_109H;
	DDR_TIMING_10AH_VAL,	// DDR_TIMING_10AH;
	DDR_TIMING_10BH_VAL,	// DDR_TIMING_10BH;
	DDR_TIMING_10CH_VAL,	// DDR_TIMING_10CH;
	DDR_TIMING_10DH_VAL,	// DDR_TIMING_10DH;
	DDR_TIMING_10EH_VAL,	// DDR_TIMING_10EH;
	DDR_TIMING_10FH_VAL,	// DDR_TIMING_10FH;

	DDR_CHAN_2_VALID_VAL,	// DDR_CHAN_2_VALID;
	DDR_TIMING_121H_VAL,	// DDR_TIMING_121H;
	DDR_TIMING_122H_VAL,	// DDR_TIMING_122H;
	DDR_TIMING_123H_VAL,	// DDR_TIMING_123H;
	DDR_TIMING_124H_VAL,	// DDR_TIMING_124H;
	DDR_TIMING_125H_VAL,	// DDR_TIMING_125H;
	DDR_TIMING_126H_VAL,	// DDR_TIMING_126H;
	DDR_TIMING_127H_VAL,	// DDR_TIMING_127H;
	DDR_TIMING_128H_VAL,	// DDR_TIMING_128H;
	DDR_TIMING_129H_VAL,	// DDR_TIMING_129H;
	DDR_TIMING_12AH_VAL,	// DDR_TIMING_12AH;
	DDR_TIMING_12BH_VAL,	// DDR_TIMING_12BH;
	DDR_TIMING_12CH_VAL,	// DDR_TIMING_12CH;
	DDR_TIMING_12DH_VAL,	// DDR_TIMING_12DH;
	DDR_TIMING_12EH_VAL,	// DDR_TIMING_12EH;
	DDR_TIMING_12FH_VAL,	// DDR_TIMING_12FH;

	DDR_CHAN_3_VALID_VAL,	// DDR_CHAN_3_VALID;
	DDR_TIMING_141H_VAL,	// DDR_TIMING_141H;
	DDR_TIMING_142H_VAL,	// DDR_TIMING_142H;
	DDR_TIMING_143H_VAL,	// DDR_TIMING_143H;
	DDR_TIMING_144H_VAL,	// DDR_TIMING_144H;
	DDR_TIMING_145H_VAL,	// DDR_TIMING_145H;
	DDR_TIMING_146H_VAL,	// DDR_TIMING_146H;
	DDR_TIMING_147H_VAL,	// DDR_TIMING_147H;
	DDR_TIMING_148H_VAL,	// DDR_TIMING_148H;
	DDR_TIMING_149H_VAL,	// DDR_TIMING_149H;
	DDR_TIMING_14AH_VAL,	// DDR_TIMING_14AH;
	DDR_TIMING_14BH_VAL,	// DDR_TIMING_14BH;
	DDR_TIMING_14CH_VAL,	// DDR_TIMING_14CH;
	DDR_TIMING_14DH_VAL,	// DDR_TIMING_14DH;
	DDR_TIMING_14EH_VAL,	// DDR_TIMING_14EH;
	DDR_TIMING_14FH_VAL,	// DDR_TIMING_14FH;

	DDR_CHAN_4_VALID_VAL,	// DDR_CHAN_4_VALID;
	DDR_TIMING_161H_VAL,	// DDR_TIMING_161H;
	DDR_TIMING_162H_VAL,	// DDR_TIMING_162H;
	DDR_TIMING_163H_VAL,	// DDR_TIMING_163H;
	DDR_TIMING_164H_VAL,	// DDR_TIMING_164H;
	DDR_TIMING_165H_VAL,	// DDR_TIMING_165H;
	DDR_TIMING_166H_VAL,	// DDR_TIMING_166H;
	DDR_TIMING_167H_VAL,	// DDR_TIMING_167H;
	DDR_TIMING_168H_VAL,	// DDR_TIMING_168H;
	DDR_TIMING_169H_VAL,	// DDR_TIMING_169H;
	DDR_TIMING_16AH_VAL,	// DDR_TIMING_16AH;
	DDR_TIMING_16BH_VAL,	// DDR_TIMING_16BH;
	DDR_TIMING_16CH_VAL,	// DDR_TIMING_16CH;
	DDR_TIMING_16DH_VAL,	// DDR_TIMING_16DH;
	DDR_TIMING_16EH_VAL,	// DDR_TIMING_16EH;
	DDR_TIMING_16FH_VAL,	// DDR_TIMING_16FH;

	DDR_TIMING_160H_VAL,	// DDR_TIMING_160H;
	DDR_TIMING_180H_VAL,	// DDR_TIMING_180H;
	DDR_TIMING_181H_VAL,	// DDR_TIMING_181H;
	DDR_TIMING_182H_VAL,	// DDR_TIMING_182H;
	DDR_TIMING_183H_VAL,	// DDR_TIMING_183H;
	DDR_TIMING_184H_VAL,	// DDR_TIMING_184H;
	DDR_TIMING_185H_VAL,	// DDR_TIMING_185H;
	DDR_TIMING_186H_VAL,	// DDR_TIMING_186H;
	DDR_TIMING_187H_VAL,	// DDR_TIMING_187H;
	DDR_TIMING_188H_VAL,	// DDR_TIMING_188H;
	DDR_TIMING_189H_VAL,	// DDR_TIMING_189H;
	DDR_TIMING_18AH_VAL,	// DDR_TIMING_18AH;
	DDR_TIMING_18BH_VAL,	// DDR_TIMING_18BH;
	DDR_TIMING_18CH_VAL,	// DDR_TIMING_18CH;
	DDR_TIMING_18DH_VAL,	// DDR_TIMING_18DH;
	DDR_TIMING_18EH_VAL,	// DDR_TIMING_18EH;
	DDR_TIMING_18FH_VAL,	// DDR_TIMING_18FH;
	DDR_TIMING_69H_VAL,	// DDR_TIMING_69H;
};

const struct clock_config *get_default_clock_config(void)
{
#ifndef TARGET_TOOL
	BUILD_BUG_ON(sizeof(struct clock_config) > AP_FACTORY_CLOCK_CFG_LEN);
#endif

	return &clock_default_config;
}

