# NMake Makefile portion for displaying config info

INC_FEATURES = Uniscribe Fallback OT
BUILT_TOOLS =
BUILT_LIBRARIES = HarfBuzz

!if "$(GLIB)" == "1"
UNICODE_IMPL = GLib
INC_FEATURES = $(INC_FEATURES) GLib
BUILT_TOOLS = hb-shape.exe hb-ot-shape-closure.exe
!if "$(CAIRO_FT)" == "1"
BUILT_TOOLS = hb-view.exe $(BUILT_TOOLS)
!endif
!else
UNICODE_IMPL = ucdn
!endif

!if "$(FREETYPE)" == "1"
INC_FEATURES = $(INC_FEATURES) FreeType
!endif

!if "$(GRAPHITE2)" == "1"
INC_FEATURES = $(INC_FEATURES) Graphite2
!endif

!if "$(DIRECTWRITE)" == "1"
INC_FEATURES = $(INC_FEATURES) DirectWrite
!endif

!if "$(ICU)" == "1"
BUILT_LIBRARIES = $(BUILT_LIBRARIES) HarfBuzz-ICU
!endif

!if "$(GOBJECT)" == "1"
BUILT_LIBRARIES = $(BUILT_LIBRARIES) HarfBuzz-GObject
!endif

!if "$(INTROSPECTION)" == "1"
BUILD_INTROSPECTION = yes
!else
BUILD_INTROSPECTION = no
!endif

build-info-hb:
	@echo.
	@echo ==================================
	@echo Configuration for HarfBuzz Library
	@echo ==================================
	@echo Unicode Implementation: $(UNICODE_IMPL)
	@echo Enabled Features: $(INC_FEATURES)

all-build-info: build-info-hb
	@echo.
	@echo ----------------
	@echo Other build info
	@echo ----------------
	@echo Built Libraries: $(BUILT_LIBRARIES)
	@echo Built Tools: $(BUILT_TOOLS)
	@echo Introspection: $(BUILD_INTROSPECTION)

help:
	@echo.
	@echo =============================
	@echo Building HarfBuzz Using NMake
	@echo =============================
	@echo nmake /f Makefile.vc CFG=[release^|debug] ^<PREFIX=PATH^> OPTION=1 ...
	@echo.
	@echo Where:
	@echo ------
	@echo CFG: Required, use CFG=release for an optimized build and CFG=debug
	@echo for a debug build.  PDB files are generated for all builds.
	@echo.
	@echo PREFIX: Optional, the path where dependent libraries and tools may be
	@echo found, default is ^$(srcrootdir)\..\vs^$(short_vs_ver)\^$(platform),
	@echo where ^$(short_vs_ver) is 9 for VS 2008, 10 for VS 2010 and so on; and
	@echo ^$(platform) is Win32 for 32-bit builds and x64 for x64 builds.
	@echo.
	@echo OPTION: Optional, may be any of the following, use OPTION=1 to enable;
	@echo multiple OPTION's may be used.  If no OPTION is specified, a default
	@echo HarfBuzz DLL is built with OpenType, fallback and Uniscribe support
	@echo with a bundled Unicode implementation (UCDN).
	@echo ======
	@echo DIRECTWRITE:
	@echo Enable DirectWrite support, requires a recent enough Windows SDK.
	@echo.
	@echo GRAPHITE2:
	@echo Enable graphite2 support, requires the SIL Graphite2 library
	@echo.
	@echo FREETYPE:
	@echo Enable FreeType2 support, requires the FreeType2 library
	@echo.
	@echo GLIB:
	@echo Enable GLib2 support, with GLib Unicode support, requires the GNOME GLib2
	@echo library.  Enables the build of utility programs.
	@echo.
	@echo ICU:
	@echo Enable the HarfBuzz-ICU layout library, requires the International
	@echo Components for Unicode (ICU) libraries.
	@echo.
	@echo GOBJECT:
	@echo Enable the HarfBuzz-GObject library, also implies GLib2 support,
	@echo requires the GNOME GLib2 libraries and tools, notably the glib-mkenums
	@echo tool script, which will require a PERL interpretor (use
	@echo PERL=^$(PATH_TO_PERL_INTERPRETOR)) if it is not already in your PATH).
	@echo.
	@echo INTROSPECTION:
	@echo Enable the build of introspection files, also implies GObject/GLib2 support,
	@echo requires the GNOME gobject-introspection libraries and tools.  You will need
	@echo to ensure the pkg-config (.pc) files can be found for GObject-2.0 and the
	@echo Python interpretor (that was used to build the gobject-introsoection tools)
	@echo can be found by setting PKG_CONFIG_PATH beforehand, and passing in PYTHON=
	@echo ^$(PATH_TO_PYTHON_INTERPRETOR) respectively, if python.exe is not already
	@echo in your PATH.
	@echo.
	@echo CAIRO_FT:
	@echo Enables Cairo-Freetype support, needed for the build of the hb-view utility.
	@echo Implies FreeType2 support and also requires Cairo built with FreeType2
	@echo support; GLib2 support must also be enabled.
	@echo.
	@echo LIBTOOL_DLL_NAME:
	@echo Use a libtool-style DLL name to mimic the DLL file naming generated by
	@echo MinGW builds.
	@echo.
	@echo Note that GLib2 support is required for all utility and test programs.
	@echo ======
	@echo A 'clean' target is supported to remove all generated files, intermediate
	@echo object files and binaries for the specified configuration.
	@echo.
	@echo A 'tests' target is supported to build the test programs, if GLib2 support
	@echo is enabled.  Use after building the libraries and utilities.
	@echo.
	@echo An 'install' target is supported to copy the build (DLLs, utility programs,
	@echo LIBs, along with the introspection files if applicable) to appropriate
	@echo locations under ^$(PREFIX).
	@echo ======
	@echo.
	
