/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.Hashtable;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.IgnoredTestListener;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class PlainJUnitResultFormatter
implements JUnitResultFormatter,
IgnoredTestListener {
    private static final double ONE_SECOND = 1000.0;
    private NumberFormat nf = NumberFormat.getInstance();
    private Hashtable testStarts = new Hashtable();
    private OutputStream out;
    private StringWriter inner;
    private BufferedWriter wri;
    private Hashtable failed = new Hashtable();
    private String systemOutput = null;
    private String systemError = null;

    public PlainJUnitResultFormatter() {
        this.inner = new StringWriter();
        this.wri = new BufferedWriter(this.inner);
    }

    public void setOutput(OutputStream out) {
        this.out = out;
    }

    public void setSystemOutput(String out) {
        this.systemOutput = out;
    }

    public void setSystemError(String err) {
        this.systemError = err;
    }

    public void startTestSuite(JUnitTest suite) throws BuildException {
        if (this.out == null) {
            return;
        }
        StringBuffer sb = new StringBuffer("Testsuite: ");
        sb.append(suite.getName());
        sb.append(StringUtils.LINE_SEP);
        try {
            this.out.write(sb.toString().getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write output", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endTestSuite(JUnitTest suite) throws BuildException {
        boolean success = false;
        try {
            StringBuffer sb = new StringBuffer("Tests run: ");
            sb.append(suite.runCount());
            sb.append(", Failures: ");
            sb.append(suite.failureCount());
            sb.append(", Errors: ");
            sb.append(suite.errorCount());
            sb.append(", Skipped: ");
            sb.append(suite.skipCount());
            sb.append(", Time elapsed: ");
            sb.append(this.nf.format((double)suite.getRunTime() / 1000.0));
            sb.append(" sec");
            sb.append(StringUtils.LINE_SEP);
            this.write(sb.toString());
            if (this.systemOutput != null && this.systemOutput.length() > 0) {
                this.write("------------- Standard Output ---------------");
                this.write(StringUtils.LINE_SEP);
                this.write(this.systemOutput);
                this.write("------------- ---------------- ---------------");
                this.write(StringUtils.LINE_SEP);
            }
            if (this.systemError != null && this.systemError.length() > 0) {
                this.write("------------- Standard Error -----------------");
                this.write(StringUtils.LINE_SEP);
                this.write(this.systemError);
                this.write("------------- ---------------- ---------------");
                this.write(StringUtils.LINE_SEP);
            }
            this.write(StringUtils.LINE_SEP);
            if (this.out != null) {
                try {
                    this.wri.flush();
                    this.write(this.inner.toString());
                }
                catch (IOException ioex) {
                    throw new BuildException("Unable to write output", (Throwable)ioex);
                }
            }
            success = true;
            Object var6_5 = null;
            if (this.out == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.out == null) throw throwable;
            try {}
            catch (Throwable throwable2) {
                Object var9_12 = null;
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close((OutputStream)this.out);
                }
                this.wri = null;
                this.out = null;
                throw throwable2;
            }
            try {}
            catch (IOException ioex) {
                if (success) {
                    throw new BuildException("Unable to flush output", (Throwable)ioex);
                }
                Object var9_11 = null;
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close((OutputStream)this.out);
                }
                this.wri = null;
                this.out = null;
                throw throwable;
            }
            this.wri.close();
            Object var9_10 = null;
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close((OutputStream)this.out);
            }
            this.wri = null;
            this.out = null;
            throw throwable;
        }
        try {
            try {
                this.wri.close();
            }
            catch (IOException ioex) {
                if (success) {
                    throw new BuildException("Unable to flush output", (Throwable)ioex);
                }
                Object var9_8 = null;
                if (this.out != System.out && this.out != System.err) {
                    FileUtils.close((OutputStream)this.out);
                }
                this.wri = null;
                this.out = null;
                return;
            }
            Object var9_7 = null;
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close((OutputStream)this.out);
            }
            this.wri = null;
            this.out = null;
            return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close((OutputStream)this.out);
            }
            this.wri = null;
            this.out = null;
            throw throwable;
        }
    }

    public void startTest(Test t) {
        this.testStarts.put(t, new Long(System.currentTimeMillis()));
        this.failed.put(t, Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTest(Test test) {
        if (Boolean.TRUE.equals(this.failed.get(test))) {
            return;
        }
        BufferedWriter bufferedWriter = this.wri;
        synchronized (bufferedWriter) {
            try {
                this.wri.write("Testcase: " + JUnitVersionHelper.getTestCaseName(test));
                Long l = (Long)this.testStarts.get(test);
                double seconds = 0.0;
                if (l != null) {
                    seconds = (double)(System.currentTimeMillis() - l) / 1000.0;
                }
                this.wri.write(" took " + this.nf.format(seconds) + " sec");
                this.wri.newLine();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    public void addFailure(Test test, Throwable t) {
        this.formatError("\tFAILED", test, t);
    }

    public void addFailure(Test test, AssertionFailedError t) {
        this.addFailure(test, (Throwable)t);
    }

    public void addError(Test test, Throwable t) {
        this.formatError("\tCaused an ERROR", test, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatError(String type, Test test, Throwable t) {
        BufferedWriter bufferedWriter = this.wri;
        synchronized (bufferedWriter) {
            if (test != null) {
                this.endTest(test);
                this.failed.put(test, Boolean.TRUE);
            }
            try {
                this.wri.write(type);
                this.wri.newLine();
                this.wri.write(String.valueOf(t.getMessage()));
                this.wri.newLine();
                String strace = JUnitTestRunner.getFilteredTrace(t);
                this.wri.write(strace);
                this.wri.newLine();
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    public void testIgnored(Test test) {
        this.formatSkip(test, JUnitVersionHelper.getIgnoreMessage(test));
    }

    public void formatSkip(Test test, String message) {
        if (test != null) {
            this.endTest(test);
        }
        try {
            this.wri.write("\tSKIPPED");
            if (message != null) {
                this.wri.write(": ");
                this.wri.write(message);
            }
            this.wri.newLine();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void testAssumptionFailure(Test test, Throwable throwable) {
        this.formatSkip(test, throwable.getMessage());
    }

    private void write(String text) {
        if (this.out == null) {
            return;
        }
        try {
            this.out.write(text.getBytes());
            this.out.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Unable to write output " + ex, (Throwable)ex);
        }
    }
}

