if(CMAKE_SYSTEM_NAME STREQUAL "AIX")
  set(sla_regex "/lib${name}\\.a$")
  if(NOT sla MATCHES "${sla_regex}")
    message(FATAL_ERROR "sla library does not look like an archive:\n ${sla}")
  endif()
  execute_process(COMMAND ar t ${sla} OUTPUT_STRIP_TRAILING_WHITESPACE OUTPUT_VARIABLE sla_members)
  if(soversion)
    set(soversion_regex "\\.${soversion}")
  endif()
  set(sla_members_regex "^lib${name}\\.so${soversion_regex}$")
  if(NOT sla_members MATCHES "${sla_members_regex}")
    message(FATAL_ERROR "sla library archive has members:\n ${sla_members}\nthat do not match:\n ${sla_members_regex}")
  endif()
endif()
