.\" $Xorg: xsm.man,v 1.4 2001/02/09 02:06:01 xorgcvs Exp $
.\" $XdotOrg: $
.\" Copyright 1994,1998  The Open Group
.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xsm/xsm.man,v 1.6 2001/01/27 18:21:24 dawes Exp $
.\"
.TH XSM 1 __xorgversion__
.SH NAME
xsm \- X Session Manager
.SH SYNOPSIS
.B xsm
[-display display] [-session sessionName] [-verbose]
.SH DESCRIPTION
.PP
\fIxsm\fP is a session manager.  A session is a group of applications, each
of which has a particular state.  \fIxsm\fP allows you to create arbitrary
sessions - for example, you might have a "light" session, a "development"
session, or an "xterminal" session.  Each session can have its own set of
applications.  Within a session, you can perform a "checkpoint" to save
application state, or a "shutdown" to save state and exit the session.  When
you log back in to the system, you can load a specific session, and you can
delete sessions you no longer want to keep.
.br
.sp
Some session managers simply allow you to manually specify a list of
applications to be started in a session.  \fIxsm\fP is more powerful
because it lets you run applications and have them automatically become
part of the session.  On a simple level, \fIxsm\fP is useful because it
gives you this ability to easily define which applications are in a session.
The true power of \fIxsm\fP, however, can be taken advantage of when more
and more applications learn to save and restore their state.
.SH OPTIONS
.TP 8
.B \-display \fIdisplay\fP
Causes \fIxsm\fP to connect to the specified X display.
.TP 8
.B \-session \fIsessionName\fP
Causes \fIxsm\fP to load the specified session, bypassing the session menu.
.TP 8
.B \-verbose
Turns on debugging information.
.SH SETUP
.SS .xsession file
Using \fIxsm\fP requires a change to your \fI.xsession\fP file:
.PP
The last program executed by your \fI.xsession\fP file should
be \fIxsm\fP.  With this configuration, when the user chooses to shut
down the session using \fIxsm\fP, the session will truly be over.
.PP
Since the goal of the session manager is to restart clients when
logging into a session, your .xsession file, in general, should not directly
start up applications.  Rather, the applications should be started within
a session.  When \fIxsm\fP shuts down the session, \fIxsm\fP will know to
restart these applications.  Note however that there are some types of
applications that are not "session aware".  \fIxsm\fP allows you to
manually add these applications to your session (see the section titled
\fIClient List\fP).
.PP
.SS SM_SAVE_DIR environment variable
If the \fISM_SAVE_DIR\fP environment variable is defined, \fIxsm\fP will
save all configuration files in this directory.  Otherwise, they will be
stored in the user's home directory.  Session aware applications are also
encouraged to save their checkpoint files in the \fISM_SAVE_DIR\fP directory,
although the user should not depend on this convention.
.PP
.SS Default Startup Applications
The first time \fIxsm\fP is started, it will need to locate a list of
applications to start up.  For example, this list might include a window
manager, a session management proxy, and an xterm.  \fIxsm\fP will first
look for the file \fI.xsmstartup\fP in the user's home directory.  If that
file does not exist, it will look for the \fIsystem.xsm\fP file that was
set up at installation time.  Note that \fIxsm\fP provides a "fail safe"
option when the user chooses a session to start up.  The fail safe option
simply loads the default applications described above.
.PP
Each line in the startup file should contain a command to start an application.
A sample startup file might look this:
.PP
<start of file>
.br
twm
.br
smproxy
.br
xterm
.br
<end of file>
.PP
.SH STARTING A SESSION
When \fIxsm\fP starts up, it first checks to see if the user previously
saved any sessions.  If no saved sessions exist, \fIxsm\fP starts up a set
of default applications (as described above in the section titled
\fIDefault Startup Applications\fP).  If at least one session exists, a
session menu is presented.  The \fB[-session sessionName]\fR option forces the
specified session to be loaded, bypassing the session menu.
.SS The session menu
The session menu presents the user with a list of sessions to choose from.
The user can change the currently selected session with the mouse, or by
using the up and down arrows on the keyboard.  Note that sessions which are
locked (i.e. running on a different display) can not be loaded or deleted.
.PP
The following operations can be performed from the session menu:
.PP
.TP 22
.B Load Session
Pressing this button will load the currently selected session.  Alternatively,
hitting the Return key will also load the currently selected session, or the
user can double click a session from the list.
.TP 22
.B Delete Session
This operation will delete the currently selected session, along with all
of the application checkpoint files associated with the session.  After
pressing this button, the user will be asked to press the button a second
time in order to confirm the operation.
.TP 22
.B Default/Fail Safe
\fIxsm\fP will start up a set of default applications (as described above
in the section titled \fIDefault Startup Applications\fP).  This is useful
when the user wants to start a fresh session, or if the session configuration
files were corrupted and the user wants a "fail safe" session.
.TP 22
.B Cancel
Pressing this button will cause \fIxsm\fP to exit.  It can also be used to
cancel a "Delete Session" operation.
.PP
.SH CONTROLLING A SESSION
After \fIxsm\fP determines which session to load, it brings up its main
window, then starts up all applications that are part of
the session.  The title bar for the session manager's main window will
contain the name of the session that was loaded.
.PP
The following options are available from \fIxsm\fP's main window:
.TP 18
.B Client List
Pressing this button brings up a window containing a list of all clients that
are in the current session.  For each client, the host machine that the client
is running on is presented.  As clients are added and removed from the session,
this list is updated to reflect the changes.  The user is able to control how
these clients are restarted (see below).
.br
.sp
By pressing the \fBView Properties\fR
button, the user can view the session management properties associated with
the currently selected client.
.br
.sp
By pressing the \fBClone\fR button, the user can start a copy of the selected
application.
.br
.sp
By pressing the \fBKill Client\fR button, the user can remove a client from
the session.
.br
.sp
By selecting a restart hint from the \fBRestart Hint\fR menu, the user can
control the restarting of a client.  The following hints are available:
.br
.sp
.B \-
The \fBRestart If Running\fR hint indicates that the client should be
restarted in the next session if it is connected to the session manager at
the end of the current session.
.br
.sp
.B \-
The \fBRestart Anyway\fR hint indicates that the client should be restarted
in the next session even if it exits before the current session is terminated.
.br
.sp
.B \-
The \fBRestart Immediately\fR hint is similar to the \fBRestart Anyway\fR hint,
but in addition, the client is meant to run continuously.  If the client exits,
the session manager will try to restart it in the current session.
.br
.sp
.B \-
The \fBRestart Never\fR hint indicates that the client should not be restarted
in the next session.
.br
.sp
Note that all X applications may not be "session aware".  Applications that
are not session aware are ones that do not support the X Session Management
Protocol or they can not be detected by the Session Management Proxy (see the
section titled \fITHE PROXY\fP).  \fIxsm\fP allows the user to manually add
such applications to the session.  The bottom of the \fIClient List\fP window
contains a text entry field in which application commands can be typed in.
Each command should go on its own line.  This information will be saved with
the session at checkpoint or shutdown time.  When the session is restarted,
\fIxsm\fP will restart these applications in addition to the regular "session
aware" applications.
.br
.sp
Pressing the \fBDone\fR button removes the \fBClient List\fR window.
.TP 18
.B Session Log...
The Session Log window presents useful information about the session.  For
example, when a session is restarted, all of the restart commands will be
displayed in the log window.
.TP 18
.B Checkpoint
By performing a checkpoint, all applications that are in the session are
asked to save their state.  Not every application will save its complete
state, but at a minimum, the session manager is guaranteed that it will
receive the command required to restart the application (along with all
command line options).  A window manager participating in the session
should guarantee that the applications will come back up with the same
window configurations.
.br
.sp
If the session being checkpointed was never assigned a name, the user will
be required to specify a session name.  Otherwise, the user can perform the
checkpoint using the current session name, or a new session name can be
specified.  If the session name specified already exists, the user will be
given the opportunity to specify a different name or to overwrite the
already existing session.  Note that a session which is locked can not be
overwritten.
.br
.sp
When performing a checkpoint, the user must specify a \fBSave Type\fR
which informs the applications in the session how much state they should save.
.br
.sp
The \fBLocal\fR
type indicates that the application should save enough information to restore
the state as seen by the user.  It should not affect the state as seen by
other users.  For example, an editor would create a temporary file containing
the contents of its editing buffer, the location of the cursor, etc...
.br
.sp
The \fBGlobal\fR
type indicates that the application should commit all of its data to
permanent, globally accessible storage.  For example, the editor would
simply save the edited file.
.br
.sp
The \fBBoth\fR
type indicates that the application should do both of these.  For example,
the editor would save the edited file, then create a temporary file with
information such as the location of the cursor, etc...
.br
.sp
In addition to the \fBSave Type\fR, the user must specify an
\fBInteract Style\fR.
.br
.sp
The \fBNone\fR type indicates that the application should not interact with
the user while saving state.
.br
.sp
The \fBErrors\fR type indicates that the application may interact with
the user only if an error condition arises.
.br
.sp
The \fBAny\fR type indicates that the application may interact with
the user for any purpose.  Note that \fIxsm\fP will only allow one
application to interact with the user at a time.
.br
.sp
.sp
After the checkpoint is completed, \fIxsm\fP will, if necessary, display a
window containing the list of applications which did not report a successful
save of state.
.TP 18
.B Shutdown
A shutdown provides all of the options found in a checkpoint, but in addition,
can cause the session to exit.  Note that if the interaction style is
\fBErrors\fR or \fBAny\fR, the user may cancel the shutdown.  The user may
also cancel the shutdown if any of the applications report an
unsuccessful save of state.
.br
.sp
The user may choose to shutdown the session with our without performing a
checkpoint.
.PP
.SH HOW \fIXSM\fP RESPONDS TO SIGNALS
\fIxsm\fP will respond to a SIGTERM signal by performing a shutdown with
the following options: fast, no interaction, save type local.  This allows
the user's session to be saved when the system is being shutdown.  It can
also be used to perform a remote shutdown of a session.
.br
.sp
\fIxsm\fP will respond to a SIGUSR1 signal by performing a checkpoint with
the following options: no interaction, save type local.  This signal can be
used to perform a remote checkpoint of a session.
.PP
.SH THE PROXY
Since not all applications have been ported to support the X Session
Management Protocol, a proxy service exists to allow "old" clients to
work with the session manager.  In order for the proxy to detect an
application joining a session, one of the following must be true:
.br
.sp
- The application maps a top level window containing the
\fBWM_CLIENT_LEADER\fR property.  This property provides a pointer to
the client leader window which contains the \fBWM_CLASS\fR, \fBWM_NAME\fR,
\fBWM_COMMAND\fR, and \fBWM_CLIENT_MACHINE\fR properties.
.br
.sp
or ...
.br
.sp
- The application maps a top level window which does not contain the
\fBWM_CLIENT_LEADER\fR property.  However, this top level window
contains the \fBWM_CLASS\fR, \fBWM_NAME\fR, \fBWM_COMMAND\fR, and
\fBWM_CLIENT_MACHINE\fR properties.
.PP
An application that support the \fBWM_SAVE_YOURSELF\fR protocol will receive
a \fBWM_SAVE_YOURSELF\fR client message each time the session manager issues
a checkpoint or shutdown.  This allows the application to save state.  If
an application does not support the \fBWM_SAVE_YOURSELF\fR protocol, then
the proxy will provide enough information to the session manager to restart
the application (using \fBWM_COMMAND\fR), but no state will be restored.
.PP
.SH REMOTE APPLICATIONS
\fIxsm\fP requires a remote execution protocol in order to restart
applications on remote machines.  Currently, \fIxsm\fP supports the
\fIrstart\fP protocol.  In order to restart an application on remote
machine \fBX\fR, machine \fBX\fR must have \fIrstart\fP installed.  In
the future, additional remote execution protocols may be supported.
.SH SEE ALSO
smproxy(__appmansuffix__), rstart(__appmansuffix__)
.SH AUTHORS
Ralph Mor, X Consortium
.br
Jordan Brown, Quarterdeck Office Systems
