.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtDisplay-Initialize XtOpen-Display XtClose-Display XtDatabase XtScreen-Database wid-get
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft CW
.ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de IN		\" send an index entry to the stderr
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.ny0
.TH XtDisplayInitialize __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtDisplayInitialize, XtOpenDisplay, XtDatabase, XtScreenDatabase, XtCloseDisplay \- initialize, open, or close a display
.SH SYNTAX
.HP
void XtDisplayInitialize(XtAppContext \fIapp_context\fP, Display
*\fIdisplay\fP, String \fIapplication_name\fP, String \fIapplication_class\fP,
XrmOptionDescRec *\fIoptions\fP, Cardinal \fInum_options\fP, int *\fIargc\fP,
String *\fIargv\fP);
.HP
Display *XtOpenDisplay(XtAppContext \fIapp_context\fP, String
\fIdisplay_string\fP, String \fIapplication_name\fP, String
\fIapplication_class\fP, XrmOptionDescRec *\fIoptions\fP, Cardinal
\fInum_options\fP, int *\fIargc\fP, String *\fIargv\fP);
.HP
void XtCloseDisplay(Display *\fIdisplay\fP);
.HP
XrmDatabase XtDatabase(Display *\fIdisplay\fP);
.HP
XrmDatabase XtScreenDatabase(Screen* \fIscreen\fP);
.SH ARGUMENTS
.IP \fIargc\fP 1i
Specifies a pointer to the number of command line parameters.
.IP \fIargv\fP 1i
Specifies the command line parameters.
.IP \fIapp_context\fP 1i
Specifies the application context.
.ds Ac , which usually is the generic name for all instances of this application
.IP \fIapplication_class\fP 1i
Specifies the class name of this application\*(Ac.
.IP \fIapplication_name\fP 1i
Specifies the name of the application instance.
.IP \fIdisplay\fP 1i
Specifies the display\*(Di.
Note that a display can be in at most one application context.
.IP \fInum_options\fP 1i
Specifies the number of entries in the options list.
.IP \fIoptions\fP 1i
Specifies how to parse the command line for any application-specific resources.
The options argument is passed as a parameter to
.ZN XrmParseCommand .
For further information,
see \fI\*(xL\fP.
.IP \fIscreen\fP 1i
Specifies the screen whose resource database is to be returned.
.SH DESCRIPTION
The
.ZN XtDisplayInitialize
function builds the resource database, calls the Xlib
.ZN XrmParseCommand
function to parse the command line,
and performs other per display initialization.
After
.ZN XrmParseCommand
has been called,
argc and argv contain only those parameters that
were not in the standard option table or in the table specified by the
options argument.
If the modified argc is not zero,
most applications simply print out the modified argv along with a message
listing the allowable options.
On UNIX-based systems,
the application name is usually the final component of argv[0].
If the synchronize resource is
.ZN True
for the specified application,
.ZN XtDisplayInitialize
calls the Xlib
.ZN XSynchronize
function to put Xlib into synchronous mode for this display connection.
If the reverseVideo resource is
.ZN True ,
the \*(xI exchange
.ZN XtDefaultForeground
and
.ZN XtDefaultBackground
for widgets created on this display.
(See Section 9.6.1).
.LP
The
.ZN XtOpenDisplay
function calls
.ZN XOpenDisplay
the specified display name.
If display_string is NULL,
.ZN XtOpenDisplay
uses the current value of the \-display option specified in argv
and if no display is specified in argv,
uses the user's default display (on UNIX-based systems,
this is the value of the DISPLAY environment variable).
.LP
If this succeeds, it then calls
.ZN XtDisplayInitialize
and pass it the opened display and
the value of the \-name option specified in argv as the application name.
If no name option is specified,
it uses the application name passed to
.ZN XtOpenDisplay .
If the application name is NULL,
it uses the last component of argv[0].
.ZN XtOpenDisplay
returns the newly opened display or NULL if it failed.
.LP
.ZN XtOpenDisplay
is provided as a convenience to the application programmer.
.LP
The
.ZN XtCloseDisplay
function closes the specified display as soon as it is safe to do so.
If called from within an event dispatch (for example, a callback procedure),
.ZN XtCloseDisplay
does not close the display until the dispatch is complete.
Note that applications need only call
.ZN XtCloseDisplay
if they are to continue executing after closing the display;
otherwise, they should call
.ZN XtDestroyApplicationContext
or just exit.
.LP
The
.ZN XtDatabase
function returns the fully merged resource database that was built by
.ZN XtDisplayInitialize
associated with the display that was passed in.
If this display has not been initialized by
.ZN XtDisplayInitialize ,
the results are not defined.
.LP
The
.ZN XtScreenDatabase
function returns the fully merged resource database associated with the
specified screen. If the \fIscreen\fP does not belong to a
.ZN Display
initialized by
.ZN XtDisplayInitialize ,
the results are undefined.
.SH "SEE ALSO"
XtAppCreateShell(__libmansuffix__),
XtCreateApplicationContext(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
